(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    139118,       3367]
NotebookOptionsPosition[    128521,       3005]
NotebookOutlinePosition[    130268,       3056]
CellTagsIndexPosition[    130100,       3049]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Factorial" :> Documentation`HelpLookup["paclet:ref/Factorial"],
           "Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "Pochhammer" :> 
          Documentation`HelpLookup["paclet:ref/Pochhammer"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Factorial\"\>", 2->"\<\"Gamma\"\>", 
       3->"\<\"Pochhammer\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Factorial2 ",
 StyleBox["(!!)", "OperatorCharacter"]
}], "ObjectName",
 CellID->32603],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "!!"}]], "InlineFormula"],
     "\[LineSeparator]gives the double factorial of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "!!"}], "=", 
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"n", "-", "2"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "4"}], ")"}], "\[Cross]", " ", "\[Ellipsis]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->31409],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "!!"}]], "InlineFormula"],
 " is a product of even numbers for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " even, and odd numbers for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " odd. "
}], "Notes",
 CellID->11307],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->180583195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->286239999]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2549118],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->289212473],

Cell["Integer values:", "ExampleText",
 CellID->443184402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100406044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "8", ",", "15", ",", "48", ",", "105", ",", 
   "384", ",", "945", ",", "3840"}], "}"}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336921352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"50", "!!"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289601152],

Cell[BoxData["520469842636666622693081088000000"], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621444447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7069989],

Cell["Evaluate numerically:", "ExampleText",
 CellID->254834060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", "1.5", ")"}], "!!"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46238338],

Cell[BoxData["1.3806626817533862`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60148641]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17738],

Cell["Evaluate for large arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"100000", "!!"}], " ", "//", "Short"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"1057987404966129872971991554655418", 
   RowBox[{"\[LeftSkeleton]", "228220", "\[RightSkeleton]"}], 
   "00000000000000000000000000000000000"}],
  Short]], "Output",
 ImageSize->{355, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->191440657]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385024099],

Cell[BoxData["1.05798740496612987297199155465541855`15.954589770191005*^\
228288"], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->370481810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1542098],

Cell["Evaluate at negative integers:", "ExampleText",
 CellID->646599906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "n"}], ")"}], "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15718371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "ComplexInfinity", ",", 
   RowBox[{"-", "1"}], ",", "ComplexInfinity", ",", 
   FractionBox["1", "3"], ",", "ComplexInfinity", ",", 
   RowBox[{"-", 
    FractionBox["1", "15"]}]}], "}"}]], "Output",
 ImageSize->{459, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174957142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67183006],

Cell["Plot double factorial:", "ExampleText",
 CellID->290430575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"n", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23204027],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5073907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2.5", "+", "I"}], ")"}], "!!"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"1.7684872940073182`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.3860619034923933`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249402174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149232749],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->69128392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}], 
  "!!"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234161390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "15", ",", "105", ",", "945"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222051272]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27681],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factorial2", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136631480]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factorial2", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18337803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115639317],

Cell["Series expansion at poles:", "ExampleText",
 CellID->204604663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"n", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219175636],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"n", "+", "2"}]], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "EulerGamma"}], "+", 
      RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "48"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "+", 
      SuperscriptBox["\[Pi]", "2"], "-", 
      RowBox[{"12", " ", "EulerGamma", " ", 
       RowBox[{"Log", "[", "2", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{"Log", "[", "2", "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", "2", "]"}], "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{"Log", "[", "\[Pi]", "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "2"],
    SeriesData[$CellContext`n, -2, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, -2, {
   1, Rational[1, 2] (-EulerGamma + Log[2]), 
    Rational[1, 48] (6 EulerGamma^2 + Pi^2 - 12 EulerGamma Log[2] + 
     6 Pi^2 Log[2] + 6 Log[2]^2 - 6 Pi^2 Log[Pi])}, -1, 2, 1],
  Editable->False]], "Output",
 ImageSize->{539, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227419189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Series expansion at infinity (generalized Stirling approximation):\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"n", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "n"], "]"}]}], 
      FractionBox["2", "n"]], "+", 
     FractionBox[
      RowBox[{"Log", "[", "2", "]"}], "4"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "n"], "]"}], "3"],
      SeriesData[$CellContext`n, 
       DirectedInfinity[1], {}, -1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {
     Rational[1, 2] (-1 - Log[$CellContext`n^(-1)]), Rational[1, 4] 
      Log[2]}, -1, 3, 1],
    Editable->False]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Pi]", "2"], ")"}], 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"n", " ", "\[Pi]"}], "]"}]}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Pi]", 
       RowBox[{"1", "/", "4"}]], 
      SqrtBox[
       FractionBox["1", "n"]]], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{"1", "/", "4"}]], " ", 
      SqrtBox[
       FractionBox["1", "n"]]}], "+", 
     RowBox[{
      FractionBox["1", "72"], " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{"1", "/", "4"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "n"], ")"}], 
       RowBox[{"3", "/", "2"}]]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "n"], "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`n, 
       DirectedInfinity[1], {}, -1, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {
     Pi^Rational[1, 4], 0, Rational[1, 6] Pi^Rational[1, 4], 0, 
      Rational[1, 72] Pi^Rational[1, 4]}, -1, 5, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{509, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226350524]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1524],

Cell[TextData[{
 "Plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 " in the complex plane:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Factorial2", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2832],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand double factorial into ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " function:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", "2"}], ")"}], "!!"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["5", "4"], "]"}]}], 
  SuperscriptBox["\[Pi]", 
   RowBox[{"1", "/", "4"}]]]], "Output",
 ImageSize->{95, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542131570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "n"}], ")"}], "!!"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->169940537],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    FractionBox["1", "4"], "+", "n", "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "n", " ", "\[Pi]"}], "]"}]}]}]], " ", 
  SuperscriptBox["\[Pi]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "n", " ", "\[Pi]"}], "]"}]}]}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}]}]], "Output",
 ImageSize->{253, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3393543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"n", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", "n"], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31176552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions involving double factorials:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "!!"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], "!!"}]}], "-", 
   RowBox[{"n", " ", 
    RowBox[{"n", "!"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1", "+", "n"}], "]"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104922368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Sums involving ",
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"k", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
    RowBox[{"ExpIntegralEi", "[", 
     FractionBox["1", "2"], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox["\[ExponentialE]"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"Floor", "[", 
      FractionBox["n", "2"], "]"}]], " ", 
    SuperscriptBox["2", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"\[Pi]", " ", 
           RowBox[{"Floor", "[", 
            FractionBox["n", "2"], "]"}]}], "]"}], "2"]}], ")"}]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"2", "+", 
      RowBox[{"Floor", "[", 
       FractionBox["n", "2"], "]"}]}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Floor", "[", 
        FractionBox["n", "2"], "]"}]}], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], "]"}]}], 
   SqrtBox["\[ExponentialE]"]]}]], "Output",
 ImageSize->{513, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352181987]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"k", "!!"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "n", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"2", " ", "\[Pi]"}], "\[ExponentialE]"]]}], "+", 
     RowBox[{
      SqrtBox[
       FractionBox[
        RowBox[{"2", " ", "\[Pi]"}], "\[ExponentialE]"]], " ", 
      RowBox[{"Erfi", "[", 
       FractionBox["1", 
        SqrtBox["2"]], "]"}]}]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "]"}]], " ", 
     SqrtBox[
      FractionBox["2", 
       RowBox[{"\[ExponentialE]", " ", "\[Pi]"}]]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["7", "2"], "+", 
       RowBox[{"Floor", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "]"}]}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "2"]}], "-", 
        RowBox[{"Floor", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      RowBox[{"Floor", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "]"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{433, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72635119]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"k", "!!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 SqrtBox["\[ExponentialE]"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14976977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"k", "!!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", "\[Pi]"}], "2"]], " ", 
  RowBox[{"Erf", "[", 
   FractionBox["1", 
    SqrtBox["2"]], "]"}]}]], "Output",
 ImageSize->{112, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->222521471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Generating function:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "!!"}], " ", 
    RowBox[{"x", "^", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox["2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["1", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"]}]]], " ", 
       SqrtBox[
        FractionBox["1", 
         SuperscriptBox["x", "2"]]], " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox["x", "2"]]}]], " ", 
       SqrtBox[
        FractionBox["1", 
         SuperscriptBox["x", "2"]]], " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"Erfi", "[", 
        FractionBox[
         SqrtBox[
          FractionBox["1", 
           SuperscriptBox["x", "2"]]], 
         SqrtBox["2"]], "]"}]}]}], ")"}]}], 
   RowBox[{
    SqrtBox["2"], " ", 
    SqrtBox[
     FractionBox["1", 
      SuperscriptBox["x", "2"]]], " ", 
    SuperscriptBox["x", "3"]}]]}]], "Output",
 ImageSize->{426, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Fibonacci",
 CellLabel->"Out[1]=",
 CellID->361827988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "!!"}], " ", 
    RowBox[{"x", "^", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"0", ",", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]]}]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{149, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Fibonacci",
 CellLabel->"Out[2]=",
 CellID->3979954]
}, Open  ]],

Cell["Recover the original power series:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"48", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"384", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"3840", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   RowBox[{"46080", " ", 
    SuperscriptBox["x", "12"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "13"],
    SeriesData[$CellContext`x, 0, {}, 0, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 2, 0, 8, 0, 48, 0, 384, 0, 3840, 0, 
   46080}, 0, 13, 1],
  Editable->False]], "Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->66360616]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25552],

Cell["\<\
Large arguments can give results too large to be computed explicitly, even \
approximately:\
\>", "ExampleText",
 CellID->276406083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"10", "^", "9."}], ")"}], "!!"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->682042817],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->874827422],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158334646]
}, Open  ]],

Cell["Smaller values work:", "ExampleText",
 CellID->350289571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"10.", "^", "8"}], ")"}], "!!"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87965497],

Cell[BoxData["1.4236800017057392676033029`7.011483476283634*^378285280"], \
"Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8133612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factorial2", "[", 
  RowBox[{"10.", "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["3.9939844265472662130041280487974`15.954589770191005*^1284"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236662944]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72112467]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6141],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Factorial2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]], "InlineFormula"],
 " at infinity:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Factorial2", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ")"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzEvPd7Y9d1741wJDuOc9OLb9qb3MRO4i5HbpKbiiVbskZdUzS9V85wOOy9
9wawgARBohCFRO+99957PcABlNz/Ic/7rg3McEbSSE7yyzvPGfAAODhlf/Za
67t2e+P8/WuXb5+/f/3i+b9/9d75u9euX2z/+1fu3IOPjvwOgUCQw3/+Vwiw
///CXuO//D//8z/hi8devwavLfDVEfTuadj5z4f/YJ/wZ49/e6T5Lfoc7f7R
E75Duy2/5Xd/+rlX/MPG36+i16cenZNA+MInrvLHnzri6U9c6w8/dcRTn/rk
T37rWT59xCfv5H81Pv57eEWHNU/w2OGNq6Jv/tdnHvHJM/7B/+jOf3sJPbyT
P/iMMn7qE8/+p5864otPevb/9p1+8ix/9Fvv5LNqBSrKlv9f7/ThHfz37/DT
1/+f1dj/aq1+dJcPbf6TT/cnDz7/woO/f/yJ93/2Ge+fWNaET/uaT7/+Jbxu
ww9/5/Dd4+f5w0+8/+tPvP+r3/L9J9+j8/3OZ16N/LnffnF7u95CpdYJw9Sd
+g5su/VdWp3GqNOZdfpencGq73HrbF6dI6zvS+o8WV2orkuMdYW9rvbU9aG6
OV53JHFvuhLJllKFfLGcEVEtfR9w7r3BH7tuG74VXpzI7tIwsbpmcWHRZN7p
yNDXYwNX/aS5JF+B6fx1ha0u1td58jpHgC4kVuJWD2ZzpJb71Ge+u3X0z+eP
/uXCm19ZHDh1IGS53YGc8CBHnMwtjuep26V9cVVrxw0e3OTH9S5cY62yDooM
VnGXVqQzi3vcotKCW32VcKro9BQOWMWFkVLvBe+1lyQn/nX7xNepJ79Bvfbi
Qdcp02RXfHOjIFDjUiNGJnrvHOXceIUz0+uhUnGBuGpzl6OpHH8vMtnmGr7l
WV1M7otxtRV3RjB/PO9xxePekE3qWunQ3XhV1n7MBE832ZWZHy0R5/ENUn2L
XIcCpjHrTChJfqMkxfUDWZ2vqAvUqDxF2rpIVz8CpfAliaFOeEpsqB/W8Meo
Par5lM36F7c264QB2KFsPdwodWAJV3pAkY74MTn1vX1UrFwRKmK4ktRUVzrq
Wn/dFK3b47gviUWyxXQxj5XTkh0zd83B2oh0n7bP9CUoWxhfWjNYytFkweXK
c2i5sbY4ea0o11Xs4QrcN5wTHonBRjUDHkmmw+Wq7Mgt/XKnoudtxtG/mH/z
Lxf6P9xnrtmV8iSbGp3ri0z1xEjzyfWVrE6Xj8TyUCFCkbzWVqUzsjN9nslO
z3SPh0GNuoJlT7AUz+R93pyQnUfYLvqu/1J68hs7H35z58Jz+/feU073OMik
LE9WZbLSS+NOhQ2jbHjXl7wHUnxlJsXaK5hdWDBZ4DJjk+2ekVYveTUpUOJ6
D+5LlKOJDHPdtTtrWmpTXX1BeP+4YeCKa+J+dHG8tLpU29xoAGOg0gNg8Gi8
h7SgAAEToQVMgHAEilJqrsss8B69PCVrvGluLfCmRYr+m+otn2uBLXC5ls11
OB95vU5eQxvhafTSA+/hO9igBm01SAPgx9GygKsY3RlUH7m1rvHWjWGAWvWl
sWiulCvmqljKZ41SZxx339SM3PauLRe4vJrejEWSBacrz2UUpvvyNErJYCoG
4iWVrgJGDyeH6iJQ1vlKdGYWtyiXplzWiJhq6n4LQW17nbXSb9qjRFYnAmOt
7sFr3pHbwbF70f3tWMwXr5cTkWhe1yA60e64/bpsstUgOwimcrlMLpvLZ4P+
zCHRG6/ITn2bdvH5g1uvqfov20lz0X1xmc5MD9/U3/o1jzjjVLsrKhe+s5Oa
7PBuLofVupwvXtzfS0x3+Mba/FsbaYkBtwSqYN+pVIpLtveckMLZ2t5RD91w
TXVHFsezays1KDpwaQ9YStBDQd0V6+pgawAHWEHREY6AR3saDOMp+Et4GnwS
fNjcGnw/n+DGKpwALH0dNiLswkvL2grsrC3X4S/abbz/2voKOgAOR5zXEVew
WrBXqGvgaVn7yKSg6KF2KZ11faBujeDeBBZNF6Dg6pWkXuBdum+grQQVCozJ
wjWmCmCzOop79NLMQHF/N+ewZhOpnNlUFAoqexz0tC2ouh6F+kHdTu2uB2Rs
1/aI4tKz5DPP0M/+G23okpY05hu95eq75O675Om75B+8HmaSIkFrNBNPgoHq
7FU6E4EcuKidv6dTC/2FUhacfL6YLZXSDnN2j1IgDrhHzknuvck/933WtZel
3WdNSxN+xl72QFqd6XV1HFdQyBGVE98XpUizvt7zxsV+O58T9CfLIlFhcSg2
0xen0csqR22XGhVyAkqOc/KaDE7V+htZ3yXrTF94ZSZHXsPBIqGIAOGBtC5Q
NfgZERvgBWWlctVV7rraXf8iGAHhCMQm2IdPCC3wTQscAIAd6Fgg+ySav3tI
E/ggZMv1VdiW6i2ri/Bb0mKdtFAnzsMuvBwhztUJX4Ud+Ay+gSPgQPgRQG0S
pTaIAk64V/AYyDQ9dbO/6omUo5livpT992rCLPJEAlk+u7i5VpGqq+4YZrCX
GbTSTH+Rt5sNOlPFXMrvzlltRbWxItLAXaNq+hqdkVocdfVdUPZ/yL/8g62z
/8bsOm2786bm9uvykRvOvouuxfH44nhy8EZw8EZ4bzUqYiU0iozVUWiSpKyG
mVtBHs3XJJkrZgPJEphPuZx2WbPyPQd/10ldtt97k3f23/Zaj0pGbiGYO9Qs
m1clzkb4yuruboo47Ru/Z2x9QzJ6TXWw5weSUkVlbaG4MlPm8nF4Tvp2oO+c
fPSc8PR3aDdeFXWfMUx0+EnzWcoWjsrlAFVMoQZZn9yGohGAAmy6QP0pUBRH
DOE64Yuwow/Wdc0tgOKV1gdlgOg+/YAuIHci9k/i+Sj/AjQIYQuwInwRmK3M
1VZmaysztWXYpmtLUzVCy9JkjXBkcbK2OIE2Qgt6aYX38Dl8Dxv8grRQW1uu
bZBqm+s1cMPggKEu8hR1CNYqR90UwN2JSixXLJYy/7cacxmSjLXs0kSRyy2Z
vWWdtUzfKYKvPdjJhByJj0rRQjYZi2c9oYLJiynsNTYvTZp1D99Q336Ne+Jf
yaefoXd+aF2cqEx2pfsu+3rOORdGYjRGmcaoLE9nR1qjUz2JlenMFrmwx8UE
qprSWjO6q85gORgvJrP5JlVTELeGquA7ILID6kSh4Armthesd1/fv/BjVtvb
0qEb5sXR4DYlz2RX15aS0z3e3guG269Lzj27N3JZwdvzB1JlmQLbIlXXFisC
EeYIldi7nt5TopPf2L764kHHCc3YXdfyVHJnBweN+MhzORow/UgdGiN1U7ze
Yk7Wn7Ik4W+iTvgD+MAUqxthi35kiNSBNhz4OGX4dZPwE7h++ZArcb5GBJQN
moByabK6OFFdGK8SWhbGqoQjcyPY7FBpdrBEaJkZKBHuTvcVp3ryU925qZ7c
VG9uujc32Z2Z6snO9GfnhrLzo9n5kdTyVGFtCdvawHZ3sT1uFYxXaqhrHbjD
V46EsoViRk41LNwz9l2wrI5bpYq0WJreWAgPXg/S5r0ujT8XCQrX9XsrJsq8
bXnSpXNXwfa3KemZPnfnh2oo8Es/YV/5hXDoRrDzlL3rpHGm3T3ZGdvcKG9u
VGYGshRSenYwszRZ2FzHGCwcfJzaUbMGKt4YchqxVMHhKsbzBWe84klgmWIO
x5L1SgIMNxpNcpYNM3eUo7e1Mz1m8kqAfZCTG2tSWX6szdZ5UnXtpQOkmn7M
nbqukLI9sUxBqyru0SrTPfHBy+a1SVPn+/vH/3mr9aiq97xmutu1tpRgcnC+
oCpW4HIDrgaF7auZQ6g6QUCyx3BQ/C3ONP60I4UTnralatZkzZqoWWCLg/VA
SkD4EkIcRXLE8Cm4T7LXkUOuTZwNy8QXxyvzo+W54fLsUHl2sAyucao3P9md
nejMjHdkxtvTo23JkTvx4dux4VvR4dvRoZuhgWsBAAK+b/g2bAGQ62Ntwene
9MJonjhb3CBVIY6AAxIo6iptxebFQtkym2zreXvv6s9YE3e0LHaGyczOD7jv
HzeThy12dSAVDtOnVJ1HWbd+vb8+67D4MYURZx/USfNwzujyZHT8nvPWa5I7
b2nvva1auG/ZXfCtzySI82XiHMZklFT6IoddIs5iGyQc4leTqi1UAdsKJkoa
PcbnVc0OLJgph0GxlSDKJ/6jGv+/1XghGTHLvUJBlH2Q2BckxJqcMVBzh8tO
Z5o0YLj0/N4HX904/Qzj6ovihXt69YE7m8vabQWJAow1cfct6ZWf7L7396u3
XlOO3Ysvjce3yAmuCJcoqxpN2WDBzN6KPVJ1JSqeWNkbL4PGAMlIaPFnMcJf
+DOYL1PxNjYPbOmqK10F0nbYkrg9gdsSTdoo94MkwvjQhvUPMX8uX8C6NIkv
TuALYxVEdqAIWKd7C5PduYmOzFh7crQtAUyHbkUHr4f6rwT6Lvl6L3p7znu6
Tjs7P7R3nLB0nLTCzv0T1vvHjO0faDs/NPdd8oJuGb0bn+rJLIzl15YgN8xz
+HWZvgaJ4fqs6/pL3A/+aaP9fdnqfHRlJtp7wXLvbfXqkM2iCsVDkZ1JzbWf
0tp+w9letDnDJZ21whMivUHdqdEYtdXFbP8Vx923VdM3tcxFu4IT4jMzzJ0K
m1nVGrBAumywYlxWBeQc8AVlqXHWID3yJcsqbY5JK6wvl/YPCgZ7zuLK+b3J
VDCSCYWzodBHWCJbyHoSFUushko0XjN6K+5gwWVLkPq05763Cynqxef2b72u
IvbbjbIwyIF4Ek6Cseix4Yvi099Yv/Yie+SWm0yqMdk1EAhKI260ll3OgjdQ
BPcPFTucKYH7j8GWLcTyRUJLFF7+AjKDSK4EtS2YLQeyGDD3NUADZVeq6kwh
627gRmYNBm2O1R5Qjnykb4B+At/eQ74L40C2itzvYGm6rwDudrIrB9Y6Bqba
ClgjYJsDV4Og/rvPujpPOTpO2u4ft7a9Z7zzpu72b9S3fq2AZODmrxTXX5Ze
fUF85Re8669IoBDgw9aj2nvvG7vPWoZvWqa6vCszmR1qbV+AD99091+GBE55
6ts73WegPuhuvyYdv67bmnYYlOFIIEaZ0JJHtRsjWjrR4o8XzE5Mrq1CGr5O
hPQcnxvMQA6zMOKjLzk0XLfPErXq82uTUcpCzGnNZ/NZrzOnVJTheMikQbUA
X0g5DO4qdy9GHPdNtAc2F3yUZT9lxb9D9HHXXbwNh1YYAvFcLGai2aI3VfEk
K2pn7UBS4XKK7O1E+3vaG6/KQSpfe0ly7z3TxoRPJYj6HXGskEwms1qxf6Nb
0ntGPXpTvT7nEkhx8BgWX8UVKPmDhXg0m87kjmSLOcLTuUI2X8jkkYzLQUAg
tKQLecKfpwr5RB7xblIONSg3LRps2d0wZ2eDry2Jql0DccOQUTz+6Eneuf+Q
7vxIdXYIm+kvTYHFNrneSyGuNyMD10J9l/29F7xdZ1wAtf0D8913DAAV4N14
RQ5+6vLPBFChz/+Ie/bZvdPfpX/4rd2TX6d++M1diE2Q15/+DiQke5ee59x4
RXz3bU3fJRd4bUjGiXN5JifP4ibG7hjO/5B9/SX+8AXF+ohJQPPYTNGgP+51
xzzumNsVd7ni0VQeNLbRi4MOoTEhhFTnhgpb5CKklQZjJuqLYtmEfM83ccM0
12bR8/0flePpZMYRwEBGQi4BuZLSVpMZa2JNjbKeHGu13z+m6/oQNn33KdgM
vWf0s50OJi0Jahp8cSJXCGVKJndFpK7RmRXSQnGyIzEAbqtRDt1nXF1nnCuD
QfZ6SCuMhJwxvJiIOANyXoy8kqXtZMXyDMRTXxKDiAzJcSGfwYopvJKsVSCy
J4/AH8Jf4ViqgqVAwpXKmUIJwQb0wDlZKMTzxSblUK5hyJkHhgyIITgjE042
EKOwjGSYMfbRE9h+/5AtRFikkrrzE51ZFFvvJiCwgrWCE25Yq/uQautRza1f
K6H2Xv4Z/8KP9yFZO/1dxt3X+ZAGDp4S9h/n9b2/f/uXex3v7He8DRu3631+
zwnRrVd5/WcVozeM8/3+TVKRvl0dbw+vLUbWl733j0nB0kEc9Z1SrvSZuVte
ozbusseVPBehRcFzE74m57kN+mQ8V/DGMbA9vqCyvV7Z3cCEQszgqkYSeQic
Hq1XzYvOtDmXelxmWTQbTxUKGYhtoD9AUELyJzWjlhK+sr5BTA7ddIy1Wqbu
mKfuwmaZbrO0vaWGXGp5Os7hYwpVscXmzBOek8qKDCa2ulgE2UEaT6I4BNX7
Q3v7MXBD3o3JEG8nYlZGE8F4FUu5de6DTdfCYHBtPshiBGTagtZcstrybkfG
70zlMylwLn5rJGCNwGvIGQ1Y/Da5yyp3m2Ueo9RrUbrLD0Ajk04XH1CONiln
y4e+umHFD7z0A8SNcPxxvqj9+rN7pBr9KqcPP53uLT4y6Eb8fdygIdq2vQsp
H+J+/ZeyKz8XAvczzzDBdo//C+Xmi6ypm0r6nElCs4m2zcwF/cgV2Uy7mrlh
Z67bWFuu8Vv6rpPq9Wk7mxYUS/NqXUWvL893O1p/I7lz9OD8D/aGrtuGbjjB
/49cM5OnvOL9hEaeJPaoRs/zRs7z5u5pKAshoy6ZzOe94ZJWU+KLqkJJxagr
BKJFMA4xRb94W8TZCK/PpKnLGZWkaDKWXP4Sgh94AF9mRvYNAoy8mtzejO8x
YjxWWMgOijgh8iTciRxc8dDN4PpSbm8nA7VOUyY8t7eTJc3lJjrT9PW0nJ8Y
u266/ooMXNn9DzTLI0E2NaaXx8OQ/5bSkWRBKQ4ttgru/obffYI/1W5cm49S
1jJ0So5DzajEmXgya1LHGcsB5oqftRY0KRIGSZg8oF68K1u4I5++Jpy9zrOr
XFCLMAzVAbB08OnImRceOPPDCuD9jArwcfpf+Hib8RN60p76eA1A+O9nQFIP
t8aGbkQgSIP2agqv+8csYPaAB+LW1RdEF58/OPd99qnv0CBrAJV55cc7oxdE
O3NmNc8T9UXSibhS6Fudsm6vulSqWDRXFAviS0Pe0dtOOiVidhfgQeCJ4NE4
ZGvHm+wPv7Xdc063QcpukAqTnaH7xy2znX4GOXXATI9f05z+1uaJf6Fce1kC
DggqgVmfTOXznmhZ58bBzwfiJTAW/qax8ygd6d3XlRMdKUj5IUOHnBQSUgDf
NH9IS8HDSwxIoimsdUOgBqUHPhPuxKSPrY1ab74KIl7Xc8E70ZFcXykQWjiC
KuE52JvoTO2SklZDOhlL7C2b2t/Yv/YCd/yWYXcjqpSlfL50vpgFLQ9Kc4+d
6L8oe+8fViCwgZWA3UAhgh8lTmZFgnwgVlQpUmtTof5LnrXxiIiVEdBi07d1
l368d+yr5Lf/euW9v11YuLHvUjvB+0M9KDXy9kN3f1gJAh+rBI/F8k/WgKbh
N/8hP/DZfbhPf7wmPKgG4P2vN72/Fwq/80MH8v5v62+/rr7xiuzKL0SQUZ55
hnHyG9QP/on8zt8SL36fMnhyf3NUo+R5Q75osZTJFHLeUJbLjYjlSZBBVh+m
M2FbxNTCcIwvLEkVRf5Bis+NifcjI5eUZ59lXX2B139Jt7WR3dooTPeG4Fr9
VwOr05ltUrbzuA70w5nvMS/9lA96cWPSa1RFkom0UgrnLx4cFLSKtMlQLBbT
Ioph4baYTY7yudjyaGLopneq27s84aVsBPmKPOSfEOvlVlQTGCzICcMby4Hd
rQB726OQJNTKLHXJ3/6+Dur85P0YcyvN3U0TWtS6IuE52BtrDdJW4g5jMhOP
cVYM83fl060q0phFJEw6PUiClUoZX6Skd+N0RqLnrGzwDG/0/MFSp466FGKQ
k8ztHHWrwNkvOcKYSJpdmYnN9Mcm7sd31vLU5WT3KdP1X0rP/YANBXrqm1vr
PUop1exSQWVIQGWAwAAFmmtUhsRnV4ZDj/DbfMEne6If9n0SPoSdj8FvCJmO
k/Z775uQmntNBXcJ/h90HAR9MM33/mHtrb9avvBvmwMnOBuDSgnTHvDFc8Vs
Ml+ABMSbwvSesjVW07pwmQ7nifA9Jk4mYdTN8tpcemk4MtPtne1w3vy1Aoyv
67R1use3TclubxfG2z23XlNAjjDVnVsczUNSD94IyENqAPVifcRhU4dyqaRC
kFydSW/MpraJefpWxawrlIspl94f8OWcnuI+I9p/DsS2sOO4ZKrTRCYF9sU5
lQs1O7IOcmtLoYn7to4Tqp7TCoj/26uZ3c3i2nS874JzvC3E2UnYbFmnHWKB
15MhPM/aCPVfsG9OeJ2GWD4RtSo8OllAKQ3JJWGTPQtAwGNXyikISFo7vruT
YO0GpAdepcCjFrpt5pTNnjdai2pTWWaoGAI4X17a45S2t0qrC6XF8dL8cGbw
egAEFqjlSz/hXf4JZ/iMuPtt9sJNvlPp+KiSwLEk9l+qAg+CQqNf4nP4P+w5
b3yzefgNuP4Hiu/zsf/rNsL+v5cufI/cf5y9MSCXMGw+VwScFeSawXTZnahY
YzikixB+we3yFSh5gpSasgX5dHF+ODXZEYbkteecHZ6555xnpDVEnM0w2RUm
B5sbDNx7XzN0w7swVgRXTpyvLk1BKgmKzXP3bd1Sj1MvDsdDKeFearonDVJl
sisLOck+Lee1JpOhsM8etFsjHIqj94QA3NOtXwsHruqXxj00ekpqqiltVTY3
tb7om2w3dR6X3XiJ1/6BYao7MTuYHb4dHrzup8yHjJokPAj4XgjDiXSGzwiO
3bbRlz1Bd6xaSmYy2WiqABm2L1H2JLBgqpTK5vK5jDtQkplqahvuCGGxLApv
4BBiqbwvVHAGSmZvBSIWeB99oC431/iy2h67tr1VI87XZvpzw7cjXWccd97U
IB/3DOODr5Jv/nxnb0Yd9wQOzb8ZCx7P7oIfV4QN0V8j/DbL/wzySPBBxAeh
f84NaTnoW+TqIeK/8iDiQ3aGXP0/brz9Nys9b9K3h6QN7FZ/AztUyECq7IpV
LBEcAq7UhCsdtcfhM1k1oRzncgt0anJzJTI7EO2/7IGwMnw7uDKTXhyPU8g5
1j42PxwgrxUbvdg1+BWDVaVsZeeH/UB+6IaHtpHUKAqkueL8CGiVONww8Kct
h4zahNubpI7Jid2yznc4J76+3fauofeCdarLQ15NHUhqIP503prJh4nEid01
D2XORh41tr4m7T5rh9voOe9cnkpxKDG7LgZWBuUNtgwhN5Ao7O1GLTZkd0De
5ytYnGW9vQLZn9FbNfmqNn8FsMtNNcgBncGyE8jnCoAominCW4W8KOCVuPsV
1gEO4cYUwG3hKvxWpqpyeTV4RtJCbXYgB3W/64wNihoM/9S3aW2/YtOndVt9
YpvUDilgBQmBTK6UfZQOPMz4fBnscasnPFn9f3IUy1Mf5468/GX/A5l3wgoi
uPWoFpwsZHcQas//kHPqO/RjX9t65+9IPW8yZBR9wuePeEJ+dwQcEdwPVEPU
hhXGtX4IqThHWOHLq4+jP5DUlWbUdKyxlg6EZcoWtjCaGrwRGLoVGLjq6b3g
mOwMbG/l2DyMK6pz+HWuoIYUmq3OFeXnh31N7ivTWeo2vkHEiHPF2cHU8K1g
zzn32nRQrMjpHPnlQe3lH26+/3/WoQwnOjOL44W1pQJ9r8aToXvQ+2r2aNUV
LdndaY836bREtmcc997RdJwwzQ2FGSxMoymEfcmPqqgtHVwrPBGUrSOKwU6x
nMER9zwg48tRs4DMBOZbl8OrsWZ0VULxQiqXj2cLkJlGMkVHuKJ21LgHlY3l
8sosRt3B9yV1lQV3RCqeOGZ0V2T6GleI+gcb6LOQb0CZQ/ADKdX66v7V53bO
fmt15hLHKrXjTzL68ONG/1D9PanF5soh38O2tgfZe0O/gTi9DCncj7hnGkYN
RQe+fPYqzyZzgL+pYOi6TbhwLXsc1wchd8LZ/AqVWqIzy48jlhrqBn/N4C7Z
41W1vQYQt8gALtp30TVxPzR6x7c4Ht3jYmjkibEu0dUk+prahXoC4O36Sqr3
gnOmPw5hYWcX4gNOXseA9WRnZOxeYGE0vC8qyEzF6W79tReZp75FhfwTnP3S
RHFtubizg/PkSMjp/TVHrApZhoDtkXKdol3rxDVl61HFSKtjbSnGk+M2Tzmb
Q93VYNRQhgDXk0HtYGA7ULCFQsbhKYnVNdD7dcIzUGfgtPCqtuIAzhMqhROF
QLyYzufgMI25ClWaQsGXpzDiDLa+UmWw6iIFbrBXZOKgK17Re3CJrs7m1eCJ
lqcqkIxA4UPmDNYE2hV08pt/udj9Jl2ybWyY9oOAnil+WuBjh079SXy/d8i3
79B4jzdS9KbxvigGZ3Lu+yzwJ8h4/5b4xp/NTV3at0ideCUJ/gQF6kZRQBUy
RaFK41whRt0ukeYLG6QiIOY9RKzx1NWO8vZ6hMlImKM4FDj7ID90w9z6hnxh
NLJByuxxMJGmDnYBeUsLOFnC/zGGkP1C8gUOfKY/SV6rHY5y2KWBFRdWFyHX
y1I2s3vcgkhdXBxzLI07Ru8Yb/5aNng9NNkVmxvKkBZKHAEO54FMDdJ4EJQH
W+b+k5zud5jnvk+fG3C0ULeThD+TGHF3tIw6sTMlqAPgGJt20eQLDxjLFIye
qtYNFQ8NVWKy0UgQha4KvroFABO+YXJVgHK5lPJ68gJhlcasry1VBQdlkaC0
vlTdIte4+/jquGvkEl8sCtljVY2zJlTU6HDYSnV2qDh8Owrh8tavlWBNEHfe
+ZuVvndZsh3jR4243UzkmyZ86LqRCT/mup/E94NDvg+N146M960Hxvug/eV7
TEg0m8b7+h9NT5xlm0R2qFRwxVTDj8ElIBVQ2at8KUajlVYXC6A15kfzG8RH
iOXWCpkU7btkG7vrotGShnB9c813713B+R8whm+aaPScsAFX5UCGZo6i5mKN
qybR1sBR0+hoLMvmBhqaRD0cxXLwscFmQBAN0XDU98Vl4myi75KnH6J2a3ym
H1x6CUIGxMR4Ol/DknKqrufoztt/vdB/UcLhJ4+gDv8vgVwyhmuWaM0WRzGu
SRZMAxwgoQVKkfB9N8p6ajpfTaBAg6MEoqrNVUrkCo4gBoFHa61Eo7n/qMRj
/rRMWNraqEmlmC9YDIQLMhm2uVYbvO658CPWW1+ZG7wo5Asj5jAOnh3iEGWr
ujxdmujMAgBITaDEQfe+9w/r/e+z5DvGf68mwJAaPeuZz3fQn0+3abodJ2wQ
d5sy+9rLEhCBEHdPf5d+4l8pg8f256/xps4yLUILuAwICbmG2IJqBA9uTaIG
6wNJdXcXI82XJjvTm4sZHjev1BTNXswSrKocuMZRpq6HWYy4NYr705gnVWFu
OIh9Wok4pTDVmt0a+6K6QAFQK3xJcmvVR5zyzfT6Rlp929uoG1goqUoUVZmm
0R+sqkAOb7RjVi+mt5dotMT6SniDGJ4d8LYfM4JHWByPEecyW+SSUNOQu8G6
M16BsMretHQe27/9GuvDb21NdphaNtdChBd0ngr4UzSqVFETq2pgj6CfFUZc
acLVpqrWWtVb87trDgrJRZx2jbe5d3bKPHHN5MTC2ZLFX4VaSKMX97bjOr6f
tR6BHGGiI0KcLfHYeQE3R5otUcj4TF/y9m8UH36TMtNlVGgzYMCNEoOqUkUl
1pXrvxwAsXj1RTEIXFC3Ax+wFLuGf6/Ga5UnZFyH3WYN1f1ZfB+pq56GmH7k
mhut5sg1/4ANrvn4P28NvM9RUA02oek/qvFD1wyeAq4CJ7ckUFsV0IHQuDyV
H70TXZuKaRQZyCl8saJSX+bLMIOnYnIXXYkK3Fum0HQ0BZs55gqVta4aX4ks
k7JZ36FWd7dTWyTf+F1d+3vim69KJju8TA4OWC1uzO7HrB5MZ8ZM1rIvUIjE
875g9oAVXhhxjtw2dZ/RgGueuO9g8/IcQWmPW+IrcKWzrvGh7kCIH950hckI
0HYCG8uejuPSKz/jdp9RbxF91mBZqsUhFlLINTqjJpDiAJpzUINkgM3BxfKq
VFFYGjDfe5N7/eX9sbtWDr8MYtrgqkJF1TmrByJ8c70w0xda6HT0XnR3nDC3
vasbuOafG8gsDGdW54ssdpU0k+g5a7v6Cx5xzKnRpUBmaZ04xB46s0paKE92
58Hd3HvffP1lKYTDY1/dHDzGUewa/6PJF/t8vshBfz7fRrsYuGbUPArqBEIv
VCSULD0L9XwXLtf/Hlu+ra9mQshjNOJBphl6M5gzVTXH63JLvaGZIPNJwqOt
DAcUwlgwlDFbcryDPJ1elKpKVn/ZE0ODNrPpTDqNhvhBJQkky+YQDvILCnNh
FOXU80P+qQ7TvXfF4DruvSVcGvUI5LjeUUUDXvNFf6zk9JY8/iL8PJ1KasQ+
8pSl76LqzlHxxee4nSeVGysBdSNFBWcNYV7lQn35EA/Msbo1gfqAwZZl5gpx
2nv3Ldnt18Srk06dNccXltYWy3PDlQ1SjcFsZLWU2jqxDrktIOZyixN3LRd+
xLz1In150CzXFi2BqjeJuaKYQldh7lWJc/nRu8HOD21dp+HOVa1vyHov2Ca7
4gsj6Z2tokhepW4kxm5bW3+jWBt36PUJf6IM1UOkrjH28NVFbKqnMHAtBOWP
ms6+zz72tc3B4xwF7RN8Ue70P+Tb6MuE+vMgGX5VfgWS4ec+xvdgWWOXOUqp
yCHfeJNvEjfFkEQGxQ98p3sikGcu9LjYm4H93aiAlaKRM+tLWQ4rzxMUxXJM
qa0YDSW9ARkgyqjzBXeiorVVmbv57tPW7rOO3vOWjuNyqMb33hRMtqqpKy6d
DfMmyhDp4YqgIEGqxlP5VDJpkHn3lgyT1yTXX+ZCZWh9QzDWqt9aDeh8VYB4
OMYK5J0xgvii3v0QGrMlNVaWJ71T3a7e86b299Rby8HZvihITKjn8yMYebUG
AXR1EQ2PbCLe2Sr1XbSOXdWSOpXsebXXnUpnc7FkzmItCkXYNrkyN5QbuhmG
Z1+ZjpLmQksTXspmbnO9SNkocLkFjbXC2YvPdNruvqVem3jEV6iq0ffwtaXK
dG8BFCGUP7jNs8/ugYAe+ID9X/bPv51v15mHwfetZke17MovhA2+ex9+cwf4
tr3KmLshZC/qzFJXNhl7nK8jiRubfMF+NxHfjpOWgUuWkRvO8bu+6c7wXH9i
biC1PJFdXShsrpap21UmA5dKK8D3MIhr9JnFXvOFH7EvPrd/5QW49H7He9KZ
dv3OilMqCntiaKwGPBccDM+IakUypZd6mUuGmZviu79iQoW//jJ78IqCOGXn
7EeNoeqDvvyHg3JgBw2vCyDoQFysr4ADZ7BAC6aGb7u7T1sg9oFvvPJzQc95
18IotjKHRrU2x7Ouk+qrC2UqKSNgJAySaMAcLCdC5Wwi4EzrZDkurbA2X57p
L6zMFiHcM9mQFmJiPSZU4xwhvi+CIF6xhSoCQWKu19n+no484zEYkoivoypU
goDGV4FvXxESVAiOV18QnXmGCVr2U/rqsxPg/0L8/RTfhv0e+uevbb77d6Tb
L+5OXeYxZtQGkeNQX6H4m6yC2AVnCFqWuoPNDYL9OhY6bSv9rtVRP3k6QllM
Lo5miPP5DVJpm1KhMWpb5DqTWdMby/4QagCyBSsqTXq+23T+ByxID0DXgWq/
/iJ38JyUOKRnU116SwmCLySo4JndvqLdkgxGsjp1lLHmmG5T33mDd+Vne/0X
ZSvjFhY7rHWXQO+hzCFdARXnTlYgM0e92ibUmSHSocEpgFhuQ8qbvleE/Hmp
2zHR7uq/rO85p1oYiWyBDNjCmbTqHqPK2qty2CBxi8TxBIMUkTICVqm3mg7/
OxZPBpM2XUbMyVNWSsS5yjalytrHheoaivhedBWo8AfiGqhro7vMYQYm7hpv
vyYjDppV8rA7UoYkGb4FxbIyWxm/n+694AXlA5oHDOrcd7f63mcfZkdQ2o9l
R4UoGrBSbvL1fp5+foxvUzy/D3z1D7snxZee56HuyW8/6J588yuL15/fGj/X
zI5ShUZ2BAISitGRwLWeGhQXYw9bnkqMtIbWRgMavl8vjZjVyQN6ens9S2eU
2LzKgQw1R0K2A6kOm1sDXy3TogaCA16WNO65/rIYXAfYESA++Q3qhR9QO9/j
znebmbQyl1vlC6tCYeVgL7vSq6fMmc2eEl+YJM16Bq9qO47LFkesAFfTgGtJ
1uHxwdLhDmPZItweVD+OoDHNhoWwooTchwI0V1g8YMX1woD4IMpgJnd3IvxG
+sOg4SoNpjeVjZYyi16cHUwPXHUPXjQu3tOJNi1YOoJ0ZjkZDaQNqhyFWCbO
VxgsnK+oQZ4GLkIXRD3kkCSzODW+GBOIMhtzjr6z4os/Zk3fkUtlUWuoKtdU
WdwaeQ2fHcyC8YK4hWKHqHT5x3SAu9YlkVJNzYbLYqPh8tOtG78t+33lU3wb
8fehvmrq50Z+tA0ZGcp+/3h64hzbLLZVGxfNPJTQYCZGLy6DhE6Ak1dL032Z
7aWUWY0G2QR9abUiCxJLrCwrrDWo1fQ95PfI66ipAkoAih0Skx1qfqoLJYBo
bNprSsjOTj/DeOdviae+Q28/ZpkdxJamcNJiDeyo+4z57LOM6y9zFkedMjPO
2EsvjHjG71mplLDKXmoBtIS3zYmPoG6Dh4HCiecKzmRV5UTygLyGWiXAkI3R
j5qdJvZIJZXNASyorlBixigavMBg10FT6U1YJF00GHK7G+nx9mjXKeuNV6T9
J6UCsrWUiqK+Isgj8mmDOr9NKpMWqgx2TWpE46lROIh+JNahJ90iV7Y3stSN
6FS76dar+ye/vjl2W8WXJAyBGgRfyOSJs4Xxe5HODx3w4Jd/yr/xAnf4tGCj
RyahGH1m78PWyUz2c4PvZ7Re/eJj/vmxUUXN/Agu12yaBI+Bupb/ZuXon89P
n2fZJNZ6IyiA04CLRnMoClv9FcgZoXD2uCAYSvt7hUAgrxWFoNxcnpzWUDR6
KmxOUqXJWO0lhaikUZb4nDRpJgKJCXiwfV6WOO69+oJwps89N+CZ6rL3X5Lf
ek3Y9/7+ep9OwMxJ+UU2NT1617dOLA5eNU93OwRKvDGr5ivblDRpLiJQlNSu
Ok+apzPidHpcwA6pOG6D2AMBy5Wqwlf7wvryNNS91NpSks5I7e6mDiQlmblu
cFRCwZzdV26BSkD4KWpZ49cPhLjZiemNOZkoQZ6PDF73t72jbz2q6jplWB11
OyzpgD/v8xWc9rxRXdgmYaRFnMmuQQSBbIs061pbcE11Otdno3RKYX4ovjDo
7/pQfel5ztBFadcpFW03IdGhWrS+gs0OxAeuuO68qbvyC9GtV3jjl2Tbo1rZ
jslv9jabJkuPGW+z6Sqce2S8n9v6/PPH+Daaro4hmQFRACyoITaQzkGtk9+h
Ixfd6ECeu8x1SCzNLAlF4YcN0K4IBmkO1F6hCuotrlBXmFsJCMEyfhQOcEdK
YlFsos24Pmr22qPJUNpjji536jpPyBnUsCVYlaszsx2G09+lDd/QcfgZ9kFy
fSU03h4kDnoVDHvYnXTqIrM35Zd/xmn0PBfZ/CrhqQNZnfCnIJLgkuiqzPzc
oHfktnX2jmHiqnLujkrMD0Hl1rghpy1N96SGb4V6L7jG2kA/heBXhBZwxYQj
ECLAlcJGaEEvP0GtHHKcxy8xqOnNxejSoL8bVX7L4DXXZGdgaTzG55VkiooI
IgUHY9Mw6mpldRGXS8qpREa0a+94j3frV5y+U1IxK6BTpokjwYErjjtHlSvD
Nj43SF0Lry4kWAfgSbD5kdzw7WDHCdTo3Ppr4eRVxc6kQcVyBK2++sP+pE93
Jj6xI/kJbH/2WO7rQuOwDwfvvv6grxDc8/kfcs58Dw0OQwrr/1lduMF3Kx1p
nzfh9UfcQb8r7HJEA9EsOAwQcZZoTWmp8cQgCbGl8Xj/FefuRsTiylsdyY1J
8+1fHQyeFEgpxlIq5lI4Fm8J7h9l04hWf7Kos2aWBg0Xf0ybaNfxFRlDBLU5
b5Fr+0zM58pVc1FwGFPnWRefJU/e1XN55d9FLfx/tEXOj7d7776t6/hAdfcN
cecHEgrJaw5V9L4qg5mf6YuP3Pb3XXK0f2Cc6Q1RqaXGr54HI9vaKC5Pp6e6
o4PXfQNX3GNtwbmh+OpCdptSZh8gn0ql1sjrtdUliAb4/EBGzIjFnAHesqrt
ld1z39tabBXZ1J6gJ7636h24YJ1s93JZSXsAjUXe49Q21/LzI8nhW+H7J6zX
fylrfU08dV21O21ScVxhZ7A5IOhj/UGHEfVJRvnpfuBPsjvnbvT3IekEoRU1
Xfz60DQPILqigT0oASKv3JUwp1S0Eel2n4DcKyJ1SzYnNEpJKBzLwA34EmWz
vayzVuTG2r4Y2yDGNdaS2VUQHYSIA+prP2f2vMVizWsNclA1CafcLlg3pLMZ
V6gMpqkw5mZ6TDxZRmquH0hrkCuDsemtoD8zXr0vn4yBHt8cVeuNeZECP2QH
tgKZysqwZ2veubvqckRKEGSsiZrGje/SQInHx+9ByFJO9wQfsePWtyk14nxx
pj+9OBLfXostjidWF7PU7TKbV1cbqzwxmpcGx2ys1tjMysZcrOu4bqtffu+V
3UvP7850acn9MqfaHfHG9je8i33usTuB5fEUT1DZ3sKXJtMT9739l01339Jc
+in/+ov7Y9c0O1NmJdsVdISaOujTHXmPpO6nwNl/G7sHbcaNHgHInB6Y3qvy
aw+GWB80xBEal3X7JeaNn+5e/eHWxWfWzn5j+fKPyGOXhLQVm0YaiMVTiXQ+
lCx642V7uKL31yQGTG0tCQRJ6rJ7+KL0wvcpt16gj123UIiYQZHHMolaKRaL
5Qw2DGSvzlsTawsSY32Xjm+sor5RS6LuiJR1qoiEarOqfMl4MhxO2VzlQ3bg
XJcmM6N341vLSZUq44kVfI1JB7ZEzRwFSYvT6InBa4ZrLwlH7zqp1OIX0a9+
gtqnuWg439oyDjm0QFzS2YtCaZlGxzh8xM4TKcMtQdjcpaG2f7OjLOWHRy7L
z39v+9LztIVhk0yftVhiYWcgEYhqxeHd1eDqdGx+OEeaxye7030XXW3vaK69
JDj3LOPijxiDZ6XkSauM5Qk4wtXGuGvUwHA4FDP/yOgeZ/doxPUTxl59kl5j
YE3TcTaMz9AcVQu+E0mfnzcAfp8F9gcJ6vF/oUBK/PZfrxz9i4U3/3L+1suM
2bsqJtGql/mNyoBOEVTKIiJRjMtLcnhpFjdNIYXmOi23f8UDZQxn6DhpnR+t
iNiFmCeZjqS8rpxcWREqalJDna8o7u7EF0Zi4/ejm6uxA2GCL00zyF7ygG5/
w25QBCOxdCBa1JgrLRI1TjjCl4GGRpqY8BR6+YOtTWxhLM9iFq0+zJ9CGRuU
gyOJgzPXB+pCdXl+2NP5oXZlOoo4tgBGwvMAkkqtE+fKoD12N2MCQXSXEifN
J4gzMfpmWMoPsHdCpJkosJdo0CgalTI6eUdx81X2/fd51C0flCwUPQQvDEv7
PEkxP86iZ3c2MepGhbyQne/xjF7V9ZwQ3X+L2/0+jzSgFzB9blu0OaI6/5jf
bI6ofjQB5tPj5pvDKZNPnKn2V4/1zHmbbhQpWFA4EAUhTQCYrymRNaLR8YKL
zx+c/xEXstHGQEkUDkHQAtIP/nG9/S3+QpuyZbFdSfjaUod67r5m4q5+vM00
2WGd7XfP9Lh7TqGsGfJKEE5g6rODZQEjJzvIKUUFjbzIO4CsvE6jF1fnw9Pd
1t7z6nvvqkZbNeNt+skO00y3deiMbLlbz1p3auThYCQDdmLxVPT2ilyPA8wv
IIq/DxSlmqreWbUFK94Uqs2QklgiuNZdk5tBjpaXpx7x+wmk/ZADb22U5waj
/ZftHcc1Y7fUXac0nSdV948r29+Xj16WdB6XDd8yrS6EuKKS3lsTShOkWcfq
nGNt3rGz5YWSfdSeVYQIn1Vqyko1ptaUNZqyTJTap3r2Vq17qxZ45VIcVksc
kqVsY3rLYZrxcAJTOfjYgOhPWiGavYTS6ScQ/N+P+s4b45sb5uiAuPvAn76l
Qxb5mqo5RwcEDRglgEATHX7APvvs3plnmJB7nvo27fR3aIQjZ56hEf757Pfo
4D/O/4B18Tnu5Z/xr/9S0vqGCk4EuWvfRd/QrehYe3q6t7A4Vl6ZxlYXKhtE
fGujRpovTnWF+y5a7xyVX3yO/eG3qKBTzz7LPP9D9sXn9y//nN99Qr7QZaSv
uZTSiDec8yfLoBcOERIaDH9PoKjJDbjWgUNIdScrrkTF7K9q7LhMXwO3/JBe
C8Aj/D19r0ycjY63ATvllZ9z0cybr28f/5etY18jf/CPGyDELz5H6zolnhsw
7+6GZZayLoDrg7ghhBvDuCmCCrbZBwvWAiUPXjCUKUWyxVi22BwCcySeyRG+
EsvkYmk0OAj8ZXOSyiGy0GNzzhrzCx9NSPoEOPMT2f3pIbv+y2hWSs8DA0Te
FGzw3nsNNXNUCxHxwTSyX0qvviiGHIfQAiQJTyGWP+VffJ4Hr0eAMOFrjQGl
6t5z2sFr+pFb5ol2Jyj53ov2sXv+mf7E4niOOIctTVb2aXk+qyg6KElF5R1y
cZ1YWZnJT3SEes7BVZW955T9F1WDV7XDNwyjreZrL4kW7usYRIdSHPIFM754
2ebDIN9T6HFBkwnh9/YldbEGKV+DF3fFK+CSoumCP1x0uIt6Y1Orfg3AcVEH
Lc5g4ZTN4vxwZOCq7e5byjtvKrtOKTtPyu8fk7W/L7n3rrj7tGS2z7hDDUpN
RXOsLpClt9b9lA3/NtlP2wmCS1Y7axpnTe/CTe4K+FaNEdPoylp9SacvmW0l
d6QMUs6fKLfAH8LTwcb8wUP/2JwZ+qXHmblTj2YL2pOgWMBjEp5C6BJ1c6Ju
ij9prtEfP6J3Jdh3qTFJ6qyrCRBMpRERwQQNyASPaluPam7/Rk1oAX9K+CLQ
hDeNRhi0A9/B0YQWqAKErw7dDE52RZen4pTNOI2e2qGm50fC4/cCSxMJ8mph
exvf3MBBPgA7nysT9Gc1svTadHxhNAMQiXOFuaHo2lKUuh3b3YnR6HEGKznd
7bz5K/lyj1kjCYTCqWC8CEYn0+FSLS4Au/vdh/z4yrrMWNN7cHcCg4oOcaZc
SCWjGeD3JXTM15kcfHurtLle2qZU11dK073RiY7oxP3o0kRsgxhdX46sLYZJ
8+HNtTCdEZGZi5Z4HRywTJWc6TTcPybuOSPbWgsq7Wi1Cz5KH2sKXRVuRSyr
0LYru5uVPVpFKKmqTLjejZsDOBphGKw4Q2WoT8CoBQzrCOoC+ULTwh7SQjN4
j4BkbgFWhCNNWsbYE6PdHz4aR3Yt9MDkwGMiaI7OUw40IbcR/MDwgBuh5e47
hpa2dwyEb4MjBXUDHhUOgWO7zzoHr4fG76fnkPAqb5HRkgGoPdONcwTl9eX0
wihiBVnWgQBns3H6Lq7XltLJTCIUE+8F57q94/dCC2Np8hoOiRZPjmbzNNeO
4ApRdt76hpo0aNcro6FgUqdL7x8UaAy0ChSTjX+MlqFm9FS9CQycE2i7f6/E
m7Qax3yTxsAomyXSfHZlOktaKMK1liZzkE3DPa8v52j0XLONHbJ5NJw0UAda
YANgHxptbLFHe+nHzOu/3J/tt7MP8jRGnrKZh2fkS2qQ4HH3qxvE6soURpyv
UKlV1kGVJ8clRlztrOucuNFVMflxcwRN43kK6UcwqBZgRDjSmJ6JrgOYANBT
jbUTPmounPA5c70+sTJhY3bHHzw24jPUfzWIpnYdwjyDjLDJE8yqBYASvgc7
wBZtH9rhKzhy4Fpw+HZ05E5suje/OF5eWwYVXuYIIHOoG3x4IFYEE9mllTeI
aPAlSHaBoGKxlgy6UiqRAdsI+pOcVfvodXPvRcdEZwQscmsTNUY1l8ICpvQ9
iJDBtnf06+NunSrhCaTpS9aFfju45OkeP9QZJqd+6DtF6praglu8lUASRHq+
VEqnktlgIAc0G8d8j7yaHmtzLE+mZgcT072JhdHsLg0fb/fce1fd9q6676Ka
yYxrXKh/R2FDNM3xujVZ82XQuE+TPrLar739KxFo8Ms/2xu5re+/pFtfiaMV
r9h1nri2u4MztityXn5+ILswloXqsb2V5wjxxki4msqM5uxqPajH3BSBrWaK
orFT5hjYXLzWgGlqbIQjpmid8LTx4exbQ/gjfeiTlvjkMdyPU268f+kR4Rth
ZK6PQYY42X3W3ZyR2kQNr0AeBCx8C34YDh66GRm7lwK2c8PYyiykdQAT35fg
cmvNFKpBqlgqph3OIk8IyXKNsoU6gdn0isNayKQQXtBnLm+GRnT1nFC2f2AY
bYsQ5+AkKHdjsFDzCJ1Z3yAVprpD94+ZVyd8SmXK7stuL9jb3xLefl02dNMH
F4UaAZAfKBvQOBAwjQ40tDqUKqXy+WCs6PCWDBZMrq42jnkWKPddMlz5xUH7
B7qhm4GRO+BPs6wDfG7Ac+UXrGNfXR+6LBGIYrYY6JeaPtygnKjbUzhENnAC
dlOEOufsOKYDgXfsa1unv0PpOiWnUuJg5nB6uO/9/ardkk+GkkJGfOp+dLIr
RpzNUak4CGGotyI16nqTWx4uehJAxAGgIYw6XlsAawv8PQLWSjiC0Da6ZAkt
uuB/e6bWE+fuvfxo9P7N6APoaMUEgO4Fpg3unu4G+p4m6Is++Bb8OBw8cicO
/hhU6fxYdXmmRl5D3UdoAT49GgjA4iYUopBD5ebtBlemICii0X1b5Dpvv+L1
FfzOBJpg4y4pFLnFAS8alXPZsDAc2aYg9wwnIc5loYYAzeXpwkhraOS2Z24g
IBBkdLYCacLZ8YFs4JRksddD28SggKWqKjj+pxvM9zg1gRhXaCpGa9kXKrr8
JaMVg7d8Mb7HqTeO+cHOLsZklyY77G1vSwauWqe6I/P9YepmRqSqrs267/6G
dfXnO+M3xDJ5pDE2EBepMihW2OsaB251l33+AigtCT8+0+PpPq25+SvutReY
bW/L1pfjILbgMXdodYmi6vcXIGNUChOLQxFwmbMD2bWVKnUbrbaAlqBSoh7X
5vhGlQvB1/jQeBmoAkD3C2iVBPhLOPJg4RP/b7fpT47TP/LAoxO+BDvDt6Jg
noPX0dIJTcSNdTF8hCPAmfB1xPWyH74YaJjxyJ3EREd2urc4P1JdmqqRFlCv
JdgV1Fi4XUsY53CiIzc0y/dkXSc1i2MxVM/FqMKrjVWNJru3Hj6gZQRcbHut
CNpq9I59ccS1ux0RqnDICpfGPB0nNIvj2XVifX6kMD+catkgpQhfptNzYmWJ
NOVjrzuF23betsOgLTg9JT4fg0gKpdZsOfi9Zksbaw+XSrBguOANFESiCryF
D8FDNI75IRBeGE3u7Ba5whJp1k/dzm0sJijE+D43rXNU6GTX2rSZOGnZnDUq
FWEIwAptcuq+dnkyAN6Zza0J+ZhKg5mcmDNS2WOhpZWI0zbStG3oum2qJ7a5
gdr5qNS6UIrbvOVEOis4SI3fRjJmrC25NImtE6s7u7XD1eLAp0uMaEQUWqnK
hTrS1B5Em/C7COtTmsZoGtge8Prv8CX83qOZV7djaM2TG5GB66Em5P7L/qeA
KuHriOu1IMCHWjB6NzF+PzPdV5wDtJNoCSRwwzs7qOtIDHLKhUP+J+CHx24o
T32L2v6BamH0AV2orRx+mTiTGLjqG2uLzw0WF8Yry1NQOEFAK1ZnzTF8e8PT
9vb+8X/ebHtHOzuQg1ICbC1CTY3w+wJ1TazB7e5iKpUuFZL5fCqby1hMeQal
tDheaQI+8pAvWt2OhCuk5UgkHwzmpWJsfaW2SUYRoHHMj5t8+6/44PaYnKLU
VONLS+y9DI+b1hjzrjhmj2KmcNUQxG1RzJso6vWxhU7Vme9Srr0kHLoRgKem
bNZQJJahaQRQ9lovDgcbg9UDUXVtubo8XVtbQaPOwZeYXVggUWCS3T0fyq+j
5encU72Flbnq1mYNxEdzCUUQH2hNQANaIQBAH64pp0YryAHtp9CyRU+hofCe
J65N9RnzKz8dsx/xHmlF6xYho274bYT8arAFUBO+CckR7MOHgLxhzXGIy5Nd
uZmB8sJYdWUWdTFAYIWC3hehKRVA3ZmoNqlDDt/+PqIOfhgebJeW3aaAnk32
X/ZB1ZkbKpJXq3QGsgpAbonhcmOByYx1n5Kd+R6z67R9pj8NxYc4gVom/D7E
AvCZ/ngJ0vtIpqgWhfOlrEFX2N8ryZQYm12k0bGWh9Qp5BqHUVHLSvFYNhLK
KSQlNrNC2Tyk/jciZW2fVyAvRg94Oa2rxpPV9O6qUlvQGvPueNkSQJOq4HOV
sw4iXaPP2h1pvTKwcEeyMWrnczBIduZHSmtLpe3tEpNT0rmr4FxbjGE484Gk
trtb21rHoWRQkBLgJgcWiOfoq86uYxJI/EHwQKVfGMfWSTi49wfD1MVoATcI
9fCYzcUE5Q8HqwN+tHLgEZW7/hRaQfCJWvsLj/19bAVBtCJVKzLmJtwWAEn4
NRjwQIPpIVagP9qWnOjITPUU5obLS5MV0nx1g4TuH26PJ6lBsgJpnTNe5fPD
gxdEb35lsfUNSZMseTULXnn4pn26FyJCYLwdLQe3Qy3ypRWFpXKIlTjlGbll
uvqiqOe8faIjtDKTgeQDfAH4NUhiQLmg6RX+miNa5R8klnrssv1grpR1uQsa
dXZ1Oro4lkDN7EgH1YSiilZTctryqXgmHs6A6tOoy0IRmv9CaND9skiFBu6q
dDlbqMoTQd6Ly3VVRxjzxMvWQEWmxwktEvAkz4ChQXq2OhXYXfF6XQmr2ut1
553Ogslc3FnLTXanF8fTbHbeFsRAtDWXlZLoa0oTLlbiO9s18nr9gIdbHOVQ
PMtYc3S+L77yc+G99wwDV73TPUnifBVCHRoH0yC8L36w3KeosVxkc7VWZOAN
zgrHA9QEtPLn564KCbbzwGAbWFsAIeE1UAXgrGEXKDeBIlNtB1PNTvcVoK4u
T2Ori1XyKo7CL6uGckE9bnDjjlhVqYlP3ZEe/6eVrpOy9aUkZQuf6AjefQu1
cEASNnwrNNsf21hJ7bHzUn0ZSVd/hSdOb60GZ3rs3ae1rW8oes6bJzq8KzNx
KrUIAA6ZQh1GA/10GGk23HHStDnjsZrQfFaFMLY04JvpCVI2cuA3hDJca8Cc
rmI0kivk0vlsOhzOgbzX6DGBFKfRSy07uwXCl9ncvFyTtXpyWkuFQa+S5tGE
AHsQDeCF9AvKt0n/G6T51OB110y7Xb4fymYzkIvFEjlfKH+wl5npSQAZFiNn
9ZWhbuh9NQiZpnDNHsdN3ioUCgTkHXJOIU3ZLNH1Ef2NFzmgxu+8qeo9bx+/
H16aLEA8AV++S0fJV3MF0EOqyGcbUT7eXIP3CFqz1dZY5fNpIPwEpl96jOmj
xeOapko4AjBb0M6/PsYzPdGZRQF3GFuarJIWcNA9mxtoSVkOrwaVXm1DC1G4
4hWtPjZ/T8LjxEFX7NIgNJf7ryAZPt4eJ85lSPMZSBH3RZjKXnPEUVeJ1lPZ
F2bIxBCYKWnSPfkQZrNEjxwCba42/HdcETY3GBYJsjZP2RNCi23LhHHBQVpj
qQJO+MkhUbc56rbG7Q9Z7nHBpxQHrxn6L+vGW7XEIR1l2S2R5/gSnEqtKQ3V
FouvQjjSxNm4NHr59upCancjAWdRitNKcVYpKQh5xYXhHJTGJJqSX+DxKjwR
yKQam4cDAI0TeSzI/EkLpcFrzuFLqsV2yfl/2z77LOvmrxQgrgZvBGb6s2Ch
YMIIJ60xnulwfWUl8sTN9ZWRqTbXVm4Y7BcA6ueTRMsAgoHGGmsARoduRAgN
in/3wDZvRIbQ+oCAM/EAZy+4XGxxAl+ZQ2O+IJiCHASBzJPWwUepLLjZW/Em
yiZT1OLBJCocHODaSnmmPz/dm1lfKbL2Ky2sgyrhy1AH0WSFZNmfRt5K5arK
DEW1Oa825XjCws5OkfD0Q5YHjY3Qgl6+RGNgIiVqToRCdwaxeL7gjZaaIAmN
ePonAFPMT4sZPjEzIBZkmxh3dquri/nuM7pT36Zc+D7l5i+5HR8o5/o8DEaB
I6jB6Vq0tirhCOw8INlQ098QSKs0SoE4kSJOZNfmiitTZVASs0PY3HBlfrRC
msPXlmsQe4jz2C69CokN/JiyWVoYzXSdNp//AfPEV1eO/wsFgui99819F32g
ReZH0bgyMILthxibk77AMEFJwRmED1fKhuqLKi9aBfsIwDyCVsb+PJIgwD/m
aj9BsuFoGyRb43DoOAqe+dlBJIsgzyHOozYJ8LWgONCkJjEyTyhVmw/zRFHX
CXhf1gFEkPLieKH7rGuy07+2GG5ZWwoTvqwwonmikBdGs0VPAtP60LQlXxoD
tiZnhcPJE56GGtpoc/hdjhA9qVhTMzorNlc2ks47/GW5ttoiVeOEP6EzMfJi
hDxuJ084yUuxPW51Z6dKXqtAxnTvPe35Z3cuPUe/+Sthxwnd3GCQwaqgcYbS
WgtAIxyBneYq+IQj6OU7jD3AE53qDvRecIEnAQWxPFmhbZRo5DJ9E2NQKktj
+Z0tfHsd214v7/MqDQOEmJOZ7Iq1vas9+Q3qsa9uorWUj2p7L3rBTKb7CwtN
eGTUMNNcSRzK6mOL0h/y0z1CCE72/yPtPbzbuq50cSxQkj3pmTeZySTzZjLp
TjJ2nEzapLvEcYu7ZNnqvVESSYlFYu8dBAtIsIAESIIgCgECBNF777134IJ5
5ff+hFnrt8+9IEjZep7MvLWur0EKJHH3d/be3z5nF9IRQBFu+sd2pz/ozNpT
fwhDZFeRaUUOE7ymj/Q9gv0QCgnvw6ktbl87CmO9iLlDuEqnoU+3wkQ6ydkq
gwbKIDI1lNSWEignRwjRW2FuutB9x3XhF5t1bwrq3hLQZ7xqZ9npzcaTyXg6
5QjkpcY9q68QSWUiibROHRu4qxrtsNSApyfVwPNVTrNx/fwyPL5AWpZIM1Od
GiZVF4qnrO682ZkHBgNwDj30dF7RdF7VjXb6AM7FxRLY9sGHicb3NfQO5UK/
uq/eONblAyyR5SQjNHELCrEFiBauFVax47r27ptbDe9Jrj23de050YMLjsnh
kpiXNahSRk16ay3WddM5NxaGsFWmyBucRQ4Xo1HzY93hzluem39E7fNuvLRD
kAMQWoVeDCB6QYwXACQrsxr4SBOJWQ0ITBkCkwxokmqqeIJH0ezVAKqf2GEX
kHkURwQigrAGMdp/qeII74CV1XsvDm5hsDWHG9YSdahiWA/TMZAKdz+khg8G
UofVN9rhv/Wy4LX/NnzvOJfJ9JqJU/4cKnQyO/LwwSGAC0dT0UCQ0Se78vOF
my+tz4xbdeE/Ay+HRyNOY/6WtZbvvm24+HNm3curLKounEjZPAfw1b0jv/e+
qgofdSg/3JoSrMX9rmgoGNdos2wucU7wYwKz5ZVC+1XtqafnX//SyJtfobz7
tanLv+GBN58ZL+8Ic8B/vdbAyqi54W3Z8H3jNj/oi+ek8uLiLDbckQfOgHZb
z9jAVoKgQHhACQfQrmqW0g+qV5ydQtucj2DG21dA3ICCoSFgIxwiYjkqBJ8a
livwne1D4yEOI/epwxrYdTcCQcjBttE1Xw1YD9LTKLCsxpagg7dxp1gfqzjF
jtxoNw7fMAqj52ZK87N5Oq2AsoUXi8srxeXlHJud0pkLClVhlebqOcc5+yNm
68kNzprLlUBdiTO5pM+XUqvzaDdJWTBpolt0zUKH+OKPaNd+vzI5YFhdj7LW
IvSZCHlyOEKq4bBTcm0RSAiJjG5fligx+MmlxXTbFc1Ik06jS3KXTBZntgpl
02lNy9kDTaQOgzHPLdJyOm3GYM7xRMiAStVYDfptP9naKdMmokMP7HANNttH
211yVUEsiFHv73R/uNZ3ntNznnfnNWFnrZM+XZbv5lzWSCIUdBl8jAGjlOuO
pdPgNbzRHOq3v5iZHwvAYu27FxhoDg+1xUe702M92bHuLGWgAisEu2hCA1EJ
zcYnb/DRoq+4RlwhD4NLQnpJFqqquonPlvi4Tj6K7J3I/l5RZeMA3zX4Wetl
N9oWvIy2d1uveEFRK97yNphZiDNBPQHi9FAbMNn8eF9hYiA7MZig9KN+GcCx
Kf2pgWY/pcOlkEZQ43+BdbZTV/+OmvLAINqwEf3a4G515yTiAtDbDWZqtE7Z
9PpK42vL55+ZvvIbRtMpSV+Dtbfe0nPX1HrJNNnl0CmjvmDa4c/ZfHmzuwDY
VtgN4MsTZOdGbI1vrVHbdRIFApfSF+yps/c1OCYGkNeEUHV2Ggxcfn4WrGEJ
kMV/9hcALoBi8Ra0liJfVJ4eizZ+sHv9hc1bf+SxpqxefxoCGrc5oOEalFzz
7qaVNe0cfuhdWiiL+CnxmlO/bUuGAm6DN5eL25y5HRVm9eT90axWkxQJE0xm
mk7LTI1lZibytMni1Fh+ajQ/QynO4jHcwfiNVXz8BvcAX8Tw8NYRhyEmkQHk
mgrGj8H1s4d5TwXXw7u8l/d3eclol/df8d37g41eBO8hL9p3H7w+xM8AY3Sg
OdDfGOy9FwHkhxoDXdesQ3cMknV3Jhl1miPrs8HOm75FalijSQRTqE4CiI7W
jsptadTSQLMP7PGJb04f/8bke/9Mfe/rNPCxd99SE3kxdW8rl0asTlMomUqG
E2l/PGvz53e1pRrEa7+wuJB6cF7+/ndm6t8RzVDCIJoFehpwBUQXFzKokGUD
XDcwx+IyEwNTWwMEh/QT0U5eb8l4YjmNucgVlqdGovff3z35FP3BCY6IZU6j
PkyoJ08qEo6Fo8FgXKtNbawDPPnZYf9ct55N0RhwUIOBpFKN0gIVuqIrmAsk
skZXUaxBfWDWkU3fw1MBinRacYGOLRGzcpYRy0CDjtioyKaC6NY+orjSVvK5
CVTxfG7kUQFZXHs/juoXHo1LwIMTqroP6UUXcTaDzt7wUxlyyzkH6duV45mK
/lYAxvuah/Duut72a462q054z/0PzBx6SLjslbGdhXQYYnujPsqa8rZdcc2P
+cWiBHhMe6RoDpVkpjKLDYiGgC9NDvnaLktbL+5c/f3mhZ9zbvxBQm46bSUd
bbtiG2hywyURxc32HIkMfJdU44wUTN7irqEMdhluR4TyMgHu9FiIiE8BWQJT
QqePArQEqKAHy8tZEnm8J0Q6tjgZEPCiQJThEojLM5QoueWsnPR09y05e9ke
TOVQmlAqYzVHRUw3f8U7B3S3Jdhz191+zdJxTjpaK2ZT1JJ1p14VkysKbG5Z
ri76Q6i1litWUDlQs15gbuBAAcAVJjqxBN0E8wuooiFWxAQkDjLFj2ArOlBY
HN0jVXQFCNsKvp+ksd2VftZB1EDpKp7NQgB7Dp2ok8hNZ6xHkHy/23TGhg5a
z+IHsDjeLQT8Z/HWACdRzkvt64prL2wv9Bi8Rn85g1on+lM5uSa1QPE/uGCn
dPqXF9IgPUBC6y0LlaXp0VDzWfN4T2BDUFhdj1F63U2ndXXvaOEXwqLpawxP
jSZrlhazNeAASTUKM9pFNAbA+qJbjcqOEXCSPoXHMyAZdJap2lvbyI60+x5c
sAw3O5foCfTTNfSZOMQhrDhfHLfjHcItkdKuJrMw4eurtcCHaDihvfOG7MYf
ti//hlv/KqfjvHS0yUQf92+sZdY2ympNPh5JoCEF6aw5gtKGd/RIyiB9wAz+
MCLIHAQS0ZgF4URAxdtjCx5FC1dGAOyQPu5W6yvICLeP4/X5wzt4+5qEJ7Ls
YwDwVBNZSEfunzSRUQYEwEL65r2TJrzLvKHheCWzDHC6/oL40q/QdBRqvcS8
bdorRkD/3InCjiozOx7svAVRVmBqNMMXYjpb0RwsiXVlGjVy/6RhuNW7ys7y
xJnRTvv991V33lDCbx58EKP0p5cWi7gOPQELdIYSIS4mIyzYChl8gJoebjUK
a1mwW8a3WvH3ErNl4FcOtwEJsHXVumYoSRIZZEf63hqnvM6rJOzCm5TOsi6A
cloN4bJYnaONB3ru2iGkvP+B/u5bylsvS678DlVc3fnTbutl09BDP42anZ9J
abW5RDSOKtXSWVu8pA+WFXYUCoJmABCcLXxgG7+CI4EaaD98h0xsPRzCjgwf
lnSk0lsJ95H4+cIRwb7W/fvhs7OPIAeO8UDNiJQ/HLP7aBoAOrVrOK4n1dS/
p4MbSkPSogQklIVEBsRI3wZB1xL5nHh1CjznqWdWTnybPnx5Uy80weOBLXEn
C1JVZnk+QunxDT2MjHZl1tdQQos7nldZsRVWvuUcGqzD4WWFu+nuWtnFX66e
eZbV8J6CRs3MzeQBP0IWYISoQxEyEBJSTdd16dKsd0cLFhTdagTS/ZjzM3h+
CoiEwchSh6JwjffCPQnWaoVVnhxJTo8n17llAjsIvKWGsiGAUrd2dZlVZmRx
PjY5HBtoifTUIeBrX5Vee0EMj9p2xTHcBjTA111r2eZFI2E0qAksrCNeMobK
ajfaGIXYAaQN2g64oH5rh0AkqAye6XuE8zHskK3ch6+mgt9j9O0Xh09BgHyi
HtKX8AZVZ6yNH1pQkt8JA57kh1CCD333TUQsACOU8Pc6SvirpG6ijHjJtee3
iXr8cz9hf/iD5fe+Mfvm31P6L26qBRZ4tkg6A0GHxp7b2k4y5iNzk8mpkQJ9
GtsWF1FVgD61NB1uu+aZGgrzRZkdVWqgTnbyu5Onf7jQeUsHBJNERnssTyLY
1hERGOuO1L+7e+Jbc/XviKkD/hqQxBdAIjWgSaQnWewykN7FhTKlL9l1x99T
558eS65vlnF5fQ01uTNgpkDJHCxq3Kj1IW8HvGF5mlLqbQg0nEC9fZpw2wyr
F9U5vrhF79HZDf4M3pIM9WkKYxpvWWZHpxNEm2oQNHe7ghOBygZuEImcUDyf
t4ZAaBPfVwSUaqookcjodoQnxfkofj0GrYOMIaKFPygYkZLZuK9a9e9qURf/
Q/mY+CyGXYDn5h+lN17auf6iBDwXnmK7denX/Au/4IBpJFpjvPVV6vVfLfZd
4KoArVwiTLRei5c09rxgO7mxmV9bw5bmilNDGR4ntTIX7bzlHWr2z46FtnfS
Cl1ypHG39iXW6WeW7r61MzUWp02g/tBA4gApCJ+HWiO3X9+te0tc97Z4ot9P
+lvck4ErAfcPcLLWSzOUxOxkYmOrBN8ko2Oqr8GLbQW2LU2rjCmUJu1DrYY4
m6Xh9vhwexIcLTw2LNjpkRhjOjrT65h8qNUrfHgj7jTokZ3QIw86/pWaKpYQ
1AAkTgxArEFI7WNzlCPCFYjwXR9FSILAqSD0uN203x/kBdxGjXhRl7dzDoIv
gDcC9QHFQXnOOCAVNP4guf6imBgrAYbuym+3Lv+aX01c36/HQ50cb/6W0XeR
tzwgB2SITn9BvOkhPKHanpcbMbWpKJXlZseSo+3R7tv+4YdBOiWysRaXKlIa
c2J52kJp1bVfAoXd6brt6rvvBx9GzLWjTe0B+4AQgtLnJ5EBGIQLGbw66buI
ZSAXjvF30fY0wEiMqwRIl5cylC43fdylMSUd0YLGVJinhluvOLtu+7tuB4AM
Tw1FRJKMQp2GKE0tDxCtMIN4ibc1junxmpNKi38dMpqgPqj1JA4MGf7YERwZ
Ef6aDN87ctim4RfSl8doyCEcUEN87+FubEStAPItr8pw8e8g8T9PKAMqGiDE
T8y8IBA49QyT2JN992vTtb9fHrjMZw4pINSOBIJE56fIftNFgAJsG2pn581w
1+MjD4O9DcGpgQhzMS7cTmstOUesqNClNzdidEpgsNmN5lfW+8Z70rSJ8iy1
PDdVXpgts9bKXBH4H952GcdheSVHOrbCyq1zczwxKkEGsTAYe2QAgvQ1xlKZ
0hPpuGoeumcSbAYhHJNK45PdLrACQJPg2YcehtjrSaMPzQryJ3JgfQEB+IRA
flAZV7RcwQHXDsBBpNpXkB2EPJI7brE4uEkj4Vpy5EBLQH8qyCAlwdnC4zTj
wGaBwTpQC7xdLZH4T6hC1Spd/k0l4x+AAOd//mcb536yDkYKHPipp9EIEuAC
735tBqxV8xus9WGZbsucCAaqvfuIbQ9YaGCkvXjjerc/JWBH58YiQy3hvvvh
6aEYi5EUiTNqc17nLgl3sstLiamR8Px0aJkW2GAltoRFoajEZJbB3kmkRZWx
COqF9kJwm/WDsS5P921Tz13TYLNpgxdXuVHiCWFW+DuoMZpEVlpbCm1tBr3x
HJcd4m4k5idi8ORAZ/sa4+O9yaWFtMKCSnjsQZStT3TPQFWRUby3jw81dkBN
zw3IZj2CigR3MYSOkGoIYAhsQGcqiBxD2H2S70A4XHKjSu+TpsqQCLwCCk3w
eQ6dzhPiBzOExP/TffH/qFJFA87i5FOLSCf+eebtf6C+8Xfjja8ui+aUmZDv
cO/jBN4RiWjOGsDDRh9qlRLfYMVnx6LDDyP9jZGZkfjqSkq4nRMri1IjKkgV
KfIyY15tzuqtKas3r9AWObwybwvTGgvucM7szldx+CrgcOcNiGLYfXUqgSRG
9NEhGucAJhpPGQnYn/fFszx2cPCebeC+h9Id72mID7Wmx/vQbhFzrbitxpQ2
lC6LyiHIqJTz84YoSvTV+NFvQbqBT6KoNGyRV4AArEHK+wqCawWBBLw4iuwX
+qcjXDwIIq7HIPK9w/m/YKiAcAApJhqCIjddxeLfuBdwg7SvBwdAfPB9BmDx
/ncXjn9zDsHxj1PAt17/m5F7f1wSzsjjHvef8fr8w30PQ7gNgDsZrDLp7xye
1O5uks1KzFHiI63RgeYYbSzJXM6scwocEaa0YgYfKh8BEJHLied1dlSQuC3H
zO6CO/IIIv9AIHL9eW53rYq7FdN4UfNsoEjbmoJEm5fqckp9xmBBrT4kguDE
QyulzTM7HKcMZCeGAA4MPAyIDWVE4KNxUXZ1AM/HJX1O7UMpmQQa8K/IWKn3
/cajgHxUM2oqngRpxzH07x/H4alDmfYQvjshsAQOhTcPwavJiKrAn3FQlSdu
hg6Jf4kQP7hp4KHHvzH7ztem3/7vk29+hfKnvxt77a+HG/6wsNQuVKxro25P
pb/ZoS4NIFESGf5P+jJReGVxZaSy9MZaap6aGG2Po3lKo6m56Rx9tiAQFoAi
+5M5cDioCj9WRI1ddGWZEdO7SlpbSYWbKByHrwAO/fet/Y3WgSbrykpcgk/R
Qbv0S9nZyej8VIQ5FzJZEI2AJaEQ+hXbUZEgw1wtLi4Ul5bQlhDIFaRLZFEe
Rbl0nwUbB14C9Q/WHSiDYLdSCVA1TKSPyv9YRf7HcD2BdzzOR3z3cNVK8zk7
eAcg4Kh5GyhAtZLvx2sVwaP5UweCP44L/r2v08ApvPNPU2/9AxV04E9/O/ra
fxt+5QuD55+ebD/OnG8TydZ0YZf3I8XdZJA66e8PZm+l8mZ3bleR5bDTC1Op
sc7EQHNy8GF6uCPHmM2pVZl4Bq1eMNiolxjQfwsy0mINfj6Gt84mNOErqxvF
NU5xDXUSL63z0OwyxgrqwDbWneltCHXedLPoIYsVpeCDx4IPFAinDc4CiBYE
XzkN3MFBUKF4EuVTkD6FrJAWX/f7VS2Hl/5HvfWn4YZgQN96zJr/68M1lQ1I
3GjEGWpk+nN8nQP1eXqlal1OfAeWN/34N2fJIGbSM7ig0ToHWb/11Qlc3GNg
dV794uArn+tveHGedp8vWVT5TM69YhQNQsCXPcHLPZGDMl5UnBYpWPxFhb7A
E+SX5iG6zgy3ZwYfZIba8kszeZUiKxMFiB7fxJLfNaDW8GgciBatULSxREhc
oipL1Gj6JcTuInlZrMB25CXeZpE1n5wb8Y/3hGcpUeCj7hDqDx2NpYKRtNFV
hPUMokSWAz/LI3JaYHkfQ0kQn4IX4H0RtvLKdO3KUn+spfkiWumPSPrJf/94
jQ96Sd7PLj1AAXWdfluD2nz/mg8ulxi3dvJ7i+9/Zx4VIMP6/mcaGHgQ+zv/
OEUG0ZOeqQr/jS+Pv/F3Y7DiX//SyGt/PfTK5wde/lx//Qt04bQsZHH8z1IY
nED5oCFFIhjNWNx5S7BYqb4NoZHcGlsJ4gi+pLTCLM7RipMjxbGewkhHkTFb
oI+FKQ+s21w/8uGJnNFVEO6WQRhE5iXAUUXhS4CC3l2CX6fGez6CmzA58xZH
Tq2MCUWpNU4W7aht57X2ktmVd3kzNndOby/CugdjgkfBeMxFrH103nYMnYN/
Gl4dNjZowe+DQCx43Mp/BiK5Yx/DAM/i/g8yfY98BIsLTuCmYPmJpnMEBCB8
iAFA+G8jsVPf/MoEGHkQPhmkT3oGl38FAlAEMD2vfnHog29RTn5j/P1/Hu16
f0XL0fxvLPS/sDABB4a3mYjGUw5PFsilxoFpfWVtEPW+V5qxXS0mUiAJg0xX
WCh5bZqCxqt23400nbECY6Y8NEqFPn88qzUXeELUExjPE8hXsED7/UcFYuxz
hzCxR4pqa0koQ7kZJkc+lMgAn9I5S8ib6isJIwpDSW/Oq41Fqa4s0uC0U0qE
wIDJ/mEoiQxA4LuBT1Tg2DdBhzzAfmT9xf3dqY9Y/b8YlYOT1JbzDkDl9A9Z
QP9RjwXczNcg6ddU5U6qQbdjIH7QA+J6Fa4vDpJBKUhHzjw1MdvAo9Vv6jia
mv8PC5GeBEwQIMVIKpHw+tIGM0oL2tGXySghsUYKslGXt3bLIANYl1+EiBg4
Cn22PNQaaT5jAr4MdrLrwtbisGaL49NZC3xxGU/kyA80qti8NJIevrdaM9xq
X6I47LYMiYxuNUZLTqrBqnuLxwAjpQUjLvh7IhlWY7AVSDWACGHqcamTarZk
ZamyRDR4QF8TlgsZIsIabe4zThKKy45UfYLwIIKr4WxVdqVIaMfs8/v15v8l
rcHrXdALiOogdEO2CYcBeYIvDMBFIqNbDYj/lc/3w4Ve9h8D+0R++bN9pJpT
3xlfaOGHjFbS0f9TDpKOASj5VDTkT1qsWbm6AHHwUVhbR+EjI5+6Nz0W675j
vvsmyH0ZkL/268WWD7dGWvRLs0Egpeubha5b6tPPzLZelq2w0vBgQw9sV3+3
9uDddfmasZiOoJzZaBbCAnATn8F1ZKd8VCjFqn5TRERSIFdRmbNvWYDRbyDL
soX//6s4nv9erf76T67nY9XvUDr8nZeUtc8vk6/+nHb0+i9opJoLz0ze+MUM
XKQa/Hbp2f2vyeh27OQ3xoiv299haNhqkNhRt8JEOha1OS0yl5zv5bGCjLno
CjN/hLkGixYl8fDQRapBt6+AKFdWEuPdttZLOzdeZP3pb0dOfIt27XnOg/Oq
kQ4Pg5Fjscvt1/UffH/hwXk1g4Eyyce63Tdf4nR8uKnmW3OJaCoe94ayBjdK
D0cSPALvItUsLxcW6On52RSpBr8R53doEwnfSaphrhYqX9fA7Sibt3cMPg/+
fzZ/71Nswd6n0SnEf81uH1gIPjcu5kfWqDrGwO7ywC5rULo6uENeG9wh1Sx2
iNpPMIcvb4AkhiSkmqFL7K6TrJUuEYnMhq+fnGngNb6ySGvgbgyLVauq/4OF
QLhmob5m4iaH9CR/Yle5qlvpkVEa5N3X1b31tpmJ+OxUnjw7DWsHjUuYLy+v
wNOhUsgvoj4BKkSWN4WJ2Qnrw/PCd/5pEnjU5V9zGz9UDz7wLq/kUFsOOtZ0
Skej5tFWJ2Elxns8rFmP2ZyFSBRuNXpTXqI6sBJP0GnZ8Z4YXJS+OAOXeW+D
g0TuqbOTaib6o8TZOIkMLgOeeLEwNRKm09KkmpVV4qM9gknlEA8+8BG4HYEv
cXCIMyESeb2S0oiOGvh7pL/5GD773Ga/puIjFa2OcN4Xy0QTyWgkmoiGU7FQ
OhbKxIMxr1fB1s+3b7PHdi1Scz4RgDt7VMro2tZs6tJBb8BkFy8op+t5kgVF
0GQDg1AFY/D8+rv/MHb3ucWJWj6jU9p7TnDjd+vXXhA8OK8dafePdsXHenLj
vRh1GFWVzNHQXiVzDU+0ViCuonShCeccfqjzhuzkU/NgusHFN5zQDLd5mas5
eEB8yksJFcCsVXwoV1gmfChIfuhhuOOmb7w3DksetSSrd9x+fbf5rGm4LUqn
oR3uhQXUzG28N9zXYBtp981Q0ihhcwX/beRVNiFoFrtSWUugAi/Ql+gdeGFG
5VCVQ6CEnw0i1SWAIH0Kbn8Frz+xgx8aoZHOAmdOoeQudJQL0T+QDaB/Ea9P
tq437lgLmTDqLJcOmSRmFUefDKBu5/+jFPYbHdvzSoAAiAq4Rlz4Fclf+/nc
u/9Ivfcyq/s099qvIARmQaRw543dzlp7910/kc4CwdJwW2q8Nz05kgaVEEjL
UkNZ5drTh8pKR4HDj/bf0575EQsiuluvyho/NPTd8y7M55AgyHMz8KTz9Apg
pC/tS324LYKaevTEl5YK87PpnjoHOIChRuPCVHiTj/G2MMYCIBPsqrU1nVK2
XTEONPsAhxU8UQ+kjlY1UQqL9PMoaAjpryASQ1vYzL0VXPjo8AGX+urjpA5q
8Fm4HVl/rNQPukS58U0uCOOJrs8QYGZzqMgal3085PHn0mhrDIIhoH75VDju
9++hqcER4B7AB31GB4gfDZLHwsSSB6mv9UsGL27e+i3j/W/PXvkF2m8AQgrC
u/b8duOH+uaztgcXnUSpYcdNdMA10pmYmShz+GWVvYwOPpx5riA6R3X33zNe
+hX3xh8kDcc1bVdt/U3BmYkceX4OtxL7K5SIouZnsyB0uNBMr8UCmI+56RiT
FeNwIkJBSGMpiiTp0TZPE2pDLb/+guDOG9L+Rh/8KvgthIWBO/w6+BK07+ji
ArFX/WlQLfgWSvB4VOaVTA9klUDqnwYpPwH//8QcHRe+rRtMZ0HYMVzYqVwS
yTuP5E0sdwg4ybDkySBx0jPEgGZiRvMeLm1Y7CBqYoGHzXY5U7vYLun8YPPy
zxgQcp15lnXhF5wrvxPe/KP0zhsqIJ317+pQc4WTpsYPzT23PaPt8ZlxbJOL
aewlY6AkkiYYc77RVsuDs6obL27f/pOs+Yyx67Z7pCM6QynMTpfm51Di4/JK
iblWIuRcwxOVwbZwt8rA2wRl0pfgoSHC2bWi6i5zoGT151gLvvYraHrtxV9y
Tz/LqntbOtjiA3mCANl4yiuxrBkMZHdIxyBGIH0apTMuVLKkPr6+963KE/vr
G9l6eIlLHCB4jNQPelAQs3n8eC+oKN4LKgGCz6bShOxzCTIInwzSJ9WA8Ivo
ipFw+f8A1jwhfFjqVcmbhYa5xq3Wd1bP/ZB+/BuzqNX0T/C1/cJ27WvyhuP6
/RHyCoCA3mPbnPfwVkJSYdbuRp2J7OGCWImtMJLjXf72a9b2i8q7b8oajmvb
rjr6m0JzM/np8fRAc3CoNTjaGZydTBI7xkptwWjOGUw5gzHH2SjM0TBYnPD0
/G1MJC7yBdm15VDXTTTS8epzwpEG5dhDLZ3qBZIIUQC4dCCJSOL4ORiY/GkK
mHTwNKTP0CZRF2LQgo+kHFbS1HDRI8l/lpD85t4hNvSJXXecRNsmWO6ViQHp
OJpSiC/6fdmDjQfxk6ryf5owOYTFxw4Ej0yLSWgYurhx6qmpt//75Ilv0U89
vXL+ZxvA22Gl172taTpthcV+HT+PnGrRWnbdEU8w6A6HA2jLEnTNG83JNUXW
anlqJDnZ56N2mnprDY0f6JrPWofbgsvL+QV6prfB3XTK0H3HcVjqgUAqEU/o
1SkGMJi+wsQghho3T2Iz44XJoczww2BPra3uHfV0r00uDSo1UakqrvWU1W40
eQwiWxAbEjkKg/cmBoHYUgbKpM9Sh1HlwQwVVS9XRhot7VsZfNkfWvOf+ojk
0fcQ53mM9P/2I9IHYwPLnrA3sPJBDMTiJzAAwRyGgTBCOA7fx/UALH4MVv+f
8XVvFBoHLmyce5r2zj9Nv/+d+dM/ZF74xea150R33lCixmP4uFRYfPXvSJfH
TAFnoNrU12WN2ixxrTa5sZah04psDsZeja8veeaGncNNdnCK1MHQOjfPXM0M
t7kfXjQR4icdln80ktQp00vTubEe1AIbHxgA8itODGYHH4S6b9sbPzTO9Lvl
8phKn9rVZtAJYRjT+coyMxp+CTZsYiA90oHyVUnk/qYU6XMjnUVgW4Dl5Aj8
OgxQmKc/svyrECBpP/l/Q2D1sSgcZBOh1mWJggfvXkb0ogvj7egOY0EiAxqk
Yx/HA2kF6XtVArSHI6HfMs49EHec5Fz+OQPvu7h68Ze8Gy/t1L2rbT5nb78R
ANcKr5tOqedGHRZrLJKpHJzKJLH1ueAiNQxcc3WjKFaWlfqCQhnlb4TWmJFl
RoyxFOPt5DcEmbmp8ER/mNIX3teCrwAKQOd1hrxSkVtlFKbGMDAZFVLOKa+w
CvO0KHsltDAGztVMG/TSJ4JCUQK1aUwULZGS1onxhYWJ/lTfvUD7dQe55byD
9Pm2az4gXsPtebwGoDCJypGRGSJy2olaoUf14BigcBT+X4Pz/dVqDECG2yda
Igc63q6qAwIiSACBK0UUb4Afx+EgkREgT39cPQjvDGsaw4EIWD2ydROjV9l7
UXTzOTZQG3C5YPvvnTQ+vOzurou2XfWCRWq7bF6a8WssGQd+RGqKlXnC9ERf
qPOWb3YysSVH5amWQNETy1mDeZ2vpHSXFc6y3FHeMaHEhfVNjLzGwc9FyJvC
MukpzhYaZsRYQv2O4JtEGblEvyfWYlp7wRXI6LSxRYoXTNpkj2dHHA3inZZd
iYLWlmcyEn33Qw8uOBqO60BPwWTe/8D04KKr60548GEWQEBVGFTkC4j5asvM
R1xAJfKqZN5xCc5DOlLVicfgUkMEaOzHnpoceGdieF5FTXB7RQCEK0sG1i86
ZSIDRKRn4xWd+bgJSxCdOnE1iQTtHsWGeaVf2XVGCD4CnrbhhAF/1AilO06b
SE30h2bGA2Ao5PqM0ZMjGrfwRanZkSBj3MddChpMqFst/Dn4QEY3GqaLOjfh
jRpM/pLJXVDrCiptQa4u4HYK3/l9ClwsooQb5dW1Mmo4hpf6g+sVyMobmzkJ
GmIS6atzd9zyQsTH5yUckYI1XFQaMxpLWq7LLtLi1F7vcJN5qE579feimy/v
Ird2xoZKILvyB+gs4HnkrAPlWMeBQTyIt8//D1kqDsJgHxOkKQBIDcD6ifnG
BCYunDeB0oD5OAwLCT95qiHQQUeANej2dFWLDjv5LB5GgNaA7QrZPVKmofP0
1rmfssFtPLjghMU33hVfmkmus7O8ncK2Orejyc1NBFYZIZMnB1ojlSW1yqhF
HXJoAhFvpJSPoWFUyYLeiU4MBXjloFi/p3OWQvFMKJTy+VIACpGfhRrn4OdM
EMvJ9aVdTQnCC3T2gRKivsYRludnM1PDscGmQE99aKQzNTuZZq2ndR5Mos7R
RlCGkNqMgOELIhJhULLp7r26C3EjXpuq66wNDbWmqUMIFaKAkFCYCiQEGkeA
7eLIICiOol2LKhBsFNwhJNY/uS6uOoCQUJAqGCQywEE6QgBCXDgqRxAqxEVo
Dul7VU+Dxxo4HMUokFnJkq79A5RcDIYLrNZ4Z2xxJsHbTEsUeZUTk9nKi/Ox
rtvOkYduPjcOpNUXy8aTqXwmVspG/pxDI5EAaPhYWmdpW1EmJligLnvmki+Y
LmRjHldyV5YHnljGMxtRctCTAinqHCNU7SmtaE6tyVuUatEmEeLwpK+x1rGp
sUzf/ehgS5Q6AGwBW+cg8gpMirEQ6rqh763VbawGQBqueCGYzAZD8VWqseFN
AVE00n7DP9CSoPTngdOCJ0GlUauV0igiyfso2oh4go1vKxJpxJWMcA7hRfA9
DPgBfDsDIQOAfmKnBgIdQlXAv5ABHlINDlAVoxowwmSAiYwU56kqXod5QALX
lDxedyKYkTe/sXryuwtXnxM9vOSeHo5zOSmFOmPwoMkEUn15Ywsb7YrRxhMS
eWlHWZKqS2pd3mzI2I0pnzsZjyOuCx9I48DEqCdrZbKIXFsikZ3ODOmYRhrj
MJO0yRxcs5M5xnIR3yU6Bo8vEGNKQwkujbWkMGF45vv3ZHqMgAidwTMw+iz4
6cLgw2R/U3JqMMlmJYWigtJUUjtQmr8jkN9a9Wyz3UT+pcFbMriKBnOG2m27
/gIa6l3RnLY0dbgIvBdIL1iySnXTflYwkXNKZAuTEWJHK4jtw0VgdaSKFVxH
0DbAEeBtj/M1j+K1b9pg5ZI9VcyS+5h9Ct2+hWxdla/hGyMp3JZtTqkaXlp8
5x+nwAq0XvbMjCS3t9M2H/hvNKdbJMXWN9CwGsZieZlRXlkps1jIG3DYRZGw
KFcVDLaCI4SGxmrdmNxcriJEqhHLShDMMjNzI7Ghh/Gh1sRQW4I6lAF4Kvun
8Mhg9zkQuJsKzhCa/r2rxfAdfrxC5juAzeRIYaQrN9SaHe0q0KcK2+KsxZWz
+lEpHJtbBgaXSCeJDEx4XJMPFdwIpYWBJvOlX7I++N7SnTdVwFxGu7LTlCJh
z+BvVlGpZmlzDiVzk3B8nqzq0up+dQUBTA3SHwCFDHr4if6mOmm1Cg1oE27u
kMUjHYPPexReILxI30Q2kDCDyRw+jQ7Bw6Jqb72wfPzrVOBiwMLG232ba0EX
xHzKBJ+XZC6laOOogLIa5wLDYazsbbKLwgNgCqZAyRYpGjwllaUk1WACcalm
cSFLepLSH+++G/wILqKdElHRgvo0PgqOSp3k8jI1S0u5Ggng+sNNToExk0XN
P2qDPfURam9kczWoVoctvoJYgWwcUOt4MmnTuPRKr0IeEPDDK8vRTRE23Gq/
+jt0oA56M9CSpA7l6LNFooj+cKkKkVt6cKgs3C+Y+FjVC4ELGd8kRrVL+EWq
ASX8RC9UwWdfdYBREhCRnkSIHHNXGpsTFwKRDO8lfRNeOOMoURCoDtHCmT5u
mO5SDt3ePvUD+uXfCNovKldmrM5onscJTfW5BpvcHTe9vfci0+PZSqWjaE+u
KNiMaZsx5XWnYvFkIJpRGDFroOCJ5W2+vNaUo3RaO2+ayIMtXtJfPbxkH2gO
HbZuAJPTkd5VFCudTrZlGKjpQSUZSG0Lz1shDCCJDPaPdGxzPTo74htuDcC1
vJKTKktklytNqjGqk4vDaIQc0Sn471tO7Y7el011GfjcsMKMGmVb3flUKuHQ
OCfvbY/USzuuyMZ7XBsCjDoYrH8XDRxCczeHsvTZwgqrhGYXS9Hfx+s30VHp
51GygHyPGFRLIMoRVuomDmNZ8VI4kkdWiCo0/KoBvf1En1XFklA3MhpuXEPA
iRA9gm4/IvrU7/dgrjQ8t8WxytSIKGb0I9Nu9KDCPzQ71pW2epJqRYDSrLjw
U+b9d7cY0zZ7JM/dCPXXm+ve0TSdsrRecY90RJisLAQtRmchGk2Ws5FyLrKX
C+eSMas1syXG1IYinuWSZk6a6v/EvfCLjZsvSxqOaztvOWYoCcQlSF8gEMWy
Eb83BbiiQEiGKfVFha5IIIv6ZShRa1QCWJx5/JI+nei/52o8ZRrtDDBXczJt
yeNNl3JRg9g5dlcOBOL0M8wT36affnr+0r+t3fzDVs8dw8pyTKLbs3tymVTc
pXVM3xed/sFc7av8sS7XOg+j9AVbzunhsw00+RfoxdWNMuoBokQZOPCnd/Rl
+FmU86RBpKiafAmfjSN6BE80bo190LV0Zb+ikERGSKKt/yNgqR7n1554LKbg
5yuoHqvoaaKqnUX0b6QfOipTd0rVDs3GCOr9q/GWVY4yuH6lBdO40GugaTp7
USpNDDYY6t/Z6Tkv4swZg/H0Ds830YzmDF9/UQJUvv2aaWrELZBhCzSfkGXX
ck1anjHmcEW9MZUsu8pCVTIGU87uze2II3231fdPKtqvWzpr7T13nbNTSaJO
G8BjLiU3FoP6baeA6Z+ZiPO2y4Cr2ZE32fOA7qYQ4bprRDPBQcQrzNTychb/
2Z/RqMmeOjdcw+2BFWZuV1Vyu9PhYDISTjIn7Y0fyuve2r7/1mbXB+y+C4LR
27K1WafBlhepSotTbhHTuty7e+2XjIbX108/y2q9rJ+hxNuv2xo/1A42mmdH
fTxBQaLCFBbUZ1dm2YO/rrSj3b1dM55+oqmkOQt2K7VO4BsRurx9Vd2HtnK6
CbAu48c4AOzy43T1yGFcyaindk1VXUlPIGS/79wfIlGdngQgGkJlYrwqkdaN
svvUqGZ1W1UGbsbfKYM8V5bSo53+ySE/a9YFQXIuE9VvuxdHQ23XfGiq7U/Z
d98QDj20rW9i4z2e5g8lA5e2lntkEYc74o1LuNm5qfI6qyTcBjYJzBP4MjMx
NRqdmUiQyOj2dwAm0kdpyeHIKLZDI802yn1dx3ULAabWXPAEs+5AFtScAFPl
LGt98LmS3be1XbeMDEYWL+dDG4A/YjBywHFVmgJcEG9rjIXJ4cDciEO0ZFSz
dcp1vUZgBSNi8xd2jKXxLsuDk8Jrv1ppfIvDphkmWjQ3X5J01TpbzhtpE34O
L7YlCGtMWYg5zP6S0Y8Bmdb5yjp/WeNBvZNRLpgBpRHh8TpSVDC8FRy5OI7s
Peb6Hs5lAMMjBIYAH0IQVTUAn/jPIonrYg1hY6tff7+qm9b92SCGCEoOV/tR
XjFRdIKKInfAu5dWN0rM1dLyMjqjIU4fYRFqzcVIJPnnQthtTnJWgKtn7r2v
P/evq1d/x+2+Y1tawvob3bde2b748zV6h8Jv8focCQE7PzFYpk0h01PpcbLG
KanV6bA/apG7ae168HaHYQQv7AtnDsNoi5WWpm333uLVv7k10e3kicr47/lR
tbjdZMmB//5zPgwmH+xuKpN0RQtye4k6YLn5Eqf2pY2lUZ3HH5fthCe7nE2n
TdTBwJY8pw+VrZGSO5avDmMlRoaZQS7BMhgspXNPhoMnUuNWVoqbWAK5zQP1
I2wqwMbAYUN4AT8DJIELPs62fiJyx9Dtu45EyXFYAQmkwij3W4nXP4qI+kcx
fIrS3ExyYiAy3hsZ7QxPj6dhUaF5DMYy0PNEOuV2pFz2lJBfmBjItF7S3z+p
qn9P1XrFNjeNdd1233lTefv13a4bOtl2eFear6HTCMr2SFchMDfLK8WJvhCH
7p7rMt3+k6Lnrr3vnrMKmVYd0mkjVcjAihn8WDiV5s7pN2lmsyWrNaEcMLyr
EHOVqBH+UYVl4hcYcI8LzQOMpdCOqSeRVzqLU8OW/nuqvgbV9KDJ5E5vieIz
44GZscDggwBrPQvxqtJYsgUL0TQ60icGG/nx6jYzXsIDACrsCL3t/ZQ9EBf8
ZULpiIQDdAC+r24AG6CGQCOj89n/pMYdRbevHuIzFSUD76cPo6boKi+q7AIN
A2cNbpq1XlqYz00MRHvqXA8vWXvrPbNTaRDJjq6s85ZdsYLGXBRtg+YKRUXS
p2enM9Sh2HhvbKQjNvggNjmKAZNtu+ZpvewYaQ8sL6ZIR2EtEl29AC1YmouL
xZH24MOLprtvqXobXHRairwwnyH9NQDG34yx56zseTufl0ANFOXoj6rtmD+S
KWQjmUQsFkvCa50FYQa/EiE2N5NBrL5IxNB4UTTp+xCA6GxF+KwuPGdZ7Slu
SeMCuHbifElcac9vq3NiTU6szrE30fCITUEZQh+jtxSIZws5dP6Tw4tfiYo9
WOS6QFnhwLOY9yGDtQHatravbcBgkJ4tow0YpGL4KToEUmjrEoIvUg3c/h+R
qyT/EhoXQn3O0SR5K7IBsH6Ya6X5udzUWHrwQQgCgsE7xoEmz/xcGhi1zFw2
hTBLBJMZMa4QnWBvlUmfXl3DFuhlULaZCYw6gi3OYYsz+ZmhxFR/ZHUlg5Ls
iM56a4+cOZD+amunDJjNTqYmBmLt1+1331Q+vGSe6A+vcfZ7zyzQU1P9zrH7
ivEm0BD30mIGhIVOy/WY05MFGCOuoNcRsdviMll6bT3P5mOAIpnSH0O5WZnV
DazaWe9p+kxifT2+LY2J5TGRLL5ryuGDo/ARNmEwgiVwYsBK5FbUgwTM3Cqq
QEUDX4BRp1OJpM+HFdD2aRDfmwF7DfoH1nPHVMlHB5cCaxs0jxgAzNyHkdC5
Kn4L9L2j8/S/OMZACOL28qmPoId3CNjT+lFuE2IrRrSa1rmlxYXc1Gh6pDPe
Wesbb3burjmXpwNLS2mQGtAuVzRPTMtWmEoKY0ljKsoUBfpMkTpcHO8r0icL
u7sFhSK/u5ORbieMtrxcW8STJPfxQw3BYTmSUeLBl9Y3UOte+oS/q9b64ILx
1is70722xekAASH8yOJ8arTT3XZZc+9tPsQ07dd0491eAkSUx0oGq0l6QiWN
8xZ86/TA1FBkhZkVqTAIVUjkgeYAqWZyJFHBEP8ET8q1Je5GtO2KbqhRO9Ss
HW030cY9SkuWDAIhfUNlLywtxIDU4hsqsLb2Jodzs1NZiBEBVYh21dIgd8Yc
8QRAJ2NEZUG0YAxgIMIDZiBB2o+0EbeeFQyX0GMTAAJ4JJRBc5Q++xfk/KM8
0Zr9fMXDdQCP84l/OBwrEhjrA2W1Bxl54gNubpeAn9Mm02Pd8d6G8FRXQLUV
KCWDbmdCqsyLNWWTqxBKoI1RolIIPH8gkXV5M1vc7ER/jjaWk2xnwfAF45lQ
PB1Jpl2BbBVmEHEVYhDezMTe0jyaUO2PZbksT9dV1bXnhRNtRpksorfltncL
APLiAo7wFU3ta1tnnl0+96/MO38SVXEGQ0wGJkP6NIuZo/ZFum66KH2hTVFW
6cKWlxO9Dd6u2x4CYgLff0EzAv15lTwE+n7+p2tXfrt56+VtcOf0CbfGltE5
88ylaM9dd9+90Hhvdmp0b7Qr23c/NtweXV5BYTFnMznaan/woWJ9yup3hVLZ
ZBjPdTf7imon9gjE+Jxu5B2r+O6Di5KjyIDtsTnaf5iX+tHZHh/J860GlTWA
7lEUebxY3RCoek9DuEyUfcqsSIt5kjJzrTg3k6X0JXvqw/ThkEGGssOCoZTa
VAR3AdG6wZKHqE5rQ/v48KtAo+3+HJdXmKEWRjrzK/M5jTar12dMpkwik3JH
0BkcRKVCRWX/o4rwaHeqpy44OxwQbXpH7qmv/E7QcU073GIVSxJKU4locMmX
lhfno2OdtrYrsqu/W0cZwdcU4932pcUYSkvH7fRnUAblUn6sK0rtDfTdDwEa
IiU2M57oqfO1X3P1NwZnJzOgMznSMwxGiTGfFPJjzGnnvXdQhlPLWWnHdc1g
s5UvjJuCmMqKra1m+htDgw+T1OEydRhbWirBggdbIlKXpKY9JivVd9/R8K6K
MWp3mFBHpUAy64wUjP4SCJGoKQdbTAyjrFhhBq6+8whbQBaeHLBFaYdPzE7/
hxh/dJpHzf8F4/19A/ivgMIS0lPVKPNAm6vO1oK2qcBILcwXJwbS3XWhuaGg
VhrZK0Z9wYwKBxoV4fMwvhBTGEoANCJ9sbLWXeKKMeYqRpssAtbM+Rx7Oeuw
JHO5uDeeM/gwWEV4pQYKmD+LBt0y9qhDqaZTutrXduveVvXfUl7+DW+oxchk
hmapoVVWGmAmUPwUuAiJobzGjo51mW69zIdQltpvXePEYFWiug/0np8DzKyV
tGgb7QlPDGbgg8A6nRoMj3f4Om96BlrCoIzU4dzMRGmkIzrywNN2EaVz1b4q
67lrZCz6NvgJCBqBuAt3yxvcMnUwOzlapvSXxnsLq2xYoRjEoiAe0OXlldRg
i6fxpHZlwmU3hYH7+lJ5a7SkCyDhHRhqHOOqChMAA7RkQJZ0BEIy2iR+UfeO
wP/w73wkXvk44h+d/kCu2HUc+kO7RKSjB5u5xH4uGQ1g+151G7c6qBKpOV5a
rMYZMvAsVBbIwCYGQQFx6Hcj6Xj4MPTwSExmYUees/qzJn9e6y3Cj++aERKr
69jcVHGsO89Zzrgs8WIuBmRT70fN+Pk7EGEzy6TPMFfLy4xib531xgvc8//K
vPRv7Ku/43Xf1rI5EeAMOwZE9Gr2Ud9FtYyFySHn3bfE905IZyieXSt2CPUv
CHbKKkvJGS0ojcWNTQzlvC/mVpfjDFp4ojvYfds30BgZ785MDhYHmyLtV+zk
xg/NpG83njKPdvo2BBmFE9vWYBxhaWW1RJ8tTY6WZsYhcM1P9GXX2AWFHdME
UIGvWLvHWEoB2Ww6ZVymuKzGSDyT9iYLplhZ5UaaXTXcwJFR9iOh0Lgqo34W
k3vkGSr8N7FHRgl6NdMTyIfBRULf/0sqNx6H/KF3APY47kcqhyw46EfRHv5T
+3v4lZHcFdMeQWnnKk/lswPpnZvBRjpSK7SURpZgU1Q2W0JlLIK1WsdPJKZG
IgP3LfOjJtqoZW7KwxMmHdGi3l7cleW57NzKSmmBXpJKc25/VmUvA+mDKErv
KpHIO4oS6dMcTp4+mZLLskvDxukHclqndvihqavWtDAXQXBvV3gwwluoKK1t
pGapgfsnFS3n1PO00BonLVRigDf+np8TePO3y+wNTLabF0pKkt2MQJBYpscm
+uNrtND2elTKT/HmvYtD7pEmX8etQGdtkEZNc0Tltc38LNVD6fUAkJ23PBvr
uV1xTrqV3uEnHd4MfF6JHi040AEgD913bDdeFM6OenX6ONAxUBWNF61yIT7T
CQRWyXOdRxZ7FtdmgBIgBYCnxveOTY3BY8GL6XH0Hbj+i5UkB9y7eormwtGt
AXSP7J+d/di9X7tKGHUigtIE/oyeR1Xp0DE1ijFmsgO39Xf/wKK268W7WcAX
fBLQj5WVyIPzitsvb9a9JXp4STfe6d7ZjoaSWbsro7UU0I67HO2C7+rLsGDQ
3Dp72RYq2gN5pSZDn4gMPwBHHfX7E1adX6mKCHaTa5zU4nwSlXoRE5k2+CX4
mjoY7G90PDivx5PinZPDoaXF1IYAIyYy8SVlvggzmrKhYMrlzxo9RY05u7Wd
YzAKYkHaawnHfWGHNijnR9nziZmh9FBbjjZVnh4vID9113H/pAw8CW3AoTOm
Pb5MNJhIhGM+X3pbUgR2QTzq7FTk/vvS008vDTeq5JokyEsPjgmXEaxDAtUl
AtUZhCcBJmA5Obo3ObJ3hDq8R6aOwEPBF+hbo+jf4B2kv6AO5QDbw6czHvw8
lIROq8m+ZJ50lMgy8OFTTtEZKY7vPxHgQmyHjmjCZY0PbY7BWlznoCE2lP58
81nj+Z+td98xrbLzoEhgscBura5H2i4rrr+4efpZ1rXntx+e1a5QbVZzyB/P
WoJFMF2wPPBOzqia8nNoIKIaNZzT6mNCXpDS7uq8Zl2nuR3mYCiatgUKyNZp
0a4AMVmNuVqiUZMjHcGuWkfjh/prz4nq35W3XTEMNDsmh4P4e34q3MEstmw0
lvKE0R6tPVKUG7FN4Z5am49HE4VMLOhO6JVpISe/NFuaGSuP9WIjnYWBlnTL
ecetV3YffrizTrN5gygZDCtGU7G4054W8Itok2wLYg6MzU333FXf/MMafcxo
DRcMblQwDM/P2UKh7tJicWEem6MBJ8GmxjDqcIk6hJJDKQMYpR8b70Mv8Lzd
GspgeQKuIWAcgPE+vlVVPBwNHzuM40G+Aenowfk1kXFwBGWJoBdPE5O+QW8d
8aI9VgQMdYGy3Fzekpbhg4JDpQ7lH1wwLczn0XROHTJ3YIXAPg42W0Y7LDf/
iLLt774upHWp9MaoM4Jmochte/jI+8rODHANDhfjrCVp/ZaZXtPAXX3zB+rF
QaNEFNMa81pTgUCOmHwI3ITBKE6NJgcfBFrOW66/KPng+0uXf82++8bWSJvj
iX3kdKa8zIBp7SW9u6RzI5pucuS94awvkrWYs1JJfo1ZWpgtrzMK85NAlLDh
tlzrFfe99w0913XcOXMoHEN9/wIJrToLAbVkt4jPacCAhPOlRcFuembUbAoV
1XZMosKI2QSge3PTBfhgU2O5yZEipb8w1pMf6cyMdGZHu+BFfqQDrtxIV36s
p1gz1lsiHRvvRSOsAEQCP2Dmj9nBOHq4UgOfRYufbxOI+atZcKncEyib51tB
fNgw6r2QzPkSeVccaZ4hgHeeNCJTAutvaizP3kCjVDXW0o4GAy/K5hW424Ut
eWGsy3rjD9yrv16daNcq9AlzqARBHvGDwHsJGgj+gjqQ7rxhu/2ahESufWWb
dOzOa+KBezbGQpojQIUYgNaT+2gBuvNzRSCurVecQFlPPb3y+t+MXHuODWjh
7/khvFkkRyMjIZySmcoQjShtZY0bnYJI1Kj8hsUq8zeLu6IsdzUPaI12F3vv
xVqveEaanGK2LxENBwMp+W6eyUTsVyApc4QQCWdnJuKstfSOvqgLYrDgtmR7
bC6KTOdnkd0d740PPQwMtcaG2zKDrdmBlmRfY7S/MdbfnCSDCpM+M9CSQo0q
8GbRoNYjXYXRLkC0NN5XrmL2iZMciPSrj+XH4TlXR4gUHiLZF+WRHiFSFvFv
oSQ6PAPoW8ANIcpW6lFCCJ9XFGyV1MaC2VNQmUpSLSbW7EmNewrH3tykq/m0
uPGkeKhZJ1YkQXTg7JVWTO8o7soLW/yCYLOwwS5xNkqLlMBIvWbojmr4jqrn
kuzeCfVIewA1lptMMRh50mHM6DSQUbLjpvfOm6qzP147++OVQ5j9BmmDcE8o
K4tVKBlu14AZXUWLv2gNFFX64o60IJUW1Mqc1ZBS7WQOwzbdF1FJk3ZLymZM
Cji52SlscRFbYZYWF7IzlDgY5LmpKFcEyyixxo7N02LUodhIZwxwGmqL9zb4
Om46Om95iZbPXXdCnbf8nbWBSv/9BnhDDLX5bqq0+QYnO9yeG+kA5EpjvWUC
uU/M+TlIaEwe6FU144roLVNzkCVfg7Lkj1ZTflPZJHBrEt4H6NvwKpzIOF0Z
my1jtWVN1hwYIFcoZ/EW0KAvF6ZylSFoWGF4luY9CzTv3JSXt50Cp6ayYSZ3
wR3MBiNp8BgWS1aOJ8CZzDmZwLPLc6kFjl2mZfCWtuWsqafeDQhOjycAvqp9
XFwsTlMyY92J7rvB+vd09e+pHpzXdd02Vewjnh/1DTYPORqwwdtyTGMq2j25
UCwdjqc9nrTXk/J5Un5PKhaMuyxJlTTDW8vPT5XAbi1O57hr+U1WbmM5y17K
TAwWpsYK1KHMWE8cVQ3edo93+0c73Hi3eWtvneXhJQuJ3HLOQvpyy3nrg4uo
4SoavXrG1nLOgbcLduzX3PnQwKHb+MChenyWQlNy4EEadS5pBRRB/4pjPeD2
Hofflw5XDVYV7iPgHS5vOFxnhQoa8PqSHxTy8WQskkpEUwn8Ho8m49FUOpFM
JeOpVDSZDiUy1Q5ciNHgewcqZ0FuLeyagGkWROoiGDBQO7s3Fwink8kE/EUI
Iy3hkjVc9MWyiXQKfnMxhZKCt+btnZcN4MIAw7Hu0OxkkrlaJNjJ8nJhdipD
6U8MtERgiXffDQ23gSak6LQcBHvH9jH8ZjVrlAv8Vlk0mHMebyaeSOZz8Xwu
VsjFIIot5aNYPpqIxB3mlFyS5bAKc1RsehSbAkIxWJzoK1B68v3NaZB4150I
6puF+jWZm8+aAar699R1byvvvimve1NGrntDRvoyvKh/G7U3QyPI31DefUtd
96624bgBfqTptLXlnB1ABTiJ2QoHczGaUgMtYGYByDyaudODPQbFrx6uuH1E
BT+WmXqAXz4R8ASdJg+2X5CYS4TYE2oe3cxfMJPI/AUL6Vvb6x6VNKHVZDXq
nFKVV2kydkccfh7WAtFt0Bgpz1LM453akVbtYLOWL4pvK5EXk+wUwYbZ7Rl/
OKOWp0U7xe2dgkqOZrJurbqEi2bOhP7Bh4r2a9ahB/4qhMTs3s+INWX6THK0
M9x7z9921Q2S7WmIDrWlqMM5Oq0E8b5SW9xHEu/D+s8QcYjVZY216PDnXR4w
nFGnO+PyZNyeDCglUM5gMGUyZyU7hdXV8nhvmj4a39nKSngZ8Waaw8gMPszW
v6sDa33rFdnV50S9d6xTQ4HpUT91wD3R55rqs88PgC4yhkykLzOGzfRec9cV
zaVf8S//VnD198JrL4jhx1Bp5nu6eycM+AqwAZbVJuywOMDAEkBWNLKz9IkV
vB9XxKoWEqUSRCY+qF7IG5CyjcJFrd/i/F9YuJQKcKnKuj+uNr3Naz0lbju9
03NVPXzPNt0XZNCyrKXS6nJ+cy2+Kwr5XBGiTaE/mdOH92hj5uvPr5z/yUJv
7Y5UHlWYSmvs8tI8xuWUVOaSyV/cEhYWpgtLM4XNzaJUjS1N+bqvKO6/LW4+
o6MORsgor3L/rHL/hOtzgKPWg62vJ/vvex6ctz+8hNoO9jcmRjqywMmXFzGV
Ku8NZBQEmjV4Njeyqhp0MqS2FtjMBG0wzGaBX5AqS6Qf6U15ANTqyKqNRfys
Lg1Wc7TRrhAEI764y5zYZOaG2vINJwynf8gCatt4XDwz4FpjRrd2M0JFRqJM
qtQxoy5s0wdcRp9V7dtacc50mVveF596hnnm2dULP+dc+e3W9RfFt16V3XlD
WfeO9t77RqSb5x0PL7uRnSVmqBJg7pvX/wjJqjIS9vQjmpjFy+LDvoBswzjf
IZm+L5QyVCGjzaVyTNaJT3534cyPVi/9ilf72s79DzRtV+39TeGJodwSHaP2
p2ZHQmuzXo3YH/cFXTqHSuHni6Ndt6TvfX3i/W9OtZ4V8bnB7Z3c4myBMYtG
/fB39nYM5eUVDLhYT12Y0hdZoMd67hqvPc+/946k5651cT6Nc5QviGSY2lay
RUtbwjilw91xzQ5Pj0ZAPUiP9RTmpsub7CJ4V7DtJnsewhn8p36JsNOikwOp
vshYSFK6I8uLma1dVKQB+BnMeeA3IgU6j15hpgZbnFNdNr08EPH4UtGYQpyh
U7I913S1z61c/dXyQK1sg+GXKpI6b1FmLRmDmDOcD0Qz0Xgqk0mAfzGpAtwl
5/g9Rd2rG+9/Z54oSL/4b9wrv9u68dIOPmxCAwuh8UPQRrTy0DSdygTcA/Qe
Ny/lALsDFcRT/AkVjOPFMFXgQP8AuIVOSfv7a81/Wp6p5y20SlhDmsVew8Vf
cq+/IAaj0HbVMdjsmugP02kodtiRFScHYn313sl2B3/RFfaGDdvmiTv8zuuS
49+gNr3GmLq/fesl4XiHa2ooPjuS1MozrMUinQbMEkgYxlzDxrt9N/8oaTq1
A8yy56xgc8o43uGsYrctw4yOgjeR39mOCFb9G/P+gfvB3nsJCNNmKMUtMQYf
ANxdOJmBmP8wdhLdntFfAoersea3BEmtrQiBBYQXXIBPhdo1odEY3ozagW0I
UuKdmMUanm/bNgiN6VhMLYmzRxX3X1+/9cL6XJ9avhu2BnK7mszifHxLXlSY
Mb21YHPlgoksSC8ei+nkARZFtz6uotwWnvjW7MmnFk8/w0QFwL/duvEHCXhI
3J7q7wN85+xI+a5/FL7/EDv/oRpNBNxBfT4Ql3jQE9hlI40D4C48O/P+1yln
fjB38acrN57n1r8phfUDeg+Ge7QLeHaetY4EpbEU3ZE8dz0ycM/Zdc28ueDx
eyIakbX/Eue9r1EAffGS2mvxb8x5um44J9oDMn44k4gZNWnWQhFC1NUNtJHI
Wg00fYi6sLS+zZItqzPhgEmX4HDzh7ELpzLBSDISTfg8cSEnSenJTA3neYKC
yVd0hAueaM6fyB7GTrBTVuO74QA6amgXz1v9BZ2jKDdg2wo0cFyuLfr8aSA1
oSSapLCrTw43ys78y3T/2XW9wJCNBQWz2pZ3+Xdf4y2NGR3ehFqbXKAGO2vd
UyOxdW4RfokaDYcugTpEM2kI8GOhcDoSsO5axmsFx78xc+Lb86dw+C7/RnD9
RQmEqnffVDcc14P2teDwtR+GD1Xtfhy73z6KXdVgPqp0uNMDx+XSO4V01VQ9
v/7Fhbe+OgEW4MyzrMu/5oPlvnfS2FXrGulI0qgYqIxgd29mPLg07eavOYca
dHf+JO+86ZjsCSh3kxt0593XBLdeZte9weUzbHZrkkmHoDY6PRCWiSLZbNxo
yK4zSxusomQbVWiIBe6By9wT36Tdf48rYlmi0SQ4IrEC2+RjePUX6W/QnPTt
MmMZXZzNklKV0xtzwjWbeN0qWLKMNduA1wHr3xQUDT5Um+CK5nWmvEJT4PDK
+AlZzXivt5JNiucK/2qDV2YyM8sLsS1+eFsYFovCngQ6QncG8yZnAf4+i5Wk
Dvo48w4l18xbd20K41Lz3uyE9+ZLvMkWtdsW9zqSdnN4utsw8sAgV8WtHlQI
KROFF0e9Qm5CIgOfjbJKtW7MGix6w+hfwbaBjD1G10yzpPODjRPfooEjOv0s
i3CQVftKeEcUhVz1dtxAsSQxDOwx6H5QRZdwh4dZTSJL9IdJAhtBJbl4NZvf
YBfOyO6/svzu16ZPPb0CxhT+LBhT+GsDzcGpsRRIGAyT3FJeWQKNkrafE136
5Wb7FS2lxzfWFVumZ0dbfYMt9plxO3XQThvziHfzC3SUfcFkpKWSBLgurQHV
QBuMOaD3kXDSKLZQ60Rnnl1pOStdnHVDUC43Yk531qDPrq5iqJMFA+2ESA3l
lRVserzEmCusLRfWmcXJTnvHGX7LcT6Yre66yDSluAYU1VHWe7Ht3dL6amlj
vcRcwcABDzR7a1/ht1+3kGeoZdKvGQuYXF2UiBOjbe7hZuvYQ4uAF3FEUClc
JJX2hrJScWSix95xXdPw3k7fJWF3rXppMY7Gn/D3Blu8Ql5uazMvYAMtz+/I
UzxhUmUqyOQphwNJEhVZOtIbq7n5ueKmqCw17mntJUcQddsF8gFvcOg9OyyD
Yk03cXvr5HfmgC8B1QA5X3t+G4KUO2+oQNpgfwnygxS4tjJA/nHa++zj8a1y
nX1/SRS+/89S+H/kg+J5dfMbqye+RT/74zVg3WDxgTjDXxnrTs7PFmDhS7Vl
UxDjcv1d13ZAwxveEY61W5YXoov0zPwsBurBl+JJtCZUgQjPuM4tg8Lztopa
Uy6UrOw5XIHlBX/4z6WIS+Oit6uu/IbXdUu3woxKjSWrOxOPRn3O2DY/MzeD
bQrKCgtKJeZtlWbGiRGnaPcDyPylX/NBQHfeUEAkQqOW2PDhLOgIbXEBdYGg
DqMDgZG26N03d45/ffLa73mdNz3UoTKPW7S6cnpDbH7Uce+4euC+lbMRNQdK
YMJj6bTNFGBNm9ov7da+yjv/U9aZZ5dbzqqmx+LVIybaJDp9gN/PWEZn6CIl
xhdmOasJxU7MD5YjFdFI4wuU1HhvdmmpwJdiCkvZ7C8CAKBXYC/hqSGw+99Y
2Cg0DV8VnPzuPNFkA8IWZKRfkyMVPmlsPmOrqDAxLr4h9pfhGz6Eb7UymKjY
/v87++7ntrMjTxxHs3uxtu6Hq1vvVp3Xd7Ozey7HHa/XHq+T7PHaI8+MNKOR
ZpRzokRRosScKUYABEmQIACSIJgQCIDIOeecc8YXgePa/Ru26vp9QVLBsj11
VSwJoEgIeJ/X3Z9+r/vT++V4wOiVrZj6TvPOfX3t2g95YLxPP7cN3g1NdGWp
JAywazYDeOKYWBiaaFXA+xq9p1pb8u/JCkJpDXBEI+ol6KpCZt7f3C5QJiK0
udzCTG51KSMVJDP5XPO06Bb4DqRfGUnY1RE20dX2WxVQSyY9vbwQo80GuXQX
i+R+9jgklVQ0yrLLWw7ES2p5cWkyC6k7GmQ7UoMY1fpr5f0TqvZT+vGn6WVq
g3s4lw3eKCCLFEJo+9vb9U1mYuqBjEHyC/mYiF/Z4uBjy425+cng7GiANBzY
2kqbg3UwM7M5IVi1zQGVe2/r/DcYV7/LWOxUTHToNzYyqLFAui+R11irDXjl
BRI6yAeXwd6sAImjU9K77KROEtcIIkpuYGEkMtEZX5pNcUU1hXUfNqcvWwUA
0odeGmzJsueYbZM8/YB7/pusA1mm4xKwYTwIWzsvOMGG+2+iPLrpol+DL+NV
fF/IVY5CL4brJdRKCa/BJ2aal7qVfWcEEPgh6j/4QNt9yTX2CAgTRl9CV2rA
F00uIExlpThE6bPe+5WC2GMXCmMmX1VuaDRb2RDptO7v8IsTnc4nZ7X9t5xj
j8KUgaBKFEeErZxtyinFwimTKiZYC9HHfU8/t4y2+4buOftvWLovGbrOQaam
XiX7vP5CJIJaRLLprEqYnO1DhAOY4sxgBc/CYWvHRx8lJroySKLlhbbBZnPx
+sa+QFzXW6taddTpK/v9xWCgYHZhCtu+WFMSyIu70iJfXOSKinpvQ6rMrFFd
U+2KJx9ufv72/Pm355e79nwGr14d2VOkdd59i7+GJoiqqmvMxtLcPoNWX6JU
5qcL5NHsdG9y8VlsYShM6fOTuzwzjx0Dd9yUiQRQTNRs7d93peuQNMLiw2cH
g/qimnQo3buLpvkOZdfHQlwQit8UhGr7UPf4tLl53tB3w4+7aPiMqdf55z+N
b1NxAYKvU+0SLBnmO2Rdp7gXv7XW1KZ7eFLfc8377EmaMtFgMtDRmUzfsPiq
4UxZq4pTR1zACGaHPWJ52ujFxKrK5ja2sVXlCKvbvDxtLtp1UdvcJF0XncS+
sFyQyOWzuWIeSQjl80F/SieLcZnhxRE/pLhAK8AzgX+CTAA+6d3jQtqw2WaK
eu2RkDNUKaXtuhhzJkjqjSyMZ2bHcMWRZ1XKZG1uug7+EnIk/EGDSgbzAnpQ
53JR1ZLGiCT4PSFUZom8VjGPJhfGUAGUPriv9aNCGLV7X22vi6Up5qxj4r7s
0W/WP3uLcvuHq9vT2lQ44fbmNA7Mma4HskjXzuKs8HnoGIO5XKPNlRdmCrNj
mameJHkgTuwJTz0NTLR7xu47eq+5SCOJdTaqo9G49u3phj9bjR1GYfDQLrVb
SDNSnyp6TguufG+z6aFRFgQk6xPT08/tXZfw86TD84c/jm/o9+LvS/ZbTRmF
NuId/qNfsc6+tXj27efBtxfHl/wMiAoyT5nhAF+NIjbXb4P9RupzcDkpuQ7b
YGWoxMzCTGZuIjrWbp7odHRf0gExfPiRbqQtMj+d2d7JgeEH0hWHH7M5y/lC
LuxPGuSxHXp4ui/Ud9MNmTk4J0TWz+raPpDf+fnu0hDkzAbJdsDrLwIlNGsT
0t20iFuan6rOT9eo5NoipU6bR86SMlknjVYR4hPVNRomESIZG6u9HIiWAuE8
fyuls5aQ1EUWMyfAvdRlpvoRuGJ9TSApe0Ilqz4iZJioHaL7723c/DGn77x6
jx1jrWRFKswYqCOA8mWLo6LRYjpdRaauiWRVvqC0uZGHT70BOS0vJdyK89fD
k4+cvdecpOEEax2VzQC+jnTDh/868A5Yc1hwA99KbhU+eX/r3NfROcWV73MO
0iQ8Ah/iiwZ0f2l8DzLbpuxc9iX/jPB9dnH7468QT/7VHCRmL+I79jgFjAbp
MOw2mviG0mW1Igb+GVjfWJt9bTnNE1RplMx4R7jvpqftQ+XVf9q6+WPe3ff2
4EV6rjqJw/kVZm1XVjOGGhoXuskW7tWcrlKpmA16U1JhkkZJTHUHe6+j8RG9
VyETc/bdMN1/X3L7p7zB6zrGfEymqbl8ZdQkEyhIRJWlWaSQubzYACdMo6Ki
irmpOnm0Cn6bPlsW7ZQs+qLPU0ik8pFoVrSdmO6KMGkZuRmzJvcV9jpPjHGF
mFhXB3Al+to2r8RmZY36TC6TDtn93CXz8G1Fz2Vt92Xb+OMIlZSFbFZpRtM4
YAHDyVIsXUim88Fk2RmrguMSyctrqwWhIG9z5MOxnGg7coTvGquKdBdcDQdu
v/DrzTwJAqKebxu7xP30q2jcKS4exwG2ePc92YMTL+CLD2Afav1S+L6gLtXM
jw74c5NfAb5jF7e7f7v60V/OnnmLDhEBnCSYXvcVD7w4cRijL8I6oGt7g6fu
S2FyeYLYaye363quOBam06zVKmk4S+yLjXfEIT+/i06vVY9PG0Zu6oZaPQsz
pc0dVIVgjjaECnTYxF6rapQQDfPJTMFoyW9u5RdJ8cmuwLOOwGRXcHYsMt3r
7blieHxa/eQzPWU8wRM2DKaKx1dMZApg+1xOncNFGfLmNqCMmNT8dJ38rLpM
KvPW8kZlLurP5jOZQj7r9xcEO7mp7iSDVsSHatR3pRiLVVpdKW3zMa4I2+GX
GEvZJWJCxov7bIlEPKtXxRanXKRhPzjY6b4keSwLblasapicVemuHx2IpMuR
dAlSKoO3onOUNI4qT1RRG8tAwLO5rEyUJvUGhhBVzwPhFMr3ta6Gs+mfAd9D
+9XzrWOXOCe/Qvn0fy+f/8Y64Huzie//l/0enQgfheDMYf7bzI8MQpt8Va9a
0w5+un36azTg7Dfwcw3gccNtcbAL2kKVvYkqDyD5dSZqe9KUjB+y7LlZpBAa
00GuLs4URPwsh50jjxQH7oTG2mNb1IBs28cgR5YXUEcm5LCORH1PWaUvYbTZ
soBT1BkrVi/mCGF7aoy9kWOxcqvMHIMGf+Zp80nKeIQ0FJnqjUz3Jza3GuK9
6p6oqtWj6dZGR9XorOocNSB17A3EduaJ9RUqJtwqGeS5oCON5ZLVUioazFmN
RYkITY6GDba+UVtdxRjLJSopD4sP6fzCTHZuMkUei093hzcWIoKtpEqRszjL
vF3Ih0prqyX4YTRako7t7tVXF4L95/n0GYsliFqblFaMPhdcIvkV5rLMXLeF
a8lcASumdPIMdSI10QUZW2Wb1xBrmvgehO+j+Av++dllLnjLM28tg3+++n38
GOtXr/hn/+EJ8p/gV0e6ZEchOPMCxariEny/qyFlVfmqse80F9LKZn705Kx1
8G5kqq+0QKqurqLmB4UZ9fTBq8Hv/ls97rXlOGxskVwXCTFIK832MmcLaE9D
yMWC3nw+l7U7SruiOn8PTWJxJWsSJUZfKM8MlRm0KncP9bKDWaHSWvvB0Jrm
oAMB3qGHKhc299fWGqvMxiqjsQIcgFPXW1A26cPrYCDz2FOgqjPmYm13u6yX
FwL2TCGe+LdaPBdPe+05jazE3awuLzRmx8vE4eJUX268M9McL43mOaIRaGh4
6sDtwGR3dGE6tbpS4AixZtfZUe00JH2wDdpPyk5+Zfb+r3eWyF5w7Mzl+MAt
c+81I2MpqvE07IFKKpmpZmN6cWJxPE0cyjNoFa6oITPtGwKN5/wZz4D3gfAI
bONXeKf+eh7JTH6bfciv8EMsnF9BBgz8GeH7JfjzkbLZ0eHy7x9xAGn/13oC
8t/uU5wDFw3sCFFoH5JkGcVoC2jUMERPMGF7vA7eAPaG0VTZ2kI9a7NjsJL5
DWZhZrC8wmwAfXW4yvF0UWetKg01gbiBILbWNzaqC0RsfhpDRIjVgHwK8mUw
B1Vzkh3e+QxRQGmua6xIWEimqgGmq7SaXl3SqUpOB4osAC78ismPyodg/Rk0
4M+VubEMeyEp3Yx6DRHIL7FKOhLOW8xlsbi6wa4Pt3qffm6GkAFBByIICmrN
ecatSK2w7UMNeTRFX8xv7mBCFWwtjCeuH9TObgC46cmu0MBtx8XvsHsuqVcY
adiBQL9Za7FVekTnr6Nkf6ewu5VQcYKU/shkd5pKLq2zKyI1atG3xRG5gvgI
aw4OE5b6d7WkWeSYvCH45KuLzduy6+/uQsLS+hslfoSFaiaaVwhH6e8fx/cF
acGDM+g/ZMJihuHpiQ34f8GEr/6ABwwZTLj/VhByzLmpGlgKZ7ch0e3r3GiC
MryO1lrbFTfAtCkTxeleVG6zNI+0vmW6usld9SUqzjDmjlQM9uruXoMnaqys
1FeYdcYy2hLU2cbqyr5CW4XIZQ1UFRZ8JpJhX2Fp6F114DOuCKazADOvLVOq
OnkhG0dUEPiDI1UHowCHv6dGJYOMZeDPlfGnyYlHQRYx6NJH9/GOUAjA7kBZ
a8SAzhF7PLd+yjv/TRZkmrCGPVc8gCwYMqzhnV9KL7+zMXTXxmJhSGOFg62u
5Fms8sZWHTLoualMzxVL+0lUHHXvX2SQpFMmUgA6LIIlvm8M1WFngqWvMAoz
/ZGZJ97R9sjcVGFtrcYV1eSWhjGMesNh5RO4c24eX8H2s+7Zp2+JjsjVzZ8I
0ZX7CXTlDgvedckF5AqWHT++Qpezf6AqFy+3f14R+O/NCs83X0b/FelC/Jir
ybFfitFg4G61k3x3t/XHa49/w3l0Ag1rBL4HyfhQa3i6P7tArANekEahuxNn
zRVDMkSQMm9x67SFIipJGU9vbpRQ4a2v5k9jngTmiSGtIbMLE0kRX2pWp4DV
rLNRF9gmu643Yqg2OwpMpi6QVVT2hs7dsARrQG/gDYuFiaWZJLE3ubcejjp8
8A7hbYPfNgfraJiOAvUPAseem6qMdyZH24IrxJBdH4fPcjDEM1dy+CsqQ21p
0v3oA+7Zt5YgFN7B7y+7L3umuuIdZ6yw+GfeonWeVy3Pp1jrwDPz4MaBVNPm
y0uUAnk02Xne+OCE4tHHOnR7/rF+pA2YVWFjsyDVF3ReFG7g41BJBcB9qNVP
Go4zGeWm7qU+sG+LILLalIsvlrNuczBg9UftXh5Z3f7eBiQyF7+NJGrBtA/u
H8B1n7Mj025e7j5AXujZ01dPp79k/9TzHeA9VH97kYi/dJB9eEvxRS3pUjq2
p9VbREPrz7Yv4hdQ+BmHffg+ULHs/AwY8D6H2xDL62pzHZys1t0QyFGF5fZW
gc/JS/byFi/qiUQdc4mq1lbTWmp78vouGjJYUZnrzclyu/J9kaIhVdWaO8Ad
xTZWQlOdFoWxbA4h59KsEd9guEduabrOaph9sm2y1SoPNl0AJMaQyoL33+ai
s5v56Qp5JLNCSfLW4lZdAjY0uDbYAWgYX7Zi9VXZS66JB4pHH/IvfhtcAK/1
N6q+qzbOemrioR240dm3l7suqMfa3TMDUfJYarIbeGFi9KG/54ppaa5IGkmO
PfKPtPnbT6IhXhAMhu56KKMe+nyUvZ7nCtG5G3G4MN2Xnp9KM5bSO7vA2FAA
AKLjiWPhDDqaAT/rMgeFTMtCp2y5W9J2nPXp/1kGJwupLJjZXdz4HzYvGC84
m8Y/+ML105/cAajD4thhp8Vz5F9RyWxSuBcvj5vmf+j/kylfcG1YcfP7aPAb
xB0gFW0faDrP2wfvhia7c3NTDcYSosQ8EYrCuKhFQ+OoGT1Vm7/iDpdRboLX
w7kT6KZpV9IQSOpmBwaB3p+soLLjIPjMfXOkYY/WvPEKIC/m+gYvi268uz43
YjJ6Ss0qOkiEV2i+J6cF195Zuf/ebtdZLXXAYZKFIFtMJnIuV1Gjruzyq8Dr
GItVzmZFLilZTPlgIPviGEZ4J4EMplDG2DQ3qdvY/bnsxo+4bSckjGmHw53d
XnZ1fMj/7O/o1+GbH6iefm7pueLqv+V/8pnl1s9E6OLiqnlprkQlF0cfBto/
1kMoxG+R5E8/Nwzcdo8/iZJHC4uzjQUiEqDf3EEHCDJzzRDat0Xr4PpgKRL5
ItiW0xwSMC3zT2Vdp3YufWMZaVP//crF72xAeG1KgzcNv3lr8XJVBzrO/1LI
v9gf++ZBbCCc//fDLnd8C2Bfcgu4lE5yq3D4gmDytuIC7p+at5R9N3xzz/LT
/QXKOORPedYabP2CwlzdFZfEsoJcmddosyp5HF4TPEs4hexzT1YXK+s2D5Yq
FEPZiiNZ17kRJs0BA5AjAkrCTV/fOdHV77PJ/WaZOg+ZH48f3+Elhu5qPvs7
Zu8ZXtcF+WibjbUY8ngz8WTe5y4YNCXRLra+UqdRUfDf3qpLpVWTuRwIFh2W
jEEZ0Spi8E7ksoQ3XvKmKkp1kk33kXrNhBbgZ4Qfrc27PeE8j+3pOiu4/O2V
oQvC6Qe6uV7H4ohvujMA+RHQLVRqdd4wN5WFbbbDTCz222c7jMQ27dg9w9hD
K3HAT51JrdAr5NEiRDHIUIDw6FwNvbeqd5V9SSySKaXyuNFbI4IV63ynvPvj
nUvfROijwoLDOytY2QdH184Q9A8r7I7sfqq3iGBt+RP90UedOReP/gVyhhfA
f73zf+mUHGcATqVTs+MgP5A2tym4ANijfZfN7KUMg5wdvBscexwkD4fEkqzB
UWYxM9TpBJ0UW5oIUPodelkYXiqby7k9RamqLtPWLZ5qPF/yZzC5NrcrSPpD
2UIJ7TWgHWCcgu3g6G3N3V/skgddbFZ+jZ6efGIefWCEfGbuoVTGsmzQ3SxW
TO8oucKYyYYpFZiAg63Rkbj68uKBEDeXV1eoqqLd8jYzy5j0LQzYKf3OHVbY
n0BjJN1JTK5KsZkhQsvceJjwLjxyhIrbLF/fJen1f9pY7FYotl16aUTCiTHI
0eE7ttvHJZff2eq5Yp19luXtVN32gk0ZNArccq5vdzvM2YpweUmxsrK5UQAi
QJ9Nak1VpDEXqnB5Me522BtErBNyJq89ssd2UXuU3Z9wLn0LTbdD5UDf2Wge
lDbLgR590oQdT9Twq8rhNsjVks+eZiZ7UEvYl+mMfw3yznT9VfBfzu+Ojlhf
ucK2y+zTN7gf/o+ZT/7XPDjGmz/cJLYbJJwkn5Wa7fU9/cyyOO5XKdIOT2GH
lZx8Euq56u44g3qeGaNWrzGEldL+YFGpR80I9iCa16IzpDdZYQbFp5OFColY
pZhK5fKBdJnDDg7d0rX+i2zwjhtdIY1lui9Zrr/LIz1QWPac1WIilspbI1W1
uy7WQZ5VZ63XaPO1BRJqSkTIM/BRBBuwBWoQ+ad685CAPz5tHLlj5rJCgUQR
71Cq2mNVhbFGaNnm1gnvwiN4zudHR+5p7x3nrYwZAo5wOpW2GFO87eTckLvr
MyWA8/ScGYjsNqtiN2Zr+XillAYzDmYq3jQGPF5tKdDIwc5zRlKvSyyKe+PF
PWGYOmGljpqUAm8mkQg4I9It1/Kwvu8zwZXvrgC///zr6LYJ3W+hKszDG+oj
2O8c3lAfFEbnpvqKM0OV17P9VztncZb36dFze7pxCH0dlyp9Lloeen46V0y9
nPo1D2CtctfEDT7xgYTyWDHXIWcOay3quFYc35j1bsx61me9Jm0iEMyJNmMb
SzEmNUklxcgjXq0mEYkVgt5cqZjxBMqecDlVKJhNCT47sDDqmOow79Lsyk2X
atst3fJz2OGRu8Cl1f03HeQR98ZGYW0lM9UFYdcCifOzy3zOrIY2aZapkruC
CLHfPPbQ3HvVPHDbh3DHp1CsMNDlJntrX6asifcqnPX8CslPaFkedxH+jLce
DCULENzc8apch22yYi0LU3HCu/BAacbs8TpAPz9itdmSzbL/cCKv0efWaf7J
dt3D3wogDXv4kWq63cynaAPepNOY0sozYklBuAe0Nslc8BB7jPd+tTdyS7VC
tjCJJibRPHRDOnR1b2NGy6MaBXQrc1Q/dFl64wdscJuochPndXd+IWkG+PaX
QA8flSWMP4UYnwcvPzNQJo1UX5PFf/UIX1sKXbQ5mihnkIF7X/bukZfP2I8q
zJra82a5x6YNOLR+p9bn0vki7kjAESW0BOGP7/ntMZ89Fo+mPc6Uw5ExWvNK
U1mkLlgDNYm0KuJiXnchX8zlijm7OSba8C0/s43c0nWdVY7dUD+7pR2/o5u4
Zxi5a24/pR9qDVDGs+vrOYmuKFJkWGsZynim41PtmbeW7/1kdeqhXK+LKsSB
oWvCS//AvPpPnOcA47L+qCV/e1+urrn8ZYczB5vpDbMxSXgzkiwEEmW1oba5
VZ2fiBFahu/ZCO8uEmM8UVVlQwdOGkuu2e/RTHM90bJkL0qfsY7ckt09vgWm
+PAX69QBg1pXEIuLrIXMwlR2pi8yeMv05FNp2wn+5X9g3X9vq/U4++7P1u/9
nN16fKP1p6xHv97sOLHTeZLf86no9k84yIH/I16Re2jMQNlRSRF+ntrkbkOt
qDgeQduZAzc+1V9CXQ4jGPnZ67ocnk9FBcqLAE41HKlXzLjZK429iDHeNfaf
k4c9LLiUfa5w2MDSHNL0BupieQeeAvwQlRPpQiRZ8saRRrfKiWYrCYQ13hbm
tBeLpWwmm7EZIkKWZ2nYMnRN8+gDSf8F1cAl9eAV7dA1/eNP9EP33LNjWXC7
kPGaYvv2BJoFzOHUZzodD365ef4btKk2mV4bVewFhq4KT3+Neuc4Z+yxD9hZ
cwTWIqWyvFhhMipCQdFsyQVjBcIxtzdH+LnVEldKImx6gjQU771mv/ue7Mln
1qne6OpqdVeKDn1N3uILPgwxGKkkwiBaR2/LWn+x+clXqfd/ujbXb1Roi0JR
aWUuQxzKDrUGOz413H1PfP1HABkbIu/Ztxln3qKf/VsGGjb7t/TPwUS/wYLk
Fjz+tR/wbvxYCHEfcbHfatpPonFUOKD4GQzQsZfLdPHhyWXiUAVd2KK228br
zt6e42qO71sSSP3KlmzYkw3gwI4X0c0g+eEjC8b7pt84uusmvIHazN486FWC
r1wewhGabVAkfA9lOImi31+wO8smO6a21EUq1JBqc6MuEY8jD3vA4yv5QqVk
JmfWx/hr3tGbqvu/5G8SLQK6U8h0rRNdPVfsk90B+mKWu4ePf7fvQ0YPybvR
XNmYs4zfEj45xRlr04glCR4nMnBTffu4qOeyYmHGj2SBFSgGL5DKk92JmYHE
CiUqlaQt3srudqplZzVBOM6mBihdKlK7ZOSG5MEJyYVvrT85axm6Hxm8F14g
Vdjs2io9yZh1+4OZ5h4GRoISAk5g4qH64fu8z96mw29Ntel2ZlRed8qmT0sF
2Y3tMm2+PNMfH77vgvDQ8anpwQkN7Jo7xyV3fim7+RPB9R/xwPECa4VvAqSo
CArNudI9Oo06H553stwJAaqHHWZNYy1OI2MtE4dRS+7sRL3ZhvsadL9yhK4p
iqzBHEOHgdZ4w5ZAQn3IiJteOlV3p18jS33QC5OFrzIu7E4YCKfL4UQpmCz7
0khuyBXB7K6yyVhWqqsiaR0dsc2Xpvsywq10LITG3AHuMmVVoa25g+VYJi9g
ewYuim//8+bamDbmDQccMS49PPIgQJlIbGwWkXgaLoOnNNY94UoiW9BKfWtE
A6lTtUL17EpynN383ES097qHNBze4mTV7sPOYFJ5/GkMeB55KLTDzSssddZK
dqozPHjL1fa++OI36ef+jvrZW3Mf/k8y5MzDDyKkUQwWEJZxsivZdcH85BMp
Z8GaicaOjuQg2x+5KbvwLVb7KeXMQGSHnbNpE+VkOJPKeCJljbchVDXYW/Vl
aokyWZzqKzTn1PRc9Xaetz8+rW8/BfRJ/xj1mFk6zlg7UGuSvXkaDsZ6UFP/
IA6APutIg72Od2YnuwtTfbgPHgaTreBVNfV51F2NChFfZ7vPNcUN4X0jfEWQ
YK05um+JNSxxpCVFaAGUCW8ic07Vnal6018TWgDspuaYB1BPV72pKqHFm64S
brsTqBXWGUL9u9YoEi7W2OtKTVUixnj8+tpqefZZaOSB68lZ6/KgxSiwJmNp
vQK4c3F7s6hW5WCbcJat3ad5195ZoffKzBJX0JPZ42Sm+5LL1CJPsq8x10wO
TG/BnJ5yOpeP5UuxVE4l8e+sOBWajNbV0HoakKcvERMcXsEURg3BsBvw1u8m
wK6OMybigI9Jg7Xz9l5Dy33jn4Wn/2bp5F9RAN1L32IOXxIxiREOG9teLa8u
VuansdGH/sGbRsl2MJPKVsvp5qGbnOcZvyW9+ZPdkfvGFXpGpa/FgZZ54r+r
IeKFpmTbqhJZjSOASN9YpgISJdJwarI7OfYoPnQPlUoN3vHjipRBQkv/rSDh
z8H/Al1C2RFqO0OkCY3HanZlo8ZesNkhCLBV8MfkZ0hhb26q3gS3qWnxGoRf
VJ/RB/cJf24IoZIpAPoA6xjSESK0gOMmHLPiNt38agHTJhyDCG3HnTmYewtE
QsI9wNQcAljrBg+qklbZkaCxUI4a0Lc26vTFMioRum64/z6aZTJ6flvCdbtD
RdF2YnEiQZtJ7ImynlSVvWjrOLFx8euL49f41F79xkJAsluanypB+NwT14ym
cjBYiMfzhXwmU8zDSqLOiGTeaEnaQlWZviEzNiC0S5UFexyNupAbUZcEkOVF
cnmqJz5w2/34tKH1N/K+awZgaWOPYxAl7/5SCpHx9N8sQory8IR0uV+jFfqd
lrxRW5CJy1xOdYVZpc8nLLayL1BMJnPlUgbMWMV3UzpN7Se1pCEnT5SxR2oW
e45Lj9jUsUY1lcwVfL6iyV1VmBvgRLZ5DRarzKCVFimluckScTg/M5CZ7s9N
9eYmurJAf1FtPVBgfObZX+B5bwWMFRWxNrvsUVkUrm8xUccNt/6CUsnvadG8
0r+t9aEaOF1gXxdE57F6HGUDQvkLY/QLQosp9kWLKf4F4c/M8S/MCfwr/gV8
A30f/cA9+A14AbUHv2K2IW0VXBwBNcSvrODG8yTUed545xeCc19nnvjv00/P
8Lc2gzpvjb2em+iMkkfiPEHBlqgzF5wPfr158iuzl/5h/f77UiA6U30JGnV/
a70m36vYjMVoMIsVUpVyJpwpg6dxJmuBDAZ5p9FZFcoaSCrIVQeuYPZhajO2
J6/ucGtrqzX6YoU8khh96O26YHzwvgziXtdF28wgrGyi/ZT23NfXbv6YDziN
3PPwV0LRQDKfz0aiBaenpDNhYkWdJ9qXqWsGC+b2laLxQqGQNWvi9El/71UX
bS4uM1UUtipzOTP8ILRCjNh0CfDiYMMQv2wxdOqPVkOB6vaRPMka4u+QngMu
C0QUNoEYHSM/axDeII81yGN19LBldrxB+G8vS1w8t1MqLi+ExKTmUQHr6zzz
c70SgAToisa73wIYtwBGLYDyMcD4DYCM8LfwAKHuR+jBD0A8UzpwCV8TukNG
yrmHAzGAoVJJ2HRfou+6DZC59F32R385O3SR13FaxFwKygw1OjU3eNc30xc+
QvLRR7zL76x3npOOd9ipxASumo4EDd/ncmpqZcXlKBr2/GGbH9CMZCAjRo1P
NlcumK4YHFWjC+nMARlYX7JTBk2THebB2+bZZyk+vyYWFXaYEeaUc6JVffUH
vGs/5D09Z3n0iQ6o6uBNJaldQR+x8JihiD+J+pzjBau1pFJjgr06X9jQ6DEW
q8Hn1eTSilFXiiUKJnWCMRnoveamzSeUlrLB19jhV4lDGc5a1mrIKLed6Cy9
iI7lbT5M56rLLYja86VIJqspXgifCal7UAETVHd6DHAlvInkAnFpknliY4EE
mAJ4hGNH8C3O4dpghGM0HMRl6v7vqf/9ngcG2yK8oXLhhapuWEv0x7EjgOHr
GDwidMF34F+aQ84U9gMtdPGhFnpTFhbeeLPHYG4Km+pNIsHbU+prP9gBF/fs
5p5i181lB5bnInxJbW4i3nnBPNrm2N5JA6xrDN/ATS1sgImn9rXVJHJcfHwA
CwttEsiUNmjRyVb1yqA66vBj5Uw+k7IYEhJRwurKAV0OZg9kvwHVtl+zL7+z
2n5SRhlP8Xdr4DzdrrSc55ts1UCucfl7O1e+v3Ph2+yh2+odTlQhjZiVfgRp
OQsE3x8tqbUYl1vf3mmYzeVQqCAWYkuUxjq9Jpdh3mBJKUktTwT7rnsYC3G9
tQj5ObgH2jy2s16c63WOXZfJt1ywOxKZgj9RtkfR9D6I9VIjvudfVPJbRado
DBqu6YYkvxpL8w3AGfnUBuE/waOlQ2E3ZI44mPBzgCcBV/17A3YGGDyS+f6j
GjXgNAErQgskFv8RcCP8X3gA34BvH4wFNKM3dzB94lAXHZa+KarYHEkKIX28
Mzl4x/vkrAEI/tm3mY8/5G1S0YwHVwhTmoEdV2YGAo8+0QzcNK6vRmyJ2q44
P9Pv67liA/sUqVA1DrxscxLJh+CtdnaqS7CK52SzbTKHwvWvtYTPHNnbCrEW
QzikeU8MA77miFYZZMedn258+jVqE8/d3ZrVjpQxDOo4pdd671+kd46LgOw8
OrVHn/OYwuiaDWAE0yrgdNcXKas0VQATXIPVUoqGczJRZWGmAZAKBDWLCxPu
ZmeHI+Bw16hRkz3vCGISeW2V2ZjuTz05a7z9s93lYZPLGoNXSxRQBbAjjs9l
wvXIkQanHH2wnaNpxUcSjYDtcqOFTgP/25ThREqcb+JTwJuwoYHGSIGV8CaY
Ofz40aHyH7DSNwGsFvhPW+DvNwA1Qg9YH5orYUA2+BzAw+kSYIzwnuANgT3C
hgEHATnVRGem/6av44zx7nuS899cJz+QMsZ0a/OOYKpkCdSkusY6G5iSD2y2
/7p+fSXkSlblhvryQmGiM87ewKuBpPtN24TPvLyQXxiPWox5CctllyEUUd+I
NLA27Sb3ulnUkMFesAZrSn1Nrq9PdTkfn1Y/+lj95KyaMpHaFdQMJtSnaLRU
dtbTw/eBdjoe/FbZdV7dBDKAA1nF0hiGOE8kVjCZygp9fWunsbNVU8oqNEpj
j1OG6L25va+x1La28pPdwaefmVbnw2Z7Hqi+VFmD90yZyPff8rZ/qFqn+Jhj
ev6yEYmp5svgd2F7mUKN5sQEVDKmOSgZa5ZIHI1Vf1mf/FAbmYFEyhm4lu7B
82NIuPwY0JIjKF+P5J8jmbR/lBgPRj8eoKfFR/qo8Kk+R5MlBAcK95Dmw/8N
uwfcO4Rs0kgVcivIyyALgywbKO38E5Vd4Qn7Yg5Xyp2sAAsWyRsrTKBHvocf
Kfuv6bZWg75URW0EYtSgkhqwB+FjwUcE9gCem7mcf/bYN3TDIlrzFZIJQJLQ
AlgS/tosDSz0OfquWhnzYbWtBHmTWIXmiy7M5CnjefJofm4yTyXldzgNnqAh
kDT4ogaHB/6wNNEVfvq5efCOdY0ZbZpltpRH47LR3HLCtzOZXChZcsTQzgCQ
GIsNqaAc9WVTsazFXoFceXUlO9rmfPiRennKY7Zm3eGKClViQxzMj7aHui9a
O07Jrv/j6uPfsPh0M2yUaA5dczmTdUu0AeSjKRYOCw2L+nzWwwu4so+Gc7AA
NFgLNCr+Tfj7j8dK+h/917945flfv/L8v77y/L/8iZ9/9flf/N7/vnr0jPAf
/h/vCb+m\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213621823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find the numbers of digits 0 through 9 in 10000!!:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"10000", "!!"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1600", ",", "1587", ",", "1692", ",", "1661", ",", "1752", ",", "1631", 
   ",", "1702", ",", "1621", ",", "1684", ",", "2901"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55384910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot the ratio of doubled factorials over double factorial:", \
"ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "!"}], ")"}], "!"}], "/", 
    RowBox[{"n", "!!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{229, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393043782]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22065],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25783],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1808],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/DoubleFactorial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Factorial2/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->237755473],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->16768694],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->532027444]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Factorial2 (!!) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 13.3109980}", "context" -> "System`", 
    "keywords" -> {"double factorial"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "n!! gives the double factorial of n. ", "synonyms" -> {"!!"}, "title" -> 
    "Factorial2", "type" -> "Symbol", "uri" -> "ref/Factorial2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5117, 180, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2549118]},
 "Fibonacci"->{
  Cell[47993, 1399, 275, 10, 70, "Input",
   CellTags->"Fibonacci"],
  Cell[48271, 1411, 1375, 50, 121, "Output",
   CellTags->"Fibonacci",
   CellID->361827988],
  Cell[49683, 1466, 275, 10, 70, "Input",
   CellTags->"Fibonacci"],
  Cell[49961, 1478, 605, 22, 73, "Output",
   CellTags->"Fibonacci",
   CellID->3979954]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[121927, 2811, 129, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 129486, 3028},
 {"Fibonacci", 129620, 3032},
 {"XRef-2005-4-26-23-37-1.8558342", 129980, 3043}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2165, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2788, 80, 104, 4, 70, "ObjectName",
 CellID->32603],
Cell[2895, 86, 443, 15, 70, "Usage",
 CellID->23424]
}, Open  ]],
Cell[CellGroupData[{
Cell[3375, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3853, 123, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3976, 129, 344, 14, 70, "Notes",
 CellID->31409],
Cell[4323, 145, 316, 12, 70, "Notes",
 CellID->11307],
Cell[4642, 159, 226, 7, 70, "Notes",
 CellID->180583195],
Cell[4871, 168, 209, 7, 70, "Notes",
 CellID->286239999]
}, Closed]],
Cell[CellGroupData[{
Cell[5117, 180, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2549118],
Cell[CellGroupData[{
Cell[5500, 194, 148, 5, 70, "ExampleSection",
 CellID->289212473],
Cell[5651, 201, 58, 1, 70, "ExampleText",
 CellID->443184402],
Cell[CellGroupData[{
Cell[5734, 206, 194, 7, 28, "Input",
 CellID->100406044],
Cell[5931, 215, 302, 9, 36, "Output",
 CellID->336921352]
}, Open  ]],
Cell[CellGroupData[{
Cell[6270, 229, 89, 3, 28, "Input",
 CellID->289601152],
Cell[6362, 234, 191, 5, 36, "Output",
 CellID->621444447]
}, Open  ]],
Cell[6568, 242, 123, 3, 70, "ExampleDelimiter",
 CellID->7069989],
Cell[6694, 247, 64, 1, 70, "ExampleText",
 CellID->254834060],
Cell[CellGroupData[{
Cell[6783, 252, 112, 4, 70, "Input",
 CellID->46238338],
Cell[6898, 258, 175, 5, 36, "Output",
 CellID->60148641]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 269, 216, 7, 70, "ExampleSection",
 CellID->17738],
Cell[7341, 278, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7418, 282, 106, 3, 70, "Input"],
Cell[7527, 287, 337, 10, 54, "Output",
 CellID->191440657]
}, Open  ]],
Cell[CellGroupData[{
Cell[7901, 302, 97, 3, 70, "Input",
 CellID->385024099],
Cell[8001, 307, 224, 6, 36, "Output",
 CellID->370481810]
}, Open  ]],
Cell[8240, 316, 123, 3, 70, "ExampleDelimiter",
 CellID->1542098],
Cell[8366, 321, 73, 1, 70, "ExampleText",
 CellID->646599906],
Cell[CellGroupData[{
Cell[8464, 326, 238, 9, 70, "Input",
 CellID->15718371],
Cell[8705, 337, 380, 11, 51, "Output",
 CellID->174957142]
}, Open  ]],
Cell[9100, 351, 124, 3, 70, "ExampleDelimiter",
 CellID->67183006],
Cell[9227, 356, 65, 1, 70, "ExampleText",
 CellID->290430575],
Cell[CellGroupData[{
Cell[9317, 361, 222, 8, 70, "Input",
 CellID->23204027],
Cell[9542, 371, 3159, 56, 70, "Output",
 Evaluatable->False,
 CellID->5073907]
}, Open  ]],
Cell[12716, 430, 105, 2, 70, "ExampleDelimiter"],
Cell[12824, 434, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12903, 438, 117, 4, 70, "Input"],
Cell[13023, 444, 273, 7, 36, "Output",
 CellID->249402174]
}, Open  ]],
Cell[13311, 454, 125, 3, 70, "ExampleDelimiter",
 CellID->149232749],
Cell[13439, 459, 221, 7, 70, "ExampleText",
 CellID->69128392],
Cell[CellGroupData[{
Cell[13685, 470, 168, 6, 70, "Input",
 CellID->234161390],
Cell[13856, 478, 241, 8, 36, "Output",
 CellID->222051272]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14146, 492, 239, 7, 70, "ExampleSection",
 CellID->27681],
Cell[14388, 501, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14477, 505, 93, 2, 70, "Input"],
Cell[14573, 509, 168, 5, 36, "Output",
 CellID->136631480]
}, Open  ]],
Cell[CellGroupData[{
Cell[14778, 519, 111, 3, 70, "Input"],
Cell[14892, 524, 169, 5, 36, "Output",
 CellID->18337803]
}, Open  ]],
Cell[15076, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->115639317],
Cell[15204, 537, 69, 1, 70, "ExampleText",
 CellID->204604663],
Cell[CellGroupData[{
Cell[15298, 542, 225, 8, 70, "Input",
 CellID->219175636],
Cell[15526, 552, 1528, 46, 98, "Output",
 CellID->227419189]
}, Open  ]],
Cell[17069, 601, 105, 2, 70, "ExampleDelimiter"],
Cell[17177, 605, 97, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17299, 611, 191, 6, 70, "Input"],
Cell[17493, 619, 2132, 71, 100, "Output",
 CellID->226350524]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19674, 696, 222, 7, 70, "ExampleSection",
 CellID->1524],
Cell[19899, 705, 218, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20142, 716, 398, 13, 70, "Input"],
Cell[20543, 731, 18880, 314, 70, "Output",
 Evaluatable->False,
 CellID->316192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39472, 1051, 232, 7, 70, "ExampleSection",
 CellID->2832],
Cell[39707, 1060, 339, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[40071, 1076, 158, 5, 70, "Input"],
Cell[40232, 1083, 322, 12, 62, "Output",
 CellID->542131570]
}, Open  ]],
Cell[CellGroupData[{
Cell[40591, 1100, 173, 6, 70, "Input",
 CellID->169940537],
Cell[40767, 1108, 668, 23, 43, "Output",
 CellID->3393543]
}, Open  ]],
Cell[CellGroupData[{
Cell[41472, 1136, 145, 4, 70, "Input"],
Cell[41620, 1142, 259, 9, 36, "Output",
 CellID->31176552]
}, Open  ]],
Cell[41894, 1154, 105, 2, 70, "ExampleDelimiter"],
Cell[42002, 1158, 227, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42254, 1169, 269, 10, 70, "Input"],
Cell[42526, 1181, 212, 7, 36, "Output",
 CellID->104922368]
}, Open  ]],
Cell[42753, 1191, 105, 2, 70, "ExampleDelimiter"],
Cell[42861, 1195, 182, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43068, 1206, 191, 6, 70, "Input"],
Cell[43262, 1214, 1285, 44, 116, "Output",
 CellID->352181987]
}, Open  ]],
Cell[CellGroupData[{
Cell[44584, 1263, 191, 6, 70, "Input"],
Cell[44778, 1271, 1986, 69, 145, "Output",
 CellID->72635119]
}, Open  ]],
Cell[CellGroupData[{
Cell[46801, 1345, 226, 8, 70, "Input"],
Cell[47030, 1355, 182, 6, 38, "Output",
 CellID->14976977]
}, Open  ]],
Cell[CellGroupData[{
Cell[47249, 1366, 226, 8, 70, "Input"],
Cell[47478, 1376, 324, 12, 61, "Output",
 CellID->222521471]
}, Open  ]],
Cell[47817, 1391, 105, 2, 70, "ExampleDelimiter"],
Cell[47925, 1395, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[47993, 1399, 275, 10, 70, "Input",
 CellTags->"Fibonacci"],
Cell[48271, 1411, 1375, 50, 121, "Output",
 CellTags->"Fibonacci",
 CellID->361827988]
}, Open  ]],
Cell[CellGroupData[{
Cell[49683, 1466, 275, 10, 70, "Input",
 CellTags->"Fibonacci"],
Cell[49961, 1478, 605, 22, 73, "Output",
 CellTags->"Fibonacci",
 CellID->3979954]
}, Open  ]],
Cell[50581, 1503, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[50663, 1507, 165, 5, 70, "Input"],
Cell[50831, 1514, 842, 27, 36, "Output",
 CellID->66360616]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51722, 1547, 226, 7, 70, "ExampleSection",
 CellID->25552],
Cell[51951, 1556, 142, 4, 70, "ExampleText",
 CellID->276406083],
Cell[CellGroupData[{
Cell[52118, 1564, 137, 5, 70, "Input",
 CellID->682042817],
Cell[52258, 1571, 357, 7, 70, "Message",
 CellID->874827422],
Cell[52618, 1580, 187, 6, 36, "Output",
 CellID->158334646]
}, Open  ]],
Cell[52820, 1589, 63, 1, 70, "ExampleText",
 CellID->350289571],
Cell[CellGroupData[{
Cell[52908, 1594, 136, 5, 70, "Input",
 CellID->87965497],
Cell[53047, 1601, 214, 6, 36, "Output",
 CellID->8133612]
}, Open  ]],
Cell[53276, 1610, 105, 2, 70, "ExampleDelimiter"],
Cell[53384, 1614, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[53502, 1620, 111, 3, 70, "Input"],
Cell[53616, 1625, 218, 6, 36, "Output",
 CellID->236662944]
}, Open  ]],
Cell[CellGroupData[{
Cell[53871, 1636, 90, 2, 70, "Input"],
Cell[53964, 1640, 161, 5, 36, "Output",
 CellID->72112467]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54174, 1651, 223, 7, 70, "ExampleSection",
 CellID->6141],
Cell[54400, 1660, 184, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[54609, 1671, 682, 22, 70, "Input"],
Cell[55294, 1695, 65857, 1084, 70, "Output",
 Evaluatable->False,
 CellID->213621823]
}, Open  ]],
Cell[121166, 2782, 105, 2, 70, "ExampleDelimiter"],
Cell[121274, 2786, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[121372, 2790, 109, 3, 70, "Input"],
Cell[121484, 2795, 320, 9, 36, "Output",
 CellID->55384910]
}, Open  ]],
Cell[121819, 2807, 105, 2, 70, "ExampleDelimiter"],
Cell[121927, 2811, 129, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[122081, 2817, 323, 12, 70, "Input"],
Cell[122407, 2831, 3019, 54, 70, "Output",
 Evaluatable->False,
 CellID->393043782]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[125487, 2892, 311, 9, 70, "SeeAlsoSection",
 CellID->22065],
Cell[125801, 2903, 696, 26, 70, "SeeAlso",
 CellID->15951]
}, Open  ]],
Cell[CellGroupData[{
Cell[126534, 2934, 314, 9, 70, "TutorialsSection",
 CellID->25783],
Cell[126851, 2945, 154, 3, 70, "Tutorials",
 CellID->666]
}, Open  ]],
Cell[CellGroupData[{
Cell[127042, 2953, 320, 9, 70, "RelatedLinksSection",
 CellID->1808],
Cell[127365, 2964, 186, 4, 70, "RelatedLinks"],
Cell[127554, 2970, 195, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127786, 2979, 319, 9, 70, "MoreAboutSection",
 CellID->237755473],
Cell[128108, 2990, 156, 3, 70, "MoreAbout",
 CellID->16768694],
Cell[128267, 2995, 182, 3, 70, "MoreAbout",
 CellID->532027444]
}, Open  ]],
Cell[128464, 3001, 27, 0, 70, "History"],
Cell[128494, 3003, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

