(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11301,        389]
NotebookOptionsPosition[      8563,        298]
NotebookOutlinePosition[      9871,        336]
CellTagsIndexPosition[      9787,        331]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], "FileHash" :> 
          Documentation`HelpLookup["paclet:ref/FileHash"], "FileType" :> 
          Documentation`HelpLookup["paclet:ref/FileType"], "FileDate" :> 
          Documentation`HelpLookup["paclet:ref/FileDate"], "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringLength\"\>", 
       2->"\<\"FileHash\"\>", 3->"\<\"FileType\"\>", 4->"\<\"FileDate\"\>", 
       5->"\<\"BinaryReadList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"File Operations\"\>", 
       2->"\<\"Files\"\>", 
       3->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FileByteCount", "ObjectName",
 CellID->12701],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileByteCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileByteCount"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of bytes in a file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If a particular file is moved from one computer system to another, the \
number of bytes in the file as reported by ",
 Cell[BoxData[
  ButtonBox["FileByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileByteCount"]], "InlineFormula"],
 " may change. "
}], "Notes",
 CellID->3467]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131518750],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->79488494],

Cell["The number of bytes in a file:", "ExampleText",
 CellID->768885001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileByteCount", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1960552519],

Cell[BoxData["19823"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->550620332]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21936],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5832]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30691],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->18610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->217097124],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->194598011],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->66452303],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->117254819]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileByteCount - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 23.7956414}", "context" -> "System`", 
    "keywords" -> {
     "bytes", "fileattrib", "file attributes", "file size", 
      "ls -l Unix command"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FileByteCount[\"file\"] gives the number of bytes in a file. ", 
    "synonyms" -> {"file byte count"}, "title" -> "FileByteCount", "type" -> 
    "Symbol", "uri" -> "ref/FileByteCount"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4553, 140, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->131518750]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9644, 324}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2507, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3130, 86, 51, 1, 70, "ObjectName",
 CellID->12701],
Cell[3184, 89, 507, 15, 70, "Usage",
 CellID->21172]
}, Open  ]],
Cell[CellGroupData[{
Cell[3728, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4206, 126, 310, 9, 70, "Notes",
 CellID->3467]
}, Closed]],
Cell[CellGroupData[{
Cell[4553, 140, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131518750],
Cell[CellGroupData[{
Cell[4938, 154, 147, 5, 70, "ExampleSection",
 CellID->79488494],
Cell[5088, 161, 73, 1, 70, "ExampleText",
 CellID->768885001],
Cell[CellGroupData[{
Cell[5186, 166, 224, 7, 47, "Input",
 CellID->1960552519],
Cell[5413, 175, 162, 5, 36, "Output",
 CellID->550620332]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5636, 187, 311, 9, 70, "SeeAlsoSection",
 CellID->21936],
Cell[5950, 198, 1205, 44, 70, "SeeAlso",
 CellID->5832]
}, Open  ]],
Cell[CellGroupData[{
Cell[7192, 247, 314, 9, 70, "TutorialsSection",
 CellID->30691],
Cell[7509, 258, 178, 4, 70, "Tutorials",
 CellID->18610]
}, Open  ]],
Cell[CellGroupData[{
Cell[7724, 267, 319, 9, 70, "MoreAboutSection",
 CellID->217097124],
Cell[8046, 278, 141, 3, 70, "MoreAbout",
 CellID->194598011],
Cell[8190, 283, 121, 3, 70, "MoreAbout",
 CellID->66452303],
Cell[8314, 288, 177, 3, 70, "MoreAbout",
 CellID->117254819]
}, Open  ]],
Cell[8506, 294, 27, 0, 70, "History"],
Cell[8536, 296, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

