(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12414,        432]
NotebookOptionsPosition[      9438,        333]
NotebookOutlinePosition[     10766,        371]
CellTagsIndexPosition[     10681,        366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetFileDate" :> 
          Documentation`HelpLookup["paclet:ref/SetFileDate"], "DateList" :> 
          Documentation`HelpLookup["paclet:ref/DateList"], "DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"], "$CreationDate" :> 
          Documentation`HelpLookup["paclet:ref/$CreationDate"], 
          "FileByteCount" :> 
          Documentation`HelpLookup["paclet:ref/FileByteCount"], "FileHash" :> 
          Documentation`HelpLookup["paclet:ref/FileHash"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetFileDate\"\>", 
       2->"\<\"DateList\"\>", 3->"\<\"DateString\"\>", 
       4->"\<\"$CreationDate\"\>", 5->"\<\"FileByteCount\"\>", 
       6->"\<\"FileHash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"File Operations\"\>", 
       3->"\<\"Files\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FileDate", "ObjectName",
 CellID->15322],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileDate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileDate"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the date and time at which a file was last \
modified. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26369]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileDate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileDate"]], "InlineFormula"],
 " returns the date and time in the format used by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12338]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140876264],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->290117674],

Cell["The date and time at which a file was last modified:", "ExampleText",
 CellID->768885001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileDate", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1960552519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3", ",", "26", ",", "10", ",", "27", ",", "10.`"}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306255729]
}, Open  ]],

Cell["Convert to the current local date and time:", "ExampleText",
 CellID->1091269872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1869219091],

Cell[BoxData["\<\"Mon 26 Mar 2007 10:27:10\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->426990474]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27399],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetFileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetFileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CreationDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CreationDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1889],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->29057]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->166418627],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->593440360],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->72233943],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->363054838]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileDate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 27.6707406}", "context" -> "System`", 
    "keywords" -> {
     "fileattrib", "file attributes", "modification date", "time", 
      "file modification dates", "inode data"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FileDate[\"file\"] gives the date and time at which a file was last \
modified. ", "synonyms" -> {"file date"}, "title" -> "FileDate", "type" -> 
    "Symbol", "uri" -> "ref/FileDate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4662, 145, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140876264]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10538, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2576, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3199, 87, 46, 1, 70, "ObjectName",
 CellID->15322],
Cell[3248, 90, 521, 16, 70, "Usage",
 CellID->26369]
}, Open  ]],
Cell[CellGroupData[{
Cell[3806, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4284, 128, 341, 12, 70, "Notes",
 CellID->12338]
}, Closed]],
Cell[CellGroupData[{
Cell[4662, 145, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140876264],
Cell[CellGroupData[{
Cell[5047, 159, 148, 5, 70, "ExampleSection",
 CellID->290117674],
Cell[5198, 166, 95, 1, 70, "ExampleText",
 CellID->768885001],
Cell[CellGroupData[{
Cell[5318, 171, 219, 7, 47, "Input",
 CellID->1960552519],
Cell[5540, 180, 256, 8, 36, "Output",
 CellID->306255729]
}, Open  ]],
Cell[5811, 191, 87, 1, 70, "ExampleText",
 CellID->1091269872],
Cell[CellGroupData[{
Cell[5923, 196, 107, 3, 28, "Input",
 CellID->1869219091],
Cell[6033, 201, 190, 5, 36, "Output",
 CellID->426990474]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6284, 213, 311, 9, 70, "SeeAlsoSection",
 CellID->27399],
Cell[6598, 224, 1461, 53, 70, "SeeAlso",
 CellID->29393]
}, Open  ]],
Cell[CellGroupData[{
Cell[8096, 282, 313, 9, 70, "TutorialsSection",
 CellID->1889],
Cell[8412, 293, 178, 4, 70, "Tutorials",
 CellID->29057]
}, Open  ]],
Cell[CellGroupData[{
Cell[8627, 302, 319, 9, 70, "MoreAboutSection",
 CellID->166418627],
Cell[8949, 313, 149, 3, 70, "MoreAbout",
 CellID->593440360],
Cell[9101, 318, 140, 3, 70, "MoreAbout",
 CellID->72233943],
Cell[9244, 323, 122, 3, 70, "MoreAbout",
 CellID->363054838]
}, Open  ]],
Cell[9381, 329, 27, 0, 70, "History"],
Cell[9411, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

