(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14493,        489]
NotebookOptionsPosition[     11327,        387]
NotebookOutlinePosition[     12728,        426]
CellTagsIndexPosition[     12643,        421]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringFormat" :> 
          Documentation`HelpLookup["paclet:ref/StringFormat"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], "FileHash" :> 
          Documentation`HelpLookup["paclet:ref/FileHash"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StringFormat\"\>", 
       2->"\<\"Import\"\>", 3->"\<\"BinaryReadList\"\>", 
       4->"\<\"FileHash\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"File Operations\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FileFormat", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileFormat",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileFormat"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]attempts to determine what ",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula",
      ShowStringCharacters->False],
     " format could be used to import the file or URL corresponding to ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileFormat"]], "InlineFormula"],
 " returns a format name of the type used by ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32194],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileFormat"]], "InlineFormula"],
 " uses heuristic methods, and may not give correct results, particularly for \
shorter files."
}], "Notes",
 CellID->10525],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileFormat"]], "InlineFormula"],
 " does not verify that ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " would succeed if applied to ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->14105],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileFormat"]], "InlineFormula"],
 " get clues from both names of files and properties of files recorded in the \
filesystem, but bases the final result it returns only on the actual contents \
of files. "
}], "Notes",
 CellID->352324372]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3387557],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->6436235],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " format of a file:"
}], "ExampleText",
 CellID->1959914436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileFormat", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1960552519],

Cell[BoxData["\<\"JPEG\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494256553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30264519],

Cell[TextData[{
 "A format name of the type used by ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1819734309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileFormat", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</Documentation/English/System/ExampleData/bignum\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1625399486],

Cell[BoxData["\<\"Table\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675751684]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26115],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringFormat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5889]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->501066907],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->30892380],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->281321771],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout",
 CellID->116172830]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 27.9051216}", "context" -> "System`", 
    "keywords" -> {
     "import format", "file format heuristics", "format guessing", 
      "format determination", "format decision"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FileFormat[\"name\"] attempts to determine what Import format could be \
used to import the file or URL corresponding to \" name\". ", 
    "synonyms" -> {"file format", "file"}, "title" -> "FileFormat", "type" -> 
    "Symbol", "uri" -> "ref/FileFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6999, 213, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3387557]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12502, 414}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2042, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2665, 73, 1575, 37, 70, "ObjectNameGrid"],
Cell[4243, 112, 826, 24, 70, "Usage",
 CellID->9650]
}, Open  ]],
Cell[CellGroupData[{
Cell[5106, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5584, 158, 335, 12, 70, "Notes",
 CellID->32194],
Cell[5922, 172, 263, 8, 70, "Notes",
 CellID->10525],
Cell[6188, 182, 428, 15, 70, "Notes",
 CellID->14105],
Cell[6619, 199, 343, 9, 70, "Notes",
 CellID->352324372]
}, Closed]],
Cell[CellGroupData[{
Cell[6999, 213, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3387557],
Cell[CellGroupData[{
Cell[7382, 227, 146, 5, 70, "ExampleSection",
 CellID->6436235],
Cell[7531, 234, 201, 8, 70, "ExampleText",
 CellID->1959914436],
Cell[CellGroupData[{
Cell[7757, 246, 221, 7, 47, "Input",
 CellID->1960552519],
Cell[7981, 255, 169, 5, 36, "Output",
 CellID->494256553]
}, Open  ]],
Cell[8165, 263, 124, 3, 70, "ExampleDelimiter",
 CellID->30264519],
Cell[8292, 268, 214, 8, 70, "ExampleText",
 CellID->1819734309],
Cell[CellGroupData[{
Cell[8531, 280, 217, 7, 70, "Input",
 CellID->1625399486],
Cell[8751, 289, 170, 5, 36, "Output",
 CellID->675751684]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8982, 301, 311, 9, 70, "SeeAlsoSection",
 CellID->26115],
Cell[9296, 312, 956, 35, 70, "SeeAlso",
 CellID->5889]
}, Open  ]],
Cell[CellGroupData[{
Cell[10289, 352, 299, 8, 70, "MoreAboutSection"],
Cell[10591, 362, 141, 3, 70, "MoreAbout",
 CellID->501066907],
Cell[10735, 367, 153, 3, 70, "MoreAbout",
 CellID->30892380],
Cell[10891, 372, 185, 3, 70, "MoreAbout",
 CellID->281321771],
Cell[11079, 377, 176, 3, 70, "MoreAbout",
 CellID->116172830]
}, Open  ]],
Cell[11270, 383, 27, 0, 70, "History"],
Cell[11300, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

