(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15699,        502]
NotebookOptionsPosition[     12436,        398]
NotebookOutlinePosition[     13832,        437]
CellTagsIndexPosition[     13747,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FileByteCount" :> 
          Documentation`HelpLookup["paclet:ref/FileByteCount"], "FileDate" :> 
          Documentation`HelpLookup["paclet:ref/FileDate"], "Hash" :> 
          Documentation`HelpLookup["paclet:ref/Hash"], "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], "FileFormat" :> 
          Documentation`HelpLookup["paclet:ref/FileFormat"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FileByteCount\"\>", 
       2->"\<\"FileDate\"\>", 3->"\<\"Hash\"\>", 4->"\<\"BinaryReadList\"\>", 
       5->"\<\"FileFormat\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"External Operations\"\>", 4->"\<\"File Operations\"\>", 
       5->"\<\"Files\"\>", 
       6->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FileHash", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileHash",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileHash"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an integer hash code for the contents of the \
specified file."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileHash",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileHash"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an integer hash of the specified type."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Values generated by ",
 Cell[BoxData[
  ButtonBox["FileHash",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileHash"]], "InlineFormula"],
 " are based on the raw bytes in a file."
}], "Notes",
 CellID->277551297],

Cell["Possible hash code types include:", "Notes",
 CellID->12017851],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Adler32\>\"", Cell[
    "Adler 32-bit cyclic redundancy check", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CRC32\>\"", Cell[
    "32-bit cyclic redundancy check", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MD2\>\"", Cell[
    "128-bit MD2 code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MD5\>\"", Cell[
    "128-bit MD5 code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SHA\>\"", Cell[
    "160-bit SHA-1 code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SHA256\>\"", Cell[
    "256-bit SHA code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SHA384\>\"", Cell[
    "384-bit SHA code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SHA512\>\"", Cell[
    "512-bit SHA code", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->175655438]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114110483],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->115245711],

Cell["The fingerprint of a file:", "ExampleText",
 CellID->768885001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileHash", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1960552519],

Cell[BoxData["77540190680901220435998691601364369372"], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587290906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1907989462],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<SHA512\>\""], "InlineFormula"],
 " hash code of a file:"
}], "ExampleText",
 CellID->1353070830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileHash", "[", 
  RowBox[{
   RowBox[{
   "$InstallationDirectory", "<>", 
    "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], ",", 
   " ", "\"\<SHA512\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1357101727],

Cell[BoxData[\
"24437512474264911609866015473170130346246982858029311081678272348261051726102\
78595385708238095345946566676159433100038240445159544598032530094845931863523"\
], "Output",
 ImageSize->{576, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1242165]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileFormat"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout",
 CellID->128150295],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->12224378],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->13575562],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->51424428],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->53942454],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->64341650]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileHash - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 28.3270074}", "context" -> "System`", 
    "keywords" -> {
     "checksum", "CRC", "digest", "hash", "hash code", "hashcode", "hashing", 
      "MD2", "MD5"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FileHash[\"file\"] gives an integer hash code for the contents of the \
specified file. FileHash[\"file\", \" type\"] gives an integer hash of the \
specified type.", "synonyms" -> {"file hash"}, "title" -> "FileHash", "type" -> 
    "Symbol", "uri" -> "ref/FileHash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7547, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114110483]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13604, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2404, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3027, 79, 1573, 37, 70, "ObjectNameGrid"],
Cell[4603, 118, 923, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5563, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6041, 167, 234, 8, 70, "Notes",
 CellID->277551297],
Cell[6278, 177, 69, 1, 70, "Notes",
 CellID->12017851],
Cell[6350, 180, 1160, 25, 70, "2ColumnTableMod",
 CellID->175655438]
}, Closed]],
Cell[CellGroupData[{
Cell[7547, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114110483],
Cell[CellGroupData[{
Cell[7932, 224, 148, 5, 70, "ExampleSection",
 CellID->115245711],
Cell[8083, 231, 69, 1, 70, "ExampleText",
 CellID->768885001],
Cell[CellGroupData[{
Cell[8177, 236, 219, 7, 47, "Input",
 CellID->1960552519],
Cell[8399, 245, 196, 5, 36, "Output",
 CellID->587290906]
}, Open  ]],
Cell[8610, 253, 126, 3, 70, "ExampleDelimiter",
 CellID->1907989462],
Cell[8739, 258, 140, 5, 70, "ExampleText",
 CellID->1353070830],
Cell[CellGroupData[{
Cell[8904, 267, 264, 8, 70, "Input",
 CellID->1357101727],
Cell[9171, 277, 316, 8, 71, "Output",
 CellID->1242165]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9548, 292, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9867, 303, 1208, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11112, 352, 299, 8, 70, "MoreAboutSection"],
Cell[11414, 362, 171, 3, 70, "MoreAbout",
 CellID->128150295],
Cell[11588, 367, 163, 3, 70, "MoreAbout",
 CellID->12224378],
Cell[11754, 372, 148, 3, 70, "MoreAbout",
 CellID->13575562],
Cell[11905, 377, 140, 3, 70, "MoreAbout",
 CellID->51424428],
Cell[12048, 382, 121, 3, 70, "MoreAbout",
 CellID->53942454],
Cell[12172, 387, 192, 4, 70, "MoreAbout",
 CellID->64341650]
}, Open  ]],
Cell[12379, 394, 27, 0, 70, "History"],
Cell[12409, 396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

