(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27577,        862]
NotebookOptionsPosition[     23425,        732]
NotebookOutlinePosition[     25094,        774]
CellTagsIndexPosition[     25009,        769]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding and Manipulating Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingAndManipulatingFiles"], 
          "Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finding and Manipulating Files\"\>", 
       2->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"], 
          "SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "FileType" :> Documentation`HelpLookup["paclet:ref/FileType"], 
          "FileDate" :> Documentation`HelpLookup["paclet:ref/FileDate"], 
          "FileByteCount" :> 
          Documentation`HelpLookup["paclet:ref/FileByteCount"], "FileHash" :> 
          Documentation`HelpLookup["paclet:ref/FileHash"], "FilePrint" :> 
          Documentation`HelpLookup["paclet:ref/FilePrint"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FileNameSetter\"\>", 
       2->"\<\"SystemDialogInput\"\>", 3->"\<\"Directory\"\>", 
       4->"\<\"FileType\"\>", 5->"\<\"FileDate\"\>", 
       6->"\<\"FileByteCount\"\>", 7->"\<\"FileHash\"\>", 
       8->"\<\"FilePrint\"\>", 9->"\<\"Get\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"File Operations\"\>", 
       4->"\<\"Files\"\>", 5->"\<\"Mathematica Session Information\"\>", 
       6->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FileNames", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNames",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNames"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]lists all files in the current working directory. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNames",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNames"], "[", 
       StyleBox["form", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists all files in the current working directory whose \
names match the string pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNames",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNames"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["form", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["form", "TI"], "2"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists all files whose names match any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNames",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNames"], "[", 
       RowBox[{
        StyleBox["forms", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["dir", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["dir", "TI"], "2"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists files with names matching ",
     Cell[BoxData[
      StyleBox["forms", "TI"]], "InlineFormula"],
     " in any of the directories ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNames",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNames"], "[", 
       RowBox[{
        StyleBox["forms", "TI"], ",", 
        StyleBox["dirs", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes files that are in subdirectories up to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels down. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27299]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "File names can be given as literal strings, ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " string patterns, ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " objects, or abbreviated string patterns."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->75096019],

Cell[TextData[{
 "In abbreviated string patterns, ",
 Cell[BoxData["*"], "InlineFormula"],
 " stands for any sequence of zero or more characters. ",
 Cell[BoxData["@"], "InlineFormula"],
 " stands for any sequence of one or more characters other than upper-case \
letters."
}], "Notes",
 CellID->823849628],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"], "[", "\"\<*\>\"", "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"], "[", "__", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"], "[", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2680],

Cell[TextData[{
 "In abbreviated string patterns, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " specifies that the string ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""], "InlineFormula"],
 " should be matched with ",
 Cell[BoxData["*"], "InlineFormula"],
 " and ",
 Cell[BoxData["@"], "InlineFormula"],
 " treated literally."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->156476555],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"], "[", 
   RowBox[{
    StyleBox["forms", "TI"], ",", 
    StyleBox["dirs", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " looks for files in all subdirectories of the ",
 Cell[BoxData[
  StyleBox["dirs", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25835],

Cell[TextData[{
 "The list of files returned by ",
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 " is sorted in the order generated by the function ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7019],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"], "[", 
   RowBox[{
    StyleBox["forms", "TI"], ",", 
    StyleBox["dirs", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " includes names of directories only if they appear exactly at level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12311],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["forms", "TI"]], "InlineFormula"],
 " can include relative or absolute directory specifications, in addition to \
names of files. "
}], "Notes",
 CellID->27773],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 " treat lower\[Hyphen] and upper\[Hyphen]case letters in file names as \
equivalent. "
}], "Notes",
 CellID->7991],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 " treats lower\[Hyphen] and upper\[Hyphen]case letters in file names as \
equivalent under Microsoft Windows operating systems, but not elsewhere."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->228914542]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181043203],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->391291066],

Cell[TextData[{
 "List the file and directory names in the ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->122983100],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$InstallationDirectory", "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845404090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->391410201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AddOns\"\>", ",", "\<\"Configuration\"\>", 
   ",", "\<\".CreationID\"\>", ",", "\<\"Documentation\"\>", 
   ",", "\<\"Mathematica.exe\"\>", ",", "\<\"math.exe\"\>", 
   ",", "\<\"MathKernel.exe\"\>", ",", "\<\"Packages\"\>", 
   ",", "\<\"SystemFiles\"\>"}], "}"}]], "Output",
 ImageSize->{455, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->335486913]
}, Open  ]],

Cell["Count the the files in the whole installation directory:", "ExampleText",
 CellID->584737678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FileNames", "[", 
   RowBox[{"\"\<*\>\"", ",", 
    RowBox[{"{", "\"\<*\>\"", "}"}], ",", "Infinity"}], "]"}], "//", 
  "Length"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224045434],

Cell[BoxData["12290"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->55494876]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20369],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21221],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "Tutorials",
 CellID->27462],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->23685]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->138666100],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->479888271],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->171545025],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->553204702],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->301192140],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->107256896],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->660497230]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 29.5301632}", "context" -> "System`", 
    "keywords" -> {
     "dir", "files", "find in Unix", "ls", "patterns", "search"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FileNames[] lists all files in the current working directory. \
FileNames[form] lists all files in the current working directory whose names \
match the string pattern form. FileNames[{form_1, form_2, ...}] lists all \
files whose names match any of the form_i. FileNames[forms, {dir_1, dir_2, \
...}] lists files with names matching forms in any of the directories dir_i. \
FileNames[forms, dirs, n] includes files that are in subdirectories up to n \
levels down. ", "synonyms" -> {"file names"}, "title" -> "FileNames", "type" -> 
    "Symbol", "uri" -> "ref/FileNames"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16733, 480, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->181043203]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24865, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3598, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4221, 104, 4193, 83, 70, "ObjectNameGrid"],
Cell[8417, 189, 2804, 87, 70, "Usage",
 CellID->27299]
}, Open  ]],
Cell[CellGroupData[{
Cell[11258, 281, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11736, 298, 566, 16, 70, "Notes",
 CellID->75096019],
Cell[12305, 316, 306, 8, 70, "Notes",
 CellID->823849628],
Cell[12614, 326, 674, 24, 70, "Notes",
 CellID->2680],
Cell[13291, 352, 651, 20, 70, "Notes",
 CellID->156476555],
Cell[13945, 374, 483, 17, 70, "Notes",
 CellID->25835],
Cell[14431, 393, 371, 13, 70, "Notes",
 CellID->7019],
Cell[14805, 408, 436, 15, 70, "Notes",
 CellID->12311],
Cell[15244, 425, 211, 7, 70, "Notes",
 CellID->27773],
Cell[15458, 434, 514, 18, 70, "Notes",
 CellID->7991],
Cell[15975, 454, 721, 21, 70, "Notes",
 CellID->228914542]
}, Closed]],
Cell[CellGroupData[{
Cell[16733, 480, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181043203],
Cell[CellGroupData[{
Cell[17118, 494, 148, 5, 70, "ExampleSection",
 CellID->391291066],
Cell[17269, 501, 252, 8, 70, "ExampleText",
 CellID->122983100],
Cell[17524, 511, 150, 5, 70, "Input",
 CellID->845404090],
Cell[CellGroupData[{
Cell[17699, 520, 100, 3, 28, "Input",
 CellID->391410201],
Cell[17802, 525, 452, 11, 54, "Output",
 CellID->335486913]
}, Open  ]],
Cell[18269, 539, 99, 1, 70, "ExampleText",
 CellID->584737678],
Cell[CellGroupData[{
Cell[18393, 544, 219, 7, 70, "Input",
 CellID->224045434],
Cell[18615, 553, 161, 5, 36, "Output",
 CellID->55494876]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18837, 565, 311, 9, 70, "SeeAlsoSection",
 CellID->20369],
Cell[19151, 576, 2200, 80, 70, "SeeAlso",
 CellID->15015]
}, Open  ]],
Cell[CellGroupData[{
Cell[21388, 661, 314, 9, 70, "TutorialsSection",
 CellID->21221],
Cell[21705, 672, 168, 3, 70, "Tutorials",
 CellID->27462],
Cell[21876, 677, 156, 3, 70, "Tutorials",
 CellID->23685]
}, Open  ]],
Cell[CellGroupData[{
Cell[22069, 685, 319, 9, 70, "MoreAboutSection",
 CellID->138666100],
Cell[22391, 696, 147, 3, 70, "MoreAbout",
 CellID->479888271],
Cell[22541, 701, 149, 3, 70, "MoreAbout",
 CellID->171545025],
Cell[22693, 706, 141, 3, 70, "MoreAbout",
 CellID->553204702],
Cell[22837, 711, 122, 3, 70, "MoreAbout",
 CellID->301192140],
Cell[22962, 716, 172, 3, 70, "MoreAbout",
 CellID->107256896],
Cell[23137, 721, 193, 4, 70, "MoreAbout",
 CellID->660497230]
}, Open  ]],
Cell[23345, 728, 50, 0, 70, "History"],
Cell[23398, 730, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

