(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15033,        521]
NotebookOptionsPosition[     11878,        419]
NotebookOutlinePosition[     13287,        457]
CellTagsIndexPosition[     13202,        452]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up Functions with Optional Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Setting Up Functions with Optional Arguments\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], 
          "OptionValue" :> 
          Documentation`HelpLookup["paclet:ref/OptionValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cases\"\>", 
       2->"\<\"OptionValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options Management\"\>", 
       2->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FilterRules", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FilterRules",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FilterRules"], "[", 
       RowBox[{
        StyleBox["rules", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]filters the list ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " by picking out only those rules whose left-hand sides match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FilterRules",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FilterRules"], "[", 
       RowBox[{
        StyleBox["rules", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["patt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]picks out rules whose left-hand sides match any of the \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The rules in the list ",
 Cell[BoxData[
  StyleBox["rules", "TI"]], "InlineFormula"],
 " can be either ",
 Cell[BoxData["->"], "InlineFormula"],
 " or ",
 Cell[BoxData[":>"], "InlineFormula"],
 " rules."
}], "Notes",
 CellID->11325],

Cell[TextData[{
 "If any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["patt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a rule of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", then it is treated just as ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17305],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["patt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a string, it will also match a symbol whose name is the string. "
}], "Notes",
 CellID->1710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FilterRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilterRules"], "[", 
   RowBox[{
    StyleBox["rules", "TI"], ",", 
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["patt", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " gives all rules except those whose left-hand sides match ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24232]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325653679],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->382496967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilterRules", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "->", "1"}], ",", 
     RowBox[{"b", "->", "2"}], ",", 
     RowBox[{"c", "->", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472674618],

Cell[TextData[{
 "Filter for options that appear in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17991679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilterRules", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
     RowBox[{"MaxIterations", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"Options", "[", "Plot", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116479108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", "3"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73664354]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32261],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OptionValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31996],

Cell[TextData[ButtonBox["Setting Up Functions with Optional Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]], "Tutorials",
 CellID->208660540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->83789056],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->49689313],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->90311839]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FilterRules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 45.1086870}", "context" -> "System`", 
    "keywords" -> {"pick matched rules", "select rules"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FilterRules[rules, patt] filters the list rules by picking out only \
those rules whose left-hand sides match patt. FilterRules[rules, {patt_1, \
patt_2, ...}] picks out rules whose left-hand sides match any of the patt_i.",
     "synonyms" -> {"filter rules"}, "title" -> "FilterRules", "type" -> 
    "Symbol", "uri" -> "ref/FilterRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7732, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->325653679]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13059, 445}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2064, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2687, 78, 1576, 37, 70, "ObjectNameGrid"],
Cell[4266, 117, 1512, 48, 70, "Usage",
 CellID->22043]
}, Open  ]],
Cell[CellGroupData[{
Cell[5815, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6293, 187, 250, 10, 70, "Notes",
 CellID->11325],
Cell[6546, 199, 399, 16, 70, "Notes",
 CellID->17305],
Cell[6948, 217, 226, 8, 70, "Notes",
 CellID->1710],
Cell[7177, 227, 518, 18, 70, "Notes",
 CellID->24232]
}, Closed]],
Cell[CellGroupData[{
Cell[7732, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325653679],
Cell[CellGroupData[{
Cell[8117, 264, 148, 5, 70, "ExampleSection",
 CellID->382496967],
Cell[CellGroupData[{
Cell[8290, 273, 315, 11, 28, "Input",
 CellID->19511],
Cell[8608, 286, 258, 9, 36, "Output",
 CellID->8390]
}, Open  ]],
Cell[8881, 298, 125, 3, 70, "ExampleDelimiter",
 CellID->472674618],
Cell[9009, 303, 208, 8, 70, "ExampleText",
 CellID->17991679],
Cell[CellGroupData[{
Cell[9242, 315, 301, 9, 28, "Input",
 CellID->116479108],
Cell[9546, 326, 217, 7, 36, "Output",
 CellID->73664354]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9824, 340, 311, 9, 70, "SeeAlsoSection",
 CellID->32261],
Cell[10138, 351, 451, 17, 70, "SeeAlso",
 CellID->24311]
}, Open  ]],
Cell[CellGroupData[{
Cell[10626, 373, 314, 9, 70, "TutorialsSection",
 CellID->31996],
Cell[10943, 384, 201, 4, 70, "Tutorials",
 CellID->208660540]
}, Open  ]],
Cell[CellGroupData[{
Cell[11181, 393, 318, 9, 70, "MoreAboutSection",
 CellID->83789056],
Cell[11502, 404, 146, 3, 70, "MoreAbout",
 CellID->49689313],
Cell[11651, 409, 155, 3, 70, "MoreAbout",
 CellID->90311839]
}, Open  ]],
Cell[11821, 415, 27, 0, 70, "History"],
Cell[11851, 417, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

