(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21818,        764]
NotebookOptionsPosition[     17289,        611]
NotebookOutlinePosition[     18683,        649]
CellTagsIndexPosition[     18598,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Searching Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindList" :> Documentation`HelpLookup["paclet:ref/FindList"], 
          "Read" :> Documentation`HelpLookup["paclet:ref/Read"], "Skip" :> 
          Documentation`HelpLookup["paclet:ref/Skip"], "StreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/StreamPosition"], 
          "StringToStream" :> 
          Documentation`HelpLookup["paclet:ref/StringToStream"], 
          "NotebookFind" :> 
          Documentation`HelpLookup["paclet:ref/NotebookFind"], "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindList\"\>", 2->"\<\"Read\"\>", 
       3->"\<\"Skip\"\>", 4->"\<\"StreamPosition\"\>", 
       5->"\<\"StringToStream\"\>", 6->"\<\"NotebookFind\"\>", 
       7->"\<\"StringCases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"Files\"\>", 3->"\<\"Low-Level File Operations\"\>", 
       4->"\<\"String Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Find", "ObjectName",
 CellID->3905],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Find",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Find"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the first line in an input stream that contains \
the specified string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Find",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Find"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the first line that contains any of the specified \
strings. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " breaks the input stream into records, delimited by record separators, and \
scans each record for the strings you specify. "
}], "Notes",
 CellID->9227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " returns as a string the first record which contains the specified text. "
}], "Notes",
 CellID->2371],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " does not find any record which contains the specified text before it \
reaches the end of the file, it returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2288],

Cell["The following options can be given: ", "Notes",
 CellID->20123],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnchoredSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnchoredSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require that the text searched for be at the beginning of a record \
\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IgnoreCase",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IgnoreCase"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to treat lower and upper case as equivalent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\<\\r\\n\>\"", ",", " ", "\"\<\\n\>\"", ",", "\"\<\\r\>\""}], 
     "}"}], Cell["separators for records ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require that the text searched for appears as a word \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}], Cell[
    "separators for words ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->30582],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", or simply ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 " if there is only one open input stream with the specified name. "
}], "Notes",
 CellID->30594],

Cell[TextData[{
 "You can open a file or pipe to get an ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " object using ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3836],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " does not close streams after it finishes reading from them. "
}], "Notes",
 CellID->11105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->636190839],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->46494925],

Cell["Open a stream:", "ExampleText",
 CellID->1761856541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", " ", "=", " ", 
  RowBox[{
  "OpenRead", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2018359751],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"ExampleData/USConstitution.txt\"\>", ",", "82"}], 
  "]"}]], "Output",
 ImageSize->{331, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49205117]
}, Open  ]],

Cell[TextData[{
 "Get the first line that contains ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"electors\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->903160046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"str", ",", "\"\<electors\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->365384372],

Cell[BoxData["\<\"choice of electors for President and Vice-President of the \
United States,\"\>"], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6712931]
}, Open  ]],

Cell[TextData[{
 "Find the next line that contains ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"electors\", \"TI\"]\)\>\""], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->4998788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"str", ",", "\"\<electors\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11336967],

Cell[BoxData["\<\"have one vote. The electors in each State shall have the \
qualifications\"\>"], "Output",
 ImageSize->{501, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92212540]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->552681668],

Cell[BoxData["\<\"ExampleData/USConstitution.txt\"\>"], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->162523141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1702428765],

Cell["Open a stream:", "ExampleText",
 CellID->139866156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", " ", "=", " ", 
  RowBox[{
  "OpenRead", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1383374074],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"ExampleData/USConstitution.txt\"\>", ",", "42"}], 
  "]"}]], "Output",
 ImageSize->{331, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1865220071]
}, Open  ]],

Cell[TextData[{
 "Find the first line that contains ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"electors\", \"TI\"]\)\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"people\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1598431425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"str", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<electors\>\"", ",", "\"\<people\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1964019652],

Cell[BoxData["\<\"of the press; or the right of the people peaceably to \
assemble, and to petition\"\>"], "Output",
 ImageSize->{557, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1934938038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1158738145],

Cell[BoxData["\<\"ExampleData/USConstitution.txt\"\>"], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1353806861]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19386],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StreamPosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringToStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringToStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookFind",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookFind"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28838],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->18603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->60450909],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->891755026],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->202714064],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->42993706],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->398638833]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Find - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 6.5779866}", "context" -> "System`", 
    "keywords" -> {"sequential searching", "grep", "sed"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Find[stream, \" text\"] finds the first line in an input stream that \
contains the specified string. Find[stream, {\"SubscriptBox[ text, 1]\", \
\"SubscriptBox[ text, 2]\", ...}] finds the first line that contains any of \
the specified strings. ", "synonyms" -> {}, "title" -> "Find", "type" -> 
    "Symbol", "uri" -> "ref/Find"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9321, 289, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->636190839]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18455, 637}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2751, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3374, 88, 41, 1, 70, "ObjectName",
 CellID->3905],
Cell[3418, 91, 1208, 36, 70, "Usage",
 CellID->7252]
}, Open  ]],
Cell[CellGroupData[{
Cell[4663, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5141, 149, 282, 8, 70, "Notes",
 CellID->9227],
Cell[5426, 159, 231, 7, 70, "Notes",
 CellID->2371],
Cell[5660, 168, 406, 14, 70, "Notes",
 CellID->2288],
Cell[6069, 184, 69, 1, 70, "Notes",
 CellID->20123],
Cell[6141, 187, 1955, 51, 70, "3ColumnTableMod",
 CellID->30582],
Cell[8099, 240, 604, 20, 70, "Notes",
 CellID->30594],
Cell[8706, 262, 355, 13, 70, "Notes",
 CellID->3836],
Cell[9064, 277, 220, 7, 70, "Notes",
 CellID->11105]
}, Closed]],
Cell[CellGroupData[{
Cell[9321, 289, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->636190839],
Cell[CellGroupData[{
Cell[9706, 303, 147, 5, 70, "ExampleSection",
 CellID->46494925],
Cell[9856, 310, 58, 1, 70, "ExampleText",
 CellID->1761856541],
Cell[CellGroupData[{
Cell[9939, 315, 182, 6, 28, "Input",
 CellID->2018359751],
Cell[10124, 323, 259, 8, 36, "Output",
 CellID->49205117]
}, Open  ]],
Cell[10398, 334, 181, 6, 70, "ExampleText",
 CellID->903160046],
Cell[CellGroupData[{
Cell[10604, 344, 140, 4, 28, "Input",
 CellID->365384372],
Cell[10747, 350, 239, 6, 36, "Output",
 CellID->6712931]
}, Open  ]],
Cell[11001, 359, 180, 6, 70, "ExampleText",
 CellID->4998788],
Cell[CellGroupData[{
Cell[11206, 369, 139, 4, 70, "Input",
 CellID->11336967],
Cell[11348, 375, 238, 6, 36, "Output",
 CellID->92212540]
}, Open  ]],
Cell[CellGroupData[{
Cell[11623, 386, 103, 3, 70, "Input",
 CellID->552681668],
Cell[11729, 391, 196, 5, 36, "Output",
 CellID->162523141]
}, Open  ]],
Cell[11940, 399, 126, 3, 70, "ExampleDelimiter",
 CellID->1702428765],
Cell[12069, 404, 57, 1, 70, "ExampleText",
 CellID->139866156],
Cell[CellGroupData[{
Cell[12151, 409, 182, 6, 70, "Input",
 CellID->1383374074],
Cell[12336, 417, 261, 8, 36, "Output",
 CellID->1865220071]
}, Open  ]],
Cell[12612, 428, 274, 9, 70, "ExampleText",
 CellID->1598431425],
Cell[CellGroupData[{
Cell[12911, 441, 206, 7, 70, "Input",
 CellID->1964019652],
Cell[13120, 450, 248, 6, 36, "Output",
 CellID->1934938038]
}, Open  ]],
Cell[CellGroupData[{
Cell[13405, 461, 104, 3, 70, "Input",
 CellID->1158738145],
Cell[13512, 466, 197, 5, 36, "Output",
 CellID->1353806861]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13770, 478, 311, 9, 70, "SeeAlsoSection",
 CellID->19386],
Cell[14084, 489, 1698, 62, 70, "SeeAlso",
 CellID->11128]
}, Open  ]],
Cell[CellGroupData[{
Cell[15819, 556, 314, 9, 70, "TutorialsSection",
 CellID->28838],
Cell[16136, 567, 140, 3, 70, "Tutorials",
 CellID->18603]
}, Open  ]],
Cell[CellGroupData[{
Cell[16313, 575, 318, 9, 70, "MoreAboutSection",
 CellID->60450909],
Cell[16634, 586, 149, 3, 70, "MoreAbout",
 CellID->891755026],
Cell[16786, 591, 122, 3, 70, "MoreAbout",
 CellID->202714064],
Cell[16911, 596, 158, 3, 70, "MoreAbout",
 CellID->42993706],
Cell[17072, 601, 145, 3, 70, "MoreAbout",
 CellID->398638833]
}, Open  ]],
Cell[17232, 607, 27, 0, 70, "History"],
Cell[17262, 609, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

