(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    208935,       7244]
NotebookOptionsPosition[    178857,       6192]
NotebookOutlinePosition[    180437,       6233]
CellTagsIndexPosition[    180350,       6228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-\
ManipulatingEquationsAndInequalities"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Inequalities\"\>", 
       2->"\<\"Equations and Inequalities over Domains\"\>", 
       3->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "FindRoot" :> Documentation`HelpLookup["paclet:ref/FindRoot"], 
          "PowersRepresentations" :> 
          Documentation`HelpLookup["paclet:ref/PowersRepresentations"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"], 
          "Minimize" :> Documentation`HelpLookup["paclet:ref/Minimize"], 
          "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], 
          "CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"], 
          "SemialgebraicComponentInstances" :> 
          Documentation`HelpLookup[
           "paclet:ref/SemialgebraicComponentInstances"], "ChineseRemainder" :> 
          Documentation`HelpLookup["paclet:ref/ChineseRemainder"], "Resolve" :> 
          Documentation`HelpLookup["paclet:ref/Resolve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Solve\"\>", 2->"\<\"Reduce\"\>", 
       3->"\<\"FindRoot\"\>", 4->"\<\"PowersRepresentations\"\>", 
       5->"\<\"IntegerPartitions\"\>", 6->"\<\"Minimize\"\>", 
       7->"\<\"RegionPlot\"\>", 8->"\<\"RegionPlot3D\"\>", 
       9->"\<\"CylindricalDecomposition\"\>", 
       10->"\<\"SemialgebraicComponentInstances\"\>", 
       11->"\<\"ChineseRemainder\"\>", 
       12->"\<\"Resolve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Diophantine Equations\"\>", 3->"\<\"Equation Solving\"\>", 
       4->"\<\"Inequalities\"\>", 5->"\<\"Number Theory\"\>", 
       6->"\<\"Polynomial Systems\"\>", 
       7->"\<\"Prime Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FindInstance", "ObjectName",
 CellID->1369],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindInstance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindInstance"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds an instance of ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     " that makes the statement ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " be ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindInstance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindInstance"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds an instance over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ". Common choices of ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     " are ",
     Cell[BoxData[
      ButtonBox["Complexes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Booleans",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Booleans"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindInstance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindInstance"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["vars", "TI"], ",", 
        StyleBox["dom", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " instances. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13016]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives results in the same form as ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], "->", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], "->", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["2", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]], "InlineFormula"],
 " if an instance exists, and ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " if it does not. "
}], "Notes",
 CellID->24473],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can contain equations, inequalities, domain specifications and \
quantifiers, in the same form as in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7369],

Cell[TextData[{
 "With exact symbolic input, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " gives exact results. "
}], "Notes",
 CellID->12626],

Cell[TextData[{
 "Even if two inputs define the same mathematical set, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " may still pick different instances to return. "
}], "Notes",
 CellID->3104],

Cell[TextData[{
 "The instances returned by ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " typically correspond to special or interesting points in the set. "
}], "Notes",
 CellID->31848],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " assumes by default that quantities appearing algebraically in inequalities \
are real, while all other quantities are complex. "
}], "Notes",
 CellID->2982],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"]}], "]"}]], "InlineFormula"],
 " finds solutions to Diophantine equations. "
}], "Notes",
 CellID->22294],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"]}], "]"}]], "InlineFormula"],
 " solves Boolean satisfiability for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31997],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"]}], "]"}]], "InlineFormula"],
 " assumes that not only ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " but also all function values in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " are real. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], "&&", 
     RowBox[{
      StyleBox["vars", "TI"], "\[Element]", 
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]}]}], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " assumes only that the ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " are real. "
}], "Notes",
 CellID->22426],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " may be able to find instances even if ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " cannot give a complete reduction. "
}], "Notes",
 CellID->29690],

Cell[TextData[{
 "Every time you run ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " with a given input, it will return the same output. "
}], "Notes",
 CellID->9890],

Cell[TextData[{
 "Different settings for the option ",
 Cell[BoxData[
  RowBox[{"RandomSeed", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " may yield different collections of instances. "
}], "Notes",
 CellID->1539474642],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["dom", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " will return a shorter list if the total number of instances is less than \
",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->700119403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->877260518],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->119623764],

Cell["Find a solution instance of a system of equations:", "ExampleText",
 CellID->716395631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"z", "^", "2"}], "\[Equal]", 
     RowBox[{
      RowBox[{"2", "x"}], "-", 
      RowBox[{"5", " ", "y"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47420189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["21"]}], ")"}]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["5", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          SqrtBox["21"]}], ")"}]}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{327, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273233923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155775989],

Cell["\<\
Find a real solution instance of a system of equations and inequalities:\
\>", "ExampleText",
 CellID->744297667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"9", 
      RowBox[{"z", "^", "3"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"2", "x"}], "-", 
      RowBox[{"5", " ", "y"}], "-", "7"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->60662809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["45", "128"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3", "4"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97791527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->657484086],

Cell["Find an integer solution instance:", "ExampleText",
 CellID->471405922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"10", "<", "x", "<", "100"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56462758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "26"}], ",", 
    RowBox[{"y", "\[Rule]", "15"}]}], "}"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40462698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119382377],

Cell["Find Boolean values of variables that satisfy a formula:", "ExampleText",
 CellID->19885214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Xor", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "&&", 
    RowBox[{"(", 
     RowBox[{"a", "||", "b"}], ")"}], "&&", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{"c", "||", "d"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "Booleans"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369927311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "True"}], ",", 
    RowBox[{"b", "\[Rule]", "False"}], ",", 
    RowBox[{"c", "\[Rule]", "False"}], ",", 
    RowBox[{"d", "\[Rule]", "False"}]}], "}"}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373930031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50909694],

Cell["Find several instances:", "ExampleText",
 CellID->158756807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"10", "<", "x", "<", "1000"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53845729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "362"}], ",", 
     RowBox[{"y", "\[Rule]", "209"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "26"}], ",", 
     RowBox[{"y", "\[Rule]", "15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "97"}], ",", 
     RowBox[{"y", "\[Rule]", "56"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357127367]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(37)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22751],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Complex Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->84922610],

Cell["A linear system:", "ExampleText",
 CellID->149821829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284710479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "22"}], ",", 
    RowBox[{"z", "\[Rule]", "13"}]}], "}"}], "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282261468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253504289],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->64844045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672643237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6354720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77578128],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->169862198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288610958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212850548]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91534336],

Cell["Systems of polynomial equations and inequations:", "ExampleText",
 CellID->899471838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "z"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145589199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"3", "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      FractionBox["2", "3"], " ", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"3", "-", 
          RowBox[{"2", " ", "#1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{458, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83429579]
}, Open  ]],

Cell["This gives three solution instances:", "ExampleText",
 CellID->141271131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "z"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101797570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"56", "-", 
       FractionBox[
        RowBox[{"303", " ", "\[ImaginaryI]"}], "10"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1465758878629", "-", 
          RowBox[{"263949200", " ", "#1"}], "+", 
          RowBox[{"40000", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"395923800", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"120000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"90000", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "3"}], "]"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{
       FractionBox["1", "30"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"550", "-", 
           RowBox[{"303", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
         RowBox[{"20", " ", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1465758878629", "-", 
              RowBox[{"263949200", " ", "#1"}], "+", 
              RowBox[{"40000", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"395923800", " ", 
               SuperscriptBox["#1", "3"]}], "-", 
              RowBox[{"120000", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"90000", " ", 
               SuperscriptBox["#1", "6"]}]}], "&"}], ",", "3"}], "]"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["293", "5"], "+", 
       FractionBox[
        RowBox[{"227", " ", "\[ImaginaryI]"}], "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"168655391161", "-", 
          RowBox[{"10152000", " ", "#1"}], "+", 
          RowBox[{"2500", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"15228000", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"7500", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"5625", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{
       FractionBox["1", "15"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"288", "+", 
           RowBox[{"227", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
         RowBox[{"10", " ", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"168655391161", "-", 
              RowBox[{"10152000", " ", "#1"}], "+", 
              RowBox[{"2500", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"15228000", " ", 
               SuperscriptBox["#1", "3"]}], "-", 
              RowBox[{"7500", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"5625", " ", 
               SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["537", "10"]}], "-", 
       RowBox[{"40", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1823882232929", "-", 
          RowBox[{"156230800", " ", "#1"}], "+", 
          RowBox[{"40000", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"234346200", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"120000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"90000", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "5"}], "]"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{
       FractionBox["1", "30"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "547"}], "-", 
           RowBox[{"400", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
         RowBox[{"20", " ", 
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"1823882232929", "-", 
              RowBox[{"156230800", " ", "#1"}], "+", 
              RowBox[{"40000", " ", 
               SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"234346200", " ", 
               SuperscriptBox["#1", "3"]}], "-", 
              RowBox[{"120000", " ", 
               SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"90000", " ", 
               SuperscriptBox["#1", "6"]}]}], "&"}], ",", "5"}], "]"}]}]}], 
        ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{568, 281},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47494914]
}, Open  ]],

Cell[TextData[{
 "If there are no solutions ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns an empty list:"
}], "ExampleText",
 CellID->71540266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "3"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], " ", "\[Equal]", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->610369292],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->133087817]
}, Open  ]],

Cell[TextData[{
 "If there are fewer solutions than the requested number, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns all solutions:"
}], "ExampleText",
 CellID->11427598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"2", "y"}], "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->99533921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["4", "5"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{224, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->414554565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->644436505],

Cell["Quantified polynomial system:", "ExampleText",
 CellID->159443640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{
         RowBox[{"a", " ", "y"}], "\[NotEqual]", "0"}]}]}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208385592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->502355828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->700158465],

Cell["An algebraic system:", "ExampleText",
 CellID->546492545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "]"}], "-", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[Equal]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31277144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{473, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345377184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1314432],

Cell["Transcendental equations:", "ExampleText",
 CellID->288893094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "3"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256538498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"67", " ", "\[Pi]"}], "-", 
     RowBox[{"ArcSin", "[", 
      FractionBox["1", "3"], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{160, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32007133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", "^", 
      RowBox[{"(", 
       RowBox[{"x", "^", "2"}], ")"}]}], 
     RowBox[{"2", "^", "x"}]}], "\[Equal]", "8"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->34551955],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"528", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
          RowBox[{"Log", "[", "2", "]"}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"Log", "[", "8", "]"}]}]}], 
         RowBox[{"Log", "[", "2", "]"}]]]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{297, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275662377]
}, Open  ]],

Cell["In this case there is no solution:", "ExampleText",
 CellID->101603241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"75", "/", "11"}], " ", "I", " ", "Pi"}], "+", "17"}]}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->474067602],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3877987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385408181],

Cell["A system of transcendental equations:", "ExampleText",
 CellID->331511400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "-", "y"}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67423421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"6", "-", 
        RowBox[{"191", " ", "\[Pi]"}], "-", 
        RowBox[{"6", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"33", ",", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"191", " ", "\[Pi]"}], "6"]}]]}], "]"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"191", " ", "\[Pi]"}], "6"]}], "-", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"33", ",", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"1", "-", 
             FractionBox[
              RowBox[{"191", " ", "\[Pi]"}], "6"]}]]}], "]"}]}]]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ExponentialE]"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox[
           RowBox[{"191", " ", "\[Pi]"}], "6"], "+", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"33", ",", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"191", " ", "\[Pi]"}], "6"]}]]}], "]"}]}]]}], 
       ")"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{422, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58734470]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Real Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->57305448],

Cell["A linear system:", "ExampleText",
 CellID->787469300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9250850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["33", "10"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["737", "10"]}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["431", "10"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{208, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541887086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114190875],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->81649366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193942569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55097111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489808851],

Cell["A univariate polynomial inequality:", "ExampleText",
 CellID->292696808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "<", "0"}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76644507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97125767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97040171],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->630117658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->758827168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116723702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354625005],

Cell["A multivariate polynomial inequality:", "ExampleText",
 CellID->14844610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", "y"}], " ", "+", 
     RowBox[{"z", "^", "2"}]}], "\[GreaterEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->223254230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"z", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{149, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331258457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389602569],

Cell["Systems of polynomial equations and inequalities:", "ExampleText",
 CellID->375009844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], ">", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->91668569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["5"]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{"z", "\[Rule]", "2"}]}], "}"}], "}"}]], "Output",
 ImageSize->{177, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176204735]
}, Open  ]],

Cell["Get four solution instances:", "ExampleText",
 CellID->87176738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], ">", "7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->314416047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "371"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "12"}]}], ",", 
     RowBox[{"z", "\[Rule]", "11470"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "137"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "68"}]}], ",", 
     RowBox[{"z", "\[Rule]", "276"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "69"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "94"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["2380", "47"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "94"}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["15", "94"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{399, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200367419]
}, Open  ]],

Cell[TextData[{
 "If there are no solutions ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns an empty list:"
}], "ExampleText",
 CellID->145489344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "3"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[GreaterEqual]", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], " ", "\[Equal]", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157970443],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23499800]
}, Open  ]],

Cell[TextData[{
 "If there are fewer solutions than the requested number, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns all solutions:"
}], "ExampleText",
 CellID->330130352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"2", "y"}], "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals", ",", "5"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->255143945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["4", "5"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{224, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->954609793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69923244],

Cell["A quantified polynomial system:", "ExampleText",
 CellID->356535914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236241633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", "18"}]}], ",", 
    RowBox[{"b", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590648375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125859915],

Cell["An algebraic system:", "ExampleText",
 CellID->15168201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "]"}], "-", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"4", "y"}]}], "\[GreaterEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126906310],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"y", "\[Rule]", "8"}]}], "}"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267095123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141393736],

Cell["Piecewise equations:", "ExampleText",
 CellID->309755201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", 
           RowBox[{"Abs", "[", 
            RowBox[{"x", "+", "2"}], "]"}]}], ")"}], "^", "2"}], "-", "1"}], 
       "]"}], "^", "2"}], "\[Equal]", "9"}], "&&", 
    RowBox[{"x", "\[NotEqual]", "0"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6175762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "2"}]}], "}"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151244969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Max", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "^", "2"}], "-", "x"}], ",", "x"}], "]"}]}], "&&", 
    RowBox[{"x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327866928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109959786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233833830],

Cell["Piecewise inequalities:", "ExampleText",
 CellID->619582499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"7", "x"}], "-", "6"}], "]"}], "<", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "x"}], "]"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->712190582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "4"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204639737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{"Floor", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"Ceiling", "[", 
       RowBox[{"x", "^", "2"}], "]"}]}], "]"}], "<", "10"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74944114],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433487293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22193703],

Cell["Transcendental equations:", "ExampleText",
 CellID->178378100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"E", "^", "x"}], "-", "x"}], "\[Equal]", "7"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32163487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "7"}], "-", 
     RowBox[{"ProductLog", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SuperscriptBox["\[ExponentialE]", "7"]]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{217, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497443772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", " ", 
  RowBox[{
   RowBox[{
    RadicalBox[
     SuperscriptBox["27", 
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}]], "x"], "==", 
    SqrtBox[
     SuperscriptBox["9", 
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}]]]}], ",", " ", "x", " ", ",", " ", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->849204275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", "2187", "]"}], 
      RowBox[{"4", " ", 
       RowBox[{"Log", "[", "3", "]"}]}]], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "24"}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Log", "[", "2187", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Log", "[", "3", "]"}], "2"]]}]]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{275, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178402686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53285106],

Cell["Transcendental inequalities:", "ExampleText",
 CellID->245801814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "4"}], "<", 
    RowBox[{"Sin", "[", "x", "]"}], "<", 
    RowBox[{"1", "/", "3"}]}], ",", "x", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285456402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["243627", "1159"]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762544468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", " ", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["2", "x"], "-", "1"}]], ">", 
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox["2", 
       RowBox[{"x", "-", "1"}]]}]]}], ",", " ", "x", " ", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44025090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["21", "61"]}], "}"}], "}"}]], "Output",
 ImageSize->{74, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98232480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147547389],

Cell["Transcendental systems:", "ExampleText",
 CellID->202401352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "==", 
     RowBox[{"1", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "-", "y"}], "\[LessEqual]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31650260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox[
      RowBox[{"1009", " ", "\[Pi]"}], "6"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{140, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91637503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["3", "x"], "-", 
      SuperscriptBox["2", 
       RowBox[{"2", "y"}]]}], "\[Equal]", "77"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      SqrtBox[
       SuperscriptBox["3", "x"]], "-", 
      SuperscriptBox["2", "y"]}], "\[Equal]", "7"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->942160119],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "9", "]"}]}], 
      RowBox[{"Log", "[", "3", "]"}]]}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43975695]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Integer Domain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247179601],

Cell["A linear system of equations:", "ExampleText",
 CellID->91649387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31436120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "22"}], ",", 
    RowBox[{"z", "\[Rule]", "13"}]}], "}"}], "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164301253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56626870],

Cell["A linear system of equations and inequalities:", "ExampleText",
 CellID->610547063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}]}], "\[LessEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", "y"}]}], ">", 
     RowBox[{"-", "21"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336458608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "7"}]}], ",", 
    RowBox[{"y", "\[Rule]", "6"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20556135]
}, Open  ]],

Cell["Find more than one solution:", "ExampleText",
 CellID->19084496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}]}], "\[LessEqual]", "5"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", "y"}]}], ">", 
     RowBox[{"-", "21"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->775889221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "112"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "88"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{"y", "\[Rule]", "6"}], ",", 
     RowBox[{"z", "\[Rule]", "16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "92"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "4"}]}], ",", 
     RowBox[{"y", "\[Rule]", "4"}], ",", 
     RowBox[{"z", "\[Rule]", "22"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{464, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42915109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20516472],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->68329701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "1000"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "777"}]}], "+", "1"}], "\[Equal]", "0"}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626380406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2675611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327203451],

Cell["A univariate polynomial inequality:", "ExampleText",
 CellID->292309597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "<", "0"}], ",", "x", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50212146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->715389604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487716768],

Cell["Binary quadratic equations:", "ExampleText",
 CellID->149610693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "109"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408955322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "7"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "5"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1130744]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "22"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78572943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "5"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198565412]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"6", " ", "x", " ", "y"}], "+", 
     RowBox[{"9", 
      RowBox[{"y", "^", "2"}]}], "-", "x", "+", 
     RowBox[{"2", "y"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157947200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242054236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160308141],

Cell["A Thue equation:", "ExampleText",
 CellID->146235021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
     RowBox[{"y", "^", "3"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264134555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104225144]
}, Open  ]],

Cell[TextData[{
 "If there are fewer solutions than the requested number, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns all solutions:"
}], "ExampleText",
 CellID->185756456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
     RowBox[{"y", "^", "3"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->657467191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5"}], ",", 
     RowBox[{"y", "\[Rule]", "3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72315633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140799112],

Cell["A sum of squares equation:", "ExampleText",
 CellID->297997273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}], "+", 
     RowBox[{"t", "^", "2"}]}], "\[Equal]", "123456789"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->454294297],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2600"}], ",", 
    RowBox[{"y", "\[Rule]", "378"}], ",", 
    RowBox[{"z", "\[Rule]", "10468"}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", "2641"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34911099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146400772],

Cell["The Pythagorean equation:", "ExampleText",
 CellID->756311395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "^", "2"}]}], "&&", 
    RowBox[{"100", "<", "x", "<", "y", "<", "z"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242404353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "101"}], ",", 
    RowBox[{"y", "\[Rule]", "5100"}], ",", 
    RowBox[{"z", "\[Rule]", "5101"}]}], "}"}], "}"}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297315477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11130723],

Cell["A bounded system of equations and inequalities:", "ExampleText",
 CellID->502130737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"y", "^", "4"}], "+", 
      RowBox[{"z", "^", "4"}]}], "\[LessEqual]", "500"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "3"}]}], "\[Equal]", "32"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572071652],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{"z", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233599594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->336612686],

Cell["A high-degree system with no solution:", "ExampleText",
 CellID->90785482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"x", "^", "7"}]}], "+", 
     RowBox[{"8", 
      RowBox[{"y", "^", "15"}]}], "+", 
     RowBox[{"14", " ", "x", " ", "y", " ", "z"}]}], "\[Equal]", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15565691],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488841442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311367224],

Cell["Transcendental Diophantine systems:", "ExampleText",
 CellID->357909727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"y", "^", "2"}], "]"}], "<", "x"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], "<", "5"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "y", "]"}], "<", "5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114962634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131562904]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"5", 
         RowBox[{"y", "^", "2"}]}], "+", "1"}], "]"}], "+", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"5", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602714198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64917898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731201360],

Cell["A polynomial system of congruences:", "ExampleText",
 CellID->4884468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "2"}], "]"}], "\[Equal]", "1"}], "&&",
     
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"x", "-", 
        RowBox[{"2", "y"}]}], ",", "3"}], "]"}], "\[Equal]", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146539654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "5"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405729530]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modular Domains",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208071237],

Cell["A linear system:", "ExampleText",
 CellID->75271447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", "y"}], "-", 
      RowBox[{"5", "z"}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "x"}], "-", 
      RowBox[{"4", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154699585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "10"}], ",", 
    RowBox[{"z", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147333785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21536370],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->60093961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55991068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247244805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332381957],

Cell["A multivariate polynomial equation:", "ExampleText",
 CellID->210277461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7784294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}], ",", 
    RowBox[{"z", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43063586]
}, Open  ]],

Cell["Find seven instances:", "ExampleText",
 CellID->432349166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", " ", "z"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "7", ",", 
   RowBox[{"Modulus", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373952145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "3"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{558, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40729985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82067436],

Cell["A system of polynomial equations and inequations:", "ExampleText",
 CellID->276046792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "\[Equal]", "z"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221242426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "5"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}], ",", 
    RowBox[{"z", "\[Rule]", "5"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->627583521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651713204],

Cell["A quantified polynomial system:", "ExampleText",
 CellID->453041102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"y", "^", "2"}]}], "-", 
          RowBox[{"3", "y"}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{"y", "\[NotEqual]", "0"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646939176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "0"}], ",", 
    RowBox[{"b", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143308637]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mixed Domains",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247230330],

Cell["Mixed real and complex variables:", "ExampleText",
 CellID->371793992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->730229669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SqrtBox["3"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{139, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9938738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740254980],

Cell[TextData[{
 "Find a real value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and a complex value of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], TraditionalForm]], "InlineMath"],
 " is real and less than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->399380530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67018416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12811953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195936302],

Cell[TextData[{
 "An inequality involving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->372916470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ",", 
     RowBox[{"Im", "[", "z", "]"}]}], "}"}], "/.", 
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{"Abs", "[", " ", 
       FractionBox[
        RowBox[{"z", "-", "2"}], 
        RowBox[{
         RowBox[{"2", "z"}], "-", "1"}]], "]"}], "<", "2"}], ",", "z", ",", 
     "7"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363312606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["3215", "3506"], ",", 
     FractionBox["20", "127"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["632", "877"], ",", 
     FractionBox["73", "223"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["661", "877"], ",", 
     RowBox[{"-", 
      FractionBox["2", "5"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "5"], ",", 
     RowBox[{"-", 
      FractionBox["60", "169"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["152", "877"], ",", 
     RowBox[{"-", 
      FractionBox["21", "31"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["571", "702"]}], ",", 
     FractionBox["3", "29"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["623", "877"], ",", 
     FractionBox["27", "56"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{342, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236208900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "=", 
     RowBox[{"u", "+", 
      RowBox[{"I", " ", "v"}]}]}], "}"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{"Abs", "[", " ", 
       FractionBox[
        RowBox[{"z", "-", "2"}], 
        RowBox[{
         RowBox[{"2", "z"}], "-", "1"}]], "]"}], "<", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Epilog", "->", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "pts", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223555947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10781029]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8448],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20097],

Cell["Find a solution over the integers modulo 9:", "ExampleText",
 CellID->487344474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "3"}]}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "9"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260171957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "8"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194567626]
}, Open  ]],

Cell["Find three solutions:", "ExampleText",
 CellID->337393461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "3"}]}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "3", ",", 
   RowBox[{"Modulus", "\[Rule]", "9"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->654738560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "8"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "8"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "8"}], ",", 
     RowBox[{"y", "\[Rule]", "7"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108984667]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RandomSeed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27277],

Cell["\<\
Finding instances often involves random choice from large solution sets:\
\>", "ExampleText",
 CellID->1017383031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217646610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["120", "151"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["8401"], "151"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["116", "151"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["9345"], "151"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["118", "151"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["8877"], "151"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518613453]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " chooses the same solutions each time:"
}], "ExampleText",
 CellID->521806113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->301039185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["120", "151"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["8401"], "151"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["116", "151"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["9345"], "151"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["118", "151"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["8877"], "151"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110352182]
}, Open  ]],

Cell[TextData[{
 "With a different ",
 Cell[BoxData["RandomSeed"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " may give different solutions:"
}], "ExampleText",
 CellID->155242055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "3", ",", 
   RowBox[{"RandomSeed", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->142016753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["107", "151"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["17", "36"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["107", "151"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["2838"]}], "151"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{403, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->101524656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9392],

Cell["\<\
Finding an exact solution to this problem is hard due to high degrees of \
algebraic numbers:\
\>", "ExampleText",
 CellID->777105701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "77"}], "+", 
        RowBox[{"3", "x"}], "-", "11"}], "\[Equal]", "1"}], " ", "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "^", "5"}], "-", 
        RowBox[{
         RowBox[{"x", "^", "2"}], " ", "y"}], "+", "21"}], "\[Equal]", "2"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], 
         RowBox[{"y", "^", "3"}]}], "+", 
        RowBox[{"z", "^", "4"}]}], "==", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], ",", 
   "60"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5143605],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25357212]
}, Open  ]],

Cell[TextData[{
 "With a finite ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " is able to find an approximate solution:"
}], "ExampleText",
 CellID->45947561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "77"}], "+", 
       RowBox[{"3", "x"}], "-", "11"}], "\[Equal]", "1"}], " ", "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "5"}], "-", 
       RowBox[{
        RowBox[{"x", "^", "2"}], " ", "y"}], "+", "21"}], "\[Equal]", "2"}], "&&",
      
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "3"}]}], "+", 
       RowBox[{"z", "^", "4"}]}], "==", "3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals", ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351142723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.016000000000003428`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
      "x", "\[Rule]", 
       "1.02881744422109050920376824311873182852992541733368227204337675147538\
62569706029197854248427010207996443315602312295`100."}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{
       "-", "1.837450143664959052547347088772375349533487973716679534796375888\
6314390169965771214385285574987048324314047621368272`100.72299244929955"}]}], 
      ",", 
      RowBox[{
      "z", "\[Rule]", 
       "1.75867847004858318232749879610453933090458841600417797572889537287127\
69643564323049263475340444157162968822274754869`100.35593556170173"}]}], 
     "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{579, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42111380]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27199],

Cell["Find a point in the intersection of two regions:", "ExampleText",
 CellID->159363089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "/.", 
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "3"}]}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "+", "2"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
       "1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646668107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{"-", 
     FractionBox["5", "4"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249079449]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "3"}]}], "\[LessEqual]", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
        RowBox[{"Hue", "[", "0.3", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "+", "2"}], ")"}], "^", "2"}]}], "\[LessEqual]", "1"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
        RowBox[{"Hue", "[", "0.7", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->524903287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"r1", ",", "r2", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->537194858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16626739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215876008],

Cell["Find a counterexample to a geometric conjecture:", "ExampleText",
 CellID->202110312],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"s", 
     RowBox[{"(", 
      RowBox[{"s", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conjecture", "=", 
   RowBox[{
    RowBox[{"27", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"a", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "^", "2"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "F"}], ")"}], "^", "6"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->186965933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"triangle", " ", "&&", 
    RowBox[{"!", "conjecture"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->244596046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox["3", "4"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"c", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47444716]
}, Open  ]],

Cell["Prove the conjecture using stronger assumptions:", "ExampleText",
 CellID->48249174],

Cell[BoxData[
 RowBox[{
  RowBox[{"acute", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], ">", 
     RowBox[{"c", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"b", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"a", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27660955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"triangle", " ", "&&", "acute", "&&", 
    RowBox[{"!", "conjecture"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->90216989],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->553346400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151317666],

Cell["Prove that a statement is a tautology:", "ExampleText",
 CellID->138659453],

Cell[BoxData[
 RowBox[{
  RowBox[{"statement", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "&&", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{"b", "||", 
             RowBox[{"(", 
              RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", 
        "||", 
        RowBox[{"(", 
         RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"!", "a"}], "||", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "&&", 
         RowBox[{"!", 
          RowBox[{"(", 
           RowBox[{"b", "||", 
            RowBox[{"(", 
             RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", "||",
        
       RowBox[{"(", 
        RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3979005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"!", "statement"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Booleans"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->554407093],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->608662459]
}, Open  ]],

Cell[TextData[{
 "This can be proven with ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " as well:"
}], "ExampleText",
 CellID->231647836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "statement", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->76307263],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->987615913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109267876],

Cell["\<\
Show that a statement is not a tautology; get a counterexample:\
\>", "ExampleText",
 CellID->236363576],

Cell[BoxData[
 RowBox[{
  RowBox[{"statement", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "&&", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{"b", "||", 
             RowBox[{"(", 
              RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", 
        "||", 
        RowBox[{"(", 
         RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"!", "a"}], "||", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "&&", 
         RowBox[{"!", 
          RowBox[{"(", 
           RowBox[{"b", "||", 
            RowBox[{"(", 
             RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", "||",
        
       RowBox[{"(", 
        RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835966022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"!", "statement"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Booleans"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56694323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "True"}], ",", 
    RowBox[{"b", "\[Rule]", "False"}], ",", 
    RowBox[{"c", "\[Rule]", "True"}]}], "}"}], "}"}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281106000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2129827],

Cell["Find a Pythagorean triple:", "ExampleText",
 CellID->23509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "==", 
     RowBox[{"5", "^", "2"}]}], "&&", 
    RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", "4"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->717517003]
}, Open  ]],

Cell["Find Pythagorean triples when they exist:", "ExampleText",
 CellID->20713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"z", "->", 
    RowBox[{"FindInstance", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "==", 
        RowBox[{"z", "^", "2"}]}], "&&", 
       RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "3"}], ",", 
       RowBox[{"y", "\[Rule]", "4"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"8", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"9", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"10", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "6"}], ",", 
       RowBox[{"y", "\[Rule]", "8"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"12", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"13", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "5"}], ",", 
       RowBox[{"y", "\[Rule]", "12"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"14", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"15", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "9"}], ",", 
       RowBox[{"y", "\[Rule]", "12"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"16", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"17", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "8"}], ",", 
       RowBox[{"y", "\[Rule]", "15"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"18", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"19", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"20", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "12"}], ",", 
       RowBox[{"y", "\[Rule]", "16"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"21", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"22", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"23", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"24", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"25", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "7"}], ",", 
       RowBox[{"y", "\[Rule]", "24"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"26", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "10"}], ",", 
       RowBox[{"y", "\[Rule]", "24"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"27", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"28", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"29", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "20"}], ",", 
       RowBox[{"y", "\[Rule]", "21"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"30", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "18"}], ",", 
       RowBox[{"y", "\[Rule]", "24"}]}], "}"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{581, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266303377]
}, Open  ]],

Cell[TextData[{
 "Two instances are now found when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "25"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->11955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"z", "->", 
    RowBox[{"FindInstance", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "==", 
        RowBox[{"z", "^", "2"}]}], "&&", 
       RowBox[{"y", ">", "x", ">", "0"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "10"}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "3"}], ",", 
       RowBox[{"y", "\[Rule]", "4"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"8", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"9", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"10", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "6"}], ",", 
       RowBox[{"y", "\[Rule]", "8"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"12", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"13", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "5"}], ",", 
       RowBox[{"y", "\[Rule]", "12"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"14", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"15", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "9"}], ",", 
       RowBox[{"y", "\[Rule]", "12"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"16", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"17", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "8"}], ",", 
       RowBox[{"y", "\[Rule]", "15"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"18", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"19", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"20", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "12"}], ",", 
       RowBox[{"y", "\[Rule]", "16"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"21", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"22", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"23", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"24", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"25", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "7"}], ",", 
        RowBox[{"y", "\[Rule]", "24"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "\[Rule]", "15"}], ",", 
        RowBox[{"y", "\[Rule]", "20"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"26", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "10"}], ",", 
       RowBox[{"y", "\[Rule]", "24"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"27", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"28", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"29", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "20"}], ",", 
       RowBox[{"y", "\[Rule]", "21"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"30", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "18"}], ",", 
       RowBox[{"y", "\[Rule]", "24"}]}], "}"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{478, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370990837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16699],

Cell["\<\
Show that there are no 2\[Times]2 magic squares with all numbers unequal:\
\>", "ExampleText",
 CellID->27971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "+", "c"}], "\[Equal]", 
     RowBox[{"b", "+", "d"}], "\[Equal]", 
     RowBox[{"a", "+", "b"}], "\[Equal]", 
     RowBox[{"c", "+", "d"}]}], "&&", 
    RowBox[{
    "a", "\[NotEqual]", "b", "\[NotEqual]", "c", "\[NotEqual]", "d"}]}], ",", 
   
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23829],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97777991]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19271],

Cell["Solution instances satisfy the input system:", "ExampleText",
 CellID->232066281],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "3"}], "+", 
      RowBox[{"2", "z"}]}], "\[LessEqual]", "3"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224463781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", "/.", 
  RowBox[{"FindInstance", "[", 
   RowBox[{"system", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "7"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->444564614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True"}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82191559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137788344],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to prove that algebraic numbers satisfy equations:"
}], "ExampleText",
 CellID->441087945],

Cell[BoxData[
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "3"}], "+", 
     RowBox[{"2", "x", " ", "y"}]}], "\[Equal]", "1"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409625579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", "/.", 
  RowBox[{"FindInstance", "[", 
   RowBox[{"system", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->664477226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4489", " ", "\[ImaginaryI]"}], "50"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["67", "5"], "-", 
        FractionBox[
         RowBox[{"67", " ", "\[ImaginaryI]"}], "5"]}], ")"}], " ", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"20153621", "+", 
          RowBox[{"5948260", " ", "#1"}], "+", 
          RowBox[{"897800", " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"5000", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          RowBox[{"67000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"2500", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"20153621", "+", 
          RowBox[{"5948260", " ", "#1"}], "+", 
          RowBox[{"897800", " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"5000", " ", 
           SuperscriptBox["#1", "3"]}], "+", 
          RowBox[{"67000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"2500", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}], "3"]}], 
    "\[Equal]", "1"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["224", "5"], "+", 
       FractionBox[
        RowBox[{"201", " ", "\[ImaginaryI]"}], "50"]}], ")"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["67", "5"], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "5"]}], ")"}], " ", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"4836501", "-", 
          RowBox[{"2946660", " ", "#1"}], "+", 
          RowBox[{"449800", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"219000", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"67000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"2500", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"4836501", "-", 
          RowBox[{"2946660", " ", "#1"}], "+", 
          RowBox[{"449800", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"219000", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"67000", " ", 
           SuperscriptBox["#1", "4"]}], "+", 
          RowBox[{"2500", " ", 
           SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}], "3"]}], 
    "\[Equal]", "1"}]}], "}"}]], "Output",
 ImageSize->{563, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103156095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9928668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57714879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->701485191],

Cell[TextData[{
 "When there are no solutions, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns an empty list:"
}], "ExampleText",
 CellID->197179996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135207748],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687771575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194510078],

Cell[TextData[{
 "If there are fewer solutions than the requested number, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " returns all solutions:"
}], "ExampleText",
 CellID->20193506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->913648111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55377368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241299727],

Cell[TextData[{
 "To get a complete description of the solution set use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->113262586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "3"}], "+", 
      RowBox[{"2", "z"}]}], "\[LessEqual]", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->288225],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}]}], "&&", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "\[LessEqual]", "z", 
         "\[LessEqual]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}]}]}], ")"}]}], ")"}]}], ")"}], "||", 
  
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{509, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285827178]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38597506],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["c", "b"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{369, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21635964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97701228],

Cell[TextData[{
 "To get a generic solution of a system of complex equations use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17532952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88981606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->642925275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117588378],

Cell["Solving a sum of squares representation problem: ", "ExampleText",
 CellID->67486460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "\[Equal]", "12345678"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198111876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3338"}], ",", 
    RowBox[{"y", "\[Rule]", "1097"}], ",", 
    RowBox[{"z", "\[Rule]", "5"}]}], "}"}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->842018642]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SquaresR",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaresR"]], "InlineFormula"],
 " to find the number of solutions to sum of squares problems:"
}], "ExampleText",
 CellID->335021184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"3", ",", "12345678"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237315054],

Cell[BoxData["24000"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->825789262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119777620],

Cell["Solving a sum of powers representation problem:", "ExampleText",
 CellID->211463965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"y", "^", "3"}], "+", 
      RowBox[{"z", "^", "3"}]}], "==", "1234567"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->685963750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "73"}], ",", 
    RowBox[{"y", "\[Rule]", "73"}], ",", 
    RowBox[{"z", "\[Rule]", "77"}]}], "}"}], "}"}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302773271]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowersRepresentations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFormula"],
 " to enumerate all solutions:"
}], "ExampleText",
 CellID->955119070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"1234567", ",", "3", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85988336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"73", ",", "73", ",", "77"}], "}"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520598042]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25267],

Cell["Integer solutions for a Thue equation:", "ExampleText",
 CellID->406450286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "/.", 
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"x", "^", "3"}], " ", "y"}], "-", 
       RowBox[{
        RowBox[{"x", "^", "2"}], " ", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"4", " ", "x", " ", 
        RowBox[{"y", "^", "3"}]}], "+", 
       RowBox[{"y", "^", "4"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers", ",", "100"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72137826],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttu00AQdeImJWmaNCmUwFP5C+gD8ARPfERUIbUPCFT6z/AXxuN4qRmf
yezM2kpFUynprj1zdm57O+2Xzf3N12+b+9vrzeXnu82Pm9vrn5efvt+Vj/JB
lg1+ZVn2Zp2V7aJsVR/6+V1+ts1t64S+8/C2yCasf8H6R6yv6S8U/ami/3LP
+qn2n+15/L79z+mrhUL9YdldA2l6zqsmyC8FeQn/Vc/yVntWPeOn2s+zN4TZ
I1Tqjtjz0/JrVHY5Cu/zGpLwxpF4z4DVSG9Zj5N3hDfv2L5jIQ4peB77RkKc
vPnQ5BdOv6W6sY6Pq7x6Ovrbr2S2vtPM0dbtIGdD5TNDQo2VO0ejJ+Bp64UV
71iMRgoqj3ks3hhEq4+sLJK8Tq+gdu2jFbk9hrS+8/k3j0LjJwe0m2jvR/Uq
NQZWxerz5x472t5ZUfh6oukHr3msNT1e47NGFO1eYK2YtbHZH1R6cSuldt/g
Y2MU7dSqvX8BUa0o2tlb08eVZ0XRssX1u4kor6znLl+wLdwj7bxn2f8fR/1V
Vhw99J9K7eUtv1PrjmYyOkOikamLbmT/V201K+PprGrN954o8n313OUFziiv
OXSKP9Tc06s5nAvf2QRjxcUF1x/n8OhpXlfcEKy4nBsL8gtBHs0Kkntd/+Yr
syS/NuKf1XYhdgnJLyPxww1uvkv+Ye8rtuf2C4M1eY0+AtHBvC01+V8E7C2t
Xvi8sXLS3FcrJ871U8fft/1967+jL7WCQt3HctKrwsZ5r5z4fdvTlfxVVJQJ
NQerhfUOzjnTmSLv5apPC8wte7n0qaDXNZ7XXwnPy6VLeBMhrlzubRFTVRUf
KHKMXhYY1VQ6C8wZsOa+26WVj8trCdXLVUt46BSH5LZ7gnYzobojl+XTJj3k
dymN2c0FvRkcJYbTbPLKgSG18sS5oOflnXfh+b3UeI8UqxAr/77wrz/ovwV2
2c5txfWg3YymUMt64+TzK1Xfd2PlKNYbp8+KD0VMzsNJBp3PLFkOJwytsquV
7R8u8ZBTas5bcfHlE89hnl2+Y3Dr+O5+khyjw+xF7/3zFufZx0LhtTY9Woec
23Ku3UrCbYPYJ8Qm8bPypJabF3FsFVk9zGSukMs3/5/QIh/L5TXlLfjhjs/j
87GKMjVj+LNs8AfvD7ME\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411343433]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"x", "^", "3"}], " ", "y"}], "-", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"4", " ", "x", " ", 
      RowBox[{"y", "^", "3"}]}], "+", 
     RowBox[{"y", "^", "4"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "pts", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11375971],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxd23dUVcfax/FDVRSRXqWLRhN77MiMisbejb0HYwHsYjfGGLti7xq7Ym+x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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1FV4EAQUBeANGIwYMAbSJV2ClKB0SIOMlkY6NiVEpbu7G6S7pTtFSulO
UTqVjn8fD/+5b+ft3PTNIsMjAgMCAj4RUTca0YlBEDGJRTCxiUNc4hFCfBKQ
kFASEUZikkT1kpRkJCcFKUlFatKQlnSk51MykJFMZCYLWclGdnKQk1x8Rm7y
8Dl5yUd+ClCQLyhEYb7kK4pQlGIUpwQlKUVpylCWrylHeSpQkUpUpgpVqcY3
VCecGtSkFrWpQ13q8S31aUBDGtGYJjSlGd/RnBa0pBWtaUNb2tGeDkQQyff8
QEc60Zku/EhXfuJnfqEb3elBT3rRmz70pR/9GcBABjGYIQxlGMMZwUhGMZox
jGUc45nARCYxmSlMZRrTmcFMZjGbOfzKXOYxnwUsZBGLWcJSlrGcFaxkFatZ
w1rWsZ7f2MBGNrGZLWxlG9vZwU52sZs97GUf+znAQX7nEH9wmCMc5RjH+ZO/
OMFJTnGaM5zlHOe5wEUucZkrXOUa17nBTf7mFv/wL7e5w13ucZ8HPOQRj3nC
U57xH//znBe85BWvecNb3vGeqPEHEo3oxCCImMQimNjEIS7xCCE+CUhIKIkI
IzFJAj/+lQ+JTYJf
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "4"], "-", 
           RowBox[{"4", " ", 
             SuperscriptBox["x", "3"], " ", "y"}], "-", 
           RowBox[{
             SuperscriptBox["x", "2"], " ", 
             SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", "x", " ", 
             SuperscriptBox["y", "3"]}], "+", 
           SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^4 - 
        4 $CellContext`x^3 $CellContext`y - $CellContext`x^2 $CellContext`y^2 + 
        4 $CellContext`x $CellContext`y^3 + $CellContext`y^4 == 1, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl0EWYFQQAhdE3dIOIMDRD1zTdjSggHZIiUtJd0t0gJSkpSiqN0oIKCCgl
3d1dEoePxflXd3VDmnWo0T4oEAhklFQEk5o0pCUd6ckQ9H6TiRAyk4WsZCM7
OchJLnKTh7yEEkY4EUQSRTT5yE8BClKIwhShKMUoTglKUorSlKEs5ShPBSry
MZX4hE+pTBWq8hnVqE4NalKL2tShLvWoz+c0oCGNaEwTmvIFzfiS5nxFC1rS
ita04Wva0o53J3egI53oTBe60o3u9KAnvehNH/ryDf3ozwAGMojBDGEowxjO
CEYyitGMYSzjGM8EJjKJb5nMFKYyjel8xwxmMovZzGEu3zOP+SxgIYtYzA8s
4Ud+YinLWM4KVrKKn/mF1axhLetYzwY2solf+Y3NbGEr29jODnbyO7vYzR/8
yV/sYS/7+Jv9HOAg//AvhzjMEY5yjP84zglOcorTnOEs5zjPBS5yictc4SrX
uM4NbnKL29zhLve4zwMe8ojHPOEpz3jOC17yP694zRsCMQKBIGIQk1jEJg5x
iUd8EpCQRCQmCUlJxgck50NS8BEpSUUwqUlDWtKRngxkJBMhZCYLWclGdnKQ
k1zkJg95CSWMcCKIJIpo8pGftzuBh0M=
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "4"], "-", 
           RowBox[{"4", " ", 
             SuperscriptBox["x", "3"], " ", "y"}], "-", 
           RowBox[{
             SuperscriptBox["x", "2"], " ", 
             SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", "x", " ", 
             SuperscriptBox["y", "3"]}], "+", 
           SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^4 - 
        4 $CellContext`x^3 $CellContext`y - $CellContext`x^2 $CellContext`y^2 + 
        4 $CellContext`x $CellContext`y^3 + $CellContext`y^4 == 1, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeADgQAANDv7HA2yd6bjBzHnTt7j87eOVvcCRGy9957Ftlk711k75W9
MitURqV4P97LHh0bFRMUCASCFRInEChFaUIpQ1nCCKccEURSngpUpBKVqUJV
qlGdGtSkFrWpQ13q8SlR1KcBDWlEY5rQlGY0pwUtaUVrPqMN0bSlHe3pQEc6
0ZkufE5XuhFDLN35gh70pBdf0ps+fEVf+tGfrxnAQAYxmCEMZRjDGcFIRjGa
MYxlHOOZwEQmMZkpTGUa05nBTGYxmznMZR7zWcBCFrGYb/iWJSzlO5axnBWs
ZBWrWcNa1vE969nARjaxmS1sZRvb2cFOdrGbPexlH/s5wEF+4EcOcZifOMJR
jnGcE5zkFKc5w1nOcZ4LXOQSl7nCz1zlGte5wU1ucZs73OUe9/mFBzzkEY95
wlN+5Td+5xnPecEf/MlfvOQVr3nD3/zDv7zlP/7nHYG4gUAQcYhLPOKTgIQk
4gMSk4SkBJOM5KQgJalITRrSko4PSc9HZCAjmchMFrKSjezkICe5yE0e8pKP
/BSgIIUoTBE+pijFKE4JPqEkIZSiNKGUoSxhhFOOCCIpTwXeAzGVhqs=
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "4"], "-", 
           RowBox[{"4", " ", 
             SuperscriptBox["x", "3"], " ", "y"}], "-", 
           RowBox[{
             SuperscriptBox["x", "2"], " ", 
             SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", "x", " ", 
             SuperscriptBox["y", "3"]}], "+", 
           SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^4 - 
        4 $CellContext`x^3 $CellContext`y - $CellContext`x^2 $CellContext`y^2 + 
        4 $CellContext`x $CellContext`y^3 + $CellContext`y^4 == 1, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOAFgYAANAvt7SwjOVlmwt3WZddl22bC1v2UC27Ldu2bdvm+/FeitAO
Ie3DBAKB5CoRLhAoSRDBlKI0ZShLOcpTgYpUojJVCKEq1ahODWpSi9rUoS71
qE8DGtKIxoTShKY0ozktaEkrWtOGtrSjPR3oSCc604WudKM7PehJL3rTh770
oz8DGMggBjOEoQxjOL8xgpGMYjS/8wdjGMs4xjOBiUxiMlOYyjSmM4M/+Yu/
+YeZzGI2/zKHucxjPgtYyCIWs4SlLGM5K1jJf/zPKlazhrWsYz0b2MgmNrOF
rWxjOzvYyS52s4e97GM/BzjIIQ5zhKMc4zgnOMkpTnOGs5zjPBe4yCUuc4Wr
XOM6N7jJLW5zh7vc4z4PeMgjHvOEpzzjOS94ySte84a3vOM9H/jIJz7zha98
IxA+EAhDWMIRnghEJBKR+YEoRCUa0YnBj8QkFrGJw0/EJR7xSUBCEpGYJCQl
GT+TnBSkJBWpSUNafiEd6clARjKRmSxkJRvZyUFOcpGbPOQlH/kpQEEKUZgi
FOVXilGcEpQkiGBKUZoylKUc5alARSpRmSqEUJVqVKcGNalFbepQl3rUpwEN
aURjQvkOJCmPaA==
        "]],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "4"], "-", 
           RowBox[{"4", " ", 
             SuperscriptBox["x", "3"], " ", "y"}], "-", 
           RowBox[{
             SuperscriptBox["x", "2"], " ", 
             SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", "x", " ", 
             SuperscriptBox["y", "3"]}], "+", 
           SuperscriptBox["y", "4"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^4 - 
        4 $CellContext`x^3 $CellContext`y - $CellContext`x^2 $CellContext`y^2 + 
        4 $CellContext`x $CellContext`y^3 + $CellContext`y^4 == 1, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Epilog->{
    PointSize[Large], 
    RGBColor[1, 0, 0], 
    PointBox[{{-8, -7}, {-7, 8}, {-4, -1}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 
     4}, {0, -1}, {0, 1}, {1, -4}, {1, -1}, {1, 0}, {1, 1}, {4, 1}, {7, -8}, {
     8, 7}}]},
  Frame->True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185677212]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26545],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowersRepresentations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowersRepresentations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SemialgebraicComponentInstances",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SemialgebraicComponentInstances"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChineseRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChineseRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13755],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/Inequalities-ManipulatingEquationsAndInequalities"]], \
"Tutorials",
 CellID->2347],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->17036],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->45946144],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->45622949],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->915101512],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->136633635],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->293910965],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->633298362],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->55252993],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->715684903]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindInstance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 56.5933560}", "context" -> "System`", 
    "keywords" -> {
     "Boolean satisfiability", "counter-example", "counter example", 
      "sample points", "satisfiability", "SAT problem", "witnesses"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FindInstance[expr, vars] finds an instance of vars that makes the \
statement expr be True. FindInstance[expr, vars, dom] finds an instance over \
the domain dom. Common choices of dom are Complexes, Reals, Integers and \
Booleans. FindInstance[expr, vars, dom, n] finds n instances. ", 
    "synonyms" -> {"find instance"}, "title" -> "FindInstance", "type" -> 
    "Symbol", "uri" -> "ref/FindInstance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14217, 462, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->877260518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 180206, 6221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4364, 92, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4987, 119, 49, 1, 70, "ObjectName",
 CellID->1369],
Cell[5039, 122, 2500, 82, 70, "Usage",
 CellID->13016]
}, Open  ]],
Cell[CellGroupData[{
Cell[7576, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8054, 226, 1268, 47, 70, "Notes",
 CellID->24473],
Cell[9325, 275, 331, 11, 70, "Notes",
 CellID->7369],
Cell[9659, 288, 229, 8, 70, "Notes",
 CellID->12626],
Cell[9891, 298, 279, 8, 70, "Notes",
 CellID->3104],
Cell[10173, 308, 273, 8, 70, "Notes",
 CellID->31848],
Cell[10449, 318, 405, 12, 70, "Notes",
 CellID->2982],
Cell[10857, 332, 418, 14, 70, "Notes",
 CellID->22294],
Cell[11278, 348, 477, 17, 70, "Notes",
 CellID->31997],
Cell[11758, 367, 1075, 38, 70, "Notes",
 CellID->22426],
Cell[12836, 407, 369, 12, 70, "Notes",
 CellID->29690],
Cell[13208, 421, 251, 8, 70, "Notes",
 CellID->9890],
Cell[13462, 431, 230, 7, 70, "Notes",
 CellID->1539474642],
Cell[13695, 440, 485, 17, 70, "Notes",
 CellID->700119403]
}, Closed]],
Cell[CellGroupData[{
Cell[14217, 462, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->877260518],
Cell[CellGroupData[{
Cell[14602, 476, 148, 5, 70, "ExampleSection",
 CellID->119623764],
Cell[14753, 483, 93, 1, 70, "ExampleText",
 CellID->716395631],
Cell[CellGroupData[{
Cell[14871, 488, 517, 18, 28, "Input",
 CellID->47420189],
Cell[15391, 508, 667, 24, 60, "Output",
 CellID->273233923]
}, Open  ]],
Cell[16073, 535, 125, 3, 70, "ExampleDelimiter",
 CellID->155775989],
Cell[16201, 540, 123, 3, 70, "ExampleText",
 CellID->744297667],
Cell[CellGroupData[{
Cell[16349, 547, 548, 19, 70, "Input",
 CellID->60662809],
Cell[16900, 568, 449, 16, 51, "Output",
 CellID->97791527]
}, Open  ]],
Cell[17364, 587, 125, 3, 70, "ExampleDelimiter",
 CellID->657484086],
Cell[17492, 592, 77, 1, 70, "ExampleText",
 CellID->471405922],
Cell[CellGroupData[{
Cell[17594, 597, 394, 13, 70, "Input",
 CellID->56462758],
Cell[17991, 612, 291, 10, 36, "Output",
 CellID->40462698]
}, Open  ]],
Cell[18297, 625, 125, 3, 70, "ExampleDelimiter",
 CellID->119382377],
Cell[18425, 630, 98, 1, 70, "ExampleText",
 CellID->19885214],
Cell[CellGroupData[{
Cell[18548, 635, 460, 15, 70, "Input",
 CellID->369927311],
Cell[19011, 652, 387, 12, 36, "Output",
 CellID->373930031]
}, Open  ]],
Cell[19413, 667, 124, 3, 70, "ExampleDelimiter",
 CellID->50909694],
Cell[19540, 672, 66, 1, 70, "ExampleText",
 CellID->158756807],
Cell[CellGroupData[{
Cell[19631, 677, 408, 14, 70, "Input",
 CellID->53845729],
Cell[20042, 693, 561, 19, 36, "Output",
 CellID->357127367]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20652, 718, 217, 7, 70, "ExampleSection",
 CellID->22751],
Cell[CellGroupData[{
Cell[20894, 729, 234, 7, 70, "ExampleSubsection",
 CellID->84922610],
Cell[21131, 738, 59, 1, 70, "ExampleText",
 CellID->149821829],
Cell[CellGroupData[{
Cell[21215, 743, 482, 17, 70, "Input",
 CellID->284710479],
Cell[21700, 762, 333, 11, 36, "Output",
 CellID->282261468]
}, Open  ]],
Cell[22048, 776, 125, 3, 70, "ExampleDelimiter",
 CellID->253504289],
Cell[22176, 781, 75, 1, 70, "ExampleText",
 CellID->64844045],
Cell[CellGroupData[{
Cell[22276, 786, 247, 9, 70, "Input",
 CellID->672643237],
Cell[22526, 797, 231, 8, 36, "Output",
 CellID->6354720]
}, Open  ]],
Cell[22772, 808, 124, 3, 70, "ExampleDelimiter",
 CellID->77578128],
Cell[22899, 813, 78, 1, 70, "ExampleText",
 CellID->169862198],
Cell[CellGroupData[{
Cell[23002, 818, 298, 10, 70, "Input",
 CellID->288610958],
Cell[23303, 830, 352, 12, 36, "Output",
 CellID->212850548]
}, Open  ]],
Cell[23670, 845, 124, 3, 70, "ExampleDelimiter",
 CellID->91534336],
Cell[23797, 850, 91, 1, 70, "ExampleText",
 CellID->899471838],
Cell[CellGroupData[{
Cell[23913, 855, 537, 18, 70, "Input",
 CellID->145589199],
Cell[24453, 875, 826, 28, 51, "Output",
 CellID->83429579]
}, Open  ]],
Cell[25294, 906, 79, 1, 70, "ExampleText",
 CellID->141271131],
Cell[CellGroupData[{
Cell[25398, 911, 547, 18, 70, "Input",
 CellID->101797570],
Cell[25948, 931, 4911, 139, 302, "Output",
 CellID->47494914]
}, Open  ]],
Cell[30874, 1073, 238, 8, 70, "ExampleText",
 CellID->71540266],
Cell[CellGroupData[{
Cell[31137, 1085, 471, 16, 70, "Input",
 CellID->610369292],
Cell[31611, 1103, 175, 6, 36, "Output",
 CellID->133087817]
}, Open  ]],
Cell[31801, 1112, 268, 8, 70, "ExampleText",
 CellID->11427598],
Cell[CellGroupData[{
Cell[32094, 1124, 406, 14, 70, "Input",
 CellID->99533921],
Cell[32503, 1140, 526, 19, 51, "Output",
 CellID->414554565]
}, Open  ]],
Cell[33044, 1162, 125, 3, 70, "ExampleDelimiter",
 CellID->644436505],
Cell[33172, 1167, 72, 1, 70, "ExampleText",
 CellID->159443640],
Cell[CellGroupData[{
Cell[33269, 1172, 632, 21, 70, "Input",
 CellID->208385592],
Cell[33904, 1195, 290, 10, 36, "Output",
 CellID->502355828]
}, Open  ]],
Cell[34209, 1208, 125, 3, 70, "ExampleDelimiter",
 CellID->700158465],
Cell[34337, 1213, 63, 1, 70, "ExampleText",
 CellID->546492545],
Cell[CellGroupData[{
Cell[34425, 1218, 545, 19, 70, "Input",
 CellID->31277144],
Cell[34973, 1239, 2387, 43, 70, "Output",
 Evaluatable->False,
 CellID->345377184]
}, Open  ]],
Cell[37375, 1285, 123, 3, 70, "ExampleDelimiter",
 CellID->1314432],
Cell[37501, 1290, 68, 1, 70, "ExampleText",
 CellID->288893094],
Cell[CellGroupData[{
Cell[37594, 1295, 219, 7, 70, "Input",
 CellID->256538498],
Cell[37816, 1304, 350, 12, 51, "Output",
 CellID->32007133]
}, Open  ]],
Cell[CellGroupData[{
Cell[38203, 1321, 295, 11, 70, "Input",
 CellID->34551955],
Cell[38501, 1334, 650, 22, 62, "Output",
 CellID->275662377]
}, Open  ]],
Cell[39166, 1359, 77, 1, 70, "ExampleText",
 CellID->101603241],
Cell[CellGroupData[{
Cell[39268, 1364, 290, 10, 70, "Input",
 CellID->474067602],
Cell[39561, 1376, 173, 6, 36, "Output",
 CellID->3877987]
}, Open  ]],
Cell[39749, 1385, 125, 3, 70, "ExampleDelimiter",
 CellID->385408181],
Cell[39877, 1390, 80, 1, 70, "ExampleText",
 CellID->331511400],
Cell[CellGroupData[{
Cell[39982, 1395, 407, 14, 70, "Input",
 CellID->67423421],
Cell[40392, 1411, 1621, 50, 98, "Output",
 CellID->58734470]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42062, 1467, 232, 7, 70, "ExampleSubsection",
 CellID->57305448],
Cell[42297, 1476, 59, 1, 70, "ExampleText",
 CellID->787469300],
Cell[CellGroupData[{
Cell[42381, 1481, 496, 18, 70, "Input",
 CellID->9250850],
Cell[42880, 1501, 455, 16, 51, "Output",
 CellID->541887086]
}, Open  ]],
Cell[43350, 1520, 125, 3, 70, "ExampleDelimiter",
 CellID->114190875],
Cell[43478, 1525, 75, 1, 70, "ExampleText",
 CellID->81649366],
Cell[CellGroupData[{
Cell[43578, 1530, 262, 9, 70, "Input",
 CellID->193942569],
Cell[43843, 1541, 232, 8, 36, "Output",
 CellID->55097111]
}, Open  ]],
Cell[44090, 1552, 125, 3, 70, "ExampleDelimiter",
 CellID->489808851],
Cell[44218, 1557, 78, 1, 70, "ExampleText",
 CellID->292696808],
Cell[CellGroupData[{
Cell[44321, 1562, 253, 9, 70, "Input",
 CellID->76644507],
Cell[44577, 1573, 252, 9, 36, "Output",
 CellID->97125767]
}, Open  ]],
Cell[44844, 1585, 124, 3, 70, "ExampleDelimiter",
 CellID->97040171],
Cell[44971, 1590, 78, 1, 70, "ExampleText",
 CellID->630117658],
Cell[CellGroupData[{
Cell[45074, 1595, 314, 11, 70, "Input",
 CellID->758827168],
Cell[45391, 1608, 352, 12, 36, "Output",
 CellID->116723702]
}, Open  ]],
Cell[45758, 1623, 125, 3, 70, "ExampleDelimiter",
 CellID->354625005],
Cell[45886, 1628, 79, 1, 70, "ExampleText",
 CellID->14844610],
Cell[CellGroupData[{
Cell[45990, 1633, 357, 12, 70, "Input",
 CellID->223254230],
Cell[46350, 1647, 355, 12, 51, "Output",
 CellID->331258457]
}, Open  ]],
Cell[46720, 1662, 125, 3, 70, "ExampleDelimiter",
 CellID->389602569],
Cell[46848, 1667, 92, 1, 70, "ExampleText",
 CellID->375009844],
Cell[CellGroupData[{
Cell[46965, 1672, 546, 19, 70, "Input",
 CellID->91668569],
Cell[47514, 1693, 389, 14, 43, "Output",
 CellID->176204735]
}, Open  ]],
Cell[47918, 1710, 70, 1, 70, "ExampleText",
 CellID->87176738],
Cell[CellGroupData[{
Cell[48013, 1715, 558, 19, 70, "Input",
 CellID->314416047],
Cell[48574, 1736, 1091, 37, 73, "Output",
 CellID->200367419]
}, Open  ]],
Cell[49680, 1776, 239, 8, 70, "ExampleText",
 CellID->145489344],
Cell[CellGroupData[{
Cell[49944, 1788, 492, 16, 70, "Input",
 CellID->157970443],
Cell[50439, 1806, 174, 6, 36, "Output",
 CellID->23499800]
}, Open  ]],
Cell[50628, 1815, 269, 8, 70, "ExampleText",
 CellID->330130352],
Cell[CellGroupData[{
Cell[50922, 1827, 423, 15, 70, "Input",
 CellID->255143945],
Cell[51348, 1844, 526, 19, 51, "Output",
 CellID->954609793]
}, Open  ]],
Cell[51889, 1866, 124, 3, 70, "ExampleDelimiter",
 CellID->69923244],
Cell[52016, 1871, 74, 1, 70, "ExampleText",
 CellID->356535914],
Cell[CellGroupData[{
Cell[52115, 1876, 602, 19, 70, "Input",
 CellID->236241633],
Cell[52720, 1897, 312, 11, 36, "Output",
 CellID->590648375]
}, Open  ]],
Cell[53047, 1911, 125, 3, 70, "ExampleDelimiter",
 CellID->125859915],
Cell[53175, 1916, 62, 1, 70, "ExampleText",
 CellID->15168201],
Cell[CellGroupData[{
Cell[53262, 1921, 567, 19, 70, "Input",
 CellID->126906310],
Cell[53832, 1942, 311, 11, 36, "Output",
 CellID->267095123]
}, Open  ]],
Cell[54158, 1956, 125, 3, 70, "ExampleDelimiter",
 CellID->141393736],
Cell[54286, 1961, 63, 1, 70, "ExampleText",
 CellID->309755201],
Cell[CellGroupData[{
Cell[54374, 1966, 496, 17, 70, "Input",
 CellID->6175762],
Cell[54873, 1985, 253, 9, 36, "Output",
 CellID->151244969]
}, Open  ]],
Cell[CellGroupData[{
Cell[55163, 1999, 453, 15, 70, "Input",
 CellID->327866928],
Cell[55619, 2016, 290, 10, 36, "Output",
 CellID->109959786]
}, Open  ]],
Cell[55924, 2029, 125, 3, 70, "ExampleDelimiter",
 CellID->233833830],
Cell[56052, 2034, 66, 1, 70, "ExampleText",
 CellID->619582499],
Cell[CellGroupData[{
Cell[56143, 2039, 397, 14, 70, "Input",
 CellID->712190582],
Cell[56543, 2055, 233, 8, 36, "Output",
 CellID->204639737]
}, Open  ]],
Cell[CellGroupData[{
Cell[56813, 2068, 336, 11, 70, "Input",
 CellID->74944114],
Cell[57152, 2081, 253, 9, 36, "Output",
 CellID->433487293]
}, Open  ]],
Cell[57420, 2093, 124, 3, 70, "ExampleDelimiter",
 CellID->22193703],
Cell[57547, 2098, 68, 1, 70, "ExampleText",
 CellID->178378100],
Cell[CellGroupData[{
Cell[57640, 2103, 230, 8, 70, "Input",
 CellID->32163487],
Cell[57873, 2113, 468, 17, 52, "Output",
 CellID->497443772]
}, Open  ]],
Cell[CellGroupData[{
Cell[58378, 2135, 385, 14, 70, "Input",
 CellID->849204275],
Cell[58766, 2151, 673, 24, 71, "Output",
 CellID->178402686]
}, Open  ]],
Cell[59454, 2178, 124, 3, 70, "ExampleDelimiter",
 CellID->53285106],
Cell[59581, 2183, 71, 1, 70, "ExampleText",
 CellID->245801814],
Cell[CellGroupData[{
Cell[59677, 2188, 261, 8, 70, "Input",
 CellID->285456402],
Cell[59941, 2198, 265, 9, 51, "Output",
 CellID->762544468]
}, Open  ]],
Cell[CellGroupData[{
Cell[60243, 2212, 368, 13, 70, "Input",
 CellID->44025090],
Cell[60614, 2227, 257, 9, 51, "Output",
 CellID->98232480]
}, Open  ]],
Cell[60886, 2239, 125, 3, 70, "ExampleDelimiter",
 CellID->147547389],
Cell[61014, 2244, 66, 1, 70, "ExampleText",
 CellID->202401352],
Cell[CellGroupData[{
Cell[61105, 2249, 419, 14, 70, "Input",
 CellID->31650260],
Cell[61527, 2265, 347, 12, 51, "Output",
 CellID->91637503]
}, Open  ]],
Cell[CellGroupData[{
Cell[61911, 2282, 520, 18, 70, "Input",
 CellID->942160119],
Cell[62434, 2302, 409, 14, 53, "Output",
 CellID->43975695]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62892, 2322, 236, 7, 70, "ExampleSubsection",
 CellID->247179601],
Cell[63131, 2331, 71, 1, 70, "ExampleText",
 CellID->91649387],
Cell[CellGroupData[{
Cell[63227, 2336, 501, 18, 70, "Input",
 CellID->31436120],
Cell[63731, 2356, 333, 11, 36, "Output",
 CellID->164301253]
}, Open  ]],
Cell[64079, 2370, 124, 3, 70, "ExampleDelimiter",
 CellID->56626870],
Cell[64206, 2375, 89, 1, 70, "ExampleText",
 CellID->610547063],
Cell[CellGroupData[{
Cell[64320, 2380, 554, 20, 70, "Input",
 CellID->336458608],
Cell[64877, 2402, 351, 12, 36, "Output",
 CellID->20556135]
}, Open  ]],
Cell[65243, 2417, 70, 1, 70, "ExampleText",
 CellID->19084496],
Cell[CellGroupData[{
Cell[65338, 2422, 564, 20, 70, "Input",
 CellID->775889221],
Cell[65905, 2444, 1146, 38, 54, "Output",
 CellID->42915109]
}, Open  ]],
Cell[67066, 2485, 124, 3, 70, "ExampleDelimiter",
 CellID->20516472],
Cell[67193, 2490, 75, 1, 70, "ExampleText",
 CellID->68329701],
Cell[CellGroupData[{
Cell[67293, 2495, 297, 10, 70, "Input",
 CellID->626380406],
Cell[67593, 2507, 231, 8, 36, "Output",
 CellID->2675611]
}, Open  ]],
Cell[67839, 2518, 125, 3, 70, "ExampleDelimiter",
 CellID->327203451],
Cell[67967, 2523, 78, 1, 70, "ExampleText",
 CellID->292309597],
Cell[CellGroupData[{
Cell[68070, 2528, 256, 9, 70, "Input",
 CellID->50212146],
Cell[68329, 2539, 253, 9, 36, "Output",
 CellID->715389604]
}, Open  ]],
Cell[68597, 2551, 125, 3, 70, "ExampleDelimiter",
 CellID->487716768],
Cell[68725, 2556, 70, 1, 70, "ExampleText",
 CellID->149610693],
Cell[CellGroupData[{
Cell[68820, 2561, 343, 11, 70, "Input",
 CellID->408955322],
Cell[69166, 2574, 330, 12, 36, "Output",
 CellID->1130744]
}, Open  ]],
Cell[CellGroupData[{
Cell[69533, 2591, 418, 14, 70, "Input",
 CellID->78572943],
Cell[69954, 2607, 290, 10, 36, "Output",
 CellID->198565412]
}, Open  ]],
Cell[CellGroupData[{
Cell[70281, 2622, 414, 13, 70, "Input",
 CellID->157947200],
Cell[70698, 2637, 332, 12, 36, "Output",
 CellID->242054236]
}, Open  ]],
Cell[71045, 2652, 125, 3, 70, "ExampleDelimiter",
 CellID->160308141],
Cell[71173, 2657, 59, 1, 70, "ExampleText",
 CellID->146235021],
Cell[CellGroupData[{
Cell[71257, 2662, 373, 12, 70, "Input",
 CellID->264134555],
Cell[71633, 2676, 311, 11, 36, "Output",
 CellID->104225144]
}, Open  ]],
Cell[71959, 2690, 269, 8, 70, "ExampleText",
 CellID->185756456],
Cell[CellGroupData[{
Cell[72253, 2702, 386, 13, 70, "Input",
 CellID->657467191],
Cell[72642, 2717, 451, 16, 36, "Output",
 CellID->72315633]
}, Open  ]],
Cell[73108, 2736, 125, 3, 70, "ExampleDelimiter",
 CellID->140799112],
Cell[73236, 2741, 69, 1, 70, "ExampleText",
 CellID->297997273],
Cell[CellGroupData[{
Cell[73330, 2746, 408, 13, 70, "Input",
 CellID->454294297],
Cell[73741, 2761, 404, 13, 36, "Output",
 CellID->34911099]
}, Open  ]],
Cell[74160, 2777, 125, 3, 70, "ExampleDelimiter",
 CellID->146400772],
Cell[74288, 2782, 68, 1, 70, "ExampleText",
 CellID->756311395],
Cell[CellGroupData[{
Cell[74381, 2787, 420, 14, 70, "Input",
 CellID->242404353],
Cell[74804, 2803, 339, 11, 36, "Output",
 CellID->297315477]
}, Open  ]],
Cell[75158, 2817, 124, 3, 70, "ExampleDelimiter",
 CellID->11130723],
Cell[75285, 2822, 90, 1, 70, "ExampleText",
 CellID->502130737],
Cell[CellGroupData[{
Cell[75400, 2827, 513, 17, 70, "Input",
 CellID->572071652],
Cell[75916, 2846, 352, 12, 36, "Output",
 CellID->233599594]
}, Open  ]],
Cell[76283, 2861, 125, 3, 70, "ExampleDelimiter",
 CellID->336612686],
Cell[76411, 2866, 80, 1, 70, "ExampleText",
 CellID->90785482],
Cell[CellGroupData[{
Cell[76516, 2871, 419, 14, 70, "Input",
 CellID->15565691],
Cell[76938, 2887, 175, 6, 36, "Output",
 CellID->488841442]
}, Open  ]],
Cell[77128, 2896, 125, 3, 70, "ExampleDelimiter",
 CellID->311367224],
Cell[77256, 2901, 78, 1, 70, "ExampleText",
 CellID->357909727],
Cell[CellGroupData[{
Cell[77359, 2906, 434, 14, 70, "Input",
 CellID->114962634],
Cell[77796, 2922, 290, 10, 36, "Output",
 CellID->131562904]
}, Open  ]],
Cell[CellGroupData[{
Cell[78123, 2937, 583, 19, 70, "Input",
 CellID->602714198],
Cell[78709, 2958, 289, 10, 36, "Output",
 CellID->64917898]
}, Open  ]],
Cell[79013, 2971, 125, 3, 70, "ExampleDelimiter",
 CellID->731201360],
Cell[79141, 2976, 76, 1, 70, "ExampleText",
 CellID->4884468],
Cell[CellGroupData[{
Cell[79242, 2981, 549, 19, 70, "Input",
 CellID->146539654],
Cell[79794, 3002, 290, 10, 36, "Output",
 CellID->405729530]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80133, 3018, 236, 7, 70, "ExampleSubsection",
 CellID->208071237],
Cell[80372, 3027, 58, 1, 70, "ExampleText",
 CellID->75271447],
Cell[CellGroupData[{
Cell[80455, 3032, 529, 18, 70, "Input",
 CellID->154699585],
Cell[80987, 3052, 332, 11, 36, "Output",
 CellID->147333785]
}, Open  ]],
Cell[81334, 3066, 124, 3, 70, "ExampleDelimiter",
 CellID->21536370],
Cell[81461, 3071, 75, 1, 70, "ExampleText",
 CellID->60093961],
Cell[CellGroupData[{
Cell[81561, 3076, 289, 9, 70, "Input",
 CellID->55991068],
Cell[81853, 3087, 233, 8, 36, "Output",
 CellID->247244805]
}, Open  ]],
Cell[82101, 3098, 125, 3, 70, "ExampleDelimiter",
 CellID->332381957],
Cell[82229, 3103, 78, 1, 70, "ExampleText",
 CellID->210277461],
Cell[CellGroupData[{
Cell[82332, 3108, 342, 11, 70, "Input",
 CellID->7784294],
Cell[82677, 3121, 330, 11, 36, "Output",
 CellID->43063586]
}, Open  ]],
Cell[83022, 3135, 64, 1, 70, "ExampleText",
 CellID->432349166],
Cell[CellGroupData[{
Cell[83111, 3140, 354, 11, 70, "Input",
 CellID->373952145],
Cell[83468, 3153, 1338, 42, 54, "Output",
 CellID->40729985]
}, Open  ]],
Cell[84821, 3198, 124, 3, 70, "ExampleDelimiter",
 CellID->82067436],
Cell[84948, 3203, 92, 1, 70, "ExampleText",
 CellID->276046792],
Cell[CellGroupData[{
Cell[85065, 3208, 583, 19, 70, "Input",
 CellID->221242426],
Cell[85651, 3229, 331, 11, 36, "Output",
 CellID->627583521]
}, Open  ]],
Cell[85997, 3243, 125, 3, 70, "ExampleDelimiter",
 CellID->651713204],
Cell[86125, 3248, 74, 1, 70, "ExampleText",
 CellID->453041102],
Cell[CellGroupData[{
Cell[86224, 3253, 644, 20, 70, "Input",
 CellID->646939176],
Cell[86871, 3275, 290, 10, 36, "Output",
 CellID->143308637]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87210, 3291, 234, 7, 70, "ExampleSubsection",
 CellID->247230330],
Cell[87447, 3300, 76, 1, 70, "ExampleText",
 CellID->371793992],
Cell[CellGroupData[{
Cell[87548, 3305, 404, 14, 70, "Input",
 CellID->730229669],
Cell[87955, 3321, 365, 14, 43, "Output",
 CellID->9938738]
}, Open  ]],
Cell[88335, 3338, 125, 3, 70, "ExampleDelimiter",
 CellID->740254980],
Cell[88463, 3343, 509, 19, 70, "ExampleText",
 CellID->399380530],
Cell[CellGroupData[{
Cell[88997, 3366, 419, 14, 70, "Input",
 CellID->67018416],
Cell[89419, 3382, 351, 13, 36, "Output",
 CellID->12811953]
}, Open  ]],
Cell[89785, 3398, 125, 3, 70, "ExampleDelimiter",
 CellID->195936302],
Cell[89913, 3403, 248, 10, 70, "ExampleText",
 CellID->372916470],
Cell[CellGroupData[{
Cell[90186, 3417, 496, 17, 70, "Input",
 CellID->363312606],
Cell[90685, 3436, 1061, 39, 81, "Output",
 CellID->236208900]
}, Open  ]],
Cell[CellGroupData[{
Cell[91783, 3480, 854, 28, 70, "Input",
 CellID->223555947],
Cell[92640, 3510, 5592, 96, 70, "Output",
 Evaluatable->False,
 CellID->10781029]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98293, 3613, 217, 7, 70, "ExampleSection",
 CellID->8448],
Cell[CellGroupData[{
Cell[98535, 3624, 224, 7, 70, "ExampleSubsection",
 CellID->20097],
Cell[98762, 3633, 86, 1, 70, "ExampleText",
 CellID->487344474],
Cell[CellGroupData[{
Cell[98873, 3638, 581, 20, 70, "Input",
 CellID->260171957],
Cell[99457, 3660, 290, 10, 36, "Output",
 CellID->194567626]
}, Open  ]],
Cell[99762, 3673, 64, 1, 70, "ExampleText",
 CellID->337393461],
Cell[CellGroupData[{
Cell[99851, 3678, 591, 20, 70, "Input",
 CellID->654738560],
Cell[100445, 3700, 553, 19, 36, "Output",
 CellID->108984667]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101047, 3725, 227, 7, 70, "ExampleSubsection",
 CellID->27277],
Cell[101277, 3734, 124, 3, 70, "ExampleText",
 CellID->1017383031],
Cell[CellGroupData[{
Cell[101426, 3741, 302, 10, 70, "Input",
 CellID->217646610],
Cell[101731, 3753, 875, 32, 56, "Output",
 CellID->518613453]
}, Open  ]],
Cell[102621, 3788, 240, 8, 70, "ExampleText",
 CellID->521806113],
Cell[CellGroupData[{
Cell[102886, 3800, 302, 10, 70, "Input",
 CellID->301039185],
Cell[103191, 3812, 875, 32, 56, "Output",
 CellID->110352182]
}, Open  ]],
Cell[104081, 3847, 291, 10, 70, "ExampleText",
 CellID->155242055],
Cell[CellGroupData[{
Cell[104397, 3861, 351, 11, 70, "Input",
 CellID->142016753],
Cell[104751, 3874, 739, 26, 56, "Output",
 CellID->101524656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105539, 3906, 232, 7, 70, "ExampleSubsection",
 CellID->9392],
Cell[105774, 3915, 144, 4, 70, "ExampleText",
 CellID->777105701],
Cell[CellGroupData[{
Cell[105943, 3923, 786, 26, 70, "Input",
 CellID->5143605],
Cell[106732, 3951, 164, 5, 36, "Output",
 CellID->25357212]
}, Open  ]],
Cell[106911, 3959, 386, 13, 70, "ExampleText",
 CellID->45947561],
Cell[CellGroupData[{
Cell[107322, 3976, 787, 26, 70, "Input",
 CellID->351142723],
Cell[108112, 4004, 879, 24, 139, "Output",
 CellID->42111380]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[109052, 4035, 223, 7, 70, "ExampleSection",
 CellID->27199],
Cell[109278, 4044, 91, 1, 70, "ExampleText",
 CellID->159363089],
Cell[CellGroupData[{
Cell[109394, 4049, 627, 22, 70, "Input",
 CellID->646668107],
Cell[110024, 4073, 271, 10, 51, "Output",
 CellID->249079449]
}, Open  ]],
Cell[110310, 4086, 1379, 45, 70, "Input",
 CellID->524903287],
Cell[CellGroupData[{
Cell[111714, 4135, 346, 11, 70, "Input",
 CellID->537194858],
Cell[112063, 4148, 4258, 74, 70, "Output",
 Evaluatable->False,
 CellID->16626739]
}, Open  ]],
Cell[116336, 4225, 125, 3, 70, "ExampleDelimiter",
 CellID->215876008],
Cell[116464, 4230, 91, 1, 70, "ExampleText",
 CellID->202110312],
Cell[116558, 4233, 1577, 55, 70, "Input",
 CellID->186965933],
Cell[CellGroupData[{
Cell[118160, 4292, 272, 9, 70, "Input",
 CellID->244596046],
Cell[118435, 4303, 378, 13, 51, "Output",
 CellID->47444716]
}, Open  ]],
Cell[118828, 4319, 90, 1, 70, "ExampleText",
 CellID->48249174],
Cell[118921, 4322, 542, 20, 70, "Input",
 CellID->27660955],
Cell[CellGroupData[{
Cell[119488, 4346, 286, 9, 70, "Input",
 CellID->90216989],
Cell[119777, 4357, 175, 6, 36, "Output",
 CellID->553346400]
}, Open  ]],
Cell[119967, 4366, 125, 3, 70, "ExampleDelimiter",
 CellID->151317666],
Cell[120095, 4371, 81, 1, 70, "ExampleText",
 CellID->138659453],
Cell[120179, 4374, 948, 33, 70, "Input",
 CellID->3979005],
Cell[CellGroupData[{
Cell[121152, 4411, 237, 8, 70, "Input",
 CellID->554407093],
Cell[121392, 4421, 175, 6, 36, "Output",
 CellID->608662459]
}, Open  ]],
Cell[121582, 4430, 225, 8, 70, "ExampleText",
 CellID->231647836],
Cell[CellGroupData[{
Cell[121832, 4442, 116, 3, 70, "Input",
 CellID->76307263],
Cell[121951, 4447, 161, 5, 36, "Output",
 CellID->987615913]
}, Open  ]],
Cell[122127, 4455, 125, 3, 70, "ExampleDelimiter",
 CellID->109267876],
Cell[122255, 4460, 114, 3, 70, "ExampleText",
 CellID->236363576],
Cell[122372, 4465, 950, 33, 70, "Input",
 CellID->835966022],
Cell[CellGroupData[{
Cell[123347, 4502, 236, 8, 70, "Input",
 CellID->56694323],
Cell[123586, 4512, 341, 11, 36, "Output",
 CellID->281106000]
}, Open  ]],
Cell[123942, 4526, 123, 3, 70, "ExampleDelimiter",
 CellID->2129827],
Cell[124068, 4531, 65, 1, 70, "ExampleText",
 CellID->23509],
Cell[CellGroupData[{
Cell[124158, 4536, 384, 13, 70, "Input",
 CellID->3556],
Cell[124545, 4551, 290, 10, 36, "Output",
 CellID->717517003]
}, Open  ]],
Cell[124850, 4564, 80, 1, 70, "ExampleText",
 CellID->20713],
Cell[CellGroupData[{
Cell[124955, 4569, 546, 18, 70, "Input",
 CellID->2619],
Cell[125504, 4589, 3277, 107, 105, "Output",
 CellID->266303377]
}, Open  ]],
Cell[128796, 4699, 182, 7, 70, "ExampleText",
 CellID->11955],
Cell[CellGroupData[{
Cell[129003, 4710, 561, 19, 70, "Input",
 CellID->7560],
Cell[129567, 4731, 3435, 112, 122, "Output",
 CellID->370990837]
}, Open  ]],
Cell[133017, 4846, 121, 3, 70, "ExampleDelimiter",
 CellID->16699],
Cell[133141, 4851, 120, 3, 70, "ExampleText",
 CellID->27971],
Cell[CellGroupData[{
Cell[133286, 4858, 495, 16, 70, "Input",
 CellID->23829],
Cell[133784, 4876, 174, 6, 36, "Output",
 CellID->97777991]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[134007, 4888, 233, 7, 70, "ExampleSection",
 CellID->19271],
Cell[134243, 4897, 87, 1, 70, "ExampleText",
 CellID->232066281],
Cell[134333, 4900, 441, 15, 70, "Input",
 CellID->224463781],
Cell[CellGroupData[{
Cell[134799, 4919, 237, 7, 70, "Input",
 CellID->444564614],
Cell[135039, 4928, 281, 9, 36, "Output",
 CellID->82191559]
}, Open  ]],
Cell[135335, 4940, 125, 3, 70, "ExampleDelimiter",
 CellID->137788344],
Cell[135463, 4945, 241, 8, 70, "ExampleText",
 CellID->441087945],
Cell[135707, 4955, 264, 9, 70, "Input",
 CellID->409625579],
Cell[CellGroupData[{
Cell[135996, 4968, 227, 7, 70, "Input",
 CellID->664477226],
Cell[136226, 4977, 2909, 87, 160, "Output",
 CellID->103156095]
}, Open  ]],
Cell[CellGroupData[{
Cell[139172, 5069, 104, 3, 70, "Input",
 CellID->9928668],
Cell[139279, 5074, 208, 7, 36, "Output",
 CellID->57714879]
}, Open  ]],
Cell[139502, 5084, 125, 3, 70, "ExampleDelimiter",
 CellID->701485191],
Cell[139630, 5089, 242, 8, 70, "ExampleText",
 CellID->197179996],
Cell[CellGroupData[{
Cell[139897, 5101, 295, 10, 70, "Input",
 CellID->135207748],
Cell[140195, 5113, 175, 6, 36, "Output",
 CellID->687771575]
}, Open  ]],
Cell[140385, 5122, 125, 3, 70, "ExampleDelimiter",
 CellID->194510078],
Cell[140513, 5127, 268, 8, 70, "ExampleText",
 CellID->20193506],
Cell[CellGroupData[{
Cell[140806, 5139, 227, 8, 70, "Input",
 CellID->913648111],
Cell[141036, 5149, 334, 12, 36, "Output",
 CellID->55377368]
}, Open  ]],
Cell[141385, 5164, 125, 3, 70, "ExampleDelimiter",
 CellID->241299727],
Cell[141513, 5169, 233, 8, 70, "ExampleText",
 CellID->113262586],
Cell[CellGroupData[{
Cell[141771, 5181, 523, 18, 70, "Input",
 CellID->288225],
Cell[142297, 5201, 2095, 70, 116, "Output",
 CellID->285827178]
}, Open  ]],
Cell[CellGroupData[{
Cell[144429, 5276, 272, 10, 70, "Input",
 CellID->38597506],
Cell[144704, 5288, 1222, 41, 100, "Output",
 CellID->21635964]
}, Open  ]],
Cell[145941, 5332, 124, 3, 70, "ExampleDelimiter",
 CellID->97701228],
Cell[146068, 5337, 239, 8, 70, "ExampleText",
 CellID->17532952],
Cell[CellGroupData[{
Cell[146332, 5349, 271, 10, 70, "Input",
 CellID->88981606],
Cell[146606, 5361, 750, 27, 62, "Output",
 CellID->642925275]
}, Open  ]],
Cell[147371, 5391, 125, 3, 70, "ExampleDelimiter",
 CellID->117588378],
Cell[147499, 5396, 91, 1, 70, "ExampleText",
 CellID->67486460],
Cell[CellGroupData[{
Cell[147615, 5401, 361, 12, 70, "Input",
 CellID->198111876],
Cell[147979, 5415, 337, 11, 36, "Output",
 CellID->842018642]
}, Open  ]],
Cell[148331, 5429, 246, 8, 70, "ExampleText",
 CellID->335021184],
Cell[CellGroupData[{
Cell[148602, 5441, 134, 4, 70, "Input",
 CellID->237315054],
Cell[148739, 5447, 162, 5, 36, "Output",
 CellID->825789262]
}, Open  ]],
Cell[148916, 5455, 125, 3, 70, "ExampleDelimiter",
 CellID->119777620],
Cell[149044, 5460, 90, 1, 70, "ExampleText",
 CellID->211463965],
Cell[CellGroupData[{
Cell[149159, 5465, 481, 16, 70, "Input",
 CellID->685963750],
Cell[149643, 5483, 334, 11, 36, "Output",
 CellID->302773271]
}, Open  ]],
Cell[149992, 5497, 240, 8, 70, "ExampleText",
 CellID->955119070],
Cell[CellGroupData[{
Cell[150257, 5509, 155, 4, 70, "Input",
 CellID->85988336],
Cell[150415, 5515, 240, 8, 36, "Output",
 CellID->520598042]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150704, 5529, 224, 7, 70, "ExampleSection",
 CellID->25267],
Cell[150931, 5538, 81, 1, 70, "ExampleText",
 CellID->406450286],
Cell[CellGroupData[{
Cell[151037, 5543, 684, 22, 70, "Input",
 CellID->72137826],
Cell[151724, 5567, 1391, 27, 70, "Output",
 Evaluatable->False,
 CellID->411343433]
}, Open  ]],
Cell[CellGroupData[{
Cell[153152, 5599, 837, 26, 70, "Input",
 CellID->11375971],
Cell[153992, 5627, 19108, 352, 70, "Output",
 CellID->185677212]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173161, 5986, 311, 9, 70, "SeeAlsoSection",
 CellID->26545],
Cell[173475, 5997, 3038, 107, 70, "SeeAlso",
 CellID->4932]
}, Open  ]],
Cell[CellGroupData[{
Cell[176550, 6109, 314, 9, 70, "TutorialsSection",
 CellID->13755],
Cell[176867, 6120, 176, 5, 70, "Tutorials",
 CellID->2347],
Cell[177046, 6127, 188, 4, 70, "Tutorials",
 CellID->17036],
Cell[177237, 6133, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[177439, 6141, 318, 9, 70, "MoreAboutSection",
 CellID->45946144],
Cell[177760, 6152, 155, 3, 70, "MoreAbout",
 CellID->45622949],
Cell[177918, 6157, 153, 3, 70, "MoreAbout",
 CellID->915101512],
Cell[178074, 6162, 143, 3, 70, "MoreAbout",
 CellID->136633635],
Cell[178220, 6167, 136, 3, 70, "MoreAbout",
 CellID->293910965],
Cell[178359, 6172, 137, 3, 70, "MoreAbout",
 CellID->633298362],
Cell[178499, 6177, 146, 3, 70, "MoreAbout",
 CellID->55252993],
Cell[178648, 6182, 137, 3, 70, "MoreAbout",
 CellID->715684903]
}, Open  ]],
Cell[178800, 6188, 27, 0, 70, "History"],
Cell[178830, 6190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

