(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18738,        612]
NotebookOptionsPosition[     15001,        496]
NotebookOutlinePosition[     16650,        537]
CellTagsIndexPosition[     16565,        532]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding and Manipulating Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingAndManipulatingFiles"], "Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Finding and Manipulating Files\"\>", 
       2->"\<\"Searching Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Find" :> Documentation`HelpLookup["paclet:ref/Find"], 
          "ReadList" :> Documentation`HelpLookup["paclet:ref/ReadList"], 
          "NotebookFind" :> 
          Documentation`HelpLookup["paclet:ref/NotebookFind"], "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Find\"\>", 2->"\<\"ReadList\"\>", 
       3->"\<\"NotebookFind\"\>", 
       4->"\<\"StringCases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"File Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Processing Textual Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FindList", "ObjectName",
 CellID->25045],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of lines in the file that contain the \
specified string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all lines that contain any of the \
specified strings. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindList"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of lines containing the specified strings \
in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindList"], "[", 
       RowBox[{
        StyleBox["files", "TI"], ",", 
        StyleBox["text", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " lines found. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30913]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " if it fails to find any record which contains the specified text. "
}], "Notes",
 CellID->14945],

Cell["The following options can be given: ", "Notes",
 CellID->20123],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnchoredSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnchoredSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require that the text searched for be at the beginning of a record \
\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IgnoreCase",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IgnoreCase"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to treat lower and upper case as equivalent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\<\\r\\n\>\"", ",", " ", "\"\<\\n\>\"", ",", "\"\<\\r\>\""}], 
     "}"}], Cell["separators for records ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require that the text searched for appear as a word \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}], Cell[
    "separators for words ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->30582],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", or simply ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 " if there is only one open input stream with the specified name. "
}], "Notes",
 CellID->30594],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " opens a file or pipe, it closes it again when it has finished. "
}], "Notes",
 CellID->19210]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->819186334],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->221286238],

Cell[TextData[{
 "Get a lists of lines in a file that contains ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"electors\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->903160046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", "\"\<electors\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365384372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"choice of electors for President and Vice-President of the \
United States,\"\>", 
   ",", "\<\"have one vote. The electors in each State shall have the \
qualifications\"\>", 
   ",", "\<\"requisite for electors of the most numerous branch of the State \
legislatures.\"\>", 
   ",", "\<\"appoint in such manner as the Congress may direct: A number of \
electors of\"\>", 
   ",", "\<\"the purposes of the election of President and Vice President, to \
be electors\"\>", 
   ",", "\<\"election for President or Vice President, for electors for \
President or\"\>"}], "}"}]], "Output",
 ImageSize->{557, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1392573726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->693498157],

Cell[TextData[{
 "The first 2 lines that contain ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"electors\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1598431425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{
  "\"\<ExampleData/USConstitution.txt\>\"", ",", "\"\<electors\>\"", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1964019652],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"choice of electors for President and Vice-President of the \
United States,\"\>", 
   ",", "\<\"have one vote. The electors in each State shall have the \
qualifications\"\>"}], "}"}]], "Output",
 ImageSize->{529, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307153127]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8787],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Find",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Find"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookFind",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookFind"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7781],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "Tutorials",
 CellID->17026],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->12559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108787454],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->343305893],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->865639992],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->972249199],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->456442483]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 58.2496484}", "context" -> "System`", 
    "keywords" -> {"grep", "records", "searching", "file search"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FindList[\"file\", \" text\"] gives a list of lines in the file that \
contain the specified string. FindList[\"file\", {\"SubscriptBox[ text, 1]\", \
\"SubscriptBox[ text, 2]\", ...}] gives a list of all lines that contain any \
of the specified strings. FindList[{\"SubscriptBox[ file, 1]\", ...}, ...] \
gives a list of lines containing the specified strings in any of the file_i. \
FindList[files, text, n] includes only the first n lines found. ", 
    "synonyms" -> {"find list", "sed", "grep"}, "title" -> "FindList", "type" -> 
    "Symbol", "uri" -> "ref/FindList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9391, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->819186334]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16422, 525}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2589, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3212, 86, 46, 1, 70, "ObjectName",
 CellID->25045],
Cell[3261, 89, 2388, 72, 70, "Usage",
 CellID->30913]
}, Open  ]],
Cell[CellGroupData[{
Cell[5686, 166, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6164, 183, 304, 10, 70, "Notes",
 CellID->14945],
Cell[6471, 195, 69, 1, 70, "Notes",
 CellID->20123],
Cell[6543, 198, 1954, 51, 70, "3ColumnTableMod",
 CellID->30582],
Cell[8500, 251, 612, 20, 70, "Notes",
 CellID->30594],
Cell[9115, 273, 239, 8, 70, "Notes",
 CellID->19210]
}, Closed]],
Cell[CellGroupData[{
Cell[9391, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->819186334],
Cell[CellGroupData[{
Cell[9776, 300, 148, 5, 70, "ExampleSection",
 CellID->221286238],
Cell[9927, 307, 193, 6, 70, "ExampleText",
 CellID->903160046],
Cell[CellGroupData[{
Cell[10145, 317, 182, 5, 28, "Input",
 CellID->365384372],
Cell[10330, 324, 762, 18, 122, "Output",
 CellID->1392573726]
}, Open  ]],
Cell[11107, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->693498157],
Cell[11235, 350, 180, 6, 70, "ExampleText",
 CellID->1598431425],
Cell[CellGroupData[{
Cell[11440, 360, 197, 6, 70, "Input",
 CellID->1964019652],
Cell[11640, 368, 370, 10, 54, "Output",
 CellID->307153127]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12071, 385, 310, 9, 70, "SeeAlsoSection",
 CellID->8787],
Cell[12384, 396, 947, 35, 70, "SeeAlso",
 CellID->14837]
}, Open  ]],
Cell[CellGroupData[{
Cell[13368, 436, 313, 9, 70, "TutorialsSection",
 CellID->7781],
Cell[13684, 447, 168, 3, 70, "Tutorials",
 CellID->17026],
Cell[13855, 452, 140, 3, 70, "Tutorials",
 CellID->12559]
}, Open  ]],
Cell[CellGroupData[{
Cell[14032, 460, 319, 9, 70, "MoreAboutSection",
 CellID->108787454],
Cell[14354, 471, 147, 3, 70, "MoreAbout",
 CellID->343305893],
Cell[14504, 476, 141, 3, 70, "MoreAbout",
 CellID->865639992],
Cell[14648, 481, 122, 3, 70, "MoreAbout",
 CellID->972249199],
Cell[14773, 486, 156, 3, 70, "MoreAbout",
 CellID->456442483]
}, Open  ]],
Cell[14944, 492, 27, 0, 70, "History"],
Cell[14974, 494, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

