(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13126,        449]
NotebookOptionsPosition[     10676,        369]
NotebookOutlinePosition[     11761,        399]
CellTagsIndexPosition[     11718,        396]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ToUpperCase" :> 
         Documentation`HelpLookup["paclet:ref/ToUpperCase"], "ToLowerCase" :> 
         Documentation`HelpLookup["paclet:ref/ToLowerCase"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ToUpperCase\"\>", 
      2->"\<\"ToLowerCase\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FindSettings", "ObjectName",
 CellID->7173],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->19229899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindSettings", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["opt", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     " \[LineSeparator]is a global option that specifies settings for the ",
     StyleBox["Find", "MenuName"],
     " dialog box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options may be specified:", "Notes",
 CellID->3461],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FindString\>\"", "\"\<\>\"", Cell[
    TextData[{
     "stores the value of the last string that was searched for using the ",
     StyleBox["Find", "DialogElementName"],
     " dialog box"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IgnoreCase\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "specifies whether a search carried out using the ",
     StyleBox["Find", "DialogElementName"],
     " command is case-sensitive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReplaceString\>\"", "\"\<\>\"", 
    Cell["\<\
stores the value of the string to be inserted in place of highlighted text in \
the current notebook\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowMargins\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specifies the size of margins around the ",
     StyleBox["Find", "DialogElementName"],
     " dialog box"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Wraparound\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
specifies whether a search should be continued at the start of a notebook \
when the search reaches the end\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->28484],

Cell[TextData[{
 Cell[BoxData["\"\<FindString\>\""], "InlineFormula"],
 StyleBox[" ", "MR"],
 "is usually set by typing text into the ",
 StyleBox["Search for:", "DialogElementName"],
 " field of the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box, which is accessed by choosing ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Find",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Find"], "MenuName"],
 " menu item."
}], "Notes",
 CellID->18193],

Cell[TextData[{
 "You can search for any occurrence of a special character by setting ",
 Cell[BoxData["\"\<FindString\>\""], "InlineFormula"],
 " to the full name of the character. For example, to search for the next \
occurrence of the Greek letter ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ", you can set ",
 Cell[BoxData[
  RowBox[{"\"\<FindString\>\"", "->", 
   ButtonBox[
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Alpha", "]"}]}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/character/Alpha"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32127],

Cell[TextData[{
 "You can search for typeset expressions by specifying the box structure in \
linear syntax. For example, to search for the next occurrence of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], TraditionalForm]], "InlineMath"],
 ", you can set ",
 Cell[BoxData[
  RowBox[{"\"\<FindString\>\"", "->", 
   RowBox[{"\\!", 
    RowBox[{"\\(", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "\\^", "2"}], "+", 
      RowBox[{
       StyleBox["y", "TI"], "\\^", "2"}]}], "\\)"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16866],

Cell[TextData[{
 "You must perform a search using one of the buttons in the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box for the value of ",
 Cell[BoxData["\"\<FindString\>\""], "InlineFormula"],
 " to be updated."
}], "Notes",
 CellID->6693],

Cell[TextData[{
 Cell[BoxData["\"\<ReplaceString\>\""], "InlineFormula"],
 StyleBox[" ", "MR"],
 "is usually set by typing text into the ",
 StyleBox["Replace with:", "DialogElementName"],
 " field of the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->19403],

Cell[TextData[{
 "You must perform a search using one of the buttons in the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box for the value of ",
 Cell[BoxData["\"\<ReplaceString\>\""], "InlineFormula"],
 " to be updated."
}], "Notes",
 CellID->18298],

Cell[TextData[{
 "You can also replace text with a special character by setting ",
 Cell[BoxData["\"\<ReplaceString\>\""], "InlineFormula"],
 " to the full name of the character. For example, to replace the selected \
text by the Greek letter ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ", you can use the setting ",
 Cell[BoxData[
  RowBox[{"\"\<ReplaceString\>\"", "->", 
   ButtonBox[
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Alpha", "]"}]}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/character/Alpha"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8885],

Cell[TextData[{
 Cell[BoxData["\"\<IgnoreCase\>\""], "InlineFormula"],
 StyleBox[" ", "MR"],
 "is usually set using the ",
 StyleBox["Ignore case", "DialogElementName"],
 " checkbox of the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->26009],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<IgnoreCase\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", searches are case-insensitive."
}], "Notes",
 CellID->8415],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<IgnoreCase\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", searches are case-sensitive."
}], "Notes",
 CellID->7719],

Cell[TextData[{
 Cell[BoxData["\"\<Wraparound\>\""], "InlineFormula"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "is usually set using the ",
 StyleBox["Wrap around", "DialogElementName"],
 " checkbox of the ",
 StyleBox["Find", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellID->10289],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<Wraparound\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a search that reaches the end of a notebook is continued at the start of \
that notebook."
}], "Notes",
 CellID->11561],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<Wraparound\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ",",
 StyleBox[" ",
  FontWeight->"Bold"],
 "a search terminates when it reaches the end of a notebook."
}], "Notes",
 CellID->5854]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8732],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17448]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindSettings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 9.7968190}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FindSettings -> {opt_1 -> val_1, opt_2 -> val_2, ...} is a global option \
that specifies settings for the Find dialog box.", 
    "synonyms" -> {"find settings"}, "title" -> "FindSettings", "type" -> 
    "Symbol", "uri" -> "ref/FindSettings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 679, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1302, 43, 49, 1, 70, "ObjectName",
 CellID->7173],
Cell[1354, 46, 217, 6, 70, "AwaitingReviewNote",
 CellID->19229899],
Cell[1574, 54, 954, 30, 70, "Usage",
 CellID->18716]
}, Open  ]],
Cell[CellGroupData[{
Cell[2565, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3043, 106, 71, 1, 70, "Notes",
 CellID->3461],
Cell[3117, 109, 1665, 41, 70, "3ColumnTableMod",
 CellID->28484],
Cell[4785, 152, 601, 17, 70, "Notes",
 CellID->18193],
Cell[5389, 171, 601, 17, 70, "Notes",
 CellID->32127],
Cell[5993, 190, 615, 20, 70, "Notes",
 CellID->16866],
Cell[6611, 212, 254, 7, 70, "Notes",
 CellID->6693],
Cell[6868, 221, 292, 9, 70, "Notes",
 CellID->19403],
Cell[7163, 232, 258, 7, 70, "Notes",
 CellID->18298],
Cell[7424, 241, 607, 17, 70, "Notes",
 CellID->8885],
Cell[8034, 260, 276, 9, 70, "Notes",
 CellID->26009],
Cell[8313, 271, 264, 9, 70, "Notes",
 CellID->8415],
Cell[8580, 282, 256, 9, 70, "Notes",
 CellID->7719],
Cell[8839, 293, 292, 10, 70, "Notes",
 CellID->10289],
Cell[9134, 305, 324, 10, 70, "Notes",
 CellID->11561],
Cell[9461, 317, 328, 12, 70, "Notes",
 CellID->5854]
}, Closed]],
Cell[CellGroupData[{
Cell[9826, 334, 310, 9, 70, "SeeAlsoSection",
 CellID->8732],
Cell[10139, 345, 463, 17, 70, "SeeAlso",
 CellID->17448]
}, Open  ]],
Cell[10617, 365, 29, 0, 70, "History"],
Cell[10649, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

