(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48663,       1897]
NotebookOptionsPosition[     37959,       1514]
NotebookOutlinePosition[     39277,       1551]
CellTagsIndexPosition[     39191,       1546]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FixedPointList" :> 
          Documentation`HelpLookup["paclet:ref/FixedPointList"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "ReplaceRepeated" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceRepeated"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FixedPointList\"\>", 
       2->"\<\"NestWhile\"\>", 3->"\<\"Nest\"\>", 
       4->"\<\"ReplaceRepeated\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Functional Iteration\"\>", 
       2->"\<\"Functional Programming\"\>", 
       3->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FixedPoint", "ObjectName",
 CellID->13098],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FixedPoint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FixedPoint"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]starts with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", then applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly until the result no longer changes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " stops after at most ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " steps. "
}], "Notes",
 CellID->23462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " always returns the last result it gets. "
}], "Notes",
 CellID->12886],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit from ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " before it is finished. "
}], "Notes",
 CellID->8456],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " to successive pairs of results to determine whether a fixed point has been \
reached. "
}], "Notes",
 CellID->17245],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["comp", "TI"], ",", "2"}], "]"}]], "InlineFormula"],
 " provides a way to use a general comparison function. "
}], "Notes",
 CellID->32015]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6827815],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->640674202],

Cell[TextData[{
 "Find a value ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", "(", "x", ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->827350711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Cos", ",", "1.0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1450130845],

Cell[BoxData["0.7390851332151607`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227339685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1896426863],

Cell[BoxData["0.7390851332151607`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18181084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->960783558],

Cell["Fixed point of an integer-valued function:", "ExampleText",
 CellID->62954242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000", ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33", ",", "17",
    ",", "9", ",", "5", ",", "3", ",", "2", ",", "2", ",", "2", ",", "2", ",",
    "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->884148000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->23058],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520578228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2094092278],

Cell["\<\
Repeated application of a rule until the result no longer changes:\
\>", "ExampleText",
 CellID->261159432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_"}], "}"}], "/;", 
       RowBox[{"b", "\[NotEqual]", "0"}]}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"Mod", "[", 
         RowBox[{"a", ",", "b"}], "]"}]}], "}"}]}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "21"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1230143031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->660019205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"28", ",", "21"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->659869695],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27292551]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30769],

Cell["Numerical fixed point of a function:", "ExampleText",
 CellID->544210848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Erf", ",", "1.0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1228256016],

Cell[BoxData["0.6174468790806075`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1819254789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470145953],

Cell["Fixed point of a repeated transformation:", "ExampleText",
 CellID->1212851900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"fact", "[", "0", "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"fact", "[", "n_", "]"}], "\[RuleDelayed]", 
        RowBox[{"n", " ", 
         RowBox[{"fact", "[", 
          RowBox[{"n", "-", "1"}], "]"}]}]}]}], "}"}]}], "&"}], ",", 
   RowBox[{"fact", "[", "17", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510574240],

Cell[BoxData["355687428096000"], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456603187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9841],

Cell["Stop after at most 10 steps:", "ExampleText",
 CellID->7000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", 
   RowBox[{"10", "^", "6"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29982],

Cell[BoxData["978"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", 
   RowBox[{"10", "^", "6"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20855],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26065]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12627],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SameTest",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21964],

Cell[TextData[{
 "Stop as soon as successive iterations differ by less than ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", "10"}]]], "InlineFormula"]
}], "ExampleText",
 CellID->77384070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1`20", 
   ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#1", "-", "#2"}], "]"}], "<", "1*^-10"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1016195388],

Cell[BoxData["1.41421356237309504880168962350253024361`19.999999999999996"], \
"Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762091373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1", 
   ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#1", "-", "#2"}], "]"}], "<", "1*^-10"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1468269344],

Cell[BoxData[
 FractionBox["886731088897", "627013566048"]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->530969055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114687281],

Cell["\<\
Perform exact arithmetic but use a numerical comparison function:\
\>", "ExampleText",
 CellID->1596760183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"2", "/", "#"}]}], ")"}], "/", "2"}], "&"}], ",", "1", ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equal", "[", 
       RowBox[{
        RowBox[{"N", "[", "#1", "]"}], ",", 
        RowBox[{"N", "[", "#2", "]"}]}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1216266109],

Cell[BoxData[
 FractionBox["1572584048032918633353217", 
  "1111984844349868137938112"]], "Output",
 ImageSize->{201, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2912280]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12628],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " using Newton\[CloseCurlyQuote]s method:"
}], "ExampleText",
 CellID->27152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11087],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->887487451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244],

Cell["Fixed point of a complex iteration:", "ExampleText",
 CellID->8037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Log", ",", 
   RowBox[{"1.0", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17650],

Cell[BoxData[
 RowBox[{"0.3181315052047643`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.3372357014306893`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186274631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54225052],

Cell["Matrix-multiplication convergence:", "ExampleText",
 CellID->14271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.51", ",", "0.49"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.49", ",", "0.51"}], "}"}]}], "}"}], ".", "#"}], "&"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23895],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuAGxjAQDkP0fyAJj
t///gTSEZAWRzCBRMGAwR+OzgFWxYBEFcUE0EwPEFBCfB4c4O5p+ZqymgkVZ
4XywGgawKBPUTExZLjL0sFHgGl40VRxEqcJqNoREV0UlG9HjlYkEG0FhClLE
jVeWg0IbkFXhtgnD54PQRlgqB5nJAqWR+eipH7sp1qOq0MKT2NKFknRB/dKF
uNgeLHl9aJUuxJXR5OV1SuooWtoIq2txlS7YazPi6nVIG4CBEQB2g1tT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{70, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->12953983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32223],

Cell["\<\
Root of the current directory tree (the result will depend on computer \
system):\
\>", "ExampleText",
 CellID->31304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"ParentDirectory", ",", 
   RowBox[{"Directory", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22950],

Cell[BoxData["\<\"/\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->995610552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7517],

Cell["Repeated differentiation:", "ExampleText",
 CellID->1962092327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"x", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24347],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20051854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1097411120],

Cell[TextData[{
 "Find the minimum of ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "2"], "+", 
   SuperscriptBox["y", "2"]}]], "InlineFormula"],
 " with the steepest-descent method (vector notation):"
}], "ExampleText",
 CellID->291124462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", "0.1"}], "}"}], ",", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"xy", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "\[Epsilon]"}], ",", "0"}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}]}], "}"}]}], "}"}], ".", 
         "xy"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1.0"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1848319124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84518754]
}, Open  ]],

Cell["Component notation:", "ExampleText",
 CellID->1758197435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", "0.1"}], "}"}], ",", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "+", 
            RowBox[{"2", " ", "\[Epsilon]"}], "-", 
            RowBox[{"2", " ", "x", " ", "\[Epsilon]"}]}], ",", 
           RowBox[{"y", "-", 
            RowBox[{"2", " ", "y", " ", "\[Epsilon]"}]}]}], "}"}]}], "]"}], "@@",
        "#"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1.0"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66496131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "3.04422472668574`0.8263277842944227*^-323"}], 
  "}"}]], "Output",
 ImageSize->{103, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559486263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5994],

Cell[TextData[{
 "Evaluate combinators [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-1122"], None}],
 "]:"
}], "ExampleText",
 CellID->29079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
        "\[Rule]", 
        RowBox[{
         RowBox[{"x", "[", "z", "]"}], "[", 
         RowBox[{"y", "[", "z", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"k", "[", "x_", "]"}], "[", "y_", "]"}], "\[Rule]", "x"}]}], 
      "}"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", 
       RowBox[{"s", "[", 
        RowBox[{
         RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "]"}], "]"}], "[", 
      "s", "]"}], "[", "s", "]"}], "[", "k", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->560],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", 
   RowBox[{"k", "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"s", "[", "s", "]"}], "]"}], "[", "k", "]"}], "]"}], "]"}], "[",
   
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"k", "[", 
     RowBox[{"k", "[", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"s", "[", "s", "]"}], "]"}], "[", "k", "]"}], "]"}], "]"}], 
    "]"}], "[", 
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"s", "[", "s", "]"}], "]"}], "[", "k", "]"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266336480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691196166],

Cell["Connected components in a graph:", "ExampleText",
 CellID->1370264369],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConnectedNodes", "[", 
   RowBox[{"list_", ",", "i_"}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{
         "list", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}]}], 
        "}"}], "]"}], "]"}], "&"}], ",", 
    RowBox[{"{", "i", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1565269433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConnectedNodes", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2128285171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->265521091]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " gives the last element of ",
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1578207386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->896449159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210523780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->464958028],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554571737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->919070827],

Cell[TextData[{
 "Apply rules repeatedly until the result no longer changes using ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 " (//.):"
}], "ExampleText",
 CellID->8858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", "b"}], ",", 
       RowBox[{"b", "->", "c"}], ",", 
       RowBox[{"c", "->", "d"}]}], "}"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"c", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3736],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["d", "2"], "+", 
  SuperscriptBox["d", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450282675]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "^", "2"}], "+", 
   RowBox[{"c", "^", "3"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "->", "b"}], ",", 
    RowBox[{"b", "->", "c"}], ",", 
    RowBox[{"c", "->", "d"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7967],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["b", "2"], "+", 
  SuperscriptBox["d", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->223007217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "^", "2"}], "+", 
   RowBox[{"c", "^", "3"}]}], "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "->", "b"}], ",", 
    RowBox[{"b", "->", "c"}], ",", 
    RowBox[{"c", "->", "d"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8140],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["d", "2"], "+", 
  SuperscriptBox["d", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->340685540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1896892088],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " is equivalent to a particular choice of arguments of ",
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->506529632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0", 
   ",", "UnsameQ", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1365408793],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28548726]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11151],

Cell["Calculations may not converge in a finite number of steps:", \
"ExampleText",
 CellID->22266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "/", "3"}], "+", 
       RowBox[{"1", "/", "4"}]}], "&"}], ",", 
     RowBox[{"Interval", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "]"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12670],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590978524]
}, Open  ]],

Cell["\<\
Providing a maximum number of iterations will guarantee termination:\
\>", "ExampleText",
 CellID->264689290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "/", "3"}], "+", 
     RowBox[{"1", "/", "4"}]}], "&"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1255093516],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["89737248461481573596281", "239299329230617529590083"], ",", 
    FractionBox["269211745384444720788844", "717897987691852588770249"]}], 
   "}"}], "]"}]], "Output",
 ImageSize->{474, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1686851920]
}, Open  ]],

Cell["\<\
Using a numerical test for convergence works in this case as well:\
\>", "ExampleText",
 CellID->416989456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "/", "3"}], "+", 
     RowBox[{"1", "/", "4"}]}], "&"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SameQ", "[", 
       RowBox[{
        RowBox[{"N", "[", "#1", "]"}], ",", 
        RowBox[{"N", "[", "#2", "]"}]}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->85756428],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["2084647712458321", "5559060566555523"], ",", 
    FractionBox["6253943137374964", "16677181699666569"]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{360, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->885471379]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1450],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9916]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27157],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->8224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->42987174],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->344154739],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->53737248],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->1049695241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FixedPoint"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FixedPoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 25.9847334}", "context" -> "System`", 
    "keywords" -> {
     "least fixed point", "mu operator", "Newton's approximation", "until"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FixedPoint[f, expr] starts with expr, then applies f repeatedly until \
the result no longer changes. ", "synonyms" -> {"fixed point"}, "title" -> 
    "FixedPoint", "type" -> "Symbol", "uri" -> "ref/FixedPoint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6187, 208, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6827815]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39050, 1539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2400, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3023, 83, 48, 1, 70, "ObjectName",
 CellID->13098],
Cell[3074, 86, 728, 23, 70, "Usage",
 CellID->3847]
}, Open  ]],
Cell[CellGroupData[{
Cell[3839, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4317, 131, 414, 15, 70, "Notes",
 CellID->23462],
Cell[4734, 148, 212, 7, 70, "Notes",
 CellID->12886],
Cell[4949, 157, 343, 13, 70, "Notes",
 CellID->8456],
Cell[5295, 172, 485, 17, 70, "Notes",
 CellID->17245],
Cell[5783, 191, 367, 12, 70, "Notes",
 CellID->32015]
}, Closed]],
Cell[CellGroupData[{
Cell[6187, 208, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6827815],
Cell[CellGroupData[{
Cell[6570, 222, 148, 5, 70, "ExampleSection",
 CellID->640674202],
Cell[6721, 229, 280, 12, 70, "ExampleText",
 CellID->827350711],
Cell[CellGroupData[{
Cell[7026, 245, 134, 4, 28, "Input",
 CellID->1450130845],
Cell[7163, 251, 176, 5, 36, "Output",
 CellID->227339685]
}, Open  ]],
Cell[CellGroupData[{
Cell[7376, 261, 100, 3, 28, "Input",
 CellID->1896426863],
Cell[7479, 266, 175, 5, 36, "Output",
 CellID->18181084]
}, Open  ]],
Cell[7669, 274, 125, 3, 70, "ExampleDelimiter",
 CellID->960783558],
Cell[7797, 279, 84, 1, 70, "ExampleText",
 CellID->62954242],
Cell[CellGroupData[{
Cell[7906, 284, 246, 9, 70, "Input",
 CellID->11604],
Cell[8155, 295, 420, 11, 36, "Output",
 CellID->884148000]
}, Open  ]],
Cell[CellGroupData[{
Cell[8612, 311, 236, 9, 70, "Input",
 CellID->23058],
Cell[8851, 322, 158, 5, 36, "Output",
 CellID->520578228]
}, Open  ]],
Cell[9024, 330, 126, 3, 70, "ExampleDelimiter",
 CellID->2094092278],
Cell[9153, 335, 117, 3, 70, "ExampleText",
 CellID->261159432],
Cell[CellGroupData[{
Cell[9295, 342, 504, 17, 70, "Input",
 CellID->1230143031],
Cell[9802, 361, 203, 7, 36, "Output",
 CellID->660019205]
}, Open  ]],
Cell[CellGroupData[{
Cell[10042, 373, 124, 4, 70, "Input",
 CellID->659869695],
Cell[10169, 379, 157, 5, 36, "Output",
 CellID->27292551]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10375, 390, 216, 7, 70, "ExampleSection",
 CellID->30769],
Cell[10594, 399, 79, 1, 70, "ExampleText",
 CellID->544210848],
Cell[CellGroupData[{
Cell[10698, 404, 134, 4, 70, "Input",
 CellID->1228256016],
Cell[10835, 410, 177, 5, 36, "Output",
 CellID->1819254789]
}, Open  ]],
Cell[11027, 418, 125, 3, 70, "ExampleDelimiter",
 CellID->470145953],
Cell[11155, 423, 85, 1, 70, "ExampleText",
 CellID->1212851900],
Cell[CellGroupData[{
Cell[11265, 428, 508, 16, 70, "Input",
 CellID->510574240],
Cell[11776, 446, 173, 5, 36, "Output",
 CellID->456603187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11998, 457, 238, 7, 70, "ExampleSection",
 CellID->9841],
Cell[12239, 466, 66, 1, 70, "ExampleText",
 CellID->7000],
Cell[CellGroupData[{
Cell[12330, 471, 267, 9, 70, "Input",
 CellID->29982],
Cell[12600, 482, 156, 5, 36, "Output",
 CellID->22538]
}, Open  ]],
Cell[CellGroupData[{
Cell[12793, 492, 256, 9, 70, "Input",
 CellID->20855],
Cell[13052, 503, 154, 5, 36, "Output",
 CellID->26065]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13255, 514, 218, 7, 70, "ExampleSection",
 CellID->12627],
Cell[CellGroupData[{
Cell[13498, 525, 225, 7, 70, "ExampleSubsection",
 CellID->21964],
Cell[13726, 534, 198, 6, 70, "ExampleText",
 CellID->77384070],
Cell[CellGroupData[{
Cell[13949, 544, 471, 17, 70, "Input",
 CellID->1016195388],
Cell[14423, 563, 219, 6, 36, "Output",
 CellID->762091373]
}, Open  ]],
Cell[CellGroupData[{
Cell[14679, 574, 468, 17, 70, "Input",
 CellID->1468269344],
Cell[15150, 593, 200, 6, 51, "Output",
 CellID->530969055]
}, Open  ]],
Cell[15365, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->114687281],
Cell[15493, 607, 117, 3, 70, "ExampleText",
 CellID->1596760183],
Cell[CellGroupData[{
Cell[15635, 614, 485, 17, 70, "Input",
 CellID->1216266109],
Cell[16123, 633, 228, 7, 51, "Output",
 CellID->2912280]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16412, 647, 223, 7, 70, "ExampleSection",
 CellID->12628],
Cell[16638, 656, 181, 7, 70, "ExampleText",
 CellID->27152],
Cell[CellGroupData[{
Cell[16844, 667, 270, 10, 70, "Input",
 CellID->11087],
Cell[17117, 679, 175, 5, 36, "Output",
 CellID->887487451]
}, Open  ]],
Cell[17307, 687, 119, 3, 70, "ExampleDelimiter",
 CellID->244],
Cell[17429, 692, 73, 1, 70, "ExampleText",
 CellID->8037],
Cell[CellGroupData[{
Cell[17527, 697, 153, 5, 70, "Input",
 CellID->17650],
Cell[17683, 704, 273, 7, 36, "Output",
 CellID->186274631]
}, Open  ]],
Cell[17971, 714, 124, 3, 70, "ExampleDelimiter",
 CellID->54225052],
Cell[18098, 719, 73, 1, 70, "ExampleText",
 CellID->14271],
Cell[CellGroupData[{
Cell[18196, 724, 560, 20, 70, "Input",
 CellID->23895],
Cell[18759, 746, 522, 12, 70, "Output",
 Evaluatable->False,
 CellID->12953983]
}, Open  ]],
Cell[19296, 761, 121, 3, 70, "ExampleDelimiter",
 CellID->32223],
Cell[19420, 766, 128, 4, 70, "ExampleText",
 CellID->31304],
Cell[CellGroupData[{
Cell[19573, 774, 171, 5, 70, "Input",
 CellID->22950],
Cell[19747, 781, 166, 5, 36, "Output",
 CellID->995610552]
}, Open  ]],
Cell[19928, 789, 120, 3, 70, "ExampleDelimiter",
 CellID->7517],
Cell[20051, 794, 69, 1, 70, "ExampleText",
 CellID->1962092327],
Cell[CellGroupData[{
Cell[20145, 799, 225, 8, 70, "Input",
 CellID->24347],
Cell[20373, 809, 157, 5, 36, "Output",
 CellID->20051854]
}, Open  ]],
Cell[20545, 817, 126, 3, 70, "ExampleDelimiter",
 CellID->1097411120],
Cell[20674, 822, 297, 10, 70, "ExampleText",
 CellID->291124462],
Cell[CellGroupData[{
Cell[20996, 836, 869, 28, 70, "Input",
 CellID->1848319124],
Cell[21868, 866, 206, 7, 36, "Output",
 CellID->84518754]
}, Open  ]],
Cell[22089, 876, 63, 1, 70, "ExampleText",
 CellID->1758197435],
Cell[CellGroupData[{
Cell[22177, 881, 770, 24, 70, "Input",
 CellID->66496131],
Cell[22950, 907, 249, 8, 39, "Output",
 CellID->559486263]
}, Open  ]],
Cell[23214, 918, 120, 3, 70, "ExampleDelimiter",
 CellID->5994],
Cell[23337, 923, 219, 8, 70, "ExampleText",
 CellID->29079],
Cell[CellGroupData[{
Cell[23581, 935, 819, 28, 70, "Input",
 CellID->560],
Cell[24403, 965, 654, 24, 36, "Output",
 CellID->266336480]
}, Open  ]],
Cell[25072, 992, 125, 3, 70, "ExampleDelimiter",
 CellID->691196166],
Cell[25200, 997, 76, 1, 70, "ExampleText",
 CellID->1370264369],
Cell[25279, 1000, 496, 16, 70, "Input",
 CellID->1565269433],
Cell[CellGroupData[{
Cell[25800, 1020, 478, 16, 70, "Input",
 CellID->2128285171],
Cell[26281, 1038, 233, 7, 36, "Output",
 CellID->265521091]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26563, 1051, 232, 7, 70, "ExampleSection",
 CellID->5418],
Cell[26798, 1060, 346, 12, 70, "ExampleText",
 CellID->1578207386],
Cell[CellGroupData[{
Cell[27169, 1076, 309, 11, 70, "Input",
 CellID->896449159],
Cell[27481, 1089, 358, 10, 36, "Output",
 CellID->210523780]
}, Open  ]],
Cell[CellGroupData[{
Cell[27876, 1104, 305, 11, 70, "Input",
 CellID->464958028],
Cell[28184, 1117, 175, 5, 36, "Output",
 CellID->554571737]
}, Open  ]],
Cell[28374, 1125, 125, 3, 70, "ExampleDelimiter",
 CellID->919070827],
Cell[28502, 1130, 262, 8, 70, "ExampleText",
 CellID->8858],
Cell[CellGroupData[{
Cell[28789, 1142, 393, 14, 70, "Input",
 CellID->3736],
Cell[29185, 1158, 228, 8, 36, "Output",
 CellID->450282675]
}, Open  ]],
Cell[CellGroupData[{
Cell[29450, 1171, 294, 11, 70, "Input",
 CellID->7967],
Cell[29747, 1184, 228, 8, 36, "Output",
 CellID->223007217]
}, Open  ]],
Cell[CellGroupData[{
Cell[30012, 1197, 295, 11, 70, "Input",
 CellID->8140],
Cell[30310, 1210, 228, 8, 36, "Output",
 CellID->340685540]
}, Open  ]],
Cell[30553, 1221, 126, 3, 70, "ExampleDelimiter",
 CellID->1896892088],
Cell[30682, 1226, 362, 12, 70, "ExampleText",
 CellID->506529632],
Cell[CellGroupData[{
Cell[31069, 1242, 332, 11, 70, "Input",
 CellID->1365408793],
Cell[31404, 1255, 174, 5, 36, "Output",
 CellID->28548726]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31627, 1266, 226, 7, 70, "ExampleSection",
 CellID->11151],
Cell[31856, 1275, 99, 2, 70, "ExampleText",
 CellID->22266],
Cell[CellGroupData[{
Cell[31980, 1281, 393, 14, 70, "Input",
 CellID->12670],
Cell[32376, 1297, 165, 5, 36, "Output",
 CellID->590978524]
}, Open  ]],
Cell[32556, 1305, 119, 3, 70, "ExampleText",
 CellID->264689290],
Cell[CellGroupData[{
Cell[32700, 1312, 324, 11, 70, "Input",
 CellID->1255093516],
Cell[33027, 1325, 382, 11, 51, "Output",
 CellID->1686851920]
}, Open  ]],
Cell[33424, 1339, 117, 3, 70, "ExampleText",
 CellID->416989456],
Cell[CellGroupData[{
Cell[33566, 1346, 541, 19, 70, "Input",
 CellID->85756428],
Cell[34110, 1367, 350, 11, 51, "Output",
 CellID->885471379]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34521, 1385, 310, 9, 70, "SeeAlsoSection",
 CellID->1450],
Cell[34834, 1396, 960, 35, 70, "SeeAlso",
 CellID->9916]
}, Open  ]],
Cell[CellGroupData[{
Cell[35831, 1436, 314, 9, 70, "TutorialsSection",
 CellID->27157],
Cell[36148, 1447, 166, 3, 70, "Tutorials",
 CellID->8224]
}, Open  ]],
Cell[CellGroupData[{
Cell[36351, 1455, 318, 9, 70, "MoreAboutSection",
 CellID->42987174],
Cell[36672, 1466, 151, 3, 70, "MoreAbout",
 CellID->344154739],
Cell[36826, 1471, 154, 3, 70, "MoreAbout",
 CellID->53737248],
Cell[36983, 1476, 148, 3, 70, "MoreAbout",
 CellID->1049695241]
}, Open  ]],
Cell[CellGroupData[{
Cell[37168, 1484, 305, 8, 70, "RelatedLinksSection"],
Cell[37476, 1494, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[37879, 1510, 50, 0, 70, "History"],
Cell[37932, 1512, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

