(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    507215,      10009]
NotebookOptionsPosition[    497428,       9674]
NotebookOutlinePosition[    498893,       9713]
CellTagsIndexPosition[    498806,       9708]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Views" :> 
          Documentation`HelpLookup["paclet:tutorial/Views"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Views\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenerView" :> 
          Documentation`HelpLookup["paclet:ref/OpenerView"], "SlideView" :> 
          Documentation`HelpLookup["paclet:ref/SlideView"], "PopupView" :> 
          Documentation`HelpLookup["paclet:ref/PopupView"], "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "Mouseover" :> 
          Documentation`HelpLookup["paclet:ref/Mouseover"], "Toggler" :> 
          Documentation`HelpLookup["paclet:ref/Toggler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenerView\"\>", 2->"\<\"SlideView\"\>", 
       3->"\<\"PopupView\"\>", 4->"\<\"PaneSelector\"\>", 
       5->"\<\"Mouseover\"\>", 6->"\<\"Toggler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Viewers and Annotation\"\>", 
       5->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FlipView", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlipView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlipView"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object which flips between displaying ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " each time it is clicked."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlipView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlipView"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]cyclically flips through successive ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlipView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlipView"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " be the object currently displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16326]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Clicking anywhere inside a ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " advances to the next object."
}], "Notes",
 CellID->3732],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FlipView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlipView"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["i", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " takes the displayed object to be specified by the dynamically updated \
current value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", with the value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " being reset if a new object is displayed."
}], "Notes",
 CellID->28127],

Cell["The following options can be given: ", "Notes",
 CellID->8441],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align objects in the display area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "base style specifications for the ",
     Cell[BoxData[
      ButtonBox["FlipView",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FlipView"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether controls are enabled", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the overall frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size for the display area", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->2093],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " leaves space only for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " currently being displayed. "
}], "Notes",
 CellID->19450],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " always leaves space for the largest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be displayed, so that its overall size does not change."
}], "Notes",
 CellID->25477],

Cell[TextData[{
 "Controls such as ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula",
  ShowStringCharacters->False],
 " and ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula",
  ShowStringCharacters->False],
 " are not clickable inside ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula",
  ShowStringCharacters->False],
 "."
}], "Notes",
 CellID->18047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula",
  ShowStringCharacters->False],
 " intercepts mouse clicks, but passes them through to ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula",
  ShowStringCharacters->False],
 " if the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PassEventsDown",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PassEventsDown"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula",
  ShowStringCharacters->False],
 " is given. "
}], "Notes",
 CellID->26994],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<FlipView\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472195729],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->38802953],

Cell["Flip between two expressions whenever one is clicked:", "ExampleText",
 CellID->160322567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{"a", "+", "b"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402517672],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 2}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      RowBox[{"x", "+", "y"}],
      "ResetImageSizeLevel"], 2->
     TagBox[
      RowBox[{"a", "+", "b"}],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`x + $CellContext`y, $CellContext`a + \
$CellContext`b}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{33, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59030148]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->825927679],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FlipView Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->99520315],

Cell["Flip between several expressions:", "ExampleText",
 CellID->317329411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120484930],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475083456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->374137360],

Cell["Flip between graphics or any other expressions:", "ExampleText",
 CellID->157113080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378281485],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 2}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.999999941761652, 0.9999995837354044}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999996187787015, 0.9999994313041395}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999992328657719, 0.9999997588489247}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 5->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999999574404889, 0.9999976139198089}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.999999941761652, 0.9999995837354044}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I
VkKUPEh2sm/Zd2Nmri27vPf9y+d8rnvuc85z5s79zkCzuW5yiYONje0LFxvb
/3++8bDh2XbRb/+LzvLidX7v9xc3KBqeUryKGIZx/FtbH6OVkvwnior3kVwx
kVbfEozeFLygciv6IPFZS2Fmczxy0L7tOEt9jb4PsGXENGSghsUrIePUJDQS
8V+0f0kRWvWnT4VJzUX+A0d8/YPrUWvBj9uMkVyU8vLy0ai1DejjfxE/xz5/
Q0IiLX0oowEdu3HsPP1AHkoTOay0v7YRha3+FjZ8GSMsv/ZMDk8LokSXcUy0
FKGI1+541uIPelsR6zJGLUelltGck7960XRE1sZu/3IUk6B6Inl1H9K7XNlf
P1+O/HeH/mMZ9iEG56zZt4YK9MIjJUmovg/t1j6m5eNdhXhKC9k9m/tRbfoS
hwrxG513SA38XjKIKGi1laB6LTp3Rs7clGMI7VUO0fK+WIvql5UjzmkPoZfT
SVOudbXoH/dE0PfPQ0gjqOmSTXIderfOVc391TB6WKFmsO18A3ovo6bYsGcU
JX7+qpwc2oBUd/0JKbUfRfURupzrqxoQ5dYXPYk3o2jd5dN5Unsa0YYXIhd+
LI+iCk4vdTaxJnT6Vb2hyFc6mqYL8bvqN6HHmSXOmf10JF//enjqYRPqKI7Z
nyQ8hpzj0uOGGU1IPXPR2vPSGJLQ/kP5XdKM1vR98i3hZSBYZ0ccWW5Go19m
39ZtYaCr/BOVRTtaUMEjX+Y6cwbKa+N5mh3XgsY9kvbHxTGQzZ3ts29cW5FB
w9E3v9WYyP/cjwbJz63ofngDH8cxJso6eORT0HArkhB8anPbiYl4xayuPjVt
Q8GM/meyqUyUlu7zx0G9Ha2Opn85TmMhOoXub2Ddjjp2xgqnarGQyh2D/aoh
7Ugp6WWg1UkWitvH/7Z/vh05jF9t/P6YhTpi7U0K1f4gZ05RX7vXLCTNWcUZ
e/4PKrxy3cA2nYWCy/3tLH79QXfHty+eaGOhGjWm5O65P4jmobUMTBbiDzQq
X7OpAxU+PLD5ERuBvMyF1OoCO1BG28NL4+sIVJDr1Jn2swPJ3Q+KUdAk0LLc
75f+Mx1of+aly1F6BLrTHzBx2LITHTtxdufDSwTK0BuPXx/Qidjse3wHbxKI
SDphylnUiQzcpkRePyKQmuBn7t7pTmQt+On+65cEuuIs+jVfpQsJTW9yG4ok
0PsGlyvRFl1ogHHv98P/CNSrWS/t+qIL1W7+T+PSZwJZLAe775zqQs327dpi
vwgUdmFqs5hyNyqlr7j8qSZQw8+T3eOnu9HzbYdaWE0EElHJDKzx60bSbIXI
qJNAhr7iuin53egnR8CjmX4CPWfemvKZ6EZaBbV36KMEskm8Vr+D0oPGnNOW
VQkCsbXLJMdv6kHW+NTc5ykCxfJXPhE91IOwC5fR01kC7dd2s/S06kFnlqYH
4xcI1OG0aSdxtweZLt/4zLdMINe4P4JWQeTxt3Vv8/4RSKreb6jqYw8ym3BM
zVkhUDbnPry3uAdpr06v+UfGpjsZ4R87e9DQLh6uADKetIt2lp7tQX9WEcev
kucHRRjqPxfpRYe2ETkvlgi0tWKJNruhF/2+Faa/NE+gmsWUhUsHelH8eQ+R
rBkCOWw+19Bo2Yts5/QVcyYJxHdeMOXAnV60zywhgJtFoMTAH14ZAb1oWebQ
/TcjBNIrcjxHS+pFBwcHFx/2EWhgSl4zsKgXFYcf1Ur9Q6An62uEVv70opgI
OLu+kUBrT3kMO/7tRW1TIT4jleS8PFcv6BDqQ9xX5Kdnighk9a0r4qhqH5o8
m1F9IpdAS2MvXb7p9KGUH+pGM2kEipRHBhvO9qHoCqfU4XcE2n2cWBtxqw8N
FxzbvD6CQLczjjfe/tCHplnmUU89CCQ+sJIyUNCHRt9vlE1yJudtzaenJ9v7
kAfXZKe0DYFY90R2bRPsR3/3XnEb0CXQZVT3mnGjH7FZ5smpLrEQW/zMtz9+
/ejigknJ2lEWiuCS66h434+azjCe32piobJyO4Uk8j631DHMR01hIVXTpfhL
WgOo5SjtQ7QxCxVk04pNTw4gnfA37y33sNBp6cODBxwGkO2bV253FVnoeVeQ
ytqYARR1NqgNM5ho5IpKShf7IEpdcBJLfsBEnpWG1dUyg6hZIvCR8QUmklK/
wcrbMYg+IyX7U7pMdGQqb2vUpUG0+ca+A15cTJT0wCTrVPkg2uLWUHrrEQNd
C36QXxs4hK6eClA2sRpDHH/ju3HSENogsdv54K4xFHmqjC29aAht+36MM568
31XIiR14MT2EmkHTPj6fjjZ9SCzVPz2M8pVyvtauoSPG94baIuoIcp64wvc5
aQR5KcxPfN49gk6HXNMovj+C5B4piL01HkFC3CtxxvojyFDvqtnDJyPI+mDM
5e6hYZRa+69t7/AIivt96MSA7DByGtzQn5k2impTwrJ9nAZRj1Ubb2H5KNri
FRzJuX0QnWx9rl49MIqen23W/Ds9gHZXDt8flKEjzw0DPw7dH0CcnxNEJLzp
KERvW3mpWz+KcKftv3t+DBWwPrrnXO1FhWLSr/eIMNHLZs7tFvQ2xEfzUune
PY4ufqm8k+qbi8r2BW3xODSO+J4Mu0Vv+YqenY7ZJW8yjposvBNXN2YijsCc
w2ftx9F/ExZHX8l+Qgv/GJdb3oyjA0JMxqmoSDTWYZb4m2MCHZ7pmo7zT8RV
ESobCqom0N+te6+dHi3Dvpka2863TSCqrnrAFkoFPlKrs+ff4ARiW/vwyy2t
Sly8ylJ/38oEYtYPiWzxqcZ5dwKv5mybRG/WKxScEq7DqabzSZ/CJpHRgegA
peAm/FKkcuPbC1Mo/cBNEZ5dXTh3l3zWMacpVLE7XOxkaRcesLqOltym0ESe
wYcm8268N1XM9FT4FDpvJWKbvacHj+hbPhCsmUKNQjVu+4178YEnzN/3904j
Hq3bOl7X+rHTR2Shoj+Nvt59t9kzuR9H1gUNNJpPo8Jdb74tjPXjcarm/JYb
0+io0bz0JfsBHJPnsXYocRptvn3Optd2EM/9Fb5tIvEXlcxqnpbUGsZK8jYr
K0p/0cIfky37bwzjYwczfVK3/UVxLxtqK5KGcULw6Rheo7/IIiCsUFhyBJts
eVua/+Qv2mApY0Ojj2AP8yljh6C/KPdN073j8qM46cGhDunYv2jFVsy69fgo
ZqsaHb/17S/aTXTe+5sxilOvbJfZNPEXHRp94LrHhY5bA7zet/77i5atYzJl
YumY62uz+jOBGUR51tRsWEXHFtxuB3pVZtBOO+4dsevGMG/8T4dwqxl0O4wy
1FE1hm3+mGLOqhlUrcRvWrvAwHxRvY4ubTPoSvPZ8lg5Js6wcJLrHppBqe90
PmdrMzFnu/f9b+yz6ErOibCvD5j4feu3HS67ZtHO3weGiGkmNow43Nd1cBY1
7lJmHxRh4elTjYGGJrOI30f8sawaCx9qYTJVHGdRxdciXoMLLDzUpJjYFT+L
9DKP3onCLPwyNNXc8NMsyox/zPRpYmFNMy3ubz9mkfkzVUYmnYW9G0/ahLbO
ol7tZvt8CoG3hvSIcA7NogUBISJqPYFbTzpi56lZlCwi++/LLgKrNjyTMxSa
QyElZfNBZwhcGyxWmSs7h8Q+ZQufukrgeyZx91U2zKHqF9JcZvcIrEjZrBqq
OYc20ofu+j0jcHldbjPHwTnUxsctuvCKwDeC9J46G8+huU1GrnFxBJYxbtjR
ZTWH6FEvbD1SCHytlhGYe38OsZVxv+wuJDAl8D5S8Z5D+vmZh20qCfztOA8r
JGQO9dcb3ZBtJLCN8Ktojvg5JMPp1czXQWD+39SjzulzqOr6at2t/QTOfJky
35k3hwyjA739RglseWxP4tGKOfTqRbWHHEFgLqES89yWOZRbfoerf4rAKdUm
3CqDcyhxl95C1yyBTV90fwmZnENc3fN6IosEXjJ0sOFgm0dGz02b7ywT+L3A
vIiz4DxS1VZ4TVkhsFHVU9wpM496Etc97SfjGT+K01HVecR9Zm/oKBnHHI2V
y905j7S69pavI2M9frVK5QPk+dXcyqFkPlZFzv2QE/MoKtYjS4u8XpjvIVUO
q3lUdDvo2Zo5Au83qG++bj+PYr+qp66fJvDQ6vNPO+/NozdhR3XtyXoCysd2
HH02j85e77UdIuvd7XOvL+fVPErgZ2qEk/3oOcIdpPx2HiUVO3Y+IPv1nDcY
haTNI7unF30jyX5uLVNgsefNo/Op9Y5Mst+t3snR18vJ/A05+XeKCOx5ePfR
zuZ5tHh1Ta5mDjkfq37NGwzMk+8H/W82p5LzUWKcmDMxj6hjkl/OviXn41mX
ufLKPGrkiD9QGELOh549d4jAAmI/djnWypvALr+8bK6rLKB3tzhEda8RWGFA
j2dmxwK6EJQd/+YsgSs5Vn90hwXU/ej5PkNDAq+HFxM+ZxYQB+eurnebCFxv
dTxUxG4B/R7WjDSSIfDDB6J7wm8sIMrl8JKjvARu+xbq+d5vAX0Iucd+uI+F
n7WdWrcpYgE5p6X1Hqxh4R1z0mWf3y+gxszkpohcFn6xM0YY/1hAK8Pfiw++
ZGGdT//FtBELSDHTQf7bFhZm1VzRvbC0gPY8sey5LcHCUcyNQ0O8i+gt/3SK
3xIT/92YvnmatoiMN9+ILy1h4qSEr3lCposoee2UZ9BJJhaNKms/kLOI1gpq
xi8dY+D8XF+PiuJFtLJGOOvdJga2bzVca1y3iAQ0hy+mr2LgX2vqrlrRF9G4
+46c2R9j+H5g29w9uSU0laKWbqM0hnuf0iXSPJdQZPDTmAv1o/jl+5RvGi+W
0GLcjbdZCaN4708nq++vl9DaoiNqD+6N4lC2qYSyDPL88JtFl+VGsb7bokb/
wBLaettppuTcCP7sLHBSSn8ZGSsaGIaXDuGqSLH7qebLyGN3gaHoyyE8VCwT
q3txGeUYRXDOnxzCMtIbxhweLiNeBT03ya5B7FV46Elh1jKqKWpK/TY2gM0p
D79cW/sPuSeKu88w+/DClwmxH4v/kPJIObzb0YnfutnTt55iA//je1Nw3U+8
tWD1nPc5NuC/nlna+74IF3AlcnfbskGC8lbPyLuFuOfFgOILZzaY40qratyV
jxXizp0a9SHjptiIB4WZOLL4ePHbPDZY/s2dkbjWHQcLasRQ1rLDHTOqlJ94
EVprUp98VZUdqj8VmkTr/ESfw5xzC9TZ4XGiWyY4FaNaamqj01526G5Us1Et
KUFC25X5K03ZQShMe+u365XI11zq3hNvdjBZeL9W3KQePY5dMp5msIPqQr25
1/Y/6MTWHJdNU+zgmM1pppP7BykU3gyymWcH/2znnMuoA33ro9fWcnNATrXO
8UH9TjS5vu14qgIH3Nis12p6qhvZpGQZ2Z3ggCHF/9qrEnvRVm0XxzfmHGDJ
eOr+e6gX/atWe9FoyQF8UvNdzuv6UCTxrkr3Kgd0Eg9TfGP6UP324KPUxxzA
JsFlPPOiH+nkOum3fuGAHQq7NUJODyIhg41Xhb9xgPBmWiY9YBB1tA8+1yvg
AC5HpmgV6e97S5ZlmVUcMD+yuXDjjiH0CR09HDTIAWE8Oyd38QwjxRKVQwaS
nPDUkvd4ZMgIYpn3X3wkzwn1emLhUsUjKG84xitHiRMK3R+ZiUyRz32rJYqV
t3JCrW3D3ivHR1GgIdcBTn1O+HE53D2GnY7YGnogz5UT/tv7c8706BjyGs1/
6/qIPJ5z3G/v7TG0mu0Nx57nnDAU0Oh1I2YMUTafKc4K5YRTlwaCq1ljaL13
3eH0T5wgpnjZSs6bgT6+SU90/MoJDLfbRteSGaTLX6xWy+eEL5/q+tl+M9Du
Xv3KxEpOqLyU7s4lzkQGe4uOxQ9xArEY/MYolIlqjOPSLzA5Ydoie7DsCxOd
vOIhQp3mhIgH97Se1TGRZahWfRQ7F6i3ta8p5mOhnmSpHRa8XHDD9qr6AWUW
ulQ080pKmAvE7rvfZddhISciwyxUjguyrUendt9ioUnuoOyTSlxwc09u9yd/
Frord12SspEL3jayO156z0Ke+pvaXu7iAoc9DyiP61jo1bt3ls9NuCBYzWeD
61rSe98e/dA7wwW32O7GlmoQKLr2vAL3BS6oPjr6xIj083/Lsj2PHLkg4aZM
J9tlAm0UXwC4xQXp+3M9N98hUPrG1rf/XLkgJ/zteKAXgXJOhdi6PecCfqvD
FQsxBNrndKN4TwAXnPsq7ceWTKBCrxPr50K5YCXNtmRvNum5KPVn2dFcMPzV
WCOlgEAVnwWGb73jgje7acHGFQQ6VkY/vOMjF9A018ZvaiD93FWWOPGJrLcr
Z5MW6b3Tf/9b/ekrFwRNWi26kx7s4H96zSmfC5aFE/qmSC9eWGtbqfaLC760
7ciJIT05uFtHbaySC/zZqk89IL187Tj1RVI9F7BtMowPIL3MurTMvNzGBeZ5
Hx40kV6+6f7nmHIPF6xzm2g8Rnp5Ljg3fWCICzZKnopYJL3rnhQu8o7JBY9e
rv3xh/Qwe8FtF+tpLpC58U2bIONnzSfrqYvk9VbHS2uSMR9z244udm7QML9v
9onMF8ApEhLNyw2xf5cWzi2SfpRhTVsIc8Phfm5pNEegiK1VZtIS3BAn7fPz
5DSB5A9/zG6R4wYXSrhYNOn/+HPPJcOUuCFY+ayKFJ1Ayrfs7plu5Ia5Kpm1
Zf0E2qzVfTJ2Kzfc8c8wVuskkAbb6S10TW5okvwu0d1EoL0ltXw7tblhVK3j
dU81gXT99YceHuCGGx4Rq7b9IpC+SVFhhT43nMgzDKz9TqATUnvfrDnBDVrP
1K/gz6Sf36uZJltyQwCP96hfFIEuXUvYMmPDDUd5o4SuBZC+36rAr3OVzOcu
7hrxmECuecJFzbe5IZLH+9CwHYEePX7+hubODdZGnxDvaQI9P8J+3+ExN4QI
Rme6HiFQWOPkFo4AbtgYPeJgpkKgN5H2/Eah3CDQ3nwlfw2B3l8YGAqP4oY6
h5gTrpyktxlNbzYncsPWz0c9GB0sVMOVy3+mkBuOxDHPlXizUFPFtuF3pWT9
X3g/1juzUEfgxyJWNTdUJ+jc23mGhehy0fe92rmB2v5fCpsqC3HvfDicPsUN
V9OjfuT9YCKBxdmihXlu+PFAXt//LRNRCp1jDrHxQEx2Y2u2FxMpGtmY/RHg
gY+N73yp+ky079KhnzzKPJCR5PDBuIKBDmzKjzFWI49/XpXMn8RABhOartHb
eeDtuLuMMnm/Of1Addt2xAPn8y12PNRhoFuh/LHnTvOAvseWipa0MeR21ss1
0YoH7KPcgz4+H0OPactmUxd54GjzCb4B6zEUmMoS8HHhAa2z926+pIyhlF91
rpm+PNCxpzqwzYGOBv6Gm/P/4IGv/x4tS/CMonidHTc7f/JArv2Pq4X1I+j8
i5qA9AoeeOgzc708ZgS1r+MuP9nKA/dEbsXMaoygupM39kZP8YB4clrm5BnS
6Z8NFTdvXAUPCiRN470HUbgjO/1Y+CoYSHOciHXvRaa50Ty0mFXAWLdnpn1X
L6Jw71aaer8KQg1WzBIme9DLaCfL8IxVILPLZR9h14O8Kv/UdFevgs+fH2eJ
hXYh5w3ZX5y5eGG8Kfva6L82ZDB47UGwCy9sVRj16bSoRXoPlFIO3uOFYy1T
NyI8fiPdNR3tMx68YKR4d3+6Xg3SOmS0+6w/LyhK9rZ9aKxEGxO2TCl94IVP
B2LPvBkpQfyXpq9kdZD5G2JX17JyUdXAA9PWw6thx40r63hsUnCZu+YT32Or
Yc53aGNixidcLE583me2Gk5us17s3/EF5x28IPzWZjWUBtyM7NHIwSnvdSuu
PlgNIk9DNCMlC/GLi6tgMWM1BPg92fFrsQIfGwjcpKDAB/hn1c9YmRZctWmg
0XIdH1SpZbmt+68FH725yyNqIx9UrKM8UdnWio9wdNVK7eKD1Wypr6MPtWFd
xU13xE7wwd/Pn/aOX/6Dd1r+KuB9zActSb/VMwK6ceY7qWuHn/OBnb5kRBdv
D94+Zi/27CUf3MljbPDX78HqrhQ7zig+8Pq4da6tvAerRpzn//eFDwpK55nS
Jb1YrnHebGqQD17OB9uu/N/jskYr2xh8MLh8WGpgqB9L28YlOk/ygbH7WOJZ
2gCWmNRbZP7jg+/3m8/9CxnAIiIhcSOS/BCTRoki7gxiTkP1sU59ftgelp54
e90wfvzqUYjcCX4YNo1Umz01jNn+NGqfNecHT9vPKXO+w3jpqltgqw0/NJ4+
duguMYxnvMt2NrjxQ7B/I3EwYwTTf9p4lqXyQ7Rsgf4+BTqmBrVee5nJDyOT
7EWdhnRsanXMzPQ7P6x9+yOgyZWO8+f2bOwp44f5B0UvfjbScfBm0cbZfn44
NeOXdd9zDJcuPMv/QeeHwt1XzqUljeGl0qXEJxP8wIceBm6tH8N2NiMPhFf4
4WNTqLc0jYH3hmMVFRkB4LaJ1rXJZmDnizspTEUB0A7USBtuY+D/tiUvZagI
QGqLy0LGEgOLVIXV7d8pAPv6cr9KAhMPsDm5mZ8QgO3NSTYc+UwsXdN/Se6U
ALy63nc89g8TH4s6c6LvnADU39oS6zbHxDk7D613sheAieCNngTpBf9rcr+f
PhOAwn231n4OZeHCXcG5R18IgHETNO1MZeEZLt73oiECIEoTip/+ycIXYqfu
vXkrAPbdeQcUCBYOdbhqa5soAD0NmziecxK4Yk+30YZ0AYh48iN1gySBNRor
1mblCUDA5qJmyj4CX30Lgm4/BSDOQ9LujBHpTafsWagQgJTdFjzN5wjMuzq+
qqpFAA7tM2m67k5g7WbJr8FdAnDmU8x+f1/S5+9evD09KAArf/jVO8MJ3Kl9
/87ApACwn682lP1EepyfuPBxnly/wY/uVd8JfKT14lFnNkFg51ldoPKLwA8S
2ndqrhKEa6IXUlxrCJxx44TikqAgjEtFX2FrIfAwKuErEhcEfteiHzldBJYT
3PfXW1YQZhO4Xd8NEti4/XO30VpBWLQpcS4YI/CzDyoVYhsEARghrsITBP5+
601m2xZBODK+7XbgXwKP64jFxmoKQrVjwIED86QPhX18LmkLwt7rddUqSwS2
6Ph3c9NBQQh/f4x9/z/Sx0m3rCYMBGHwT2DtU9LfxXfoR74aC8LSKbMdK2Q8
f+DCjgenBaGB+4XyRzJWF22WP3BeEPYFWqY8I88fejH0OPSSIJz7dccmj8z/
hm92eNheEI7OhZrsXyCwqfcqI60bgqC7Kc9XYJbAAlxSGf73BOGhQ6ecyhR5
PU9VyW4PQbjk0q3wkkVgt+Xd7tueCoKN7OuPOqTXt7vq9z7xE4RvQ3WdOqTX
6TNn9JqDBEHtgE77S9Lr8TevJatGCMKN5he/VJsIfGbcVcQtRhA+JBqWC1cT
WMTR73b1e0EI0mITO1hM4LLRqHZqsiB0PpVs/PWN9LFdCrrxWRDMhhk6oeR+
avbnvS/+KgjTk8WhGQkETujodLpaLAifK2VGWl4Q2PIMq+F7hSBcl0hy6PEk
sHjzv91CdYIgvuZ0/66bBH78m8r5pVMQrIa4uxrNCKxluPUK9wC5nsObV8nq
EXiiDKpP0QVhqq3I4fNOAl8osg5fmhGER3yrbWopBJZCN5aOLQtCmF5B1hk2
Av/+/tj6LacQxL9lVWswWXg/qWI9ESG4tdyz3FvMwnKJgzhggxCMZwWLrHdg
4cZ1M+v6tgiBZ1kMTd+Uhf3e8vhqaArB9aEN+UV7WXghUsW0TVcIesxrinN4
Wbj1xdWRtZZCEDawxF0QycSBfK5Gt22EIDbF1jzuARMf9vbNKL0iBMv1mSPt
55k42zPZ3eG2EOT4L920XsvEr24yRbJfCkH27wCz0lgGNhhfvs0bKgQv5ddW
+T9gYA5HoT8WUULwYudvpQwL8n5jtyVh5YMQWBz38qGKMfCxMy579AvJ+u6H
3YlyH8N86K91x5QQ5GmfM2vaTsf3dFR5sxfIfFwyt49y0vHQgbNpAezCUH7X
l7mmYRQXHSlc0BUWBouYy4MpzqPY1eTFq6SNwuCz0fY3z/sRPHZp/a871sLA
7199I5xB+t3fTFX0tzDs8br+w064H2sFPK+hNwnDf69NnilW9+HEoO+3ijuE
oXKr7X4r3z7sFUYrvEsXhmOrjK0dOPuwQu2MGsEhAvEcppe4xntwc1vRLzMF
ESjqveF49WonPsy0mF1rJgKuuVKvLCYbcIz4k4aHp0VANs38v7zTDXh6b3J6
x1kR4PD5+fFdfj2O8128HGYjAr1rKtuFferwgkp062pnEdAsWf3k9bYanGLT
mTvuKwL8R4XzPY8VY5HW8+75BSIwGfwtfeeXs9huxfu0bLEIRIa+nMnK9kR5
yp807pWKQOrh4g2ZLsHo6m025rYaESgxX6dpe+wdKqK8PZfwRwSMqQ9/nsn9
gm4Z9e33nyHzm54LEOv9iVqLLrJbqImCatYP2fQfDWhcp13mwRZRyE4QFM8y
bESrCo9rxG0XhYvyISkGfxqRJta6PLRbFMTyHtlLzTahkO8i1TcOicKZKorj
iGorOp6ZF+FnJQrT4m8Wsm50oJIE8a0/AkXhLYKug4f6UNc6X/2eV6LwO1Fr
ofdxH/r7bsWGM1wUzu5vipYq6EPr4umh+m9Ewe9wlprRnn70OKZgsSlJFPRU
Jv6mKQ+g/eEOpawiUThuIzW4mzGIzCX6ekRLRMF62CC9ce0Qcgw9taBRLgqi
QxrE39NDKPqV7ma336Jg16azrvjnEFoIkHq1qkMUHHhn9K6/GkZZz4utFP+K
glSr+UdemVGUaFAp5T0nCru8X5WfMhxFkQL19cxFUVhzUlGfw2MUeQZ2633n
oMAqqegLF7tHkWHEgrq5CAXuDCu804qkI2TBPponRoGlbeVndEvpaLsc7zsl
SQpckuP9HTVFR5JxayQn5CngdtH8LjIYQ30ftq74baLAycvEkU3EGGq6uit3
Up0Cn08qn4+XYKCyTftvntlOgcJw/1QbbQZKTT86rLyHArf2jvB8f85A977a
/S7Uo8AT7+b9nySYyP6+o4+qAQU88tf5mO9mIqu9tw4EGFHAsPh62v4zTHQA
P/pqaUoBG0NDzboIJhIqjY6dtaaA7wdjjlEhFmL3eXfG6hIF3mtzVXhvZKFp
g49iv65QoG196kGbQyzUVvPVO/g6Bf5VjUaX3mOhqsB8nfkbFBiz5VMzDmKh
fJNfi+fvUODEgwN1Ykks9L65/vrmBxR4cy9yTqeZhcIj2jaEeFLA6PVX05Qx
FvK16OlfeEIB/R1TrkZsBLrexTxV5ktef5Apup30k03ctOiWlxRI2R729NYe
ApnaLFaGBlFArm5n+ZgBgbSGeME2ggKZm0f+3bEn/ZgovFAeRa6Hfae8ryuB
FK9JZG6NpUBp1qRt7XMCUdTkncLjKbA/W/uOfhiBuFlKqv8SKLCx5OrSdDzp
5fSNfReTKJC7m+t9fRqB6C7boitTKMDF10ztyyVQ547d5ts/UcCnaVBFqZhA
tX/3i7z+QgHnj/fvh5Ie/fn1UMVKNgWaf0i17G4mUPZ9Qy+7bxSoWfDnFewi
UOLek/urf5Drdx5oFx0kUNTymbkdhRSojbqheHiMQC/xhYzIYgpcCan7lDJO
IM9Hlx3YyyjwQ7j/iu5f0vcHnJSvVFLg+eG6jbzzBLLjvt1TU0Pu33fhrmXS
4zLU8pbFOgoc7Btz4Ca9X7Nb/rdqEwX2NDZ6niI9/9jEpcSslay/1JAyTcaa
Dr9+PP5DAd6QP/L//zyA/lQ6K72LAu3lQu8FyDgm1jGlo5cC1sn3k56T/jfJ
LXy3epACReJZmsfJ6/E0rInSHKFAg8H50xdI/39jXA22HaOA9xdZah7pfyee
fJ9AFgVe3g2OtSHrWatIefRjggLKgs6TJ8l6m/fY3aNPU2BdykWNQLIfvie/
XZeco4BmstIzyW4C7XcUunxwkQKXS2wE6C0EmnxmY+XyjwIdx9qIVbUESojL
NothF4O+A+icSymBTn/jM6rkEgNkZvhUOZ9AAo1WB+dWiUFNTXa0SiaBbq1a
tcNESAxY8tc9hWIIpEo7u/GhqBi8fCdZMR1EoA6tdFqKuBjYb6xdVnlKoINO
p0R4ZMWgOb9F/85Vcj68k1ftUBAD8pFqJciCQClvV/6dp4mBl+1w6yI5j+JN
H5i5KmIQkuJv9X0DgQb2zlU4aoiB6vmd5tNdLBRhZlgUuYvM/3Mi06+ChQyv
x+WWaolBywfGlVtZLJQZfySRpiMGnBN8X/b6sJDX6tdPm4zEQMzuRms66fvd
Skx3DmMxEK54UNNNvl4Z+3RubTEVg3MDVrqXppnI1HnUxsdCDAy7NNlukv5f
17IHtC+Lwd6nl9WTDzNR6/iLXdeuicHjujyTCFUm8ufrUw93JPuRtU24h5eJ
prV95SduikGXX6fS41IGKn7fvvDeUwzSppyOryfvP7Y33LIEIsWglQ68EXxj
SHN7V9aGN2JwK1cvz6KPjvgmIVsvTgy2yXl3+ubS0ScXnq+e/4lBtmb7gKYd
HS05B+VMZ4hBtMsNakvOKAq7/uF7R6UY5LXITfMdHEHlDg2FKctiYFkU/8Bx
fgBFq2kWlbOJQ0TgKlRSMICcGRFFQ5zicKGV70+q9wCScLD6qcgnDiM1Nx6r
iw8gG/vR4hAJcXjkdG+LlGo/Wrq6Uuq+RRy+yn9xT9rXi7Zc3lRjaC0OegFP
xdQOtqOuq9TrqRfFQatbMoDjUxvydxATEboiDhqiabs0ZNvQqMui8W8ncdj5
dNvKV6IFvXOvbDJ2F4f98g9+fwxqQpLB9p3m4eKgvVnyv5C8WrSSl8y4UC0O
ClY37fRVvqPfFDX+23vWQL6B14uYbxV4v6PjaNS+NXDcNtJVq68Sp5WmlRah
NeDAdzpCa3U1fum+zUtEbw3s90j8YGT2GxsOaS4nm6yB//Svtz6drMMVuTpE
n/0aiCuwHU1xasa/LpxqOBGzBuqd/ziPcXRjje8Rn+++XQM5/NUvxp514/dr
2gNi3q8Bf/1GLM/dg70qLA0ZH9fA2X2Pvp737sG6Gja/vL+ugUgZexkv715c
sMrxa37tGhgXCLOTut2Pv6c9jlLjlIANnxw6dywNYR5DM5lwHgkQ6IDbkxrD
2HhU5TU7nwTsa+D4JuU4jIeVqsOaRSTAknwCC/szjMVeSwZ7KkhA5oDs8pbP
I9hKky4yRpMA52M7/LkGR3BSQ16A2XoJ+LpNI3On1ChGQjYvNqpJwM81Cq8S
3Uex/ZOU5417JOD1RoXWFG06zlZ8uAppS0CUyoSlrgMds+cbP0sCCfjx7cON
jZF0HD4388TjsAS4mE/EMqfo+KejzkNVMwn4a5Guqhg7hmVPN992d5YA6qqc
/XoNDGz3N3F66Cb5+9ceBz+aYeDPwW43je9KwMJducp/UuTzcLWii7KHBLwa
U7T7fpaJb+raO9T6SYBhm0/2+lYmzu/WHtMKkAD1uulHp/8y8eoHItcSgsn1
XbufVCLKwrFfsy67vpYAOTUnFZMjLFypxma77oMEdNILsigpLCxRUd/78iOZ
n/fpGkHSv9aXEy7Mp0qAv6m6n3YbC8++NbCqyZSATVZVd/aT/tVF8p27cyTA
00iwTZD074sO4uy77xJA767fILqRwEqSoWfuFUlA8duFxM+kf50yL7f2/SLX
0/uEaWRF4FxjrVNG5RJwcmDQUM6JwFyEQPPXKgko3WB9Xu4BgY/7d5uurSX3
+5hnkZEfgSM3ZDT4N0iAZqCM9KcIAg+WeJnMNkvAGw1z/gOkl9zYN56o6pSA
a5r9D+ZJDw8d5G9V7pUA8yShERbp4RPPGecfDUjANj27E7K/Cfytsnr4z7AE
hBzpdfcgPbxOOP265pgEJC9f3y3VTeCXJoGzgSwJGBdbNhkhPTwX6vJwbEIC
TCqd3rJID9u0mazS+ysBXdyJyxtJD1fJaQTEzUlA324fvTekhzUvrJFcXJSA
B/snzh8iPRz3bibGbEUCXqzK365EepVvuEX5E4ckrFavTtEkPXt7Y24aH48k
4MtLBQ9J7/Y4RmpeWi0JF9s2XP5Hxgaf3fKxgCQIGGhEZ5Bx5rSlnoyIJMxo
LlpHk+cr7N5fc0tMEtJLrfB3Mv9zN6r5bwlJCItHBSKkhyfz2bo2yEhCzluP
21EzpCc5+i55yUsC75Wl6bOTBC499JPZpSgJ080RZ0yYpH993t/es04S7C5u
/+kxTODoqqfLr1QkYbNxgnlvD4F5RC4/ZW2UhDxcoe3aRmDnk0cE9dUlwTn5
7gf9OgK3h20IfbdNEk4VuJUeLyPwwXY++X8akmAtFtfsn0/gNHnG+9O7JUHu
ewKFPZPA0tbVal/2SgKH/sH8lEQCe71PyxREkuCvpEoLjCYwazhg3xVdSYgo
GPdODiBwkZOJoby+JOwYs07xI/2rlrGj8a6hJAzzzcoaXyRw2F9xy/rjkvA5
+dDUcVMC27u32HubS0La8vSNxW0EbsY5U71nJCH1idd0IpXAwBnptu+cJJxu
Xh8YJED62tfSb8JWEroOhS6vGWBhj2ptMcPLZD1vPH5n1LDwiAg16r9rkuDW
l/TdP4eFf4T3fjzrIgkuz4SkFnxY2C7BruKXhyR4J+2wqVRi4dqRwyaKj8n+
Vbtdsib9q6W2od31qST83J5wdQ+DiYW/jI1u8ZeEMp1ynYzPTJxT4Lw68rUk
XJr2r/+zg4nXcpkETUdLwgV18XNhFCb2P7xD+nicJDTF3FyMGGdg65q/qlwf
yOvJXmi8/5GB+TpcjzhlSkJJWnR40RoG1rybJBjwVRIihWS3u06MYWtKa336
N0nYZzXJHlE1hnOO7Dw3USAJdKFJ59WPxrBdFuFyq1oSbvlZvGzvo+PClxej
XIckoQ/Kbed8RzFjw6sLUaOS8Nc+zf/+uVEs9atwfR5DEjzf2che3zKKnRYV
Pi1PkvOXXGrzvW4Ey11pK/ZckYSeA7L8f4VHSF8fYz2TkoJdl7nK2m4O4fcd
7l8+yEpBrXati8L+Ifz7bvK9MgUpuCDU8mlk1RBWTuPl5FsvBaPWbyIpkYO4
Qean5IttUjD8r866M2cAq0/v0nllIAX/TOiS1r19ePA/WkisuxQEZdkmW9Z0
YoZX7zynpxTMaRUpDml34kmbt+evPJGCT3+3GWekdGA2Km3TNl8pKPPQD6c9
/4NlwhWLisKlQH6e87+fmm34hDd1fDBDCpbHjpra3mnEeZflDdVGpUBtuCna
Q+MXDlGV5so1k4ZY/pUymulPZGml/KH/tDTkhB6YuOZZjNaF7DAQspQGe4eA
u5DyC2WuGAXa2kgD7fg9jTscZaix+bGc0HVpCHZV3GiaWIXEnjI0bJ9Lg5EM
9ZQovR4F9+JLgt+lwS2ZiArFf5CFZDXv7nxpoNhaz2sf6UBrjdqTbQqlyddb
bL1ebQfKyJme+FoqDawUoRXHrk5UH7DBw6ZRGvr+5OzBk91IdP+rsK9MMr9A
RpPzUi8KjLQrtVaUgeP2hh6NXwbR3TuPb7oryYBVUQztDH0QWZnEUMOVZWD/
f18W7RSHkBpf890qNRkYouIiab8hVH7/kOquPTLw56vc9jyLYcRxZp2PgIkM
BE6tYrD3jaBRDdipYiYDDWLrrcJERlGtiGWvzmkZmDyx+m/8/lEUW/Zqz10r
GRB3/Ziq+HoU7dvNSe+9JgMfTPWyXh2mo9uSfQZfn8iAEsVA+4XPGLKcWp6p
eyYDVyV+3tmZPoYO/pZ+x/CRAdo+2fjDjWOI4m28SAuUgZ1N3an/yTFQ2kxB
sn+0DCQPfL+q9R8DhdZ3nPoQKwOFuwQZcuTzpXvaHGdRvAxInZO5aTvMQEft
tlrOJsoAW/9Ms7QyE400xQrYZMnA0dsbE6Sjmej35+857jkyEFZYPLg6h4my
X7RcDP8uA5f/7RM908BEXoeEf1QVykCJpnyHKC8L0bI8HHfVyMC+JMPRzqss
xBsUKW1SJwN2abki2Z4sNO6Q/cuhUQa2Eqb9I2GkX9ex5OPbZcDZ/0SKZSEL
WYScqxEYloHt9mKPnYUIJPeFT9aeLgNiFK0RHxqBuuu+Xi5nyoD5lam4jh0E
uihMYX82LQPCH033qpkTSFkdGw3MykBZLaeuqh2BRg0dInUXZWA6+Mzg2duk
j3xLdqywy4JS1cjjK6Q/tibd9DzHLQui36gVQPpkqlSx+juvLLz6sHT4+EfS
k0PV0jICssCf+CL9VRaB7nG72d0TlgW+Z/QcwQLSw+tUvzRTZEHrpSbtRzmB
lnWbVjQkyHxa8R/f1hOowPqx4StpWTj2zUHuezvpQc8tryfkZGGT9aDu6j7S
O7Edg8cVZWEfw4HwGyHQqnyf7WlKssCVdmdOl0Wgig7NhwIqZL5wnz3qUwTy
X+yvvLZRFkoVdF4ZzRLomEyQVPlmWSjkPzYWt0Ag0T37L6lsk4UvsnfVVEk/
Np4a+/xUQxaafF/r9ZM+DbsT8a9/lyzQXZPU60lvng49dFR3ryx825PR9X+f
ymZOhsftl4U1l5vNjpJxV33swD8dWTBfOB7RROaLmzDcdu6QLDipOKe/Ij1q
I7Lw4PsRWbiqFJv0lPToui0fKqQNZeFR2dnIZNKjQ0amkveOy0Ka9N5IbtKj
SQ7sF5tNyPUmDJe8ohPIwS/tk4a5LFArFA+YDxBI/ePZ5eAzsjDemKv5/793
Hy/jNZiwlIUpntc195oIlDGcFXb8giyw387e11ZF+pLHtj/VVhbky2VynH4S
aNd6ka0Cl2VhW3+n+55cAuXZXCsvcyTX27aWcT2eQB6PJCVUXGTBwo6i2hFK
IJ24Ypunt2Qh1HV3rcdzApV0KizpuMnCTuPT+Io9gZ4vVR6J85AFsexJ/Oks
gY7K3g/990gWEvXY4rYeJVDt6Qb178/J+l8nJrapECj4rqebtL8s3ByuyuBc
QyCzsM1ldwNkIbDN5fxldgK1N3hba4TJwuJUxevOFhaKntRIC34tC2djwrdO
kPN/XrRvYTxaFtjMhN0hmYUGju0LSX0nC9pq8vdD3FjoP8fRHv4PsrDCN2ER
acNCV/3DNl/7SK6/o9+46wgLscrHS5Q/k/P5ji6uJMZCcwcT5mPzZaHhdr74
lxgmcv8e+6S4UBZk18bdb3rERGzbIwVHi2VB9euG8ZMXmWgVNYC2vZLcn6Ab
CZdVmEhi/p5+cYssJFzYtryUwECR1282jLTLgty5hHiKFwPJDzmeE+yShfMS
AX98rBloXYONi/kAud8H4vjiZBhoR6rh65FxWZAsdd766OkYylY6rCQ4TdYX
L6WWazWGtCJ1UrfNyoKIybTUmV1jSNdbs9B1WRaCJEM0Gofo6IS14qgAnxzY
W+mo1+6nI6c107u3KcmBrkrQo/SGETTpxyoyU5aDLbHr1ze+G0G3OUYNXTfI
wem47wPXb44gd6Lzws8tcjBirsMSER1BfuWlz832yYGRTp2BpN4wSnwQ1Xrf
TA4mhSS8tkQMov5B3XtF3nIw2r9mL2ugF+nG1sRv9JMDrYzOPHpcL4o7bVEd
/FIORPdfV75l2YusKl3W2obKAd/hknSN+h7U/imuivOdHCjdZr+0z6Ub1bv9
UzyULwfSL5XljAfbUZHot/LSaTmwSbsT4Gdch+K1t8lWW8vDjh9qNRV7PuCi
Y3xPFi/KA7eyJmfXcjLuO99P33BFHvQ3OBGJFz5hpceh3545yYOgyyq/2bVZ
+H3J/Blwk4dyf83PXm/zccLxoogvIfKwebg/+MiPMpxofVIislQe3oR/iPkV
0ITLbqh5lFXIQ+TzwVEjajMeecI9NFMtD5nZLodOpzVj1f++Zp1slIctxzbc
HapowUl0WTPBXnlQOoodA5fb8MebA688F+Thceux4zZ6XTj16W3Ry5sVgFpw
FLup9mPGvnOPn25VgMPMjum9F/ux2vTBqXc7FCDwkItwcGw//mgj3tSzRwG+
MbX7F8QHcCL6EmGhRx5fTBCPXhjA7+fHqcfOK8D44tiywKchPPCpNdDBRgH4
RQ48jxgYwkpXCtj9LinAO5e/Nf9JDeP45oD+UnsF8BUpUzz8cBjHflH/oHNP
AVQ891nc0xvBkY4O6juDFGBT9r2bGd9Hcfs609iTIQoQ/bLUmD48iqU79orc
CFeAYdel6yFidBxhwD+Z9kYBJK3ufNl7lY5DVT5mqX5UgFvb5GbyBMdwY1eQ
8uFUBQjeOn/OcecYFg+7H37pkwLMPmodeG45hoO59O/HZyuA5+PuheXEMRzY
O7xP7qcC+X7Lk1yuxcC1Eb9TtUoUwEao+FTeOQYWPvFV4Uy5Apj5bKsR82Tg
l/nP2MJ+K0BNa80mVhED+0etLxbuUAB81I3Yp8PEVSaCO9W7ybhzRVL3PBPz
8/1NMOwj662R9fnPnYl97xV7+4wogL+P9i/fLCb2NrM9yvlXAe78WBxOp7Jw
/PEOy0tzCjBFH338RYuF8/TNnEoXFcC4f9Zz2pSFJ7UPB/lxUGGrw5FVat4s
LLC7IJ7JTYXiUDCkxbKwyvY9mcdXU4Gvq9LROJuFLZU3tYiJUMFiw62Z830s
fFfx/chtMSqc0CV0tGdZOFhGfqFFggpVpQXbT/KT/hISlo+Wp0Je+1YuFdIn
fbzP1f8pUmGf5JGJfl0CL3Gww4V1VBjSTo1uOUn6bHbSZt0mKrQ+pntYk/4x
mrC/9UydCuN9X+kzjwh8ZWzg6cg2KqyrKvIoJL30ePBcuMFOKkSU6fQVkJ56
092cmLKbCvwPvQunSW/ltB3/JrSPCs+quWosSY/VN5RVOiMq0H4a5M+RXmNW
63TW61Kh8J7AsTLSc7xl31gaelSoK1PcX0l6T6loB1u4PhV6B5+YsrcTeH9e
iui8IRXW1p62vNZL4NPZ65XOnqDCtyT6ep4RAt/8FKPx4yQVRkZTnzWS3nz5
UVKPeoqsz0nnTBPp0cT3gaceWVDhldP1B7yzBP4Zs/pq/zkqVB9Sb3UkPdsV
8dj1kDUVnii/Pcm9TOD54EW/DxepcOO9VHcN6WHxF7ferL5ChVBFsesV///+
2JuZZm9PBQ0x7eVZMtZ/ZFdQ7USFeA2X56fI+KJbd92WG2R/vHLER8l8HrdP
9wfdpsKBrQbJKYsEfn29bnrqHhX6zP0s4udIf1814DF3p8LmVCHNimkC/7b9
KZnzkAo6K6/M140TmH5u3waZJ1QwDlrV/olOYK7TWVruz6ggdP5R//UBAlNN
1A27fKjwZs/BKOvO/39f++EcvKDCw+I89WdNBDbVU7weH0j239iztrOKwNfh
tSdXCBVkXx/NufKTwL5alGC7cCrcPMWupJJL4AQNv3dlkVRILkg0kU4jcIE6
V9bGGCoEtdm/RPEE/rt2poX1ngrPrQMvbHhOYBH566MnEqkQt6k/hnmfwBsl
RxYykqmgu3brnuFrBL7A3y5/N4Ps16Xc1e4GBHblPrmlLYsKAsMfRaT2EDh0
pRL25pLzV7AoPqZM4IqpH7YrmMxPbWTtYiPwzo63Sd7VVJA5WTXumsTCIupX
5tJrqUB5Fq185xULMx6qH25toIJfv+/gL3cWfq/0fUC1nQr/ZK+vXDRiYXH7
RmrFEBX+i1C5/2mIicfzIp0mR6lw2ePMF6tK8vUuZP1DhkmFlMy81kvpTOyV
wbSwn6KCu9EWy0e3mXjBnfMoD5siMGY7TFbmGXgkwe5GJLsiNAnOtj1rY+Dm
mvLX6pyK8EXkXoRDDgNnKAaOmPMowtLMjwSzWwx8rVju2QcBRdCTs1f7MjCG
2/g1C49IK4LDGqGoE4l0XKLxeqRDRhFe6NzfKeNBx5nnloRd5Mj4pDo6fpKO
A9OLrF5TFWHD7nDblcVRfOTk8aXR9Yogn7drIVhvFOdEXtnlt10RBO/o/bta
OIwjNkSlVh9VhLC7xX99zAbw9JRewhMjRbg7+72ha80APp4/Gb3nuCKcSLZ1
SG/qxzwnDfwTTBShp7bTvuJkP77tPn/twRlF0N0yky5h0IdNfp9S3XxZEYa9
b8v7KfZggdvi7/wfK0Lmbe9D6zhb8MOCFxFHcxUB3u03fS2aiOmdBSHz3xQh
xboFV/C+w+aLU4Ef8hRBue94Bs9KFFbTtPDhLFAE2xt3Ph+/8BC3Jiu7fi9R
hNmph2lie+PQ9nB8dlMjud4eMQ32XXloyHFCgZ9QBN/L+oh7ohYZ+62TzR0n
+8HmTzf0r0N5iackL0+S13uXvX29Sj161f9D+OdfRcgWWqNz72wDgjO+bG5L
ikBMur7Uzm9CkQeV+uiraXCmN9xy/ko7MpI1S6hYR4MLu3uF66J7UcSAesFZ
ZRps6vvz8dqfXjSQyvuHoUIDe4WX795K9yF3yBMR3kQDH6U0476QPpRyScn9
5DYanGs1C/F51o/4Pk2YdGjT4B1SLj1mNojM71c6OiIa7MRdYmtfDKJ43YTn
/4AGfUffmnsUD6I9TafzFQ/SYGYyd75q2xC6soA3XDKggefutaNveYZR6cGX
bCxzGrSlJ3SrRYwgitAV2YenabDRYrsoT9kIsmrR0RSxoIHuOxdr89kRNHP1
r/32czTQTPhw9LTpKFIOsGy5Y0sD7h4lp1+r6OjGac3JVZdoEHhs/MPeHXSU
TxMRfG1Hg8xD+zfSrOjILPOn7ver5Hq3F57SzKAjr7aNaSvXaTA5tX6H88kx
VBvPVR7oQoMrkqvuHXYdQ3IOXf20mzQ4T5ubeRY3hr78C5I+eIcGz8f1zuwd
G0N9SvNez93Jfmm/uWh7n4HUmfWx0h400P+3Q8ouioFcs1O+fXxIg48tg2UV
eQxE0b8wXvWYBl8s9h34usxAOk6lZ0V9aHDIsujw6ntMtNA6qlfsSwMREc/K
G+FMlHlAYPtdfxq8YawoyWUzkbK0MW9nAA3Wnfuyd9MEE/U8uTkVEESDoytW
bgGCLPSaFdql+4oGdXElgVs3sJBAcXtmYhgNzK2FbilbsVCJ+nLs2Qhyf8TY
6ffvstDD11Q/oUgaHP6v8+mqQBaadLpofesNDeqvBWXX5LNQqzRLEN7T4P2P
0+VLFNInXiLzkwk0cEnkkhZVJj1DbB9I+EADmcM1imd3Eyi/+O43/mQasK2v
ePzSgvTulsiE/BQa9ET3/btzjUDbIvMCXdLI9XbQ77y6T6D319kvt3ymwbTy
jRY70lNW7Uomvl9osJKjzS9PekvykJ62dhYNorPC6rjTSC+lX1Edz6ZBlo5y
pyLpM18ZP7F3OeR+PqsedCT9dvBp6j+zbzS45vUhkUH6bpn4PcqbR4N7ZXwj
0aT/si0mG7//oEHZvK+9B+lD51/iBU6YBm76CyuBpB83bt2VTCukQWL+tbuN
pC/7I8+ENRbRIOfClqQjpD+jud0feReT84U6XZikT82dYxy0SmjgdcbwSxHp
V5E/BaeYpTTYcj7CtIz0bfmhft24chrQzGi6/0j/Pv7ErX6ykgYGYv6OF0kf
75NVleappoFWfFH1AhnPPDXgyq2hgeydaatCMk4fdyDsa2nw0DtsbQ7p7ytn
A9oV6sl+6ttSu5cItLbk86+6BhrMPbSw1vz//19vbfzk1USDWmbB/I8ZAoVG
zUTtaiH7N0JduT1Jep9H2pveSoOLxQdfWDEJxOuy98abdnLeqfDr7jCBiv6c
O3eigwaP+S9VF/YQyE3vfxXbaThV2x/AccotbrlU6Eaps5dGUxo0KPsnhSgi
FRKOVH/SYNblxo1UGmj4u2kwRBIinQZjC5UMZQqZShwcB+csUxmK7url583a
61n7t158n2fvYJOpn+l9UzSp3tRI2DWZ91Y/b+VA3LKXksIqwopV3qi6tnHg
mHXzjeK3hE0OE8jM59Pzcxt4U5dPWO6AzNeKDnq+QVfqlHiErS02L1/TzYF6
0+w07duEvaLj8VwgpPdH9h856SuENb5zPf5WLwd0Rthzc4IJm+PR4CdB6H2z
tF78hktYr5ZxZ14/Pd/v/vLuloTVMF5gfniQAydZrVvGQNjY+c5q775ywPNz
rlmMCmE3rlbXch7hwJUgHtddhj5/+/C60VEOSBp8KAv/Jmal/cLM1H5woK1J
sC2nQsyerE7xDJzCgG6Wc0i/r5j9vdsrcLYUA5yp1rk7HcVs4uSmsOTfGHDJ
2Cfz04jeD/XK6FppBladfjHLSUHMQthQgYYcA7VOWyrUH4jYpjt5ZUXyDEQ0
BERtCBex3ryztTazGXik1bQizl3EJn+Z2x2qyMDZ2Gbbv7RF7Cy9TXKfVBiY
/3/NGb6P+th2Enrg8jIG5L2ij6682MsGTjM/glYw0Bgbc5Lj0ssqLZjrka3O
gIrFyaN+m3pZU9OHoZ1aDLgVCN/u6e1hnyS+T928lq5fIRv81aCHDbFVGhcZ
MLBUfGIoivav6snWqaGGDKxTa28zpv2bFZYsq7yNgY6C3P3HPLvZPt5GjpEJ
A/kLyo2U5bpZ6z8cTWLMGbCUPTCqvEXAqr16EGW+n4FAvfXu2RGdbIXGaGKL
PQMnYrUzbGw6Wf8oE56bAwMXZ7bWhizqZMtdhZVhXAa6HvMunMnoYD3l1WXw
EQaChcmuhiV8Fh9ID9D2ZkB5T6qWsLONtRt96iR/ma6v4Pix8lkzG6lZtKLm
JQMPFheYDvS8YpPX75c5U8BAk2v7QH5KEYsNhwU6RQwkyhvPmuNWyIptl9y/
+oaBDP2eeFFFPmsWFr7Q8h0DM4uMVGbk8dhprVYKVY0M3JVandSzzxEHRPIn
3g8zUNxpf7Dg8Gt87XZgy9/fGDgU4JEOSW9wSpJiruYoAw13ymx0O4txQ56x
/+XvDNQpOHVyuaVYV5g6uGMKAoebWseaLStwv4G3oFwOQfbZ6TkbptXiw0NS
1aUrEKwUJ15Ttf2EHVK2VthrICjJN/syt/UT3ssNLSeaCF64WsW7uXzGRpVT
ixV1EIh8y/nyx1rxktQpudx1CMp4NlLSuV9wp7PE/TFDBBLXZRx0nrTjlnlw
79I2BHsFn5MtSDuurQqKXWiMICtyP1dKg49f6/+M3maKIDkef1BP5ONE5ckr
V3chWDa4f6d5RAd2qfnuv/wAAjMPVYViiy5sf0HPN88BwbPNnJbMs13YGgK8
LJwQ2DfumrUotwtvTR8/5nMQQWTHftUgNQFWCx9zLnRFYBq86NPSAQHmG4zs
sPVF0HGqgNHyoP08qmva54dg8f3zFrkxQlyT4WscdApBsQQ/IbtciIsWfDO4
H4igpulH029qPfje2LDuwBkEwjZOY+H7HuycObjoQgSCe+TevgmpPlwiEyDe
fBVBr+aR1JUafVjTeWre4DUE1bK63qlWfXh0tsI++ygE8u5+p7zu9uEI77WX
te8iIP/ailatEOHhd/l2HTEITkk5HDxnJsJ2i42WRccheP1cb1jFXYSX1O99
NSWRns/SEsUpqSKct85/rC4FQcgNu/VptIeZSIm34WkIpP9aZNhLe/hc9/kb
bDqCsaoEE5c9YmwVHa39MBPB4xd7r0ueF+OsAc7EAR6CJ+7jl9TixHiBaUrZ
7GcI/rbd0XP6hRh3j+ccCsyi63M3e3zki7H5bsPVOjkIys87+deOijEvtVyi
KxdB+nGDmGmytL/sW25bYASNk9s2Sq8muOOpi6tUIYKqUO8X9VsJNpUV6WYX
IUhqDeQ27CFY8eVENVOMIHZeUYiXD+0VpbDYj2/p+7z8TWNmKMFfjv9x7FIp
gv+ZjbnUXyXY6G3URoNyBHmffaqrYwhOW7hQ+ts7BCpHnRdMphA82/9BXUoF
AtkmyTG75wT7VWknOFYhUO/snNddQHDLsqyTCjV0vif6N94vI3jLP6Bf+gHB
pVk28699oP3aWDLjdB0CrkZiSHozwbKrLBtXfUTgNsLTG28n2DO8MUnQgEBO
MV/BR0hwQzvX+04Tgpl2OztUCe1nvR4DyxYER/hmZ0eGCE647ik37TOCMzLj
HydpD0v3jbfktCKYtXK4cA3t0+NbQ1JOtNF59FylFU37tfbODH81Pp1vbRlZ
Ddq3G75e39bYgaDSfbm16Nf/zzvnz7nShSBifvxkC7VUUuKXLd0I3m9unvmd
9rPbpEb6iBCBamNsqDFdr2rvs4C0XgRDTXM8imh/62Zs3s4V0fMuy2o/Svdz
e3qxkhJBsMbBnRjS/Uo4mXeU9SPY0nvkiamY4MNZ9ZlBgwguPmV3BNP+fyfv
GLRmGMFthfb2jjaCV7kKdgi/IrA4GxXv30TwzcITyjEjCHaF/sjSqyF4Yt6o
wGoMQZz1745apQSXlEmH5P1A0MKP3Z7wlGB3w7bI0h+/5v/5IXNq+bzsmHrq
Z2strcZ4BNs8csvpp7bWULhrTi2IeDegNkHf5/TW0W+ZBE/bE+l0mTrj8Fip
fgbBhq1z9R0mEXhM1telPCS4a1+/2VFqK/UjU3dRh1eV2PpTK2VflPyaTHBN
4Smfa9QNf944oU/tnNicVkytz388uzKJ4GDXWBXtnwgK7a/7CBIIVmv3W76J
WvbPlLQL1CV2u9Ztpz7adOCpOrX8DsndB6lvP4hZe4L2e6zWwfB/qRWabvwc
iqPz9kDvZiK1wZaE3BvUXQsVkjKpNRfuNlkb9+t7+TeF5dSeXtEffGLp/i7c
rWygDpfRqVGk9p3i+6mTWmDpHv+Mzr9ygHnvIPWtFjODPdQvh5aM/aT+saEq
c/guwf8BSPWnVg==
           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999996187787015, 0.9999994313041395}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999992328657719, 0.9999997588489247}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999999574404889, 0.9999976139198089}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{186, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->665227151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->333506232],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " resizes for each pane:"
}], "ExampleText",
 CellID->30642317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47389411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{192, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675911439]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", "d", "]"}], ",", 
   RowBox[{"FlipView", "[", 
    RowBox[{"d", ",", "3"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->650262231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        "ResetImageSizeLevel"], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        "ResetImageSizeLevel"], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        "ResetImageSizeLevel"], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        "ResetImageSizeLevel"]},
       ImageSize->Automatic],
      FlipView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 1]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 3}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        "ResetImageSizeLevel"], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        "ResetImageSizeLevel"], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        "ResetImageSizeLevel"], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        "ResetImageSizeLevel"]},
       ImageSize->Automatic],
      FlipView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 3]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{94, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136561811]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " leaves enough space to display without ever resizing:"
}], "ExampleText",
 CellID->400562774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"FlipView", "[", 
    RowBox[{"d", ",", "3", ",", 
     RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->908772701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        "ResetImageSizeLevel"], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        "ResetImageSizeLevel"], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        "ResetImageSizeLevel"], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        "ResetImageSizeLevel"]},
       ImageSize->All],
      FlipView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 1, ImageSize -> All]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 3}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->20],
        "ResetImageSizeLevel"], 2->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->30],
        "ResetImageSizeLevel"], 3->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->40],
        "ResetImageSizeLevel"], 4->
       TagBox[
        GraphicsBox[CircleBox[{0, 0}],
         ImageSize->50],
        "ResetImageSizeLevel"]},
       ImageSize->All],
      FlipView[{
        Graphics[
         Circle[{0, 0}], ImageSize -> 20], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 30], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 40], 
        Graphics[
         Circle[{0, 0}], ImageSize -> 50]}, 3, ImageSize -> All]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{134, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->601077669]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FlipView Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->162604191],

Cell["Start by displaying the third slide:", "ExampleText",
 CellID->95901997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2418263],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 3}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      3]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180047113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76697582],

Cell["The setting is based on position:", "ExampleText",
 CellID->597442895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450667964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TogglerBox[Dynamic[$CellContext`x], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{52, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135223884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->803930813],

Cell[TextData[{
 "Connect ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " to a slider:"
}], "ExampleText",
 CellID->212078590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52549515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TogglerBox[Dynamic[$CellContext`i], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      
     Dynamic[$CellContext`i]]], ",", 
   SliderBox[Dynamic[$CellContext`i], {1, 4, 1}]}], "}"}]], "Output",
 ImageSize->{245, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494022356]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->314849454],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->102315031],

Cell["Center the expression:", "ExampleText",
 CellID->166624227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"30", ",", "30"}], "}"}]}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193807334],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     Alignment->Center,
     Background->RGBColor[1, 0.5, 0.5],
     ImageSize->{30, 30}],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      1, Background -> RGBColor[1, 0.5, 0.5], ImageSize -> {30, 30}, 
     Alignment -> Center]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{34, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599373673]
}, Open  ]],

Cell["Align the expression to several positions:", "ExampleText",
 CellID->118276869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FlipView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"j", ",", "i"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "//", "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->377846922],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Left, Top},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Left, Top}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Center, Top},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Center, Top}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Right, Top},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Right, Top}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Left, Center},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Left, Center}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Center, Center},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Center, Center}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Right, Center},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Right, Center}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Left, Bottom},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Left, Bottom}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Center, Bottom},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Center, Bottom}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 1}, 
       InterpretationBox[
        TogglerBox[Dynamic[Typeset`var$$], {1->
         TagBox["a",
          "ResetImageSizeLevel"], 2->
         TagBox["b",
          "ResetImageSizeLevel"], 3->
         TagBox["c",
          "ResetImageSizeLevel"], 4->
         TagBox["d",
          "ResetImageSizeLevel"]},
         Alignment->{Right, Bottom},
         Background->RGBColor[1, 0.5, 0.5],
         ImageSize->{30, 30}],
        FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5], 
         ImageSize -> {30, 30}, Alignment -> {Right, Bottom}]],
       DynamicModuleValues:>{}],
      Setting[#, {0}]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{110, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70142281]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->38799849],

Cell["Set background color:", "ExampleText",
 CellID->379888678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6922762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->RGBColor[1, 0.5, 0.5],
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 0.5, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->RGBColor[0, 1, 0],
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[0, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->RGBColor[1, 1, 0],
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> RGBColor[1, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{88, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179438102]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->167422825],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->221837909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"FlipView", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "x"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331323740],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       BaselinePosition->Bottom,
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       BaselinePosition->Center,
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Center]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       BaselinePosition->Top,
       ImageSize->Automatic],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      BaselinePosition -> Bottom], 
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      BaselinePosition -> Center], 
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{85, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345645486]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->103509793],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->775355],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386132537]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227336428],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 3}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox["a",
      "ResetImageSizeLevel"], 2->
     TagBox["b",
      "ResetImageSizeLevel"], 3->
     TagBox["c",
      "ResetImageSizeLevel"], 4->
     TagBox["d",
      "ResetImageSizeLevel"]},
     Enabled->False,
     ImageSize->Automatic],
    FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d},
      3, Enabled -> False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->896058855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->57567863],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " to control the width:"
}], "ExampleText",
 CellID->531703742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "50"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->70423267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->10],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> 10]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->20],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> 20]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->50],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> 50]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{121, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52776789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96519842],

Cell["\<\
By setting the second element you can also control the height:\
\>", "ExampleText",
 CellID->140288415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "x"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "50"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->191865534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{Automatic, 10}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], 
       ImageSize -> {Automatic, 10}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{Automatic, 20}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], 
       ImageSize -> {Automatic, 20}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{Automatic, 50}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], 
       ImageSize -> {Automatic, 50}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{68, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57684864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->858831009],

Cell["A fully custom image size:", "ExampleText",
 CellID->364605617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Gray"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "25"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2944956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{10, 20}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> {10, 20}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{20, 50}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> {20, 50}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 1}, 
     InterpretationBox[
      TogglerBox[Dynamic[Typeset`var$$], {1->
       TagBox["a",
        "ResetImageSizeLevel"], 2->
       TagBox["b",
        "ResetImageSizeLevel"], 3->
       TagBox["c",
        "ResetImageSizeLevel"], 4->
       TagBox["d",
        "ResetImageSizeLevel"]},
       Background->GrayLevel[0.5],
       ImageSize->{50, 25}],
      FlipView[{$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d}, 1, Background -> GrayLevel[0.5], ImageSize -> {50, 25}]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{121, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196783860]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26727802],

Cell["Select a function by its graph:", "ExampleText",
 CellID->155821455],

Cell[BoxData[
 RowBox[{
  RowBox[{"fl", "=", 
   RowBox[{"{", 
    RowBox[{"Sin", ",", "Tan", ",", "Exp", ",", "Sqrt"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14993498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", " ", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "fl"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"fl", "[", 
     RowBox[{"[", "x", "]"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46611695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TogglerBox[Dynamic[$CellContext`x], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlzXs0FPgCB/BBqIgpoVzP7dbkEVHdJHx/WD2QTg+0rUumrEkidlMKdY+W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          "]], LineBox[CompressedData["
1:eJwVVXk8lfn/vavs93mutURCKpMlXU1l9HkjikipkJEiRApTjVCTfhUiu9Jm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          "]], LineBox[CompressedData["
1:eJwVVmk8VA0fHYQaZLgzQ2buVfFKxZCoRN1/CxJvT5Qe2bJVsmdpQSW0kUh2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          "]], LineBox[CompressedData["
1:eJwV0XlUjVsfB/Cj0niaSHUq2s8pJREl9V7R80O3txRSaE7K0EARDRSR5Da4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          "]], 
         LineBox[{{1.570584418141648, 5.9561924587047965`}, {
          1.570616510699446, -6.030154080083801}}], 
         LineBox[{{7.852507436177768, 5.9561924587047965`}, {
          7.852533746638103, -6.030154080083801}}], 
         LineBox[{{4.713228414082248, 5.9561924587047965`}, {
          4.7132550552996255`, -6.030154080083801}}]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-6.030154080083801, 5.9561924587047965`}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc41Q8bBnAj0rH3ds6hzBPZinxvMyTqhAYpEkVEkohkZUciJLOMEqmo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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {0., 9472.784642037954}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVynk81Ikfx/FhzDjXuiohM5iIsPweooTPJ2wyrE7SIIwi94/HklJbyeZn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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {0., 3.16227762790024}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwlzXs0FPgCB/BBqIgpoVzP7dbkEVHdJHx/WD2QTg+0rUumrEkidlMKdY+W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           "]], 
          Line[CompressedData["
1:eJwVVXk8lfn/vavs93mutURCKpMlXU1l9HkjikipkJEiRApTjVCTfhUiu9Jm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           "]], 
          Line[CompressedData["
1:eJwVVmk8VA0fHYQaZLgzQ2buVfFKxZCoRN1/CxJvT5Qe2bJVsmdpQSW0kUh2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           "]], 
          Line[CompressedData["
1:eJwV0XlUjVsfB/Cj0niaSHUq2s8pJREl9V7R80O3txRSaE7K0EARDRSR5Da4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           "]], 
          
          Line[{{1.570584418141648, 5.9561924587047965`}, {
           1.570616510699446, -6.030154080083801}}], 
          
          Line[{{7.852507436177768, 5.9561924587047965`}, {
           7.852533746638103, -6.030154080083801}}], 
          
          Line[{{4.713228414082248, 5.9561924587047965`}, {
           4.7132550552996255`, -6.030154080083801}}]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-6.030154080083801, 5.9561924587047965`}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV1nc41Q8bBnAj0rH3ds6hzBPZinxvMyTqhAYpEkVEkohkZUciJLOMEqmo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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {0., 9472.784642037954}}, PlotRangeClipping -> 
        True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwVynk81Ikfx/FhzDjXuiohM5iIsPweooTPJ2wyrE7SIIwi94/HklJbyeZn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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {0., 3.16227762790024}}, PlotRangeClipping -> 
        True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[
     Part[$CellContext`fl, $CellContext`x], StandardForm],
    ImageSizeCache->{35., {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{80, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339222873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319006012],

Cell["Flip through the first 25, 1D cellular automata behaviors:", \
"ExampleText",
 CellID->36692093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ArrayPlot", "[", 
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", "All"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "25"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162974139],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 1}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBtyAkZERjxR2gEdm1JZRW0ZtGbVliNsCAAAjBKc=

        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 2->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGZgJB2M6hnVM6pnVM/I0wMAa6sHCg==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 3->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyVzbsNwCAQBNHDZThzDe7EJdCA+88gBe6zcxIBmpXe0/+vX2Z2z/eaeK2t
P+HWFUckZRtxRFH2DUcE5ZhwpFbOBUdKxRlwpFK8zpFCcTNHcsWvHEmVIHIk
U6LGkUQJE0diJS4D3LwEmg==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 4->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGbEBXDLjGoZ1TKqZVTLCNQCAGzwBwo=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 5->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBtyAEQhxSeECeGRGbRm1ZdSWUVuGuC0A3RcEmg==

        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 6->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBhBgJBmQoYVx1J5Re0btGbVnaNsDAEgSBv0=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 7->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlIGzBKYXbLJwyALe1BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 8->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYcBaNgFIyCUQAHuAtFALA5ByM=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 9->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyV1MEJwCAMheFnx+jNGbpJR3CB7n9rQQpVfGn+gCcJn5hHarvOtknan3OI
VVHB1duwIUK9bdgAytiGjLTy/WJsJBUNY8RGStEUFWwklNn4U5bDw0asmIBg
I1JsCLHhlSDo2AgUf+kVu4ICJXzAWnF1AwZwBKg=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 10->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGZgJB2M6hnVM6pnVM/I0wMAa6sHCg==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 11->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJydzcENgCAMRuHKGN6cgU0YgQXc/yYxhgDS0kcTTv8j35XvlIOInOVF2bgD
X/mDDeq8PTaY8tXYIEptseFXmhIbXqXrsOFThgobHuXXYGOtTApsrJTpjg1b
UVZsWIq6YcNQ9OUBvLIEjg==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 12->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGbEBXDLjGoZ1TKqZVTLCNQCAGzwBwo=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 13->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyVzrERgDAMQ1GZMeiYgU0YIQuwfwdtEku2lEv1L/dyjfcZB4Dzvzf4gh86
8chWOMO/5SqwlbAV2ErYCmwlbAW2ErYCW5lKS5lTR1lKQ1lTrWylVPZUKUkp
lCxpJS1SyZNSSBEKS1xh+wDsUwSa
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 14->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBhBgJBmM6hnVM6pnVM+w1YNTBgAnNgbx
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 15->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJydzcsNgCAQRdGHZbijBjuhBBqg/50YY0D5zXWSWb2bHB9TiJukPf+hP+fw
yWEDM1ePDajcNTaQ8rTYAEopsWFW6g4bRuVdYcOkfBtsGJS2wMZS6e3YWCj9
FRtTZbRhY6KMlxO6DQSN
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 16->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkGZCuZVTHqI5RHaM6hr4OAG41Bwo=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 17->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJydzbENgDAMRFGHMeiYgU0YIQuwfwclSXy2PyeliCz9d/T76puZ7e87bVxr
Vln7bvyp/WCmAFZqzFzASolZElipMGsDKwXGiWAlZ7wKVlLGzWAlY/wOVhJG
hLASM6qElZCRKaxEjG7JywPdcgSa
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 18->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyVkdENwCAIRM+O0b/O0E06ggt0/7/6Y4rInYghBC/4QK76PvUAcDa/m6Og
WMvk401J5XDHW6TD+Vwz639tVBHrcDHieJ3NoXQ2h9IVg+m6gv2lPqpf5qpf
FlW/LDLOuGO9r/4eRM44KmcclTPOah8RZ7WPiGNjlmNjlrPD6O/vVezNYTmx
feadBpE=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 19->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlAGzBI4PTLJwyALe2BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 20->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkFZCjZdSOUTtG7Ri1Y8jbAQBL1Ab9
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 21->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbWF/rbgsR63WThlALe3BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 22->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyVkdENgDAIRKlj+OcMbuIIXcD9/zRNaihyB5AQQi/woBz9vvomIvvrpwxr
2jL5+tJS+ahTbs3TxfivxtG/WoeBdDHR41gd7cF0tAfTGQPpvAL8pfn/6F56
XuRsXhTZvCgiznLj4F6zn5AccViOOCxHnOgeHie6h8fRMcvRMcupMGb/WkVt
D83x7QFK1AZg
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 23->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlaNiCWwYAt2kEjA==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 24->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkGZCuZVTHqI5RHaM6hr4OAG41Bwo=
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"], 25->
     TagBox[
      GraphicsBox[RasterBox[CompressedData["
1:eJyV0bENgDAMRFHDGHTMwCaMkAXYv4MKgbj/LU5K41P8FGUdxz7mqlqus1Wf
qaYr71GX+9pz8hNplS/SKAnplIC4EpFGSYgqGXElIqYAokpGRCHEFEBYQUQU
QlBhhBVESBEEFUZokSCkCGKboOK3ICKrqJF/weYE5FwEmw==
        "], {{0, 0}, {51, 26}}, {0, 1}],
       Frame->Automatic,
       FrameLabel->{None, None},
       FrameTicks->{{None, None}, {None, None}},
       PlotRangeClipping->True],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBtyAkZERjxR2gEdm1JZRW0ZtGbVliNsCAAAjBKc=

        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGZgJB2M6hnVM6pnVM/I0wMAa6sHCg==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyVzbsNwCAQBNHDZThzDe7EJdCA+88gBe6zcxIBmpXe0/+vX2Z2z/eaeK2t
P+HWFUckZRtxRFH2DUcE5ZhwpFbOBUdKxRlwpFK8zpFCcTNHcsWvHEmVIHIk
U6LGkUQJE0diJS4D3LwEmg==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGbEBXDLjGoZ1TKqZVTLCNQCAGzwBwo=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBtyAEQhxSeECeGRGbRm1ZdSWUVuGuC0A3RcEmg==

        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBhBgJBmQoYVx1J5Re0btGbVnaNsDAEgSBv0=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlIGzBKYXbLJwyALe1BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYcBaNgFIyCUQAHuAtFALA5ByM=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyV1MEJwCAMheFnx+jNGbpJR3CB7n9rQQpVfGn+gCcJn5hHarvOtknan3OI
VVHB1duwIUK9bdgAytiGjLTy/WJsJBUNY8RGStEUFWwklNn4U5bDw0asmIBg
I1JsCLHhlSDo2AgUf+kVu4ICJXzAWnF1AwZwBKg=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGZgJB2M6hnVM6pnVM/I0wMAa6sHCg==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJydzcENgCAMRuHKGN6cgU0YgQXc/yYxhgDS0kcTTv8j35XvlIOInOVF2bgD
X/mDDeq8PTaY8tXYIEptseFXmhIbXqXrsOFThgobHuXXYGOtTApsrJTpjg1b
UVZsWIq6YcNQ9OUBvLIEjg==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGbEBXDLjGoZ1TKqZVTLCNQCAGzwBwo=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyVzrERgDAMQ1GZMeiYgU0YIQuwfwdtEku2lEv1L/dyjfcZB4Dzvzf4gh86
8chWOMO/5SqwlbAV2ErYCmwlbAW2ErYCW5lKS5lTR1lKQ1lTrWylVPZUKUkp
lCxpJS1SyZNSSBEKS1xh+wDsUwSa
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBhBgJBmM6hnVM6pnVM+w1YNTBgAnNgbx
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJydzcsNgCAQRdGHZbijBjuhBBqg/50YY0D5zXWSWb2bHB9TiJukPf+hP+fw
yWEDM1ePDajcNTaQ8rTYAEopsWFW6g4bRuVdYcOkfBtsGJS2wMZS6e3YWCj9
FRtTZbRhY6KMlxO6DQSN
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkGZCuZVTHqI5RHaM6hr4OAG41Bwo=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJydzbENgDAMRFGHMeiYgU0YIQuwfwclSXy2PyeliCz9d/T76puZ7e87bVxr
Vln7bvyp/WCmAFZqzFzASolZElipMGsDKwXGiWAlZ7wKVlLGzWAlY/wOVhJG
hLASM6qElZCRKaxEjG7JywPdcgSa
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyVkdENwCAIRM+O0b/O0E06ggt0/7/6Y4rInYghBC/4QK76PvUAcDa/m6Og
WMvk401J5XDHW6TD+Vwz639tVBHrcDHieJ3NoXQ2h9IVg+m6gv2lPqpf5qpf
FlW/LDLOuGO9r/4eRM44KmcclTPOah8RZ7WPiGNjlmNjlrPD6O/vVezNYTmx
feadBpE=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlAGzBI4PTLJwyALe2BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkFZCjZdSOUTtG7Ri1Y8jbAQBL1Ab9
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbWF/rbgsR63WThlALe3BI0=

        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyVkdENgDAIRKlj+OcMbuIIXcD9/zRNaihyB5AQQi/woBz9vvomIvvrpwxr
2jL5+tJS+ahTbs3TxfivxtG/WoeBdDHR41gd7cF0tAfTGQPpvAL8pfn/6F56
XuRsXhTZvCgiznLj4F6zn5AccViOOCxHnOgeHie6h8fRMcvRMcupMGb/WkVt
D83x7QFK1AZg
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjBrIAI+lg1JZRW0ZtGbVlaNiCWwYAt2kEjA==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJxTTMoPSmJiYGCQAmJjIGYkGZCuZVTHqI5RHaM6hr4OAG41Bwo=
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True], 
      Graphics[
       Raster[CompressedData["
1:eJyV0bENgDAMRFHDGHTMwCaMkAXYv4MKgbj/LU5K41P8FGUdxz7mqlqus1Wf
qaYr71GX+9pz8hNplS/SKAnplIC4EpFGSYgqGXElIqYAokpGRCHEFEBYQUQU
QlBhhBVESBEEFUZokSCkCGKboOK3ICKrqJF/weYE5FwEmw==
        "], {{0, 0}, {51, 26}}, {0, 1}], Frame -> Automatic, 
       FrameLabel -> {None, None}, FrameTicks -> {{None, None}, {None, None}},
        PlotRangeClipping -> True]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{186, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268799283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->659000327],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 " is a special form of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->149798949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "->", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Sin", ",", "Tan", ",", "Exp", ",", "Sqrt"}], "}"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", " ", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->725091639],

Cell[BoxData[
 TogglerBox[1, {1->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], 2->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlzXs0FPgCB/BBqIgpoVzP7dbkEVHdJHx/WD2QTg+0rUumrEkidlMKdY+W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      "]], LineBox[CompressedData["
1:eJwVVXk8lfn/vavs93mutURCKpMlXU1l9HkjikipkJEiRApTjVCTfhUiu9Jm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      "]], LineBox[CompressedData["
1:eJwVVmk8VA0fHYQaZLgzQ2buVfFKxZCoRN1/CxJvT5Qe2bJVsmdpQSW0kUh2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      "]], LineBox[CompressedData["
1:eJwV0XlUjVsfB/Cj0niaSHUq2s8pJREl9V7R80O3txRSaE7K0EARDRSR5Da4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      "]], 
     LineBox[{{1.570584418141648, 5.9561924587047965`}, {
      1.570616510699446, -6.030154080083801}}], 
     LineBox[{{7.852507436177768, 5.9561924587047965`}, {
      7.852533746638103, -6.030154080083801}}], 
     LineBox[{{4.713228414082248, 5.9561924587047965`}, {
      4.7132550552996255`, -6.030154080083801}}]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-6.030154080083801, 5.9561924587047965`}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], 3->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc41Q8bBnAj0rH3ds6hzBPZinxvMyTqhAYpEkVEkohkZUciJLOMEqmo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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 9472.784642037954}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], 4->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVynk81Ikfx/FhzDjXuiohM5iIsPweooTPJ2wyrE7SIIwi94/HklJbyeZn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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 3.16227762790024}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, "1"]], "Output",
 ImageSize->{186, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356613502]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlipView", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", " ", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"Sin", ",", "Tan", ",", "Exp", ",", "Sqrt"}], "}"}]}], 
      "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26548005],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 2}, 
   InterpretationBox[
    TogglerBox[Dynamic[Typeset`var$$], {1->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 2->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwlzXs0FPgCB/BBqIgpoVzP7dbkEVHdJHx/WD2QTg+0rUumrEkidlMKdY+W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          "]], LineBox[CompressedData["
1:eJwVVXk8lfn/vavs93mutURCKpMlXU1l9HkjikipkJEiRApTjVCTfhUiu9Jm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          "]], LineBox[CompressedData["
1:eJwVVmk8VA0fHYQaZLgzQ2buVfFKxZCoRN1/CxJvT5Qe2bJVsmdpQSW0kUh2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          "]], LineBox[CompressedData["
1:eJwV0XlUjVsfB/Cj0niaSHUq2s8pJREl9V7R80O3txRSaE7K0EARDRSR5Da4
dXHTQFxKkXQjrkh7NyiFm9yuRpqeJg3qRM7hpPd5//itvT5rr73Wd39/lF+o
814JDocTxs7/zzYv2zu75RAsNFd+1L1Ik/wattMyljXVmDSqo65Jgmp0EvK5
CJTGNMOtV2kQt7HYIislBHuEvxs01KkTW/W+5kZlBE6XKUcFX3XCD7itJ5yH
wD/DXXY8awFpU7CotOMhyDR1Cb22Wo3UmmcOdWohuKxUV2fQN5+UeouVD+uw
fqBabHxxPkkrrvLJ1EUwjySnr/02j9i5bBUPL0ZQtjG683GPKrGIua930hDB
7zeCHb2vqxL9vAUO84wQ1Jl2O1f5qhLO147MNcsQDIxFPkgYUCGPswIsk80Q
BDcd1bKUUiG3ql/66JojsJYqtDTJUSaXRk0SHqxGsG/3iOkJC2VyyPpLc8d/
EFikl1cEhiiRJb2nw5bRCFIGyxIWi7hEXaE/kwCCoqqfysXXuUTK3K5y+wYE
R+arXiKbuKT7rJLKiZ8RxLZ6h76+qUAyjLKLXjsgWJN85aFXkDz5PGWbd2Yz
ApsqH7VXPHmytUJw5aetCCRbrTYJG+SItMumlDxnBHaO3cabzeRIeIwo6IQ7
gvEb7RZH58uSN7Z5fqs8EYhWRnU4NcqQZarbPIa9EMgFbJQ5myJDmLwC+x2+
CATF3JIGeRni3Oi6ZPl+tp+Hg4VkgTS5lymJ+gIQHM9fXu7QMZfI7SnWyAxC
8NdrpdT+P+YSIpSWmRuCoObvKC9Ds7lkBf9Rf+dRBFuOz1Tp+kgRbrjazZQ4
BBl2wd2/fJAgATTJ2hCPIPnMyDNhiQSpljtwQXgWweOCVn9eggQ5nlN9ek8i
AtlG617PlRJkuC7Md20ae38yiheeMofUajUtHL2KoN231KRlF4fw+2MW3LiG
wFYQWf/bWg45UbxE0e0PBNzolXK1PA4xtzklrs5l+y26NEMVzuIbB1d0ZBci
gMa9ii25P3AsOZ/hUMbmd90VHVshxh/fk0uiJwjMUw8/lU4Q453fp9LyyxF0
LpzRsNgixsssPBIlCYKTXh5ep7q/49ZCg+NPaxHcfntv/CD3Oza7jD2NmxFo
ksk6OlaEr5YKXNv+RXD0QBz5tFWEZd8u3n6uBcFko/ZLHUqEu7gpjn3tCF5V
HAnsrxHilDi3ddk9CC5cV3k+rSrEAwcnFyl8YvednjUSQqbxtmR97bIJBPRv
RU8kM6ZxeYGrxn4BAv7boOmvodP4Yt8z5eovCI4plGQL0TQG9yROtBiBVITi
fdNzX3CWjV7vRzkKjHIXPXfx/4w3a+/Ia9CnoGXXigpDZwHOYEyIpwEFg25p
MfarBZgpku0YNaSA3xeekKMpwDFQrqJsTMHOYe9/urom8d29ejEuphTAWvGm
okOTWP7PSefOdRTMTMVIjGZN4DqbXznjOymQEnwz3K8zjucpBWjHulHwQ2qi
9eexMezTst5CxYOCR9HMvsCKMTwd+CXYzJuC/wYXfYjePYYNUr1aIvwp2DN8
2+bxnVEc37b03mwoBfs8Kq2G7Ebw+pA6T9VECv7ZjmoOFw/hb63DtjVJFDzs
5nubxQ/h0o1cs8gUCqxtNHWM3YewAW+b7PtUCoZ0g/yrJIcwt6a9tCCdgnyn
RTPhnoO4lTeuCLkU3Fv8OXe/2gA+9FyNhGD2vdNV7fMFffiajp/+qy8U+Gva
XcyL/YDXrDI28ftKQaWzwDB8/QfcbP/ZUihk/1uT6nhE8gOWjUxw0BdT4PTa
kxade48PNd0Ji5HggzNd0LPwYieGhCmyTJkPqe/L4nxK2nHvp3jv80v44NIw
vyJdvgXrV+enb/Hkg5uGKDue9wanLa9a+raCD9K3cozj/ryD901JNdUv1YPC
p47JcbE1tF+JACWm6kGUcs+VpTUt9IsG2TPlYj1wbyx9dzqcoQ9s7EmrZ915
2p5XEMHQKuVlOe9Y726M2Pt3JEO7FQU9mWCtmZujpX2coQdTX03qz+iB0wIr
YelJhpbekeZ7nnXCnn2nP55j6I1dGtY+P/TAYdfZJq8shh5wnXAIZr2r8F+7
+GyGTnrzwj2Ktd9sW33hFYZ+W3ks/AJrsanE8LcchvbL7bhby/qXkaHszJsM
fSrwmvaKWT1ot2lqbr3L0Pq9kUZrWdc8rB/k3GPoFx5Olvas7aXipYyK2fyO
c1z8WUfcX+95rIShr5n4J11mbXRDdELrEUNvyLfKyGXN38Lr2vAXm09X7VYJ
64yGOZuCHzO0ierzypesi4tXrit/wuZLvNrYynrOu6jnzFOGjpCIeN/PWsfu
vKviM4bWit4yImCt2B8ytbqCoSumDESzrL8mL8r0wQz9P7oAafU=
          "]], 
         LineBox[{{1.570584418141648, 5.9561924587047965`}, {
          1.570616510699446, -6.030154080083801}}], 
         LineBox[{{7.852507436177768, 5.9561924587047965`}, {
          7.852533746638103, -6.030154080083801}}], 
         LineBox[{{4.713228414082248, 5.9561924587047965`}, {
          4.7132550552996255`, -6.030154080083801}}]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {-6.030154080083801, 5.9561924587047965`}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 3->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc41Q8bBnAj0rH3ds6hzBPZinxvMyTqhAYpEkVEkohkZUciJLOMEqmo
RDKTjJSSpElC+iF7v71/PddzPf/ez319qM6n6MeYGBgY9BgZGP4/sy44s6q6
xOl7OL/UYmCYIJq6KZb7KCeIVd5M8VSOCWLtRW04hRJA1Pgo/1QXnSCy6hLI
LJQYwuJXtUmi2gRxcruf5xw5gzjT0ypce2yC6F46njJBvk28qXz5H1PnBLH+
0w+5P+QqooezmOZcOEnkvcrx+U1uJZJUK67Sz00R0+mVil/jW4m4Xym6Y9FT
hKlb28DbhVYCCjWklIwpYox5zvZp9yuCLWizNVf1FKGz3WpbTFQ7MX57fXPZ
6hTRdW+ZSW78NbFWpqN4J3qaCHlFs1A93E0w6ldpDRTNEGX3Yj6dVO4jtqTX
FZsIzROjfKPxFk59xOZZV4nTCvOE3FkLffmUPuKcumF3qd48kavHnjew0Ec0
NG7V3Xt0nkhujXc92PyJ8G56ZrHv/jxxdiBxcofDZ4JjuVHPevcCkcPeFs5r
8o0QLrkste/6IuFGvMkYOz1AnHSVCCxzWiEY8meffoobIFQk87bdOLdCpK+T
6H9169/doflrZuIK8bLVVep2zwAR0fWG+82zFULeZjn/2LZBwlj+VpKA+Cox
fFzu7hfGn0Rf7INLHB9XCffk4NqupCHioddl7quqDPD6qTBQUTZC3OkLuHbn
IyO+OX5kq28dIXY7Kru1DDNib2+0csfgCOEpsI95co4ROm2/An6KjRKlhc6t
7kJMYL5fwCMUNUo4XZl+trCXCelBVH3/w78JIyeR6ctvmFDPL5qxlecPcYBw
+vqzhxkkaoTcV51/OSCnhXzjYMVLvSsqF0wmCE8eQVVLKVZc2p+tLUn/t7ON
FTSrsIIp6ckOe48JwpyVxvKDzorF1TG3D1kTBPlKVHt9Bit+99sWv2aaJBKb
36vIKa5He7qcQl37JPHwTNfNXls2XOZpU8w7MkVIbXQ7cOoTCVXakpVWXlPE
xy0tjV5/SRh0PEUsn58ipLujvoZuYIduKb/NvrQpgnP6rteANjuGzR2COTun
CJtatKSmssMo/M/rAN1pokT+5KkXNhyYn+H2owvNEHXVleLdPzjh/MnmOXP7
LOGx/W/Eu1wekDK/e/p8nCVarsaxvy7jwYODXhJfh2aJAFVf+vsaHjD3RQU8
ZZwj2OyrzFg+8uBW71N1H+05Yrng5Z8pXl4MvacUf8mfI1zedowKXOKFe9dY
UlXAPHFQ1Gex1J8PPs0RzqfkFomwszGUG2ECkBo0ZZ1VXyQsV3jmy5MF0Ma0
4U4QFglOWpDH23wBbELCZMyBRWL1ddIu3UYBfHyaevFW3CKxv8FTsHCdIAzK
C7M/ji8SdO/L4cMxguDNfNln9GSJ8F3cvXg8Wwj3vTn2ipivEJJHyXkVkyJo
v84fUGq3QlTQYmNGWUUx1CSWY+iyQpSPU86rSYhCTFTh98mQFcKvQfvxvKko
IupNwusrV4iumbtGR7JEYccX8tBdepVQTKY53t4lhsWHk/zPllYJjpmZ71dr
xJF33mN0yz4GqB4RSQn8IIUtdRvmow4xICb/c/DMuBTq1hWzfD3KALPcoffh
bGR8SxikJHgz4DprKNenrWRI5R7aNxLDgE0VD238ssi43mTdlFfDADVmeqC6
BgXJnBrZfNKM0PSMifvASkVYzvKe6TFGOJVq29S3S2P3lic+SlOM8Fj2knT+
JA2pet8rzguMKJjyNeMalcbTH6NdXSxMYMw5+Ct6vQz+bvpoXSrFBC57M0M2
Ixk4363c5bqbCb09c7u1a2RgUOVl3vuQCdqVt06kPd4Ihu5vqAlkRpBLbmTQ
O1lEjNTmBYYyg9Gi2bLxlyw2MGQxbY1mhg8l9aDYkiz4Nh9oqkxlhvj9raEL
VDlsinqz4145M0606V8I9paDhW6DVf4QM0JpwueLeeRx9eZNh2j6Otxj8RQc
P6QA2TOu52wUWRBREBkVr0LD5m1f9+ZsYUGo/o7iOhMaNBj2q4xqsWChs8mU
1YEGw3jzoRAjFtzeJqHxIpoGx1s0mxIHFsw+fGIjNkDDtXd/VZgSWUAjcmfI
mZvBohny694UC4Su2hiyiKpgcCbNjv0ZK74W9FjXy6ki30Dd93MjK2ZZq8fd
tFRxOKEz8d4rViTtecQnbqKKvo0srXt7WRFe+YSjyFkVb/ae1r0xxYqxacdV
u2xV1N63pGz+9+c7v1CcKSJqSPNkHLVKWw/tmlX3IkF1WPx0D072YQOf9MYu
EV1NmAbL3DU+x4ax/iu+Py01YSjY3zd7gQ1qqgrM9Y6a2GayS8c+ng3OLKMi
BWGaUCxQmZIpYoOPQVqIdJsm2I9NH6/sZ0NGfubRFUcttA8G2/Tu2IA601Hu
xGRtWA0mKUlJkXCR9bujDG0b2pUG3zlsJOFO3OszGdiGnb7aFzIVSeje3hVD
tt0GM6YvXSLaJFz9IDxgf2EbDClKZ/l3k/Cxm/7w2ptt0HRormMLI8FD6vI4
+bwuJN4t2E79JGHZ6w5vf58eRhudL74sZYf0DV6dudcEyFd63S9XsOMNbTl3
cpSAjaOVrU01Oy5qHPdjZAZq57cqfnvJjv1z3tqaUkDyZt53cwPscJ5fLpWz
BXTTnsvJiXHA3zyP06AZiHeXeB15iQO/x4nM+DIDKPP2SBod5kTCxQWV/iIj
DCUMhaUe40ScW9Ud98dGyCLN/frlwYksTg8/lhYjcKwTeRB/jhPyjQXUI0NG
GJ09YNpzhRO3jLYO39lkjIL+z14nmjhxXjnkc3ahMSSKfz5PVOCC4N7vUTse
mIBEzDj1T3HB9dx2hom/O3DOQJ7t0SIXDCNTEwLXm2HIyL4skZEbxiHbqoQk
zNBgVr9oyM2Na8ajchEmZgikJ1y9rcgNsxtqnJoZZvh9bFPzWSdueHgL+C0b
maM93lae9zU3avfQjicVWWDHn4Nz0rb/evhqnLb3nV3IFgjvDtnPg6mFLboe
jbswrVtyr9+eB43Fn3ac79+F3Nglt2vOPNg7qdDYx2WFRbkbvRu8eZD+1Foz
44wV7jp/rpqI5cGGybgeGWNr8PQeDqqt40GocV3PfMBu9Da4MB6k8WIsnbNm
/y46Jgz6xIJVeBGYuWvxiT0d6+utNXLVePH2j1X4Rnc6tJ5vcxvS4YXIilCG
ZBQdKdU8HadNeNER1NmRXk+HdUVNepwjL5Z6k4yqdfbiRYHAlmdJvFg7XSk8
qWKDyugmR8oML05HMt/UN7ZDsUWbSNQ8L6RXu55o7rPDdY63b/8s8aKgqG9G
z90OF5O+mlYz8UGu+pFEUJIdLNMXle14+PAg8X5e7Wc7/CjashanxAc7o9Ku
I+f3gavlRs6cEx9K/ENCLjTuhyuL37fOTj6Q26UjvWLtIUZu/bD0hg/CCcN5
Nrn26NSRfC3/ng/uDQfkLR/ZQ+tk87OwT3yQiSi5feqHPVi7BTO1hvngdcdn
XayuAwpyH9lmM/KDurzztMikAwZ15195avCDIkA3ZHR3xNHT5ys5rvOjOrOT
pNB2BFpqXyoVsvhxoz3HCL1HQPqLR6a5/KDvflbu9PMIyn1YH18s5IdaVcWO
xrUjWPa+8mT6AT9qdd6bMWk64dqpour+Nn7YXQsoO5vnhNaT3fV3V/hxtFCb
wzfMGSpuSp2WTgIovEHakOvqgi8nyKdKXQQQ3FIn8d3fBfEn+Xm4jgtgn5L+
yy0xLhjxWdrz2ksAW3fPCS+XuOBmUNv7PUECUDgRO2v01wXCyR6f7dIEIO2r
UHEz9BjWakrGjnQIwGdSMXqlxBWv+WjsflsFYWlxRJdP7QT0PT1HMvUEsWot
4jNtcgJlLWUtDYQgJIj+fUMHTuBykGoEj6kgipTE3BdCT8BySGulhC4IAZ+r
q5/fnsCrKoPxHx6CgB51ssTfHc1H9nXvzhZETX2+fWWHB6rLwjJpzEK4ICJY
5FvmBVZLW7E0ViHc0puMf/DSC3tG5DIYSUKQjdoztH7AC79kOq718Ahhj2ko
ZoVPgT9DOPmilBCaIz3KB8JOwSP8bvS7rUIICW/cE6PsDfH9PX5B3kI4IO5S
W8jrg/OMirvbPwtBV0Vc+ffKaQwZs/fKfhdCX36AzBdOX+yOHjscOiiEm5wF
wV8kfbGR+94prd9COLPePWG9vi/aJTQSc+eFoDk7uW/5gi+kdPQ7z/ALQz7j
Sn4g8xk0eNEtJc2Fwbo8aS8h7AdSf6CZV4UwvieFaxd7+EPL/zZn4mNh5Jmn
MjBc8IcTX+/be0+FMZLiJOea5I8nZpqHJuuEEWqgUX2o0h+uleM+ZzqE4Ra5
oLO05o/6yy6ZgUPCqDEipSyknfvXV1b/XRIRwdt0oS+23QH4WUhNyQkSwd27
Ib56gUEYi/i+wHxRBCxrkZs8k4Pw1znv8PFwEXzqHT/64J/UGMhUJdVYEbRW
dbYFfgqCWBqloSHtn7OcpDRY9IOxO4o88fOBCOztI5a4119AjZukJW1EBCvD
m1WCb4cgRV50XZWtKDjkvwVOZ4TCwVG2aGC/KOiaOYIjRaHYmKJuweUgCqtN
03XDlaGoWNuVdNRZFO6kCyc3vA3Fu54wCa5TouBV9uR6QwoDf+SYxtFoUQyb
PbAOvRCG5O/Pj3FWiyLga0tXgVc4kq67tjhRxPCWOz1F+Ewk/M+G+QbJ/HMc
1VupKSISjvRscpqsGALMxx8Hp0aCRurxb6eJ4eRvjT7hx5FoDTCR194qhm/V
3YdHFiPBdGBjDAddDNGMQidIkZfgJ/zD4nG4GGbepYwk3IzCwZRDnRy/xDD0
aLiPkSMWEg9J4h6jYkh/Hy+/SI3F1zeP3Vr/iIH5pdzqOp1YuHDzMV6aFoPn
uvchdJdYeMW+UF9jFMfj3JnUzmexCLuokjEpIQ7NM6cZDpyJw+2TjC499H/u
rG9WV5iIx7xxwUJOrThGmMpP6/EnIag6J7ypXhyJjZL3fpCTwKB2nXOkSRw8
7aVfk2lJWE9OpKq1ieOGcaIer2kShBbOmTd9EIf4vFLDpYAkqJdaZgxPiINl
amTO/kcSvASndVRlJCAmEKwxXH0FAz8NzzVESUDt+/V+16SrMMzpzFeMk0DV
5sla4byryN1/sCP5sgS46Le/9Ny/Csc2H+mjqRIIyvvOerH7KvrKc9uZb0pA
VUVxT4hwCt6eX6WY1EqAJcauQC8/BQ28T1tbpiVgfItuwN6YivztquIdTpJQ
6vhbMKiRjgYrUviSiyTUaZxdNLN0/Dg8MKpwXBIWhwTsIuzTIROW+vSSlyRa
//wodApLx60XCwdwXhJkg3MVPV3pKLBuSH+YIgmaQYFbpXcGip32Cl1vkcRB
kaSQ7JrrKI3043Xb/A8i/2nt54jOwpjeobDILVI4mDkoLpGTBdq08dRNdSlo
PBr9vv1RFu44C7z/tlUKCocsSx8PZqGYeJh+0FQKDN4DHZGG2bi1MEG2OiwF
p79dtemMObjueVJZ84oUfl9TXlozzUWU7dGdzDNSEF6QjEubzEO+db/DsXkp
JJb+EWpjyEeNua1Xy5IUin9Hh7Pz5OPv9h1X4pjI0Gd9rfhQOR8Oskof+HnI
GCc5/Mw+mQ+1ub/OG5XIEPOybJkczceX9LBAEycyPpoeFn8/eROa/Xm3ozrI
WK3pzVNVKgSP8vH5e11k7LS7aPtErxBjIco7ervJ4Bc3HLS0KsQtmepB+T4y
GH/9qc3xKYSAxzvyqyEyslGf9edJIRaDmHeyMlCwy2S2Sd2iCB/ZterNRCko
7xK5W+VfjHSFzNKOnRTcyoifMGcswfSUaUH4LgqWGXwveIqUwLr2742t1hSM
b/j89ZZKCVj3WsQX0CkwF9Z3snYsgV/QgnvwAQqa085sT60pAf31PvnNbhTY
jspemgq6Cw4/gZvxYRQYG0Q3nuUsQ0hdQvrOKgp+l5I8Pjwpx+jnupSFpxS0
ZfqeGn5RDrulqaSiGgpWW5jNWd6Xg6Z1MIa5jgKRwtM3nSfL0VsiG1j9goIm
HyuuUsX7UEt7bq/0joK9K/NZMTn3MeQ5KcU+ToFRSNf5O8kPsEvctuDVRiqE
K4Yjx3MrkD6oXGcvS8W12PxlqfsVGCxl+zQmR8X+iYOy9vUVCEIND7cSFb24
83ThewXuHpMJ2qtKhcly6VqXTCVI5ZP0/u1UJPFk90/crkSL8WWG/+yoCA29
mKJf9wgGXi32vDFUzJo58fsKV2Gxd8S0KZaKgJHhmHZaFSqMONT846nw3PBK
UcewCrKie9g+J1JRJh2gYOpZBY6mvoria1Rs2ZjUqd9UhV7R//7hl4pX/10O
L/d7Cu9mgTqv51SstS83sP6qRo6E88b2GSq6SQcCtNY/xzZ1JWXnOSr0C+sS
PpGf4535tPb8PBWFzBaaKTrPweZ/aefGZSo+qq6dh/tzeL+5czqISRpOO22z
L3U+By5N1dG4pTGc5xrjsasOP8YjDiXIS6P6yhOJYGo9REPfdEVaS4MUKHvK
5WID/gdHptSP
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {0., 9472.784642037954}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"], 4->
     TagBox[
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVynk81Ikfx/FhzDjXuiohM5iIsPweooTPJ2wyrE7SIIwi94/HklJbyeZn
V45hI2JWD7TJkUWlZl0Z5yBXLCN3tY5yJhK/7/7xfrwez8fjrcEOPXFelEQi
hRD7t9k/sanG5361UlGMDdfPsoSGHrrjabo/3GX+lirtVgRbjdU36fRLgDzq
4z6ZCpDlPHksNRADn2/93u6V+Ayya2/TKPR46GI47Rtm8UD/47nELb8k0J4X
FOeV18CwbM7mRj8Hcooele7yqIMgy4jgVdpd+LvAxIEv0wDlvaN5yzb34IaU
00WaLR/WAx2FC35cmBjXicoKaATb9pTdn/rvg/PsbMDJxGbo+XIhbZ72EM7E
PM7uYgkgsknd6GNZIXQJEkfMzNtBJbW3bc6mCKyMxXy0FDuArYfkGb9SmD8c
fTSzvBOiiqSrFvv/BIN1xrKyRxeID43rzNGq4ITkpnGdTC8M1P4VMfu+ClJJ
Tgdd3HuhsCDj5UzZc3Ab7Rt8VtgLTuFOntM2PGh+qZypatsHdySf33nnVwPm
Q5Xt6QGvQeFes+hCfz10jVkpHEscgNxWbtgMrQV03ZufdrCEsJxRqTeS0AJX
nqmfFc8QwmG/tonutRYoqL1Cqe4Vwix51fl5Tytc2Su5UOY4DPstnczj4wQg
JSNdSDF7A69KN0R1PnbCn+tu5zmrI3CtVZ9p7NkD2T+5BK1njsEfZU+1H/3W
A1/OsE0Ky8egO8OavFvQA/zEjGozwRgw/Fx5ygd6wZh7z/7Dxhi0kmMNSYp9
wBMZr+13H4ftlkMKnY2vIVDIGKHsmICS0vihIMNB0LxgN8W5OAnTCtMJTO9B
MKQHbAv8dRJ0IplWe9IGIdhqSt+IOwm/W0jnTqwNgjCpduZG4yRwWhJ8Wfwh
qDCp87VXmoLIiaQFO/dh8KG5W6cWTQFXuu2m/PejwJs5Mohdb8EPuu7Ohk+A
Sd8PjtcW30PIlO5ERck/wF8tH/lYOAtSGrE6I/vnIcr0erSL2jwkyrXp5Xot
wZu75am5WQvAHjpVQxZ8AgvVp+YmO5cgjB/LDtVZB723Xtb9Py5D2X9lTirb
f4XcGG2Tq/krkBsdOG10moQiTUZJi8OfIIa7cXx5VgS3WZwzZC6tAqlnFHmX
ydifct7uxupn0P7RN+qUHgXlDkiks6jrMLmS7iL9FxXF3wX858baOjCnAq5y
wiTQS3/PvtrVL+A0mbxXXV0KH5IHvx96vwHTL9nXm4ul8cl4unV//VcwlH+9
y8bzG/zSFKwV/McmSMGKt3BJFsvnv81/FbUFdnOsVU1nOcwomQs9o0fCgfpz
Iix9ecws0FyITSVh5f8aztJX5JF+Czudl0joS4kY7ehQwMUyT99xVxH0CY+u
lMlUxAXWh5W8ShH8zm9vh6O3EjKT+bxGWVHsVNCXjjiwDc/LjZmmBIvii5KY
LH3ydpyjyQlcGkQxWkTvmGB4O36b49mQTyejlPDykZCKHfj3C++WrEtknCrQ
SONeUcboKvPDBm1kTNuzU6zKeSe6pL/p0NcUw+RM3yZvugoO2H5YUAoXQ1aa
R4fMOxV0Tym+BTVi+Nk2f41brYqhD3fffiFPwYkp66j6ODU8cbCYxPGg4H1L
Y9V2711oBOyGeyUULP45Qt7PQB3Z9rQnB9coGOfs40BeUUdTJvN42CEq7hPm
Poxrp+Gj0uPHahKpmKGbVdzuQMdTQQnea31UvFZ7O8Ohio6OAXUhxpri+IOq
c34rQwNj7AbSlYLE8VBIk5t8vAZmv+lKMH4sjlw1NkOwooG8/f+0Ga+JI+Pl
gztObpqYcr89h2MhgckG9Xrd1ZpYYj4RPHtVAn2XxLpa9LRwQ7jNTa5BAtll
i/T4JC2cvBxu0C0mic2tEjd5G1qYaZ/Es2NKYpDNWHILYX85weZRwnK8qpzX
hNsZ1EOuhF2LA57PE/Y0DedfIPwuSbDA+KqFyxu6HfGEqc7JXrcJ71dRHmkj
bDOyw+rsphZyH3zYPOogiW9PzzsEEjbS7kNXwr+8aj4TRbho8VmMF+HuuksR
HMKBEVHUMMLsvKGiRsInNPu/4RC+7s9V/W5LC2XVFNV6CTPGL+paEI663OEh
JNzMOmZmT/iTdhx3krCco8hJH8JmAfOaK4S5hj6/pBPelXlfd7ujJFo/OJiR
RzjU/0igOuG3NKWCMsIzt2aKtAkbyvPr2gj7F+kamRHujs/uHPj3X9EQBoQj
RSOHpwgXSnmU2xFWiXaaWSSsUrq4fJRw9ZL22hbhhtyfTV0J/x/L5zKz
          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       PlotRange->{{0, 10}, {0., 3.16227762790024}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-0.9999993680039507, 0.9999995755730018}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwlzXs0FPgCB/BBqIgpoVzP7dbkEVHdJHx/WD2QTg+0rUumrEkidlMKdY+W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           "]], 
          Line[CompressedData["
1:eJwVVXk8lfn/vavs93mutURCKpMlXU1l9HkjikipkJEiRApTjVCTfhUiu9Jm
KypCSkP257FUKlNkGRqyb9eSrJd7r/vt98d5ndf557zOP+ecte7+9p40CoVS
8RP/zwxv20qNWj5S5bCKe9SUyarSqMsf6vgo39zCnMNSJn3bbTQONPHRMc4x
rC9FiXyj0OTjyuWjgbKgAoM6RfIsJ0lmcJ6PFF771Z88qkiuOXj4pS9dgM73
OibJLSmQwfEdvKDVAiRw3tKyykSB1C54kCLaIECdx1vUtfvlyeZ/jkK4kQAd
WSs6woyWJ3Wl+iKS9glQLGXj49JBObI3jKv4/IoAzW5QlqgsYpOxWXllnBgB
ClFpfLDKn00a1/q5lt8ToH10r3d+OmzyNmXmcX2hAA1rfl2b/QQnrS7yOf0D
AvR6zLDS8RVGzt+rbPf5IUBt+8emj4RgZGZJ6KUpoQDJbhXTf2eGkcI5ep1Q
UYjyd25/eaSARb4MkD6obCVE/v71j9LUZcmG+3LB+Q5CFDY2+aq+TIYcqluV
buYhROfLq0LOOMqQq1ZuHDsdKkQO/92M+nBHmrxebXGtukiIvJtvBYUbSpFp
YzY5DrVCNOjvp7f5myRZonDo81ijEBXV9ge/vilJTvi4qyiOC9GzyEOxSuMS
pAM79NUpjWX0bxHLJ54UJwN+C+8Q6S+j1sAupb+CxckorxjRLZNlxGD2oH+3
iJNE2YO9hNMySq5ptnuat4LccKKkXy5uGelPtWxOzhcjl179kKvkL6MMXtyT
oQEGKf+Nt91eQoQ4zX96mLxgkHrilOPDiiIkvhc/EXyJQZ5wkc3DDUXoSro9
I1KJQTYwftnl5S1CNmLmfj6OdDLtsMd5VqsIvUg/vrpjkUqWhPrez+oTIaoR
acxuopLNOWfJ7VMilNjk5zOQTSUZoSBWyKRA0m6jjxbOVHJb8z77TnUKNJ06
GZNeSyEfXvTlGjhS4M+tWfs3uogIA1KCF3GUAgmpZKHmGhFBMrKZ3ScoIFR1
V+zoWyZ6YgbUYwJ+6vWWgV6nlwm1jKOOo5EUsEqi5eVGCIn7dXZ1DysoQH0W
V6/VySd0JCabeDUU2Pj0TaN1Dp8otY3utntPAQczq3P8QD7R3la/JGylgOHC
b5+m5fiE4qjpZufvFKjO0ezlHVwiEmU4aWwNKkRWqX65zuURGvZfcn02UCEs
XAa3IXjEy+SAUlKPCotuMXWXbvGIxjX5LX7GVLjYwquUAx4ha6gt9fEQFSSa
Jk5wHywQUQ7KQdciqFBcQOeNeMwTV9MFB2bHqYDWedTJbZkl9huU/PHLDBVW
djSKz7FnCbXqcwnui1RorI9+Lj8zQ5T1cRsbmTRIT75UJPX3DDG9rsMuX40G
XxSbc6q3zRDueUW2XvtpENikfC3DZpowLfWzan9Fg407wqRP3psiZK11fFhl
NDjSyjybFzpFdH4dvGFJ0oAUqU2t8poiggQu9X830OD2qIbRH1umiBdo7+6E
QRqkuM/FcdO/E+pv11tYK9HBOTzTZ3TNJEFp7oGKEDrsiHuS0XVgjLg+WvUw
5P/o8Bv+xNxFc4yQoKTStt+gQxlnh5HqHJdg6x6pK7pNhzMfyQb3e1xiXUTT
7oIXdDipXDA5NDBKWBvX7Hs0RIcUjTwt3YgRIikz0+WGPQO6A6+XMGYHCe3z
XkGHdJiQvOmZivT+XkJ3R/fBdAMmRDgsn4/X7yU4FCd97lYm7NTncAxYvYRZ
tNVQqDkTnEo1y8lPPYRr1qZDuS5MaCe9ZlXteojklml9WhwTJl2rjyjlfCOY
RqHDBTNMqMh+v7O15ysxMHfHQapSDM4UblY5QjQT1oOn/kr8Qxwkct/mqKgU
E/sG4n9RU5OEk697FVzzCcStdb9Sny8F4c+LbEcUWtGahPZTsX9LwZj1WXVJ
+1Z0yHXf4UPlUhDXvm3ENrYVVfG26/TUS0E8o2idyYo2lKiLtyz0S8Huv0K2
vFtqQ8Z3iPXrV0nD6r2uaTMj7Sj61OrPYeHSEKxM4RsNdqLqXxNL98ZIw5Cu
HjdSuwvNM8Sz8FvSEN6tb4d5d6Hj6TNBqQ+lQRj2tbt4rAtxWj5oFFVIw5m2
YqNLc99Ql0lw4MC0NDQ5bhsqi+xBenibqvkxGaCna0cuVvWhoZihq7c9ZWBo
YSSI0tuHUiUXhod9ZSArp3bzeno/kmYoF0YHycB/0lVHW3f3I+78Ecu2BBk4
+O1Xv6ov/ehxZ5efT50MpGFhVgrfB9Dq7EEibqMsRAWraGbsGkYtWvNaffqy
0Fd/+rmr7zC6+VAsirNVFnosdmlZJw6jpfvrD3WYyYLZiNinnJ5h1B7jM6Lh
IgsqvJlT90NHUNK5Caw4Vha4NprLJW9HkSSac+uckYUvWpgt+/I4CjLdIF68
JAvhxwwzHQvG0ZD578/jqCwYd/7cNtIzjmr2VC+ZsVggKayrmt41gULsY5Jy
dFgwdM70I4lNojHPdW8C3VjwT+b2R0Yl35Gzt5Pvfm8WvEk1qCie/I7qT93E
dfxZUOh4/fEH9hTK8v9xtOsSC7Y57R/71XoKuQRXzpvfZYHhaqusY+VTqCH6
8Ab8Mwvaj1tsvPL0B9oRd+MTt5UFYRs4vy+/+YGyE8rP13Wy4GBow9vigR/o
evLa6gtcFvBynz3q0JhGao3zm77TMAhQly0UPZxGbR01bw6rYdCnWBCQmjeD
dk84L2gcxsCyocEpe2kOpclfaw51wqC7gPfu2dp5NGucW9D5OwblwqfO4lbz
KCOKfzLZHYOGlKx/v96dR0vrU9olAjB4UEhcEDdZQHnuXaVTURjo3lZYFN7l
IVoUM9k2FgOTg5NpgW95yOml7tlnCRhsSvE185rlISblso7HXQxs44+PFx5Y
RK6pag/+fYzBrElaKGIvIaz92KUqEgPfA9eDTfP5yEsU4aRSh4HKuXOLZv18
VKH9ghP0DgOXmrKn/SsFyOdPysTmTxjk79GckI0UoBr2w6OP/8Ngubt0h7f/
zx+27dsZPY9BZEJVq/UxEfpwXlJldBGDFXl2Sr0ZIqSeYrhgIcRg/UXrWvt+
EfqHe7VARMdBYJzx5IwRBbRvaKqfw3HwHnf7FP7zJ9prPKjOm3B44BXg4D9H
hSnTr6v+0schERP0JKvQYEW1HSfDEAfdh7+1WJrRYCux4+TQNhweWd47YJNA
g1vl2D9nLXCwutYaZ7WVDnk7wodu78HB8/rpFyw3OtSW8kUle3GgFHBjg6Pp
MP16yFB0AAfOex/bPYN0sPu74u5NVxwiuWTy7nQGeG0xLHzuhoMe1Sgj4zMD
Lhc+/djkgUPpha5wksKEvBeJy0q+OOxN+uOEjycTJPO9PbIu4LA/yfUdb5sY
vH0sb1AZj0OH2rBFpKw4fNOKsupJwuEo4/27tfvEYS5T5E6/g4NfSOqW8Vhx
0HrEvW2V+tPfNtfEWF4CrqaR/NYcHIQSxm5tepJwX3WrwmIeDjlrQxAWLAkv
U3L1Vr/4mde05vDnOknouZ/s5l6Mw4LnkxssNynYeef0u8kaHOID544qP5cG
B8W+HvwtDldLGeKLTBk4c9txifMeh6eJ/h7NP3cnJclM9+JnHEpA+1PFSllY
ilNOWtGJQ50Dtj0ymwVsVmyeTjcOUfqWGZskMNgYS39r24fDh+VXFzwRBk7R
k7ykERwKrc32LBdgUHSjzlV9Dgdf08nLnpk4ZFt/VI7g4WBjeiV6YRSH+9Jf
vkzwcci39+XkGrLhSny3ZTmNDQNyZZLdH9hwzn6IoiHGhkTNZbizSg685CfK
bkiwwdN858ne03Jgc3dJzwFjg99Mo8TLlfKAnKmjFXJs6AzjiYWel//Ze/FM
TSU2XFR65hLwRR6UMhSUfqiy4dpWNO57VwH6nhqIbv7ChiAKKbPPXglafX4t
ndZjA03hU0j+RyVYLh820NZnQ7JlrqpWsxL8D/yIjbk=
           "]], 
          Line[CompressedData["
1:eJwVVmk8VA0fHYQaZLgzQ2buVfFKxZCoRN1/CxJvT5Qe2bJVsmdpQSW0kUh2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           "]], 
          Line[CompressedData["
1:eJwV0XlUjVsfB/Cj0niaSHUq2s8pJREl9V7R80O3txRSaE7K0EARDRSR5Da4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           "]], 
          
          Line[{{1.570584418141648, 5.9561924587047965`}, {
           1.570616510699446, -6.030154080083801}}], 
          
          Line[{{7.852507436177768, 5.9561924587047965`}, {
           7.852533746638103, -6.030154080083801}}], 
          
          Line[{{4.713228414082248, 5.9561924587047965`}, {
           4.7132550552996255`, -6.030154080083801}}]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {-6.030154080083801, 5.9561924587047965`}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwV1nc41Q8bBnAj0rH3ds6hzBPZinxvMyTqhAYpEkVEkohkZUciJLOMEqmo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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {0., 9472.784642037954}}, PlotRangeClipping -> 
        True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], 
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwVynk81Ikfx/FhzDjXuiohM5iIsPweooTPJ2wyrE7SIIwi94/HklJbyeZn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           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
        PlotRange -> {{0, 10}, {0., 3.16227762790024}}, PlotRangeClipping -> 
        True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}]}, 1]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{186, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->401723634]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8741],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlideView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlideView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24833]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->741],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "Tutorials",
 CellID->14681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->11665752],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->223852311],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->214149900],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->268965074],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->720160668],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->223289898]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FlipView - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 27.8441560}", "context" -> "System`", 
    "keywords" -> {"click view", "cycling between views"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FlipView[{expr_1, expr_2}] represents an object which flips between \
displaying expr_1 and expr_2 each time it is clicked. FlipView[{expr_1, \
expr_2, ...}] cyclically flips through successive expr_i. FlipView[{expr_1, \
expr_2, ...}, i] makes expr_i be the object currently displayed.", 
    "synonyms" -> {"flip view"}, "title" -> "FlipView", "type" -> "Symbol", 
    "uri" -> "ref/FlipView"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14370, 449, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->472195729]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 498662, 9701}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2899, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3522, 91, 1573, 37, 70, "ObjectNameGrid"],
Cell[5098, 130, 2402, 78, 70, "Usage",
 CellID->16326]
}, Open  ]],
Cell[CellGroupData[{
Cell[7537, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8015, 230, 227, 8, 70, "Notes",
 CellID->3732],
Cell[8245, 240, 662, 22, 70, "Notes",
 CellID->28127],
Cell[8910, 264, 68, 1, 70, "Notes",
 CellID->8441],
Cell[8981, 267, 2502, 68, 70, "3ColumnTableMod",
 CellID->2093],
Cell[11486, 337, 608, 22, 70, "Notes",
 CellID->19450],
Cell[12097, 361, 617, 22, 70, "Notes",
 CellID->25477],
Cell[12717, 385, 554, 21, 70, "Notes",
 CellID->18047],
Cell[13274, 408, 711, 24, 70, "Notes",
 CellID->26994],
Cell[13988, 434, 345, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[14370, 449, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472195729],
Cell[CellGroupData[{
Cell[14755, 463, 147, 5, 70, "ExampleSection",
 CellID->38802953],
Cell[14905, 470, 96, 1, 70, "ExampleText",
 CellID->160322567],
Cell[CellGroupData[{
Cell[15026, 475, 201, 7, 28, "Input",
 CellID->402517672],
Cell[15230, 484, 589, 20, 40, "Output",
 CellID->59030148]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15868, 510, 220, 7, 70, "ExampleSection",
 CellID->825927679],
Cell[CellGroupData[{
Cell[16113, 521, 236, 7, 70, "ExampleSubsection",
 CellID->99520315],
Cell[16352, 530, 76, 1, 70, "ExampleText",
 CellID->317329411],
Cell[CellGroupData[{
Cell[16453, 535, 171, 5, 70, "Input",
 CellID->120484930],
Cell[16627, 542, 640, 22, 70, "Output",
 CellID->475083456]
}, Open  ]],
Cell[17282, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->374137360],
Cell[17410, 572, 90, 1, 70, "ExampleText",
 CellID->157113080],
Cell[CellGroupData[{
Cell[17525, 577, 398, 13, 70, "Input",
 CellID->378281485],
Cell[17926, 592, 238116, 3959, 70, "Output",
 CellID->665227151]
}, Open  ]],
Cell[256057, 4554, 125, 3, 70, "ExampleDelimiter",
 CellID->333506232],
Cell[256185, 4559, 216, 8, 70, "ExampleText",
 CellID->30642317],
Cell[CellGroupData[{
Cell[256426, 4571, 361, 12, 70, "Input",
 CellID->47389411],
Cell[256790, 4585, 424, 15, 73, "Output",
 CellID->675911439]
}, Open  ]],
Cell[CellGroupData[{
Cell[257251, 4605, 212, 7, 70, "Input",
 CellID->650262231],
Cell[257466, 4614, 2067, 71, 70, "Output",
 CellID->136561811]
}, Open  ]],
Cell[259548, 4688, 470, 17, 70, "ExampleText",
 CellID->400562774],
Cell[CellGroupData[{
Cell[260043, 4709, 331, 10, 70, "Input",
 CellID->908772701],
Cell[260377, 4721, 2092, 71, 70, "Output",
 CellID->601077669]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262518, 4798, 237, 7, 70, "ExampleSubsection",
 CellID->162604191],
Cell[262758, 4807, 78, 1, 70, "ExampleText",
 CellID->95901997],
Cell[CellGroupData[{
Cell[262861, 4812, 197, 7, 70, "Input",
 CellID->2418263],
Cell[263061, 4821, 640, 22, 70, "Output",
 CellID->180047113]
}, Open  ]],
Cell[263716, 4846, 124, 3, 70, "ExampleDelimiter",
 CellID->76697582],
Cell[263843, 4851, 76, 1, 70, "ExampleText",
 CellID->597442895],
Cell[CellGroupData[{
Cell[263944, 4856, 321, 10, 70, "Input",
 CellID->450667964],
Cell[264268, 4868, 699, 23, 70, "Output",
 CellID->135223884]
}, Open  ]],
Cell[264982, 4894, 125, 3, 70, "ExampleDelimiter",
 CellID->803930813],
Cell[265110, 4899, 203, 8, 70, "ExampleText",
 CellID->212078590],
Cell[CellGroupData[{
Cell[265338, 4911, 444, 14, 70, "Input",
 CellID->52549515],
Cell[265785, 4927, 660, 22, 70, "Output",
 CellID->494022356]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[266506, 4956, 222, 7, 70, "ExampleSection",
 CellID->314849454],
Cell[CellGroupData[{
Cell[266753, 4967, 230, 7, 70, "ExampleSubsection",
 CellID->102315031],
Cell[266986, 4976, 65, 1, 70, "ExampleText",
 CellID->166624227],
Cell[CellGroupData[{
Cell[267076, 4981, 392, 11, 70, "Input",
 CellID->193807334],
Cell[267471, 4994, 790, 25, 70, "Output",
 CellID->599373673]
}, Open  ]],
Cell[268276, 5022, 85, 1, 70, "ExampleText",
 CellID->118276869],
Cell[CellGroupData[{
Cell[268386, 5027, 822, 25, 70, "Input",
 CellID->377846922],
Cell[269211, 5054, 6733, 191, 70, "Output",
 CellID->70142281]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[275993, 5251, 230, 7, 70, "ExampleSubsection",
 CellID->38799849],
Cell[276226, 5260, 64, 1, 70, "ExampleText",
 CellID->379888678],
Cell[CellGroupData[{
Cell[276315, 5265, 439, 14, 70, "Input",
 CellID->6922762],
Cell[276757, 5281, 2549, 79, 70, "Output",
 CellID->179438102]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[279355, 5366, 237, 7, 70, "ExampleSubsection",
 CellID->167422825],
Cell[279595, 5375, 75, 1, 70, "ExampleText",
 CellID->221837909],
Cell[CellGroupData[{
Cell[279695, 5380, 518, 16, 70, "Input",
 CellID->331323740],
Cell[280216, 5398, 2281, 68, 70, "Output",
 CellID->345645486]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[282546, 5472, 228, 7, 70, "ExampleSubsection",
 CellID->103509793],
Cell[282777, 5481, 206, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[283008, 5493, 168, 5, 70, "Input",
 CellID->775355],
Cell[283179, 5500, 640, 22, 70, "Output",
 CellID->386132537]
}, Open  ]],
Cell[283834, 5525, 483, 17, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[284342, 5546, 246, 7, 70, "Input",
 CellID->227336428],
Cell[284591, 5555, 679, 23, 70, "Output",
 CellID->896058855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[285319, 5584, 229, 7, 70, "ExampleSubsection",
 CellID->57567863],
Cell[285551, 5593, 210, 8, 70, "ExampleText",
 CellID->531703742],
Cell[CellGroupData[{
Cell[285786, 5605, 468, 15, 70, "Input",
 CellID->70423267],
Cell[286257, 5622, 1968, 61, 70, "Output",
 CellID->52776789]
}, Open  ]],
Cell[288240, 5686, 124, 3, 70, "ExampleDelimiter",
 CellID->96519842],
Cell[288367, 5691, 113, 3, 70, "ExampleText",
 CellID->140288415],
Cell[CellGroupData[{
Cell[288505, 5698, 532, 17, 70, "Input",
 CellID->191865534],
Cell[289040, 5717, 2069, 64, 70, "Output",
 CellID->57684864]
}, Open  ]],
Cell[291124, 5784, 125, 3, 70, "ExampleDelimiter",
 CellID->858831009],
Cell[291252, 5789, 69, 1, 70, "ExampleText",
 CellID->364605617],
Cell[CellGroupData[{
Cell[291346, 5794, 641, 21, 70, "Input",
 CellID->2944956],
Cell[291990, 5817, 2005, 61, 70, "Output",
 CellID->196783860]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[294056, 5885, 226, 7, 70, "ExampleSection",
 CellID->26727802],
Cell[294285, 5894, 74, 1, 70, "ExampleText",
 CellID->155821455],
Cell[294362, 5897, 191, 7, 70, "Input",
 CellID->14993498],
Cell[CellGroupData[{
Cell[294578, 5908, 601, 19, 70, "Input",
 CellID->46611695],
Cell[295182, 5929, 71582, 1229, 70, "Output",
 CellID->339222873]
}, Open  ]],
Cell[366779, 7161, 125, 3, 70, "ExampleDelimiter",
 CellID->319006012],
Cell[366907, 7166, 102, 2, 70, "ExampleText",
 CellID->36692093],
Cell[CellGroupData[{
Cell[367034, 7172, 481, 15, 70, "Input",
 CellID->162974139],
Cell[367518, 7189, 17650, 438, 70, "Output",
 CellID->268799283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[385217, 7633, 237, 7, 70, "ExampleSection",
 CellID->659000327],
Cell[385457, 7642, 322, 12, 70, "ExampleText",
 CellID->149798949],
Cell[CellGroupData[{
Cell[385804, 7658, 594, 18, 70, "Input",
 CellID->725091639],
Cell[386401, 7678, 35458, 610, 70, "Output",
 CellID->356613502]
}, Open  ]],
Cell[CellGroupData[{
Cell[421896, 8293, 497, 16, 70, "Input",
 CellID->26548005],
Cell[422396, 8311, 71495, 1227, 70, "Output",
 CellID->401723634]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[493952, 9545, 310, 9, 70, "SeeAlsoSection",
 CellID->8741],
Cell[494265, 9556, 1447, 53, 70, "SeeAlso",
 CellID->24833]
}, Open  ]],
Cell[CellGroupData[{
Cell[495749, 9614, 312, 9, 70, "TutorialsSection",
 CellID->741],
Cell[496064, 9625, 121, 3, 70, "Tutorials",
 CellID->14681]
}, Open  ]],
Cell[CellGroupData[{
Cell[496222, 9633, 318, 9, 70, "MoreAboutSection",
 CellID->11665752],
Cell[496543, 9644, 173, 3, 70, "MoreAbout",
 CellID->223852311],
Cell[496719, 9649, 149, 3, 70, "MoreAbout",
 CellID->214149900],
Cell[496871, 9654, 153, 3, 70, "MoreAbout",
 CellID->268965074],
Cell[497027, 9659, 154, 3, 70, "MoreAbout",
 CellID->720160668],
Cell[497184, 9664, 172, 3, 70, "MoreAbout",
 CellID->223289898]
}, Open  ]],
Cell[497371, 9670, 27, 0, 70, "History"],
Cell[497401, 9672, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

