(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    327044,       6635]
NotebookOptionsPosition[    314866,       6216]
NotebookOutlinePosition[    316262,       6254]
CellTagsIndexPosition[    316175,       6249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Piecewise Functions\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ceiling" :> Documentation`HelpLookup["paclet:ref/Ceiling"], 
          "Round" :> Documentation`HelpLookup["paclet:ref/Round"], 
          "IntegerPart" :> Documentation`HelpLookup["paclet:ref/IntegerPart"],
           "Chop" :> Documentation`HelpLookup["paclet:ref/Chop"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"], "BinCounts" :> 
          Documentation`HelpLookup["paclet:ref/BinCounts"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ceiling\"\>", 2->"\<\"Round\"\>", 
       3->"\<\"IntegerPart\"\>", 4->"\<\"Chop\"\>", 5->"\<\"Piecewise\"\>", 
       6->"\<\"BinCounts\"\>", 7->"\<\"Quantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Mathematics and Algorithms: New in 6.0" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Mathematics and Algorithms: New in 6.0\"\>", 
       3->"\<\"Numerical Functions\"\>", 
       4->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Floor ",
     StyleBox["(\[LeftFloor]...\[RightFloor])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Floor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Floor"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the greatest integer less than or equal to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Floor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Floor"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the greatest multiple of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " less than or equal to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"\[LeftFloor]", 
   StyleBox["x", "TI"], "\[RightFloor]"}]], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]lf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["x", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]rf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or \[LineSeparator]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Backslash]", 
    RowBox[{"[", "LeftFloor", "]"}]}], 
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "RightFloor", "]"}]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3410],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns an integer when ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    StyleBox["x", "TI"]], "InlineFormula"]], "InlineFormula"], 
   TraditionalForm]], "InlineMath"],
 " is any numeric quantity, whether or not it is an explicit number. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1730,
  ButtonNote->"1730"]
}], "Notes",
 CellID->11173],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " applies separately to real and imaginary parts of complex numbers."
}], "Notes",
 CellID->124085891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194283272],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->124876621],

Cell["Round down to the nearest integer:", "ExampleText",
 CellID->20717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", "2.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12446],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13352140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", "2.6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19962],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462887342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1943],

Cell["Round down to the nearest multiple of 10:", "ExampleText",
 CellID->7489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"226", ",", "10"}], "]"}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[1]:=",
 CellID->1730],

Cell[BoxData["220"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280262747]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28606],

Cell["Use exact numeric quantities:", "ExampleText",
 CellID->25151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"Pi", "^", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946],

Cell[BoxData["8769956796"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491566869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"Exp", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7985],

Cell[BoxData["23"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->967708049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->19423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.5", ",", "2.6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306026466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15348],

Cell[TextData[{
 "Round down to the nearest multiple of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->4250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{
   RowBox[{"99", 
    RowBox[{"Pi", "/", "5"}]}], ",", 
   RowBox[{"Pi", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17852],

Cell[BoxData[
 FractionBox[
  RowBox[{"39", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{34, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294156523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11591],

Cell[TextData[{
 "Manipulate ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->23068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], "+", 
   RowBox[{"Floor", "[", 
    RowBox[{"x", "+", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6908],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Floor", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104044766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Floor", "[", "x", "]"}], "+", 
     RowBox[{"Floor", "[", 
      RowBox[{
       RowBox[{"2", "x"}], "-", "1"}], "]"}]}], "==", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16709],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "\[LessEqual]", "x", "<", "1"}]], "Output",
 ImageSize->{58, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143081060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->710],

Cell["Evaluate an integral:", "ExampleText",
 CellID->3745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31562],

Cell[BoxData[
 RowBox[{"21", "-", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}], "-", 
  SqrtBox["3"], "-", 
  SqrtBox["5"], "-", 
  SqrtBox["6"], "-", 
  SqrtBox["7"]}]], "Output",
 ImageSize->{211, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28169124]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2310],

Cell["Complex numbers:", "ExampleText",
 CellID->24486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"4", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8493],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54595728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", 
     RowBox[{"3", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240593731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248504347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VM0KwjAMztr96aYHERG8DHwE9eAL6MmHGEPYDqLMvX9Nt1RHl4nisNAl
X5p+ab92PaVVfr6kVZGlybFMb3mR3ZPDtcSQdABgj321BPQVenXfK4W2/ZX4
lTjko/XQTghLwtoKIAeaJtB1ydKAnqLqBqGFpxa2820sDHMr5g5XyXti2tC/
a3k/KafVcfv3wUe/riSoEokBzYg5GQGveyM/4o9qYV+4q/qc5Qmomr6VAdoF
m7Wpo2Zluydq52zfRHm+X6IBqRNbqo2sPC1v/33w2RONO1qGPezfsE6Iwyge
DcA1GmBd3d2OuXksu3nXuqyRdS4zliNm567ZXPNurlXrH6U3FpwH5Pzd/w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81736590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20967],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]lf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]rf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter a short notation for ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[LeftFloor]", "x", "\[RightFloor]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9506],

Cell[BoxData[
 RowBox[{"Floor", "[", "x", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17490168]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "+", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1rU0EQ37xN0ioSsYJJq5QivbQiKqIHa1svKn60xVrrwVMMQnvQSowX
/Rf0bi/2oF7Ui1gqgl7sxYJYEAVRQSpIPVgEi4eA8Do7Oy+7b7N5ea99DTS8
N5uZ+c282dnZ2ZcM5EtjV67mS+OFfMfJYv762HjhRseJiSKIeIIxNg13Mcfg
uwvf8J52XRh1mgbKQdUKY5JGwR+kMUfyHPEptNokqGBd/LCsxgNlbYY+F4EX
9jsNvSPlnNTwceBOGqhtFCs35C015PWiajV4c1YyqiagIppdhnYH8l+//O7v
ncScwOhQhoO8ZsmfzHRzHXSUzIax59b1xbkkFR99hbNVHuxr7NVjG2VBH21Z
8vRe3cqsXSLpxQqn245Glu5F6cLCn/n3P+FiWwXh5fJ/QlXWlPQZ1H/6+Iv0
x9GLyO0zrN60LetmLgL0UfFx+9vo+EY/X9V2UH85XEdv8u1ucB3HuQN2oxTK
eur+O7hYsyD8yeMPhNpjWGWQn33z3Yd/MfOZ9Ec0r4uLf30osAr0Cj3Vh4eo
fF7XPtsw2Rt25amSsmrPa1JWEyVXFPrIuaEH4phIC8KBka2F7TOsxInnndaM
Fy4/Bbyyg7wQ7gB6v2BYm1U6GgE1jI/X+3fteTuWDre6NaiWtngZo06bwk67
vFwmVJ9hJSqsycB0a57m3v6YuPYcLpYSRKvQPpqJrFHIbQ1cd0wzC1NzI5Z6
WC1qC0phHrSXOJJHD+ep9npde313IQ8732enOkGn5l2hkohSa3BU8+qdiGL2
Xd76QiDKTkXVGaLKgrXhshN3/5Sx3L0zS1XEkcDkCHWWnrcfcdABfbjbt14S
rl3zpt5HOBLoo5o3PQbZRyD7PrzqF/VOkjhrOHh1wvYZO07ADiEeMku9kSNR
Z0Qu8nN4YKXpUruPEVd7o1+HnmhKe4DIvri09I9k233r04MWoL1ZmlFV9vrV
tyr0xq4HHdfv0h7w9S21ZzJV0YjxmOvvR9zoY5mYowx7isbZmzx/+CtF7BTq
PQ5WxeS9OUJvtvoQVkmj2uzItdbPoCv3ohOYnaGqHNd7e2+EnWBPCyYFJ67s
TGdOTUEd4f8HjY96kHLIA3O5HpWmSwdc6kN0LjnG7+qELwoRM0tX3tjggvYF
G5hHjoMlVgDt1Jmh\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281006654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "  ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 250},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295427564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Fibonacci numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell["Table[Floor[GoldenRatio^k/Sqrt[5]], {k, 12}]", "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "1", ",", "3", ",", "4", ",", "8", ",", "12", ",", "21",
    ",", "33", ",", "55", ",", "88", ",", "144"}], "}"}]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76311850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144"}], "}"}]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21065267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find the millionth digit of 1/997 in base 10:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"10", " ", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"PowerMod", "[", 
       RowBox[{"10", ",", 
        RowBox[{
         RowBox[{"10", "^", "6"}], "-", "1"}], ",", "997"}], "]"}], ",", 
      "997"}], "]"}], "/", "997"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76324933]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RealDigits", "[", 
   RowBox[{
    RowBox[{"1", "/", "997"}], ",", "10", ",", 
    RowBox[{"10", "^", "6"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156769743]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.4"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "2.6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37988320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7865088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609237933],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiMgkGIPs/kAXG
W/7/B9KYZBCQZAYqYAPxQIz/YMAQBpYNRRNlxqoKonfypGP5eZuBiEESRDCX
lmz7+fMPSEodSLAANbFiMY0JyA1HMuX580/nzz0FIgZJEMF8+9YbqGo9qGrs
Lg1BE2WhwD/4wySahqKI0Bia5gXhiGmIbDCSKANOVUpg0b177kBTkxQ4NT18
+B6qigtqB3oMs6C4D2IKMAGipKarV15AVYsQlRKITy8MLAhRfP7HnYJH0xVu
NaCQY8YZrsTlfTuwKLA8sbedCUQM3EACnI5AHJBqqDiID+KSYjY1VSGnEmqH
M7GibNDwlvwPyWuSSHxk1eJQcQmoOgnkeGLgxKIaOf9LoclLkMAH6ZdGk2eC
iDNDpYGACUs5IQh1K3peFsIhTshV6GGC7iuIq9ihsSlDhOlMWEIa3VRxqDpI
SHMQUE1KyBKjHxLE6PErBiJQykFS3SGOYQL2OIalTyloKCDT2EIJJg9Lx5BQ
o3ZJBgqVjeB0h17Co6cpJgLypKqntnlDXT297UekSnwlA6E8TUg9Oh9iK/1q
6eHdZqFGGwObKkS9mZy0BtrGkAS3OYB8qDo5Cu0Yym2NwZ5aqNGnIb93CuKa
gjnz551BST2uznMgnSJoOUCbvko8mIc5bsDACAB7Au3h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495660636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9415],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->251461377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4003],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"1", "\[LessEqual]", "x", "<", 
      SqrtBox["2"]}]},
    {"2", 
     RowBox[{
      SqrtBox["2"], "\[LessEqual]", "x", "<", 
      SqrtBox["3"]}]},
    {"3", 
     RowBox[{"x", "\[GreaterEqual]", 
      SqrtBox["3"]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{116, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461654311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53959189],

Cell[TextData[{
 "De-nest ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->280823093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "+", 
     RowBox[{"1", "/", "3"}], "+", 
     RowBox[{
      RowBox[{"Floor", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "/", "2"}]}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568666707],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVc1uwjAMDk3LytimXSYmNE1oQ+y0wp3TLttpD1EhJDhMIMYz7MQ79dEy
J3GoMW0TBJUa93P879T5zreL+U++Xc7ywdcmXy+Ws9/B52oDLNkSQuzg7T0K
+FbwZd6dUkAlrBLg3x4JDZV5argZLBHAIdJJpdSE4VeG3yu1xh6t7IK+MoJh
PdDSeBwUYYfhmOH7oAymHisfRivCiqdAE6BdxI6fIP/BY62PcjHTbyNfU4n7
drcp4xvjosRWn0r0PPE8MyyPLHarJJI9xo7JoHhvSRU1tftFUQj7SLMARvnE
E31Mqtlkp43+rpBek6rX5cLPSVqTi7MV0nmXM61BekYMx/13Gfr6/kQrcGCh
o86vTdXfQfd1zSTWrinKO1X+bZQfMfvcTtMZ9cXOJ5gvRj5lRif4dt0aMf6p
k+1N0alxmcnOZ/QwSIv7elH8pirvPHsPitY/nHK2GQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245872150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "z", "]"}], "\[Pi]"]}], "]"}]}]], " ", 
  "z"}]], "Output",
 ImageSize->{118, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118785285]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"Sin", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{594, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->727540341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Reduce equations containing ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Floor", "[", 
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}]}], "]"}], "==", " ", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"Floor", "[", 
        RowBox[{"x", "^", "2"}], "]"}]}], "-", "2"}]}], "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "x", "<", "2"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"1", "\[LessEqual]", "x", "<", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{70, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->637639450]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145353071],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " function in the complex plane:"
}], "ExampleText",
 CellID->194005584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295494130],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzEvXmcnEXV9909qygiBBUUkS2AiCCi4H53g7JEVkFADIIoiiBhUQRXCLiw
r4KyiKIsIooCskPoRkCIIEIQBAIRQgghySQzk8me6Xk6XfU9lfO7UncHn/f5
vPNPz+86p+qqOufUqVPrtdGXj9nnqx2lUult25VKy3/D3xvq/G465sLRYy7s
MvyZ5XB02fALt42bfNu4pTXwZi3+IcNTWvRZhl9q4cmGnwq4An4m8BveJORn
+LnwPsO7hvJUPX+X4fir2Oqlv9QPTP3A1A9M/cDUD0z9wNQPTP3A1A9M/Tx/
V1X0orhQD7D+Uj8w9QNTPzD1A1M/MPUDUz8w9QNTP8/fVRU7U1zQi9YDrL/U
D0z9wNQPTP3A1A9M/cDUD0z9PH9XVdqN4oKdqV60HmD9pX5g6gemfmDqB6Z+
YOoHpn6ev6sqfkBxod2onaletB5g/aV+YOoHpn5g6gemfmDq5/m7quLXFBf8
gLYbtTPVi9YDrL/UD0z9wNQPTP3A1M/zd1XFTysu+DX1A9pu1M5UL1oPsP5S
PzD1A1M/MPXz/F1V6XcUF/y0+jX1A9pu1M5UL1oPsP5SPzD1A1M/z99VlX5U
caHfUT+tfk39gLYbtTPVi9YDrL/UD0z9PF9XVeICxYV+VPsd9dPq19QPaLtR
O1O9aD3A+kv9PH9XVeIcxYW4QPtR7XfUT6tfUz+g7UbtTPWi9QDrL/WTuE1x
Ic7RuED7Ue131E+rX1M/oO1G7Uz1ovXw/OnX22cxLtU4TuMejRO0X9V+SP22
+jn1C9qO1O5UT1ov/Q3lH6jx+89Wfo9U+A35DVRyz/X31lbxG/bbejymp84v
8gTf0eLrENyoKSZdGPMsMjoYOvWADoa+eUse04wOhv5qqJ/Rqa9i+DcK6Y0O
9u1+wOhg6I2R5X8LjQ6GrnIEQw/m0lGFDhY5Gx2sdq16yumFdNBX/tuo5Z6j
r5XzN8wOoXv+Rg19Qff8Sm/U0Cf86A/s6Y0a+ls5f6OG/qB7/kYN/UH3/I0a
+oPu+Rs19Afd81u7MLrnN/1URX9VSV9oN17+5YIe4ce/qd6g4+/0Ob/4P9U3
dPQHRj9g9AFG/mDkDcY/qn48f7mq+oGO/1T9iPxUvlX1U+qHoCNvbRfwI29t
B9CRt8oZOvLW56RD3jxH3mD6I5U/dPon1Qd0+ivVD3T0Ax39QEc/0NGPz7/L
6OhH5K36qGo/of2A7xfLdfVL8Pt5jKIf8vMARTv34+jUD0PXX/QDRh9gP+4Z
MH1AR/5gH2cPmPw9f9nkhfyh+zhvwOQv8lR5K73u7bBckK/KU+UHxl5VHr68
Q4X6a321flofjSNycUOun8n1S+r3tF1qO1S70DhO7QQ+fts9x354jv2AocOP
/UDHXsDQ4cdeRH6GoWscpnGW9tMqf/ixJ+jYU65fwb5UnioXMPan8TJ07FGf
84t9apwNHXmqvKFjv9Dhlzi1qvIXeRbkrXGrxj0aN8GPvLVfyPXbyFv51W+p
HYKRv9qlztOo3EmP/PW5zhNAR/5+HFSuqrzByFvkqfyFcYDGkRqHwu/nDwZk
3neg0M/6+YQkX23HYD+/MFCwQz/fMFCQk59/SONG6NirPvdyLpv84JdxlNGR
t8jT6Mhbx1Ual2tcDz/yVn6NUzTuhI78Ne7Rflb9KBh9qF+Fjj7UT0BHH2rH
0LF31YPXU7mqz0mHPqCjD5F3VfWn417SoR8v33Jdx1Xwox8dR0GnfWjcDx39
qD6hox/tx8DoR/22+l0w+tB2AB25qt17v1I2+fHr8++q6nORr8rf6OiD5+gD
OvoA6zgUfXh6GjehD+gat6MP/75iXKlxBBh9kF76OZtvU/1ARz/qx6GjH/U7
3i+VTZ4qZ/SjehF5F57Lbx0+9AMd/YDRD/zox9PTvAL6ga7jYPTj3zdQiJs1
ztB+UP00OOdXPH/Z5KF+BvmqXYu8CnKV58irLvKri3zrIs+6yK8u8rJ1ODD2
CMb+wCKPutS/LvW1cum+Ap2v03V5na/TdW2dJ9J1YZ3X0HEe2I9j0rqkjpN0
XU/jfF0X07hU15U0jtJ1Ge33dV1D+x1tZzm7IJ3Oq+m8j84z6LgYjPx0nKNx
uMaJGsdov6l+W/1Ezs6pn84L6ryVjuvB1EfHaWDqo3EumPpoP6/9jPq1XDul
PjqPqfNsOq+j8xRg6qfjTB0HaZyucaPGKdpPql/W/RtqNyp3LSeY9gmmPYJp
f2Damx+3lauev0v77cJ+BR3f6zylzgNpOXWcruNGHefourGOezTO03VKjfty
fp766Xha9yvo+Fnn/XTeS/Wi42AdJ+i6qsapuX7J+800PtV5YJ2HUzvReRAd
l+s4UtftdfyocbWuE2ucnetnqZ+OB3WdQfcn6PhP5111HlLbidqdzkNovXXc
puvgOm7QuCoXV/h+NK2b6Dy9zhvrvKq2e5230nkUHffruFPHPRpna1yYi5O8
vaZ1H11n0HlvnSdWP6Z+QNuV2qHqScdtOk7QuFbL7/eVDhimfMSvlM/vUxkw
zPvBvE/35fJe9jeAfTzXqPn4rWHtPlduvy8vrU/pepOux2g6MPX1+2gGDFNf
MPXV/XUiR9M75df5aS237qfTcWlObjrPA7/uh9P5Q5WT7gfTca3uP1O5aDly
dqJyVLlJv6j9jPrl2P6Ga8+3+Lrrd7aSzzH87hb/vyrgkP2g4Qta+ZSq4Bb7
6F7D/PKe3Vu/L9XA81r0uw3zPvCyVvt91TDvz5Vbf3kfmPzB5AfWcmo+pAeT
How8wMgjV2/4wfCDVQ8qJ62XlpP8cnLl/WD4wap31YPKUeVCfjm7UbmpXLSc
+qt2p3JXuapctN5a7vtD+gq/t4T62u/PQjnMzoN/GDS9kQ5MOnDwE8OGQ9zQ
XWg/vIffo5dnc1untSswvzk+ysdz9AdGfqSn/NCRH/i9ARs/8gZD5/3kB538
9H3wIy/eh37AO4fyWnr0CYau+UEnPzB0+NEP78PuwOe38AJLDyY9+oQfuwKr
3fA8pyf0Ax35Kla/AB15KNZ2DJ36KIafemu5wOgTjHzByBeMvMDajnJ2lbND
5Jez45zcVK7qX9UvwA8fmN8cH/LgOfIHIx8w9qd06ov8oGNvYOjaTrXd5dop
dD/OGDY5UD4wdNol74eufhY67yOu0ThE27G285xfQP85v5JrF9putL9TPeb0
Sv3Ij/qDoVNe6q9+Tf1Uzq95PzZg+oAffYF5P5jyKZ38KR9Y+7WcXwQj/5yf
zfkdsPqRXLvItSO1U7Vj5K5yy8kR+VA+5AfWfp765voJ9Yu5dpxr97l2lWuH
OTvM2W3OLnJ2hBxycqI82BXpdb1L7Vr7Wz/P023zArnn4FgO5F8vt97bYRh7
VuzXswaRv/Xb4DD/MaOASS/xal30Uxf51CV+rYu86yI/a2fQsVtwK7uRcgGT
PiOnrNxyv8gNvfEcDP2iYB9GB0NHvtA1LkGe0P14s2z9GnTfz5VNvtD9eLRs
fha697vl+lGt9rzY6GDKh/yhg6EH/s6qT99ZFTusip0qvSBXfrE/MPoWuzbM
e44N9bB0YOQPJn8w8gdjz2DkC8Z+wcgHTHnB2u4oL+2S8oLVbsCUG7np/AB0
7BE6GDrPeR/PwdB5jnygIx8wdNKBSY/9gpEn6ZEnGDr5gUmPPYOxX/jB0LXf
Rj9g6KQH+/w7qz7/zqr4zar42ar42araNVh/kS8Y+YApv/hpw+pXwOSLPUAH
Q1c9gqHzXH+ho2+eg6GjT+hg6OgXOhg6+oUO9vTOqqd3alxR8Ksqd51fASN/
jQs0f/XTfjxQNqx+HMx70Q90sNoF+VFvMOVSuuqB/JALdB0X8pz8eA6Grr/w
oU+eg6GjT+hgjWt5H/oAo2+fvlPjvkK/CB17V/mqHYCZzwZTHo0TwejXjz/K
hnkfGP2AeT+YeoJ5Dxh5gSmfxLmFfl/HS2CNC8DkS38EHQwd+4UOho78eR/y
AKufBpMeeYGxX/jB0JEfGLuAHwwde4QOhs5zystzMHSfX2fV59dpdPoPiZOr
Eicbv8ZN2m+oH1O71V/sV8pTiPOIw3k/WONA7EH7SfgpL1j7UZ2H0XkJ9AXW
cTD1AKsc+ZVxhf3GfAtxLJj1OI37SMf6nPZDYMaD2o+QnvpBZ7yo7Rh+1u1U
b9BbcEyP6RW5tRtnUs/cOEnHUfD7eLdh8Su/xM2Kdfyl6weKdTymcbLG0f58
6wzDtG+df1es4yf1e+oXyR+6f19nVecPFOt4S9uV6kfHqe3GCWDkqdjLfaCm
4wGNK9vFMe36BbC3vzSvQTly43Cl+32rRTuCnhtH5uTi7XOgMK5Suem4zNvr
gNjrQDZOVzrYzw8M1HJxDnTsnXJ6+x8o9MNgHV9pP0163x4GzN79+zqNrv0A
GH78lfYT6mc1rkdu+FvFGuf5eduBAs7Ni6lfx37w+zrvgP3oepCOT3S93Z93
nFGol47DdJym9QbDxy9xtmId3+m4QccV5A/d76ccNH7iVMU6L65xnWLyz80r
6DhUsZ7zzNVDx0k6TsBe/Dz+QGH80G4elXTYD3LTeSrsCbrOu+i8im/XAxJ/
D2TH5eBcuwCjF/ixH8UqR+i5caTK0e//HLRf7Eexji+how+wj+8HjA7OzUOt
2rxFftzbbtwBxh8r5tfvpxwWe0oYvty8sNL9OYpinAQ9N28KP/aq2J/3GyzM
6+l4UceH/jzgDMPYI+nB0LFHnXeAH7tQTPrcODynJ7DqSceV0NG/7kNSOpj+
1b+v0+g6LvLrUsOFcRX9rY4zeG9unaDdvGq7ebx28zztxtVgyku9wLqu1Ppp
jpNy6xxKB+fieOiyTmBY43zKJ+NLi4vhlzi5MC8N1vE2dPRB+aCDNe6SOKsw
L4098z4w/DqvAdbxOnT0SXmgg9VOxS5N7748ndlxP1jLQ/5iN/ZLeUgHH8/V
fiJd5hXKdV3n8uOXcmEcruNs7EnXyUiv6wa6DuXHK+nenNy4yo9X0ry6rkPo
uR+d99Z589w8uh+/pHMqOs+am3dVP6XznL4fS+fSc/2gH9+UC/Ng3g+k84Q5
P7Jq8yTFcazSc+MO+itwrh9XOjjn53J+DT4/bm4UsO5zg469KNZ9UD6OGChg
jRtycUY7P6t+kfbLuTr0qOcLc/NOuk6t67ToMzdPwC/vo73pecTcuJH2pese
el4xN07QdQyNy5BvLi6j/fh7X7sL/VCun0L+uq9C1/l1nVrXuXVeJTfPwrhO
19103UbXJXR9VtcjdR+I3j+UG5e3G2fR/+biXrDeO6J08tM4mf5U57X1PKTu
q1DszxENFvYN6PnI3DwX+oVf1ynB0HPratDRHzi3zwbs+5GBtvMc7cat6I/n
uXGI3vuidPLTcQr60/LrPiGdF/fzho0C1nnC3Lwi8oCOvBRrvf04aqCANc7M
xaX4k5WPj9P6mp6XzM3r674gnSel/rl5Uu9Hy7I/NM1rwa/r4n4+JM1T5OYx
dJ1Y1zGxl9w406crF+Jm5JuL4709dRbWRfx53O6288benjqr3p6Snftx8cAq
j5O9PRXHFdRPx5PE+/gLnsv4yuIG9aPeLodlP2W5MI6FHn+N7s93dtj5D9q9
Py+Xvv/hxwcdlg/P/TmfsmE/bijXfVxblvW9dJ8I+dMeyA/56LkU0vvzqh12
LoRy+HNw6d4E3qfnNjjfC1338aMfsPdz6R4l0mP3ft95wt4vlOvezsuy/pf0
o3LVOFT9mI4r8Vvwa7/s5+2Sn6Ne6A37QW9g/V6H6k3Hof5+i2ErF/ai3yHR
dTf9jgflQ/+UDww/+gfjT/S7Ehqn+Ps6Bg1jD3rvv85rev7Owj3zOj7R+z90
HKBxkPYrYD1Hjr58fNxh7Qr9+PNPZcPIGX7eA53ygeHj/eiD9/McPp6TnvYJ
HX1Ap/7+HEyHnWOmPfpzGwljr2oHOh7QfhqMfCkn8tXzrfq9EN0fCB371++d
EAdQL96HPMkPrOMYMPXU+zY1jvb3rA0axt71uxU6XtD6arvROEbHpRqn+3g6
xTXIH70jb/Tuzwulcwbqh1c+T5TiF7Cfd9Dvfeg6evr+B+VDP5TPny9K40iw
H6eV5bxQWscC+zhZvxei6w5p3lzkk5nHTfNglJ/66zhK40Yw8td+TufVKAfy
B+s8guzHKsSpsn/KfjXey7zP/ILaMZhf7W91fo841+83yc+T6b1VuXGZH4el
e15ycbePsxs1rbfGbdovE4+rn9J2AUY+Ou+s+2/Il/fpfhQ/riwX9o9A5306
D65xYbs4Qfupdn62XbsGUz49l9JuHlTvHdP5Iuj4Yb1XWeePoONH9V4f7Q+1
X1A/pPsa9VzNqs3bDhTiLO//BgrzYtpPeX84UJiHUb+pcZz2c+pX/brr4sK5
N+xL18N1HlrvgdP1aJ3H0XuTdD1X70f24+80ztA41Ne3s9AvkJ+uc+A3dd0g
N48OlvFvdp7G43JhXA6dcoFz49x24xaNi9vFce3iDH2/jqNz42rKo3F4Li7X
eUver+uH6me0Xaoe1W5Vr2DKnxvH67gTe9BxQm4cQXvQuFDjLo0LdB5Bx306
ztC4S/fRqd/R+XedhwLz/ty8Au/PjWvUT6tfW/k8aZr38u0/zc9quwNTvtw8
hs4TeP+dxlW5cZeXY7mqcb2f7y7LfpXiPlPdB+Pr01nVeS0d9/p1iHR+mHGp
jlPhB+u9OOSj99eANR3y0PkozdffF5L8gP6SP5j8dTyt95EwjqJfAeN39f44
4l3uIwVzn6Lu29bvskLnPjEwdg/mPjF/DmVpYR+bfrdQ9/VApzyUk/Rg+MHw
U274wfCD4dfvrOr+Vp6THkx65AC/zBMbhl+/D6r7H6GTHuzj6KVyz8RS4wf7
93VVff5dVZ9/V7VFvhB5luvg0H8sq4FDfNxneEmrnf27Aj6y1Q5eMxza9zzB
pcJ7NF/4wPob6tNfWbeFH6iAP9XK54nsc7D+hveNxHs+h+2X58gr+q36MeF5
jd9gx/2GSQcmPX7B79tZVMjHnwdfJOejF1n+wQ8Oyj6wdM+1tiO1W7UrtRu9
R4F5RZ6DKR+Y8ihdzlkV9ofj92iHYNoJmPzA5KeY/lX1wvu4FxQ5Qid/6OTn
73tlvWnE7vVWP6V+RNu5tmNtp3oPRMimw/QC9vunO6xclJPyQ8eO1S7VD6uf
VTtTPate2+lF/ZbKWf2U1gMs+z/rsk/F+h8wv3oPBnLItVPtL+Gj/tDp38HI
A4w8/HrQgGHqr/0n76P+Wv5cP69yIR/1M9quwdRH26m2I7VL9R+aj373S/vf
nBzh035U4xT9PpXej9VO7np/s+pB/bL6Qa2H+kH1Y+p3tF2rP9A4SuM/jYs0
7tG4RPWl8ZPqY1XjQo1bNU7TOErj2lw5wBqnaRymcRX9rP5qHELcAD639c90
w2H8NGBxgv8tVXPPVzVf8B9a9flDhV/im9xz4powruizX55rvmDSg5nXAzOu
ApMvWPMPahmstHtPu3xo72DaMZj+PeI68gbDpziM2/jORrmucRjPsQulh/Ql
e1+YT+owTHr0rnEI6SkP6X35uL+1VNf0If8lVm/KFeKZhpXTx6PzDFMvcJg3
eK3m5TrPMHFSlJu1I+iaPowfphv29/H01950e8suaowjsBPaB5hxBZj2ovbv
713ps+fYk9oh/Dy/sWVXUwwHO5taoXw6boCf8ul4QvPLlcv7v/6CnZNf6I/m
m12vmt0xTmiYnhnXgXdrlWthzcez87N24u0q+TPoyAu8cj85z3CYH1pkOPjr
JQW/GuSzrOLbN/PsneZvQ7/eVRU/UCU9mHEe9qz8inkfOOijwzDzaTk/k2vn
6Afs/Uuxnfnxaqpnrh6+vmm8H/xzd1XKab+annUGX+4UJ6t/VLtrZ4fMg6tc
2tkp/Hpvlm/HcwrtTvlyfijnFzQ/9RN+vnmkkmsnq+rndL5Z/ZH6Ib0/Sf2W
8qn/+r9tt8wTaz/p9zePWLwI9uviqZ/zdrMg26/RD4H9ftTkl/04edAwftbX
e3HWD/n9qskvqf/Sfbye3plt195/lWSdTf1j0Q9G/kJc0a6fX9V+nfUF7efb
+d1V9avUp1WNFdYflY5c2vk58dP4tYK/Iz/WN9Q/q92+XrvWfSTky3qA+he1
Y8XYsd+/PSLr4WovJVmPGZF20K3ykPqkOIN1O7ULykl9GEdo/Kb11ntrtXys
N/E+3R+m+kLP9BNqP9CRi9qD7kdSOvql/Ll6+/vR+gt+xu+vH5HzEknuvFfl
rnLJ+U38ji9/MV/6HY2fdb+eygN58st6u6d316FTPuj079DZnwP9nuDHjc46
IHTGF9CRL3T6K0/vFHvqsnL7ci4Tf7igUE4tF/i/WzdZXCgnmPZOOSUerIt9
y/cmGuZ/Vr5O2rB9X/p9EOh+3bMh5/oacn9tQ+7Zaci9+g05d9aQ+2obtu8I
jH/T73GoHwztfpGMb0fEXyU5UG+/n2Og5s9DD9T8+eb0vSzk5NvfdLMDjes1
fU6uWi7iQdon8tD0OT2QTuNK4lww8Sj5+3shRoy/nV5Vjrn3aHyr3znL2QXl
0/HzLq33LSy0C9Lr9wj8OfNO6fcG5HsEiwp6BqMH8turlf4JoyNH6MyPqVw9
niPxZH+hnr7/6Cj0H9pva7+68nigo+r9UIpP9fvwatfKp/0FcQi/mh6/RXr1
d/QnpGu5/8n6/bEB+f7YgHxvbKDGOI32iV35c4IDRtd8KZ+2f/oryndX0Kvx
+3tXRir0X/BvE+yiUG7S+3tZRmw8CD/1UDkiJ5Wjn/9J9aLcWi8w9YCfcmu9
wJQbftq/1gNMeVWOKifff2L3XdaP0869nXVJ3JjafU8r3TPmv2nX8EMHazvH
z5Ie/wc/41KwtnvmDymnlkvfo+k0zsV/8T6ZX6x6f9lpckMu8Mk5Has3dOoJ
nXpBpxzQeS90nmt/rd8l4rmuU2D3ag8tuMJ4hvaMP9X7tNXPKpZ17UK+Pg6Z
Y9jfv8S8S/K/7OdDDhrHIAcw82Te3y6SeYTOwvhA3wOGT9YbCuXQ+bl29fT7
M0cqao+U2+8nHJF9lKl/0nE99WRcpvaI/qhnu3Kp3r1dJ3+k85Lq99WvMw4B
M+5Q/ag/Uv9C3EA70X5a/bz6cfXT+GH1i+rn1G+pH9G4Se2I9QX6XTD9LHYE
3d8/ntZJWTf2elgq9jtkmHVl1o91fMtzMPGn19uQ1Hup0OP3hCf22i/0Fh6T
1gXYVwBmXwGYfQVgjfvZRwBdMe0GzD4D5OTnW4cMIwc/zzskceFSoRfnL0M2
Hf+f1fv11lPLoel1vk31r+fUqR92BPbnNUZsH7J7/9hmu/jPoycsWrNU3+3U
R0e/+565NXse0+l72ulJy6F6o1x+P1r/69Yrdkx5+eV5q9yjSnXqF8ZDIzVw
8Ldza1p/+EjPc/hCHNIv/Ukad2EnYB3PomfohmP+wc+n/gS78fOrHW39Ss4P
qD+kHfhxaJo/xm6wS/Tm9wv1t82nnZx4j8qtIKc2clG7VT/73/pV9I49YGc8
B6M/fa7p4APTT+b8NPEbz53+1J+vgHW+U+c3dT5T5y91vpJ5v/9X+ap9EvdT
L9qnySG2G7DGuYwLdJ5D5zH8vR2rnk714OdfRgr60vkCHZ/r+FvPlb3edNr/
6XhTx486HtT5qNebTu2SuBD7p11onM8vz0mn7Yl4DEw8pu3K/3abvYTfNB5n
3wr0lh8ba/er2Ly7o09eanEucTf04Pd0/aDP6Be38pttdOJ06Hu2/nnB6MTt
0D/ewpcX5vWhf70lt2dtXMs8BvTgV2fKvP48o4c4ZsjojBOgBz+s6xcl03er
H+pL5+oZV/j+u8v0onpQuaucVa4qR5WbyknlonLQems9tV5g6nd2q9xPm7z+
0irXDMOh/0zvwZ+tajrtL1pympjsN9jfnJrT18mlAl9oX8sK7YtyaT5uf/sK
+frylQr9mb5H25u2L20vat9qz2q/qif8BfTrW/V4zHAYR04yfTD+hB7ihFcM
79T6J32HSP1P8GMJh7hs0PbhkI73wsd7ofMe6LwHOvmq3yNu4/n3W/hyw6u3
yneL5cP4HfonW//cJ/OFfUY/L/gvw8OtcvXJOnZ/Yd6R95KO90IfauXzUKEc
YMoBP+/19tcv7bW/IJ/Yz0h/kHAcV5gfYt0Geqtf7usxOvvqoLfmG65OuJV+
+w7JryT5JdxiG5/uAWefjMt/9JDh0H7mWbtlH43Lf1y6x5t9NdBDXD5T2nm6
15t1JfMTwS6Nzj4bJ7/JS6U9LjO9sA8HevCz6R7voJ+y9Bdl8SvpPhrWh9z7
trdxtskRvTq93Jb0GORe1LOXo+hx+6Rn9g1CD35uuOb0avVP/WErLprYJeVP
94gHeXYbvdXvXJ3o7Jv09pNwrIfxObvt6yn460i3elIvL4eEqSd27eVZkv5m
nthVsmvs1stvoGDHYOwYfuzWt4u07h3WG18p2LH3H8vEfyS7xm693TUKduz7
gWSn2K3vFzqMHvRatGP//hRvYCe+3SW7aL1/VE/BbsDEuTk/RJya8xPEef97
O8X/pfg7xM8pXg7vedHwJ0I/UXPlHp3iz/DetA+F+WUn91Gp3QZ/nOJM5p+9
Hb1suLPFN9Xshvlp6z9bzx82vF/op2qUg3S8Fz7eC533QOc90MlX/Qfz4l6P
XaLH4rqZ9w+Jzrw69OPD+MHwJa30TxfW2aCHuHuS0ZmXh75j658XJH54sbAu
Bz306y9JO5sv7XDIcFivmV9Yx/P9zwJbx3D+ZVRRLmDqCf9fQ9xYqDeYesAf
4tSXC/UCU074N27pv1hu3y8vEn+2SPzdYvFvC6XfX1Dzclsk67KLJZ5K7SzE
+53aT9j6HM/DuGGplGNJYR1Ryw2dcvv+ZaG017TvjXp4v5ow9YKfenl/0en9
bLOe/6/8lvNLK+wLoN1C13V/2iF02hl02pWXQ2oXtBMv1yUi96RHX87UT7Bv
x9fT/H5hniWXj86zMK/i7SjJW9+r8yjMm0BnngTMvAiYeRBfj+RXmOfI1LMw
z8G8hsqPfUle7imuYX3S6y3FFX7fUcpH89V8SKflCfYucd+YGBeOLz4HMy6n
n2M+AOznYxIdzLgcfuYL/Pow8kx0sL5HywFfrhw811/9HifPmQ9hHoT+GzqY
dMw/QQfrOrKuO0NnPoD3Mu8BP1jXoXPr1swP2HpWnCfx5+rmVbTeWi+tt9bL
78MqWZyD/vx6f8nm6aBreuIg6H5/QMnm9aCDc3Ly5wJLVb/PM2Ho/jxTwjm5
gdWO1c61Haidq5xUjionlaPKSeXo978V5ahyUDn5/XBFOfFcf6Ern54TZ30l
99yPL7vt/B+Y3xwfz+l3/b2sXfab40P/PPf3mHfV0QfpwaSnP4cOho4+oIOh
M58GHQwdO4cOhk68AB0MHX1CB0NHH9DB/rzRPDl3N0/oJYt7/D3LXXXiFdKD
VU85PSBP6GDvX6dYOwZ7fznf6GDoOb2q3lWvqnfVq/ovLbffZ1myuBD5af5q
F7YvM64zMA+bsxP1l35/Sqkwv8w+yJxdqd2pXal/Vb3oeNLfl1i0Q7XTldvh
vIr6IX/PappXblV38mDWLsF+f2zRznN2BW6nZ7+/tqgXv9+2WC/Ws6kXfhUs
5zPrsr/T9tW0shmbcExv7RJ+Oe9mcgHLeTe7D4NygN137CeWZX/PMrN7sL+X
aL7RwerPmdelvGDolMPfa1b2+4cmpvs6eB/Y3+c0x/YVqV9hvVGx+k/Kh/z8
PQzpnjt/L1i6D8S3i3SvD+t5lI/08LPeqVj7V371OfmGcUaRj/lcnoO9HZbF
TtP3TLBjfS/jXH8/1ZKa1+8SubduSc3Lc4ncs5buP8nZPe0EO/H3qcyz8oDV
7tQu9V4YtUvm6aGDffrhmt/3tsz4wfAzD2PjoYj9vZ3zjQ7W8QT14zkYOnr2
976/ViN+hQ8Mn/abYOjEr9DB0LXfAfvvFS4yOtjfX7XE6GA/LijZugf24+8N
SP0CmPTab0BHPtA97jR+sL8vv8voYO+Heqrej6XvL7JepPas7VTXF/09+kU9
qp5Vj2Deyzwb/PSD8Gt8Qr9HXEO/CNZxB/EGz/W+HfjAfl9YqervuUiY8pKe
8mq8ofkRH/h7G/U+nmK/in5Y1/L3+i2raL+h/Yr2G9qv+HtSEobu71lJGLo/
t5EwdH8fUMLaLqiPbzfLKtpuPH9qZ/b+aF/0g96vl+X8flnuH0r3EZG/xtH+
npaS3OOWsB8npzgVDN3fg5IwdH8vSsI6Dkdefpy+rOLtqiz3E+j9RyXD8Pn7
kBL29tlT9XFJT1Xtl/dpHEB7CXJLcQHrpP5+xeT3wP4eya6s3wMzzuG9jEPA
LfOcnPbjUC/y9/csdrWpd5p3lXsl6rk4PRcHg4lbcnER/VIuTsnFFRp3aBzh
2/2ySs4v5fyI+hn1I2DkmrOD3DhA4xiNczQO0jhH/ZT6MfVz6sd0nKLjCDe/
PT6dT1C9tItrNe7SuIx+OxeX0a/m+l3mFSgf/Vqu31M/rX6cdp7zw+3aNe1H
+1nt99VPqx9XP69+XOfpNc7UOFTjzHZxBZg4Ihen5PoR7We0H9F1AY1zNQ7W
OFf7Ge2HtJ/SfkjHvTpOhU/9RLtxmsbZGof7+7qKcbW/r6sY1/n7uopxmvaj
2s9iz7l+VvsJ7Uew79w43d833JUdF+i4QccF2o9rP69xgPbzeh8Y5dZxu/se
0ArjBrD7/s8K/T6Y3/ge//2fFea3dF4JzPoq/ot9wuCgn4GK2yc9vjge0nkb
3T+PHEjHOji/zJOwvg1mvVnn3ciHX923hVyhsy4O1n1cep8VzznPrPLW+6mU
Tjrd9637vPUcgY83BiXeGLTfHB9+kn3G+EkwdPw7dP2eQy4f+HL5+Habvq+4
8u89FPmIe7Arf79uimf0Odjfm8vzwZqPi9M9iWB/73+3tRuwf3+P0f29oVq+
QSnfYA15oj+w90v9hfkU0ns5DdYov48H0nc3KT90sM5XaTly5fLr6v1ZObYr
F9h/D6JYT8oLHaz+X/Wkely5nnqqfn62JyunduUA6zkLPUeBPwUTTzLfwy/P
v9/6vdx+iTdzz9Eb+XC+AD7OF4DhIx3Pc+kot55bwB7g57mem0DeQQ6pX4zy
t35Jzyvrc/btkg98+AE9h6r3aSudfdI8Ry74NzD6pZ7sXwETt8LPfivonG8C
40fhR17QOe+h+iIdz3PpqJ+eP2DftepBz3HoPnh+fftK43aLV0V/9Mfozeur
Q86lLzA9UB8w5z/BzEd4v7RYcGc1p1fyz+kVfvQKvZ1eOWet5170HIvOGwe5
LhV/keI9PTeh42LkTvyRkxP9Ndju1ZV1MBcv2XdyBy0+03R2f+ZK7xtIes3p
Sc/Fvd5zcOLvZZ6oR+YZemQ9skfGYT0yr9xT97/F97D/CTpY4wP2ZfvvynQa
nXlp6GB+c3zsM/bzKOl7OszLQAf7ebPpsr483ejsz4IOhs66BnQwdNoddH//
W6nOvAF0MHTG9dDB0Bl3Qwf7fQsdZidgv07QKePwzkJ8p3JVuatcdT4Nfr8P
c5HFQWA/b7+o1s6OsSO/Dt9Z1/fkyoG+/bzmdKNzPgA6GDrnAaCDobP/HzrY
7wvpsDgMrPsG1C7B7JfGr+TqAWZ/s/dDJTtH5edbU7ug3rwfDJ14CrqOq5AL
fhgMHbuHrvsU/T2eCfN+MO/375uaLQfvyZXDt5N+Kw96pDwrv/8z51dLdfjJ
36cvtmOPO2VfR2dd202uXfn7Q4t69/d+JQzd3x+asOolpzfkqHLLydXfL5qw
ylP9mvo99Ws6H6btrt17jR77fbvn1MUJaf1Q77Fw800rnGPTc2p6Do1fPdfE
uSXe//1WeS6XOCKdU+IcEuVowdG9fBernouLVI96bkfP5YT6pfMw5KtxsPv+
tI1PFtX8PrAFhomnPO60e0X8vU7FuMTjzmyckutXwOoH1U/SPnJ+sp0fQ85+
Xrxf6l30A2D1K+p3cnGNxj0a1+h+Du0X2/kRlZvGRboeo35G5apxk67HaL+s
cte4Cpzrt8HYL+vG7r417hFf4dymnrvUc5N67lHP2fn9/P32XQo3jzM23Q/S
YrswYfjdvM7YdM8H/Lo/gnTkk3sP+cJPPrn3cF8X41zGP34+YZrR0St0npMP
z1nHgU4+0NG/fieMdDk+ftW+Wj9jeupOHqNSHADd1b9J5z4zP0/eZfnQr0Bn
3h86959B53wcdOQCnfNx0LkPza8LDRmd59zrxnP6KeoHnfopnXvgoNOvQUc/
0JlH9PcUsm7QZXL09xKW7HwgdNZBfL6zKv69M+29/n7ykp3/g46/oFys11Mu
nsNH+4cPecKHPOGjPqTHX5Cefh2MfuHHn0DXeRnmzaBTT8pDPSkP9uHnvYcs
Pc8pN8/d/VZNjB6oP/zUn3pSHuiUBzrvo97kj13Dj5zgRw7wo3fKQ36UBzn6
9b5Ub9oJ5SV/3o+c/Xp6alfIUe63qst9THKO7A2mH+ik515G0jOvSXropIeO
f6Ge3P/g61n26w5j430XK9gz91byfvotvx9mqekTOueFXT3Glq0epPP1TO/h
fkzonCdW/wWfk8/olA45QEcO2C3P0TPpsCPo3M/p14GWGN3vYxiqOX00y4O8
3bikr1TV9JSX9JSX+0B9PNBVVXngj3mOPwbTfngf7YP30T7ID7mQHvv3+0GG
LD32778XUbLz4vD5e2lLdn4cur+ntmTnyTV+QS8ufpm8VL5PUbLz5poevfj4
p1z19+CWquqH/L23JTt/Dt3fg1uy8+h2TmPFfqjJ5+KpyUsl37LEW+Wqvy+5
ZOfXtX7wUT/m3SW+MXpo/2lfJ+nJl/QS/xid9Pg1WTeo41/8fr6l5pewA57D
h1+BD/uATjtT/8U5e+rHPhHk7tddlxb6T9JTP9IjF9IjF60f5eQ5duz92iLx
ewvF7hdJu1ho62bYKetk2CnpuZeX9KwPeT83reL94Cs2b0b7J3/8Iu+FD78B
n7ffAXt/GB8MiB9dKH52kbSbhdKuFkn/neROO/Dr3x1+PDOqU9a/O/z4ZVSa
N8ePOfscm865YUfQaeesJ7Ley7jJn5PrsXUi6H6/b+LTfDi3Fuqb7o/w/eKA
2RV6wh7QE+vfPIcPO4HPfw+wZPdcuLhyctrvQjtBLvgJ6M5PjNfz3QPSzgfs
e1XUj3JTP+zMnxvoN7r/vg79RsPolM/tVx2V/KKfv22YvsnHf2+iZPeEuLhu
TPKr5K/jD/jIH75A77dxIvcmg7mf1/aZtfgTho97jsHc0+u/15buTWedm/eB
yZf8wOTnv6+W7kknPeUDu3EV36XrS/fAg/U+YttnF/MD+/0FL9n93pST+oB5
P+2L99G+ZJ+GxTPQwdBb86DVcr2V7Q1xP8FqCVNO0oNJH+bpZtXgp5zwg+G/
IORfhd+fry36Ge51JT+xP/N3sZ3ac3d+YVTi8/rrsOfMZ/PctfOrEx/9nO83
F5ofYB4COvMQ0Il7oRP3Qsd/QMe/Qacf9OPKV2RcmNZr6ce830/zsfRTrl+a
nNYt6GdUfsiB5+6esDFpvRS9uHmGyXLuuSl3P25bJOOiFHcgX09/xejIFzrr
EtCRn98n/7KMi9N6KesUPm7v8HH51R0F/0s5vXxeMTrlhE45oWMH0OlH6Peo
B/0e9SA9dNJD57mPm16xfPz+7gGJM/V7DBZH17V/QI6kR47++w0lW0fy4/JF
Ms5cJOPMaUJ/xej+ew8lW5eC7r//ULJ9ddD99yBKtm7l5+f0nEO/jCvTeiL1
9uOmtK6H/aj84HPtusmnftzh5nhE/TRYx1H+Po0e2/eD33X7gJr8/j6MHtsX
BL/bJ9TkD+UfNH72DcEP1n4CjHyw09brRwbMbtGDH+f3V9g/F/sb66fB8v0E
2/9IOrD7fmxTzqRjXyN8/rtPZYtH3DzCyHAFOvEGmPgAfvanUR4w5WGehfKE
epWrvt5li3ODPMtVz99r+6PBcq+b1UP3eYP9dyuJp/uNj3LD5+9d6Ld6IB/o
yAeMfODHnngP9gTGfohr4ffxeopTSUccBp+/J6nf5uHgZ78w/P7epH6bv6Jd
YL9g7JdxKvaLPuQ78nW5Z8/sBn34/d3pu8Hox/MPmp3475eWTS7YDeUmf7D/
zulAhfx9ucvyPdSyfZ+G/NEP6dAn2PmHcQ3zJ35802P5Ii/4wOSL/MjXn3/o
Mezi63GNmucfLNiV1kPLCeY3+Md0ngXMe2LcWtV0/JKO+mv5tJ22sxOlq57B
vh332H5aykM7dfW4MOkZ7OrdtAP43fnnMalfyvVT7nz0mNQv5fop+iX46Ydy
/RT7AJArGLkSn9NukBP8YN/OBozf21E8H9bXU/XzN/0WJ/p0abwK3X8nKt2D
g//3+/lG7L4N/CXYt7d+e+7Hx8mPcu8LdMXcE+nniZZY/ZlHdfVvxjNy373N
19COkRt8yA0+9AAf9dT+GTr1lntjrb/0ccOAzV/RP/D9IsbzxKNg9q2wzs+8
JXZCf4Cd8H45T2DlhI4coXs5Jv+GXKBrP6p2oH6Z9+p9/7QnnuO//Ppej/kH
+Pz6Xo/5A+h+/3IxbvX7l4txKnL1fnewon5Y6wHGv1IeL6clVg/m/dmvjz0j
X+Y1vD0O2zkAtz7ZlLe/bwD7TPxuPcvO982ruH6zWU/tZ9AL5WbdnftrKAeY
dQEw6+Jg7Jd4h3JBZ94ZzDw4ONqvrZdTHva/Uh4w5QFTHjDvB/N+T++y+29o
P7HdyLn2fvvV5/gb6sG4lXzBnn/Q+BnHwg9mfIo8+OW5P6+XygEmf8ah5A+G
DzuBP4ixw+QCdvf5Ncf97j6/JobOuB46WO1K9ap2pnrOvUflrnIF84sf5pfn
vM/tD2rKSeWSk4PWW+1A9cx7VC8qd7BvN0MVtXNtZ2r32u60HUDXdqd+QdsZ
GH8p8imUX5+D/febuu0eUfbH+nFWl9w72mn7U/GX0LkvFey/i/H639MuXzC/
3KsJZr9p7rkfPya5+Hto8EfLpB13VdVfwaf5ajp3HrfpB+U70XIfcI/JW+n0
h/6+luT/lM49GWD1a0pnnOHlMt34oTOvAh/ntcDcgwPmnBCY+MzfgzrP5Eg/
AObeBTDnJMDcS+HvUe2stquXnkemHQW5ly095wC8HsqmJ38PUL/VB+zvSemv
+Hs1kly93stG9+WYb9ifo+gv0HP10Pe005vWU/WI3JAj/gecs/N2dp2zY/Zf
01/n5KLtTNuJtgOVd84uVc/+vpj+tnardtHOjtVu1A5z7ZDxlq932daV8Uvw
M46IcWzdt5/FJn/ibzD3u6h/Zl8235P1ckx25+ufnms5gt10FsqFX8Uu2pWT
7/F6v5jkxjkUvRcLew7z/C8V6su4lHrz/LZQDrGrxYKTv9J2xPN2ctRyU07t
d/7bcuXkpnpBDtpeiXdsv3e0P9v/F7Ht95Pz1vDZfnA5B8W5DtuvF+m2Hzxi
26/nzncvFXpX4bw35QJTDs6rUI5ot1WtP+UCUy4w5fLn05cKPZWLONh/3ySd
pyIuhq6YdTh3X+bydbUV7wdvxsn+vEuHv7eoGae7eyfGpP0Bdn4p/hLH2/qk
1GPl9yt0WD2g2/pjxLbeGLGtL0acq1euHrxX5ZqTI+VpJ1eVo53PlXppvq+3
nuI/bd4X++SX5+wT5DnfLwazfg3me7aaH/v+wHzHCsw6L5jvqOm9VtBz5fpv
36PlzdXL22v7eyGYN1I+vWfC29MMqy9+XO0BPjB8q3pOEkw/qfnrd9uRA342
5/fUb+X8lL6vnZ9v54e1/1A/nPOz6lfJT/uRVe03kBP8YOTo7vNp9pf8qj+k
3+RX/R/P6ceh07+CiTfAxONg5nPBzJODmc8F271nzl8OGiYO0XpQbsrn7w99
yeRPetXHqtZT3/N666nler31ztVD9e3va3jJyq3PsR/maaEzb+K/556+n6bP
9X4IMPMnYOZX9Ptk+n0xLe9/m4+f/0jfd9L2oN9v0vag32eCbt9bidi+jyXx
Ifs27Z7YSLf7QSO272M5O+oT/5rqZfeHSj0oN+UD8z7vP+cX2sOq1lPf0/pZ
4Rwh/Ktaby3n65WD1otysP8IzH4sfy9nr91z7fuN+YX4kPGu3Vvr+t/Ub/j+
Zon0a0ssX/1+h97Tpt/bsPYR50n8OGV+ob2TP/Mmen8XmPU2sOqFeQTfvy2R
dqf3OaT7wpDPyuOB16wcWk7VP/Of/j3LjB70WTY9MB/q4+Iu2z+i+tL7zlVP
K7+Pa1mhHDoPq3bVTo++f0r3cate/T0XSY7YO/sFwXoeQ+Xo20W5IDe1r//W
bvSeCW1H7ezIt690nyH5B73Mra3XqvdZ9n69/9U/b9RUX7pPzus3xeWh3073
tdm+k5Xml+4v9fJN8Tv5qbztnhwph+bTrlz6ntw9mTzXey355bneA6j3/Ok9
i7nnuXyk/BKvpvvk4LPvaYr87Z4jFy+n++B4bvcd0d5jO/V+Yrph+/5mxPY9
zYjt3pGI7R4qN84aMGz3nrt+Ls0f2L3ZUr9cuZGX3n/Gc+SifN7PTTfM+haY
+yzAeo8J5Vf/r/mqXO2+l4jV/u1eqIjt3qfXKUctJ36jZRdbxXRbley52pna
lcr1/7Ye7exM9dLO7lRvaoeqR+I42iX5aHsmfgOTP1jvQ8nx5d5DfwFm3xtY
zx/yPLTvQcP4YfVzzFuzjqHrFGAdh+s6AusftDP2BTNO8+d5OuU+poT9d5X6
C+uvus7JfkS/fj5dzie+ZJjxLPz+PqV+W2+DP7durPXy3y/ut3p6ObSvl9YD
rPXw3ztO9yczX0k94fffN+4vrGvqupmuY+o6mV9PSut1uXzpd8VOCuv97d5L
Puhd6w2GX/dJ6P4K3XfEuFK/owzdf0e63/ZHkI9vD2nfAnGKx2mdUeMSyq3l
alcOL98V5luiH9H1LsqlfFouf4/THLkPbE4l91zPhaIf5pHAzBupP9R0uk6Y
y6cFx6b7xfnlOetY+j7WmTiPgzxbxbDvh/QXnnMe1r5LETH7RPWe85W325mF
57l0rcc3xHudx8y1/bTunO+4hp3THR36hwqY3yAP7qHpsXr4/iadA+EcL/No
Yb5hxOzJnTeanNoD+7TJh3PFYPbn6/opz+FjH7aXT8K8px0f8luvhc+yeSvo
Oo/i6j0+nacG80u9dBzqz3MnOYOhs98cumL2n1Pu4PZSPdQueK5xg8YVtFtw
KFe/jSdD/RLGDrXf8/cfpn5d+1n1w/+73+yqfqNV3rkVvmeJnv15gP6a6h+M
/HLpaGf+XEJ6vqr5ok/sAAyddubjoR7zU94+0r2EWi7KwS/l+N+fzzX7yJ3z
9/cD9Ft5/fmMZL9gd75ihXNa6of8vv38vQf+HFTyW2D4c/cceP0k/+/l0l+Q
m9d7wrl0aje5fNSO6IcUq93xfQ7aDZjfHB/5+XNqqZ/y5+PyfLlyqt8hP+bb
+A6CuwfCzs0kOfn7mRL299r027lulQPlAmPH+pz3ebmNFOSZ45P62/fVV+p/
JqZ711bqNyaWvZ1OTPd0qX+iXwlxzwx7Hvr7surF2hP9hvoN8qE8/j60hKHD
Dx2s56b4xT+DkSPfuUCfYLHXutihySl3Lkvt2Z8/7zc5YX96jkvbP/w8B+fO
jWkcoPXWc296zo30ei8q/TDnscDIN/ccPBQO2lv/zy/PaU/kE9bh5xhfOO/f
Zxg+0vE8lw5+6gm9NY45LOHAVjL7J92ugc/8y62BzzB2Cn+Yr5hj8UmIu/sM
U27K487NjE/vhw/sz0PMsfqDoTOPhP7o322dNNo9euJ5Lh3zNe5+nnGDNddv
NzH+jvkf6GDojPPIL6wbDJtfA8PP+Th331ATQycffy6sWC4tt5ZLz7cjD7Cb
P1khLnL3xI3k66H11HqAiX+ZVyB+p/3qPVDEz4xPGC/k7oWCn/z9PUjFe5L8
90UbFb13Su9hIl9/D1G/3fNJvmDyhd/d3zB5qeULRt7+uxjFe63A/v6yeeZf
/X2vCZM/csrdcwXWcSX5+3mp4Yq7T7ZpJ6y/6LyHv/cmxTHIzd3HuJK4hfqS
P3w+jklY+ykw79N+WPtp0nGvFOnApAOTDozcyBf56ntD/zzPyg8mPeV2fqaJ
2R+FX6M/xF/zHD6ew8c+TP0eHXx8V07zIx3Pc+k4785z5pH8veeTpH+cVfg+
G3TmnaAT30BnPknLS745PsoJP+WEruWkXPBTLugah/l7vfsL/b3yEa/BRzre
xzzo92Mc4s+vN6zePIeP9ggdvwyd5/DxHL7Wz+RBO5dIP6Lz+WD4SMdz0um6
ub9/YrDmx7sJ059puhyf3rfAOhnl9d+J6bfvKYKxb9Kz/kV6//2Hfvs+HRj7
4j25cuTeC+Y9uXLk3uvunVrhO6/4UzD+iP7cx/GNQrocn943o7/0Q4wvfFzT
MOzjn4bEN8V0Gif5/pl7O6NdjBopxDW+f+Z+3DgOGjVi+xooDxj+EPZ3+/uT
RqV5Kb03BuzvhyzOY+l4FXtv9SPjmU/qt30cuh8EfuwLuWBfrn9c4buv/r6X
QZlvGpRx4oDcPzBgcaGfn2j4eRGT56Bh0iNP+JGn3sek9fTfW+nP1ht5Uk/k
uXHQt9Vb6+Xv7enP1lPlmJObG4836+/vZei2+Bd5uHm7UWm8nLNLMPVtZ6et
anJ/dlMerWIe1pPVE5j65/SWqxfYxa8rqaf/rl4aH8CHX9R732y/X/SD9P/6
POwLmm39LVjvZWjBFe5BA/v5kPy9XGA/H9Jr+xbRQ6jvTGvnYOLAkE+an2pl
f0LZ9AaG399Ht8T8iL9fh7g43S8C3d9Ht0Ti5qW2vzR3753eU8Qv9cY/U08/
TptZ8/FP8R424ifyZZ8X/GD4iePUnnT+lPLRH1Ae4nVw7h4+1SvrlZQLO6Rc
YMqBvaIP9iO7cXET+3vVhuycbO5eQfRBOtqXzq9jZ+gHu0I/YOIR3gfmfcQj
un5C/siX/JAvOHdvobaD20K9bD9u7p5H2p3vV5N9cr8x9fbtsq/m718s3mPo
7yHsN73m9I6eVe65e/iop/bfKne9l0zbgb8Hrd/aBf5U7yG0/ZPRb8KP/NAr
8kOvfr2oVHXtaiX3OiK/ldrJSu4NRB7aH+o9nWAXZzbbgZdTw+5vIx32Szo/
jmkY9nY5YPzwEZ/AB4aP+ITn1BdMfeGjvjzHL/LcjT+b+aA/+MHw6/gWPvKB
Dzr1gK7xO3w813z8vawJQ9d2o/fqqX2jB+hgPz/G9xuYR+yv+Pi5qCfiSNWT
i6tGD/h50L5+iytzdgUmHeM4MHaXswMw9aOcYMqZs1Own78drLj4cIV7CHPr
ji22FdbRW6+rcu9kv81D4TdmtN57u8VbpHfrN9XeqvoP+JArfKRj/h/MfIw+
13VPvz+r39ZdKJ/ui6A+YOpDuXiu73X3bjXrRTpZLy6s00EP+xhT/AVmnTO3
TogcdB8H6408d/etNfWm5UNe3u/Mt3VWnmMnup8j9Lt2j2c9Vw5/z3haZ9T4
TO0xtw6q67Lkp+WjHsxz469oZ2DaLZhf/BUY/wpmf93lLXxWjXMlPu7rsfus
sXfkEeVW9fsne2xdj/bKOVNt724eZdSIjS983JHau7/fvd/8GuUif3ef44Vp
vyrPOTfNOXN/z2HDsO+nh4yfc0zwg/1+ONbzOmwcwr5gP0/YYee0yZ9zPuQP
dvM7o1nf67C4mvz8OL/Dzn37+xi7LI4Fq16Io9ALcZSXQ7rvlPGYl9sSkxty
hJ9zXvB73GH3BVCPnBwpB/x6byXYzVeVFhk/+7Ht3FTEflw6JPdkzjd+sBtf
Th6U+g5a/eADMz9NOuanSQf248Vpds8D5wjgB/t5ooXGzz5tPy+0yPixR/i9
PSbs5sdGM64bsviO+mGP4NuCfqvkz75vf59ap40vsF/4vf0mrPJHrjk5gjnv
EH4G7RwH/gSM/4GPdPBx7sPPg0+x9Un3PcCmfKAjH3DO74Lxu/hh2hd68/vc
l5nf8LjD7tWgPeX8CO0Lfr3nFezmL5vty+7tiO3JzvNF7Odxhoyf9gQ/2M0X
NPXr6zto9fPnRJaZ3MkffZI/2K8nDBm/3lML9usWC42f9uTXKRbJPMlS46c9
wQ92862jhy0dfNQPPjDti3S0J5+us+rr22X8tCf4wfD7fir1I+zf9fs1Urv1
/ING934qlcN9H9HWi1I5wLl+W8875/op/FKuX0KuuXal5VA55OIEjwetX8r1
Q9pPab8DRn7u+4YraXfaLrWdgb38ivO2Xn7Ffs7Lr9hOvfyKdpHzw+3aMRj5
0m/m+kkwfjjn18mPdp/rR7Wf1X4TjL7IL+c31K+onwCjn9y8OfrJ9dPUN9dP
Mc+bmwdGvzk/hX5z7ToXl3o8aHFELm7QuELjBDDyJ7+cn1Q/qn5R42qN273+
h+1+N1mHtflBjweF377nYXGwP485bPc++3XCHuvXwfBRLp7nysU5EOhg6OTj
xz8NOycCHxg6cYffB5nutyNfPx5omN+EznlL6GDy9X40Yf+9omkyPpwu48Pp
xs85GOhg6MSh5Ofj+0Zhng0/Bb+P7xuFeTH8Bvze7zSsnfg4saPq8+uo+v6u
s+r7u86q6tf3V0U5qx5UztqfwY89g7FfMPYLxn5pJ95+i+3E292gYX1vrlzY
hx9vTjd+MPych4IOhs75cOhg6JyzhQ7247XkB8HQ0Rflztmxx4PCX6yXP389
bPfG+3HBdNl/Ot3K48dnDZML5QFj58wnB3setHPA9NPIjX4aDJ12BN3jYcvP
7xedav2W18uwxBMN0xvlB8NHubVcWm7KlSs35cMOKB+Y9kC9sP9cP0B9fDzT
MDujPt4OG+ZnoINpT7wPrO02166xIz/enJ61K+wIfuwGfjD8ui6BfkiPPnJ2
gBxyeqD9+fioozB+8vFL0Q+rn1Y/rPGNtvt25fDvG7T7hMmv9VPq9t+NLnWb
XcFP/tDdd85WuF+PfMHkSz6Ug3S5cvj+dtAwdO6hJD/Oz8MPhp/5AfgZN8AP
9nH7kPEzHwA/WOejKFeuHGDkCz/yhY58weRPPXLl1vEQ9ciVG4y+KAeYcqA/
yo2+cnaBvqCDoVNv8qOeOTkQT0EHQ8d/QgdDZ18272OdJLdOTfv17aVhdur2
eTYxfKTz9l1Mx3PugfBxV7rPMceHPj3/gGHkS3l8+2jUvF01anrvBRg6dkd+
vv00xO4adg+ij3+nGB19kJ/fP9UwDL9fl0/Yj7uGLD/fXhuG9ZwR8vJ677J7
Gb3fnl9RPeX04OU5aBi6l8+gYe/X51e8359f8XoeFn9T1KvqXfXarpxg5AVG
Xp5/WPxT0S7UbtQuvByGzU5ydqH77lSOaodqN35f1LD4y6Ld6Dwx5WMfLvtJ
kA84Z0der6mfVbvM2QG4nZ70nBRY52N0nK/3g+XG+blxlt4flhsH+PFRMc7O
xZlgjVs1rs2N23VcT78CXdfpdFwHpl/x3+sqxqUqB/op3qfrfDpO1HGkjhN1
HKlxWLt+XuM4jbva9etK135a+3Htp8HMJ/r91cluOdfW+rHz9Amzz0HPI0Pn
XiAw9+PBz3P95Z4h+LhfL8xzvCrn8NL5/nCeeYbtf2j5ke07bB9pGAeW/b75
aWl/td+P86rsn55h+5l5j9+v86rsn55h+4vhd/uSm+Xy55jSflzK5fY1Nfn9
vvi0v9bVo6kv9megL38OJX7vZFKPfXceOvpy34Ft6gt+9OPv30kYPbXEsVpv
lXOJ7FsCs3/Q55f0DiY/9kvw3Ncz2SV81BO6r2eyS/ipJ/1IS11j0z4Y//2t
dK6Lc4XwMf8IH/2dXy8btvNNLTg6fYfayXFc+r4kfoL3cs6E7ze4efmru6tK
d/PsTbo/z9IwPt4LH/Wi/6VeyIl7C9hP5/q/k7m35TVrj+wHBrfgDan9hfwT
1n0/Xp7Fdb7wvgWG+XXjYdv3nc4nUC7d56DrXLpOxfctPH3YxoV+n2M6b8D7
QhiX5hv5PoYvf6PGvZLoh33UPs7geyUdEt8MG5+uYyIvPSfmxp9N+aAnMHrC
/v05oEE5l5jmd5CXpw/7dbumfHgfmPchL59fWkfy611l+X57WeZ3umU+p9u+
VwwfcqY9+Th50Pb3Q+e90HmvnqdDbrRD/AbpeA/p2L9N+ciH8pEP73f6GFuW
9p7Wv+AD84scw29xfQis8+DsTwRTT12fQS+cs/brK4OF9Rl/H9Zi4U/zel5v
00ROqZz4VfLFr8JPu9d5cf993WHrB9x3sceluI77R8FeHoNS30HTI/omP95H
fmDkp/bvy9GQchT18r/rIZUbe1R7hd/3O8kP4Ff9fSHDdm8C/SL9uL+nqFR1
fqzZj0OnH1d+54ea/JQHfjDtjH1itGf6YeyZ8ard193in2eY93F+in4Sfxna
4YDt72KfgN9nk/Z7+H0z6TnxOhi/qfnBB1Y+v+8m7SPRX7/vaZnc98H33ecU
4kl3D81hKX5kvzVyAyNnzjUQL8JHXAEfGD705v3qUtu3Qvn9vpfUX9n3naJe
7TsNEeu+TPoLv/8j7acAky/8fj9H2i/h9+102PeoWJ9Hj36/7rD5W/iRF/x+
n+awtXP4GQfC7/fxDEu7H7J5Jeqt8+DeDwxZO7HvYkQMP+VBTswzISd/Tm3Y
yk25KLefn0/zpvDzHvj9ebk0Lwo/9YDfz+eneU/KgX/j/AByB6Mn+CgPfLwf
PrC/B2ue0cHEb/qL/Nl35uW/2NKB4WdfjefvrHr+zqrfZ9pV1fyJR9ErGL0y
X6jlAJPOf794mcWP+gu//57xMosPPX+ntUv/veOUP9+fA2MXvv8qF8ah3j+m
75bAr+NQ7y/5PhPnfdI4OPQjJXsOxr4oP/YIJm7x+1kHK9qPhOfJn6m/gg6G
7s9dLrN4EezPCS4zf6XtEKzt1H+nZZmtExGHEudgN2Dsk3l7+ImD4AfDjzyR
A/IEI08vt0HDfh13ocVv2BEY+/PrkgstvoMfDL/O2yEv3z8vsnJgx7wXOu+F
ru/hue6D5DnxNLgFR/cW9JDTE+9TvZBfCzbHIc+2Pjgx3uqz2aYfm7Ac7xbb
CXT0B6Z+ks7OM4/dZY3nfrvPKdauoZMPmHyMHt8/OTy3/e3QkR+YfdfgfcN7
Y/pZFcpLOjDpDj3xpPt7bh1fu3/NGXvtsl25fsVD+23Z+G1Xned/jc/PifjR
vwzN2PC8pTXw23Z+x7Z/+cuQ4bMuuO3oV26cVRu4fvtJVz8yvvbL689Y65B5
k2tnRfq8+Jzfk8vP33Lgq89VFkd8/IQTDnn5vbMqJxx47/CUW8bXPrT7m9b5
z7FDFfKfdef0f+y++1LDvxq7z9V/W7tc/WdM/4e/P7b+Raekel27Q8dGu83t
rR4a87vvh988c+pGdk96nd/Kqed8e/0pI6YH7Ab9kQ79gZG3nseBjpwtfcwf
++ZeNPJh3xCYX/iwD8aNlD/mX8gHOwSfuNfLlyxZt1G56q3v32jPJj/lwT+A
g/l1VOG76YM7bXTw9T1mZ7QfMPNClIN2gFyRo8nZy9HmHXL5gskn1y7Rm2+P
AwU9PX3QlEdX1IO0P4u3+OU5ckcPtM9cO1O5Yg/QkTN05CN2ZPMu0MkHjB8i
X+wC/bMuBR/2iP8Bs+7r7XfIMO/z+3YaJl8w72U9CBz1W6gv7wUzbvb1HTL7
1nztfJK3z+rcE47Z/Jy75tbOuWXXkTnbddfXrW60+YI1S9UvT9rp2NOb+H13
Xnj7Sdd01+E75fI77rypc2ptTsQ8X+eM85/55k4v1taJ6Q8t/eSXz3wq4cs3
P+6E1w6/pfbGq1a/9NkDe6r4J/L56di7uk/f++kK/K9e8Os/3vnijAr0vb+5
6THDn5lX2f/yi3d+5ZpUzg+PfmD+bt1T7T2bbbLdhn/96H2G1zr6S/vuvMGr
li/p3rjaccP7nFKyclCua0a+95XN75lbeWDyx994y5K+yrURHxLlcVaU06c2
Hn3bQWuV7Lf2wuQxV83prK8V5cDzTcb9Y/+7j7/F8EWxnuAPr3bRsRv8Z4bh
fWM9wRNivsj5wpDe5BbfV4G+YIORZy96dr7Jjfp8IeqDfH8b83nntT8565iP
JH1Af2PMd1ZtyjOrze2sI4e3jHvih/fs+7TlC/93D9tl5z2Xpf0FtMsHT9j9
lvpBvdVrhX8olnNGzB+9UI6JoR+tDB0V3of+vhnsyPQ5MerJ7C6mvzz005Yf
9aQclMv742GLu3nOL8/J7/RTPrH4M3N762I/9S0Wb7Xs3c388S9/Oue58ztu
XWZyjfoxTPrq3HVuvOPvHfU3vlja7BubLTE5IZfT13vmoiceKmMPVbW/1UM6
izPmhDjA8MCyn775yI0W2Xv3D3ZW26tj0+cf+nCH2df7t/jZZ265Y4HZF+k/
HOKM2u6l3m0O/OB9Rj850ofvOaQ+9b2zDHd/6srK+k9Nqz204Bvnvbjhq2aP
Tzx91K277bLYMHp7POix9q5nL7hg7ZM7zS9R3k+GdmJyolxrd3538OIpC62c
Z8Tfo/+53TFf+/Lf7ZfnfUEOFh9tPftXEzae3WF6xX8yz4ydbx3t7pjox3g+
EuzT+PjdL7S3ytzox3iO3xY7qYIpx6gQNxp+S6hn5a/Bbs0ukM/1wc4q35u2
+Te2/kiH0f9n7PEbzL1o2OR8Wt8lXz/lzgU1bS/3hTjW5PA/Qc7Vz2267yNP
PT7J2tdfrz7rxTW/MWj4u6MO/8VJOy82PLjg3I4bTuo0P/v4Dcte+MrsnqqW
98/Dz23ykYfLhs8IftX4Yj2t/2Z8Q3sEM96F76og59p+E//1ze1uWWb1/HzE
t50yVF3UxPTD2OHi2C7px5kfUzsjv9+MXXz3Q8/M13LVxP/VYnu29zD+svg4
tkPosT8wzD4G+E+OfhY6duP3uS62eOSGaBfw3xTlTvtCHv58YtniceZrwLH/
s/S0E9oN92d8dMLNH6sfd5ph4knKS7yOPGfEdkQ5PxD7RfhIR5wOVrsQedl8
HZj3Xbf9luf8fbd5FepPvlJ/K09v9MvniB8hv0Ou7vn0RzZfUlk9xBUpjgrP
zW7+EN5ruC/4B8Njo98A/yrYmeFo14Z/GvoFazfUh3jvSyFuMTp6uzv2I+oH
4Zse+mXLj3gRO6DdISdth7QDsNh9RTHtDX7VI5h+Vvs1cGlC6IfOlH6Ifon3
EBdTH+wEP0t+9YxfBJPer98lufDLPBXz6DynvtpulU/olg9+DD2RH3ZMu1Y7
B5Mf/Hbvm+hd81e/oHETdPqXG8K8g+ltm2Bvde9/yoYZ7+q4LcZxlg/rlY9E
Ohh/wziM9GP2+vFq394r2QPzLpvd/9lr1pjxnMUJX/rVNbv0fvdRswvshflI
/B3lxB/l/B6YcarGidTb66lsmDiB+TltV2BtR9gNGLtRPfpxdbdh9Mt7eD/P
qR9yR67IGTnRPiR91g9ouwGH/XcLDEt8b/5H3wPG7kiH/pivQO/YAXqAruXQ
dintwtqztm/40C92/tI9wX7Yh4d8wfDbOlnEzPOAsXvW22+L+YLJN/afVeyb
9HaPTMTErTzHfqEz/wBmfsbTu6pv/PFhZ/2rKZcd97h97MRHH6yAx7719sMm
3fdEZc6nx/U9fMD99vx9a1641T6nPW74exuedfaKvzxf98GtLj3+2P7Kgu9f
fvyWU0Yqxx+y3uI/PzNcOf3KaT17b96w5/G3NuNjk7521nnN9vCnVx85Ya3B
2ranv+eP06aO1N4Z8qnBd/tn1/3QGXOGK9CnhXSWD8/JZ3rMN5bL9MG8G+U4
q1WuQaMzzwbWuMfOXUY6mPdTzv3/vejw5e//6X+O/9by95zYksOAvZf0zLst
nbDHXW+b211VOvNuPD9u/SP+8uBD3RoP1H08nfw584KUk3q0S4eccnKx7x+I
nFQuWk+tF5h2lWt3uXYDRs/vinZzz3b73XR1ua/2jxP/ve966/fXnp8z78WT
d0kYvewT9FTZZrfjNh+4preqds1z5NZ63YW9po8jLu16T5Ne5/1/2XKL4370
91Id+ka9L045+JSOOu/74QsXH7uc/sFoLxfefP2TP6+V6jf5dLXLu8eceukT
r9U2G12a8eiLI7VL7h3360vPKlc3j5j8b3zthC0vvXNJ7bnJI+t8cIN+Swd9
cet3Xu388J4q9d+16/7eDf+U8P6z97moenpv9bPbPfnicc168Pv91z4967m5
N5g8uj90wya3/ehaa8c/nbXr5Vv9zxR7Dh/0vd9+xr++tvP8ykuLNtjoNyeV
TS5BXsusnPsGPsPPxvpQ79GnXrhe9YpnxH/MM3xDkIP6l0pveE/lnKk/3/1j
H+kyvX0w6hW9oL8tzvr0kR+8qsf47vzzOcsOmN1lfIc8++8WHfucNOYza75l
SvIzZwY/V3ssynWPEw792w0fXmb29s6ue7uX08n/qW1X23vqbgvNDtAH9nF3
tGPwC9GOX/3eI7se+PG5tTsPvGabxU05HTZ9z5++9j+/r/x4pwduemczPfbK
PY9b33br3P6mXhgn4q9HiVzXFT9/wrvGf//73em7wjuc0vrOfeWSqHf4qN/0
pTssafo5y2/Lfyz48/q3LKpEOVm8TDsgHfXDTsHYKfE8+TCuARO/gIkPwcQv
YOIALRcYv+L5Ow3jB/Bf1HfPfz197g+266xGedfETmxcsuH6v6vu/Z+RitKJ
u7454atX//GKhul3l2u/8M+eZrufEfWOPrWeYO4b/vzycHvNVA/iyrtiviPn
XnfYL1Yv1/nlPdiNxhfUm/dQDpUr9dD3gnN6Q86DDy/o++J2TT8b10uJJ1k/
R97B3/aY/Ijj4SMdv2HfSGedX42vec46PPT3hvoaZjwCZl8PmDgbzLjjlHfc
d/O7n+B7LAuMTn0+tUZ9woSOxVYOysX7wbwPLPG46RU98x7qxft+/9VRVz7w
i+n2PW7sFj3repqWQ+WCXeAX7vvT1Q+8+b0vG74svM/8w6/fN+r3/zh7aqWd
HLXe18V05HvKyyf/+MdLXjGMXRIvMz7Hnskfv0B5JgxUdtxxeEEl9gNmZ/Aj
571DOze66uH9we+ZnMeH8hkeHfys4XExDgc/HOUGptz2vYH39F6yPM7Gfz4R
+hHj3yDEHeaXGF95f1e29gjfxV9b+u81vtBR/fPf37fBuc36EhdQf+wCP4Gd
UX/aHb88x+7A2AlYxpc1TXd36IdN3heG/sfkV7/m2catP7rW8Mmx3wLf2/mH
3540eF2l8/lbD5/ZrMeph3fedM4vb6g8MuXMfy7vZ+A7L8QJ9p5tQv9Y+8Fd
H9/zlSbfobGf/dypb7nj+heb/feznz//Hx+8tnLEB0P8gz6QK/OiPL8h6M38
N/bNL89/FPmJp0iP3hn/YO+8h/cSj0yNfMwLQGceD8y8E3jnqN/hln577Tnj
d+OL7RGM/fOc+qxqOjDp4KMfsH4h6ufp4++++NGDUjv8Thi/mj4fjONY4jT8
HPQlYdxl6R8L7c7S/yS0S8Pfi37mj+9/8elvbJLuj6ZdMt9AO2GcwjwB9WOe
AMx4Hsw43vefS4XeVVV5kQ/zGNCZhwDjF8Gn7vuRwUNumls7+Cvbvbb/PXNr
dz2y3A80xz2/u3mnmWuW6je/Zbmce6vQ2/HRfikHv+322ei+jde770L3peT2
oeT2SfFe+y5zmK80v9Ru30luX9VGs47rvG7tUh05Lbn8Yy1/cvC+QwcdUS3V
3xOfX/bi8nHQiMmXdGffvPXZX2jMqZHu6xssH+/010j385CuAvbz94tqvPek
qOdD4nt7D3uwNV4gX95zhZSD+pAf+TMvAF0x8wDHfeyuymFvG6lNPuDI1bZ+
i813274j3x93VH2/0GF6Y94COphfjff8vd8dBbmoPcBHPaAz3wGmXuBcPXLl
ln1oVp6cHHm/ylXlqHLT+E3zWdV6YRc90V6wi69GO+Q5fOh5XNB75dy/vacZ
pyf/cfaN+7361J1za93bnP/bnz89Upvys/f+9My1SvXS48d88Ygt+msnbPH0
879u4gMuPHD6RpOa4ybhG/ln4CMf4taWnCf2Vjfb4Wujlvs18I579O32haPv
qBC34PeIs+EjH+jEt2D/XYLOeo6PcbamAzOO9t+JT+WmvSI30hFXgYmPwIxL
wMQV/206MOWjH0W/Fzy4U/3ymf22Tn7l5AlXfGjmYxXW/8O+h4EKer80+iny
IV/6ZdYpTuo9v7Px27QfduJj+9VOaI4/O5d09+79b9OT7dv4XrSTTb7wu7PH
N+2BdOTD+JX7Jvx6Tur/d9r7m01/212nvP2nndSMI+fUzv7hMzccNn2S1eOJ
Je+79PhjBw2TH/dRgLkPh/xfnTtu0g3f+Y/R7dxcxJwTgP9900rPT97yRqOz
7x3MuQH497us75CPf/21itbz+DBvbPWk3rlyXxPGV1YO6pEr9wshzjJ+6pEr
91UyDqQe0O38oqzH8ZzxEOffiIP3ebJv/22/1WfP4SN+/E3Yhy3rnV2GuceG
fvS6039a2vTeW6xczIuA/X0+KZ/uHZenT+MI8oX+/A/HTat9+d8mr1y+4LGx
XvC/8MB1HZveO7fSFdsD/iLGY3WZr6mf3/IjZYs/sFueD0U7V/qy3/ynOY5M
612cu/PrXeV6x8EbbvSbk0pWDn67wvM6+fD8D/MP3Pa1F2fY+35+6nL7LFt6
n/8S4kwr1/u7n2yOa4ZrGo/+LuZLejufEjHnlsDcP/DM55ePA3oK8e2fgv4N
X7bar3Yd97Vb7Pwk9jU16NPskOec7+L5w6H9m73r/Br8n957y76rXppVuejK
/Z/b5f6kZ/Tu1/fm23c3c3r6RRjXmz2iN+h23jlizhmBuVfX9iuEeRKzX86n
5eSM/LATMHrnvJG187gOaeO0KG/onD/yfiHtI+LeUNsvEebVLD/O86h/sXNe
rv2Uq9yLyfN/hXGnjSM5Pwedc79a/xffeu6yA2an55x3hb7+OZ+d2nNxsusn
W/1M0ktOT/THI1cu2+rE3zSyekNPlPvwA/Zpvm9+jXbKe0+Kfg+MnaoeVG/Q
yf/x2C5Ij91j52r/Ob1Sv/IhnZNOP3ggq2f0yvsvve6G9RcfuaTCeUH1K+Bf
Bj6Ti/qNV1rzKPOMbveW4J9Dv5vW5WL9oE+O7R467Rb6YUEPRlc7XK+1rrnM
6Ngl9LAOWTZ7xK5MTyGuMTpxFHGVt/9k59i1pQv9mtlrsJueKvqZe+YdT2/w
teRHg18t1aH3bXlr1y96y3We4+/f8cSazXhgZs33Y6k/IL+3RT7yO3L9GydO
XDyz9qXGpZdW3j23NrjF1X/+TjPug/+mO375jV3uvazi5yvKVt5rFv3snHN2
KFeJX9c/4oLGC98YrL3y86PLG180UNP9nZzTZx/xGsfMfc/jMx8yO6Y9QP9k
3LdLOvg2DucjjI900M9vzDrniv7HjO79xbDtO/xY2Fec7p2JfGF/cMP43tmq
V6Om+9VntOo5XLs37Cdm/2O9GvMFbxnOn9g+4Zc3O/ro2eN7DMP36RDv14Yv
WP8dHx14yPZtEq8zD/nm67fd4dH1+yvXnPu5x8f+u6/2lTCOLMTT3KtBPR6M
5Vwv1MfyD+VI52h4/qGwT75ywLwvrnPF4Owa58R4L+Wg/PdEuZF+apBPut8j
luuTsZ6UK4y3076MsH+zuN96h1hO7Jq4g3JvEeXs90mkfaOfC+duqg/v+ubT
j91ztu2zfqy1vzudq2HekbjykDAest/zZ9269J0H3Fk5KOK19njhsjmX/bly
cMQHCd/BwrfdExfM+vqX/27Pb9766Lf+4ooHDS84ZdO79/nxBMvnpK/c9qGl
P73f6Pzm8jlI8jlY8pnr9lGnffhhH26vnaM44hu3PXfNVSvswz/jL7tVmtjs
5uZNNtm8kfYFz+xbv/sLw0tql140ZtMvHFS2fE68+/af7fzCUrOr+/Z4/vln
yvMN83vWp3c96s6Nh2pX3fDskb84d6bZUSW8p3De4oPjd9xz9kZDpr/fRn0+
tfO4XU/5QlfBnt92Yatd1Y745ZhHur77qMnlhF9v/9lZv3q8cmDEn93/6vf9
dvV/Vb4Y8Zo/GbXDR69/wujfjOdXvx7x4/+64bU/LX7N8JcXL/j+kzvOMNw1
tTbQe3yiMz7Bzv7nxsMOOPPGlN+Ll2z1j3tfmm2Y+t7w3B8/9N73v2ByeHO9
vPvTuye+aiYf0r991NQl13TMrzzQOpdQNr0+fvKEm9aestTk+o7AZ5j3fTvo
sTIxth/owxdufeqn/visvWeboJd0Di7YhWF+/xHeW7n+sCPvfGdTX7q/+7jd
bi+t9ff0/Jdb3XXeiU3852i36o+/F+2sGu2S56dHuwJ/J9bD8Aa/eHN1w1J1
1uMvTepbr1T/Vnyv5v+A2O3hS2/d5djz03mKt3z4xi2uOs9w/dEop5fX2v7C
q449LcZFzfFR1A92eKDY4RfFDg8UO6RfGxK5/yD2e8hv/302u/jrx71i9nD8
f2m3vG/G6Me2Hj57pvWzzMsxX2fxaLRT0sEHHfld2vWZO847Jp0/GHh4r6cP
OjbFo+wrQZ6PxHbOPhDd/+bnJYYlzl9gmPVT308MSty8uOLjOp1HSXFeXD9M
8WK0lyfFD/UcW/rZdmunc0Xb7NO58S/XLuZD+sujH/X9eUeduHPjvc5ef/HH
8vVmHwly13rn5MD7PxH9bk4O7EvJyU3ljtwkDrJ+Yul5I0f9fXbaV8l3MeQc
Vn1x5COfHUNcUPAHbwjyNvzZeE7w8Niv8XxSOM9n/uGw2K7B8fyf4dmVxl+2
+MvLhmO8ZviOOI8LPii2Q/D0EB8b/mVsB+B4ntHkhN1o/a4M6ey928q5x6di
vZAn3/Wgvf0wnHurvSR6QG7gK+J7yDfWx85N3x7qa/QoH/NDXwnytHYf5V84
H/nlmC98/4hy9/Y03cq/TjgXbemfiOUwOcc42vurqeaXPnD74Inn3fSy0Zln
hb56PHfN+0nP+z8Qzm0nvcZ6w0e+20c+8uU90Nea/IEnOr71itF5zjot/o1x
wIHPz3zTFmeW6m+J8TfzrV+L4wDKy/3SlPdH4dykfW8GvnDeq6dwHvNLUW/g
x+K5V+7xJv22wY9ZeuwM+vzg101v6BH6qFB/o3Pvtuk99GtGZzwIfeM4joSO
/KFvH/UMHTniz9ifyX4/5HpAkHP1vLBOY/MoyNXWHUK/b/nzHRfonwhxs/l9
PSeEfL8a2wWYc8TsP4KfdrNH9BN6zsb75/Te74RztdUY31j7HjPx4nvmb/mC
tbtxV++05MQ/P2vt9YwQPxn+VYjDkr5Df5/OA8Y4YR2xp2/H98b43PwY5fh3
fH5UeL+147XiPAR2/plQXrPLtWMcrOfN/xjiyno9xG0V9Z8HSL2/G99LuVf7
WSu+CvswRpXqzx32xYPvv+BSy+dLUU7gK2Tc8kkp50+iHMn//hAfGv+EWE6J
B+w8PuuK2CV2+vLhZ1517DrJjpknUHtgH5HvDxIf+5r8OspLVh72Gfn5xrLx
2TxOrC/3brw72HFB3zy/dfsjP/XGf00yfe8W5x3A8b4Ow9QbP+jjwOSHhsI5
7vrWoV8s6P+0eA+I9T9yL8BfY7nIH7+E/r4U5qcs/e8Dv8kHPwX/GnHeCv77
5F6B70s91w3zaUbfMtYD+RH3UN84b2LyHYxxCu//RPCDhj8W/Kbh1WM/hB2x
fyeeO7Tn7OPhPNnxjU12u3bdpypDcZ1wr01vP+qJe16tcD8U9z594KiR8luH
JtvzS2+ffOtXXnrR8Lyjxj1fP/wly4d8le/4o8dc8M69plWWSjroPH9sk8m3
n/jUNHtOuVjfHrX+nedudm2p+tbwW+f5+Ph741nrPfjVw/vsPlg978q8OL+y
/7LCOg7nEo5e+5Pfuvr8Wbbf4uKWPGfX2LfQ8td9peoxkY99/PCx7k9+m929
zctPr1cmLrD7A0eH53YOgHxJz/vgJx/4ea78lIP38x7ez3uof0Y+cs6wZPtl
t72qfszC+b31ded+5dnLti7Xec55Gp7f/KljL7top1k16G8Pzwv56Hmcv8R0
Xzrl9I232rfHzuscVvrwuKfvHKxNjXZy1NWHTLpk+/7aRzY86bU3HTq+ts8e
l+8+r8nHfCDpeO+PfvSV/1TWeNSeT9ntqiOu+siAYeS1aUtevVXOt1xQXf1t
q20/XNvjR107/nzKAPMCst++x85Vbhn9K/v/wOzDA7MPD8w+OzD77Dy9qwo+
LZzrs3XXeP7OcO75GfH8DvmwL8vTBw1/N57rg599Wzz3fMM1fQ+Y9Oy38uUb
Tuds4jlK+NnnBWafGTh3L5ne8wc/+8Fy+ahctN6aj9YrV25/79iq3yOo9xpi
N7H8lr/Ip/pMaCeVbcdfvv2sg7rr4J/2VcafelLC6446Y9TvHuo0/MDV0x5+
y7Wd9a4/BPyr4Ndr4CXBj9f+23zBuXzBnfH31NC/1MCTflZqzHrTv2q55+Ar
W/tgequliFeP5/GwM+ZhiIc2vOjsn2z1yLLaGjFugW+1eL6uJPlCvyeen/P3
owzbussJ59+z+sIfDteo9/4Ttxr7obm9dfKL+73rkj/nLSuHx/OXsb+tPLjr
2Nu/+cziGni9o0eN/vTFi61ef4rnJaG/efLJpe7hQcNfiX4U/oXx/OQa8f1b
PT9619PfO8v0cONzu/5s60/NMPy50D9b+h+Ecwi1oVY9yqbfz7fqWbZ6tR6v
2WG4cvvVu56z+QIr12sX9E2++8iEP3/2Ld/e8rQJtTdE/jeFehB3VA4N9TB8
X5CL4XWCXAy/PdijtYu/Bns0nKsnOOitbPZ0XaiP4Zfj+U/ksl887wkeiuc5
wX+I5znBZ8bzm94+7dyJyRl6PG9q/NTz40Guhl8Jck37x+J5VW9/qV65eup7
yT+nR2//A7bvkntC0Ct6vm7Dv5WW7/up/u7Qi+/Y4TfZdgHOtYOc3TOfwDnu
nJzA8JGOcxDo4/hQrwr1PNyfk7Z81G6vGHn4wi12HijYsb9vZaCtXSNP+x5n
Gzt3+1yb/QNyzLVT6oFdb+H6yUHT77RvfOt7kz40z+4tmRznQdDzC5+/ccqE
jdN+MeavSX/mMZ+a94ZTB+XepWGjvyv4ZbtfckycR2G+BbmdftcnP9d310zz
39gRdsX8C/xfvKD/+k9/tmzj8zBO7pV7OtO8/NmhnFZv6gH9xSCHCu9H3npO
pd05Gfr3+u9uf/uaby9Vv/XPCautdfZ4y0/P0eh9GXpedVXP2ezZuu+pv3C/
3N7huZyrWmSYuAhMu/nao0/9quvK/topr3zytt835U+52H8Pv2LiKH+uuUPt
V84Tp3PTeh8E722Xrl29yFfr+d/Wg30gP/rjQ2++cs/Ztb+fedFOF51i+8EZ
/1Z4flrkY1/FlNY+u7Qf9Q0PnPzyW2Y8Z+uQDw32Lbz2J8/YOuVWbx71hgO/
92/D79lyn7d/tme6rSP+vGe1H79vwquGh9avrrHorEQ/Iv5e8/uxT35x3uTK
vhG//L2+e/+23xTL94dfmvintx76H0v3zsMnbbvDu182/MfWeP0lw3seP+1j
l10y1eRBvfz+yd7qhqdeNXHkpLmV3e/5zi27np/2K7Gu+cVMvWd9fPy7+td5
qiAHLXdYh3/RykU9oN+91+XXfXuvaYa1XtQDDN9pO55x5buemmbPVe7I2c93
p3u3dB1Q/XBunQ+/y7lg5Ii9BH/WMH/2yw++99Clh4xYe+X56YHP/EG4Vy6d
n7B7GOJz+JgXzc1bMi+Zm/dsN6/p98e/ZO+9OZSj1u7eIr13aFXvFdL363lE
6PhxMH4afOrGR573g+1Kdu8GvzznXOzUbx/w1ze/d27l7ta5zbmVN8V++ceB
r673e4RzxOnej/7hDYeXY79e21mfEPm4jwU653zAtC+/vjbHzvVgt+T7evMB
kw/5+n3e6RwH53rAnOsB63mg15sOzL4fzt+cGeW5IOijNjv+6nlozqX4+xoS
5hwKmHMnYM6dgDlnAmZdEsx+4/+/3uvvtSgVzuuyj4r+7OFLb9n9/IfSfSCc
KwFzjmT21J2Pe/bAUv0LMZ3M/9p79XyK5gMm3d/C+6vkOzO8x/pd5pvJV+/z
CPuS0zl0ziH4eG6JvVe/n4Rc+GUfNfyK2Ue98veUDbNPHsy+eB93zjfMvDeY
/blgyuv1O0/GHeneG/alq7z8d8bSOIR918rPvu7XWy/60+lhP12N/nffVr88
x+g3x/UC5K/1zMkBft3fv/L7YdrLKWcn/h6C12rt7ELl7O003XegcvXpinrB
r338/J12nrlm2fqZUbXXpu9/z6xa7dc/PGu14+fW7pu157nfacoV+kcDv/lz
1tfAyDf3XOWp3w/V8rNv+eBNN+h4+Jy5tTXO2/vzM9fvt+c+/i7ez6PP2XcB
Zp+Et8fpZj/sYwCrn4Se49P6sm9By8G6abtygVkHBSNvLZe+19tXR0FePP9W
1Pval2x4xfDGpfqDR7z1J+e+o1R90+yT1u35w0lmDzNi/LLzvg8988Do/spf
3/a5J29/Zylbr1y5G2ts2LtsJ1t/qch6TOXWHyydcMRGg4aZv7gx3p8EjvfG
GN4h3kcEfjLeV8Y6EutK0K+M9wmBD4v3Z2wZ79Oxe4DieTTwB+J9OeD74/ky
8Onx/hzwsnjeFPzPeP8N+JPxvBd4/XgfjtUjnt8Czyp96Fd7PNlr6/I8r8X7
gMBbxfvMFsf7GkWOhvm9JN6nA94r3g8G/la8z9HPj5etHIeEeRib354/evzI
ko5hm7f7dWu+LK0rnR3vryE/1i2hbxjvsyEd+cwL+co8XMLbhPUMmzf7cVjP
MHxvvJ+H9/w23s8DphyUS8/xhnnT3sJ8LeXQdFoOxnfwzb31o5884rJum7/i
OXw8f/D233y3a4duO3cNH/0/WO85J32YJ0v7WzSd5ktcbfNgj55wZvnUut1f
D992P/v8q/9Z2GPvYXwI/Y+dj39n+z1etXwYL0Jfe+SRQ29+X0eh/uy/5fnb
Ap+9l/2ujG/rG7+03xm/XWDvpRy89/PL3n/axJtn2D3k8PW12lOyY6+/xTZ+
rr7w7utP+OJio1MP0oV2merF/lu/v63TxsfwfTrka/WgXtC/vtlNj9Xmzjc6
42fo94R6Wzl5znuo/2XP7vmB6ppLLF/ygf618B6rN3yXhHSWP/WCfspzp/7z
nJdTPccdse6f99iql/s6K/zy/Nprw3zu0yc+1tpXffhRa18x9t2zK+Nav/2V
Ky78+T+ffrK3+n84e+vAqHagD7Rb2eLORUtxd4cL9yzu7u7u7u7uDhd3d+cs
7lZoKVagWKlQBep97cn8Jt+mb9/9vvfX7pyJTCbJZJLMTIYTTHo66yHDlXSr
1wT23vMpQTuesGzS5ZYmK+CGpns5Ml31199c2xSUlG+KMZ63aI3Ed64P68za
rMWWFHUK5XQffDvqx/OGaCl+fevkvMXVcrXs+K0PbgdrW0S9XM/P1Sna55oT
rwPONOzPwS9TQzXA+D0q6LP8WXXqRrNxZqb7ibth96DBDiL289ArccP3aoiH
B3pg91HvzD9NCrtt5XM2o75YV8u9RuPLeYQkaB2ijwU6JsLCPiRBO3aq7+k0
PjJO4touO0oNuJ8AewuOM3KO6oUdCuqFHeBX1Ev8utD98vFR6xKYX+4UJ/Kd
Nix96kS9YV3EyiDfRwk60iHfo14D3Dok6gMP9o0PO/jPIm2P56UcIy+4WnaS
HvKLzjnU+Lb4jn2nug8EDD4Z03wmrye6iL/lYHWr1H1D76vB+sDnuYsMbOrA
8S2RPqGOa6aMifD7jqP6at3ku53gC8rBecswKufC6KKd9yfyCfsWPic9Fvr0
L/cAboez0LsZtrUnMlts7YXMrL9XN/RxGfcF72cjPWCk77vet7lvkzhbe6dh
YazPbR3kdtLtTJhW2tAT2L5D/9f4Hs/l9DbKCeV8OwsXTWy/Odl5V6e1Tonr
udxfHBLt1kNFv1nV9B1EetjXatmFXSnLJ9hL4jvS4TvSfaHzG/AT42jmmFep
Xr+W4wrjLOXzm1szhi/Ren1NtWbRRZkP5Qh/BwdrCNUHe3DUh+9/RDqWg7Bv
rjmv3XuXjA7Wht9+16zRfjOnQz6kQz6hZ3FcaC4fdCAd6AC9C+ncMGrisYDb
m4K1VM3GGfp6/Ukvutf1DtEfUrvblV/fu3yiHMn+Jc1F1782ai/v/J2yzfoQ
vUTTxTXL15X6NemJrBfdofhyrSh+JL5XpHiQgFU9T9XTvBW97P1nEScG+cem
+bHE2xqs5fStH+U0+yzbmTUv0vnV9OB4HfH9SpSo1SXnpAT9jPfeorMyhHK6
Vy+v7fk6P4TTNRH5NOAhZ2c3PJbNWiFBLyrKYbmHchG/tuSfbKZGRUO0ew+O
T+mfJlTPNu7+2AsZQrW4ebXPZ02cHyUEXs8YeLVHy14yHfKhHtQLOz/Yo0GO
YH6Dzh3TJ7z3OGJW7PnMvI4iP+zcwAf84jvWjdfEF9AxXdDFv/iOdQ3rHPhy
0ad8a68nUu7BThH3DiI+hAPb/cHOD3xs4jT1S/QGuc5h3UP6/Ge6ru96N57p
bXBiXKbrNeU6inUVdCAd6IAcBB1YD9V1mO0uSQ5Wr9Ry7qbweO4vp8lXGybF
2UQ/k72gFpvr5uwvgfHa9POt/LRHIcwv9RwF4w3tQrqZIp+OclAu9weVi3wo
B/wrTOMU5XC7aNx5pvCLP/cqgduBdmUz7CRdeVw5juqwZeAYVwvmB/YvvH6R
HvRgwZfJphqneV06kHvD/cR5ynCncctmnIu8oL2hdMjXjr4jnf62aIR7f6mX
dTTkvLzHQHtBJ9prIjqxDn0gOlEOykU5WRqcNvCA1Xo8Rm26ctVRvmvwRMD8
q5z303vrCWwvDBjjBjDSC3nM8VEZBh73H8gPWKXbXrlqOfboVOlQ6VbpUOMm
4ztg/KI+0Fl2ef86teNCdPziu7rOojyVLtCh3Dcx/ciH8bE8+v24Jqd/snzw
Dks/PMuOINZTuok4U/qt3ht2Odd+yfm6tIlZvT6XB+vPfSk+D/LlNeROGKev
Z8idME6/0NYel+ed6/BmNU8tlvd8XY34+hLeYehFDhbPBg9SVfEM4vkxv1+P
w4+X/uT5UTSl6cS1hqe1oU6NrqRJnI8cv9ht9os9JS+xfPhD8wzlF6R5Fk/f
kS6K5inS5ad0gFE+zTcr5ADJBdZjSS5YKxj23NIevGG+x0eLnTRxPorfwvnA
R+TDfG5E+cDHIZRvKfUryn9J/Yp1pyP1K8pHO5eci2k7+pqUu5WMdxEkHGbo
mSZrD2MdknbujY11yIHln4iXzXHwmY5eIp8VfEK7SC5xu0gucbs+GvbnccyH
yy0WB/1zI47H7URbe2puzycxTngezdi8o21Su1lPFuOG078plPFIZfMPxldO
MTX1juZ++pRKXy8syin1glWnQ39f9pTr8Gnb8z6mc5kYb0yn34eM6wJXn2Q6
M1E8v7eiXh7P/7yo3jspbh/Gc3FBhyr/eX+cVcg7qyKnGa5aqNT2o/vjuJ1+
xrsMyfcx6vqBfubxRv0M+otQP99749Gzdccwni/ZjXctku+DACPdIjHelPt3
k+VFw7z/On+Weo14HyL5Pk3d72BfhXGGdnSjeQ9Y3XelFHKH+Sne9ZD2AruE
3Em2v8I+DXYjkLeA1fUA54G264YD7EP1TZ8K16rd9iL/4jv23XvyxueaYdmv
dxe/2ijyr8C+f5SIx6I/oe+wb+J0lA/l9FLyoZzG6xuvivq8U7tJ6w1+8X20
mEc8HrGO4b5XuW/VbffTJqtyn8p4nAvb7rdNVuW+nPmn+uOodKBcxEljOig/
6EB/1hDzjv1UkB6/OL9tKe5JtfHE10PinpTho39X831e+6eG+75mt+64lb4a
xDDuRXFuppaDdPbKYT5TO9A+dbyBb4ijBjy/syLkO8enU/Or31W+qPWqMOot
LfQZrle5v9Q5HcFIh3zgO84n4dcGOwfoRZlPjlrQZISEfyb9rHSwwk4B+TKK
dKxPBYp0DMNPDn5zp0U/8P1tK9EP+g2C31EcxuXF6yx5OcrBulT8WvD9Ubtw
j6NVf+qAt5JdM/yzepNdM2C6R+N2k9zS5tN6ouYbpYf7/74v30sjeQx5r18y
3iELZbzw05JwdWN9COX0K4QfF79jVkWsH5Dbej3jXbV4xg836pfwXaP+eG0N
pYf/F+6ZkQ50o1zQrdIJPOjEPh37dtv41JJutAP50Q6VbtAJuuHXCD+3i++m
LwgaE6jTubj+3FifHHh9gt8g0j8j/AhKf4HyI73t+42x/D5UwX7t9peaEcP1
PDDOm2M4H2Ccd8CvEvRfVuqpfG7Rk1LpI/h8BHSCH0+JTvCN77cypnGfeeEn
t/8D6VGgC3q6ev7+hvTyszE1Ij+0ku+JpaD04AfK4/N5Suf0pca0XJnjuJ5u
CbnCx++M1VdRuq4Eoz1FiU60/x2Vi/R7HL6kWdQ9nNsPutB+Wvct2yiu2Qia
75FNRVyzkQSPVL7XoDhlo+n7EYpThvzzKC4Z8CPspPtB8cxGK/kmUdwksiPW
21LcJORLQ3GTAMNeEvGyn1AcJKwrZop7BNiX4mgBHke/iNulpgN9vSm+E+gC
nSpdyK/S0ZPiMal04V4I/qL1dtZtuXww3xvpa2tunjp6XYiG81Y1XZer3rmu
NP5X7/Wo3sAa5WU65IO8FH6x8Sw//6V7b1u7iHi76QAjHfIJv5R4rmcr3VMD
PiXS8/0MvtvLx/HvKJ/t+85huu35noTFPimU0yGfvXS8/6J1G3IU+y3s23CO
CNhWnsvv9vJd2L/OOB8/9U73vP033kOQ79keyHx0iD7BhfeTt+6mdMytyXNb
6B1Ij/0Y8DgX5f10x8HbHifuQ1sUsBSvfitEh10M+FGsZafP945d4f1ALv8J
r0o9fsAw5CHSC//nOMa7i3YxjPYgPdoDPNoDGOlAF77bowvtOS74p7zzEKf4
aSen0/YdCslne3xvRPWl73p5Z8tJZuX9Ddkue+0U+m2glvrwovwbc8v3dqG3
Ij382mPzOGRYMsGf37ccdejA86NV/fVLqfXpmT4k6LUjE/526y3fu+zjuS5R
vzJZLhLe9v2WaB7XDeJ+XtrbKYb3Hcx38rtHOryXCTrqR1hmBeUNYTps5UCo
bitPwnhfAPsnyKf1Qq7pq8jvHvfP0P9Bz1Hhx8/9FtF2/PsBn7E/8ef5BjtH
9BfiBti+hxbE5TgVH5L79boAfj8TfGxA7etNfER9RveONynve8k4BIgPgH5E
OvQj0oFO0IU4BaALdAIPOoFHvcCjXnX+gI/4Dj7aviMkz9nQ79h/IN08ineA
dNiPAI/4B6r8w/zF9xw0X5X7eB4Pg/y9xr6K5XWA7+0xfmBH0MNi3O/r6+l+
H9+Rbqgoh8tV7A1Yrzol9EHmM9rN7wJSO9EOtKssySG1XYCbCbnKcgn5UD7S
3aBzY8DgM9KjfuBxbgxYjTuhnkMj/e376ztea+tqOU/rDOQXvr+lfdf8sjXn
zt0s91GoB7/4rtyfsJwwr6u0PPBBFJ/Dqud8gIuMibPkL+rHdKL80uI7r4fF
7xYOqjjwLKdbJM5tuf3lRD0W0IHvpagcNR9g5FPjhYAulIN2fB7fs9ahajv1
FS9vD8l3JVg3GxvimfpNslveR/5Cj0W8QgvGXRNhV6qdpnUd4wHta07jBPZE
HnSuh32P7ftfv5K9vwQ7ftiBAw+7a/V9J8h/wLATRznqvgsw7OQBgx71/UGU
B/8PfId9MmDYsdu++xXNMOzIAaM9an2oB+2B3bptObHK/tdZeU9L8gnttscn
tR61XJXfKp/s8RH1qXxU26HSrfLjf8tndZz8F99t34WLVuIhyXe6AOMX6eBP
pPIH9tq279U6WmGPju/gm20/fWMY/kiAVbmqyk3Yndv2p1Oy/rNHB9oLvMoH
tEtNZzu/vjEMO3XAsKcHDHt623fzkr9Xppar8gn1gA9Yx2zf3ZXvy6JewBhP
tu8GJuejPTrhR4bxoH4HjP4EDP8ywPCjAQw/GXU+/G/zgX7QgV91PMAvDL+q
PMZ31As8/McAgw7A8McBDL3N9p3fIIZVuuG/o9IJulA/YNRn20+/NHU82WuH
Wu7/tV0qHf/Xdqp0q3JGlSvqvMQ8+N+Oe3tyRl3n1HJVefxf81qdF6jvZ4Fh
hp1yMYfzY0ssd7A+H+PbcVk6B8viMr2r5j3mYPVa6qi/f/Wd5/Xv9/dqnrD6
sb7xuKu2MkUq+U7xnHvLQl48NfE+FvrPKyoH+gnK4bhmVA70SJSD+NRDPp3o
v+SD2QL6Wi9IvXu9brY0W1q8pW+MA8ex7v/taeZXuUzcjqlxQWVK/Jb07pzp
XHHcDUkf6EE61L+D0qHclBGp0+04Fsfv3/1JHRHao1UY9Cu9sjgf5/OkVBRP
BfBvsiP838Zd+7/GWVPjusGvG3aI9G4Nw/3ovSHA9K4O20tuofd6ANM7amzH
OZDsHaCfhlJ8TPi316N4lsVvf+ocmQg7XyuypcM6V2sJgj+Xv5qx/8ZoHXBJ
4zecYf9jaRpmvfmDYbfHtX9uGvBLA/yyep69rnViNZRf92Xs0eorTBbA7ksG
LwqNTeQPwcVcL+k7ijhz/VH7Dp8Zk92by1/vO7LUVB8Xxl/7UTwotzme8ZVq
lVu1/7uvPujLseIXEuG/Rl2YtmObmctPMbVF5ePF/3D6rBt+LCt78xbDtf/y
zPQ5KpTpj5xz4n5Lz0im/9Tx07n+qu/E9F8p4dT69khHhZ4wpbw4zt8q3dgZ
tVrEMr+37Nh478WYXwwfD10y89qJcE7fr8eAKiWXRjM9g9xWeMzJ58z1uxj9
ZeL6m7Vs+uXHRTPDozf5pKjQ1MmK9BM6mPcs/hTJ9KWP/Hdo93bfJL3VnsW5
1HzO9Cw6ENVlXJ4/XH9MLe++BwY7Mj9fRdaz9PB2YfjD2HXj0znJ/jmZZcGQ
T+E+ep2uv2u0T9zfdC7W27tISRcrYPH7kfGBzQ4PbjrOifE53ldK83yeB/uP
lIzfcLNvp0iGp9a7cThTva8MvzQNrLFl3x8NfiA7h6dvd/mY9OvZXyBrhNc4
6Sf0eOj+7HlTOFmRP8VZl+257sZweS0bFPc7GhDBcK0DpSLfVX3CcGTj6J5f
qkaw/8qJC57ZWmeJ4frTN75zY30/Z66/WsPu82OuOXN9K44//tHoxTsd+GmF
ppUdndtsQfvfPZ/76WVIjAZ4r9e2It4vnBn/dkt7z43+0cy/gqWn5CmRPoLh
Qn0PFh+Q9Rfnr/zx6WmfTY7MX4evflGfpv7h9Hd9zhy60/Yuww65spnzzInk
/FVjvl2MzS39bOYIvxsub/fl+fkutZTte1UrrPy7P55c3rPGGW/+0+s1wxk2
1FyxzlX2R6jwQ+Py8mXumz3t0s/M713GO0Sf9Bz0vhf7XdJ7XexHSe+LAe5P
730B9rW1n9K203tmgL/T+2WAe9F7Y4A7iXeFWK7WEPHedcjVV0Lu8bzKK+Qi
w8WEHOV5VV/IRZ6nH4XcZXwRIRd53ucTcpPn2f07ZRyjb/hw+WeEnGJ8l4CJ
a/Okec744y9jP4wrH68NJDm5TshVLj9nq/Dz/jWkXLgk5Bzjl/fP9+fRaTPT
GyvkJKevK+Qow85C7nJ7mpVwyrv4cRzXf0XITc02fxznbyHkJsvF90LOsNz5
7dprzc5Dch1yEnKR6a1n8NeV6R0k5CrLuZNC7jK8Qchlrs9byDnmZ5yQgwwv
E3KS82ub572r8NSX6akfU/1yr15ynRkj5DCXP1LIaYsixxkeIuQ+15epU9sm
S7+/4vJCBt4YOThSzsO/z/6scf1fL55n3etO8ql3XM6rNvdat3tS3JfxGYWc
4nl4SsgxnnexQs4xXOFa2scFUrxhuLmQkywHnYUcZbiKkHsWRc5xfbuFnGbY
W8hx6ffZtPe2GR+kHFh+++i1lbvuMVxUrAtc30Mh11W5z/AHIVe5/UWFnGQ4
n5CjLPe8hZxleKeQcyyHs5xqu+70YjPz11nITS6v1Axr2XkbvzIc+8WQu1xe
RSGXLYpcZPiu8Ltl/uwX6wDX93tdxPV7oz4yP8LyPwgvPfk911ddyG1OL+Ko
O3F5KVYUTrN//lNOP61l+b/OlXzB5e1/u/akw4MF2qH8lUYWuBhM9xfBepPZ
xrvc4t6ri6sF8FDxroIV3wGL84gExsNOHPkAAw+7bODFOYuEgUd62HWr5SCf
Wi5g4YeaoKnlqHSrdKp0AMYvymW+KPbnanr4+eEX9YvzIz+m19g23jcxX5Ef
6QCnMfYbZ7ge5AMM/x/A8N8T8er8lX5MXh/SAYYfpu24kPWJdplt6x8Wz/ls
+R/C5SCOmcovfFfzqd9t2+tgxa8tP5OPX3xH3CYVj++AwU/Ef6Q4+hxfGfD9
0xF+eVfEaMsmTL9pPjtT33K3XYn4Xc6WXgTby0cwl4s4g4ARZxDxCO2lQ/xB
wIgvCFhsSx253v9Kh3ZkrZ+j/OnTETrggIvfHjdtGqOhXYcfPHFbO8vZsmBW
jajGwa5WfDfILuiKuNQ64joA/inK4XLhVw58laaps30YKeuF3z3w+EU8gUyC
TuY//NCRDn71an6VTsQpA6zShbh6gN8KOySGQafar4g3hnSIFwAY/vmA0e/I
j/hkKv0cR03Qxe2Fv70t7JSs/SqfBD8kn1S+gc4lxOethxZl7BH+lssDnTSP
2M/0v+jCuNkm5g3zxR7fjopxx+NN7bfCN1vtTef3hukEn9T2K/HheR75rCk+
f3FGB6up7Mpd670SdIdnI7oNKhbC3xt+HTbry+0ErWFX87W2ibAjpVt6ot13
z8T1tDbFswk6cPxU3nXB6nizIF3CU1Eu/B+XG+/Ru/K78er7v9s+JsVnTtCn
t6ka1uNkMOdzTx+7vFovRyu976rDv36geE9KzxcwKnE/JcvxqF3rxIbUf/Ae
rP57yYuXH7eFM9zl8YRuYx/cZHj2zfS3ckz5pgEuffVai4ERkQw3f3TJZ2c7
Jwtgeq+e43SCnvWCfg104/1k2/eSzZbN1E7kQ3q1Heq73WVcXiTu8+L0bgHP
fE4mnZtSu/COONL1I76o793PJr6qdKnvgqP8VGNLlnDvHcvw5f2jmk5L48L5
roj3lq34RTt2b33w18E6Ml6rl3gP2qKOA7X+/ZQP8KiLxrtKDKMcwFSOJa2g
k/mCfmpvbjX25Pxf3A58RzsA4/dQ1LElzSdFc7ol/qdis2R35ncPMc4xHlEf
xhPgOTSeAGM8Acb72GgH1mPoAbbvBztYEYcC6dBu5jfRW2JO0Usdb5qt+EV9
d792/TvM00+Zh/L97cKd9y+dmThf+6/u9C2fhxy/GOcoR52H5UW7uN2Yd2jX
Q6o3tNmnezNuP+H4G6WMcRzK8CaaN4BVvtn2t4npwbxU6UC/A0a/Aka/Aj4q
8DwO7H3PeGP01qxbX/H4CBfzj+HObTd83W99xvTi3esc9J414jHk8uwXVaxs
LJfbd8Di2lfa/mJ468ZxV+scluPQpfr6denLOVtU+lAOYJQDGOUARjmA63Rc
fnp2eOK+jH5R/osyzdvMmeDD9HyuuayPfx9vpudr8c1mr6ey3dz/lA/wF8oH
uMfkaduf+f1gGOU0z3RjeulEfn2onDpjGxcPhgsdjCpXtmqYdip9UvwQOd71
fbtj6rQ/qa3d0f5Ng5vB2l3f/B+bjXPld9/Bf+QDna6i/Vb8go7tgk9Mt5+g
i+EQ0Q6G74h2cjtaiffHGe4l+oHh7KKfGK4l+G1R5RXqBRxM9QK+S/UCRj2A
UQ9g1EP+OzriYSAeCL4jvkaBR7sKR99N4HZa8kS6jbkRyfnIv4npufXJ1Xdp
zT+cfvu82T3LZPvG+GNpdvn1TvuZ4c0Cr+EdY7xrDHwNUR/zaUP3D0UqTnZk
/Mupr+rtr+HEfDtZoV6+7ofMPG7HZm3mFPDdxYpfpMOvl8hv3STKZbzaDpSH
dMepHTyPbh8JcOt8m+FN1C7AeOcS67varv9qB+gEjH4AvEPhc38hdxg+IOjl
cWAV7WNY5Svo6KeUo7bzIJULGOXCT4HsSC0YJxhnf0i+txf8sDTMO39xUtwM
+JMgPjfm7bzl80e8DHW1HO7ep2XSvajf5IcNO/0dzP7Ohn91ORnfAuWiHvH+
oyu/K1lfyQf/1+9ULuQG5AjaF3170OCQJy7Wq0JfSDaelol1xNpSrENWdfzg
+77DA3N21D5wvmrPTh6ZuvA5wxloXQGsP8kyb+JBX4bH1Qj5+9tcKTex7gB+
ItZdTaULdLiJ8uW4FvTweGgj1stk8vy2oEMf0TRdyrqHXC3gN/C5qVxVD0I5
VZV2bqZ6VT2Jxym1u+zaiSPzJOITTo/Y0bdDEKdX6US74Q+EcYV1AuMK6dGP
6Fd8v0PtVPXBvdRvOEfB+yQ+Fbq9dqkawnIT4xJ8wvq1P6jmrOd1nmGd0htU
yDch5Z1QjhuBeYNfnM9gPO7etPKy82c5jjGuse9EevhB7qvlmK9JsKy/4Caf
be10FyvK6+I6dPToay7W4u3rLVzvk6BtKhf7a9Q6F+val7HZs+d2sSLflRK+
nWdsDNLXEd2Yl1kmzpo7NzpI72Sk+6Aj/ctuPvr4Zx6s93TvkqOq5v6K1/HP
o4+5RQ0OY3z98lf/Pjxdrvv4HZbLr3XaIb48Hxu+dNs7c4CvXozorTit++np
Nz8xfsDnLe/X3rjB+EoL/v1rWXkr4x2umfdkvPpNAz5L1jvrMvf6rnXrP6Ju
TG7JF/caH6wx9SRfdhjt/sDl9N3v77N33keu5zfZX2w33uUxWbLvN/QRTj+/
x7+L2ow/x+kja0V1+Vn7B7/P+8W/2uDAf/2YrvTjGhT7uMmB+/2U4D/rN0On
tOgZkXS+R/104WqRspNTOFvxHfw7R99HCv7rwN8kfYnKt9YX/cflrvqS7WjY
2iCGQUdQibPOG1ydmS8ljF8na0KPAWm/7/3F6fHbmsaFeK/IZH2K9woJ/2lY
q2U+1U5yfw8mOlFfgcdz3xXK/or55uJujsr3zJP3yaNS/ttwWP8zXG9fGmfI
70ftBN590c2UU+r/4HHWVGl3AxqHyH+B+I70Dj1FO9EPe2k+Qr6Qfsn8Xzl2
Xepy412tynpiRXuc057u06ypq3WjIZfkfhn5G/qOvPFvK0feFyJdBpp3SI/y
Z7SMX3+5pSOXf2Xy8pyXizhao3d+8Ok+S+638RsrvnN9Djs2hmXvHM38Hzb1
9JbWHaN19Pf3Zy92tTJHQ49mui65rajZ65iJy3Fb1srXvC6O5cSlx7VvtZ0V
y/3sJPioq/O9keC//p3GycJV54Z/PRGghyrjJI/Sj3HbDboZBv3n0nl/+TI1
XC8BedEnMuBz8XAd8wtyGOljxbzUz4h5w3JTxMeS5yP4HpNwa+3dZze4nQ/E
eOTyRPkfeF53F3KD6VxD86zbsPY5123w53c7kH/NnKZ9j+7/pYH/OcqU7HYs
6pc257hpUN3jJu73+vNGfa3rbeJ+bxZaJFeuObFMx4utrllye8ZyP64X5TI+
uyiX+QT6zot+066R/Ff3UxhX2cQ8Zbqj8hjzlNt9WvQD40uJfuB2DRbjTM5b
Mc400IPvjUW7+Psj0S7GzxJ8sQQIOcXyU9DhZCmutI/kJ6frItYBTucm1gHL
aprHqny7SOPaRPMG3xvTOAYMfQHvIZ4jvgK/kuhQy3dU5kmhH8Wz9Q78zf2w
2njn/Tf3W4ac/e9u3vhbx7xGP0HOX6R+3ExyE3i8PwI6Id/cqV+9D16aMChf
iBZE/Yr6C93ePnRoGg/u5zpj8rQc2fYF8/fN+Bq/5178xvKS5heXh3VvCc0T
pOtK8wTpeF7/5em3LXMU1z+8+iWtb9YoHg8hXzdV7TeA8daMNM9n9Xd9mSSn
14d2qJ6UD/w9p8zzglH1Dtfo58TjIWjxBS/3/nLcHO9ZtE3eFU6c/wLJPcDx
JIci7rXw6joynt+pTtgRW2rCznjutzRVThTbvSKU39kW736bWa9DvyAun+37
8CaOGwg5jnL6OMzb6l0nkN67d1Xe2XawfNN9vFMGO3B737Y3P3l6N5Tfp0P/
g++De7ebO/DHY+6XQT0OFrpQ45lWMfX88i5h97h/Hh9bOCSu1x1OB35Vn3ht
1p8l8dxf5x/5LPxdLZ7fYeJ7T+JfYeN8J15vIvRiHrdnKB/ghrW9n8778z/m
C5WDduA9MrQH4+POglrTU4wNlfok1YN3A23umRvJe1784t0e8K/Z6h5nHrRJ
bHe7BmuWtgnS57+6Pr+Vewi/y4V3ukAf6rE9z4rXbO5rE+u1jQ9p5v5qTO0G
fz0N/pt5vGZ+2ThmYKSUZ1jn0E/Wnfvr7U4TyP3kHdm/yt4TgVobMW54/bG5
73ZIwe8GAR5h8D2W5duFtGMPzq/0i+GGYUvaT3oQnUx/xLqF8egnxqP1Tf98
vQ9ZnJPJvyaiHC537dwT21MHh+sjlwyOeLLIkfUN3LeC7lF/55lyo+sflpv9
RD8xXMujXelb3l+5H1bc+jS35u7IZPoD1j3Mr05indbjWzSdlKaUE/cL6Ltc
6tDzv4v46+ZPUWafMm94fniWn1LgzXdvyXf6vmfpp+MrDr/j757Ve65ZE/5e
iyc5qZxnMh9t+RSrxYQ13XrqtCPr5dXc3rufWuzI6RsZ4zxO7kdSfX6w6MQf
nhfOPZw8Fnb/w/ijNO+B707z3nYehzE8+VfuSuNbRHL6WEPeRTIe/X1IyC/L
GL9Bz4s6Sbla6drrZsVKSrn7sFbhU14v5Ljm/Y6xDptk+0s4ff/+2ZnLhxzF
OGX7Fxs9L5b7E3Ia9QAPuLJBl9SPz9M4/ynO7fU2owuNiGss9ctd/xzvpH+K
4PwF/Ze3tlb4pZ+Oe1Og6j2Tlc779RPL3qx0PBvL5TSjcY56otwTXq99LetZ
R+Me+CLiHJzhKzTuAD97+3eqM4n7g91iPusthj1uf3nsGS7vs9BbebyXS7l2
pPsHPw34KK3c13JnAhnv+tGh8JDC0YwfQuPOdp9j4vlw+f3bRrt/OiEutT6Y
+gl4jP/Y+cb+nMd5H7F/5/Xj80cxj8DP9zSPuD9EuzW8T0b2CTy/Hs3e2XRW
jZ8a7Fzxi3qRTisyavyPAWdY/l0X/GMY4wXrNus/B9b9fh4izy0akdzjeXO9
5T5LnhhO/y7rqKPao2hun26sR3FcfjvjfdFY3rdBr1qYy3vt87tSbmJcotyO
Ih+P696iXtb3P4h6eVxCTwSdO7tEXb7r/YvzH2ozLtijdgTji4p2cv7fDyuM
evDEn/flvmPHzrhX3J/x0AOB9xv6fNqVNl7czrsk90DfY5J7yH/AeLcwnNP/
K+YVp88n5hWnh94HenvsMdetWiSa87c/sjhDqasxjPcW85zzox9Qfj0hLxnv
YuzTTSyvhDw2sXxKlXJUXOtZUs5BT0R6oXc5Md7nZl7N+ZKzBfzZaZwjyP3K
jfFNz1i7ynM+jK93tE4i38AnTqmWD5b59kauWbaslpSHz8if21Y/knKohWOh
d3erOPK4mvylyJDSVR2t59ft71g3ER522v+h82wHa538Bc91zehgPUZyC+3C
vhJ8/qfLWPfgtbzOWGmd4HFUw9AHwzi9eCczHLD1PsktyJmmDq5lO1W4zvKi
LY0rzMsEGlfgB/adKL+t8A9iuXX395AVH/N+Z3hG3wb1m8cGcb9jX4r8N/Ys
+ZhhSJjUO2lcIP9RwQ+kt6ZVxgF+sV7R+SvLxSVnGib8rCT1uQ3i/JXz9fSo
N3JhIv6doafHsZ7RntYd9MshogPwIioXMOgtU2xN4zMXfuveojyWW/mJLsDg
M/ieh/Z5kNPoT+zTwa9JmQZsmF4/ivsZ6S7ROMA4RTvR7k7iHJrHMfLhXALl
LwjaOHDWxd88Pp57DT3bpEEU7tH13K9Xrco8Q8477PvBzzDhP8btfGO+1Pbm
ZjPrTS22vzryYaSZ5arYP0p8HeOcxdX6jvKp+upw0kvXCn2S+wt2cpiHjYT+
KfVlukcAHnZovD8S5SbTj0cqeu4aqhf8my70Mnn+vdPQy/SDR18P3rDcn/kI
vRl0orwGROeGtY0Kde7K70yw3M9Y8dHySuW+cvn5lyyZWcXzK8/XVALP4yav
wPN8rdK946Wu4Z9ZzhZ23XSvc4vPWlX6jnLy03dVfw4R6xDLg3sN0y4c2TyQ
x+dsoedy+Q5Cz5XnLqT3uwr5zv0MfALp+XfEvonbHV7wSem4pf48LsE/9Bv4
R+PBsiTb+tKvYh14XAr5buJxie9RQo/neVBF6PE8j3dTvwHeRP3C+xChZ7He
8FGsMzyexf2Rs5X2kazXulqf5HzS5HOy89i89yN+Hol+L+W9WLe5v1+LdZvt
wl+VvvNjc+OVjP/mvlb/WnoPl7d+z7e71o/e3P/oP9aPhB4hz0eF3ot9LvcP
7XO5XTXFeOH+KSnGC9ORUpxX8LyIFucVjE9N4xT5c9M45XMm4qs6/2g9thYm
PuF7u9VVt54YsIfhldRuwGdJb+X7FmonYB8qF3zYJfIzH7OI+phPp8W+RFP3
o1spH+CclA9wDOn5TBeVM1joFTyO9gu9gvkdLPRyHhc/hF7O/MQ5A/K/pHMG
dT/ncOL0/HAPM+sjQs7I+5Hlxrwxs35CehGNe1fWSxrTPYlSLtfjSPXweb44
l2R+Qn/bRful+qK8ZPsV3BdC3gSu2n7k4kc//s77mqvinhHyanPx0m9zH3aw
zKPzIdgnmMkuBO1Eu2n/y/x+QnoR5E1OUR+Pd7O412T+XxL7B9YTp4l7IZYr
4NtJ2pdiHUgl9nk8TyKEXi33FUKvZvnzm/ap4PMH4muTO7tcfiSmD/g29keX
K3K9AN0oL0Dwj/GlxX0u6xNdjHOpjyzP04h9i9wXiH0L6z1EP49nuj+z7KF+
RT7UBz5hfM0X+yzmz1Xax6YhvuB7YTqHRz1v6FwacAE6R2a+CDyPN7QT46Ud
tRPjCnxHu0eLc27uX+RHO2qLe3GeX+AT8i8X9wTJ5p8P0QU6UC7GbX0qF+kb
0bphammsi8numx3o+0Vh5/A/9BtxTsrrqm6sNwxjXmwT88TqTuemQWQXBjkz
Tpwb8byoIs6NrEOFHpTs/tmF1jXAPZVzwNNEJ/h0W5x7MZ8Hi3Mvzn+E7DeQ
PjSVOAdHel86B0f6Oso5o8lq2+434vyd8cOoHZiPZyoPrpPqpdy/5DLsRsP4
HWaOB1vg7fkJnl+0GLo3RdwO1Z4E8UqQbuzwRqtytvjC6RDfI4Dw803vznT6
/obxqLfE0ARTloi3WhSlQ7lIJ+KgfGK/B5Sr0qPSiXjm9B65jvfIgVfjweO7
8j46l6PWh3jwYyldO3oPG9+RrphhL812iPz+4vuf4R9nNAjieCk+5A8DO6gU
t7oN2/U4gL8jjko6+s72auR3Anzc8gN9N6Qxsd2QykfbeFYmtrtCPtAp7LwT
10Pnm65JcVXU9yMbiu8W23hBKfhc4P89HpAJfmIc1wX3FIBVPyHExUQcubgC
jTcmvfv10OnwrulhBzTcz9i2K1R73/GEz9X8Mv4R7Oxt6Ynj+Lfgk/IeMsdL
xrkg7KIAo37A6neHw+K9tScz+t7PstvZivfX/ILGB3WsarYCPzWTdca0WRLf
e8/RLtUCHa0pCF9NzBM9HcGTxHzTUS7KQbkoB+UCj3KBR7kplHJRD74vEvNX
NxO8Od+qoqMmP9LxPYXyHelqdMlVJaSTmd/dfTHj6snMPjEcH8BC5zyA8ftM
pOP36lAOzl13GPeSzhakb0vnlkp6jDP0G8cpmGusz678PvLCRvdXuTeN4Xfz
Ogzb02hDvkim63uQm0vnuGjGP38b9ObkyAjlPeVQTl92Zu3mgfkimI+eQq7q
6aqkzLTrgeT/lHOVh388Lcs5urrLuYE+fxiu2LTx8tieD5ifT0S9yjvHoQzP
E+1guI1oB8OTxXiwYDz0FOOB+6fsu4INFxYP0J1VugnG+Mb9Zdi930HdKpk4
fxrRPoZzZ/KN3uv4i/lSSvCF+/mL4CvD+4x7HWfu5ztif8v9BrkEOTXU7cT9
+1H+yeyoAKPdEwWfGT4o+Mz15hB0amo7oKflFH4WvJ6PMvSoBO4ne/2I9fbr
+uGm/GtDWW+saYz7UO5X9DP4Cj6jHVFi/6u1v1+qS8VgV57PGOfe/zGO7Y1b
0Be3yi1HtdC7zI+V8QHLtoU8Yb0S9/T2+Ag43Yjgos/8ZTm490c5SIdxjHTi
vDeU4xa4rV06r9TDENaHVhh6Z8h/jnNb/SZeOX+NZ3mMeQC+YR5g/yj63ayc
v5otdanfcE6L8iLEPOB+wDzvItYVrQmtf1eIDuSvRfVgnIEfdF7MfrYoB361
gHHOBhi/8O+Fnyq+41wJsIXao8rfI3RvMu9E7gEu3+NgF621pnslNT2d12ur
RD/xPIGdBPRck3FuJu+9hol5xDDsPKCnBxt2M/L+FnYKwKMdKp/g14p84tzB
ZJeP0DuQvnXLEkG7PwUk4zP8avEdfrWA4edrW0+wXruMOM+Cn6/aX6o/Mr7D
79cWdrKo+dHPZNfN7cavsGOT/a6OA5Vu0HmM7lXQz8CDTivda6j4/6LbHh/R
bypfAGN+jmly3iHjA2errf26PGfCudM4Sof5Nfny+TX138fw/vtWs3fvvE2/
GMY9twfpKR3vr7vyq8R7xvfcUy96wvHXfE6wTZyjMjyvbsOhF/NHMFzjVIEC
ReKjGYY8Iv2Gz71wz/qi/rCGsxLXP/W+5TrRify0XvG8wj0r0jciupH+4psj
FYuXkeevOHcDP4dRu5A+bnXp2XWOvOZ5iHtWlE/nx5w+SJxj8zkCzu2QfhHx
JYLKxXiB3QrWB5RH+hPXj3tblKcRX5Ge9DPeT+OeFu3zJL7a2o/I+0/co2Ld
wToUarx7G6KVL/L6dsPEdRj+EdhnoJ/6xpxtMHKlXO+3OTe+sGJEJNtDzvj2
T7NPpUO4P34Z9iLyfgV2NCgvUIs/Xez0Z+6frq0Lrxs46ivnz/S23HPHMV/5
vAvn1sDnp3UY5cMOB+VR+Rrs3NAu9EtGUT73C+5RUH7l82ETVpz8zP2Nc2+0
v4/gB6dPbdg7/GF6YOeD9ppHOqyplFnaeQwYcu7N3t3yPK3GotNNtEQY4wF2
P8hfW6yjfP77qfDw4YEz5XlvGuNcVp774x7gM6VDOfil+q0pBF38fQf1K2DU
h3S9qZ+Af/H26raK/k8Y/kZ6FsPUDyxfiG+AQX/51k75tyaWD/php9WP+GSP
D4OoHcxXZZyGKeMs62qDPsa3F+3hcbNJtJ/7We030EH6JJdznviA8bBW6Jc8
/nGvgvwXRXrmA41/rRyNO4xT3AtinDJfhb7N8Faim/Q45ivuacHXf8Q4YzzO
CYFPL8YxtwP3omyXIOhjPO41MU+qi3nJeJwTIv9U0ruBx7kgn1vTvAQe954o
P1TIFcbj3hL5y4pxxPMK94R29CkL4sVeovfCcD+pvof44Mxy73RvHCy7WuYv
2qCSK87dNPziu/K+GZeD++lntu+l8fkb8KjvTsnb225tCNQD/p6ZOySbp9aN
6llQe9GO3J5fGB5Ivx+N96k+8vfLLbYcGNfii4Z3xlCvbXwqB/X9ZU6/0HiP
VMZJQjrQNyf/4BVTz7pa3MQ5K8+DisIOhecP9ncFjXtGCR8jfyOM8/wFKuW9
Ue0605/21ozP6f3eaLsOdnnRLfythvc7jxjvEX7iduN3vTnl3JJXv2vZjXiR
IRy/Eesa1jn4QWC8VCe9HuMJ+5ZrtD8BTOc4PN9KXFx9fvpeFwv2rWjX0c/G
O7Zcv58xT+N43vsKmPlTjMqBfIHfAOZ7TbLLAZ/gl8Pn8LZ0WuCHgfHeVsSv
5PlQiPwa1fP/QuIexjqC/Aj5ftDhtuG3A/g1xRlgmPwWANvu7+L1ghSHAHiM
K4x/jCuM/8JEB875A0R9fA8xQNDH9wD5xP1Ssvvcr5QPsB/ZcQIeROVsrnHs
R/GXCazHAJ+fyj0p7NOstvs1ue9qIex/WP6VE/Y/vM/KKfwqWX61ILtN4NOS
HuY7ZMxkj4oJWgUar2mG/Tn4ZWoCj7eoFQlDHwSara3IDk35zutjDKXDeHos
7Lik/azIz+MtzfCebeq7y3ta2N1DXyK7OF4v/IUfCrc3m8jP46+u8K9ivXOi
sJPj8Qc6yb6M5wXZ11nKk90Vvj8huyXAsFsC7Cnw3D743aG/pgk7K6YPfmXc
XyKeK89/+I0h/xxhR8V41OtB9WKewg8HfKxM5YKP8OOoI/R6pneJ2DcwnNZq
aurVVO4rxon9HMOjxH6P+6+j2Adwe/3pHBf0ws4a8qICndsCD7th5D8q9lHc
3gNi38X4v+gckflJdrso/zGdawMPu0vweyuda6vjwUJ8AbyQ+AL+wk8A/D1H
dCL9ROITYNo/y3Ei9kfWV/QL/k0S+0Lmf02xr2R+XxX7UoZR3lDKx3YVlA9w
ZupHwFYqB3ZG4IfwU5L7fNgNgd8p1xj7Se4v2AEh/02y4+J9MMWNwLrdo5C7
471lwXr6FS07+ruF6B2FnLXADgnrPvzx8a4w5KFjL69RNXcFc5zFixPGxX2s
52C9MLpo5/2JcvJA5YkJy3I7WMNGHt+f1TdBd6vUfUPvq8H6NUqHepFupu7+
j1tifa/2T2y+uJAa9/KnHkrl9CK6ET8FdOLcWMTff8sw1pESbUoOuRKbqJcQ
HVtXr3/q9cKV31s13il/J/UYvLOMey+818zxAYgO0IV2oF2dXxTVktox7P63
vEntCrOTDv0AOkCXzfvpiXRhvJC9q7Wk0A+S7d/yCDlo1YXdBX/HuCZ7DOuC
LRcunnTy5XG6q8sll4UtvRjuTXbDvL8qsKv8iR5ntN93HbudMfpX3Kuz3cii
ld6j631k+DrZCQOeRHbCvL+je3jAGNdYV239m5ysEcJOhtOjH/CeOdqNdt4Q
9PH8nSLay/O1hFhPks3fjKIdrOeiX4AnewKGCyh+IauJj7yukx7A/jLC3prz
NyG9GPBakZ/nMfQE5B9CfhZIP4vaBbgK+aGAD9QePncn+yxOT/43XD7Zj7Oe
Ab0D6UsT3xC3AP0WQe9KoN/AD7Jv4rgDaFdPencC9aYjPR8w/E7Yvl/xI/m3
Y9Z8nScHMx569Rcjbrvch2AeQS4VJjkAPRPzDfzCvEK7EMcC7WpPcd+X0TxE
vmw0bgDPp34EH1oSnwHjl/qP+YK4GLzPpbjywCMOBvCFBd8YD39g3oeTHoe4
JHzuKuziuV2IA4Jyegl7Kq4HcUCA3yLGIeNhvwf8d7LrAx58Bt/xi3kGOQ55
v/VUV6dXg4J1yM9x9LuUviv+nLwvQNwVxZ/T+nvKlrFJ42CsW1L8B4lH3BLg
Lx9fFtsh0Bl+BlbVLpj9SIQ9JsdzQZwV1e5XtdtV7XJVe2HVjhhxYUAv7HJB
796SmQ4+XirjuyDOCvCrAxpuKfWPD+Nhtwv8+7rDgu51uCnjGFDcFeCte1/H
n52zj+nprsQHgZ0v0u/ul2nHrQ3fGI84LcDPyD1zyhQXaZ+MuDWIo8N0Xk2K
0yj7BXbXwNcT7z0wHnFt2N7z2J5baYtLPsHOGvjvwcM8jk6UfELcG+DnNTvf
5f6j24yHHTb3wxdjP894xMVhf87PM+bOjZZ8gV028O3E+xSMv2/Yq8p7qyJL
6g6usNvBAjzOEc5QPBXIu+qtuvwd5intj2Fnjbg26n4ecW5gd63aH8JuGnFn
7NlBI+4MYJx3hb0oPPh9ZhPHkbFnN404MvbsqBFHRvV/hh01+ELvHbHdtRKX
gNuFuDhq3Bo1Lo16XqDapatxgGCnrtqZg17YdfM4mDbsi95b5odd+8QBY0IL
Z3SwDK+Qq9TgS4t4XMTSuRHSq3GGYAev2rXbi0MEO3nQB7ty1NflRVD78mNk
esQlQtwitkvwXd+0elXZD6odPeIOIX3Z2atzWbZJPmC8hIjxYgm2jafEcYMA
l6NxrtYn4kfIe18Rv8SV6fpA77wgzogaF0Qd//CLRxwKdfzBLxzlb+ifFM/V
keNgqPMNcU043gH5KaM8+JWivK30Do0aBwVxjDjuivAXZngYxRNQ45yoftfq
egO/aMThwfdKyrhGHBLVb1iNK6L68arxAOAHi/bSe2Y65B/8zBFHRPXbVOdn
ISFHksUpQNwVyM1MYvyx3MR3xE3B941iveRxB79a0PtWrBvcLvh5Iz38apG+
L70bxHKJ4tYgzhTnc/3o032WHFf3hX8s44fQO25Mh+Jnn4fejeN1n+LasP1I
+ZQtfZv8YTz86oEfQO/MqfMLfupvSN9B+p5CTnB6xLFhPSLD6lKtFzxjPsDv
HPhnQg4yHn7gbAdO79wBjzg17N/4+PdxtzORcn0lv3DgN9G7eLb8crDAbxnf
6b09DXFqkK75S6/lUys58foLv2DgneidPeC5f0U8G5YDiEvE6xD58aMc+C2j
nDr0jtU5kmuqPEHcEHtxPRimedSU4lghzoUqzxDnCvWLeRALfTeZPLugyBE1
TgjikqF8xMVA+ddDtdq14+S4RBwt4Nv8lRRvlPNbfWjcOShyFHHOABdQ5ADu
f2qf6Nth8YkAjhOmxuWyXUekH+Bqpd84vgiNY35HjMYx2oM4Hzwuspzv63H9
OeMR54vnIckle3FVEKeN/TZJj0T93UmPRNwTpLtHcgrpUD/iiKF+8Sv3IWoc
F8SFQ37EJUF+LZ316lVHOS8Rhwz4oz+S/LOiNYojpdpnWe+S3EecPOBPiHw8
LhCHDvgoQTfjKd6L1N/FPoPxiCMH/HyS88AjThzwLcU4ZDzipgHvKuYJ4xE3
jdd1Q+8w8bxGXDTgL4p9ZjL58UZZ59Q4OYirh3IQ9wXlvBybFFfQSbF/k/Us
E3obz+u1pEeocYds462ZrDgH+1bwcvZBkfI+OuBCU5/uJhP7P+DcFumwz8f+
Hn4dgw5m2aTlCdavBzRfPjFxnsJe0Ff4v/L5M/w11LgtiLulzk/E0cK4/yn2
tzwv4IcPfElapxA3Belqi/0fp0PcLuC70LxW5xfiXoDfC3d8MbcsEq+dt42/
ZRnbI1fUcW+ZDnG7kvnHUtyC87b+/xxHATDiInA+4V9vUeS9FXHBEHdL1c8Q
ZwB0TTDoDOU4W2ocLVWfRFwc1Ie4Y+wHSnETGtrGJ7MsMfgk61XjcI0S5zbJ
5ktDhQ7EYUA+xEVAvhhxrmDB+w+4J8gu3nFO5s+C73XEu878He9Yq+nxfjVg
e/mUfmI9Hn62oB9+rKC/mHEuYGa/X9WvMNn+Q/EzhJ8v4iyofoxqXATVL/W/
/AJVPz/Vj0/121PjCKh+p2ocAbV9apyIwsq+B36j4Cf8QMHPMkKP5DgWqh+m
GhdCjeug+kGqfoqqX6Ia10DdzzRSyoWfNeiHnzLonynOmTi/Pb9RyC3EgYDc
OiDOD2V8SfK7Bn4WnWOhfvjJov574pwtmV8q/F5R7nVKh3IRx4L9u+ncUJWn
8LtFfc/FPkZDXBHWa0oUGzXngZwnPE4Uv1b4GcPvFfm9xLrJ+RHng/29hZ7D
fEecDuAPCvoZD79X4CeK9YLx8HMF/jatU7weUD8Bv536CXj4vcMPPiXxLQL0
U5wO5L8q9G7Oj7gYwK8T5xjJ5KsaN6WAsi+Hnz/KgZ88ynEX+1rLGFrn93pe
yjGyqoP19qAs85bncLCkDpye3Xx4ulZ6dZJekji++qxObNBMfh+x1ixDD2F6
YKcEuyT1/AZ2Qv9bOx91PwQ7HtDfUuwD2e4n2X7Mjl2UaqfE51hkB8T6v9A/
ktlRsR0R6SVIP4z0EtXOSrWDAh52VqpdFPyQsS7Bj1hdz+CXDBh+yIBRzn+l
s1cP7A0Bwy8ZMOwkYY850vgNZPvLH0L/tIym79A3oa96CPtG6xehj/L9E/I/
FvabVqRT8X1yP54/NzqAy0M5zqEfIp0uhcFfVoM/LeiGPSn8L6H34runYqcA
PRd4+P39TXa5sG9JQ3a4SAc7duDzkp0t7PSRLj3ZgaPcSLLD5/h8ZFcPGHTl
E+8KainIjh34amSXvk/xh4ogO9ys5Demxg2sQHa4IfRuE9mhs/91B/HuD9Px
k+IEgQ7QhfTwM0f5tyguEPlRa/B3hr9c+YKZCjVfEaOXIPsr+N0g/wGyuwEe
fjigJ1b4cbAfte17lQxTf8bBf18rI+plvz1hp+LC758psPZI+DdbFP9m9tuD
HxHo3EV+QGgH/JiAv0N+MGiHiOPlwOk9jfXPgd9Df0xx74CHXbT6PqPaTsDI
FyLq4XfXX4h67LYbsOIvbulOcdzU8UT38ZY6L4N2Dn51lt8rrkn34nuV9NQu
nk9/G/frP/md9yPGOvtTv01xcpAvjOKsIN8cinOi0jOP4kwiHcVX4XyZyC4S
cQkwnqdR3EB1PlG8GC5/CtlNAib7GEseMU65vFhDLn+3sz/5pFXOK+4zoX8B
b6+c/hS3BnQtpjhygDdTHBnVP3Iy2VkCnk92k+Mpzt1em3HixO2CXRnszrqt
CjlUt5Urv989geyrsU7eo3eG0B4+B6PvyIdy2j5zL7b2XQK9h+xqxXtG9ZPe
Mzrpar0g3i22Ip3zqA5bBo4xcbojZT56DSlAcRsS0+H9IydKh/Xj7ohLF7OO
MFnxTjLKw7vIKh0otwHRgXLxTjLjT4zLdL1mPMfNwHfUg3eW8b2J09Qv0RvM
FpR3n96T+vu88e4yl1P/2Pmla8/u1teK+BMa1rcpeZcsTZofLt0nFHq3Y5f2
y/JXjoN1/LXJ9H127brG+4kF2+xOirvOdneQF2SPw3y5ceq4Z//68bzOgk7w
5Z9mLYtvuhiqAZ/e8YPjgTVmtucBXYiTEdgoqYELNLRjZbdM1wf32aFBb8B+
H+daws7DFXJJX5kpW5WOiXCzcwsTiieWf8hYnp8wXcWfN0tYVuoZly/aF8r4
iy0WB/1zI5TxQ/29xr6KjWf94MGcC3N6/EjQWxXdVqlb4rxaQ3rGNKIT52ag
E/kGiXLw3jLrxZlXZK2U1A+pnoca/LC11wyBvqhfpXaaBj7Lf/THTG1hunwZ
a8XJ97ar0Ht1qAf14t3rV0IOYHyynpZpY95tcbtcLTtJr/+X7BQxTmCfh/mL
70hH975WemdJ+0n3wIDr0rk9zvGbtEpX9sdHfy4H8UlQfj+hpzEe/RBvxHeR
9kVYx4D/tDF3poVt4/h8Eus4YPj7/r5U4pN5nRyvqeq9zBM1WI5P6FvIFxqX
N67DUDleEe8FeHw/OCT29O0GJqtt/SbWFzEuoB+q75kjHcrrJPgEe1aeb9BD
UY/t+1smpnO/oAf7O81kMe432U8S9UG+NjX2+T91pEM+rKvsV0/rKtZZ1e9n
D9l1ra2c40NS3BLYgaF/ca4G+LLwg2L5Y2+cAsY4zXRy1IKk97wYpnEMfmD/
AX0/1fBmNU8tTtSLaJ49mezmdGCNjJ+E/kA69bxbnGv/4P6JEHKT8UKOSP7f
FuuFQo/ZYrufkeNK7F/kOwtiHxLP+6WqhUptP7o/juu3GHI1judVCl891HVs
4jhYWy//2U2rcP6ie10w3gnm901mWj5eT+qXwz3d7ngl9hPKsxpyPEwzGeeR
vA/ncYxxI+z1HayvyG7/p7HP5ntK7E+1hONGORZbf2OT5TXleyvK4XU+UJRj
WUn3BoWS+JnJwTrDdaVTfH5pl2S85xySoOe4nPQA72J+RzIjtbPN7PQXDn1M
lJ+xdep9iVqp5Rtbxt/Tf6a2eeLU6AoFHCzX+pi23Ki0SHt6YH5s78R2g07Q
DT0X+gv0XIx32EFus9FvpF09zzfi4z5FT0c50NPR/qoUxxz9A/t5lAs7eaSH
3kf9qkWe+adJYbetWr3zex//5Z6o59P5C8lHLbyxWFejJx4LuL0pWGvQbJxx
XpOyn+BHuQ6TnLYl1pOa+LXJLd1fZccEJ9vHq/t87Ott9/0hOuYxYOBHR7h2
LJa4zj+keQv9BevY2XlXyng0DdFDM0c+Kj1+JuvLtA/lfRL2TZBLVchvFXjs
myqR3zHKwT4R6Y6THy/KwT4ReOwzsd/DL/aB2Ndhn4e4JRj3Y9P8WOJtDda6
n3jfYvmu07qIU5HA+mOJErW65JyUqK+SPorvSAe9BDD0PuQDf5EP8/lYUdeN
Y0cmUPyUBA14/CIf6n318tqer/NDktVLccj4fCJj4NUeLXuFaCX+ZDM1KhpC
fqaJ+8G9q4x+xC++oz7QgbhuRQX9TCfoxnuVq08derFeN3McuIs+5Vt7PTGz
ng29GPHckJ7oZv0AdCNuGtqF9uMX318TH6BXgK5Dgk7+xfcFZJ+O9Qvz+5Ow
V2O5AD0a6ZAPejb0bl536BwL6xLmIfRKlAu6wQ9Vzxbnng44B+V2Yh+i6vGo
F+sU6sW6hPTQ63HuxvoUrTvNqV6st7cOlliRBMNPDuPKM4Vf/LlXCXomGlel
Og839FiMH8Q/g98i9GKsu61fRQ5YsiKE+wPrFfD4Bd/a0vrgfuHhhVshu7hc
jA+U01aUy+MWfCtM4xbzEH6d8PNEftCFfDwPqVyk4zjoNF7R/1+N80mzBXwA
X8S+Su57kQ/lAI96oUcfdj11r6HbKR434AfGY+/Fo2c2cj2vDaFffEc8L+Q7
YOiV0h8D9YPPtvs/qY8hna1+JGGUa7uvlu3CuMF8Vv3pBb1SX0N69K9aDuiK
d2t1v3QOKVdRDsq1tZ8I5e/jRTr+xXfUBzow7/CL+fFN+Ldwee2NcSHT5RR+
7pwev5AjoAvp4S+D8Y1flc9+VC/ypaFyAftUTmmu75WgXX3sdiSvT/J0uRW6
gMd9lRj3kh9IN8iwe5R0VGgyqkgSPIC+oxzgFxq/IdxP4Cu+2873UO539DP4
pO4T3hyoJO5rOjyw4Svf5xEf8f2oIe9Dkp1viHha0g8T+xxxf+LB6XAOh3Ti
XDTMdp4k7ktV+ZrWkN8OzK8QYx+aqE+nmJp6R/OfPD/hx4n56VW3SlyVcyd4
nb2csUMVp3Tntegin9NtSOTv8Qcl3Zcn/s7+UTfgTfBRXp/TGHSeYf5h3qP+
dSQXwGfgJ5BcQTrIFaQ7QflYrtrOb6si/6yG/nFfntchrhbS2ehD9+U7Z0iH
fkF+9AvyY137verUjWbjpPyYZ6zH8rxvl7HvNlnjk45NZziwXIK+j/Li67hm
yvghcT14+KrU1yEOVvB3x/QJ7z2OOFht9RW5nkOf/0N0QO6DL2gn+IJ2FjY+
xPE6jnMOdfw8+zMnosdJGd+kshg3DM/v1+Pw46V+PG9s4sMFyfNGyG2Uj+81
xHjheqH3Ao/x9H5chxtpi//g85wFol4evySfrMo6wDD2uYDTGOc1ccnmI/oJ
9KCfsK/lfbtx/iNh/O4Q/c3rGOLLYV+OdP7GPaWUY7b2dMnTYf+exfDDlP2E
dcheu3BOhXHUqtKLj6PgxzxTzgOMI5Q7heY10qMfkB7zVh0vKl9wLib0SDlP
oA+CT2FCLjFefTcS33GOVtuwv5DroMeoTVeSYPX8jcux0YfNfM5L/lKcb8r7
dSPnPHDg/RfupRAXObVxPn6Y71sBd6RzhScUL7krwdaAszE5O1zkfSn2s4Cx
n0U5qGcu/UIOqvWiXNSjlrst5vX5jZb92g1ar1AP8PiOdC/EPOf5hXWU1lXr
Z2G/alX1j0/0XSM+qnhhnyb7NVuD00b644Z9jkOy9brH61dGevQX7EZLUDlI
j3M023VanoeSnoBzEn2xsLtkujAu1PO4HIsP1Pyf4yFAyB1qhxw3+A0lf0iU
h/7C+ST6M86QA0HcT07ld73csvGnBntX4NFPfx53K9F3QBDjN34uPynJTxLy
bjyNs5Yi3jqXq5YDGOWo9aIe0qO4n3I6X3NJ4peqf52kfrON92SyfIupFX3c
OzSZPBT3PCaL6Fc5j1Ee2Wnx92nG/JN8nijsYpkOP6OeOB4XkJvAZzfoDmM7
ZHV/BLkgvst9Vl6y+0W944WdK8O27QpR7JFDNfJX4/PrnvvEuMA+/vhycT/z
u3Q6o/8QVx9x9tF/kMs2cdYTYdhLzRrzKlVSeuihM5cW/VV4n4MVcf1RLtYx
lAsY5c4Q5bAd1nRRDuu3iOOPuP7Qh1AeYJSXUowrtt+OE+NKh5wBX3DOi3Na
9d4AMK07mq9Yh3DuoqlyGXpv3gGfgyYcDuP3ADaaI+/9KiNh6PeIx+9r3POE
Mn5wlGuVVM8k/EHcA7H+O8DASxj7CJSXx6g/nvHrjPoljHSIr4vv9uguT+dX
l1plr7jop6TLHt3Qr8An1Af7i/9qF+qrd+z7w/EZJd322oV3GXC+lXdexfP7
bgUyfNJWvmt4VwH74/PGOZwD37tVsV0/+BzlvdHBMVzumKv99hzZJuE4Y98t
309EnCPQq74T4UZ0Ij3iFuH8MlZ5NwJ08rkP6eFfKD4bxXfg+6k3dA69smdA
wdlTfjKdE7dneTttbhDDTY14i/LdHPwizgX0Tp8K3V67VA3R3xW5Pd69l+RX
Pu/qiz7+K+GnIh/HY3gizjP1tx5lu2/pHMv1nllScubWCAmL81/p7wW/QYpv
w/se8GMRtQvwZGqX7b43XCvwaFfh6LtynwP+vqd2ID/aAf0S8gUw5MsIkkPb
hN5jNx3gCGPdu8vpACPdj1mFLreee5XLrWnMk+ucHjDfN1C6Gs9XBQzs/cBu
uYCx7sNfwF65gHtvbfTQedIjrgf2BsgH2NYO04PxgFW/AtAh7OX8OT1g1a4H
6XtG/Z7yorYf6xmnjfL9OD9g5K8h7uc5/Qqj3wM5PWCkt/cdMOiAv4Q9PgBG
epyToF/btt9Tcleal3b5BBh0j786vsfn4gF2+aTyUeUD4FpDer1MXSJEy5Ap
MG/1Cgf4HBr5ACPfwBv95iwbnLje0XqJd1dgd3N8iJcRNx3n1vbKAYxyUK5q
lwh+4X7YNv64tFMRdq3xnM5ePqRDPsUOUOgfCXHcT4C5XpGf7U3spQPMdraU
D/vUDRen582YJUx5bydUB35I/VkffgaEcjp8x7qMfEhnmy+Oz73AR6yzorx4
xuMX+WzXf5kO+WAvjPXFxp4sMf2F/et6l0+U15vP9h3zyC+e+YL0fhm2Fu73
3MWCcrFvRr1zH+RsMP6rxNeo+jvus9XMMPQHpBfnBRKPesDPhh0Hb3ucKL8H
Nd6ytEK2UL3v1K15raE3uR9wPgB+Psq6sKhH+duMHyj4wjDGC9KvFXxhPNoH
GHahSI/2AY9f0IV0eI8IeNCF9kGvQ/vWC34noxvlIT3woBt8A93gK+gGHnTb
2P0l9lsjqn/OvWUhL1qYLSof1HejgEd5uE/HOMom9rW8f0T6sL3Pz7Ta6mr9
p2ngm+Z9/PX+HVZNOpZYbwfvruc9v/7QBxAcEli3UckBJgvggPtFVy+eL2GU
d8UxY73O+6L1joGt11oWmvi8adOB4Unv0em1qB7A7aked2fjHSt+12pd8zPH
4nx+MJ2wF0B7sB/bI/bFPJ+2inw832CfhHJyuRdJMTI2UNtM9aNdoMef2oXy
s4rzCu6v9qJdFlv92mQBH23lg4nP1665OtzydTNZX79NyFbBXd6zo5+2EN2g
E3Sjn0E38LB3Ax502c4nE48TfAdf8R3lgB7wGe1AP34/XOxus5fPeFwPEvKR
YXt2GoCR7gnNN8wbyHnF3lDHu7ewb0Q6yMPMNF6c3p0d4J9YbuQAw55RX0D2
jPiOdNBPETemN8kF0AW5gH4FncBjnw8+DRByj+UE0m2f6P7Qa+xzLgflAq/y
cZ1Yh7QC+1vkq/1e1qPyGfYU4DNgVZ/C/TC+A0b/byP60P/Ql3h8ED3AY3+N
9QHj+e/Kg/bXKuFqOU/rknqPDPlVndLBLqa58W6O3NejnVgvUE58g1eZHm64
pL1Ob8tf5AN/cR4A+sU8cLUq792xHFq5IrNz1enRPK/w/k2EMX+lvMI9ENK9
pXqBR73AawMvlry4XMor6NPAg/66Ip2unqNjfd9b9bXRbpQzyiX/4jNNg7T+
N1v95VkihONPozwhd0wWtFtZz/n9wXpUr1qu7TpgSrZ+ol0oF3xCueAT9scY
h+q+R9Xj8YtzUsDYtwDG/nPPHsMuTX/XW9gfvhb6rT6A4gaQPTTNC2lH+kD4
S7P9IMan7fs/oSxfAEMOxYp3ENkOAONzE+lhmP/Yb18Q5zXcn/1JTsB+Lo7s
j+kcRIM9Ui7PflHFysbq3QKe+ZxM5GvfAYtrX2n7i2Hyb9Ld08cur9bL0bp1
47irdQ5Ha8C7VF+/Ln05ZwtgW33NZC1S0MHvUSKdWIeQbrsoh+vxK77Z7PU0
XN/U/UORipMd8b6cnnZsyRLuvWOZjlufXH2X1vzDcHtzq7En5/9iGL+/l7x4
+XFbuO5y+0iAW+fb/H3zvNk9y2T7Br8tvUaeSLcxNyIZPhR1bEnzSdEMv5z6
qt7+Gk7wC9OX+J+KzZLd2aLW1+XxhG5jH9zk9mQXfOVyUol2MN9qdVx+ena4
LOfy/lFNp6VxYT6i3UcFPVwu2gVYLVctB78qnzxq1zqxIbXkI/od/YLv6BfA
arvUduB39s30t3JMkXwuffVai4ERks/qOFL52vzRJZ+d7STf1XGGfgIs3iU0
87g5WaFevu6HzFb8Il307UGDQ564WFX+tBT18XeMQ4sYH5wOfONxLMYTw7ef
ZJk38aCvxNO6BzmGdQ9yDOse8Fj3eH8n6OB2gy8q/eUFfxlW5wnaofIJ7QaM
cgAvFP3IcNVnJ49MXficYatoL/frE8Efht2E3OB+BH2LlHJ3KHysRvWAL9Cb
wBesX0ivEx2AQQdgzHPAoAuwOs/Bd8B1xDi3js3azCnguwvz66qYbwwfS7PL
r3faz9yuvYcH5uyofWA4443RW7NufcX8CRfzWVPnz4syzdvMmeDD8Oeay/r4
9/HmdF/FvOT2gA7QqY4PVzF/rMvEPGM8ysN3D6oX+NyCXoa/EB2AN4v2Mdxj
8rTtz/x+MJxwesSOvh2CtLJrJ47MkwirdLcRcklT6QRdwaI+pvOuoI/50EvI
LU0dX/uI74BDlHLclHZloH4BfIfqATyuRsjf3+b+4Ho2Ke1uJfyFGUa/Albp
VNuNceUlxmGy/sH3fm03fN1vfcZ0HxTjjcuxinmvqf1/nMYlr9vKuthfKXeT
sk4eoHp43lM9gCFXAd8hOXju/a/sezI4WBrWXlls2zoH67lZEZak+P6ww7Bu
qP+i/qhvPM9hxwM94vaKTJOu5vRjfSdN59JNjvVx5H0i7FyQPl3XyztbRpl4
HwB9Uqd6bO3f/Ph8C/Ww3QnVg/SoB/uOtFQP2rd27PuTObzNFtv2mSluvHxH
rGBUnHNbJ5MV+Y422RPhtvUHt0/onbL9sBO4VqyhR7rE9mYN8poduVG2T/gV
yfbjXhzp0T7Uw36CVE9tr/OlQnk/8kNH+/6iepAe9SA96oHfayMRB4rjS1Cc
KD6HLWCkj2B/OB9xn8jwIHGfqL2hc4qu+4e1CS0XyvlxH+dL79Q/pfdrAZcj
Pwfcey8QcZzYnn0S3ecDzkHxFgHXoniH8NvOa7xDGMvpfSl+K/x3Axwq/tvs
Bdt5aNspXirg7xRPFHBfER+P4V4UjxNwfxFXk9/bGbvySpo/00LZLnvpiDrh
KWaHsV/5R8NuO5zfSRxtpI9T0rPdCfnrODG9myleLOCbFA+R44xRnBjAsRSf
G3BNirdn60/vZLlB98A4HwR9Cy/VbBt0yV+39X82sV8SxZtkerwoLjbSB5+t
VnPQZhf2n660puP3D3/M3B9BRn+YrGj/wMInn+jBv5hfR5yeTazc7LsO/MbX
zctZMkRryJ854WGvUyUdufxZb2Y/XfbZifuj7vs8h8Z3i+L8V/J/ardo12/2
74GfPs4bVD919R1X1Y9f9VvHO7/77Pj5q3EIAuh9CuRPP0y87wB8J3ovwN67
7zUQ398mHoXZYs/PXo1roL5DC7/6fXb86hFnwJYeGT9Ep3eaAavv1v9v3zXn
uAj/8a65GpcEflco77/ilKh+WIhTgvLUOCVqXBLEzUB+xMnAfIK/GGD4hwGG
Xxhg+IFhPpWj+GKAF1K8LsBPKZ4VYDeKlwS4BMV7A9yK4hEBTkPxWgG3o/ip
gCtSfCHAERTvE/Bhis8JeDHFhwR8jd5DALyL3hMAHEXx9NB+cd8RowEW648z
47GeABZ2yRG6bfoIzi/OYRyZv0J/iOT038V5K8PinuwP5xf7OslPV4oXD3wh
QR+3L4DiswP/SRSgK/KV04+j9ySAF/EXvjB/jtH7DIsoviG+U9xhhseLdYTl
3ECK9wx8P4rPDJjiZnO/baF4x4ApLj63u4eQ+yy3RX2hXF9use7yOvZFrHOM
XyzWQcafoHhrKh94Xad4aYB3UHw0lS+AdYpPxnG4KR4Z4DEU/1HtR7XfANM6
xevK7fM7JznXkuuYx6Pxi02zrbxOUVwQ5k/H2DIL7p/yY7zQO0ycP6tYtzj9
ZrGucXqrWKeYf/3Fush6g0Wsa8zPDu/8Uxdb7MTltxXrEMs1NY4M3qkHjLgz
kGuIGwM84sQA34PefwHcmd57QfpQes8H+Hr0Xg/wiLsDPOLaAK/GqUHcHcBq
XJgb9F6lGicGMO6LsU7+I9YtzTZ/POend8YZv4Pel0P9iCsFPOJGAT/X4KeM
/0PvbHN6eqebYXqXnOuD37Eaxwsw4nipfshqHC81rhZgxNFS1lGGEccKMOJW
If8bisMKv3N769j/dh1cSu9B8Pym+M2A/1C8Zo7/SO9BAG5N8ZYBp6T4yoCv
ULxkZd3h+ijOIMMvKN494Dv0HgzvC+h9F8ClKJ484BYU/11Zhxn+v65j/7Uu
Yl2xt85hXfmvdU7dBwBW9Xyse8BD72c/ZGXdU9dhdV+jrsPqPibfjNZfKnu5
WlDvKq3Y6FwB8LM2WZ3yagVmH3K1gK9p7pctliNUwsCDz8ADHlyrS8873q4W
3KPvfF50Vp/fEn4x+5x16UlXC9pVa3crx7uBEhb7bFcL4vIBxn058qNfkR8w
8Ohn4AE7rtyesZanq4XjrfTduHZppITRPowLtA8w4reAb/hFnB3Aa1MOOlVq
v+TvxdYxXuOrmayo//X60hcq3ozRUf/zoBqntk2N0YEvUKyN6e73CMbnnNkr
psxOyd8qJx06b0sVyPztOvKBV9G1AYxfc3iN95z97xj/rlgRj82X3or7yS+u
FKfsjQZY3Jv6a8j/52HDr551IjTk7xv4uXCGGRGMP1qt4NY67jGMz9VZfz+t
s+Rv4/y3Or+IcmD+Pvl95X0eN5MF+EKvy1VePMCZ8QePFr/oudjZLt8Ag28o
B3xDOeAb8OAb8OAb2gG+oR3gG/DgG/D2+AYYfEN+8A35wTfgwTfgwTfQD76B
fvANePANeP9TFdo8eip/3QbVHlbus/xt5d5qwfrf8hfyAHIPMOQM6mF/N6oH
MOYL5CTmC2AeD2S/hvyAMV8hVzFfAWP+w54DMOJQIj/sN5AfMPCQ08ADRj/A
Lgb9ABjtg1xH+wDb45stHK/b4yP4ZI+P4JM9PoJP9vhoj2+AVT6pfASf7PER
fLLHR/DJHh/RLqyTaBdg/NpLB7qw7oEuwPi1l85WHr5U5vV3bhfuJW3bFcZ+
1MgHOxHAkFvw80R5OH9HeYCRz1654APO48EHwPbaARh022sX6IV9CdLBHgTp
AIMe+BuAHsCwh1H5ABj2v7bzI0yZH366Pb5hPwI8YODBF3t8w3fYp+A7YNiN
Ih1gbie1A+201w7A9ugEDL7b6mVxyvyP43LRD/b6Cf1gr5/stQsw+GCPT/bo
UukW9yUyH2AxHkI4HWCkgx0i2gcY7UM59uqBHMa+CXJI2Cv9ZjkLGHIC+yrI
CcDAww4NeMDACzqjWE4CRv0CdmI5CBh0gm7QZY9ulS6VbpUulW7Q9f9Nt5PF
Ht32+g2wvX4DjHZi3ws6sO8FHYCxbiF+LtILe8vfTDdglIt6UI69elAu6kE5
9upB+0eI9nD7AcPOEfwDDP7Z+w4Y5dirB9/zXwzLlOKqHPf/folacWWT/I50
+K7mb+A4r0qrFvL7zVJLz7iUlPjCht4p8YcMvVPmQzrkQzrkAx75gFf3leq+
E/tKe/tO7Ovs7fuwb7O3r8M+GOMD+1B7+1R7+1LA6j5U3aeCD81O9Rma5amc
L+27tBt9OKvU81Y4pxqx61+JX9Al+6DUHeV80ipWK55tajDL+frVCu576BjM
+E/+BX9/LCbn29gHi87s+yn1NK37sNIDB0r80ekpRu7anaCBLtABukAH6AIe
dAEPulAP6EI9oAt40AU86OJ9JtEFvLrPttEL77va6o/3Jf5ss61rAsrKeXNk
z6Flbf2lXj4m5tfKbr0kfsqe7+sj9ifoqCdXQvcHegWpv8EPH3RxnCOqB+Wi
HpSLeoBHPcCjHtQL/3nAarvUdmMcCz65KOcUcl8t5pHcV59feHl932nyfEKs
M7FMF2DgN9RdeHZfuNx37wiadLlm9VhlHv9Szo9+cf5PXkfiq2b/xfl/zPjX
+Vn3Xzxu4J8B/gIGPnzDqgeHF8jzjyfed5vljQ/keXvFmKY+PG8BI3+qSWcv
7tj5nvNfj85nXbTch/Mj7gfyA0b+KRn/CWu+fSfnL+e+q9AG80HW3/EeB+CT
Rv3eDMPeGrBYd/wVPSdcWS/DGb+po8PR5i7yXKFE1X5DsjwIV+ROtCIHozl/
iztv+1z5GM35ffda8s/eG837C/ij2OphUo8c3CRb182fJP7b+Dyvm19zYDkr
9FkpZwEjf31j3ZDnFjeMdcOZxy3GsTpO1XGojlOMM3vjUB1H6jjDOLE3jjAO
7I0Ttd/Vflb7Ue1n9JO9flT7Qe0n8NleP4AOsY55Ml3CT0DSLdY1P4bFezE/
mG5fQ45LuscZclzuKy2GHA9X1pdwTZVr/3/pAAw6UC/oQL2gw3Y9CU+2311t
/Mpxts44hzSxvO85pmHVBf/IfdXfZ6Zfjjkj9117lp6/O/G6HEf3m8yq69wk
SK7naw/O/DxG9lNq64m4DS1lPw4f0n5G7qUSH6a1cBx43MEuXYCbG+t1rLJe
y33YSmO9lviFxnot5wvWLXvrGtoNPNoNPNoNPNoNPNqN+tFu1I92A492q/op
2mmrL8n9JdoJPNqJ9RF+MBg3NQz4McNLjXH1jOEBxrx6wbCY189Zz8P7Sbbn
LF8YFv7oXxnOa/z5rsiFbzzP4f+CeQ6Yx3X64QtdxoTyuHUN9qj/sIrEi3Ik
3mKUI/GLQlZNiF4q58WfDKUuVrwn52uJaY20Mc0l/lrXY3FVM4fxu4lotz2+
2M7Pb5zeXrsBo532+AC6+V6C6OZ1j+gGHnQDDzrgJ4V6IwzBuIdhP6Pe8wyX
MzKe5HbArwr4f43+vcawiIdwg9PDvwp4cX4XoPAhUJFz8twwv/EniNuF+AO2
5zoyDizqtdcOwGgH0vc26LjP+PlGuXf+s522ekuQsh9K3g7AoNteu3JlfZvS
3UviF1Ua36RTRjmur+5c/XzDBolvOevPim5dZX7oDUaxq13Vezp5DmnIUQlf
MO6ZJHzW0IddrbbnE2bGv3ne7PLR9DL9+y3LYvSH8h5AnOPIc7xGR52LLboj
4SYT6g7aMlvCI61ey75kkfCw3+ubeXR0VOqX+4C3Rv0mpX6Jd/zqnjdldwkn
5Pz44fdOBz7/EucI4awXAYY8LTboeYOHNeS9WflMN5v1niPv1YZcntC4UxqJ
75Npft0bt2V+sQ8KV/ZbYcp+K1zZb8n8iMsAPGDgLy/L+SZ4nsTfqpzm4/xH
Eh/3wfpuWjuJ/1X5qde3dGGst8HeG3IGMMbVvCtvuj575i/XwbgMH+s2kPer
9z0bBV5vI/E/12Ye1Oy9zN8levX0b1vlOfXMi11jRhWW59jZPhUIjsjxg/Fh
+TqPHrTyB9Mn9NpvTB9g5D/oMmxWjj7fOf/c+rudl7/+zvigPO8ypP72jfGZ
fPYuWz/iG5cv5l0sy1nAyO9a8XzO4lfkveSmzLlfB8+U95b99ie0Phkt8R53
N68NqCTzi3kcy3gxj+U5vZjHEi/mscyPOBvAA+ZzA2M9jFPWQ4n3MNop8ZrR
zjg+fxXywcR6MWDb/YlJ2Z+YlPMwk3IeJvEm41fi5xm/JuW8zqSc10n7A3GO
Je/JAPP4HtHz57Xijpx/0pYBQ8a4Svy7+mmD/tSW+J65zCPr9HdMJhftyT3A
kHuQQyZDrpgVufLfchEw5CLKsyf3bO+h4hW5IM9TGoz+WijDZKkH/nM/3H1S
Ban/uhj8lPi0Bj8lHvwW40vukwAjXz6jv+R+dZvRXxLvYPxK/Fzj11npDxel
P+S9UqzRnxI/0ehPiRfHjhIPGHjvwk/uj9so8W1be9YvPk7iL8RNvnfshMTX
8BjTJPqFC7cf9u5oP2DWrw09Xt67pjH0eIkfaejxEh9h6PES38Swa5D4p4Zd
g9TvhxrnCRLvZ5wnmJPRAZj3L1Qu8CiXzy2oXOBRrnp/B7se8APjDPxQx6FY
f+KV9ef/aezMg6u66jiekE2GoWyFWotgSlMoAmFKWwRq34OUtMOqLS4tliqL
1oIiRRBG6EA60uKM7dRGOozagcFkLAqOFGlAaKCAzSAokLIKIQutUJYsNC+L
5D3fO+d+fj/PYe7EvzLnfu85995zfvf8lu/3vsQ9/xP3/I/i2C04dguO3YJj
t34cEObnaePXw/w+ftqtVzZ59cobXr3yxi1+2Z23JhnfPmej9342eu9no/d+
Ko6fB8fPg+PnwfHz4L5fp41fwE+D46fB8dPg+Glw/HKY315VkLcpP/8j6V/S
pX7gX8suSv+Hh+7o88gfFb9j/tV12+5Wv42fB8fPg+PnwfHzbp5wMxLm9/HT
brzd4cXbN714++YtftnVh3R4+ZvyDjGTv8W9/E3xPSZ/Uxw/L3FJ4Ocl7gj8
vPAagZ93+WH1u7TFfgM/DY6fBsdPu/yZ4vjlML9t9131y3bfVb9s923F7b6t
OH4eHD8Pjp8Hx8+D48fC/Bx+ye2vfgK/BI5f8v2Qq+/JkvGLt1/aNG+A7r+f
XVtz75/H6/67/fy4kmHZio/sWnB3TW2WNz9Z3vwojl9z51dxeI3/N2+CV8Ce
4BWwJ/ICqQsGeYHU/YK8AJy8AJy6OfdL3Zz7Je4EJ+50+VTFiTt9f2bjKOV/
Fpo4K0v4HcvfNHv8TUz2UauzVNzqLJWfsfNU7fEv1Z4+VfF3q4u3fHXIBcG/
ePHEx0VrdgiefeXltMFjdwk+deu02T3e2ib4R9PGvH7ywy2CW/5D+QvLf7R5
+lXFrQ5T+Q27Dhkef5GhehYTVyhudZiZUl9419q5zO+guS9kRh/QOPfeEdse
faIhy8v3tf24qQdkid5hlxmvVvwGbbHDaYmS2c116hdee/C+U/Mv6r7/3A8f
nLFM8dGDv7TtQnqd+h1Tp60R/JCp09YI/h1T561Vv2TqvLXi10baupHcH236
v3Qkt6Z/e4X0bzjafu165SHBi++vGlCX9YHgg/OzevcadlD14ge6PLdk6F7B
q4ue3FG4cbfgh58tHPqnAe8LPmbOwNGrW/eXsw6sS9g802Zew+adeeK6zBPX
ZZ7AmSdw5iVs3nhO+vOc9Oc5wXlOv75l9VXK5+4w+5yvm8709rkMbx9U3YPV
62R4cWSGF2eqPifbxHmn5bloc9/57z9WdXnUWbnvjwu2Xzz+hX8JXvZpXsfh
MWcET1+8M1Y3Rfuf+3JZbr/DJwTP2z35ruEXPhR8RrezXUb97aTg3X5R2LX/
O6dk3qfburXcH236L5uxYPCKb1ZK//yTp4fPm6jjp788qfDZWccFn5RVFVm6
6JjwCfb3a6s8/uCctNuMnz3v1XurPX7hgtRNbX241qub1nj14VpP59Lsfd/Q
7PG7yg9bftfX7zd7+n3tP9fUdxQ/Zuo7McGzTX1IcVsfapb7e8w8mOqEabv1
n5j0n27iSh3fxqWKv2Li0pYIdordDjb7rNYL7jH7cOd2TBu7CLObyRt2nvhK
zRHdp35TXfFizmGxi7HjOt78+Yl/ql0OnP/E1lNHBcfO5L0I7EzsPrAzcOwM
HLtweQXlmezvNtd1aje0WYewdTpmjus62Xi6RdZhsYnHFc828bjirKvYYbCu
bn1fcdbV1RWrHp428WTC5Hv6XUHM5HutEqfsMfmi4gdNvtjq5bNtgq8w+Wyb
4DYfVnyLyYe1/2Q7X3J/tLm/1w0PGfP41pj0n254TMW/YXjMFr2+fV5ZH9qs
j9VHaZxj+ew2mT+rr1Lc6qtaPd5I9Zy0pe5j6jgaB1k+VuMgy+cqbvlcxV2d
Xrun42v39D+qH7L6H//7p3bv+yftv8DwD4rPNfyDrttQw1+0e/xFe6hd0Xb5
CbUL7MTlNxTHTsLsgrZb39F1v82c1+LVhxSPmLqJ4tiZy3erXWFn4NhZmF3R
dvlgtRublytu83rFbV6vOHbq6j/ULrFTV5/YGgmzS9o8n80b1e5s3qh58Bsm
71T8DpN3an/s3NVbKI6du3qNjNC8ijZ5FeOQVzEOeRU4eRU4eZWbf2oeRV4F
Tl4leVCQV8n+HORV4ORV4ORV4seDvErsIMirRDcQ5FXu922aZ5FXufmtziN5
FTh5lfvdgMalYXErbeLOsLiUOJL7JY7kfokjwYkjwYnz8L9hcRxt4rCwOI24
iusRV0keHMRVkucGcRU4+2jYPsu+yPyyLzK/7Ivg7Ite/SCUJ/d1pHw37HzP
MzPdex/+470PqtNBBwqODhSc74Yl/grazMevzL6g9Rra4Og8wdF5gqPjBEfH
Ce7rNtFp0kaH6b4vqi9DZym6uUBn6X73o/Uc/7tkYz/XtF5E260XZXr1In2f
XH/S6PENjZ4/avT4hsZyd7+Pe/t93PMXcc9fxCPwJG79Pu7V7+Ne/f5/vo9E
5xnUETlOHdH1B9meP8gS3orz4K2EHwh4K3B4K+HJzHqE68Q6032h23Lr16pn
QbcluslAtwXOOGE6HTdfUh0Muhk331Ic3Yyvg+pMpyS8bAgPLDxKwHtwPXgP
qZsEvIfwLAHv4fKVWsembu7ynYpTN+9MZ4Ouxd3/VMeCrgUcXQs4ugh3f1Yd
BLoI0SEEugip3wQ8MuPDIzM+PDI4PDJ4Z3VG6oSiEwnqhKIDCeqEUqcN6oTg
1PHAqeMJ3xXU8cCp4/l62rC8XHSmQV5NP/JqcPJq8dNBXu3uw7fmweJXgzzW
1X9o3koeK343yGOJy5l/4nJXb6A4cTk4cbPLZ2mcTNzs8mGKE9e6fIjaOXEt
OHGtv1+SJ3OcPBmcPBmcPLmzOiJ1Pe6fuh73T11P6mhBXQ+8szoZdSvXX/q/
n6DxEXUryX+DvNKNJ/zfh9D4h7wSnPv4qYkzfi3/t5Xj+5rmTP2gIyd654Gu
r9bXJyL3xGKlP07kRHfsXfrAhOuJyMzKbXV5HfjpROS2M1fvnJrQ9gGz3xZH
zDQ0BXxk8i/HJ3U9VPn85ZzokNHnx7TflRZd8MLCaT1v5kS/33VI/sTxadFL
6Xv6pI5vvr5zb+q8fx8sGpI6/oej/SenzvvZt998svnTnOjvS0ur2/qnRYeN
u29yn3hOtKDX9fcWJc87PqXimaKU3ilnfcXT0+sj/OX48LKZN7Y25ESvFact
LxraUF63dc3aGcnnearo6yVHChrK35q6oVdT8ryR0aWTWo4nIqUti7/7avK6
A6/+Y8N7exIR+jEO/Rjn4U+e+m2q37plIy41JsdZPWvAX1L9ljwy5VupcUYE
/frMT6xZeSIh/d5e+fbT9+9OlHOc8zjOeeuDcff3LZ39meENkaXBuCs31kwa
P6EhwnHO4zjndZvZc3fh7vrykk9mFew7kxOd+FJLvyHJ9px1W9s3pPi/9ut9
Nibfg1VrP9fjRs+0vetWXD7XPTnfr3X/e21lzaryzY8u3Nw7eR8bG/JK4w+t
Luc453Gc86bWrR/1Rg9dz+mtizJ39dT1rJoyYf475bo+a0+X7S9pSc7j79Zt
+cnJVXKc8xZ073f0bK7Of+HS1bdfy9X5X973oWcGVen83yh8vNvtVbfOf3HT
5fy8Kp3XXWtfvNI72a6smLPpXK7O37y+S2JXcnX+uC73QX/ug3G5DuP668d1
GJfr8NzMw49GLl+zOdkv+rUeg7L31JePzTy7/gfJ963ie8M6Uv+vIlr5/C/P
pNbp833370u+B/8F0T885w==
   "], {{{}, 
     {RGBColor[0.34262441560620727`, 0.14296454526832994`, 0.598580381024661],
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2Q1WUZxh+Ew76w57C7ZxE4Z/97tBJ2D3DSCQ2MSj+wJAoTL4PT1Jdq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsVGUUx49AAyhzbee2GKf95tJEhg4yiSSFIOL2IBoCRFuCD/Dkg0Dp
YhABldqW1aWydJlp6WA0QKKouAQEqgImPvgsJCaENZhoYkMMD8YIVH/H/8NN
vv939nP+37n1L3U0tU8wsw18k/jeS8yuPMyh2mwgbbYTfBn8b2y2D9w226wr
Y7YE5QdTZmPgxcGsssLsb/CaWWaZnNkhzoG7XnAd+Ah4LrhYMPsK+zS+ThIj
g/0i8EMTzZqmmY3g60P0OyKzlXzfIf+Ru58my8c+zpfIZ5x8liPfAG5oMKvC
37xIvrvnmDVWK8af2C9BZxX53sH+FngpuI5cxsEriDVWZ7YaeTPxR5H/gDxb
oRq8F3fx35dWT75B9is1HawyayFeH/25hs4EZCV0ziK/Dp4IbkdeQn4UfIN8
DyBP42sjOvOR3a2S7A53e9PS2YTsBv7LyBag04hsQU65e85bg3y47SLkj3Ce
j/yflGYwSLxfPGd8DePzMLIZM80WTlUPuuhNIVFvvEd+zuPj6hTdHQB/hP15
7Mvgm/TjOWJGFYqxifmdrzc7jm0j8Y/g/9hM9c5nWJs3+yun3jpHOrDvZiZL
Oddy9zu2JXyswPYUPq5Tawn/zeDd1PQ09uu4uwRejk2ZfHaRzxfkc5B8iuTa
khP3nBPu67d6ccl9+ixO4W99pJlUgjcH9XItPvqCYnqs5yPN8g3uHos00x7i
lbA5je77xGsln9accn+cHl0gVmdBtZ/AfxW6nUGzWIfNVXRr+IZT6tnX1D8a
ZOt3M4jXnBPXnWO11DNG/0JKHPS3NoD+C5HenHNhD3hZJE68Q3496ByNxcl3
wdvAn4L7wb3key9fkfM5vv3ItyP/LNbdAHgH+HPwEHgluoPE+DnSjHYg70b+
SSxOtpFrT0az8Bx3J4rxv2++LnS3JerVx9jE4P6g3q4HV4PLQW+5LVbubyey
9Rp8tiOJuOYzfgXdtwrq7Rrw9kQx3PeetGrtTbSbvOad4KFEb+sYuAZ8Muht
toO34ut+7l6OxdkhZEW+1licewpZZVa76gJ4OJFP9zWCzzL2Y8z8W2xfjGQ7
VBB33cdrQTl7rv6mXw/inHPt0Ui77Hvu2iLttDeDOONccc4NBvXMe+Uz/6Cg
nnmvPOZef+/gllgc8F23Jci37zyv7dWg3ec1PgGOqOf2ZM10Ovhc0C7qiLUb
puVVm+8I50Z/ot3lHLmI/yx8uIj+k3D2WeQPZHX2N+m793aDZuE72LlUTLRr
nFOe6/6g3ew5O5d2Jfp3OKf+qFdPvZej1FdDLk3IF6e1o+6p5R0WJPO7Kcg7
4d/CSdpRp4Nm7LP1N34mqEavzXv8JbllZmmW3gN/y/flxXV/076bU3ntEt/R
UzmXc/p3eYxnkNdk9a/yHvguHG/Q2/Kd+B9a+BAT
         "],
         VertexColors->None]}]}, {}, 
     {RGBColor[0.5394580780310363, 0.4852051263416497, 0.8752539051233054], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4lFXaxiedxEAI6SQkk5AyM0lIAAERWBtiRQULYBdFZcW+imVFXey7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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndglUXWxl8ggQQTwk1Bc0ParQGSIL26FFkFbDQRcS00V2QXRcWCvXcp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         "],
         VertexColors->None]}]}, {}, 
     {RGBColor[0.6906268652550595, 0.7313073908284768, 0.9123895275035815], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXd8VcXWhk8SkpCEkIQk56STQCoEEpooNgSUYr323gUrimDviOUK9t7u
tYAoqIAdULELqNjrFRXEAmK5Ster3/vwLn5+f+zslTmzZ8/MnrLKu9bUHX3q
3mPTE4lERpEu3ceVJRKn6/pnWiKRXp1ITOmRSIzI12+irxE9SvRfVYnElaKH
iU4o/SrRu4hOin5C9J2i82oTietFP9cxkdimOJG4W/SpSs9X+m2i31R6f6Xf
IvogpX+dpfI6JRL3qsidO5kuV4U6K/89yvOJ8v+u904SvYPyH6D6/ZqZSOym
eyfluVHpzyvPjoX6XVdZZ5c5JMrZQe+aqjwX6NnuHRKJ/+rZY9TwL5OJxBw9
96zK2Ts3kXhM9IeiX69LJE7qlUj0zlGFWhKJQXpuG9pYkkjkqq+2U/omlTtZ
72hR/v1Uzr66Jur39Uq/SunterRQdXtQ7/1c5Z6d7Trvo/TtVZ/7lX6eyrwx
3/XZW+nDlT5b6TcpbSfRM0X/U3SBynlA9H9UzmClzxB9hdL/oTrPVtr7aW7r
0GjvbPXBLqIfURs3dU0kxij/tcqXTCUSp6gen+h9U/T7ZF1nKn95XiJxtejT
leeoLvpGBf69We2ZV+x8E0sTiUt0fapne6W5jKGqc0/9foLKz6ZvRR8h+hfl
L1A5H9Eu1eH5pN/Ps3XKc5jyrFaejarbgaKn6LdapR8qepXSq1Sfm3Qfr/RH
C922h1XOIN231VWkOv9P4+Fy5R+s967IcnsrlH52gcfQgXq2Rt96jd55rJ59
TXXYJHqjrjUq87dC/5/SuH1K5dytcs7Ts7vr2YM6+lutiTFG2m66KlX+t3rX
qKCfKDQ9S+VvUH0mqpytVc5IpY2I+vD7rv/vWcq5P+H6Do88++d6/K7Qu9Yn
PW/eFJ2msZbQNUv/n6f083U/hzGg8X17rumz+U3XHJXTS3n66fteq2dHq27H
6dpdYzUZ+cjzkN45IM9l3Sk6IfpM0f30rV/UN9tRZX+q8X+pxv+lSr+GMasy
f1eZO/XWvOmm8atxsJvK/r3AeR5UOe15rgfXWfGuE1X3E3Q16ro2yilUX01V
P9wc32ewxuSOuobrt2O7+R2UP075RyntF713uOr0vd7xna5X9NtJuR4zZyjP
rsqzTnmG6rnj9PwO+n1CpM9R8xbnu5xHRR+t3wcr33bKM1JldmKt4nfRu6rM
W1TmIrX9VLV9TEfX8dao59pCj5vb9H+Bntktz79x3RJ5ytTOffWu/6k+R1IX
vWtbvWuFyryhl58dpLoNUp7ZrLFqz5P6Pi8offu4T1Q5BSqns64X9f89qtcz
+m0J81zfd4buN6pvh6mc7VXOIpUzO9/0bWpjSnQP1e0e5Vuo947Ve4/iG+X7
vVcpz8H61gfpqlS5p3V03nNU5lb6DgN07aR8b+laEPV5QWnTcpw+Ptfr9wv6
jhlaG0/Q/4P121y9ax+960GV20lz6mD6sF7zQc8O1DVEzy7TOnYg66ryfK6x
8x9dA1WvaeXuN8bGWOXZUf32rdaDO9V3d+jqoPd10/+Ha379pD5boTyHqJx2
lfOs3vtrnftqnu77Kr1adaru4rlwv/rnKKUdqeth5b9V5d2iK4021Pk30rdS
nY8XPVp1nq/0/UTPUPrJuV679lXdnlI9P441rYfqc7zqk84+qO/yl8os0biu
UjnPK/0hpdeIfkn0LNFd9FuxrjOU/eJ0/w/9h/bbT0r9W5XK3F/5P1MbP8z0
+tlF9X9Ta8tIpU/v5Pb/qCuzg9fKlboyRDel/H7KfarAv/2k9t+k/3+I/FMK
TR+s99+Y5WdHqQ7fxtyinEKlF+maoPRL0v3/mapDs9qyRHV4Vm3ZU/X8VPQi
0ePKnYf8p+u9/VTOoI6+99WVo3HVqGffVP55jE3R77Bfi65T+yr17Pl69rAO
pq/UO7sqzyvKM0d5qvWt3xD9P5XZkOm6Ua9W5XlP6S+w7yjPx6JzNQ6rRC8S
/TtjRvSHorOUfn6263OKnv0s3+39MtP9sTr655ruicS/2zRm1aaZuqdpf1qp
eXid0u/X/w8p/X29//ZOrvOr+v0pzYGT1cZnRV8suqPe9ZzoS0S3i27O85xk
jj2sMjrot9Uq822VU6P0sSpnifqtq+iXVMfX9Pu8Fu/LpJFnH9Vtmp59uUZj
V88+Uql5rDz7aKz2Uvnd8r0u0Kbv4zuerzpfpGeu0fharDJfV/57VObFSr9M
6Tcp/QLRl4i+TvQloq8QfYvojSUeEwele/ww3nZVPZ8p8Pj7WfW8Wek/i94h
4f0eOlvvnVfg/+cpz+t67wt67/UZHtOf6lpHHTSeb1f61FzzSqTDL12o9FuV
vm+9x+e30ZbZBX5+jsps172PrqwMf9P+McbaRG8t+g6N1dtU7gb1y/Hq//kq
+OD+alOe90zuJyh9Tme/u7vy/7vAvAXfdJ7yH9Tfzz8jej/R60Q/K/oQ0ZtE
T9G1Js97a4PG2BcaY51Ft4tO66nvq7pcrTk9RdfvGmOX672/K3+L7rfmurwm
3fdReVv3E3+l/+/Iddkn5nhfyIi94TeVkSz1N5mn+k5S+pGq552a73foWqHy
T9f7lmf6G5F2e8r/Z6g+F/cwX9uqOXui6ByNlZ5aB3roWit6ocq+WWWv1P/j
WKMzvSak69kLe5g/vln9c5ne+3y279SBMf+Dvte4Hh6nH6mcD3V9ped/UvoE
pdcrPU3lnN/DfOpr5S5/O/V5i9JX9jAvfWBnt5n973n182H93V9800HB7+2l
+n+m/G+ozHo9+7nofD27g/IO1vW98r+lPvxW9wG61+nZ3np2f72rrZNpxszF
Ss9XP56a5jztkc44GhBjaYLau43oP3i/yt62v8slbeuoz2kFLnet8pyfHmWq
324qcJl8ozdVjxV6rr/uS3Jdx610/0rXatF753h/z+7kPf4ItTFD46dc/TFJ
dC/Rj4neU2vdOvYa0fsp/QfR69QPuyt9jeiE0vdV+irRa5R+e5H3qVa1cSv1
VZvKuUjlX6E8fUXPU/7+Su8sujNrtejcnt5nr1R7WtSWu/TsccrfSemtyj9A
fTCwv9tzS7rzTNar++rZjj29n87S+tGkOd9Je2+j3t839t+NGg979bIcNUl7
5bHKm4KH1+/HiO4Cn6zx115ovmu1xuMPuh5TnafrtwylvaFyNij/0fBfPKvf
jkduyPDcYd4cof/nZvj+S7rLHh/lI9/8mWsZ5wW166Rs762sCawHhyu9Te08
NNfljog5Au/UrvTDyBe80rjglxZmupyd0y0vIOMha8zQPHiw1H27QuPha13D
1faUeML31Q+fqm1VKrtS18J875vjCrw/3aXn+uT4W3yltC917ag8y3Vfpmuo
6BKV867K+Vjl1KgepcgrasspReb114q+Od/1Qd48RHUvyXE+2ocsQD7atEHp
KdGnFvm+Xs/uoXLH6f+yju7v06PP/8xxH9SJPlXXPqLHKv9P4pfu6RVyiup4
boHlnEeV5xC+Z7rXPdY8/j9G9zdy/Dzy2lkFlvn3UnpFrr93mfompevRfO8p
cwu8xwzW79/o2QVq2xjWUtGHKn9v9cmPqsPvJR6bjOOb9d5OGq//Dh6VdYz5
yfq1vb7pbrn+ll0zXMZvassmjdX7VM7h2oOeUPphSv9J5fTX2tVP1zkav0d3
Md/MGPhL5Z4IryG6j8o8PNf/v67xcKLqMFTPPq52PKbrJ/3+ZKHlxl9Ezyq0
fLtK9Fzdn0EuFb1G/TlddXiro/cy9jHqsU7pD/HdO5rnndbLfO+cQsv8q/Xs
xgy/tzDN+w57TrnybFL+2cr/isq6PN9rPev8kAJ/m/6Rj/zIanwnvhfj681W
fS9dx6pvt67z/9AddO2pPH+i28jx9+PbrRK9R67nN3wYegp0FKV69l49O6zE
ayPvZIzMUv5c0aMzzeehi0EPw7fhGzHvkbGQ0daJ3kH8z9Eq61vRqTr/D91H
9Msq/zCVX6h2HaH8BfSf/h+ja6DopTmeD8yF3sr/QqvloVP0vmc0bo5K+D43
y2v4NuXmBy/Rdx8iXuSV4D/hma7Vdb2ePVz92ZDnsfDPSn8nvtHseD/9iR7l
T82p5/X8LI3VqyXjfKa5fhj8a17MrRzfmV+sZ5THuIKvRUeAfmC66vuAruF6
b0Wd/4emrZuUr6Kj38cdmf26TH9XZKuE3vusxsAC5U8XvYDxI/p53dP0/wsl
/n1+5Mks8Xg+FzlX4+sWXS939h7O+EGOuDLf/Ae8x/eFpg9R+tWFljfmKn+5
+JGy0D1tVJ1nqfyXWHdS1mmR/hG8WL7l04uVp7vyTNL7LxJdhy5C9NACzwf2
90qlP6i2jyjxvk8a85V9lj2WfWBSqb95u/qhqs7PkP9SdHVJ09kZXks+UZ2H
FXgv4fkPlDZE95epm65hohfrXq0yZuq9o/TsoTlej3j+SNE751pu/pB5L/o1
3f9S3hm6/hI9QmPjuDrTbxd7f7w6zd9gqxLr3d7T9W6B+6Kn6tjAnof8pbFX
z3tE36rfsjRmlqrvqrQW9VH6fUo/Hb1JqedXWqbzn6H0u5S/NduyRnqmyyS9
NNPpE0V/qGe6aXxmZ3t/PjP26PVKX1diHeyDrD911mMgu8GfwW/XZ7oOtAV+
jXR46RtU/+t1ZWV7Th6q69OOHg+fh0x9aa75uK/17AT1zwh967uUb7eUeWr0
DLxzRbz3L/VD9+iHnFLLW8dlWn+WA0+QaZ0Sc4b5MkrvH6lrgso8P9fjLYnO
ROXtrnfdp/Rh9e7LapU9p877GXtZItPvmqD8tdnmF+Enp+v3XfTsnXq2q95V
o6sUvZvS25U+Relj1eeZ2ZZrypBLczwX30G/k229MWsQ+/KVSk/qXhz0lJAt
+P86lXl9nfVsI/R9mpS2KNM6ieYc61SvFd91peS3RVqPbhZ9lej3RL8d79op
YZ4EfQ+6qV1UTrXoW/TsF9rvduxluZH3fBrv+gB9aJ7rjb6nL+tmluubjHq+
rzxn5vn/y7R+HK817Qq9Z5Hem59t2erzQvdDpzTrteBtloRuE/36PPiNAu/P
N6DTQK+dZ33YRJV5nMq8uNT8IbLCYxoPxxW5T+lP6pcKenxn73n8/7XatXMv
6/jOz3d9kFUXhK4NvdbRGhdHJT3eXlUdXtGVlu/vzPc+MvYC6FGq5/W6X5dt
O8VA+N9s86VbB/2A6tamsdBb11XZlltnFVi+3UFtSVNbUqVeS/6b4/WEct6K
Z2/jG+Wal2avW5jj/Q65++kCy+H3dXI9qMNWHSzPIMsgj5xaYDlnke4LdXXM
t1xCnvNUfhbfQte5Sl+g6yalT1M5o1Keg7fq/0+LzTvB/99TYNkYfQfr2YSO
XtNeK/R9ucpcVOh2fJduPcZbBdZZvFzotfPLdK+jK3P8/7f6/RtdI5VnWZb7
8zO9a6ToG9HZKn/HIteNb72z0m/Ito6dvLQdu8b8fKffp/o/l+9npya85mOr
QAZHD/ZkgfVc6Gfpy91ivO3Od9H/9fouX2ucrGT9E71M9Leia0UvFb2ixGsh
ewDrIXaJv3ItV6CPfS/pftmhs3mhMzpa3v4DPibTsmBdjKV85e2UtD5qpN4/
osDrzvWq73XopEssJ2/StUemdafwQ/BC6GbhpeCjVuu5H3QdqHavyvV4on7I
lciU74v+Z8hXdyr/MpX7la4vis2zwk9NSjOPhoxEPurOug8v10nfLk/XHfne
56gXc7W/+mSN+qRjqfkyZAPKQl4eX2DZ+Ntcf2/2T+QG7sgOf2VaX4P+7ftc
jyf2SfZM5iRz4DSV+0mJ9yL6l9+R3ZCNy2K9Yu0qLzJvPF1r3YYajUP9f6/W
u3vKvIbwbaEPznf6fboOET2nUetulfnRg1qdfkS9r3vj2eHlpsmPXuTmMutY
StRfPXX1x07aT3NN191ap15R/sVhE/tVdOcGtUn0U/rO+yAjpZtHhFeci15O
9/N07YANTffnkl7DsZ9l6dqqo3Xo/9Zv00t8/Uv0bpoH98Jji74twzoeytlf
9JG6H6Vrreo2NuX/oc/IMT0ww+24KdpCeXdHmR+nTD+e4zu/oT/Htvl7hvep
x1XHvUT/I92//zvyoKOmT4boXR+IzlP79lKeJ9XPParMx7P/sA9RznZKa1L/
vJHuutMXr+bYBpOr6zeVUau0rrreVJ5q3WuCJo3fzlH+mernOtH6BIn6MtNv
KU9VPLuj6tpQ5t9Irwt6SIbv/Haeyumpe6OuJcrzR7ppvm833bvHs026N0ce
fueZXVROa9Ck76x2taldS0WPUaWO03WHxkZeucv6PepWHW1hLFwT4+EN9VXv
KvP3DRXi21XO57xLdKXor6iD6CrRK0QnRXcRfYfoieUed9hhq5WeVPo7Sp+r
fWaJ5mqTvtuDWbZ5w7eMKvP4WRF90i3aSNo/Ir2ryilTOe+JrhVdLvp90TWi
U6LfTfc3ODr6mfsx6IyZFyn/D71E8/KBnlqTNTf/11fzX9fZeZa9uMNHDBVz
dFGt5p3KOVd1HKG6zlb565V3Y9+/eQvu8EIp1WFmT+fJVh/n9DOPwvpwQZ7X
iLVq+wa1/XK1/fTO5qV4dpnqM13PLlZ9lmrduLvW9kP4B8qAZ8hXeQX9XNZo
tWOMrv8lvLewP7G/fFnsen6p/vxMZd6vMp9VmTurLdfW2o7xkfphhK5Rytcn
9FppnW0PPKqbbYIbYs9bpvtXKmeaylmocr4v9ZzPKfLcpCzm6QNaW3fJsu34
I+X/t/I/ozxPtVuPjA55uOh/19pOgv2XNPY49lLqwl5/gta9h3u6rFfVRyez
Bqb5fkrQyHGsE+iQ4W3nKt9qtWtHjdMeDR7zg0X3FF2MzVp1vkvlFSrPhTnu
O+bIvrrvp2uq0tan/P+dSr9SY/7Qrrat/aD95JCutummid5d/OcZJbYtdmuw
fbFO43wrPXu5yqlR/d9SG7srzw6qQ0uDxzDvofxvRG+v9OYGz7UJKdeH73iL
6ONFD1KdG0WPFz0F/b/oE0UfmubfT4g8a0pt5+jYwXXgt/QM5z0p8k/Jcd8d
BR4kx791zPBa0RTrwxvsEbpe0nWG0s7UNR87RY7rMFH5u5cbf1MoembKNDgc
fp8Q9aQfz4g+RAZH/kaX3jPldMp8VN/2FPXPN+huy12HP2L9rIr1Z6Xa9WOZ
x9pGfdufGesqb13QyFBPaUw9oStXe+kCzYnnuNCx610/lRmfQH7otbqnK/03
9CF6dnqpaeQF+nBNmfuRcbKuzGOFtYf18Vy1aYPS15f594/03Ur1/Yr03X/L
97Pbp/k58gxJc9raSMfuig0V++mpqkNHlblRbcxTnRKiV2b5nqZreZr5L2h+
L8VmW2qZ6lW17xVdL+TZnvu/Mpf9V76f59kl+v1NXS8rT47ScnWdzTfXe7NF
n6D7yUH/GrZdypmY7jlP3c5U/qKkn9+EHTjpckhjf8iJMsc1qU1V1outLXV7
6cvTU+439pTn9X2e7W9d11FKO7Lc+3+T7s263qZv439o8CHQkzI8Lhgf5yt9
a60jlaJfzrH9qLDc/EVK+buIPh0ds+h80SVJP5cfz7bq/8Zy6yqQ9TuXW95n
f6cc+Jwfil3OtTmej/M0n3ZBXojxwDftnXSdqWNP3Xvoeoo1R//Xi75bz+5a
Zrokw/ODOXOr0t/TmGtSGYMTf9ePMT8s8jCnBiq9m+jrlH/HMtOdMryuMLeZ
163lfjfv7RH0yfmW5fkfObah3O19Myf0M6KPyfDaQDmsUWtTTifPJzE+GQNF
aa6ntrZEndaxu/R9V8AL695b4/6DdPMU8Basoyndy8rML1WU+X/oDemm+yTc
J7uVuX9o1w5l5h9o+9Ay8w9XZ5jGRn9aufPR9sFlpsm/i+rQ3uD1kzJ2inTu
Q4LeuczlUuYtOf7twgyXQVn07YQc15k6ci+POrP+7aW2H6Q6vK31/9iuxpKw
x5CO/nBT8En0D3o5dHLIa/eor5LaF3bWml+keTGmq3U5B6rO2zZ4bTxA9KAG
jzf6qrLM/C/9xP/wwJVBUx++957KeyC4Oz3bR8/erfT9RW/T4PWfNZY86MnH
l7vtjCXu9AVjbzh7XZl5vwFlHk+UPTBoeKfDMvwb7/peY6NPmfmoNt3by8yz
gTX7NbBqf6q9p4VO6iflHxT7C/dty7znrGkWn6J+mNxF81dp28S7Ls1xubuD
Q8zxb4fFOB8YeyhlUNYHUeet49lJOa4bvD73vlHPH1SHfmXmCdek3F72rBG6
j4zxQBp9wZ6GfAKvOVHtPbPcY5Q5yziFhs/kPipo1jzWPr4/43RElMnYYiyO
Trj+A6Ke1KV/1OeuHOdnjF+W49+Qu75JuR/oW/hf8J6jQsfPHT3/j+LHDhZP
+bTyL9K+eaH2zQ1aq9rFX72m/38Vz/YjegDlO0Fz/SLd79T/8zWnZyjPOuX5
otA6e3T42MZ6afD27uv//wu+LHiwn/TcF3r+xKRlf/S3yOn8jo0K/Rd6hZI8
y72PqPw/VP4qdDYaD6t7GuORVNkpXWV5lsG5I4f/ovK/UvmnJI3pK82zTgCb
Z3Ge5XBspnV5tm9iW8Bmga1qusb8phbbsx8U/UeLMRaPiM7oYbs3ds6FgUd6
VOmZPYzFnK9+fkZXq/r1g6Tv1yWsT6jJs06hjv7o6/8f0XhtyrP9rIfSevZ1
nfro3q+v6/SM2vtTT9sdKpVWpatS6Y/p+xxTaR0LugvS0F8gg1I3ZDdwdolW
64ovU3/cr35ZrO81XGWM0NU3z7qH1jzrbbZX2g59/f9Mlf+93rt/B9tJyYut
9BPJC6tV1vlq373K87XyDAWTA5/V03Lybipj977GVq6sNYYYncnlGkMdAtdx
hSr4aX9jLDdq8f69j8fBXnpub10DA5dJGWA7sb2QRj+Qr0uMGTCW4C3PCns0
eD9sZcg0/+lpueZGsE89rW++U/Rnoq8UvR4dTm/bQAbpndv29fPITOt6W266
UmlX6dojz/oZ7puxgEqb1NfYR+SM5T0ta6zp5rnEPBqm33fu6/ohD73f0zLR
2Uo7V9fIwE1SBjY99FWkgbWcqXGV6GEcBjZMbKjYMWco/c8WY8peFb11D+OT
XxY9oIcxKW9qLVysPNNUhzdELxR9X4bxLuhBK1SHlUovV/7R6DHRe4u+o5P3
5PfiXceVm4aXmK88yR7G/z4juksPY3vR02RHmU8pvbCHsbxPiu7cw/jjidgE
UtYNXZry/2+Inqs8JT2MCb4vy2VRDjT1xF4PphA9dFkH3zOCRkfNb8ls60zQ
bWOzGJVnTCr9+lrosMGTZ+reQVe58pyr996oPhlRb51Ah8gDXh7dC/sOemP6
69ds2/qoG+smv+fFu5YGja7m9QK/416VN7zA+chzqMbQy6XG6O5XYswx47pf
nrHCjN8P9C2+bjH++X3Ry1qMXcfWdH6RbRyPq86dehjXfl6R+3KA6txFc/xU
za807MHIKEp8j/Gucr5pMdb6XdFLW4zV4fsyluArivXsaXo2O9e6ZPTp4OLe
Vv5PW4wFws7Svcg23HeU/p8W44Imqz5viX4u15gFnkUPz3h5P8bPkg6m0YO9
XuLxhf78iXLryEhHr076q3r/8eXWo6FDe0Plj1B7p3XymvZhrLdrVYc1ukqK
beNdEvbNrnnGcKOfvqDU5TenuV73R7umdnJ5zIVF2ER6+LehWf6NdPAa6BfQ
LXAHZ8o8Wl/s/6HBibwVNlYwF2+G7f4b9Xt7q2WojnwLXR+pXjeqPjfoatd7
PtJ4+FBXb9F3wvfofr3e9WzK+0evLGMHeA78R2vYT8jXV/vgYVpD1mjN3EXv
OrKn8QLjlH6m6L4Ftr1gg8EWk6P0QUp/E4y83r9Nlu1NU9Od53a9d4LynKM8
W+nZQ2pgxjVvC4wneTbP7cOe+1bYZwbrvXv3NAZ6quS/B3Q9Ac6si/uQvsRe
c3uebTZH6fdj+vn/k3Q/RdddYdPCtgXOrVnv3U9l/qh6NoreR/QPnY0ZWJxn
3ECr0g9S+n+V3ib6kOBJikQPEf1RZ+MtBkbbl+s9K/r5+R7Kc4Dy/Kw8VaJH
iv5S9KP6fbaup5Vnca7vv4Y9jL7CDvW8rgNFP6auWZNmG8xSdBEaXweIfhb9
ba33Y/biIVr7T6+1nHeJ7m/oXU8y79Q/B2X9Xd5BoTfbpOtg0Y+r/APFf72u
/I9kWCd2YOT5SvPi8Z7WpYxM2TbFMxkp2yPRLaA7XNzT+kPwVugdSN8/y/X8
HLkC/k55TlOel3R/safx88P17HE9rfdeSJ/pekl98RLyva4F7E9qzzHK84f6
baTyHy/6NqXN1e/z+3msgLvgOebl5erDIVn2VQFbRRnMm1HKu5uu6/X/Pypc
D+owl71a5f6kMh/M9e9gCujz/aP+Z+r3eXzHYtu7+BbYvPgG5Jmd8LisyzU+
H2wVYw181d565766btT/R2qOdtJVDrau3PInsmd33d/ROxqV/pn28af0LXfS
XH2rm/XI6JCn6p6nfGX4iChvfpQDjqNLq7Eck8Bw5hmr9L34mpV9zM9iA/oz
7EGv0xaVVQ2+WL9/18e/sX4lgl9dqfd+3Nu22VX6fXUf/4Y96K+wGYH/Wphr
DNrduV6PXwIHpfLrVZ8clf+B6OZW+zA9K7qv6BLRC0QPEJ2iH0Rv1Wqb9HLR
vVttF1+mOrymOuyTDDttrnGI2DAX5dq2dofqNbGP5TR07Q9HX+1ULb5C5Ryn
9I+V/rjSt2H9E/2Y6K1EX8a8zTPe532lP6r0fknjs0pajdGCZ/82+q2r0tKq
rPOk3Y/wG/Ywfdvb+vl/bG6z8lzHe5R2r67H8lxf7mCy7mQd6ud8c/M9Vu9J
2H7IekZbr+jg9exRja+HlH6D0g9X+h56bq9+/n8v9dWeuh7XmHxFa8sdzIsi
Pzssxu1ZQVPOjNwYgznGy8zI8ze8UOVdrOt+/f+o0u/NMz4L2WVV2DQZL6Wt
HjML9c6U6BrwFegEgkYfTB/RP/DI2EHhk5Glvo8x82mbeWL44e/V5x+q3CPV
51PUhoGq/yv6JmerLuf2cz2m6H5NP9f1BjEON/X12j0r1/X9QvW8XW2fomd3
Bxsl+irRI0XfKnqy6F0Lbe8ES3ZKYEieCVzZ3FbLOfD24EzBm4KbKtS42add
71Z/vqoyLqj1Pgz2ER0qGHv0vlkdrPvNV/692u2XUCB6b9FXg+9QHY7SNVr5
8pS+h9JvKDKOYtfAUnTR70fW2L8AHQxl7oq6U/kPbbc9AtsFz2CLHxn1BBO7
a6SD1y1T/kPabQcBo4DPAP4Uv0pW69FkHO/vnY137aT8g/TOZqVPYM8R3SR6
qPqmQ71tGMgU6fW2qSA7gJHlWXzBWlTmNk2WEeYwZ9CfdjBOFLwo/lC/VXp9
Z22fAha+g3X4e6T7Dg4E35WqwN/in1NW+HcZ0Okd/c6qqHOi3vYq9poS0Qe0
2/6CDxy+cOBb8DXDLr9EbXm+TOtSmfmyVco3s8j20S86+x2UDz4Gf9HOabbl
8yx+amOw+Snv4diU9dxlRcZ/4X/7bWAnzgC3WGO+pSd6Ct3/qX7bKd1lgjvC
t3Z14AQOVd6x6rfxKmdWlAeGineujjozjmkL+B8wK/hH4K+BPy1yAjLCsHT7
vqLLnFFk2Rc7bC+Vf6D6fSQ4LPXPbu3WzXxfaf6JPQqdPjh05KAW5d+f7wTO
FF5I9C7I8vAt4MDgK9B1qvyCNGPidwzfXuQM6oMMwn3HoG8tMv4VPhz79aao
23dKfyh+AwuCbwl+JZmq5wjVsynT9rn2GOf4KbE+MiavFt+ND/DKfOPyHgyM
Ind8vLYB41Hu/6HhefF121f0gvCl20v0Xem+oxuhfd83u41nIAeJvjbX/fFt
s/sE/yhwLR1FH6T01Uof1dH9tKLZfUV/r2p2n1+tOnylufAPvWOo6CG6vk56
bDOuh4a/IDRzBF+iJ9rsTwQeBx/C2xL27wJbk93R76ceh2cae87/2EAfLjX2
blWJ/a/AEuUo/6sqc06b/Q+WpMynj473zo46lKiPp4veNtPzjPoxF/BNfCDf
fpHYaLDP8GyfcufnN3CM+OmWKH3nRsuifPedlGewrs/wwyu0nLF76G47dLD+
to/qtkq813D9dl6J19yvM63n611jvhqMAlgFxja/94w8t6bs10JZv1RaDqFt
/Wr8bfguF5Z4/OyaZT+NPmHz/aDBfn34L/F7n8iD/0bP8MHh6hHrf53G5HHt
xnV+K1kqQ7JtVbN91b9IGlMENgU/ReY7aUvju1+YZ9weNu1z8ozPw36+t/L+
2mp/N+74v0HjW0x/gTX6PGnsEfTRat/W7caC4TvLunZaptcKaNaoCzVu16pe
U1TP5Uljnqgbv78R+XmW9ZV1+zzl/1n5b871msr6y7rKfWHkx0+CsYSdGuwO
a1qu+uTMVvuS4UeG3zRYd+YINrNnkVMTTpsT6eDg+R+c2KAM5wGH/0Ng7sHb
g7uHZh5t+R++HV/zRyP9BT03O8P+FIPhffHF1v+vi8cbVelxuyjSyIP/BPIx
PhQvFVkGwgcZ3cgLhfZ7xpeAMmeHreo50b+LPlf35zOMy8J35ZkM47ef0B5y
btL6wAWRjlxGnqeCfjHD9Eblr1TdHmj0nAEDPjfKAdO8xT8GXwR8Elh/kD/n
hO/AQj37sJ69QOP832rf443Gsf1L9GN1xqVtn+/neRZ/Bmh4vLeL3BZ8YRo1
3k7U+PmyyOPjqi7WVdL2x6J/rtL91UJjCLsEDVYNrNhLhe4H8HEvFv7df9Dw
deR9LZ5dXGgMItg8+MXFQb8eeSj77OhbMJDwgq9H+mbsYuAXyft64Bpv0m8L
C41pXBjlQ39Z4v8fU92e0/+PR1vOjTqDdeT+ctDz0y3X4leCrwM+FehMDo07
6fjhzInx81z0D2MDn5mHIw/0TNGzlD4vaPx95ut7DdO3WZ/td74SmEtkBmj6
8pWoDzS61heiD3+O+jM+58e7KB8c/WExjteEXwo+KVz4p4DPxHcFHxYwmewL
+CaxTxETZHn4KOHvxHxmLi8Imj2C+4qgwSRhm8Eew3hlb3gg9J1poVckRga4
VTCrm7prv2+3fp7/wbLCQ7EvLYs64NdJ+qps37OCRt+J3hNdKHpW9K3oXS8t
NY56dexR7IVvZrsNlMl+h/8VfljI3fm6H9tkfSx5v438rFU/BQ+2S7npg2Mv
5Vn206W6f6HrK717u3zT2+b74jdkMeJZfFXw9zu/imeJw7Ii/MgGRn7KwYce
X3p4lZFRf/Zx4lCQTt4BBcZzro89trjQ+yx3+py9GPsjGFnsraNCR49Onjn3
QszBder/Qe22fQzT3je/q2NldNN8H91un3ve959oy1N67ulC77k753v8sFcS
E4PxA9+Cfoq1iLVkrcrfpt22PPLOjfw75bssyvlv+FBtGYNPRjnoqStjLO2F
fFFpf9VT9OwfBbbj0wedoh+IUwMNxnWo8s/r6pghDxcZx7RTwjiVgqDviOfx
lXgiaUwkv72qsbBPV/cnuH/kgWeUPqandUboi0j7I9LHaS+bpfTsEteJ35Ad
iAHDXEAnv7/q06vS+mHk3UW1lnOJe0Mb94k5Be91tJ6bqLxpLdaBgPVaEOng
F2g/7wHbcGS9/3+txrwafNo0fbPBevbHDraf/FFrfS9YB56jbtPUvj4t5ueX
Vfp/aDD1YOsXdrDe8MRM61fB0d8Y9gX89siDzEUbSedd9D3fYH2UcUGUg+By
V3frDsGw48dIe+k/6k4fTlGfZGk/2ob+Fr95W3fvP/xOzAnyHKD6NrYY5zlX
da4RvWuO/V3we8EXBlwHcYnAe4DT53/kpmeUv0r5Ryn//apHuehflWdirTHH
4I3/pT4oanE/gw0ZG+WwXp0bbaF/oFmjchvd/+RhTSIf6xLYwueCx35Je/2L
ZdZb0083RV+B/cfPCtmcOzGBvuhg/oo4KfBj+F1dGenwX/BhyHTg3/H3gwfm
TtygzzrYf+vyoLFP4sOGTRg5h1hHrC0/Z3ltuif2Hd71aZrXLtKR39Fj4cOG
DXxTjeMUIFNQBv6+yJvDIp5JXpFjtRCfBX0yOlp0yuiLblQfbkgah8Y3Yr5N
DIzZ2kj/A9miu2ML4dvK2OC7EDOHfODWSLsl0jcl7RdEOno6/KbAVIzo6lgM
xGEgTgz2UvbBB2od94GYD+zFEyL9rlr7NuPXjB8RfvnMNcbdg20ee2BUwZuC
NUXO2L/Z69UvGqvP19nvCb6bWDbEaZipZz9qMyYZHeTBzdZD9lTdTqyz39pL
+Hojn6ktjyWt71gherqefa/N/CXYMHBh6DgeUPq7bbbzoqvCrx5bA76s+LTy
3ZCZiH2DDY9vjWzLt/qX2jhfz36ld96nct5q8zp4r+g32yzn76s8i9rsP91H
9eylOifVJ8dj724zNha89zuxZk4qN3Z0JfNLeffUVZoVeD9d3yt9uMoZ0ex3
3R0yHnEwHu1unR1lgTt/O8p8RuU9jW5Y/89XP2/T7P1rpsrL1vVdiecHc4E4
FTuCQdP1bNJY0pWtxvkP1XtfrbNP1BqVc2Sz+Q3mB/OC2Ckb2tw22nV6un3q
xiSsX8bfA9vHifr9ReVbVuyx+UqbxydzlzmMrZa4WfiHgaHl+2CP5xuxzi1s
81q3VvVqUB2W8X1Vn9Fd3T8F+m77NdsvqEVp9aI7d3F8CnTu6NvxY8CfAbkw
XWvXn7XWBxJPAvwB2IMnk963vu3gODeDm82rLNS7tm+2Dx32ZHymsOGuVvoB
zZZVaftfoS/KaHebaS++cfjIkY6vYVrQxL3AxxBfw7HlfhYMD/zOdrG2NNAW
Xbld7HuGDxo6mSFK21HvbVT6X3y3Nss1xBV4PuYgMTzQoaM/J4bEz7XWZzLv
N68J2V5rD231njAw1jTWIngieCP4JebFdrGOEWsG/g9eDn0F8ZXgo4aqP2c0
O84DMt+TzZb7eA4dP22BB3+42XvZtHQ/+7jqnK02HVZnf88Tu3oOMP7R1xFT
4boO5hv5Hzn3JrXjabXxxWL7UTEX2KfQGaBT4FvsgizW7NgUJ2B/bPY+si7K
pcw98+xHh73xVOV5ptmyNmWgk2DP2oxr7WxZDzzd9GZj6ojtQIwq/L+4bxc0
fAXPoh8DU8vzPIvehnzoxNAHkQ5WFhvIyvjWY4lp02xfz4tUnyWsdR09xqc1
e5wzb8H7gulFr4Y+bVG2MezgqMBQTSi3rym4MuIE4YN6GeMt3en4n65t8zrF
GjVJ73q/2T415CEmxaUJY4XR+RF/CT7x6mbzinuJ/qjZ8YvgYefG3scdneB+
mbaZzA2a8cK4Qa8Fn4/u7OBMxyhChw3eEh6e35AdsN/NjzzXdDXGndgEN6ue
mS3eu/EJboy2gJGf3GycfKvqdl2z18YDlP/iZsfDwdeWfsDf9gil/7PZsXe2
VVnJTO+h4OuvaDbGfn/R45rdfvgg8uA/iG2B/se+0EHj9uA6+9Szz6JzRfeL
DhaavRX85r+bjeFsU91ua/b3GqM63N1s3qNd6Xc2e07Bz97YbJ4WfS1lobtD
1l6QYZl6M9476gA/g14MndgTetfRLZaDnhR9bItlPXyMjmixnxGx5fB7R9eB
Lwc+7/iE9uhqfhde96Byx7PD7owu5ZrI/5TyjG6xTDpT9d+9xXzRo0r/R4u/
F/Nyv1rPTeRc5MNzGLdZlk+g8eMZ02JfHtKGRHq50vdosY0WmemCFstN2KuJ
ewZmHjkP2Y82IuvwPH4u32RZFrwvZLqBsY5hP2H9Yu3iOfKc2cH6GHQ06GS4
7xDplLN90IeoHw4GE49vRFH40+r6Ms/4A2JAIA+d12KZ6Ho9c1Wm16ilIVMy
L7D3HppvXCG8wwm15h9m6tmdWzxHZonep8X87SzwAC3el5GbR8V6y31krCes
LdCsvci7yL18F+TpH0OmxveY+qADeUxlHtriNR/fvsNa7N+HbhUdK/rbrC5e
x5DR0E/w/Rg//L42eGZ4TtZbdMvIJXcETWyf0pgjyKTIsehAHlWZB7aYT/g+
5NvzOpi/wJ8QHoN9GV9C/qf+7M/suYwZxg+6BTD+u7QY59+Mf3eReUjWc+w2
8PbI6MWhG8E/Ef0C/o3EVqQ/+C700/CoA/WBnhY2IMphX6COu0QefM+vjD7E
/nNQyAtzulp2Qm46I2U8P3j9iZqviSbraecjb4reS3lKtFZ81GosFnZysCTY
yrfX+vFBq2NvoBcFB4FOKUftPSWwW+jBwNqgC8OujU0bm/6CsPFDg9+8vLcx
nNNET9X1RqntgvA4rHvZBcY98Py6lPH3YO83puz/gO/DmA6OMbHZdqMyrlCZ
b5U6Bg1YidwM+7rsFW1AJ/jfaAsyD77Ks4KHWRp6G3TZ2AHwhcG3Fzsne9/y
LMefBRuGPvnrwIRw8duW8pZHHvyalwWN/g4bPhgDbPergi5Uv40N3FpOgfGv
/LZTnX8jfWRgp5HNByNzqP9PKrFtCfsbcW6xP9IP2ICGKc9QXacoz+pcYz2x
0YOt47vyjcDKlfZy+deo38ap324qNV4FrAo4/RnxHDik5bm28fPb6Xp2fJ3t
xWAJDo9+vkrlnKxyrik1z8JYZwyfpbwVetcFJV5zSGf8EysLjCj6y3HKk+xl
Gw7jqEvUc4bKvFJlvqMyz1b6OXXGUfD+hVGHDgX2PwRjkBl4L+z4j0YasW7o
j6Wt7pNZ8TvxgdA5vqP6XKD67Bc0PMi+HRzLDz7tw86miYlxZp1jnYCNmaB7
mep5fonrtSnqdkad85GH9Z51gTV/cNJ+L/h0EAelWy/HQjkr1nH2AnRoxJNF
B3t2B9Pg937J8v/Q6OT+2916OfT4c8JGs1D7YVf99q8ix7+4t8S6feJPEYcK
zAI+jvhkgsXCtxsfb3hOsODQ+HqD1yLP1Gj7+MjDO+tCHwhml/hWlL2lrsj+
PE9++op3kge+a2j0A/smdrBfutsWVqt16afuXsv7FPgZ8hPzgNgH8OfYHFZ3
t93hPu1FFfo/rYt9Ha+MPjlFaYfWOv4Keyb9yZ6IreiMDo5F8JzWtmvACBZY
bhgYfCxzHp0Ie+49KqNBZS1ROSu1Rr7Y5BhywyWP/Ka6Fhcbx8U343uBhYFG
10GsK/CjzHewl8TMgh8AZwxN7Cz8IL9ttS/kQLVnqyKPk22K7K+Frxa+CBf3
tj/CL1rnfk7Zn3qF7l/reiHHzw0glmyOYwqCl0J/gW8p+AjirmBTI4YyfYAf
MP7A+JoPKvL7GKtnVllGHVVv/0X8DfFHJKbCwlgHto/+hPfIL/J7TtZ420Nt
+Q78WY79eH5utS8PfUD8L3gMMNPQ9M012l8uQl9Xb7w134F4ymBRz42+ui/6
kGd3i3S+LzFj0fMRT3iEvsGcHpYL99F7j69zHN396qyXQSezb5VtothIiVdI
3B0wM1tVeS9HZ0B8PnyC8TPeW8+uUvrZ1L/EacQluD/wT3xf4hVdUuWYRejO
Wbew/bHPsA6yBoJzZd1kzXxeY+nAVscXv07f8wDRz3Y0b4VvBPzVOuXZs9Vx
mulv1l/6PKfasj88BjoacA9gHu7R+3dT+vo8x/FijWN9O6vV2BFwI3vovlbl
9i0xzwfvBw/9hsbVTNWjAZ+8XK+DrIF51Zapka2nK8/9sYeCx6B9x4avDXYW
dL9gWMFHYockjhDyx3DleaOz82D/Qd9A/B10Duzf7OPsyZ3Vz7e22u5KrCBk
IOIFvaL33qf3JpPuV2wUvBusOjadLXYAaPTGYNTBxGP/eUnP3qtni/ERVPk3
q/wdShxnCDmGWEOs92OCN0E2Q0bDN+fwSuvusyM2A3EQ8NMG2zUvMF341eA3
gk0PXyAwoPA++Njgy0E8PfC6FfHd2ZvR6zyfZhsNscGQ15pVt/mtxs4fW2ms
GDgxcPVgaMDPgFk4sdW4hcf1DeeJzi1x/FZiPRC74rJKx5IjVgZrJvVkbT9X
+Sfw7Yut7z+p1Tr/SX3Ea/XxGvGa+mqa+qo8aZvgbVvsgmWOmUi8xBdqjQ0F
F4p9+Y6wMb+mb/pXre312D1vDdtn/0bNz1zz5Ng0xgZ+b4remd3X/U1MWGJi
Mk9ZP+4ObOfvtfZdZy1nvOAjhy73pVpjW8GjgpU7vtV4Ob4Zcxc+nHjq8Grw
adl1th9gO4AfhleGn8fHenz4r23W2bRab1NVYlwzvqv4fOPfjZ/3kPCRxA+S
MxPGhT/g+cF/w3tvnbTfKX6R7D+/xB59Up31enx7fOzwtcP3Dj8R8FHEp8Ln
GF0K8tCFIRchEw2octvpA2KJoWOinvgR4u+G/x9+/CeHn+CYQseqRY9yrvJX
Kf9FJY73A/8OrpqYWHvmOA7bFH3303o7Jg3yCHGo9lb6eXWOjQ7eDz60OHjC
k0UXiT63xD55+N/hhwcW+ufAl6JL+L3V+gR8648PP0QwgeT5JfgI9n14iW3C
JxH/xf5F1l8SB4/1O7eXx0afIuv/iJUHpnZA0jzbVXpPpvJtXWI9APGg0AXM
1ny5stVx3NE1Y9tDnwymBzwY9pGlZY45zP9gIcExYnP5ITCN4C6Ja35Orm1M
jHGwKYxzvhv6s83frs7rLGsseEN0K9i/4L/gxeHD8WFH38Fv7MPoxtiL8Yde
EvEU0O2y9hPjlFgUxDHAL5hYL0eGf+vZMa6wqxATEd0N/TxEdGfRJ5fYBxdf
XHxzexe5XMokFjo2LvBqxDvBJx9/fOJ5EMeDOB/Yeol5iK6MdRycOxgSYqLg
Q44PODFa8N/Eb72vvkMfXWeJrk/a7x2f9/RSn49RWWKdLxhj9stF+i5l4qP+
XeRxwLhBPkK+RwZAPgW7uqDG+NWHSh2LjNiq8IB9gl89QDxXMnha1jnSiVHM
vW/Q4Grn1xhbu2eBfS9ZJ7Drsv6y9rIGQxN/G/vMxhrbaEjbKtLB2M6rMc6W
vRcsFrL94hq3h7Z8Jj40s92+D9jOaAuyDPZ0cC1gMFL6/TflX1pkXrWiq/lV
sLfEBAF/+1ObY5cQt+RLlZnbbp+gb5R+c3fjjFa2GYcNBvsr8aFPg6EUfWNP
8XMao08U+50j4734EkKzfm62hxV4/2Ufx87Pfkra8EhHf4Ashg5hMvgxvWOD
2vG53p/d7nj42OrBi2CvJ1YkeGr0ruAF7q31OKLvS5vd/2AzwGpgGy3Dt0np
fxXZ7vx0B9thn4CXb7N+mJjFxJJEL8dYKGv2eAAPMrPW8hn4XmLPgafFvkl+
5iyxKHkenfPTKnN5m+384FupAxjXx7o7LsxmW2Bnx10m/YIix0XEH+357u5r
+vkRrc83h27k5e7+Tnyjl0T/2Oa4N/O6+zvxjegPYmdutrN3t54aHTU2cdLh
W67TfJnfwT5uyDXwSfBI8ErQYFfQx6CXIcbC3FLHlloKrkF9mN1svPBJKcek
IL4QdvPfA/9wg97bodltp7w3o8z/IFe1G7u1XHR+u+U+1mbWaOQd9hD2EvYD
YstAs6fwP+eMsEcM0Dw4p926636iz2p3DF7yji78Oy80+nzidB0X9Be9HHON
eGvviM98sdF6KvoGX0T6J6vGOn3GFfwe6dD0LWOOvMh+6JN5L7/fGnnA3IHn
w2+mHb1pu2NTt9RbJkQeJGb/+XWO2/+16rCh0br9NyodR5s1Pq3GNgzG0h/K
U1zgcXK+3v1Do+fIHPC6jV6nLkZf3mg8wDZ61wXt1nVvLfr8dttWeoke1268
Za7KP6LG32Wxnk022YbYW3lOb3cMty/13m8ajTduU/r4dsf/nBVtBEv2tvI8
12g5eonoeY2Wc9kDP23yPgiGnVhC4NiXaTxe392Ybuz2xOtGz9yiPEep7Z/o
vft2tRyODD61q9c71jow1NgVsCkw9on9xPgHP8/4YV3n/keMpR7KP1plLi22
3wBxlPAdYP1GN8Eajmx9SK3l62p0CSq/QxfPXcYxYxg/S/wtwXvzHSY0+VvM
VP9/1mhcFz49+9bZr+cL9cOyRut18Vn8uNF+i2AnwVCyVmPXfDGwlNMrHWse
Xump7u4j+ufDatvVsKmxrrC+sNZgF8JuhG1xmp5d1OiYpMi+z9VZ/p1a6bMi
iFvKM8TIZY3iTjmMK/iNKUEXK29nzdmNRcbIgJXBvgO2hLUOvgJcOnFjsb8g
w0J3j284scnfEV+Qi5os2+LzcUGT/T7AwoGzQVZCTkJewg4O5oS4k+jqx6gP
esXY4/wH0vHzQKbiGWQ93kc9rgrMDzG7qefmsyAK7L+CbqZ3u+coY5lyKZM2
zY38h6N3CXzdg1HmotDNYxN9KXAuT0fdqAc0fBpnnhDzEYw/cWiJXYm9qSae
RUdHP15V5NiZHH42oIN9c56MNPT8nGdALMstzy2J9zIvz2vy3MRPGn9p+u/m
6ENsEPhDvx7yJmmLIp3200a+Fza3beNd6LT6tntOIYcgPxATDB9JaOSI4SGn
sB4SfwlcPDIBsT7ZJ9gjRoasgA0FGzS/Iy/gn7S4yb4dxHdAV8Zza2vMf8B7
wAfBD7EOsy+cGvo00vaIdOye8Gbw86TxG7zT7pEHOYv4gcQFhJ9l3D8X2Bv8
ohY22X8ITAT4MNY07q8GnRbpjCX0cwNiTcbfnTz8ji6wf7v1gWkx9hirt8e3
xhbA+T+XNrke2LLR+zMmmRPMDcYSOCR8XfF5ZdyiD2decN7PQyWep3uGvy5x
D9CVUw42/YdrvR6xFs3TXP5fo2Un3n9PjDf4EvgRdMXoS8CkgUMAs3NJrXE7
n3Q3loL1Bgwk+Ed8scFC8j/46nTN/fRm+w+9091YN7BGYHPAzSDHoHfFD5i5
/KHywDiBJ3m3u/FSYFGwO2+ON59u/fSHkf+t7sa4gG+Bl9zUZF4FvSx50M2y
J6Q1e90De0k52EPh36kzuj5w9GDrwcxzB0+P7W9N4Iax/YGzAyOHzRrehFhZ
8HngPdfUGPPJGONZ7CTw1+uazGOvF71R9LIi4+Uok7kCthT9BzgrcKDUDywo
eHZw7fgC4OMPth3dJu9Z3+R38Tvp+MjD4//eZD4frNO0WuvS/lL6X032HyLG
BOcHcHbARTXGYaDrJg4Fcbs5I4/zi7BLMQ7PD9sAaw79CA1WgXiwnEEA3mBS
0OiOuN8c6RfUGHfCHLwi3fYGnmU94vvtE/aH/WKMXVhj7AL68OtqvWezX8NT
HF1rvoIzp4hfz1lOrI/gApF5L671fsxezPcBB8k3IgbbGU3WN+ELRjo8OXbH
3WO+M2+wJzF3uH8ZNP5t/M+8Ic4B84I5Ct+PHIAsiT8M8ZE/jbqwbmNLBXv1
ZNCn1/iMJWS3zWfZFZjPpC6zo55n1PjMJOQy5NQhUT7xxooj5hh4sacCh7Y7
Ml2ldeN7pjtO0o7gARp9NhX+Ts82+rwr8BzEMUOnTpxVYgrtFvnR50wNPOPL
jT6PCjwuGN2DMxxfiPPH4GU4j2+q1oApFbYxjA99MbriIZU+Nwj8OedoTU7z
NyI+IWd58d3Q5U+OdxPjgVgSe2b4/mTQxC3hf+JLbI4BW27/uRkRF25j4GUY
i4wlxjpzGl3xjEafuQWWZXyr9YPoBvGZwLcBvwl85/Chw4/mmUaf6QUmpoPy
z1P+LiWO10XbwZDj38HYxaejo/r8wQpj9u5otF4enTz9Qyw6+PDbGn3+Jbg5
YsmD54GnbS3yuSbwtOhVodFdrOjleC7EcrlXfXtehffyJY0+KwgM7OjoH/qG
mMGjA+dQpz7/pt4xJgobvY6zhtNPR0S/YVfHvs54u6bR53GCK9xTbfm90vaX
93trbZDMckTSZxySHzsm8UsuCJkR3MGgwB7sXhnn7qjOe6icTZW2y/DcifGu
KY0+4xMc4k2q4wkV9oG8qsnn98BvNkV+3vmu6vCt6nB40jgO2og9Al9TfE4Z
D8eoTUeX23fzaeIU6to7w3G9oIckfD8+aOKOQCPXr1SeMeWOW0Z/jonxNjr6
dTD2WeTNcpdHfMJjyx0LljJPjHdteZ78fJPRUc7p5Y6tRly1a1LWXzInn2tw
fB/WXc5q4BwOzuAATwqeEyzlDSnrGon3hQ8mvoJgJDr31x6u62Pt4aeWG4M4
OuHndoxnn41yhqKPbXO8XWKOse4j3+ML+GqD4wSxho2JOtOOU9ock5fYZZx/
d3rUHywkvrVgIIljRjoYMHBGYI84gwPcDTQYJLCtyDHoIR8ITA5YIHA5B0ce
7odE+lFtjvNLTDPWUeQ2ziIh7iXxH8dGrFNiLBJ/lW9wTHz3w9scv5V4pPjF
Mh6Y+4z5o2J9OLrNcX6J+UY8z0MCI0R8P+IGEosNLCf9yZkIrFe0nzWLto6L
9sLbwk/D3x7T5pjCxGrjuVMj7iL304J+uNz1JKYl7zg1vtdxbY5BTMw3Yuwc
V/73eD428hOLkViLxGJkP0X3x37R2GicCjpuxuHTMb5HdLH+Ed3jVi2OwwIv
wG9PxZjn7KynYtw+Fc9Cn9bkWC3wODeVO/Y38Ze3bnG8Ffg2Yr2+XG7ffHSJ
nPlCf2CTzA275HVNju0Cv0JMI8pB58P91aDhGdE1o2cmbg3xa4jxgi94qoux
tcRUfCPe9XLQxJjFb5z7QQnb8cHMgisAW4h+8f7I/1o8y16UF31C7H94W/Qn
/btYJ0f9wflvOaNmz3ieeIYvxzuhTyvyOVJtRfaVbOjive4QfcfXK61PHhG2
ZuI+0Y72aEup7m1dPIcOUv5XK63fPkz0okrjkb6I+AvYJPGJw56JfnhpxI/A
zrlHF2OHeS96oJtCF5QedlR03+i8iauP3hsbJngg7JjDAqtDHKpj9d53K22n
AM8LLwP/v7PSJ2gePS36tKRxW8TzHxv7FPvVUO2NR3Y2jnGRyl+u8vdPetwN
CN33jm2OWUm8SsYIfU0/D6u2nQwbGb6Jm30adR3X5FgV6LpOL/L5XH2LvMbn
d7EehHiVfFO+zz0p20+I/Tg63Xe+0RjV5+t649GJ/8x5yMQbWJ/pfIydjY32
gaGf0EcSe4sxyZ29DRvuBUHz+0ul/o30brH3kU7Mf3TzyNfX9dE62Me2vZGV
PjeOcy62nD2GHYeYyaxbxPGb3uizVMECc1YNMVbHJNzHY4MHgN8YG7zWvxp9
ljM+BL0iD9+C+JnEzmQu/N5oXyDmInwA+yUYUWxl9AX5iNGxOVZ6muOJHxf7
KXwNvB28DXoCdAjwRbtW+vw8zmtrL/IcYPxf3uhzx9HZTCry+GZslyXNlxJb
F7+bzeeHgeVAX1rhuA9gLMBa4AvAnEjGs8RUwP8KfBdYUs6DIL7AzbFusCZx
TtfAOp/PRUyPxTHHmaOLY03oG+MHHdfILvYnYPyA52d9Z23HVk0e7G79ijzm
eG5io890R547NdrLt2uLuY8/bE+N7WOrHAN5XDxLOSdVW0+KjhT/AL4p3zYZ
WGTsL8RpQi/DuXLteteyKvuDIk+jIwRzhb0FHwawlMSxYE2kHPRF8AFg0vFF
xr/6j8ADHBDflLjFxDLGbvWG+nsGelWVU4vPQVevg5MrzK/Dqw9uNT4DbAb8
LLzzqfASyr9TV69xxOsmVin7IHZIsAn4dMO7w8szbv8QL5FebZzmn6Izqo17
3ST6rypjUvFTx6edOKg/tBprAs7kbtVnmurzVgfHiiZmNLa27qpDc1fPf3QA
yOzIpLSvJOpAXUqDRt+Pfge5MkN927/YuE/iMILjwf9zTKwBjBPiom9ZP8Aa
ck4IWERiTXLuB2eJsEc9V2+bKPjH/DjfBBshPurgq4nnQDrYyF+1Bvy3j/eT
0+I8FPRZ36mMvhXGxhBnk3P2sKeAGcVvnHFF7LjJav/UNMfw7hRlEvtiSrlj
ynHnf+IhEA/j6khf3stnvXDOC74qjBvGzKpyyw/IDr+oXj/38V7BmTnMc+Y4
/c13Ic7AsnLPVeZpR/V/vvr/N9WzQHSJ6E1Frhv2e2JYjI31jzUK+yF2RPxE
wLqAcwHjOiHDMbaZd/QFz6G/I64P/jzgXGnX5GjL/r18RjX6Kmyb2DiR/YtV
h1RX7ydgCIfouifN8cqJGYjt9gv18fX1Xpu5L60wDeYVbAp4V3gN9rrJCcfl
HpY0hhY8035J23HXtPosNM6HQe5H3scvhrO2OHMLHRr59g1b8EVa1C/o7zMS
12nMb6gynp0x3yf6NkubzE/K8xJxHBt8Zi16VmzK/SPPZO1fj+g7fqw95/gK
y0jIR183+Exu9IXEJB+aNAZ4hdKXV1kvS1yzwYGrPFfvOae/z/w8X/fz+vuc
T2JoED+DtT+h/kzgh6X+rOmr9hKLNs+YPNqIL+Bk5Mh675+3qm7PqG7rVLdW
Pdve1ev+J+zd9d5rP67wM+T/WvvOsojpsbqXz7Dk/Er6iz4hdgVxk6/NsCzc
RHzcvo77SMxd4izPVfopKvPmesdBytB7M7rabxCcU5foN+rKtwGPV9Hms2o4
p6a38vftal5sg/rqf1X2J1imuv0n6XggzDvm3KUqp7PWje2L7b/6ntr7Sr19
Er9UG2eJp/1NPMsHSn+13r5mD8V7GQ+3K32e2rix1Ovu5bH2oht4rd76gRN6
+VxGzmScHPOa2Dno/oi1QawE8OLwf8RGQAeDzRY9DD436AuRQcCmokcnPga6
BHyH6ENidyNvIp8NbHK8Y2IdY7tCP3VG6LjA2KMD4BwP4g6ijye+MXFmiC1z
XcqYnS3n4nBHtj281efTczY9+E+wrrMTxneDLZ0lejf1/8l6bwN2K+V/osZY
yx4ag8397YeBjDgtZMa1WpN+62N+gfhT6JfR++3V5tjxxPH+R5vPoSEOOfwv
PD08MDHswGGAwcCGgE0B3WmR3vt4jbGl+PViowN3gZ8CbQfPwH140MjxJ4SM
/1n0w3UJn1+ETP1spO0U/QPvsX/wXUdUO14P/j6ch4S8jp6BNZ4zVYlFQYwT
zlglDTmefRz7Jr+TDt6sb8j4m2MuFfk30knjN2JIPKb7nHLr6MDJIsshu72n
fn2nv894JC7SkFhLvwqaeE2Md+pP+1YkHUdpS96hkedNlbG4v89NxbeD/mG8
HN/m83uIk/+2fl/S3+dVwofgD83+C49FjCrslS82OJYx+mPwuej10IeA6WuL
eEQ3NDn+KXp0eLxHQjZkLJ9R7rWBGOrQExOOqU68ddIObfP5KJyNAs8Jv3l6
mrFfm2MV5fi5M6Ocg9t8bgrng8CbIU/Dn4H/K4tnkbVbY13lTh7OppzR25hR
8KKXltvvF10r+9rm9+q+d5vPGOB8gRvK7e+NT/erIUfDu4KloJ2cDYFuCwwQ
Pir8z++cwfVQg2MxgwvGX5xybk+4zOuDfqDBsZjBFLOXkc5+hq8V/H5hpPEM
trIbg+ZZ6gq/zl48s8ExoMFlo3eiXeiLOH/q4dA/HBM0+hR0NehxmLu8i/mL
3mZapENvr7WvMWkMIXiPR6Ld6HYfj3FLvDPGsKb85vFMOtgW7o9FnjlBg3VB
nuAboeumjpdGPV9rdAw++DLqR703x2pL89lR9Cc6NfZ4dNQHtvmMLs5HmBjl
MF/R03IuB7rah8qtU0ZfxO8T412c3dE7+ATOlpoZ/cP3vTnG7ZHx7BExfifE
uOW5XlGHI8DRVBrnViw6t9Jnku4W/g7EdgZ3DV8MDpBz874p8TmS4FyIwUH8
OvyJJzfapxjbP88gxz0T9BZ8KfsieyI4efwzwNhXV9u3HL9y4nLha4L/CPs+
+cGjsv+fEbbCbwLbjy1sTaHPBSX+/PpCny35e6YxOmB1wOQQS+iBDPNX8yqM
52BNOwYsQaNjJ64sNIaXc5jA4OMTAw7/u/DLQJ+DLQ7bHvY4bHHoFbAh0k/g
ArH3oWtBjsH+hb0Lexg2L/Qc+B9hawOTNzH4jqlRN3RNrBGsFbsG/wlPzV7M
+UPwBPADnHXJGkmsZurM2VH4bBJbDL8SzlH9qMRn+vEd2dN5lrWX2GPLSxyv
jfMJOaeQ8wcfrXDcDfxM+bbL4/ty//r/5Sce02a/0c62C2JnRP/Au/5KmGeh
vuxT7L3EOWL/5cyGzZgppc0rNY6KNPZBsHrg9IixNC/y872mR58cr3fd3ujY
QcRzo3/AxPLOT+K9pF0U6fjV0A/wUdg2sXFiGyUeA/7j+JFflnR7aDs+1vha
46P9fYn9ovGJBs+OHAsO6sNSY1TBruIr8N86+wvgy4jfLP6MNwWGFWwJOBPw
cGDniF+FTox+m1Zt31f8K/kWfDP6GX3ZTTE+76wwhmlzjJdq+/Tis0k8D85z
JbY2sXShOYv8xeA7wFltUvpGXQelG1cLTdw59EbEeR8ecgZ2et6FnQQaez3n
GHOe8ebzgsNuw9m1G0rsS8B5xL3yfCbGhPAv2BA+Bsjo2F+R09dFft41tdr+
w/h+MpZoM+3FF+X0ODcZvpd0eJh7K+wPTL+hG0I2hp8h/vFLtcacc77qefEu
zncC78raiH7o7LCdIU8jQ6N/ww+KczCJJw++G595Yi+k9/YZsZwP20X1LKy1
3wP67LmB2x8buhFkSbDDjA10ROA1kd3xv0B/Q7wG9Od/aYx1rnVfTdJ3y691
7GzmI2dtMmY5k3lc9POwoBnD4N53KDX2fXr43uB3g/83PuG/hi2Zd6HfAHsH
lhF84/0V9mlnHKLX4VtgByd+PbHoiZkO7uermL+MSeby5rhtui8sMaYaHyPO
NmO9WV5szClr6uXV9iUG/7M+fmctYh/E7gvPgV8H+zj7OTrmdYXWM0+stv88
tuMrqu0zD+6oU8jh7PuXVdu/Fxs0ZW2Wz9PM03M2AOcCcD7AiLDxTa4OrF62
eTn2EuLwz8yzXyu+rBXl/g0ej9hw6FGwjaJTwlYKPz9W32hjV5+bsC7ayt4B
tgBbAjbu3iU+AxWfDuyzjDFi5b1eZH0MdHOezwXhjJXTVOamrj4vGl3acY3W
pzGndgndJvsedcYW+XDKPg3oszoVOXYPeBnO/ZkYOlh4anjr1jT7TDTGb+i8
r2i03ptxj+2YefFYtWNVEKeC+HjnRj3Rl/Eexup91Y4FPDTWFt7Lvjyl2j7e
YKhmRzxr/GM5r4w6wNtT94HR5+yT7Jeb/eNKvB9vyrTNY1KME+JW07f0MXwL
Z6LBf1ylviqotT8EzyDLIrMv0jxYWOqzeNAljG60PoFzFPBDwweNfY/9b8t+
PSj6hzpuEzT8LHwtNmJsuNDwt8QzvCrGA/hnzsx+Ouw+xNXawt/CL0+L/Xlq
rJnDIg2sFzzt1MiPHbg8vi/7y6Sk5xi68d6hP0dHMKiLbcXoy3tF+vHhJ4C/
z+Oh20X/xv/kQR/H2Qjgp6jfUSrjhRLjYPCN4vxa8Fd8R+R/9oXVkY7PFPbU
12OOgzOABh/yeIUxmuAzOf+SvJx9+WScVYA/9uexd8NHcf889nHeMyPexX57
X/Ae6B4eCh6Ps/7YD5izt1c7pga4PrDB2ArAGPBd8HvZ7POi3zNqHdv07mrH
uQA/xh7L914e+gbwROgc4G+6he1jVYwHeCHWCtJZV7HbN0X55+JHX+u4q/j8
N8V4YE3uHvl5rnusM6wbV8acQl4cEGP+ikhn/KCPbw+dPHr7/lt0+OVOR9bm
G7bGd2wPewXp4LNpe3HYJHgWfy709/2iHOx/+N4cHvaOPvEuMLTYB7Ap8Az5
0f9y7xv0QSUek+zjxBD+ocT4DeQTaHS5lAMOF70N+psFQY8pcSwBfL2xp5OO
fXyHLsa8o8/F9v5b0PjW4fuCjxXrNGs3WF/ialFWe5rrQp1YS8nLM/g07ZoK
G7zG3oIKY8HBgbM3Hho8XnelVdXaBoMfDLYrbA2sqazRyBznxlrP98JXDNs2
6x3xCVhPka9ZS4lDht0ZfA3ndg4KnR/YTHRW1PHgqCd+P9j5N59nl+Pf6E/q
dVjJ33vToUETg5x5zhzHB4jz8Dibj3m/KtK3K7UM8G2x+b7vYm3Zuouxb2B/
GtTe6lrbTTkPHL0vfmfYd/Yo8Xe/rcJx7ohxt0O142qBz8TOj02f9qNrAwMH
zg1fOmwMnPFBvADiPuDTui7u2NrAEaBTRxe/Z4nfhW0qU/e9gia+7LLQDeKH
VBVnyYHjJlYf4wn+AZ8weAjWqa1KvK9yRtfIkC/oG/oVuRueEH4IXyres2e8
65UKx4VB5nq5wrFO4OfhH3kGPoq9+PPYj9mf+Z/97t2kfXqIW/ty2FIYH3tV
O94WctaqUp/Pir0J3e1pKdt60AejK2dsEEccHRVyDX5a4Dw4ixkeHF6cOHL0
xaJY0/ALgC+HJwd7ujjme7d847bgodOKfD4G/YE+FRzoHHQIFY51iDyyR7Vj
BIMxPlGy+dJK+0vCoyH/Idehj0buom6fiKddJZ72GOw/yr+iwucBjRX9XaX9
x0eL/qgyztEVvbzS+vkTRH9eaZ9Kvift4/ymbkr/usJnBo0R/XGl/SvZ5/F5
Ys/euYtx3owZzq0jnh++LYwv7C3YjRnrlSHzwpfi1wtvCv8IzwvfCA/P2Sx8
wza1u1utbVvwp+xZ7F0fiMdOqY2fljjWCPzopOh7zhKk7/H9zYzxs1ece4ju
njPyOpQ4jhz7P+MCPpAYHkPjTMODo77w/PDg+LbiA4uvHnoWdCzcwfOh29k6
zknEbvdqhePvIBcTPwKeHh0RcQKwi6OffS/pcUncY+ZEc8wLfEnBO4LF4px7
/NbxX+f8Ps6K4Qw/zqbD5xjfZHxYwUahB8cHFD3xPsFTDwz9IfYu7HvYdtGD
fh9rC/tz5+D34DU7h1yJrZOzIbG9/Sm+66xGx1SifvOKzRMTZ2F2sWWKAfpG
DbX2585u9bkvjGkwi6wHjJ8ni83/wfvhF/dk0MgITwTN+brg2PCFREdELAPi
KKK7eij0Vw+HDQL9ADG5f4l9Cj/nmvgN7B84XHx84Gc6Fjl+GjwV8SWZXx9l
OqYUPn2cHYyPJusz5zhwZy16OHR36PDmphybYYvth/vEkD3BgaHnx+ZA+dgd
4G2eDZr9Dx4IXgK5kxj+yJ6cm5IeewB8xBWxZ4EvviLGJGMdHg1bJOciE0MN
fCrnemEXQV5m/N4Qsgz7+arY09GFIr+je23Jsn6B/WVGhePPIjOSf3XwA+Bd
psc+BKYXrBs4N/DVYFjBACD7Eu8R+Tc3ziPgWWw9xHqbGLI/7UX+vb/accSI
r0V8NrBrlMlzPN8x+qY08oMjxn5/RuiRpoS+Cznn4pB50WckS63TAI8NRoG6
cU4256MR24gzr4iJhT/dJVqrOtU6JimxxolFzrwjdmFujA3uOUGDRRgRuCz2
QNY11jT0RsTXIybJ0V18Biyy3pmhV2V9ARMwMnAd8ETwSfBFxJWBt0Dnzz7D
GeC8s1PIeVvOAcuLOci6CV/TP+F5zHxGVmbuwh8wf1lvOPMW/QZzsSTm43+b
fS4Ofh/U8ZGo54tdHBeemPDgoYojf26rz2diD+OMzBcjz9gtuo80r4WnBr2u
2Wfw4NuCTznnu1OPBSU+H4Z4LGAWugRvPCzayTpDnPWfYl48XOJYq8RZXVzh
WFfEuWLtYF9Ejugd8hEyEHoy0uEZ+gdvDM/bJ3hveGOwZ2Dq0W+w5/4c8x1s
Mz5t+Eg+WO14ecTd6iO6e60xgh1jDCD7IMvwPvSHYFc42xpsBzZMMJfsE/Aa
jAP4jbOCH2L/3zb8oPBJAa9REHI369/ykIGJD0+8ePgR1rhOMQbQQVKPUVmO
bQDGBYwreJc9Al9H3vzoz9+afe4R5wKN175/rfbEm0vtH8h4A4cAFqBf4AEW
q8xFZX/rXrkjz+HftCR8nM6ucnxS1ij64qOU60PcbWyuOyVsnyUd3/lTlP8f
Ddqf0hyXi3KI+TBW6XuDD0hz3o8j/7UV9jXFr6paeQ5qMLYQfN+BDcb4jW/0
GS347W9d4XMrwS6CYQZvDyYVnRrn0hE/BNsNfgXYaMDQks6ZdONU5n4q89A0
ny9C/bEX48OHbQe/sPMafU4GsSrA9TF3wbsS/5h+ARPC+s46vzZh3C40+kZs
Q9iQKAu8KrhVMK2n6737671HpJlnmh9n9T4TZy/SRvaUebGvcGbNC3FuzZBY
d7fo+bijq0HnuVm/in5dC8MdusZ3dnnPRpnFYkaK+hlPAYYUPh58I+eugyeG
ZyOOxWENjs08VXzU3DrrCIhVRh2IkzBe9T9Aef6Z5u/5VnzTS8PGiH0KOxb3
IQn7oPF9GS+n6tl99GzvNOtQOXsLLM4Ype8K1iHh9yyId7FPEZMReYozVUiH
1x4bPBhrzm9lzoMt745SxxsC0zuwwueYgh29q9S/sX5yDtSFpV5b+lT4PFF0
v6RdFOkXl/p/ZHnuFwSNjA+NjPZJmeMIg13nXNmkrk8yfd/8f5qxxNDY9w4B
P1hrWZSzZokXhm9Urn7PS1lX0V7hc08585Q9iXjZK9Js+/4maV4dGvsOZ6Nj
A+d/7ODgVrCdf5hm+zj09Qm3+/Zo+zdhR+dZzohZFvmx225MWp+F3PB1PIue
ZXnk+Sry/yPetTxwMqloO+29rNR9gixfprTylGMEkTYx0vEB5oyHTzMd+5CY
L8QoQLZHxkeHgE5gUql9cJ4FE9JgnDJnJRELGNk/PXQCzHF4UOK14Xe2TYXP
ncUuCV6efIwN3n9plMkakB7PglVEDw32jPOED6u0LZv8k6LOl0b9P43vS5uJ
zYJeMhVtJ64n8bbwE8ROUB55+LZ84+Lon8sj9vQVpf6f8rE7kwc91SWRTp7+
FT43lzNzwXOURX9SblmMN2KYfBnfIi3aAS+UpXU0r9Y+n2C3T24wfrtdMtpp
DcZbXq/nbki6bq8oz0kN5ndni36uq+2N+IBcG34gnLFwXcgUnON2dcpxzvHD
J1YOcZDIyzON0a7ro3zOhbsm5BdiJpCOnZ0YMWA0wWPQB9dF/t1S1vsQD6dR
61l9f+PNOVd0RqwJ6Fug8d/prXad0mDZfFTgg6YlfO4xeGjsTcgF6KnAQBZE
HCzia4GFH9tgPDz2f+qAfXyh0k9tsNwB5p1YnODeaSfnRzO//6l6XalrcOe/
Y5Cha+J8hgsbjA3GrnJZ6HuPDVkGORF5/YIGy+zI1uc3WL7e4m/MXHgb3H2D
/WrAv5/ZYAw8daKcjcrzodLPbjC+fGSWsVZTwbcofUKDcVHI6+gl8D0Bfzo+
5TFA7Ar8U1h7Wasmblm7iK/VYLs/35nvDT6KPQ3fN/a1yZFOTB3ukyPP+Ar7
jeMz/pbKGd/g8QOWfLMvTLr3uGdibyKNejAeWM/TY48mpsYZUTdiNxBrhvQt
+yXyFjbZmRFn/o48x2EjHhu4DjAd6LLYHx6MMbPFHwPeGNw5+wVY8UERnwm7
4sHaj7YHa5LmOcVeiw9Ra5NjZxMbiLMh7oi9Bv3OXbHGrgsbEWsKmOvhDcZd
o4sg/il4G3SN6BzBhr0a8j+y/75l1leQh287Lr4vfjqdwhYGTm2vBvczOHR0
rGDReW5DPIu+g/+Rj3Yp8/t4F3aVDaEPQddJOmsFdVkXefDdWRu6UOpFHEPw
bOgnfg56NHifBtcNnQK6Bfb6VSn7p+GvBD4NPzTsQbSN57HV/phyOv5H3Pkf
2xD+XDyLPQ7ZE330Fpn44ZAl+Z13YBfb/P1Tlrcp54coc16kM64mRd/Qb6xZ
6EPg8Vg7WU9ZP9GpfJvyuObO//hzfRfp0IyNn6LtrF/kgZ+kPt9He/EJXRHj
/6EYb4xVyqAs/FuZH19HnvJy07z3OM4ZbzAPyXMPxZrG2RSfNjgeP1i4z5N/
nw3H/++zRmjteay/Y9ByziR6CjBIM8TrPdjPtprHAq/UOXiJFWXmGTgbERq+
Ykjwyug3sK+9X2YbG2epEKsGOxh6vj/rzbeCeSA+F7gHsATQ4Ao4/w4c7d7B
J0DDM5C+vMx8HPZ87Pq0BZ6OdPg92kQ6ugvkD+QRMDpgQhaHbMIe8kGZ9xfq
z7nmxOs7MduyL7ol1jh4evRLYPT3jLZ9hGxT5roTqwQfNvh56v5F1J+9gvWd
tZ2Y3n/VO653DranBq9JnOPD+T3EEMCHAV8G9IHEcajLNv+2e8r9xFqFX9PA
lPscff3Wqb/ToOGvrg/sG/gL/KM/LjP+FnvGVinz//BgAyP/gJTTGQPzIj/8
N89+VGb/avwxoeG3J5b/zZtzbgl9yJ58dZPjoeO/wt7+YZnlspuibxkbjIP3
yox/4swK8jwee/t1sY+DO4Unhh9+O+RBvsEu8c7+oVvDl3Xv4AnJD0+Fry88
E3zNUUnHIWYNPbfNazHrMHw3thN4b+wn0PDq3J8P+knJuZ9Izh2ETNtmWQs5
68w2y3vIeqzZd8Wa/y/Nj7v72Y49oc1yCHvNbFX20f6OYz2+zesdax18NOcB
ca7SGUrfX+mDQkagDtTxHKUfCI40zesDOIM9Y20pD5nw66BZE7AZkoc1jXUM
Ozpr5jUVjhlEvCAwq+h80P1gc0B3yjhHV4Qdd3rwFWAf2TOQ2UgHg/Sh5I7t
6mxjI+3HSD+9zesOa86OKbeLvYz7S0FfrfKvLTWmlG9ydXwXzsthzqNnu09z
4pEqxyF+Xv2f3WA86guiOzYYfzhDfflgf8d4fkD3qf0d+3lKlEn5xLAkliXn
Kv5Lz02vcnwUcMiko8O5R+kzqhzDGHvLgBj/t5R6LXg++EzWaOb82W2WV5FV
n1F9/tPNPhizRX/QzT4MrH88u2/Ij7Sd7zw59fcZxTdojFzXz/iRIY0+EwgZ
hXhlrLnETDtFZeY0uC3Yr8BBoo9a3cnxg4gdxNlTxAkCuwWu+T+hp2Vu0xZk
W842BH8D9qa+3Bhi7C+3lbqdtBE88JToN+IJcZYwMYWI08N5ePBdT7f6/HXO
xkGWqEl5bqJLZPyCE6A8Yg6yFhEP+YrATN4Q7yL910yvb8Qj+qzVcQyxzWao
P9L6+VxT4tpe3+DYtvgoUia+hGALwfuhrwVbio7zvtDdkoZOmLM1wILAq+Af
Tgxe4rGyfu4Rayj2g91CFthO7xyka0pe6LlTXmPX9tL31DftWGq5gfzId5RB
njvS7SvCufXHdLQOB/0Nay5r6lchR3MG1v5Z1tHjCwFGEaziT2U+0wpdB7Iy
sjmxdHbOMq4THT973RchIy8Pmn0NPMHnsV//HOWMiTzsf+yJ5P0y8vM8afQd
+agr9aQO6Fv4nzLWR32IAwRuFH+BydmOZcv3nRdp2ERO0pw7QVd6J8e3fyTa
xbhjLjH2mNuMK3hXYokQY2dRtHdD6CIeCDsA2Etky/XRD4wp8oB12RT6BPLz
zfgeyPfYGsATYn/hfE9wNuiCh3ZyXH7i1TAfV4SuAxxTU8p2jeGdHBebGDKM
5a4p+8uwR90c84KxzdylLsSSAAuLPgMbAWVhJ1ia/Pv85+Yon7WaO/+XZJlu
jHTG6dwYqyOVNirGITS6TvSWyJvQyGz8PjLSsS3fEHbEEZFOP2yuV8p6GNbe
wSn3Ff23Y9CMad6L3RbfC+Io4EeJr9GZ6oNjO3qtJj/tRU9NOazbrcyblPsA
XU7veBdp/MZ+ip4S3ALrPzZ2aHhAcE7EAoKP/Ia43w3WQ2aX2x7Gb8SK55wb
9BL8Tzq2sVOCRt65psxxD8EFkcZv6BaINXRS5OE3/uedlH9ipDPubgleiPg6
xOohTsof+H83WGbqGW3h+xIPblT0OdjDzRjFdMtT2LRJI2/PaPuVYefHBoEO
addYK/BnPSxsRqx/t8U6hq9BTYw37OQXN7hc4tZc1uB9HFzLbTEOF2svOKfB
8ifyNLoRZGrOVeaMQGwZnHPHeXb4SRFf9u1S+2ex9uCnhB1kP/EAi7saH36M
yrykm3WUd7X5XGH8a/DDQL8Ij7VQ5fVMs+2SmBLEzIAHe0xM/X3tWuNyzde/
F7z9O1ozS1TmxyX2F4f3he/ND7sM9gfibxN7m3jjnE8FRhb9/79Uh2u6ayzo
/T+qrT9VOZ7XStE/VDlmG+W9HPw05zmUhi22ihhXFZ5rxCAkFiGx+zj7bn2D
4x2yTm6MteUr1bOb6vltic8VAm+Ez8g2xIaqsA4Kf9xJ9eb3wVLNDnsSuC/a
CvZrWJvHNOOZGL3EDKL/4Zvhl+GP4Zfhm/k/pb0+We3zZ4j/y3fC1vFOfK8h
acZqPR72JGLKsuYSAwGM1VNhh945vul9amJ1m+PdMDcPVbv61BknRJzIWWEb
Jm45sXXA/s1Pmr9n7NUQZ6zKc5kY+e/W+wzDrqpnTbXPbj9JPMAhNY51DK/O
OXPw86/Et0APhp8B/m/sDb3DZgwfwnh8LvYy4q0SdxWM6APE81Y9h5c4fgf7
MWsgOJX3k8Z74yO7JTY2+AVwDDdmWK5aGjIX7/ko6b34yKTlMc5xB6P0dr3j
2PPc+/Fs1zLr5NBdVZRZf8la9XngDVk3wI1gvxoUur1loTdjXWQ9ZW3spH5L
Vvi92OyZG8iI+MfBQ7DGwiN8EHXrGLY+1vXX9XxTmn3EaCf1w0Y8J3x9kJeJ
icsZgcTFnRvfizE1WnN2UjfrfOl7vgFYYuLckG9own4hjEH6HJ8VxglxqK7S
XHha/bFPvbEN8CH4V3bq5bN8wN6tUb8dUeyzu/bX+9/oan8T/FHQAWLjXqfx
kl5rPTH15tuwH+Wpzv+pMK4WjP4rMTbQH86JfmT/eje+BXbzA7OM3cJnkb2O
PJwXsLDe8c/Hqr2Tu1lmuLrCcU6Jcbqul+NsYtPnnD3OmCFWALIq50cin4Kv
wv6N7XuBOnW61qvvVa8DNZ4XVRnbi+yCDIPcQ9+zR9H/L+nPg8q/Ktd2+C/r
fdYdZ3Hi+4u/xvoyx/LmnMsTkz7zku/1ek+1rcLngh+sd71ZZXz9D0p/o8oY
JMYZ7yLe2qA26zTRZ1If6ow8RfkbYk3YTuU8WmV7L7+vijw9Y51GV0Y7aQd2
5aHK/1SVeZyn1Jap7T63Z2elz62yvWhtmdtDWwqVPqnYc/T2lPVr+Hf2LLO+
Fj0rMZOIZ8QegF4XXRf7xP+UJ6H2T1R79mz0uZvo0Tlb4416n1sxXW1/pLtx
aY2tPs8AXNEPoQdBB0I5f5QZe3J+m/dm9mXinRCDhpgn9Sp/T9Vzkb5FeqNj
sBKHkvenRR1KAr8Cj/ea2j6j3Wcf8W34VpvPflZ7H68yn7hAY2xpN/vAH6Uy
64otY52SdLmU10/p+xb77LrnlP/zbvY/R0fydMxN+pOY71vOauWOvJfZ6HjB
6Jtb22wXgW9h3UfngV6D867eLLWfNXoUdFLIneCQ8H2HjyJmzHv1Pl/hc43/
j+q91g6M3xm3n/b2OZScQdlL7+rV3fhC9CtPxLq9Us+9Vmk7M+vK3NgL7taz
z3dzP84MfBP7zkfRRuYU/ufUC1m4vsy2C3Bp2LiRWZlDhzTY3oOtZxv188wq
YzWINY1cgR8ye92SGNsnJD0O6TP4FepJ36yqt70Eu8ROxLZSW+5L2beSWDvw
Qtu22SaBPWIo60+lfRse1Hsn1DgeA3NoY7wLf6XfSo3raQpeZnDYibCXYi/D
j3Na+Hg+rXF7dr1jlhBD5daw2U9T+eNqHJsB3Rdn96I/xAf6g3qfwdum+vTu
brsI/Y8ujO/NN+YZ+vI5fbQHND6/5UytNttdsLmUhx0JnoTxMCfK367N9hts
N+wX6CDRG/Md2dfR77HnfBj7Dj4hzydt46vu5fMh8Fv7v6LOJSSqMIrjRS/L
jTE54zycxscI4UKa7GWUriKFpEXSriiSCFpFRDlS2mOV9MDQSEhaV9AuEoVA
zEUPCCIma9WiIIhAiqAW9f/1P9Hicu98893vfvd73fOd8/+fA45mPGV+GbxS
2hXcIJivSq258rciD/oo7EzwC9AhLOj/t7Wea/w/FnlIAwfK2MOPI9x6MPDs
x9mfg4fBnxkcfjAHO7RGPm62HDhbY94I+BX4KQ9S7seazZpH2mO+0nqxqs32
fsbh14Qxt3+5MUnbwuDWVZe0HpTs7xbsIHgEfM6AGaKerCHwNdEJsjclpvqh
BvM9r6nv+hKOGXg3Zf9K6Pcm4xq8JWf+o4+4now8tBnvTbthHyIdPhhckdsp
8wjgyCJbo7/kN+vsvpgL+Bdk7NOetDsyDDLjaMp9vU3vtLVk3k9N2j4ruR9e
PnpS9DCV6BfqwbkSffQy9gHMqVMZ8xvhNo7r3Y9qru5vdixE4iPCy6B86ozf
qgPK/3y9Y8c0qh8K7fbFhR4JnBn6l396Yew2jPEbKc9HzvxmzeE9yEPfrWgz
jofx3Bd7I/h87MkG4xo8EeWDKWI8gE1C5waOeKBou9rvVsf8wM85mCN8iCC3
gWEjLgt41KUaP59U5/miy+uKMlknykWPMfAq3IM9bGOU82OJY/qA54UTsT3K
BNOSVj/U6UhX+zipPEeqLMsgI4ERZfzejzrfi2t4AT+1xnblbI8Ga8V/cKRG
GYdgEtQXn/Ve5YIxw1903Y8dV9fLlWco5/g5xM6aanb8rAXdV0jYN/Y7XTeG
D2989fEMym9K2y8GtuD3ytOUsN/ulW3GTtFHxDPCVxdcjxMZc5XhKWPvw56M
zgNMHfI8XCGwQpQNXoi26Yg2H1LdDhctmyGP48cFO8h1pV/Rs2ZU/01qt7Ke
dabKHFbmAT6s4Ed0hM0FOZkzNpexWKuYv8gQ+JBgf3RZfXux3bG60euS/miZ
963otrERdIZsTjnMK/YNlMW3eyrWTPxPcD86Yc7lpPXGp7Um/MoZi3FBhQ3r
2Kln9Sq9P2HZk7wD8Vx4r+x7+Y7guwj/R+DJv6k9JrOO0Yc/OdLBvz1RO7xY
49iZ2bBvzobNGH9l8FGfJn2N3YG5Ph3rOfLXdMj8FdVrS8mY7WPok8G7q87n
lDaoo0fpu9TXrzNug159Cx42mENFmXwjsJtwnonyC8pzvsE+ger0vVudt3+p
Eb3LdNaxHs+2sAE17mY+6bpSz9YW47nB0XToem+99/pXVc8RHT1cq14jJfvh
/q7yF/PGOS6q/DtZ86opj3LZU8xF+fD19qyzz1D8CSCb7o6+Jm040rv1jI9F
xzzfoPLHEtYNYCfBdoKOBZ3Xpfh2PAv5i+8yPpGJxcXeqlH35vL2gdSl+naW
zEvOKX1t3n650Luj80Qfy76Me9FRoMtOgjvWcVPjbSL1/5swEWvsHDJtvWN3
IwMeDBmBvSs2Qbg2xGZBFwCv8HjqP348EzZubD2M/cEYhx+KjpEANor98puY
g6wj5ciDLAvHGHx1j96pu+R5+QexldmK
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAmcztX3x79jjBkzZhieGWPGjNmemSkzz8w8zyiERMpSVFKWIlGS0mKJ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         "],
         VertexColors->None], 
        PolygonBox[{{13543, 12540, 3241, 7374, 9671}, {12878, 13558, 8402, 
         11302, 5130}, {13587, 12698, 9328, 7289, 10638}, {13550, 12593, 2724,
          10649, 8130}, {13556, 12865, 5129, 11300, 8401}, {12621, 13546, 
         11280, 10640, 2749}, {12545, 13542, 10268, 7405, 3362}},
         VertexColors->None]}]}, 
     {RGBColor[0.7629498222241303, 0.8471043187164284, 0.9138881679292966], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHd41VW2909ieghJID05QCInQEiBJM44dqUqoKBYR8cuIKIzI4KVIiqg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1mnd8lUX2xt9A6r0JEEyoBkggQSC5N7dY1oKuK2ABaXZFkbWhAqL0IiCI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         "],
         VertexColors->None], 
        PolygonBox[{{13548, 12591, 2723, 10648, 8129}, {13552, 12635, 2767, 
         10726, 8132}, {12641, 13554, 11293, 10703, 2771}, {12619, 13544, 
         11279, 10639, 2741}, {12581, 13538, 9614, 7325, 2830}, {13536, 12555,
          3525, 7474, 9762}},
         VertexColors->None]}]}, 
     {RGBColor[0.8279332444466995, 0.8687745584830519, 0.8847756530073505], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHeclNX1xt/dhVm3sAsziLDKsrALO4WVhV0Vg6AmJrE3RA0WiIIaG1YE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmcz1Xbx7+MZZgxmNFijJ9hlt8wlvktpTtRKqVQSfXUQ7lDyB4RLXe6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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8929166666692686, 0.8904447982496752, 0.8556631380854045], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHl8VdW1xw+EhEAGbpgSwiSS8QYI3NyCCM5WxQEUlZkwOBS1Wuh71vp4
FrGAINK+92y14EDRJ2FSrAjPTg6VEnCoyCSIrYK2DrQgqEXs9H7f/BYf/zg5
++6zzx7WXnsNv7VO+kz/1uhbWidJUpCXJDm6H9eP4rIk6afy7blJclnbJFmt
8vRUkkzTdWm7JKkpTpKRqm+jtmv6J8n27kkypXOS3Kz2F6n+QbX/ekWSFLVP
ktmqG6G6E3rnW7m+8/vjVklySzxbq/ZvFOl5gd/5VcrtaJPpkySb+7n/B1T3
HT3rm58ki1TfT2Pfo/rZqv+wKkkuVn/vZZLk/Yz7OqdDktyv/hp0vRL3NVrk
dVrrYr3zhspLo8+01jJOaztDbZ5o6+f3RpvfqL8tuq5Rn6u01q2aT4XanpdN
kgt1faT6BwbqPV2rtJYJml+l+umpdx9qkyR/13i6JVv0p1B9D1N5sdqu0HVB
4rV+GfRZX+w2PbX2vzQkyVFdr6n/WYWaj9YzU/eOuharvE7tdmhee3TNUJum
bupMdSJLMqokSXKL/XuhKv6qeY8Vrb5Q3XFd8zWXT3omya0dTc83NM5uXZvV
z69TbleQ7/2Alimt94jal2ncp/XuLt136qrTvq0elCSdNYf9alurfflVP491
XP39Tdd2vb9Hc35Gz/+ufjadmiT3DdD4XdSX3tukq1Ft9qn/XdrHj0S3w3me
JzywVHRar2uTlnNAde/qmqE59NO47+jdAq1xkZ4v13Wa2nxTz97W+w+rvEJj
zdNYzRqrtsj1q7TXS1X/PdVvVP0lPURrzfkC8Wyj1j4lZf5erfWtYY2iw+ZC
/x6id+/RXKemTJPqDq6nzbmi+VjVL1Z5nNY6Qe2aVT5T7+7TuE2cF813bcbP
OEeNMdbUGJc+R2o+hzWfkZrPJ5pzvtrubetntOdMfSRajetl/tyb5/4f0nrv
UJ9HRMONosEsjXOrrgvYP11vaU5vqJ9pHczfp2o+L4gOPxUdUl2T5DbV7dG7
T+jddzXn/84zr76lsXar/mONdUPGvAvfpkT/Y/zWfI40eA+g/+vaszf17hqV
723rMnPjvjfKu/Xu5To7n2lOY7TGT/MsB+5t4zKyZaroOUVXStcf1f5atf9H
e5/X20IOXFlkXnk49p0yPAOtGYu5zNG6jmr+L+n5smK/y7l/T3N7TjT9q9ou
0Pl4UTTfrT7/obW00lg7RLN7xM+Ldc3N9/3NKC/UfY+uO1S+V/cBOmOLxfN3
9/Ez6pfo/gNdd6n8ruY5XP01aLzdp0iuqX2t2s/JjzrR9mdlPlNnt/V7e+Pd
oWp7mq7/UvsFqkurvIhyyvICWXG3yk8iB/XuDRrrC/UzQ/czSiyr1uX67C6o
9vktVXl+tWXOW5rPMPVZpz7fFO8NVvnlQp9t5gNtf9LH82AOe9tbTiIvl6n+
QV1LNM/taj9Oa+yg+n5FlhH0wfN3os1u9fuk6nfp3kX32zSHZs6yaD5Q14IC
83VjtXm7h+pO0TW3wGt9qtjtkZHro8wcdwXd/ix+/ETXt9W+VjQ5U3P5gdos
1fjDNf/7OvtMMsfFbSzfOFecqWtTPoec7zc1v8/VZ3+1fU51V6jNvDzX/TXq
ry+KNolpfVxlkTLZWOjy+ra+fxHlbxT5Xd67VGvs290y/BC6qsBjPKC5P6hr
tH6fUNsvdT3V1uvYmu+1pPK9Bua/VW1f1XWd2q8TPdbq+rPotkhzfSJ445wS
8/X6NuYR6j9Xm3167/e6btK7c7WIY3XmbWizJfqfqLbj23vs7+e5/9NbWw+h
g8q13p1qV6I5DlW5ROemi6696vO3XSxDhmgO12jNuarbpX7e01k+S3v6d/V7
tcYfo2uont2pOXxS57PzrOp+pWuq6m8qMh1uLPI54dy+l3j8e0MPHtKzyQWm
0/yUadFP/YzQGGeqfpHK/1domkLP99XmvZR58i6N+1mdz9o1qvuE9romaPyJ
GZ/byeiojPuaEnYQcpuzy/M79e6r6r+Vnj2r+pVxPpAtHUX/q1U+lmceukdt
D2sdNxZ43TvzvTbmJjZNDhe4PXvQqLlN1rW2s9cA/f6id5/v42fUwzfwD/1+
g/3UdZ5+Xyo6z9W1UM+nY79k3I7xGHdOrHd6rOed0iT5g67nOdfSB0t1jVH/
L8queFXXds2tOcrdta4r62UriIdv5ixpLtMrfL6bZFOMqLWN8Yp0y3vSMePV
136V/6zyDJXP0PttW9nO3JmynbJO7bulrA/Whr10SbQ7oHeP6t1Zene9xr9Y
9W1U31ftX8g1TdZoz1fHvj+mteZo7feoj3GS/aWdtC+a252i/xxd/1T/h3LM
y5Q3iR836vqF6HKh6rdhFKv/sXq3q97dpHfHaL2/0Xq/rfWOVfkllf9N5VVa
78Va79t672DKZ4EzsVuydHRa50DvfpaxbEIuTdb8G7t5vcgD5ALypFzjXKX2
r6n9gYzPJ2fzVdYu2i5X+wnSEad0M83fVv0x1a9V/TWl7nN6qdc6Ku31MveR
ac9/u+Zzqco/K3Q75sE+dCj2OcVIpW6Vrkm6pmqNPXTAX8du0RovrbVs+SzH
z5F7k6Mt/WyqFH162FZlP5FztMHmm9HePM9aqcfGGB57qKOXFGJv6npRe3lW
yAn4vTl4Dfu5NXq/yOdrtOZ/m2hRpT7TRbbtzlf7m6U3evWynQifNgffbutm
PqaMfQGPLVGnbwRP0/93y9znjsR3fv9Sc6/VuntXeg1HW3s+HRProO8W2UZa
oYpStXsrx3P8TpHtjduL3AY9tUK8e3GOefqnat+51nP4RDS7Le11bNVceui5
ti2Zqv2fkjE9tuS4XuRJTlP7vprPZv0eIp4d3GCdxfOtsUbo2iNou6a35EGt
bWbWPTbWDj1e6Oa1NKvPczWH5dq7ERrrKdWfrvqs3jtV9Pyg2O23xTtbo8xY
80rN75xJzuZTcT65r49+nowy82rUfCfrekBzXqD7fF0rVX5CemOdrrwOpi3n
H/31mOoe1ZXTwboL3Yb+OjkPaPXnxL8pM86TMe5c8cOPOtmfQY5Qj8xhD1+M
tXfX86u19r1a+1mFttfPEy911f53KTOdz5QMHyX+m5fv++VRhieR+ex3k/Zq
VeYrG4g7MhzddSL0F/oA/xL5Qj8jdfVrbT22OPw7zudK9FShddE1IZ+xXbFb
kTPYsPzGBl6i/v5UbL9mbcp7xVnATsZnxrd9Vowzo639F+yR42EffiHbvkg0
OqY+S/TOZ+3sI9dIdj6ntXyZ5/7of5nqZ+V5DvS5pdB91oiGTbkeC9sS2/BA
O6+zbbHXiP05Jewr1sI1LXwffKZx4Te9JV7aV+pzhwzAZsBnqQn8AT+oKeXz
zR5NC/1F/XHN+YtBfoc+x+jKa2W9iAxC/tAn/aEv8IfQnfw+Ve+10Xo/z7Pe
eDhj3XGB+rhQ1x2af2+dg9HdPS6+Nf1jU01X++W6BrS3zVkT88G/uyDerS52
P1XFvqjHx0E34GPiX2bVx/W6xmhOZbr/TnN4SO9OVV9T2trWWih+fBC+V/tl
3Vx+pdC/l3bzXlC3LNpUNNiGxn5eGvV35VkG4muhZ8Eq1gVesSX6oc3Vkv/d
NOhLmuetmuMjhfbd/ley52nJi3MKLZuw7aDrxWp/g+q7t3JbZAk8c5Xqh6r+
5dbm1UeiHh5/PPh8RL3lGmcNfdIU+uUdHdYzar132Qb7CfgI6Jem0KFNobMo
w4M/CT5s1poOipYX5ZgXD0QZGxFbEZsW3uF8Ye+tF72fyvgZfHpt8Cpn8Nrw
C07ovPxnR9sY2BHsy4HEd/YJnxp8Zmrs17nax56SXdepn2wPrwc9giwDI3i7
nWnPHfp/qf5ndLQfB63wn6E5NIJWqNbZ4sOR4sPe+ZaVI2KdN+rd/er/3yvs
a/PujlZ+r4XWbVxHv8gK9mFJ9P+3nvbH0FMftLXu5Ywg15Bv2oLkP+HjlH0Q
aAl9oedB+f2LtM4C9Xm15v69Gvs7q8SrTWWeT1p7UlvsswDOAt7C2WnUe29q
TwvaW05Pq7Os5r2VZX4nR2v9pvp8S2v6sdpMrzNeho5B7+B3zJfM2NXGv28S
fWaqTY3WMzfPGM35mudYrfFs2XNvqs2lVZ4T8xmiNQ1O2Q4ao/nPqbGPgH+A
PUe/zAXshTP9mPT4o7r2tLHNe7rWsjDPeA24DbIO3252jX0TZO+vc302t2kO
ieYzLHgHHoJP4EX8LGQwfZxb4352qf0mbC/VV6Tsi7b4ELLLd+Hzt3Efd0Y/
2LL81vDJy3r3Sa3zpjbG8GYW29fFVlqTso7AHwQ7QK9Stzbq/xS/4RN4E17F
70QX0Ibn27R3ic7LX9obwwS3BTPcqf18VzzRrrVlxHfwzQv9/NfRhj2mfDzw
SJ6B24zRnPt1tB14ep4xZfDkj1q5DJ7zfK5tRewr7oVRniAeGF9qexg/cZXu
7+vdXVHGZ8ztZlsZumVTfn+Y5nmW1lKqczqtnf0jfKMmtfl9g88w53eI7jlq
M76ddfmaXONsS1V/eJDxTewV7BZsDc455x3ZhQ2ITcP5mqq2n6rfju3Ne6li
8+S16BBdfdr53LFO1rVYdQPxmdvZFhtV5314WTS+X/XdNNZQ0e3Tcstt1ohP
hTwcJrulKNb4NdUVh409uqfxPuzwK1QeJj55XPVX9jSGyLqu7mnsjDlsKTJW
D170qsb9rejQ0OorHB85s6m1y+iUDVrfM7p+XmBca4Pef7rIPE4ddsbwnj47
nCHOaE2cU+wS7AlkOLThXGKg46NQBk9gHawL2uJPoA9YC2diZ5wL8FiwD/Q0
GG114LePaNzBvYwXFYp+B7SWm3KtQ5rCn+E8zY0zhW9/UXvjDuhB+HlsvukJ
DzGP53Lth0JnfNB5KesI/Hj8f+xAMAmwCTCUtMb9pq6/aYySErc5FvgK7+KX
cp8f/dAnMoR65DJj4Z8Obe2xkc/UPRf1YGxPBM4G3ju9g/UF82A8sB10BXEa
sC+w1pKTcxB9NnS0TwrGBs6IPqLv52Mszs3zsd4nelpuIjPX9bQOQP6nYmx0
4syssX5w/n/POqZCPGVMieXsYM15tMpvhj1cUug50wfP34827MP9BcZtiQs1
9HFs6CmN29jRvuHPVH5G5QH5nvvdMf/hJT4PYAaMe3WJ5TuyiX1FD4J7gn+C
dfcS/x4Wr3dpbdzwvdAF2IzYlMjhw120R5w5ze27WcdjiMWABYGXQauJ6mdS
g+e9VjTbAz/mGi9mvdRx3xtrZwzmtTPwD+QJPmZJYOHs3X/kupzT2nS7osT9
csaGBR5+c8hQsPBvi9ce0Px+mRib+mGB8Sl0wj0R35mq5+donr9Rm/N076pr
jp59B/tWz15KjDu/oXEe1hxGlrj8euLf21OOd1G3I+qxN5eGLfpI0Jmzc3mJ
zyr2OffdUd4fPgb+xSvax/UR16ss8lrQBZzhOwPDYS/QidjwzOeyEs+D/omB
7QzdBh8gm8FmZ+YZpwUPZCwwN2JKK1OmVVet91St/UGNe77uX28wvfALaYP9
v/8UxwzAVdFXF9ZYroIb459iu34WOCzjVoctwtw7iZZvDQTQiDGjT3wayszl
Xw2Ws8jYHRGzxPYjbkOZM1Xc1WupUfkXGcfJiJFtEE9OU/1Olfec4pglMYCf
6fmlWdu65VpjRmM8kmsbeFHEmNCV1+dZb2JTYltiD3LW0Unw8wVhB+G/4EdU
RZmYUU7K5w59Rxm+BQ9pHT4ydW2iDfwO34O7gpNQz3stMZb+xqKJsYALgwm3
xEP6u/2JGp/Vbbqe0FpGaC2/J847yHYJNslbaj+vv/10+As+o09iEff2N/a7
v4exy4kVxnKR9dgOPD9R5zbYAXOifqf6Hikafqr+zy22POKd11Q/XnM40t72
MutFFg1R/6n+lrPflM55qbd1XE+1v1l79liedSu4J3oTOQ+OiT/OGeIssfYx
0QY7EP+cGPOh1o5v47/xu1ltylNf9Vce7T/QvA7pegX5M8jxWmK1E8uMJ4Il
5kaMkHO0X23f0dUMVqnnk8qMeaZ076BrJjpN9xJds9pZL62OOZ+rNf68t884
+mt1xAvQmbeGHYj9W18dNjB2dZlxVHC2GREjZu7dYi3pPo5hE1P+g8qL+hsr
qNI6ikXDE3nmnZzgH+R8RdjJrIcyOhNdiE7EDl8TcVv8bjDYzyMug86ZFnpn
a7THtkcPzwvdTX99o0/O68o4s+gi8iHQR+hi2qAfj+k8HtXV2Nn+U034UGAf
1YEDUFcb9cTYMinbY4z/ZMwBv7U2sIXTejmGhz02ROVbOtqunhb90zcYERgQ
eE1exrwL32J3/ypsb3xO7PoPW9mWwaZBjmHTZGP+BVGmHj8JmxV7FVsOOw6f
Bbus5Zn6GaD97K/rrnaOTwyO9thsXwt7qQ30Ys+KfbFe5BgyHloih6lrCDpw
ztD52GD4jn1q7D/21dqv7G6fBR+FuBjrubaT/U78R3xUZBh2EfIM35bf2Jas
hblDd9ZxqJX9mzXh42A7LAgd8qDGWlJn7G+udNOo7o7779EZnyA91Sx+qUam
51q/pKMMNon8xT/Ep2NNmVj7NPkiU3X9b679B84A/P/1rH1j/OINktszVf5F
Yn2D/8zakSnIFmKYjNMU46IjpoW9h11/W3vTEP9gco19hCOa8y16VlVkfh4e
dlELz5Z43/GVZ7f33p0eGCI6t8WfKPH5wg4hTwj+Aecj3swaeT482swIH5hz
R8ybNshk9DT6mvwY9DT6OomYPDYKWOlHkkMXYyu3s323sMZyFd+dPWZ/wfsv
qbP+vLDBfho+2tgG+3X4dGBv1cVfYXHoLDBwcoLuD/mJrfdi1vbextZeF7lP
ta1tr2EnMF/sDGwbZPPIsDfAh1nXyNBpe8KuA49iX+AFbDTwUPzGH3T1c/o9
0WCfEH8QXBE6YAvd3Vft6rX/ZW63JuZwyyBjhWMCY55QbLseXwefB9kI9oJ9
Pztsy9FhHzIHytiZxBnvi9gk+g89SPxuRta5I+SNQDf0PfR6v8h6F53LuX8l
8qleGmgbEfsQ7PfxAuNDrPWKGGvjQNug2J/f13rnNbjdT1Q3CT9I7b+ntU6s
Mp45B5+iypgVMhLsCTnJOdid9VnAPi0PG/Xk2qDRrrD/4Cn86RvDpyYvCV2C
HiHX4Zyg1Ul7Gh4GE2Us5AD7cHnsxU/FY/9VZ5y6SmOmWQO+jO636lpeYDz/
zOABMD3qwE7gizOD58Glzw2flIs5cJax5aeEPQ+utqrA9hd1U8MvA1P5eda4
yg09jWHBz9iS/521PQnGDk6FPc/5uKzKchBeZo30/yft7ce6ZhbYB8IXwrcq
ibGYy0LyeRo8D/yeMeErcfEOMU5kz6zI88N3nhwYLDHDLpWOG67QOI/rurrA
Pm5J+ML5EatvyWuKPYD+xKawdbBbwBPYD/Ziotbyj7R1yFVFzvvBfrhN9afU
GfPF5sX2JVbGHi+L+DV1z3Rx/HRjlLGN/6fcser5sec/iLG+qz771Dm+cl+5
Y3XICrAwcozAOsgzooyf9aH2olud8wXpe0P0Xxf5ZuBvyFl8GDDMSer/n2nr
n6nhJ2PPH+McaR9LOZsZ46pgqp9wdlTfNXIzO+mqzzEO/UqN8YGHxeN/ULu2
re0zEmck/kWcCf2H7nu31LE96onzz4vfT0uPHUxbrw1o8DyYwwbV/zFtnqfv
W7Lu/+5S63bGwF7CV0fXcGctn6PHC5zzhE3NGjtG/WVae7P6fEbPRqq8N227
FRwI+YKd83LGa2a9c4iDqHxJK9uJS7SnA3Mcv8PXJG77Qrl9RfxE8L9xuo6o
zZEuzjUAD8QPwx/DL7uwwjoUXQquD74Pzo99iC2LHbuli/NXsGfAnSj/K8e+
Pn0TVyXmTZ9gfYNEm4yugwWOI+IHgp8gmw9HHBA/FV2LTfrDrtYBhxPbDcRd
7opxGBts+dwC2wJgDR26OvcBOwF9daTAdj9tJwcW/ZTodHHWz5gz88X/ukr0
uLLU/H+XaF5XZ9wXvQAGgT+FPcJZwQZDfiG7kduXl9q3h9bI1raBDSK3kKHQ
kLr8qEcnog95B12WFxgjNiD2L/REn/fPWqfP1XzSdcbGUhnnBpEXhGxseV/t
70TP19kvQraDfePHMRZ4BP4RMgqMBn8NGyI3xsU/xs5iXcRVHqsxFoQNhg2K
XdQmbFBi99/XWP3qnGfG/vww9PTeUvMd8WX8IfInOIPw5vVZ8+e0cucB0M/+
jPFZsFnOa+fwoYjfLSqzjqNP4sv0O6baMXhiZvhPt9fah3pKdflpx6WnlzvX
hPjvbOnK490dJ72in3MKsa2IC/26xucR+bk6x3mYxCuIW/TSfF4r82/Kh6IN
cq8h7KA1EQteE/XkCP+mJvItS517gYy9UvPZ1tuxvBcHGj8CO0IO8xwoknO9
v8Jne0PIYJ6Rc/FG8lVuxtbIKwCPAZdhjfARtiG811fr/XG5+Qp7Er8NLIUy
Z4ecYXw64qnY5Nw3Rz2xbnAfbOOzqk3TswIHop79Ahf5WoNxEGKb7dOOXSC/
iZcgw/EJKKMHmDfzzw0c6dmYM3F+fmOnzZHubehknfY9lTOdrLsymsOjGqNT
ocffFHMgtvyHGmNB7BFylpwRzjF35Dp5vuBQZTnOFQBTOj/ylchbIu6DP0qb
poi/nB3tlwcGB19dV+58a+iDrbsqx/r3UJThGWR2p5Db0GpfjmnYR+9tSRvT
Hxrjol/wffrnOKeC+aRzHHPpG2Xm1lhqzIB2xaHHyMcAHzgn5kYeBGODvZ8Z
ORnMn7WfHTFo8kWaI88A2fdo0An7dEelsaFNQd+W3Et1tq6j80Y4f/fEGcTe
Jf6A3hlVYR8NX+36cuc8ke90VT/nyCLviMOCv5GbirwkRw7ZAt+CXbLvE7TP
f087LoXvQD0+4DjVf5m2rByr8om05ePpkRcMxrQqYlfQDb9wcqnpjn0ADkis
mftO4q6JsTowO0Ig8CC8Bw7Pc9oVBv13RZ83al2PdHQ8Jbfatgt2y79ljEmB
R20L7AOa3NTdmAt2cjr4jH1EToAdwC/k0cEHYIM/0p+pov8I0fE0rfGhtPM3
V6jvnw6yvfhhxrnj5I0PUZsH085ZXh39wXvYKgfCPgGjGlXq3CvkD/qMHK3i
wKPIK0DHjw+9T6z/opjr/Crnr4Pnt5F8mRj2weTwuz8mlhFYFnkOrTW3Vhnb
p627ebwd0eZo5H29Psh4H1jfYM1/Wdp5be9ljUmBR92o8z2y0jJ2XuRVkhfx
r8j/Qi9/o3tglPnOm7is0m3Kurk9az8YdMCWBhNrDtv4zt7mdeQqNOX7Gexw
bBH6x8Z7Qf1/o9J4HblY9EfMnFjiX7KOJ9L3wcj5JA72x4iFlTUYBwcDJ8fz
+krjhORv0Qcx9yY9f3ig82j+OcixNN59XPeHBjpP/H7xwzV697IKr+mdoAP4
EHuMDckepmIfG2Nv2Bf2alKp588ZoB4ZsznyjpBdRXqvMPZuSqnfP7mnhbFn
+JdHs/Yx2Xv65TunydEeWYSOLo45zI14OvoFvqAv2kyKdz9I/Jt6+IH2M0Ne
kftI+fzgt/HRnnGmhOwrjD6ZM7lO2AHkMdJ2QrSnTVFgs6wfGjHn7lpHua79
Bc6fpA75Ca+Ss4hu5tm6wIXRtdSRG8hVFTYMOBr4CjIBGY+8JVeB8wON6LtD
0IQx0NtXht7HJrwi7MJ+WvTveltHdA7fBBrynHa/S7zmkqDhxNjP40HbjkGH
cZEvxpyQ8cj6spAHPUM3sZfIge5xp39sg9siT5O1gQW+W2M8EEz0/2qMi0Jn
css2h28E73FG+AYJP4H4HbjtscBpuY6G/T8/4nzQ5nC0b8m5FSEL6ownIS/I
Qcen5VuaDqEXlmb8bdgqjTVYtNrR2+sqjjbY8+CI22pstyAr5kc+JXFo/Av8
DM7d8NhrcEnydrC7GsnDqrSM2hff16D3F0Q/nDW+jyAu+HDEucBYyQV9JmLy
+E3QclTsV32MyVjMsTjWsqDcuaS8i228JPwXdO9JO+VAoeNAxHeGhm4AMyQW
Shkd8UHk32EzLAk/CHwLO5jf6ExyoImhgvXhU5M/vjzseeaDPED3pmJuz2Sc
w0f+XseMvw1r+S6swN9QgTMsLHdODLYc2BW+GjZvc/hc7DV73hxl5Nqh+C5j
c8Y5keRD7so4fk/sHl44HPyDLH03ZPVk7cvZlabn24EVtORnFpsW2BUXht5E
n+J3PhvxfXCVuyot14eLxx5NOz42TOUVacfTXiUPvdJ++PMR9wezBZttiUur
7xmDnEdIDuH88Pfhhxf17oxKn0v4b2rYGOgW4i3EFLBbf5y27Urex5bIyceG
/VHadiznDdmFPOH87Qs5NrHA3wKRA4t/szfO3d7I7aR8jehzQaX5Bx7cEHyI
T/P9SvdHng5+1iFsIbU/r9KyfQq5ypWWk/Dd3aFHWOOCyANbP8hxQWKC5Ozf
UGn/a5rePb/SffLewsAyyOW/sdJxKOp41ivwQPwo1o7+hIboP+b8TGBQNQ2O
pxJL5ewwZ84PdJ0W+uhkfgy2zaqwuSl/oXHnVVr/krNyTayXPCfagD83Rs4S
2BoyCDkA/vCh+OOBcr83hhzntH1ZfIsjtZbrfauMs7C3xdX2pfGjV/DNY60x
mxMDxKfl9nPJHV0YtjF+VXP4UMShsAnB8AfLF1tebjoT298S9bOqnMtOHjvY
5MuR94cvTR4Jfnen8IOhE7Yvfjr4Z58qY0PQlPGxQbHZiKUiB5AbH2X9TQvf
s3BW0M/IFnK6sXuQ54dDNrfQqcp2NuO0qzZWCE54RpVt8fw4i/TPeTyryrY7
dnuHamMBzP2+rHFMMMw7etimwZ4h5oI9gm1fWe3cRPISl4Q8Q47R92vR/9Ks
sVdwV2zpvqF/p0TeaIttL/n6Tq11xIqssWZwZmIxL1Q4HrNd+/V8hf2e0XHm
0O1geMSowPFeje8d0JWze9guxyYvqrJMQZ7wfQB6BVvuknrzInyITbkt7H/u
L8devJR1LJk4Mn4TeBlYWX6V7Xhs+Oasv/vlm1/ilrujn4+rrC/RlfuqjIGC
f26v9HcyLd/I5DhXgr38VAy+updzBIhN7I6xkJO7gt8+zTr3mrzrtlW2xbHD
p1UbLwYrbldlPwQfBBlMvhpnEZtlR63tll9mHfMm3o3+JHeW8wf2Ce4P/olO
Q7e1AI71tu+RD6PCBuke9iQ2DjzxcqW/tyGX/4jW0tTL8fxVYdNgz9QG7yA/
c2IM/AKwu3djrMIqy31kPhg18og4CHkEq2ttZz4Z31Wgr4kZfBD+zxfgar2c
O3WH5jy7r/3eHoFfgF0cVZtVvZwfgR9I7BDsqG/wI37l0Dhn6KmayKPDViHv
ATsSf3VZ5KGDYU6q8rdM8D04PboCjP3pMucCkneHD70j/FrkwaTAAsCPwYvZ
F+Qo9chD5HJjYGXQrDp8sWOi8e1pf2+KHMevOGnfUUYXExtaE7E2+pscfbJ3
+Jbo6IM6U8crrA+xJ7GnsamQwfACspq2E6N9YXyHdTTo1Df0+GLx0j1Z54bs
ijMODWk7IfwRdGLXyHngu49ZYXsz3wExZ+Jt5NYQd+CbtFci1k5svzri+xPj
OxNi3i3ntcwymngTWCA4BlgH9Zxfcvk7V4a9LTk0NmPsgf/xcHvEhsjTr6gM
X6zM+RnoaPBRbC9wKnItkB/YeOQWgH2AfYFzwNNgIGAMHWvNwwOjHj5HNjZG
n/virIApESNdGXFS/Azo3+LLiKn/WuFY949F1x9l/U3qdZr7tRlj5MS7yM8m
1rkycs5P/t8J8lE584/1dmy9JcZe7HbkMNF2VbQnTtYUOefkRhDjgW+/lfF3
lXxTObPeNgT8Q2wvFTgI/EVOMGuHlhvjjCN3qAcbxw6H/7Ed+CaIZ2A1LXWR
I3tfpXUzenlD1J8d68B+QHbNqrf9BA3BTKgHp53P+ioc3yCfHAyXmBb/k4Nc
wJM51E3B08hrcm3Js30h429u+d6WvaCefeFbIdqBoY0Q7S/KOp7xhNquy5gH
sZXAK5GH+AKUscu2Z/x9Mt8m99Tmj09bhvK90WcVluvLM/7mme+dv1Vvu5nz
dW98o8B6sX1yI7ZITJcyNg++JD42diDYArjJ84FplAXeMT7ajAteWhXfI/w2
Yiz4LNjOyDj8EXwUbALs8CH1trORK40R30QmDapy/gQxvfuqHVMhngL/p0Om
7wh8DtlALuqNtT4v+xr8vzb4Pxs19bZrsQ+7Zf3tNN9NN1aZXtBqcpW/TyOm
9Lpk1B9PdbyHvI5XK5zbsbza3zwgm8nbvaHWsac1J/G5Vv4uM522rPm8wf9b
hP8rUlFvHxJZB/7O3JGrxICJFxOX5dsR9BixeM5GTeRRYEuR30BcgO/vkcHw
amW9bXT2BX9+W9g5TYFtklvINwoHQqeAee6KenyluvBVGRO89Y3APQ+GPhoX
+A12MN8QrozcoG2i39as/+9Lbtb/x4H/4TCgyjk62LJdQu62yKQi26r4g+gj
xkLt9s76/1PwvymKw0dHVvEdxi21xt9Ya128e3e1Y8bLIg5GPIwcGGxBvosA
f6iut9+Fz1VVb2wOHOTNrP+PDP9DBnlzZejKw1W26bHnkXH8/xRigeiRwsCF
iL1srjUOQFyZ+DL5sdzhTfz006OeMmfiQGB9w2Is6AwuflWtsfG7dd9YYSz8
SKX1K2vFJtoRehA5gvzAN1lS73gAsqs+6//Twf/o4IxzvrHZiL22/D+FHN/3
RnlRteN/xP7Iv2uJmarP/wclCk5D
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlY1WUWx99UFLyIZJiKc0mEe3HBC9z7E2uycU1zKdNQ3HDNfbcaa3zS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         "],
         VertexColors->None], 
        PolygonBox[{{12486, 12443, 2774, 12707, 12485}, {12690, 12486, 12485, 
         12692, 2721}, {13589, 12705, 9329, 7308, 10702}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3ts1WcZx9+19MB2Ttu5xVjaHgqm5exwUXpOUbM5ndHNW4zRAb1twgqL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtLVHEUx482PtKyZTDOnZxwvJkRzr3TA+y1aCyjNoFNNumIOgQFurCi
TZuysIKIUKPSKC2mJk0jK6Ogghb1F6QQVPRY9BDMoHb1OZzFF8655/y+53se
M5G2rt2d+SKSAAHwYoVIsSvSVyYSKRYJ1Yh8d0QqsC/wrd0TaQMryd1SKhIm
/pP4cIG9OYjfERaJLhAJLhFpIbcZ5OeJbCQ/hb0PHCgUqcMfxR4DTdjH4Nge
F2kASfzH1LhaTe1qq10D5yB2BFzEX4XvUO+HY1r123P0F6H/fJlp7oOrH+yH
r4BGnxIfcE2bQ3wPtRsB6bKeHIfGNgWtVnKRyHHy612z7xWJlFPvG/VyAasx
CvcYyJZaj6d8kdPgJv6HhcwPvgTz2EWtRjjC+JuDpr0Jfyl8Xx3T0gvfTrju
14o8Qc8cHJ/R9gmcYDad+Am4t4Ik3G9L6As7Bb6Q30/8CrMZj1ot3cEQXNmY
yEyJ7ayZ3BbfcpVjGR/rw9ZbijcPiT0CU8Tnib9GzxvwEX+K97NwXQbzcOfx
7T3vp9E/gr6ZxcTwc/j/2G8GP83sCqvM1pkNwzUCrum82Mca33rWXn+hcS3+
Ot961RkM0c9E1LSt1pp6S57l/qbGDt5O1Jq2Ob69ZF+XqBliv8uZ6XW03gDd
lTbDJG/3erZrvcGGkEgPNdLM/ijv7xLLeaZNb/I2dtaz29Sb/AvXH3AnYDMN
Ur88brXbdZ7sc9ax2gNwDqLtVsx2RSk5S+65uN2+7mwC7nHPetEbPUPvvb7d
jt7UuwqRZ2hvqjSNh+DPhG0W2qMHVyxuu9IdddHLNtduS2+uDj/l2m294s0G
/FbXtE3jT1LrgW+/Dd35EezDvvWiO0qjrdWz36723EPspG+96I13EMt49l+g
N9ENt1tlt6D/Cf8BfRmh3g==
         "],
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{12442, 13384, 13385, 12966, 12968, 12967, 12557, 12972, 
         12973, 12969, 12971, 12970, 12507, 13474, 13475, 13171, 13173, 13172,
          12608, 13338, 13339, 12752, 13386, 12464, 12663, 13512, 13513, 
         13360, 13362, 13361, 12629, 13237, 13238, 13234, 13236, 13235, 12508,
          13460, 13461, 12974, 12976, 12975, 12576, 12801, 12802, 12753, 
         13109, 13388, 12465, 13387, 13110, 13111, 13026, 13028, 13027, 12558,
          12704, 12705, 13589}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12443, 12486, 12690}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13015, 12885, 12886, 12884, 12888, 12887, 12571, 12890, 
         12891, 12889, 13451, 13450, 12487, 13147, 13148, 13146, 13150, 13149,
          12597, 13124, 13125, 12708, 12709, 12444, 12422, 13187, 13188, 
         13186, 13190, 13189, 12623, 13192, 13193, 13191, 13485, 13484, 12488,
          12893, 12894, 12892, 12896, 12895, 12552, 12791, 12792, 12710, 
         12711, 12445, 12423, 12898, 12899, 12897, 12901, 12900, 12541, 12697,
          12782, 13562}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{13568, 13539, 12582, 12814, 12816, 12771, 13119, 13410, 
         12481, 13408, 13121, 13123, 13078, 13082, 13080, 12566, 13090, 13092,
          13084, 13088, 13086, 12526, 13505, 13507, 13287, 13291, 13289, 
         12618, 13357, 13359, 12773, 13412, 12483, 12662, 13471, 13473, 13094,
          13098, 13096, 12570, 13106, 13108, 13100, 13104, 13102, 12530, 
         13430, 13432, 13010, 13014, 13012, 12586, 12652, 12654, 12596, 12646,
          12707, 12485, 12692, 12644, 12590, 12650, 12648, 12568, 13006, 
         13008, 13000, 13004, 13002, 12528, 13426, 13428, 12994, 12998, 12996,
          12584, 12990, 12992, 12984, 12988, 12986, 12441, 12463, 12751, 
         12749, 13145, 13143, 12607, 13335, 13337, 13329, 13333, 13331, 12506,
          13457, 13459, 12961, 12965, 12963, 12547, 12957, 12959, 12951, 
         12955, 12953, 12439, 12461, 12747, 12745, 12800, 12798, 12556, 13537,
          13541}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13581, 13545, 12620, 12673, 12671, 12494, 13414, 13416, 
         12913, 12917, 12915, 12573, 12909, 12911, 12903, 12907, 12905, 12427,
          12449, 12719, 12717, 13129, 13127, 12599, 13315, 13317, 13309, 
         13313, 13311, 12492, 13509, 13511, 13303, 13307, 13305, 12640, 13299,
          13301, 13293, 13297, 13295, 12425, 12447, 12715, 12713, 12820, 
         12818, 12588, 13023, 13025, 13017, 13021, 13019, 12490, 12694, 12696,
          12636, 13553, 13577}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13583, 13555, 12642, 12703, 12701, 12510, 13422, 13424, 
         12978, 12982, 12980, 12578, 12804, 12806, 12755, 13390, 12467, 12656,
          13525, 13527, 13379, 13383, 13381, 12638, 13271, 13273, 13265, 
         13269, 13267, 12512, 13497, 13499, 13275, 13279, 13277, 12610, 13341,
          13343, 12757, 13392, 12469, 12658, 13463, 13465, 13030, 13034, 
         13032, 12560, 13042, 13044, 13036, 13040, 13038, 12514, 12681, 12683,
          12592, 13549, 13573}],
        "3.5`"],
       Annotation[#, 3.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{13531, 13533, 13547, 12622, 12679, 12677, 12504, 13418, 
         13420, 12945, 12949, 12947, 12575, 12941, 12943, 12935, 12939, 12937,
          12437, 12459, 12743, 12741, 13141, 13139, 12605, 13325, 13327, 
         13319, 13323, 13321, 12502, 13493, 13495, 13229, 13233, 13231, 12628,
          13225, 13227, 13219, 13223, 13221, 12435, 12457, 12739, 12737, 
         12781, 12779, 12538, 12838, 12840, 12832, 12836, 12834, 12500, 13444,
          13446, 12866, 13557, 13585}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13540, 13536, 12555, 12797, 12799, 12744, 12746, 12460, 
         12438, 12952, 12954, 12950, 12958, 12956, 12546, 12962, 12964, 12960,
          13458, 13456, 12505, 13330, 13332, 13328, 13336, 13334, 12606, 
         13142, 13144, 12748, 12750, 12462, 12440, 12985, 12987, 12983, 12991,
          12989, 12583, 12995, 12997, 12993, 13427, 13425, 12527, 13001, 
         13003, 12999, 13007, 13005, 12567, 12647, 12649, 12589, 12643, 12691,
          12484, 12706, 12645, 12595, 12653, 12651, 12585, 13011, 13013, 
         13009, 13431, 13429, 12529, 13101, 13103, 13099, 13107, 13105, 12569,
          13095, 13097, 13093, 13472, 13470, 12661, 12482, 13411, 12772, 
         13358, 13356, 12617, 13288, 13290, 13286, 13506, 13504, 12525, 13085,
          13087, 13083, 13091, 13089, 12565, 13079, 13081, 13077, 13122, 
         13120, 13407, 12480, 13409, 13118, 12770, 12815, 12813, 12581, 13538,
          13567}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13561, 12808, 12685, 12580, 12810, 12812, 12759, 13113, 
         13396, 12471, 13394, 13115, 13117, 13046, 13050, 13048, 12562, 13058,
          13060, 13052, 13056, 13054, 12516, 13477, 13479, 13175, 13179, 
         13177, 12612, 13345, 13347, 12761, 13398, 12473, 12665, 13515, 13517,
          13364, 13368, 13366, 12631, 13246, 13248, 13240, 13244, 13242, 
         12534, 13481, 13483, 13181, 13185, 13183, 12614, 13349, 13351, 12763,
          13400, 13566}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13564, 12731, 12729, 13137, 13135, 12603, 13168, 13170, 
         13162, 13166, 13164, 12532, 13487, 13489, 13205, 13209, 13207, 12625,
          13201, 13203, 13195, 13199, 13197, 12431, 12453, 12727, 12725, 
         13133, 13131, 12601, 13158, 13160, 13152, 13156, 13154, 12496, 13453,
          13455, 12929, 12933, 12931, 12543, 12925, 12927, 12919, 12923, 
         12921, 12429, 12451, 12723, 12721, 12796, 12794, 12554, 12675, 12699,
          13588}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13572, 13548, 12591, 12682, 12680, 12513, 13037, 13039, 
         13035, 13043, 13041, 12559, 13031, 13033, 13029, 13464, 13462, 12657,
          12468, 13391, 12756, 13342, 13340, 12609, 13276, 13278, 13274, 
         13498, 13496, 12511, 13266, 13268, 13264, 13272, 13270, 12637, 13380,
          13382, 13378, 13526, 13524, 12655, 12466, 13389, 12754, 12805, 
         12803, 12577, 12979, 12981, 12977, 13423, 13421, 12509, 12700, 12702,
          12641, 13554, 13582}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13576, 13552, 12635, 12695, 12693, 12489, 13018, 13020, 
         13016, 13024, 13022, 12587, 12817, 12819, 12712, 12714, 12446, 12424,
          13294, 13296, 13292, 13300, 13298, 12639, 13304, 13306, 13302, 
         13510, 13508, 12491, 13310, 13312, 13308, 13316, 13314, 12598, 13126,
          13128, 12716, 12718, 12448, 12426, 12904, 12906, 12902, 12910, 
         12908, 12572, 12914, 12916, 12912, 13415, 13413, 12493, 12670, 12672,
          12619, 13544, 13580}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13579, 13559, 12879, 12883, 12881, 12520, 13438, 13440, 
         12848, 12852, 12850, 12551, 12788, 12790, 12767, 13404, 12477, 12669,
          13521, 13523, 13373, 13377, 13375, 12634, 13261, 13263, 13255, 
         13259, 13257, 12522, 13501, 13503, 13281, 13285, 13283, 12616, 13353,
          13355, 12769, 13406, 12479, 12660, 13467, 13469, 13062, 13066, 
         13064, 12564, 13074, 13076, 13068, 13072, 13070, 12524, 12687, 12689,
          12594, 13551, 13575}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{13565, 13399, 12762, 13350, 13348, 12613, 13182, 13184, 
         13180, 13482, 13480, 12533, 13241, 13243, 13239, 13247, 13245, 12630,
          13365, 13367, 13363, 13516, 13514, 12664, 12472, 13397, 12760, 
         13346, 13344, 12611, 13176, 13178, 13174, 13478, 13476, 12515, 13053,
          13055, 13051, 13059, 13057, 12561, 13047, 13049, 13045, 13116, 
         13114, 13393, 12470, 13395, 13112, 12758, 12811, 12809, 12579, 12684,
          12807, 13560}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13569, 13543, 12540, 12876, 12877, 12875, 13449, 13448, 
         12667, 12475, 13402, 12765, 12786, 12785, 12549, 12845, 12846, 12844,
          13436, 13435, 12518, 13250, 13251, 13249, 13253, 13252, 12632, 
         13370, 13371, 13369, 13519, 13518, 12666, 12474, 13401, 12764, 12784,
          12783, 12548, 12842, 12843, 12841, 13434, 13433, 12517, 12871, 
         12872, 12870, 12874, 12873, 12539, 12868, 12869, 12867, 13447, 13529,
          13534, 13586}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13570, 13535, 13528, 12854, 12853, 12856, 12855, 12544, 
         12858, 12859, 12857, 13442, 13441, 12497, 12822, 12823, 12821, 12825,
          12824, 12535, 12774, 12775, 12732, 12733, 12454, 12432, 13211, 
         13212, 13210, 13214, 13213, 12626, 13216, 13217, 13215, 13491, 13490,
          12498, 12827, 12828, 12826, 12830, 12829, 12536, 12776, 12777, 
         12734, 12735, 12455, 12433, 12861, 12862, 12860, 12864, 12863, 12545,
          13542, 13571}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13574, 13550, 12593, 12688, 12686, 12523, 13069, 13071, 
         13067, 13075, 13073, 12563, 13063, 13065, 13061, 13468, 13466, 12659,
          12478, 13405, 12768, 13354, 13352, 12615, 13282, 13284, 13280, 
         13502, 13500, 12521, 13256, 13258, 13254, 13262, 13260, 12633, 13374,
          13376, 13372, 13522, 13520, 12668, 12476, 13403, 12766, 12789, 
         12787, 12550, 12849, 12851, 12847, 13439, 13437, 12519, 12880, 12882,
          12878, 13558, 13578}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13584, 13556, 12865, 13445, 13443, 12499, 12833, 12835, 
         12831, 12839, 12837, 12537, 12778, 12780, 12736, 12738, 12456, 12434,
          13220, 13222, 13218, 13226, 13224, 12627, 13230, 13232, 13228, 
         13494, 13492, 12501, 13320, 13322, 13318, 13326, 13324, 12604, 13138,
          13140, 12740, 12742, 12458, 12436, 12936, 12938, 12934, 12942, 
         12940, 12574, 12946, 12948, 12944, 13419, 13417, 12503, 12676, 12678,
          12621, 13546, 13532, 13530}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13587, 12698, 12674, 12553, 12793, 12795, 12720, 12722, 
         12450, 12428, 12920, 12922, 12918, 12926, 12924, 12542, 12930, 12932,
          12928, 13454, 13452, 12495, 13153, 13155, 13151, 13159, 13157, 
         12600, 13130, 13132, 12724, 12726, 12452, 12430, 13196, 13198, 13194,
          13202, 13200, 12624, 13206, 13208, 13204, 13488, 13486, 12531, 
         13163, 13165, 13161, 13169, 13167, 12602, 13134, 13136, 12728, 12730,
          13563}],
        "2.5`"],
       Annotation[#, 2.5, "Tooltip"]& ]}, {}, {}, {}, {}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154148746]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28754],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->16609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{
   RowBox[{"\[Pi]", "^", "2"}], "+", 
   RowBox[{"2", "\[Pi]"}], "+", "1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", "1"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31070],

Cell[BoxData[
 RowBox[{
  RowBox[{"Floor", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Floor[\\(\\(1 + \\(\\(2\\\\ \[Pi]\\)\\) + \
\[Pi]\\^2 - \\((1 + \[Pi])\\)\\^2\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"Floor::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->241681269],

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[Pi]"}], "+", 
   SuperscriptBox["\[Pi]", "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Pi]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{177, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154549703]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196492977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Guard digits can influence the result of ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"1`100", " ", "-", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "130"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725430381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"1`100", " ", "+", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "130"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220756026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1`100", " ", "-", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "130"}]}]}], " ", "===", " ", 
  RowBox[{"1`100", " ", "+", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "130"}]}]}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->472581026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Self\[Hyphen]counting sequence:", "ExampleText",
 CellID->237086599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Floor", "[", 
       RowBox[{"2", "k"}], "]"}], "]"}], "+", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "21"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23553765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", 
   ",", "4", ",", "4", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6"}], "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66587000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"2", "^", 
      RowBox[{"Floor", "[", 
       RowBox[{"n", "/", "GoldenRatio"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "10000"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234030024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2", ",", 
   RowBox[{"Take", "[", 
    RowBox[{
     RowBox[{"ContinuedFraction", "[", "%", "]"}], ",", "15"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10668688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", 
   ",", "13", ",", "21", ",", "34", ",", "55", ",", "89", ",", "144", ",", 
   "233"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78616647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "1"}], ",", "13"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", 
   ",", "13", ",", "21", ",", "34", ",", "55", ",", "89", ",", "144", ",", 
   "233"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250928635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Convergence of the Fourier series of ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}], "-", 
       RowBox[{"UnitStep", "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"2", "Pi", " ", "k", " ", "x"}], "]"}], "/", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", "o"}], "}"}]}], "]"}], "/", "Pi"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"o", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WflXE3m2zwio53SfM+9N9w/z47yZ6Z7WeTPvL+jTo7LIIksgLEkIZN9T
2SpLZU+AQBKzkMomCCgu4NKNG250q9i4tIq2SouK7YDNaPfoMK1P53G6z+Hd
qqQFI4kz57zHgaK+3/rU/d5v1b2fz73JJrZWxJeztWIu+1dFarZSJOZqflWI
qGEq52cUCuUw/Ml/SYHzBTgj/1YvLCxQcogz8ocySBwob5i9/uXtZWY1iHmZ
WRFf/+TJc8p7MCaG78P/3NR/YvxB2ko5L+9eAZOUnHDg89SV36Yh318yJqBr
0q6/l9EyhXBAyLWq67ru3nmcjvtd2jjdw9+kdpD7qj0Jq3WPwYMoDqXbS7//
vdTe0v3PW7SXRzw3ljsoY5kNR8+O3n9t7+k238+wxhKbK4l3Xxswe5su7xtr
ZAzOz//4m+WeWO7i+PVn+tvX7JJvKZdlFR/RRnfuuJqIX/x1avaD1P/fvfFN
U1bBLFoa48lNu2WGhxMzYtEQvBjKzkXEakCY8xMynnZoi/Fc59DEzUfwqGEP
/05effjw6d491x32EZh0t53+dGQKLv04/8OK2fG7lJUvns7NzoxPfnvniy/v
TYyf//r+Q9ei5XfBcsuHCZVY4k3Qtta23Zq6ua931G0/OT07d+fx/YdPv5t7
Mg23P/3+IcDnpr+9umPkcs+xyeGL889ekHt4B1aHpetou8Kd52Dpq+OzB4Ym
CGfKOntKTIcUkb06c7e7SN/TVGrAPDUGltDl/Cjx4NZ3FOeiH2vBD9uGuFgh
MtgNtg2JerHXgBX7i1vElbFSrL00VmV2VmwRopjAjakN1VrELtjstRubWvVK
icoqt9/66q4S1Svkco1CZG9hhKwRfcCp0TTx46pyzMDiJjoKIzE5Wxwqq8e8
aGXY2hiT20r0xTF1ZSjhPpz0hHivnxBvNOnT7+HEo9opbfAaC+NiR1l7TcK2
PlEtC8I8zqlvzY9U86Pr7HKGg9nSqBGobQqxBy6pm+1yMdKsNkYC3VqGRSxV
1lqNMG+kt5RaeM2IWc3CgwwbaiktDdcR88VRb42R3VohrA9bC+JSg00sU2Cl
McKPVWlRszJtnPeG8f81/v97/RWvRub5ExMQnCx+WztdU6W2y3pEPa6KY3EP
RGCi1GYp9UGkTU/PQZTCEc6N+t1KWfDCuWtkZL776Oafz/r2QgQex3ogYn/8
YX7y5vDlsZ6Zry8MT54amjix78R1HWv3sd49Oz7dg1M7LJFymURqXxdfJvfT
eTGdc5Z4vjo5O/Tx2X3bu3r2jQ5c2QeL3rv0+Qrwm7L66cMn4O1m31mgoY8+
TMARzi9emEnmMqgFl7MPjuDz/m0auRABf/7xbN6xaH/Jqv9B8gdkHeQbJPse
g14sMuiKY7evfkNZvIPgIZLtVgIMwAMsV7NBqSmPDB+6uLzdX5PopC9jW47K
2zmKmmAsuHd5NGk7DygIbz/pNjVK6D6nNk7JhgV+ApbbrkZBNzS8UAYsyfu5
oAAdvKiQB4IVXB6X1BwDMiRhW5HaQNrOk28KGFUo1KPleIa1kiiJVG8sihKn
9iyobd391g0J2EMGVDJWIHK7/LuJU1sWFLxdRKwlaoRF1E/6QckxF8RlUgSI
NZuNXF1ZRCRE+RVdYMaaBaehhoQ8825NDMIgCy5PWw84a49MLBV+DFJDsWTB
6oU4vMNAG+fC/osQLEuwL3ex0q3rETE9cl/j6bbdsBcIFHNmi6v6osOy2iDL
pt3RhP790RzkBygMxZTljnMjE5ryaJPYeiCAXd9zGhQIhJDyCxILiQWSSIxX
EIe3YPFnz+ZByCAXAfvg3pVr4/tHJsdOnb4xfPyTqduzlAZypVSBk/rJXW7d
d//+8Cmospat7evjBms7zt0Y3e471OE8ce3ug5Gpsem5b6ZujUDmP/72Dojx
xNAYbH9Ym4BVgQJIhso9fvSKkOtFtcNHhydzwG/K21DxuTa6+6qc4N/HAU1X
S2XjVh5V7G4RMAUNIce6+N++fVpPurYizaectDH57NcQ4i4RYEIHRGydxKPH
yrxFblVZrMzoK8dL3Kq6EL1dwQ+ytGo6qnWyW1Q2cwOGyaQyHd/c0zfQqDbJ
+VpUakT1zTIkIFOiJq6kqp3zJ9QubIh7C/x+ZGNVqJrFwY0b4+F6X52TaVsf
R6j4kYGLlMx+vqyI1lgL4yJEBlnAsPFsG2L1ihZLSbCZ5zWVBMX0TmNpSEAP
Yxs75TTcVISL6zpNhRFVdQDyQl632VgY028KGYti5HkcqfUaiyNCus9YHJbX
BfSbOsUNQV2FX8DEzbWtdEHYVeJlitzKKpzLc7Urd2Tx7/XnaGN2aaibpbSo
Q1uhrenSVOLVTrvavSHcIG3dGC8TRzc5EWEHGxVKJHZPi9KtNtGVYqNEphAb
bKMnxuRyFQdVsFqsAatNw2mvNAkQhd3WHIgL9OqW/OIIgyoOoyWxYK2S3l4p
qsNthXGWExMKjAZG9F/x8+3D/eegumpAFabq1uI2mWsLt9tVejqyFWJvS7FF
QU1AjbqCiLQ8yAwQnuqqvoBvkOCfZDWXzAwQHzhCmMIcqOX1y3ugALz56A6U
hONfzaLcvWcPnzk19nk/p12D1wklGqz0n/WS1NW3Ll2ZuDl26cqde7f/MnH/
7uiTmRmoKwmJnv8Bkh0q6WS25kBmgKwT3pHquAouAslAAu/j+OK9PJlEAZGQ
WjlVUlNedhNLVi0leQiSDLjg/uj1vQ6tWIJAatS/wlabSJQJOw6Ss61BK5Rp
IL3/+s1c3bLcU7aQ0kgofc8GPhFiIijiz3x6bXk0aTuvFx6r96TZxlZXhrf3
HaJkw4K+EEU1IlDU+ltNWzJgyxdSGunjeCSMDlQYqHtlT5UkXtrYL2a1Kho9
GaxULKQ0UsyxILRABlTSlkhg1FR0Eqe1WVAaxKEtx9+E2jt4BNJ3sHs0Gyr3
8ePvgSDUXD08Etoru6MupJRWrZQAs1Noy1qpIq1YN8SFcgWvfju8sposOKwo
KhRr+7EdIFVZcHloeUQiQKFlg4gk+rXqbNiasEBgjGH8sYNXicCufn0XK43c
iJDjbMFZ0OBBYkLcUzNbXOU29IqYHc0dTbsabH999H2yZkxeo7zsz1+7K6mt
DXrzEV8rCBJQAGRYMrdy4H54hKRSQllKeRtMAleAbQCO2LeP9x+7OjZw/EzM
f2znjsDB1rDv2hf3/mthqVYuGaSv/G+jJ6+DRvM51n09WivbP3A0lkB67KZD
+0cv9Vzec/7ehasXd4BWAhkA68ATWAFlO+WXcAKElDQEWZ+I7AK5DIeOA4E9
eT4HCgsPvh8/499gHlBtnTw+tjPA8DsYNRFREzOIYBXQ30Ev+cP8j39c+Ge4
ifR0LSQ8pL2OrbZUBQwlkTqZx4BVtBdtVpXHy7C26s6NbiG7tdzXKMCrzDKG
WG1nWgQGI11jkvPUWrZJbnBx1KiUZUb4BolGxkU8OrbZykE2tdX/yehUVMc9
BR6Hfl2Bh6MsT2AF8XgNVmVEzUURYI8vz3+d9DTdM8LznJ8iZY3zozjKVaKl
cYW5xr4+zuW7VbQgS2q2FoYQalRFDTZxNmPFQWgsVdROHiNsKYhgG8MKahQ6
TKwIN20My6txcUMA9BOkVVYX4DNClvy4qTgkbXY2cQJoeVhfjqMyhMHD7VSn
uC6C1AaFDP+24DFKZv+WjpN+WjbF9aU4U9AebGaJGN0SZoARUXU4i4N1Nmd5
V4UYbwzodFGN0SZwJrq22X0tLhqqEiFySTjed370glFulKiUyg7bNotDIfSz
VEirxtoptW3FBAJ/yaaYkCoIa4tj0XppbUellBZzlseq7BiH72yV9KX8fPXz
nPTIJL38xUD8MxARMVbLo/vLOptCkboeS81BpHOQ4d5K9zZReyEZQTkgV4C9
oWsBUoY8IW298/zJUyjnQCqnRsZBu2AOir3ZmXE4AamEEJ3682Ot6JPr4/cm
Tl0+ZPEKO/lCAWagR3/yL4tmkRzx8/vTM7P3Zm89mPlu7gHYhgWhz0vmBCQE
kAQoGuQwuEZU6mTNu6iSsIWWeDVfCvocSa2YziYoyT1gB3YJW9kVlEukMqDK
RTTBUHqSxWDzN67ObqUDQgKcm8GijrQIiQk+nLT3SiVq6/oEVK1/WBadtAxU
u8t7VGqS6Etily/cpmTDwr6a6AMOXbO2PLKr/0gGrIE45BI9qdSkooY6Wrr/
8MqOjOR1EBRNPZSSPrXEs7wdEpcz+tmUlOmWsdozrIaRY0lTi4zeQZz+ZxaU
jGdHaP43oRymANQIZ05MLkERfpN9UM7OvgNoadTIdWWzkQtVFkS2WaGG1/v7
zLi8fzybt69LqBBxQ81OoqtduyyWXDkXikupQtaNDULEZcHlESklVQzpNqf6
tzVZsMaSCF+khn7z1PAEVF9LsMSOyV5xpZ6Kg4JGQzwIUoh3yMYPMltcZWyM
CflmxE+DDABdAx8gapJdGwlOz7XkXW5VH5/dxnSpDljboUqEoorwJqmOoDjQ
NZcW96bUsWBDN2TMveszyU+YTvm2jRxwdB2yqfsSW8xxncMD6pj8nPhNXEmu
/VZv+Ki4PtAgtQ7FvWqut2uXPSqKGNX78UNH7SPBoUsDlBXHhzDKqsmbwzMX
bkEbmfhQ1V9h7fdEpm7cStp858qlGw6TDX6PDV+A/Y7PAiXcefK3Fz7ToG+D
Zbd+4MrhwXC4wmBFmjwmQ0073c6Eusqen6D8C56u/eKz26DkKMNp2Yhryztp
CrdJV9GSj6MliXxzR5V/Y1sNai4L0WSdpRaplIlZalx1GhdD7VLRzRqGjam0
1ytdWpoTacaYGl2NImSltpkbDMXtDcU6j64s7ilzSVz5ZZgDuMBYmAjx2EyB
x1DpBVGGhjtVaqTxZs5PmbH22ZPnQDdYnYUQBGW9qTCuqgmxeH6Gge8oCGKF
cSY3xJBaQSqt+VEuK8jk+W35uGNdtLkJb2rCbfkRx/oIq7mT09QJ7agtP8wU
trHYIVNhzF4QZilQBj+gK43ZisIiE5vDwlGmCYoMQ61bQY2cPvhl0rs31Rlk
RK+xgeIWRqq1pghNjYi7m5FWVZdku58bqAnaaLF6Lt6ys6t1l9Pebx08/OnR
aNSPV6lQiVaLfjX59YPpaVerXYJKXJh1QBdAmjosqDNssSQQWdxWwU/UfhRi
VktxaVk0ShPVeqqkNVEfP0iV20V0X8J7MFWwvel9k36+nWg7AP28TcooF3ob
YrXxwPoeMQdCHqJvp74f1BCSZAWwASUXpKiqoh/SBMifXCF3/tkLkCsQR1Cs
pHXoI5//95OXq60GvgGdmJ6eg7w+Hgw0uNVCdotd3p2bMVfJz+pXgtqC5aTm
gg3IVdKHHFBqSHgCkuwYiZ5GNPTi2f/sormQAE3Ms+oZ+NJvr5ZY7iUYh9wJ
KDqOs/kig74CX8QSbNRHrp78/PLG+amtcqFQprQUxJa3SKLzklq4X94mUsih
dsuw+jYSC0/v4/YhqVICjAy8vPR7otewBLNVb9NoREC2t76ayYDdTr4JKOVd
GinE6smjZ1/9lrF/IaWE+po2aNn83u7l7ZC4nMG+iwpaQCNrz7BaEgXWQOOk
XEcG1A5ybNC6TAb3y1h40/eur8xSfva/aQArXg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357819594]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31440],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->55]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30196],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->7055],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->12996],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#4227"], None}]], "RelatedLinks",
 CellID->210767829],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/FloorFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Floor/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->48530393],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->70720259],

Cell[TextData[ButtonBox["Mathematics and Algorithms: New in 6.0",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->380230565],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->1860535],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->133829222]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Floor (\[LeftFloor]...\[RightFloor]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 36.2818720}", "context" -> "System`", 
    "keywords" -> {
     "entier", "entire", "greatest integer function", 
      "nearest integer function", "round down", "rounddown"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Floor[x] gives the greatest integer less than or equal to x. Floor[x, a] \
gives the greatest multiple of a less than or equal to x. ", "synonyms" -> {},
     "title" -> "Floor", "type" -> "Symbol", "uri" -> "ref/Floor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12502, 348, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194283272]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 316031, 6242}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3110, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3733, 94, 4283, 86, 70, "ObjectNameGrid"],
Cell[8019, 182, 1071, 35, 70, "Usage",
 CellID->28692]
}, Open  ]],
Cell[CellGroupData[{
Cell[9127, 222, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9605, 239, 124, 4, 70, "Notes",
 CellID->126685801],
Cell[9732, 245, 1245, 44, 70, "Notes",
 CellID->3410],
Cell[10980, 291, 567, 18, 70, "Notes",
 CellID->11173],
Cell[11550, 311, 478, 14, 70, "Notes",
 CellID->17699],
Cell[12031, 327, 232, 7, 70, "Notes",
 CellID->124085891],
Cell[12266, 336, 199, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[12502, 348, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194283272],
Cell[CellGroupData[{
Cell[12887, 362, 148, 5, 70, "ExampleSection",
 CellID->124876621],
Cell[13038, 369, 73, 1, 70, "ExampleText",
 CellID->20717],
Cell[CellGroupData[{
Cell[13136, 374, 99, 3, 28, "Input",
 CellID->12446],
Cell[13238, 379, 157, 5, 36, "Output",
 CellID->13352140]
}, Open  ]],
Cell[CellGroupData[{
Cell[13432, 389, 99, 3, 28, "Input",
 CellID->19962],
Cell[13534, 394, 158, 5, 36, "Output",
 CellID->462887342]
}, Open  ]],
Cell[13707, 402, 120, 3, 70, "ExampleDelimiter",
 CellID->1943],
Cell[13830, 407, 79, 1, 70, "ExampleText",
 CellID->7489],
Cell[CellGroupData[{
Cell[13934, 412, 170, 5, 70, "Input",
 CellID->1730],
Cell[14107, 419, 160, 5, 36, "Output",
 CellID->280262747]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14316, 430, 216, 7, 70, "ExampleSection",
 CellID->28606],
Cell[14535, 439, 68, 1, 70, "ExampleText",
 CellID->25151],
Cell[CellGroupData[{
Cell[14628, 444, 121, 4, 70, "Input",
 CellID->1946],
Cell[14752, 450, 167, 5, 36, "Output",
 CellID->491566869]
}, Open  ]],
Cell[CellGroupData[{
Cell[14956, 460, 127, 4, 70, "Input",
 CellID->7985],
Cell[15086, 466, 159, 5, 36, "Output",
 CellID->967708049]
}, Open  ]],
Cell[15260, 474, 120, 3, 70, "ExampleDelimiter",
 CellID->5570],
Cell[15383, 479, 200, 7, 70, "ExampleText",
 CellID->19423],
Cell[CellGroupData[{
Cell[15608, 490, 159, 5, 70, "Input",
 CellID->9118],
Cell[15770, 497, 213, 7, 36, "Output",
 CellID->306026466]
}, Open  ]],
Cell[15998, 507, 121, 3, 70, "ExampleDelimiter",
 CellID->15348],
Cell[16122, 512, 189, 7, 70, "ExampleText",
 CellID->4250],
Cell[CellGroupData[{
Cell[16336, 523, 191, 7, 70, "Input",
 CellID->17852],
Cell[16530, 532, 206, 7, 51, "Output",
 CellID->294156523]
}, Open  ]],
Cell[16751, 542, 121, 3, 70, "ExampleDelimiter",
 CellID->11591],
Cell[16875, 547, 197, 8, 70, "ExampleText",
 CellID->23068],
Cell[CellGroupData[{
Cell[17097, 559, 213, 7, 70, "Input",
 CellID->6908],
Cell[17313, 568, 236, 8, 36, "Output",
 CellID->104044766]
}, Open  ]],
Cell[CellGroupData[{
Cell[17586, 581, 309, 11, 70, "Input",
 CellID->16709],
Cell[17898, 594, 222, 7, 51, "Output",
 CellID->143081060]
}, Open  ]],
Cell[18135, 604, 119, 3, 70, "ExampleDelimiter",
 CellID->710],
Cell[18257, 609, 59, 1, 70, "ExampleText",
 CellID->3745],
Cell[CellGroupData[{
Cell[18341, 614, 241, 8, 70, "Input",
 CellID->31562],
Cell[18585, 624, 305, 12, 38, "Output",
 CellID->28169124]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18939, 642, 238, 7, 70, "ExampleSection",
 CellID->2310],
Cell[19180, 651, 55, 1, 70, "ExampleText",
 CellID->24486],
Cell[CellGroupData[{
Cell[19260, 656, 168, 6, 70, "Input",
 CellID->8493],
Cell[19431, 664, 214, 7, 36, "Output",
 CellID->54595728]
}, Open  ]],
Cell[19660, 674, 105, 2, 70, "ExampleDelimiter"],
Cell[19768, 678, 196, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19989, 688, 217, 7, 70, "Input"],
Cell[20209, 697, 260, 9, 36, "Output",
 CellID->240593731]
}, Open  ]],
Cell[20484, 709, 105, 2, 70, "ExampleDelimiter"],
Cell[20592, 713, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20681, 717, 88, 2, 70, "Input"],
Cell[20772, 721, 168, 5, 36, "Output",
 CellID->248504347]
}, Open  ]],
Cell[20955, 729, 105, 2, 70, "ExampleDelimiter"],
Cell[21063, 733, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21128, 737, 338, 10, 70, "Input"],
Cell[21469, 749, 576, 14, 70, "Output",
 Evaluatable->False,
 CellID->81736590]
}, Open  ]],
Cell[22060, 766, 121, 3, 70, "ExampleDelimiter",
 CellID->20967],
Cell[22184, 771, 453, 16, 70, "ExampleText",
 CellID->19211],
Cell[CellGroupData[{
Cell[22662, 791, 110, 3, 70, "Input",
 CellID->9506],
Cell[22775, 796, 188, 6, 36, "Output",
 CellID->17490168]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23012, 808, 223, 7, 70, "ExampleSection",
 CellID->22020],
Cell[CellGroupData[{
Cell[23260, 819, 267, 9, 70, "Input"],
Cell[23530, 830, 1388, 27, 70, "Output",
 Evaluatable->False,
 CellID->281006654]
}, Open  ]],
Cell[24933, 860, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[25063, 866, 334, 11, 70, "Input"],
Cell[25400, 879, 10314, 173, 70, "Output",
 Evaluatable->False,
 CellID->295427564]
}, Open  ]],
Cell[35729, 1055, 105, 2, 70, "ExampleDelimiter"],
Cell[35837, 1059, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35903, 1063, 107, 2, 70, "Input"],
Cell[36013, 1067, 317, 9, 36, "Output",
 CellID->76311850]
}, Open  ]],
Cell[CellGroupData[{
Cell[36367, 1081, 191, 6, 70, "Input"],
Cell[36561, 1089, 317, 9, 36, "Output",
 CellID->21065267]
}, Open  ]],
Cell[36893, 1101, 105, 2, 70, "ExampleDelimiter"],
Cell[37001, 1105, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[37094, 1109, 338, 11, 70, "Input"],
Cell[37435, 1122, 157, 5, 36, "Output",
 CellID->76324933]
}, Open  ]],
Cell[CellGroupData[{
Cell[37629, 1132, 299, 10, 70, "Input"],
Cell[37931, 1144, 158, 5, 36, "Output",
 CellID->156769743]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38138, 1155, 233, 7, 70, "ExampleSection",
 CellID->26335],
Cell[CellGroupData[{
Cell[38396, 1166, 220, 8, 70, "Input",
 CellID->23787],
Cell[38619, 1176, 269, 10, 36, "Output",
 CellID->37988320]
}, Open  ]],
Cell[38903, 1189, 123, 3, 70, "ExampleDelimiter",
 CellID->7865088],
Cell[CellGroupData[{
Cell[39051, 1196, 236, 8, 70, "Input",
 CellID->609237933],
Cell[39290, 1206, 928, 19, 70, "Output",
 Evaluatable->False,
 CellID->495660636]
}, Open  ]],
Cell[40233, 1228, 120, 3, 70, "ExampleDelimiter",
 CellID->9415],
Cell[40356, 1233, 315, 13, 70, "ExampleText",
 CellID->251461377],
Cell[CellGroupData[{
Cell[40696, 1250, 221, 7, 70, "Input",
 CellID->4003],
Cell[40920, 1259, 955, 30, 78, "Output",
 CellID->461654311]
}, Open  ]],
Cell[41890, 1292, 124, 3, 70, "ExampleDelimiter",
 CellID->53959189],
Cell[42017, 1297, 195, 8, 70, "ExampleText",
 CellID->280823093],
Cell[CellGroupData[{
Cell[42237, 1309, 401, 13, 70, "Input",
 CellID->568666707],
Cell[42641, 1324, 683, 15, 70, "Output",
 Evaluatable->False,
 CellID->245872150]
}, Open  ]],
Cell[43339, 1342, 105, 2, 70, "ExampleDelimiter"],
Cell[43447, 1346, 297, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43769, 1362, 222, 7, 70, "Input"],
Cell[43994, 1371, 421, 14, 44, "Output",
 CellID->118785285]
}, Open  ]],
Cell[CellGroupData[{
Cell[44452, 1390, 231, 7, 70, "Input"],
Cell[44686, 1399, 3119, 55, 70, "Output",
 Evaluatable->False,
 CellID->727540341]
}, Open  ]],
Cell[47820, 1457, 105, 2, 70, "ExampleDelimiter"],
Cell[47928, 1461, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[48138, 1472, 443, 15, 70, "Input"],
Cell[48584, 1489, 213, 7, 38, "Output",
 CellID->637639450]
}, Open  ]],
Cell[48812, 1499, 125, 3, 70, "ExampleDelimiter",
 CellID->145353071],
Cell[48940, 1504, 202, 7, 70, "ExampleText",
 CellID->194005584],
Cell[CellGroupData[{
Cell[49167, 1515, 418, 14, 70, "Input",
 CellID->295494130],
Cell[49588, 1531, 247085, 4107, 70, "Output",
 CellID->154148746]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[296722, 5644, 226, 7, 70, "ExampleSection",
 CellID->28754],
Cell[296951, 5653, 209, 7, 70, "ExampleText",
 CellID->16609],
Cell[CellGroupData[{
Cell[297185, 5664, 270, 9, 70, "Input",
 CellID->31070],
Cell[297458, 5675, 507, 9, 70, "Message",
 CellID->241681269],
Cell[297968, 5686, 370, 12, 39, "Output",
 CellID->154549703]
}, Open  ]],
Cell[CellGroupData[{
Cell[298375, 5703, 98, 3, 70, "Input",
 CellID->211],
Cell[298476, 5708, 158, 5, 36, "Output",
 CellID->196492977]
}, Open  ]],
Cell[298649, 5716, 105, 2, 70, "ExampleDelimiter"],
Cell[298757, 5720, 198, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[298980, 5731, 165, 5, 70, "Input"],
Cell[299148, 5738, 158, 5, 36, "Output",
 CellID->725430381]
}, Open  ]],
Cell[CellGroupData[{
Cell[299343, 5748, 165, 5, 70, "Input"],
Cell[299511, 5755, 158, 5, 36, "Output",
 CellID->220756026]
}, Open  ]],
Cell[CellGroupData[{
Cell[299706, 5765, 252, 8, 70, "Input"],
Cell[299961, 5775, 161, 5, 36, "Output",
 CellID->472581026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[300171, 5786, 208, 6, 70, "ExampleSection"],
Cell[300382, 5794, 74, 1, 70, "ExampleText",
 CellID->237086599],
Cell[CellGroupData[{
Cell[300481, 5799, 350, 12, 70, "Input",
 CellID->23553765],
Cell[300834, 5813, 404, 10, 36, "Output",
 CellID->66587000]
}, Open  ]],
Cell[301253, 5826, 105, 2, 70, "ExampleDelimiter"],
Cell[301361, 5830, 331, 11, 70, "Input",
 CellID->234030024],
Cell[CellGroupData[{
Cell[301717, 5845, 229, 8, 70, "Input",
 CellID->10668688],
Cell[301949, 5855, 353, 10, 36, "Output",
 CellID->78616647]
}, Open  ]],
Cell[CellGroupData[{
Cell[302339, 5870, 222, 7, 70, "Input"],
Cell[302564, 5879, 354, 10, 36, "Output",
 CellID->250928635]
}, Open  ]],
Cell[302933, 5892, 105, 2, 70, "ExampleDelimiter"],
Cell[303041, 5896, 195, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[303261, 5907, 723, 22, 70, "Input"],
Cell[303987, 5931, 5926, 101, 70, "Output",
 Evaluatable->False,
 CellID->357819594]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[309974, 6039, 311, 9, 70, "SeeAlsoSection",
 CellID->31440],
Cell[310288, 6050, 1667, 62, 70, "SeeAlso",
 CellID->55]
}, Open  ]],
Cell[CellGroupData[{
Cell[311992, 6117, 314, 9, 70, "TutorialsSection",
 CellID->30196],
Cell[312309, 6128, 147, 3, 70, "Tutorials",
 CellID->7055],
Cell[312459, 6133, 152, 3, 70, "Tutorials",
 CellID->869807265],
Cell[312614, 6138, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[312784, 6146, 321, 9, 70, "RelatedLinksSection",
 CellID->12996],
Cell[313108, 6157, 270, 6, 70, "RelatedLinks",
 CellID->210767829],
Cell[313381, 6165, 184, 4, 70, "RelatedLinks"],
Cell[313568, 6171, 194, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[313799, 6180, 318, 9, 70, "MoreAboutSection",
 CellID->48530393],
Cell[314120, 6191, 154, 3, 70, "MoreAbout",
 CellID->70720259],
Cell[314277, 6196, 181, 3, 70, "MoreAbout",
 CellID->380230565],
Cell[314461, 6201, 147, 3, 70, "MoreAbout",
 CellID->1860535],
Cell[314611, 6206, 160, 3, 70, "MoreAbout",
 CellID->133829222]
}, Open  ]],
Cell[314786, 6212, 50, 0, 70, "History"],
Cell[314839, 6214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

