(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44935,       1727]
NotebookOptionsPosition[     35404,       1386]
NotebookOutlinePosition[     36690,       1424]
CellTagsIndexPosition[     36604,       1419]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nest" :> Documentation`HelpLookup["paclet:ref/Nest"], 
          "FoldList" :> Documentation`HelpLookup["paclet:ref/FoldList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Nest\"\>", 
       2->"\<\"FoldList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Functional Iteration\"\>", 
       2->"\<\"Functional Programming\"\>", 3->"\<\"Looping Constructs\"\>", 
       4->"\<\"Math & Counting Operations on Lists\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fold", "ObjectName",
 CellID->23893],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Fold",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Fold"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the last element of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["FoldList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FoldList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit from ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " before it is finished. "
}], "Notes",
 CellID->29645]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->496960588],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->10812996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12834],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], "]"}], 
   ",", "d"}], "]"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1740862711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"List", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1225692943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "a"}], "}"}], ",", "b"}], "}"}], ",", "c"}], "}"}], 
   ",", "d"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->711894119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35632801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"Times", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1287855344],

Cell[BoxData[
 RowBox[{"a", " ", "b", " ", "c", " ", "d"}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1882721986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->335893605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "^", "#2"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614115886],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", "a"], ")"}], "b"], ")"}], "c"], ")"}], 
  "d"]], "Output",
 ImageSize->{75, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529781133]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23986],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29737],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], "]"}], 
   ",", "d"}], "]"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13525],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit a ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "+", "#1"}], "&"}], ",", "2", ",", 
   RowBox[{"Range", "[", "6", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "6", ",", "42", ",", "1806", ",", "3263442", ",", 
   "10650056950806", ",", "113423713055421844361000442"}], "}"}]], "Output",
 ImageSize->{507, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", 
        RowBox[{"10", "^", "6"}]}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"#", "^", "2"}], "+", "#1"}]}], "]"}], "&"}], ",", "2", ",", 
    RowBox[{"Range", "[", "6", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1978],

Cell[BoxData["3263442"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1438551534],

Cell["Fold to the right:", "ExampleText",
 CellID->764004239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"#2", ",", "#1"}], "]"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2083642256],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"d", ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", 
       RowBox[{"g", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88547215]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30919],

Cell["Create a nested polynomial (Horner form):", "ExampleText",
 CellID->16637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "#1"}], "+", "#2"}], "&"}], ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6990],

Cell[BoxData[
 RowBox[{"e", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", " ", "x"}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29204825]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HornerForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HornerForm"]], "InlineFormula"],
 " directly produces this output:"
}], "ExampleText",
 CellID->5401630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reverse", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "]"}], 
    ".", 
    RowBox[{"x", "^", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "4"}], "]"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31228229],

Cell[BoxData[
 RowBox[{"e", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", " ", "x"}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385279015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11599],

Cell["Form a continued fraction:", "ExampleText",
 CellID->13829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"#2", "+", "#1"}], ")"}]}], "&"}], ",", "x", ",", 
   RowBox[{"Reverse", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16774],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"a", "+", 
   FractionBox["1", 
    RowBox[{"b", "+", 
     FractionBox["1", 
      RowBox[{"c", "+", 
       FractionBox["1", 
        RowBox[{"d", "+", "x"}]]}]]}]]}]]], "Output",
 ImageSize->{73, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192118137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30128],

Cell["Form a number from digits:", "ExampleText",
 CellID->6953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"10", "#1"}], "+", "#2"}], "&"}], ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "6", ",", "7", ",", "8"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2437],

Cell[BoxData["451678"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99682587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12232],

Cell["Form an alternating sum:", "ExampleText",
 CellID->28292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#2", "-", "#1"}], "&"}], ",", "0", ",", 
   RowBox[{"Reverse", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28870],

Cell[BoxData[
 RowBox[{"a", "-", "b", "+", "c", "-", "d", "+", "e"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109630644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29084],

Cell["Form a binary tree:", "ExampleText",
 CellID->2842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"List", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "a"}], "}"}], ",", "b"}], "}"}], ",", "c"}], "}"}], 
   ",", "d"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7548463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28592],

Cell["Form a left-branching binary tree:", "ExampleText",
 CellID->1388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#2", ",", "#1"}], "}"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249217032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10607],

Cell["Form a function composition:", "ExampleText",
 CellID->13898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#2", "[", "#1", "]"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26111],

Cell[BoxData[
 RowBox[{"d", "[", 
  RowBox[{"c", "[", 
   RowBox[{"b", "[", 
    RowBox[{"a", "[", "x", "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315720291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13517],

Cell["Apply an indexed sequence of functions:", "ExampleText",
 CellID->26601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"#", ",", "#"}], "]"}], ",", 
       RowBox[{"g", "[", "#", "]"}]}], "}"}], "[", 
     RowBox[{"[", "#2", "]"}], "]"}], "&"}], ",", "e", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3130],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"e", ",", "e"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"e", ",", "e"}], "]"}]}], "]"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"e", ",", "e"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"e", ",", "e"}], "]"}]}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373555500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27947],

Cell["Successively partition a list:", "ExampleText",
 CellID->22837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"Partition", ",", 
   RowBox[{"Range", "[", "30", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"9", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "16"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"17", ",", "18"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"21", ",", "22"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"23", ",", "24"}], "}"}]}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{557, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77492463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31662510]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17827],

Cell["\<\
Folding with an empty list does not apply the function at all:\
\>", "ExampleText",
 CellID->124683376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582673030],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438662126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135407807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " returns the last element of ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20131962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->443937487],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
  "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->943763242]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135278042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27289976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->921797622],

Cell[TextData[{
 "Functions that ignore their second argument give the same result as in ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "#1", "]"}], "&"}], ",", "x", ",", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23972],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268191271]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15389],

Cell[TextData[{
 "An explicit form of the primitive recursive function ",
 Cell[BoxData[
  RowBox[{"r", "[", 
   RowBox[{"z", ",", 
    RowBox[{"r", "[", 
     RowBox[{"s", ",", 
      RowBox[{"r", "[", 
       RowBox[{"s", ",", 
        RowBox[{"r", "[", 
         RowBox[{"s", ",", 
          RowBox[{"p", "[", "2", "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]], 
  "InlineFormula"],
 " [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-907b-text"], None}],
 "]:"
}], "ExampleText",
 CellID->10959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fold", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Fold", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"2", "^", 
             RowBox[{"Ceiling", "[", 
              RowBox[{"Log", "[", 
               RowBox[{"2", ",", 
                RowBox[{"Ceiling", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"#1", "+", "2"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"#2", "+", "2"}], ")"}]}], "]"}]}], "]"}], "]"}]}],
             " ", 
            RowBox[{"(", 
             RowBox[{"#2", "+", "2"}], ")"}]}], "-", "2", "-", "#1"}], "&"}], 
         ",", "#2", ",", 
         RowBox[{"Range", "[", "#1", "]"}]}], "]"}], "&"}], ",", "0", ",", 
      RowBox[{"Range", "[", "#", "]"}]}], "]"}], "&"}], ",", "100"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "1", ",", "0", ",", "5", ",", "2", ",", "3", ",", "3", 
   ",", "2", ",", "2", ",", "3", ",", "4", ",", "1", ",", "8", ",", "5", ",", 
   "4", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",", "2", ",", "7", 
   ",", "2", ",", "9", ",", "5", ",", "2", ",", "12", ",", "9", ",", "7", ",",
    "5", ",", "4", ",", "2", ",", "2", ",", "3", ",", "4", ",", "1", ",", "8",
    ",", "5", ",", "4", ",", "2", ",", "2", ",", "3", ",", "3", ",", "2", ",",
    "2", ",", "15", ",", "8", ",", "5", ",", "1", ",", "43", ",", "20", ",", 
   "13", ",", "10", ",", "3", ",", "14", ",", "7", ",", "3", ",", "11", ",", 
   "8", ",", "3", ",", "8", ",", "5", ",", "4", ",", "2", ",", "2", ",", "3", 
   ",", "4", ",", "1", ",", "24", ",", "13", ",", "5", ",", "4", ",", "2", 
   ",", "11", ",", "4", ",", "5", ",", "5", ",", "4", ",", "1", ",", "13", 
   ",", "6", ",", "5", ",", "5", ",", "4", ",", "2", ",", "7", ",", "5", ",", 
   "3", ",", "1", ",", "3", ",", "3", ",", "2", ",", "2", ",", "31", ",", 
   "14", ",", "10", ",", "3", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{500, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113919724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->935113058],

Cell["Generate all subsets of a set:", "ExampleText",
 CellID->117412640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "e"}], "}"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{"s", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Append", "[", 
          RowBox[{"#", ",", "e"}], "]"}], "&"}], "/@", "s"}]}], "]"}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78903678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37470052]
}, Open  ]],

Cell["\<\
Find all possible sums of any of the elements of a list of numbers:\
\>", "ExampleText",
 CellID->863611226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"#1", ",", 
      RowBox[{"#1", "+", "#2"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60762775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "8", ",", "9", 
   ",", "10", ",", "11", ",", "12", ",", "13"}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96286282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1100459763],

Cell[TextData[{
 "The fourth Swinnerton-Dyer polynomial [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Swinnerton-DyerPolynomial.html"], 
    None}],
 "]:"
}], "ExampleText",
 CellID->1748310545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#1", "/.", 
        RowBox[{"x", "\[Rule]", 
         RowBox[{"x", "+", "#2"}]}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"#1", "/.", 
        RowBox[{"x", "\[Rule]", 
         RowBox[{"x", "-", "#2"}]}]}], ")"}]}], "]"}], "&"}], ",", "x", ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Prime", "[", 
     RowBox[{"Range", "[", "4", "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398912381],

Cell[BoxData[
 RowBox[{"46225", "-", 
  RowBox[{"5596840", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"13950764", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"7453176", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"1513334", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"141912", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"6476", " ", 
   SuperscriptBox["x", "12"]}], "-", 
  RowBox[{"136", " ", 
   SuperscriptBox["x", "14"]}], "+", 
  SuperscriptBox["x", "16"]}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389766390]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1903],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8096],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->8224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->218823755],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->818913391],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->139835451],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->180894097],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->48935027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Fold"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fold - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 39.1881964}", "context" -> "System`", 
    "keywords" -> {
     "functional iteration", "discrete dynamic system", 
      "nested function application with input"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Fold[f, x, list] gives the last element of FoldList[f, x, list]. ", 
    "synonyms" -> {}, "title" -> "Fold", "type" -> "Symbol", "uri" -> 
    "ref/Fold"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4755, 154, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->496960588]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36461, 1412}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 83, 42, 1, 70, "ObjectName",
 CellID->23893],
Cell[3023, 86, 848, 28, 70, "Usage",
 CellID->6339]
}, Open  ]],
Cell[CellGroupData[{
Cell[3908, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4386, 136, 332, 13, 70, "Notes",
 CellID->29645]
}, Closed]],
Cell[CellGroupData[{
Cell[4755, 154, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->496960588],
Cell[CellGroupData[{
Cell[5140, 168, 147, 5, 70, "ExampleSection",
 CellID->10812996],
Cell[CellGroupData[{
Cell[5312, 177, 198, 6, 28, "Input",
 CellID->12834],
Cell[5513, 185, 382, 14, 36, "Output",
 CellID->7976]
}, Open  ]],
Cell[5910, 202, 126, 3, 70, "ExampleDelimiter",
 CellID->1740862711],
Cell[CellGroupData[{
Cell[6061, 209, 206, 6, 28, "Input",
 CellID->1225692943],
Cell[6270, 217, 367, 14, 36, "Output",
 CellID->711894119]
}, Open  ]],
Cell[6652, 234, 124, 3, 70, "ExampleDelimiter",
 CellID->35632801],
Cell[CellGroupData[{
Cell[6801, 241, 207, 6, 70, "Input",
 CellID->1287855344],
Cell[7011, 249, 201, 6, 36, "Output",
 CellID->1882721986]
}, Open  ]],
Cell[7227, 258, 125, 3, 70, "ExampleDelimiter",
 CellID->335893605],
Cell[CellGroupData[{
Cell[7377, 265, 248, 8, 70, "Input",
 CellID->614115886],
Cell[7628, 275, 340, 13, 41, "Output",
 CellID->529781133]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8017, 294, 239, 7, 70, "ExampleSection",
 CellID->23986],
Cell[8259, 303, 191, 8, 70, "ExampleText",
 CellID->9015],
Cell[CellGroupData[{
Cell[8475, 315, 203, 6, 70, "Input",
 CellID->29737],
Cell[8681, 323, 383, 14, 36, "Output",
 CellID->30787]
}, Open  ]],
Cell[9079, 340, 121, 3, 70, "ExampleDelimiter",
 CellID->13525],
Cell[9203, 345, 304, 13, 70, "ExampleText",
 CellID->23405],
Cell[CellGroupData[{
Cell[9532, 362, 237, 8, 70, "Input",
 CellID->28142],
Cell[9772, 372, 305, 9, 36, "Output",
 CellID->4608]
}, Open  ]],
Cell[CellGroupData[{
Cell[10114, 386, 437, 14, 70, "Input",
 CellID->1978],
Cell[10554, 402, 160, 5, 36, "Output",
 CellID->25260]
}, Open  ]],
Cell[10729, 410, 126, 3, 70, "ExampleDelimiter",
 CellID->1438551534],
Cell[10858, 415, 61, 1, 70, "ExampleText",
 CellID->764004239],
Cell[CellGroupData[{
Cell[10944, 420, 280, 9, 70, "Input",
 CellID->2083642256],
Cell[11227, 431, 382, 13, 36, "Output",
 CellID->88547215]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11658, 450, 223, 7, 70, "ExampleSection",
 CellID->30919],
Cell[11884, 459, 80, 1, 70, "ExampleText",
 CellID->16637],
Cell[CellGroupData[{
Cell[11989, 464, 282, 10, 70, "Input",
 CellID->6990],
Cell[12274, 476, 460, 17, 36, "Output",
 CellID->29204825]
}, Open  ]],
Cell[12749, 496, 210, 7, 70, "ExampleText",
 CellID->5401630],
Cell[CellGroupData[{
Cell[12984, 507, 363, 12, 70, "Input",
 CellID->31228229],
Cell[13350, 521, 461, 17, 36, "Output",
 CellID->385279015]
}, Open  ]],
Cell[13826, 541, 121, 3, 70, "ExampleDelimiter",
 CellID->11599],
Cell[13950, 546, 65, 1, 70, "ExampleText",
 CellID->13829],
Cell[CellGroupData[{
Cell[14040, 551, 337, 12, 70, "Input",
 CellID->16774],
Cell[14380, 565, 354, 13, 78, "Output",
 CellID->192118137]
}, Open  ]],
Cell[14749, 581, 121, 3, 70, "ExampleDelimiter",
 CellID->30128],
Cell[14873, 586, 64, 1, 70, "ExampleText",
 CellID->6953],
Cell[CellGroupData[{
Cell[14962, 591, 288, 10, 70, "Input",
 CellID->2437],
Cell[15253, 603, 162, 5, 36, "Output",
 CellID->99682587]
}, Open  ]],
Cell[15430, 611, 121, 3, 70, "ExampleDelimiter",
 CellID->12232],
Cell[15554, 616, 63, 1, 70, "ExampleText",
 CellID->28292],
Cell[CellGroupData[{
Cell[15642, 621, 294, 10, 70, "Input",
 CellID->28870],
Cell[15939, 633, 210, 6, 36, "Output",
 CellID->109630644]
}, Open  ]],
Cell[16164, 642, 121, 3, 70, "ExampleDelimiter",
 CellID->29084],
Cell[16288, 647, 57, 1, 70, "ExampleText",
 CellID->2842],
Cell[CellGroupData[{
Cell[16370, 652, 201, 6, 70, "Input",
 CellID->20238],
Cell[16574, 660, 365, 14, 36, "Output",
 CellID->7548463]
}, Open  ]],
Cell[16954, 677, 121, 3, 70, "ExampleDelimiter",
 CellID->28592],
Cell[17078, 682, 72, 1, 70, "ExampleText",
 CellID->1388],
Cell[CellGroupData[{
Cell[17175, 687, 269, 9, 70, "Input",
 CellID->4268],
Cell[17447, 698, 363, 13, 36, "Output",
 CellID->249217032]
}, Open  ]],
Cell[17825, 714, 121, 3, 70, "ExampleDelimiter",
 CellID->10607],
Cell[17949, 719, 67, 1, 70, "ExampleText",
 CellID->13898],
Cell[CellGroupData[{
Cell[18041, 724, 249, 8, 70, "Input",
 CellID->26111],
Cell[18293, 734, 272, 9, 36, "Output",
 CellID->315720291]
}, Open  ]],
Cell[18580, 746, 121, 3, 70, "ExampleDelimiter",
 CellID->13517],
Cell[18704, 751, 78, 1, 70, "ExampleText",
 CellID->26601],
Cell[CellGroupData[{
Cell[18807, 756, 434, 15, 70, "Input",
 CellID->3130],
Cell[19244, 773, 665, 23, 36, "Output",
 CellID->373555500]
}, Open  ]],
Cell[19924, 799, 121, 3, 70, "ExampleDelimiter",
 CellID->27947],
Cell[20048, 804, 69, 1, 70, "ExampleText",
 CellID->22837],
Cell[CellGroupData[{
Cell[20142, 809, 229, 7, 70, "Input",
 CellID->4964],
Cell[20374, 818, 1125, 38, 54, "Output",
 CellID->77492463]
}, Open  ]],
Cell[CellGroupData[{
Cell[21536, 861, 101, 3, 70, "Input",
 CellID->2427],
Cell[21640, 866, 222, 7, 36, "Output",
 CellID->31662510]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21911, 879, 233, 7, 70, "ExampleSection",
 CellID->17827],
Cell[22147, 888, 113, 3, 70, "ExampleText",
 CellID->124683376],
Cell[CellGroupData[{
Cell[22285, 895, 152, 5, 70, "Input",
 CellID->582673030],
Cell[22440, 902, 158, 5, 36, "Output",
 CellID->438662126]
}, Open  ]],
Cell[22613, 910, 125, 3, 70, "ExampleDelimiter",
 CellID->135407807],
Cell[22741, 915, 322, 12, 70, "ExampleText",
 CellID->20131962],
Cell[CellGroupData[{
Cell[23088, 931, 192, 6, 70, "Input",
 CellID->443937487],
Cell[23283, 939, 324, 12, 36, "Output",
 CellID->943763242]
}, Open  ]],
Cell[CellGroupData[{
Cell[23644, 956, 196, 6, 70, "Input",
 CellID->135278042],
Cell[23843, 964, 568, 20, 36, "Output",
 CellID->27289976]
}, Open  ]],
Cell[24426, 987, 125, 3, 70, "ExampleDelimiter",
 CellID->921797622],
Cell[24554, 992, 242, 8, 70, "ExampleText",
 CellID->16285],
Cell[CellGroupData[{
Cell[24821, 1004, 212, 7, 70, "Input",
 CellID->23972],
Cell[25036, 1013, 304, 10, 36, "Output",
 CellID->268191271]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25389, 1029, 224, 7, 70, "ExampleSection",
 CellID->15389],
Cell[25616, 1038, 571, 20, 70, "ExampleText",
 CellID->10959],
Cell[CellGroupData[{
Cell[26212, 1062, 978, 30, 70, "Input",
 CellID->8373],
Cell[27193, 1094, 1254, 21, 88, "Output",
 CellID->113919724]
}, Open  ]],
Cell[28462, 1118, 125, 3, 70, "ExampleDelimiter",
 CellID->935113058],
Cell[28590, 1123, 73, 1, 70, "ExampleText",
 CellID->117412640],
Cell[CellGroupData[{
Cell[28688, 1128, 539, 19, 70, "Input",
 CellID->78903678],
Cell[29230, 1149, 560, 19, 36, "Output",
 CellID->37470052]
}, Open  ]],
Cell[29805, 1171, 118, 3, 70, "ExampleText",
 CellID->863611226],
Cell[CellGroupData[{
Cell[29948, 1178, 334, 11, 70, "Input",
 CellID->60762775],
Cell[30285, 1191, 314, 9, 36, "Output",
 CellID->96286282]
}, Open  ]],
Cell[30614, 1203, 126, 3, 70, "ExampleDelimiter",
 CellID->1100459763],
Cell[30743, 1208, 256, 9, 70, "ExampleText",
 CellID->1748310545],
Cell[CellGroupData[{
Cell[31024, 1221, 555, 18, 70, "Input",
 CellID->398912381],
Cell[31582, 1241, 654, 21, 54, "Output",
 CellID->389766390]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32297, 1269, 310, 9, 70, "SeeAlsoSection",
 CellID->1903],
Cell[32610, 1280, 443, 17, 70, "SeeAlso",
 CellID->15912]
}, Open  ]],
Cell[CellGroupData[{
Cell[33090, 1302, 313, 9, 70, "TutorialsSection",
 CellID->8096],
Cell[33406, 1313, 166, 3, 70, "Tutorials",
 CellID->8224]
}, Open  ]],
Cell[CellGroupData[{
Cell[33609, 1321, 319, 9, 70, "MoreAboutSection",
 CellID->218823755],
Cell[33931, 1332, 151, 3, 70, "MoreAbout",
 CellID->818913391],
Cell[34085, 1337, 155, 3, 70, "MoreAbout",
 CellID->139835451],
Cell[34243, 1342, 147, 3, 70, "MoreAbout",
 CellID->180894097],
Cell[34393, 1347, 189, 4, 70, "MoreAbout",
 CellID->48935027]
}, Open  ]],
Cell[CellGroupData[{
Cell[34619, 1356, 305, 8, 70, "RelatedLinksSection"],
Cell[34927, 1366, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[35324, 1382, 50, 0, 70, "History"],
Cell[35377, 1384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

