(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55211,       2107]
NotebookOptionsPosition[     44255,       1717]
NotebookOutlinePosition[     45560,       1755]
CellTagsIndexPosition[     45474,       1750]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fold" :> Documentation`HelpLookup["paclet:ref/Fold"], 
          "Accumulate" :> Documentation`HelpLookup["paclet:ref/Accumulate"], 
          "Differences" :> Documentation`HelpLookup["paclet:ref/Differences"],
           "NestList" :> Documentation`HelpLookup["paclet:ref/NestList"], 
          "ComposeList" :> Documentation`HelpLookup["paclet:ref/ComposeList"],
           "ExponentialMovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/ExponentialMovingAverage"], 
          "Partition" :> Documentation`HelpLookup["paclet:ref/Partition"], 
          "MapIndexed" :> 
          Documentation`HelpLookup["paclet:ref/MapIndexed"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fold\"\>", 2->"\<\"Accumulate\"\>", 
       3->"\<\"Differences\"\>", 4->"\<\"NestList\"\>", 
       5->"\<\"ComposeList\"\>", 6->"\<\"ExponentialMovingAverage\"\>", 
       7->"\<\"Partition\"\>", 8->"\<\"MapIndexed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Functional Iteration\"\>", 3->"\<\"Functional Programming\"\>",
        4->"\<\"Language Overview\"\>", 
       5->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FoldList", "ObjectName",
 CellID->31400],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FoldList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FoldList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{
         StyleBox["f", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["a", "TI"]}], "]"}], ",", 
        RowBox[{
         StyleBox["f", "TI"], "[", 
         RowBox[{
          RowBox[{
           StyleBox["f", "TI"], "[", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            StyleBox["a", "TI"]}], "]"}], ",", 
          StyleBox["b", "TI"]}], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"], "[", 
   RowBox[{
    ButtonBox["Plus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Plus"], ",", "0", ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " generates cumulative sums of the elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14560],

Cell[TextData[{
 "With a length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " list, ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " generates a list of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2439,
  ButtonNote->"2439"]
}], "Notes",
 CellID->4075],

Cell[TextData[{
 "The head of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12446]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->504225620],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->327503950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], "]"}], 
   ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
      "]"}], ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322574210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19473],

Cell["Cumulative sums of the elements of the list:", "ExampleText",
 CellID->911898196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147229304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134089394],

Cell["Cumulative powers:", "ExampleText",
 CellID->736277372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "^", "#2"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32048866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "a"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["x", "a"], ")"}], "b"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", "a"], ")"}], "b"], ")"}], "c"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["x", "a"], ")"}], "b"], ")"}], "c"], ")"}], "d"]}], 
  "}"}]], "Output",
 ImageSize->{237, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542452457]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19401],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11647],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], "]"}], 
   ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
      "]"}], ",", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{497, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26998]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1165723351],

Cell["Fold to the right:", "ExampleText",
 CellID->418432524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"#2", ",", "#1"}], "]"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2083642256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", 
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", 
       RowBox[{"g", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"d", ",", 
     RowBox[{"g", "[", 
      RowBox[{"c", ",", 
       RowBox[{"g", "[", 
        RowBox[{"b", ",", 
         RowBox[{"g", "[", 
          RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304513975]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15997],

Cell["Compute successive factorials:", "ExampleText",
 CellID->4086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Times", ",", "1", ",", 
   RowBox[{"Range", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720", ",", 
   "5040", ",", "40320", ",", "362880", ",", "3628800"}], "}"}]], "Output",
 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215421755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9346],

Cell["Compute products of successive primes:", "ExampleText",
 CellID->31775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Times", ",", "1", ",", 
   RowBox[{"Array", "[", 
    RowBox[{"Prime", ",", "10"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "30", ",", "210", ",", "2310", ",", "30030", 
   ",", "510510", ",", "9699690", ",", "223092870", ",", "6469693230"}], 
  "}"}]], "Output",
 ImageSize->{492, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->699027297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37858849],

Cell["Cumulative sums:", "ExampleText",
 CellID->26997326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7740861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705249847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->693],

Cell["Build up a continued fraction:", "ExampleText",
 CellID->6865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"#2", "+", "#1"}], ")"}]}], "&"}], ",", "x", ",", 
   RowBox[{"Reverse", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FractionBox["1", 
    RowBox[{"c", "+", "x"}]], ",", 
   FractionBox["1", 
    RowBox[{"b", "+", 
     FractionBox["1", 
      RowBox[{"c", "+", "x"}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"a", "+", 
     FractionBox["1", 
      RowBox[{"b", "+", 
       FractionBox["1", 
        RowBox[{"c", "+", "x"}]]}]]}]]}], "}"}]], "Output",
 ImageSize->{189, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->977849062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1327],

Cell["Build up a nested polynomial (Horner form):", "ExampleText",
 CellID->5587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "#1"}], "+", "#2"}], "&"}], ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{"b", "+", 
    RowBox[{"a", " ", "x"}]}], ",", 
   RowBox[{"c", "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", "x"}]}], ")"}]}]}], ",", 
   RowBox[{"d", "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", "x"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]], "Output",\

 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122949501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13831],

Cell["Build up a number from digits:", "ExampleText",
 CellID->27052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"10", "#1"}], "+", "#2"}], "&"}], ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "6", ",", "7", ",", "8"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "4", ",", "45", ",", "451", ",", "4516", ",", "45167", ",", 
   "451678"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293347758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16648],

Cell["Form alternating sums:", "ExampleText",
 CellID->7755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#2", "-", "#1"}], "&"}], ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{"a", "-", "b", "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b", "-", "c", "+", "d"}], ",", 
   RowBox[{"a", "-", "b", "+", "c", "-", "d", "+", "e"}]}], "}"}]], "Output",
 ImageSize->{328, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15242],

Cell["Generate a random walk:", "ExampleText",
 CellID->2038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", "0", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"RandomInteger", "[", "]"}]}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "2", ",", "1", ",", "0", ",", "1", 
   ",", "2", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", 
   "7", ",", "6", ",", "5", ",", "6", ",", "7", ",", "6"}], "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->508847467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21738],

Cell["Find successively deeper parts in an expression:", "ExampleText",
 CellID->1516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "[", 
     RowBox[{"[", "#2", "]"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   SuperscriptBox["x", "2"], ",", "x"}], "}"}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3821262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Part", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   SuperscriptBox["x", "2"], ",", "x"}], "}"}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178167156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30226],

Cell["Successively append to a list:", "ExampleText",
 CellID->3372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Append", ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93578440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22367],

Cell["Build up a binary tree:", "ExampleText",
 CellID->11193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"List", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "a"}], "}"}], ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "a"}], "}"}], ",", "b"}], "}"}], ",", "c"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "a"}], "}"}], ",", "b"}], "}"}], ",", "c"}], 
      "}"}], ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{420, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41084366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4902],

Cell["Build up a left-branching binary tree:", "ExampleText",
 CellID->2099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#2", ",", "#1"}], "}"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "x"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"{", 
          RowBox[{"a", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{420, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3651221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26066],

Cell["Make function compositions:", "ExampleText",
 CellID->26915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#2", "[", "#1", "]"}], "&"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"a", "[", "x", "]"}], ",", 
   RowBox[{"b", "[", 
    RowBox[{"a", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"c", "[", 
    RowBox[{"b", "[", 
     RowBox[{"a", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"d", "[", 
    RowBox[{"c", "[", 
     RowBox[{"b", "[", 
      RowBox[{"a", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21024691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12810],

Cell["Compute a power using a power tree with successive squaring:", \
"ExampleText",
 CellID->21355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", "x"}], ",", 
     RowBox[{"t", "=", "85"}]}], "}"}], ",", 
   RowBox[{"FoldList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#1", "^", "2"}], " ", 
       RowBox[{"m", "^", "#2"}]}], "&"}], ",", "1", ",", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"t", ",", "2"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "5"], ",", 
   SuperscriptBox["x", "10"], ",", 
   SuperscriptBox["x", "21"], ",", 
   SuperscriptBox["x", "42"], ",", 
   SuperscriptBox["x", "85"]}], "}"}]], "Output",
 ImageSize->{206, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8710908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", "3"}], ",", 
     RowBox[{"t", "=", "85"}]}], "}"}], ",", 
   RowBox[{"FoldList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#1", "^", "2"}], " ", 
       RowBox[{"m", "^", "#2"}]}], "&"}], ",", "1", ",", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"t", ",", "2"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351456580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "9", ",", "243", ",", "59049", ",", "10460353203", ",", 
   "109418989131512359209", ",", 
   "35917545547686059365808220080151141317043"}], "}"}]], "Output",
 ImageSize->{408, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->637079116]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17982],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " makes a list of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"f", ",", "x", ",", 
    RowBox[{"Range", "[", "10", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11966],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156031228]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rest"]], "InlineFormula"],
 " gives a result of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->8320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Plus", ",", "0", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4114],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e"}]}], "}"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->325310547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373990913],

Cell["\<\
Folding with an empty list does not apply the function at all:\
\>", "ExampleText",
 CellID->124683376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582673030],

Cell[BoxData[
 RowBox[{"{", "x", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474253377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390545052],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " gives the last element of ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1421140109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165182714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700790061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2060669151],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
  "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314362594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2906],

Cell[TextData[{
 "Functions that ignore their second argument give the same result as in ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "#1", "]"}], "&"}], ",", "x", ",", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", 
       RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848467465]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227683162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", 
       RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290938336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411862236],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Accumulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accumulate"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->267742625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Plus", ",", "0", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382843853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28523946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accumulate", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114797211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->665478051]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1464],

Cell[TextData[{
 "Compute the minimum number of coins of different value needed to make up an \
amount ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->420756297],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeChange", "[", "d_", "]"}], ":=", 
  RowBox[{"Quotient", "[", 
   RowBox[{
    RowBox[{"FoldList", "[", 
     RowBox[{"Mod", ",", 
      RowBox[{"100", "d"}], ",", 
      RowBox[{"{", 
       RowBox[{"25", ",", "10", ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"25", ",", "10", ",", "5", ",", "1"}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1218334684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"makeChange", "[", "1.63", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1662146977],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "1", ",", "0", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->845640399]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31663],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentialMovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialMovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapIndexed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapIndexed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->826],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->15225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->600578039],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->41020756],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->119177309],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->12738802],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->182831101],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->985759086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FoldList",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FoldList"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FoldList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FoldList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 38.7506852}", "context" -> "System`", 
    "keywords" -> {
     "Accumulate (Version 1 function)", "binary operators", "cascade", 
      "prefix operation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FoldList[f, x, {a, b, ...}] gives {x, f[x, a], f[f[x, a], b], ...}. ", 
    "synonyms" -> {"fold list"}, "title" -> "FoldList", "type" -> "Symbol", 
    "uri" -> "ref/FoldList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7098, 226, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->504225620]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45331, 1743}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3150, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3773, 94, 46, 1, 70, "ObjectName",
 CellID->31400],
Cell[3822, 97, 1274, 42, 70, "Usage",
 CellID->5829]
}, Open  ]],
Cell[CellGroupData[{
Cell[5133, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5611, 161, 448, 16, 70, "Notes",
 CellID->14560],
Cell[6062, 179, 481, 19, 70, "Notes",
 CellID->4075],
Cell[6546, 200, 515, 21, 70, "Notes",
 CellID->12446]
}, Closed]],
Cell[CellGroupData[{
Cell[7098, 226, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->504225620],
Cell[CellGroupData[{
Cell[7483, 240, 148, 5, 70, "ExampleSection",
 CellID->327503950],
Cell[CellGroupData[{
Cell[7656, 249, 201, 6, 28, "Input",
 CellID->9010],
Cell[7860, 257, 825, 29, 36, "Output",
 CellID->322574210]
}, Open  ]],
Cell[8700, 289, 121, 3, 70, "ExampleDelimiter",
 CellID->19473],
Cell[8824, 294, 87, 1, 70, "ExampleText",
 CellID->911898196],
Cell[CellGroupData[{
Cell[8936, 299, 205, 6, 28, "Input",
 CellID->22347],
Cell[9144, 307, 336, 10, 36, "Output",
 CellID->147229304]
}, Open  ]],
Cell[9495, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->134089394],
Cell[9623, 325, 61, 1, 70, "ExampleText",
 CellID->736277372],
Cell[CellGroupData[{
Cell[9709, 330, 251, 8, 70, "Input",
 CellID->32048866],
Cell[9963, 340, 665, 24, 41, "Output",
 CellID->542452457]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10677, 370, 239, 7, 70, "ExampleSection",
 CellID->19401],
Cell[10919, 379, 192, 8, 70, "ExampleText",
 CellID->20378],
Cell[CellGroupData[{
Cell[11136, 391, 207, 6, 70, "Input",
 CellID->11647],
Cell[11346, 399, 826, 29, 36, "Output",
 CellID->26998]
}, Open  ]],
Cell[12187, 431, 126, 3, 70, "ExampleDelimiter",
 CellID->1165723351],
Cell[12316, 436, 61, 1, 70, "ExampleText",
 CellID->418432524],
Cell[CellGroupData[{
Cell[12402, 441, 284, 9, 70, "Input",
 CellID->2083642256],
Cell[12689, 452, 817, 28, 36, "Output",
 CellID->304513975]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13555, 486, 224, 7, 70, "ExampleSection",
 CellID->15997],
Cell[13782, 495, 68, 1, 70, "ExampleText",
 CellID->4086],
Cell[CellGroupData[{
Cell[13875, 500, 171, 5, 70, "Input",
 CellID->14369],
Cell[14049, 507, 324, 9, 36, "Output",
 CellID->215421755]
}, Open  ]],
Cell[14388, 519, 120, 3, 70, "ExampleDelimiter",
 CellID->9346],
Cell[14511, 524, 77, 1, 70, "ExampleText",
 CellID->31775],
Cell[CellGroupData[{
Cell[14613, 529, 200, 6, 70, "Input",
 CellID->14703],
Cell[14816, 537, 342, 10, 36, "Output",
 CellID->699027297]
}, Open  ]],
Cell[15173, 550, 124, 3, 70, "ExampleDelimiter",
 CellID->37858849],
Cell[15300, 555, 58, 1, 70, "ExampleText",
 CellID->26997326],
Cell[CellGroupData[{
Cell[15383, 560, 207, 6, 70, "Input",
 CellID->7740861],
Cell[15593, 568, 336, 10, 36, "Output",
 CellID->705249847]
}, Open  ]],
Cell[15944, 581, 119, 3, 70, "ExampleDelimiter",
 CellID->693],
Cell[16066, 586, 68, 1, 70, "ExampleText",
 CellID->6865],
Cell[CellGroupData[{
Cell[16159, 591, 328, 11, 70, "Input",
 CellID->27636],
Cell[16490, 604, 522, 19, 68, "Output",
 CellID->977849062]
}, Open  ]],
Cell[17027, 626, 120, 3, 70, "ExampleDelimiter",
 CellID->1327],
Cell[17150, 631, 81, 1, 70, "ExampleText",
 CellID->5587],
Cell[CellGroupData[{
Cell[17256, 636, 273, 9, 70, "Input",
 CellID->5853],
Cell[17532, 647, 635, 23, 36, "Output",
 CellID->122949501]
}, Open  ]],
Cell[18182, 673, 121, 3, 70, "ExampleDelimiter",
 CellID->13831],
Cell[18306, 678, 69, 1, 70, "ExampleText",
 CellID->27052],
Cell[CellGroupData[{
Cell[18400, 683, 292, 10, 70, "Input",
 CellID->3952],
Cell[18695, 695, 276, 9, 36, "Output",
 CellID->293347758]
}, Open  ]],
Cell[18986, 707, 121, 3, 70, "ExampleDelimiter",
 CellID->16648],
Cell[19110, 712, 60, 1, 70, "ExampleText",
 CellID->7755],
Cell[CellGroupData[{
Cell[19195, 717, 261, 9, 70, "Input",
 CellID->23533],
Cell[19459, 728, 436, 13, 36, "Output",
 CellID->23860]
}, Open  ]],
Cell[19910, 744, 121, 3, 70, "ExampleDelimiter",
 CellID->15242],
Cell[20034, 749, 61, 1, 70, "ExampleText",
 CellID->2038],
Cell[CellGroupData[{
Cell[20120, 754, 334, 11, 70, "Input",
 CellID->659],
Cell[20457, 767, 405, 10, 36, "Output",
 CellID->508847467]
}, Open  ]],
Cell[20877, 780, 121, 3, 70, "ExampleDelimiter",
 CellID->21738],
Cell[21001, 785, 86, 1, 70, "ExampleText",
 CellID->1516],
Cell[CellGroupData[{
Cell[21112, 790, 444, 16, 70, "Input",
 CellID->23990],
Cell[21559, 808, 505, 18, 39, "Output",
 CellID->3821262]
}, Open  ]],
Cell[CellGroupData[{
Cell[22101, 831, 370, 13, 70, "Input",
 CellID->27447],
Cell[22474, 846, 507, 18, 39, "Output",
 CellID->178167156]
}, Open  ]],
Cell[22996, 867, 121, 3, 70, "ExampleDelimiter",
 CellID->30226],
Cell[23120, 872, 68, 1, 70, "ExampleText",
 CellID->3372],
Cell[CellGroupData[{
Cell[23213, 877, 231, 7, 70, "Input",
 CellID->22574],
Cell[23447, 886, 516, 17, 36, "Output",
 CellID->93578440]
}, Open  ]],
Cell[23978, 906, 121, 3, 70, "ExampleDelimiter",
 CellID->22367],
Cell[24102, 911, 62, 1, 70, "ExampleText",
 CellID->11193],
Cell[CellGroupData[{
Cell[24189, 916, 204, 6, 70, "Input",
 CellID->2665],
Cell[24396, 924, 774, 29, 36, "Output",
 CellID->41084366]
}, Open  ]],
Cell[25185, 956, 120, 3, 70, "ExampleDelimiter",
 CellID->4902],
Cell[25308, 961, 76, 1, 70, "ExampleText",
 CellID->2099],
Cell[CellGroupData[{
Cell[25409, 966, 274, 9, 70, "Input",
 CellID->16083],
Cell[25686, 977, 765, 28, 36, "Output",
 CellID->3651221]
}, Open  ]],
Cell[26466, 1008, 121, 3, 70, "ExampleDelimiter",
 CellID->26066],
Cell[26590, 1013, 66, 1, 70, "ExampleText",
 CellID->26915],
Cell[CellGroupData[{
Cell[26681, 1018, 253, 8, 70, "Input",
 CellID->28255],
Cell[26937, 1028, 533, 17, 36, "Output",
 CellID->21024691]
}, Open  ]],
Cell[27485, 1048, 121, 3, 70, "ExampleDelimiter",
 CellID->12810],
Cell[27609, 1053, 101, 2, 70, "ExampleText",
 CellID->21355],
Cell[CellGroupData[{
Cell[27735, 1059, 468, 16, 70, "Input",
 CellID->17402],
Cell[28206, 1077, 416, 13, 39, "Output",
 CellID->8710908]
}, Open  ]],
Cell[CellGroupData[{
Cell[28659, 1095, 472, 16, 70, "Input",
 CellID->351456580],
Cell[29134, 1113, 351, 10, 54, "Output",
 CellID->637079116]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29534, 1129, 233, 7, 70, "ExampleSection",
 CellID->17982],
Cell[29770, 1138, 338, 12, 70, "ExampleText",
 CellID->2439],
Cell[CellGroupData[{
Cell[30133, 1154, 202, 6, 70, "Input",
 CellID->11966],
Cell[30338, 1162, 159, 5, 36, "Output",
 CellID->156031228]
}, Open  ]],
Cell[30512, 1170, 260, 10, 70, "ExampleText",
 CellID->8320],
Cell[CellGroupData[{
Cell[30797, 1184, 251, 8, 70, "Input",
 CellID->4114],
Cell[31051, 1194, 390, 11, 36, "Output",
 CellID->325310547]
}, Open  ]],
Cell[31456, 1208, 125, 3, 70, "ExampleDelimiter",
 CellID->373990913],
Cell[31584, 1213, 113, 3, 70, "ExampleText",
 CellID->124683376],
Cell[CellGroupData[{
Cell[31722, 1220, 156, 5, 70, "Input",
 CellID->582673030],
Cell[31881, 1227, 180, 6, 36, "Output",
 CellID->474253377]
}, Open  ]],
Cell[32076, 1236, 125, 3, 70, "ExampleDelimiter",
 CellID->390545052],
Cell[32204, 1241, 322, 12, 70, "ExampleText",
 CellID->1421140109],
Cell[CellGroupData[{
Cell[32551, 1257, 196, 6, 70, "Input",
 CellID->165182714],
Cell[32750, 1265, 569, 20, 36, "Output",
 CellID->700790061]
}, Open  ]],
Cell[CellGroupData[{
Cell[33356, 1290, 193, 6, 70, "Input",
 CellID->2060669151],
Cell[33552, 1298, 324, 12, 36, "Output",
 CellID->314362594]
}, Open  ]],
Cell[33891, 1313, 120, 3, 70, "ExampleDelimiter",
 CellID->2906],
Cell[34014, 1318, 250, 8, 70, "ExampleText",
 CellID->26887],
Cell[CellGroupData[{
Cell[34289, 1330, 215, 7, 70, "Input",
 CellID->4721],
Cell[34507, 1339, 702, 23, 36, "Output",
 CellID->848467465]
}, Open  ]],
Cell[CellGroupData[{
Cell[35246, 1367, 137, 4, 70, "Input",
 CellID->227683162],
Cell[35386, 1373, 702, 23, 36, "Output",
 CellID->290938336]
}, Open  ]],
Cell[36103, 1399, 125, 3, 70, "ExampleDelimiter",
 CellID->411862236],
Cell[36231, 1404, 446, 17, 70, "ExampleText",
 CellID->267742625],
Cell[CellGroupData[{
Cell[36702, 1425, 246, 8, 70, "Input",
 CellID->382843853],
Cell[36951, 1435, 325, 10, 36, "Output",
 CellID->28523946]
}, Open  ]],
Cell[CellGroupData[{
Cell[37313, 1450, 173, 5, 70, "Input",
 CellID->114797211],
Cell[37489, 1457, 326, 10, 36, "Output",
 CellID->665478051]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37864, 1473, 223, 7, 70, "ExampleSection",
 CellID->1464],
Cell[38090, 1482, 213, 7, 70, "ExampleText",
 CellID->420756297],
Cell[38306, 1491, 432, 14, 70, "Input",
 CellID->1218334684],
Cell[CellGroupData[{
Cell[38763, 1509, 110, 3, 70, "Input",
 CellID->1662146977],
Cell[38876, 1514, 223, 7, 36, "Output",
 CellID->845640399]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39160, 1528, 311, 9, 70, "SeeAlsoSection",
 CellID->31663],
Cell[39474, 1539, 1967, 71, 70, "SeeAlso",
 CellID->29565]
}, Open  ]],
Cell[CellGroupData[{
Cell[41478, 1615, 312, 9, 70, "TutorialsSection",
 CellID->826],
Cell[41793, 1626, 167, 3, 70, "Tutorials",
 CellID->15225]
}, Open  ]],
Cell[CellGroupData[{
Cell[41997, 1634, 319, 9, 70, "MoreAboutSection",
 CellID->600578039],
Cell[42319, 1645, 162, 3, 70, "MoreAbout",
 CellID->41020756],
Cell[42484, 1650, 151, 3, 70, "MoreAbout",
 CellID->119177309],
Cell[42638, 1655, 154, 3, 70, "MoreAbout",
 CellID->12738802],
Cell[42795, 1660, 145, 3, 70, "MoreAbout",
 CellID->182831101],
Cell[42943, 1665, 145, 3, 70, "MoreAbout",
 CellID->985759086]
}, Open  ]],
Cell[CellGroupData[{
Cell[43125, 1673, 305, 8, 70, "RelatedLinksSection"],
Cell[43433, 1683, 361, 12, 70, "RelatedLinks"],
Cell[43797, 1697, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[44198, 1713, 27, 0, 70, "History"],
Cell[44228, 1715, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

