(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66289,       1474]
NotebookOptionsPosition[     61867,       1327]
NotebookOutlinePosition[     63281,       1366]
CellTagsIndexPosition[     63195,       1361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Styles and Fonts in Output" :> 
          Documentation`HelpLookup["paclet:tutorial/StylesAndFontsInOutput"], 
          "Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Styles and Fonts in Output\"\>", 
       2->"\<\"Text and Font Options\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Style\"\>", 
       2->"\<\"BaseStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Graphics Directives\"\>", 
       3->"\<\"Notebook Formatting & Styling\"\>", 4->"\<\"Stylesheets\"\>", 
       5->"\<\"Text Styling\"\>", 
       6->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FontFamily", "ObjectName",
 CellID->28866],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FontFamily",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies the font family in which text should be rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"FontFamily", "->", "\"\<Courier\>\""}]], "InlineFormula"],
 ". Other common choices are ",
 Cell[BoxData["\"\<Times\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Helvetica\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13116],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will combine settings for ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontSlant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSlant"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontTracking",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontTracking"]], "InlineFormula"],
 " and sometimes ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " to construct a complete name for the font you want. It will then use this \
name, together with any settings you have specified for ",
 Cell[BoxData["FontPostScriptName"], "InlineFormula"],
 " and ",
 Cell[BoxData["FontNativeName"], "InlineFormula"],
 " to try to locate an appropriate font on your particular computer system. "
}], "Notes",
 CellID->7010],

Cell[TextData[{
 "When generating PostScript output on a printer or otherwise, settings you \
give for ",
 Cell[BoxData["FontPostScriptName"], "InlineFormula"],
 " are typically used in preference to other font specifications. "
}], "Notes",
 CellID->12060],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try making replacements for the font family name that you specify \
with the option ",
 Cell[BoxData[
  ButtonBox["FontSubstitutions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSubstitutions"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29595],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default uses heuristics such as translating ",
 Cell[BoxData["\"\<Helvetica\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<Geneva\>\""], "InlineFormula"],
 " for appropriate computer systems. "
}], "Notes",
 CellID->14981]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4257068],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->601249729],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Courier\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->71723857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Courier\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427933374],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Courier"]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46850723]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Times\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->37138760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343677596],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Times"]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281457506]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Helvetica\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->336261304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6607165],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Helvetica"]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104090770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390885877],

Cell["Font family can be specified in style-related options:", "ExampleText",
 CellID->140250670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Courier\>\""}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128544304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13894927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->397887262],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJydXAdUVUe3RqOIFTsqxgaxxZaoUWPZEUuisfcaNWpiieX/7RoLmkSNvYI1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   "], {{{}, 
     {RGBColor[0.34283597664026555`, 0.14333239277132617`, 0.598877755651205],
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV0tMVVcUPfdx75XahxXkI9IKlE8dIQo4aKqPJ/anov0MGCg2adqkURQb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk7trlUEQxff7MvvZmM4HdgqC+QPsczXxgSLxUVgICqJg442PNEYQtbBI
IxijUbAIWgiRpLo+blS0SCMXY3xXEhvBBLXQaKFJ/B1OcWDOntnd2Tmz6w73
7q2XKaUaCLA1p7QNXClSOggfYvEh/AR8AX4V/gDeC/8HX0v8E+zikGnWxojH
s+P9YJT4Hpgk3gmesf8X/HvpPTfhT+Fn0DKoKu5ibY54sXTuc/iO0nuWo5+C
f0OPtpQm0DfBN1DLBPoMcT+YL/yGJvqNsNYEx+AdoKf0mV+Jm+FaVeMXeCNc
axNMw+/C1xMP6s3wOnyWeJ79C/BB8Jf7f8MX0S6qkcRj5BxBuwbvhneBYeqf
hZ8lpUX9q+ErwQVy2+GL6m34rD9gCO1D2ItJ9PPwqXCvLsPPwVu6Dz4Av0W8
qvJZa9j/MrymuJ+cAi1V9k6evue+d2AAPkXOAXJn4J+Ix9E/E99Wjwuv7Sbe
k/027WnjrLLybJws/La36K9Kv1Hetlf2Sh7Lu65wLfJQXtdAX2HPN+susDF5
7THxk2zvOlj7GO6JerGisPfqgd6uGRiGPyL/dOGeNLI9k1cN0B3uoXqnO+bC
nsgLeXyc3KNgC7n7QI24M/vuOvol8g+FZ2MEPbP3Rfjt8lh3L6s8u6rhengG
5L3O1N9ZyvZWf2gU/U1279UzzVZn+C7NmGbrfnbtmrE+tO2aMbQfoIU2Eu6F
1uTVneza5Jn+Qk94dvUnNJvyWN5qRl+Hz9RZmsH/7s+RVQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.44167592992079663`, 0.3151883783139786, 0.737809266953615], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2Ql1UZxp+X8zyYq1gmOgXLJNloKowxU7C7gArrW9NMiN9yGpBq8suy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsl0UUxef7/jOfIAoKCIYtkpggiH3jQVTAAmUJiRXfjMQENNEHJWrA
GBQTEAlC4gNtaWmpS1xYXR5oGxYpBCxoXQpIQUOkFFBDIQYSA0FafofzcJJ7
5tzZ7r1zZ+zCxfNfzUMIK0AEw4sQhoG7sxDuKoVQz+AQ+J3YrTjuSyEMghfw
7+AZ9mF8rmNfA3+hN8PPYZ8FrdhXGbuEvZA1z8AfZM4o5r/CfjvQdjF2Hn07
eAs+F302+m78r6DNZ+whtHX4X4R/BK+D16NfxO4BF+At6G8zdyo+47FXscZl
7Q3agn160R7HZzJaHWNDsQeD5Znv+A++L+DTHHymH7HfQV+NVuCzsfCZdJYO
xn7GfpexdSXHrBF7EzgB7wQR+wd8brLW/4oJ9jLwH75VoJr9cnxuoK0GDySv
obmK2VF87yuci0r27IEvV7yZ2wDaou+su+bwncxvAitzxyDIxieDf4Oe8K2B
9wafqTz5jrrbcPgG+EB8EuuthZfBf0IvwXvwmZa8p/Yahj5AtQEeY70Mn3K0
qcnaUnxmwJ9MXnsZfD2+4+GLsJvwr8Hux1gf+hpwGH4/fCDaIXgJ+whrTAyO
kXzb4Usyz+nA/6noWmqHd8HPJOf2Y/gzaJ3wo9ibVNOqbbBXd8dnF9pesEe1
jP4F9pfJtVcOzjF/CxiLXg3firYT3gXfAmrhrclvoR/6h2gvgynwwWBb8hz5
bgVN0W9Eb6M7dy51Rp1NOd2A/SL665lzdAz+KRiJ73uMVWAfQN8Pnxys/Q7W
ZvZ5tvCb0FtYUHLunwPfZq6B75U/cCB3zv5A+wyM0fvC52+0oclz9YansF6W
XDt6g3ob25PvojdSHV3Dqt1msDG6hlQ7irFy/URyLJTz3cpNdKyVw9roGlDu
W0Ad9pHk3A9Cf0l3je4dp8Wja0i1ozet2uxfuPZUow3w/czZlztGffCn4eN0
X/Ru7M+Tc/tn7ticTbYVo23w48m95RHQBZ8FH40+uuTe0whqc/cgxa47+i0r
hu8rnsm1t5nzreRsx6PvUqMeAr+j8F0noc8pXBOqBfU89Ubtqb3UIw+x1sHk
XCtnFdid6B9kPtOb2POic3cl893Vs2/3arAEe0507fwLrkb3MPWuMvjc6DPq
bBXsUc/8TxhrY+56UKW7MbZKtZu7dyqmiqV6qN6mepx6m96o3srD8HElv5mT
8AbmV+U+cyX2JPSyknNyAn4sOdYd8JvYi5kzIbiHae9Q+G/RGTT3t2RfrTER
PqFwL9SebzB3pno2/HLmv6kluTb1R52KjplipTej3j4tOhfq8erl06N7g3r6
BeY+H51LvXn1JsVUsVSPWoD+WnRvfBT9XvR7CvcC/Snqpb9E9z71VNXO5uhe
pRqakZwDxX5E7r/ja8Z25P5D9iT3VPVS9ah2+Ozov0A5Oql8JedSPU6xVg5v
5w58lfzH6m/Vmvq7FSPFRn94L1pfcm4Vc/1NldG9Tn/Ur9iN0WdTTG8BdGEX
0Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5405158832013277, 0.4870443638566309, 0.876740778256025], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1lsV1UQxu//blp4oCAgiQvxoSWoUJ9IJOASReiCQcEqLgkIifLgHiPG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsT1EYxd97//v+URZqaGMum4ohlhKJFimqA6ERswQJrYUaFkIiphCN
BBGJWc1VNqaFJVFaQwgxj5HWHJSYVhK/k7M4yTn3fPfd+777fd+ABUurapMo
impAAN/SKPoMZsRR9BHjBvwm2AGfil+WjaJyMB9dScxVNv3F/46eBBai29Gf
tBe/Fb2H+JuZKFrG/nnoU/gn8M+gr8ObQEdim1jbC88lvgPx29DPiN+NbkEv
IL4dvQ99Fz2QPdXwr6nvuoS18fjXUn9rHX4n/BywCp7gn8Wvwm9AjwDv4I2g
BP6GPV2IvU/MhMh3+I53DsyM/U9z8d6mjr3IWnfiu+kMeA7xJfqXrM/qQcwD
4jeid6HzianFrwYTlE9Qgz8bPRz+Gn8cfBJr0zm/D2sv4SdBAXw7/jH8o+AQ
uh4U8u33ylHsmEfw48F7t7A2FH8IKIQXcoee8If4m9Gd0VPhW1lrgK/gzLfo
OvSxjPec56wL4EHsHDyFPwFrI99hLLyePbmxv/kz+I66m3K8gW+NY62U+J18
sw+6N+iKVwfaiG0FB/CPqxDhRfhFGa+Jx6wVZ7ym3Gxh7XDGOTqHHo0egx7E
/grVDvEV6HIwBj0KXIgdsy91DvTvqmnlXjWk2tEbHIEfBe2J/7k465pRregO
qtUWcC1xzapXvoAPiXtmP/w2aE78jwfZezV1LapGDsHvghv4PdB/gv9Bd29E
H4b348zunFXKWgG8b9a50toX/MFZv6Xe4IXeEn0A3Y+YO3y7Pzov4zN24Bel
rq3HxH+EXwru3ebYvdsknbiHldtXwXdTjtULXbOubfVEM/GlrK2PnYOJqldw
Cr0+cq8+D6519ewvxYJ/sWNUW5ODZ4FqTHevDO5t/cO94JpRraimdJZ6Sr2k
M1WrX4N7XzW7Cj4xuDd+gpXwiuDa/wHK2VuWurb3oNfgTQnmf2PPprbg3GlG
DSN2OXpk5JkxBz9fbw4fxh1uwXuxlpvxGyvXuoPOVs7fBZ+hb6sn1ftlwbNT
M2B16hmo2acZuhg9GExO/Aaabd+Cc6kZdwS+CH984pkhrhpRbWgtJ3XNq9Yr
we/UM1mzWDXcgD6Zurc0cxP4JvwkcU/UBc9szeoc1map9lLXhmo6L3WMPOVA
bzkjuFb1pqfxK7M+WzNUudEbKPfKkXpxWurcqSd1tmaoZqfucBnvSupZrxnx
H+PNz+g=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6193565456522419, 0.61679581840411, 0.9107647837322218], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0tsVVUUhs+554GiEyVSikqpGmxJFDpwIolFxUSFtkrQIEFAIwUdgEY0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIl1EUxd/f/3sfZK2SBpucGpQgdVGLgrQJKodKGsxCKxq0oIFoUWQQ
RSAtTIiwwDQa1EhSV1LuWmk0LFK0edFEkwZa1iL6HW6LA/fce9797vfuvS9t
16GSgwnOuTLgwWBw7g5GH85nYAg7B9+fmHON4Ce8NnKuLe7cEngR9nji6+DF
IAeeC7Kws4inY7/mTDJ8KmjC3oe+hlgSGIddiKaZb3XD+4ifhdejTYbPxb6J
LxU7Fd9G7DWcSUd/Fd8IfBGaHGK11F9E7Lu3WmejmUPsg7ezKeAC9gGQRywJ
VKF/AN+D/i3Yj32RM11oe8n3CV4NxojVgyvopxOfSLyO803YjWAAPgi60G4O
9i/FoAz+HN6P9gz5stDOiyxXBvoXxDqlIT4A3sPfgQa0t+AnsSvQ71Y9nNmJ
tg7eCW9EM5/40mD/spf4MmL5kfUmH81C9Qa+HnslvvPYw95604JvBXx5ZLlU
wzbsyZzZQawC/EJ7GvxF36r+E7sW2b+eQF9C7Cm+h9iV5KghtgHfUewbaLZH
die6C+UsR3scPgJfzJkEeF5kteqfJwWrQd++B7+P9ge+z2i/gCmaHXyJ2D0x
q20ruB2zGjW7Y95q1QyP6tvBZiGXnNnkXhD97wW8lVhLsLvWDHZ464l6MQje
eJthze60uM2aciqXZu63tzPSqoYZxPtVk7MZ2eTtznXXx9RTeGZkve/lzEdv
d6a7yuT8OewizSPaBnwTgu2Ydks91G4UEC91tiP61kx8SXH75pNg31DuHvDS
W07l0g51EG8Hd4m1g1XY173tWi14BH8MLiVYDdr9b952TW/A2mA1q1btYHlk
PVJvNKNbiJcG602bs13SjGo2tVNV8MrIduur5t3bjmo3NTNt3t4gvT3amQxi
q4PNlt6Q7GA9US80Qw3wNM1s3Goehg8Fmx39Y3FkNakWvVHancRgu6Ad0ltW
6u3t0JumXK+83YVyarc7g92VdvwI9mFwOWZvwmiwndAu6A1JQT8rsrdNPWn2
1hP1QjtyCrs62C5rhjXb3d7uQjNeCC8INiv6Rq92K9hbo57/A+6/vcU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6920267820769206, 0.7335566676302089, 0.9124214412953171], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlklsVmUUhu9//3vvwgF3bXVFW0f+P1Y7GgQXaImJY6st0Bq1NdCBBEes
BmpE6cI4RFpXrNqaaCJY0HYnZeVOEw20JGAilG5cysoqNfF9PG+jiy/fud9w
hve853y3fvDl7gNpkiRrGmWNoVKSLGn8IPmuIknu0WjQxseaWzWq2ntC8015
kpyVvFOjS/vTSczdGqckH9d6o8aY5A4ZOFAOvSvsaxzT+v3Sc59GRd+/Z0ny
oeRpnZnVqPjuNdn5Tnt9+u6Vnh6NLZI7bRdb3GHtqORn7QN+tWi0SZ7S+rB0
jxThB/vP+C66ny9C/6DWXtJ4WnI1i2/kVutBPzGNaH5LoyJfdmh9QWtl+fmI
9Dys73aNDttdl56tRXw/4L0Nfe0+s4N7RejqT0PHdvtQ0RjQd4v2m8Ff8muy
9YnkPTr7oOa/s9BdyiJXDbq7V3v9ziNY1pcDz3HdfUdjSPuHtHZY41ISmHQZ
tzNZ4A4mC5rfkI1h41O1P/iFDD51mms1hqXzXDlyTH6b0uAIZ7AzbluNWr+9
HDlbdC7nzL1DPvOT7H6ZRSzbSsEZODaveU5jJgk75/x9WWebdOeYzk5r/ioL
rnbL91vy4MVKKWxcTMIfbBFXh862a9QYP7B6U2caitCLzovS8bXkZsm/SP4m
C7/WNJ/0+oji2guOkt/Tmds0fpR8q+YXi9jjDDjBvS+yiJMY5/PAGn/IY5KF
H/3O5Zkk4lxy7JvT8KvR+KMXu+xfNX+wA7bYWvV6Xxp8xXfwhG+rXmd/1XeJ
70/H2Cq/8jzW++wPvBpNwy76O22PPF4hHxq706gZ8jyRRDxwEWzXNX/uOqev
kLOqde9zvMxDltFFrNQdtdPiegeTeXNjwfKMebJgPp90DU9Yz2XXArUOR+En
a/iND+/nkT9ydwf9Bp2Sl40/OHybBQ82uHnanG/Q2qjiWfb6nH27u4h8k+vr
mjuK8Ise0OaesEl3u4roTeSdOlvU3Xu11lSEHyfc1yaT6IUVx0Vtch6s6AtX
jP+sY6uaG8vGZ861M2msdpoPFfODfG5wgjOnXNdz5go+0LuuGhPOgNWM/UN3
s/3Ev1bni/Xz3tuaB9bgfN7+gCH1RL1x5vssamO49F/fAZNh9wp4WOM+BPd6
dHYwixipaWqbuvhLc0semNd6vcZ1dtxvza9Z1Dx1dbPOtueBywf0tzywHdD+
IrrSeI92pcHn3drflQef4Dl6x/wOJs77hVL4vdGTe3y3x7qQ6Ze56+jONPyd
8BvX6LfvMdl5PI/viutowrY2u07I+azjYh9dnAHrdmNywvwmXzfQO4voxzXu
h+D8kdauZaFjj+YjWeSoxm/Tv7jz/hRho9l6yXutMSaWV6T/1Tzwovf3Ohb6
D3yacr1T//SY59LYm3LvQt5ubnF+0n0Grlfdw2sdF3OdZbCgDsbMB+Inrop8
+ayIN+GhPL5XzKkh54jeVud3DTvoof8suQ7wgTrvt87T/rfZ5rUL1sP/z9L/
3h5m3rgGv9kbfCmZJwd5c/PAYJ/W1vLQtSmNGd1L7sXoP6L9d/PoxxVjjj/8
K9BnZ92ba50LuLtsn7eYh3BjwH0HnoPzjGuW/7Pr/n4U3hXBM3rEgvsG2BEn
sb3NP1Ue/0mX+I/IghP4se6e/4J0HM4j509JbsuD98uOs9+5oxbRw79hTxZ1
wLlF1/vPutftGsbHaft8Yx7/qdQTvZb6p5bg61nf7c2C33Cbnl2fh33qYCAL
G+Oaf8uiNmds46j/dTsdO/1gfxG40gOeLKIPZHn0I3oRdfOHawe9FeMHB0ez
wO+g5NeL+DeBp+gjR/u1/2kW3PkHp6dZgg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsT1EYxd/re/ctDLU0rFTNLdVBJ8OiFZEYqv9OWmMrqq2kRVshKWUp
QoodFspCYo50WVaWFoJKiEjs2GGj0kr8Ts7iS873nXPvu/d8330FXQO5/rwo
inYTKdGYRVF7iKJn4KYkii6AL0NMkh9HuIS8E005+E0cRYfAh4lu8g7yDrQN
aFaQPyLfCJ5DvAQHagfRLiI/yt5dxCnwedacYf82+HnkDZm1r1gzQH4ymGsl
utDegJ9g7Thr6sFf4CfQ1lFrgz9N3o72LHwN/Cy1KrhKYghukNgPf4CYBr+G
72H9R2II/TAxkriWg9uBZinaW+SFcF+pXY9dawHvhC8E36X2nXwVmmWJ77QB
XAo/A1dErQR8Dk1v5D1q4Zuo3Yx8xr9wY9SegzfDl4FHqc2Ci6k9AX8O9raM
aAbXZb57UZ73Gg6+m/a8BneVKI7tyS/WPyVWgu/H9iIh6hN78iO15/J6uc7L
2nXEONq1ib1+kfps8nxhcE/VS82Ier8+s1YzsIB8L3mOvJnoBf+m9oG1/eS7
gr+pb8lDcZOpZ0maI+hrqDWCjyX2pl3+R/boHVx5Zm/uobkDToNnY4raHvK5
wbNUop6DezJ/u4q8jHwTeTV5BZrb4OnU3r6ndhF+lOhF25fn2ZtPvj32DP5L
PWOaLe0xqLNophPP0BX47tSzlc/6E5oN+KnYb2hE2uC3pTcUgu+gs29BM8ba
rdS+gT9xp2q4GWqPY/dQb2lf8N30pnTWxcFe6cx/Ut9Jd5Fn28AVwXur5+pN
fvBbV4/09i8F31X/gM7UM6bZ0hvuS+2hvNOZ1Jva4H+BevQwdU/UC82cZv9n
6rehN1Ae7Lm81h3W8P3V8iT2m9Gst6aeTc38A/Db4LcnjWaxNPNb0kwWBHss
b+VpJXku86ypR/8B4XuJPA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7644864248373172, 0.8476167347436998, 0.9131997713355886], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVslvzlEU/U3vWYjWsNLaGFaiiWjJZ4huDF3SCjWGSli0tIZiZVhQiWEh
WGBVNiqVfobqyleNXbGw0aTFwj/QsjGGc5wjFi/v/u677757zz33ft/8ts7m
w1mSJBWsHKsOHy/SJLkLubZIkk58t6TaaViGfje+2yE/h9yV6Yz6qkL615A3
prIfgNyB/ZDtawr5pc8+PHgfaznkA7nsdtl3h+3PhCQ5izUK/TLYFLh7I9E9
yrz7GLaPsMbtf26hd5tTyRXHVl38919leWWhO4xnEj6nsHpgfwxvHsd6ythw
fgnrFfQXoevBegP9rUx3bkJ/O9Nd6kZyxUP7oVSYEs/n8HEoJkkDvr9gfTZW
V6C7ivUgF5bEh9h18TuXn7FUd2j/DHJjKhzyoFgZJ/EgLtQzDsoXjFWf5bWw
u54oHubAWIhPqRAWxKHGMrEj7kszYbkd72yO+n6Csy1RufHd4Fp8h80J6CcS
xbQ405st0K+K+ua7Jb9VwVqSiS+XobsKu+pMb5dcu3epdOQdMZ40zsSoxrX+
ZB6QA4OQc8i9xBb+Lgfh14B9XdRZP75/GwvifCQXH3Zi347VBLk1V1z0Uw+5
wVxlrvWWZ8Dntag8NmDfiLUh1zn5et3cqDOv7uA8BMVYzlRf1vQ8fJ6Cvsj0
LmNgTw3DLrqPWHees/bEgjnx7krc2wu/03G2CXt10L0fxDAqbnK/yzkuwHl7
VM7sy+nuNfZ9k3t/Nmy2wmaHY9nheBgve4fvPjLXy+Y+82SOrzPJ5Nt4plr9
65Fb1q8J6iVygTWjjwnjTHyJ3Yj5X3YvMIdO60bcF4xhyr12hvei/JPX5A35
U4t32qA/6P7i3pL+r3Gv51Wrc/wI+/dBsbPv5wf531roDfpfwr6L4l2jZxP7
7gT004L6fiITF1g3zox5zrfs3me+5AX7/h70e+D7QxBWRRBXBu3nmfud+ZbN
89U4XxbE42/YfwT5ZS6D5u3coBk66lnIPv47G3F3RRC32t1brOks6FqiuMA+
eWo/F6A/HzTvWYcq16LW85O9uAjnHVG4rwriJbl1MggXYsI4GAP5RtuFQfYd
jmOXOT5kXN+Z66xjPezfBvFrJvZSUJxHsW8rhCF9DzvHz8aKefFeX6G7VUF9
QrvuoNnEufQS51+D+MSZRAz//Y5xL3tuNhmTTvg4jNWda16WPDPrXM8ez9t+
zxnmM+T+Iu4Vx/mT8zbK7r5nG2u9Dbo5QTOpKWrm1nle7zaG7M1Wz6uHOJ/y
HKa/X4V8sp4zjRXrMeq7Fec34Pn/xjjvj/qtYg+xFwv3I/Pkb9CY7zfb/lzQ
bwN/F8jHenOy0bky98WeucRjPfzHIE7Tb6PxYb9NOHf6GnY9e40jfXXj7nGs
07m4udbn/Ob8/+TfijHzhrO5rVCuxHXc/vdBXxP0v+MPvDMbIA==
         "],
         VertexColors->None], 
        PolygonBox[{{1588, 1677, 939, 813}, {1645, 1316, 471, 564}, {1676, 
         1110, 134, 938}, {1335, 1623, 859, 328}, {1594, 1276, 429, 554}, {
         1408, 1409, 560, 459}, {1334, 1293, 447, 518}, {1213, 1633, 870, 
         348}, {1308, 1635, 564, 462}, {1410, 1411, 621, 620}, {1299, 1621, 
         857, 859}, {1339, 1340, 462, 339}, {1313, 1642, 880, 204}, {1295, 
         1618, 518, 448}, {1336, 1335, 328, 449}, {1274, 1591, 819, 148}, {
         1396, 1397, 554, 437}, {1632, 1305, 459, 523}, {1607, 1605, 439, 
         838}, {1221, 1529, 754, 755}, {1400, 1399, 440, 516}, {1365, 1284, 
         438, 556}, {1412, 1307, 871, 623}, {1643, 1213, 348, 881}, {1122, 
         1365, 556, 447}, {1411, 1338, 523, 621}, {1642, 1314, 881, 880}, {
         1622, 1370, 177, 858}, {1621, 1298, 858, 857}, {1277, 1595, 511, 
         429}, {1502, 1503, 731, 150}, {1586, 1587, 717, 134}, {1265, 1676, 
         938, 309}, {1617, 1294, 448, 560}, {1501, 1203, 732, 731}, {1646, 
         1221, 755, 885}, {1420, 1647, 885, 472}, {1651, 1653, 894, 483}, {
         1315, 1164, 527, 471}, {1370, 1414, 624, 177}, {1440, 1588, 813, 
         667}, {1592, 1198, 309, 820}, {1306, 1410, 620, 870}, {1604, 1283, 
         437, 515}, {1634, 1339, 339, 871}, {1460, 1459, 690, 691}, {1194, 
         1440, 667, 717}, {1678, 1394, 420, 939}, {1652, 1460, 691, 894}, {
         1287, 1608, 557, 440}, {1459, 1220, 753, 690}, {1422, 1421, 472, 
         527}, {1286, 1157, 516, 439}, {1331, 1274, 148, 511}, {1285, 1332, 
         515, 438}, {1531, 1530, 220, 754}, {1528, 1126, 204, 753}, {1591, 
         1275, 820, 819}, {1413, 1412, 623, 624}, {1203, 1606, 838, 732}, {
         1620, 1297, 449, 557}},
         VertexColors->None]}]}, 
     {RGBColor[0.8297492293531931, 0.869380141060736, 0.8839620933966047], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVbtOVFEUvXPvnMuIkoDa+YrxVVloQiTBYgoRoTQ81DhMAmiARHBmTMAw
xsSIUQQf/wA/IBWVyqAdDq0kow3wBTZq41pZy0Cxc87Zd+3X2vuce3p46uZk
HEXRS0gC2clE0QSkjn1niKLhNIoOAdCArEKfh5QTYb4B8wKYO5BL+L4O3WWs
K9APwu4K9E04Xw3yRT9bwHTE8k+7gVS2dehbsPZjfQjdOXz7jn0FsdqyinkU
3/OQXeg/QlcCrh3nzYzWz/C5kZG/PtrGivkJ+vupbIgbghQgPcDUIDnsezMS
6pci5UF/HyADiD2YCN8FP92QLpzXMqqPGNba4XqZd9H2uax4W8Z+CnYLwFRj
1bJrrincN4A5hu/Pg+ogJ8yDfLIexqHPUfg5Efwd+yNBucwj1usgHhexf499
q2tbt5+a61x2jZvOszMWDzX3sG78AvycCer1PNZXQTasb8tz0gzMwaz4eYfv
b8Nen3eMYQ9b3cdSrP0Qvj3F+RfO29ivQncvVXziiKHtNHQXg3yxn+SGPW31
PBXdt2bnMIc1DeojfbQ5Fu3JO/lmj2hPW/byADDXEvWLe875/zO5OhzENXlm
P3PGsC9r+3pTdG79ifJZ8fyQH+raPR/EluHva1Y8zTovzkA5FkfMmXyfMuec
26Lncxq6maBzG9a+VDM6An+zOI/GugdrzpHxm50D+zzq+7oCXSOolvGM8mAO
I/B3HPox4P9g/RvUp99Yv2SFPRk0i3X3+lkijmege5zqvOH45IQ9po9x37l1
z2J3otp6jOszPz/h/0fQ20M+yr7LzKlsftjfkt8Tcl8yhj3MuadV8zvunjIm
OSz4LeD+bqK5Y068f3O+g7224QxwTrhf8swX/NYxFr+RQ87+Bc9/i98m3jPy
3u85uQFumoLq3jbvDc8JccTw3eMd4L1j/k9i7Rdh9yboXPDdZg4T7h0x7M9k
utfPqvUlzzu54jwM+E0jlxXzxriPEnF7PdV85PfVwFi3ob+VirOzyOVBKpvz
QW8355t3rmI/E/5nMO4/+TW/dw==
         "],
         VertexColors->None], 
        PolygonBox[{{1416, 1340, 524, 627}, {1311, 1638, 565, 464}, {1531, 
         1529, 361, 756}, {1286, 1605, 837, 164}, {1420, 1421, 637, 636}, {
         1646, 1647, 636, 361}, {1402, 1625, 860, 452}, {1169, 1132, 576, 
         532}, {1222, 1656, 898, 568}, {1214, 1635, 872, 350}, {1413, 1414, 
         561, 461}, {1299, 1623, 519, 450}, {1422, 1164, 206, 637}, {1622, 
         1298, 450, 561}, {1296, 1619, 854, 178}, {1415, 1416, 627, 626}, {
         1607, 1606, 320, 837}, {1501, 1503, 733, 320}, {1398, 1399, 607, 
         606}, {1657, 1655, 485, 898}, {1325, 1169, 532, 485}, {1287, 1398, 
         606, 839}, {1425, 1424, 474, 528}, {1308, 1415, 626, 872}, {1375, 
         1159, 520, 571}, {1419, 1418, 464, 525}, {1336, 1296, 178, 519}, {
         1620, 1204, 329, 855}, {1309, 1162, 525, 463}, {1317, 1165, 528, 
         473}, {1634, 1307, 461, 524}, {1502, 1118, 441, 733}, {1315, 1644, 
         883, 206}, {1619, 1297, 855, 854}, {1654, 1530, 756, 895}, {1319, 
         1650, 568, 474}, {1637, 1310, 463, 562}, {1624, 1209, 562, 860}, {
         1400, 1157, 164, 607}, {1649, 1318, 473, 565}, {1403, 1402, 452, 
         612}, {1644, 1316, 884, 883}, {1159, 1123, 612, 520}, {1204, 1608, 
         839, 329}, {1645, 1214, 350, 884}},
         VertexColors->None]}]}, 
     {RGBColor[0.895012033869069, 0.8911435473777723, 0.8547244154576208], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFU7tuU0EQ3eu9eytT8LhliCiAij+ggU9IgYgoEtsKCNsCgfJwHMnYchHJ
KFLMt7hJ60ip49a2oCT+C87hnKsUo505Oztz5rHPml93vtRCCB8gETKA8QNy
C/1BHkId8jnqpP0uC6GVQmhC3sKvg7ML2YG+yXT+xdmO8ufbh8DWwBqZbJ7z
oJhN3F1DHwEfQn6H+3zEj3B/XJP/MfBHwBfQu1F3+5nydTPh5LSOykds4Fr4
ljZ1xnic6+1hTTb1J7n8/wThR847QX0/k3iQbwsyC9Lr7gnjMQ7znETZ1BmP
cTuZ6qPO+J9w/kLMkfMcupYylw99S2B3roP9KY2fFCGcFsLoWzr+yj1m3/rR
vch0zjwfzmJk/DRq1nx7CS5TyBB2D7FvqphR/eTbc2B7SbUvozgzX8t9YR/W
zrtx78md9TLP0LPgW8blvMiddTAXOS29H+wh+0f/lXkT7yP/WVLOVi5O5FPt
Fmvn7lGfW+9EcfuIuraTdmdtDsx5BrwPGcN+gftv0Hvelzvz546Vrmfs2RCb
IP9WUi72uPoHnD9r4Eyf4v6gEI+N95W1875nnyv4vy/Ek/PpVzsMfJrrX6z8
/v/+Z+rPwv+07Rpf19SrlWe3dBzyfeN9+o48L5PmzxkuHafh/zD3vAbeDe41
cfrsFpoB+38B/HnSjMjxVRLPf9wsizA=
         "],
         VertexColors->None], 
        PolygonBox[{{1417, 1418, 630, 629}, {1637, 1209, 342, 875}, {1648, 
         1318, 888, 887}, {1325, 1655, 897, 222}, {1215, 1638, 876, 352}, {
         1166, 1127, 641, 529}, {1657, 1656, 363, 897}, {1624, 1625, 611, 
         342}, {1388, 1386, 487, 594}, {1170, 1133, 577, 533}, {1378, 1171, 
         692, 578}, {1319, 1423, 639, 889}, {1403, 1123, 180, 611}, {1419, 
         1162, 194, 630}, {1649, 1215, 352, 888}, {1423, 1424, 640, 639}, {
         1309, 1636, 874, 194}, {1425, 1165, 208, 640}, {1311, 1417, 629, 
         876}, {1386, 1659, 899, 487}, {1658, 1170, 533, 899}, {1317, 1648, 
         887, 208}, {1376, 1166, 529, 572}, {1222, 1650, 889, 363}, {1426, 
         1377, 890, 641}, {1636, 1310, 875, 874}, {1171, 1387, 594, 692}, {
         1377, 1379, 578, 890}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{233, 593, 232}, {1387, 1171, 232}, {237, 241, 232}, {245,
          241, 237}, {1386, 1388, 593}, {1659, 1386, 593}, {573, 237, 232}, {
         593, 233, 224}, {1377, 1426, 573}, {1171, 1378, 232}, {241, 249, 
         233}, {241, 245, 225}, {249, 241, 225}, {1379, 1377, 573}, {237, 573,
          210}, {1170, 1658, 224}, {241, 233, 232}, {1127, 1166, 210}, {1166, 
         1376, 210}, {1133, 1170, 224}},
         VertexColors->None], 
        PolygonBox[{{1388, 1387, 232, 593}, {1426, 1127, 210, 573}, {1378, 
         1379, 573, 232}, {1658, 1659, 593, 224}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1133, 1170, 1658, 1659, 1386, 1388, 1387, 1171, 1378, 1379, 
         1377, 1426, 1127, 1166, 1376}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1132, 1169, 1325, 1655, 1657, 1656, 1222, 1650, 1319, 1423, 
         1424, 1425, 1165, 1317, 1648, 1318, 1649, 1215, 1638, 1311, 1417, 
         1418, 1419, 1162, 1309, 1636, 1310, 1637, 1209, 1624, 1625, 1402, 
         1403, 1123, 1159, 1375}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1118, 1502, 1503, 1501, 1203, 1606, 1607, 1605, 1286, 1157, 
         1400, 1399, 1398, 1287, 1608, 1204, 1620, 1297, 1619, 1296, 1336, 
         1335, 1623, 1299, 1621, 1298, 1622, 1370, 1414, 1413, 1412, 1307, 
         1634, 1339, 1340, 1416, 1415, 1308, 1635, 1214, 1645, 1316, 1644, 
         1315, 1164, 1422, 1421, 1420, 1647, 1646, 1221, 1529, 1531, 1530, 
         1654}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1111, 1394, 1678, 1677, 1588, 1440, 1194, 1490, 1587, 1586, 
         1151, 1110, 1676, 1265, 1198, 1592, 1275, 1591, 1274, 1331, 1330, 
         1595, 1277, 1593, 1276, 1594, 1363, 1397, 1396, 1395, 1283, 1604, 
         1332, 1285, 1692, 1284, 1365, 1122, 1682, 1293, 1334, 1618, 1295, 
         1616, 1294, 1617, 1369, 1409, 1408, 1407, 1305, 1632, 1337, 1338, 
         1411, 1410, 1306, 1633, 1213, 1643, 1314, 1642, 1313, 1163, 1126, 
         1528, 1220, 1459, 1460, 1652, 1653, 1651, 1324}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1131, 1168, 1342, 1323, 1684, 1130, 1372, 1640, 1641, 1522, 
         1212, 1521, 1211, 1630, 1631, 1404, 1405, 1406, 1161, 1303, 1629, 
         1304, 1368, 1367, 1614, 1291, 1613, 1292, 1615, 1333, 1290, 1681, 
         1121, 1364, 1602, 1603, 1500, 1202, 1499, 1201, 1273, 1680, 1113, 
         1153, 1271, 1691, 1272, 1196, 1497, 1197, 1498, 1114, 1359, 1582, 
         1583, 1581, 1585, 1584, 1329, 1264, 1675, 1109, 1355, 1356, 1257, 
         1391, 1392, 1393, 1149, 1256, 1575, 1577, 1576, 1190, 1487, 1191, 
         1488, 1106, 1352, 1571, 1246, 1570, 1247, 1327, 1145, 1374}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1322, 1385, 1219, 1527, 1218, 1525, 1526, 1697, 1696, 1695, 
         1458, 1457, 1456, 1520, 1519, 1125, 1160, 1301, 1627, 1302, 1628, 
         1208, 1366, 1288, 1611, 1289, 1612, 1449, 1448, 1509, 1508, 1117, 
         1156, 1282, 1599, 1601, 1600, 1200, 1270, 1679, 1112, 1152, 1268, 
         1590, 1269, 1358, 1357, 1262, 1689, 1263, 1328, 1261, 1674, 1108, 
         1353, 1354, 1255, 1673, 1105, 1148, 1253, 1573, 1254, 1574, 1189, 
         1244, 1670, 1101, 1144, 1568, 1485, 1486, 1437, 1569, 1245, 1671, 
         1102, 1349, 1187, 1237, 1668, 1099, 1142, 1562, 1482, 1483, 1434, 
         1563, 1564, 1238, 1565, 1567, 1566, 1183, 1382, 1184, 1383, 1390}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1129, 1167, 1341, 1321, 1683, 1128, 1371, 1639, 1517, 1518, 
         1514, 1516, 1515, 1626, 1300, 1512, 1207, 1511, 1206, 1609, 1610, 
         1401, 1120, 1447, 1446, 1445, 1507, 1506, 1116, 1155, 1280, 1597, 
         1281, 1598, 1199, 1362, 1266, 1690, 1267, 1442, 1441, 1496, 1495, 
         1107, 1150, 1260, 1578, 1580, 1579, 1193, 1252, 1672, 1104, 1147, 
         1250, 1687, 1251, 1188, 1243, 1669, 1100, 1143, 1241, 1686, 1242, 
         1186, 1235, 1666, 1097, 1141, 1560, 1480, 1481, 1433, 1561, 1236, 
         1667, 1098, 1348, 1182, 1232, 1665, 1093, 1139, 1551, 1471, 1472, 
         1432, 1552, 1553, 1233, 1554, 1556, 1555, 1179, 1473, 1180, 1474, 
         1094, 1476, 1477, 1475, 1479, 1478, 1095, 1347, 1546, 1547, 1545, 
         1229, 1326, 1137, 1373}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1320, 1384, 1217, 1524, 1216, 1523, 1312, 1694, 1693, 1455, 
         1454, 1453, 1210, 1513, 1124, 1452, 1451, 1450, 1205, 1510, 1119, 
         1158, 1444, 1443, 1505, 1504, 1115, 1154, 1278, 1596, 1279, 1361, 
         1360, 1589, 1493, 1494, 1491, 1195, 1492, 1258, 1688, 1259, 1439, 
         1438, 1192, 1489, 1103, 1146, 1248, 1572, 1249, 1351, 1350, 1239, 
         1685, 1240, 1436, 1435, 1185, 1484, 1096, 1140, 1234, 1557, 1559, 
         1558, 1181, 1230, 1663, 1091, 1138, 1548, 1549, 1470, 1178, 1431, 
         1550, 1231, 1664, 1092, 1345, 1346, 1227, 1661, 1088, 1136, 1542, 
         1543, 1465, 1176, 1430, 1544, 1228, 1662, 1089, 1467, 1177, 1466, 
         1469, 1468, 1090, 1343, 1344, 1223, 1660, 1087, 1134, 1532, 1461, 
         1462, 1427, 1533, 1135, 1534, 1535, 1463, 1172, 1428, 1536, 1537, 
         1224, 1464, 1173, 1429, 1538, 1539, 1225, 1540, 1226, 1541, 1174, 
         1380, 1175, 1381, 1389}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameStyle->(FontFamily -> "Helvetica"),
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->398520424]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24348],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11847],

Cell[TextData[ButtonBox["Styles and Fonts in Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StylesAndFontsInOutput"]], "Tutorials",
 CellID->10356],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->27842],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FontFamily",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FontFamily"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->227138553],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->280241866],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->669755249],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->153632542],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->198392215],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->488306145],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->336962961]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FontFamily - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 40.9694920}", "context" -> "System`", 
    "keywords" -> {
     "courier fonts", "cursive", "font-family", "helvetica fonts", 
      "monospace", "sans-serif", "serif", "times fonts", "times new roman", 
      "typeface"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FontFamily is an option for Style and Cell which specifies the font \
family in which text should be rendered. ", "synonyms" -> {"font family"}, 
    "title" -> "FontFamily", "type" -> "Symbol", "uri" -> "ref/FontFamily"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7162, 225, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4257068]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63054, 1354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2876, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3499, 93, 48, 1, 70, "ObjectName",
 CellID->28866],
Cell[3550, 96, 750, 23, 70, "Usage",
 CellID->28154]
}, Open  ]],
Cell[CellGroupData[{
Cell[4337, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4815, 141, 301, 10, 70, "Notes",
 CellID->13116],
Cell[5119, 153, 1110, 35, 70, "Notes",
 CellID->7010],
Cell[6232, 190, 257, 6, 70, "Notes",
 CellID->12060],
Cell[6492, 198, 331, 11, 70, "Notes",
 CellID->29595],
Cell[6826, 211, 299, 9, 70, "Notes",
 CellID->14981]
}, Closed]],
Cell[CellGroupData[{
Cell[7162, 225, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4257068],
Cell[CellGroupData[{
Cell[7545, 239, 148, 5, 70, "ExampleSection",
 CellID->601249729],
Cell[7696, 246, 131, 5, 70, "ExampleText",
 CellID->71723857],
Cell[CellGroupData[{
Cell[7852, 255, 192, 5, 28, "Input",
 CellID->427933374],
Cell[8047, 262, 232, 8, 36, "Output",
 CellID->46850723]
}, Open  ]],
Cell[8294, 273, 129, 5, 70, "ExampleText",
 CellID->37138760],
Cell[CellGroupData[{
Cell[8448, 282, 190, 5, 28, "Input",
 CellID->343677596],
Cell[8641, 289, 231, 8, 36, "Output",
 CellID->281457506]
}, Open  ]],
Cell[8887, 300, 134, 5, 70, "ExampleText",
 CellID->336261304],
Cell[CellGroupData[{
Cell[9046, 309, 192, 5, 70, "Input",
 CellID->6607165],
Cell[9241, 316, 235, 8, 36, "Output",
 CellID->104090770]
}, Open  ]],
Cell[9491, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->390885877],
Cell[9619, 332, 97, 1, 70, "ExampleText",
 CellID->140250670],
Cell[CellGroupData[{
Cell[9741, 337, 346, 11, 28, "Input",
 CellID->128544304],
Cell[10090, 350, 2802, 50, 124, "Output",
 Evaluatable->False,
 CellID->13894927]
}, Open  ]],
Cell[CellGroupData[{
Cell[12929, 405, 448, 14, 70, "Input",
 CellID->397887262],
Cell[13380, 421, 44801, 764, 70, "Output",
 CellID->398520424]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58242, 1192, 311, 9, 70, "SeeAlsoSection",
 CellID->24348],
Cell[58556, 1203, 447, 17, 70, "SeeAlso",
 CellID->18824]
}, Open  ]],
Cell[CellGroupData[{
Cell[59040, 1225, 314, 9, 70, "TutorialsSection",
 CellID->11847],
Cell[59357, 1236, 159, 3, 70, "Tutorials",
 CellID->10356],
Cell[59519, 1241, 150, 3, 70, "Tutorials",
 CellID->27842],
Cell[59672, 1246, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[59855, 1254, 305, 8, 70, "RelatedLinksSection"],
Cell[60163, 1264, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60565, 1281, 319, 9, 70, "MoreAboutSection",
 CellID->227138553],
Cell[60887, 1292, 135, 3, 70, "MoreAbout",
 CellID->280241866],
Cell[61025, 1297, 149, 3, 70, "MoreAbout",
 CellID->669755249],
Cell[61177, 1302, 169, 3, 70, "MoreAbout",
 CellID->153632542],
Cell[61349, 1307, 134, 3, 70, "MoreAbout",
 CellID->198392215],
Cell[61486, 1312, 135, 3, 70, "MoreAbout",
 CellID->488306145],
Cell[61624, 1317, 171, 3, 70, "MoreAbout",
 CellID->336962961]
}, Open  ]],
Cell[61810, 1323, 27, 0, 70, "History"],
Cell[61840, 1325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

