(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21013,        551]
NotebookOptionsPosition[     18236,        461]
NotebookOutlinePosition[     19643,        500]
CellTagsIndexPosition[     19558,        495]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FontFamily" :> 
          Documentation`HelpLookup["paclet:ref/FontFamily"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"FontFamily\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Font Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FontSubstitutions", "ObjectName",
 CellID->616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FontSubstitutions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FontSubstitutions"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which gives a list of substitutions to try for font family names. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical setting is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Geneva\>\"", "->", "\"\<Helvetica\>\""}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->20447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FontSubstitutions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSubstitutions"]], "InlineFormula"],
 " is used only for ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 " settings, and not for ",
 Cell[BoxData[
  ButtonBox["FontWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontSlant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSlant"]], "InlineFormula"],
 " and so on. "
}], "Notes",
 CellID->13742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161856591],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->26764212],

Cell["The system level font substitution list: ", "ExampleText",
 CellID->241923120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"$FrontEnd", ",", "FontSubstitutions"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211455895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FontSubstitutions", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"Helvetica\"\>", "\[Rule]", "\<\"Arial\"\>"}], ",", 
     RowBox[{"\<\"Courier\"\>", "\[Rule]", "\<\"Courier New\"\>"}], ",", 
     RowBox[{"\<\"Times\"\>", "\[Rule]", "\<\"Times New Roman\"\>"}], ",", 
     RowBox[{"\<\"Helv\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Arial\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Times New Roman\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Courier New\"\>", "\[Rule]", "\<\"Courier\"\>"}], ",", 
     RowBox[{"\<\"Lucidabright\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Charter\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Lucidatypewriter\"\>", "\[Rule]", "\<\"Courier\"\>"}], ",", 
     
     RowBox[{"\<\"Fixed\"\>", "\[Rule]", "\<\"Monaco\"\>"}], ",", 
     RowBox[{"\<\"Math1\"\>", "\[Rule]", "\<\"Mathematica1\"\>"}], ",", 
     RowBox[{"\<\"Math1Mono\"\>", "\[Rule]", "\<\"Mathematica1Mono\"\>"}], 
     ",", 
     RowBox[{"\<\"Math2\"\>", "\[Rule]", "\<\"Mathematica2\"\>"}], ",", 
     RowBox[{"\<\"Math2Mono\"\>", "\[Rule]", "\<\"Mathematica2Mono\"\>"}], 
     ",", 
     RowBox[{"\<\"Math3\"\>", "\[Rule]", "\<\"Mathematica3\"\>"}], ",", 
     RowBox[{"\<\"Math3Mono\"\>", "\[Rule]", "\<\"Mathematica3Mono\"\>"}], 
     ",", 
     RowBox[{"\<\"Math4\"\>", "\[Rule]", "\<\"Mathematica4\"\>"}], ",", 
     RowBox[{"\<\"Math4Mono\"\>", "\[Rule]", "\<\"Mathematica4Mono\"\>"}], 
     ",", 
     RowBox[{"\<\"Math5\"\>", "\[Rule]", "\<\"Mathematica5\"\>"}], ",", 
     RowBox[{"\<\"Math5Mono\"\>", "\[Rule]", "\<\"Mathematica5Mono\"\>"}], 
     ",", 
     RowBox[{"\<\"DefaultMonoChineseSimplifiedFont\"\>", 
      "\[Rule]", "\<\"\[CapitalEDoubleDot]\[CapitalIHat]\[CapitalIGrave]\
\[ARing]\"\>"}], ",", 
     RowBox[{"\<\"DefaultChineseSimplifiedFont\"\>", 
      "\[Rule]", "\<\"\[CapitalEDoubleDot]\[CapitalIHat]\[CapitalIGrave]\
\[ARing]\"\>"}], ",", 
     RowBox[{"\<\"DefaultMonoChineseTraditionalFont\"\>", 
      "\[Rule]", "\<\"\[CenterDot]s\.b2\[CapitalOAcute]\[Copyright]\[UAcute]\
\[CapitalARing]\[EAcute]\"\>"}], ",", 
     RowBox[{"\<\"DefaultChineseTraditionalFont\"\>", 
      "\[Rule]", "\<\"\[CenterDot]s\.b2\[CapitalOAcute]\[Copyright]\[UAcute]\
\[CapitalARing]\[EAcute]\"\>"}], ",", 
     RowBox[{"\<\"DefaultMonoKoreanFont\"\>", 
      "\[Rule]", \
"\<\"\.b9\[CapitalUGrave]\[CapitalARing]\[CapitalAAcute]\"\>"}], ",", 
     RowBox[{"\<\"DefaultKoreanFont\"\>", 
      "\[Rule]", \
"\<\"\.b9\[CapitalUGrave]\[CapitalARing]\[CapitalAAcute]\"\>"}], ",", 
     RowBox[{"\<\"DefaultMonoKanjiFont\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>"}], ",", 
     RowBox[{"\<\"DefaultKanjiFont\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>"}], ",", 
     RowBox[{"\<\"JFontSans\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>"}], ",", 
     RowBox[{"\<\"JFontSansBold\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>"}], ",", 
     RowBox[{"\<\"JFontText\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.96\.be\.92\[Copyright]\"\>"}], ",", 
     RowBox[{"\<\"MS PGothic\"\>", 
      "\[Rule]", "\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>"}], ",", 
     RowBox[{"\<\"\.82l\.82r \.83S\.83V\.83b\.83N\"\>", 
      "\[Rule]", "\<\"MS PGothic\"\>"}], ",", 
     RowBox[{"\<\"NSimSun\"\>", 
      "\[Rule]", "\<\"\[CapitalEDoubleDot]\[CapitalIHat]\[CapitalIGrave]\
\[ARing]\"\>"}], ",", 
     RowBox[{"\<\"\[CapitalEDoubleDot]\[CapitalIHat]\[CapitalIGrave]\[ARing]\"\
\>", "\[Rule]", "\<\"NSimSun\"\>"}], ",", 
     RowBox[{"\<\"PMingLiu\"\>", 
      "\[Rule]", "\<\"\[CenterDot]s\.b2\[CapitalOAcute]\[Copyright]\[UAcute]\
\[CapitalARing]\[EAcute]\"\>"}], ",", 
     RowBox[{"\<\"\[CenterDot]s\.b2\[CapitalOAcute]\[Copyright]\[UAcute]\
\[CapitalARing]\[EAcute]\"\>", "\[Rule]", "\<\"PMingLiu\"\>"}], ",", 
     RowBox[{"\<\"Batang\"\>", 
      "\[Rule]", \
"\<\"\.b9\[CapitalUGrave]\[CapitalARing]\[CapitalAAcute]\"\>"}], ",", 
     RowBox[{"\<\"\.b9\[CapitalUGrave]\[CapitalARing]\[CapitalAAcute]\"\>", 
      "\[Rule]", "\<\"Batang\"\>"}], ",", 
     RowBox[{"\<\"AGaramond\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Avant Garde\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Bodoni\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Bookman\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Caslon 3 Roman\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Caslon 540 Roman\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Century Old Style\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Chicago\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Dom Casual\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Futura\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Futura Book\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Futura Condensed\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"C Futura Condensed\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Futura Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"L Futura Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     
     RowBox[{"\<\"Galliard\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Garamond\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Geneva\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"GillSans\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Goudy\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Helvetica Condensed\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"C Helvetica Condensed\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Helvetica Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",",
      
     RowBox[{"\<\"L Helvetica Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Helvetica Narrow\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"N Helvetica Narrow\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Melior\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Meridien\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Mishawaka\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Monaco\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"New Baskerville\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"New Century Schlbk\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     
     RowBox[{"\<\"New York\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Optima\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Palatino\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Prestige Elite\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Sabon\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Tekton\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Trump Mediaeval\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Univers 45 Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"L Univers 45 Light\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Univers 47 CondensedLight\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"CL Univers 47 CondensedLight\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Univers 55\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Univers 57 Condensed\"\>", "\[Rule]", "\<\"Helvetica\"\>"}],
      ",", 
     RowBox[{"\<\"C Univers 57 Condensed\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Zapf Chancery\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Abadi MT Condensed Light\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Algerian\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Arial Black\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Arial Narrow\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Arial Rounded MT Bold\"\>", 
      "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Billboard\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Book Antiqua\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Bookman Old Style\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Braggadocio\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Britannic Bold\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     
     RowBox[{"\<\"Brush Script MT\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",",
      
     RowBox[{"\<\"Calisto MT\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Century Gothic\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     
     RowBox[{"\<\"Century Schoolbook\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     
     RowBox[{"\<\"Colonna MT\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Comic Sans MS\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Desdemona\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Excalibur Logotype\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Excalibur Monospace\"\>", "\[Rule]", "\<\"Courier\"\>"}], 
     ",", 
     RowBox[{"\<\"Excalibur Script\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Fixedsys\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Footlight MT Light\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     
     RowBox[{"\<\"Haettenschweiler\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], 
     ",", 
     RowBox[{"\<\"Impact\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Kino MT\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Kool\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Matura MT Script Capitals\"\>", 
      "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Modern\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"MS LineDraw\"\>", "\[Rule]", "\<\"Courier\"\>"}], ",", 
     RowBox[{"\<\"MS Sans Serif\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"MS Serif\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"News Gothic MT\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     
     RowBox[{"\<\"Playbill\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Small Fonts\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"System\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Wide Latin\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Wingdings\"\>", "\[Rule]", "\<\"Times\"\>"}], ",", 
     RowBox[{"\<\"Gothic\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"New century schoolbook\"\>", "\[Rule]", "\<\"Times\"\>"}], 
     ",", 
     RowBox[{"\<\"Swiss721bt\"\>", "\[Rule]", "\<\"Helvetica\"\>"}], ",", 
     RowBox[{"\<\"Terminal\"\>", "\[Rule]", "\<\"Courier\"\>"}], ",", 
     RowBox[{"\<\"Utopia\"\>", "\[Rule]", "\<\"Times\"\>"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{572, 804},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9666102]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12979],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13787],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->27576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->440920771],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->428267282]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FontSubstitutions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 48.2040522}", "context" -> "System`", 
    "keywords" -> {
     "font map", "font mapping", "font naming", "font replacement", 
      "font substitution", "substitute font"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FontSubstitutions is an option for Style and Cell which gives a list of \
substitutions to try for font family names. ", 
    "synonyms" -> {"font substitutions"}, "title" -> "FontSubstitutions", 
    "type" -> "Symbol", "uri" -> "ref/FontSubstitutions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4532, 158, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->161856591]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19415, 488}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1718, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2341, 73, 53, 1, 70, "ObjectName",
 CellID->616],
Cell[2397, 76, 764, 23, 70, "Usage",
 CellID->14874]
}, Open  ]],
Cell[CellGroupData[{
Cell[3198, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3676, 121, 194, 8, 70, "Notes",
 CellID->20447],
Cell[3873, 131, 622, 22, 70, "Notes",
 CellID->13742]
}, Closed]],
Cell[CellGroupData[{
Cell[4532, 158, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->161856591],
Cell[CellGroupData[{
Cell[4917, 172, 147, 5, 70, "ExampleSection",
 CellID->26764212],
Cell[5067, 179, 84, 1, 70, "ExampleText",
 CellID->241923120],
Cell[CellGroupData[{
Cell[5176, 184, 150, 4, 28, "Input",
 CellID->211455895],
Cell[5329, 190, 11262, 202, 825, "Output",
 CellID->9666102]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16652, 399, 311, 9, 70, "SeeAlsoSection",
 CellID->12979],
Cell[16966, 410, 200, 6, 70, "SeeAlso",
 CellID->31540]
}, Open  ]],
Cell[CellGroupData[{
Cell[17203, 421, 314, 9, 70, "TutorialsSection",
 CellID->13787],
Cell[17520, 432, 150, 3, 70, "Tutorials",
 CellID->27576]
}, Open  ]],
Cell[CellGroupData[{
Cell[17707, 440, 319, 9, 70, "MoreAboutSection",
 CellID->440920771],
Cell[18029, 451, 135, 3, 70, "MoreAbout",
 CellID->428267282]
}, Open  ]],
Cell[18179, 457, 27, 0, 70, "History"],
Cell[18209, 459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

