(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16332,        492]
NotebookOptionsPosition[     13412,        397]
NotebookOutlinePosition[     14810,        436]
CellTagsIndexPosition[     14725,        431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Font Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FontTracking", "ObjectName",
 CellID->13081],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FontTracking",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FontTracking"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies how condensed or expanded you want the font in which \
text is rendered to be. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14284]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings are ",
 Cell[BoxData["\"\<Condensed\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Extended\>\""], "InlineFormula"],
 ". The default is ",
 Cell[BoxData["\"\<Plain\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30281],

Cell[TextData[{
 "For some fonts and on some computer systems, additional settings are \
supported, such as ",
 Cell[BoxData["\"\<Narrow\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Compressed\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SemiCondensed\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<Wide\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14210]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375789283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->206730053],

Cell[TextData[{
 "Different settings for ",
 Cell[BoxData[
  ButtonBox["FontTracking",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontTracking"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->154242949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Column", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<AaBbCcDd\>\"", ",", 
       RowBox[{"FontTracking", "\[Rule]", "t"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Narrow\>\"", ",", "\"\<Condensed\>\"", ",", 
         "\"\<SemiCondensed\>\"", ",", "\"\<Plain\>\"", ",", 
         "\"\<Extended\>\"", ",", "\"\<Wide\>\""}], "}"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110547051],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Narrow"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Condensed"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"SemiCondensed"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Plain"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Extended"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Wide"]}
    },
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Column"],
  StripOnInput->False]], "Output",
 ImageSize->{77, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355839697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24895058],

Cell["Font tracking can be specified in style-related options:", "ExampleText",
 CellID->140250670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "^", "x"}], ",", 
       RowBox[{"x", "!"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontTracking", "\[Rule]", "ft"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ft", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Narrow\>\"", ",", "\"\<Extended\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56063421],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353569307]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5757],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->1933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78894921],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->708943172]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FontTracking - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 48.5009348}", "context" -> "System`", 
    "keywords" -> {
     "font tracking", "font spacing", "font packing", "character spacing", 
      "character tracking"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FontTracking is an option for Style and Cell which specifies how \
condensed or expanded you want the font in which text is rendered to be. ", 
    "synonyms" -> {"font tracking"}, "title" -> "FontTracking", "type" -> 
    "Symbol", "uri" -> "ref/FontTracking"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3841, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->375789283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14582, 424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1179, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1802, 58, 50, 1, 70, "ObjectName",
 CellID->13081],
Cell[1855, 61, 783, 24, 70, "Usage",
 CellID->14284]
}, Open  ]],
Cell[CellGroupData[{
Cell[2675, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3153, 107, 265, 9, 70, "Notes",
 CellID->30281],
Cell[3421, 118, 383, 12, 70, "Notes",
 CellID->14210]
}, Closed]],
Cell[CellGroupData[{
Cell[3841, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375789283],
Cell[CellGroupData[{
Cell[4226, 149, 148, 5, 70, "ExampleSection",
 CellID->206730053],
Cell[4377, 156, 214, 8, 70, "ExampleText",
 CellID->154242949],
Cell[CellGroupData[{
Cell[4616, 168, 580, 17, 47, "Input",
 CellID->110547051],
Cell[5199, 187, 1026, 38, 118, "Output",
 CellID->355839697]
}, Open  ]],
Cell[6240, 228, 124, 3, 70, "ExampleDelimiter",
 CellID->24895058],
Cell[6367, 233, 99, 1, 70, "ExampleText",
 CellID->140250670],
Cell[CellGroupData[{
Cell[6491, 238, 608, 20, 47, "Input",
 CellID->56063421],
Cell[7102, 260, 5219, 90, 141, "Output",
 Evaluatable->False,
 CellID->353569307]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12382, 357, 313, 9, 70, "TutorialsSection",
 CellID->5757],
Cell[12698, 368, 149, 3, 70, "Tutorials",
 CellID->1933]
}, Open  ]],
Cell[CellGroupData[{
Cell[12884, 376, 318, 9, 70, "MoreAboutSection",
 CellID->78894921],
Cell[13205, 387, 135, 3, 70, "MoreAbout",
 CellID->708943172]
}, Open  ]],
Cell[13355, 393, 27, 0, 70, "History"],
Cell[13385, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

