(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69055,       1523]
NotebookOptionsPosition[     64774,       1380]
NotebookOutlinePosition[     66218,       1420]
CellTagsIndexPosition[     66132,       1415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Styles and Fonts in Output" :> 
          Documentation`HelpLookup["paclet:tutorial/StylesAndFontsInOutput"], 
          "Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Styles and Fonts in Output\"\>", 
       2->"\<\"Text and Font Options\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FontSlant" :> Documentation`HelpLookup["paclet:ref/FontSlant"],
           "Bold" :> Documentation`HelpLookup["paclet:ref/Bold"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FontSlant\"\>", 2->"\<\"Bold\"\>", 
       3->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Font Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FontWeight", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FontWeight",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FontWeight"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " and related constructs which specifies how heavy the characters in a \
font should be. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Standard settings are ",
 Cell[BoxData[
  ButtonBox["Plain",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26979],

Cell[TextData[{
 "For some fonts and on some computer systems, additional settings are \
supported, such as ",
 Cell[BoxData["\"\<Thin\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Light\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Medium\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SemiBold\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Heavy\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Black\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Fat\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20930]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19623752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->488622067],

Cell["Plain fonts:", "ExampleText",
 CellID->47509944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", 
   RowBox[{"FontWeight", "\[Rule]", "Plain"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946307472],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Plain]], "Output",
 ImageSize->{116, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249329908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40371029],

Cell["Bold fonts:", "ExampleText",
 CellID->44183612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", 
   RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120864318],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Bold]], "Output",
 ImageSize->{117, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129429599]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6295],

Cell["Specify the font weight without using the option:", "ExampleText",
 CellID->490889040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", "Bold"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417895822],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Bold]], "Output",
 ImageSize->{117, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87387019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269724364],

Cell["Additional weights can be used on some computer systems:", "ExampleText",
 CellID->292128097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"\"\<ABC\>\"", ",", "Large", ",", 
     RowBox[{"FontWeight", "\[Rule]", "w"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Light\>\"", ",", "\"\<Medium\>\"", ",", "\"\<SemiBold\>\"", ",", 
       "\"\<Heavy\>\"", ",", "\"\<Black\>\"", ",", "\"\<Fat\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625511073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"Light"], ",", 
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"Medium"], ",", 
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"SemiBold"], ",", 
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"Heavy"], ",", 
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"Black"], ",", 
   StyleBox["\<\"ABC\"\>",
    StripOnInput->False,
    FontSize->Large,
    FontWeight->"Fat"]}], "}"}]], "Output",
 ImageSize->{327, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201330543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1368198],

Cell["Font weight can be specified in style-related options:", "ExampleText",
 CellID->140250670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"FontWeight", "\[Rule]", "Bold"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128544304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43363344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Bold"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->397887262],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJydXAdUVUe3RqOIFY0FFWOD2GJL1Kix7Igl0dgL9qhRE42x/L9do4gmUWPv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   "], {{{}, 
     {RGBColor[0.34283597664026555`, 0.1433323927713262, 0.598877755651205], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV0tMVVcUPfdx75XahxXkI9IKlE8dIQo4aKqPJ/anov0MGCg2adqkURQb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlk7trlUEQxff7MvvZmM4HdgqC+QPsczXxgSLxUVgICqJg442PNEYQtbBI
IxijUbAIWgiRpLo+blS0SCMXY3xXEhvBBLXQaKFJ/B1OcWDOntnd2Tmz6w73
7q2XKaUaCLA1p7QNXClSOggfYvEh/AR8AX4V/gDeC/8HX0v8E+zikGnWxojH
s+P9YJT4Hpgk3gmesf8X/HvpPTfhT+Fn0DKoKu5ibY54sXTuc/iO0nuWo5+C
f0OPtpQm0DfBN1DLBPoMcT+YL/yGJvqNsNYEx+AdoKf0mV+Jm+FaVeMXeCNc
axNMw+/C1xMP6s3wOnyWeJ79C/BB8Jf7f8MX0S6qkcRj5BxBuwbvhneBYeqf
hZ8lpUX9q+ErwQVy2+GL6m34rD9gCO1D2ItJ9PPwqXCvLsPPwVu6Dz4Av0W8
qvJZa9j/MrymuJ+cAi1V9k6evue+d2AAPkXOAXJn4J+Ix9E/E99Wjwuv7Sbe
k/027WnjrLLybJws/La36K9Kv1Hetlf2Sh7Lu65wLfJQXtdAX2HPN+susDF5
7THxk2zvOlj7GO6JerGisPfqgd6uGRiGPyL/dOGeNLI9k1cN0B3uoXqnO+bC
nsgLeXyc3KNgC7n7QI24M/vuOvol8g+FZ2MEPbP3Rfjt8lh3L6s8u6rhengG
5L3O1N9ZyvZWf2gU/U1279UzzVZn+C7NmGbrfnbtmrE+tO2aMbQfoIU2Eu6F
1uTVneza5Jn+Qk94dvUnNJvyWN5qRl+Hz9RZmsH/7s+RVQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.44167592992079663`, 0.3151883783139786, 0.737809266953615], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2Ql1UZxp+X8zyYq1gmOgXLJNloKowxU7C7gArrW9NMiN9yGpBq8suy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsl0UUxef7/jOfIAoKCIYtkpggiH3jQVTAAmUJiRXfjMQENNEHJWrA
GBQTEAlC4gNtaWmpS1xYXR5oGxYpBCxoXQpIQUOkFFBDIQYSA0FafofzcJJ7
5tzZ7r1zZ+zCxfNfzUMIK0AEw4sQhoG7sxDuKoVQz+AQ+J3YrTjuSyEMghfw
7+AZ9mF8rmNfA3+hN8PPYZ8FrdhXGbuEvZA1z8AfZM4o5r/CfjvQdjF2Hn07
eAs+F302+m78r6DNZ+whtHX4X4R/BK+D16NfxO4BF+At6G8zdyo+47FXscZl
7Q3agn160R7HZzJaHWNDsQeD5Znv+A++L+DTHHymH7HfQV+NVuCzsfCZdJYO
xn7GfpexdSXHrBF7EzgB7wQR+wd8brLW/4oJ9jLwH75VoJr9cnxuoK0GDySv
obmK2VF87yuci0r27IEvV7yZ2wDaou+su+bwncxvAitzxyDIxieDf4Oe8K2B
9wafqTz5jrrbcPgG+EB8EuuthZfBf0IvwXvwmZa8p/Yahj5AtQEeY70Mn3K0
qcnaUnxmwJ9MXnsZfD2+4+GLsJvwr8Hux1gf+hpwGH4/fCDaIXgJ+whrTAyO
kXzb4Usyz+nA/6noWmqHd8HPJOf2Y/gzaJ3wo9ibVNOqbbBXd8dnF9pesEe1
jP4F9pfJtVcOzjF/CxiLXg3firYT3gXfAmrhrclvoR/6h2gvgynwwWBb8hz5
bgVN0W9Eb6M7dy51Rp1NOd2A/SL665lzdAz+KRiJ73uMVWAfQN8Pnxys/Q7W
ZvZ5tvCb0FtYUHLunwPfZq6B75U/cCB3zv5A+wyM0fvC52+0oclz9YansF6W
XDt6g3ob25PvojdSHV3Dqt1msDG6hlQ7irFy/URyLJTz3cpNdKyVw9roGlDu
W0Ad9pHk3A9Cf0l3je4dp8Wja0i1ozet2uxfuPZUow3w/czZlztGffCn4eN0
X/Ru7M+Tc/tn7ticTbYVo23w48m95RHQBZ8FH40+uuTe0whqc/cgxa47+i0r
hu8rnsm1t5nzreRsx6PvUqMeAr+j8F0noc8pXBOqBfU89Ubtqb3UIw+x1sHk
XCtnFdid6B9kPtOb2POic3cl893Vs2/3arAEe0507fwLrkb3MPWuMvjc6DPq
bBXsUc/8TxhrY+56UKW7MbZKtZu7dyqmiqV6qN6mepx6m96o3srD8HElv5mT
8AbmV+U+cyX2JPSyknNyAn4sOdYd8JvYi5kzIbiHae9Q+G/RGTT3t2RfrTER
PqFwL9SebzB3pno2/HLmv6kluTb1R52KjplipTej3j4tOhfq8erl06N7g3r6
BeY+H51LvXn1JsVUsVSPWoD+WnRvfBT9XvR7CvcC/Snqpb9E9z71VNXO5uhe
pRqakZwDxX5E7r/ja8Z25P5D9iT3VPVS9ah2+Ozov0A5Oql8JedSPU6xVg5v
5w58lfzH6m/Vmvq7FSPFRn94L1pfcm4Vc/1NldG9Tn/Ur9iN0WdTTG8BdGEX
0Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5405158832013277, 0.4870443638566309, 0.876740778256025], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1lsV1UQxu//blp4oCAgiQvxoSWoUJ9IJOASReiCQcEqLgkIifLgHiPG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsT1EYxd97//v+URZqaGMum4ohlhKJFimqA6ERswQJrYUaFkIiphCN
BBGJWc1VNqaFJVFaQwgxj5HWHJSYVhK/k7M4yTn3fPfd+777fd+ABUurapMo
impAAN/SKPoMZsRR9BHjBvwm2AGfil+WjaJyMB9dScxVNv3F/46eBBai29Gf
tBe/Fb2H+JuZKFrG/nnoU/gn8M+gr8ObQEdim1jbC88lvgPx29DPiN+NbkEv
IL4dvQ99Fz2QPdXwr6nvuoS18fjXUn9rHX4n/BywCp7gn8Wvwm9AjwDv4I2g
BP6GPV2IvU/MhMh3+I53DsyM/U9z8d6mjr3IWnfiu+kMeA7xJfqXrM/qQcwD
4jeid6HzianFrwYTlE9Qgz8bPRz+Gn8cfBJr0zm/D2sv4SdBAXw7/jH8o+AQ
uh4U8u33ylHsmEfw48F7t7A2FH8IKIQXcoee8If4m9Gd0VPhW1lrgK/gzLfo
OvSxjPec56wL4EHsHDyFPwFrI99hLLyePbmxv/kz+I66m3K8gW+NY62U+J18
sw+6N+iKVwfaiG0FB/CPqxDhRfhFGa+Jx6wVZ7ym3Gxh7XDGOTqHHo0egx7E
/grVDvEV6HIwBj0KXIgdsy91DvTvqmnlXjWk2tEbHIEfBe2J/7k465pRregO
qtUWcC1xzapXvoAPiXtmP/w2aE78jwfZezV1LapGDsHvghv4PdB/gv9Bd29E
H4b348zunFXKWgG8b9a50toX/MFZv6Xe4IXeEn0A3Y+YO3y7Pzov4zN24Bel
rq3HxH+EXwru3ebYvdsknbiHldtXwXdTjtULXbOubfVEM/GlrK2PnYOJqldw
Cr0+cq8+D6519ewvxYJ/sWNUW5ODZ4FqTHevDO5t/cO94JpRraimdJZ6Sr2k
M1WrX4N7XzW7Cj4xuDd+gpXwiuDa/wHK2VuWurb3oNfgTQnmf2PPprbg3GlG
DSN2OXpk5JkxBz9fbw4fxh1uwXuxlpvxGyvXuoPOVs7fBZ+hb6sn1ftlwbNT
M2B16hmo2acZuhg9GExO/Aaabd+Cc6kZdwS+CH984pkhrhpRbWgtJ3XNq9Yr
we/UM1mzWDXcgD6Zurc0cxP4JvwkcU/UBc9szeoc1map9lLXhmo6L3WMPOVA
bzkjuFb1pqfxK7M+WzNUudEbKPfKkXpxWurcqSd1tmaoZqfucBnvSupZrxnx
H+PNz+g=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6193565456522419, 0.6167958184041099, 0.9107647837322218], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0tsVVUUhs+554GiEyVSikqpGmxJFDpwIolFxUSFtkrQIEFAIwUdgEY0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIl1EUxd/f/3sfZK2SBpucGpQgdVGLgrQJKodKGsxCKxq0oIFoUWQQ
RSAtTIiwwDQa1EhSV1LuWmk0LFK0edFEkwZa1iL6HW6LA/fce9797vfuvS9t
16GSgwnOuTLgwWBw7g5GH85nYAg7B9+fmHON4Ce8NnKuLe7cEngR9nji6+DF
IAeeC7Kws4inY7/mTDJ8KmjC3oe+hlgSGIddiKaZb3XD+4ifhdejTYbPxb6J
LxU7Fd9G7DWcSUd/Fd8IfBGaHGK11F9E7Lu3WmejmUPsg7ezKeAC9gGQRywJ
VKF/AN+D/i3Yj32RM11oe8n3CV4NxojVgyvopxOfSLyO803YjWAAPgi60G4O
9i/FoAz+HN6P9gz5stDOiyxXBvoXxDqlIT4A3sPfgQa0t+AnsSvQ71Y9nNmJ
tg7eCW9EM5/40mD/spf4MmL5kfUmH81C9Qa+HnslvvPYw95604JvBXx5ZLlU
wzbsyZzZQawC/EJ7GvxF36r+E7sW2b+eQF9C7Cm+h9iV5KghtgHfUewbaLZH
die6C+UsR3scPgJfzJkEeF5kteqfJwWrQd++B7+P9ge+z2i/gCmaHXyJ2D0x
q20ruB2zGjW7Y95q1QyP6tvBZiGXnNnkXhD97wW8lVhLsLvWDHZ464l6MQje
eJthze60uM2aciqXZu63tzPSqoYZxPtVk7MZ2eTtznXXx9RTeGZkve/lzEdv
d6a7yuT8OewizSPaBnwTgu2Ydks91G4UEC91tiP61kx8SXH75pNg31DuHvDS
W07l0g51EG8Hd4m1g1XY173tWi14BH8MLiVYDdr9b952TW/A2mA1q1btYHlk
PVJvNKNbiJcG602bs13SjGo2tVNV8MrIduur5t3bjmo3NTNt3t4gvT3amQxi
q4PNlt6Q7GA9US80Qw3wNM1s3Goehg8Fmx39Y3FkNakWvVHancRgu6Ad0ltW
6u3t0JumXK+83YVyarc7g92VdvwI9mFwOWZvwmiwndAu6A1JQT8rsrdNPWn2
1hP1QjtyCrs62C5rhjXb3d7uQjNeCC8INiv6Rq92K9hbo57/A+6/vcU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6920267820769207, 0.7335566676302089, 0.9124214412953171], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlklsVmUUhu9//3vvwgF3bXVFW0f+P1Y7GgQXaImJY6st0Bq1NdCBBEes
BmpE6cI4RFpXrNqaaCJY0HYnZeVOEw20JGAilG5cysoqNfF9PG+jiy/fud9w
hve853y3fvDl7gNpkiRrGmWNoVKSLGn8IPmuIknu0WjQxseaWzWq2ntC8015
kpyVvFOjS/vTSczdGqckH9d6o8aY5A4ZOFAOvSvsaxzT+v3Sc59GRd+/Z0ny
oeRpnZnVqPjuNdn5Tnt9+u6Vnh6NLZI7bRdb3GHtqORn7QN+tWi0SZ7S+rB0
jxThB/vP+C66ny9C/6DWXtJ4WnI1i2/kVutBPzGNaH5LoyJfdmh9QWtl+fmI
9Dys73aNDttdl56tRXw/4L0Nfe0+s4N7RejqT0PHdvtQ0RjQd4v2m8Ff8muy
9YnkPTr7oOa/s9BdyiJXDbq7V3v9ziNY1pcDz3HdfUdjSPuHtHZY41ISmHQZ
tzNZ4A4mC5rfkI1h41O1P/iFDD51mms1hqXzXDlyTH6b0uAIZ7AzbluNWr+9
HDlbdC7nzL1DPvOT7H6ZRSzbSsEZODaveU5jJgk75/x9WWebdOeYzk5r/ioL
rnbL91vy4MVKKWxcTMIfbBFXh862a9QYP7B6U2caitCLzovS8bXkZsm/SP4m
C7/WNJ/0+oji2guOkt/Tmds0fpR8q+YXi9jjDDjBvS+yiJMY5/PAGn/IY5KF
H/3O5Zkk4lxy7JvT8KvR+KMXu+xfNX+wA7bYWvV6Xxp8xXfwhG+rXmd/1XeJ
70/H2Cq/8jzW++wPvBpNwy76O22PPF4hHxq706gZ8jyRRDxwEWzXNX/uOqev
kLOqde9zvMxDltFFrNQdtdPiegeTeXNjwfKMebJgPp90DU9Yz2XXArUOR+En
a/iND+/nkT9ydwf9Bp2Sl40/OHybBQ82uHnanG/Q2qjiWfb6nH27u4h8k+vr
mjuK8Ise0OaesEl3u4roTeSdOlvU3Xu11lSEHyfc1yaT6IUVx0Vtch6s6AtX
jP+sY6uaG8vGZ861M2msdpoPFfODfG5wgjOnXNdz5go+0LuuGhPOgNWM/UN3
s/3Ev1bni/Xz3tuaB9bgfN7+gCH1RL1x5vssamO49F/fAZNh9wp4WOM+BPd6
dHYwixipaWqbuvhLc0semNd6vcZ1dtxvza9Z1Dx1dbPOtueBywf0tzywHdD+
IrrSeI92pcHn3drflQef4Dl6x/wOJs77hVL4vdGTe3y3x7qQ6Ze56+jONPyd
8BvX6LfvMdl5PI/viutowrY2u07I+azjYh9dnAHrdmNywvwmXzfQO4voxzXu
h+D8kdauZaFjj+YjWeSoxm/Tv7jz/hRho9l6yXutMSaWV6T/1Tzwovf3Ohb6
D3yacr1T//SY59LYm3LvQt5ubnF+0n0Grlfdw2sdF3OdZbCgDsbMB+Inrop8
+ayIN+GhPL5XzKkh54jeVud3DTvoof8suQ7wgTrvt87T/rfZ5rUL1sP/z9L/
3h5m3rgGv9kbfCmZJwd5c/PAYJ/W1vLQtSmNGd1L7sXoP6L9d/PoxxVjjj/8
K9BnZ92ba50LuLtsn7eYh3BjwH0HnoPzjGuW/7Pr/n4U3hXBM3rEgvsG2BEn
sb3NP1Ue/0mX+I/IghP4se6e/4J0HM4j509JbsuD98uOs9+5oxbRw79hTxZ1
wLlF1/vPutftGsbHaft8Yx7/qdQTvZb6p5bg61nf7c2C33Cbnl2fh33qYCAL
G+Oaf8uiNmds46j/dTsdO/1gfxG40gOeLKIPZHn0I3oRdfOHawe9FeMHB0ez
wO+g5NeL+DeBp+gjR/u1/2kW3PkHp6dZgg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsT1EYxd/re/ctDLU0rFTNLdVBJ8OiFZEYqv9OWmMrqq2kRVshKWUp
QoodFspCYo50WVaWFoJKiEjs2GGj0kr8Ts7iS873nXPvu/d8330FXQO5/rwo
inYTKdGYRVF7iKJn4KYkii6AL0NMkh9HuIS8E005+E0cRYfAh4lu8g7yDrQN
aFaQPyLfCJ5DvAQHagfRLiI/yt5dxCnwedacYf82+HnkDZm1r1gzQH4ymGsl
utDegJ9g7Thr6sFf4CfQ1lFrgz9N3o72LHwN/Cy1KrhKYghukNgPf4CYBr+G
72H9R2II/TAxkriWg9uBZinaW+SFcF+pXY9dawHvhC8E36X2nXwVmmWJ77QB
XAo/A1dErQR8Dk1v5D1q4Zuo3Yx8xr9wY9SegzfDl4FHqc2Ci6k9AX8O9raM
aAbXZb57UZ73Gg6+m/a8BneVKI7tyS/WPyVWgu/H9iIh6hN78iO15/J6uc7L
2nXEONq1ib1+kfps8nxhcE/VS82Ier8+s1YzsIB8L3mOvJnoBf+m9oG1/eS7
gr+pb8lDcZOpZ0maI+hrqDWCjyX2pl3+R/boHVx5Zm/uobkDToNnY4raHvK5
wbNUop6DezJ/u4q8jHwTeTV5BZrb4OnU3r6ndhF+lOhF25fn2ZtPvj32DP5L
PWOaLe0xqLNophPP0BX47tSzlc/6E5oN+KnYb2hE2uC3pTcUgu+gs29BM8ba
rdS+gT9xp2q4GWqPY/dQb2lf8N30pnTWxcFe6cx/Ut9Jd5Fn28AVwXur5+pN
fvBbV4/09i8F31X/gM7UM6bZ0hvuS+2hvNOZ1Jva4H+BevQwdU/UC82cZv9n
6rehN1Ae7Lm81h3W8P3V8iT2m9Gst6aeTc38A/Db4LcnjWaxNPNb0kwWBHss
b+VpJXku86ypR/8B4XuJPA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7644864248373172, 0.8476167347436998, 0.9131997713355886], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVslvzlEU/U3vWYjWsNLaGFaiiWjJZ4huDF3SCjWGSli0tIZiZVhQiWEh
WGBVNiqVfobqyleNXbGw0aTFwj/QsjGGc5wjFi/v/u677757zz33ft/8ts7m
w1mSJBWsHKsOHy/SJLkLubZIkk58t6TaaViGfje+2yE/h9yV6Yz6qkL615A3
prIfgNyB/ZDtawr5pc8+PHgfaznkA7nsdtl3h+3PhCQ5izUK/TLYFLh7I9E9
yrz7GLaPsMbtf26hd5tTyRXHVl38919leWWhO4xnEj6nsHpgfwxvHsd6ythw
fgnrFfQXoevBegP9rUx3bkJ/O9Nd6kZyxUP7oVSYEs/n8HEoJkkDvr9gfTZW
V6C7ivUgF5bEh9h18TuXn7FUd2j/DHJjKhzyoFgZJ/EgLtQzDsoXjFWf5bWw
u54oHubAWIhPqRAWxKHGMrEj7kszYbkd72yO+n6Csy1RufHd4Fp8h80J6CcS
xbQ405st0K+K+ua7Jb9VwVqSiS+XobsKu+pMb5dcu3epdOQdMZ40zsSoxrX+
ZB6QA4OQc8i9xBb+Lgfh14B9XdRZP75/GwvifCQXH3Zi347VBLk1V1z0Uw+5
wVxlrvWWZ8Dntag8NmDfiLUh1zn5et3cqDOv7uA8BMVYzlRf1vQ8fJ6Cvsj0
LmNgTw3DLrqPWHees/bEgjnx7krc2wu/03G2CXt10L0fxDAqbnK/yzkuwHl7
VM7sy+nuNfZ9k3t/Nmy2wmaHY9nheBgve4fvPjLXy+Y+82SOrzPJ5Nt4plr9
65Fb1q8J6iVygTWjjwnjTHyJ3Yj5X3YvMIdO60bcF4xhyr12hvei/JPX5A35
U4t32qA/6P7i3pL+r3Gv51Wrc/wI+/dBsbPv5wf531roDfpfwr6L4l2jZxP7
7gT004L6fiITF1g3zox5zrfs3me+5AX7/h70e+D7QxBWRRBXBu3nmfud+ZbN
89U4XxbE42/YfwT5ZS6D5u3coBk66lnIPv47G3F3RRC32t1brOks6FqiuMA+
eWo/F6A/HzTvWYcq16LW85O9uAjnHVG4rwriJbl1MggXYsI4GAP5RtuFQfYd
jmOXOT5kXN+Z66xjPezfBvFrJvZSUJxHsW8rhCF9DzvHz8aKefFeX6G7VUF9
QrvuoNnEufQS51+D+MSZRAz//Y5xL3tuNhmTTvg4jNWda16WPDPrXM8ez9t+
zxnmM+T+Iu4Vx/mT8zbK7r5nG2u9Dbo5QTOpKWrm1nle7zaG7M1Wz6uHOJ/y
HKa/X4V8sp4zjRXrMeq7Fec34Pn/xjjvj/qtYg+xFwv3I/Pkb9CY7zfb/lzQ
bwN/F8jHenOy0bky98WeucRjPfzHIE7Tb6PxYb9NOHf6GnY9e40jfXXj7nGs
07m4udbn/Ob8/+TfijHzhrO5rVCuxHXc/vdBXxP0v+MPvDMbIA==
         "],
         VertexColors->None], 
        PolygonBox[{{1588, 1677, 939, 813}, {1645, 1316, 471, 564}, {1676, 
         1110, 134, 938}, {1335, 1623, 859, 328}, {1594, 1276, 429, 554}, {
         1408, 1409, 560, 459}, {1334, 1293, 447, 518}, {1213, 1633, 870, 
         348}, {1308, 1635, 564, 462}, {1410, 1411, 621, 620}, {1299, 1621, 
         857, 859}, {1339, 1340, 462, 339}, {1313, 1642, 880, 204}, {1295, 
         1618, 518, 448}, {1336, 1335, 328, 449}, {1274, 1591, 819, 148}, {
         1396, 1397, 554, 437}, {1632, 1305, 459, 523}, {1607, 1605, 439, 
         838}, {1221, 1529, 754, 755}, {1400, 1399, 440, 516}, {1365, 1284, 
         438, 556}, {1412, 1307, 871, 623}, {1643, 1213, 348, 881}, {1122, 
         1365, 556, 447}, {1411, 1338, 523, 621}, {1642, 1314, 881, 880}, {
         1622, 1370, 177, 858}, {1621, 1298, 858, 857}, {1277, 1595, 511, 
         429}, {1502, 1503, 731, 150}, {1586, 1587, 717, 134}, {1265, 1676, 
         938, 309}, {1617, 1294, 448, 560}, {1501, 1203, 732, 731}, {1646, 
         1221, 755, 885}, {1420, 1647, 885, 472}, {1651, 1653, 894, 483}, {
         1315, 1164, 527, 471}, {1370, 1414, 624, 177}, {1440, 1588, 813, 
         667}, {1592, 1198, 309, 820}, {1306, 1410, 620, 870}, {1604, 1283, 
         437, 515}, {1634, 1339, 339, 871}, {1460, 1459, 690, 691}, {1194, 
         1440, 667, 717}, {1678, 1394, 420, 939}, {1652, 1460, 691, 894}, {
         1287, 1608, 557, 440}, {1459, 1220, 753, 690}, {1422, 1421, 472, 
         527}, {1286, 1157, 516, 439}, {1331, 1274, 148, 511}, {1285, 1332, 
         515, 438}, {1531, 1530, 220, 754}, {1528, 1126, 204, 753}, {1591, 
         1275, 820, 819}, {1413, 1412, 623, 624}, {1203, 1606, 838, 732}, {
         1620, 1297, 449, 557}},
         VertexColors->None]}]}, 
     {RGBColor[0.8297492293531931, 0.869380141060736, 0.8839620933966047], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVbtOVFEUvXPvnMuIkoDa+YrxVVloQiTBYgoRoTQ81DhMAmiARHBmTMAw
xsSIUQQf/wA/IBWVyqAdDq0kow3wBTZq41pZy0Cxc87Zd+3X2vuce3p46uZk
HEXRS0gC2clE0QSkjn1niKLhNIoOAdCArEKfh5QTYb4B8wKYO5BL+L4O3WWs
K9APwu4K9E04Xw3yRT9bwHTE8k+7gVS2dehbsPZjfQjdOXz7jn0FsdqyinkU
3/OQXeg/QlcCrh3nzYzWz/C5kZG/PtrGivkJ+vupbIgbghQgPcDUIDnsezMS
6pci5UF/HyADiD2YCN8FP92QLpzXMqqPGNba4XqZd9H2uax4W8Z+CnYLwFRj
1bJrrincN4A5hu/Pg+ogJ8yDfLIexqHPUfg5Efwd+yNBucwj1usgHhexf499
q2tbt5+a61x2jZvOszMWDzX3sG78AvycCer1PNZXQTasb8tz0gzMwaz4eYfv
b8Nen3eMYQ9b3cdSrP0Qvj3F+RfO29ivQncvVXziiKHtNHQXg3yxn+SGPW31
PBXdt2bnMIc1DeojfbQ5Fu3JO/lmj2hPW/byADDXEvWLe875/zO5OhzENXlm
P3PGsC9r+3pTdG79ifJZ8fyQH+raPR/EluHva1Y8zTovzkA5FkfMmXyfMuec
26Lncxq6maBzG9a+VDM6An+zOI/GugdrzpHxm50D+zzq+7oCXSOolvGM8mAO
I/B3HPox4P9g/RvUp99Yv2SFPRk0i3X3+lkijmege5zqvOH45IQ9po9x37l1
z2J3otp6jOszPz/h/0fQ20M+yr7LzKlsftjfkt8Tcl8yhj3MuadV8zvunjIm
OSz4LeD+bqK5Y068f3O+g7224QxwTrhf8swX/NYxFr+RQ87+Bc9/i98m3jPy
3u85uQFumoLq3jbvDc8JccTw3eMd4L1j/k9i7Rdh9yboXPDdZg4T7h0x7M9k
utfPqvUlzzu54jwM+E0jlxXzxriPEnF7PdV85PfVwFi3ob+VirOzyOVBKpvz
QW8355t3rmI/E/5nMO4/+TW/dw==
         "],
         VertexColors->None], 
        PolygonBox[{{1416, 1340, 524, 627}, {1311, 1638, 565, 464}, {1531, 
         1529, 361, 756}, {1286, 1605, 837, 164}, {1420, 1421, 637, 636}, {
         1646, 1647, 636, 361}, {1402, 1625, 860, 452}, {1169, 1132, 576, 
         532}, {1222, 1656, 898, 568}, {1214, 1635, 872, 350}, {1413, 1414, 
         561, 461}, {1299, 1623, 519, 450}, {1422, 1164, 206, 637}, {1622, 
         1298, 450, 561}, {1296, 1619, 854, 178}, {1415, 1416, 627, 626}, {
         1607, 1606, 320, 837}, {1501, 1503, 733, 320}, {1398, 1399, 607, 
         606}, {1657, 1655, 485, 898}, {1325, 1169, 532, 485}, {1287, 1398, 
         606, 839}, {1425, 1424, 474, 528}, {1308, 1415, 626, 872}, {1375, 
         1159, 520, 571}, {1419, 1418, 464, 525}, {1336, 1296, 178, 519}, {
         1620, 1204, 329, 855}, {1309, 1162, 525, 463}, {1317, 1165, 528, 
         473}, {1634, 1307, 461, 524}, {1502, 1118, 441, 733}, {1315, 1644, 
         883, 206}, {1619, 1297, 855, 854}, {1654, 1530, 756, 895}, {1319, 
         1650, 568, 474}, {1637, 1310, 463, 562}, {1624, 1209, 562, 860}, {
         1400, 1157, 164, 607}, {1649, 1318, 473, 565}, {1403, 1402, 452, 
         612}, {1644, 1316, 884, 883}, {1159, 1123, 612, 520}, {1204, 1608, 
         839, 329}, {1645, 1214, 350, 884}},
         VertexColors->None]}]}, 
     {RGBColor[0.895012033869069, 0.8911435473777723, 0.8547244154576208], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFU7tuU0EQ3eu9eytT8LhliCiAij+ggU9IgYgoEtsKCNsCgfJwHMnYchHJ
KFLMt7hJ60ip49a2oCT+C87hnKsUo505Oztz5rHPml93vtRCCB8gETKA8QNy
C/1BHkId8jnqpP0uC6GVQmhC3sKvg7ML2YG+yXT+xdmO8ufbh8DWwBqZbJ7z
oJhN3F1DHwEfQn6H+3zEj3B/XJP/MfBHwBfQu1F3+5nydTPh5LSOykds4Fr4
ljZ1xnic6+1hTTb1J7n8/wThR847QX0/k3iQbwsyC9Lr7gnjMQ7znETZ1BmP
cTuZ6qPO+J9w/kLMkfMcupYylw99S2B3roP9KY2fFCGcFsLoWzr+yj1m3/rR
vch0zjwfzmJk/DRq1nx7CS5TyBB2D7FvqphR/eTbc2B7SbUvozgzX8t9YR/W
zrtx78md9TLP0LPgW8blvMiddTAXOS29H+wh+0f/lXkT7yP/WVLOVi5O5FPt
Fmvn7lGfW+9EcfuIuraTdmdtDsx5BrwPGcN+gftv0Hvelzvz546Vrmfs2RCb
IP9WUi72uPoHnD9r4Eyf4v6gEI+N95W1875nnyv4vy/Ek/PpVzsMfJrrX6z8
/v/+Z+rPwv+07Rpf19SrlWe3dBzyfeN9+o48L5PmzxkuHafh/zD3vAbeDe41
cfrsFpoB+38B/HnSjMjxVRLPf9wsizA=
         "],
         VertexColors->None], 
        PolygonBox[{{1417, 1418, 630, 629}, {1637, 1209, 342, 875}, {1648, 
         1318, 888, 887}, {1325, 1655, 897, 222}, {1215, 1638, 876, 352}, {
         1166, 1127, 641, 529}, {1657, 1656, 363, 897}, {1624, 1625, 611, 
         342}, {1388, 1386, 487, 594}, {1170, 1133, 577, 533}, {1378, 1171, 
         692, 578}, {1319, 1423, 639, 889}, {1403, 1123, 180, 611}, {1419, 
         1162, 194, 630}, {1649, 1215, 352, 888}, {1423, 1424, 640, 639}, {
         1309, 1636, 874, 194}, {1425, 1165, 208, 640}, {1311, 1417, 629, 
         876}, {1386, 1659, 899, 487}, {1658, 1170, 533, 899}, {1317, 1648, 
         887, 208}, {1376, 1166, 529, 572}, {1222, 1650, 889, 363}, {1426, 
         1377, 890, 641}, {1636, 1310, 875, 874}, {1171, 1387, 594, 692}, {
         1377, 1379, 578, 890}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{233, 593, 232}, {1387, 1171, 232}, {237, 241, 232}, {245,
          241, 237}, {1386, 1388, 593}, {1659, 1386, 593}, {573, 237, 232}, {
         593, 233, 224}, {1377, 1426, 573}, {1171, 1378, 232}, {241, 249, 
         233}, {241, 245, 225}, {249, 241, 225}, {1379, 1377, 573}, {237, 573,
          210}, {1170, 1658, 224}, {241, 233, 232}, {1127, 1166, 210}, {1166, 
         1376, 210}, {1133, 1170, 224}},
         VertexColors->None], 
        PolygonBox[{{1388, 1387, 232, 593}, {1426, 1127, 210, 573}, {1378, 
         1379, 573, 232}, {1658, 1659, 593, 224}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1133, 1170, 1658, 1659, 1386, 1388, 1387, 1171, 1378, 1379, 
         1377, 1426, 1127, 1166, 1376}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1132, 1169, 1325, 1655, 1657, 1656, 1222, 1650, 1319, 1423, 
         1424, 1425, 1165, 1317, 1648, 1318, 1649, 1215, 1638, 1311, 1417, 
         1418, 1419, 1162, 1309, 1636, 1310, 1637, 1209, 1624, 1625, 1402, 
         1403, 1123, 1159, 1375}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1118, 1502, 1503, 1501, 1203, 1606, 1607, 1605, 1286, 1157, 
         1400, 1399, 1398, 1287, 1608, 1204, 1620, 1297, 1619, 1296, 1336, 
         1335, 1623, 1299, 1621, 1298, 1622, 1370, 1414, 1413, 1412, 1307, 
         1634, 1339, 1340, 1416, 1415, 1308, 1635, 1214, 1645, 1316, 1644, 
         1315, 1164, 1422, 1421, 1420, 1647, 1646, 1221, 1529, 1531, 1530, 
         1654}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1111, 1394, 1678, 1677, 1588, 1440, 1194, 1490, 1587, 1586, 
         1151, 1110, 1676, 1265, 1198, 1592, 1275, 1591, 1274, 1331, 1330, 
         1595, 1277, 1593, 1276, 1594, 1363, 1397, 1396, 1395, 1283, 1604, 
         1332, 1285, 1692, 1284, 1365, 1122, 1682, 1293, 1334, 1618, 1295, 
         1616, 1294, 1617, 1369, 1409, 1408, 1407, 1305, 1632, 1337, 1338, 
         1411, 1410, 1306, 1633, 1213, 1643, 1314, 1642, 1313, 1163, 1126, 
         1528, 1220, 1459, 1460, 1652, 1653, 1651, 1324}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1131, 1168, 1342, 1323, 1684, 1130, 1372, 1640, 1641, 1522, 
         1212, 1521, 1211, 1630, 1631, 1404, 1405, 1406, 1161, 1303, 1629, 
         1304, 1368, 1367, 1614, 1291, 1613, 1292, 1615, 1333, 1290, 1681, 
         1121, 1364, 1602, 1603, 1500, 1202, 1499, 1201, 1273, 1680, 1113, 
         1153, 1271, 1691, 1272, 1196, 1497, 1197, 1498, 1114, 1359, 1582, 
         1583, 1581, 1585, 1584, 1329, 1264, 1675, 1109, 1355, 1356, 1257, 
         1391, 1392, 1393, 1149, 1256, 1575, 1577, 1576, 1190, 1487, 1191, 
         1488, 1106, 1352, 1571, 1246, 1570, 1247, 1327, 1145, 1374}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1322, 1385, 1219, 1527, 1218, 1525, 1526, 1697, 1696, 1695, 
         1458, 1457, 1456, 1520, 1519, 1125, 1160, 1301, 1627, 1302, 1628, 
         1208, 1366, 1288, 1611, 1289, 1612, 1449, 1448, 1509, 1508, 1117, 
         1156, 1282, 1599, 1601, 1600, 1200, 1270, 1679, 1112, 1152, 1268, 
         1590, 1269, 1358, 1357, 1262, 1689, 1263, 1328, 1261, 1674, 1108, 
         1353, 1354, 1255, 1673, 1105, 1148, 1253, 1573, 1254, 1574, 1189, 
         1244, 1670, 1101, 1144, 1568, 1485, 1486, 1437, 1569, 1245, 1671, 
         1102, 1349, 1187, 1237, 1668, 1099, 1142, 1562, 1482, 1483, 1434, 
         1563, 1564, 1238, 1565, 1567, 1566, 1183, 1382, 1184, 1383, 1390}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1129, 1167, 1341, 1321, 1683, 1128, 1371, 1639, 1517, 1518, 
         1514, 1516, 1515, 1626, 1300, 1512, 1207, 1511, 1206, 1609, 1610, 
         1401, 1120, 1447, 1446, 1445, 1507, 1506, 1116, 1155, 1280, 1597, 
         1281, 1598, 1199, 1362, 1266, 1690, 1267, 1442, 1441, 1496, 1495, 
         1107, 1150, 1260, 1578, 1580, 1579, 1193, 1252, 1672, 1104, 1147, 
         1250, 1687, 1251, 1188, 1243, 1669, 1100, 1143, 1241, 1686, 1242, 
         1186, 1235, 1666, 1097, 1141, 1560, 1480, 1481, 1433, 1561, 1236, 
         1667, 1098, 1348, 1182, 1232, 1665, 1093, 1139, 1551, 1471, 1472, 
         1432, 1552, 1553, 1233, 1554, 1556, 1555, 1179, 1473, 1180, 1474, 
         1094, 1476, 1477, 1475, 1479, 1478, 1095, 1347, 1546, 1547, 1545, 
         1229, 1326, 1137, 1373}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1320, 1384, 1217, 1524, 1216, 1523, 1312, 1694, 1693, 1455, 
         1454, 1453, 1210, 1513, 1124, 1452, 1451, 1450, 1205, 1510, 1119, 
         1158, 1444, 1443, 1505, 1504, 1115, 1154, 1278, 1596, 1279, 1361, 
         1360, 1589, 1493, 1494, 1491, 1195, 1492, 1258, 1688, 1259, 1439, 
         1438, 1192, 1489, 1103, 1146, 1248, 1572, 1249, 1351, 1350, 1239, 
         1685, 1240, 1436, 1435, 1185, 1484, 1096, 1140, 1234, 1557, 1559, 
         1558, 1181, 1230, 1663, 1091, 1138, 1548, 1549, 1470, 1178, 1431, 
         1550, 1231, 1664, 1092, 1345, 1346, 1227, 1661, 1088, 1136, 1542, 
         1543, 1465, 1176, 1430, 1544, 1228, 1662, 1089, 1467, 1177, 1466, 
         1469, 1468, 1090, 1343, 1344, 1223, 1660, 1087, 1134, 1532, 1461, 
         1462, 1427, 1533, 1135, 1534, 1535, 1463, 1172, 1428, 1536, 1537, 
         1224, 1464, 1173, 1429, 1538, 1539, 1225, 1540, 1226, 1541, 1174, 
         1380, 1175, 1381, 1389}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameStyle->Bold,
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->235129655]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19266],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontSlant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontSlant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Bold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26991]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18863],

Cell[TextData[ButtonBox["Styles and Fonts in Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StylesAndFontsInOutput"]], "Tutorials",
 CellID->21050],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->7507],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->6269518],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->77892748]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FontWeight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 49.9072208}", "context" -> "System`", 
    "keywords" -> {
     "\\bf (TeX)", "bold characters", "boldface", "bold font", 
      "\\boldmath (TeX)", "emphasis", "face", "font-weight", "normal font", 
      "\\rm (TeX)", "weight"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FontWeight is an option for Style, Cell and related constructs which \
specifies how heavy the characters in a font should be. ", 
    "synonyms" -> {"font weight"}, "title" -> "FontWeight", "type" -> 
    "Symbol", "uri" -> "ref/FontWeight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9316, 252, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19623752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65990, 1408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2192, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2815, 80, 4194, 83, 70, "ObjectNameGrid"],
Cell[7012, 165, 767, 24, 70, "Usage",
 CellID->7579]
}, Open  ]],
Cell[CellGroupData[{
Cell[7816, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8294, 211, 441, 16, 70, "Notes",
 CellID->26979],
Cell[8738, 229, 541, 18, 70, "Notes",
 CellID->20930]
}, Closed]],
Cell[CellGroupData[{
Cell[9316, 252, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19623752],
Cell[CellGroupData[{
Cell[9700, 266, 148, 5, 70, "ExampleSection",
 CellID->488622067],
Cell[9851, 273, 54, 1, 70, "ExampleText",
 CellID->47509944],
Cell[CellGroupData[{
Cell[9930, 278, 196, 5, 28, "Input",
 CellID->946307472],
Cell[10129, 285, 249, 9, 48, "Output",
 CellID->249329908]
}, Open  ]],
Cell[10393, 297, 124, 3, 70, "ExampleDelimiter",
 CellID->40371029],
Cell[10520, 302, 53, 1, 70, "ExampleText",
 CellID->44183612],
Cell[CellGroupData[{
Cell[10598, 307, 195, 5, 70, "Input",
 CellID->120864318],
Cell[10796, 314, 248, 9, 48, "Output",
 CellID->129429599]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11093, 329, 215, 7, 70, "ExampleSection",
 CellID->6295],
Cell[11311, 338, 92, 1, 70, "ExampleText",
 CellID->490889040],
Cell[CellGroupData[{
Cell[11428, 343, 156, 4, 70, "Input",
 CellID->417895822],
Cell[11587, 349, 247, 9, 48, "Output",
 CellID->87387019]
}, Open  ]],
Cell[11849, 361, 125, 3, 70, "ExampleDelimiter",
 CellID->269724364],
Cell[11977, 366, 99, 1, 70, "ExampleText",
 CellID->292128097],
Cell[CellGroupData[{
Cell[12101, 371, 483, 14, 70, "Input",
 CellID->625511073],
Cell[12587, 387, 816, 31, 44, "Output",
 CellID->201330543]
}, Open  ]],
Cell[13418, 421, 123, 3, 70, "ExampleDelimiter",
 CellID->1368198],
Cell[13544, 426, 97, 1, 70, "ExampleText",
 CellID->140250670],
Cell[CellGroupData[{
Cell[13666, 431, 412, 12, 70, "Input",
 CellID->128544304],
Cell[14081, 445, 3046, 54, 70, "Output",
 Evaluatable->False,
 CellID->43363344]
}, Open  ]],
Cell[CellGroupData[{
Cell[17164, 504, 366, 11, 70, "Input",
 CellID->397887262],
Cell[17533, 517, 44782, 764, 70, "Output",
 CellID->235129655]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62376, 1288, 311, 9, 70, "SeeAlsoSection",
 CellID->19266],
Cell[62690, 1299, 684, 26, 70, "SeeAlso",
 CellID->26991]
}, Open  ]],
Cell[CellGroupData[{
Cell[63411, 1330, 314, 9, 70, "TutorialsSection",
 CellID->18863],
Cell[63728, 1341, 159, 3, 70, "Tutorials",
 CellID->21050],
Cell[63890, 1346, 149, 3, 70, "Tutorials",
 CellID->7507],
Cell[64042, 1351, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[64225, 1359, 317, 9, 70, "MoreAboutSection",
 CellID->6269518],
Cell[64545, 1370, 134, 3, 70, "MoreAbout",
 CellID->77892748]
}, Open  ]],
Cell[64694, 1376, 50, 0, 70, "History"],
Cell[64747, 1378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

