(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23065,        891]
NotebookOptionsPosition[     17646,        701]
NotebookOutlinePosition[     19089,        740]
CellTagsIndexPosition[     19004,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"], "Throw" :> 
          Documentation`HelpLookup["paclet:ref/Throw"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Do\"\>", 2->"\<\"While\"\>", 
       3->"\<\"Throw\"\>", 4->"\<\"NestWhile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Looping Constructs\"\>", 
       2->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["For", "ObjectName",
 CellID->8155],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["For",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/For"], "[", 
       RowBox[{
        StyleBox["start", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["incr", "TI"], ",", 
        StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]executes ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     ", then repeatedly evaluates ",
     Cell[BoxData[
      StyleBox["body", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["incr", "TI"]], "InlineFormula"],
     " until ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " fails to give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27319]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " evaluates its arguments in a nonstandard way. "
}], "Notes",
 CellID->12135],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"], "[", 
   RowBox[{
    StyleBox["start", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["incr", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " does the loop with a null body. "
}], "Notes",
 CellID->7740],

Cell[TextData[{
 "The sequence of evaluation is ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["incr", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " exits as soon as ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " fails. "
}], "Notes",
 CellID->21755],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
 " is generated in the evaluation of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop exits. "
}], "Notes",
 CellID->14642],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
 " exits the evaluation of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", and continues the loop by evaluating ",
 Cell[BoxData[
  StyleBox["incr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31907],

Cell[TextData[{
 "Unless an explicit ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " is used, the value returned by ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1473],

Cell[TextData[{
 "Note that in an example like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"tot", "=", "0"}], ";", 
     RowBox[{"i", "=", "0"}]}], ",", 
    RowBox[{"i", "<", "3"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"tot", "+=", 
     RowBox[{"f", "[", "i", "]"}]}]}], "]"}]], "InlineFormula"],
 " the roles of the semicolon and comma are ",
 Cell[BoxData[
  StyleBox["reversed", "TI"]], "InlineFormula"],
 " relative to C-like programming languages. "
}], "Notes",
 CellID->17669]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53222419],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->253225074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "0"}], ",", 
   RowBox[{"i", "<", "4"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"Print", "[", "i", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145],

Cell[CellGroupData[{

Cell[BoxData["0"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->4604],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->3330],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->31823],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->701]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21031],

Cell[TextData[{
 "A comma delimits the parts of ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 "; a semicolon delimits the parts of procedures:"
}], "ExampleText",
 CellID->23742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "=", "1"}], ";", 
    RowBox[{"t", "=", "x"}]}], ",", 
   RowBox[{
    RowBox[{"i", "^", "2"}], "<", "10"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "i"}]}], ";", 
    RowBox[{"Print", "[", "t", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1866],

Cell[BoxData[
 RowBox[{"2", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->22001],

Cell[BoxData[
 RowBox[{"3", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}], ")"}], "2"]}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->21837]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31159],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " breaks out of ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->573356624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "<", "1000"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", ">", "10"}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}]}], "]"}], ";", "i"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84738196],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475648974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139756651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " continues the loop without executing the rest of the body:"
}], "ExampleText",
 CellID->8751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "=", "1"}], ";", 
    RowBox[{"k", "=", "1"}]}], ",", 
   RowBox[{"k", "\[LessEqual]", "5"}], ",", 
   RowBox[{"k", "++"}], ",", 
   RowBox[{
    RowBox[{"t", "*=", "k"}], ";", 
    RowBox[{"Print", "[", "t", "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"k", "<", "2"}], ",", 
      RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
    RowBox[{"t", "+=", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77766953],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->120791021],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->909422189],

Cell[BoxData["12"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->161770600],

Cell[BoxData["56"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->297849546],

Cell[BoxData["290"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->760457076]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9261],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loop can be written as a ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->100015937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203540335],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->10715584],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->296663092],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->643833344]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", "3"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"Print", "[", "i", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->380364078],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->155183251],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->14894847],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->103419725]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24933],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12209]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14477],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->18025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->53731447],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->591675558],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->27799136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
For"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"For - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 56.2667586}", "context" -> "System`", 
    "keywords" -> {
     "repetitive evaluation", "repeat evaluation", "evaluation loop", 
      "evaluation flow", "iteration", "iterative evaluation", "loop", 
      "repeat", "repeated calculation", "repeating evaluation"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "For[start, test, incr, body] executes start, then repeatedly evaluates \
body and incr until test fails to give True. ", "synonyms" -> {"for", "loop"},
     "title" -> "For", "type" -> "Symbol", "uri" -> "ref/For"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7388, 264, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53222419]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18862, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2161, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2784, 78, 40, 1, 70, "ObjectName",
 CellID->8155],
Cell[2827, 81, 1080, 36, 70, "Usage",
 CellID->27319]
}, Open  ]],
Cell[CellGroupData[{
Cell[3944, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4422, 139, 204, 7, 70, "Notes",
 CellID->12135],
Cell[4629, 148, 348, 12, 70, "Notes",
 CellID->7740],
Cell[4980, 162, 484, 20, 70, "Notes",
 CellID->21755],
Cell[5467, 184, 428, 17, 70, "Notes",
 CellID->14642],
Cell[5898, 203, 389, 14, 70, "Notes",
 CellID->31907],
Cell[6290, 219, 454, 18, 70, "Notes",
 CellID->1473],
Cell[6747, 239, 604, 20, 70, "Notes",
 CellID->17669]
}, Closed]],
Cell[CellGroupData[{
Cell[7388, 264, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53222419],
Cell[CellGroupData[{
Cell[7772, 278, 148, 5, 70, "ExampleSection",
 CellID->253225074],
Cell[CellGroupData[{
Cell[7945, 287, 237, 8, 70, "Input",
 CellID->145],
Cell[CellGroupData[{
Cell[8207, 299, 86, 2, 70, "Print",
 CellID->4604],
Cell[8296, 303, 86, 2, 70, "Print",
 CellID->3330],
Cell[8385, 307, 87, 2, 70, "Print",
 CellID->31823],
Cell[8475, 311, 85, 2, 70, "Print",
 CellID->701]
}, Open  ]]
}, Open  ]],
Cell[8587, 317, 121, 3, 70, "ExampleDelimiter",
 CellID->21031],
Cell[8711, 322, 245, 8, 70, "ExampleText",
 CellID->23742],
Cell[CellGroupData[{
Cell[8981, 334, 418, 15, 70, "Input",
 CellID->12201],
Cell[CellGroupData[{
Cell[9424, 353, 132, 4, 70, "Print",
 CellID->1866],
Cell[9559, 359, 209, 7, 70, "Print",
 CellID->22001],
Cell[9771, 368, 294, 10, 70, "Print",
 CellID->21837]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10126, 385, 216, 7, 70, "ExampleSection",
 CellID->31159],
Cell[10345, 394, 301, 12, 70, "ExampleText",
 CellID->573356624],
Cell[CellGroupData[{
Cell[10671, 410, 355, 12, 70, "Input",
 CellID->84738196],
Cell[11029, 424, 159, 5, 36, "Output",
 CellID->475648974]
}, Open  ]],
Cell[11203, 432, 125, 3, 70, "ExampleDelimiter",
 CellID->139756651],
Cell[11331, 437, 231, 7, 70, "ExampleText",
 CellID->8751],
Cell[CellGroupData[{
Cell[11587, 448, 518, 17, 70, "Input",
 CellID->77766953],
Cell[CellGroupData[{
Cell[12130, 469, 91, 2, 70, "Print",
 CellID->120791021],
Cell[12224, 473, 91, 2, 70, "Print",
 CellID->909422189],
Cell[12318, 477, 92, 2, 70, "Print",
 CellID->161770600],
Cell[12413, 481, 92, 2, 70, "Print",
 CellID->297849546],
Cell[12508, 485, 93, 2, 70, "Print",
 CellID->760457076]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12662, 494, 232, 7, 70, "ExampleSection",
 CellID->9261],
Cell[12897, 503, 318, 13, 70, "ExampleText",
 CellID->100015937],
Cell[CellGroupData[{
Cell[13240, 520, 213, 7, 70, "Input",
 CellID->203540335],
Cell[CellGroupData[{
Cell[13478, 531, 90, 2, 70, "Print",
 CellID->10715584],
Cell[13571, 535, 91, 2, 70, "Print",
 CellID->296663092],
Cell[13665, 539, 91, 2, 70, "Print",
 CellID->643833344]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13805, 547, 254, 8, 70, "Input",
 CellID->380364078],
Cell[CellGroupData[{
Cell[14084, 559, 91, 2, 70, "Print",
 CellID->155183251],
Cell[14178, 563, 90, 2, 70, "Print",
 CellID->14894847],
Cell[14271, 567, 91, 2, 70, "Print",
 CellID->103419725]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14435, 577, 311, 9, 70, "SeeAlsoSection",
 CellID->24933],
Cell[14749, 588, 919, 35, 70, "SeeAlso",
 CellID->12209]
}, Open  ]],
Cell[CellGroupData[{
Cell[15705, 628, 314, 9, 70, "TutorialsSection",
 CellID->14477],
Cell[16022, 639, 164, 3, 70, "Tutorials",
 CellID->18025]
}, Open  ]],
Cell[CellGroupData[{
Cell[16223, 647, 318, 9, 70, "MoreAboutSection",
 CellID->53731447],
Cell[16544, 658, 147, 3, 70, "MoreAbout",
 CellID->591675558],
Cell[16694, 663, 154, 3, 70, "MoreAbout",
 CellID->27799136]
}, Open  ]],
Cell[CellGroupData[{
Cell[16885, 671, 305, 8, 70, "RelatedLinksSection"],
Cell[17193, 681, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[17589, 697, 27, 0, 70, "History"],
Cell[17619, 699, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

