(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73909,       2779]
NotebookOptionsPosition[     61535,       2348]
NotebookOutlinePosition[     63094,       2389]
CellTagsIndexPosition[     63008,       2384]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quantifiers" :> 
          Documentation`HelpLookup["paclet:tutorial/Quantifiers"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quantifiers\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exists" :> Documentation`HelpLookup["paclet:ref/Exists"], 
          "Resolve" :> Documentation`HelpLookup["paclet:ref/Resolve"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Blank" :> Documentation`HelpLookup["paclet:ref/Blank"], 
          "SolveAlways" :> 
          Documentation`HelpLookup["paclet:ref/SolveAlways"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Exists\"\>", 2->"\<\"Resolve\"\>", 
       3->"\<\"Reduce\"\>", 4->"\<\"Element\"\>", 5->"\<\"Blank\"\>", 
       6->"\<\"SolveAlways\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Logic & Boolean Algebra\"\>",
        2->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ForAll ",
 StyleBox["(\[ForAll])", "OperatorCharacter"]
}], "ObjectName",
 CellID->3208],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ForAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ForAll"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the statement that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for all values of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ForAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ForAll"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["cond", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]states that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for all ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " satisfying the condition ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ForAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ForAll"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]states that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for all values of all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". The character ",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]fa\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData["\\[ForAll]"], "InlineCharacterName"],
 ". The variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is given as a subscript. "
}], "Notes",
 CellID->4798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", 
     RowBox[{"x", ",", 
      StyleBox["cond", "TI"]}]], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24002],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21211],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[ForAll]", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["cond", "TI"]}]], 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24344],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ForAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
 " can be used in such functions as ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28152],

Cell[TextData[{
 "The condition ",
 Cell[BoxData[
  StyleBox["cond", "TI"]], "InlineFormula"],
 " is often used to specify the domain of a variable, as in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1022],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     RowBox[{
      StyleBox["cond", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8619],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", 
     SubscriptBox["x", "1"]], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[ForAll]", 
       SubscriptBox["x", "2"]], "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->29275],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be localized, as in ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26707]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467988868],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61911495],

Cell[TextData[{
 "This states that for all ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], TraditionalForm]], "InlineMath"],
 " is positive:"
}], "ExampleText",
 CellID->204316434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70687862],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", "x"], 
  RowBox[{
   RowBox[{"c", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}]}], ">", "0"}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->698902572]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to get a condition on real parameters for which the statement is true:"
}], "ExampleText",
 CellID->9573649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"%", ",", " ", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430461369],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{342, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1719118]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the condition in a solved form:"
}], "ExampleText",
 CellID->713782625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->337761020],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"c", ">", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{"4", " ", "a"}]]}]}], ")"}]}]], "Output",
 ImageSize->{271, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->288722883]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10986],

Cell[TextData[{
 "This states that for all ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " the inequation is true:"
}], "ExampleText",
 CellID->46228782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "x", "+", "1"}], "\[NotEqual]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331483428],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", "x"], 
  RowBox[{
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169085971]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove that the statement is false:"
}], "ExampleText",
 CellID->337485886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65029305],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139286317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122518545],

Cell[TextData[{
 "This states that for all real ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " the inequation is true:"
}], "ExampleText",
 CellID->576543645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "x", "+", "1"}], "\[NotEqual]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157594200],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Element]", "Reals"}]}]], 
  RowBox[{
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140810741]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove that the statement is true:"
}], "ExampleText",
 CellID->36144885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158538849],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60788320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35607302],

Cell[TextData[{
 "This states that for all pairs ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " the inequality is true:"
}], "ExampleText",
 CellID->2016847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[GreaterEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49125088],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "\[GreaterEqual]", "0"}]}]], "Output",
 ImageSize->{99, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333658303]
}, Open  ]],

Cell[TextData[{
 "With domain not specified, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " considers algebraic variables in inequalities to be real:"
}], "ExampleText",
 CellID->156930490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93535409],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187032298]
}, Open  ]],

Cell[TextData[{
 "With domain ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ", complex values that make the inequality ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " are allowed:"
}], "ExampleText",
 CellID->228888947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"%%", ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152035922],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23853836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7788870],

Cell[TextData[{
 "This states the tautology ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[And]", 
    RowBox[{"p", "\[DoubleLongRightArrow]", 
     FormBox["q",
      TraditionalForm]}]}], TraditionalForm]], "InlineMath"],
 " implies ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->143851254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q"}], "}"}], ",", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{"p", "&&", 
       RowBox[{"Implies", "[", 
        RowBox[{"p", ",", "q"}], "]"}]}], ",", "q"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242585925],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}]], 
  RowBox[{"Implies", "[", 
   RowBox[{
    RowBox[{"p", "&&", 
     RowBox[{"Implies", "[", 
      RowBox[{"p", ",", "q"}], "]"}]}], ",", "q"}], "]"}]}]], "Output",
 ImageSize->{236, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[1]= ]",
 CellID->212106647]
}, Open  ]],

Cell["Prove it:", "ExampleText",
 CellID->78430878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193562729],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[2]= ]",
 CellID->93901621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373276802],

Cell[TextData[{
 "If the expression does not explicitly contain a variable, ",
 Cell[BoxData[
  ButtonBox["ForAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
 " simplifies automatically:"
}], "ExampleText",
 CellID->217337348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{"x", ",", 
   RowBox[{"y", "\[Equal]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761623207],

Cell[BoxData[
 RowBox[{"y", "\[Equal]", "0"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297063404]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"y", "\[Equal]", "z"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124115997],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]], 
  RowBox[{"y", "\[Equal]", "z"}]}]], "Output",
 ImageSize->{71, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1013211884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23784818],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->221878257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{"p", "[", "x", "]"}]}], "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->178484386],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[ForAll]", "x"], 
   RowBox[{"p", "(", "x", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[1]//TraditionalForm= ]",
 CellID->249600658]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16255],

Cell["\<\
This states the inequality between the arithmetic mean and the geometric \
mean:\
\>", "ExampleText",
 CellID->49187758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "/", "2"}], "\[GreaterEqual]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", " ", "b"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226717895],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}]}]}]], 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", "b"}], "2"], "\[GreaterEqual]", 
   SqrtBox[
    RowBox[{"a", " ", "b"}]]}]}]], "Output",
 ImageSize->{164, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147025521]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove the inequality:"
}], "ExampleText",
 CellID->279817491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224569629],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236931844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->639407459],

Cell["\<\
This states a special case of H\[ODoubleDot]lder's inequality:\
\>", "ExampleText",
 CellID->604358210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{"d", ">", "0"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "c"}], "+", 
     RowBox[{"b", " ", "d"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "+", 
       RowBox[{"d", "^", "2"}]}], "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->549226970],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"c", ">", "0"}], "&&", 
     RowBox[{"d", ">", "0"}]}]}]], 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "c"}], "+", 
    RowBox[{"b", " ", "d"}]}], "\[LessEqual]", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SuperscriptBox["d", "2"]}]]}]}]}]], "Output",
 ImageSize->{332, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95654543]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove the inequality:"
}], "ExampleText",
 CellID->87924586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->307502371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229919811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237324540],

Cell["This states a special case of Minkowski's inequality:", "ExampleText",
 CellID->32116044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], "^", "2"}]}], "]"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{"b", "^", "2"}]}], "]"}], "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"c", "^", "2"}], "+", 
       RowBox[{"d", "^", "2"}]}], "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65274632],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", "d"}], ")"}], "2"]}]], "\[LessEqual]", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "+", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SuperscriptBox["d", "2"]}]]}]}]}]], "Output",
 ImageSize->{324, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12526414]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove the inequality:"
}], "ExampleText",
 CellID->440432247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431665753],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350580204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185129299],

Cell[TextData[{
 "Prove geometric inequalities for ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " sides of a triangle:"
}], "ExampleText",
 CellID->752673305],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"acute", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], ">", 
     RowBox[{"c", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"b", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"a", "^", "2"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"s", 
     RowBox[{"(", 
      RowBox[{"s", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->186965933],

Cell["\<\
This states that an inequality is satisfied for all triangles:\
\>", "ExampleText",
 CellID->16833573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "triangle", ",", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "c", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "/", 
        RowBox[{"b", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"c", "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"c", "^", "2"}], "/", 
        RowBox[{"a", "^", "2"}]}]}], ")"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"a", "^", "3"}], "+", 
     RowBox[{"b", "^", "3"}], "+", 
     RowBox[{"c", "^", "3"}], "+", 
     RowBox[{"a", " ", "b", 
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}]}], "+", 
     RowBox[{"a", " ", "c", 
      RowBox[{"(", 
       RowBox[{"a", "-", "c"}], ")"}]}], "+", 
     RowBox[{"b", " ", "c", 
      RowBox[{"(", 
       RowBox[{"c", "-", "b"}], ")"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6016461],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"c", ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
     RowBox[{
      RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
     RowBox[{
      RowBox[{"b", "+", "c"}], ">", "a"}]}]}]], 
  RowBox[{
   RowBox[{"a", " ", "b", " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SuperscriptBox["a", "2"], 
       SuperscriptBox["b", "2"]], "+", 
      FractionBox[
       SuperscriptBox["b", "2"], 
       SuperscriptBox["c", "2"]], "+", 
      FractionBox[
       SuperscriptBox["c", "2"], 
       SuperscriptBox["a", "2"]]}], ")"}]}], "\[GreaterEqual]", 
   RowBox[{
    SuperscriptBox["a", "3"], "+", 
    SuperscriptBox["b", "3"], "+", 
    RowBox[{"a", " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"a", "-", "c"}], ")"}], " ", "c"}], "+", 
    SuperscriptBox["c", "3"], "+", 
    RowBox[{"b", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "c"}], ")"}]}]}]}]}]], "Output",
 ImageSize->{355, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->414530572]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove the inequality:"
}], "ExampleText",
 CellID->61703012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->345611915],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21303860]
}, Open  ]],

Cell["\<\
This states that an inequality is satisfied for all acute triangles:\
\>", "ExampleText",
 CellID->290993733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"triangle", "&&", "acute"}], ",", 
   RowBox[{
    RowBox[{"27", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"a", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "^", "2"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "F"}], ")"}], "^", "6"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->210392438],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "&&", 
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"c", ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
     RowBox[{
      RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
     RowBox[{
      RowBox[{"b", "+", "c"}], ">", "a"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], ">", 
      SuperscriptBox["c", "2"]}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["c", "2"]}], ">", 
      SuperscriptBox["b", "2"]}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ">", 
      SuperscriptBox["a", "2"]}]}]}]], 
  RowBox[{
   RowBox[{"27", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}], "2"]}], "\[LessEqual]", 
   RowBox[{"512", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], 
     "3"]}]}]}]], "Output",
 ImageSize->{481, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8650523]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove the inequality:"
}], "ExampleText",
 CellID->41318811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->663339354],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->330749333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97572279],

Cell["Test whether one region is included in another:", "ExampleText",
 CellID->102801770],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"2", " ", "x", " ", "y"}]}], "\[LessEqual]", "1"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->165438567],

Cell[TextData[{
 "This states that all points satisfying ",
 Cell[BoxData["R1"], "InlineFormula"],
 " also satisfy ",
 Cell[BoxData["R2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->54453802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"R1", " ", "\[Implies]", "R2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->814644484],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]], 
  RowBox[{"Implies", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "x", " ", "y"}], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", "2"}]}], "]"}]}]], "Output",\

 ImageSize->{282, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1771171]
}, Open  ]],

Cell[TextData[{
 "The statement is true, hence the region defined by ",
 Cell[BoxData["R1"], "InlineFormula"],
 " is included in the region defined by ",
 Cell[BoxData["R2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->202488301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52993724],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->460201638]
}, Open  ]],

Cell["Plot the relationship:", "ExampleText",
 CellID->241929558],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RegionPlot", "[", 
      RowBox[{"R1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "35"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Pink"}]}], "]"}], ",", 
     RowBox[{"RegionPlot", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35717418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"r2", ",", "r1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->204010330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5882091]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22471],

Cell[TextData[{
 "Negation of ",
 Cell[BoxData[
  ButtonBox["ForAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["Exists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->375346019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Equal]", "a"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306369163],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{"x", "\[NotEqual]", "a"}]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->846249550]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}], ",", 
    RowBox[{"x", "\[Equal]", "a"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402630171],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Element]", "Reals"}]}]], 
  RowBox[{"x", "\[NotEqual]", "a"}]}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->241945937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86081891],

Cell[TextData[{
 "Quantifiers can be eliminated using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->125926680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"form", "=", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], " ", "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"a", " ", 
          RowBox[{"y", "^", "2"}]}], "+", 
         RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}]}], ",", 
      RowBox[{"x", "\[Equal]", "y"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->645716618],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]], 
  RowBox[{"Implies", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"c", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "2"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"c", "+", 
       RowBox[{"b", " ", "y"}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["y", "2"]}]}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"x", "\[Equal]", "y"}]}], "]"}]}]], "Output",
 ImageSize->{404, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560375774]
}, Open  ]],

Cell["This eliminates the quantifier:", "ExampleText",
 CellID->499650896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"form", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->457795290],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[GreaterEqual]", "0"}]}]], "Output",\

 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217355013]
}, Open  ]],

Cell["\<\
This eliminates the quantifier and solves the resulting equations and \
inequalities:\
\>", "ExampleText",
 CellID->269908548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"form", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->84668305],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{"c", "\[LessEqual]", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{"4", " ", "a"}]]}]}], ")"}], "||", 
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"c", "\[GreaterEqual]", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{"4", " ", "a"}]]}]}], ")"}]}]], "Output",
 ImageSize->{282, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->30342070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10126324],

Cell[TextData[{
 "This states that an equation is true for all complex values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->685179284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", " ", "-", 
        RowBox[{"2", "b"}], "+", "1"}], ")"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", "\[Equal]", 
    
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", "b", "+", 
     RowBox[{"3", "c"}], "-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33917184],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", "x"], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", 
       SuperscriptBox["b", "2"], "-", "c"}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "a", "-", 
       RowBox[{"2", " ", "b"}]}], ")"}], " ", 
     SuperscriptBox["x", "2"]}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["a", "2"], "-", "b", "+", 
    RowBox[{"3", " ", "c"}]}]}]}]], "Output",
 ImageSize->{301, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352764416]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find the values of parameters for which the statement is true:"
}], "ExampleText",
 CellID->636343469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5719946],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "11"}], "-", 
        RowBox[{"3", " ", 
         SqrtBox["13"]}]}], ")"}]}]}], "||", 
    RowBox[{"c", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "11"}], "+", 
        RowBox[{"3", " ", 
         SqrtBox["13"]}]}], ")"}]}]}]}], ")"}], "&&", 
  RowBox[{"b", "\[Equal]", 
   FractionBox[
    RowBox[{"4", "+", "c"}], "3"]}], "&&", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"2", " ", "c"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{475, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75350398]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->286318889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", " ", "-", 
        RowBox[{"2", "b"}], "+", "1"}], ")"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", "^", "2"}], "-", "c"}], ")"}], "x"}]}], " ", "\[Equal]", 
    
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", "b", "+", 
     RowBox[{"3", "c"}], "-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->392689070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "11"}], "-", 
         RowBox[{"3", " ", 
          SqrtBox["13"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["13"]}]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["13"]}], ")"}]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["11", "2"]}], "+", 
       FractionBox[
        RowBox[{"3", " ", 
         SqrtBox["13"]}], "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->264932402]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2664],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolveAlways",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SolveAlways"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24254],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "Tutorials",
 CellID->306]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->279212929],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->714290429],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->388881301],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ForAll (\[ForAll]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 50.8447448}", "context" -> "System`", 
    "keywords" -> {
     "always", "first order logic", "for all quantifiers", 
      "general quantifier", "logic quantifier", "universal quantifier", 
      "universal quantor"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ForAll[x, expr] represents the statement that expr is True for all \
values of x. ForAll[x, cond, expr] states that expr is True for all x \
satisfying the condition cond. ForAll[{x_1, x_2, ...}, expr] states that expr \
is True for all values of all the x_i. ", "synonyms" -> {"for all"}, "title" -> 
    "ForAll", "type" -> "Symbol", "uri" -> "ref/ForAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11701, 422, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->467988868]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62864, 2377}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2509, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3132, 84, 106, 4, 70, "ObjectName",
 CellID->3208],
Cell[3241, 90, 2540, 85, 70, "Usage",
 CellID->17726]
}, Open  ]],
Cell[CellGroupData[{
Cell[5818, 180, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6296, 197, 829, 29, 70, "Notes",
 CellID->4798],
Cell[7128, 228, 514, 20, 70, "Notes",
 CellID->24002],
Cell[7645, 250, 565, 23, 70, "Notes",
 CellID->21211],
Cell[8213, 275, 500, 20, 70, "Notes",
 CellID->24344],
Cell[8716, 297, 580, 22, 70, "Notes",
 CellID->28152],
Cell[9299, 321, 365, 13, 70, "Notes",
 CellID->1022],
Cell[9667, 336, 708, 27, 70, "Notes",
 CellID->8619],
Cell[10378, 365, 776, 30, 70, "Notes",
 CellID->29275],
Cell[11157, 397, 507, 20, 70, "Notes",
 CellID->26707]
}, Closed]],
Cell[CellGroupData[{
Cell[11701, 422, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467988868],
Cell[CellGroupData[{
Cell[12086, 436, 147, 5, 70, "ExampleSection",
 CellID->61911495],
Cell[12236, 443, 347, 13, 70, "ExampleText",
 CellID->204316434],
Cell[CellGroupData[{
Cell[12608, 460, 262, 9, 28, "Input",
 CellID->70687862],
Cell[12873, 471, 340, 12, 36, "Output",
 CellID->698902572]
}, Open  ]],
Cell[13228, 486, 253, 8, 70, "ExampleText",
 CellID->9573649],
Cell[CellGroupData[{
Cell[13506, 498, 135, 4, 28, "Input",
 CellID->430461369],
Cell[13644, 504, 974, 34, 58, "Output",
 CellID->1719118]
}, Open  ]],
Cell[14633, 541, 211, 7, 70, "ExampleText",
 CellID->713782625],
Cell[CellGroupData[{
Cell[14869, 552, 201, 7, 70, "Input",
 CellID->337761020],
Cell[15073, 561, 507, 18, 55, "Output",
 CellID->288722883]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15629, 585, 216, 7, 70, "ExampleSection",
 CellID->10986],
Cell[15848, 594, 175, 6, 70, "ExampleText",
 CellID->46228782],
Cell[CellGroupData[{
Cell[16048, 604, 223, 8, 70, "Input",
 CellID->331483428],
Cell[16274, 614, 298, 10, 36, "Output",
 CellID->169085971]
}, Open  ]],
Cell[16587, 627, 222, 8, 70, "ExampleText",
 CellID->337485886],
Cell[CellGroupData[{
Cell[16834, 639, 102, 3, 70, "Input",
 CellID->65029305],
Cell[16939, 644, 162, 5, 36, "Output",
 CellID->139286317]
}, Open  ]],
Cell[17116, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->122518545],
Cell[17244, 657, 181, 6, 70, "ExampleText",
 CellID->576543645],
Cell[CellGroupData[{
Cell[17450, 667, 297, 10, 70, "Input",
 CellID->157594200],
Cell[17750, 679, 361, 12, 36, "Output",
 CellID->140810741]
}, Open  ]],
Cell[18126, 694, 220, 8, 70, "ExampleText",
 CellID->36144885],
Cell[CellGroupData[{
Cell[18371, 706, 103, 3, 70, "Input",
 CellID->158538849],
Cell[18477, 711, 160, 5, 36, "Output",
 CellID->60788320]
}, Open  ]],
Cell[18652, 719, 124, 3, 70, "ExampleDelimiter",
 CellID->35607302],
Cell[18779, 724, 229, 8, 70, "ExampleText",
 CellID->2016847],
Cell[CellGroupData[{
Cell[19033, 736, 288, 10, 70, "Input",
 CellID->49125088],
Cell[19324, 748, 367, 13, 38, "Output",
 CellID->333658303]
}, Open  ]],
Cell[19706, 764, 265, 8, 70, "ExampleText",
 CellID->156930490],
Cell[CellGroupData[{
Cell[19996, 776, 102, 3, 70, "Input",
 CellID->93535409],
Cell[20101, 781, 161, 5, 36, "Output",
 CellID->187032298]
}, Open  ]],
Cell[20277, 789, 369, 13, 70, "ExampleText",
 CellID->228888947],
Cell[CellGroupData[{
Cell[20671, 806, 135, 4, 70, "Input",
 CellID->152035922],
Cell[20809, 812, 161, 5, 36, "Output",
 CellID->23853836]
}, Open  ]],
Cell[20985, 820, 123, 3, 70, "ExampleDelimiter",
 CellID->7788870],
Cell[21111, 825, 346, 13, 70, "ExampleText",
 CellID->143851254],
Cell[CellGroupData[{
Cell[21482, 842, 357, 13, 70, "Input",
 CellID->242585925],
Cell[21842, 857, 414, 14, 52, "Output",
 CellID->212106647]
}, Open  ]],
Cell[22271, 874, 51, 1, 70, "ExampleText",
 CellID->78430878],
Cell[CellGroupData[{
Cell[22347, 879, 103, 3, 70, "Input",
 CellID->193562729],
Cell[22453, 884, 171, 5, 50, "Output",
 CellID->93901621]
}, Open  ]],
Cell[22639, 892, 125, 3, 70, "ExampleDelimiter",
 CellID->373276802],
Cell[22767, 897, 262, 8, 70, "ExampleText",
 CellID->217337348],
Cell[CellGroupData[{
Cell[23054, 909, 156, 5, 70, "Input",
 CellID->761623207],
Cell[23213, 916, 187, 6, 36, "Output",
 CellID->297063404]
}, Open  ]],
Cell[CellGroupData[{
Cell[23437, 927, 215, 7, 70, "Input",
 CellID->124115997],
Cell[23655, 936, 285, 10, 38, "Output",
 CellID->1013211884]
}, Open  ]],
Cell[23955, 949, 124, 3, 70, "ExampleDelimiter",
 CellID->23784818],
Cell[24082, 954, 203, 7, 70, "ExampleText",
 CellID->221878257],
Cell[CellGroupData[{
Cell[24310, 965, 196, 7, 70, "Input",
 CellID->178484386],
Cell[24509, 974, 292, 9, 50, "Output",
 CellID->249600658]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24850, 989, 223, 7, 70, "ExampleSection",
 CellID->16255],
Cell[25076, 998, 130, 4, 70, "ExampleText",
 CellID->49187758],
Cell[CellGroupData[{
Cell[25231, 1006, 434, 15, 70, "Input",
 CellID->226717895],
Cell[25668, 1023, 481, 18, 51, "Output",
 CellID->147025521]
}, Open  ]],
Cell[26164, 1044, 209, 8, 70, "ExampleText",
 CellID->279817491],
Cell[CellGroupData[{
Cell[26398, 1056, 103, 3, 70, "Input",
 CellID->224569629],
Cell[26504, 1061, 161, 5, 36, "Output",
 CellID->236931844]
}, Open  ]],
Cell[26680, 1069, 125, 3, 70, "ExampleDelimiter",
 CellID->639407459],
Cell[26808, 1074, 113, 3, 70, "ExampleText",
 CellID->604358210],
Cell[CellGroupData[{
Cell[26946, 1081, 717, 24, 70, "Input",
 CellID->549226970],
Cell[27666, 1107, 776, 28, 45, "Output",
 CellID->95654543]
}, Open  ]],
Cell[28457, 1138, 208, 8, 70, "ExampleText",
 CellID->87924586],
Cell[CellGroupData[{
Cell[28690, 1150, 103, 3, 70, "Input",
 CellID->307502371],
Cell[28796, 1155, 161, 5, 36, "Output",
 CellID->229919811]
}, Open  ]],
Cell[28972, 1163, 125, 3, 70, "ExampleDelimiter",
 CellID->237324540],
Cell[29100, 1168, 95, 1, 70, "ExampleText",
 CellID->32116044],
Cell[CellGroupData[{
Cell[29220, 1173, 714, 24, 70, "Input",
 CellID->65274632],
Cell[29937, 1199, 726, 27, 45, "Output",
 CellID->12526414]
}, Open  ]],
Cell[30678, 1229, 209, 8, 70, "ExampleText",
 CellID->440432247],
Cell[CellGroupData[{
Cell[30912, 1241, 103, 3, 70, "Input",
 CellID->431665753],
Cell[31018, 1246, 161, 5, 36, "Output",
 CellID->350580204]
}, Open  ]],
Cell[31194, 1254, 125, 3, 70, "ExampleDelimiter",
 CellID->185129299],
Cell[31322, 1259, 327, 12, 70, "ExampleText",
 CellID->752673305],
Cell[31652, 1273, 1328, 48, 70, "Input",
 CellID->186965933],
Cell[32983, 1323, 112, 3, 70, "ExampleText",
 CellID->16833573],
Cell[CellGroupData[{
Cell[33120, 1330, 999, 32, 70, "Input",
 CellID->6016461],
Cell[34122, 1364, 1441, 48, 72, "Output",
 CellID->414530572]
}, Open  ]],
Cell[35578, 1415, 208, 8, 70, "ExampleText",
 CellID->61703012],
Cell[CellGroupData[{
Cell[35811, 1427, 103, 3, 70, "Input",
 CellID->345611915],
Cell[35917, 1432, 160, 5, 36, "Output",
 CellID->21303860]
}, Open  ]],
Cell[36092, 1440, 119, 3, 70, "ExampleText",
 CellID->290993733],
Cell[CellGroupData[{
Cell[36236, 1447, 903, 30, 70, "Input",
 CellID->210392438],
Cell[37142, 1479, 2506, 85, 91, "Output",
 CellID->8650523]
}, Open  ]],
Cell[39663, 1567, 208, 8, 70, "ExampleText",
 CellID->41318811],
Cell[CellGroupData[{
Cell[39896, 1579, 103, 3, 70, "Input",
 CellID->663339354],
Cell[40002, 1584, 161, 5, 36, "Output",
 CellID->330749333]
}, Open  ]],
Cell[40178, 1592, 124, 3, 70, "ExampleDelimiter",
 CellID->97572279],
Cell[40305, 1597, 90, 1, 70, "ExampleText",
 CellID->102801770],
Cell[40398, 1600, 488, 18, 70, "Input",
 CellID->165438567],
Cell[40889, 1620, 199, 7, 70, "ExampleText",
 CellID->54453802],
Cell[CellGroupData[{
Cell[41113, 1631, 214, 7, 70, "Input",
 CellID->814644484],
Cell[41330, 1640, 624, 22, 39, "Output",
 CellID->1771171]
}, Open  ]],
Cell[41969, 1665, 236, 7, 70, "ExampleText",
 CellID->202488301],
Cell[CellGroupData[{
Cell[42230, 1676, 102, 3, 70, "Input",
 CellID->52993724],
Cell[42335, 1681, 161, 5, 36, "Output",
 CellID->460201638]
}, Open  ]],
Cell[42511, 1689, 65, 1, 70, "ExampleText",
 CellID->241929558],
Cell[42579, 1692, 845, 27, 70, "Input",
 CellID->35717418],
Cell[CellGroupData[{
Cell[43449, 1723, 149, 5, 70, "Input",
 CellID->204010330],
Cell[43601, 1730, 4639, 80, 70, "Output",
 Evaluatable->False,
 CellID->5882091]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48289, 1816, 233, 7, 70, "ExampleSection",
 CellID->22471],
Cell[48525, 1825, 318, 13, 70, "ExampleText",
 CellID->375346019],
Cell[CellGroupData[{
Cell[48868, 1842, 176, 6, 70, "Input",
 CellID->306369163],
Cell[49047, 1850, 238, 8, 36, "Output",
 CellID->846249550]
}, Open  ]],
Cell[CellGroupData[{
Cell[49322, 1863, 252, 8, 70, "Input",
 CellID->402630171],
Cell[49577, 1873, 300, 10, 36, "Output",
 CellID->241945937]
}, Open  ]],
Cell[49892, 1886, 124, 3, 70, "ExampleDelimiter",
 CellID->86081891],
Cell[50019, 1891, 341, 13, 70, "ExampleText",
 CellID->125926680],
Cell[CellGroupData[{
Cell[50385, 1908, 711, 22, 70, "Input",
 CellID->645716618],
Cell[51099, 1932, 730, 24, 39, "Output",
 CellID->560375774]
}, Open  ]],
Cell[51844, 1959, 74, 1, 70, "ExampleText",
 CellID->499650896],
Cell[CellGroupData[{
Cell[51943, 1964, 133, 4, 70, "Input",
 CellID->457795290],
Cell[52079, 1970, 357, 13, 36, "Output",
 CellID->217355013]
}, Open  ]],
Cell[52451, 1986, 136, 4, 70, "ExampleText",
 CellID->269908548],
Cell[CellGroupData[{
Cell[52612, 1994, 202, 7, 70, "Input",
 CellID->84668305],
Cell[52817, 2003, 601, 21, 55, "Output",
 CellID->30342070]
}, Open  ]],
Cell[53433, 2027, 124, 3, 70, "ExampleDelimiter",
 CellID->10126324],
Cell[53560, 2032, 191, 6, 70, "ExampleText",
 CellID->685179284],
Cell[CellGroupData[{
Cell[53776, 2042, 539, 19, 70, "Input",
 CellID->33917184],
Cell[54318, 2063, 635, 22, 39, "Output",
 CellID->352764416]
}, Open  ]],
Cell[54968, 2088, 248, 8, 70, "ExampleText",
 CellID->636343469],
Cell[CellGroupData[{
Cell[55241, 2100, 100, 3, 70, "Input",
 CellID->5719946],
Cell[55344, 2105, 896, 33, 51, "Output",
 CellID->75350398]
}, Open  ]],
Cell[56255, 2141, 224, 8, 70, "ExampleText",
 CellID->286318889],
Cell[CellGroupData[{
Cell[56504, 2153, 545, 19, 70, "Input",
 CellID->392689070],
Cell[57052, 2174, 1300, 48, 86, "Output",
 CellID->264932402]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58413, 2229, 310, 9, 70, "SeeAlsoSection",
 CellID->2664],
Cell[58726, 2240, 1418, 53, 70, "SeeAlso",
 CellID->8659]
}, Open  ]],
Cell[CellGroupData[{
Cell[60181, 2298, 314, 9, 70, "TutorialsSection",
 CellID->24254],
Cell[60498, 2309, 131, 3, 70, "Tutorials",
 CellID->306]
}, Open  ]],
Cell[CellGroupData[{
Cell[60666, 2317, 319, 9, 70, "MoreAboutSection",
 CellID->279212929],
Cell[60988, 2328, 157, 3, 70, "MoreAbout",
 CellID->714290429],
Cell[61148, 2333, 147, 3, 70, "MoreAbout",
 CellID->388881301],
Cell[61298, 2338, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[61478, 2344, 27, 0, 70, "History"],
Cell[61508, 2346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

