(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14597,        502]
NotebookOptionsPosition[     11674,        408]
NotebookOutlinePosition[     13115,        447]
CellTagsIndexPosition[     13030,        442]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningOutputFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Defining Output Formats\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToString" :> Documentation`HelpLookup["paclet:ref/ToString"], 
          "ToBoxes" :> Documentation`HelpLookup["paclet:ref/ToBoxes"], 
          "MakeBoxes" :> Documentation`HelpLookup["paclet:ref/MakeBoxes"], 
          "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], "FormatType" :> 
          Documentation`HelpLookup["paclet:ref/FormatType"], "Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToString\"\>", 2->"\<\"ToBoxes\"\>",
        3->"\<\"MakeBoxes\"\>", 4->"\<\"MakeExpression\"\>", 
       5->"\<\"FormatType\"\>", 
       6->"\<\"Interpretation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Format", "ObjectName",
 CellID->32038],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Format",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Format"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the formatted form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". Assigning values to ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Format",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Format"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " defines print forms for expressions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Format",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Format"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a format for the specified form of output. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Standard forms for formatted output are: ", "Notes",
 CellID->4130],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CForm"], Cell[
    "C language input form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FortranForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FortranForm"], Cell[
    "Fortran input form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell["\<\
one\[Hyphen]dimensional form suitable for direct keyboard input \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MathMLForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MathMLForm"], Cell[
    "MathML form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OutputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OutputForm"], Cell["\<\
character\[Hyphen]based two\[Hyphen]dimensional form \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell[
    "standard two\[Hyphen]dimensional form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TeXForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TeXForm"], Cell[
    "TeX input form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[
    "form approximating traditional mathematical notation ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->3928],

Cell["You can add your own forms for formatted output. ", "Notes",
 CellID->21985],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Format", "[", 
    StyleBox["s", "TI"], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " defines a symbol ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " to print like ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->503670053]
}], "Notes",
 CellID->3958],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Format", "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " defines a function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to print like ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->303594532]
}], "Notes",
 CellID->28185],

Cell[TextData[{
 "If you specify a new output format for an expression by giving a definition \
for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ", there is no guarantee that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will be able to interpret this output format if it is used as input. "
}], "Notes",
 CellID->22283],

Cell[TextData[{
 "Definitions given for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " are used before those given for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1688]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134985418],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->192111459],

Cell[TextData[{
 "See an expression formatted in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->654242009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Format", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99857668],

Cell[BoxData[
 TagBox[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}],
   TraditionalForm],
  Format[#, TraditionalForm]& ]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599911158]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14862],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormatType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormatType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1004]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2324],

Cell[TextData[ButtonBox["Defining Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningOutputFormats"]], "Tutorials",
 CellID->13414]
}, Open  ]],

Cell["New in 1  |  Last modified in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Format - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 51.6103894}", "context" -> "System`", 
    "keywords" -> {
     "format expression", "formatted output", "output form", "special output",
       "custom formatting", "extensible formatting"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Format[expr] prints as the formatted form of expr. Assigning values to \
Format[expr] defines print forms for expressions. Format[expr, form] gives a \
format for the specified form of output. ", "synonyms" -> {}, "title" -> 
    "Format", "type" -> "Symbol", "uri" -> "ref/Format"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8012, 261, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134985418]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12887, 435}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1723, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2346, 66, 44, 1, 70, "ObjectName",
 CellID->32038],
Cell[2393, 69, 1174, 36, 70, "Usage",
 CellID->2605]
}, Open  ]],
Cell[CellGroupData[{
Cell[3604, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4082, 127, 73, 1, 70, "Notes",
 CellID->4130],
Cell[4158, 130, 2033, 54, 70, "2ColumnTableMod",
 CellID->3928],
Cell[6194, 186, 82, 1, 70, "Notes",
 CellID->21985],
Cell[6279, 189, 434, 17, 70, "Notes",
 CellID->3958],
Cell[6716, 208, 500, 19, 70, "Notes",
 CellID->28185],
Cell[7219, 229, 403, 12, 70, "Notes",
 CellID->22283],
Cell[7625, 243, 350, 13, 70, "Notes",
 CellID->1688]
}, Closed]],
Cell[CellGroupData[{
Cell[8012, 261, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134985418],
Cell[CellGroupData[{
Cell[8397, 275, 148, 5, 70, "ExampleSection",
 CellID->192111459],
Cell[8548, 282, 228, 8, 70, "ExampleText",
 CellID->654242009],
Cell[CellGroupData[{
Cell[8801, 294, 169, 5, 28, "Input",
 CellID->99857668],
Cell[8973, 301, 263, 10, 36, "Output",
 CellID->599911158]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9297, 318, 311, 9, 70, "SeeAlsoSection",
 CellID->14862],
Cell[9611, 329, 1458, 53, 70, "SeeAlso",
 CellID->1004]
}, Open  ]],
Cell[CellGroupData[{
Cell[11106, 387, 313, 9, 70, "TutorialsSection",
 CellID->2324],
Cell[11422, 398, 155, 3, 70, "Tutorials",
 CellID->13414]
}, Open  ]],
Cell[11592, 404, 52, 0, 70, "History"],
Cell[11647, 406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

