(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    170859,       4894]
NotebookOptionsPosition[    152252,       4232]
NotebookOutlinePosition[    153657,       4271]
CellTagsIndexPosition[    153570,       4266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Numerical Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNumericalData"], 
          "Discrete Fourier Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/FourierTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Numerical Data\"\>", 
       2->"\<\"Discrete Fourier Transforms\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"], "FourierDCT" :> 
          Documentation`HelpLookup["paclet:ref/FourierDCT"], "FourierDST" :> 
          Documentation`HelpLookup["paclet:ref/FourierDST"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "FourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierSinTransform"], "Fit" :> 
          Documentation`HelpLookup["paclet:ref/Fit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InverseFourier\"\>", 2->"\<\"FourierDCT\"\>", 
       3->"\<\"FourierDST\"\>", 4->"\<\"FourierTransform\"\>", 
       5->"\<\"FourierSinTransform\"\>", 
       6->"\<\"Fit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Data Transforms and Smoothing\"\>",
        2->"\<\"Image Processing\"\>", 3->"\<\"Integral Transforms\"\>", 
       4->"\<\"Numerical Data\"\>", 
       5->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fourier", "ObjectName",
 CellID->15668],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Fourier",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Fourier"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the discrete Fourier transform of a list of \
complex numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The discrete Fourier transform ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 " of a list ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     StyleBox["n", "TI"]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["r", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->True], 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["r", "TI"]], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{"2", "\[Pi]", 
     StyleBox["i", "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["r", "TI"], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
     StyleBox["n", "TI"]}]]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->48089863,
  ButtonNote->"48089863"]
}], "Notes",
 CellID->28926],

Cell["\<\
Note that the zero frequency term appears at position 1 in the resulting \
list. \
\>", "Notes",
 CellID->30702],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->807],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14605],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the discrete Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     StyleBox["n", "TI"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        StyleBox["a", "TI"]}], ")"}], "/", "2"}]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["r", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->True], 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["r", "TI"]], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{"2", "\[Pi]", 
     StyleBox["i", "TI"], 
     StyleBox["b", "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["r", "TI"], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
     StyleBox["n", "TI"]}]]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->10648],

Cell[TextData[{
 "Some common choices for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 " (default), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 " (data analysis), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " (signal processing). "
}], "Notes",
 CellID->5747],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " effectively corresponds to conjugating both input and output lists. "
}], "Notes",
 CellID->29914],

Cell[TextData[{
 "To ensure a unique inverse discrete Fourier transform, ",
 Cell[BoxData[
  RowBox[{"\[VerticalSeparator]", 
   StyleBox["b", "TI"], "\[VerticalSeparator]"}]], "InlineFormula"],
 " must be relatively prime to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->522842977,
  ButtonNote->"522842977"]
}], "Notes",
 CellID->2415],

Cell[TextData[{
 "The list of data supplied to ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " need not have a length equal to a power of two. "
}], "Notes",
 CellID->8264],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " given in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " can be nested to represent an array of data in any number of dimensions. "
}], "Notes",
 CellID->29223],

Cell["The array of data must be rectangular. ", "Notes",
 CellID->15547],

Cell[TextData[{
 "If the elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are exact numbers, ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " begins by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to them. "
}], "Notes",
 CellID->21017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->20893]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146301636],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->127347545],

Cell["Find a discrete Fourier transform:", "ExampleText",
 CellID->25865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "0", ",", 
    "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.82842712474619`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"1.2071067811865475`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.20710678118654746`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.20710678118654746`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    RowBox[{"1.2071067811865475`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{392, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84581493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18867],

Cell["Find a power spectrum:", "ExampleText",
 CellID->20220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "2", ",", "2", ",", "1", ",", "1", ",", "0", ",", 
      "0"}], "}"}], "]"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.999999999999998`", ",", "1.7071067811865477`", ",", "0.`", ",", 
   "0.29289321881345237`", ",", "0.`", ",", "0.29289321881345237`", ",", 
   "0.`", ",", "1.7071067811865477`"}], "}"}]], "Output",
 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97184409]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " always gives approximate numerical results:"
}], "ExampleText",
 CellID->10227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.2247448713915892`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.2247448713915892`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{398, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112298165]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " to remove negligible imaginary parts:"
}], "ExampleText",
 CellID->2297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2247448713915892`", ",", "0", ",", "0", ",", "1.2247448713915892`", ",", 
   "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192649737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60651336],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a list of real values:"
}], "ExampleText",
 CellID->413253560],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1"}],
     "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87945966],

Cell["Compute the Fourier transform with machine arithmetic:", "ExampleText",
 CellID->990656031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56592719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.1338934190276815`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2730872440409331`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.13151188545021084`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5295164598590715`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.6639926388028409`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.046674757881550046`"}], "+", 
    RowBox[{"0.2044954757469482`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.046674757881550046`"}], "-", 
    RowBox[{"0.2044954757469482`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5295164598590715`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6639926388028409`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2730872440409331`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.13151188545021084`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->388533646]
}, Open  ]],

Cell["Compute using 24-digit precision arithmetic:", "ExampleText",
 CellID->229684788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"N", "[", 
   RowBox[{"x", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110326053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.13389341902768168164354960870254018244`23.69897000433602", ",", 
   RowBox[{
   "0.27308724404093304366422360673911635658`23.149825741000562", "+", 
    RowBox[{
    "0.13151188545021087883095684649741495102`22.88355709465925", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.5295164598590715185375485108079787717`23.390634674548764", "+", 
    RowBox[{
    "0.6639926388028408838980160125022749532`23.594149256550356", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.04667475788155010777273904507873500666`22.378516584021334"}], "-",
     
    RowBox[{
    "0.20449547574694823727102714100031009578`23.054218625124435", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.04667475788155010777273904507873500666`22.378516584021334"}], "+",
     
    RowBox[{
    "0.20449547574694823727102714100031009578`23.054218625124435", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.5295164598590715185375485108079787717`23.390634674548764", "-", 
    RowBox[{
    "0.6639926388028408838980160125022749532`23.594149256550356", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.27308724404093304366422360673911635658`23.149825741000562", "-", 
    RowBox[{
    "0.13151188545021087883095684649741495102`22.88355709465925", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{578, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100191187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200448062],

Cell["Compute a 2D Fourier transform:", "ExampleText",
 CellID->144411824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311628150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.9124057422070315`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.0499349547886956`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.30346587963296695`"}], "+", 
      RowBox[{"0.2607402910133476`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.3597316156675715`"}], "+", 
      RowBox[{"0.12701515204806438`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.31909024034766625`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.03939878211859152`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.48182917648364587`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.22207735677044044`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.3124375928276258`"}], "+", 
      RowBox[{"0.20051319946456897`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.7647778610624135`"}], "+", 
      RowBox[{"0.10566155554556368`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.16566770135256692`"}], "+", 
      RowBox[{"0.23504909292362394`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.009215690505350895`"}], "+", 
      RowBox[{"0.17702606243108684`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.3163595174231944`"}], "+", 
      RowBox[{"0.24656749802650815`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.15142379997922154`"}], "-", 
      RowBox[{"0.04248482710159523`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.31406238993026353`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.09761505013710096`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.5708824981885311`"}], "-", 
      RowBox[{"0.48274318389657805`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.049118802258749546`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.44184535593530055`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.26082657631406186`"}], "-", 
      RowBox[{"0.1886607409053032`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.07689007836361447`"}], "-", 
      RowBox[{"0.31976869510260014`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.015675878100629387`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.3531390899003995`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.601680679502991`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.05566380374822101`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{492, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229778278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100783856],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a rank 3 tensor with nonzero diagonal:"
}], "ExampleText",
 CellID->33600865],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"x", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"x", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2", ",", "2"}], "]"}], "]"}], "=", "1"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142022986],

Cell["Compute the 3D Fourier transform:", "ExampleText",
 CellID->29067393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151685488],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{486, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67294175]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13083],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18508],

Cell[TextData[{
 "No normalization:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->10648,
  ButtonNote->"10648"]
}], "ExampleText",
 CellID->185963725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Fourier", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
      "0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"FourierParameters", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320765889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.1180339887498947`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.36327126400268045`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.1180339887498947`"}], "-", 
    RowBox[{"1.5388417685876266`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.1180339887498947`"}], "+", 
    RowBox[{"1.5388417685876266`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.1180339887498947`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.36327126400268045`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{567, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216370944]
}, Open  ]],

Cell[TextData[{
 "Normalization by ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SqrtBox["n"]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->741719999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
    ",", "0", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164749528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.2649110640673518`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.35355339059327373`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.11487646027368059`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.47434164902525683`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11487646027368058`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "-", 
    RowBox[{"0.48662449473386504`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4743416490252569`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4743416490252569`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "+", 
    RowBox[{"0.48662449473386504`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.47434164902525683`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.11487646027368058`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.35355339059327373`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11487646027368059`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{518, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1151595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", 
  RowBox[{"Sqrt", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->215750475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.118033988749895`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.36327126400268045`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.118033988749895`"}], "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.118033988749895`"}], "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.118033988749895`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.36327126400268045`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{567, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->540113628]
}, Open  ]],

Cell[TextData[{
 "Normalization by ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "n"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1380829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->448291357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.4`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.11180339887498947`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.03632712640026805`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.03632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.11180339887498947`"}], "-", 
    RowBox[{"0.15388417685876266`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15000000000000002`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15000000000000002`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.11180339887498947`"}], "+", 
    RowBox[{"0.15388417685876266`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.03632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.11180339887498947`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.03632712640026805`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{462, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->373051972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43068943],

Cell[TextData[{
 "Data from a ",
 Cell[BoxData[
  ButtonBox["Sinc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sinc"]], "InlineFormula"],
 " function with noise: "
}], "ExampleText",
 CellID->209804439],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sinc", "[", 
       RowBox[{"x", "-", "10"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "n"}], "}"}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".05"}], ",", ".05"}], "}"}], ",", 
      RowBox[{"{", "n", "}"}]}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->218852198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20447913],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw1kw0w1HkYx/dIh95wjua6UV7bVujFy1pdviiKNrtrLbmTl+pub25SXFOI
ayV1uFtKL3IUlrXOIlGOxu5iprzklLqKjY677oacM1xMhuu62cd/Zuc/n/3u
53l+v2d/P+vYI4JDegwG4+C7z/9v3TPpvdLFKlIxWeNNX+DB2BnfiDPtxIZ4
6urfOvyoltgE8vaslbJfrqh1bA5RhI1TrPge8WpkXxs7KyxuI/4YBgyDuIHA
W+SvQ7SnItdyepDYBlO5/De9H4wR20HbaO/i4vg3sQOWbJNkzMpfETMh61E9
7Ml4QcxCg/bUA6v9i/U3YmZp5dvVGzqpvzPaB1awtZV3iTehxSNwuYugkngz
YgZP5ynmFeRvQflY2o1jSfXEW8HOVjc6TyQSu8JxTvvX3JVb5Lth2VHG7dSx
n4jdwREPF5QPNxB7oKy1S1zhWE0+G5sE1U+XDtQRe+JiqXzjaL6UmAM8zllv
ZhtAvhc4Am688GU98Ta8frKWc9Awl/gTDJXFdRu3lZK/HTH/xDOYyhJib4yr
rRcmRoqJgecOuc45a/J0LAHcvbaw1v4rp3o+MDbh977yKtWxxAfSgA9Vs5U/
Uu6LJeqkjqeP08n3xWfiN36uJyqpvh8sCvnHK8oKKfdDjOn16rvu6eTvgCbV
0jLUjuYv2YGm/jWSJrt88nei+4uROwqWkvydSJywfeiT/C3l/hCXZ0YHLlyn
3B925yfV4oUkygPgObFTfy4xn+oHIFcf0axmIeW7cG12yr7GtIjyXVDp9bkb
pVdRvhvMwoheSGlekt0YHp3fl8K4QHkgBEnH3xqOKckPBPcUqy5uMIP2F4Tx
GT3BKwsZ+UFoK3hUfCjqIvl7oB+V68Fi0/2R7METWd905376PxhcQKXaennZ
AfK5UDZ+vX2zUxbV34voOhHv5KrF+e7F0LqZxyXPF/cfDIa+XZ+ggeYlCUbh
s4j63w7IyOdhypvzK7O/SJeDh5WPZKYmqxJoPTyoTTYHGim/1+UaHk5cWDGe
51pCPh+TLd1O7A4e+XwEXV3/sqhj8bzwIUw2/maD7SUda/hI7JQebrL6jnwB
boxfTQip+UHHEMB5+nVerel5Wq8Arq/dhqKPllH/d7+/2+1oM3GE/BDcvNk7
2mUrp/4h+JIZc6zqLJ1PSQj6IpVarqqA+oeg/46RZyxn8X4LYRnRnp+3hdYL
IZq6Gk7OpWZRfyGaz9VIX7TQedYIYZiR41+VSTkjFLf3Dcy/l5BDfigUzT+n
FXx+mPqHovqP5eBZXKT+oRC4/87WU1wiX4T7wc/i01ovkC+CtUObmHl/cf8i
MCe7I1seVpAvAo8x/9VHZnSeGGHQbDTvEd0LJj8Mytr6DKeUROofBgttikEp
l/anCcP7l3mRznanaX7hcNH0jw+uqyE/HLxPe+y1rCjywyEv4ej5JiSTHw6z
P91qT7RIyd8HffORlOzMEu//ADvn4/w=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17827375]
}, Open  ]],

Cell["Ordinary spectrum without normalization:", "ExampleText",
 CellID->327738748],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"Fourier", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FourierParameters", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112561964],

Cell["Partial spectrum:", "ExampleText",
 CellID->488876028],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Fourier", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"x", ",", "20"}], "]"}], ",", 
     RowBox[{"FourierParameters", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"20", "/", "n"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->586775117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "s", "]"}], "^", "2"}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", "p", "]"}], "^", "2"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->162880751],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlXlIk3EYx70iLSrFpZW1dNpyatNMzSv36DzmtUt3BB02szKoBYM0ul7R
GB50KFipZRokHZIa1rLDV9EUExcoWVkSFhZYQ//StOjA5w1+v8HL+Lwf3r2/
3/N7nu98DEZ1noOdnd3+v9e/78XPtGS8/MmpOd0mwBswe1NoGu7wRXaGSheX
5okwzruCRWYfU1+9GZkHYznx9yqOC5HXQIbTkfnoMQHyeqiXB38dd+a8N3yY
OhHwbDfnBdAtbunvGeHYDxTFw+Z8Fz9kIZy0Gao8Rdzz/lAhrNI6eHHvDwDr
N1v0U4EPchBMmXgt8d58ZDFs+TVh5CduRA6BJUOmsh6+J/JWsKpKIl45OCGH
Qntw/vcvvy2SRd4Gy0enmyb8upDD4L7MaO8X0oYcDp8WVoWaq6uQI2DOIrYy
ggfI28HsW++TdLQFORKGamOcyho4joJwfuSMa+QQcjTYeAPOQQWXkGNguKs1
9p3xBnIs7NOVN6943Yq8A+78cG9b9v4achw0lncWVXvdRpaAQOReXJh3BRng
57HJCzOmykVmABZGA7sdH71AHw+9hiieofc8+njYMPnx6vUibj8JIJ/vOVQg
PYs+AaxlTbdKbVw9pJA4eLdPmlaKXgoen3vjhIYR9IngdnhQJEq4jD4RdOa9
taVnOtEngUfs6pHq5yXok0BcucsizalBnwxB/rn2gQmN6JPBc+2bBn4dgz4F
HPccCHGLakefAs6mjtOitw3oZVC8sm62sGYYvQweKyTymYPc+abCuYcDrHUp
t/5UmLrY3/dyXS76NMqnUc+nU7+fTr0/g1pfBrX+TGp/mdT+5VR95FT9FFR9
FVT9leT5gJI8P0ZJni+rpM5fRfYHqMj+YVRkf7Eqqv/UZH+CmuxfRk32N6um
+j+LnA/IIueHySLni82i5i+bnE/IJueXySbnm82m5l9D5gNoyPxgNGS+sBoq
f7RkPoGWzC9GS+Ybq6XyT0fmI+jI/GR0ZL6yOip/9WQ+g57Mb0ZP5jurp/J/
5///hz9wr7Q6
      "]]}, {}}, {{}, 
    {RGBColor[1, 0, 0], 
     PointBox[{{1., 11.06992649624631}, {2., 10.999008765705883`}, {3., 
      10.789219053225969`}, {4., 10.466726597192503`}, {5., 
      10.107900437776934`}, {6., 9.831835938914375}, {7., 
      9.748572103488971}, {8., 9.89920960793821}, {9., 10.228126942796747`}, {
      10., 10.590881472611924`}, {11., 10.776221216868231`}, {12., 
      10.538877800955289`}, {13., 9.668013713232076}, {14., 
      8.097790885534247}, {15., 6.002576418572434}, {16., 
      3.783230660336803}, {17., 1.907554811984807}, {18., 
      0.6866926617567538}, {19., 0.13927423807890593`}, {20., 
      0.03783517776712286}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 100.}, {0., 11.794183582216974`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->261897263]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25736],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Computing Spectra",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->355405434],

Cell["\<\
Fourier spectrum of \[OpenCurlyDoubleQuote]white \
noise\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->28418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", "200"}], "]"}], "]"}], "]"}], "^", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28228],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1.9931560809985742`, 0.37905836410380156`}, {2., 
     0.02777313585783062}, {3., 0.1041165742610571}, {4., 
     0.13626677106548388`}, {5., 0.023848632579075185`}, {6., 
     0.07911864255370209}, {7., 0.08667480510035855}, {8., 
     0.02718326793062414}, {9., 0.22864566128562647`}, {10., 
     0.1086544766613215}, {11., 0.030347125860198568`}, {12., 
     0.016498098532632573`}, {13., 0.21347263811689546`}, {14., 
     0.001584318747610079}, {15., 0.05944286010668199}, {16., 
     0.09583476462385426}, {17., 0.04697729212775592}, {18., 
     0.03902262893966999}, {19., 0.2889115785346111}, {20., 
     0.19144330677459612`}, {21., 0.007502094964113615}, {22., 
     0.040395113901864434`}, {23., 0.09488892875886326}, {24., 
     0.03596649571836541}, {25., 0.10052438368952148`}, {26., 
     0.14377013821401727`}, {27., 0.002716227299634691}, {28., 
     0.11722735701365021`}, {29., 0.010632042273930059`}, {30., 
     0.012416212100263958`}, {31., 0.0727649947873635}, {32., 
     0.07715268883629241}, {33., 0.03536526227166284}, {34., 
     0.19411287007505987`}, {34.929682497340615`, 0.37905836410380156`}}], 
    LineBox[{{35.037534009938184`, 0.37905836410380156`}, {36., 
     0.020357051689668927`}, {37., 0.09655641219220783}, {38., 
     0.017352468719634254`}, {39., 0.0017386874447712299`}, {40., 
     0.04001778451235391}, {41., 0.03032543564326214}, {42., 
     0.02903148396239392}, {43., 0.027508241686237465`}, {44., 
     0.006650964321872682}, {44.773847497145645`, 0.37905836410380156`}}], 
    LineBox[{{45.32227299638926, 0.37905836410380156`}, {46., 
     0.15018503263115748`}, {47., 0.13262484793210016`}, {48., 
     0.10650195303580826`}, {49., 0.05356991221136391}, {50., 
     0.313854611605048}, {51., 0.05218988254668974}, {52., 
     0.16152220476110016`}, {53., 0.1555519712204429}, {54., 
     0.0007304690612010287}, {55., 0.000018970588196004628`}, {56., 
     0.011281959640381133`}, {57., 0.015856688712363485`}, {58., 
     0.09431116251046943}, {59., 0.14776828183638507`}, {60., 
     0.07863404665761092}, {61., 0.0116519180255149}, {62., 
     0.02460006024426737}, {63., 0.02053474766352451}, {64., 
     0.0885181915205296}, {65., 0.046606174534504545`}, {66., 
     0.026867166339496505`}, {67., 0.12046278194237568`}, {68., 
     0.013269277888839805`}, {69., 0.024743709013980444`}, {70., 
     0.04887458243868472}, {71., 0.009324964076227873}, {72., 
     0.030599705056629487`}, {73., 0.2616864380073403}, {74., 
     0.0482078632776312}, {75., 0.13197135157167128`}, {76., 
     0.27045883025946943`}, {77., 0.07514519044216873}, {78., 
     0.08657328398430182}, {79., 0.15013286114477184`}, {80., 
     0.056076226161982996`}, {81., 0.18918912567870144`}, {82., 
     0.19346877237183732`}, {83., 0.0448389134272007}, {84., 
     0.04102965628033721}, {85., 0.047328087715508296`}, {86., 
     0.10831223940560859`}, {87., 0.254536544852057}, {88., 
     0.01359237281130783}, {88.75149114810445, 0.37905836410380156`}}], 
    LineBox[{{89.2751163893367, 0.37905836410380156`}, {90., 
     0.060626308289737633`}, {91., 0.019068376980983005`}, {92., 
     0.0915118146662592}, {93., 0.0579974237156961}, {94., 
     0.15631695313895969`}, {95., 0.06547936833811105}, {96., 
     0.02517261862827775}, {97., 0.18146549397239634`}, {98., 
     0.22997930322520893`}, {99., 0.1883642359280311}, {100., 
     0.006736622186679114}, {101., 0.01382461252810023}, {102., 
     0.006736622186679114}, {103., 0.1883642359280311}, {104., 
     0.22997930322520893`}, {105., 0.18146549397239634`}, {106., 
     0.02517261862827775}, {107., 0.06547936833811105}, {108., 
     0.15631695313895969`}, {109., 0.0579974237156961}, {110., 
     0.0915118146662592}, {111., 0.019068376980983005`}, {112., 
     0.060626308289737633`}, {112.7248836106633, 0.37905836410380156`}}], 
    LineBox[{{113.24850885189555`, 0.37905836410380156`}, {114., 
     0.01359237281130783}, {115., 0.254536544852057}, {116., 
     0.10831223940560859`}, {117., 0.047328087715508296`}, {118., 
     0.04102965628033721}, {119., 0.0448389134272007}, {120., 
     0.19346877237183732`}, {121., 0.18918912567870144`}, {122., 
     0.056076226161982996`}, {123., 0.15013286114477184`}, {124., 
     0.08657328398430182}, {125., 0.07514519044216873}, {126., 
     0.27045883025946943`}, {127., 0.13197135157167128`}, {128., 
     0.0482078632776312}, {129., 0.2616864380073403}, {130., 
     0.030599705056629487`}, {131., 0.009324964076227873}, {132., 
     0.04887458243868472}, {133., 0.024743709013980444`}, {134., 
     0.013269277888839805`}, {135., 0.12046278194237568`}, {136., 
     0.026867166339496505`}, {137., 0.046606174534504545`}, {138., 
     0.0885181915205296}, {139., 0.02053474766352451}, {140., 
     0.02460006024426737}, {141., 0.0116519180255149}, {142., 
     0.07863404665761092}, {143., 0.14776828183638507`}, {144., 
     0.09431116251046943}, {145., 0.015856688712363485`}, {146., 
     0.011281959640381133`}, {147., 0.000018970588196004628`}, {148., 
     0.0007304690612010287}, {149., 0.1555519712204429}, {150., 
     0.16152220476110016`}, {151., 0.05218988254668974}, {152., 
     0.313854611605048}, {153., 0.05356991221136391}, {154., 
     0.10650195303580826`}, {155., 0.13262484793210016`}, {156., 
     0.15018503263115748`}, {156.67772700361076`, 0.37905836410380156`}}], 
    LineBox[{{157.22615250285435`, 0.37905836410380156`}, {158., 
     0.006650964321872682}, {159., 0.027508241686237465`}, {160., 
     0.02903148396239392}, {161., 0.03032543564326214}, {162., 
     0.04001778451235391}, {163., 0.0017386874447712299`}, {164., 
     0.017352468719634254`}, {165., 0.09655641219220783}, {166., 
     0.020357051689668927`}, {166.96246599006182`, 0.37905836410380156`}}], 
    LineBox[{{167.07031750265938`, 0.37905836410380156`}, {168., 
     0.19411287007505987`}, {169., 0.03536526227166284}, {170., 
     0.07715268883629241}, {171., 0.0727649947873635}, {172., 
     0.012416212100263958`}, {173., 0.010632042273930059`}, {174., 
     0.11722735701365021`}, {175., 0.002716227299634691}, {176., 
     0.14377013821401727`}, {177., 0.10052438368952148`}, {178., 
     0.03596649571836541}, {179., 0.09488892875886326}, {180., 
     0.040395113901864434`}, {181., 0.007502094964113615}, {182., 
     0.19144330677459612`}, {183., 0.2889115785346111}, {184., 
     0.03902262893966999}, {185., 0.04697729212775592}, {186., 
     0.09583476462385426}, {187., 0.05944286010668199}, {188., 
     0.001584318747610079}, {189., 0.21347263811689546`}, {190., 
     0.016498098532632573`}, {191., 0.030347125860198568`}, {192., 
     0.1086544766613215}, {193., 0.22864566128562647`}, {194., 
     0.02718326793062414}, {195., 0.08667480510035855}, {196., 
     0.07911864255370209}, {197., 0.023848632579075185`}, {198., 
     0.13626677106548388`}, {199., 0.1041165742610571}, {200., 
     0.02777313585783062}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 200.}, {0., 0.37905836410380156`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->245175859]
}, Open  ]],

Cell["\<\
Show the logarithmic spectrum, including the first (DC) component:\
\>", "ExampleText",
 CellID->26265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"10", ",", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Fourier", "[", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", "200"}], "]"}], "]"}], "]"}], "^", "2"}]}], "]"}], 
   ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28085],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdVwtQVGUUXkHSVBhwyDRUVkVl8JEmKoLIp6CAogILu7CwcPe92Dg4DWXm
64KGBmYFYTYorUSTKCniW0yvDYmKOpaY2JQuvniJ+EhQQKyG/3fmXGZ2mG/P
nv8/95zvnPPdUYb0WLOTQqE499/n//+9f49CTixz7D+0uTOEfQF72eVWx8m2
072wPy6O3qh0yXzGsDuC91wwhvZ5zrAnprg7OXyK6hkeijk7Gvx35b9keDhS
Xx0PvKJ8wrASdXnFczXN/LzRuFZdeX+N732GfbCyquwdXRnH43D3ia6pclEL
w764V5980NujiWE/FLT2dT21TyH14omoXzzpyitn/vvJUFZ3bSi9xeOZAq2y
Ijk9jMczFWfb17l0neH3vYfaQTOfPo/vYXgaPv3K5JtRxe/zR/bwksaG0McM
T8efT6e3X9c+ZHgGureNq3mw0YnFMxO3PMN6juU2MHsAVp0edXXpAJ6/Wdhb
0ey2+gS3B6JPz9vOuzs5DkJrfnplftFThmdDVW7PCijh/sEQ3AacKQ18wfAc
dKs6SiuP3GQ4BOO9/YrbhnYwDNTkPx72W4FLb3wi4JvlURm8gp83F8+v2ya6
er7qxeJcJHUWehtzeD7noaC+7lhJI8uXOA+bFCk/XpJ4fkLRrbtzYGd/Fq8Y
ihEvsk1emX1ZPsLgCI8/uEvJ4hXD8JlXv/iirTxf83Fu3njbgOR/mH0+vKsV
yyeV8fouwKqEIQlZobeZfQHe78zPm13M4lWEo+TU0G/OruH3h2O3z8wjG2M5
nyPQUVV9pHY/t0eg/+HATXnr+PmR8A0umihtucPskfA7cPPnnAlvMPtCDFnS
5lef0YflbyFqXPuN3+bK+bAI+yIXnD/wCcuHuAizikIuinXsPEUUTs7a4Brh
xvgvRqGrdtKVJnd+/mIM9DHGIKid2RfD49eol2f8eX2XQJhxemxmBuOvuATf
thiGl65g+VAsxfbL4S/1q9nziEuRc7RIM/IXXt9orM26W94Y09iLEY0f6gtD
Dr/OVzROHbRrAoYx/kvRyNy4vTjN+xHzj8F36/3S/AczjBiIN86VrJrAzhdj
YPAqnarOZf0gxaCw0xjuZuf1jcVHDerq2/n8/lj0BFUMrJjGzhNjUTO4zXlT
KotfikVF4RfhAfksHwoVvv505/Hrfs3MXwX/5Vs67rm0Mn8VGi6UD0oLYPWR
VBii8mj+KbKb+cehbIe74q09bB4gDpe6C3Q3oni+41BgKxcufvCAxR+Hhfop
6jGTOf/j0fbuymjNHnYf4vHhVOmQ8nfO13h0fK8eG/k3q4cUD22L6x/rx3B+
qKE45quq2sryCzXWXt2tqhvIsKjGGK+uz10aGD8kNUbUrh55OILfr8GyGkX3
Q7B+hgYz7mQ8vrad81GDSF9tR2gO45ukwbPskPTNEV3MPwF/nfdMLF3OnhcJ
aAqPcP/yTZ7/BOx1Kjirqb3H/BNgX58bNFLk/EvE0ZCj2c7tjC9IRMuh3Lz6
jx3MX2aXEmX+Wno+tLL7tTQ+SSuLP4k+H5Jkz59E8yMlyfKXTPOLZFn+k2l9
pGRZ/XS0vtDJ6q+j/JB0Mv6kUH4hRca/FMpPKUXG31TKb6TK+J9K+0NKlfWP
QPtLKdD+g0D7UxBo/4oC7W+7QPtfEuh8cAiy+aGn80Wpp/MHejqfBD2dX6Ke
zje7ns4/SU/no0Mvm58GOl+VBjp/YaDzWTDQ+S0a6Hy3G+j8lwx0PzgMsv1h
pPtFaaT7B0a6nwQj3V+ike43u5HuP8lI96PDKNufJrpflSa6f2Gi+1kw0f0t
muh+t5vo/pdMVB84TDL9YKb6Qmmm+gNmqk8EM9UvopnqG7uZ6h/JTPWRwyzT
Txaqr5QWqr9gofpMsFD9JlqovrNbqP6TLFQfOiwy/Wil+lJppfoTVqpPBSvV
r6KV6lu7lepfyUr1scMq0882qq+VNqq/YaP6XLBR/S7aqL6326j+l2z0/cBh
k70/pL1+v/gXw8ZEKA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{229, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->261677370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20656],

Cell["The spectrum of a \"pulse\" is completely flat:", "ExampleText",
 CellID->5374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"KroneckerDelta", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "200"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372958817],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWM1OwzAMzpq2cEZCbGOHCZ6BnwviBkKIh6gmpO2AQNtehQMSPy+xN9uJ
U0i6pMscN0mzjnXapCaxY7uu/dmJ9pRNh88v2XQ0yPr34+xtOBpM+nevY86i
LULIjD+TNuFrxlf5M2OMz+Z4wUfKBSifIz73JB1JWvG7kk/iXE3+1G6HzzGi
RXPhazEKZakaabRYCtskXtKrEphGG9DUIX8ihqTYR6QULcLXEnNDPG97vaFp
Xncs+7jPlxIxkeFbL8zbpUap5dMgLxWOCjN1xdewSw07uVyqc3wxcaVFQdU5
rFRV55Esc12+WyK/qHC9oxyDb/u0cI/4+E1UU4EyMaATB+2S37f9FI3qOaDP
Ku7jVpdZFqj4cshsTlMCkhT1o8krPMcKcYat1WrLZax1HGYF+gVpPyvw3cI3
QYZre/ng6D4WW1pmUrbaRZKasr853MB4heUsOPMJAVGvhOFDM2eLUcTdHzPq
LIB9pxZtBB1YzLeBEru3GFpwXNdaTY2wZcWOgVm6FnZsJ50dQ/pcFwIUot5v
bz4IfXz4mc9/848OtuTXh3Rk7SQq1usozaiXnT3JaMWYp2jGqkb7P62UYW/L
X7LTiNH3sXO5NFIHBYdpReavb4mrz80J2jD6KXPgxaG7T2ipdgeiGI+V34U2
kW3fG3Kuh5wFtrsxyCwL7qh2Tc87salp/s9LWn//5Rln\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395761785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30056],

Cell[TextData[{
 "Power spectrum of the Thue\[Dash]Morse nested sequence ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-586"], None}]
}], "ExampleText",
 CellID->29150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"Nest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "->", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], ",", 
           RowBox[{"0", "->", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}]}], "}"}]}], "]"}], "&"}], ",", 
      RowBox[{"{", "1", "}"}], ",", "7"}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15616],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1.7638647748289094`, 1.3358094763408688`}, {2., 
     0.00003524756976849528}, {3., 0.}, {4., 0.006433205176646855}, {5., 
     0.}, {6., 0.04308225565298442}, {7., 0.}, {8., 0.054855402513725775`}, {
     9., 0.}, {10., 0.10871660415568354`}, {11., 0.}, {12., 
     0.37157393753237733`}, {13., 0.}, {14., 0.36712630098124127`}, {15., 
     0.}, {16., 0.07182887779420569}, {17., 0.}, {18., 0.08923646472521159}, {
     19., 0.}, {20., 0.7095192537074225}, {21., 0.}, {22., 
     1.1456676624358453`}, {23., 0.}, {24., 0.5612729273199953}, {25., 0.}, {
     26., 0.5163576993472485}, {27., 0.}, {28., 0.8644356017999131}, {29., 
     0.}, {30., 0.3850705739014835}, {31., 0.}, {32., 
     0.020159222154224214`}, {33., 0.}, {34., 0.02117389318322796}, {35., 
     0.}, {36., 0.4464038090881965}, {37., 0.}, {38., 1.1076718572742223`}, {
     39., 0.}, {40., 0.7331716002522957}, {41., 0.}, {42., 
     0.8863468099624607}, {43., 0.}, {43.66051154810382, 
     1.3358094763408688`}}], 
    LineBox[{{44.33948845189618, 1.3358094763408688`}, {45., 0.}, {
     45.94766982272522, 1.3358094763408688`}}], 
    LineBox[{{46.05233017727478, 1.3358094763408688`}, {47., 0.}, {48., 
     0.20131423869402876`}, {49., 0.}, {50., 0.18620936363999915`}, {51., 
     0.}, {52., 1.1113071745115883`}, {53., 0.}, {53.99487135821537, 
     1.3358094763408688`}}], 
    LineBox[{{54.00512864178463, 1.3358094763408688`}, {55., 0.}, {56., 
     0.4841370234568709}, {57., 0.}, {58., 0.31613947443455287`}, {59., 0.}, {
     60., 0.34930170077364636`}, {61., 0.}, {62., 0.08721283474799088}, {63., 
     0.}, {64., 0.0014358268098346725`}, {65., 0.}, {66., 
     0.0014358268098346725`}, {67., 0.}, {68., 0.08721283474799088}, {69., 
     0.}, {70., 0.34930170077364636`}, {71., 0.}, {72., 
     0.31613947443455287`}, {73., 0.}, {74., 0.4841370234568709}, {75., 0.}, {
     75.99487135821536, 1.3358094763408688`}}], 
    LineBox[{{76.00512864178464, 1.3358094763408688`}, {77., 0.}, {78., 
     1.1113071745115883`}, {79., 0.}, {80., 0.18620936363999915`}, {81., 
     0.}, {82., 0.20131423869402876`}, {83., 0.}, {83.94766982272522, 
     1.3358094763408688`}}], 
    LineBox[{{84.05233017727478, 1.3358094763408688`}, {85., 0.}, {
     85.66051154810383, 1.3358094763408688`}}], 
    LineBox[{{86.33948845189617, 1.3358094763408688`}, {87., 0.}, {88., 
     0.8863468099624607}, {89., 0.}, {90., 0.7331716002522957}, {91., 0.}, {
     92., 1.1076718572742223`}, {93., 0.}, {94., 0.4464038090881965}, {95., 
     0.}, {96., 0.02117389318322796}, {97., 0.}, {98., 
     0.020159222154224214`}, {99., 0.}, {100., 0.3850705739014835}, {101., 
     0.}, {102., 0.8644356017999131}, {103., 0.}, {104., 
     0.5163576993472485}, {105., 0.}, {106., 0.5612729273199953}, {107., 
     0.}, {108., 1.1456676624358453`}, {109., 0.}, {110., 
     0.7095192537074225}, {111., 0.}, {112., 0.08923646472521159}, {113., 
     0.}, {114., 0.07182887779420569}, {115., 0.}, {116., 
     0.36712630098124127`}, {117., 0.}, {118., 0.37157393753237733`}, {119., 
     0.}, {120., 0.10871660415568354`}, {121., 0.}, {122., 
     0.054855402513725775`}, {123., 0.}, {124., 0.04308225565298442}, {125., 
     0.}, {126., 0.006433205176646855}, {127., 0.}, {128., 
     0.00003524756976849528}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 128.}, {0., 1.3358094763408688`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8272920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28680],

Cell[TextData[{
 "Power spectrum of the Fibonacci nested sequence ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-586"], None}]
}], "ExampleText",
 CellID->14413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"#", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "->", 
             RowBox[{"{", "0", "}"}]}], ",", 
            RowBox[{"0", "->", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}]}]}], "}"}]}], "]"}], "&"}], ",", 
       
       RowBox[{"{", "0", "}"}], ",", "10"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3072],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlg9MlGUcx29UBsEKg1EzzZPM0jnIP4CnZ3xFQDj+eNxxfznee9+brEbZ
3RqDoKLXXA5nc9oyhhlCOHOEpcSfENQ3QYdoE2MRczJPTbIWUtEfomn/7kfr
97zb7fa57z3P+/x+z+/5/p4FPr+lJEyn0+36+/PPd+j5IdX27/Mg6AfknkuI
feQXb2oIwxFxeLSyN6KcOBpD20x3HzNuJ46Fcd4TmcHLrxI/jB/HYvYH6hqI
56JvyGBYFvsmsR4TzffOsks7ieMRen878UIM6nfuyf99F/EiJA/FGX5NbCR+
EvLVwPyaRTO8BL2zF1cHRt8hXoqJ22WlI6XniBPgnuqaHBjfR/wU9oyef3tk
7fvEy2Bl71+O4ZjSq+UT9cQrYGH6SpwuTSj54uwHxEmo6Hm303KjiTgZ1ZNr
9tWEXyNOwSavdizr0AHiVfjwZNzqE5uOEBtgZ/OvRuSB5Pa5JQeJ16BpRPJ1
Vw0QG/Hsb/uvm15vIV6L/D/VxPjgYeKnYZ+TUm/aPvP/VOwYXNzVsryZGNjs
i/FPn+oOsQohvnU4vsL/kL+d5lPXoaz22jMtB38mPQ33uU5lhj1K61fThP1b
j5Hbzom2Bb2kr8drl3dfb3vlY9LT4U/ZFj31Uz/p6UL8GehOQ13sdCvpGfg+
8kivNSlIeiai8+IfX9lxlPRM1GwZa6ytOEH6BgxnPLa1fPwk6RuQaA4MXtlM
8+my0HnPquHpqVHSs4T1Z2Ps60Nnqv/oJD0bSSWXTl8sv0C6CUr9vMrGpZ+Q
bsIbL8y+c+vKGdJzcL5x6oGLxh7Sc4T4cnFTiiqrfDkKIT1XqL88+A2zzipN
FI+ahy+dam1k+Mz8+Wj9qmKHureN9HwY+l7Mq/5miPSNeOl4XW1EaxfpG2EY
6AibPPop6WaMR9y19c6FSyGGGY7/v181o/9GMDFg6QuxZob+Iynb6P2Mxhfg
rfn35/THddD4Amypan7uu6pbNL4AgffmfJveQ/nTChDlic/23aR86CwYXAKL
9PznNN7C868KumYRxlv5/LAK77fy9WlWYf2FPD4UCvEX8vxohUL+bDy/sPH8
qza+P5pN2D8731/Y+f6rdl4fml2oHwevLzh4/akOXp+aQ6hfJ69vOIX8O/n5
0JzC+XHx8wUXP3+qi59PzSWcXzc/33Dz+FQ39wfNLfhHEfcXFAnrL+L+pBUJ
/uXh/gYP9z/Vw/1R8wj+Wcz9FcXcf9Vi7s9aseDfEvd3SEL8Eu8PmiT0Dy/v
L/Dy/qN6eX/SvIK/y7y/6WVef5B5f5Rl3j9VmffXBpn3X03m/TkoC/1b4f1d
r/D9g8LvB7LC7w+qwu8XDQq/f2gKv58EFeH+4vvvfvMXYw+cWw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{229, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70391167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28248],

Cell["2D power spectrum of a nested pattern:", "ExampleText",
 CellID->13767],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"i", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "63"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "63"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5015],

Cell["Plot the nested pattern:", "ExampleText",
 CellID->9918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19635],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJylldEJAzEMQ+1u0k06Q0foAt3/r7R3JRebSJF9IQgjLg9jhO+v9/N1M7PH
edufN49573rzflvo6O+Vhh5SV2/qf4zV+jzl2kYvpfrSS6m262uFenqtUM+l
XnuzjnFW/XBkP+RZ9sOV/ZBn2Q95lv2QZ9kPKvuLuW77i7lu+4u5bvu+7m3L
B71t+fD1DR/b3Mc298lHfk/5ZnnPfHw5H1/Ox/ud8w0q52PlfKycj/c75+P9
zvl4v3M+3u+cj/c75+P9zvm45nxcc76W98zX8p75Wt4zX8t75mt5z3wt75k/
q86fVefX5j74tbkPfr33g1/v/eB36PW5D37r9ybd/QNaOg9Q
   "], {{0, 0}, {64, 64}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->286721415]
}, Open  ]],

Cell["Find the logarithmic power spectrum:", "ExampleText",
 CellID->1055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", "data", "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19083],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{131, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{131., Automatic}},
 CellLabel->"Out[3]=",
 CellID->33345434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24339],

Cell["\<\
Find the Fourier transform of the rule 30 cellular automaton pattern:\
\>", "ExampleText",
 CellID->16411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27772],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1lVFSwzAMRCVuwhm4CUdghm/u/0eLrd2VsWM3iUPJtImj9dNKyvvXz+fX
m5l9PP6/7Xm4Pz7PU/3+OD//vP76u1dXxMVyo1zFfSsRLBaXBYxZbnpdEI8b
49TdaKi4+vcLUjVK2WeNkjaHBVgXcTxwPQHWy+YiFYtlg7I5wwKsi1wiB1ge
YQ3wErMBTZsb+IIoVHGgCTyhkQpNAFm6voSd4gDRAE9opCInYOKLR0KQO0FD
4VnwMxU5ARNfkH4XeT5pjImNwtJWZdovJvLMHsPDisi8t8dKv6h8fCS8bJQ3
+ixH/aLykT0JHxXiodRVmfQL86XZU9vdRXakMukXXmb2JDxaZsQx9cU1X6bM
6I3I85hj6oucPDNHAbLYDjTm/ZKnFtqSbdjtjxHLqF8wPGBxJeMUnnAoy6Bf
MDyMsODwyPSKykG/eAyP+IKxiOcXNGb94t58Mczlw/4YsfR8MUkSTAq2JT9a
lo4voiylxIJb1jjyRZWl/Vhwr6n0fUnKrLD++2OVpfUlKTsrbK0/RiytLwzK
CgPfGZWOLzJNWGpl/QmNkS8yTZDFV/pjxKK+mEri9XWWQ1nUF5kmGO/nOZRF
fUHHsNMvcCiLjlyO/MC4ptHzhSO/il/kUBadJhr8OgdCuvqSg9+h8d+X6MfX
3h8LKsmX6JNr/dFRSb6A6zaOqqK+ROZu5Kgq6ks4c6tG68vZ98eCSop+P0dV
SdF3aCRfNvghKuHLJo6qgjG/79Axv1Vlox+ispmjqOzXOMXxC/ECEP0=
   "], {{0, 0}, {101, 51}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->133200402]
}, Open  ]],

Cell["Logarithmic power spectrum:", "ExampleText",
 CellID->17784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", 
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
     "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32109],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->63370055]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filtering Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->498910946],

Cell["\<\
Compute discrete cyclic convolutions to smooth a discontinuous function with \
a Gaussian:\
\>", "ExampleText",
 CellID->118182371],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "100"}], ";", 
  RowBox[{"dx", "=", 
   RowBox[{"1.", "/", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"UnitStep", "[", 
      RowBox[{"x", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", "dx"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[LessEqual]", 
        RowBox[{"1", "/", "2"}]}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "100"}], 
         RowBox[{"x", "^", "2"}]}], "]"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "100"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "x"}], ")"}], "^", "2"}]}], "]"}]}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", "dx"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"b", "/", 
    RowBox[{"Total", "[", "b", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->6694767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"b", ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310724071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109348060]
}, Open  ]],

Cell["Compute the cyclic convolution:", "ExampleText",
 CellID->165424525],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", "=", " ", 
   RowBox[{
    RowBox[{"InverseFourier", "[", 
     RowBox[{
      RowBox[{"Fourier", "[", "a", "]"}], " ", 
      RowBox[{"Fourier", "[", "b", "]"}]}], "]"}], 
    RowBox[{"Sqrt", "[", "n", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->341491492],

Cell["Show the original and smoothed function:", "ExampleText",
 CellID->125172635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->242618114],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->40535304]
}, Open  ]],

Cell[TextData[{
 "The convolution is consistent with ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->111859113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"c", " ", "-", " ", 
    RowBox[{"ListConvolve", "[", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->170494011],

Cell[BoxData["3.3306690738754696`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->257719876]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frequency Identification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->155604882],

Cell["Here is some periodic data with some noise:", "ExampleText",
 CellID->298512716],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"per", " ", "=", " ", "12.34"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pdata", " ", "=", " ", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "\[Pi]", " ", 
        RowBox[{"x", "/", "per"}]}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "n"}], "}"}]}], "]"}], " ", "+", " ", 
    RowBox[{"RandomReal", "[", 
     RowBox[{".1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", "pdata", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->193912421],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40695489]
}, Open  ]],

Cell["Find the maximum mode in the spectrum:", "ExampleText",
 CellID->502322473],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", " ", "=", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", "pdata", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"pos", " ", "=", " ", 
  RowBox[{
   RowBox[{"Position", "[", 
    RowBox[{"f", ",", " ", 
     RowBox[{"Max", "[", "f", "]"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->166263675],

Cell[BoxData["82"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111144653]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", "f", "]"}], ",", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"pos", ",", " ", 
         RowBox[{"f", "[", 
          RowBox[{"[", "pos", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58846495],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiIgkGIPs/kAXG
W/7/B9LIpAqQZAFKMQFpJiDNDKVFQLIgif8wgC6LzIfRwjjEBYE0MxZbkGkG
BlUQyQqxE06C9TAwY+eDmIKoLiVChwCIYEPWQZw+fkr0Ee1CGB8UhYwgGiym
RrIv+aExy8AOdyvOcB2qoaJOhA4MO9HlCbidkrAB6WMiwZ6BCBNS3QhSz0yq
nwYofajQKd7AZRArnE9kyA9kyKj+x14S4y/3RZHChdhyH1d5jyj3MWslXjQf
LwGL8oBFS0u2ASXsbWcyzAYRzC5Oc6GqIAUdF5BczAAr9iB6Fi08C9Yzi4EN
RDBDOCAmC9AMATQxVgJ8HhLVU9s8PiABcjcTLnWxUctB3ubAGpZgUZaTJx65
OIEC0N11Tj1YpKRoK5ALRHExK7mw6cEwiRPMd3KYDdHHADEnPHQZhO/qPEcU
jz5gnHh7LejqOADVB3RRUsLq2JiV27fdwK5vCVwUlHaWEkwpS5ecB0r09hyG
qoWIAt0HFAU6DkUUaDtQFGg1XnOJsZuWosPFbtb/kDqEFassB5ooevmHWxWI
S4oZbFB/YXcHG5ooC1ZV7FAzsMsO/7gcqXZDIhwGYDUi9pQETn04a+z/ONMn
bfUhcgu93Qet+MEA1hbAHnIjNXUNf7shEQ4DMCV48g+SKDMaH0/qpIkunDnn
P8FSAKOXgF7LYOYQlv+k1DCQ1tX58Dyg3EXLAIYGMB/YFgI2yUBtIXxtslfc
okC5n0ysUF2QthyorYTQBXIJpH14Y8Ki2zK6lwrboaqBbaj8vM2gNhS+9hsD
IwAqi0FJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->427035251]
}, Open  ]],

Cell["\<\
Find a high-resolution spectrum between modes where the maximum was found:\
\>", "ExampleText",
 CellID->8345421],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fr", " ", "=", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"Fourier", "[", 
     RowBox[{
      RowBox[{"pdata", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"2", " ", "Pi", " ", "I", " ", 
         RowBox[{"(", 
          RowBox[{"pos", " ", "-", " ", "2"}], ")"}], " ", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", " ", 
             RowBox[{"n", " ", "-", " ", "1"}]}], "]"}], "]"}], "/", "n"}]}], 
        "]"}]}], ",", " ", 
      RowBox[{"FourierParameters", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"2", "/", "n"}]}], "}"}]}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"frpos", " ", "=", " ", 
  RowBox[{
   RowBox[{"Position", "[", 
    RowBox[{"fr", ",", " ", 
     RowBox[{"Max", "[", "fr", "]"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->12531618],

Cell[BoxData["519"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->454410773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", "fr", "]"}], ",", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"frpos", ",", " ", 
         RowBox[{"fr", "[", 
          RowBox[{"[", "frpos", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->170178971],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->620977582]
}, Open  ]],

Cell["Determine the period from the frequencies:", "ExampleText",
 CellID->386051367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"n", "/", 
   RowBox[{"(", 
    RowBox[{"pos", " ", "-", " ", "2", " ", "+", " ", 
     RowBox[{"2", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"frpos", " ", "-", " ", "1"}], ")"}], "/", "n"}]}]}], ")"}]}],
   "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->653459834],

Cell[BoxData["12.340194481465028`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->41187781]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Computing Eigenvectors",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->559026584],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a circulant differentiation matrix:"
}], "ExampleText",
 CellID->33982314],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"N", "[", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", " ", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1"}], ",", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "n"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->206815089],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3000", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3000, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8623122]
}, Open  ]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Omega]", " ", 
       RowBox[{"(", 
        RowBox[{"k", "-", "1"}], ")"}]}]], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Omega]", " ", "k"}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Omega]", " ", 
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}]}]]}], "\[LongEqual]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Omega]", " ", "k"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "\[Omega]"}]], "+", 
         SuperscriptBox["\[ExponentialE]", "\[Omega]"]}], ")"}], "-", "2"}], 
      ")"}]}]}], TraditionalForm]], "InlineMath"],
 " the eigenvalues of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " are:"
}], "ExampleText",
 CellID->2094598],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"Chop", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Omega]", " ", "=", " ", 
          RowBox[{"2.", " ", "Pi", " ", "I", " ", 
           RowBox[{"j", "/", "n"}]}]}], "}"}], ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"-", "\[Omega]"}]], "+", 
           SuperscriptBox["\[ExponentialE]", "\[Omega]"]}], ")"}], "-", 
         "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", 
        RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->376797245],

Cell[TextData[{
 "The eigenvectors are the columns of the DFT matrix, so Fourier diagonalizes \
",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->137802077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"m", " ", "-", 
    RowBox[{"Map", "[", 
     RowBox[{"Fourier", ",", " ", 
      RowBox[{"ConjugateTranspose", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"Fourier", ",", 
         RowBox[{"DiagonalMatrix", "[", "d", "]"}]}], "]"}], "]"}]}], "]"}]}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->619689550],

Cell[BoxData["9.071871688646662`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156315866]
}, Open  ]],

Cell[TextData[{
 "This allows very efficient computation of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatrixExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixExp"], "[", 
   RowBox[{
    StyleBox["m", "TI"], 
    StyleBox[" ", "TI"], 
    StyleBox[",", "TI"], " ", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " for a particular vector:"
}], "ExampleText",
 CellID->328121017],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"n", "/", "2"}], " ", "-", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"n", "/", "2"}], " ", "-", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->667660352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"Fourier", "[", 
     RowBox[{
      RowBox[{"Exp", "[", " ", "d", "]"}], " ", 
      RowBox[{"InverseFourier", "[", "r", "]"}]}], "]"}], " ", "-", " ", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{"m", ",", "r"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->5746973],

Cell[BoxData["9.664385318241405`*^-13"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->625059841]
}, Open  ]],

Cell[TextData[{
 "Show the approximate evolution of the heat equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "u"}], 
     RowBox[{"\[PartialD]", "t"}],
     MultilineFunction->None], "\[LongEqual]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], "u"}], 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["x", "2"]}],
     MultilineFunction->None]}], TraditionalForm]], "InlineMath"],
 " on the unit interval:"
}], "ExampleText",
 CellID->58791339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Range", "[", "n", "]"}], "/", "n"}], "]"}]}], ";", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Fourier", "[", 
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{"t", " ", "d", " ", 
             RowBox[{"n", "^", "2"}]}], "]"}], " ", 
           RowBox[{"InverseFourier", "[", "r", "]"}]}], "]"}]}], "}"}], "]"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0.05", ",", "0.01"}], "}"}]}], "]"}], ",",
     " ", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->354876339],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->608062330]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23282],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 " inverts ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.2247448713915892`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.2247448713915892`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.06493303673679`*^-17"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{398, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2156312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "0.`", ",", "1.0000000000000002`", ",", "0.`", ",", 
   "1.0000000000000002`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94801702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12650],

Cell["\<\
For real inputs, all elements after the first come in complex conjugate \
pairs:\
\>", "ExampleText",
 CellID->23911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.573214099741124`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.22474487139159`"}], "-", 
    RowBox[{"2.1213203435596433`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915892`"}], "-", 
    RowBox[{"0.707106781186548`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915892`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915892`"}], "+", 
    RowBox[{"0.707106781186548`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.22474487139159`"}], "+", 
    RowBox[{"2.1213203435596433`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536421810]
}, Open  ]],

Cell["The power spectrum is symmetric:", "ExampleText",
 CellID->23300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "73.50000000000001`", ",", "6.000000000000005`", ",", "2.000000000000001`", 
   ",", "1.5000000000000002`", ",", "2.000000000000001`", ",", 
   "6.000000000000005`"}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258029336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342853996],

Cell["\<\
Cyclic convolution corresponds to multiplication of Fourier transforms:\
\>", "ExampleText",
 CellID->287084426],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->819955511],

Cell[BoxData[
 RowBox[{
  RowBox[{"c1", "=", 
   RowBox[{
    RowBox[{"InverseFourier", "[", 
     RowBox[{
      RowBox[{"Fourier", "[", "a", "]"}], 
      RowBox[{"Fourier", "[", "b", "]"}]}], "]"}], 
    RowBox[{"Sqrt", "[", "1000", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->523473544],

Cell[BoxData[
 RowBox[{
  RowBox[{"c2", "=", 
   RowBox[{"ListConvolve", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3415809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"c1", "-", "c2"}], "//", "Norm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->150688254],

Cell[BoxData["3.771958124717912`*^-12"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->754271702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1017],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVs1SgzAQXkgC1Cp4sfYm72H1qCfvemQ6zrQHR6f2feybYlKCjcsGEpg6
HdvMQLJ/3252l4SnYr14fSvWy3mRP66Kj8Vy/pk/vK8kiwUAwRcAZFOQ61Ku
to8aG/kAcPVmNa+EZ0TPPOnbDjnbemWI+yJfoSTvLPNMz/fILiTRFFdAxVdW
sZyVmOu52nQ9YpKbIMzIwKgxY2j6jpHe6EhwhCNOgvT65tleeRA/tC4os/jC
vY/RhKdctHo3M6b4wtihm9XJh58P3stH0mqFe8h/H80uDqm4DfpMvqIaFqrB
CbTI4kHU/EacKYovJbXO/yEG3RsYIyO1xl5xRKgiQUmdXLjmIxLbfr7xTimO
Y0gW0yPEGtIxF73iok+Lrlto2zl8R2uLXxx7p7jonTppGNahdhKuK769OKLp
7nDTaj+daenkgG2uWm3oWrbbuNWMzu4Y1WD/lbvxyOTf6tJZzj10J1TOGze2
4jL9hYaw+59kmh8h+tKYTZxU86d7ll9b5FmHHHdg9VOqlhuHFQTfcLRSmw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{415, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363760646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
    "]"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.000000000000001`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`"}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46256211],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "s"], TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox["n"]], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"r", "=", "1"}], "n",
     LimitsPositioning->True], 
    SubscriptBox["u", "r"], 
    SuperscriptBox["e", 
     RowBox[{"2", "\[Pi]", "i", 
      RowBox[{"(", 
       RowBox[{"r", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}], "/", "n"}]]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->48089863],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}],
     "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"u", "/:", 
  RowBox[{"Subscript", "[", 
   RowBox[{"u", ",", "r_"}], "]"}], ":=", 
  RowBox[{"x", "[", 
   RowBox[{"[", "r", "]"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->272526693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       StyleBox["n", "TI"]]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{
        StyleBox["r", "TI"], "=", "1"}], 
       StyleBox["n", "TI"],
       LimitsPositioning->True], 
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["r", "TI"]], 
       SuperscriptBox[
        StyleBox["\[ExponentialE]", "TI"], 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["r", "TI"], "-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
          StyleBox["n", "TI"]}]}]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282552249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.583005244258361`", ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"2.746979603717467`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"1.054958132087371`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"0.3019377358048386`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"0.3019377358048386`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"1.054958132087371`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"2.746979603717467`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175265393]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"v", "-", 
   RowBox[{"Fourier", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230118472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->377138254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642067338],

Cell["Fourier is equivalent to matrix multiplication:", "ExampleText",
 CellID->85199546],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", "n_", "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     StyleBox["n", "TI"]]], " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     SuperscriptBox[
      StyleBox["\[ExponentialE]", "TI"], 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
        StyleBox["n", "TI"]}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107344537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["6"], 
   RowBox[{"m", "[", "6", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84057634],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWztT20AQFrYJE94YbGPzsBMSHPIgIc+CNo9JkfwHJpOZpMgkk1DQUaSg
pHTJT6B0SUlJSTpmaCgpKZU76Q7Jn++8e0IGZwIzWFrdd3e72tNpX/qwtv7l
87e19a+f1mrvfq79+PL106/a2+8/xaVsn+d5x+L/97Qnzn1xFvwf+744xn/7
5W92Z2fHD/68jPjpF9BBdayr42PL9YWg/+bmpuqfDUbNBaeHh4fNZlOehrNI
DkLUzRgtfr0loJ874he1FAcHB8hFo9FQo1BcjItjRhxLcH1SXS8omalxRhW+
DNeHWq6fnZ1tbGxE3Gb11ZBh7wYxizwdA8yUAZMHzCxj3BHAFA2YQcCEd21r
a0uIoFdSKFVmf39/gJg1A+3DQBcIPN6JOcf5zNLY8SjPdECL5S4Wfav0wQo8
OTkx6VTOmlMrD6XNqZXXSXe6/6iB+5xace1SRc9lnMvoGUYu47PKe/EQ6HnA
V6B9Eejz9R9uOxYu5FMmn5YqjP7Qb+dO4lDji0CXtS4U3WectRbQYhvZDP68
QfmTDbeV6F5E7RPQXifaC8T4eeDHzGVF6Tdclaenpy2jCVrhihbcBODqRHuB
mIfH9Z8UUbfEj1RuFrSMz+m8wuWY+CVHfImJm2RJdRt6Be25iPYCueMIfBe1
98Dnhe4xQyKKiaTJxWi5D3RqN+EfOeJRDmz/n6SQ60buklL70oapwSg5aH9A
tJeBLrC4+AiyrAL9PpFGnhCjIn6ONUuau9W/jZK6N9n++pgH+i5rVMq+RRsf
97EJAn8vFS607Y+Wtbbx0SJDrqj+06lwabLzkROTXV9m9EkyLm83oKSibPw8
gUebvuJ3liTt+Xg7s80nQNs/75ttfdRh3rF/Ml1V4V7cARrfWnUCX2JxoX0C
3NHv+O33ROLuEziehtAnQJt+nGhfuWD/IRaXNp8Abflxov1BSuPwuO6GT8C1
3fOO+GddHn+YLaWbPV9w7vHyEuYYY0nral0XHfGvujz+tZTmlet57T4F2kjY
/uKC/UcT6QLfGW+Idp53sUSMQs3Ce3P1qkdxdT6M9lWqvjmvoWmeFtEqmgIa
9+oVoDHKje3JuNCy4B6M3NQtOOTKhvuX79E1F1fNhbblC35k08vjU3UcAbrK
GrVX95/rqE2Iv5yojS0Dq6MxJb8zV1R/XjSfE7XhZFoxAoPPKyciwxl3PBWp
LppZxagLehZU1Oai800kugtUJhajMahDW3TG1j+ZrjAzuww02v23CTwv76d3
eszQLvvt9yRzvhPZcTwNhREoe1SlQrRTmVyq/w0HLu1RlCk/nQwudxwe12m+
p2QEXSqXGyVxxbtmdF3HH2BLGe9Fx0eqzj3cM73ucwyypMUnnYof1BzxrjlU
1/GvpTSvXM9rj6rME+1UJpnqfzORLvCdsUq08/JwGIVxnYX35upVj6J3fBhb
NWp3fBjXatR0fBhdLYrPn/ZNKj6vGtWWgdbVrsmylCZfBi1v9J5MfgnGGpJm
ttGKT8dDo6o+0Z6mfBGMLaed8cbIzFSiu6B9Gawe1RlG9FFQh1QGG6tdk+kK
/TqsSl0AfBXasSqVlwfXvgzWEqDtpeutUONYlcrTEPoyrlWpVAaaqkodceDS
XiU6C+1JM89jFhzOx+O6G75M2lWprplnblUqLyOGtlUaVanuGeYZEsGzrjpZ
7Z7hiU07t4pyYPv/JIWu3edWpVIZYKxK5UXJ3oMsmHt9nUgjWJWKo6KGeB5I
r1rqLqjt7W0GKvomLY5qNBrhBu+c3wh9t6Ojo93dXXka/+qk2WyqL8fQykCL
CvP2SGNc15zn39vbM3wnJARTvF0OF0IPLd9qUd/LdYeLSO8RFxmhjW7fA2kf
ZsT9DqRWskay4/7Xjdnj82VjXIQfi10eF9F8IRfa89QZ2PtwLAAdRHjU96Re
31+1jQNz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->157904768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"m", "[", "6", "]"}], ".", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32015240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.573214099741124`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915883`"}], "-", 
    RowBox[{"2.1213203435596433`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.224744871391588`"}], "-", 
    RowBox[{"0.7071067811865472`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915894`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.224744871391588`"}], "+", 
    RowBox[{"0.7071067811865472`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915883`"}], "+", 
    RowBox[{"2.1213203435596433`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->789999093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"v", "-", 
   RowBox[{"Fourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->117476890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->20906716]
}, Open  ]],

Cell[TextData[{
 "The conjugate transpose of the matrix is equivalent to ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->808910579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", 
     RowBox[{"m", "[", "6", "]"}], "]"}], ".", 
    RowBox[{"N", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     "]"}]}], "-", 
   RowBox[{"InverseFourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->234626556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->145133411]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22992],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is not relatively prime to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", the transform may not be invertible:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->522842977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Fourier", "[", 
       RowBox[{"#", ",", 
        RowBox[{"FourierParameters", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}], "&"}], ",", 
     RowBox[{"IdentityMatrix", "[", "8", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "m", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->187529183],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136171033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->653514822],

Cell["\<\
Lengths that are powers of 2 or factorizable into a product of small primes \
will be faster:\
\>", "ExampleText",
 CellID->292440529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Fourier", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{"2", "^", "20"}], "+", "1"}]}], "]"}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208915469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.156`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27673967]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"2", "^", "20"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354505294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"17", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61681", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32152768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Fourier", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"2", "^", "20"}]}], "]"}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->714233270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4380000000000009`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194856286]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Fourier", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       RowBox[{"2", "^", "20"}], "-", "1"}]}], "]"}], "]"}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->515235279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9209999999999994`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->696328877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"2", "^", "20"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->163856224],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->280879281]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18374],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDCT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDCT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDST",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDST"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30564],

Cell[TextData[ButtonBox["Manipulating Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingNumericalData"]], "Tutorials",
 CellID->12166],

Cell[TextData[ButtonBox["Discrete Fourier Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FourierTransforms"]], "Tutorials",
 CellID->1899]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->18640],

Cell[TextData[{
 ButtonBox["Demonstrations with Fourier",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Fourier"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#15565"], None}]], "RelatedLinks",
 CellID->2969],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Fourier"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3517994],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->266203057],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->318030140],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->214831135],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->60626102],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->811540217]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fourier - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 4.7044746}", "context" -> "System`", 
    "keywords" -> {
     "Cooley-Tukey transform", "data", "discrete Fourier transform", "FFT", 
      "Fourier transforms", "frequency spectrum", "image transform", 
      "power spectrum", "spectrum", "transform"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Fourier[list] finds the discrete Fourier transform of a list of complex \
numbers. ", "synonyms" -> {"DFT"}, "title" -> "Fourier", "type" -> "Symbol", 
    "uri" -> "ref/Fourier"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10508, 371, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146301636]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 153426, 4259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3119, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3742, 97, 45, 1, 70, "ObjectName",
 CellID->15668],
Cell[3790, 100, 512, 16, 70, "Usage",
 CellID->10932]
}, Open  ]],
Cell[CellGroupData[{
Cell[4339, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4817, 138, 1139, 45, 70, "Notes",
 CellID->28926],
Cell[5959, 185, 122, 4, 70, "Notes",
 CellID->30702],
Cell[6084, 191, 107, 3, 70, "Notes",
 CellID->807],
Cell[6194, 196, 259, 8, 70, "Notes",
 CellID->14605],
Cell[6456, 206, 1315, 49, 70, "Notes",
 CellID->10648],
Cell[7774, 257, 570, 23, 70, "Notes",
 CellID->5747],
Cell[8347, 282, 242, 8, 70, "Notes",
 CellID->29914],
Cell[8592, 292, 433, 14, 70, "Notes",
 CellID->2415],
Cell[9028, 308, 247, 8, 70, "Notes",
 CellID->8264],
Cell[9278, 318, 377, 13, 70, "Notes",
 CellID->29223],
Cell[9658, 333, 72, 1, 70, "Notes",
 CellID->15547],
Cell[9733, 336, 414, 16, 70, "Notes",
 CellID->21017],
Cell[10150, 354, 321, 12, 70, "Notes",
 CellID->20893]
}, Closed]],
Cell[CellGroupData[{
Cell[10508, 371, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146301636],
Cell[CellGroupData[{
Cell[10893, 385, 148, 5, 70, "ExampleSection",
 CellID->127347545],
Cell[11044, 392, 73, 1, 70, "ExampleText",
 CellID->25865],
Cell[CellGroupData[{
Cell[11142, 397, 215, 7, 28, "Input",
 CellID->28663],
Cell[11360, 406, 1036, 26, 54, "Output",
 CellID->84581493]
}, Open  ]],
Cell[12411, 435, 121, 3, 70, "ExampleDelimiter",
 CellID->18867],
Cell[12535, 440, 61, 1, 70, "ExampleText",
 CellID->20220],
Cell[CellGroupData[{
Cell[12621, 445, 277, 9, 70, "Input",
 CellID->26775],
Cell[12901, 456, 371, 10, 36, "Output",
 CellID->97184409]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13321, 472, 216, 7, 70, "ExampleSection",
 CellID->14604],
Cell[13540, 481, 215, 7, 70, "ExampleText",
 CellID->10227],
Cell[CellGroupData[{
Cell[13780, 492, 189, 6, 70, "Input",
 CellID->14112],
Cell[13972, 500, 864, 23, 58, "Output",
 CellID->112298165]
}, Open  ]],
Cell[14851, 526, 211, 8, 70, "ExampleText",
 CellID->2297],
Cell[CellGroupData[{
Cell[15087, 538, 94, 3, 70, "Input",
 CellID->534],
Cell[15184, 543, 287, 9, 36, "Output",
 CellID->192649737]
}, Open  ]],
Cell[15486, 555, 124, 3, 70, "ExampleDelimiter",
 CellID->60651336],
Cell[15613, 560, 141, 5, 70, "ExampleText",
 CellID->413253560],
Cell[15757, 567, 213, 7, 70, "Input",
 CellID->87945966],
Cell[15973, 576, 97, 1, 70, "ExampleText",
 CellID->990656031],
Cell[CellGroupData[{
Cell[16095, 581, 102, 3, 70, "Input",
 CellID->56592719],
Cell[16200, 586, 1071, 24, 54, "Output",
 CellID->388533646]
}, Open  ]],
Cell[17286, 613, 87, 1, 70, "ExampleText",
 CellID->229684788],
Cell[CellGroupData[{
Cell[17398, 618, 163, 5, 70, "Input",
 CellID->110326053],
Cell[17564, 625, 1510, 41, 122, "Output",
 CellID->100191187]
}, Open  ]],
Cell[19089, 669, 125, 3, 70, "ExampleDelimiter",
 CellID->200448062],
Cell[19217, 674, 74, 1, 70, "ExampleText",
 CellID->144411824],
Cell[CellGroupData[{
Cell[19316, 679, 243, 8, 70, "Input",
 CellID->311628150],
Cell[19562, 689, 2727, 63, 122, "Output",
 CellID->229778278]
}, Open  ]],
Cell[22304, 755, 125, 3, 70, "ExampleDelimiter",
 CellID->100783856],
Cell[22432, 760, 156, 5, 70, "ExampleText",
 CellID->33600865],
Cell[22591, 767, 488, 17, 70, "Input",
 CellID->142022986],
Cell[23082, 786, 75, 1, 70, "ExampleText",
 CellID->29067393],
Cell[CellGroupData[{
Cell[23182, 791, 103, 3, 70, "Input",
 CellID->151685488],
Cell[23288, 796, 3412, 60, 70, "Output",
 Evaluatable->False,
 CellID->67294175]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26749, 862, 218, 7, 70, "ExampleSection",
 CellID->13083],
Cell[CellGroupData[{
Cell[26992, 873, 234, 7, 70, "ExampleSubsection",
 CellID->18508],
Cell[27229, 882, 181, 7, 70, "ExampleText",
 CellID->185963725],
Cell[CellGroupData[{
Cell[27435, 893, 394, 12, 70, "Input",
 CellID->320765889],
Cell[27832, 907, 1373, 30, 54, "Output",
 CellID->216370944]
}, Open  ]],
Cell[29220, 940, 181, 8, 70, "ExampleText",
 CellID->741719999],
Cell[CellGroupData[{
Cell[29426, 952, 239, 7, 70, "Input",
 CellID->164749528],
Cell[29668, 961, 1427, 30, 71, "Output",
 CellID->1151595]
}, Open  ]],
Cell[CellGroupData[{
Cell[31132, 996, 119, 4, 70, "Input",
 CellID->215750475],
Cell[31254, 1002, 1369, 30, 54, "Output",
 CellID->540113628]
}, Open  ]],
Cell[32638, 1035, 165, 7, 70, "ExampleText",
 CellID->1380829],
Cell[CellGroupData[{
Cell[32828, 1046, 385, 12, 70, "Input",
 CellID->448291357],
Cell[33216, 1060, 1388, 30, 71, "Output",
 CellID->373051972]
}, Open  ]],
Cell[34619, 1093, 124, 3, 70, "ExampleDelimiter",
 CellID->43068943],
Cell[34746, 1098, 208, 8, 70, "ExampleText",
 CellID->209804439],
Cell[34957, 1108, 543, 19, 70, "Input",
 CellID->218852198],
Cell[CellGroupData[{
Cell[35525, 1131, 166, 5, 70, "Input",
 CellID->20447913],
Cell[35694, 1138, 1912, 38, 125, "Output",
 CellID->17827375]
}, Open  ]],
Cell[37621, 1179, 83, 1, 70, "ExampleText",
 CellID->327738748],
Cell[37707, 1182, 273, 9, 70, "Input",
 CellID->112561964],
Cell[37983, 1193, 60, 1, 70, "ExampleText",
 CellID->488876028],
Cell[38046, 1196, 365, 12, 70, "Input",
 CellID->586775117],
Cell[CellGroupData[{
Cell[38436, 1212, 380, 12, 70, "Input",
 CellID->162880751],
Cell[38819, 1226, 2164, 44, 143, "Output",
 CellID->261897263]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41044, 1277, 223, 7, 70, "ExampleSection",
 CellID->25736],
Cell[CellGroupData[{
Cell[41292, 1288, 238, 7, 70, "ExampleSubsection",
 CellID->355405434],
Cell[41533, 1297, 128, 4, 70, "ExampleText",
 CellID->28418],
Cell[CellGroupData[{
Cell[41686, 1305, 266, 9, 70, "Input",
 CellID->28228],
Cell[41955, 1316, 7402, 123, 160, "Output",
 CellID->245175859]
}, Open  ]],
Cell[49372, 1442, 113, 3, 70, "ExampleText",
 CellID->26265],
Cell[CellGroupData[{
Cell[49510, 1449, 397, 13, 70, "Input",
 CellID->28085],
Cell[49910, 1464, 2521, 49, 151, "Output",
 CellID->261677370]
}, Open  ]],
Cell[52446, 1516, 121, 3, 70, "ExampleDelimiter",
 CellID->20656],
Cell[52570, 1521, 85, 1, 70, "ExampleText",
 CellID->5374],
Cell[CellGroupData[{
Cell[52680, 1526, 348, 11, 70, "Input",
 CellID->372958817],
Cell[53031, 1539, 928, 19, 70, "Output",
 Evaluatable->False,
 CellID->395761785]
}, Open  ]],
Cell[53974, 1561, 121, 3, 70, "ExampleDelimiter",
 CellID->30056],
Cell[54098, 1566, 245, 7, 70, "ExampleText",
 CellID->29150],
Cell[CellGroupData[{
Cell[54368, 1577, 620, 20, 70, "Input",
 CellID->15616],
Cell[54991, 1599, 3767, 66, 166, "Output",
 CellID->8272920]
}, Open  ]],
Cell[58773, 1668, 121, 3, 70, "ExampleDelimiter",
 CellID->28680],
Cell[58897, 1673, 238, 7, 70, "ExampleText",
 CellID->14413],
Cell[CellGroupData[{
Cell[59160, 1684, 664, 21, 70, "Input",
 CellID->3072],
Cell[59827, 1707, 1881, 38, 168, "Output",
 CellID->70391167]
}, Open  ]],
Cell[61723, 1748, 121, 3, 70, "ExampleDelimiter",
 CellID->28248],
Cell[61847, 1753, 77, 1, 70, "ExampleText",
 CellID->13767],
Cell[61927, 1756, 433, 14, 70, "Input",
 CellID->5015],
Cell[62363, 1772, 62, 1, 70, "ExampleText",
 CellID->9918],
Cell[CellGroupData[{
Cell[62450, 1777, 104, 3, 70, "Input",
 CellID->19635],
Cell[62557, 1782, 709, 17, 121, "Output",
 CellID->286721415]
}, Open  ]],
Cell[63281, 1802, 74, 1, 70, "ExampleText",
 CellID->1055],
Cell[CellGroupData[{
Cell[63380, 1807, 201, 6, 70, "Input",
 CellID->19083],
Cell[63584, 1815, 7898, 134, 70, "Output",
 Evaluatable->False,
 CellID->33345434]
}, Open  ]],
Cell[71497, 1952, 121, 3, 70, "ExampleDelimiter",
 CellID->24339],
Cell[71621, 1957, 116, 3, 70, "ExampleText",
 CellID->16411],
Cell[CellGroupData[{
Cell[71762, 1964, 262, 9, 70, "Input",
 CellID->27772],
Cell[72027, 1975, 1145, 24, 139, "Output",
 CellID->133200402]
}, Open  ]],
Cell[73187, 2002, 66, 1, 70, "ExampleText",
 CellID->17784],
Cell[CellGroupData[{
Cell[73278, 2007, 377, 12, 70, "Input",
 CellID->32109],
Cell[73658, 2021, 12459, 208, 70, "Output",
 Evaluatable->False,
 CellID->63370055]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86166, 2235, 235, 7, 70, "ExampleSubsection",
 CellID->498910946],
Cell[86404, 2244, 141, 4, 70, "ExampleText",
 CellID->118182371],
Cell[86548, 2250, 1285, 44, 70, "Input",
 CellID->6694767],
Cell[CellGroupData[{
Cell[87858, 2298, 581, 17, 70, "Input",
 CellID->310724071],
Cell[88442, 2317, 4015, 70, 70, "Output",
 Evaluatable->False,
 CellID->109348060]
}, Open  ]],
Cell[92472, 2390, 74, 1, 70, "ExampleText",
 CellID->165424525],
Cell[92549, 2393, 317, 10, 70, "Input",
 CellID->341491492],
Cell[92869, 2405, 83, 1, 70, "ExampleText",
 CellID->125172635],
Cell[CellGroupData[{
Cell[92977, 2410, 265, 9, 70, "Input",
 CellID->242618114],
Cell[93245, 2421, 2306, 42, 70, "Output",
 Evaluatable->False,
 CellID->40535304]
}, Open  ]],
Cell[95566, 2466, 226, 8, 70, "ExampleText",
 CellID->111859113],
Cell[CellGroupData[{
Cell[95817, 2478, 295, 9, 70, "Input",
 CellID->170494011],
Cell[96115, 2489, 181, 5, 36, "Output",
 CellID->257719876]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96345, 2500, 245, 7, 70, "ExampleSubsection",
 CellID->155604882],
Cell[96593, 2509, 86, 1, 70, "ExampleText",
 CellID->298512716],
Cell[CellGroupData[{
Cell[96704, 2514, 660, 20, 70, "Input",
 CellID->193912421],
Cell[97367, 2536, 8283, 140, 70, "Output",
 Evaluatable->False,
 CellID->40695489]
}, Open  ]],
Cell[105665, 2679, 81, 1, 70, "ExampleText",
 CellID->502322473],
Cell[CellGroupData[{
Cell[105771, 2684, 414, 13, 70, "Input",
 CellID->166263675],
Cell[106188, 2699, 159, 5, 36, "Output",
 CellID->111144653]
}, Open  ]],
Cell[CellGroupData[{
Cell[106384, 2709, 484, 15, 70, "Input",
 CellID->58846495],
Cell[106871, 2726, 1075, 22, 70, "Output",
 Evaluatable->False,
 CellID->427035251]
}, Open  ]],
Cell[107961, 2751, 123, 3, 70, "ExampleText",
 CellID->8345421],
Cell[CellGroupData[{
Cell[108109, 2758, 978, 29, 70, "Input",
 CellID->12531618],
Cell[109090, 2789, 160, 5, 36, "Output",
 CellID->454410773]
}, Open  ]],
Cell[CellGroupData[{
Cell[109287, 2799, 491, 15, 70, "Input",
 CellID->170178971],
Cell[109781, 2816, 2669, 48, 70, "Output",
 Evaluatable->False,
 CellID->620977582]
}, Open  ]],
Cell[112465, 2867, 85, 1, 70, "ExampleText",
 CellID->386051367],
Cell[CellGroupData[{
Cell[112575, 2872, 328, 11, 70, "Input",
 CellID->653459834],
Cell[112906, 2885, 175, 5, 36, "Output",
 CellID->41187781]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[113130, 2896, 243, 7, 70, "ExampleSubsection",
 CellID->559026584],
Cell[113376, 2905, 153, 5, 70, "ExampleText",
 CellID->33982314],
Cell[CellGroupData[{
Cell[113554, 2914, 959, 30, 70, "Input",
 CellID->206815089],
Cell[114516, 2946, 489, 17, 36, "Output",
 CellID->8623122]
}, Open  ]],
Cell[115020, 2966, 1004, 33, 70, "ExampleText",
 CellID->2094598],
Cell[116027, 3001, 772, 23, 70, "Input",
 CellID->376797245],
Cell[116802, 3026, 199, 7, 70, "ExampleText",
 CellID->137802077],
Cell[CellGroupData[{
Cell[117026, 3037, 398, 12, 70, "Input",
 CellID->619689550],
Cell[117427, 3051, 180, 5, 36, "Output",
 CellID->156315866]
}, Open  ]],
Cell[117622, 3059, 400, 14, 70, "ExampleText",
 CellID->328121017],
Cell[118025, 3075, 345, 11, 70, "Input",
 CellID->667660352],
Cell[CellGroupData[{
Cell[118395, 3090, 371, 11, 70, "Input",
 CellID->5746973],
Cell[118769, 3103, 180, 5, 36, "Output",
 CellID->625059841]
}, Open  ]],
Cell[118964, 3111, 521, 17, 70, "ExampleText",
 CellID->58791339],
Cell[CellGroupData[{
Cell[119510, 3132, 807, 25, 70, "Input",
 CellID->354876339],
Cell[120320, 3159, 5304, 91, 70, "Output",
 Evaluatable->False,
 CellID->608062330]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[125685, 3257, 233, 7, 70, "ExampleSection",
 CellID->23282],
Cell[125921, 3266, 317, 12, 70, "ExampleText",
 CellID->16855],
Cell[CellGroupData[{
Cell[126263, 3282, 188, 6, 70, "Input",
 CellID->1738],
Cell[126454, 3290, 862, 23, 58, "Output",
 CellID->2156312]
}, Open  ]],
Cell[CellGroupData[{
Cell[127353, 3318, 106, 3, 70, "Input",
 CellID->23905],
Cell[127462, 3323, 294, 9, 36, "Output",
 CellID->94801702]
}, Open  ]],
Cell[127771, 3335, 121, 3, 70, "ExampleDelimiter",
 CellID->12650],
Cell[127895, 3340, 127, 4, 70, "ExampleText",
 CellID->23911],
Cell[CellGroupData[{
Cell[128047, 3348, 189, 6, 70, "Input",
 CellID->13458],
Cell[128239, 3356, 911, 25, 54, "Output",
 CellID->536421810]
}, Open  ]],
Cell[129165, 3384, 71, 1, 70, "ExampleText",
 CellID->23300],
Cell[CellGroupData[{
Cell[129261, 3389, 249, 8, 70, "Input",
 CellID->30116],
Cell[129513, 3399, 358, 10, 36, "Output",
 CellID->258029336]
}, Open  ]],
Cell[129886, 3412, 125, 3, 70, "ExampleDelimiter",
 CellID->342853996],
Cell[130014, 3417, 122, 3, 70, "ExampleText",
 CellID->287084426],
Cell[130139, 3422, 364, 12, 70, "Input",
 CellID->819955511],
Cell[130506, 3436, 306, 10, 70, "Input",
 CellID->523473544],
Cell[130815, 3448, 237, 8, 70, "Input",
 CellID->3415809],
Cell[CellGroupData[{
Cell[131077, 3460, 121, 4, 70, "Input",
 CellID->150688254],
Cell[131201, 3466, 180, 5, 36, "Output",
 CellID->754271702]
}, Open  ]],
Cell[131396, 3474, 121, 3, 70, "ExampleDelimiter",
 CellID->11444],
Cell[CellGroupData[{
Cell[131542, 3481, 188, 6, 70, "Input",
 CellID->1017],
Cell[131733, 3489, 761, 17, 70, "Output",
 Evaluatable->False,
 CellID->363760646]
}, Open  ]],
Cell[CellGroupData[{
Cell[132531, 3511, 249, 8, 70, "Input",
 CellID->16701],
Cell[132783, 3521, 274, 9, 36, "Output",
 CellID->26470]
}, Open  ]],
Cell[133072, 3533, 124, 3, 70, "ExampleDelimiter",
 CellID->46256211],
Cell[133199, 3538, 651, 24, 70, "ExampleText",
 CellID->48089863],
Cell[133853, 3564, 496, 17, 70, "Input",
 CellID->272526693],
Cell[CellGroupData[{
Cell[134374, 3585, 930, 32, 70, "Input",
 CellID->282552249],
Cell[135307, 3619, 972, 26, 54, "Output",
 CellID->175265393]
}, Open  ]],
Cell[CellGroupData[{
Cell[136316, 3650, 158, 5, 70, "Input",
 CellID->230118472],
Cell[136477, 3657, 257, 8, 36, "Output",
 CellID->377138254]
}, Open  ]],
Cell[136749, 3668, 125, 3, 70, "ExampleDelimiter",
 CellID->642067338],
Cell[136877, 3673, 89, 1, 70, "ExampleText",
 CellID->85199546],
Cell[136969, 3676, 741, 25, 70, "Input",
 CellID->107344537],
Cell[CellGroupData[{
Cell[137735, 3705, 161, 6, 70, "Input",
 CellID->84057634],
Cell[137899, 3713, 2185, 40, 70, "Output",
 Evaluatable->False,
 CellID->157904768]
}, Open  ]],
Cell[CellGroupData[{
Cell[140121, 3758, 268, 9, 70, "Input",
 CellID->32015240],
Cell[140392, 3769, 915, 25, 54, "Output",
 CellID->789999093]
}, Open  ]],
Cell[CellGroupData[{
Cell[141344, 3799, 254, 8, 70, "Input",
 CellID->117476890],
Cell[141601, 3809, 246, 8, 36, "Output",
 CellID->20906716]
}, Open  ]],
Cell[141862, 3820, 250, 8, 70, "ExampleText",
 CellID->808910579],
Cell[CellGroupData[{
Cell[142137, 3832, 492, 15, 70, "Input",
 CellID->234626556],
Cell[142632, 3849, 247, 8, 36, "Output",
 CellID->145133411]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[142928, 3863, 226, 7, 70, "ExampleSection",
 CellID->22992],
Cell[143157, 3872, 299, 10, 70, "ExampleText",
 CellID->522842977],
Cell[CellGroupData[{
Cell[143481, 3886, 458, 14, 70, "Input",
 CellID->187529183],
Cell[143942, 3902, 158, 5, 36, "Output",
 CellID->136171033]
}, Open  ]],
Cell[144115, 3910, 125, 3, 70, "ExampleDelimiter",
 CellID->653514822],
Cell[144243, 3915, 144, 4, 70, "ExampleText",
 CellID->292440529],
Cell[CellGroupData[{
Cell[144412, 3923, 279, 10, 70, "Input",
 CellID->208915469],
Cell[144694, 3935, 210, 7, 36, "Output",
 CellID->27673967]
}, Open  ]],
Cell[CellGroupData[{
Cell[144941, 3947, 157, 5, 70, "Input",
 CellID->354505294],
Cell[145101, 3954, 306, 11, 36, "Output",
 CellID->32152768]
}, Open  ]],
Cell[CellGroupData[{
Cell[145444, 3970, 248, 8, 70, "Input",
 CellID->714233270],
Cell[145695, 3980, 224, 7, 36, "Output",
 CellID->194856286]
}, Open  ]],
Cell[CellGroupData[{
Cell[145956, 3992, 279, 10, 70, "Input",
 CellID->515235279],
Cell[146238, 4004, 224, 7, 36, "Output",
 CellID->696328877]
}, Open  ]],
Cell[CellGroupData[{
Cell[146499, 4016, 157, 5, 70, "Input",
 CellID->163856224],
Cell[146659, 4023, 482, 17, 36, "Output",
 CellID->280879281]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[147202, 4047, 311, 9, 70, "SeeAlsoSection",
 CellID->18374],
Cell[147516, 4058, 1479, 53, 70, "SeeAlso",
 CellID->31059]
}, Open  ]],
Cell[CellGroupData[{
Cell[149032, 4116, 314, 9, 70, "TutorialsSection",
 CellID->30564],
Cell[149349, 4127, 163, 3, 70, "Tutorials",
 CellID->12166],
Cell[149515, 4132, 154, 3, 70, "Tutorials",
 CellID->1899]
}, Open  ]],
Cell[CellGroupData[{
Cell[149706, 4140, 321, 9, 70, "RelatedLinksSection",
 CellID->18640],
Cell[150030, 4151, 359, 12, 70, "RelatedLinks"],
Cell[150392, 4165, 266, 6, 70, "RelatedLinks",
 CellID->2969],
Cell[150661, 4173, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151083, 4191, 317, 9, 70, "MoreAboutSection",
 CellID->3517994],
Cell[151403, 4202, 167, 3, 70, "MoreAbout",
 CellID->266203057],
Cell[151573, 4207, 143, 3, 70, "MoreAbout",
 CellID->318030140],
Cell[151719, 4212, 149, 3, 70, "MoreAbout",
 CellID->214831135],
Cell[151871, 4217, 138, 3, 70, "MoreAbout",
 CellID->60626102],
Cell[152012, 4222, 145, 3, 70, "MoreAbout",
 CellID->811540217]
}, Open  ]],
Cell[152172, 4228, 50, 0, 70, "History"],
Cell[152225, 4230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

