(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52884,       1919]
NotebookOptionsPosition[     35401,       1374]
NotebookOutlinePosition[     43544,       1594]
CellTagsIndexPosition[     42479,       1568]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierSinTransform"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "FourierDCT" :> Documentation`HelpLookup["paclet:ref/FourierDCT"], 
          "InverseFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:ref/InverseFourierCosTransform"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FourierSinTransform\"\>", 
       2->"\<\"FourierTransform\"\>", 3->"\<\"FourierDCT\"\>", 
       4->"\<\"InverseFourierCosTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierCosTransform", "ObjectName",
 CellID->10862],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierCosTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierCosTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["\[Omega]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic Fourier cosine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierCosTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierCosTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional Fourier cosine transform of \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Fourier cosine transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      RowBox[{"cos", "(", 
       RowBox[{"\[Omega]", "\[InvisibleSpace]", "t"}], ")"}], "d", 
      "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29648],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->28558],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6280],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["FourierParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FourierParameters"], "->", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], TraditionalForm]], "InlineFormula"],
 " the Fourier cosine transform computed by ",
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SqrtBox[
     FractionBox[
      RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "-", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      RowBox[{"cos", "(", 
       RowBox[{
       "b", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", "t"}], 
       ")"}], "d", "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->3752],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18445]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200434893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->192519754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "t", "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"In[1]:=",
 CellID->409380582],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["\[Omega]"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"Out[1]=",
 CellID->51490539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59341575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", " ", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"In[1]:=",
 CellID->510216563],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"Out[1]=",
 CellID->391298610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535862854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"In[1]:=",
 CellID->71906731],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{156, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"Out[1]=",
 CellID->37784802]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23859],

Cell["Elementary functions:", "ExampleText",
 CellID->1337587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "4"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"In[1]:=",
 CellID->559634976],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["\[Omega]", 
     SqrtBox["2"]]}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox["\[Omega]", 
      SqrtBox["2"]], "]"}], "-", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Omega]", 
      SqrtBox["2"]], "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"Out[1]=",
 CellID->349280288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "3"}], "t"}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"In[2]:=",
 CellID->86052490],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], 
  RowBox[{"9", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"Out[2]=",
 CellID->74550895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"2", "/", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"In[3]:=",
 CellID->295748689],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Omega]"}]], " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   RowBox[{"Sin", "[", "\[Omega]", "]"}]}], "\[Omega]"]], "Output",
 ImageSize->{109, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"Out[3]=",
 CellID->61297184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"In[4]:=",
 CellID->39179587],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sech", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}]}]], "Output",
 ImageSize->{104, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"Out[4]=",
 CellID->86453482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229510772],

Cell["Special functions:", "ExampleText",
 CellID->374012082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"In[1]:=",
 CellID->419408488],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"ArcTan", "[", "\[Omega]", "]"}]}], "\[Omega]"]}]], "Output",
 ImageSize->{112, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"Out[1]=",
 CellID->274757430]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Sqrt", "[", "t", "]"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"In[2]:=",
 CellID->100635333],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["1", 
     RowBox[{"4", " ", "\[Omega]"}]], "]"}]}], "\[Omega]"]], "Output",
 ImageSize->{93, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"Out[2]=",
 CellID->308879833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362298078],

Cell["Generalized functions:", "ExampleText",
 CellID->609824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"t", "-", "1"}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"In[1]:=",
 CellID->489072697],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Sin", "[", "\[Omega]", "]"}]}], "\[Omega]"]}]], "Output",
 ImageSize->{225, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"Out[1]=",
 CellID->130273223]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"t", " ", 
    RowBox[{"HeavisideTheta", "[", "t", "]"}], " ", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "t"}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"In[2]:=",
 CellID->731592460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cos", "[", "\[Omega]", "]"}], "+", 
     RowBox[{"\[Omega]", " ", 
      RowBox[{"Sin", "[", "\[Omega]", "]"}]}]}], ")"}]}], 
  SuperscriptBox["\[Omega]", "2"]]], "Output",
 ImageSize->{190, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"Out[2]=",
 CellID->310244598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3714409],

Cell["Multivariate transform:", "ExampleText",
 CellID->41273068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "t1"}], "-", "t2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568585444],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]1", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]2", "2"]}], ")"}]}]]], "Output",
 ImageSize->{129, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101888898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"t1", "^", "2"}]}], "-", 
     RowBox[{"t2", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29467176],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[Omega]1", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["\[Omega]2", "2"], "4"]}]]}]], "Output",
 ImageSize->{73, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38743599]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28575],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145440021],

Cell[TextData[{
 "Fourier cosine transform of ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " is a piecewise function:"
}], "ExampleText",
 CellID->129286313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Omega]", ">", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"In[1]:=",
 CellID->786369123],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"Out[1]=",
 CellID->79074450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Omega]", "<", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"In[2]:=",
 CellID->320784725],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["\[Omega]", "2"]}]]]], "Output",
 ImageSize->{60, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"Out[2]=",
 CellID->154634459]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12425],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->327143797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"In[1]:=",
 CellID->379941444],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"Out[1]=",
 CellID->244437011]
}, Open  ]],

Cell["\<\
Use a non-default setting for a different definition of transform:\
\>", "ExampleText",
 CellID->21669668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"In[2]:=",
 CellID->257823649],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"Out[2]=",
 CellID->34605236]
}, Open  ]],

Cell[TextData[{
 "To get the inverse, use the same ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->440478316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->596811075],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "t"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->484470727]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11879],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->327317843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"In[1]:=",
 CellID->205781283],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"a", " ", 
      SqrtBox[
       FractionBox["2", "\[Pi]"]]}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["\[Omega]", "2"]}]]}], ",", 
   RowBox[{"FourierCosTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "t"}]], ",", "t", ",", "\[Omega]", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{547, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"Out[1]=",
 CellID->275225504]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierCosTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->899866971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"FourierCosTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}], 
   ",", "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"In[1]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"Out[1]=",
 CellID->21568183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierCosTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", " ", "t"}], 
    "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"In[2]:=",
 CellID->72689112],

Cell[BoxData[
 RowBox[{"g", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"Out[2]=",
 CellID->414942657]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[Omega]"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->4810312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->402324171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4553799],

Cell[TextData[{
 "Results from ",
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " agree for even functions:"
}], "ExampleText",
 CellID->211365622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[1]:=",
 CellID->145126959],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[1]=",
 CellID->438047247]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], " ", 
  "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[2]:=",
 CellID->204658303],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[2]=",
 CellID->360108619]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24425],

Cell[TextData[{
 "Fourier cosine transform may be given in terms of generalized functions \
such as ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238568336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"In[1]:=",
 CellID->741524577],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"Out[1]=",
 CellID->17888323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "3"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244656350],

Cell[BoxData[
 FractionBox[
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["2", "3"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        FractionBox["1", "6"], ",", 
        FractionBox["1", "3"], ",", 
        FractionBox["2", "3"], ",", 
        FractionBox["2", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "2"], ",", 
        FractionBox["5", "6"]}], "}"}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["\[Omega]", "6"], "46656"]}], "]"}], 
  RowBox[{
   SqrtBox["6"], " ", "\[Pi]"}]]], "Output",
 ImageSize->{365, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87049661]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7942],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDCT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDCT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3682]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15299],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->26461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->52580062],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->781830928]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierCosTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 57.7667970}", "context" -> "System`", 
    "keywords" -> {
     "cosine transform", "Fourier cos transform", "Fourier cosine transform"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FourierCosTransform[expr, t, \\[Omega]] gives the symbolic Fourier \
cosine transform of expr. FourierCosTransform[expr, {t_1, t_2, ...}, \
{\\[Omega]_1, \\[Omega]_2, ...}] gives the multidimensional Fourier cosine \
transform of expr. ", "synonyms" -> {"fourier cos transform"}, "title" -> 
    "FourierCosTransform", "type" -> "Symbol", "uri" -> 
    "ref/FourierCosTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7847, 260, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->200434893]},
 "Ex--22034523510008951413,5"->{
  Cell[8405, 283, 256, 8, 28, "Input",
   CellTags->"Ex--22034523510008951413,5",
   CellID->409380582],
  Cell[8664, 293, 237, 8, 55, "Output",
   CellTags->"Ex--22034523510008951413,5",
   CellID->51490539]},
 "Ex--22034523510008951413,1"->{
  Cell[9065, 311, 281, 9, 28, "Input",
   CellTags->"Ex--22034523510008951413,1",
   CellID->510216563],
  Cell[9349, 322, 345, 12, 68, "Output",
   CellTags->"Ex--22034523510008951413,1",
   CellID->391298610]},
 "Ex--22034523510008951413,7"->{
  Cell[9859, 344, 230, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,7",
   CellID->71906731],
  Cell[10092, 353, 403, 14, 60, "Output",
   CellTags->"Ex--22034523510008951413,7",
   CellID->37784802]},
 "Ex--22034523510008951413,12"->{
  Cell[10850, 387, 328, 11, 70, "Input",
   CellTags->"Ex--22034523510008951413,12",
   CellID->559634976],
  Cell[11181, 400, 587, 21, 66, "Output",
   CellTags->"Ex--22034523510008951413,12",
   CellID->349280288]},
 "Ex--22034523510008951413,13"->{
  Cell[11805, 426, 271, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,13",
   CellID->86052490],
  Cell[12079, 437, 337, 12, 77, "Output",
   CellTags->"Ex--22034523510008951413,13",
   CellID->74550895]},
 "Ex--22034523510008951413,15"->{
  Cell[12453, 454, 285, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,15",
   CellID->295748689],
  Cell[12741, 465, 406, 13, 56, "Output",
   CellTags->"Ex--22034523510008951413,15",
   CellID->61297184]},
 "Ex--22034523510008951413,16"->{
  Cell[13184, 483, 231, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,16",
   CellID->39179587],
  Cell[13418, 492, 349, 12, 60, "Output",
   CellTags->"Ex--22034523510008951413,16",
   CellID->86453482]},
 "Ex--22034523510008951413,17"->{
  Cell[13996, 517, 258, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,17",
   CellID->419408488],
  Cell[14257, 526, 354, 12, 76, "Output",
   CellTags->"Ex--22034523510008951413,17",
   CellID->274757430]},
 "Ex--22034523510008951413,18"->{
  Cell[14648, 543, 294, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,18",
   CellID->100635333],
  Cell[14945, 554, 377, 13, 76, "Output",
   CellTags->"Ex--22034523510008951413,18",
   CellID->308879833]},
 "Ex--22034599492440594602,3"->{
  Cell[15552, 580, 266, 8, 70, "Input",
   CellTags->"Ex--22034599492440594602,3",
   CellID->489072697],
  Cell[15821, 590, 465, 16, 76, "Output",
   CellTags->"Ex--22034599492440594602,3",
   CellID->130273223]},
 "Ex--22034523510008951413,25"->{
  Cell[16323, 611, 346, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,25",
   CellID->731592460],
  Cell[16672, 623, 509, 17, 77, "Output",
   CellTags->"Ex--22034523510008951413,25",
   CellID->310244598]},
 "Ex--22034523510008951413,22"->{
  Cell[19762, 751, 339, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,22",
   CellID->786369123],
  Cell[20104, 762, 199, 6, 36, "Output",
   CellTags->"Ex--22034523510008951413,22",
   CellID->79074450]},
 "Ex--22034523510008951413,23"->{
  Cell[20340, 773, 339, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,23",
   CellID->320784725],
  Cell[20682, 784, 327, 12, 87, "Output",
   CellTags->"Ex--22034523510008951413,23",
   CellID->154634459]},
 "Ex--22034599492440594602,9"->{
  Cell[21639, 827, 247, 7, 70, "Input",
   CellTags->"Ex--22034599492440594602,9",
   CellID->379941444],
  Cell[21889, 836, 312, 11, 77, "Output",
   CellTags->"Ex--22034599492440594602,9",
   CellID->244437011]},
 "Ex--22034523510008951413,28"->{
  Cell[22357, 857, 360, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,28",
   CellID->257823649],
  Cell[22720, 869, 274, 9, 52, "Output",
   CellTags->"Ex--22034523510008951413,28",
   CellID->34605236]},
 "Ex--22034523510008951413,19"->{
  Cell[24443, 940, 326, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,19",
   CellID->205781283],
  Cell[24772, 951, 742, 24, 77, "Output",
   CellTags->"Ex--22034523510008951413,19",
   CellID->275225504]},
 "Ex--22034138112425334325,15"->{
  Cell[26220, 1007, 337, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,15",
   CellID->87244332],
  Cell[26560, 1018, 226, 7, 36, "Output",
   CellTags->"Ex--22034138112425334325,15",
   CellID->21568183]},
 "Ex--22035133735460154583,1"->{
  Cell[26823, 1030, 344, 9, 70, "Input",
   CellTags->"Ex--22035133735460154583,1",
   CellID->72689112],
  Cell[27170, 1041, 233, 7, 36, "Output",
   CellTags->"Ex--22035133735460154583,1",
   CellID->414942657]},
 "Ex--22034558506017011754,4"->{
  Cell[27440, 1053, 302, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[27745, 1065, 321, 11, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->4810312],
  Cell[29130, 1122, 276, 9, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->145126959],
  Cell[29409, 1133, 345, 12, 68, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->438047247]},
 "Ex--22034558506017011754,5"->{
  Cell[28103, 1081, 203, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[28309, 1088, 267, 9, 52, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->402324171],
  Cell[29791, 1150, 278, 9, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->204658303],
  Cell[30072, 1161, 345, 12, 68, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->360108619]},
 "Ex--22034523510008951413,31"->{
  Cell[30989, 1201, 197, 5, 70, "Input",
   CellTags->"Ex--22034523510008951413,31",
   CellID->741524577],
  Cell[31189, 1208, 306, 10, 38, "Output",
   CellTags->"Ex--22034523510008951413,31",
   CellID->17888323]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36670, 1402},
 {"Ex--22034523510008951413,5", 36823, 1406},
 {"Ex--22034523510008951413,1", 37067, 1413},
 {"Ex--22034523510008951413,7", 37313, 1420},
 {"Ex--22034523510008951413,12", 37559, 1427},
 {"Ex--22034523510008951413,13", 37811, 1434},
 {"Ex--22034523510008951413,15", 38060, 1441},
 {"Ex--22034523510008951413,16", 38310, 1448},
 {"Ex--22034523510008951413,17", 38559, 1455},
 {"Ex--22034523510008951413,18", 38810, 1462},
 {"Ex--22034599492440594602,3", 39060, 1469},
 {"Ex--22034523510008951413,25", 39309, 1476},
 {"Ex--22034523510008951413,22", 39561, 1483},
 {"Ex--22034523510008951413,23", 39810, 1490},
 {"Ex--22034599492440594602,9", 40060, 1497},
 {"Ex--22034523510008951413,28", 40309, 1504},
 {"Ex--22034523510008951413,19", 40559, 1511},
 {"Ex--22034138112425334325,15", 40810, 1518},
 {"Ex--22035133735460154583,1", 41059, 1525},
 {"Ex--22034558506017011754,4", 41307, 1532},
 {"Ex--22034558506017011754,5", 41772, 1545},
 {"Ex--22034523510008951413,31", 42238, 1558}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2260, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2883, 82, 57, 1, 70, "ObjectName",
 CellID->10862],
Cell[2943, 85, 1717, 53, 70, "Usage",
 CellID->31354]
}, Open  ]],
Cell[CellGroupData[{
Cell[4697, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5175, 160, 606, 20, 70, "Notes",
 CellID->29648],
Cell[5784, 182, 109, 3, 70, "Notes",
 CellID->28558],
Cell[5896, 187, 258, 8, 70, "Notes",
 CellID->6280],
Cell[6157, 197, 1159, 39, 70, "Notes",
 CellID->3752],
Cell[7319, 238, 491, 17, 70, "Notes",
 CellID->18445]
}, Closed]],
Cell[CellGroupData[{
Cell[7847, 260, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200434893],
Cell[CellGroupData[{
Cell[8232, 274, 148, 5, 70, "ExampleSection",
 CellID->192519754],
Cell[CellGroupData[{
Cell[8405, 283, 256, 8, 28, "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellID->409380582],
Cell[8664, 293, 237, 8, 55, "Output",
 CellTags->"Ex--22034523510008951413,5",
 CellID->51490539]
}, Open  ]],
Cell[8916, 304, 124, 3, 70, "ExampleDelimiter",
 CellID->59341575],
Cell[CellGroupData[{
Cell[9065, 311, 281, 9, 28, "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellID->510216563],
Cell[9349, 322, 345, 12, 68, "Output",
 CellTags->"Ex--22034523510008951413,1",
 CellID->391298610]
}, Open  ]],
Cell[9709, 337, 125, 3, 70, "ExampleDelimiter",
 CellID->535862854],
Cell[CellGroupData[{
Cell[9859, 344, 230, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellID->71906731],
Cell[10092, 353, 403, 14, 60, "Output",
 CellTags->"Ex--22034523510008951413,7",
 CellID->37784802]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10544, 373, 216, 7, 70, "ExampleSection",
 CellID->23859],
Cell[10763, 382, 62, 1, 70, "ExampleText",
 CellID->1337587],
Cell[CellGroupData[{
Cell[10850, 387, 328, 11, 70, "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellID->559634976],
Cell[11181, 400, 587, 21, 66, "Output",
 CellTags->"Ex--22034523510008951413,12",
 CellID->349280288]
}, Open  ]],
Cell[CellGroupData[{
Cell[11805, 426, 271, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellID->86052490],
Cell[12079, 437, 337, 12, 77, "Output",
 CellTags->"Ex--22034523510008951413,13",
 CellID->74550895]
}, Open  ]],
Cell[CellGroupData[{
Cell[12453, 454, 285, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellID->295748689],
Cell[12741, 465, 406, 13, 56, "Output",
 CellTags->"Ex--22034523510008951413,15",
 CellID->61297184]
}, Open  ]],
Cell[CellGroupData[{
Cell[13184, 483, 231, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellID->39179587],
Cell[13418, 492, 349, 12, 60, "Output",
 CellTags->"Ex--22034523510008951413,16",
 CellID->86453482]
}, Open  ]],
Cell[13782, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->229510772],
Cell[13910, 512, 61, 1, 70, "ExampleText",
 CellID->374012082],
Cell[CellGroupData[{
Cell[13996, 517, 258, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellID->419408488],
Cell[14257, 526, 354, 12, 76, "Output",
 CellTags->"Ex--22034523510008951413,17",
 CellID->274757430]
}, Open  ]],
Cell[CellGroupData[{
Cell[14648, 543, 294, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellID->100635333],
Cell[14945, 554, 377, 13, 76, "Output",
 CellTags->"Ex--22034523510008951413,18",
 CellID->308879833]
}, Open  ]],
Cell[15337, 570, 125, 3, 70, "ExampleDelimiter",
 CellID->362298078],
Cell[15465, 575, 62, 1, 70, "ExampleText",
 CellID->609824],
Cell[CellGroupData[{
Cell[15552, 580, 266, 8, 70, "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellID->489072697],
Cell[15821, 590, 465, 16, 76, "Output",
 CellTags->"Ex--22034599492440594602,3",
 CellID->130273223]
}, Open  ]],
Cell[CellGroupData[{
Cell[16323, 611, 346, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellID->731592460],
Cell[16672, 623, 509, 17, 77, "Output",
 CellTags->"Ex--22034523510008951413,25",
 CellID->310244598]
}, Open  ]],
Cell[17196, 643, 123, 3, 70, "ExampleDelimiter",
 CellID->3714409],
Cell[17322, 648, 65, 1, 70, "ExampleText",
 CellID->41273068],
Cell[CellGroupData[{
Cell[17412, 653, 343, 11, 70, "Input",
 CellID->568585444],
Cell[17758, 666, 384, 13, 57, "Output",
 CellID->101888898]
}, Open  ]],
Cell[CellGroupData[{
Cell[18179, 684, 395, 13, 70, "Input",
 CellID->29467176],
Cell[18577, 699, 400, 14, 55, "Output",
 CellID->38743599]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19026, 719, 218, 7, 70, "ExampleSection",
 CellID->28575],
Cell[CellGroupData[{
Cell[19269, 730, 232, 7, 70, "ExampleSubsection",
 CellID->145440021],
Cell[19504, 739, 233, 8, 70, "ExampleText",
 CellID->129286313],
Cell[CellGroupData[{
Cell[19762, 751, 339, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellID->786369123],
Cell[20104, 762, 199, 6, 36, "Output",
 CellTags->"Ex--22034523510008951413,22",
 CellID->79074450]
}, Open  ]],
Cell[CellGroupData[{
Cell[20340, 773, 339, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellID->320784725],
Cell[20682, 784, 327, 12, 87, "Output",
 CellTags->"Ex--22034523510008951413,23",
 CellID->154634459]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21058, 802, 234, 7, 70, "ExampleSubsection",
 CellID->12425],
Cell[21295, 811, 319, 12, 70, "ExampleText",
 CellID->327143797],
Cell[CellGroupData[{
Cell[21639, 827, 247, 7, 70, "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellID->379941444],
Cell[21889, 836, 312, 11, 77, "Output",
 CellTags->"Ex--22034599492440594602,9",
 CellID->244437011]
}, Open  ]],
Cell[22216, 850, 116, 3, 70, "ExampleText",
 CellID->21669668],
Cell[CellGroupData[{
Cell[22357, 857, 360, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellID->257823649],
Cell[22720, 869, 274, 9, 52, "Output",
 CellTags->"Ex--22034523510008951413,28",
 CellID->34605236]
}, Open  ]],
Cell[23009, 881, 242, 8, 70, "ExampleText",
 CellID->440478316],
Cell[CellGroupData[{
Cell[23276, 893, 274, 7, 70, "Input",
 CellID->596811075],
Cell[23553, 902, 213, 7, 36, "Output",
 CellID->484470727]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23815, 915, 235, 7, 70, "ExampleSubsection",
 CellID->11879],
Cell[24053, 924, 365, 12, 70, "ExampleText",
 CellID->327317843],
Cell[CellGroupData[{
Cell[24443, 940, 326, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellID->205781283],
Cell[24772, 951, 742, 24, 77, "Output",
 CellTags->"Ex--22034523510008951413,19",
 CellID->275225504]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[25575, 982, 232, 7, 70, "ExampleSection",
 CellID->1876],
Cell[25810, 991, 385, 12, 70, "ExampleText",
 CellID->899866971],
Cell[CellGroupData[{
Cell[26220, 1007, 337, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellID->87244332],
Cell[26560, 1018, 226, 7, 36, "Output",
 CellTags->"Ex--22034138112425334325,15",
 CellID->21568183]
}, Open  ]],
Cell[CellGroupData[{
Cell[26823, 1030, 344, 9, 70, "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellID->72689112],
Cell[27170, 1041, 233, 7, 36, "Output",
 CellTags->"Ex--22035133735460154583,1",
 CellID->414942657]
}, Open  ]],
Cell[CellGroupData[{
Cell[27440, 1053, 302, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[27745, 1065, 321, 11, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->4810312]
}, Open  ]],
Cell[CellGroupData[{
Cell[28103, 1081, 203, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[28309, 1088, 267, 9, 52, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->402324171]
}, Open  ]],
Cell[28591, 1100, 123, 3, 70, "ExampleDelimiter",
 CellID->4553799],
Cell[28717, 1105, 388, 13, 70, "ExampleText",
 CellID->211365622],
Cell[CellGroupData[{
Cell[29130, 1122, 276, 9, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->145126959],
Cell[29409, 1133, 345, 12, 68, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->438047247]
}, Open  ]],
Cell[CellGroupData[{
Cell[29791, 1150, 278, 9, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->204658303],
Cell[30072, 1161, 345, 12, 68, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->360108619]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30466, 1179, 226, 7, 70, "ExampleSection",
 CellID->24425],
Cell[30695, 1188, 269, 9, 70, "ExampleText",
 CellID->238568336],
Cell[CellGroupData[{
Cell[30989, 1201, 197, 5, 70, "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellID->741524577],
Cell[31189, 1208, 306, 10, 38, "Output",
 CellTags->"Ex--22034523510008951413,31",
 CellID->17888323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31544, 1224, 223, 7, 70, "ExampleSection",
 CellID->5488],
Cell[CellGroupData[{
Cell[31792, 1235, 261, 9, 70, "Input",
 CellID->244656350],
Cell[32056, 1246, 826, 29, 66, "Output",
 CellID->87049661]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32943, 1282, 310, 9, 70, "SeeAlsoSection",
 CellID->7942],
Cell[33256, 1293, 1018, 35, 70, "SeeAlso",
 CellID->3682]
}, Open  ]],
Cell[CellGroupData[{
Cell[34311, 1333, 314, 9, 70, "TutorialsSection",
 CellID->15299],
Cell[34628, 1344, 194, 4, 70, "Tutorials",
 CellID->26461]
}, Open  ]],
Cell[CellGroupData[{
Cell[34859, 1353, 318, 9, 70, "MoreAboutSection",
 CellID->52580062],
Cell[35180, 1364, 149, 3, 70, "MoreAbout",
 CellID->781830928]
}, Open  ]],
Cell[35344, 1370, 27, 0, 70, "History"],
Cell[35374, 1372, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

