(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24527,        915]
NotebookOptionsPosition[     18772,        718]
NotebookOutlinePosition[     20278,        758]
CellTagsIndexPosition[     20193,        753]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier" :> Documentation`HelpLookup["paclet:ref/Fourier"], 
         "InverseFourier" :> 
         Documentation`HelpLookup["paclet:ref/InverseFourier"], 
         "FourierTransform" :> 
         Documentation`HelpLookup["paclet:ref/FourierTransform"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Fourier\"\>", 
      2->"\<\"InverseFourier\"\>", 
      3->"\<\"FourierTransform\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierParameters", "ObjectName",
 CellID->22392],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FourierParameters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Fourier",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
     " and related functions that specifies the conventions to use in \
computing Fourier transforms."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14660]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical setting is ",
 Cell[BoxData[
  RowBox[{"FourierParameters", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->48149627],

Cell[TextData[{
 "Some common choices for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 " (default), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 " (data analysis), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " (signal processing). "
}], "Notes",
 CellID->6989]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->509643823],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->277733491],

Cell["\<\
Use a non-default definition of the discrete Fourier transform:\
\>", "ExampleText",
 CellID->29362937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100695184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"21.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3.000000000000002`"}], "-", 
    RowBox[{"5.196152422706633`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], "-", 
    RowBox[{"1.7320508075688785`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], "+", 
    RowBox[{"1.7320508075688785`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3.000000000000002`"}], "+", 
    RowBox[{"5.196152422706633`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{570, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->961363923]
}, Open  ]],

Cell["Use the same definition to get the inverse:", "ExampleText",
 CellID->911696921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"%", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79573487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999999999991`", ",", "1.9999999999999991`", ",", 
   "3.0000000000000004`", ",", "4.`", ",", "5.`", ",", "6.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->441165837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->903782071],

Cell["\<\
A non-default definition used for the continuous Fourier transform:\
\>", "ExampleText",
 CellID->30566834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271797725],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], " ", 
  SqrtBox["\[Pi]"]}]], "Output",
 ImageSize->{58, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251943108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->794722258],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{27, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167031425]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32116],

Cell["\<\
A typical pure mathematics or systems engineering definition of Fourier \
transform: \
\>", "ExampleText",
 CellID->213863735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"Abs", "[", "t", "]"}]}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234980255],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163492665]
}, Open  ]],

Cell["Use the same definition for the inverse transform:", "ExampleText",
 CellID->433121450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125914329],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   RowBox[{"Abs", "[", "t", "]"}]}]]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121511603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58457310],

Cell["A common signal processing definition of Fourier transform:", \
"ExampleText",
 CellID->452981054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"Abs", "[", "t", "]"}]}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6822254],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"1", "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"], " ", 
    SuperscriptBox["\[Omega]", "2"]}]}]]], "Output",
 ImageSize->{67, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15404746]
}, Open  ]],

Cell["Use the same parameter definition for the inverse:", "ExampleText",
 CellID->34903984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37492091],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   RowBox[{"Abs", "[", "t", "]"}]}]]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148784337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130393082],

Cell["\<\
A typical data analysis definition of discrete Fourier transform:\
\>", "ExampleText",
 CellID->44142530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"Range", "[", "6", "]"}], ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127754712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5000000000000003`"}], "-", 
    RowBox[{"0.8660254037844388`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    RowBox[{"0.2886751345948131`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"0.2886751345948131`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5000000000000003`"}], "+", 
    RowBox[{"0.8660254037844388`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{324, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256576767]
}, Open  ]],

Cell["Use the same definition to get the correct inverse:", "ExampleText",
 CellID->231916884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"%", ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->698168409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999999999993`", ",", "1.9999999999999991`", ",", 
   "3.000000000000001`", ",", "4.000000000000001`", ",", "5.000000000000001`",
    ",", "6.000000000000001`"}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101988225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14952],

Cell[TextData[{
 "The same ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " values need to be used for both forward and inverse transforms:"
}], "ExampleText",
 CellID->246043329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539588314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5000000000000003`"}], "-", 
    RowBox[{"0.8660254037844388`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "-", 
    RowBox[{"0.2886751345948131`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5`"}], "+", 
    RowBox[{"0.2886751345948131`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5000000000000003`"}], "+", 
    RowBox[{"0.8660254037844388`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{324, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1509416]
}, Open  ]],

Cell[TextData[{
 "Here the inverse uses a different choice of ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->702519974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->212244885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4082482904638628`", ",", "0.8164965809277258`", ",", 
   "1.2247448713915896`", ",", "1.6329931618554527`", ",", 
   "2.0412414523193156`", ",", "2.4494897427831788`"}], "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140675954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2447068],

Cell["\<\
The second parameter needs to be relatively prime to the data length to \
guarantee invertibility:\
\>", "ExampleText",
 CellID->417917905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81525342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.16666666666666666`", ",", "0.16666666666666663`", ",", 
   "0.16666666666666663`", ",", "0.16666666666666666`", ",", 
   "0.16666666666666666`", ",", "0.16666666666666663`"}], "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53857150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFourier", "[", 
   RowBox[{"%", ",", 
    RowBox[{"FourierParameters", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->543622116],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFourier", "::", "\<\"fpopt2\"\>"}], ":", 
  " ", "\<\"Warning: the discrete Fourier transform may not be invertible \
unless the second element of the option FourierParameters -> \
\\!\\({\\(\\(-1\\)\\), 3}\\) is an integer having no factors in common with \
the length of the input.\"\>"}]], "Message", "MSG",
 CellID->379151989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999999999998`", ",", "0", ",", "0.9999999999999998`", ",", "0", ",", 
   "0.9999999999999998`", ",", "0"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31816517]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22387]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierParameters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 7.0482846}", "context" -> "System`", 
    "keywords" -> {
     "discrete Fourier transform", "fast Fourier transform", 
      "Fourier cos transform", "Fourier parameters", "Fourier sin transform", 
      "Fourier transform", "inverse Fourier transform"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FourierParameters is an option to Fourier and related functions that \
specifies the conventions to use in computing Fourier transforms.", 
    "synonyms" -> {"fourier parameters"}, "title" -> "FourierParameters", 
    "type" -> "Symbol", "uri" -> "ref/FourierParameters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3523, 130, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->509643823]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20050, 746}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 813, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1436, 46, 55, 1, 70, "ObjectName",
 CellID->22392],
Cell[1494, 49, 655, 19, 70, "Usage",
 CellID->14660]
}, Open  ]],
Cell[CellGroupData[{
Cell[2186, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2664, 90, 249, 10, 70, "Notes",
 CellID->48149627],
Cell[2916, 102, 570, 23, 70, "Notes",
 CellID->6989]
}, Closed]],
Cell[CellGroupData[{
Cell[3523, 130, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->509643823],
Cell[CellGroupData[{
Cell[3908, 144, 148, 5, 70, "ExampleSection",
 CellID->277733491],
Cell[4059, 151, 113, 3, 70, "ExampleText",
 CellID->29362937],
Cell[CellGroupData[{
Cell[4197, 158, 316, 10, 28, "Input",
 CellID->100695184],
Cell[4516, 170, 850, 25, 36, "Output",
 CellID->961363923]
}, Open  ]],
Cell[5381, 198, 86, 1, 70, "ExampleText",
 CellID->911696921],
Cell[CellGroupData[{
Cell[5492, 203, 229, 7, 28, "Input",
 CellID->79573487],
Cell[5724, 212, 314, 10, 36, "Output",
 CellID->441165837]
}, Open  ]],
Cell[6053, 225, 125, 3, 70, "ExampleDelimiter",
 CellID->903782071],
Cell[6181, 230, 117, 3, 70, "ExampleText",
 CellID->30566834],
Cell[CellGroupData[{
Cell[6323, 237, 336, 10, 70, "Input",
 CellID->271797725],
Cell[6662, 249, 310, 11, 46, "Output",
 CellID->251943108]
}, Open  ]],
Cell[CellGroupData[{
Cell[7009, 265, 266, 7, 70, "Input",
 CellID->794722258],
Cell[7278, 274, 238, 8, 40, "Output",
 CellID->167031425]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7565, 288, 216, 7, 70, "ExampleSection",
 CellID->32116],
Cell[7784, 297, 136, 4, 70, "ExampleText",
 CellID->213863735],
Cell[CellGroupData[{
Cell[7945, 305, 369, 12, 70, "Input",
 CellID->234980255],
Cell[8317, 319, 233, 8, 52, "Output",
 CellID->163492665]
}, Open  ]],
Cell[8565, 330, 93, 1, 70, "ExampleText",
 CellID->433121450],
Cell[CellGroupData[{
Cell[8683, 335, 288, 8, 70, "Input",
 CellID->125914329],
Cell[8974, 345, 244, 8, 36, "Output",
 CellID->121511603]
}, Open  ]],
Cell[9233, 356, 124, 3, 70, "ExampleDelimiter",
 CellID->58457310],
Cell[9360, 361, 104, 2, 70, "ExampleText",
 CellID->452981054],
Cell[CellGroupData[{
Cell[9489, 367, 391, 13, 70, "Input",
 CellID->6822254],
Cell[9883, 382, 297, 10, 53, "Output",
 CellID->15404746]
}, Open  ]],
Cell[10195, 395, 92, 1, 70, "ExampleText",
 CellID->34903984],
Cell[CellGroupData[{
Cell[10312, 400, 311, 9, 70, "Input",
 CellID->37492091],
Cell[10626, 411, 244, 8, 36, "Output",
 CellID->148784337]
}, Open  ]],
Cell[10885, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->130393082],
Cell[11013, 427, 115, 3, 70, "ExampleText",
 CellID->44142530],
Cell[CellGroupData[{
Cell[11153, 434, 278, 9, 70, "Input",
 CellID->127754712],
Cell[11434, 445, 858, 25, 54, "Output",
 CellID->256576767]
}, Open  ]],
Cell[12307, 473, 94, 1, 70, "ExampleText",
 CellID->231916884],
Cell[CellGroupData[{
Cell[12426, 478, 252, 8, 70, "Input",
 CellID->698168409],
Cell[12681, 488, 359, 10, 36, "Output",
 CellID->101988225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13089, 504, 226, 7, 70, "ExampleSection",
 CellID->14952],
Cell[13318, 513, 273, 8, 70, "ExampleText",
 CellID->246043329],
Cell[CellGroupData[{
Cell[13616, 525, 338, 11, 70, "Input",
 CellID->539588314],
Cell[13957, 538, 856, 25, 54, "Output",
 CellID->1509416]
}, Open  ]],
Cell[14828, 566, 245, 8, 70, "ExampleText",
 CellID->702519974],
Cell[CellGroupData[{
Cell[15098, 578, 110, 3, 70, "Input",
 CellID->212244885],
Cell[15211, 583, 363, 10, 36, "Output",
 CellID->140675954]
}, Open  ]],
Cell[15589, 596, 123, 3, 70, "ExampleDelimiter",
 CellID->2447068],
Cell[15715, 601, 149, 4, 70, "ExampleText",
 CellID->417917905],
Cell[CellGroupData[{
Cell[15889, 609, 337, 11, 70, "Input",
 CellID->81525342],
Cell[16229, 622, 368, 10, 36, "Output",
 CellID->53857150]
}, Open  ]],
Cell[CellGroupData[{
Cell[16634, 637, 287, 10, 70, "Input",
 CellID->543622116],
Cell[16924, 649, 372, 7, 70, "Message",
 CellID->379151989],
Cell[17299, 658, 304, 9, 36, "Output",
 CellID->31816517]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17664, 674, 311, 9, 70, "SeeAlsoSection",
 CellID->16601],
Cell[17978, 685, 722, 26, 70, "SeeAlso",
 CellID->22387]
}, Open  ]],
Cell[18715, 714, 27, 0, 70, "History"],
Cell[18745, 716, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

