(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     63372,       2365]
NotebookOptionsPosition[     51049,       1929]
NotebookOutlinePosition[     53261,       1987]
CellTagsIndexPosition[     53083,       1980]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/IntegralTransforms"], 
          "Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integral Transforms\"\>", 
       2->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierSinTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierSinTransform"], 
          "FourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierCosTransform"], 
          "Fourier" :> Documentation`HelpLookup["paclet:ref/Fourier"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "CharacteristicFunction" :> 
          Documentation`HelpLookup["paclet:ref/CharacteristicFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FourierSinTransform\"\>", 
       2->"\<\"FourierCosTransform\"\>", 3->"\<\"Fourier\"\>", 
       4->"\<\"InverseFourierTransform\"\>", 5->"\<\"LaplaceTransform\"\>", 
       6->"\<\"Integrate\"\>", 7->"\<\"Piecewise\"\>", 
       8->"\<\"CharacteristicFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Generalized Functions" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedFunctions"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Generalized Functions\"\>", 3->"\<\"Integral Transforms\"\>", 
       4->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierTransform", "ObjectName",
 CellID->18534],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", "\[Omega]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Omega]", 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox["\[Omega]", 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Fourier transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], 
      SuperscriptBox["e", 
       RowBox[{
       "i", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", "t"}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->26011],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->24196],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18878],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "-", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      SuperscriptBox["e", 
       RowBox[{
       "i", "\[InvisibleSpace]", "b", "\[InvisibleSpace]", "\[Omega]", 
        "\[InvisibleSpace]", "t"}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath",
  ScriptLevel->0],
 ". "
}], "Notes",
 CellID->8035],

Cell[TextData[{
 "Some common choices for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 " (default; modern physics), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " (pure mathematics; systems engineering), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 " (classical physics), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{
     RowBox[{"-", "2"}], 
     ButtonBox["Pi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pi"]}]}], "}"}]], "InlineFormula"],
 " (signal processing). "
}], "Notes",
 CellID->19691],

Cell["The following options can be given:", "Notes",
 CellID->7064],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[
    "assumptions to make about parameters", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FourierParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FourierParameters"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], Cell[
    "parameters to define the Fourier transform", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GenerateConditions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GenerateConditions"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to generate answers that involve conditions on parameters\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16818],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["t", "TI"], ",", "\[Omega]"}], "]"}]], "InlineFormula"],
 " yields an expression depending on the continuous variable ",
 Cell[BoxData["\[Omega]"], "InlineFormula"],
 " that represents the symbolic Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with respect to the continuous variable ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " takes a finite list of numbers as input, and yields as output a list \
representing the discrete Fourier transform of the input. "
}], "Notes",
 CellID->4402],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " is output using ",
 Cell[BoxData["\[ScriptCapitalF]"], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->13494]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181718872],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->382477125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29296],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Cosh", "[", "\[Omega]", "]"}], "+", 
     RowBox[{"Sinh", "[", "\[Omega]", "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Omega]"}], ")"}], "2"]}], "]"}], "-", 
     RowBox[{"Sinh", "[", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Omega]"}], ")"}], "2"]}], "]"}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SqrtBox["2"]}]]], "Output",
 ImageSize->{404, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215462647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2712],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83256670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32121],

Cell[BoxData[
 RowBox[{
  FractionBox["\[ImaginaryI]", 
   RowBox[{
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Omega]"}]], "+", 
  RowBox[{
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}]}]], "Output",
 ImageSize->{192, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->663940486]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23840],

Cell["Elementary functions:", "ExampleText",
 CellID->53795168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77848019],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    RowBox[{"Abs", "[", "\[Omega]", "]"}]}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{82, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->844074725]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"t", "^", "2"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194822829],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}], " ", 
  RowBox[{
   SuperscriptBox["DiracDelta", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{148, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->534722017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"t", "^", "3"}]}], ")"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25734],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"5", "/", "6"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", "+", 
         SqrtBox["3"]}], ")"}], " ", "\[Omega]"}]], " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{"-", "\[Omega]"}], "]"}]}], "+", 
    FractionBox[
     RowBox[{"6", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"5", "/", "6"}]], " ", "\[Omega]"}]], " ", 
      RowBox[{"HeavisideTheta", "[", "\[Omega]", "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}], "2"]], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]"}]], " ", 
     RowBox[{"Sign", "[", "\[Omega]", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{330, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92394270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "t", "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1400],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Sign", "[", "\[Omega]", "]"}]}], ")"}]}], 
   SqrtBox[
    RowBox[{"Abs", "[", "\[Omega]", "]"}]]]}]], "Output",
 ImageSize->{156, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->498291953]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->564391953],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->109947537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "t", "]"}], "^", "2"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->67872223],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "\[Omega]"}], "]"}]}], "+", 
  RowBox[{
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"2", "+", "\[Omega]"}], "]"}]}]}]], "Output",
 ImageSize->{483, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->618145444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1689],

Cell["Special functions:", "ExampleText",
 CellID->18815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4336],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}], "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "+", "\[Omega]"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{217, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258604303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"2", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154387234],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"HeavisideTheta", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Omega]"}], "]"}]}], "+", 
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{"1", "+", "\[Omega]"}], "]"}]}], ")"}]}], 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[Omega]", "2"]}]]]}]], "Output",
 ImageSize->{435, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13213461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26143],

Cell["Piecewise functions and distributions:", "ExampleText",
 CellID->25177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"t", " ", 
    RowBox[{"Sign", "[", "t", "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18523],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox[
    FractionBox["2", "\[Pi]"]], 
   SuperscriptBox["\[Omega]", "2"]]}]], "Output",
 ImageSize->{46, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590912874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", "t", "]"}], " ", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "t"}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182596577],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Cos", "[", "\[Omega]", "]"}]}], "+", 
   RowBox[{"Sin", "[", "\[Omega]", "]"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Omega]"}]]], "Output",
 ImageSize->{137, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53761639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1016000708],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13494,
  ButtonNote->"13494"]
}], "ExampleText",
 CellID->16703465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85101394],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ScriptCapitalF]", "t"], "[", 
    RowBox[{"f", "(", "t", ")"}], "]"}], 
   RowBox[{"(", "\[Omega]", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->126930837]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29149],

Cell["Multidimensional Fourier transform:", "ExampleText",
 CellID->10886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "y"}], ")"}], "^", "6"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10505],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["u", "2"], "4"]}], "-", 
     FractionBox[
      SuperscriptBox["v", "2"], "4"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "120"}], "+", 
     RowBox[{"180", " ", 
      SuperscriptBox["u", "2"]}], "-", 
     RowBox[{"30", " ", 
      SuperscriptBox["u", "4"]}], "+", 
     SuperscriptBox["u", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "120"}], "+", 
     RowBox[{"180", " ", 
      SuperscriptBox["v", "2"]}], "-", 
     RowBox[{"30", " ", 
      SuperscriptBox["v", "4"]}], "+", 
     SuperscriptBox["v", "6"]}], ")"}]}], "8192"]], "Output",
 ImageSize->{377, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617976629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11260],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2038],

Cell[TextData[{
 "The Fourier transform of ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " is a piecewise function:"
}], "ExampleText",
 CellID->320106373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", "t"}], "]"}], ",", " ", "t", ",", "\[Omega]", ",", " ", 
   
   RowBox[{"Assumptions", " ", "\[Rule]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "\[Omega]", "  ", "<", "1"}]}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190547095],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[Omega]", "2"]}]]]}]], "Output",
 ImageSize->{134, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384128365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", "t"}], "]"}], ",", " ", "t", ",", "\[Omega]", ",", " ", 
   
   RowBox[{"Assumptions", " ", "\[Rule]", 
    RowBox[{"\[Omega]", " ", ">", "1"}]}]}], "  ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166519481],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->584389158]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", " ", "t"}], "]"}], ",", " ", "t", ",", "\[Omega]", ",", 
   " ", 
   RowBox[{"Assumptions", " ", "\[Rule]", 
    RowBox[{"\[Omega]", "  ", "<", " ", 
     RowBox[{"-", "1"}]}]}]}], "  ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->196327874],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->253614764]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15513],

Cell["Default modern physics convention:", "ExampleText",
 CellID->2664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36032769],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{133, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436625809]
}, Open  ]],

Cell["Convention for pure mathematics, systems engineering:", "ExampleText",
 CellID->13475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->35031957],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41887756]
}, Open  ]],

Cell["Convention for classical physics:", "ExampleText",
 CellID->20051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259476732],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184241881]
}, Open  ]],

Cell["Convention for signal processing:", "ExampleText",
 CellID->24318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{"1", ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->167356415],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->314590879]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15029],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get parameter conditions for when a result is valid:"
}], "ExampleText",
 CellID->243654745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", " ", "t", ",", " ", "\[Omega]",
    ",", " ", 
   RowBox[{"GenerateConditions", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392464334],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[Omega]", "2"], 
       RowBox[{"4", " ", "a"}]]}]], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["t", "2"]}]], ",", "t", ",", "\[Omega]", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{539, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858725182]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4752],

Cell["The power spectrum of a damped sinusoid:", "ExampleText",
 CellID->12785766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", "^", "3"}], " ", "t"}], "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "t"}], "/", "10"}], "]"}], 
    RowBox[{"UnitStep", "[", "t", "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340551833],

Cell[BoxData[
 FractionBox[
  RowBox[{"50000", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], 
  RowBox[{"100000001", "-", 
   RowBox[{"20", " ", "\[ImaginaryI]", " ", "\[Omega]"}], "-", 
   RowBox[{"100", " ", 
    SuperscriptBox["\[Omega]", "2"]}]}]]], "Output",
 ImageSize->{173, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625272604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Abs", "[", "%", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "1*^-1", ",", "1*^4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129867816],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdlLlFEUv82Mk7u55NJq1L8RPURFhEQP0UP0YBZo5JJpi7bYZvtLPaQQ
+dAC7UZiBAWREAmREAlRQRiEPSRB0oMQfP3Oud+d+eZ810/NsQUbxvvdc7/f
We85517GsvKGyq3V5Q1VFeWlq+rL6yqrKnaWrqytx1J4hlKqC3/VxQpzBzP+
63IcPP1jAcYQAGGiwoTkD08LMaFnsfsMudh8QYfdZ84o6+aZLd6nsQUkTUXi
mpWKClsKBV3s4wgJRG4gQlk4sibEYZOQOaZV0f/+/vf3X/c3Jbbi8kWmsdem
e0bdZ5H7LHESO1++Y++IOaOsezumlyZbIi6t1G3hi7bpjou1UXeFt+ybmiNW
LwSskodtWEyxYuSey+j6ThlftFOnvYSOSy+MBF98J0tzzYWvXulrb+tVo2o5
zfSD7jfHW5/QNM2KOsV07/OPjQ3dNE23ok4aVHPTw5GRHyrDijrB9Lu3X2pr
7g8Pj+gqZBSBjvPbwcFvFZtv0dssq4xWpoeGvldVdgLLteNHHWMaUqAJ+rgC
/aijTMNe+Nb38pOaFYA61PLo8aP3NLWjjjB9/tyzmzde0TTXijrMNCAA0jQv
hqLq1W97nn5AFGmab5XRYqKICFCsC6yogyaaiADFabYVdcBEALIoToUBqHgE
NCrkJN7zcgXXfuFrEXP5q0hWTbag9zGN/YEnjsnuX5DTLPKrZAJyiGwysYId
/a8/6yiNg3+moCOCbhKZkyy5e53Eyp0b2zV5BpEa97DhT8h0fo+0Pcb7TRuv
Uz7NY7h3z5Xy3wY019kzPfc6+2mqufKc+HnqRe8WFs8fBxqbicSNo/PHiMou
pmEOjKLpAseW8Y3G2w3rr6HXqIWJKGQAvqqMBvIOzZz6eRYNKahfJKv+Eq+2
KF4HQpYGqjIayC6vrAw0Aq0L33VrLy9b2g6DMIdONG7ah0xhaWlMOsVsC1Gp
wEE6ZKPTA4YdhDUoAe74nn5Tao1FJYdxYOAr7Ac3WPW5Byawxvm8GSRPPplx
YXNX8WC2sR6YBT3oNXBJ5yBW1qzuoOkirSChKlhK1LvixKvFd5+TWb2daYTS
jUDE0O6ZmHyN1RQF7K3WhERHuidPEymqcRLrQveNFcsvIqJT4xNrjMZqCh+o
hgGLp0gTHEExIC9A6bpyNXky0NzV5V1bSqxlvbGzTbdhpeXJStDYmJ84M+kc
CMLqOGAKe6k6A7AReIU8BwrjEiuujmmUL+oOowpCIaHhCzWoOIr838Fv4QCs
R5IHykCawm5gA1GIB/oStasgFGoKKIwuyrs/tk5h6xBaEpxPkMQ76s+xhBXr
TdwnGU0yKZKJ9Eqk1p5sW5FZUyQZp8VvkmxyQNaqrFEvN1WcPc90ZgMCIE3t
tTZ9URmOveJslWaXkO7bd3knk7InI4dsrZ8EfzjW7f6sH+PfGVMHMv//lgya
DijzX4/xVUTBL+23jWv0bE2ejqniMr972vMWtwz35mnfh6DfIe2rasZPJICg
ng==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183691410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11388],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->31157007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], "]"}], ",", 
   " ", "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70250391],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161977038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", " ", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], 
    "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50546575],

Cell[BoxData[
 RowBox[{"g", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11206956]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    RowBox[{"Abs", "[", "\[Omega]", "]"}]}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{82, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->234096817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", " ", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->63032382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812614804],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierCosTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierCosTransform"]], "InlineFormula"],
 " are equal for even functions:"
}], "ExampleText",
 CellID->706195156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333107711],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58970850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", " ", "\[Omega]"}], " ", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352411717],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Omega]", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127351669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134077371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 " differ by ",
 Cell[BoxData["\[ImaginaryI]"], "InlineFormula"],
 " for odd functions:"
}], "ExampleText",
 CellID->758502932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"t", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "t", "]"}]}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18103367],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"]]], "Output",
 ImageSize->{60, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12383392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"t", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"Abs", "[", "t", "]"}]}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->273594666],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"]]], "Output",
 ImageSize->{70, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148168621]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18147],

Cell["\<\
The result from an inverse Fourier transform may not have the same form as \
the original:\
\>", "ExampleText",
 CellID->17690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"1", "+", "t"}], "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"1", "-", "t"}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30908],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sin", "[", "\[Omega]", "]"}]}], "\[Omega]"]], "Output",
 ImageSize->{84, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309008951]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3394],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "t"}], "]"}], "+", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "+", "t"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{182, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137219983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->632],

Cell["\<\
The Fourier transforms of weighted Hermite polynomials have a very simple \
form:\
\>", "ExampleText",
 CellID->113561636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], "]"}], 
    RowBox[{"HermiteH", "[", 
     RowBox[{"10", ",", "t"}], "]"}]}], ",", " ", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427428655],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[Omega]", "2"], "4"]}]], " ", 
    SuperscriptBox["\[Omega]", "10"]}], 
   SqrtBox["2"]]}]], "Output",
 ImageSize->{63, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373810976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFourierTransform", "[", 
   RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}], "//", "Factor"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->176873899],

Cell[BoxData[
 RowBox[{"32", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox["t", "2"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "945"}], "+", 
    RowBox[{"9450", " ", 
     SuperscriptBox["t", "2"]}], "-", 
    RowBox[{"12600", " ", 
     SuperscriptBox["t", "4"]}], "+", 
    RowBox[{"5040", " ", 
     SuperscriptBox["t", "6"]}], "-", 
    RowBox[{"720", " ", 
     SuperscriptBox["t", "8"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["t", "10"]}]}], ")"}]}]], "Output",
 ImageSize->{364, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415459003]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16347],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacteristicFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30427]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19921],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralTransforms"]], "Tutorials",
 CellID->2681],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->17353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->302611896],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->411120533],

Cell[TextData[ButtonBox["Generalized Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedFunctions"]], "MoreAbout",
 CellID->737029309],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->953763144],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->728398138]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 7.7983038}", "context" -> "System`", 
    "keywords" -> {
     "distribution", "Fourier transform", "frequency dimension", 
      "function transform", "integral operator", "integral transform", 
      "Integrate", "inverse Fourier transform", "power spectrum", "spectrum", 
      "transform"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "FourierTransform[expr, t, \\[Omega]] gives the symbolic Fourier \
transform of expr. FourierTransform[expr, {t_1, t_2, ...}, {\\[Omega]_1, \
\\[Omega]_2, ...}] gives the multidimensional Fourier transform of expr. ", 
    "synonyms" -> {"fourier transform"}, "title" -> "FourierTransform", 
    "type" -> "Symbol", "uri" -> "ref/FourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11843, 374, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->181718872]},
 "Ex--22034558506017011754,4"->{
  Cell[38537, 1425, 299, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[38839, 1437, 355, 12, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->234096817]},
 "Ex--22034558506017011754,5"->{
  Cell[39231, 1454, 205, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[39439, 1461, 266, 9, 52, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->63032382]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52440, 1959},
 {"Ex--22034558506017011754,4", 52594, 1963},
 {"Ex--22034558506017011754,5", 52845, 1970}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3273, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3896, 97, 54, 1, 70, "ObjectName",
 CellID->18534],
Cell[3953, 100, 1608, 49, 70, "Usage",
 CellID->20201]
}, Open  ]],
Cell[CellGroupData[{
Cell[5598, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6076, 171, 687, 24, 70, "Notes",
 CellID->26011],
Cell[6766, 197, 109, 3, 70, "Notes",
 CellID->24196],
Cell[6878, 202, 259, 8, 70, "Notes",
 CellID->18878],
Cell[7140, 212, 1177, 40, 70, "Notes",
 CellID->8035],
Cell[8320, 254, 842, 32, 70, "Notes",
 CellID->19691],
Cell[9165, 288, 67, 1, 70, "Notes",
 CellID->7064],
Cell[9235, 291, 1173, 31, 70, "3ColumnTableMod",
 CellID->16818],
Cell[10411, 324, 935, 27, 70, "Notes",
 CellID->4402],
Cell[11349, 353, 457, 16, 70, "Notes",
 CellID->13494]
}, Closed]],
Cell[CellGroupData[{
Cell[11843, 374, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->181718872],
Cell[CellGroupData[{
Cell[12228, 388, 148, 5, 70, "ExampleSection",
 CellID->382477125],
Cell[CellGroupData[{
Cell[12401, 397, 287, 10, 28, "Input",
 CellID->29296],
Cell[12691, 409, 835, 28, 63, "Output",
 CellID->215462647]
}, Open  ]],
Cell[13541, 440, 120, 3, 70, "ExampleDelimiter",
 CellID->2842],
Cell[CellGroupData[{
Cell[13686, 447, 147, 4, 28, "Input",
 CellID->2712],
Cell[13836, 453, 264, 9, 38, "Output",
 CellID->83256670]
}, Open  ]],
Cell[CellGroupData[{
Cell[14137, 467, 193, 6, 28, "Input",
 CellID->32121],
Cell[14333, 475, 397, 14, 61, "Output",
 CellID->663940486]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14779, 495, 216, 7, 70, "ExampleSection",
 CellID->23840],
Cell[14998, 504, 63, 1, 70, "ExampleText",
 CellID->53795168],
Cell[CellGroupData[{
Cell[15086, 509, 256, 9, 70, "Input",
 CellID->77848019],
Cell[15345, 520, 314, 11, 60, "Output",
 CellID->844074725]
}, Open  ]],
Cell[CellGroupData[{
Cell[15696, 536, 176, 5, 70, "Input",
 CellID->194822829],
Cell[15875, 543, 354, 12, 38, "Output",
 CellID->534722017]
}, Open  ]],
Cell[CellGroupData[{
Cell[16266, 560, 253, 9, 70, "Input",
 CellID->25734],
Cell[16522, 571, 1470, 46, 106, "Output",
 CellID->92394270]
}, Open  ]],
Cell[CellGroupData[{
Cell[18029, 622, 207, 7, 70, "Input",
 CellID->1400],
Cell[18239, 631, 501, 18, 65, "Output",
 CellID->498291953]
}, Open  ]],
Cell[CellGroupData[{
Cell[18777, 654, 232, 8, 70, "Input",
 CellID->564391953],
Cell[19012, 664, 304, 11, 68, "Output",
 CellID->109947537]
}, Open  ]],
Cell[CellGroupData[{
Cell[19353, 680, 210, 7, 70, "Input",
 CellID->67872223],
Cell[19566, 689, 650, 23, 60, "Output",
 CellID->618145444]
}, Open  ]],
Cell[20231, 715, 120, 3, 70, "ExampleDelimiter",
 CellID->1689],
Cell[20354, 720, 57, 1, 70, "ExampleText",
 CellID->18815],
Cell[CellGroupData[{
Cell[20436, 725, 182, 6, 70, "Input",
 CellID->4336],
Cell[20621, 733, 429, 15, 60, "Output",
 CellID->258604303]
}, Open  ]],
Cell[CellGroupData[{
Cell[21087, 753, 215, 7, 70, "Input",
 CellID->154387234],
Cell[21305, 762, 740, 26, 87, "Output",
 CellID->13213461]
}, Open  ]],
Cell[22060, 791, 121, 3, 70, "ExampleDelimiter",
 CellID->26143],
Cell[22184, 796, 77, 1, 70, "ExampleText",
 CellID->25177],
Cell[CellGroupData[{
Cell[22286, 801, 208, 7, 70, "Input",
 CellID->18523],
Cell[22497, 810, 268, 10, 77, "Output",
 CellID->590912874]
}, Open  ]],
Cell[CellGroupData[{
Cell[22802, 825, 296, 9, 70, "Input",
 CellID->182596577],
Cell[23101, 836, 408, 13, 55, "Output",
 CellID->53761639]
}, Open  ]],
Cell[23524, 852, 126, 3, 70, "ExampleDelimiter",
 CellID->1016000708],
Cell[23653, 857, 308, 11, 70, "ExampleText",
 CellID->16703465],
Cell[CellGroupData[{
Cell[23986, 872, 223, 7, 70, "Input",
 CellID->85101394],
Cell[24212, 881, 351, 11, 50, "Output",
 CellID->126930837]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24612, 898, 239, 7, 70, "ExampleSection",
 CellID->29149],
Cell[24854, 907, 74, 1, 70, "ExampleText",
 CellID->10886],
Cell[CellGroupData[{
Cell[24953, 912, 507, 18, 70, "Input",
 CellID->10505],
Cell[25463, 932, 866, 30, 66, "Output",
 CellID->617976629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26378, 968, 218, 7, 70, "ExampleSection",
 CellID->11260],
Cell[CellGroupData[{
Cell[26621, 979, 227, 7, 70, "ExampleSubsection",
 CellID->2038],
Cell[26851, 988, 230, 8, 70, "ExampleText",
 CellID->320106373],
Cell[CellGroupData[{
Cell[27106, 1000, 363, 11, 70, "Input",
 CellID->190547095],
Cell[27472, 1013, 510, 18, 87, "Output",
 CellID->384128365]
}, Open  ]],
Cell[CellGroupData[{
Cell[28019, 1036, 324, 9, 70, "Input",
 CellID->166519481],
Cell[28346, 1047, 158, 5, 36, "Output",
 CellID->584389158]
}, Open  ]],
Cell[CellGroupData[{
Cell[28541, 1057, 356, 10, 70, "Input",
 CellID->196327874],
Cell[28900, 1069, 158, 5, 36, "Output",
 CellID->253614764]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29107, 1080, 234, 7, 70, "ExampleSubsection",
 CellID->15513],
Cell[29344, 1089, 72, 1, 70, "ExampleText",
 CellID->2664],
Cell[CellGroupData[{
Cell[29441, 1094, 151, 4, 70, "Input",
 CellID->36032769],
Cell[29595, 1100, 265, 9, 38, "Output",
 CellID->436625809]
}, Open  ]],
Cell[29875, 1112, 92, 1, 70, "ExampleText",
 CellID->13475],
Cell[CellGroupData[{
Cell[29992, 1117, 275, 8, 70, "Input",
 CellID->35031957],
Cell[30270, 1127, 238, 7, 36, "Output",
 CellID->41887756]
}, Open  ]],
Cell[30523, 1137, 72, 1, 70, "ExampleText",
 CellID->20051],
Cell[CellGroupData[{
Cell[30620, 1142, 276, 8, 70, "Input",
 CellID->259476732],
Cell[30899, 1152, 201, 6, 36, "Output",
 CellID->184241881]
}, Open  ]],
Cell[31115, 1161, 72, 1, 70, "ExampleText",
 CellID->24318],
Cell[CellGroupData[{
Cell[31212, 1166, 300, 9, 70, "Input",
 CellID->167356415],
Cell[31515, 1177, 201, 6, 36, "Output",
 CellID->314590879]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31765, 1189, 235, 7, 70, "ExampleSubsection",
 CellID->15029],
Cell[32003, 1198, 365, 12, 70, "ExampleText",
 CellID->243654745],
Cell[CellGroupData[{
Cell[32393, 1214, 368, 12, 70, "Input",
 CellID->392464334],
Cell[32764, 1228, 773, 26, 69, "Output",
 CellID->858725182]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33598, 1261, 222, 7, 70, "ExampleSection",
 CellID->4752],
Cell[33823, 1270, 82, 1, 70, "ExampleText",
 CellID->12785766],
Cell[CellGroupData[{
Cell[33930, 1275, 383, 13, 70, "Input",
 CellID->340551833],
Cell[34316, 1290, 400, 13, 78, "Output",
 CellID->625272604]
}, Open  ]],
Cell[CellGroupData[{
Cell[34753, 1308, 315, 9, 70, "Input",
 CellID->129867816],
Cell[35071, 1319, 1742, 33, 70, "Output",
 Evaluatable->False,
 CellID->183691410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36862, 1358, 233, 7, 70, "ExampleSection",
 CellID->11388],
Cell[37098, 1367, 372, 12, 70, "ExampleText",
 CellID->31157007],
Cell[CellGroupData[{
Cell[37495, 1383, 289, 8, 70, "Input",
 CellID->70250391],
Cell[37787, 1393, 185, 6, 36, "Output",
 CellID->161977038]
}, Open  ]],
Cell[CellGroupData[{
Cell[38009, 1404, 297, 8, 70, "Input",
 CellID->50546575],
Cell[38309, 1414, 191, 6, 36, "Output",
 CellID->11206956]
}, Open  ]],
Cell[CellGroupData[{
Cell[38537, 1425, 299, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[38839, 1437, 355, 12, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->234096817]
}, Open  ]],
Cell[CellGroupData[{
Cell[39231, 1454, 205, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[39439, 1461, 266, 9, 52, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->63032382]
}, Open  ]],
Cell[39720, 1473, 125, 3, 70, "ExampleDelimiter",
 CellID->812614804],
Cell[39848, 1478, 374, 12, 70, "ExampleText",
 CellID->706195156],
Cell[CellGroupData[{
Cell[40247, 1494, 232, 8, 70, "Input",
 CellID->333107711],
Cell[40482, 1504, 303, 11, 68, "Output",
 CellID->58970850]
}, Open  ]],
Cell[CellGroupData[{
Cell[40822, 1520, 245, 8, 70, "Input",
 CellID->352411717],
Cell[41070, 1530, 304, 11, 68, "Output",
 CellID->127351669]
}, Open  ]],
Cell[41389, 1544, 125, 3, 70, "ExampleDelimiter",
 CellID->134077371],
Cell[41517, 1549, 429, 14, 70, "ExampleText",
 CellID->758502932],
Cell[CellGroupData[{
Cell[41971, 1567, 268, 9, 70, "Input",
 CellID->18103367],
Cell[42242, 1578, 364, 13, 83, "Output",
 CellID->12383392]
}, Open  ]],
Cell[CellGroupData[{
Cell[42643, 1596, 266, 9, 70, "Input",
 CellID->273594666],
Cell[42912, 1607, 387, 13, 83, "Output",
 CellID->148168621]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43348, 1626, 226, 7, 70, "ExampleSection",
 CellID->18147],
Cell[43577, 1635, 137, 4, 70, "ExampleText",
 CellID->17690],
Cell[CellGroupData[{
Cell[43739, 1643, 296, 10, 70, "Input",
 CellID->30908],
Cell[44038, 1655, 286, 10, 76, "Output",
 CellID->309008951]
}, Open  ]],
Cell[CellGroupData[{
Cell[44361, 1670, 154, 4, 70, "Input",
 CellID->3394],
Cell[44518, 1676, 367, 13, 51, "Output",
 CellID->137219983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44934, 1695, 222, 7, 70, "ExampleSection",
 CellID->632],
Cell[45159, 1704, 132, 4, 70, "ExampleText",
 CellID->113561636],
Cell[CellGroupData[{
Cell[45316, 1712, 323, 11, 70, "Input",
 CellID->427428655],
Cell[45642, 1725, 389, 14, 68, "Output",
 CellID->373810976]
}, Open  ]],
Cell[CellGroupData[{
Cell[46068, 1744, 191, 6, 70, "Input",
 CellID->176873899],
Cell[46262, 1752, 658, 22, 43, "Output",
 CellID->415459003]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46981, 1781, 311, 9, 70, "SeeAlsoSection",
 CellID->16347],
Cell[47295, 1792, 2041, 71, 70, "SeeAlso",
 CellID->30427]
}, Open  ]],
Cell[CellGroupData[{
Cell[49373, 1868, 314, 9, 70, "TutorialsSection",
 CellID->19921],
Cell[49690, 1879, 147, 3, 70, "Tutorials",
 CellID->2681],
Cell[49840, 1884, 194, 4, 70, "Tutorials",
 CellID->17353]
}, Open  ]],
Cell[CellGroupData[{
Cell[50071, 1893, 319, 9, 70, "MoreAboutSection",
 CellID->302611896],
Cell[50393, 1904, 128, 3, 70, "MoreAbout",
 CellID->411120533],
Cell[50524, 1909, 153, 3, 70, "MoreAbout",
 CellID->737029309],
Cell[50680, 1914, 149, 3, 70, "MoreAbout",
 CellID->953763144],
Cell[50832, 1919, 145, 3, 70, "MoreAbout",
 CellID->728398138]
}, Open  ]],
Cell[50992, 1925, 27, 0, 70, "History"],
Cell[51022, 1927, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

