(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    167095,       3801]
NotebookOptionsPosition[    156525,       3425]
NotebookOutlinePosition[    157764,       3461]
CellTagsIndexPosition[    157677,       3456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerPart" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPart"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"IntegerPart\"\>", 2->"\<\"Mod\"\>", 
       3->"\<\"Floor\"\>", 4->"\<\"Ceiling\"\>", 
       5->"\<\"Round\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FractionalPart", "ObjectName",
 CellID->9341],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FractionalPart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FractionalPart"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the fractional part of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " in effect takes all digits to the right of the decimal point and drops the \
others. "
}], "Notes",
 CellID->30959],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    StyleBox["x", "TI"], "]"}], "+", 
   RowBox[{
    ButtonBox["IntegerPart",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IntegerPart"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 " is always exactly ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7139],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " yields a result when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is any numeric quantity, whether or not it is an explicit number. "
}], "Notes",
 CellID->16892],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10553],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " applies separately to real and imaginary parts of complex numbers."
}], "Notes",
 CellID->124085891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69560201],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->559520252],

Cell["Find the fractional part of a real number:", "ExampleText",
 CellID->20717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", "2.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12446],

Cell[BoxData["0.3999999999999999`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679671612]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28606],

Cell["Use exact numeric quantities:", "ExampleText",
 CellID->25151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"Pi", "^", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "8769956796"}], "+", 
  SuperscriptBox["\[Pi]", "20"]}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146783820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->19423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.5", ",", "2.6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3999999999999999`", ",", "0.5`", ",", "0.6000000000000001`"}], 
  "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668995702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11591],

Cell[TextData[{
 "Manipulate ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->23068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", "x", "]"}], "+", 
    RowBox[{"FractionalPart", "[", 
     RowBox[{"x", "+", 
      RowBox[{"1", "/", "2"}]}], "]"}]}], ",", " ", 
   RowBox[{"0", "<", "x", "<", 
    RowBox[{"1", "/", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6908],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{45, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128525092]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FractionalPart", "[", "x", "]"}], "+", 
      RowBox[{"FractionalPart", "[", 
       RowBox[{
        RowBox[{"2", "x"}], "-", "1"}], "]"}]}], "==", "0"}], "&&", 
    RowBox[{"0", "<", "x", "<", "4"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16709],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   FractionBox["1", "3"]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "3"}]}]], "Output",
 ImageSize->{191, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->747323442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->710],

Cell["Evaluate an integral:", "ExampleText",
 CellID->3745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31562],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "12"}], "+", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}], "+", 
  SqrtBox["3"], "+", 
  SqrtBox["5"], "+", 
  SqrtBox["6"], "+", 
  SqrtBox["7"]}]], "Output",
 ImageSize->{219, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263297960]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101516778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->595153280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FractionalPart", "[", "x", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->649745621],

Cell[BoxData[
 FormBox[
  RowBox[{"frac", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->25632638]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2310],

Cell["Negative numbers:", "ExampleText",
 CellID->195120443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.4"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "3.0"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506251593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.3999999999999999`"}], ",", 
   RowBox[{"-", "0.5`"}], ",", "0.`"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88594855]
}, Open  ]],

Cell["Complex numbers:", "ExampleText",
 CellID->24486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"4", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", "I"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8493],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "5"], "-", 
  FractionBox["\[ImaginaryI]", "5"]}]], "Output",
 ImageSize->{40, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228660383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27046229],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->85316167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143897065],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639957986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605917267],

Cell["Series expansion:", "ExampleText",
 CellID->99506518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", " ", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56743205],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWMlOIzEQNb0k7BDWwAwJIMRyQdxZgkajmRMfESEkOMyAgH+AvwUOnI3d
scF5XXa5G25ESrufXS6XX1e1X3LWv7+8+Ne/vzrvr/+97d9cXp3frf+5vlVd
6YgQ4lV9N9pC3Ut1V3xfpVTtqr6mGhefEl4E/ANwV10SBTum/V14XQGrn4Dn
Aa8B7jD4V7HKpLrmqrOpUfY+aiJJTDttrDLw0aSw18uMx8sk4Ia6aJjXimnH
zE7NeGrsixsx+GgfmWkHA5ldL3fXE5YZx38yHJW6aYFFFEtBj3OMR2SMjhxn
VY98F3DKYPt8Sj5LlsjBKOE5MezrjTWYSHPp5HHAD46jn3FjF8do1Sij+Cyt
GscoMuhjgsstLlutH3z/fE2OxkZZn8l8qO7dOWOA8Wl+98pPrGc6Q+neEsvj
1A68b/lZJs5WcDa3S22n4YyfxdqRWbstT78pYzEYcT2n8uMEK/PXIGPF6l8C
jF6wepcZe8QBxgJecRxxZ5hx4t23QHLSNIxhbi1IJ2sDimzRY5cTu7bKRNsv
mzZ3WlR2TQWXyKivAfcAH5Kz/jtYc34C+DhqrRPAR+Ssp6LX5uXLO3JtngO9
tD/s3QGM+hifFurrronPtgfkKtuAUS9jRaDeRv3cBbxPrqqr1ac7eN3tU8zV
dLdPKU8B1tnL625fTC2ww9PU7pg+FTj1Qp87nz9Pq5/Q3JmCrNKR8yc0F/lc
acaoh/k4xq2CxncYp8w5Rc0p81CFuHhCOnlXWZlz3ucde91O1OIQV0EFWVdL
x2pyLmfq5WZslJbDMfmZPOT2yqvy71TzqHhIdljOcd3wCcCxEdbkMbpZwzqa
PEbva7spmIf7j2NtmowQrThljVXFKfd6SrzNMIN408tIZt7Zlm9Kd/v0NCo5
nz7ndHdbhnX3putXPMLoKeBCf4oHp1cz2AO8R/rqAS5+N4vB/8Ji5A1UZskB
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{245, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39905045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25419],

Cell["Plot fractional parts of powers:", "ExampleText",
 CellID->426214396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}], "^", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31902],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw11A1MU1cUB/CXRiZb6EaAbC4Y2rlpjEM+FNSpkzNhtNCWftJWF1fC2hlT
ZVs2dTqzvHXLgAa3wT5c1nUkZlPZBFmYBCfEF77EiikpLoCCbgiMzAImGgzg
uvW9/m+T5uaXc07fuafv3ufK3zK5ZBzHOaNfcY197uXF1j+xchRbBuB4eBhO
hJvhFPgOvAIegVfCrbAyZuUEvCrmslH4hZjVk/CamIdvw2tjHv8bXhfzIHt+
umS+fQbOkCx8F4azJCun/4GzJZe1sf1ukKz2svyNkvcHWX6O5IIKlp8rucXE
8jeJ5hOOsfzNooWk31m/W6T8v9ra4Zek+BlvD7xVtPq/5Gl4m+jmpcMCvF10
eSR9Cn5ZdNbI5h/hHaL7esxNcF7UgvfG0DhMUSsHLuejX150VtsvLtbvK1Gr
v/roW/TLi97/eqeTzXdn1AWpqowbiIt+13L+JIvnE8efjTz1HubPRy3IIs9k
sPkUEEfxiyrvdcSjLkt46A7eQvxV4tRFC1+ksudHHZ45uKuB9V9I3PhE1mOR
u4hHfaqpLmlxEHEV8Y9ks8eXZhFXkXB02aTlCMypid6Wn4u4byKuJsGwVv4o
vxPxIlIeaU9edF1FvIiGd1/77IMa9MsVU0F8jvVCCP3yxdS/4ntZ+vv9iGtI
W73IJzZinryGpnxznuzl7H3RUvi3jatccWz+WupO872Zmch+X0fJtgc1zyfM
Ia4jv6fCnFvH+i+hu12r/9XfZPMtoU7NOw/natl509Px3tP99e4LiOtp60HH
/Ppudt4MdM6Rdqdai/7JQE8qXmvwTwaQb6CfXvQoUp9G/4KBbsfJO05+wvZn
pL3dV+RH3/gD9UbSmW1e3xO4P3gjTS/E1YcU2K9gpNH5qtmLmez+MNG6K7kn
9qb9inoTXWocKPc1sn5NpPes9Obs7EK9iW41B1oGt7DzYyZnMX8g3ID7hMx0
X15lGc3D/ngzhVP6Pww4MC/BTD07nMccCvzfnIVSMjX+ShvyyUL+3ntuzcfs
fbHQsDmUP16NfMFCVUuHrp7ys/ejlMw/aGvSlnD+qJQm3Ce+rOhpQX0pbXOe
vbjsPM6DUEr2bzzPVn7O7iMrPd5Vqf26CfMgKxWGXAtzHrzfvJUGD2WHg1VD
qLfSdK0x6dK+n1Fvo4r1HTp9EM8jG63u9j2Yb+1AvY0u54zpSupwfwo2qg3c
37Bn7FPU22lmaNNU3Jpa1NtJURco7LvG/j877Wl1XLfvC6HeTr19qnpZkPW/
i0y7h8aWHxjJ+x+2Up1W
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 100.}, {0., 0.9702317955986665}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22371945]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"FractionalPart", "[", 
       RowBox[{"GoldenRatio", "^", "n"}], "]"}], ",", "20"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->735088560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTtv1EAQ3svavgNOggIhGsgRiV+QQBeBhICKElGfIkSugKCQnwENggJE
Fx4FBQUSFAghFPGITiISFW34I2Zm1/bsrcd7a9+ROBef5N3Z8TePXX87Wvtu
9DdWb9/tbwxW+r3r6/37q4OVB71ra+ugki0hxC5cj08LkGOQ1LUbx9Dn20Vo
AwDMQT8H/QJqURGnP9SeS3pZMJ6HXhpepNELsYRtqH1mrcIKmUVSPozIDOIM
NpGJmAKuMGKaIy5oC3ulu+CVJQJEmMVOvM3XIP+LDCLn074/EsN3FmcTDhR4
mHLe7mhyoplUWefFiVepF9OuyZR7ypWleHQ387VhwZhBUW2wawLVBrMWnbBy
/sVqT2Gz+erlzqXlZ48ebsGokWdY1jw9Nh7XUWzpQvs7Y5fNnbY1DrB5Sz6E
uHXzNchXr7yAO9s//67de//xwx8tw91MNvVahrusvrGtv23CMbhd5BdkrJEd
f1a1WSblbM9POI7YjI6qDMx9Qhl8LraQWc7iqwNFvgiFFX2HteGreBmtmqOk
XfrNgaIZuFA0A0L9zxmM01aLnRQ59ZMGQo3hCnirkVNAaNn52EQWRnrY2HsE
dxwOfbHj/Ku88xrnmkXJyodsPOLbNvsMNIr45kIR3wh18PhWv9i5HZA7L9vP
dlp8RnYFnvvFxKQ5FXE/jHlOVsAaa2PvKH6Gh5VFtWKwWTs8eeBd+zysinhZ
PYZMZ4FvqbqoDu6806V1yNjYMw5SW11qLy8/1wV3mFu/dvJsMgtddp8++a6L
73Dfn/ZhjX1QWF6m+k4zn2rnFJ8nqG3oLPODtdE50FnGhaKzDI+qKwdtbcda
mS0HilaGUJjbEWtFeB98/K4V/4tBh/Rnn3w5FnStDLUf21LRyck75adtvvdS
bp8q+lRzfmO+Ce/796RG3svvdsfL2UQleIYAzS+TsybXGnmG5YRf5WzK8MtE
nMRm0/HdsZFnSU64Vc6mKrfKnvfy/+GL1j891zS8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->318977616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331911171],

Cell["Plot fractional parts of powers of a Pisot number:", "ExampleText",
 CellID->396262046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", "#1", "+", 
          RowBox[{"#1", "^", "3"}]}], "&"}], ",", "1"}], "]"}], "^", "n"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120406062],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1FlIVHEUx/GTuRUtWoIDFU0LNolZrpmW/rUabXXXsYYaqilLQakeCjUu
CEU9RFFEC0gvWtE8WLT4EHlBqSgxlyksrKaFaFULpAHb7v/+f2egBobhM997
/udyYWbOtpoidxAR7TDe8lO9RrLiTl7vX/TAm4UvxIMSa8rogg9wuFjyT48Q
9Lnrh8t1A476zxYx8qg50u57Bs9E74StQg89l7/F/xKeK3TrPXtG+Bt4vrDe
bXfnnn4HxwjKif3YYr8M2wTVR1+fuPchHCu0bUXea5b3cJzQQhNSn2f3wPFC
yx7Qkm9+gZcIer9nuGnZEJwgKKqj5rCjA04UZFtZ2z/0CU4S5HixKfhQG5ws
aChp0mjnMJwiyNs0dur3VzhVUE/9HU/zLXipoM6+sKMd3NMEUbc7cfd5eJnh
9V/6w07B6YLSxl3oO8P3l2H0yQsb21rg5YIubk+PXMz7VxhdO1H9NBHONHyi
aVExn5clSB8Nq07g64XRvQVHmtA1w+LT/pAu7tmCtPocVzesGSYxWJV5DD3H
8K7b7vPcpemH31OHvlJaTx1LR5cuvdLey+evkn27x9mALh0fMfsJ99WypwV/
d6Cb/tDbuhXdLp/XtLOveb80WaoKq9FzDefV1X7jLu1q+PiLz88z76+rcTO6
dKu/Ypj7GrPfLytHl7a+mhGYXyuftzNkjM+XJjp8vBB9nWE9Y46f+zqzkzsT
fb1p39RZ6KYHv/J5tMHs9d4cdNPOpz+5bzS7tjUKXVm/bUPPl3Yc5PvV8lXf
l4BeID0Q/AddKF9iawXqflPmKeumWz2/eX+h6jtnYN50hC8wb9p3hK3j+spo
zBeZrgzsV6Yewjysf8tUn6a1q3w9FaNPwLzy48B+dHqLefaYMpWYfhPYr0xa
EOaVpxj/i2pe2cKmUpw3EfPKNu4a9+mYV3YF5stMH2CLMlwfg3llX2A/9yTM
l8P4fQllaxDv527HvLI+nvc7VA/h/TA5MQ9P4P3cKzFfoRwxkvUX06ZNIA==

     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 100.}, {0., 1.00390625}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->790001769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->654867703],

Cell["Iterate the shift map with a rational initial condition:", "ExampleText",
 CellID->207147698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"2", "#"}], "]"}], "&"}], ",", 
   RowBox[{"1", "/", "11"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187284816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "11"], ",", 
   FractionBox["2", "11"], ",", 
   FractionBox["4", "11"], ",", 
   FractionBox["8", "11"], ",", 
   FractionBox["5", "11"], ",", 
   FractionBox["10", "11"], ",", 
   FractionBox["9", "11"], ",", 
   FractionBox["7", "11"], ",", 
   FractionBox["3", "11"], ",", 
   FractionBox["6", "11"], ",", 
   FractionBox["1", "11"]}], "}"}]], "Output",
 ImageSize->{330, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472832085]
}, Open  ]],

Cell["Irrational initial condition:", "ExampleText",
 CellID->386930541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionalPart", "[", 
      RowBox[{"2", "#"}], "]"}], "&"}], ",", 
    RowBox[{"Pi", "/", "4"}], ",", "10"}], "]"}], "//", "Expand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->796981175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "4"], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    RowBox[{"2", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "12"}], "+", 
    RowBox[{"4", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "25"}], "+", 
    RowBox[{"8", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "50"}], "+", 
    RowBox[{"16", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "100"}], "+", 
    RowBox[{"32", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "201"}], "+", 
    RowBox[{"64", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "402"}], "+", 
    RowBox[{"128", " ", "\[Pi]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "804"}], "+", 
    RowBox[{"256", " ", "\[Pi]"}]}]}], "}"}]], "Output",
 ImageSize->{402, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200475789]
}, Open  ]],

Cell["\<\
See the degradation in precision for approximate real numbers:\
\>", "ExampleText",
 CellID->202213467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"2", "#"}], "]"}], "&"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "4"}], ",", "8"}], "]"}], ",", "30"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->420602787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7853981633974483096`8.", ",", "0.5707963267948966193`7.560361292636983", 
   ",", "0.1415926535897932385`6.6538908482572054", ",", 
   "0.283185307179586477`6.6538908482572054", ",", 
   "0.5663706143591729541`6.6538908482572054", ",", 
   "0.1327412287183459081`5.722765973682684", ",", 
   "0.2654824574366918162`5.722765973682684", ",", 
   "0.5309649148733836324`5.722765973682684", ",", 
   "0.0619298297467672648`4.488570039400642", ",", 
   "0.1238596594935345296`4.488570039400642", ",", 
   "0.2477193189870690593`4.488570039400642", ",", 
   "0.4954386379741381186`4.488570039400642", ",", 
   "0.9908772759482762371`4.488570039400642", ",", 
   "0.9817545518965524742`4.183523098551834", ",", 
   "0.9635091037931049485`3.874346001815222", ",", 
   "0.9270182075862098969`3.556548447890414", ",", 
   "0.8540364151724197939`3.2199065769324715", ",", 
   "0.7080728303448395877`2.8374781226208707", ",", 
   "0.4161456606896791754`2.3056155671197085", ",", 
   "0.8322913213793583509`2.3056155671197085", ",", 
   "0.6645826427587167018`1.9068591997561983", ",", 
   "0.3291652855174334036`1.3006942370105807", ",", 
   "0.6583305710348668072`1.3006942370105807", ",", 
   "0.3166611420697336143`0.6818149921223131", ",", 
   "0.6333222841394672287`0.6818149921223131", ",", 
   "0.2666445682789344573`0.005092968285848713", ",", 
   "0.5332891365578689147`0.00509296828584868", ",", 
   "0``-0.022899764326252636", ",", "0``-0.3239297599902338", ",", 
   "0``-0.624959755654215", ",", "0``-0.9259897513181963"}], "}"}]], "Output",\

 ImageSize->{573, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->264791406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252733927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    RowBox[{"x", "+", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->627109056],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1nUmodEcVxzs9vn5DvyGaAWO+L4PGOA8kWYkLJ0SiRI1xXHwJQrJIojG6
0I1udGNc6MaAmIUDOCwShIgQQQyIATEgBkRF+QSJC4NgcBEQrnXvqb7/ql+d
6tvviUGTV933VtX515n+p+revvXCg3d/4t4LD95z14Xz73zgwifvvueuT59/
x/0PhI8ml4xGo4vh/1+9YhT+bsJf3f8vNk3476faf0/advfP6N4Nn36s/ffi
qV/99fOf++nb3/rNt7z54Xe/65EvfuGJp3/zt9EqfDcON9zXXfmR9t97zz//
wmcefDz878lf/OWFF/4TPguf/OyJP91/349DD+Hv0b47zoe7T5999l933fmj
MNpo0bVDJ6EdPh3tuXd9qPv04sV/xqvmcUajWfgjfBBGtVtG0/hh2ccd3adh
Zkkfo31d1f1hE3vuuX/3n1T7+2A3XJA9gBBQCq127PF6En2v3SezcEWYZP9h
N3rbpfoaP/KtX+8Ud0+6ux/+xlPf/c7Tutuf0e3dp8/87u/33P1o+2fZ27T7
JEj4xz/8Y5NsH+g+DbKFnsKlo2Wlp/BHuCJcN9DTD3/w269/7Zftn7tx5ebJ
f8u73r8e/47bvxcWY3Rp1w5/ffyj3291yx/L7gpABbjaP18UUZ1l+vu+dV+h
73bmL163beFNsqJvuysIEURp/7wMck3cu26DHJevdfC29367Hdu/a60b10Sd
Oh/b6XhXYD5j9HR1vOd87ONcbHd423omV59L2qM48nq9TVuubKIFhhVYjzeO
/ac9nUdP1+L7SSO1tn/Ga21KrroizpqfXxk/73ELLiSY3+glbXsWHE9wJL2K
mhTJ3UNtm9QiSnZ9DSMbJo5pE6iPSfmvbhK9NwvdcHU/ZtCX9s+runUJyhT8
lA04NN45tKfu+l+drDf6jbZkI8u2ypHPFX34a7/W7msjEtfE/3ZRIV7ZYdva
ZJR7HDV4nNy3tgpD8j3dHb2XNYkmodEGsPDP/clVD33lyccefUZX/eTx33/5
Sz/XVbc20WpDCGyt1DA0q3WuCirQ9JofQmZUfvM2rZ38OXxySS97sRptOxhW
1g6zbnWsa8/66wNAweILW5+upYgj0zuatQQ7rnxPK5usJQsftf8eup7t015f
bUdfU/0+5Bt9e95/H/4JKAWsiJO1w00hRCqKWqOOm+GgcXW9fd+HUmvPpcXd
VUGJXXzruhAWMmuHCBb+R10wVa/oQjDSikzjtUwhyRs58dfXhYDZlrrzf9OF
YItt5K9+H/1SqQvBPQcL9XXB8irpgmNDYVDh0OaNqS4o75ys29HfdP3vGM6p
OgRHE8Bk3N+kETZ/zUkxf76ec+i0G67JPdBu11bMvhTf0z/b98oOd9ffZ/2H
RtRQG18xwebXR0RhGKOVyROoRaZbYT7Rjv22ru9yjmAKPnoHyQpo9Ppsd1xp
g9cN8b3986RpsihwnYuWZmv3I/ue9Jl7HD9cHG7R/BSxrB2WKosFREvy+O0Q
oiJ7WaO1TNBR7zOgNUdvO+jNpFP+eQK0fHQkvd2viL6D1Zi7aATFCcmON19D
R5nQBLYxwfgTXD/2tCGiFEzWKG0cNSxoWFbNss8zoxRaI5NS+cUJ2i1KlusY
rO1nx01uxXvocwG9sTnIqn2kNEcfKUk+iXrSe7SI8BjzShHS7GbofY5eFpjd
HhA9wf29HhlBi3okvdjD9Qt8P8d4c8x3Cj2fYj4TSO23h1Dah7bPoVfzASlM
Sgt50pHgqIK7av/suEnMtW0uJxhxb2AdFu46aoZ9HhHth9qxHU7yjoaTYkOK
U321iBttgV7lJOryyxJ8LH26FD3tYn7Wc4A7gK62VoB6Pm1UWyhjluT029K/
MVY+xaXuDQ2XPrsovClj0QlWL9Ufu8qP/fKn9HTUYHrKnpNEfaDdTSCh3z4b
TrITeoMdSLULfTqGFrR6NF6n9jEDPcGKMzLuAJk5kPH9M5Fi5JJMXltZEWSN
CKl3Zh1zaMqOI13b+wn66SxMbMQWqre/PeDKXMtGZWZLr6xZrq1tChkp8zZY
aKVmmOUctroDq6HPOEYbmMSywglG2fU0OcGCmdgM+uBhU1Yi5RM9jBj/i3wj
YqVRZxjF5x7S+l2suGElfwqsbLoRK2njrreORU4ve541qVdWjuTbGHPrnGmU
0czHKF+pdvRFk2TeRcwRBkdNbskv70RKuavhd4wVtX7o/XOm0Y7PNZqiH2sr
hz8bKuIIKSrybz4P05otXOnUPo7S3NCYLx7jfmrWrjerDZpLLzBzUaC9MZ/O
eVcZyZDrRZTIVuteYOFahtrH6K/UJVtnszBFo120fbYhHfFZq9A3aWl5RIs8
THJsQovslbyM2S59rtb8aG1BkdvfUKBlOYAf66XbXBWfxep7ZpH0zT4bkdxj
XE82kqLF3IwZiXqlhaxj/jGkuTxaYFp/6ZKjUbn7ZzOV/z9q0syA1s/MlmyW
bSIkX+jzFPK17RAkO5KW+7yEeaWsdy19t/+X7ZGkuI2qOKrnI1ezFc3JY+Zo
z9w26yr0ftJ4H0/1Z9/Ljxmee1gl8jzOystC01U/wiiXFbgO1bXJR61H+lfm
N+Q/lIB1Bkng+8Ghah5jL+JBxLVuLT7/YUar2GUoSM9LXBfAsZ3npI/K8qhH
WFE/66VPos/SzPy6zVD972x4sramNv07pVhCz5nhlfbv4Vm2tWJcoaW7wmRa
am+uY+R+U4xrqI4Kfx5xZBwk61RWYbOWPzWpZI0mtSJUieO0+MTfzZMkR0CG
a+fzMmZsueesIUl+JmRzJPszQBFB7qUwL5N/ot9nZcOklR9vT1hsOofDrNfu
p0eWHtr4zPLJYhlnyE1YRyPXIGvV6nnoMcdXe55enVgPoymt7RUuSvR63PXQ
LBf43uOvpZfTKvpVNNnRaavVstY1X1zz1zJH0yjMbg67trzcjVGnuOZ23WOP
PvPQV55UP8gVwNTEY7WL4ldA6KPIwM6CSlkB4e4rGRqlo/SS7kbo0hT9H0IK
or5wdDodP6+FyJfmtTQyr6EKrLQgRYl2Tj+Q59fiAfJ+Jq38k4+ORrfr86qB
LJqRhuxeKLGi6FfTyBe2r1OnKMm7+WyfjEy92torezHp5Zd8tBQNzC8xvgoF
G6+e59B/sn96c78GyRq2bGsTaoy4ZP2MQUKVudEhpHwlULP+5a0PsSrWn2Iy
K1dzSOnXSsit6vU3j6uqui05UrTqmZ7PsZj/SLpDrGmLljIFen+iLhTInHxG
T9RYUaK3J0rUNcVwopiiRXS438e8WnyEFnQIVHzdEpp2vbz9ElKQWdj9yk59
FMmHcq9ffl+v7RLVFDWej+Dakh/p+yWkPoQO+qhJNxhD6RfNIukhuKtNFFlN
YjTYHjV+P09QY22ALB2RtchKFRtXTW7JrwJq9Isr9L8Lqeg3fS7O+ZPhcF+B
qLJCzj1xosa9H5+LkwGxgiPvvcKoPmqSagXdYz7nM57NTLusCDEaEFUy7fq+
QooaKxh5PqQ8iTohS1nF617dmNcnc6EOeucpxCUYw3nKjYxn6Ixgzvs27R+k
qDASk02LYTCXp3dmturrErNVRg8yLO5RMV8ke+ae8FB1cagKjqpRRI01CDKO
cs25N8Vs1UeL6Mp/GFqscXP1yKLzExZiQkM1Q/nBob2CFKW81uBpPv3FElKY
Rclyr2qS3RbtlHdjlvWaBWRbYW2WmKV/bo5neWmXZAC1eiH5kCLuJgxz7lpy
bfIj5pyaPSNe9zzJqfYHFtAh61EWtwR+/j4WK1C02KH6F+td29ezhasqKIxV
ZE5kOvKHlL7Es52/9+zlwl0Zyb2E1vv7Vzl/ly2TFRCfPDOTfirO1XHbVL3k
7g9PCy6hnyu0ffzSfcB2hEkfd+WDV5Dbr1rXM3KfyZMn0CcK/03V68Jii6yA
+TZZzALSMFNdAecSx04/qv5RerXCyH49mzkwWSorszlzEE7M2uTpvCyvjx5F
zulzes2KdRzyowPM8qqt8SMfXaFn00N6aGbDzOZpv2Re9H9DNV1pFs/3p/rI
WZHPssJDa9MsGWde2qTZcj26GJqMLvS/zB3q/mfqaiezaKLFzIb7CPUKeYom
GQ53+Zlz0PcLXUaZ1ziotbZxiNlZP6yMM9qxCkBdPC1a1EWt5ia06rNgBsbI
yYrTCqO+JureEmu5AhpLoMzdHrJ/v2bCLJpsnhkfGRozRN2fokUN50mruhSU
0lAQA/N0K+UgKxd9MTSujs2HkY3zl4VvV9WkzikjYzXAUKN/oj/z96zIEtQ+
ACqvBWpLoHoA3aMu+ntW9fjmV5p4ulBRe3PFHNpT5J4+v+X+JP2O1pzS+2jJ
Yu16eW2eemDu5++pEy2e1TpdNdM7PZ+ixUySFsC9bp6NyXWlHe11LkqyXENJ
mRt1fAEU/WoAaydkCjxBSEsdqpT7aPHcLHf+WYNVdNiB1PT2rW613p5PrTJD
XmL2PBGW77EPVZiGqpWs8dYr47MEJbJkRm7OnrqgtaeX9y2Q+Rv3wHh2nGyK
dYq8SlKvNA3VdusV8RQt1mh40p7PsMm/USdpWbREcqIDjLcEegugR47Eqs4U
aPr+iTURnoZmHoY9vG6Wnob73JO5viL+AdbIR0vR4gDSsibAmovH1KVLmytv
w7XeeoU81S3GFs6OsYm5vKQ9gK76aPF6oe3n9Fw9Mh7qklaL71LgCYTtar8+
aqxvkJ8z/2FWyYxAbR81WZSXb2l3h/NiXkid2lxNq1d36xXyFCWuHb0qc2ta
jvzMAVBuUWpjIU/v+vkVT70op/ZZNVFh9qn7J5CD+wv+WXkfLUnrsWpvje0+
eb99jPZ66BKfMef1Xu6ufQ3yWFYQa5WwWkWW+RWeDY2zYa5L9swdPGHLfIre
/HxTPtvSzcaphfEdBgdAcgeI+KynLotXjxBSeZWmjiB8eaEfrBl5u3npLHdw
PT38ua7T053J5tNAB9B9ns/lSVSybp5L8ys7rL6erjpbQ7buN5h5MKvkXvwB
VuLsyErn/NyNmXV9zn49g7ka832e+OP3RBanbYuqjM/QlaVwJ9nP4aRf2yI7
6aML9Z9Rik+00EMxw6I9DtXVGGvznRnvRPw8QZI+Rppus1PuPoe0zO8sWujk
+3kXyYnjPe1OxQ8+lc+qCjmfz++Haka0cZ4X5PfMn8G6Ch+f7/rTrrSKzPj2
gXOJIy2b7X3gtQ+94IgepxU/oi8dqr0x6hBHZtTg+iOe1zbpFMd9lkbeIa2n
9Ou3Sy6a9JkEoqfx9rGu3An39wVZERiqNrEmx/1ooexXy30U63UUb59QJ3WY
A8oLv8FFS7bK9xzl/IP7bDxJxNMlfMKDcZvRgr6w/qzCJpQY43imQ7Pyc0hp
+BuijjG35FvFdqAzPrelTeR1E1UGhlDK+Ybqu+i/313zzzFyF4/vQGNcVCTx
dYgoKoYzG+JunsdlhYb89BTz8Gtwteq3h075NBD9ADmsvCmlIgpvBEpEcR+6
5nMMRkXGe83PP380VLGkn5IO0yJT1Lh2+X67/AW5hnrne558tIQOvbrHI7xo
7aPCUx482cwKJS2wvleQosSTwdxHZy0s5w+tNKyh+Sgxh+MbMTWuz1vJ/Pn8
CuslQ5VKoqX++AxCihYjLPNs+SefEwht6kqLWuvFV64OMq/iOyHITZmXEh3W
Tbh7x5NYPOHCfAu6HNFiVkfWz5MlzPuZXart65ju9/MpMjbu67P6xayT+VOt
Usksfju06mvGNSVr5v7RPnTER0sW5+VT5ZMZ1PW6LfjP6VGneMpqqAqOtzJE
1Mhk6TdoKXy3Rh2FNwE1npYio7T+WNet+1P/hEut/sYaxlA1HNpUnNDkE6cz
zIZ7BoxlJr38jo8WGWeebykG8ywcmRjnzef0qEtEiydYyMPxZEjxjGXOVskL
+b5KWSZjnYeSYijrxszV87xP86HnGKqP5f6oXsuFhRenzf21YnaomEcmtI/v
W3TaGHgI3eIb7/xcnUyGuk2U5O23QancYdkOLfIp7o6R9+U6IN3QbH1Ly2Of
3gPI1eC+fZ2X+nnUUGWQKPJsBt5AWpw28tkxeSBzdukGvfJ1zfY7LIYkIwIj
Bq2fPIOyKK75u8HUsyFE6/sCKaJcVzJrckbGMa0A9zev64Y63b4An2nnm3o8
DiD/xrNyjKHM7VnH4qlQ6jDPdviIstpWemM+R8DavEmNt9efCUlZEVfH5wf0
hbU6BneVmdMN1V3zzLfvF+vJaM+TVxqV+0UmreJpiWAnT/Iki+GlCgrfCefv
nzCLzPOP/te9+sjJc3w8G3oanMp6Cs8skDfRjpS3MMKeXePEQK1P+XX6C39P
b6jawQraaauwPAeP/gpf7fN37v/wXdKKpoaCvOrZkSVr5T60Vo8s2c/+iOxQ
te209W30VzwVSe7ss1d5U79GKR9xfbP5nWGGIqM2K8XkZVx5PhvOigmrcfWa
pX/eZjsUmX3RivLfclCWJ/9u/k0e4CagdQRp94BOzsvqnsdHiW3m2NvWwXGC
rsj6WAP0T+ySMTAKaJSbom4dQ3cYb8hg+ATmDPf7daShWiUru+Wv6zBzTFHi
2yuZCTJ/JevU6HvQLV+XiCrzZTIc7l7UKyJ+Xem0lV3Nn2dSU9QYn3jemU87
cudIkYMW5aMmlPxcuL5KOfdnnNxcoyyrcHynRX3XwNDiuYgZdMBntcwWmBML
PR8trRn9G3dHGY24PzdzbYQo5nnwNr9TtAktVkzIGOlPeEaL+a/8jY+W0PBr
lPxFoPp8/MqJX6OsoyQ/y9iYosT3lbNSwfeUUAeEMnXk5sa8+wnQs+toycxU
qNt8uoa7HMwMhmqT/LWi+m7BJEGLdaXSP/DNRPTG9Ds3Q5csFsqS+F48+r05
pPXPEzBPHKpVDtW9+YSBjxY1mk8YMDvkO4LprZW9+qjJy/JNlXwG25/fUMWD
MZAoscLB+nd9tyBFjVUDPmNDZpLn9K0O7gMNHy3dt34nLJ/D4KrY+DyhyWd8
hk7jbVsH99DxIrDHziWN1mAPOuCjojWkzjGb3YZx1381jKiUv/Hko4JnFYsT
klOskc8DaRn0N7reR4m/PcffUeKTouR9jG2sQwzVFmlJ3CXg2RXoZGVXkLNk
xCa75S+oKcLe0ljs83+Jju/LJKPi+VeyZNYW+GQT0eG+G88RM3f30SK/Yozh
LiZjFn+1RzHkFujYiYsuMw9mu0OsmbUEZgh8p+FQ1ZWowcIr+/VEjYyDTwkL
Vf7O2g1N+msMm/dYTrCCfLcn9xh9zljXAF8vh35diojyvAu8QOW8CKM4997q
Uq7j3o1AqxttYw3R8CQH59qRHzH/of/h+SCetmLWNvQ7VGQEPp5OfYcnibOq
fAAz+uLeDuMs+eZr9w36W+DKvC+EluxkpS2fZhRGzHAN0SCzubAO2UnIIC6f
So4a0vvHLHqERrZ3GCaTfQ//q+fT4lXXrGcRZ92/tzN+vx1Ok55LhduyOqJ6
flur0WEBjeHdeWr87/2f7rvQ5DXjz3afXiz+Pbrkv1pZ+A8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564878585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135131888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"FractionalPart", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72156770],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4626062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114770225],

Cell["Make a Bernoulli polynomial periodic and plot it:", "ExampleText",
 CellID->209508331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BernoulliB", "[", 
    RowBox[{"12", ",", " ", 
     RowBox[{"FractionalPart", "[", "x", "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25913413],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15561310]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609237933],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431209029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244661483],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->251461377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4003],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     SuperscriptBox["x", "2"], 
     RowBox[{"x", "<", "1"}]},
    {
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"x", "\[GreaterEqual]", 
      SqrtBox["3"]}]},
    {
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      SqrtBox["2"], "\[LessEqual]", "x", "<", 
      SqrtBox["3"]}]},
    {
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{149, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36762543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->597600705],

Cell[TextData[{
 "De\[Hyphen]nest ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->280823093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"FractionalPart", "[", 
    RowBox[{"x", "+", 
     RowBox[{"1", "/", "3"}], "+", 
     RowBox[{
      RowBox[{"FractionalPart", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "/", "2"}]}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64754430],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{350, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27185087]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28754],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->135387540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", "+", "1"}], ")"}], "^", "2"}], "-", 
   RowBox[{"E", "^", "2"}], "-", 
   RowBox[{"2", "E"}], "-", "1", "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Exp", "[", "E", "]"}], "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->790272592],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerPart", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(IntegerPart[\\(\\(\\(\\(\\(\\(-2\\)\\)\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \[ExponentialE]\\^\\(-\
\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \\((1 + \
\[ExponentialE])\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"IntegerPart::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->77592756],

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}]], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{268, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13336077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556752000],

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}]]}], "]"}]], "Output",
 ImageSize->{166, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->564821750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407111086],

Cell[TextData[{
 "Guard digits influence the result of ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->318143903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"1`100", " ", "-", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "110"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214727424],

Cell[BoxData["0.\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
99999999999999999999999999999999`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39979475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{"1`100", " ", "+", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "110"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134520022],

Cell[BoxData["0``100."], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149777547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1`100", " ", "-", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "110"}]}]}], " ", "===", " ", 
  RowBox[{"1`100", " ", "+", " ", 
   RowBox[{"10", "^", 
    RowBox[{"-", "110"}]}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31714491],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->107822757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->285360355],

Cell[TextData[{
 "Convergence of the Fourier series of ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->39817554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], "-", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"2", "Pi", " ", "k", " ", "x"}], "]"}], "/", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "/", "Pi"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131541232],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytvXd4HdeZH8y1JFKS5bKbTbJZb3adTeJNNps4+b788f0jkUTv/eLeC+D2
3nvvvfc296KDAEkALGADq9hJkRJNyRRp0SQtiSomJYtLWzTXhs3n4ffOnMEF
CFGS7QTPQ2LuzPu+5/f2c2bOXLRz9GKBgqOX8Djfb9Ry1GIJT/f9BpUWTj3z
Z+vWrbsN/+J/tQ6OH8MR8e/248fw+4v/b4b/nwGCH8LvZ8nf+Of/B7+KHzwm
ftY9Q1DXrDn7w1Wf1z2F64d/kJT/uebz/1rz+b+T2J59Kvda6v8B/30DPq6W
imN7jvj93a9BuFba2us/JKX/YdJwLOueXfn8RQv9jy/Iwz+te+bHi9c/fOdT
/OQ/kee+QXBenLvyi4/uP+X8rrd/82AJP/xvpAfR+fPb3/r90qNlK37RF99d
hTDcNengTCAL+DdX7JLJFZ1AuP/lcsC6jbTrZ7fvw+dcYmHd/16R8xySAxeM
zditO+8g3mcf3HsIpzSdpXu/uovO3L3xGZyRUXP/8psHSP71c+/DGSEztVbe
L+987t1YdtaUgxnNuiq3e3PZ0lAuD1vQmbdPvwtE2nZs5/YEOnN6/i04I+8t
XHh15/+7InE9SAR2UzMGo7FdA0sPfkv46Llbb3wIJ92bMbmN9mjpEek5kGJq
KZmaS0YDE8mdz54ytBe0beWYkY3kvgT/XwWxf/bkKBcWf6LqKdpacjS93kxN
PrvG+hvWfH7+a65vWJZ7ZOslWX/OVVcasIlsrJGvk/sHjYPLnYwc5rITns3Y
kGvIIdv2f01uVr2DLQiCXK6rP2Rd+GPlft0431ix+oaqdeyt2X61w9djm33t
OIrzr5D4F0+7jstaGDkvpqcdjcV+s87aGTz3syt/uqyceRdYAbxGt4nV3dFb
v/jga2U9VTYuKyydYUtcEL90P1XYk7vz+ad/mqwvt+LeyQsyasbZnh+Q+nK9
hraonag2xLXhwH4eO2ZvLvbpLFGKY6jkW7kWl29jSnzW5lK/Ue/r9Sm3JVeu
BTiTQ0qLoxaj2kWm7oRrsYiuPR3F83B2PHyQx04423NMXjw3IGpxhG/f/wjJ
g6AakvjNrSW6zFeiGevclgdLvybHCoqnORK7uQnr0ZsLVFt9yLD06Hfo2npX
/whLrbM2lnpNhjQ90J60/K8nxyx49vA5EXNHgcvMxIWDvcpwYo8LyU0otrLE
Pl1ziYAjaDW4J4/EyTG9Q2NMpcXQVgE85T51q82659wYec3RN8xRq8wt5V6d
rUy1NNiNF99eRFV0pd5v4HHDuraslFIKaDtprJxyivvBuxeIWr7u+ZBkmi1x
ajsrOCjxwIAspxkd+uyTG+gqkq/rHmbxY0k2l6pNmyv9D399D111N5U5Bpm+
ZxiQYRRZnz3uHWPA1R+u6P0CjB+BmBK7NN1lZVfZYW1k9JVY22QnDwVJBG7q
KEOjU1ErYmrRr21nDFbEs+ozR+Poqr2vwleptdQKj5mNSCmDolHldtWlc2Po
qrOhLDLwtZQyQxhPcJgs87h5u+LaWwurELwICPyiKXCbeqii68CUrmbzwGhT
XjqSa3n0+6V/XKWnklmW95Qt9np2L9YxIdw6TEGjuBoxnkGmYJfE1JJf20al
YMztqh1T3GUMmEwlknGKgDAqpzDE4/KdxsWd+jUY3OxhrsQhFZYc9WW+vynC
nKTm3SNbJR9/cJnA8AJoylWphaK8rh3TeBoRyJkpDjhjHaIAbYV6vkyckfZV
rI5aKX2ktsAezzUv/fYBSeHdiMk1XL4kjiO1tIMelBkpUICiqOus4HFShtlq
DVOXh/I5GOzPs8qcXDpRkR+ZiJB42kt8tZJpSFgbMYG3NcGc5JXjibzg+JZs
FQ+mVEjp2oC+A5N5Wj3MiT7MgmXYF/dsISnw1qxj0OQusKvd1WgcGgOdRpPU
qycPrcbzTcBj6y3zFVq6LQI83VHmyGCM6cjakoqZKPPN6WPr/iuBG0YU63ht
VrerFhsMUUusAtMZ9WTksyHJtYVziAb0kWsFHQarpaXI83Wl2RN0rzueV251
SN47fQXRwBgWhYBisejbMZmvOcze0u0zFPOKbTbVx5dv/vcn8+dFoUzb6LW7
G4q9Hvlwr4PXn/IdTGyt9G2l+B7e+/y/EBoAMoVC+rJHhcOP8Sq0IHcwFjmS
nJ/kjDdbHy39fh2ig8s6LbsrYQFXDYTpxYEsjxnCjucW54wgDqf7B4IOJlYw
xzDLeZysy1FfYgW70rQRrsg/9mrm8Jx9Bze+bgXlupdw+7WVBCoFAHB1pLtN
5kwrXsU14SB4/9KW/Rex/VWccqW0M2dwN+R7Pep0UxjIbLMxIDuX2XFl7uQK
TpNCMFR2ezeXeoKSRH3St7Ec2lrYUuo8bB0DQyKcL8EUyl5XtgnE0im3byNG
jQzG6vJAmtxdgAxZ1Jc/uPDOPz2JFHeiRtKeMnopkX6lP9YY1rdU5AOZfbPK
m2+dAisgBDBf0qgEtIrZ05PuNdjDNWlj27BImgSxPz1/akGcXkGqlwnF0053
c6HHpQ9tzGt6R5SyLCC9efoiIHgSKVNh3evy1pT6fIrAKyVd/6jGnBtJ1/5k
/7mTwW2rkH4LIQVjUQqWmCDI4WYCm3Md0rK9Hhvdkb5yaQ6c8NmNj0jpgMIg
F3AnzRFOmiWIBjYWmpVlS2Npdt5/651jWzqdECk/IOTCjBVmnEahRD/vCNKL
g2JfcFOeIqgou7Hdc6b3b5wj4+UHq1Bbh7S+PU5fD8YT+IN1aSYHiiW2Y1r6
4c9+BNT/9GQmQbhIFErhpGXcH7LXl12tsTb9sLumxE6FoKyu+8alsUNVzDqx
VDdrLVnz0LdcnZEmVcXclleHoudPZM/E5yGnEOaq7dy7zHn1sLWxaO+KdgjK
lqaCa9ILtiBjAlH/9M2PYFqr55j889qUZNzSlDf1xemCEZjcBrc4oTzvUxYg
zVD9X7E2OFwrFymnrMd35yD2xVwfW1sxtyc7TcGxSSYwANuKtZVimXVed3zn
FBxzJAGGNs0TeYTs6Py8CpAAntXILRytb1Z1dG4XEDMUIYo+7N1YaggZTxyJ
Qsifzy4g5N+8fOqmtr1kG3CGZ8Q7KnshR4fkiU6tCw4ak1IwCmG9//ZkfXhJ
J+M75nVgBZY5/YqlKHIYDIOJAUlBk90EjkTu/MEybhNX4dgmg5jo0yeBmBOQ
DUUgwzFPoWnpwb8AMcINCzHArWMbAQl06zZ9us6a6g+zbB35XlMsM0qF0MOr
AKJGuDWsQHqcBf2iWZdrtCa6Yv0wKWz3Oie2ikjrrbL4t/G++HJZIZbZZsTv
3Tydkdg64qzudJOZj7EYJWZi853bV5Cj/jNBjyxpYus9E5y7P7/qYqthgI5s
kzaPwZJFaez7lwf3UEog+h+/9q6+tWRjOkIj9M/uvquWKfqj3R25Ziet1C/K
q0KvABWoC0ojeqSDghOM5Nt+eeeOXCsF+s5Mu7O3SFEk9IGNVVv+45P1BA8G
mSwwwfn57R+P1BqEI70iZ4+bG1RRCi257qNTDtxnq3XQsg2BCuWjd65uZQRo
pSatmR1wGFm8nIple21/CaIBYmI1JhUrEMy337l2Y5Yf7SptturkwUE/m1li
phreubgXhT6iX5g/r+nKSfneXL4VCt+8KdNcesVmMIT6/HReiR9/5cMbb0Dl
unv1faQDuVAmflbPs4nPy3clvoN0NPEUgPrdNy6BgLdf2zsm4MY4LGN7oSHF
Hvf3zoT3DQ8lr129u+4/ETxIU6VI703VoXz40fFtlSF2VtnS6kk463NzEd6E
Y36Ek799+z7Jg7SVcb25UhekPhSA0zuylSFeclAqpRfbcz37Sppx/ZYR6cgK
z7bhV+X9GarQu3VsEKXSYtk5zFDF6Woho9ST6TqyJTAiqozot9y79xB18XVP
3rV4bo3ehM7fhQPAr+fh+K8vXoTa/Oh3S+PqPidHBaWsNWwL6jcXzHvKtSaV
ct/Bxev/keB6/9YnUJ4VTGep1AWzBuh6D391b0TRomdrNkacWkoszGGWbfsq
bS4ed8fFCx8grtNHr+g6igKBa2qSg7wPXGVZrZkTgJJVH2dnJW1l067h/rBE
vHDzxmeIC2neJ3VC3zrmnrp17PL9u7cr0noDK62i5muTg2Vez4hxfpiVZgzO
gsH+y1N0X79mlULEwJ8j3bU8HfgB4YHTV+Yu++lj7jqsQx81ejdP02Ozg6FP
b/3coF988/LH6/6e4Lz+9kfQc6Qcz/joAMIEpy+NvWalj9CD4UFhxN9j2ykZ
gTR6cO8BmAD3I+LctfOsviPfL3HAzBV1bTh9MnhE0I15NpcaPIaIcdNB0y7I
rwcPloDzzp3PSc6Z8hHcDjoPTOlR/sPpg+a9nB7MVVtq9Cvjhprj3oPQ14EH
OIEfVfE1tli7jsRXbPjHdd8Zm+RUIT289xBrLvrrihRRURaqmxI492vGQE+Q
DWZeWnq07j8QqFAsswR28E4V1Wc3Ps21Yw5qpt6a9tVlJgY8exUYyIW0Ac+S
+iC/Diq8oA/q23D6gwvvJzrAEliPKWZ1toxRwvNsXOiZ0+/ZrIdJznRkVklN
UBzWi6cxMBRUKjh9ffFasAODqVG71+O1dEz0JsebbVD0IGZDwZN/sCWI+x0Q
20I27iGEizj/4nT0iLo1p+jFrL2BWEtmj2orxAxcyWXPz89dIayxnrSGzAI6
IWSId9S3yBpIbbKXzAzzuDC8Xz0NWQNXQCfQjOB9joxzo+PCiSLwohh9MaOa
17TlBeySqy2caC7sV01AlsIVcDBkCOKMu2ckg7Ehl/3i0TEIVpIzzp7StucE
vIKnKZZqLewSlpBnEecPnmIPoiJ88Qx+B8/YUuLybScW/VVk39y192oDaxjW
72yNJtHrjLdUdojTcAXqD5WyFY+Q7xPcRxdf17UXB5Xuk/ujEJwkulTxTLtk
tM6bZzl40bZ4un/kgGUMrgA0AIj0Gs3tBouAXq8dHMZ7MOK0+4/QpMOmZkzo
ZERbkvG+EeQHFCKIM2aZFrAiA0nd2V0VKMkkp8Kyl6nBYKomdvWG6vKpwRFo
WHDl1WO3PO5jP/hCp1j/eNV9XdwK4Fuu3HJmX6aKZgNUxV75dG3IWx9V+TlC
dz3G7ImT922Rd/HDvyMkoNwfsNlO7kjh82UkAdKpVTRRFw7WxHn+2qyjH5MP
ZkgJUHSgeq5ISIRmIPIZbsvpuRLUHUT1PNi6n7K1njvSEk3UJ9g+qsvZUTFx
CkgGOAOSdkVGyDguZEWYKcWZqXF8RkZQvQQyWlrGm0VjzaFMc3zQSwk4O8pR
5QhchEsgA9z6n1fmA7g1dO0lttx5ci6DWxhJgYGA9MJbH9TKchsdqT5DwF1T
7uRiP3n9BlwHVUCh76+K9kGHFZa50ABJfuT9Y+dvvSzJbnQkpINJWX+5nl16
8M8Pqn76/qqYBy1OjY1A+yH5UQxM7r60UZHZ5IwwxXF9W7mBWVz6HX77HNIU
khXxO1WYhBkSpgTH4hXowaQl9yxcS8TPZGfOblRkN7qDIn5M3VVuGyQtWcYu
zky/iR/+p6ol0J1+ltn66nC6iuOFKmXgwDh3wiaLtAdryn3KSiq6l/Rsdyfe
qPHDvyXwbCWqO8ujPZLO4atDgupbAAYgwaFkJsobtxscPYG6co8SGx9+FTkG
xOB1/u9WRT0zIT0cykGVIGVUo5BecTAqRoujzb+x3CHHjhx484lsRTKsspKU
6RcnaQeMOagXpF2hakPthsPOnLG/qPRpOsGvraLim1fwJ1DQ3SCI10QHRPqg
3XQonqpa94VqJJ5+73X5HhM9tzFLyfULMJZ0fN1aCxNW+W4hsV3Rn2ZEpPsd
KZhdIZ1bm8eXiMchc1cOmBYdrPTGRHupW4bJNNNICtR7qPorUnyaiogZFScZ
O2VhmBLCObAZWA5JGbs0Z9hnEic3heuwLhXmdu9cm3uElOftXEzAdyui3VDE
Pr9zr6o36hrBk0XTXp0mUhMA4+oK6cwhJAVVW/zwP67YB79LqezLcBzq3bow
TPzhHGqNqFs8WPp15xZhP1Zn4Rs4nFSNU4XiF+YfUG4IPz2PKgErxN3O9N2/
/Uk1uxCa2/c/GphV9RQ3mjQqMbVQZzGST5gImhWdbLKShBmQxynVBozaJZJy
+eNr0gVbb/4VB83fJyq220gpiKYq5VkrIw+WcVUo5Zc1SANwIrgStRFwtv6A
t6P4sqMj3qosUe0uJKVKs9oyePeFPOD6RdMDDmTlb4yPXSIq5Xrr4Vh6Vm1T
sezN5ZqAqnBk59oK9+8JrWL2aREjIo71VCcHKCJQF+DuMGJTUqe3y7u5UhuQ
HXjr7OqwIjUissCap4Nd1kYDimXKVlkGowf4ZgW9sjkxcOWjmyiZIKxQJj1r
HswK+Z7o8CC0ZILn29Uswgd89DsQEUq3Rxg+Eau8OUH94N7dakyt1BeiHyso
GVaAsWzdVTGFrH3js/cGpyVFRYdvc6nWFmpL8cDmj5dnJkijkG4Mqr4xPVTV
aKUCISkXPniTOSPGNJsdTUW6KNyRE1y9i1dtVD9QvFh5RRHXG6wMQgNcbTVk
2cXrJ2TT0ix3wNGIbXabuzEJxCFcgaCF0CUkbNDT8xKeNV3BZ5pwAjUMNM94
ceHaEc0YL8MSGDtKm30q2pj63kP8MSma16+KEvxZBES/KjUAubgihejTL5y9
ecbtbQrVFjs1hfYMDTLp8fLkAMXrBqeiJGaGbdmhBWLCgtKK5N57eUfE1Rxj
R/UdWG+OBcECp1FbILmRX1NlNrS9atqR3FOnyylTu38j1mSKDRUVELBwGgU6
ya2j4fqPVWTQ9FYkI+78kXhW3ueBybw5IBgzuo+lq05clSNEx3nOmGLsUxYe
Lzc1tMJ5YbrYm+pxDnGLjYVaz7QOwqBa6VBukPU9ibFg+kD4HrILjf7o90tj
sYZhw6CzptyVqDfO6CH/gR08TGI3DmRFfFcZk6ye+JLYl377YDTSEG5O9Mky
PZmNolER+B61c5Lb0JsVCGwTOSWa+qKEIrk//9WdqWRHoCbfqYtTU5sZ40Lw
POmXNX6XDsS9OTayHikD6Q5T7v1JzN5UMrclo0qG53CiGnpI9w0WKa57qiiA
Rv14eSJMcsPy5VVsWEbF2DJ12tGSOImtUCBuHRG542k5WieiokNy75jiTivy
Ekq5Pt9UcndDS4HTKMFIblNnTiiybA+pYA1VTRuSezzXvEVaMrSUzR2RrEUE
abBC8fdPag99LJnlggXXyNhw/eriif0hHQ1j8kLeroQo3rvsXWL89UZGFjJ3
LCGGdoycip5rXrk0d3J3VsGumFuyodSQuMh8kk9HzYp59qmAHNovSjOC7wVY
ep2Zn3DXlhvd0kyoT7NFVS2z68gRO/IikXmbUQMtF7kScR7b735t2y4+f7jP
IAs2Rx17/St+WqUt3gkgS9NRHlhsNf/DX9/bUuosqLc1mVKulnTEPAR1ilxZ
opFNA3iGDvskMIFBiY84P/vkBjjKLRwztRQNfo0v1AeVk4wyxKmlZMQ8B8KM
UhNxfvzBZQgQWycmpqVcFZkm2Ak9mlxZEpzPGjoKIpFugivB14tgPcR3651j
Rxc8Ij5W69IHm/Mq98BKxq7SFa/x0IfLbvz+Ic5NPCF/ARagZ0f21JkwgcSY
pGlRVIHn8Bnf3xB49fSchGcf10hgCoDS8fnleDya3c9gl9RsD2ZuhonSSrwg
ThSPo2wBLJFRhd+wXAW2DlMWwvvtdWVBSpR1d0MRIesrshGhqWGYIqq6bcNy
BQC/TFh21pnSVoknxDdA/SArwBq/SpnBkoYH7R3xI8zv3Tx9aIfNxizW6ssw
uCYRrjYfEjPEooRvGx7gQVNHqYk4IYZP7csah/JQueqNOdt4diWi/mY5FoUi
0wRTUTUg4rx0buzswoi2PyeglpvMqcj88EpmkxbuyMt45m1cZ9WAiPP8iey5
HTN0RRLQOuqwypH5Fd/8hydr9bPYIKPK/QLRRxdmxJcW9nWGu/w9MSY399mN
T1FQEGM+p6FmpBwnoCXnEwTPBvDM7NjgG9MHtbC+E1p7NemHUF3waEFcyC+z
EjfprReWswW4jsT3uOozDqOCqk4BF5mniM9RXxIoNPuMGTITXliuyMA34xxv
zNc4ewOqgfyjpUekN1b0I2b6kGtTPA3J/SKhH3BvHxnocjHVGp6+K+fmBt7+
8U/AZWhENTUtYzsBKdmVqzxz4+xBpdLZ46215Epi74Xzb4HIqnYSgWnRXiCz
DvFARm/FqJIhh10oqzXnRlTuxf2X4TLB84wd10x9MriNsBLi+ODdC9vKg7XR
Xqe239SEzTt987M/Asuv0ukZQifXDqWb4PsmwQfWV6iMvbk+T31BySpuK7A7
WkfA2d8j0Bk7cnyR+YAjS/ZEgmcDZIRArnM1pTkGn4menx/jNdWXSatDXEkE
RmhjpE0Rx+f3P2EolJ6mbL8l4Boqzk8IcE8iDns9JpYrL40dIiMbcdy7816n
WWgc5uu68iFaaWGbBc83pM0X7no/V723Q16o3tmAGn/QWyQlv0RI3hPZ0Zjq
MQ06JIz8seJEPKDDcX6P9EZOIDLBNIDskIhji2OLUKQ3MB1UQ+bIWMamt+HX
vrcqyqBxkTmCOOKSnIxn0vDcLE3m+NasXmHGM+97y/rK5aqre18j6xbisPPD
HYUWocJtbykemHLwmG5c2veRPl9/zxfXVcJxXCgt1NeOrEiF5tbJywsCA5YG
zJEyDKdac5nTCAeq7IY3trwKOL6FeubcyW5uxtWY3uhIBXMuLNEBMURSEzGn
OTt9GiyDqM9UFjv4aVdDutYRGR7LFGPdeO4tU2MKuerU7AWwPKLeF5jtUYe6
IoPmlvxwKp8L03GrP00/fM5c3VGJH0g5juOFA9VxobyaqfFiwGJqLdFswm3b
LSatlxwXok8qMC5ixyD6EPVnNz7SMHPRzkS3tNiWa58c1wbdyRWUUqVsd+k4
ZBaihsaq5JeTDA+bUerOd4yVeLHQOEnt3oyJlerZ0fOQC4j6+uJFoXg07eAN
CAvGQU8l1Tk2cuRLdVq735O4N/0MCCOpyFij+BWqgIQXMfQkiodifisF9+Zf
r9JuNHwIsvfbRBWvdLnNrIC+OzdoUid3eb0WTlUzuUyV9B6GZo+wQjvMdXtt
GgsU9QGbeGRPxGOWkJrhj/FUErv5ILikauNsf8irV9absq6GLDbi8NntT9Xs
ucer7iXiV/gSk0c5D5K+jaIkPn9qy1GVRubZhHUHmH439fUL11b0kQjMOulO
SE5EDTVtcXy/py7PksS6o4yItwPPm79e1kklVqPERNSwUDgwvVvJDGh70j1+
ScDZi+fMXy/rpNTxUFIialiu7pveTjF4lAMh5VDIZ6NV7w59nU4ikZ7ROwlQ
vr2cVbBGyqWN6r4Sx8hv5eXKxWIVZUmoUKMk/PZyVkFBCfKcCmqxt9zewUvu
nt+DqJ+BmFLI1Xgv/A5Bi545OV1SW3OJHeTRJZ7jx94gafF9FkoZrBlJWhD6
1vZjarOcpU+4m7JDEvs7124v67OqQq59GlB9TijlG/AqjKShh6M/ufoaRZoz
94SUTpNC7yRHBsvL5DK8/n5nOTpgffr6G6/CdKYv3sHR2Bzu8ApKpUGKd7/v
LOcfrKkPnpjtExX0VHe/2JeMp1Zo3Sod3vW+s8quI1vTLeakZsjK6ssMY2Ok
RtUOJhWYPe5j5JwLPdbpCnhc9XmrlyYWKauI1RI1PhtFdOB7mElKh1Jyjtvs
axVLtSs21cghnUg6UOuzjz9pswcNfWGXhCdUWKp0dpUer2+rrfXpL3/Rak0w
zBJ/W1Cutq1FCn0d75nfXa4VENzeYyXJQFHMzVvUjMtvXVv375bRqsR6vB4S
cytoheues82lIVO7fGmjgv3L+w9ISnzfkdCA9zKEFz3dE80FuuU5a2tJJ+cT
dM/+8yefw5xRzzPfvn0fUcLgAIE56qy1pO2NJSNfvoIW3etFt17wkyhuYcIP
5jhy/bRfk3A0ZhrM6YAvuIJYKtbhufndZdotnc7F6yc81JRM5Wk0pbZMbV3B
rBgy45n53VURMf3mbpvRZaanhgTpV4+cWvdXBO2Vq+/ioun2dX++XI/Bxdnz
EwaN2ahOSmmZd37yLlp3r9hZIVTjmfzny3pePnCKE1GbeoMieZilt1URy0U6
/BDRQaC98eoZjc5p6YhQjH6pyVlFqxMGVugWxOnLb7yus1v7gxRrU0FndyOk
x0+cBpEBVQXtV8Uj7NVLJ5xmNzNHd9aVXP7kGpRyqXVFKrKBYW9Iw9c7mdlu
Y7A6ulltWkunm/FZegMKZZBmIEf/8MNPwb9pxxZydJQ5oryJkuyy9MBaL4jo
9u0+DCjHsidJOgiW09md4rCxO99i7spIeaE1KI0aJ374F8u23LNrp8ao9TUU
G/T5u3d/8VfLKCOucpXuuWPuqZmFGb3U4OnNNZpTpC9PvHoOxt4//+a6f0VQ
QbUePjip1Is1AZelqUhSTU3vBKoLZ98jqUDd2N4838nUGQLG9vxaXwc9mRV8
kIXgHk3aqmRb+KxUOINV8R0/cHKFDnrfLD+mDBr1dPeAILtj4eC/XTU2Ppcj
xl4PUbxDmpTbdP2lLnVX6ei2c4iuUpkAOjyCER2Ukhl5VG3QcMosex126+3b
//6JXPrL5Y673zsqkypN7ek2tzblCcLie92/WUb4S3SP8l8t087oEmKF1NyS
7XQps/4IvjPsXxO0hewwjI4f/uVy9Z1SRLlmVpfOZ2tJj8VygIekNWj90FRX
aEFKSe5jOOkcdkpN92xLDoOOJG0qVZFyXdWO8IX3RQiq9TCaszlHUwT7w91B
gwNqCCH5mQtnfgxK4IeERus/fe9jS2eSJQoOevojJgckLqIL+vMkekR35/r7
A0artSUrUYvTSneVTil1ksgR3e2f3BzQOJ31eaGJmxHbQRFEB5BVlOSXo0bc
89lFRW+JM8pQGTTzJvyBD2HnZxLhPIma8Oz6SWyHualEy/fIHJq9htLHl28i
OoveS6JGdIFUgc1P6OhuqUsPIQIGR3RSkYVEjeh07rChM8Ox8JQxK4QmGA/R
STjOr0e94fdLj6DmWzGPSivOnZog93Oi/fBGhYdERMT4egk177OklUbx5KlZ
yBkgRHRQZp5A/uFHd2vMOV9LwaQwzh6ah2qKEIn5TyLfd/AYpIaLEdcbdYsH
90E1Iem+Bjni1lISGl4Mig83q0U9CaGRiUxPoB5Sez0NxcFgv3LKifY9ITqF
SPkEXZcx5GSkNQK9aXcI7SEj6uEzUOelAgMAR71lfbMp7m/A5Gqx+1ga7dJA
dNCZpAC8P0m+l/V01AaDx1WDtZXrHVbP69cugb0RN2S6VGgAQOQoMhOISnPV
IqnDeOvtd2AgRAeVQyTWm1sKJB1fZ5HwYlqmXejTXTv5OiiI6KBfC8QWfWeG
pGPqbBpmUiE00OJStE8K0b167BasV9WU1CrUeD0hbLJh356j5o70gCIj1UfG
Ls2ReyCRZjB3UIs0VcQbtk7P0dV+WJsqDYm5KwfQ9IekhVmMWGCq2nBDIpam
y+OghdocOXnzNbQpmaSdmX4ThS5J67Lbqaqovb6odEZfv3UZej4eoYgWZlsi
jl9Fj36VzTeAB61Dakd/ss0UZ0+F0bRoRYJKLl/RAuY9NumgmR8RMPPS2SSa
HJO0ifgZmAmuaHH9+gdWyZC3ptiuz3sPjaPNpyQtzEYlHBceDYj24OIxv7zX
3B+nikuFs9vRRieSVsCZlw6F5Mzwl2iB4pOvdPha4jBFbbeE7925C3ZAdLDc
FSjUsAZAM9z1PLnFZu+DFVSf2QUeAD8gOphLy1AcIzqGxOLpCnFVKprHjbZa
IrquphEZx6HqT5HIwXpDIptewzP2hpl+J2k9Yk76LL6doQmTAXhWBGH/st2B
+GF1fbNWtw2JaIrbl5cJ9DXmwsL2BBln314eA5ZUEiJ8COQbAoFQuzKs4llZ
rOLRxVH0DJmkhjwCBQRinaGdpDaabXJmQs12NlhS1y4eArtB5yOpIWc5PWNE
AqSRVZQ6E8vnddXnunXROz99G2bcSNNrV+8aGBMyRlDBjpGa/iH7fdZq+hys
rRQajacmTzdkDEYRsTf328sjKPhz0lV6Luxc5Cjc3clOZx3mtYpRkSORQ36b
+Ft5YquxI4uoJ0cn2cKYtTVeb87n/FJydzOihvyLa+YEfLe2P4moC+lsjywh
5euZzNJUzoIWNSQ1rCAK2hkpM6DmJP8PdN0Avkj5m81Gv60pr+9NRP3D+H7e
6hh57yIqrAgRLBsKkTpuXqbsy5oGXfnEdnwvDKKG1dKody+RUClEffnS+7lI
o4bltjSXbHT7SHIB3/mCqCGnpz07JcygkhFF1CdefSsbaqcHmJ5NmIOh3547
gO/WQdSQqfPeYTEzrOP+EdriyqL8cJoMIztcQwaFjJYL0KO+dqKDfmtZ9r70
AVjKG9oLxH2P9XYdt7IYGDLoXfVFg8Ybb3MjFJDFh3OLUo5DvawhxL3PSs/v
C3KlXltnWslIjVACJGbI5UPx7bKhoJITR9T37j2MOvuSC162MuRqzkp5uRlu
gqSG9DkUxiSDMZMo8WUaPvOU3ET6RUM7xnIUSranUVsKNmTZvGE8rpB+3Z1b
zlUO8kQ2iMLvIWtYS1PDwq5Mp5BaisvcIkYBn1US95meQ5l8obJPwgU10+hO
0AarPjy9RdeWoFElyTAlo6Sl8GxGHOjp2tFQRcoIQjCSHHqFedfOYEuExRHG
wkMZTXcEz2jEgZ7577J6oYFYNOl1T9N3rZ5ro3e5Yl8vxJj7KjO1zqitOdmh
MZ4r7iNHQY8FIOJEfJuuJ0PigiitpGnbYsP1xrSzMdWgtuH5ijjQLX3QBIqN
hrrMkcucHk53VsKZTeYi1IQ2hQe3LeJAD8NBEwkzoOcvc0RCh0bSrUlLvFGX
dzWluuQevFIiDnQ7f1ipAN2t2sy6L1Zk/L7MN56Sr0hj0ErASe3IqERyzEoL
8VUynyz1hOwDjqyM41RTl30HWtlNyT0515C65Oj3cJXysnmE4MDv9q97ZpfO
L+B7DbQUSQ9zhpAntC+e6DWVvC2xXg9tT2THKvppsVbMjFgEy/Jh1FTEt9ef
bzIX/PWZNj/tROkAiQg9eElLuUpq0mepfEnvRNkBQXT+xLB9KC3iRS1Dzl47
562L29Fdf1LOrMQNntEue+Z5FKtnjmWM9CzT4HI1pllW3rW3FhAPurk/xdNI
2D4tg9TueRStxxdCMnbeTA2L5EqxlXfrnWOrebJ8logZtYlzJA/YnN6/5cCU
gyPMO/oCXLVYaxN+/MFlxANB9uHPPo1qh0DHkH3kq3R8HumxP7OtS14IdKRa
/bTju4OXzo29uCwJhprgSoR8tx78RzwHeR5hmvaPNpgzbp5bxDUf3mW/cmmO
eG61vvqgDRtkQOfT8lOIC90PzVkwFi/jGgr2mfkH5nXv3Ty9muvBvQdpFQMC
0WnOIy5A8PFHn3mkWTE7YWF7BvWifbNK0BRxocdzUCvCbpaCksn6J56cjxLW
eqG6W4qrjfo2YnV+9Yxkausw5eGv76E3odejzIQKXGGxhXyPcSBDjP4C2jjy
aOkRTR1lKZ2O+vxBz+4nOFGGwjw0p+RCyhn4WcSJHkMtPfgtTZ5y1xZanPpT
xYOzY4P4G4yrOQF7yslFjvqbVR759O4vaOKsoynXYdO/NnZgxxQXaYx0ga7r
DnCVvZlCYttXePcFpBccZs+MuloTvTpXh75wcnwKf7/n+VXyoHZWtBzo3ToO
8tYL6LExHAYPZ1RGhZARUfZj53ZNXDyNEZxE5j179+r7mFMAehsFOcSHHijC
oW6LCd8M5bKL+KVT+7IQHuSIaIchVKwYmHRF7xUvCSoS8NJmt0PGwxZnHBAi
JCeyDMyWjVEOTADGJ3Y/XXfkdbT54/R7r8dYBp3E0WjKjNrmwXf4G6IbVsmD
Slh2i5Dv0O41dC9+8fqJgqOjP8Zw1JUPxA8AJ0KBoh/m4ekoD5LSpSgi/CiP
HxPbGWMdziGTpMZUOlVaBNetW80J1d0RFSj60/nIVsSJug/yUrTVT7Gz603l
08O7Di9YSU6UhzDp04T5oPn26UNfpTnS68HSr9XOIV9rptHqUHIwlDak5kge
TMqxOFfMDFnFeULzF9B2njuff2oLdmswvrQ/4+sfXZgR3/35VXKXSzW7YY2T
zHLBAG5lEe1LeAFl+OWPr4VkKivT32yMJzVbwW6f/+oOyV3dCwUTKXOCBymL
pWZJbuSvCx+8GRFotTx7ozE3YdlJvtG7frnToGiGpYTQJwRDzG49+iXVbU3m
6+YtwS6ftidmaauc2zmDxz+SWbU9GDeZ563Sh4hw3FzSCt8fp7ZYjZ6a8pmF
ESiOJC/KYDiElu7IcMhqi7Sp7qPlJWi+lpSUmlTzKlDkr19dJLmrmQKrOnWc
oe7JjlfI/TOkB5ce/U4SoHvaE+bmvL2jDOGA5wLiRntj4HBBnBY5BLp2WNO8
/pW2qMbnwrUj6SSfZmeIqKUKz43HJ5KJdkAg+7pLQ5LBqFuz7NtqPcAubk0m
hpoTvYr+bEXghrAiuasaw6rAkGQoqYm4fwvJXbVU8GQx7h4wdMXE3PBCzIC/
G4+4q/usQR9egAu+nZ89QXJXveg5nAg4+/uMKqiLu6L+FS9Wd1hv6bYzTCpd
e+n44Utr7k0gWWgH6L2H9ylbZR3Z5h5ZKdqSyfnr8bpMzPA2oCyFQ1h2mNIc
ZX8yYK+gu7vk/ukbn73Hn9M35es75Vi0OZ0ON+AxirirO0NhBS2NDyn6k+nI
NnLsau5cvXtDtsNEtTG0HeUpU38+20XqUd1HC+tNvh1P9V07z5LcVf9BSbPs
cdelu6WDlSzNNDw8hMZ+vrobHRrZcLtSoDGYWkqXLvz06VHxN8sx/jzyan9O
1GiK+1/BQqYmznYlBN8zy1Kr+71h0axIw7QikQjNEBZ5seo397F0T5rXYM76
m9MeGUO1YK9KqOYt/IzUGlgBBkr8v11Vc+BQuc/Tmu531pRDYp3V3eQ5mkAe
fL6ao7heLWqmTY3C/W9XeRQOxQu2xnRPhxwLNKa0vubR17eR/NXou3/7k618
i0itw2+mX7/z5XZZ9yLazvaY2CbMHrds9Fpc9ViRT0vstGTPTyC9qhkMP+WX
Nfxov6I/lYttQ5ap7vTGN5OnZZvcTktvId7hdC7Y5q4cQBKqWQwTiCmKme2T
yPszk/l9SEL1KkhoTvAEA2lvd2HUUKfeZYYYQBKqe7hhIgGzUZbZAMF/+uib
f7vau1DQG6LsWnMqsAkbt7YrdpmhzCJ+NE+BQ2jIe5wBodz8VbYhIvHFapTe
vXe/JsLnCNJausM83AcpBdZC73FU3wAAm29n+hhh7iqfv7g6pt66dbsmKO03
RR1NSX9BCEIQsmpcwCRjh9LHtuu0Xbkd208jCWjmh2Cdeutau9XoqC/Wll/2
bpdAHCEJ1cggdVMZ9a2lH7/2LpJQrWjwM7F/scZjtTfleoKd/l1aiGUkoaop
NO396YBEZLPXlX/x0f2vsM5fVi0KPy2KWK0tF+vIMrw94gULtMbHq14aeYy/
bffOXlNy0K5Dfv87QoLHfezVY7eQhHpZrNGWwkRumUDLntdB6Xn85MsTMBHZ
5wsP2k2oWBASvlWtYUu/e1SjDliaiyNmRVd5c/M4G2LpcXW/NuGr50C5g+mw
QGFBrkdPh79VrWR3Pv28VutTU/IJgZIyXN88zgEvP15+YYKUAQ39yFhMKlWA
gX555/M1tZew+LeqeQg/Vutso6kyrs662sL6/Sa0s5LcyV1FdSSdG7KbkNtJ
VNWsgh+9cVuNqTzniXnqM5Z9bsiqx8uvT5AyoKkfLSVZegfZHwkZ36zmFfyw
pONsZrnITNJzG+V7TGjbPrHrDEmA1n5sMsmX4rZ5/9YnJIrVb1e0cCo8ZgVj
RntLmzT7XUgCaoYkCmiIx+eiIvEXbbM6eggbvYR22uN67LnULcGMypKxO0mV
ZtqNmQcPl1BWVS1+YjxHt1nJLoGQVV8Vg0/bxk70KMt+Q0k5EOPws33OPIQD
ucMMyYBGf2xLnCO3Q9F4/cR1Usbq8CqmD1Jk5WB9ud3uafRHuFH8fTQE8gnt
pHwLqR2SsTo/3dbtdHE53F5qsIeb/SFRAv9GNHJvNiHjWWiWh3Z75UKl/+Xy
078TDlmnOkOBTtA0UGzSlhUamb2hUGsNubLHEOgqqrO7sUG1R9dRWNx3Ee0I
+mY1N+9/cr9tsNisw1RyhamlUGePhrCTeEagPWowCTm1kOLKLdr20uVTN0nu
al7e+tHPepiYprOsFSlr3YkmczI7dg7PBcQNXfLobteKvxF3dY5yfu9FOqPk
3VjmOJmbHbkuWz49fBaPe4L7WeiQs/MGuVTx1bb4ZvW9MfiUZqcSjfmMskvC
cfPE2XruaDJ1lkQDtj27mGPKIQdKrx2/SqJZXf18PcFMbS6radb2RYfkiXr2
6NTUZZJ7vNl6fJ+Pz7WTteGL3OY2b2pjPtThbI5rNgVdjewxMBL5Ji+4CdQ5
sNsiFarcm8u/ebCE+KudE/qesTcW3lgKSPvoNm+XOdTOm8T3lyAvot0aY1sE
EoUUzEF+v98f+7SAiMgXq76HlJ6Xzsx7lAPJLlMz1jlQOHDw7dV4YVYq4TqQ
64l9nC9WfXfYOrZDunWbk0v3sq1NWF8fdvbsTcSLnprAJF3KNtvrsJ+/fw/x
VusoBNVWxmS4LtMWYTcEky007P337yE90e6JqS1CDU+L6/n3T3JCQBVahmOd
LnN70tJU7KJgUAsQJ9p3Eqv0y5+w0B95552w0F9UIwqW2Iu6qTm9U5R8hckp
+esKWN/IIyLSENLFnXoh22FsKV27dBtpWY0IKLmHrLOzJj0rU8sZwoL1xVHa
OLIQwgpaSsVqlBqItzrXAs8cNM3l+oNSjXSTrZisz83I55Ge0OZgnZQdpqhE
qhULVeMI/LJo2Jnp9/ZHhpQ9xXhNYc60p9pHoFS6UnVqoRZ/YveHWwg3EB6v
xDzqO6D5PDs+QXMbQjXdmriroRTtH7117KePifkFAJia5MhZHrJPoPfkUcyB
3vtU5QmaQx7ZSBVmXV3lbE/l48sfPibmFQCuOEzR8nRktSA4v4tqDTjimHvb
MN3u7AxuMhf1wVGsvXz/9j8DyUVsPyzB/dkmuUwGBkHf1IDmTHjntG+fkemZ
6Toms+RijlUaiw+JlgAWfnPHIUepW6xQOepLT7PFE3sKV8UIytwlYg/66eO3
oDAcDe5zWDa1u5zejZiGFt7jiBEZiO8Ke7ZU6tKzDEglZAvgBC+fOnIdOHcb
ttisNe3WoKcGczMDR6IVhA309abq9DwdrAIeQHdAtoB+BF3r9YM/hsib4Se9
9akuY5pVyCQ44TMVfF0AkXH98DlHoUO5yhYwxcF73aE3YR23heeXe+rpsryd
Vs6wPZe2H0L5eOvia44Rulih/BJbfH3mEBH8XWQV38s2QUuxqG+rjwtMrfkU
lzYsbfvswxvooRooZuBrkUUIhN8BvcBhsZdN4v6JqHFza9zkqiumhJ0jisbP
790BeO//6Mc+rNsgwFsB+S0kwANWzL2sF1EnvUMKiSDRnXDnpM2jqqalf3kA
Bnrv8uvuEbpGLHVvxkge/HklfQZ4NMIJh6OmKxDx1pTy0rZxTTv+VSPN1ts/
fU0/KkRm+BMrCKHRt9HDxgMVbWOmR91XCHLNUT5rZM4OhfGjd66GKxQbT44s
QLyr/C201282xa1PssxteRdP71XQ5/bHANOd9972jjGUUtyh5Hf/oMeNmGXI
2pyhOEw6gc5u6T1+YhKo379xzrpFIJPJHZDhiBrtski5GlpiRk9tUU6zueyd
p87MQUO5fnVRNaqRi3TGzuJTesoT3zrwBR1Rsv/08sHBVIOAXnIIi53Z+nZs
c7nDePfnVwMTHDtHAc3990uPkI5o38QbR0Y6U90KSk4nLLflajrKNVsZgfdu
nrbNiBUS6bKORO5889g2j7EzxpIF2fbR1tzmnnI96HLtrQXztI70EdIQWXvv
qLY+zra15njSTEemZqDcBvAunsbk41a+1GDtLn7Jt+wS2nwL7ZB99PslafIV
qrBkHcoOhYbqHGGlNXjrnWOebXKdSLLiAVT9H/76Hj9Vy2BhWl5M5OBvsqfs
3iTgs27T6GX8FWq0P+DTj6+pZHIRvUTL6GUW4SvWXDJcAXyKSbNUIV/RBtn1
/Rtn+xIUBbUg1DjlWvEr9sxsaQc05IGCRbBWG9xHhI1fQttGsuO0XkPc3JXi
GGPdmpiSUvrRuWnXDiMChb5PC30Pk6vURFHm9P1hoS5DkcW1NAwBgiYKAYTw
oJ2zSw8fGuLNztpyU7FTosn3ypIaNnZsv5szYpUpZLamZfTIjmAZVamJxSqJ
RQa2KkMXJc3S0X2zys6UUSjVW3tKX+ILIk9fQv4E4R0hh7um2KMZtvaGIJTm
cwXtdotcy65qgfJm705thzVgbcn06EesnRGg3Dsa4I1ZkFkRJdoUMT5K03Xm
B2ymLuOorTUBlDswA61oFcp0lq7iP6yyYQZrpciSBlq8yVhx1Wd8G8tbMVZj
0CQWmswDpa9Cj7r7mxenU9syzjqsQVPx12SktHxGERNOWZVaFoyKRkKbQc6f
yHq2FKB11OnL/k15OQXDzE56ySZXSp0N2D8sZ8OLMKMyWzH1QKlRX/Fvxr/+
pWhRtyVMgB0MiiSiZgizEkkYszeVu5QVaBKG1nLJQam36QRCp5PzJXNphB18
DWXh5tvHDuyyaTox1mAltDlLk4WDA9HBil2hFENUoJHQN5dduTS3eDBtbMZ4
lHKwOcLlZoJcW3vCLNKKSezrXkLzQYirqV0ViB8erRzo8IkY+YBQu9mnFcq0
tl6SEuUJ2GPsQAX/uuW+sr/PIaNgSYOyy+gViJwu7vDT0RPR/01of9cOntpS
6tTp4q6aSrwh1GW0uttTnTkDAkR+fyDunsMLEI5qTsS+uZzodNFkQR89/LJH
JZTixiTpAPbV8/vA7mp62LWpHKcZmaK4nx1qsUJpMzioZZIOTPbmue1HD4cN
fUnXxnKMo+SzsiG5n2oMC0QON2/kS6IdoUb5Pp5rdu5KWBqL5W5br0ftaSgA
Go5e7m5cRg0zv6Pu8ZF0rWbcb6rHSp2aXr3d05urc1uQEUk6SJ2TWfyxHi9n
Ntdhw0OKPpXXN5ChWIIkGkQHsXJufHrHFHcwrDXUYwWxkCGK+oVZjizD43uC
qi1rKgzhoxeh7O3ZIg9v9dA0kQo91B3lQjI2eu0I6n9dptk+zNBOGOny3AjF
1u3SeBpLMDxXqbH3ltHoEGlQJ8ayTWJMw9BUyj26XqvR1VFkqDJPoISVz+xQ
YDzbxCrJB0XDw3R5j8btoRd54qKAFU46Zr/EtkQ1ehGq0aSO6wnAqj9TYOYH
g1TPZoxmi3CVWkCC0EItn7DSTT4+Pz48PBTuDvB9m7BBQ5atNLnow1WaUUe3
Mi6WJ2eGae5uN8yiMIG0yJHYA6IpRAN5P+JsU2UVgsB0pU/f7dC5WjEVKytk
RwDm01ESNn3hZ++cmJjTUvPuCHNS4G21NmJ8VZ6tsLhoZfJbVa/+aGF4t5mV
S+SYBWqQ5q4ri4RFSAjcToji4olKdp9Hmq9gg7GuIAf/PnRBmcsLJgzbSIoz
R5KZAwFBYqRC93e5pO56TDmU5HMiBc+eL7EhQrf02wcjuZaarMA8MKr0Nuja
y3JemSdyePijpOTPf3VnpEJpyWiDQxNsf6eltaRkVsA0QfE0SfHxB5dHtkr6
s57UUHkg0OeqK8upRT47nHXtJClgClCcVTMzicJAsjvExL/JtCsiGkxOpg99
CToiPp6HLO6fkrF7MYu9Xt5T1g4McyQOv3ASfVMvZEFtjquhlWWeVl0Hpu4p
s8SemHwGjQndfqLUtTktstHLQm8LrFh0vQnSIv+4rHul1NWS1IWoBcANU0lr
v0dGzSxMnFuTHUQMPA/1UDwjYQyVArouMbWg7SbHQ2igsjFnxKyeotXRJO2r
GFqyYIKceze6Cs29b0wq7CnoPE3a9rKlPS4YSk0l0HdPPg9VqCHPV/fkRL5W
ABrs8wOMvZMXvso2oJ9xhEYRRxMSBpeZ0bSWhGw8ZZBE6NHyYRptMO03douo
BXNHBqmOrt6/d1s0OjjQl7c7O9Qd5UBnGI2Hrn72yQ3GyACzu6DytUF7CQ7Y
Fb35k7uuPB0NYZsNZ2+e6bTj33XN5MXNbQU+O1r07iG/1XrvW3v6tbmodIDL
Sjs701xWcjp2lLw2enaUIy/6tRQZpRjoicn6c0e2XiKvZY5nOVzMbm3XtpXD
NIsO3aX6KhRLj34HBbNA1Q9Iffa2AjIxKe3ew/v1Dk+GwRsSRt1tWaQwee32
/Y/abZEkm8UfzHj7Iqru4oXFn5DXLn98rU+TCUr7AaGXZoUMufXGh9X1w+Pq
fHr5ryh89V0aIvLWG+eKwR4bRWdxtBRRwBHf/rteNJxKUtQA3tGRllHyx2cv
o/O9MX+KLmXw4u6uiK4de/vsu+h8i9eTYLOE9Kydajc2l+/e+AzhWosE3XP7
qpUNwvXgN78xd0epRp2jKS+jZhe3vI7G+dnHd0N9rn6d2daa1XQV3zj2U3T+
tWs3E1TToMRv6YqCk96//DE6f+zStSxNw+IkjLQATCpgJfTH4MIJiEh8LqiY
HbAJnXVFXQfhe/T3FzzMbL9FZW/Ik74gz1LDFK3N2p4m7zAgJEu/exSmOgGh
gRKDBP/Ng6U/1UII0U8vvsd20fC3ktqxdy7cJsd+be+VITvfVVsyNWPgBPLs
yclzVIvS2lhw1BOI0N+J2J/aR9HYDB1ZELL+T8RCROazetegsxYDdT+6eheN
+GjpkdiFl9cnRoSzQy4eaA8X0F+meHjv4ZBRBmfcTZX/MwwnLsxC4OHvz9z5
HP11jtGFBEDC10for38EJiww3fPWLn/WpCxw0ds9ip4G/0FrUvT3SNT9RfJt
ETTS0qMlPRSvxlFS8t1f/cLSUA71TZKfr3x0A0ZO8raTI62tGUgqVIFRKX5f
juSaTZyYcx9d+TxqWzyUP7/yGVMvnN/+FmHuqlQcM8KE/oDKCvXK57XX/7+n
Yrr8FWfX/dn/D8Q2TsA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288614722]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1246],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30529]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14847],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->32663]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->13057],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/FractionalPart.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/FractionalPart/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FractionalPart"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->451703054],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->68539315],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->139555106]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FractionalPart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 8.5170722}", "context" -> "System`", 
    "keywords" -> {"frac", "non-integer part"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FractionalPart[x] gives the fractional part of x. ", 
    "synonyms" -> {"fractional part"}, "title" -> "FractionalPart", "type" -> 
    "Symbol", "uri" -> "ref/FractionalPart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6256, 210, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69560201]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157535, 3449}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 81, 51, 1, 70, "ObjectName",
 CellID->9341],
Cell[2946, 84, 559, 18, 70, "Usage",
 CellID->27242]
}, Open  ]],
Cell[CellGroupData[{
Cell[3542, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4020, 124, 124, 4, 70, "Notes",
 CellID->126685801],
Cell[4147, 130, 316, 10, 70, "Notes",
 CellID->30959],
Cell[4466, 142, 397, 15, 70, "Notes",
 CellID->7139],
Cell[4866, 159, 381, 12, 70, "Notes",
 CellID->16892],
Cell[5250, 173, 496, 14, 70, "Notes",
 CellID->10553],
Cell[5749, 189, 250, 7, 70, "Notes",
 CellID->124085891],
Cell[6002, 198, 217, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6256, 210, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69560201],
Cell[CellGroupData[{
Cell[6640, 224, 148, 5, 70, "ExampleSection",
 CellID->559520252],
Cell[6791, 231, 81, 1, 70, "ExampleText",
 CellID->20717],
Cell[CellGroupData[{
Cell[6897, 236, 108, 3, 28, "Input",
 CellID->12446],
Cell[7008, 241, 176, 5, 36, "Output",
 CellID->679671612]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7233, 252, 216, 7, 70, "ExampleSection",
 CellID->28606],
Cell[7452, 261, 68, 1, 70, "ExampleText",
 CellID->25151],
Cell[CellGroupData[{
Cell[7545, 266, 130, 4, 70, "Input",
 CellID->1946],
Cell[7678, 272, 237, 8, 36, "Output",
 CellID->146783820]
}, Open  ]],
Cell[7930, 283, 120, 3, 70, "ExampleDelimiter",
 CellID->5570],
Cell[8053, 288, 218, 7, 70, "ExampleText",
 CellID->19423],
Cell[CellGroupData[{
Cell[8296, 299, 168, 5, 70, "Input",
 CellID->9118],
Cell[8467, 306, 256, 8, 36, "Output",
 CellID->668995702]
}, Open  ]],
Cell[8738, 317, 121, 3, 70, "ExampleDelimiter",
 CellID->11591],
Cell[8862, 322, 215, 8, 70, "ExampleText",
 CellID->23068],
Cell[CellGroupData[{
Cell[9102, 334, 353, 11, 70, "Input",
 CellID->6908],
Cell[9458, 347, 224, 8, 51, "Output",
 CellID->128525092]
}, Open  ]],
Cell[CellGroupData[{
Cell[9719, 360, 392, 13, 70, "Input",
 CellID->16709],
Cell[10114, 375, 346, 11, 51, "Output",
 CellID->747323442]
}, Open  ]],
Cell[10475, 389, 119, 3, 70, "ExampleDelimiter",
 CellID->710],
Cell[10597, 394, 59, 1, 70, "ExampleText",
 CellID->3745],
Cell[CellGroupData[{
Cell[10681, 399, 250, 8, 70, "Input",
 CellID->31562],
Cell[10934, 409, 324, 13, 38, "Output",
 CellID->263297960]
}, Open  ]],
Cell[11273, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->101516778],
Cell[11401, 430, 203, 7, 70, "ExampleText",
 CellID->595153280],
Cell[CellGroupData[{
Cell[11629, 441, 151, 5, 70, "Input",
 CellID->649745621],
Cell[11783, 448, 233, 7, 50, "Output",
 CellID->25632638]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12065, 461, 238, 7, 70, "ExampleSection",
 CellID->2310],
Cell[12306, 470, 60, 1, 70, "ExampleText",
 CellID->195120443],
Cell[CellGroupData[{
Cell[12391, 475, 233, 8, 70, "Input",
 CellID->506251593],
Cell[12627, 485, 274, 9, 36, "Output",
 CellID->88594855]
}, Open  ]],
Cell[12916, 497, 55, 1, 70, "ExampleText",
 CellID->24486],
Cell[CellGroupData[{
Cell[12996, 502, 198, 7, 70, "Input",
 CellID->8493],
Cell[13197, 511, 234, 8, 51, "Output",
 CellID->228660383]
}, Open  ]],
Cell[13446, 522, 124, 3, 70, "ExampleDelimiter",
 CellID->27046229],
Cell[13573, 527, 83, 1, 70, "ExampleText",
 CellID->85316167],
Cell[CellGroupData[{
Cell[13681, 532, 117, 3, 70, "Input",
 CellID->143897065],
Cell[13801, 537, 240, 8, 36, "Output",
 CellID->639957986]
}, Open  ]],
Cell[14056, 548, 125, 3, 70, "ExampleDelimiter",
 CellID->605917267],
Cell[14184, 553, 59, 1, 70, "ExampleText",
 CellID->99506518],
Cell[CellGroupData[{
Cell[14268, 558, 371, 11, 70, "Input",
 CellID->56743205],
Cell[14642, 571, 1187, 24, 70, "Output",
 Evaluatable->False,
 CellID->39905045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15878, 601, 223, 7, 70, "ExampleSection",
 CellID->25419],
Cell[16104, 610, 75, 1, 70, "ExampleText",
 CellID->426214396],
Cell[CellGroupData[{
Cell[16204, 615, 333, 11, 70, "Input",
 CellID->31902],
Cell[16540, 628, 1834, 40, 164, "Output",
 CellID->22371945]
}, Open  ]],
Cell[CellGroupData[{
Cell[18411, 673, 353, 11, 70, "Input",
 CellID->735088560],
Cell[18767, 686, 1229, 24, 70, "Output",
 Evaluatable->False,
 CellID->318977616]
}, Open  ]],
Cell[20011, 713, 125, 3, 70, "ExampleDelimiter",
 CellID->331911171],
Cell[20139, 718, 93, 1, 70, "ExampleText",
 CellID->396262046],
Cell[CellGroupData[{
Cell[20257, 723, 474, 16, 70, "Input",
 CellID->120406062],
Cell[20734, 741, 1563, 36, 166, "Output",
 CellID->790001769]
}, Open  ]],
Cell[22312, 780, 125, 3, 70, "ExampleDelimiter",
 CellID->654867703],
Cell[22440, 785, 99, 1, 70, "ExampleText",
 CellID->207147698],
Cell[CellGroupData[{
Cell[22564, 790, 246, 8, 70, "Input",
 CellID->187284816],
Cell[22813, 800, 548, 18, 51, "Output",
 CellID->472832085]
}, Open  ]],
Cell[23376, 821, 72, 1, 70, "ExampleText",
 CellID->386930541],
Cell[CellGroupData[{
Cell[23473, 826, 280, 9, 70, "Input",
 CellID->796981175],
Cell[23756, 837, 1041, 37, 71, "Output",
 CellID->200475789]
}, Open  ]],
Cell[24812, 877, 113, 3, 70, "ExampleText",
 CellID->202213467],
Cell[CellGroupData[{
Cell[24950, 884, 304, 11, 70, "Input",
 CellID->420602787],
Cell[25257, 897, 1719, 36, 75, "Output",
 CellID->264791406]
}, Open  ]],
Cell[26991, 936, 125, 3, 70, "ExampleDelimiter",
 CellID->252733927],
Cell[CellGroupData[{
Cell[27141, 943, 296, 10, 70, "Input",
 CellID->627109056],
Cell[27440, 955, 7825, 132, 70, "Output",
 Evaluatable->False,
 CellID->564878585]
}, Open  ]],
Cell[35280, 1090, 125, 3, 70, "ExampleDelimiter",
 CellID->135131888],
Cell[CellGroupData[{
Cell[35430, 1097, 421, 14, 70, "Input",
 CellID->72156770],
Cell[35854, 1113, 72536, 1193, 70, "Output",
 Evaluatable->False,
 CellID->4626062]
}, Open  ]],
Cell[108405, 2309, 125, 3, 70, "ExampleDelimiter",
 CellID->114770225],
Cell[108533, 2314, 92, 1, 70, "ExampleText",
 CellID->209508331],
Cell[CellGroupData[{
Cell[108650, 2319, 310, 9, 70, "Input",
 CellID->25913413],
Cell[108963, 2330, 7865, 133, 70, "Output",
 Evaluatable->False,
 CellID->15561310]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116877, 2469, 233, 7, 70, "ExampleSection",
 CellID->26335],
Cell[CellGroupData[{
Cell[117135, 2480, 245, 8, 70, "Input",
 CellID->609237933],
Cell[117383, 2490, 2583, 46, 70, "Output",
 Evaluatable->False,
 CellID->431209029]
}, Open  ]],
Cell[119981, 2539, 125, 3, 70, "ExampleDelimiter",
 CellID->244661483],
Cell[120109, 2544, 333, 13, 70, "ExampleText",
 CellID->251461377],
Cell[CellGroupData[{
Cell[120467, 2561, 230, 7, 70, "Input",
 CellID->4003],
Cell[120700, 2570, 1285, 44, 94, "Output",
 CellID->36762543]
}, Open  ]],
Cell[122000, 2617, 125, 3, 70, "ExampleDelimiter",
 CellID->597600705],
Cell[122128, 2622, 221, 8, 70, "ExampleText",
 CellID->280823093],
Cell[CellGroupData[{
Cell[122374, 2634, 483, 15, 70, "Input",
 CellID->64754430],
Cell[122860, 2651, 2435, 44, 70, "Output",
 Evaluatable->False,
 CellID->27185087]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125344, 2701, 226, 7, 70, "ExampleSection",
 CellID->28754],
Cell[125573, 2710, 231, 7, 70, "ExampleText",
 CellID->135387540],
Cell[CellGroupData[{
Cell[125829, 2721, 402, 13, 70, "Input",
 CellID->790272592],
Cell[126234, 2736, 640, 11, 70, "Message",
 CellID->77592756],
Cell[126877, 2749, 569, 17, 45, "Output",
 CellID->13336077]
}, Open  ]],
Cell[CellGroupData[{
Cell[127483, 2771, 104, 3, 70, "Input",
 CellID->556752000],
Cell[127590, 2776, 363, 11, 45, "Output",
 CellID->564821750]
}, Open  ]],
Cell[127968, 2790, 125, 3, 70, "ExampleDelimiter",
 CellID->407111086],
Cell[128096, 2795, 232, 8, 70, "ExampleText",
 CellID->318143903],
Cell[CellGroupData[{
Cell[128353, 2807, 194, 6, 70, "Input",
 CellID->214727424],
Cell[128550, 2815, 278, 7, 54, "Output",
 CellID->39979475]
}, Open  ]],
Cell[CellGroupData[{
Cell[128865, 2827, 194, 6, 70, "Input",
 CellID->134520022],
Cell[129062, 2835, 164, 5, 36, "Output",
 CellID->149777547]
}, Open  ]],
Cell[CellGroupData[{
Cell[129263, 2845, 271, 9, 70, "Input",
 CellID->31714491],
Cell[129537, 2856, 161, 5, 36, "Output",
 CellID->107822757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[129747, 2867, 228, 7, 70, "ExampleSection",
 CellID->285360355],
Cell[129978, 2876, 232, 8, 70, "ExampleText",
 CellID->39817554],
Cell[CellGroupData[{
Cell[130235, 2888, 710, 23, 70, "Input",
 CellID->131541232],
Cell[130948, 2913, 21644, 359, 70, "Output",
 Evaluatable->False,
 CellID->288614722]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152653, 3279, 310, 9, 70, "SeeAlsoSection",
 CellID->1246],
Cell[152966, 3290, 1168, 44, 70, "SeeAlso",
 CellID->30529]
}, Open  ]],
Cell[CellGroupData[{
Cell[154171, 3339, 314, 9, 70, "TutorialsSection",
 CellID->14847],
Cell[154488, 3350, 148, 3, 70, "Tutorials",
 CellID->32663]
}, Open  ]],
Cell[CellGroupData[{
Cell[154673, 3358, 321, 9, 70, "RelatedLinksSection",
 CellID->13057],
Cell[154997, 3369, 185, 4, 70, "RelatedLinks"],
Cell[155185, 3375, 203, 4, 70, "RelatedLinks"],
Cell[155391, 3381, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155820, 3399, 319, 9, 70, "MoreAboutSection",
 CellID->451703054],
Cell[156142, 3410, 148, 3, 70, "MoreAbout",
 CellID->68539315],
Cell[156293, 3415, 160, 3, 70, "MoreAbout",
 CellID->139555106]
}, Open  ]],
Cell[156468, 3421, 27, 0, 70, "History"],
Cell[156498, 3423, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

