(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61635,       1637]
NotebookOptionsPosition[     55203,       1417]
NotebookOutlinePosition[     56578,       1455]
CellTagsIndexPosition[     56492,       1450]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingTwoDimensionalGraphics"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Labeling Two\[Hyphen]Dimensional Graphics\"\>", 
       2->"\<\"Tables and Matrices\"\>", 
       3->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       4->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
          "Prolog" :> Documentation`HelpLookup["paclet:ref/Prolog"], "Epilog" :> 
          Documentation`HelpLookup["paclet:ref/Epilog"], "AxesStyle" :> 
          Documentation`HelpLookup["paclet:ref/AxesStyle"], "FrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/FrameMargins"], "Dividers" :> 
          Documentation`HelpLookup["paclet:ref/Dividers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Frame\"\>", 2->"\<\"Prolog\"\>", 
       3->"\<\"Epilog\"\>", 4->"\<\"AxesStyle\"\>", 5->"\<\"FrameMargins\"\>",
        6->"\<\"Dividers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Graphics Styling in Notebooks\"\>", 
       3->"\<\"Grids & Tables\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrameStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrameStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " and other constructs that specifies the style in which to draw \
frames."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all edges of the frame are to be generated with the \
specified style or graphics directive. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16787],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["left", "TI"], ",", 
       StyleBox["right", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["bottom", "TI"], ",", 
       StyleBox["top", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies that different sides of a graphics frame should be drawn with \
different styles. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7273],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15125]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1526293],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->216679939],

Cell["\<\
Specify overall frame style, including the frame, frame ticks and the frame \
tick labels:\
\>", "ExampleText",
 CellID->7911699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170076932],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219864157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197735942],

Cell["Specify the frame style of a grid:", "ExampleText",
 CellID->106618511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Dotted"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318063793],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   FrameStyle->Directive[
     RGBColor[1, 0, 0], 
     Dashing[{0, Small}]],
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{117, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->782491588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255047801],

Cell["Specify the style of each frame edge:", "ExampleText",
 CellID->84494844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Thick", ",", "Dashed"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81179046],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameStyle->{{
     Thickness[Large], 
     Directive[
      Thickness[Large], 
      Dashing[{Small, Small}]]}, {
     RGBColor[0, 0, 1], 
     RGBColor[1, 0, 0]}}]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->538146350]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15291],

Cell["\<\
Styles associated with lines affect frame edges and frame ticks:\
\>", "ExampleText",
 CellID->356019607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457869047],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87729127]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13225709],

Cell["Styles associated with fonts affect frame tick labels:", "ExampleText",
 CellID->23472827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Italic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140553305],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWluIVVUY3nMuc+Z+1bnbjOM46piO42XUvN9viQhFD+LDJIE+lKH2Ui/1
Ui/1Ui+FoIEVWD0YiREYREIkSEIkRAUxQdhDIiQ9CMHuX+tf6/xrf2udvff4
1sCcs9b+1/q//77WXuscnjl38rnnZ86dOjEzsu/MzIsnT504O7L39Bl6VKyL
ougq/Z/ti6gdU0v/X41j+nY/++izQKRB+i6Z76ioxuq/aIA+VNd+95vvgplX
rHKxsyLggn3LNSpJn/m6M/SISnUEPzW0gmAmeCBKn6tTKpo/QmEoI9bVwBoC
rN6wNIknA46t54a2IITmyD/keMmzYgpS0OqezJmeRHq9y4E/Gc+1QNF8F4z8
BSfK7Lii+ebZfvTyZ8XMMsGoEW18XtKPGkDqEkhdpu/z1cgqmLgpwqyiZ52S
96QtBUk1yxn0lgx6vfqo/PLzXx9+cPvihVufXblz794/Ross7CzeuWTzoimK
GnPZST3YoboNJPFL566dePbT9969STq89eaNZ57+iPQ56MyLomiO/N0RGqdI
ViKQm9/9bvz08OG/hEjQ1DgUSx5wdDWFUJwYQYztFuP0C5+TRjoKoyKhvfLy
lwQQHfQQlB4qJuvNN3Lcpvt37/5NUj948NDofeOb34ijah7wOPYaTjyTUEmW
Oz/+GTWr52Ta/YZeqI528baaUS129qmTV0ifaH8Qx525xepOM5Surbo/O3uf
JFf9fTk50HQSVzU5dt95+9tPPv5BNfdmctis+19d//W1V6+rZrvuk92OH7us
/BHmoKyx2epL0pLMUafuEzDBq+buVKttgtGdlhsFscLdkyn5EzCjO4Cfh8MX
13564/WvVbMbOIY5KJ1YelKcnKea8wB7Z6ruGyEi51ubHz1ySfl9V6bkzIFy
kBJFNXt0n0oAVTKLn85hQ2yyhHRVzV4bi6TUXDhQKaCao5q8e6HUuf39H7Gp
HmHrbQA790MMbk+13noY3Q/cfNyKy8+tTaaK+Nwlo3hllozSGVfijmZupKw4
fFSdqyAW9Kdjk+uUZ6o5CPbX2VUmIUiUKhSsrLzUOAXc00ahqu40+GoI4ncT
xE8hqVdilQhh+JpRKJsllbEkNzBv3b1UXQ3MsvEgrq3rdJ8CjsJONXmHR1wJ
XrAoSShVtF4elrunCa1PYUSx1GNxMhM5Myk0KUDDiHb9KhvfIOJaax/SQa1f
w3Ey3jl7pFoUPQSbZyyr1Jlhy/nQgYtqJnOS+md3e+G8Wwuajeg+TSUGcTVz
JP/Dcrkc14AmC8Gb0+DNUk6OotEoxCJbhJKAUmEuHEWrUfA/c5R6EeaorIra
LgJt2b5SkUup3lgNmo6BpmtA03KmpqshksdA0zWgaTbHKdB4MWi8GjSur2k7
1HYctJ0KaFvbdlOg6ThoOgWahuVyOa4CTZeApqtA00pOjqLxUtB4EjTOy1G0
Zo6Sv5OgdZijsipqu0z3pcqujJN5m1h/PbkmQVPmJvWPuZFryEGq2eDJ1eDy
l3UjDq8ZjEclkQqjak6AHVbEyYwP4+F7b9oastJqZOruct2Xiv442LMxjJjx
zqzqrbx9550RlatP2ARGGqnz2F8O9nt0aR1sDh7DWyy1Aiw1AfQmD9t9yw35
RuPKyQr9cU5NANIK8AnSfeSmOPle6iNxhZkAe3J0SF4uA7qPZPOQ97NSZZZa
65jMwcyq0h3r1c5L5i4Vh2uaZPkkWGgpWKg5KLePIJm3BPpYsZCeF0FkHgcL
TYGFkN5S0/ZFGDkOSLj2Ib051fZF0HQx9HGtRnpYbh9B5BkDfXAnhfTWnAgy
YwwQcT+E9GyEEmi9CPprwUqLILPCCLJmiCyjoMs6iPUq3WRWa6p3S8BtFNDW
AbdRQGvLtEwZLLEQNJ+GPtLzIojMIyAzvqWPgLfbcyKIlUYgItdn0MMIyiv8
bi77vWGIkw1gPaS3pXqX34+rb+7mDZGKKO39lOYbwXJI7/DkTuxv4PwCdzes
2/Fjl2dn76smvxHL7onfiKWqM132kWH0tJMNlKoCHBlB9pUsgZxFLACJa0iQ
egahZChWZZOdJ589yCkLn3PIPnwIfNUey71cXly33wCRwqc6cnrEZ6aytxyE
SOvMobt9t8FdJmNLxvHJlZyz8Fmx5EeVbjK2y8PGvRQihiWQjGQEOX/YAogD
EJu+BHaHYs9K8KypEezLZ4GyN90aJzO9H2LRR7Q1gu8x5DyuDyJrm+7L3qsP
xnfFaTWiCeKA6ZIzfCsi53O9oGd3UG4fQaKB6RQKFPyCINHQA76ZlxNB4qsH
vL0DooHpcg4YRlA2a4GR88EaO+NkBUF6d6rtm60nTb2dB57bFaQnT+vTLdMS
8JYblbuDdJE/L4LI2AU67AnSRYeeTIRWkJHvZ6Sy7Q3SRYcwgvIK31HJDVOH
7st6uA9k7wjIXtu7bRA77SCXvsu7eOFWu41Oc3vVl2kR5NQKSAcsR9KLksyT
JC+CrEbo5UNgKabLfWF/TZt3xu4dpdSdJ3Vf6iPnhtRH+7uWsK07rMbmvpQr
guTlYUs3N6JNEDMDnrxqBSlWX9N54bGn0rjT6bRxZLjz6iMV7YjukydIOuUP
pvNNuWoOeuh4Q46/b8D1rssikATqfrzeIhgJjlo6+UfZp7qjJRPQEL3zyXF7
7p+bOCN07WgkK1BMkKKUJhQvFBLkUIoakiV6yo4gKWkxoBHUJoPRCIpUcpXe
gT6KHOqBro71fF9PhZ44knlJZZRzAPr4Cxi9OtST94gPLUFkMaIRnyGDU5iL
fVL3bFm/z8iiz3X8/5Jf4PcpzSHbw8na+YSn3NOw9/VT/1dHUd1/LW1dAw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189054598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466432450],

Cell[TextData[{
 "Styles can be combined by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21248147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Italic"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348130125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->946533253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159354370],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " to specify the styles for individual elements in the grid:"
}], "ExampleText",
 CellID->236182765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}], ",", "b"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Item", "[", 
       RowBox[{"d", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameStyle", "\[Rule]", "Blue"}]}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275463759],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVEsOwiAQnRbQxvhfuWzjXXTlIUhj0i6Mpvb+OAP9ANLYTVUSYBjefJh5
4SLr4nqTdZnL9FzJR1Hmz/R0r1DFIgDIcB4PgLJCSc9MKdzNusN1q/UkAUPR
DFjiEk1wM0cJL/RuIxguAvW8Q85ITSrVDpSN1rKLgyjhemHdPSS/sB/3CitK
7PigWvGAFdWMkFowxlb9/B74L2GDSNH4FYOIcRwAMNzCUF3UtQndnVcm9T9E
UCVFUwU8WB0ULX8dvG7CQKd7VJgvs4m90Vv4V7Ih3vhs5sF8+l/Ay4c3VNbj
vc5+5/xoSdjC6SBlufjoeSxr9jg3qv9VIXoBYW/5Ug==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{33, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320435860]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " affects frame, frame ticks and frame tick labels:"
}], "ExampleText",
 CellID->730034636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178370624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50488903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " offers overall style of all the label-like elements, including frame tick \
labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168862781]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"FrameStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWl2IVVUUPt6f+XH+Z64z13FmHGdGMx1nRs0mG20yUxkroge1iB4mqcaH
0sxe6qVe6iV9KIqEyId+oJ8HIzECg0iIhEiIhKggDMIekiDpQQhua+2191nn
fmefc89VJMFzz9o/31rr22vtvc/ec9/8kYXHnpw/cmD//PCuw/OHFg7sf2Z4
58HDVJRfFATBKfp/rBzQe4XezP9TlQr9xp+P87NIbSruH7efM3VP8DMvdVy6
25QuREr5dS4szVHhbu1Z0DauVZIV1/McpSeb00e/7Eg/2LfE1pcjvxHbbGne
YI142egDxGUgl7y9epOxqphhzTxQi/g3xYoyaGX8hkD8u/Hal3pYrUerh/k6
tPvGtBqJNRdsFMT7L4n0ZznnbZVLscDvWRlw/a2SSzlj0mxxse1it9/26atk
j+n07OFxZeVF+j0W9kG+G2J8N0CLPMiFOuVr6t9I8qVLf5/96tcvzvxy8eJf
lju07Yborrd/LO4DM28Ugnj/oi3HUcAZwPRrunLl6vPPfb5vz/v0fPGFM488
/MGzR04TK201epej2oOBGj7MGPnnn/7c/+jHRLatP/fNbySf/+73YAe0l2we
rMHU7UYmYw8snKSnHTny6OBTnzLq3V5UMxfFMqYIbTcb+fLlf8hCxm5y2Fbe
7sVmzvM2vjnTxEJilFzl12YjX/jhD7Lw6tV/g222nbA4Cpi3Gfmz0z++/NKX
/Npi5PfePX/8zXP8us1rA6JMRzyhZ9BqZNJOrNGI1IXy2qtff/Th9/wq8UEs
kyf8emciCvs3HRl/fu0wMoUcJR+/3pHKw63QugPQZjN5sAl6dXlsyIqivboA
NRmF/ZPeNNdQnvFrD8THllQeboExkN5kCJnDr1szebDRjf89cyc4BmV1I4Ps
FLilDpRPTl44+spZfhUUMozMS0dh/8QTooyI096UXQ/c/w7bNJPKwwbgXHZY
lCSUKpVwtqnlgaCQ+eSEoiiqyb4C5bptn3WuWw/8LgVfTTQXyVeqD6HrwlbW
lwLrgh3WV2G79cK3vrAo2DJ1KjbNGLQ4sB+ShTRp0PRl9hiZGZkyMjFJSPwq
O2CNeokGzYqcd/yi65lvnRYtOjuKFlptaFlTLVRJTZK1LLOR50fXLFkGoyzo
FL5EWDK6jynWNgWxJyufRrTEKtFFpDn05PyYBE8HofcGQMd11Z8vk+DhEMhT
wAhGgR91wsi6jiyvVGflFIxiMirzMQm9lwO6oBEUATrPk3mcAA+HQZ4Aj3EP
4fd4Hdi0AmyeAI/rQVWUFaBlAjxPRmU+0PMRkMc9nifzOA62jIKt4+Ax5p7f
43FAGQUtUq9RXg+qejoG8hrnORXRHB40pvKInq8EmwRNM9PtG/08rgWPV0Lv
NYDut41nrnwQjwBBpylaljyLrp7eDHKTF70FSs1uM7bbxiwWy2lhoeWFX28C
T1aDp37dReuZmx3bk3Xb7ynyhsJOPNP5UrTrvmo18O7X3mS1diZqPRrQv1g/
N+bdydZqqRhhLdT1QjzQ7F4FcdecyFe0NJMFAmosyJ14+1sZOc3dVcCVX3NV
DDaEtWFwCYqutmHs2flG6jUr/VpcFuYgmiSndb+xFtgb87AHWdkQZUnicqVl
BGezMWBkcaKt5kQiRNVMGwM21gIbUq+Zm6IhUoqsjAAr64AVqdccxUyv5jwP
HEpv3Z2tA5akXnNwcZzz2EmAjr+sdrI3VXRlaAQYSrY9rkVHTtZ/3cfKbkO/
BYeBodY6tChTw8DUJDAl9foVmKwlF87yytRyYGoSmMI9TkvqOBSAoSGIofUQ
Q0PgK54y+RkqQC9G4UzDXfEQWJMNHRkahFgJv+dsNg6C3J7KfwOM1gDEiHxH
axYOgE9tqfyL7boODAADGwFtALT5ba917iY+6Rdtv2OESOMTpk3AaFhvY6zj
OrTqt24/+CZadQaRev1Wzq41H46bfv32QyTjSY7Ua161VaKn6LV8k52aziRl
0D4N6GXQ3un1LXrTFHjWe9Gq+5wyMDwNDJaBYb/WgUp05kFtmjdliCLRpmdA
ZYgiv7ZazMpeTTPC3KZE8m8zjGsvRFWXV6vLbtl3aP71gjZB15mrF8a5s5KW
3YKuJzIlx6DNoxlgsOSihkjj1+5E2+NaNApKEAUzEAUliIJsWmRPonuYHpBn
IDp6nGznlJ7UcWgBm7vBJzkZ1VlY6vVkvTt1HBYD793A+1bHu83Wbq+vtRgy
Ky2tal1g+yzYLnmg+4FSZvQov53gwyz40OHakxt837EkUQvzJiut7lnawYdt
4EM7jFcplf/wxsLGQhvYdlfFzhwkV9Xb9r2ZGGoDm1vBp+0QM62QB9m0iOc6
30hsUaDQUDDvchOmOS/1emOEf01QPQ4dbhTtjVizY8Le9ex09cQUR0GzY87e
avWljkN470K26AmA+rLLyGQ4zZ1sK9bjHaKe6/LnJZ4JSITKTMzaZEXWvctc
pF5P3+iNxo+axO4/42siv+Iq1eV8IIb4pjLvtBCDjHqvixKKLa2nN2KQSmP4
yee+fARhtDXSeBBJs1uPE687tr9F/vARO54g+25go3KPD4uqKbbMWb7e1nrX
zGu7nyeifGe9/8sd+XX0z7lRZ2c8dwvXekc/5NEDfycRO295veLilDu+YaT4
X148LWYF1XGssrm9Cg5BaSPIZs8V7KFn0Z2fufuiQtjKW5IDJPk7FG1hGlkr
9vpsjbXNZdAaLykAtrmlCvZBaZPffr8N6JWTgyRtD0JpoQ4ecdzymTRgq0K9
TCX68pCPgQw8+cYvwaqaOvNR/orR/k4X1kQ8qtIn8bfH27oXtPpzY6+1pRVq
m0H25188b4NF/wG9EnT1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203869841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->657512805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " affects frame ticks and frame tick labels, but nothing else:"
}], "ExampleText",
 CellID->715340404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423721885],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94762632]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 ", but has lower priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->336383769]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9644],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prolog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prolog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Epilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Epilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dividers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dividers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10484],

Cell[TextData[ButtonBox["Labeling Two\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"]], "Tutorials",
 CellID->15199],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->624098088],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->110319020],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->94268497],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->27317671]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrameStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 18.7517092}", "context" -> "System`", 
    "keywords" -> {
     "box style", "frame style", "frame ruler", "graphics frame style", 
      "grid frame style", "plot frame style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrameStyle is an option for Graphics, Grid and other constructs that \
specifies the style in which to draw frames.", "synonyms" -> {"frame style"}, 
    "title" -> "FrameStyle", "type" -> "Symbol", "uri" -> "ref/FrameStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11266, 300, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1526293]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56350, 1443}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3128, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3751, 95, 4194, 83, 70, "ObjectNameGrid"],
Cell[7948, 180, 759, 24, 70, "Usage",
 CellID->29744]
}, Open  ]],
Cell[CellGroupData[{
Cell[8744, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9222, 226, 382, 10, 70, "Notes",
 CellID->16787],
Cell[9607, 238, 606, 19, 70, "Notes",
 CellID->7273],
Cell[10216, 259, 1013, 36, 70, "Notes",
 CellID->15125]
}, Closed]],
Cell[CellGroupData[{
Cell[11266, 300, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1526293],
Cell[CellGroupData[{
Cell[11649, 314, 148, 5, 70, "ExampleSection",
 CellID->216679939],
Cell[11800, 321, 139, 4, 70, "ExampleText",
 CellID->7911699],
Cell[CellGroupData[{
Cell[11964, 329, 380, 11, 28, "Input",
 CellID->170076932],
Cell[12347, 342, 3092, 55, 138, "Output",
 Evaluatable->False,
 CellID->219864157]
}, Open  ]],
Cell[15454, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->197735942],
Cell[15582, 405, 77, 1, 70, "ExampleText",
 CellID->106618511],
Cell[CellGroupData[{
Cell[15684, 410, 399, 12, 70, "Input",
 CellID->318063793],
Cell[16086, 424, 494, 16, 88, "Output",
 CellID->782491588]
}, Open  ]],
Cell[16595, 443, 125, 3, 70, "ExampleDelimiter",
 CellID->255047801],
Cell[16723, 448, 79, 1, 70, "ExampleText",
 CellID->84494844],
Cell[CellGroupData[{
Cell[16827, 453, 492, 15, 70, "Input",
 CellID->81179046],
Cell[17322, 470, 424, 15, 162, "Output",
 CellID->538146350]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17795, 491, 216, 7, 70, "ExampleSection",
 CellID->15291],
Cell[18014, 500, 115, 3, 70, "ExampleText",
 CellID->356019607],
Cell[CellGroupData[{
Cell[18154, 507, 314, 9, 70, "Input",
 CellID->457869047],
Cell[18471, 518, 2896, 52, 70, "Output",
 Evaluatable->False,
 CellID->87729127]
}, Open  ]],
Cell[21382, 573, 124, 3, 70, "ExampleDelimiter",
 CellID->13225709],
Cell[21509, 578, 96, 1, 70, "ExampleText",
 CellID->23472827],
Cell[CellGroupData[{
Cell[21630, 583, 315, 9, 70, "Input",
 CellID->140553305],
Cell[21948, 594, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->189054598]
}, Open  ]],
Cell[25043, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->466432450],
Cell[25171, 657, 210, 8, 70, "ExampleText",
 CellID->21248147],
Cell[CellGroupData[{
Cell[25406, 669, 383, 11, 70, "Input",
 CellID->348130125],
Cell[25792, 682, 2982, 53, 70, "Output",
 Evaluatable->False,
 CellID->946533253]
}, Open  ]],
Cell[28789, 738, 125, 3, 70, "ExampleDelimiter",
 CellID->159354370],
Cell[28917, 743, 237, 8, 70, "ExampleText",
 CellID->236182765],
Cell[CellGroupData[{
Cell[29179, 755, 580, 19, 70, "Input",
 CellID->275463759],
Cell[29762, 776, 560, 13, 70, "Output",
 Evaluatable->False,
 CellID->320435860]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30371, 795, 233, 7, 70, "ExampleSection",
 CellID->13654],
Cell[30607, 804, 231, 7, 70, "ExampleText",
 CellID->730034636],
Cell[CellGroupData[{
Cell[30863, 815, 435, 13, 70, "Input",
 CellID->178370624],
Cell[31301, 830, 3209, 57, 70, "Output",
 Evaluatable->False,
 CellID->50488903]
}, Open  ]],
Cell[34525, 890, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[34653, 895, 265, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[34943, 907, 658, 20, 70, "Input",
 CellID->852841955],
Cell[35604, 929, 3116, 55, 70, "Output",
 Evaluatable->False,
 CellID->168862781]
}, Open  ]],
Cell[38735, 987, 364, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[39124, 1003, 712, 21, 70, "Input",
 CellID->610817034],
Cell[39839, 1026, 3100, 55, 70, "Output",
 Evaluatable->False,
 CellID->203869841]
}, Open  ]],
Cell[42954, 1084, 125, 3, 70, "ExampleDelimiter",
 CellID->657512805],
Cell[43082, 1089, 252, 7, 70, "ExampleText",
 CellID->715340404],
Cell[CellGroupData[{
Cell[43359, 1100, 540, 16, 70, "Input",
 CellID->423721885],
Cell[43902, 1118, 3119, 55, 70, "Output",
 Evaluatable->False,
 CellID->94762632]
}, Open  ]],
Cell[47036, 1176, 371, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[47432, 1192, 697, 20, 70, "Input",
 CellID->131785817],
Cell[48132, 1214, 3189, 56, 70, "Output",
 Evaluatable->False,
 CellID->336383769]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51382, 1277, 310, 9, 70, "SeeAlsoSection",
 CellID->9644],
Cell[51695, 1288, 1427, 53, 70, "SeeAlso",
 CellID->31351]
}, Open  ]],
Cell[CellGroupData[{
Cell[53159, 1346, 314, 9, 70, "TutorialsSection",
 CellID->10484],
Cell[53476, 1357, 182, 3, 70, "Tutorials",
 CellID->15199],
Cell[53661, 1362, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[53811, 1367, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[54117, 1378, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[54300, 1386, 319, 9, 70, "MoreAboutSection",
 CellID->624098088],
Cell[54622, 1397, 175, 3, 70, "MoreAbout",
 CellID->110319020],
Cell[54800, 1402, 166, 3, 70, "MoreAbout",
 CellID->94268497],
Cell[54969, 1407, 139, 3, 70, "MoreAbout",
 CellID->27317671]
}, Open  ]],
Cell[55123, 1413, 50, 0, 70, "History"],
Cell[55176, 1415, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

