(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59966,       1538]
NotebookOptionsPosition[     54028,       1335]
NotebookOutlinePosition[     55427,       1374]
CellTagsIndexPosition[     55341,       1369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"], "FrameTicks" :> 
          Documentation`HelpLookup["paclet:ref/FrameTicks"], "TicksStyle" :> 
          Documentation`HelpLookup["paclet:ref/TicksStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrameStyle\"\>", 
       2->"\<\"FrameTicks\"\>", 3->"\<\"TicksStyle\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrameTicksStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrameTicksStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for 2D graphics functions which specifies \
how frame ticks should be rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " gives styles for both frame tick marks and frame tick labels."
}], "Notes",
 CellID->12167170],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameTicksStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all frame ticks are to be rendered by default with the \
specified style."
}], "Notes",
 CellID->6849],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ". Styles can also contain rules for options such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15125],

Cell["\<\
Style specifications can refer to styles using style names from current \
stylesheets.\
\>", "Notes",
 CellID->797803519],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellID->3528],

Cell[TextData[{
 "Explicit styles specified in the setting for ",
 Cell[BoxData[
  ButtonBox["FrameTicks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicks"]], "InlineFormula"],
 " can override styles specified in ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->39190952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459646201],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->193505522],

Cell["\<\
Specify overall frame tick style, including frame tick labels:\
\>", "ExampleText",
 CellID->108500934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3077879],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->752594150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27066729],

Cell["Specify frame ticks style for each edge:", "ExampleText",
 CellID->5392742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Black", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747103243],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47034266]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Styles associated with lines affect frame ticks:", "ExampleText",
 CellID->356019607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457869047],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWktoXUUYPr335v1+NLlJWpOmafqyTdI2TR/W2mesbSkFxYW4iEVoF1pp
60Y3utGNbnSjCC1YFXwsKpaKUEEsiIViQSyIClJB6sIiWFwUhOP/z3/m/HO+
mXNvcmsguTN3Zv7v//7XzJmTw3Nnjj/9zNyZE8fmRmZPzT13/MSx0yP7T56i
r4qLoii6SL+nyxG1Y2qZ34txTJ/u3zL9LdDQEH2Wks+oyHPNTzTojPMn93m4
kPSLRko//y3pqqycKCB3wFvhfzPofcOoTG0Rf+YgLwGkcsLMl/Z/IS4FxP4Q
dw+nEBypBc/1YTHIojZeYTmFgI1rs2TZkRaS6sac+1mM3djzY1r+NsQaqa5U
XnnezGiEkaKncx19vGNlWEDzk+JXXc8z3ZWWlWXNekZ1P//05/vvXT939tqn
F27cvv1P1AGzhgKSCgtgwWv3cLeRpD9/5tKxpz55+62rhPf6a1cef+wDwj6U
zFqIVHfGLtMnHiT66re/RSWz4u7dfwmHAKlx0IuAhaM8ZFFOPvsZ28lYr0h4
L77wBUFEj3gYDQmveufTlbjT9G/d+pv0vnPnbtRk+le+/pUkcvOAJ7E/kSQr
CZV0ufHDH1ELf08mfThjSXc2j7baVSeOXyAe0aw329Vuh+VLs5lfm+nfvPkX
acv92aB2vgRaTipys93033zjm48/+p6b+3P5ycovL//y8kuXudlh+mSjJ5/4
kG2/L8jzAcuPNCQ9oy7TJzCC5Obeiny3w+wuK42C1GJW5rsNVvQE8Ocj4fNL
P776ylfc7AGJYQnMSbQn4uQwbvYC9u6gxbZBxC22dj565Dz72F/larvV9CnD
KAm42Wf6lNZUSSxmZb5bbAYQP27225gjIvkSWCPBpgSn+sHNsulTOlz/7vc4
yVaf7xaw5wDEmb/K1XYGZg+AtF2etrYCuPXa1nCsBjOQLYOQLSYnStIRMaKl
kZOpXA0gGXeLzXGSyZRN3BwCq5s8qiM1SJlUaM5OJGXSAQ+i88wZ8NgSiNjt
ED2FBTJUDApecodiaBaYeC+lHst420exuxd6atr0KdAo3LgppyKSR8ApCu8M
lBqGiRcXYSwXA/vTYJ374mzuST5QYFJ4hjFtLNpPRNgUJ9FMLHg3Go6z0S65
o7Wh6CHYLBNdtaoMW8kHD5zjlSJJq5w90RcCUpTRiOnTEloYp/miGe9Lcdlt
BO2XgQ83gw9LQXa+RGUxCrEn+lOwU8jnS2SNNwGTUfC1SNLKYKM9ay9kuBwY
CorW2lJFe20AdmPAbiOwq6tqrw0QsWPAciOwrC5xChivAMYbgHF9rgeQ7Tiw
nQqw9T2ADMeB4VSAYb4HJoHdSmA3CewaqtprEliuApYTwDIskTWeAqYiSXNz
ApjaE3DWXshwtelr3VwfZ3OywZPispsAdiJN65lII1eQQ7jZ6LFrjP3dmpuh
ailoVOCozHFzDVhgXZzNaR/N7GGZPaAU/sZBXW85JZV0relrjb4fLNpUM6o+
e853RfqMKEZIdNH6jf21YEFr/YWhRnXpNxI4iVy10Tqw0RoYb67dM/XpN/Qj
ebQG0NaBR3DcR7d2sDmTqRJONVkN9pTY0JzE8aY4lIMiVavKKmudJGswq9Jx
x3r5OSnStcJIDdMMnwDrrALrtHjWCSNo3q2E/iRYBcfni6A6j4OFpsBCON4a
RNA6ozPHAQn3NxxvCXq0BAxXQB93KRz3pfrPEqrDGHDAUxGOt1W1N1plDBDx
nIPj1RHQQsuhvwkstBwyKYygu4TqMgpcpiG+0/Ekm9qCHq0DKaOAMg1SRgHF
l+o/aSj7ZcB2M/RxvL2qvdEqI6AvPlePgIc7cu1dD5YZgeibqTLeHrS3PF1q
pR2GeNgCFsNxX6prDdE5fbpOnuSoQNI5jtluBWvheKdnjdC5hTfj0LlFuNGD
Pz3+c1OeXfVUJM+uWrFlXM+EPrq/W+LTOd6DN4BMwdDTouigNwVLQedadWB7
NFprJmdKuSHQuxC5hdBT9RLwVmdc+ZSSh9sEMSJ3Lnq7I3eXel4cghirhmtP
Cehv4au5JbdKemclN62aEel4kpvd87A1YuKptdHKTLJQMPR+YAdgDkJM+jrY
iLdPBPb82QxWlRs6PWM+GGczewAirysO1QORqvdjZYihnaavZ6gyzO/2pLrW
aQbPy7hmh7x30HuyfuDY41knjKAxIOMUABTmiqAx0Af+6J0ngkZVH3h4F0SA
jOu9XBiBbdYKMxeDNXbH2VqB4z1Bj7ZaDyY1tRc8tic4rnx6K3q0NeAhNwr3
BsdV58VV7Y36d4P++4Ljqn9frr3xHY28BdG6tT84ntXdt7dI1fc3naave9ws
6NsZ0Dff3u0QIx2gk3krdu7stQ4bhcn7oXJVO6OkNkA6YCUSL0omT5P5Iuj+
gp49CJaScX0LN5Drya7Yfeun9eVQnK2BLXG2Btp34wVPmvvGsRny7rAdT94t
hipx9h1v3hty3E26bOwkkmU30Wp1xPTJ+qQZ+0DG5f0yN4c8CzUBgv/uF3ew
botBOvAb5nqLkehw1I6TV9g66YmdDEBTzAnmXnUwVaKJ7ECRQFQpOShKKBDI
jRQrpEv0qJ1BWlKppxnUJpPRDIpPcpQ5S9aiB77/N7rUy7tvKukknYxN9O1p
B/93wOyIJfIZzadNhaxU+T8LatPKPQOFblCwf6/zFrq+Vp56F4d3Q++ab/3/
QIkW/QfByPyE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1031072812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13225709],

Cell["Styles associated with fonts affect frame tick labels:", "ExampleText",
 CellID->23472827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Italic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140553305],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWluIVVUY3nMuc+Z+1bnbjOM46piO42XUvN9viQhFD+LDJIE+lKH2Ui/1
Ui/1Ui+FoIEVWD0YiREYREIkSEIkRAUxQdhDIiQ9CMHuX+tf6/xrf2udvff4
1sCcs9b+1/q//77WXuscnjl38rnnZ86dOjEzsu/MzIsnT504O7L39Bl6VKyL
ougq/Z/ti6gdU0v/X41j+nY/++izQKRB+i6Z76ioxuq/aIA+VNd+95vvgplX
rHKxsyLggn3LNSpJn/m6M/SISnUEPzW0gmAmeCBKn6tTKpo/QmEoI9bVwBoC
rN6wNIknA46t54a2IITmyD/keMmzYgpS0OqezJmeRHq9y4E/Gc+1QNF8F4z8
BSfK7Lii+ebZfvTyZ8XMMsGoEW18XtKPGkDqEkhdpu/z1cgqmLgpwqyiZ52S
96QtBUk1yxn0lgx6vfqo/PLzXx9+cPvihVufXblz794/Ross7CzeuWTzoimK
GnPZST3YoboNJPFL566dePbT9969STq89eaNZ57+iPQ56MyLomiO/N0RGqdI
ViKQm9/9bvz08OG/hEjQ1DgUSx5wdDWFUJwYQYztFuP0C5+TRjoKoyKhvfLy
lwQQHfQQlB4qJuvNN3Lcpvt37/5NUj948NDofeOb34ijah7wOPYaTjyTUEmW
Oz/+GTWr52Ta/YZeqI528baaUS129qmTV0ifaH8Qx525xepOM5Surbo/O3uf
JFf9fTk50HQSVzU5dt95+9tPPv5BNfdmctis+19d//W1V6+rZrvuk92OH7us
/BHmoKyx2epL0pLMUafuEzDBq+buVKttgtGdlhsFscLdkyn5EzCjO4Cfh8MX
13564/WvVbMbOIY5KJ1YelKcnKea8wB7Z6ruGyEi51ubHz1ySfl9V6bkzIFy
kBJFNXt0n0oAVTKLn85hQ2yyhHRVzV4bi6TUXDhQKaCao5q8e6HUuf39H7Gp
HmHrbQA790MMbk+13noY3Q/cfNyKy8+tTaaK+Nwlo3hllozSGVfijmZupKw4
fFSdqyAW9Kdjk+uUZ6o5CPbX2VUmIUiUKhSsrLzUOAXc00ahqu40+GoI4ncT
xE8hqVdilQhh+JpRKJsllbEkNzBv3b1UXQ3MsvEgrq3rdJ8CjsJONXmHR1wJ
XrAoSShVtF4elrunCa1PYUSx1GNxMhM5Myk0KUDDiHb9KhvfIOJaax/SQa1f
w3Ey3jl7pFoUPQSbZyyr1Jlhy/nQgYtqJnOS+md3e+G8Wwuajeg+TSUGcTVz
JP/Dcrkc14AmC8Gb0+DNUk6OotEoxCJbhJKAUmEuHEWrUfA/c5R6EeaorIra
LgJt2b5SkUup3lgNmo6BpmtA03KmpqshksdA0zWgaTbHKdB4MWi8GjSur2k7
1HYctJ0KaFvbdlOg6ThoOgWahuVyOa4CTZeApqtA00pOjqLxUtB4EjTOy1G0
Zo6Sv5OgdZijsipqu0z3pcqujJN5m1h/PbkmQVPmJvWPuZFryEGq2eDJ1eDy
l3UjDq8ZjEclkQqjak6AHVbEyYwP4+F7b9oastJqZOruct2Xiv442LMxjJjx
zqzqrbx9550RlatP2ARGGqnz2F8O9nt0aR1sDh7DWyy1Aiw1AfQmD9t9yw35
RuPKyQr9cU5NANIK8AnSfeSmOPle6iNxhZkAe3J0SF4uA7qPZPOQ97NSZZZa
65jMwcyq0h3r1c5L5i4Vh2uaZPkkWGgpWKg5KLePIJm3BPpYsZCeF0FkHgcL
TYGFkN5S0/ZFGDkOSLj2Ib051fZF0HQx9HGtRnpYbh9B5BkDfXAnhfTWnAgy
YwwQcT+E9GyEEmi9CPprwUqLILPCCLJmiCyjoMs6iPUq3WRWa6p3S8BtFNDW
AbdRQGvLtEwZLLEQNJ+GPtLzIojMIyAzvqWPgLfbcyKIlUYgItdn0MMIyiv8
bi77vWGIkw1gPaS3pXqX34+rb+7mDZGKKO39lOYbwXJI7/DkTuxv4PwCdzes
2/Fjl2dn76smvxHL7onfiKWqM132kWH0tJMNlKoCHBlB9pUsgZxFLACJa0iQ
egahZChWZZOdJ589yCkLn3PIPnwIfNUey71cXly33wCRwqc6cnrEZ6aytxyE
SOvMobt9t8FdJmNLxvHJlZyz8Fmx5EeVbjK2y8PGvRQihiWQjGQEOX/YAogD
EJu+BHaHYs9K8KypEezLZ4GyN90aJzO9H2LRR7Q1gu8x5DyuDyJrm+7L3qsP
xnfFaTWiCeKA6ZIzfCsi53O9oGd3UG4fQaKB6RQKFPyCINHQA76ZlxNB4qsH
vL0DooHpcg4YRlA2a4GR88EaO+NkBUF6d6rtm60nTb2dB57bFaQnT+vTLdMS
8JYblbuDdJE/L4LI2AU67AnSRYeeTIRWkJHvZ6Sy7Q3SRYcwgvIK31HJDVOH
7st6uA9k7wjIXtu7bRA77SCXvsu7eOFWu41Oc3vVl2kR5NQKSAcsR9KLksyT
JC+CrEbo5UNgKabLfWF/TZt3xu4dpdSdJ3Vf6iPnhtRH+7uWsK07rMbmvpQr
guTlYUs3N6JNEDMDnrxqBSlWX9N54bGn0rjT6bRxZLjz6iMV7YjukydIOuUP
pvNNuWoOeuh4Q46/b8D1rssikATqfrzeIhgJjlo6+UfZp7qjJRPQEL3zyXF7
7p+bOCN07WgkK1BMkKKUJhQvFBLkUIoakiV6yo4gKWkxoBHUJoPRCIpUcpXe
gT6KHOqBro71fF9PhZ44knlJZZRzAPr4Cxi9OtST94gPLUFkMaIRnyGDU5iL
fVL3bFm/z8iiz3X8/5Jf4PcpzSHbw8na+YSn3NOw9/VT/1dHUd1/LW1dAw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214538758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466432450],

Cell[TextData[{
 "Styles can be combined by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21248147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Italic"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348130125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40888205]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " affects frame ticks and frame tick labels, but nothing else:"
}], "ExampleText",
 CellID->242285675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404749038],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WkuMFUUUbd5vmP+bGQYGBpgPMODAMIDIIN8R+YiEGBcGlLgYiTosFIK4
0Q1sdKMm6kLYyMJP4meBkWBMhsRIYiQxkhhJjJIYTAwuJCYSFyQm7b11q/v2
O1X9+s3PCbxXt7rr3ntO3XuruvodHDs1/vRzY6eOHR3r3Xdy7MT4saMv9O49
fpK68nOCILhI/9/oCqgdUsv8vxiG9O1+PsOfBb7D/FHjYfP1LH/mpT+Ie8cT
vdzcH/fmMkam2Z/aZ7+xGAYL6btgv8lmGPnVlbjO3yzz5ZyV80ZLn2CPR1Xq
Yd5Q7wJnhNvT5fSwVZ6KOfydYnkRWJpvkbnaZspiN1js9GF37ESsTt/e/IS2
vBfF1HD59eQ8HE+Nyf6ENp/WZMwlv/NhMvbcmO6yM37WSBiJRcMS/eVNPpu/
wiTltmmOn648I/YLKgdmdoKgwzKXh5kohJW1LQxKvjuqyF6N05WLIt+69fe1
73+nT0Exg1ZmxetEVkS8Y0bn7Tz4MsLRV3f9xz+OPvXpocc+PP785/RJ7avf
/ha0wL1dHl0Fm5d+D5Lr03Yjf/D+tWPjF375+U97nVovnrpEvcG+kLM7SGS3
WwGKoHObkc+/+925s1e5KTFFAnVxc4+jM6oIJdC01ciffPzD2299w825RiaB
uri529HUZzXJSGKQuLt799+gwcgEiijk5i57Xy4elbR7v5Hv3LlLnHP8NRr5
9u1/njzyEfUGD3rtuhoIM5HIzSYjf3bh+uuvXYnsV9ewOZoJ8oGbMu8kUBc3
H0jFLrZffunLK1//qiOJC5pjbo5GMSHGAr/9EbBfBq2jmQhGYEQZNGZr2ASe
t4PGnTVq0BHtoNGvgVncBN7OA/63V42g+4xMk01TrqPJCXKFmzsyPd8YxRyl
Pkew7D6oRTL11qxBs8fsJygH/SMZi3hNBijooxHGh0cfeS+0mZ2O+V4jU4JR
moVxZdKc2+bYjXY2WEFE05nTE5cnbqgmZc9EeEFgGUXWI6yrBdC7AThdCJya
nCvG0SGqa1hDWdwAbIsvWqtGEhHBuac81uY1uUSOqWaN4U2AIufwnGVhvZFp
0kkDNxcbmYrdzZt/aTQr/1OzwLG3xPRTUbRrg2jW/HQ1J9eGXMyz+rYYYhTz
Jt47VK1268LKbF9qZFo8aAeiEan1O+/46deoK4Bo/OLST6++8pVq1FmtVaNm
p2ik9YiQM9INMIuFTI3DEEm9YWXGrofZ8mvkWUG0vYB2vQdteiUZBqS9gHQd
IC1mIl0LSPsB6TAgrVWjIu4HxMOA2K+ROUC0/YB2rQdtOndDgHQ5IB0CpKVM
pEOAdDkgHQKktWpUxMsB8RpAXJfKHaIdALSrPWjTuVsDSAcA6WpA6voVPfPi
irYGEA8A4kFAPNfR7J4pYI1dDVysAi7uCStrmGujIZRzqma/LX1SpGo9CFyt
Au1iTSuoaw05yoHc5PXizXhF5vFFklr93hZjTeKk9VD5GQQPVwKCesfjueBh
S5ZlMWYtK1eDYGkleOJajk432pPxVYrt0J/E1kqIM7Gkq+MAyA2OpSizZDZ0
B7vCyLTo0tIbxhGtPq/wsAeZVuEvDaPB7A/vC4Zg9ArQ7vfTjZ4D+89TUoVx
TdF9AtaUuObQEG421miBSgEVBG4uA0akTmt1kOtaPfwW4hOvxM55mWUFVyXR
qBnd4HLs+EvVheaan1qXASO4ruC605TJSB4Y6QNG1gEjfcBIrRYkViINzAzu
TPqAGb9mrcwEkZKAm73ACu4tcO8hT/JZ+0mpzZo9PcAM7ul7gJnmTGYKwEyP
ZUb2lfocIpo1k7I1I0NLgaH4KcrWkKUgt9RoQdmRpwKtzBvBZ7mu1cFvQU+Q
VJOM1Mq7ETQt8bDjzi6v6nnPilsCZuRZRKsvPovgs0qrgyPrvK4Ecd8NUYDn
Hd1w/1Qtqs/dMHdiUZ8Nu4GT2iyyWBdW5nD8dE4VmtkbiWT7nIvPwS2hvsPK
xiXWLk/cOHN6Qq1pZGyGyJHrWuvKk2ayDvCIRj1REotaI7rg/jbHYtpuE89J
zXucxNPtlrCy+sh1rT6upSi/6kHTAoiGLcCiXNf8KofVVqx68Cs+87IMbAV5
PnjT7vXbtaDR2gn+bgPmOkGu1YJGaSfMsljQ9UVOBnV96UjlXk6hNZc7jKy7
hh1hZe7LdV0J2qP4rLpyyUm51qwO0LoDrLYD3nmZDDUCp20wi6PAWBvgqNWC
YmgDDKMQBWXPnFW30AQYWgHDLsDQChj8FniWm8H3VsiJXWCpxeN7eoY1gx/N
wMRuI+vJK1/nXcWCTEaaIz/IL6phliH1aw/gkut0J93PcraFlgg5kcEjMI72
hpVVrBGY81tgrsqQWZLDuqo+BPFTb1mJ3lz7uS4Dl3URYnKJ9+PmtyGc+SQz
Y1K1K1ck9wyg4NmHxPFLLtJ4u2ZLjPD7qwOhrTn2LV8pskT3M5OLHEvJ81yu
GGjRZFSBxpKv9I+UGg4KZIMmRAAeND004+QFkUUNuYdullE0vNuxnPbO1NSZ
evKZtO3cfo5WAAokmnlSYn3EkfhW1VTaEnlClZaGkxK6RgoXhck3pothlPis
yCfxjtw+ic7K2+ZZlNFfeY60YIihyf5GIO3tuI/p6f6CY7rj/295Vvz1/ALE
PT18J4zynCuY/KbG/c3NibAy73FPa3ZkwXHoxf2o2RUGh0I5r8vbeWbP+EhI
bjd/toE5Fzh2zRvA4LD/vooeV1d17UGqtcc9KHM1WsD6iWedYuEJz125aPSM
WDhiHI97U/mOLEdzo/cW7BU/R0c8XuSjYfEc52KShXKwn2p7q9dGGeQ6r2eH
vMg7PHPqRu5hi6IBruJ5sD873KwK5vwHNBW87A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48508181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " controls overall style of all the label-like elements, including frame \
tick labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320446589]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169056188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468017888],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " affects the style of the frame, frame labels, frame ticks and frame tick \
labels:"
}], "ExampleText",
 CellID->2867181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82910697],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9258541]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " and has higher priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9798752]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11991344],

Cell["\<\
Individually styled frame ticks can be used with other styles, and have \
higher priority:\
\>", "ExampleText",
 CellID->145936691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", "0"}], "}"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69778533],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->17768930]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->273517680],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->330860775]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrameTicksStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 21.8455384}", "context" -> "System`", 
    "keywords" -> {
     "frame ticks style", "styling of frame elements", "graphics frame", 
      "plot frame", "grid frame", "ticks style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrameTicksStyle is an option for 2D graphics functions which specifies \
how frame ticks should be rendered.", "synonyms" -> {"frame ticks style"}, 
    "title" -> "FrameTicksStyle", "type" -> "Symbol", "uri" -> 
    "ref/FrameTicksStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7516, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->459646201]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55198, 1362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1661, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2284, 67, 1580, 37, 70, "ObjectNameGrid"],
Cell[3867, 106, 494, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4398, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4876, 142, 246, 7, 70, "Notes",
 CellID->12167170],
Cell[5125, 151, 236, 7, 70, "Notes",
 CellID->6849],
Cell[5364, 160, 1313, 48, 70, "Notes",
 CellID->15125],
Cell[6680, 210, 131, 4, 70, "Notes",
 CellID->797803519],
Cell[6814, 216, 265, 8, 70, "Notes",
 CellID->3528],
Cell[7082, 226, 397, 13, 70, "Notes",
 CellID->39190952]
}, Closed]],
Cell[CellGroupData[{
Cell[7516, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->459646201],
Cell[CellGroupData[{
Cell[7901, 258, 148, 5, 70, "ExampleSection",
 CellID->193505522],
Cell[8052, 265, 113, 3, 70, "ExampleText",
 CellID->108500934],
Cell[CellGroupData[{
Cell[8190, 272, 440, 12, 47, "Input",
 CellID->3077879],
Cell[8633, 286, 3157, 56, 138, "Output",
 Evaluatable->False,
 CellID->752594150]
}, Open  ]],
Cell[11805, 345, 124, 3, 70, "ExampleDelimiter",
 CellID->27066729],
Cell[11932, 350, 81, 1, 70, "ExampleText",
 CellID->5392742],
Cell[CellGroupData[{
Cell[12038, 355, 540, 16, 47, "Input",
 CellID->747103243],
Cell[12581, 373, 3180, 56, 134, "Output",
 Evaluatable->False,
 CellID->47034266]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15810, 435, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[16034, 444, 91, 1, 70, "ExampleText",
 CellID->356019607],
Cell[CellGroupData[{
Cell[16150, 449, 319, 9, 70, "Input",
 CellID->457869047],
Cell[16472, 460, 2971, 53, 70, "Output",
 Evaluatable->False,
 CellID->1031072812]
}, Open  ]],
Cell[19458, 516, 124, 3, 70, "ExampleDelimiter",
 CellID->13225709],
Cell[19585, 521, 96, 1, 70, "ExampleText",
 CellID->23472827],
Cell[CellGroupData[{
Cell[19706, 526, 320, 9, 70, "Input",
 CellID->140553305],
Cell[20029, 537, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->214538758]
}, Open  ]],
Cell[23124, 595, 125, 3, 70, "ExampleDelimiter",
 CellID->466432450],
Cell[23252, 600, 210, 8, 70, "ExampleText",
 CellID->21248147],
Cell[CellGroupData[{
Cell[23487, 612, 388, 11, 70, "Input",
 CellID->348130125],
Cell[23878, 625, 3042, 54, 70, "Output",
 Evaluatable->False,
 CellID->40888205]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26969, 685, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[27210, 694, 252, 7, 70, "ExampleText",
 CellID->242285675],
Cell[CellGroupData[{
Cell[27487, 705, 540, 16, 70, "Input",
 CellID->404749038],
Cell[28030, 723, 3119, 55, 70, "Output",
 Evaluatable->False,
 CellID->48508181]
}, Open  ]],
Cell[31164, 781, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[31292, 786, 267, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[31584, 798, 658, 20, 70, "Input",
 CellID->852841955],
Cell[32245, 820, 3116, 55, 70, "Output",
 Evaluatable->False,
 CellID->320446589]
}, Open  ]],
Cell[35376, 878, 362, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[35763, 894, 717, 21, 70, "Input",
 CellID->610817034],
Cell[36483, 917, 3185, 56, 70, "Output",
 Evaluatable->False,
 CellID->169056188]
}, Open  ]],
Cell[39683, 976, 125, 3, 70, "ExampleDelimiter",
 CellID->468017888],
Cell[39811, 981, 262, 8, 70, "ExampleText",
 CellID->2867181],
Cell[CellGroupData[{
Cell[40098, 993, 638, 19, 70, "Input",
 CellID->82910697],
Cell[40739, 1014, 3102, 55, 70, "Output",
 Evaluatable->False,
 CellID->9258541]
}, Open  ]],
Cell[43856, 1072, 362, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[44243, 1088, 697, 20, 70, "Input",
 CellID->131785817],
Cell[44943, 1110, 3187, 56, 70, "Output",
 Evaluatable->False,
 CellID->9798752]
}, Open  ]],
Cell[48145, 1169, 124, 3, 70, "ExampleDelimiter",
 CellID->11991344],
Cell[48272, 1174, 141, 4, 70, "ExampleText",
 CellID->145936691],
Cell[CellGroupData[{
Cell[48438, 1182, 961, 27, 70, "Input",
 CellID->69778533],
Cell[49402, 1211, 2748, 49, 70, "Output",
 Evaluatable->False,
 CellID->17768930]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52211, 1267, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[52530, 1278, 712, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[53279, 1309, 299, 8, 70, "MoreAboutSection"],
Cell[53581, 1319, 175, 3, 70, "MoreAbout",
 CellID->273517680],
Cell[53759, 1324, 197, 4, 70, "MoreAbout",
 CellID->330860775]
}, Open  ]],
Cell[53971, 1331, 27, 0, 70, "History"],
Cell[54001, 1333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

