(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53180,       1682]
NotebookOptionsPosition[     45480,       1410]
NotebookOutlinePosition[     46673,       1445]
CellTagsIndexPosition[     46587,       1440]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeled" :> Documentation`HelpLookup["paclet:ref/Labeled"], 
          "Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Labeled\"\>", 2->"\<\"Frame\"\>", 
       3->"\<\"Panel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Document Generation\"\>", 
       3->"\<\"Graphics Annotation & Appearance\"\>", 
       4->"\<\"Mathematical Typesetting\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>", 
       6->"\<\"Viewers and Annotation\"\>", 
       7->"\<\"New in 6.0: Formatting & Styling\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Framed", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Framed",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Framed"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays a framed version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->7191],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["background color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins to leave inside the frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives giving a style for the frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[TextData[Cell[BoxData[
    Cell["margins around the image of the displayed frame ", "TableText"]]]], 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->3770],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " wraps onto multiple lines, the baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Framed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Framed"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is taken to be the baseline of the first line of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30829],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " draws no explicit frame. "
}], "Notes",
 CellID->26227]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->417993730],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->356459882],

Cell["Put a frame around any expression:", "ExampleText",
 CellID->167367552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], "+", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79439879],

Cell[BoxData[
 FrameBox[
  RowBox[{
   FractionBox["1", "x"], "+", "y"}],
  StripOnInput->False]], "Output",
 ImageSize->{45, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90759629]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19385],

Cell["Put a frame around any object:", "ExampleText",
 CellID->154964172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43595103],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[SphereBox[{0, 0, 0}],
   ImageSize->Tiny,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{106, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466101626]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"TabView", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->317495003],

Cell[BoxData[
 FrameBox[
  TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}}, 1],
  StripOnInput->False]], "Output",
 ImageSize->{83, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253411947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812753864],

Cell["Use a background color:", "ExampleText",
 CellID->673027995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", "y"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280065797],

Cell[BoxData[
 FrameBox[
  RowBox[{
   FractionBox["1", "x"], "+", "y"}],
  Background->RGBColor[1, 0.5, 0.5],
  StripOnInput->False]], "Output",
 ImageSize->{45, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169590239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->743728863],

Cell["Use a style for the frame:", "ExampleText",
 CellID->583731587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", "y"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->680818914],

Cell[BoxData[
 FrameBox[
  RowBox[{
   FractionBox["1", "x"], "+", "y"}],
  FrameStyle->RGBColor[1, 0, 0],
  StripOnInput->False]], "Output",
 ImageSize->{45, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43610782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192597496],

Cell["Text can linewrap inside a frame:", "ExampleText",
 CellID->687289110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"100", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237853692],

Cell[BoxData[
 FrameBox[
  "933262154439441526816992388562667004907159682643816214685929638952175999932\
299156089414639761565182862536979208272237582511852109168640000000000000000000\
00000",
  StripOnInput->False]], "Output",
 ImageSize->{583, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8684217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->500870917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"i", "!"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32814469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox["1",
    StripOnInput->False], ",", 
   FrameBox["2",
    StripOnInput->False], ",", 
   FrameBox["6",
    StripOnInput->False], ",", 
   FrameBox["24",
    StripOnInput->False], ",", 
   FrameBox["120",
    StripOnInput->False], ",", 
   FrameBox["720",
    StripOnInput->False], ",", 
   FrameBox["5040",
    StripOnInput->False], ",", 
   FrameBox["40320",
    StripOnInput->False], ",", 
   FrameBox["362880",
    StripOnInput->False], ",", 
   FrameBox["3628800",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{459, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510965173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143804084],

Cell["\<\
Different framed expression align as if their frames were not present:\
\>", "ExampleText",
 CellID->36797762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"Framed", "[", "x", "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"x", "^", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398005381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    FractionBox["1", "x"],
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    SuperscriptBox["x", "2"],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{101, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174929056]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->79361397],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->191018178],

Cell["Change the background color:", "ExampleText",
 CellID->834598791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"LightRed", ",", "LightGreen", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651845975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RowBox[{"x", "+", "y"}],
    Background->RGBColor[1, 0.85, 0.85],
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    Background->RGBColor[0.88, 1, 0.88],
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    Background->RGBColor[1, 1, 0],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{151, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464913344]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->831098518],

Cell["Add margins within the frame:", "ExampleText",
 CellID->176665291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "25"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86875525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RowBox[{"x", "+", "y"}],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    FrameMargins->5,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    FrameMargins->10,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    FrameMargins->25,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{247, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611540416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->192911356],

Cell["Change the frame style:", "ExampleText",
 CellID->116169378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->663449491],

Cell[BoxData[
 FrameBox[
  RowBox[{"x", "+", "y"}],
  FrameStyle->RGBColor[1, 0, 0],
  StripOnInput->False]], "Output",
 ImageSize->{41, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1325692]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->592670271],

Cell["Add margins outside the frame:", "ExampleText",
 CellID->503162128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "25"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380942705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    RowBox[{"x", "+", "y"}],
    ImageMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    ImageMargins->5,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    ImageMargins->10,
    StripOnInput->False], ",", 
   FrameBox[
    RowBox[{"x", "+", "y"}],
    ImageMargins->25,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{279, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645319559]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13228],

Cell["Frame integers that are prime:", "ExampleText",
 CellID->29792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", "n", "]"}], ",", 
     RowBox[{"Framed", "[", "n", "]"}], ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264292580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FrameBox["2",
    StripOnInput->False], ",", 
   FrameBox["3",
    StripOnInput->False], ",", "4", ",", 
   FrameBox["5",
    StripOnInput->False], ",", "6", ",", 
   FrameBox["7",
    StripOnInput->False], ",", "8", ",", "9", ",", "10", ",", 
   FrameBox["11",
    StripOnInput->False], ",", "12", ",", 
   FrameBox["13",
    StripOnInput->False], ",", "14", ",", "15", ",", "16", ",", 
   FrameBox["17",
    StripOnInput->False], ",", "18", ",", 
   FrameBox["19",
    StripOnInput->False], ",", "20"}], "}"}]], "Output",
 ImageSize->{528, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145672100]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " provides additional features for framing objects: "
}], "ExampleText",
 CellID->4980905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{
     RowBox[{"1", "/", "x"}], "+", "y"}], "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"1", "/", "x"}], "+", "y"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59254514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox[
    RowBox[{
     FractionBox["1", "x"], "+", "y"}]], ",", 
   FrameBox[
    RowBox[{
     FractionBox["1", "x"], "+", "y"}],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{118, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37833788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144165052],

Cell[TextData[{
 "Many functions have a ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " option: "
}], "ExampleText",
 CellID->182766638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541076733],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"1", "2"},
      {"3", "4"}
     },
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", 
   FrameBox[
    TagBox[GridBox[{
       {"1", "2"},
       {"3", "4"}
      }],
     "Grid"],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{102, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276653763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Framed", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195900755],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXGusXUUV3vc87j23qFhe3tLb3ioPBREExAcKFaGUUqFUQcTK43JFWhUK
paAtUFoeBbRFLaBUkYIUE19JiQYjqYmRhEhiJDE2MWpiMDH4Q2Ii8UcTk+23
Zs2c2WfttffMnHNurMpNe7tnz55Z3/rWmrXWzNmnF0yvX33NddPr18xML1q6
bvqG1Wtmblp07tp1uNUcybKRbVmW3TWR4TrHlflLP9vxN8uep9/NTqeT8c+z
9Iva5pk8Gy085Ubm2bOi/dpTvU8dht8NIlL00r0FSh+RTvcmcU23Gso4ra84
rlUx7g3i3qk18hfUyF/Yp/wxlaFD6XfL382yVunO/NIdOdeRot0sjZjUpFfM
kKkoXi9GnBJENT+IauHAqOSIA4vVMAP/CVbDMxzYrMr+xgHBahjVMFlt5xy9
FiSz2bIjp4bAokMhuQmzF49i2KzV2SyOvZLfBHDE8Vh8ImxVjc9UXDqzLmeP
5t7DXP5qWFaL/ZOif1L0V+XdqucXBvr1PDqbtc0hov3UEEd18uoKibzicfx7
sOij9u5KJsYiLF++I+eS/iQ9VLb/L59vd9tMYsnXuz6wZvWeV1/dH5x1UFT/
6/N3RDvN4+lG1nzppb/bu28Rsx0t2kfVtGkqLbp1Lf7CL/988/pnghlHyjwm
0D8YA9lo987LL/9j5uofwCm/IWZ8naaRnen73/vNgzue3z0sDPh58dd/WXv9
j6Iw+NW2ZfPen+39Y/bkYDhk1dFk7ejykQg8ZH0z0f79/4IK+37712+reFyE
d/lLegRHflaJLr8ew8VYkUOYEvHllVf+mT2hIniTlcxaAy6e/sPv/5Y9nPNO
ttKHe9iBpeDQGJ09XimlvPY9tq/F6FXixdtkV5TUtsD6cKJURr1923NP79lH
l49FSeVKCkMwkC4fipDqfQE4gRaYI6VxrgYtIIcuH0zUkaXCJrAM7JN9q1Iq
YewIjDtyva6TUpgT+BmkkCUejdKNpSEsITgRth2JujE3z/3iT7du/CldfjNK
6rjA+tVEqYx65yMvPLX7RbqU8UyXOkdg/UqEVGKex2EQhtLlzlr78SwABnh0
+UCk/cadJcAJcmaNlDJmH80eCOjUzPVTuKYSpVnvbuIqRek6RN0gHURU3oEW
I3am4Doo7405MoJXV/pVmvKO0a/Q7cmY5d5O7i94Bh+xZHSuyqUhLtirwDPY
Ji62JSOXOxF6gprMiY96MrJXIdaYoCbvquCmcFa6vD/Xs2EcwjIHIAAuQZcy
G1QhDc37xrw3ynwxmdtwJcTYffwdFva5po0FgrrYsR0TF6qqJrYe4hJwkp/J
HNh/LTjXMWDjXgipi8o8jst+upSZK64aPMTpZXeM90VIL6P3VZPMZL254TDT
6yPX1jwuN3Dbr0WZufRIzNJ+8szv7t36c7rcmqibOfMr+NCXo6Qenveumnv6
kuqr5jipR5i2z4N3R0gl5hmtr5pltqqT5nNcjLQyRz5qy3zT6zUTptdnpzvz
OK9hlD7iytyg68bSfG12Z6JuPJ+vf74UJXWeafvabEuiVEYNR4e706WM1brU
IwXWzRFSifl5zv62RteluTP3ubk/WS3udTZF2pGliQjZ8jWBjWqlmmOuaM93
qMExlnR2R0DbnlqxdPYmIylz6VfSfeqoVhTSSacx1gfFgE0BpOn1GHPhvfze
BLSNJF74swW/em9P1sWdpcnMySz5NbM1pEOpT1YNUoLUnD8F8dnytr50Kdaz
xBY1mSVfH98zsC6NAmt0e8r0+9y7wd6X9pKeo+9PtFqC2fGZ7+6h6CDZKvYv
yns9YKNiP+0znHidmDUfV+8aWKdmhaQ3m7avpDaI/tDZdpWu0odZIx8F6zRS
7RHFG591e1/4gqKNq0vrYv8ih9ZWQzIbS4QjDKvJ/zieYng5Slj686K/Khey
pn4HIzM3yRlBk5CNqKy6mY4Wlrklj8uPjACykS0IgcziOkehHNRFY5m/JYKP
Mp8YCVQUK+/IAyunBssxjmNbAdyciIV18bFv0wBYjhVsr0/Ewrr4fdvtA2B5
q8NiT6huisBCHsXj/M7otkQMNMdxwr435nHeKmXfOoD+jMHvI25MtMXbCPOu
x341CIbjnT2xagnDDYkYjrMYNg6A4e2m7fPg2kQMx1sMG2owyGr+HcKO1+XV
9qf7J1gZJhMo1bvcm2jzp+jk5Mk4ru+EThTSPheQpp0j06WWC1kTn1lk9Ip7
M6N47ySB9rMBtP2czJ0oUMs41/+J1zsF+s8MCT0NOUmglhExDTUNPFmgvTaP
PbeNZcKjXTc0jk8RqFf3xbG2PzjZYbZncTLm1mHW5jvVIbXx89pkpKG3QJgL
lNWIBnQpI3TMZw/avO8ybY66hPzTAeTFCr2h2IyZAEh7GiOjeG+cqJrlNNPm
+oLy8jUBVC4+8ziU69ZjrleluzO595hefpuCpMzkcdn/NGFtGdX16MzSuNag
s5WZCJ2K7Xc7S1lOZHTXpb7XSbVV59WJUoscEWoZpXWp7zNtPkeis9XpRKkS
tYyuutTTTZtPnMBTdlWEVLL36QW0dBK4ptZrPmB6eYeD8JFdEek1XXSwH72J
I6OZrtMZuV339kzl8kQm3+/Qbtm8F+uiFJl0qWea9tN79kFH8rVPJkpl1AgB
kEorRK5fXeri3Hq43ZWsSpTKqMGt9dVP1drxrNz7GO0NL6uxI93/oLkPb7Y+
LdevrhNL4ZND8GmkpOjEUnmnRuPl+tWlfoh+tcA8vAZ/cHFpQG5KLXhWaXa5
0tKrwXNy63HWdh8L4O2nUjm7IIP860oVdT+VypLc+sblq75Lpx6XzAL6c5wM
7JMpul0xEHoaeK7p4YiEtQo7rsxj68LimRk9uMTNhYiBaIW5ZMyoq1A0jzjP
tBGzbA74yCxwutS0EcXBKcmQEad/j1iW2+iCmSnurpwF9MwQf55PMj4xNPTn
53aFwy2Y/hUB/KF3D5aVZvy4ijb0Wf+Hc78KSOcLA7hkPF1ucPB4VKkAJCNN
b5a4sBc3Bi7P6/PEBW4EpocQFBQyGugxe4VDBjFYQVhK5yfqxlhBLeIbCmCE
0Y9GSWbfxCpA9KIcsyxR7kWmjXoY46kikitVl2qeagEkUggzuzRRrsFNMQd0
ceC9KEryxQWmEa6QCpZESCbbXuwYRsTkjzWl//V6j8m6LURrwANIKHumwwzv
4FedYmpH40EtPA+HAmLIXWyewIT8Qol9zy+kucHThm9iyKWXfAdOQnnQVKZt
xoS7+E01nzxxD1mjqysw8kfqpvZsM0bMC5k0bxzSyxxSuBXGoo6kytzsgdrA
zDNapDJ6hZCauVtwF5gQYCHB7HLaoBWMMFKqWuU8OlKT59pcdfICIkzmhKEN
GUDudZefFIWQrurFhRhE9jJzjzI3cGFWAU3pRb2+eKWZC76L9bZyxZOYkSqV
ExyjCKaQYPcmLgpXxThTe4yKUUDAs8FSXRlUKcuTXp3HqwpaYUIMh5Gh+rFO
FqfpLg0HJXLJ87NFli/bxa8ZQRzPD0HsU1xnw1iHqqiJGbqpfVtd5iqzQxiD
/zNyJgTakQ2nzJRgimMXBLO2knEtz8bKN3uFMajIrw9Bad6yUqUz5bChD6jQ
B4ToI2xHqJqPK0jqqwhzljQOGXyEBx2hKb86A8VphZl3qDrAAxSwKrhffMZO
/GaQ0m8kF+qbDrWIzD50HJIRpph4KA5ngxsDEe07jO4dNHALnOEJmA0XUAE+
MW9IzJjzjDlQkV+WgMZLzn6UnQ9NhDXgo0MXEwFz90NrqUF358CL8RD+ADsi
AEgDUN7ho//wofNmTkQ6IACC2U5ghU0FqfQJBaPtfk8MP8SmuTsH3OEJ8F0c
h2lgdAyQ39tN4ZRuhL79NZXbCAcsoBtI0GdeNc7aYB1o+A94zBrmLkhldqEt
cV5cDzRWi4xxnNID5kSUcjnUZzGMBRbsYgFLFiHWDZ7AerD+Kb9/l+SBr317
ddDng99eTV9b+nec4yz6xCwikDuxHyvzFvt/qM4ym98x/298amJiIuMf/t+S
0O55ii75f1fKRv4NNh3xAg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{396, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173806469]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Framed", ",", "x", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14427299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox["x",
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox[
        FrameBox["x",
         StripOnInput->False],
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{345, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146674520]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22064],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10947],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->797121093],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->43032211],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->216265624],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->411606465],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->312712863],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->770202458],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->157222289],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->307210963],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->645868854]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Framed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 12.3140444}", "context" -> "System`", 
    "keywords" -> {"framed (Version 1 option)"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Framed[expr] displays a framed version of expr. ", "synonyms" -> {}, 
    "title" -> "Framed", "type" -> "Symbol", "uri" -> "ref/Framed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8880, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->417993730]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46444, 1433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3193, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3816, 100, 1571, 37, 70, "ObjectNameGrid"],
Cell[5390, 139, 548, 18, 70, "Usage",
 CellID->6446]
}, Open  ]],
Cell[CellGroupData[{
Cell[5975, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6453, 179, 68, 1, 70, "Notes",
 CellID->7191],
Cell[6524, 182, 1538, 39, 70, "3ColumnTableMod",
 CellID->3770],
Cell[8065, 223, 451, 16, 70, "Notes",
 CellID->30829],
Cell[8519, 241, 324, 12, 70, "Notes",
 CellID->26227]
}, Closed]],
Cell[CellGroupData[{
Cell[8880, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->417993730],
Cell[CellGroupData[{
Cell[9265, 272, 148, 5, 70, "ExampleSection",
 CellID->356459882],
Cell[9416, 279, 77, 1, 70, "ExampleText",
 CellID->167367552],
Cell[CellGroupData[{
Cell[9518, 284, 148, 5, 28, "Input",
 CellID->79439879],
Cell[9669, 291, 237, 9, 61, "Output",
 CellID->90759629]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9955, 306, 216, 7, 70, "ExampleSection",
 CellID->19385],
Cell[10174, 315, 73, 1, 70, "ExampleText",
 CellID->154964172],
Cell[CellGroupData[{
Cell[10272, 320, 234, 7, 70, "Input",
 CellID->43595103],
Cell[10509, 329, 11433, 194, 133, "Output",
 CellID->466101626]
}, Open  ]],
Cell[CellGroupData[{
Cell[21979, 528, 195, 6, 70, "Input",
 CellID->317495003],
Cell[22177, 536, 250, 8, 70, "Output",
 CellID->253411947]
}, Open  ]],
Cell[22442, 547, 125, 3, 70, "ExampleDelimiter",
 CellID->812753864],
Cell[22570, 552, 66, 1, 70, "ExampleText",
 CellID->673027995],
Cell[CellGroupData[{
Cell[22661, 557, 216, 7, 70, "Input",
 CellID->280065797],
Cell[22880, 566, 275, 10, 61, "Output",
 CellID->169590239]
}, Open  ]],
Cell[23170, 579, 125, 3, 70, "ExampleDelimiter",
 CellID->743728863],
Cell[23298, 584, 69, 1, 70, "ExampleText",
 CellID->583731587],
Cell[CellGroupData[{
Cell[23392, 589, 215, 7, 70, "Input",
 CellID->680818914],
Cell[23610, 598, 270, 10, 61, "Output",
 CellID->43610782]
}, Open  ]],
Cell[23895, 611, 125, 3, 70, "ExampleDelimiter",
 CellID->192597496],
Cell[24023, 616, 76, 1, 70, "ExampleText",
 CellID->687289110],
Cell[CellGroupData[{
Cell[24124, 621, 122, 4, 70, "Input",
 CellID->237853692],
Cell[24249, 627, 356, 10, 82, "Output",
 CellID->8684217]
}, Open  ]],
Cell[24620, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->500870917],
Cell[CellGroupData[{
Cell[24770, 647, 227, 8, 70, "Input",
 CellID->32814469],
Cell[25000, 657, 697, 27, 43, "Output",
 CellID->510965173]
}, Open  ]],
Cell[25712, 687, 125, 3, 70, "ExampleDelimiter",
 CellID->143804084],
Cell[25840, 692, 120, 3, 70, "ExampleText",
 CellID->36797762],
Cell[CellGroupData[{
Cell[25985, 699, 277, 9, 70, "Input",
 CellID->398005381],
Cell[26265, 710, 380, 15, 61, "Output",
 CellID->174929056]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26694, 731, 221, 7, 70, "ExampleSection",
 CellID->79361397],
Cell[CellGroupData[{
Cell[26940, 742, 231, 7, 70, "ExampleSubsection",
 CellID->191018178],
Cell[27174, 751, 71, 1, 70, "ExampleText",
 CellID->834598791],
Cell[CellGroupData[{
Cell[27270, 756, 388, 13, 70, "Input",
 CellID->651845975],
Cell[27661, 771, 523, 19, 41, "Output",
 CellID->464913344]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28233, 796, 233, 7, 70, "ExampleSubsection",
 CellID->831098518],
Cell[28469, 805, 72, 1, 70, "ExampleText",
 CellID->176665291],
Cell[CellGroupData[{
Cell[28566, 810, 378, 13, 70, "Input",
 CellID->86875525],
Cell[28947, 825, 566, 23, 83, "Output",
 CellID->611540416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29562, 854, 231, 7, 70, "ExampleSubsection",
 CellID->192911356],
Cell[29796, 863, 66, 1, 70, "ExampleText",
 CellID->116169378],
Cell[CellGroupData[{
Cell[29887, 868, 190, 6, 70, "Input",
 CellID->663449491],
Cell[30080, 876, 247, 9, 41, "Output",
 CellID->1325692]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30376, 891, 233, 7, 70, "ExampleSubsection",
 CellID->592670271],
Cell[30612, 900, 73, 1, 70, "ExampleText",
 CellID->503162128],
Cell[CellGroupData[{
Cell[30710, 905, 379, 13, 70, "Input",
 CellID->380942705],
Cell[31092, 920, 566, 23, 91, "Output",
 CellID->645319559]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31719, 950, 223, 7, 70, "ExampleSection",
 CellID->13228],
Cell[31945, 959, 69, 1, 70, "ExampleText",
 CellID->29792],
Cell[CellGroupData[{
Cell[32039, 964, 311, 10, 70, "Input",
 CellID->264292580],
Cell[32353, 976, 707, 23, 43, "Output",
 CellID->145672100]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33109, 1005, 233, 7, 70, "ExampleSection",
 CellID->23328],
Cell[33345, 1014, 220, 7, 70, "ExampleText",
 CellID->4980905],
Cell[CellGroupData[{
Cell[33590, 1025, 283, 10, 70, "Input",
 CellID->59254514],
Cell[33876, 1037, 354, 14, 70, "Output",
 CellID->37833788]
}, Open  ]],
Cell[34245, 1054, 125, 3, 70, "ExampleDelimiter",
 CellID->144165052],
Cell[34373, 1059, 207, 8, 70, "ExampleText",
 CellID->182766638],
Cell[CellGroupData[{
Cell[34605, 1071, 615, 22, 70, "Input",
 CellID->541076733],
Cell[35223, 1095, 465, 20, 58, "Output",
 CellID->276653763]
}, Open  ]],
Cell[CellGroupData[{
Cell[35725, 1120, 512, 17, 70, "Input",
 CellID->195900755],
Cell[36240, 1139, 4324, 75, 70, "Output",
 Evaluatable->False,
 CellID->173806469]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40613, 1220, 224, 7, 70, "ExampleSection",
 CellID->13603],
Cell[CellGroupData[{
Cell[40862, 1231, 141, 4, 70, "Input",
 CellID->14427299],
Cell[41006, 1237, 1143, 49, 89, "Output",
 CellID->146674520]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42210, 1293, 311, 9, 70, "SeeAlsoSection",
 CellID->22064],
Cell[42524, 1304, 682, 26, 70, "SeeAlso",
 CellID->21038]
}, Open  ]],
Cell[CellGroupData[{
Cell[43243, 1335, 314, 9, 70, "TutorialsSection",
 CellID->10947],
Cell[43560, 1346, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[43743, 1354, 319, 9, 70, "MoreAboutSection",
 CellID->797121093],
Cell[44065, 1365, 172, 3, 70, "MoreAbout",
 CellID->43032211],
Cell[44240, 1370, 149, 3, 70, "MoreAbout",
 CellID->216265624],
Cell[44392, 1375, 175, 3, 70, "MoreAbout",
 CellID->411606465],
Cell[44570, 1380, 159, 3, 70, "MoreAbout",
 CellID->312712863],
Cell[44732, 1385, 169, 3, 70, "MoreAbout",
 CellID->770202458],
Cell[44904, 1390, 154, 3, 70, "MoreAbout",
 CellID->157222289],
Cell[45061, 1395, 171, 3, 70, "MoreAbout",
 CellID->307210963],
Cell[45235, 1400, 173, 3, 70, "MoreAbout",
 CellID->645868854]
}, Open  ]],
Cell[45423, 1406, 27, 0, 70, "History"],
Cell[45453, 1408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

