(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24004,        833]
NotebookOptionsPosition[     19558,        680]
NotebookOutlinePosition[     20817,        716]
CellTagsIndexPosition[     20732,        711]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Frobenius Equations and Computing Frobenius Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/Frobenius"], 
          "Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Solving Frobenius Equations and Computing Frobenius \
Numbers\"\>", 2->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrobeniusSolve" :> 
          Documentation`HelpLookup["paclet:ref/FrobeniusSolve"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrobeniusSolve\"\>", 
       2->"\<\"FindInstance\"\>", 3->"\<\"Reduce\"\>", 
       4->"\<\"IntegerPartitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Integer Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 4->"\<\"Number Theory\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrobeniusNumber", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrobeniusNumber",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrobeniusNumber"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the Frobenius number of ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n", "TI"]]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Frobenius number of ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"], ",", 
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 " is the largest integer ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " for which the Frobenius equation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]]}], "+", 
    StyleBox["\[Ellipsis]", "TR"], "+", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["n", "TI"]], 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}]}], "==", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " has no non-negative integer solutions. The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be positive integers."
}], "Notes",
 CellID->10013],

Cell[TextData[{
 "If the integers ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are not relatively prime, the result is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32571],

Cell[TextData[{
 "If one of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the integer 1, then the result is -1."
}], "Notes",
 CellID->31632],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is the Frobenius number of ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"], ",", 
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrobeniusSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrobeniusSolve"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17138]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112364109],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->443244503],

Cell["The Frobenius number of 12, 16, 20, 27:", "ExampleText",
 CellID->18242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusNumber", "[", 
  RowBox[{"{", 
   RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23658],

Cell[BoxData["89"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1428322309]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20076],

Cell["Make an array of Frobenius numbers:", "ExampleText",
 CellID->12886932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FrobeniusNumber", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"i", ",", 
       RowBox[{"i", "+", "n", "+", "1"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11086011],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVsuuwiAQRfvwqhufV5d+jcaFH9EYE10Yjdfv9Ve4M0OxDWIqigG0Tcrh
DEgPCGdYZeftZp+dd+tstjhlx+1u/TebH04QihqMsQu8yymDOocavRfOAW/L
BMoIOoxynCjcFGMa9QdLpJweai3zcUX7u3lEKtsVvXpQpED7T6JYixTKGNgw
xwFGk+tXqI/P0YTLffLoL3CmLC7W0XXEfAblneCCh6oY93rZDX4Bm4DjJ1GM
es+7bstWSRVWh/w1N5OYakf34XTaOt+qY7t2aL1jh6kSd+Erp0Ci2IVVWcs1
F2tg4l2hRQt3xia7HvO418nvDyyhec4JLVrkKJ/Oi8r1uca1KpXrs4ZrVSoX
N/DaMV1H9bfDz3DMME5qrbJW6RcPSSU6jY0bvESatYFzYZ616VxNGrXj2Vqr
XKjM0yM92Bgrvbr5nD4tHtJ/VKv8NpV4p7bpiOKmLtyONf4Bwu71zA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{222, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565475919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84904050],

Cell["Frobenius numbers of pairs:", "ExampleText",
 CellID->156996437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FrobeniusNumber", "[", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"i", "+", "1"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259780254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "5", ",", "11", ",", "19", ",", "29", 
   ",", "41", ",", "55", ",", "71", ",", "89", ",", "109", ",", "131", ",", 
   "155", ",", "181", ",", "209"}], "}"}]], "Output",
 ImageSize->{407, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->973655291]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->370918992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", ",", "14", ",", 
   "16", ",", "18", ",", "20", ",", "22", ",", "24", ",", "26", ",", "28"}], 
  "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399085697]
}, Open  ]],

Cell["Frobenius numbers of length-4 runs:", "ExampleText",
 CellID->752661473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Differences", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"FrobeniusNumber", "[", 
      RowBox[{"i", "+", 
       RowBox[{"Range", "[", "4", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54826577],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 1.}, {3., 6.}, {4., 2.}, {5., 2.}, {6., 10.}, {7.,
      3.}, {8., 3.}, {9., 14.}, {10., 4.}, {11., 4.}, {12., 18.}, {13., 5.}, {
     14., 5.}, {15., 22.}, {16., 6.}, {17., 6.}, {18., 26.}, {19., 7.}, {20., 
     7.}, {21., 30.}, {22., 8.}, {23., 8.}, {24., 34.}, {25., 9.}, {26., 
     9.}, {27., 38.}, {28., 10.}, {29., 10.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 29.}, {0., 38.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->841879898]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21821],

Cell["\<\
For a pair of relatively prime integers the Frobenius number has a closed \
form:\
\>", "ExampleText",
 CellID->6569],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"frobeniusnumber", "[", 
    RowBox[{"{", 
     RowBox[{"m_", ",", "n_"}], "}"}], "]"}], "/;", 
   RowBox[{"CoprimeQ", "[", 
    RowBox[{"m", ",", "n"}], "]"}]}], ":=", 
  RowBox[{
   RowBox[{"m", " ", "n"}], "-", "m", "-", "n"}]}], "\n", 
 RowBox[{
  RowBox[{"frobeniusnumber", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"_Integer", "?", "Positive"}], ",", 
     RowBox[{"_Integer", "?", "Positive"}]}], "}"}], "]"}], ":=", 
  "Infinity"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->15480],

Cell["Check:", "ExampleText",
 CellID->21442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"frobeniusnumber", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "==", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FrobeniusNumber", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24307],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103900882]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4336],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrobeniusSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrobeniusSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6235],

Cell[TextData[ButtonBox["Solving Frobenius Equations and Computing Frobenius \
Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Frobenius"]], "Tutorials",
 CellID->13674],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->118]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->13033971],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->194613025],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->30951852],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->32682175],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->828223507],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->689024901]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrobeniusNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 27.3300538}", "context" -> "System`", 
    "keywords" -> {"Frobenius number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrobeniusNumber[{a_1, ..., a_n}] gives the Frobenius number of a_1, ..., \
a_n.", "synonyms" -> {"frobenius number"}, "title" -> "FrobeniusNumber", 
    "type" -> "Symbol", "uri" -> "ref/FrobeniusNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9318, 297, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112364109]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20589, 704}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3009, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3632, 94, 1580, 37, 70, "ObjectNameGrid"],
Cell[5215, 133, 1009, 33, 70, "Usage",
 CellID->16551]
}, Open  ]],
Cell[CellGroupData[{
Cell[6261, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6739, 188, 1080, 41, 70, "Notes",
 CellID->10013],
Cell[7822, 231, 335, 13, 70, "Notes",
 CellID->32571],
Cell[8160, 246, 208, 8, 70, "Notes",
 CellID->31632],
Cell[8371, 256, 910, 36, 70, "Notes",
 CellID->17138]
}, Closed]],
Cell[CellGroupData[{
Cell[9318, 297, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112364109],
Cell[CellGroupData[{
Cell[9703, 311, 148, 5, 70, "ExampleSection",
 CellID->443244503],
Cell[9854, 318, 78, 1, 70, "ExampleText",
 CellID->18242],
Cell[CellGroupData[{
Cell[9957, 323, 178, 5, 28, "Input",
 CellID->23658],
Cell[10138, 330, 160, 5, 36, "Output",
 CellID->1428322309]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10347, 341, 223, 7, 70, "ExampleSection",
 CellID->20076],
Cell[10573, 350, 77, 1, 70, "ExampleText",
 CellID->12886932],
Cell[CellGroupData[{
Cell[10675, 355, 408, 13, 70, "Input",
 CellID->11086011],
Cell[11086, 370, 695, 15, 70, "Output",
 Evaluatable->False,
 CellID->565475919]
}, Open  ]],
Cell[11796, 388, 124, 3, 70, "ExampleDelimiter",
 CellID->84904050],
Cell[11923, 393, 70, 1, 70, "ExampleText",
 CellID->156996437],
Cell[CellGroupData[{
Cell[12018, 398, 295, 10, 70, "Input",
 CellID->259780254],
Cell[12316, 410, 378, 10, 36, "Output",
 CellID->973655291]
}, Open  ]],
Cell[CellGroupData[{
Cell[12731, 425, 107, 3, 70, "Input",
 CellID->370918992],
Cell[12841, 430, 344, 10, 36, "Output",
 CellID->399085697]
}, Open  ]],
Cell[13200, 443, 78, 1, 70, "ExampleText",
 CellID->752661473],
Cell[CellGroupData[{
Cell[13303, 448, 366, 11, 70, "Input",
 CellID->54826577],
Cell[13672, 461, 788, 20, 140, "Output",
 CellID->841879898]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14509, 487, 233, 7, 70, "ExampleSection",
 CellID->21821],
Cell[14745, 496, 127, 4, 70, "ExampleText",
 CellID->6569],
Cell[14875, 502, 544, 18, 70, "Input",
 CellID->15480],
Cell[15422, 522, 45, 1, 70, "ExampleText",
 CellID->21442],
Cell[CellGroupData[{
Cell[15492, 527, 623, 21, 70, "Input",
 CellID->24307],
Cell[16118, 550, 161, 5, 36, "Output",
 CellID->103900882]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16340, 562, 310, 9, 70, "SeeAlsoSection",
 CellID->4336],
Cell[16653, 573, 975, 35, 70, "SeeAlso",
 CellID->22887]
}, Open  ]],
Cell[CellGroupData[{
Cell[17665, 613, 313, 9, 70, "TutorialsSection",
 CellID->6235],
Cell[17981, 624, 181, 4, 70, "Tutorials",
 CellID->13674],
Cell[18165, 630, 154, 3, 70, "Tutorials",
 CellID->118]
}, Open  ]],
Cell[CellGroupData[{
Cell[18356, 638, 318, 9, 70, "MoreAboutSection",
 CellID->13033971],
Cell[18677, 649, 157, 3, 70, "MoreAbout",
 CellID->194613025],
Cell[18837, 654, 144, 3, 70, "MoreAbout",
 CellID->30951852],
Cell[18984, 659, 161, 3, 70, "MoreAbout",
 CellID->32682175],
Cell[19148, 664, 137, 3, 70, "MoreAbout",
 CellID->828223507],
Cell[19288, 669, 198, 4, 70, "MoreAbout",
 CellID->689024901]
}, Open  ]],
Cell[19501, 676, 27, 0, 70, "History"],
Cell[19531, 678, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

