(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37002,       1288]
NotebookOptionsPosition[     30445,       1062]
NotebookOutlinePosition[     32014,       1103]
CellTagsIndexPosition[     31928,       1098]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Digits in Numbers\"\>", 
       2->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "IntegerString" :> 
          Documentation`HelpLookup["paclet:ref/IntegerString"], 
          "FromContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/FromContinuedFraction"], 
          "NumberForm" :> Documentation`HelpLookup["paclet:ref/NumberForm"], 
          "DigitCount" :> 
          Documentation`HelpLookup["paclet:ref/DigitCount"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerDigits\"\>", 
       2->"\<\"RealDigits\"\>", 3->"\<\"IntegerString\"\>", 
       4->"\<\"FromContinuedFraction\"\>", 5->"\<\"NumberForm\"\>", 
       6->"\<\"DigitCount\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Digits\"\>", 3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Number Theory\"\>", 
       5->"\<\"Numerical Evaluation & Precision\"\>", 
       6->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FromDigits", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromDigits"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an integer from the list of its decimal \
digits. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromDigits"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the digits to be given in base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromDigits"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an integer from a string of digits."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromDigits"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<Roman\>\""}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]constructs an integer from Roman numerals."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->22534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["IntegerString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerString"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3955],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " to be an exponent, while ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["rep", "TI"], "}"}]}], "}"}], ",", 
      StyleBox["n", "TI"]}], "}"}], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  StyleBox["rep", "TI"]], "InlineFormula"],
 " to be repeated, so that ",
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " can also be used as the inverse of ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17459],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " discards the sign of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"], "[", 
   RowBox[{
    ButtonBox["IntegerDigits",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IntegerDigits"], "[", 
    StyleBox["n", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " not just ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28094,
  ButtonNote->"28094"]
}], "Notes",
 CellID->22220],

Cell[TextData[{
 "The digits in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " and the base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " need not be positive integers, and can be any expression. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3881,
  ButtonNote->"3881"]
}], "Notes",
 CellID->1702],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " appears in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", it is assumed to signify unknown digits beyond the precision of an \
approximate real number. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->32241,
  ButtonNote->"32241"]
}], "Notes",
 CellID->4502],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " takes the digits in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 " to be given in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->132424342],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ", digits above 9 can be represented by letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 " or ",
 Cell[BoxData["A"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["Z"], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->534460390]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343624419],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->293322449],

Cell["Construct a number from its base-10 digits:", "ExampleText",
 CellID->11965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "1", ",", "2", ",", "8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16124],

Cell[BoxData["5128"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5654],

Cell["Base-2 digits:", "ExampleText",
 CellID->455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1"}],
     "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18629],

Cell[BoxData["91"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4872]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10173],

Cell["Use symbolic digits and base:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"FromDigits", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x"}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32080],

Cell[BoxData[
 RowBox[{"e", "+", 
  RowBox[{"d", " ", "x"}], "+", 
  RowBox[{"c", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"a", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32522],

Cell["\<\
Digits larger than the base are \[OpenCurlyDoubleQuote]carried\
\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->13298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{"7", ",", "11", ",", "0", ",", "0", ",", "0", ",", "122"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26911],

Cell[BoxData["810122"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9500],

Cell["Reconstruct a rational number from recurring digits:", "ExampleText",
 CellID->12522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"11", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7", ",", "1", ",", "4", ",", "2", ",", "8"}], 
      "}"}]}], "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19142],

Cell[BoxData[
 FractionBox["11", "7"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27304]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1984],

Cell["Construct a number with limited precision:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->32241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "Indeterminate"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10211],

Cell[BoxData["1230.`3.089905111439398"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26025]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13046],

Cell["Find the number with recurring digits 123:", "ExampleText",
 CellID->21053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20899],

Cell[BoxData[
 FractionBox["41", "333"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2271],

Cell[BoxData["0.123123123123123123123123123123123123123123123123`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24341],

Cell["\<\
Find numbers with successive recurring binary digit sequences:\
\>", "ExampleText",
 CellID->21462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FromDigits", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "#", "}"}], ",", "0"}], "}"}], ",", "2"}], "]"}], "&"}], "/@",
   
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", "4"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "15"], ",", 
   FractionBox["2", "15"], ",", 
   FractionBox["1", "5"], ",", 
   FractionBox["4", "15"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["2", "5"], ",", 
   FractionBox["7", "15"], ",", 
   FractionBox["8", "15"], ",", 
   FractionBox["3", "5"], ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["11", "15"], ",", 
   FractionBox["4", "5"], ",", 
   FractionBox["13", "15"], ",", 
   FractionBox["14", "15"], ",", "1"}], "}"}]], "Output",
 ImageSize->{412, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FromDigits", "[", 
     RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"111", ",", "112", ",", "113"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"121", ",", "122", ",", "123"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"131", ",", "132", ",", "133"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"211", ",", "212", ",", "213"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"221", ",", "222", ",", "223"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"231", ",", "232", ",", "233"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"311", ",", "312", ",", "313"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"321", ",", "322", ",", "323"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"331", ",", "332", ",", "333"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{353, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12712]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3489],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " drops the sign:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "/@", 
  RowBox[{"IntegerDigits", "[", 
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "10"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "9", ",", "8", ",", "7", ",", "6", ",", "5", ",", "4", ",", "3", 
   ",", "2", ",", "1", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", 
   "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10"}], "}"}]], "Output",\

 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15873]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28898],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27897],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->17194],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->123037413],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->39507323],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->784406556],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->634612585],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->644218125],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->962644911],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->83207003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FromDigits",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FromDigits"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FromDigits"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromDigits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 28.9707208}", "context" -> "System`", 
    "keywords" -> {
     "encode", "implode", "integer digits", "number conversion", 
      "number reconstruction", "reconstruction", "roman numerals"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FromDigits[list] constructs an integer from the list of its decimal \
digits. FromDigits[list, b] takes the digits to be given in base b. \
FromDigits[\"string\"] constructs an integer from a string of digits. \
FromDigits[\"string\", \"Roman\"] constructs an integer from Roman numerals.",
     "synonyms" -> {"from digits"}, "title" -> "FromDigits", "type" -> 
    "Symbol", "uri" -> "ref/FromDigits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15211, 448, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->343624419]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31784, 1091}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3358, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3981, 101, 4194, 83, 70, "ObjectNameGrid"],
Cell[8178, 186, 1641, 50, 70, "Usage",
 CellID->22534]
}, Open  ]],
Cell[CellGroupData[{
Cell[9856, 241, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10334, 258, 476, 17, 70, "Notes",
 CellID->3955],
Cell[10813, 277, 1250, 46, 70, "Notes",
 CellID->17459],
Cell[12066, 325, 980, 38, 70, "Notes",
 CellID->22220],
Cell[13049, 365, 365, 13, 70, "Notes",
 CellID->1702],
Cell[13417, 380, 463, 16, 70, "Notes",
 CellID->4502],
Cell[13883, 398, 617, 20, 70, "Notes",
 CellID->132424342],
Cell[14503, 420, 671, 23, 70, "Notes",
 CellID->534460390]
}, Closed]],
Cell[CellGroupData[{
Cell[15211, 448, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343624419],
Cell[CellGroupData[{
Cell[15596, 462, 148, 5, 70, "ExampleSection",
 CellID->293322449],
Cell[15747, 469, 82, 1, 70, "ExampleText",
 CellID->11965],
Cell[CellGroupData[{
Cell[15854, 474, 169, 5, 28, "Input",
 CellID->16124],
Cell[16026, 481, 156, 5, 36, "Output",
 CellID->1756]
}, Open  ]],
Cell[16197, 489, 120, 3, 70, "ExampleDelimiter",
 CellID->5654],
Cell[16320, 494, 51, 1, 70, "ExampleText",
 CellID->455],
Cell[CellGroupData[{
Cell[16396, 499, 229, 7, 70, "Input",
 CellID->18629],
Cell[16628, 508, 154, 5, 36, "Output",
 CellID->4872]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16831, 519, 216, 7, 70, "ExampleSection",
 CellID->10173],
Cell[17050, 528, 115, 2, 70, "ExampleText",
 CellID->3881],
Cell[CellGroupData[{
Cell[17190, 534, 244, 8, 70, "Input",
 CellID->32080],
Cell[17437, 544, 374, 13, 36, "Output",
 CellID->13384]
}, Open  ]],
Cell[17826, 560, 121, 3, 70, "ExampleDelimiter",
 CellID->32522],
Cell[17950, 565, 136, 4, 70, "ExampleText",
 CellID->13298],
Cell[CellGroupData[{
Cell[18111, 573, 195, 6, 70, "Input",
 CellID->26911],
Cell[18309, 581, 159, 5, 36, "Output",
 CellID->21401]
}, Open  ]],
Cell[18483, 589, 120, 3, 70, "ExampleDelimiter",
 CellID->9500],
Cell[18606, 594, 91, 1, 70, "ExampleText",
 CellID->12522],
Cell[CellGroupData[{
Cell[18722, 599, 126, 4, 70, "Input",
 CellID->13036],
Cell[18851, 605, 348, 12, 36, "Output",
 CellID->2387]
}, Open  ]],
Cell[CellGroupData[{
Cell[19236, 622, 102, 3, 70, "Input",
 CellID->19142],
Cell[19341, 627, 175, 6, 51, "Output",
 CellID->27304]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19565, 639, 238, 7, 70, "ExampleSection",
 CellID->1984],
Cell[19806, 648, 129, 2, 70, "ExampleText",
 CellID->32241],
Cell[CellGroupData[{
Cell[19960, 654, 184, 6, 70, "Input",
 CellID->10211],
Cell[20147, 662, 176, 5, 36, "Output",
 CellID->26025]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20372, 673, 223, 7, 70, "ExampleSection",
 CellID->13046],
Cell[20598, 682, 81, 1, 70, "ExampleText",
 CellID->21053],
Cell[CellGroupData[{
Cell[20704, 687, 240, 9, 70, "Input",
 CellID->20899],
Cell[20947, 698, 177, 6, 51, "Output",
 CellID->15157]
}, Open  ]],
Cell[CellGroupData[{
Cell[21161, 709, 116, 4, 70, "Input",
 CellID->2271],
Cell[21280, 715, 210, 6, 36, "Output",
 CellID->31661]
}, Open  ]],
Cell[21505, 724, 121, 3, 70, "ExampleDelimiter",
 CellID->24341],
Cell[21629, 729, 109, 3, 70, "ExampleText",
 CellID->21462],
Cell[CellGroupData[{
Cell[21763, 736, 362, 14, 70, "Input",
 CellID->24918],
Cell[22128, 752, 659, 21, 51, "Output",
 CellID->23427]
}, Open  ]],
Cell[22802, 776, 120, 3, 70, "ExampleDelimiter",
 CellID->4899],
Cell[CellGroupData[{
Cell[22947, 783, 263, 9, 70, "Input",
 CellID->3902],
Cell[23213, 794, 1011, 32, 71, "Output",
 CellID->12712]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24273, 832, 225, 7, 70, "ExampleSection",
 CellID->3489],
Cell[24501, 841, 247, 8, 70, "ExampleText",
 CellID->28094],
Cell[CellGroupData[{
Cell[24773, 853, 218, 7, 70, "Input",
 CellID->6521],
Cell[24994, 862, 405, 11, 36, "Output",
 CellID->15873]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25460, 880, 311, 9, 70, "SeeAlsoSection",
 CellID->28898],
Cell[25774, 891, 1489, 53, 70, "SeeAlso",
 CellID->22032]
}, Open  ]],
Cell[CellGroupData[{
Cell[27300, 949, 314, 9, 70, "TutorialsSection",
 CellID->27897],
Cell[27617, 960, 143, 3, 70, "Tutorials",
 CellID->17194],
Cell[27763, 965, 198, 4, 70, "Tutorials",
 CellID->22869]
}, Open  ]],
Cell[CellGroupData[{
Cell[27998, 974, 319, 9, 70, "MoreAboutSection",
 CellID->123037413],
Cell[28320, 985, 144, 3, 70, "MoreAbout",
 CellID->39507323],
Cell[28467, 990, 137, 3, 70, "MoreAbout",
 CellID->784406556],
Cell[28607, 995, 162, 3, 70, "MoreAbout",
 CellID->634612585],
Cell[28772, 1000, 137, 3, 70, "MoreAbout",
 CellID->644218125],
Cell[28912, 1005, 175, 3, 70, "MoreAbout",
 CellID->962644911],
Cell[29090, 1010, 159, 3, 70, "MoreAbout",
 CellID->83207003]
}, Open  ]],
Cell[CellGroupData[{
Cell[29286, 1018, 305, 8, 70, "RelatedLinksSection"],
Cell[29594, 1028, 365, 12, 70, "RelatedLinks"],
Cell[29962, 1042, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[30365, 1058, 50, 0, 70, "History"],
Cell[30418, 1060, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

