(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14399,        452]
NotebookOptionsPosition[     11815,        372]
NotebookOutlinePosition[     13011,        403]
CellTagsIndexPosition[     12968,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating the Front End from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating the Front End from the Kernel\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookEventActions" :> 
          Documentation`HelpLookup["paclet:ref/NotebookEventActions"], 
          "CellEventActions" :> 
          Documentation`HelpLookup["paclet:ref/CellEventActions"], 
          "EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookEventActions\"\>", 
       2->"\<\"CellEventActions\"\>", 
       3->"\<\"EventHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Low-Level Interface Control\"\>", 
       3->"\<\"Low-Level Notebook Programming\"\>", 
       4->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       5->"\<\"Stand-Alone Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrontEndEventActions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrontEndEventActions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFormula"],
     " \[LineSeparator]is an option for the notebook front end that gives a \
list of actions to perform when specified user-interface events occur. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4835]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrontEndEventActions", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ":>", 
      SubscriptBox[
       StyleBox["action", "TI"], 
       StyleBox["2", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["action", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be evaluated whenever ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"event\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " occurs in connection with the notebook."
}], "Notes",
 CellID->17512],

Cell[TextData[{
 "The possible event specifications are the same as for ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 ", with the following addition:"
}], "Notes",
 CellID->6074],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<WindowClose\>\"", Cell[
    "window being closed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23504],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrontEndEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFormula"],
 " is set as an option for ",
 Cell[BoxData[
  ButtonBox["$FrontEnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEnd"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13405],

Cell[TextData[{
 "By default, any action specified for an event by ",
 Cell[BoxData[
  ButtonBox["FrontEndEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFormula"],
 " will override any default action that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would take for that event."
}], "Notes",
 CellID->563375303],

Cell[TextData[{
 "The default behavior can be changed by including rules for ",
 Cell[BoxData[
  ButtonBox["PassEventsDown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PassEventsDown"]], "InlineFormula"],
 " in the list given as the setting for ",
 Cell[BoxData[
  ButtonBox["FrontEndEventActions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->141044261]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17464],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEventActions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEventActions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11820]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24440],

Cell[TextData[ButtonBox["Manipulating the Front End from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]], "Tutorials",
 CellID->13069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->543728174],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->414012532],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->369881598],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->163969498],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->70542577],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->240601128]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrontEndEventActions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 29.5332352}", "context" -> "System`", 
    "keywords" -> {"global event handler", "session event handler"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FrontEndEventActions is an option for the notebook front end that gives \
a list of actions to perform when specified user-interface events occur. ", 
    "synonyms" -> {"front end event actions"}, "title" -> 
    "FrontEndEventActions", "type" -> "Symbol", "uri" -> 
    "ref/FrontEndEventActions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2912, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3535, 95, 1585, 37, 70, "ObjectNameGrid"],
Cell[5123, 134, 533, 14, 70, "Usage",
 CellID->4835]
}, Open  ]],
Cell[CellGroupData[{
Cell[5693, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6171, 170, 920, 29, 70, "Notes",
 CellID->17512],
Cell[7094, 201, 263, 8, 70, "Notes",
 CellID->6074],
Cell[7360, 211, 353, 9, 70, "2ColumnTableMod",
 CellID->23504],
Cell[7716, 222, 344, 12, 70, "Notes",
 CellID->13405],
Cell[8063, 236, 369, 11, 70, "Notes",
 CellID->563375303],
Cell[8435, 249, 434, 13, 70, "Notes",
 CellID->141044261]
}, Closed]],
Cell[CellGroupData[{
Cell[8906, 267, 311, 9, 70, "SeeAlsoSection",
 CellID->17464],
Cell[9220, 278, 744, 26, 70, "SeeAlso",
 CellID->11820]
}, Open  ]],
Cell[CellGroupData[{
Cell[10001, 309, 314, 9, 70, "TutorialsSection",
 CellID->24440],
Cell[10318, 320, 192, 4, 70, "Tutorials",
 CellID->13069]
}, Open  ]],
Cell[CellGroupData[{
Cell[10547, 329, 319, 9, 70, "MoreAboutSection",
 CellID->543728174],
Cell[10869, 340, 168, 3, 70, "MoreAbout",
 CellID->414012532],
Cell[11040, 345, 163, 3, 70, "MoreAbout",
 CellID->369881598],
Cell[11206, 350, 169, 3, 70, "MoreAbout",
 CellID->163969498],
Cell[11378, 355, 208, 5, 70, "MoreAbout",
 CellID->70542577],
Cell[11589, 362, 154, 3, 70, "MoreAbout",
 CellID->240601128]
}, Open  ]],
Cell[11758, 368, 27, 0, 70, "History"],
Cell[11788, 370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

