(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79624,       1641]
NotebookOptionsPosition[     74890,       1490]
NotebookOutlinePosition[     76728,       1537]
CellTagsIndexPosition[     76608,       1531]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FrontEndExecute" :> 
         Documentation`HelpLookup["paclet:ref/FrontEndExecute"], 
         "FrontEndTokenExecute" :> 
         Documentation`HelpLookup["paclet:ref/FrontEndTokenExecute"], 
         "SystemDialogInput" :> 
         Documentation`HelpLookup["paclet:ref/SystemDialogInput"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FrontEndExecute\"\>", 
      2->"\<\"FrontEndTokenExecute\"\>", 
      3->"\<\"SystemDialogInput\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FrontEndToken", "ObjectName",
 CellID->27200],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrontEndToken",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrontEndToken"], "[", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]is an object which represents a front end command \
token, typically corresponding to a front end menu item, to be executed by ",
     Cell[BoxData[
      ButtonBox["FrontEndExecute",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrontEndToken",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrontEndToken"], "[", 
       RowBox[{
        StyleBox["nb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a command which targets the specified \
notebook. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrontEndToken",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrontEndToken"], "[", 
       RowBox[{
        StyleBox["nb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\"", ",", 
        StyleBox["param", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a command with a parameter."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->19854]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical tokens corresponding to menu items without parameters include: ",
 Cell[BoxData[
  ButtonBox["\"\<New\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/New"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<Open\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Open"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<Paste\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Paste"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SpellCheckerDialog\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<StackWindows\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/StackWindows"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<Fraction\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Fraction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<OpenCloseGroup\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/OpenCloseGroup"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<EvaluateCells\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/EvaluateCells"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<EvaluateInitialization\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/EvaluateInitialization"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->9990],

Cell[TextData[{
 "Typical tokens with associated parameters include: ",
 Cell[BoxData["\"\<Style\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<SelectionConvert\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/SelectionConvert"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<EvaluatorQuit\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/EvaluatorQuit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->52599603],

Cell["\<\
The mapping between command tokens and menu items or keyboard shortcuts is \
defined in front end text resource files.\
\>", "Notes",
 CellID->68365832]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40345922],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->318374149],

Cell["Create a notebook with two cells:", "ExampleText",
 CellID->239290059],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<line1\>\"", ",", "\"\<line2\>\""}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773708822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145785313],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1vFFUcxvE1JtxoDAn/gIRrr0yMMVyplwQT4o1vSEEKaNToH+AFob5Q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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->531477209]
}, Open  ]],

Cell[TextData[{
 "Merge the cells by using a ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25884281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<CellMerge\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->42677359],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvlEUcxvEaE280xsR/QOK1VybGGK/USwIJ8cYzRSmiUaN/gBeGg1I1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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->653583982],

Cell["Open a document:", "ExampleText",
 CellID->362669881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{
     "$InstallationDirectory", ",", 
      "\"\<Documentation\\\\System\\\\ExampleData\\\\document.nb\>\""}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128716651],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnduTHsV5h79U7lP+F/Kv5HApu4ryVaiKERWEnJTLlRRXoMqFK9iJkVOR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   "], {{0, 0}, {458, 187}}, {0, 255}],
  ImageSize->{458 0.75, 187 0.75},
  PlotRange->{{0, 458}, {0, 187}}]], "NotebookImage",
 CellID->312996701]
}, Open  ]],

Cell["Use a token to move the insertion point:", "ExampleText",
 CellID->433891569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<MoveNextLine\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115593858],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnduTHsV5h79U7lP+F/Kv5HApu4ryVaiKERWEnJTLlRRXoMqFK9iJkVOR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   "], {{0, 0}, {458, 187}}, {0, 255}],
  ImageSize->{458 0.75, 187 0.75},
  PlotRange->{{0, 458}, {0, 187}}]], "NotebookImage",
 CellID->39183247]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FrontEndToken", "[", 
     RowBox[{"nb", ",", "\"\<MoveNext\>\""}], "]"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->536953365],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztneuTHsV1hyeV7yn/C/lXcvkou4ryp1AVIyoIOSmXKyk+gSofXMFOjJyK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   "], {{0, 0}, {458, 187}}, {0, 255}],
  ImageSize->{458 0.75, 187 0.75},
  PlotRange->{{0, 458}, {0, 187}}]], "NotebookImage",
 CellID->343086122]
}, Open  ]],

Cell["Use a token to select all of the document:", "ExampleText",
 CellID->33028262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<SelectAll\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12473157],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f2THMV9x/FN5feU/4X8J648/BY5FeJfEqowuAI+J+WikuInUMVVLoMT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   "], {{0, 0}, {458, 389}}, {0, 255}],
  ImageSize->{458 0.75, 389 0.75},
  PlotRange->{{0, 458}, {0, 389}}]], "NotebookImage",
 CellID->151230114]
}, Open  ]],

Cell["Use a token to close all cell groups in the selection:", "ExampleText",
 CellID->226612649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<SelectionCloseAllGroups\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->338802177],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnV1vFccZx0/V+ypSPkGUj9APUKntZdNIbW7aqg1EDZBWadUqV03Uiygv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   "], {{0, 0}, {458, 166}}, {0, 255}],
  ImageSize->{458 0.75, 166 0.75},
  PlotRange->{{0, 458}, {0, 166}}]], "NotebookImage",
 CellID->361968206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304367392],

Cell["Use a front end token to tile notebook windows:", "ExampleText",
 CellID->324527576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<TileWindowsTall\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235867734],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{576, 87},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->162400848]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12931],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32544]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrontEndToken - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 36.5177890}", "context" -> "System`", 
    "keywords" -> {
     "front end commands", "front end tokens", "notebook interface commands", 
      "notebook interface tokens", "scripting front end", "scripting gui", 
      "scripting menu commands"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrontEndToken[\"cmd\"] is an object which represents a front end command \
token, typically corresponding to a front end menu item, to be executed by \
FrontEndExecute. FrontEndToken[nb, \" cmd\"] represents a command which \
targets the specified notebook. FrontEndToken[nb, \" cmd\", param] represents \
a command with a parameter.", "synonyms" -> {"front end token"}, "title" -> 
    "FrontEndToken", "type" -> "Symbol", "uri" -> "ref/FrontEndToken"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5742, 193, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->40345922]},
 "Notebook Image"->{
  Cell[57519, 1171, 16172, 268, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->162400848]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76337, 1520},
 {"Notebook Image", 76477, 1524}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 868, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1491, 47, 51, 1, 70, "ObjectName",
 CellID->27200],
Cell[1545, 50, 1573, 45, 70, "Usage",
 CellID->19854]
}, Open  ]],
Cell[CellGroupData[{
Cell[3155, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3633, 117, 1419, 47, 70, "Notes",
 CellID->9990],
Cell[5055, 166, 485, 16, 70, "Notes",
 CellID->52599603],
Cell[5543, 184, 162, 4, 70, "Notes",
 CellID->68365832]
}, Closed]],
Cell[CellGroupData[{
Cell[5742, 193, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40345922],
Cell[CellGroupData[{
Cell[6126, 207, 148, 5, 70, "ExampleSection",
 CellID->318374149],
Cell[6277, 214, 76, 1, 70, "ExampleText",
 CellID->239290059],
Cell[6356, 217, 231, 8, 70, "Input",
 CellID->773708822],
Cell[CellGroupData[{
Cell[6612, 229, 152, 4, 70, "Input",
 CellID->145785313],
Cell[6767, 235, 2890, 50, 70, "NotebookImage",
 CellID->531477209]
}, Open  ]],
Cell[9672, 288, 219, 8, 70, "ExampleText",
 CellID->25884281],
Cell[CellGroupData[{
Cell[9916, 300, 191, 5, 70, "Input",
 CellID->42677359],
Cell[10110, 307, 2794, 48, 70, "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12953, 361, 220, 7, 70, "ExampleSection",
 CellID->653583982],
Cell[13176, 370, 59, 1, 70, "ExampleText",
 CellID->362669881],
Cell[CellGroupData[{
Cell[13260, 375, 316, 10, 70, "Input",
 CellID->128716651],
Cell[13579, 387, 7891, 132, 70, "NotebookImage",
 CellID->312996701]
}, Open  ]],
Cell[21485, 522, 83, 1, 70, "ExampleText",
 CellID->433891569],
Cell[CellGroupData[{
Cell[21593, 527, 195, 5, 70, "Input",
 CellID->115593858],
Cell[21791, 534, 7910, 132, 70, "NotebookImage",
 CellID->39183247]
}, Open  ]],
Cell[CellGroupData[{
Cell[29738, 671, 276, 8, 70, "Input",
 CellID->536953365],
Cell[30017, 681, 7964, 133, 70, "NotebookImage",
 CellID->343086122]
}, Open  ]],
Cell[37996, 817, 84, 1, 70, "ExampleText",
 CellID->33028262],
Cell[CellGroupData[{
Cell[38105, 822, 191, 5, 70, "Input",
 CellID->12473157],
Cell[38299, 829, 12514, 207, 70, "NotebookImage",
 CellID->151230114]
}, Open  ]],
Cell[50828, 1039, 97, 1, 70, "ExampleText",
 CellID->226612649],
Cell[CellGroupData[{
Cell[50950, 1044, 209, 6, 70, "Input",
 CellID->338802177],
Cell[51162, 1052, 5898, 99, 70, "NotebookImage",
 CellID->361968206]
}, Open  ]],
Cell[57075, 1154, 125, 3, 70, "ExampleDelimiter",
 CellID->304367392],
Cell[57203, 1159, 90, 1, 70, "ExampleText",
 CellID->324527576],
Cell[CellGroupData[{
Cell[57318, 1164, 198, 5, 70, "Input",
 CellID->235867734],
Cell[57519, 1171, 16172, 268, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->162400848]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73752, 1446, 311, 9, 70, "SeeAlsoSection",
 CellID->12931],
Cell[74066, 1457, 752, 26, 70, "SeeAlso",
 CellID->32544]
}, Open  ]],
Cell[74833, 1486, 27, 0, 70, "History"],
Cell[74863, 1488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

