(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42881,        929]
NotebookOptionsPosition[     40081,        837]
NotebookOutlinePosition[     41352,        873]
CellTagsIndexPosition[     41267,        868]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "DataRange" :> Documentation`HelpLookup["paclet:ref/DataRange"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"All\"\>", 
       2->"\<\"DataRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Graphics Shape & Size\"\>", 
       2->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Full", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"]], "InlineFormula"],
     "\[LineSeparator]is a setting used for certain options, typically \
indicating that a full range of values should be included. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", "Full"}]], "InlineFormula"],
 " specifies that a graphic should be stretched to fill out an enclosing \
region. "
}], "Notes",
 CellID->13444],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", "Full"}]], "InlineFormula"],
 " specifies that a plot should include the full range of values of input \
variables. "
}], "Notes",
 CellID->23186]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3616941],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41396763],

Cell[TextData[{
 "Normally, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " shows only the existing points:"
}], "ExampleText",
 CellID->5640093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34086266],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238932473]
}, Open  ]],

Cell[TextData[{
 "Show the full ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " range, using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", "Full"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->204923944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748967300],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198413430]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26431],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7152]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->47758058],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->28867143],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->21630011]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Full - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 43.8461016}", "context" -> "System`", 
    "keywords" -> {"full plotrange", "plot domain", "domain range"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Full is a setting used for certain options, typically indicating that a \
full range of values should be included. ", "synonyms" -> {}, "title" -> 
    "Full", "type" -> "Symbol", "uri" -> "ref/Full"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5193, 161, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3616941]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41126, 861}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1373, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1996, 60, 1569, 37, 70, "ObjectNameGrid"],
Cell[3568, 99, 484, 14, 70, "Usage",
 CellID->8387]
}, Open  ]],
Cell[CellGroupData[{
Cell[4089, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4567, 135, 302, 10, 70, "Notes",
 CellID->13444],
Cell[4872, 147, 284, 9, 70, "Notes",
 CellID->23186]
}, Closed]],
Cell[CellGroupData[{
Cell[5193, 161, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3616941],
Cell[CellGroupData[{
Cell[5576, 175, 147, 5, 70, "ExampleSection",
 CellID->41396763],
Cell[5726, 182, 325, 12, 70, "ExampleText",
 CellID->5640093],
Cell[CellGroupData[{
Cell[6076, 198, 463, 15, 28, "Input",
 CellID->34086266],
Cell[6542, 215, 21778, 361, 160, "Output",
 Evaluatable->False,
 CellID->238932473]
}, Open  ]],
Cell[28335, 579, 336, 13, 70, "ExampleText",
 CellID->204923944],
Cell[CellGroupData[{
Cell[28696, 596, 465, 15, 28, "Input",
 CellID->748967300],
Cell[29164, 613, 9371, 158, 167, "Output",
 Evaluatable->False,
 CellID->198413430]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38596, 778, 311, 9, 70, "SeeAlsoSection",
 CellID->26431],
Cell[38910, 789, 442, 17, 70, "SeeAlso",
 CellID->7152]
}, Open  ]],
Cell[CellGroupData[{
Cell[39389, 811, 318, 9, 70, "MoreAboutSection",
 CellID->47758058],
Cell[39710, 822, 152, 3, 70, "MoreAbout",
 CellID->28867143],
Cell[39865, 827, 144, 3, 70, "MoreAbout",
 CellID->21630011]
}, Open  ]],
Cell[40024, 833, 27, 0, 70, "History"],
Cell[40054, 835, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

