(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9982,        353]
NotebookOptionsPosition[      7311,        265]
NotebookOutlinePosition[      8628,        302]
CellTagsIndexPosition[      8544,        297]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteOptions\"\>", 
       2->"\<\"InputForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FullGraphics", "ObjectName",
 CellID->26890],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FullGraphics",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FullGraphics"], "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a graphics object, and generates a new one in \
which objects specified by graphics options are given as explicit lists of \
graphics primitives. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullGraphics"]], "InlineFormula"],
 " generates explicit graphics primitives for objects specified by options \
such as ",
 Cell[BoxData[
  ButtonBox["Axes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axes"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 ", etc. "
}], "Notes",
 CellID->8805],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullGraphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullGraphics"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " should display the same as ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", though it may have a different internal structure."
}], "Notes",
 CellID->105594930]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131221536],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->334992109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633420125],

Cell["Graphics[Disk[{0, 0}], Frame -> True, FrameTicks -> None]", "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->348000260]
}, Open  ]],

Cell["\<\
Generate explicit graphics primitives for everything, including the frame:\
\>", "ExampleText",
 CellID->23489170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"FullGraphics", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385114785],

Cell["\<\
Graphics[{Disk[{0, 0}], {{GrayLevel[0.], AbsoluteThickness[0.25], 
    Line[{{-1., -1.}, {1., -1.}}]}, {GrayLevel[0.], AbsoluteThickness[0.25], 
    Line[{{-1., -1.}, {-1., 1.}}]}, {GrayLevel[0.], AbsoluteThickness[0.25], 
    Line[{{-1., 1.}, {1., 1.}}]}, {GrayLevel[0.], AbsoluteThickness[0.25], 
    Line[{{1., -1.}, {1., 1.}}]}}}]\
\>", "Output",
 ImageSize->{539, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->498163663]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23165],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32372],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->30032]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FullGraphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 38.2365830}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FullGraphics[g] takes a graphics object, and generates a new one in \
which objects specified by graphics options are given as explicit lists of \
graphics primitives. ", "synonyms" -> {"full graphics"}, "title" -> 
    "FullGraphics", "type" -> "Symbol", "uri" -> "ref/FullGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4011, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->131221536]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8401, 290}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1306, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1929, 60, 50, 1, 70, "ObjectName",
 CellID->26890],
Cell[1982, 63, 602, 17, 70, "Usage",
 CellID->16671]
}, Open  ]],
Cell[CellGroupData[{
Cell[2621, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3099, 102, 500, 18, 70, "Notes",
 CellID->8805],
Cell[3602, 122, 372, 12, 70, "Notes",
 CellID->105594930]
}, Closed]],
Cell[CellGroupData[{
Cell[4011, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131221536],
Cell[CellGroupData[{
Cell[4396, 153, 148, 5, 70, "ExampleSection",
 CellID->334992109],
Cell[CellGroupData[{
Cell[4569, 162, 283, 8, 28, "Input",
 CellID->633420125],
Cell[4855, 172, 217, 5, 50, "Output",
 CellID->348000260]
}, Open  ]],
Cell[5087, 180, 124, 3, 70, "ExampleText",
 CellID->23489170],
Cell[CellGroupData[{
Cell[5236, 187, 144, 4, 28, "Input",
 CellID->385114785],
Cell[5383, 193, 502, 11, 114, "Output",
 CellID->498163663]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5946, 211, 311, 9, 70, "SeeAlsoSection",
 CellID->23165],
Cell[6260, 222, 467, 17, 70, "SeeAlso",
 CellID->15431]
}, Open  ]],
Cell[CellGroupData[{
Cell[6764, 244, 314, 9, 70, "TutorialsSection",
 CellID->32372],
Cell[7081, 255, 158, 3, 70, "Tutorials",
 CellID->30032]
}, Open  ]],
Cell[7254, 261, 27, 0, 70, "History"],
Cell[7284, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

