(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    104938,       3699]
NotebookOptionsPosition[     84863,       2985]
NotebookOutlinePosition[     86684,       3033]
CellTagsIndexPosition[     86552,       3027]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pure Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PureFunctions"], 
          "Variables in Pure Functions and Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/VariablesInPureFunctionsAndRules"], 
          "Some General Notations and Conventions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeGeneralNotationsAndConventions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Pure Functions\"\>", 
       2->"\<\"Variables in Pure Functions and Rules\"\>", 
       3->"\<\"Some General Notations and Conventions\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], 
          "CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Apply\"\>", 
       2->"\<\"CompiledFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Functional Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Function ",
 StyleBox["(&)", "OperatorCharacter"]
}], "ObjectName",
 CellID->8329],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Function",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Function"], "[", 
       StyleBox["body", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["body", "TI"], "&"}]], "InlineFormula"],
     " is a pure function. The formal parameters are ",
     Cell[BoxData["#"], "InlineFormula"],
     " (or ",
     Cell[BoxData["#1"], "InlineFormula"],
     "), ",
     Cell[BoxData["#2"], "InlineFormula"],
     ", etc. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Function",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Function"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pure function with a single formal parameter ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Function",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Function"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pure function with a list of formal parameters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   StyleBox["body", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["body", "TI"], "&"}]], "InlineFormula"],
 " is applied to a set of arguments, ",
 Cell[BoxData["#"], "InlineFormula"],
 " (or ",
 Cell[BoxData["#1"], "InlineFormula"],
 ") is replaced by the first argument, ",
 Cell[BoxData["#2"], "InlineFormula"],
 " by the second, and so on. ",
 Cell[BoxData["#0"], "InlineFormula"],
 " is replaced by the function itself. "
}], "Notes",
 CellID->22974],

Cell[TextData[{
 "If there are more arguments supplied than ",
 Cell[BoxData[
  RowBox[{"#", "\[InvisibleSpace]", 
   StyleBox["i", "TI"]}]], "InlineFormula"],
 " in the function, the remaining arguments are ignored. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25967,
  ButtonNote->"25967"]
}], "Notes",
 CellID->23072],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " stands for the sequence of all arguments supplied. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29126,
  ButtonNote->"29126"]
}], "Notes",
 CellID->3591],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"##", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " stands for arguments from number ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " on. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26705,
  ButtonNote->"26705"]
}], "Notes",
 CellID->12189],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " is analogous to ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " in LISP or formal logic. "
}], "Notes",
 CellID->15787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". The function body is evaluated only after the formal parameters have been \
replaced by arguments. "
}], "Notes",
 CellID->31490],

Cell[TextData[{
 "The named formal parameters ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " are treated as local, and are renamed ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], "$"}]], "InlineFormula"],
 " when necessary to avoid confusion with actual arguments supplied to the \
function. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->8044,
  ButtonNote->"8044"]
}], "Notes",
 CellID->3239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " constructs can be nested in any way. Each is treated as a scoping \
construct, with named inner variables being renamed if necessary. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->573653727,
  ButtonNote->"573653727"]
}], "Notes",
 CellID->14893],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    StyleBox["params", "TI"], ",", 
    StyleBox["body", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["attr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " represents a pure function that is to be treated as having attributes ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["attr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for the purpose of evaluation. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16360,
  ButtonNote->"16360"]
}], "Notes",
 CellID->3053]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94419939],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->80281647],

Cell["Pure function with one parameter:", "ExampleText",
 CellID->13998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"u", ",", 
    RowBox[{"3", "+", "u"}]}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21083],

Cell[BoxData[
 RowBox[{"3", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315286842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"3", "+", "#"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1662480133],

Cell[BoxData[
 RowBox[{"3", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266044399]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "+", "#"}], ")"}], "&"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29515],

Cell[BoxData[
 RowBox[{"3", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->44726518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29993],

Cell["Pure function with two parameters:", "ExampleText",
 CellID->15826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}], ",", 
    RowBox[{
     RowBox[{"u", "^", "2"}], "+", 
     RowBox[{"v", "^", "4"}]}]}], "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15722],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "4"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357256382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#1", "^", "2"}], "+", 
     RowBox[{"#2", "^", "4"}]}], ")"}], "&"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24828],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "4"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105367307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24399],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " to be a pure function:"
}], "ExampleText",
 CellID->8978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "+", "#"}], ")"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11891],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "+", "#1"}], "&"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140201030]
}, Open  ]],

Cell["Use the pure function:", "ExampleText",
 CellID->26943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "+", "a"}], ",", 
   RowBox[{"3", "+", "b"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257428557]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->87490922],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Use a pure function as argument",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1197707878],

Cell["Map a pure function over a list:", "ExampleText",
 CellID->2702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"#", ",", 
     RowBox[{"#", "^", "2"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x", ",", 
     SuperscriptBox["x", "2"]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"y", ",", 
     SuperscriptBox["y", "2"]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"z", ",", 
     SuperscriptBox["z", "2"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{196, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230303521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->569879184],

Cell["Select with a pure function:", "ExampleText",
 CellID->10687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", ">", "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->603783890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->754182531],

Cell["Use a pure function as a predicate:", "ExampleText",
 CellID->404324366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
   RowBox[{"_Integer", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", ">", "0"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1812804422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93294541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->587984190],

Cell["Create an array from a pure function:", "ExampleText",
 CellID->18413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"#", "^", "2"}]}], "&"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11400],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "10", ",", "17", ",", "26", ",", "37", ",", "50", ",", 
   "65", ",", "82", ",", "101"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452028277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148143891],

Cell["Sort by comparing the second part of each element:", "ExampleText",
 CellID->14372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "<", 
     RowBox[{"#2", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242082370]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Use a pure function as an option value",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->823687550],

Cell[TextData[{
 "Specify a custom comparison function in ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->264880107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1`20", 
   ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#1", "-", "#2"}], "]"}], "<", "1*^-10"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1016195388],

Cell[BoxData["1.41421356237309504880168962350253024361`19.999999999999996"], \
"Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727080066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41896137],

Cell["Specify a custom color function:", "ExampleText",
 CellID->549999477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{
        RowBox[{"1", "-", "#"}], ",", "#", ",", 
        RowBox[{"1", "-", "#"}]}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1217298744],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7382657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62357987],

Cell["Provide a custom distance function:", "ExampleText",
 CellID->1083420556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", "5", 
   ",", 
   RowBox[{"DistanceFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"#1", "-", "#2"}], ")"}], "^", "2"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1618038406],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725570602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Return a pure function as result",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->740014874],

Cell["Derivative of a pure function:", "ExampleText",
 CellID->2005626528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}], "'"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698434720],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"2", " ", "x"}]}], "]"}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64245191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204205777],

Cell[TextData[{
 "Derivative of ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->729918881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "'"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->780585980],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Sec", "[", "#1", "]"}], "2"], "&"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293590932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244095561],

Cell["\<\
Solutions of differential equations may be expressed as pure functions:\
\>", "ExampleText",
 CellID->2142864125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"a", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1806399388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", " ", "x"}]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464861408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17256134],

Cell["Difference equations may return pure functions:", "ExampleText",
 CellID->1489544862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "-", 
       RowBox[{"2", 
        RowBox[{"a", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "a", ",",
    "n"}], "]"}]], "Input",
 CellTags->"Ex--22029503983018204282,3",
 CellLabel->"In[1]:=",
 CellID->18971727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["2", 
        RowBox[{"1", "+", "n"}]]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{207, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22029503983018204282,3",
 CellLabel->"Out[1]=",
 CellID->890322633]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8935],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " stands for all arguments:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->29126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19410],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"X", ",", "##", ",", "Y", ",", "##"}], "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11382],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "X", ",", "a", ",", "b", ",", "c", ",", "d", ",", "Y", ",", "a", ",", "b", 
   ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27189],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"##", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " stands for argument ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " on:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##2", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13874],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2663]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
    "##1", ",", "X", ",", "##2", ",", "Y", ",", "##3", ",", "Z", ",", "##4"}],
     "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20722],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "X", ",", "b", ",", "c", ",", "d", 
   ",", "Y", ",", "c", ",", "d", ",", "Z", ",", "d"}], "]"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22566],

Cell[TextData[{
 "Create a pure function with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"g", "[", "u", "]"}], ",", "Listable"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6038],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", 
   RowBox[{"g", "[", "b", "]"}], ",", 
   RowBox[{"g", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18588]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"g", "[", "u", "]"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7811],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9467],

Cell[TextData[{
 Cell[BoxData["#0"], "InlineFormula"],
 " stands for the whole pure function:"
}], "ExampleText",
 CellID->32425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#0", "]"}], "&"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26867],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", "#0", "]"}], "&"}], "]"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13189]
}, Open  ]],

Cell[TextData[{
 "A recursive definition for factorial using ",
 Cell[BoxData["#0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"#1", "\[Equal]", "1"}], ",", "1", ",", 
     RowBox[{"#1", " ", 
      RowBox[{"#0", "[", 
       RowBox[{"#1", "-", "1"}], "]"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13063],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"#1", "\[Equal]", "1"}], ",", "1", ",", 
    RowBox[{"#1", " ", 
     RowBox[{"#0", "[", 
      RowBox[{"#1", "-", "1"}], "]"}]}]}], "]"}], "&"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30502],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29617]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25023],

Cell["\<\
Turn a function that takes several arguments into one that takes a list of \
arguments:\
\>", "ExampleText",
 CellID->358798615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cplus", "=", 
  RowBox[{
   RowBox[{"Plus", "@@", "#"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1437853734],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "#1"}], "&"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1845710]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cplus", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2116411461],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->530819859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1963269286],

Cell[TextData[{
 "A function that returns a function that multiplies its argument by ",
 Cell[BoxData["n"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->591629748],

Cell[BoxData[
 RowBox[{
  RowBox[{"makef", "[", "n_", "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"n", " ", "x"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1220220993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{"makef", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1352822970],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x$", ",", 
   RowBox[{"2", " ", "x$"}]}], "]"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22599852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", "5", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->101922602],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13293027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59883127],

Cell["Preserve arguments in unevaluated form:", "ExampleText",
 CellID->1041535829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", ",", "$MaxMachineNumber"}], "]"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{"symbol", ",", 
     RowBox[{
      RowBox[{"Context", "[", "symbol", "]"}], "===", "\"\<System`\>\""}], 
     ",", "HoldAll"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->972657636],

Cell[BoxData[
 RowBox[{"Hold", "[", "$MaxMachineNumber", "]"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1508424288]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->321726587],

Cell[TextData[{
 Cell[BoxData["#1"], "InlineFormula"],
 " uses only the first argument supplied; the rest are ignored:"
}], "ExampleText",
 CellID->25967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#1", "]"}], "&"}], "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8456],

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169348999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250791120],

Cell["Not using any arguments results in a constant pure function:", \
"ExampleText",
 CellID->74539718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"17", "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1484693174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17", ",", "17", ",", "17"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25877109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105391536],

Cell["Replacements can be done inside pure functions:", "ExampleText",
 CellID->29962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"p", "+", "#"}], ")"}], "&"}], " ", "/.", 
  RowBox[{"p", "->", "q"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26819],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "+", "#1"}], "&"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24992630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10556],

Cell[BoxData[
 RowBox[{"q", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282727859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236391989],

Cell["\<\
Formal parameters are renamed whenever there is a possibility of confusion:\
\>", "ExampleText",
 CellID->8044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "y", "}"}], ",", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], "]"}], "[", "y", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30591],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "y$"}], "]"}]}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->893439898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "y", "}"}], ",", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}], "]"}], "[", "a", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3388],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "y$"}], "]"}]}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576888167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "y", "}"}], ",", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", "z", "}"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], "]"}], 
  "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7450],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "z$", "}"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "y$", ",", "z$"}], "]"}]}], "]"}]}], "]"}]], "Output",\

 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7660901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->855937645],

Cell["The names of the parameters do not matter:", "ExampleText",
 CellID->565842741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"y", ",", 
       RowBox[{"x", "^", "y"}]}], "]"}]}], "]"}], "[", "x", "]"}], "[", "y", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2108754328],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70840769]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"y", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"y", "^", "x"}]}], "]"}]}], "]"}], "[", "x", "]"}], "[", "y", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2030512569],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51096391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8538401],

Cell["However, reusing a name introduces a new scope:", "ExampleText",
 CellID->573653727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{"x", "^", "x"}]}], "]"}]}], "]"}], "[", "x", "]"}], "[", "y", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1967603499],

Cell[BoxData[
 SuperscriptBox["y", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53356803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18121309],

Cell["Nested functions take their arguments one at a time:", "ExampleText",
 CellID->279833269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Function", "[", 
      RowBox[{"y", ",", 
       RowBox[{"x", "^", "y"}]}], "]"}]}], "]"}], "[", "a", "]"}], "[", "b", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->879674601],

Cell[BoxData[
 SuperscriptBox["a", "b"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584457232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"x", "^", "y"}]}], "]"}], "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1033794124],

Cell[BoxData[
 SuperscriptBox["a", "b"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260697393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->815690094],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", "#", "]"}], "&"}]], "InlineFormula"],
 " is the same as simply ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " in the univariate case:"
}], "ExampleText",
 CellID->1150254824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#", "]"}], "&"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2093373106],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446677040]
}, Open  ]],

Cell[TextData[{
 "In general ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", "##", "]"}], "&"}]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->412152674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "##", "]"}], "&"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42305261],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160749192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45879510],

Cell[TextData[{
 "Turn a formula involving a variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " into a pure function:"
}], "ExampleText",
 CellID->630696395],

Cell[BoxData[
 RowBox[{
  RowBox[{"formula", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514951200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Evaluate", "[", "formula", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->852300799],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{139, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62995052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132284389],

Cell[TextData[{
 "Use a formula in ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2132488719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643712487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396856391]
}, Open  ]],

Cell[TextData[{
 "Use the corresponding pure function in an equivalent ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->515853344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1021468397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->363019614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291081164],

Cell[TextData[{
 "There are special purpose function constructs including, ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->250811022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "6"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->902546438],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227155987]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "4", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205583927],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31691875]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1919816596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "^", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->670485441],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    SuperscriptBox["x", "2"], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{284, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151139964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5.0", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1738384124],

Cell[BoxData["25.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15443583]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NearestFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NearestFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1657681850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1777283476],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->49928352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3.1", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1922775913],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->733825524]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->191457026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->254194147],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->179531365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->244218684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{55, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->7073654]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6272],

Cell[TextData[{
 Cell[BoxData["&"], "InlineFormula"],
 " binds more loosely than ",
 Cell[BoxData["->"], "InlineFormula"],
 ", so it usually needs parentheses in rules:"
}], "ExampleText",
 CellID->25791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"x", "->", "y"}], "&"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29383],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Function", "[", 
    RowBox[{"Rule", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->727661472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x", "->", 
   RowBox[{"(", 
    RowBox[{"y", "&"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1775],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Rule", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Function", "[", "y", "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->395663379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->508037783],

Cell[TextData[{
 Cell[BoxData["&"], "InlineFormula"],
 " binds more loosely than ",
 Cell[BoxData["?"], "InlineFormula"],
 ", so it usually needs parentheses in pattern tests:"
}], "ExampleText",
 CellID->1154813464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"OddQ", "[", 
       RowBox[{"#", "/", "2"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1525681141],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426479339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23569],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " does not evaluate its body until the function is applied:"
}], "ExampleText",
 CellID->18300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"#", "+", "#", "+", "#"}], ")"}], "&"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17954],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "+", "#1", "+", "#1"}], "&"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2647561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3585],

Cell[BoxData[
 RowBox[{"3", " ", "a"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->404895496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1559107221],

Cell["\<\
Supplying fewer than the required number of arguments generates an error:\
\>", "ExampleText",
 CellID->1793033747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"#2", "&"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471751041],

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "::", "\<\"slotn\"\>"}], ":", 
  " ", "\<\"Slot number \\!\\(2\\) in \\!\\(#2 &\\) cannot be filled from \\!\
\\(\\(\\((\\(#2 &\\))\\)\\)[x]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Function/slotn\\\", \
ButtonNote -> \\\"Function::slotn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->662362350],

Cell[BoxData["#2"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521704236]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->893],

Cell[TextData[{
 "Define the recursion operator of recursion theory [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-907b-text"], None}],
 "]:"
}], "ExampleText",
 CellID->407099134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"g_", ",", "h_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"#1", "\[Equal]", "0"}], ",", 
     RowBox[{"g", "[", "##2", "]"}], ",", 
     RowBox[{"h", "[", 
      RowBox[{
       RowBox[{"#0", "[", 
        RowBox[{
         RowBox[{"#1", "-", "1"}], ",", "##2"}], "]"}], ",", 
       RowBox[{"#1", "-", "1"}], ",", "##2"}], "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1992136962],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"#1", "\[Equal]", "0"}], ",", 
    RowBox[{"g", "[", "##2", "]"}], ",", 
    RowBox[{"h", "[", 
     RowBox[{
      RowBox[{"#0", "[", 
       RowBox[{
        RowBox[{"#1", "-", "1"}], ",", "##2"}], "]"}], ",", 
      RowBox[{"#1", "-", "1"}], ",", "##2"}], "]"}]}], "]"}], "&"}]], "Output",\

 ImageSize->{337, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->582390418]
}, Open  ]],

Cell["Use it to define the factorial function:", "ExampleText",
 CellID->429115848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{
    RowBox[{"1", "&"}], ",", 
    RowBox[{
     RowBox[{"#1", 
      RowBox[{"(", 
       RowBox[{"#2", "+", "1"}], ")"}]}], "&"}]}], "]"}], "[", "10", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115000401],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1701929895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193896730],

Cell["Newton's formula for finding a zero of a function:", "ExampleText",
 CellID->2120143300],

Cell[BoxData[
 RowBox[{
  RowBox[{"NewtonZero", "[", 
   RowBox[{"f_", ",", "x0_"}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "-", 
      RowBox[{
       RowBox[{"f", "[", "#", "]"}], "/", 
       RowBox[{
        RowBox[{"f", "'"}], "[", "#", "]"}]}]}], "&"}], ",", "x0"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->971100393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonZero", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "#"}], "]"}], "&"}], ",", "5.0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351788941],

Cell[BoxData["5.135622301840683`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10356772]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24176],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompiledFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CompiledFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18479]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17063],

Cell[TextData[ButtonBox["Pure Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PureFunctions"]], "Tutorials",
 CellID->10681],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VariablesInPureFunctionsAndRules"]], "Tutorials",\

 CellID->135909037],

Cell[TextData[ButtonBox["Some General Notations and Conventions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions"]], "Tutorials",
 CellID->314307143]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->5257688],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->21110944],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->15642971]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function (&) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 47.0180578}", "context" -> "System`", 
    "keywords" -> {
     "ampersand", "anonymous functions", "expressions", "lambda expression", 
      "pure function", "unnamed function", "function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Function[body] or body & is a pure function. The formal parameters are # \
(or #1), #2, etc. Function[x, body] is a pure function with a single formal \
parameter x. Function[{x_1, x_2, ...}, body] is a pure function with a list \
of formal parameters. ", "synonyms" -> {"&", "lambda"}, "title" -> "Function",
     "type" -> "Symbol", "uri" -> "ref/Function"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9954, 343, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->94419939]},
 "Ex--22029503983018204282,3"->{
  Cell[47207, 1356, 472, 16, 70, "Input",
   CellTags->"Ex--22029503983018204282,3",
   CellID->18971727],
  Cell[47682, 1374, 473, 16, 39, "Output",
   CellTags->"Ex--22029503983018204282,3",
   CellID->890322633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 86160, 3013},
 {"Ex--22029503983018204282,3", 86312, 3017}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2391, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3014, 84, 100, 4, 70, "ObjectName",
 CellID->8329],
Cell[3117, 90, 1827, 58, 70, "Usage",
 CellID->16290]
}, Open  ]],
Cell[CellGroupData[{
Cell[4981, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5459, 170, 635, 22, 70, "Notes",
 CellID->22974],
Cell[6097, 194, 353, 11, 70, "Notes",
 CellID->23072],
Cell[6453, 207, 244, 8, 70, "Notes",
 CellID->3591],
Cell[6700, 217, 332, 13, 70, "Notes",
 CellID->12189],
Cell[7035, 232, 280, 10, 70, "Notes",
 CellID->15787],
Cell[7318, 244, 405, 13, 70, "Notes",
 CellID->31490],
Cell[7726, 259, 899, 33, 70, "Notes",
 CellID->3239],
Cell[8628, 294, 416, 12, 70, "Notes",
 CellID->14893],
Cell[9047, 308, 870, 30, 70, "Notes",
 CellID->3053]
}, Closed]],
Cell[CellGroupData[{
Cell[9954, 343, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94419939],
Cell[CellGroupData[{
Cell[10338, 357, 147, 5, 70, "ExampleSection",
 CellID->80281647],
Cell[10488, 364, 72, 1, 70, "ExampleText",
 CellID->13998],
Cell[CellGroupData[{
Cell[10585, 369, 177, 6, 28, "Input",
 CellID->21083],
Cell[10765, 377, 180, 6, 36, "Output",
 CellID->315286842]
}, Open  ]],
Cell[CellGroupData[{
Cell[10982, 388, 157, 5, 28, "Input",
 CellID->1662480133],
Cell[11142, 395, 180, 6, 36, "Output",
 CellID->266044399]
}, Open  ]],
Cell[CellGroupData[{
Cell[11359, 406, 160, 6, 28, "Input",
 CellID->29515],
Cell[11522, 414, 179, 6, 36, "Output",
 CellID->44726518]
}, Open  ]],
Cell[11716, 423, 121, 3, 70, "ExampleDelimiter",
 CellID->29993],
Cell[11840, 428, 73, 1, 70, "ExampleText",
 CellID->15826],
Cell[CellGroupData[{
Cell[11938, 433, 303, 11, 70, "Input",
 CellID->15722],
Cell[12244, 446, 228, 8, 36, "Output",
 CellID->357256382]
}, Open  ]],
Cell[CellGroupData[{
Cell[12509, 459, 237, 9, 70, "Input",
 CellID->24828],
Cell[12749, 470, 228, 8, 36, "Output",
 CellID->105367307]
}, Open  ]],
Cell[12992, 481, 121, 3, 70, "ExampleDelimiter",
 CellID->24399],
Cell[13116, 486, 149, 6, 70, "ExampleText",
 CellID->8978],
Cell[CellGroupData[{
Cell[13290, 496, 155, 6, 70, "Input",
 CellID->11891],
Cell[13448, 504, 199, 7, 36, "Output",
 CellID->140201030]
}, Open  ]],
Cell[13662, 514, 61, 1, 70, "ExampleText",
 CellID->26943],
Cell[CellGroupData[{
Cell[13748, 519, 169, 6, 70, "Input",
 CellID->24834],
Cell[13920, 527, 251, 9, 36, "Output",
 CellID->257428557]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14220, 542, 220, 7, 70, "ExampleSection",
 CellID->87490922],
Cell[CellGroupData[{
Cell[14465, 553, 253, 7, 70, "ExampleSubsection",
 CellID->1197707878],
Cell[14721, 562, 70, 1, 70, "ExampleText",
 CellID->2702],
Cell[CellGroupData[{
Cell[14816, 567, 243, 9, 70, "Input",
 CellID->8707],
Cell[15062, 578, 457, 16, 39, "Output",
 CellID->230303521]
}, Open  ]],
Cell[15534, 597, 125, 3, 70, "ExampleDelimiter",
 CellID->569879184],
Cell[15662, 602, 67, 1, 70, "ExampleText",
 CellID->10687],
Cell[CellGroupData[{
Cell[15754, 607, 285, 10, 70, "Input",
 CellID->8346],
Cell[16042, 619, 213, 7, 36, "Output",
 CellID->603783890]
}, Open  ]],
Cell[16270, 629, 125, 3, 70, "ExampleDelimiter",
 CellID->754182531],
Cell[16398, 634, 78, 1, 70, "ExampleText",
 CellID->404324366],
Cell[CellGroupData[{
Cell[16501, 639, 350, 12, 70, "Input",
 CellID->1812804422],
Cell[16854, 653, 212, 7, 36, "Output",
 CellID->93294541]
}, Open  ]],
Cell[17081, 663, 125, 3, 70, "ExampleDelimiter",
 CellID->587984190],
Cell[17209, 668, 76, 1, 70, "ExampleText",
 CellID->18413],
Cell[CellGroupData[{
Cell[17310, 673, 191, 7, 70, "Input",
 CellID->11400],
Cell[17504, 682, 300, 9, 36, "Output",
 CellID->452028277]
}, Open  ]],
Cell[17819, 694, 125, 3, 70, "ExampleDelimiter",
 CellID->148143891],
Cell[17947, 699, 89, 1, 70, "ExampleText",
 CellID->14372],
Cell[CellGroupData[{
Cell[18061, 704, 499, 18, 70, "Input",
 CellID->18716],
Cell[18563, 724, 361, 13, 36, "Output",
 CellID->242082370]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18973, 743, 259, 7, 70, "ExampleSubsection",
 CellID->823687550],
Cell[19235, 752, 227, 8, 70, "ExampleText",
 CellID->264880107],
Cell[CellGroupData[{
Cell[19487, 764, 471, 17, 70, "Input",
 CellID->1016195388],
Cell[19961, 783, 219, 6, 36, "Output",
 CellID->727080066]
}, Open  ]],
Cell[20195, 792, 124, 3, 70, "ExampleDelimiter",
 CellID->41896137],
Cell[20322, 797, 75, 1, 70, "ExampleText",
 CellID->549999477],
Cell[CellGroupData[{
Cell[20422, 802, 548, 17, 70, "Input",
 CellID->1217298744],
Cell[20973, 821, 22577, 374, 70, "Output",
 Evaluatable->False,
 CellID->7382657]
}, Open  ]],
Cell[43565, 1198, 124, 3, 70, "ExampleDelimiter",
 CellID->62357987],
Cell[43692, 1203, 79, 1, 70, "ExampleText",
 CellID->1083420556],
Cell[CellGroupData[{
Cell[43796, 1208, 401, 14, 70, "Input",
 CellID->1618038406],
Cell[44200, 1224, 180, 6, 36, "Output",
 CellID->725570602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44429, 1236, 253, 7, 70, "ExampleSubsection",
 CellID->740014874],
Cell[44685, 1245, 74, 1, 70, "ExampleText",
 CellID->2005626528],
Cell[CellGroupData[{
Cell[44784, 1250, 172, 6, 70, "Input",
 CellID->1698434720],
Cell[44959, 1258, 239, 8, 36, "Output",
 CellID->64245191]
}, Open  ]],
Cell[45213, 1269, 125, 3, 70, "ExampleDelimiter",
 CellID->204205777],
Cell[45341, 1274, 187, 8, 70, "ExampleText",
 CellID->729918881],
Cell[CellGroupData[{
Cell[45553, 1286, 89, 3, 70, "Input",
 CellID->780585980],
Cell[45645, 1291, 231, 8, 36, "Output",
 CellID->293590932]
}, Open  ]],
Cell[45891, 1302, 125, 3, 70, "ExampleDelimiter",
 CellID->244095561],
Cell[46019, 1307, 123, 3, 70, "ExampleText",
 CellID->2142864125],
Cell[CellGroupData[{
Cell[46167, 1314, 385, 14, 70, "Input",
 CellID->1806399388],
Cell[46555, 1330, 394, 13, 36, "Output",
 CellID->464861408]
}, Open  ]],
Cell[46964, 1346, 124, 3, 70, "ExampleDelimiter",
 CellID->17256134],
Cell[47091, 1351, 91, 1, 70, "ExampleText",
 CellID->1489544862],
Cell[CellGroupData[{
Cell[47207, 1356, 472, 16, 70, "Input",
 CellTags->"Ex--22029503983018204282,3",
 CellID->18971727],
Cell[47682, 1374, 473, 16, 39, "Output",
 CellTags->"Ex--22029503983018204282,3",
 CellID->890322633]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[48216, 1397, 238, 7, 70, "ExampleSection",
 CellID->8935],
Cell[48457, 1406, 167, 5, 70, "ExampleText",
 CellID->29126],
Cell[CellGroupData[{
Cell[48649, 1415, 184, 6, 70, "Input",
 CellID->19410],
Cell[48836, 1423, 224, 7, 36, "Output",
 CellID->19877]
}, Open  ]],
Cell[CellGroupData[{
Cell[49097, 1435, 230, 7, 70, "Input",
 CellID->11382],
Cell[49330, 1444, 292, 9, 36, "Output",
 CellID->26260]
}, Open  ]],
Cell[49637, 1456, 121, 3, 70, "ExampleDelimiter",
 CellID->27189],
Cell[49761, 1461, 266, 10, 70, "ExampleText",
 CellID->26705],
Cell[CellGroupData[{
Cell[50052, 1475, 185, 6, 70, "Input",
 CellID->13874],
Cell[50240, 1483, 213, 7, 36, "Output",
 CellID->2663]
}, Open  ]],
Cell[CellGroupData[{
Cell[50490, 1495, 276, 9, 70, "Input",
 CellID->20722],
Cell[50769, 1506, 322, 9, 36, "Output",
 CellID->32195]
}, Open  ]],
Cell[51106, 1518, 121, 3, 70, "ExampleDelimiter",
 CellID->22566],
Cell[51230, 1523, 265, 9, 70, "ExampleText",
 CellID->16360],
Cell[CellGroupData[{
Cell[51520, 1536, 280, 9, 70, "Input",
 CellID->6038],
Cell[51803, 1547, 297, 10, 36, "Output",
 CellID->18588]
}, Open  ]],
Cell[CellGroupData[{
Cell[52137, 1562, 263, 9, 70, "Input",
 CellID->7811],
Cell[52403, 1573, 238, 8, 36, "Output",
 CellID->28245]
}, Open  ]],
Cell[52656, 1584, 120, 3, 70, "ExampleDelimiter",
 CellID->9467],
Cell[52779, 1589, 129, 4, 70, "ExampleText",
 CellID->32425],
Cell[CellGroupData[{
Cell[52933, 1597, 141, 5, 70, "Input",
 CellID->26867],
Cell[53077, 1604, 229, 8, 36, "Output",
 CellID->13189]
}, Open  ]],
Cell[53321, 1615, 142, 5, 70, "ExampleText",
 CellID->10542],
Cell[CellGroupData[{
Cell[53488, 1624, 294, 10, 70, "Input",
 CellID->13063],
Cell[53785, 1636, 354, 12, 36, "Output",
 CellID->21547]
}, Open  ]],
Cell[CellGroupData[{
Cell[54176, 1653, 94, 3, 70, "Input",
 CellID->30502],
Cell[54273, 1658, 160, 5, 36, "Output",
 CellID->29617]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54482, 1669, 223, 7, 70, "ExampleSection",
 CellID->25023],
Cell[54708, 1678, 138, 4, 70, "ExampleText",
 CellID->358798615],
Cell[CellGroupData[{
Cell[54871, 1686, 143, 5, 70, "Input",
 CellID->1437853734],
Cell[55017, 1693, 201, 7, 36, "Output",
 CellID->1845710]
}, Open  ]],
Cell[CellGroupData[{
Cell[55255, 1705, 159, 5, 70, "Input",
 CellID->2116411461],
Cell[55417, 1712, 190, 6, 36, "Output",
 CellID->530819859]
}, Open  ]],
Cell[55622, 1721, 126, 3, 70, "ExampleDelimiter",
 CellID->1963269286],
Cell[55751, 1726, 169, 5, 70, "ExampleText",
 CellID->591629748],
Cell[55923, 1733, 211, 7, 70, "Input",
 CellID->1220220993],
Cell[CellGroupData[{
Cell[56159, 1744, 126, 4, 70, "Input",
 CellID->1352822970],
Cell[56288, 1750, 241, 8, 36, "Output",
 CellID->22599852]
}, Open  ]],
Cell[CellGroupData[{
Cell[56566, 1763, 98, 3, 70, "Input",
 CellID->101922602],
Cell[56667, 1768, 158, 5, 36, "Output",
 CellID->13293027]
}, Open  ]],
Cell[56840, 1776, 124, 3, 70, "ExampleDelimiter",
 CellID->59883127],
Cell[56967, 1781, 83, 1, 70, "ExampleText",
 CellID->1041535829],
Cell[CellGroupData[{
Cell[57075, 1786, 371, 11, 70, "Input",
 CellID->972657636],
Cell[57449, 1799, 206, 6, 36, "Output",
 CellID->1508424288]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57704, 1811, 238, 7, 70, "ExampleSection",
 CellID->321726587],
Cell[57945, 1820, 154, 4, 70, "ExampleText",
 CellID->25967],
Cell[CellGroupData[{
Cell[58124, 1828, 173, 6, 70, "Input",
 CellID->8456],
Cell[58300, 1836, 185, 6, 36, "Output",
 CellID->169348999]
}, Open  ]],
Cell[58500, 1845, 125, 3, 70, "ExampleDelimiter",
 CellID->250791120],
Cell[58628, 1850, 104, 2, 70, "ExampleText",
 CellID->74539718],
Cell[CellGroupData[{
Cell[58757, 1856, 170, 6, 70, "Input",
 CellID->1484693174],
Cell[58930, 1864, 215, 7, 36, "Output",
 CellID->25877109]
}, Open  ]],
Cell[59160, 1874, 125, 3, 70, "ExampleDelimiter",
 CellID->105391536],
Cell[59288, 1879, 86, 1, 70, "ExampleText",
 CellID->29962],
Cell[CellGroupData[{
Cell[59399, 1884, 185, 7, 70, "Input",
 CellID->26819],
Cell[59587, 1893, 198, 7, 36, "Output",
 CellID->24992630]
}, Open  ]],
Cell[CellGroupData[{
Cell[59822, 1905, 93, 3, 70, "Input",
 CellID->10556],
Cell[59918, 1910, 180, 6, 36, "Output",
 CellID->282727859]
}, Open  ]],
Cell[60113, 1919, 125, 3, 70, "ExampleDelimiter",
 CellID->236391989],
Cell[60241, 1924, 121, 3, 70, "ExampleText",
 CellID->8044],
Cell[CellGroupData[{
Cell[60387, 1931, 330, 12, 70, "Input",
 CellID->30591],
Cell[60720, 1945, 296, 10, 36, "Output",
 CellID->893439898]
}, Open  ]],
Cell[CellGroupData[{
Cell[61053, 1960, 329, 12, 70, "Input",
 CellID->3388],
Cell[61385, 1974, 296, 10, 36, "Output",
 CellID->576888167]
}, Open  ]],
Cell[CellGroupData[{
Cell[61718, 1989, 439, 15, 70, "Input",
 CellID->7450],
Cell[62160, 2006, 399, 14, 36, "Output",
 CellID->7660901]
}, Open  ]],
Cell[62574, 2023, 125, 3, 70, "ExampleDelimiter",
 CellID->855937645],
Cell[62702, 2028, 85, 1, 70, "ExampleText",
 CellID->565842741],
Cell[CellGroupData[{
Cell[62812, 2033, 283, 10, 70, "Input",
 CellID->2108754328],
Cell[63098, 2045, 180, 6, 36, "Output",
 CellID->70840769]
}, Open  ]],
Cell[CellGroupData[{
Cell[63315, 2056, 283, 10, 70, "Input",
 CellID->2030512569],
Cell[63601, 2068, 180, 6, 36, "Output",
 CellID->51096391]
}, Open  ]],
Cell[63796, 2077, 123, 3, 70, "ExampleDelimiter",
 CellID->8538401],
Cell[63922, 2082, 90, 1, 70, "ExampleText",
 CellID->573653727],
Cell[CellGroupData[{
Cell[64037, 2087, 283, 10, 70, "Input",
 CellID->1967603499],
Cell[64323, 2099, 180, 6, 36, "Output",
 CellID->53356803]
}, Open  ]],
Cell[64518, 2108, 124, 3, 70, "ExampleDelimiter",
 CellID->18121309],
Cell[64645, 2113, 95, 1, 70, "ExampleText",
 CellID->279833269],
Cell[CellGroupData[{
Cell[64765, 2118, 282, 10, 70, "Input",
 CellID->879674601],
Cell[65050, 2130, 181, 6, 36, "Output",
 CellID->584457232]
}, Open  ]],
Cell[CellGroupData[{
Cell[65268, 2141, 256, 9, 70, "Input",
 CellID->1033794124],
Cell[65527, 2152, 181, 6, 36, "Output",
 CellID->260697393]
}, Open  ]],
Cell[65723, 2161, 125, 3, 70, "ExampleDelimiter",
 CellID->815690094],
Cell[65851, 2166, 274, 10, 70, "ExampleText",
 CellID->1150254824],
Cell[CellGroupData[{
Cell[66150, 2180, 145, 5, 70, "Input",
 CellID->2093373106],
Cell[66298, 2187, 185, 6, 36, "Output",
 CellID->446677040]
}, Open  ]],
Cell[66498, 2196, 260, 11, 70, "ExampleText",
 CellID->412152674],
Cell[CellGroupData[{
Cell[66783, 2211, 177, 6, 70, "Input",
 CellID->42305261],
Cell[66963, 2219, 218, 7, 36, "Output",
 CellID->160749192]
}, Open  ]],
Cell[67196, 2229, 124, 3, 70, "ExampleDelimiter",
 CellID->45879510],
Cell[67323, 2234, 185, 6, 70, "ExampleText",
 CellID->630696395],
Cell[67511, 2242, 192, 7, 70, "Input",
 CellID->1514951200],
Cell[CellGroupData[{
Cell[67728, 2253, 169, 5, 70, "Input",
 CellID->852300799],
Cell[67900, 2260, 291, 10, 39, "Output",
 CellID->62995052]
}, Open  ]],
Cell[68206, 2273, 125, 3, 70, "ExampleDelimiter",
 CellID->132284389],
Cell[68334, 2278, 195, 8, 70, "ExampleText",
 CellID->2132488719],
Cell[CellGroupData[{
Cell[68554, 2290, 199, 7, 70, "Input",
 CellID->1643712487],
Cell[68756, 2299, 299, 9, 36, "Output",
 CellID->396856391]
}, Open  ]],
Cell[69070, 2311, 241, 8, 70, "ExampleText",
 CellID->515853344],
Cell[CellGroupData[{
Cell[69336, 2323, 170, 6, 70, "Input",
 CellID->1021468397],
Cell[69509, 2331, 299, 9, 36, "Output",
 CellID->363019614]
}, Open  ]],
Cell[69823, 2343, 125, 3, 70, "ExampleDelimiter",
 CellID->291081164],
Cell[69951, 2348, 266, 8, 70, "ExampleText",
 CellID->250811022],
Cell[CellGroupData[{
Cell[70242, 2360, 215, 7, 70, "Input",
 CellID->902546438],
Cell[70460, 2369, 356, 13, 36, "Output",
 CellID->227155987]
}, Open  ]],
Cell[CellGroupData[{
Cell[70853, 2387, 97, 3, 70, "Input",
 CellID->205583927],
Cell[70953, 2392, 157, 5, 36, "Output",
 CellID->31691875]
}, Open  ]],
Cell[71125, 2400, 195, 7, 70, "ExampleText",
 CellID->1919816596],
Cell[CellGroupData[{
Cell[71345, 2411, 200, 7, 70, "Input",
 CellID->670485441],
Cell[71548, 2420, 346, 12, 39, "Output",
 CellID->151139964]
}, Open  ]],
Cell[CellGroupData[{
Cell[71931, 2437, 100, 3, 70, "Input",
 CellID->1738384124],
Cell[72034, 2442, 160, 5, 36, "Output",
 CellID->15443583]
}, Open  ]],
Cell[72209, 2450, 193, 7, 70, "ExampleText",
 CellID->1657681850],
Cell[CellGroupData[{
Cell[72427, 2461, 210, 7, 70, "Input",
 CellID->1777283476],
Cell[72640, 2470, 446, 16, 36, "Output",
 CellID->49928352]
}, Open  ]],
Cell[CellGroupData[{
Cell[73123, 2491, 100, 3, 70, "Input",
 CellID->1922775913],
Cell[73226, 2496, 180, 6, 36, "Output",
 CellID->733825524]
}, Open  ]],
Cell[73421, 2505, 200, 7, 70, "ExampleText",
 CellID->191457026],
Cell[CellGroupData[{
Cell[73646, 2516, 285, 10, 70, "Input",
 CellID->254194147],
Cell[73934, 2528, 327, 12, 36, "Output",
 CellID->179531365]
}, Open  ]],
Cell[CellGroupData[{
Cell[74298, 2545, 144, 5, 70, "Input",
 CellID->244218684],
Cell[74445, 2552, 242, 9, 51, "Output",
 CellID->7073654]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74736, 2567, 225, 7, 70, "ExampleSection",
 CellID->6272],
Cell[74964, 2576, 204, 6, 70, "ExampleText",
 CellID->25791],
Cell[CellGroupData[{
Cell[75193, 2586, 143, 5, 70, "Input",
 CellID->29383],
Cell[75339, 2593, 385, 14, 50, "Output",
 CellID->727661472]
}, Open  ]],
Cell[CellGroupData[{
Cell[75761, 2612, 167, 6, 70, "Input",
 CellID->1775],
Cell[75931, 2620, 385, 14, 50, "Output",
 CellID->395663379]
}, Open  ]],
Cell[76331, 2637, 125, 3, 70, "ExampleDelimiter",
 CellID->508037783],
Cell[76459, 2642, 216, 6, 70, "ExampleText",
 CellID->1154813464],
Cell[CellGroupData[{
Cell[76700, 2652, 327, 11, 70, "Input",
 CellID->1525681141],
Cell[77030, 2665, 180, 6, 36, "Output",
 CellID->426479339]
}, Open  ]],
Cell[77225, 2674, 121, 3, 70, "ExampleDelimiter",
 CellID->23569],
Cell[77349, 2679, 231, 7, 70, "ExampleText",
 CellID->18300],
Cell[CellGroupData[{
Cell[77605, 2690, 140, 5, 70, "Input",
 CellID->17954],
Cell[77748, 2697, 209, 7, 36, "Output",
 CellID->2647561]
}, Open  ]],
Cell[CellGroupData[{
Cell[77994, 2709, 92, 3, 70, "Input",
 CellID->3585],
Cell[78089, 2714, 180, 6, 36, "Output",
 CellID->404895496]
}, Open  ]],
Cell[78284, 2723, 126, 3, 70, "ExampleDelimiter",
 CellID->1559107221],
Cell[78413, 2728, 125, 3, 70, "ExampleText",
 CellID->1793033747],
Cell[CellGroupData[{
Cell[78563, 2735, 116, 4, 70, "Input",
 CellID->471751041],
Cell[78682, 2741, 431, 8, 70, "Message",
 CellID->662362350],
Cell[79116, 2751, 159, 5, 36, "Output",
 CellID->521704236]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79324, 2762, 222, 7, 70, "ExampleSection",
 CellID->893],
Cell[79549, 2771, 257, 8, 70, "ExampleText",
 CellID->407099134],
Cell[CellGroupData[{
Cell[79831, 2783, 496, 17, 70, "Input",
 CellID->1992136962],
Cell[80330, 2802, 495, 17, 36, "Output",
 CellID->582390418]
}, Open  ]],
Cell[80840, 2822, 83, 1, 70, "ExampleText",
 CellID->429115848],
Cell[CellGroupData[{
Cell[80948, 2827, 271, 11, 70, "Input",
 CellID->115000401],
Cell[81222, 2840, 165, 5, 36, "Output",
 CellID->1701929895]
}, Open  ]],
Cell[81402, 2848, 125, 3, 70, "ExampleDelimiter",
 CellID->193896730],
Cell[81530, 2853, 94, 1, 70, "ExampleText",
 CellID->2120143300],
Cell[81627, 2856, 386, 14, 70, "Input",
 CellID->971100393],
Cell[CellGroupData[{
Cell[82038, 2874, 212, 7, 70, "Input",
 CellID->351788941],
Cell[82253, 2883, 174, 5, 36, "Output",
 CellID->10356772]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82488, 2895, 311, 9, 70, "SeeAlsoSection",
 CellID->24176],
Cell[82802, 2906, 461, 17, 70, "SeeAlso",
 CellID->18479]
}, Open  ]],
Cell[CellGroupData[{
Cell[83300, 2928, 314, 9, 70, "TutorialsSection",
 CellID->17063],
Cell[83617, 2939, 138, 3, 70, "Tutorials",
 CellID->10681],
Cell[83758, 2944, 186, 4, 70, "Tutorials",
 CellID->135909037],
Cell[83947, 2950, 190, 4, 70, "Tutorials",
 CellID->314307143]
}, Open  ]],
Cell[CellGroupData[{
Cell[84174, 2959, 317, 9, 70, "MoreAboutSection",
 CellID->5257688],
Cell[84494, 2970, 140, 3, 70, "MoreAbout",
 CellID->21110944],
Cell[84637, 2975, 154, 3, 70, "MoreAbout",
 CellID->15642971]
}, Open  ]],
Cell[84806, 2981, 27, 0, 70, "History"],
Cell[84836, 2983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

