(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    330453,       7096]
NotebookOptionsPosition[    315842,       6619]
NotebookOutlinePosition[    317276,       6659]
CellTagsIndexPosition[    317189,       6654]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Factorial" :> Documentation`HelpLookup["paclet:ref/Factorial"],
           "LogGamma" :> Documentation`HelpLookup["paclet:ref/LogGamma"], 
          "GammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/GammaRegularized"], 
          "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "PolyGamma" :> Documentation`HelpLookup["paclet:ref/PolyGamma"], 
          "RiemannSiegelTheta" :> 
          Documentation`HelpLookup["paclet:ref/RiemannSiegelTheta"], 
          "GammaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GammaDistribution"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Factorial\"\>", 
       2->"\<\"LogGamma\"\>", 3->"\<\"GammaRegularized\"\>", 
       4->"\<\"InverseGammaRegularized\"\>", 5->"\<\"PolyGamma\"\>", 
       6->"\<\"RiemannSiegelTheta\"\>", 
       7->"\<\"GammaDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gamma", "ObjectName",
 CellID->4042],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Gamma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Gamma"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the Euler gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Gamma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Gamma"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the plica function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Gamma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Gamma"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the generalized ",
     "plica",
     " function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"a", ",", 
          SubscriptBox["z", "0"]}], ")"}], "-", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"a", ",", 
          SubscriptBox["z", "1"]}], ")"}]}], TraditionalForm]], "InlineMath"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The gamma function satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"z", "-", "1"}]], 
      SuperscriptBox["e", 
       RowBox[{"-", "t"}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1847],

Cell[TextData[{
 "The ",
 "plica",
 " function satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", 
     RowBox[{"a", ",", "z"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "z", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"a", "-", "1"}]], 
      SuperscriptBox["e", 
       RowBox[{"-", "t"}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7469],

Cell[TextData[{
 "The generalized ",
 "plica",
 " function is given by the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     SubscriptBox["z", "0"], 
     SubscriptBox["z", "1"]], 
    RowBox[{
     SuperscriptBox["t", 
      RowBox[{"a", "-", "1"}]], 
     SuperscriptBox["e", 
      RowBox[{"-", "t"}]], "d", "\[InvisibleSpace]", "t"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->16345],

Cell[TextData[{
 "Note that the arguments in the incomplete form of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " are arranged differently from those in the incomplete form of ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4380],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has no branch cut discontinuities. "
}], "Notes",
 CellID->31913],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->14964],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->392129891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350641],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->102875715],

Cell["Integer values:", "ExampleText",
 CellID->144841031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720", ",", 
   "5040", ",", "40320", ",", "362880"}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710600429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->381226267],

Cell["Half-integer values:", "ExampleText",
 CellID->30359850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["\[Pi]"], "2"], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}], "4"], ",", 
   FractionBox[
    RowBox[{"15", " ", 
     SqrtBox["\[Pi]"]}], "8"], ",", 
   FractionBox[
    RowBox[{"105", " ", 
     SqrtBox["\[Pi]"]}], "16"], ",", 
   FractionBox[
    RowBox[{"945", " ", 
     SqrtBox["\[Pi]"]}], "32"]}], "}"}]], "Output",
 ImageSize->{283, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11502764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate numerically for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"2.3", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"0.7191409365372843`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.5406144679098515`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35400067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44155935]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate for large arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", "100000", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"2824229407960347874293421578024535518477", 
   RowBox[{"\[LeftSkeleton]", "456488", "\[RightSkeleton]"}], 
   "00000000000000000000000000000000000000000"}],
  Short]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->309968212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"10.", "^", "6"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["8.263931683182147309`8.65973724534849*^5565702"], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181617424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"22", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.\
1018024908797127327691419862229964808241863995904167242695162651166`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166434738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", "2.20000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.1018024908797127327691419862229964808241863995906944097972`41.\
25731676194003"], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113621666]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Gamma", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "3"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"EulerGamma", " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "+", 
      SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["EulerGamma", "3"]}], "-", 
      FractionBox[
       RowBox[{"EulerGamma", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "2"], "+", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "4"],
    SeriesData[$CellContext`z, 1, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {
   1, -EulerGamma, Rational[1, 12] (6 EulerGamma^2 + Pi^2), 
    Rational[1, 6] (-EulerGamma^3 + Rational[-1, 2] EulerGamma Pi^2 + 
     PolyGamma[2, 1])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{456, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120930197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23103932],

Cell["plica function:", "ExampleText",
 CellID->86523737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1.5", ",", "7.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370601037],

Cell[BoxData["0.0016099632282723204`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202798518]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Euler Gamma Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2286912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82825595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "24", ",", "720", ",", "3628800"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121289668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}], "//", "Simplify"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{"EulerGamma", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", "EulerGamma"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "+", 
      SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["EulerGamma", "3"]}], "+", 
      SuperscriptBox["\[Pi]", "2"], "-", 
      RowBox[{"EulerGamma", " ", 
       SuperscriptBox["\[Pi]", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, -EulerGamma, Rational[1, 12] ((-6) EulerGamma + 6 EulerGamma^2 + Pi^2), 
    Rational[1, 12] (6 EulerGamma^2 - 2 EulerGamma^3 + Pi^2 - EulerGamma Pi^2 + 
     2 PolyGamma[2, 1])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{542, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319365553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at poles:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "z", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"120", " ", 
      RowBox[{"(", 
       RowBox[{"z", "+", "5"}], ")"}]}]]}], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["137", "7200"]}], "+", 
     FractionBox["EulerGamma", "120"]}], ")"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "12019"}], "+", 
       RowBox[{"8220", " ", "EulerGamma"}], "-", 
       RowBox[{"1800", " ", 
        SuperscriptBox["EulerGamma", "2"]}], "-", 
       RowBox[{"300", " ", 
        SuperscriptBox["\[Pi]", "2"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"z", "+", "5"}], ")"}]}], "432000"], "+", 
   RowBox[{
    FractionBox["1", "25920000"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "874853"}], "+", 
       RowBox[{"721140", " ", "EulerGamma"}], "-", 
       RowBox[{"246600", " ", 
        SuperscriptBox["EulerGamma", "2"]}], "+", 
       RowBox[{"36000", " ", 
        SuperscriptBox["EulerGamma", "3"]}], "-", 
       RowBox[{"41100", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "+", 
       RowBox[{"18000", " ", "EulerGamma", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "-", 
       RowBox[{"36000", " ", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "5"}], ")"}], "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "+", "5"}], "]"}], "3"],
    SeriesData[$CellContext`z, -5, {}, -1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, -5, {
    Rational[-1, 120], Rational[-137, 7200] + Rational[1, 120] EulerGamma, 
    Rational[1, 432000] (-12019 + 8220 EulerGamma - 1800 EulerGamma^2 - 300 
     Pi^2), 
    Rational[1, 25920000] (-874853 + 721140 EulerGamma - 246600 EulerGamma^2 + 
     36000 EulerGamma^3 - 41100 Pi^2 + 18000 EulerGamma Pi^2 - 36000 
     PolyGamma[2, 1])}, -1, 3, 1],
  Editable->False]], "Output",
 ImageSize->{541, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165759701]
}, Open  ]],

Cell["Expansion at symbolically specified negative integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "n"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"n", ",", "Integers"}], "]"}], "&&", 
     RowBox[{"n", "\[GreaterEqual]", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWUtv00AQdmI7IX0GSqHloUQ8RAH1WFEhUaEKtb3wD9pDVCG1Bx5q+0so
/ACOCC5w5NIz5XeAxKknxHHxrndj5/Osd+wkJa2lxJ7d2ZnZee3u7PPOwc6L
l52D3e1Oe32v82Znd3u/vfZ6L2ryK55X+el53tqcF32L6Ev95PMr+sWf+HUc
/fsRWqjfXqCa9aMA31AR6lVTCN/lf9jt0YNCslW+pwqPCgfCO59KEHVIqBq9
q4Dp5/NP9RgK8ZD4qVlHH0NP04r5Q9tk2oohv75p7i39bvT0pMe1AK53MT8S
M/IJ7UkdSRXXoT0QlPegBu38aNuh91VJLJSFRyuWRenKPzo60hJL1PdK9Gaz
eXJyIrQfhFb/Qro451qh0f1qiKRXUjd92ilIYM+7QNChYg7hRJIvbM4SaUpk
IxJ9Oaa9DK3ybwnaVli8W4Qsvpmj94jgg20rIom6dEST+mVRfAVwRY2cglaE
ZwF+LOJMuaDlGYf+27p9iYmHlhgD+BrAz8hZTEIr5tEZgJ8AfI+QQkp3F9rR
G7jj0GoYAzcAXk3BXtdvJgBLZqyQ8IlLgvJRl6ZNnk/ne1+HDcXF1/2yfUbL
GHrZTO8Lev0w2bDc+jE7JGmrlvH9SevKxYYr7hR41FcBjmMCvQUjkPQa5wqL
kUavAjgPn8SiVqyqmV8Gm5Yn3Qrxkttql8KO1d1R9b2qXj53WrNJNRh9ceLH
rU8erzVBRY8tL7iiSFmlZ/8zrimhZsjdY6E9Zjc3jFjs4JklFEX2wWPnWF8I
96cpV5TgulGMOh0XRVeVdL/kgusJZWWzrjOt2xNtmZO8bgsK2tPXY8p5fLms
N3fGdOHy5uHkfmqnNqisP2jvlrLLVbFO26ZkfkW7Bnas/5DtKatzzvtXzpWu
ysQGR0usnVGP9spyKhchtooqVU2sdxVnHjy3B5nZ9Jwukx7dGicD8yTzN5kv
fbZKjfK7LdbTK8/3ObUnI8foztXlu5xZck/AkwxasSdibsV6BlWHCLrkUmrN
yIKUpklb1zL2wVhokOPaxMzdnoR7AYyn4cro8gBqp5KGXfWudcUXa49yFFXz
bGRmhfQpC/paH4HWgqQ8oeF2ipOvtS/heUFXKYvQk++mg56r6rmhpvlAU8c9
Mo4+dMB7ihrWh9NUpQ8cAvyOpII1c5QNeb8FeF9RkZ/2e8nkax5GXwdY/n1W
mOiRNwnMTwoTc2P8cPNVuXrgJoun/HuqEOgdP0bhIO/Etkgs+d7IkYi8V8nJ
ycVuxGiZqFvdPK25ZBzMvVkZWTk3z+79Xdn7tS2mBInMVeG+67bFDWfPsMmg
n0iD+wHUA2aAHTYlzGmYdXatlOQX5jC8wfoK8O8CWLGtkjvrZaWtCAZt1wDv
A+CZW5MivHlYlAbwdg7z2KKjX9665d0t3tLtfxU3HH0R4IeO/gWCO66+ktsd
aP+juOOexlQzMV/cZ+JJ3Zk9uu+d/u2cwc9f3+i549nRpQMXPlrqLN2X9HfL
RFctkAdtBeMJrhMaWoM7rpxVRqsuX+weox9rDCMmTF4YxRpxuZrhqGn47Ncj
y9uBs5csZwlbrRCrBWXpjE5Fjad9Ti0s1jSOxB0RvxbWGhil062PXSX1gjvN
huBWlFAK/shQFKsxzYn0bnVRY6/otySKNRKv8g/7diIg\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{485, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99277946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59098094],

Cell["Series expansion at infinity (Stirling approximation):", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "z"], "]"}]}], 
      FractionBox["1", "z"]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "3"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, -1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {-1 - Log[$CellContext`z^(-1)]}, -1, 3, 1],
    Editable->False]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], " ", 
      SqrtBox[
       FractionBox["1", "z"]]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], 
       RowBox[{"3", "/", "2"}]]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 1, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[
     1], {(2 Pi)^Rational[1, 2], 0, 
      Rational[1, 6] (Rational[1, 2] Pi)^Rational[1, 2]}, 1, 5, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{345, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91236409]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "z", "]"}], ",", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{572, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1958904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760443585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->125224332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "plica Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate symbolically at integer and half\[Hyphen]integer orders:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"3", ",", " ", "z"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "z"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "z"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     SuperscriptBox["z", "3"]}], ")"}]}], "z"]], "Output",
 ImageSize->{120, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557802575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{
    RowBox[{"7", "/", "2"}], ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"15", " ", "z"}], "4"], "+", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["z", "2"]}], "2"], "+", 
      SuperscriptBox["z", "3"]}], ")"}]}], 
   SqrtBox["z"]], "+", 
  RowBox[{
   FractionBox["15", "8"], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Erf", "[", 
      SqrtBox["z"], "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{278, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->526432160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at generic point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "z0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWctu00AUncR2kzpNUpo2CW0TIkQrgdgifoCWFQLEjhWhQmqRUKvSHWLb
38qPUGAP/2A8L2d8fJ25SbzAUp257zN37rzcV9Ob809fpjcXZ9PJy+vp1fnF
2dfJ6eV1ygpqQtT+CCHGQ5G2k7Sl/uTzN/3TTd36kb4jI2xlHGFZ6hE5+Z18
B5lc/WwpyU9Com1+EZJYSX4Tkk02Dmuo4x+n73rKaYHPvuG/A/5DoD8C/Qxo
9Iv2D0ycI/MbZ6hcrdhIh8B/A/QjoD8A/RzoTY/9GOgjoJsKbd1kNUx/e0LT
chAC0A5K+BsOX7IjkHeMfA/0DkHPxu16/DWA7hn9XbAbefxvgDxaMi4X7xaR
L0rP+ut4/OlR08OgmMpShHMNI2y6HPet9CNg5riZmaoKRElryQpvkFKe57ZD
CztbmL4OWCi7a6DD0d8BtIMlfGPlY6wOaYUIogp7U32+sOpptLzqovPBw/E/
zpYOaAUsX+765FbefZY3nCFlqziuisth09az2UzoR6ZZ0W4+cI57o/nmi40e
ktZ5bMv2DGdKtXmLjTVvdpTFxh2CF9vMjDCxZZ3o/UaOUciq+zk3MDYU4tCu
JKxdZNGOIJsDliesdvR8byU8vj1ANvssz76K7pq8YUTeuu3DXU02Vlvhkd5e
KXZxVffvhr4aXmdFV5Va3FOWrvA6yHtMv+T5J2e3vSJCX80j4h1mnArPQBX0
qrp8rXHuyUXrrhi/ODPsfcPe84orvqtdduuwfHs74c0WqS070V9o1QYrvHXj
TYsXe2Ri7y20wtg4ftTKHJj64GPx3R15XnZZWniPXOuc7Gjg14QDlt/9xDlN
YJ4L1vZEA/MhoXfDQ9IHnpKelCBokdYyRmC9FBA0wQfGesxChN9teP2wM5C+
lWHeaZ9UrdSzJcGe/CaGO0rmX4YkPXAz2RD5/dNE6Dj5o7IeOSuQfqhsZCPg
8I8Z0dsQHeu5GD0ujLPs6dMSDLgylWGlTjl2VZX+x5BZvD3UFMTPDldALiW9
T4zmoup87/GHN0mfv29An1D2qhehk3f99mG3lfnCjFqP9OJDbL18B/4pme9L
T35fAz0EfaRvgT4BWhfnFeFVYn4LfOwr3p1vgaZHo/yLfbWSO9MLyVF7rGrp
/0CI2j8/+uhx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{491, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433440755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518990918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67544855],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], " ", 
  SuperscriptBox["z", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", "z"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "3"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {1, -1 + $CellContext`a}, 1, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{210, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->910344272]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "a"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "z"}]], "a"]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "z"}]], " ", "z", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "a"], ")"}], "2"]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "a"], "]"}], "3"],
       SeriesData[$CellContext`a, 
        DirectedInfinity[1], {}, 1, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`a, 
      DirectedInfinity[
      1], {-E^(-$CellContext`z), -E^(-$CellContext`z) $CellContext`z}, 1, 3, 
      1],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"Log", "[", 
         FractionBox["1", "a"], "]"}]}], 
       FractionBox["1", "a"]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "a"], "]"}], "3"],
       SeriesData[$CellContext`a, 
        DirectedInfinity[1], {}, -1, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`a, 
      DirectedInfinity[1], {-1 - Log[$CellContext`a^(-1)]}, -1, 3, 1],
     Editable->False]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", 
       SqrtBox[
        FractionBox["1", "a"]]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "a"], ")"}], 
        RowBox[{"3", "/", "2"}]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "a"], "]"}], 
        RowBox[{"5", "/", "2"}]],
       SeriesData[$CellContext`a, 
        DirectedInfinity[1], {}, 1, 5, 2],
       Editable->False]}],
     SeriesData[$CellContext`a, 
      DirectedInfinity[
      1], {(2 Pi)^Rational[1, 2], 0, 
       Rational[1, 6] (Rational[1, 2] Pi)^Rational[1, 2]}, 1, 5, 2],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{540, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81752063]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalized plica Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate symbolically at integer and half\[Hyphen]integer orders:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"13", "/", "2"}], ",", 
     RowBox[{"7", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], "//", "FunctionExpand"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"48594", " ", 
      SqrtBox["14"]}], "-", 
     RowBox[{"4888", " ", 
      SqrtBox["2"], " ", 
      SuperscriptBox["\[ExponentialE]", "3"]}], "+", 
     RowBox[{"3465", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"7", "/", "2"}]], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Erf", "[", 
         FractionBox["1", 
          SqrtBox["2"]], "]"}], "-", 
        RowBox[{"Erf", "[", 
         SqrtBox[
          FractionBox["7", "2"]], "]"}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"64", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"7", "/", "2"}]]}]]], "Output",
 ImageSize->{435, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44580432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at generic point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z1", ",", "z2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z2", ",", "z20", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z1", ",", "z20"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z20"}]], " ", 
    SuperscriptBox["z20", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "a"}]], " ", 
    RowBox[{"(", 
     RowBox[{"z2", "-", "z20"}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "z20"}]], " ", 
      SuperscriptBox["z20", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "a"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "a", "+", "z20"}], ")"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z2", "-", "z20"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z2", "-", "z20"}], "]"}], "3"],
    SeriesData[$CellContext`z2, $CellContext`z20, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z2, $CellContext`z20, {
    Gamma[$CellContext`a, $CellContext`z1, $CellContext`z20], 
    E^(-$CellContext`z20) $CellContext`z20^(-1 + $CellContext`a), 
    Rational[-1, 2] 
    E^(-$CellContext`z20) $CellContext`z20^(-2 + $CellContext`a) (
     1 - $CellContext`a + $CellContext`z20)}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{346, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42313038]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " in the complex plane: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Gamma", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212876524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find the asymptotic expansion of ratios of gamma functions:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"n", "+", "\[Alpha]"}], "]"}], "/", 
     RowBox[{"Gamma", "[", 
      RowBox[{"n", "+", "\[Beta]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "Infinity", ",", "2"}], "}"}]}], "]"}], " "}]], "Input",\

 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{553, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378741539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Volume of an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional unit hypersphere:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", 
   RowBox[{"(", 
    RowBox[{"n", "/", "2"}], ")"}]}], "/", 
  RowBox[{"Gamma", "[", 
   RowBox[{
    RowBox[{"n", "/", "2"}], "+", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", 
   RowBox[{"n", "/", "2"}]], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["n", "2"]}], "]"}]]], "Output",
 ImageSize->{87, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->626206532]
}, Open  ]],

Cell["Low\[Hyphen]dimensional cases:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"%", " ", 
    RowBox[{"r", "^", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "r"}], ",", 
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["r", "2"]}], ",", 
   FractionBox[
    RowBox[{"4", " ", "\[Pi]", " ", 
     SuperscriptBox["r", "3"]}], "3"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r", "4"]}], "2"], ",", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r", "5"]}], "15"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "3"], " ", 
     SuperscriptBox["r", "6"]}], "6"], ",", 
   FractionBox[
    RowBox[{"16", " ", 
     SuperscriptBox["\[Pi]", "3"], " ", 
     SuperscriptBox["r", "7"]}], "105"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "4"], " ", 
     SuperscriptBox["r", "8"]}], "24"], ",", 
   FractionBox[
    RowBox[{"32", " ", 
     SuperscriptBox["\[Pi]", "4"], " ", 
     SuperscriptBox["r", "9"]}], "945"], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "5"], " ", 
     SuperscriptBox["r", "10"]}], "120"]}], "}"}]], "Output",
 ImageSize->{478, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356557143]
}, Open  ]],

Cell["\<\
Plot the volume of the unit hypersphere as a function of dimension:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"%%", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "25"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 3.141592653589793}, {4., 
     4.1887902047863905`}, {5., 4.934802200544679}, {6., 5.263789013914324}, {
     7., 5.167712780049969}, {8., 4.724765970331401}, {9., 
     4.058712126416767}, {10., 3.2985089027387064`}, {11., 
     2.550164039877345}, {12., 1.8841038793898999`}, {13., 
     1.3352627688545893`}, {14., 0.910628754783283}, {15., 
     0.5992645293207919}, {16., 0.38144328082330436`}, {17., 
     0.23533063035889312`}, {18., 0.140981106917139}, {19., 
     0.0821458866111282}, {20., 0.04662160103008853}, {21., 
     0.025806891390014047`}, {22., 0.013949150409020996`}, {23., 
     0.007370430945714348}, {24., 0.003810656386852123}, {25., 
     0.001929574309403922}, {26., 0.0009577224088231723}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 26.}, {0., 5.263789013914324}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->868156338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Plot of the real part of the plica function over the parameter plane:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Gamma", "[", 
     RowBox[{"a", ",", " ", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180048571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "CDF of the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 "\[Hyphen]distribution:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDF", "[", 
   RowBox[{"ChiSquareDistribution", "[", "r", "]"}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14089156],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{
   FractionBox["r", "2"], ",", "0", ",", 
   FractionBox["x", "2"]}], "]"}]], "Output",
 ImageSize->{182, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605498051]
}, Open  ]],

Cell["Calculate the PDF:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "x"}], "]"}], ",", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{"ChiSquareDistribution", "[", "r", "]"}], "]"}], "[", "x", 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "r"}], "/", "2"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "2"}]], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["r", "2"]}]]}], 
    RowBox[{"Gamma", "[", 
     FractionBox["r", "2"], "]"}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "r"}], "/", "2"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "2"}]], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["r", "2"]}]]}], 
    RowBox[{"Gamma", "[", 
     FractionBox["r", "2"], "]"}]]}], "}"}]], "Output",
 ImageSize->{221, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235797776]
}, Open  ]],

Cell["Plot the CDF for different numbers of degrees of freedom:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"CDF", "[", 
        RowBox[{"ChiSquareDistribution", "[", "r", "]"}], "]"}], "[", "x", 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->984882913]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify gamma functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "z", "]"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->581829668],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"\[Pi]", " ", "z"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25537286]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Gamma", "[", "z", "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"z", "+", "2"}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.15176430063653112`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45083801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Sum expressions involving ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "n"], 
  RowBox[{"Gamma", "[", "k", "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
    RowBox[{"ExpIntegralEi", "[", "1", "]"}]}], "\[ExponentialE]"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"-", "n"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}], "\[ExponentialE]"]}]], "Output",
 ImageSize->{374, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287629728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Generate from integrals, products, and limits:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "t"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Gamma", "[", "z", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251811083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "^", 
   RowBox[{"(", 
    RowBox[{"z", " ", "EulerGamma"}], ")"}]}], " ", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"z", "/", "k"}]}], ")"}], "/", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"z", "/", "k"}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "z"}], "]"}]]], "Output",
 ImageSize->{84, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58266989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "k"}]}], ")"}], "^", "z"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"z", "/", "k"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1", "+", "z"}], "]"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->516652400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " as the solution of a differential equation:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "a", "+", "z"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], " ",
    ",", "w", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], "-", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"a", ",", "z"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205742126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "b"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"a", ",", " ", "z"}], "]"}]}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "b"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"a", ",", "z"}], "]"}]}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"1", "+", "a", "+", "b"}], ",", "z"}], "]"}]}], 
  RowBox[{"1", "+", "b"}]]], "Output",
 ImageSize->{234, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->952568633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"10", "^", "8."}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->201302115],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254523498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine\[Hyphen]number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"10.", "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["4.023872600769312967956830725276`12.183353657098916*^2564"], \
"Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409086459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128892409]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Nest ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{"Gamma", ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "3"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1.25"}], ",", 
      RowBox[{"-", "0.6"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "0.25"}], ",", "0.25"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx13V/IZVd5x/GpioIXAQOWehGworZg7wJeeHMQxGoVCSLkRhpaaC/aWm2p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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxN3XncftX0PvDzPPdgSKEoSvMkGslQmifRD8lQEY3SoEkqJZo0D0g0pzJF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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJysu3k0lu/7/qsoZCgNkiKi0qRIxjhCo6JCohLKUBGlIiXSICkNJBqIBpoo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    "]],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{-1.25, -0.6}, {-0.25, 0.25}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590763729,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Fractal from iterating ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayPlot", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "=", 
       RowBox[{"N", "[", 
        RowBox[{"cr", "+", 
         RowBox[{"I", " ", "ci"}]}], "]"}]}], ";", 
      RowBox[{"Length", " ", "@", 
       RowBox[{"NestWhileList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", "#", "]"}], ">", "20."}], ",", 
            "Indeterminate", ",", 
            RowBox[{"Gamma", "[", 
             RowBox[{"#", "/", "c"}], "]"}]}], "]"}], "&"}], ",", "c", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"#", "=!=", "Indeterminate"}], ")"}], "&"}], ",", "1", ",",
          "20"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ci", ",", 
       RowBox[{"-", "2.5"}], ",", "2.5", ",", 
       RowBox[{"5", "/", "100"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"cr", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", 
       RowBox[{"4", "/", "100"}]}], "}"}]}], "]"}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNmltu6zYQhknxfpNyltAtdQkH6HP3/9Z/hpQiO+hDSWvQH4mN2Mh8nBsp
kfrj999//t6UUn+N389Jf9Tau+mNBq1Jj0G0MWbrjAcoeuNXw3oGYrSy1m7K
PAghBxxkzJ3yQQCHiRHflA8jECbvt5MxKJcfHyFtxigP6TuELGvzCfMsdiCQ
Xhzp333Avj5TEcI3RXH+Rz/idRsv005YHu3JYMpwwKiNqpkBrGlHkAvnvNHh
JrdZqjVumaEliDM+QuoWrRA27611ALmPQOCFIkg8GQq2XaByBsjzK4vSM1nH
nO50CgzP1pAU/y2GTNYYBd24GwPyZNw4YzmGA6KnA2U2T0Xk3Qukhy4q3987
xE03vEXC2US8QmViCnaYjxcFgZqeU5zBqHPOvnsSFOoWGTfqhYIKsAs96JUi
Rs7sSbCbdVFt8CTxh4OBaltgKIyczeUCpeQCbKYYOnhgMJCV6RdZD0GdjFKs
0t12OCHBokvsAgE/nAkQBiX4/CaEUM8zaKrQXLhsHmP2FQGL4QfETTMMGg2x
RoI7JAY4BpPOlJRrrWdGtnkEkhFQugmc0LOBLtc+xOZzqV2jthbygWLxqCAY
VJ1hPOKUMqJVT+FTRd7OywRqkG4L8o6ig+H7eoOUFNYWXcSKIQ2ihMdvFy5I
pkV+iWKwpvoOaZh2t/LGQE4W8jFEsxUiwpDyww0ur6WEkJD6XlgcLmS95EDG
946wmFniQvl2uchdnlXde1ZCbm3vyvQJemYpI/1fEQ+bojrT4vLJ2PdRDX7a
FXR2BAZTOyhGx1xiLLFRdd0h8FHPz++OFldnOO0ZCxSN11WLxrwYO6U9zgJY
5IKFJ9RsMelokJtWa4w3CJSWIJjOa9EhY0Jxtepc7oG6GGj+6QrGBYOiUm3Z
j+r1PxiIVsmoLjvdjKmgA8hqDVxDyPo7pDTOPK4qpl1RNterTlvbQGkvjIPU
Wl1IPZbxoOoFKbXU9OIKM469Ls4pKKtuiyg10ewSLdn/YvE3ZW1KSdzhfbzA
oMLa0f/+GjrAiytt4l2kqhqMo+4xwav+9wnpBTYdrlTRiApL+Qk5djR6w4z4
DoGzeaq6AjUiWrl4vZ+QluAXT/FnShCueuyU+qmIRZs8GUPM3QUptaXWwgtk
5H4mYL60Espp7AwXfKDcNHrrjF8QvsBX/xFgYqXVCXNK6RA2dPAyhXx8IS/7
UX8NBMTD2PP/zxOWRE5kqkukT0gCHd+9eXzuIj0/C4usJyIro8QaL3O1InHd
pWSuIEWuhUWu6pXE/cnQ43daJJF7RpG7X5H7eIkdCYm9FZFdIpH9LpGdO5k9
SCWym9o5j+8Ldz2/wy20Vy9y6iByfiJyEiRyptX1+OkcS+KcUebEVObsV+QU
W+Y8Xg3Go08WdEk8I6FEnvYgCTy30vX4EzgsiWeJlMhTURfq2ee7BkTiSbUX
3L/pH3oFgqQ=
   "], {{0, 0}, {101, 101}}, {0, 21}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541797471]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27504],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RiemannSiegelTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RiemannSiegelTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9462]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25710],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->20061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25385],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#31251"], None}]], "RelatedLinks",
 CellID->452352806],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GammaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Gamma/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Gamma"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->236503001],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->330644698],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->29154262],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->197418765],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->180197269]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gamma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 52.0806874}", "context" -> "System`", 
    "keywords" -> {
     "Euler gamma function", "factorial function", "gamma function", 
      "plica function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Gamma[z] is the Euler gamma function \\[CapitalGamma](z). Gamma[a, z] is \
the plica function \\[CapitalGamma](a, z). Gamma[a, z_0, z_1] is the \
generalized plica function \\[CapitalGamma](a, z_0) - \\[CapitalGamma](a, \
z_1). ", "synonyms" -> {}, "title" -> "Gamma", "type" -> "Symbol", "uri" -> 
    "ref/Gamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9538, 328, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->350641]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 317049, 6647}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3027, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3650, 94, 42, 1, 70, "ObjectName",
 CellID->4042],
Cell[3695, 97, 1924, 65, 70, "Usage",
 CellID->31357]
}, Open  ]],
Cell[CellGroupData[{
Cell[5656, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6134, 184, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6257, 190, 453, 16, 70, "Notes",
 CellID->1847],
Cell[6713, 208, 489, 19, 70, "Notes",
 CellID->7469],
Cell[7205, 229, 456, 18, 70, "Notes",
 CellID->16345],
Cell[7664, 249, 396, 13, 70, "Notes",
 CellID->4380],
Cell[8063, 264, 248, 9, 70, "Notes",
 CellID->31913],
Cell[8314, 275, 529, 20, 70, "Notes",
 CellID->14964],
Cell[8846, 297, 242, 8, 70, "Notes",
 CellID->392129891],
Cell[9091, 307, 212, 7, 70, "Notes",
 CellID->31226],
Cell[9306, 316, 195, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[9538, 328, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->350641],
Cell[CellGroupData[{
Cell[9920, 342, 148, 5, 70, "ExampleSection",
 CellID->102875715],
Cell[10071, 349, 58, 1, 70, "ExampleText",
 CellID->144841031],
Cell[CellGroupData[{
Cell[10154, 354, 187, 6, 28, "Input"],
Cell[10344, 362, 308, 9, 36, "Output",
 CellID->710600429]
}, Open  ]],
Cell[10667, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->381226267],
Cell[10795, 379, 62, 1, 70, "ExampleText",
 CellID->30359850],
Cell[CellGroupData[{
Cell[10882, 384, 237, 8, 70, "Input"],
Cell[11122, 394, 544, 21, 56, "Output",
 CellID->11502764]
}, Open  ]],
Cell[11681, 418, 105, 2, 70, "ExampleDelimiter"],
Cell[11789, 422, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11880, 426, 106, 3, 70, "Input"],
Cell[11989, 431, 272, 7, 36, "Output",
 CellID->35400067]
}, Open  ]],
Cell[12276, 441, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[12406, 447, 216, 7, 28, "Input"],
Cell[12625, 456, 3806, 66, 160, "Output",
 Evaluatable->False,
 CellID->44155935]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16480, 528, 200, 6, 70, "ExampleSection"],
Cell[16683, 536, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16760, 540, 114, 3, 70, "Input"],
Cell[16877, 545, 349, 10, 54, "Output",
 CellID->309968212]
}, Open  ]],
Cell[CellGroupData[{
Cell[17263, 560, 106, 3, 70, "Input"],
Cell[17372, 565, 204, 5, 36, "Output",
 CellID->181617424]
}, Open  ]],
Cell[17591, 573, 105, 2, 70, "ExampleDelimiter"],
Cell[17699, 577, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17774, 581, 161, 5, 70, "Input"],
Cell[17938, 588, 235, 7, 36, "Output",
 CellID->166434738]
}, Open  ]],
Cell[18188, 598, 105, 2, 70, "ExampleDelimiter"],
Cell[18296, 602, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18414, 608, 126, 3, 70, "Input"],
Cell[18543, 613, 238, 6, 36, "Output",
 CellID->113621666]
}, Open  ]],
Cell[18796, 622, 105, 2, 70, "ExampleDelimiter"],
Cell[18904, 626, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18969, 630, 235, 8, 70, "Input"],
Cell[19207, 640, 1418, 45, 84, "Output",
 CellID->120930197]
}, Open  ]],
Cell[20640, 688, 124, 3, 70, "ExampleDelimiter",
 CellID->23103932],
Cell[20767, 693, 57, 1, 70, "ExampleText",
 CellID->86523737],
Cell[CellGroupData[{
Cell[20849, 698, 128, 4, 70, "Input",
 CellID->370601037],
Cell[20980, 704, 179, 5, 36, "Output",
 CellID->202798518]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21208, 715, 223, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[21456, 725, 221, 6, 70, "ExampleSubsection"],
Cell[21680, 733, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21769, 737, 88, 2, 70, "Input"],
Cell[21860, 741, 166, 5, 36, "Output",
 CellID->2286912]
}, Open  ]],
Cell[CellGroupData[{
Cell[22063, 751, 106, 3, 70, "Input"],
Cell[22172, 756, 169, 5, 36, "Output",
 CellID->82825595]
}, Open  ]],
Cell[22356, 764, 105, 2, 70, "ExampleDelimiter"],
Cell[22464, 768, 184, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22673, 778, 162, 5, 70, "Input"],
Cell[22838, 785, 246, 8, 36, "Output",
 CellID->121289668]
}, Open  ]],
Cell[23099, 796, 105, 2, 70, "ExampleDelimiter"],
Cell[23207, 800, 185, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23417, 810, 265, 9, 70, "Input"],
Cell[23685, 821, 1458, 43, 81, "Output",
 CellID->319365553]
}, Open  ]],
Cell[25158, 867, 105, 2, 70, "ExampleDelimiter"],
Cell[25266, 871, 49, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[25340, 875, 223, 7, 70, "Input"],
Cell[25566, 884, 2183, 64, 137, "Output",
 CellID->165759701]
}, Open  ]],
Cell[27764, 951, 77, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[27866, 955, 400, 12, 70, "Input"],
Cell[28269, 969, 1902, 35, 70, "Output",
 Evaluatable->False,
 CellID->99277946]
}, Open  ]],
Cell[30186, 1007, 124, 3, 70, "ExampleDelimiter",
 CellID->59098094],
Cell[30313, 1012, 77, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30415, 1016, 204, 6, 70, "Input"],
Cell[30622, 1024, 1599, 54, 76, "Output",
 CellID->91236409]
}, Open  ]],
Cell[32236, 1081, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[32337, 1085, 246, 8, 70, "Input"],
Cell[32586, 1095, 6693, 114, 70, "Output",
 Evaluatable->False,
 CellID->1958904]
}, Open  ]],
Cell[39294, 1212, 125, 3, 70, "ExampleDelimiter",
 CellID->760443585],
Cell[39422, 1217, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[39650, 1228, 138, 4, 70, "Input",
 CellID->35954786],
Cell[39791, 1234, 245, 7, 50, "Output",
 CellID->125224332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40085, 1247, 215, 6, 70, "ExampleSubsection"],
Cell[40303, 1255, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[40424, 1261, 147, 4, 70, "Input"],
Cell[40574, 1267, 427, 15, 56, "Output",
 CellID->557802575]
}, Open  ]],
Cell[CellGroupData[{
Cell[41038, 1287, 170, 6, 70, "Input"],
Cell[41211, 1295, 697, 26, 66, "Output",
 CellID->526432160]
}, Open  ]],
Cell[41923, 1324, 105, 2, 70, "ExampleDelimiter"],
Cell[42031, 1328, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42113, 1332, 223, 7, 70, "Input"],
Cell[42339, 1341, 1383, 27, 70, "Output",
 Evaluatable->False,
 CellID->433440755]
}, Open  ]],
Cell[CellGroupData[{
Cell[43759, 1373, 223, 7, 70, "Input"],
Cell[43985, 1382, 2615, 47, 70, "Output",
 Evaluatable->False,
 CellID->518990918]
}, Open  ]],
Cell[46615, 1432, 124, 3, 70, "ExampleDelimiter",
 CellID->67544855],
Cell[46742, 1437, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[46819, 1441, 229, 7, 70, "Input"],
Cell[47051, 1450, 892, 30, 52, "Output",
 CellID->910344272]
}, Open  ]],
Cell[CellGroupData[{
Cell[47980, 1485, 229, 7, 70, "Input"],
Cell[48212, 1494, 2495, 82, 76, "Output",
 CellID->81752063]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50756, 1582, 227, 6, 70, "ExampleSubsection"],
Cell[50986, 1590, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[51107, 1596, 267, 9, 70, "Input"],
Cell[51377, 1607, 854, 29, 81, "Output",
 CellID->44580432]
}, Open  ]],
Cell[52246, 1639, 105, 2, 70, "ExampleDelimiter"],
Cell[52354, 1643, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[52436, 1647, 237, 7, 70, "Input"],
Cell[52676, 1656, 1474, 44, 67, "Output",
 CellID->42313038]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[54211, 1707, 207, 6, 70, "ExampleSection"],
Cell[54421, 1715, 209, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[54655, 1726, 393, 13, 70, "Input"],
Cell[55051, 1741, 22177, 368, 70, "Output",
 Evaluatable->False,
 CellID->212876524]
}, Open  ]],
Cell[77243, 2112, 105, 2, 70, "ExampleDelimiter"],
Cell[77351, 2116, 84, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[77460, 2121, 356, 12, 70, "Input"],
Cell[77819, 2135, 2550, 46, 70, "Output",
 Evaluatable->False,
 CellID->378741539]
}, Open  ]],
Cell[80384, 2184, 105, 2, 70, "ExampleDelimiter"],
Cell[80492, 2188, 158, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[80675, 2197, 226, 8, 70, "Input"],
Cell[80904, 2207, 309, 11, 63, "Output",
 CellID->626206532]
}, Open  ]],
Cell[81228, 2221, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[81306, 2225, 203, 7, 70, "Input"],
Cell[81512, 2234, 1226, 41, 54, "Output",
 CellID->356557143]
}, Open  ]],
Cell[82753, 2278, 98, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[82876, 2284, 203, 6, 70, "Input"],
Cell[83082, 2292, 1252, 29, 171, "Output",
 CellID->868156338]
}, Open  ]],
Cell[84349, 2324, 105, 2, 70, "ExampleDelimiter"],
Cell[84457, 2328, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[84582, 2334, 370, 12, 70, "Input"],
Cell[84955, 2348, 22397, 372, 70, "Output",
 Evaluatable->False,
 CellID->180048571]
}, Open  ]],
Cell[107367, 2723, 105, 2, 70, "ExampleDelimiter"],
Cell[107475, 2727, 170, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[107670, 2737, 178, 6, 70, "Input",
 CellID->14089156],
Cell[107851, 2745, 278, 9, 49, "Output",
 CellID->605498051]
}, Open  ]],
Cell[108144, 2757, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[108210, 2761, 266, 9, 70, "Input"],
Cell[108479, 2772, 976, 35, 67, "Output",
 CellID->235797776]
}, Open  ]],
Cell[109470, 2810, 82, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[109577, 2815, 443, 14, 70, "Input"],
Cell[110023, 2831, 7711, 130, 70, "Output",
 Evaluatable->False,
 CellID->984882913]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117783, 2967, 217, 6, 70, "ExampleSection"],
Cell[118003, 2975, 203, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[118231, 2986, 217, 7, 70, "Input",
 CellID->581829668],
Cell[118451, 2995, 241, 8, 36, "Output",
 CellID->25537286]
}, Open  ]],
Cell[118707, 3006, 105, 2, 70, "ExampleDelimiter"],
Cell[118815, 3010, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[118916, 3014, 352, 11, 70, "Input"],
Cell[119271, 3027, 227, 7, 36, "Output",
 CellID->45083801]
}, Open  ]],
Cell[119513, 3037, 105, 2, 70, "ExampleDelimiter"],
Cell[119621, 3041, 183, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[119829, 3052, 161, 5, 70, "Input"],
Cell[119993, 3059, 630, 21, 52, "Output",
 CellID->287629728]
}, Open  ]],
Cell[120638, 3083, 105, 2, 70, "ExampleDelimiter"],
Cell[120746, 3087, 69, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[120840, 3091, 431, 14, 70, "Input"],
Cell[121274, 3107, 189, 6, 36, "Output",
 CellID->251811083]
}, Open  ]],
Cell[CellGroupData[{
Cell[121500, 3118, 466, 16, 70, "Input"],
Cell[121969, 3136, 233, 8, 53, "Output",
 CellID->58266989]
}, Open  ]],
Cell[CellGroupData[{
Cell[122239, 3149, 380, 13, 70, "Input"],
Cell[122622, 3164, 212, 7, 36, "Output",
 CellID->516652400]
}, Open  ]],
Cell[122849, 3174, 105, 2, 70, "ExampleDelimiter"],
Cell[122957, 3178, 207, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[123189, 3189, 507, 16, 70, "Input"],
Cell[123699, 3207, 517, 18, 36, "Output",
 CellID->205742126]
}, Open  ]],
Cell[124231, 3228, 105, 2, 70, "ExampleDelimiter"],
Cell[124339, 3232, 33, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[124397, 3236, 227, 7, 70, "Input"],
Cell[124627, 3245, 455, 16, 54, "Output",
 CellID->952568633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125131, 3267, 210, 6, 70, "ExampleSection"],
Cell[125344, 3275, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[125469, 3281, 106, 3, 70, "Input"],
Cell[125578, 3286, 357, 7, 70, "Message",
 CellID->201302115],
Cell[125938, 3295, 187, 6, 36, "Output",
 CellID->254523498]
}, Open  ]],
Cell[126140, 3304, 105, 2, 70, "ExampleDelimiter"],
Cell[126248, 3308, 101, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[126374, 3314, 106, 3, 70, "Input"],
Cell[126483, 3319, 217, 6, 36, "Output",
 CellID->409086459]
}, Open  ]],
Cell[CellGroupData[{
Cell[126737, 3330, 90, 2, 70, "Input"],
Cell[126830, 3334, 162, 5, 36, "Output",
 CellID->128892409]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[127041, 3345, 208, 6, 70, "ExampleSection"],
Cell[127252, 3353, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[127462, 3364, 515, 17, 70, "Input"],
Cell[127980, 3383, 179402, 2955, 232, 85796, 1416, "CachedBoxData", \
"BoxData", "Output",
 CellID->590763729]
}, Open  ]],
Cell[307397, 6341, 105, 2, 70, "ExampleDelimiter"],
Cell[307505, 6345, 180, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[307710, 6356, 1124, 34, 70, "Input"],
Cell[308837, 6392, 1885, 38, 246, "Output",
 CellID->541797471]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[310783, 6437, 311, 9, 70, "SeeAlsoSection",
 CellID->27504],
Cell[311097, 6448, 1763, 62, 70, "SeeAlso",
 CellID->9462]
}, Open  ]],
Cell[CellGroupData[{
Cell[312897, 6515, 314, 9, 70, "TutorialsSection",
 CellID->25710],
Cell[313214, 6526, 144, 3, 70, "Tutorials",
 CellID->20061]
}, Open  ]],
Cell[CellGroupData[{
Cell[313395, 6534, 321, 9, 70, "RelatedLinksSection",
 CellID->25385],
Cell[313719, 6545, 271, 6, 70, "RelatedLinks",
 CellID->452352806],
Cell[313993, 6553, 184, 4, 70, "RelatedLinks"],
Cell[314180, 6559, 190, 4, 70, "RelatedLinks"],
Cell[314373, 6565, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314793, 6583, 319, 9, 70, "MoreAboutSection",
 CellID->236503001],
Cell[315115, 6594, 165, 3, 70, "MoreAbout",
 CellID->330644698],
Cell[315283, 6599, 181, 3, 70, "MoreAbout",
 CellID->29154262],
Cell[315467, 6604, 155, 3, 70, "MoreAbout",
 CellID->197418765],
Cell[315625, 6609, 145, 3, 70, "MoreAbout",
 CellID->180197269]
}, Open  ]],
Cell[315785, 6615, 27, 0, 70, "History"],
Cell[315815, 6617, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

