(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    322209,       6691]
NotebookOptionsPosition[    309768,       6284]
NotebookOutlinePosition[    311031,       6320]
CellTagsIndexPosition[    310944,       6315]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "GammaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GammaDistribution"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gamma\"\>", 
       2->"\<\"InverseGammaRegularized\"\>", 
       3->"\<\"GammaDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GammaRegularized", "ObjectName",
 CellID->27616],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GammaRegularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GammaRegularized"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the regularized incomplete gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Q", "(", 
        RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "In non\[Hyphen]singular cases, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Q", "(", 
     RowBox[{"a", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"a", ",", "z"}], ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->5220],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is the generalized regularized incomplete gamma function, defined in non\
\[Hyphen]singular cases as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["0", "TR"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["1", "TR"]]}], "]"}], "/", 
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    StyleBox["a", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14615],

Cell[TextData[{
 "Note that the arguments in ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " are arranged differently from those in ",
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22348],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->94447958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354131725],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->31696146],

Cell["Evaluate numerically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"1", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.22313016014842982`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16653571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"1", ",", "z"}], "]"}], ",", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"2", ",", "z"}], "]"}], ",", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"3", ",", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35311048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292579203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671466948],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   SuperscriptBox["z", "n"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"n", " ", 
         RowBox[{"Gamma", "[", "n", "]"}]}]]}], "+", 
      FractionBox["z", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "n"}], ")"}], " ", 
        RowBox[{"Gamma", "[", "n", "]"}]}]], "-", 
      FractionBox[
       SuperscriptBox["z", "2"], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "n"}], ")"}], " ", 
          RowBox[{"Gamma", "[", "n", "]"}]}], ")"}]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "z", "]"}], "3"],
       SeriesData[$CellContext`z, 0, {}, 0, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`z, 
      0, {-$CellContext`n^(-1)/
       Gamma[$CellContext`n], (1 + $CellContext`n)^(-1)/Gamma[$CellContext`n],
        Rational[-1, 2] (2 + $CellContext`n)^(-1)/Gamma[$CellContext`n]}, 0, 
      3, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{434, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451472254]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"2", ",", 
     RowBox[{"33", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.\
158597619825332023416095930388516634103957667085863968682019593751`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556817691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"2", ",", "3.30000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.158597619825332023416095930388516684324650290194`28.\
663482926452797"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259940413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate numerically for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{"3", "I"}]}], ",", 
    RowBox[{"4", "-", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.1522398554329478`"}], "-", 
  RowBox[{"0.23324343668111017`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9887474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170367886],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->420429012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GammaRegularized", "[", 
   RowBox[{"n", ",", "z"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329617373],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["Q",
    GammaRegularized,
    Editable->False,
    Selectable->False], "(", 
   RowBox[{"n", ",", "z"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->795116114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Regularized Incomplete Gamma Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate at integer and half\[Hyphen]integer arguments:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"3", ",", "z"}], "]"}], "//", "FunctionExpand"}], "//", 
  "Simplify", " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "z"}], "+", 
    SuperscriptBox["z", "2"]}], ")"}]}]], "Output",
 ImageSize->{115, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238637647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{
     RowBox[{"13", "/", "2"}], ",", "z"}], "]"}], "//", "FunctionExpand"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"10395", " ", 
    SqrtBox["\[Pi]"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "z"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"10395", " ", 
      SuperscriptBox["\[ExponentialE]", "z"], " ", 
      SqrtBox["\[Pi]"]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["z"], " ", 
      RowBox[{"(", 
       RowBox[{"10395", "+", 
        RowBox[{"6930", " ", "z"}], "+", 
        RowBox[{"2772", " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"792", " ", 
         SuperscriptBox["z", "3"]}], "+", 
        RowBox[{"176", " ", 
         SuperscriptBox["z", "4"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["z", "5"]}]}], ")"}]}], "-", 
     RowBox[{"10395", " ", 
      SuperscriptBox["\[ExponentialE]", "z"], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Erf", "[", 
       SqrtBox["z"], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{530, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181282440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"0", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433657094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], ",", 
   "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2872974951836458`", ",", "0.5438131158833297`", ",", 
   "0.8911780189141513`", ",", "0.9858126880090866`", ",", 
   "0.999938373089875`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277290811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GammaRegularized", "[", 
   RowBox[{"a", ",", 
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     SuperscriptBox[
      RowBox[{"O", "[", "x", "]"}], "4"]}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"a", ",", "1"}], "]"}], "-", 
   FractionBox["x", 
    RowBox[{"\[ExponentialE]", " ", 
     RowBox[{"Gamma", "[", "a", "]"}]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"\[ExponentialE]", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "a"}], "]"}]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "a"}], "]"}]], "+", 
       FractionBox["1", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}], "]"}]], "-", 
       FractionBox["2", 
        RowBox[{"Gamma", "[", "a", "]"}]]}], ")"}], " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"6", " ", "\[ExponentialE]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    GammaRegularized[$CellContext`a, 1], -E^(-1)/Gamma[$CellContext`a], 
    Rational[-1, 2] E^(-1)/Gamma[-1 + $CellContext`a], Rational[-1, 6] 
    E^(-1) (Gamma[-2 + $CellContext`a]^(-1) + Gamma[-1 + $CellContext`a]^(-1) - 
     2/Gamma[$CellContext`a])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{413, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17491973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], " ", 
  SuperscriptBox["z", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"Gamma", "[", "a", "]"}], " ", "z"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "z"], ")"}], "2"]}], 
      RowBox[{"Gamma", "[", "a", "]"}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "3"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {
     Gamma[$CellContext`a]^(-1), (-1 + $CellContext`a)/Gamma[$CellContext`a]},
      1, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{273, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33254286]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"a", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"DirectedInfinity", "[", "x", "]"}], ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "z"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["1", "z"], ")"}], 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", "\[Pi]", " ", 
        RowBox[{"Floor", "[", 
         RowBox[{
          FractionBox["1", "2"], "+", 
          FractionBox[
           RowBox[{"Arg", "[", "x", "]"}], 
           RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], 
      RowBox[{
       RowBox[{"Gamma", "[", "a", "]"}], " ", "z"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", "\[Pi]", " ", 
         RowBox[{"Floor", "[", 
          RowBox[{
           FractionBox["1", "2"], "+", 
           FractionBox[
            RowBox[{"Arg", "[", "x", "]"}], 
            RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "z"], ")"}], "2"]}], 
      RowBox[{"Gamma", "[", "a", "]"}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "3"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[$CellContext`x], {}, 1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[$CellContext`x], {
     E^(Complex[0, 2] (-1 + $CellContext`a) Pi 
        Floor[Rational[1, 2] + Rational[1, 2] Pi^(-1) Arg[$CellContext`x]])/
      Gamma[$CellContext`a], (-1 + $CellContext`a) 
      E^(Complex[0, 2] (-1 + $CellContext`a) Pi 
        Floor[Rational[1, 2] + Rational[1, 2] Pi^(-1) Arg[$CellContext`x]])/
      Gamma[$CellContext`a]}, 1, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{518, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->371983563]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalized Regularized Incomplete Gamma Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate at integer and half\[Hyphen]integer arguments:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"5", ",", "3", ",", "z2"}], "]"}], "//", "FunctionExpand"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "3"}], "-", "z2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"393", " ", 
     SuperscriptBox["\[ExponentialE]", "z2"]}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"24", "+", 
       RowBox[{"24", " ", "z2"}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["z2", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z2", "3"]}], "+", 
       SuperscriptBox["z2", "4"]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{340, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22985760]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{
     RowBox[{"13", "/", "2"}], ",", 
     RowBox[{"7", "/", "2"}], ",", "z2"}], "]"}], "//", "FunctionExpand"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"10395", " ", 
    SqrtBox["\[Pi]"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["7", "2"]}], "-", "z2"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"145782", " ", 
      SqrtBox["14"], " ", 
      SuperscriptBox["\[ExponentialE]", "z2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"7", "/", "2"}]], " ", 
      SqrtBox["z2"], " ", 
      RowBox[{"(", 
       RowBox[{"10395", "+", 
        RowBox[{"6930", " ", "z2"}], "+", 
        RowBox[{"2772", " ", 
         SuperscriptBox["z2", "2"]}], "+", 
        RowBox[{"792", " ", 
         SuperscriptBox["z2", "3"]}], "+", 
        RowBox[{"176", " ", 
         SuperscriptBox["z2", "4"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["z2", "5"]}]}], ")"}]}], "-", 
     RowBox[{"10395", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["7", "2"], "+", "z2"}]], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Erf", "[", 
       SqrtBox[
        FractionBox["7", "2"]], "]"}]}], "+", 
     RowBox[{"10395", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["7", "2"], "+", "z2"}]], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"Erf", "[", 
       SqrtBox["z2"], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{549, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->669655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at generic point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"a", ",", "z1", ",", "z2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z10", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"a", ",", "z10"}], "]"}], "-", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"a", ",", "z2"}], "]"}]}], ")"}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z10"}]], " ", 
     SuperscriptBox["z10", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}]], " ", 
     RowBox[{"(", 
      RowBox[{"z1", "-", "z10"}], ")"}]}], 
    RowBox[{"Gamma", "[", "a", "]"}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z10"}]], " ", 
     SuperscriptBox["z10", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "a"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z10", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}], "]"}]}], "-", 
       RowBox[{"Gamma", "[", "a", "]"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z1", "-", "z10"}], ")"}], "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "]"}], " ", 
     RowBox[{"Gamma", "[", "a", "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z1", "-", "z10"}], "]"}], "3"],
    SeriesData[$CellContext`z1, $CellContext`z10, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z1, $CellContext`z10, {
   GammaRegularized[$CellContext`a, $CellContext`z10] - 
    GammaRegularized[$CellContext`a, $CellContext`z2], -
    E^(-$CellContext`z10) $CellContext`z10^(-1 + $CellContext`a)/
    Gamma[$CellContext`a], Rational[1, 2] 
    E^(-$CellContext`z10) $CellContext`z10^(-2 + $CellContext`a) 
    Gamma[-1 + $CellContext`a]^(-1) ($CellContext`z10 
      Gamma[-1 + $CellContext`a] - Gamma[$CellContext`a])/
    Gamma[$CellContext`a]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{518, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65481088]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"GammaRegularized", "[", 
    RowBox[{"a", ",", "z1", ",", "z2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{509, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364497570]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot of the real part of ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " over the complex plane: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"GammaRegularized", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "/", "2"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{232, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538749027]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"GammaRegularized", "[", 
     RowBox[{
      RowBox[{"ax", "+", 
       RowBox[{"I", " ", "ay"}]}], ",", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "I"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ax", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ay", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{238, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15687340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "CDF of the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " distribution:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDF", "[", 
   RowBox[{"ChiSquareDistribution", "[", "r", "]"}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{
   FractionBox["r", "2"], ",", "0", ",", 
   FractionBox["x", "2"]}], "]"}]], "Output",
 ImageSize->{182, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321500722]
}, Open  ]],

Cell["Calculate PDF:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"%", ",", "x"}], "]"}], ",", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{"ChiSquareDistribution", "[", "r", "]"}], "]"}], "[", "x", 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "r"}], "/", "2"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "2"}]], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["r", "2"]}]]}], 
    RowBox[{"Gamma", "[", 
     FractionBox["r", "2"], "]"}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "r"}], "/", "2"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "2"}]], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["r", "2"]}]]}], 
    RowBox[{"Gamma", "[", 
     FractionBox["r", "2"], "]"}]]}], "}"}]], "Output",
 ImageSize->{221, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234497289]
}, Open  ]],

Cell["Plot the CDFs for various degrees of freedom:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"%%", ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11822930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["CDF of the gamma distribution:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CDF", "[", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Theta]"}], "]"}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34798608],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"\[Alpha]", ",", "0", ",", 
   FractionBox["x", "\[Theta]"]}], "]"}]], "Output",
 ImageSize->{178, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599458984]
}, Open  ]],

Cell["Calculate PDF:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"%", " ", ",", "x"}], "]"}], ",", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{"GammaDistribution", "[", 
       RowBox[{"\[Alpha]", ",", "\[Theta]"}], "]"}], "]"}], "[", "x", "]"}]}],
    "}"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox["x", "\[Theta]"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["x", "\[Theta]"], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Alpha]"}]]}], 
    RowBox[{"\[Theta]", " ", 
     RowBox[{"Gamma", "[", "\[Alpha]", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox["x", "\[Theta]"]}]], " ", 
     SuperscriptBox["x", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", 
     SuperscriptBox["\[Theta]", 
      RowBox[{"-", "\[Alpha]"}]]}], 
    RowBox[{"Gamma", "[", "\[Alpha]", "]"}]]}], "}"}]], "Output",
 ImageSize->{178, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213545505]
}, Open  ]],

Cell["Plot the CDFs for various parameters:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"%%", ",", 
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->459491380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Fractional derivatives/integrals of the exponential function:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fd", "[", 
   RowBox[{"\[Alpha]_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], ",", "x"}], "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell["Check that this is the defining Liouville integral:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", "x", "]"}], 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", "x"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "\[Alpha]"}], "-", "1"}], ")"}]}], "/", 
          RowBox[{"Gamma", "[", 
           RowBox[{"-", "\[Alpha]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "y"}], "}"}], ",", 
        RowBox[{"GenerateConditions", "->", "False"}]}], "]"}], "/.", 
      RowBox[{"y", "\[Rule]", "x"}]}], ")"}], "-", 
    RowBox[{"fd", "[", 
     RowBox[{"\[Alpha]", ",", "x"}], "]"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382009446]
}, Open  ]],

Cell["Fractional derivative/integral of integer orders:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"fd", "[", 
     RowBox[{"k", ",", " ", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "//", "FullSimplify", 
  " "}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "x"], "-", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   SuperscriptBox["\[ExponentialE]", "x"]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29786164]
}, Open  ]],

Cell["Plot fractional derivative/integral:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"fd", "[", 
     RowBox[{"\[Alpha]", ",", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{236, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->200322411]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify regularized gamma functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"a", "-", "1"}], "]"}], " ", 
    RowBox[{"GammaRegularized", "[", 
     RowBox[{"a", ",", "z"}], "]"}]}], "-", 
   RowBox[{"Gamma", "[", 
    RowBox[{"a", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"a", ",", "z"}], "]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "a"}]]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->771032274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express through ordinary gamma functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{"a", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"a", ",", "z"}], "]"}], 
  RowBox[{"Gamma", "[", "a", "]"}]]], "Output",
 ImageSize->{83, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155422693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Solve a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"GammaRegularized", "[", 
       RowBox[{"\[Alpha]", ",", " ", "x"}], "]"}], "^", "2"}], "-", 
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"\[Alpha]", ",", " ", "x"}], "]"}]}], "==", "r"}], ",", " ", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->635278312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseGammaRegularized", "[", 
      RowBox[{"\[Alpha]", ",", "\[Infinity]", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox[
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "r"}]}]]}], ")"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseGammaRegularized", "[", 
      RowBox[{"\[Alpha]", ",", "\[Infinity]", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox[
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "r"}]}]]}], ")"}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{377, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73784309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GammaRegularized", "[", 
      RowBox[{"3", ",", "z"}], "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"GammaRegularized", "[", 
       RowBox[{"2", ",", 
        RowBox[{"z", "+", "2"}]}], "]"}]}], "+", "z"}], "\[Equal]", "6"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "5.948329738226758`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172701424]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Large arguments can give results too small to be computed explicitly:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"10", ",", 
   RowBox[{"10.", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->31160833],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54771668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine\[Hyphen]number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{
   RowBox[{"10.", "^", "1"}], ",", " ", 
   RowBox[{"10.", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.411488803565340618770399984637`15.954589770191005*^-413"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267731231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81836250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " is usually generated in computations:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "+", "1"}], "}"}], ",", 
    RowBox[{"-", "z"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"-", "a"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "a"}], "]"}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"a", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "a"}], "]"}]]], "Output",
 ImageSize->{216, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201712771]
}, Open  ]],

Cell[TextData[{
 "Regularized gamma functions are typically not generated by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"GammaRegularized", "[", 
   RowBox[{"a", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"a", ",", "z"}], "]"}], 
  RowBox[{"Gamma", "[", "a", "]"}]]], "Output",
 ImageSize->{83, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->805744624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"a", ",", "z"}], "]"}], 
  RowBox[{"Gamma", "[", "a", "]"}]]], "Output",
 ImageSize->{83, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200261113]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Nest ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " over the complex plane: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GammaRegularized", "[", 
         RowBox[{"#", ",", 
          RowBox[{"1", "/", "#"}]}], "]"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", "2"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33381716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 " at infinity:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"GammaRegularized", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ")"}]}], ",", "1.3"}], "]"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Exclusions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414908694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Riemann surface of the incomplete regularized gamma function:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
         RowBox[{"r", " ", 
          RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
         RowBox[{"Re", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"2", " ", "k", " ", "Pi", " ", 
              RowBox[{"I", " ", "/", "3"}]}], "]"}], " ", 
            RowBox[{"GammaRegularized", "[", 
             RowBox[{
              RowBox[{"1", "/", "3"}], ",", 
              RowBox[{"r", " ", 
               RowBox[{"Exp", "[", 
                RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}]}], "]"}]}], "+", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"Exp", "[", 
              RowBox[{"2", " ", "k", " ", "Pi", " ", 
               RowBox[{"I", "/", "3"}]}], "]"}]}], ")"}]}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[CurlyPhi]", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfQd4XMd17hoAwSJShbIsudc4cfJgx3b84hfHcWInjkuWVewURVFLil3s
Vey9N7D3AvbeO9F772UBLIAtwC62N7T/e2/mzNzl4gKkKH2P3/LuzN175875
57Q5c+ZC+9G8yRNnfDRvyscffe+/53w0a/KUj+d+74+fzmGnIr+i0WiusP/l
72lY+f+yEv2/AoD98NLjZHaMYhf/B9Wm8GMkq1JNOfuxvCYy7Fde/Hf6dZrq
7O9ecpY/TRP1/Gz4cyNY7fdd+jeQHXkzY6g2SNXqaDr7J9m/KNWv73XbB3Ub
78gnREycOPHfu72iv7xCEy36zI7sWnHsvs035B3Uo+jQ+dBd/xaijVP9utID
VSsRndFi9/EzvJ//SvePlff1o/tE46H7wur/h64eLZ+mfsprqqsjVfVf092/
lHf/QD6zv+qqKFX9n+muX3QZ7++8gNY3Vff3UNX/9wva+6Yc+3dV10er6r96
wf3vyf6oeftr3bTHkX9RO+/IfnxHdV8vVf0XL7hf4TE1D39TdX9vVf3nnUbn
TdmKIEeI8ee12EdV/0e69feypb9T/armlp/R1d+UV3//BaP7Y9VdfSWa4u5v
qa5WeCRGddfrqvr/6vZupS/qPpCU9KzJhj4LlZkoy0BJOgrTkJ+KLtzzhqr+
D90+6T055m9R58z5MOahPhe1OajORlUWyjNRmoHiDBSkIy8N2anISEFaEr76
OU/7+26fpuipt3nlbVshmgr4EJvy0ZCHulzU5ECfjYpslGWhJBOFGchPR04a
slKRnoKUZCQlIT4RordhT1NL3k+6fXpIB4ZxFumArzmK0FwEayE/ay6AMR/1
eajNQ3UuKnNQno3SLBRloiADuenITkdmGtJSkZyCxCQ8S8TjBKjpV/fw70I8
FiHR7k5SqJVvekrgLoGzGPZi2IrQVEQYFaKhAIZ81ORBn4uKHJRlozgbhVnI
y0ROBrLSkZ6G1FQkpSA+GU+T8CgR9xNwJ17wanhv+kveFb36hxdwm7pOvPsd
fxm8pXCXwlkCewlsxbAWE25FMBairgC1BajOR1UeynNRmouiHBRkIzcL2ZnI
zEBaOlLSkJiKZyl4koyHSbiXgNvxuPEMailW89jfUG+jJMd+r5vRJBnoEyxH
oBy+MnjK4CqFoxTNpbCV8ossxXiN3/NaViYyMpCajuR0JKThWSoep+BBMu4m
8suux3fVUu+o6j+ix/YIw4g3/G3ZK+K93m2VaKlAoAK+cnjK4SqDswz2MjSX
MXSpH6ZiNBShrgi1hdAXoDIf5fkozUNRLgpykZfDrAi/rldCOp6m4XEqHqTw
59xMxLUEXHmGnqpeqXX+D6lf0aqR/PoLRpyf1/TqqALreGslghXwV8BbAXcF
XOUC7bcaS2EugbEE9cUwFKGmCPpCVBSgLB8l+SjMQ34ucnOQlY2MbKRlITlT
0trrSToepfHe30nBzSROwOV4XHgGtZ1T0/ADoqGnqq9fkzR8l/Nyhx6ab7dX
obUKwUoEKuGrhKeSP8tZAXs5LzSVwVIKUykaSlBXjNpi6ItQWYjyQpQWoDgf
BfnIy0NOLjJzkJ6D1GwkZyEhSzxUE30vDbdTcCMZVxNxKQHn46G272oN/P1u
+/227DdR9YOOarC+s0+bHi1VCFTBV8V7666EsxKOCjRX8GpjOcxlMJaivhSG
ElQXo6oYFUUoK0RJIYoKkJ+P3Hxk5yEzF2k5SMlBUjbis/i9jzNJ52iib6Xi
egquJOFiIs4lIC4eaj/pPakXvh+StK4Wnp8groruqAHvPn3aqtGqF8/p462C
pwou1v1K2GkQmipgKYepHA1l6MWv6Z9fgJx8ZOUjIw9peUjORWIOv/JJFh5m
4n4GMXkarqXgcjIuJOFcIs4kQO0VfkNV/05IJsM9CbVf9D2qd9SCE1DDuJMf
erfX8GcGqxHQw6eHRw93FZxVsFcpMlhfDkMZasqgL0VlKcpKUFKMomJCRNMr
PR+p+UjO4608y8HjbDzIwl2Jfc+rqbiUggvJOJuEM4k4mcBdYdIW4f2nOum9
V9HHwk/rMICTUitI0nB422rQUoNANfzV8DI69HBVi368aatCUyUslTBVoKEC
hnKip4zTU16K0hIUl6CwGPlFyC1CdqGgLTo+D09y8Sgb97NwJxO3MkRrPS6l
4nwKzibjdBLRo/YcSQuStQv5GNEDP+EIace1a0e1ad8Pagd6SSIYGZrenBAD
/5kV2mrRWoNgDfw18NVIHfKOs5r/bNOjqQqNVTBXwliJekZIBWrKoS9HZRnK
y1BSiqISFJQgrxg5xcgqQkYR0goVWX6ci4c5uJeN21m4mYlrCj3nUxGXwik5
kYSjiegyPuR3huY6ZJ96D5mJgVOhnUhUjW3XjmjVDvFrtR7tnxyCAzvqmH5i
VP2A02XgBLYb0FqLYC0Ctfwuby3cNXAS/zVXw6pHox7mKhir0FCJukrUVqC6
AlXlqChHWRmKy1BYivxS5JYguxiZZH5TipBUiIQCQUnfB7m4m4Pb2biRhWuZ
uEwCdS4NcalEXjKOJkFNHUkTecfdcR+NXt/R8zFsFgZNh3YyEfxhh3ZMq3Z4
QDvYp/2rS/tHu/Y/GslP6IH6jo56MOLZh8w0/36rvQ5tBrTQIPsN4KTXwkUw
2Gtgq0ZTNSx6mPRo0KOuCrVVYvKp6VNYhrwy5JQiq4RfnVqM5CIkFiK+EE8k
1T3u5uJWDm5k42oWLit2J4pReCoVx1NwJJlo5hpO0NoLYTOv1ycsxdiFGDEX
Qz6Fdhq0klHbtKOC2vd92oEe7V+c2v+0aX9nJn8qGg0dHQ2QRNaDaGRfr7Fq
G9EcrAOj0WeAxwC3AU4is7lWUhRdo0d1FaqqUFGJskqUVIL0TM/0UqSUIKkY
CUV4WojHBXhYoPgLt/JwPQdXs3EpCxcy+VieTsfJNBxLxZEUHEzuyrPvhnQi
H0yi+80pq6Fbjg+XYPQCvD8Hg2ZC+5yFW7UjAtohXq3WxVhY+4cm7W+NNGPq
+ZzeBpJRUSCaudZprQcjOMBoroO3jhPsqlO0Ti2aamGpgakGDTWoq0ZtNar1
0OtRWYXyKpRWobgShZXIr0BuhfA0eqaUIrEE8cV4WoRHhXhQiHsKDlHXc3El
BxezKaJAZ06k41gajqTiYEoXzv5aCAPiaK6qFCyip63FpFX4aBnGLsKIeRg6
Cz2Jl7T/49L+d/MHQ2za3zQM+22tmAX3gLEDRk63wEDTg3/zG9ob0NaAlnoE
6uGv5wAIXfNVex1sBlgNaKyFuRbGGtTXwFCDmhpUV6OqGhXVKKtGqR7FehTq
ka/nDWdVIEN6XP2fleBJMR4W4X4R7hbiNs2ZruXjci6n/lw24sjOn8jAsXQc
ScOhVOxPwbdUGLzzHANp0wUS5PP1m7EBk9fg4xUYtxSjF/KfBnUnBIKmyHlT
nGP+ZJwzxii8G45KB0PFCJgIlShWFPqOznJgGhBsgJ9A8zbATQVHPZrrYK1D
kwEWA0wGNBhQVwtDLWpqoa9FZQ3Ka1BWg5IaFJF+zNMjR4/MSqRXIKUcSWVS
8h+X4GEx7hXjThFuFUou6cPIu5CLczk4k00IZeIYKcJD6dif2gWhr3ZBSPzj
+oI46J152/DpZkxdj4mrMX45b2lEuABNIqw+aNeObNUO9WsHeLR/drAzW1Z4
5oyz7FxsFW33gKmD4dRBH6EZTVyMjCRUJu6PsOIbbUa00imuKY14DloD7PWw
1aOpDpY6mOtgZLzWh3yQ/BrkVCNLj4wqpFUiuQKJ5Ygvl37ZgxIO0O1i3CzC
9ULOO5fycSEPZ3NxJkdcE3UsE0cycTAD+9PxTUn7O52lR6IVKX8l1Pov2InZ
WzF9Iz5ZiwmreD9HL8bw+RgyGwNnQDuFkBnfTsYiqB3i02rd2v+20zMjN863
XdnvVNpkEy9zB8wcHHYUkHSYFayi+Hefdqq0mBAwgmNjhIegchphbxBatHdD
PerqYahHTT30daisQ3kdSg0oMYjh1fTM1CO9CqlVSK5EQgWeVeBJueScN+6W
4HYJbhTjWhGEujifj7P5/CGncvnxaBYOM6AysT9D6BduZogAwVDh3BSGWg+J
GsUd+i7ajbk7MHMLpmzgbX60AmOXYuQivD8Pg2dhAFlZoQu1w/zaQR4ysbYl
s1zs1PEtDoFXT4mXWcGLlS2ci8ziyR30m6iTd2gGQy5ogt8EnwkeE9wmMfr9
m42wGdFkhKUBpgYYG1DfICGsrkdVPSrqCUWyboUG5Ncit0bc2y9NjxQ9kqqQ
UIVnlXhcgYc077pTilsluF7CcblcpMwFGZRn8nFSQJmNw1kEZSYoRsOuVM8J
+4fQ5Pf3kihSvOS15QewZC/m78Ks7Zi2mbf48WqMW47RSyDEUzwzUsrnuHah
xXpo/+LQ/qd19wYv7+Upj/B4omHpgIUQZNBZwMoRvBIpqgJZi9D5DFEGZqsZ
QTP8Zvgk4MxLNcFugs0EqxGNRpiNMBrR0IA6hmYDahqgb0BVAyoaUEYyXVSH
gjrkGZBTi6wa2UqPJD0S9HhWhceVeFChUHGzlCN5tUReFRlXgNMMyTzFMh7K
xoEs7MtCbCb6STTVsYz+3fJmb4kqRRnfXnkYS/djQSzm7ORdnLIJE9dh/CqM
XYZRi/mZwXMwMFzvMcdhZEA71Cf60V83xs48B1bKvu8PYYpGBdZGBWIqdChV
wvar7Ra0WhC0IEAc7TXDQwWnGQ4zmhmuJjSZYDHBZILRhHojDEbUGlFtFPLS
u7QBxfUorEd+HXINyDYgsxbptUitVWYS8dV4qsfjKjysxL0KhNyCK6W4VIIL
5FTHFeJUAU7k4xhN6w7l4EA29mUjNktExbnMdxdb64rta3IkKMb1jdVHsewQ
Fu3DvD283WlbMWkjJqzFhyt5dfhiRQGEa86xLcIvG6Dl0r9qkfuTERZWeP9X
UyI4qpECS16MYN80ZeWo0kdYGfbdr70RrY1oIaz9Fvgs8FDZaeHI2s2wmdFk
FuytidSbUCn1LmmhvHrk1CGrDhkGpBmQakCygudXn1bjcTUe6nGvSmrMa2Vg
YF4sxXny2M8U4VQhThTgGKnRQ7k4kCPBjJLoqOO43WP5uuRT8j2+w86vPYHl
R7D4AG929m7M2I7JW6AjlTp2BUYvxfCFGDIPgxSVyhH9sE07pkU73K8d7B0z
2sPOxG72zhi0/IPfzdbGFKGJeJF/RXZQuUMp9hMV8WlvQhuhG2yEvxHeRnio
6mqUNub1RgvMFpgsaLCgzgKDGTVmVJtRRfxcbkKpCcVGFDbIOEF2PTLrkV6H
1DqkGJBkQIKCcO9HNZJLb1FQ5Wo5LpdxeM+VKFr1ZBGOF+IoOYiH8nAgF/ty
EJtN2L79Sti+KbEl/fsGO7/yGJYe5u3NjcXMXZi6DZNIxY5bjTHLMWIJ3mfY
zgXzFsWs5i1mpj6Z6J0/071wzPpP/rx4yC8/0cbkM6xghTgKAEWVl60CWaHd
WpoQaIKP/RLhkee+6myEoxHNjbA2oqkRlkaYGmG0oJ4grbWgxoJq4uIKC8rM
KDGhyIQCI/KkNngtvR6p9UiuQ2Id4g14StPPhzWcT+/ocbNK4tfvUjkulOFc
KeKIY8PhPJiP/XnYm4vYnK6x4O6xVKLsIv605Rw2nCFZome9NW8/ZsViOinX
jzdh/DqMXYWRyzB8CYYu4CcHhCnXIdPbhkxtlXwwd7Zv1aTts95fOeLX0zgr
x+RwMK1Syq1SF4hTEfzwfVZvt6LVimAT/E3wsg9d7qYRcDbB0QR7E2xNHN/G
RpgFxE2ob0JdI2obUU18XdmIcgtKLSg2o9CMfBNyTcg2ItMoEfx6SgOS6pFA
s+EnBsmvd6txS48bVbhKjHuxHOfLcLYUZygmf6IYx4twtLAzyrldUaYIRJdY
9tsSZVILWy9i4zmsOY3lJ3hzCw5izj7M2E392IqPNuKDtRi9SvDVu4PnY9Bs
rmTZh9U/3IAP1mP0Ooxa03Fo5anNs/bp/nuB0LCEchZ/pg0dNogjB9kmEY4W
9TYrWqwIWOGzinVqj1X4XC4rnFbYrWi2wmpFkxWWJrES0bPIggIL8szIMSPb
hEwT0k3Str8bX48ndXhkwINazqu3a3CzGtf0uEIx4gsVOFeOuDIFxxIcK8IR
gWMB9udjbx725HVdR+keR0I7ml21/TI2X8C6s7ydz45LrD7dy6ufbMfHWzCO
NOvwlXj/MwxdxDXrwFnQTuf6lZ2fsh3z94JpizNbL+1ZcmzK/yxhJ0f9Zuag
n08SPNKjE4LNXPptAqV2G1ptCNrgp9/Y0WtDhMcm+umyiRk3SbTZCqMVDVbU
WWEgXq62osqKyiaUN6G0UfGh8izIsSDLjAwz0hRco57W43EdHhhC0YO3rlfj
ahdcT5cpuBbjCK3CHSjEvgLszSdc1Rq1e1xp5vj2jqvYcgnrz/NGlp/CkuOY
T1p1eiwm74JuO8aTVh2xBsNXYNhSDF0I7RxoP1XmKquP4cq+W+um7Zo5ZBnn
1d/PGf7P0zQiF6JZPq8ZHM0IfugloG2zocWGAAEXaIaPockQ1bzraZYTS4ap
wwa7DTYbrDY02mC2wWSD0YZ6G+roxhob9DaObYUVZVaUNKGoCQVNCsKZpHlT
zUgyIUHRA70e1pNyNeAWBb2uVeOKHpeqpJU7W4Ez5Tgl4C3FsRIcKVb82dh8
hOP5avj23HUD265i4yXe4soz+OwkFh5TPL2psZi0i//wwSaMWo+RqzB8GYYu
wYD5pGYpzsH4mFNxPe3eyUdLP9rIyjOGLJ/4p4Vjfvup7FeHnfjVzvm1WcZ8
mtHajGAzAoSnn6PvY4c3vAq+7ma4muFshr0Zzc2wNqOpGZZmmJthaoaxGfV2
JVZR3cxhrrSh3IZSK4qtKLQivwm5TciWlvDtVAuSzUgw4ZkRT4yKdq3DbQNu
Es5Xq3FZj4t6XCBOjqvAaYGzGKvD5NXuL8TeAsQWoEsGzEsQ7r37FrZfx+Yr
vIXV57D8DBaf5OVZhxSpGrcVYzZi9FqMWCn6+9bA+Rg4B8KQsXrBk/wLu6+t
nLSVleeNWjt1wGcc/39ZMPBnE4WGBaFrl16WHW12tDCACXl2ZAD77fBR1WsX
ttTNvns47XDY0WyHzQ6rXXoikbV2OQqifz1LbCiyocCGPCtySGdkNEn0X080
I96EJyY8MnLGvVePO3W4ZcANgvVKDS5V44Ie56vk/OIE8e6xUhwhT2F/EfYx
VAuxp+AL8e0P99zBjpvYeo03svYiVp7F0tPkbR3FzEOYuo+Xx+/AB1swmrTu
wBUY9BkGL8YgBu1saGfAUlxXmVa+b/kx9uuKiVsXf7iReQZcRfzHnGH/e6r2
/+gJ2nSmFxxy1mpHux2tDFrCp4WdjgiwYi8/1Rm8DFuPg/wDB1wOsQbUt8kB
iwNmB4z0U70DBgdqHai2o8qOCjvK7DJemU9qI9uKDCvSmpBCrkO8GU/NeGyS
c4M79bhVhxsGXCcn4XKN9NTiKnG6AicocnCsDEdKcYgA3lfE0Y0t7Mqzb74Y
3ddi72HXbWy7yVtYdxmrLmAZmbX5JzDrCKYfVOzsaFK+g1Zj8AoMYfAuwsB5
0M6Cx2DLeZizZ8kh9uuGmXtWTNzGL3v/8KS/LB77b7M4sL8W8CYTL3KEe7Q5
0EoIsWOQsHWIx/gd8PG61yFofdvpgN2BZgdsDjB0Gxm6Tpic/N4GJ+qcMDhR
44DegUoHyh0otaPYjkK7Im+ZNqRZkdKEpEapVwW890kz3K7HzTqCV0S0Ltbg
vB5nKbp8uhInK3CcUGYQHy7FwRDKRYRytxk2IoNMIzLONG/vvovtt/lt669i
zSWsIOO28BTmHueFqQeg24vxpHiHb8KQ9Ri6BkMY+y5VvG00+x7GPT6wknPu
9gUH103fLfTC9MErJvwX97wG/FSn/XWVjGt0ONHulNBGtDoRwcF9k1UCTgho
fU54CT2PE24nnE44nGh2wuaE1YlGJywukGZ4u9qJKicqnChzoMSBImo0z45s
0tvpNqRYkdSEhEY8Jev2kHC9a5TI979qwGVSDOerOaJnSNk+R7QsDNFiQrQI
ewqhnt12z7m0XtNvzwPsuMsb2Hgda69iJRm2RXGYd4q8hsP45AA+jlX68/56
DFnNf9AuAZo9njrbuV0XWfXg6pOxnx3bPGcfK3/28da5I9eywsd/WjTsn6dq
f2cQMy6Ga5tT6FL2HdHiFI0GnWDAaiL87NDb55SaVCDrcsHhgt2FZpeyompx
8yuMbjS4UedCrUuuHJfSnQUO5DmQY0dms8xFSLIioQnPGvHYIs2YkInrdbhi
wKWu4FbieAWOEr6Hy3CwFAcI373FEtwuOWAvQffN2EfYeZ/fvukW1l3HajJq
i89hAU3QZh7D1MOYROGEsTsxYpu0ZgNWQbuc41uTXXExlicrn9xy/uCa07yd
WXvXTtuzePxmTsufF3/wu9l8MH5nkDG7dhfNDtiRc66mN1e7LgiIAy746Wev
S4yCR2LXz+aG1Y0mNwS4JjcYvvVuGNyocUPvRqUb5coIfJ8D7ECmHenNSCEN
zAFuwpNGCfAdE24ZcYMCjlfqOMYXCOa4apzR4xTBzDGuwBGCWY1x0RfC+Ed7
n2DXQ3775jvYcBNryMQtuYCFpIE/PYnpxzCZfOAPYzFmJ4ZvI29sLbSrALsn
6346q17ad+187LXjm86x8q4lxzbPPcgKK6fv+XTYat2fFnGMmYr4Xa3QEAxl
BnErwRjB8I0IusQszMdOvet1Kz6ZG043HG7Y3WhmEHvQ5OE/WTwwe2D0oN6D
Og9qPaj2oIp+KnWj2IUCl9Rc3+Uo25HSjCQC+ilNox9apG27acT1BlylOfBF
A87X4ixFbk7rcZJQPkYoH1ZQ3h9CufiLovzWvmfY85jfvuUeNt7BWjJ1Sy9h
0QVemH0aM05gylFenrAf42Ixaqek4S0uv3bP4/OPWOXW8btXD93morXx4qG1
ZxnSrLx84vaFH3BPePwf5nFP4r+M9PiINrfgYAY0Z2KCWzCx3w2fW7bf0+MG
Q9rlgdPDnsOkBjYvM8n8t95lHhS7UehCngvZpCHSQnAKn/1RIx4Qnrcp/nit
AVcIzwsGnFPwPKXHiSocp5jCkXA8S0X4U52T+RIc/2Z/PGKfYidBueke1pNd
++wKFl/CArJrM09jGsUUdIcwntyyETsxdCtjVZez1pxw9Rk78+j8k9sn7rPC
2d3XTm3jCuLozmsbZ+1fMWkHK0/+n6XaGHIa/mgSs7oeDMpWN1qIM4McuQA7
9PRTXfCr1wOPh6Mo7uht8/GzjT5YfDD7YPSh3geDDzU+eUVUoVuimqH4Gc9s
eEIceo8QvUWIXm3A5XpcpJUcBmccIXqyM6Jirh3J2VJwptoreOMliB5IxN54
7HpKzPkAG+7xwvLrWHIFC8mazYrDDLJmE4/io4O8MHoPhu8Esy36rBJWTbmV
nHiDe1aXTiRcO3LvfOxNVt638vTuz45zJp+wderAZdoY6ShI6gWiXL+6mfyz
UnSAJNjvgc8jARUc5vLC6YXDB7sPAtUmPxr9MPth9BOqfn6yyocKL8q8KKbb
89zIdiHDqXhV8TY8teJREx4oavaGCddIx16qwwVybhm2p6txqlrJIztIcwfG
pftI8AW8u4vQPbrd5T1qfnwwGXsTsTueN7D1ETY+4IUVN7H0GhaRNZt9HjPj
eOGT4/j4CJmyfYxZ2UTJVZyYw6o5j7PS72Vyrr2QcP9sPCtcP/XkxNbLB9ee
ZeU1U3dP1PLp2Zh/mzX0V1O0f22ivke3etDiQZA+AtYIn0S0p9cLtxcuH5w+
iWuzX4QiND30flT4UOpFkQf5Hmmz+qU4kEAu12MrHjThLvkCN8jZukIYXqjD
eYPEre/RShyhhZqD5ThAGO4rxV7CUAC461UxFBZqXxL2JBCAT7DpEdaTR/DZ
DSwhUzX3Ij49xwuTT2EiebQfHASfZjpceU/yWbU4uSj3aS4rJN/KiL+WxrXU
kQcX998RTLps4nZtzBauPf9r/sjfzCS/s6dAr4WgY3zJ0PN7JSf18Hnh9cHj
g9vHMZR+VXMAtgCaArAEYAqgISB8g8hSH4q8yFOQ7J1kR3wzntCs9l4jbltw
0yQZUqD3BuO/E3ocJwN0uDsY91BwQMDYZZb1YhxpfL+z9Aa/ed5lzL7IC1PP
YBLJ9odHOGb2mnpWrs2r1OdUskJ+QmHO0wJWSLyd9eB8wu1TT3hv1p5d8BH3
n2YMWzXxrzxoOOJfZgz8RxGfi9b+p0FD/1q9pCy9iAh4xUSfQeijkz4fR1DM
LVx+OAP8pD2A5iCsQTQGYQ6iIchP1gRQ5Ue5X0Ev04U0MkMcQxseEowcQ7Ni
j3gmCenKM0yYSVce1+OYAuYhMj0MzH0UiWVgxip4MjB3fiE8Nb32pyE2BbuS
SHM+xUYySivuiryGr087h8lxmEjowukwl9Wygrm8rqGEFyqyKkvTK1gh7X5u
0i0u3tePPdy5lCvMyQN3zRmzftqQFaw87vdzh8n4oaa39i8mjfKvxQuGbYDw
DPi4/+8TVuRNjx9uP1wB/mF1RxD2MFzZmbogGK6VfpQRb4pxS3ci2YF4iiww
WBlrUmtfu9wgufMsqciTxJyswGWczM+hcOYkVPd0hlQdfe0eUZqp9t2bit3J
JOnx2EQWafVDLL+LpWTm513D7CuyXzwc6nS46vnSqqOusbwmyAr1JQ3sWJJe
WZBUlvOsiJUvHbq7Yd4BPizTdi+awMV82tBVur8sHvO72TLXYKBVIip806CC
KPtwTAXn+uHzw+uHJwB3ACKHp8KPEjJH2W6kk3PF0GNMSf37+nWS6kv1ENzI
Uxu7ciNJ937GjQSgRI9pyDD0dhR2XRd4/cUI/mRvOvakYieBuDkeGwjElQ+w
jMz6wpuYd50XZlzClPOA0wYXz3xqaXYGrE4OZX2zrdbGCoaihqo8LsppD3JP
777OCtOHxq2dvX/Z5J2sPGfshqmDOX8yHAf/cjIraAdZpWUPEnbs4xcyHsHQ
0/TzETOyf27iQVcLHC2wtaCphVcbWmAIoiqg5E7kepDh4gwp2nzvhhlXKVhy
vg6MEc/UKiqTMWKVZMSDFThA4s3QFFA+l+1ikm3WFwanerVKoKnsTiESIHIw
KePu7/akY1cqiXgiNpIdX/MYKx7iMzJDC25hLqnU6Zefw8nNq8ev4bFQn7eJ
p61Ya5tNlY2s8PR62qFNF1hh/dy4zYuOsMLcD3Yu+phHWsf/ccGEPy0a+a8z
OZzDHMKOB3yyVwHycthRZGr6gvASkp4WuFvhaEVzK6+aW1DfgmpCu8iHXDJh
DEihbe82kqpkjNkgGZNBKRjzmF7OijhX8nDNC3DqtM9AnbEvEIvNwK507CDQ
NiViA4G26jGW0zRz0V3Mvy2UYhOPuAvEPBwlTpK3jfOjs8Vn4wBW5tXeOR/P
Cp+OfLB/47kdy0+w8oYFh5ZP203QbZwyeLmGW6CZ2pFuYZ+1Axs1yj/SjApm
UYEA/EH+8bWgN/EZE2BmmkNeYs975BxeM+ISqb04A9kQ8gl6y2TUkJyWPJdT
6RnsKJRjtb0A2wq67jN5FQQp1/Xvd2dgJ+3A2ZKMjYlYRwiufIJljwjBe5h/
Bxw+VzNxm1uBr0XAB18H/B2sUJBWfuXEA1bYvOjBke2XWWHJpOPblnEQpw9f
vWTS9lmj17Hyh/+1gFkZ7Sg357z3mwVaqb/VcQ72IyjwiwgyfusdCEoafa3w
tMJJTNfYQvZarCgxzzvdIS+6rcjtOYPwh/oLWWWCKmR1b6nkuj0lnQR1Bx23
F2I7LepHcDgjtxYg3Lf+gsjSnoAf78rAdkJ2UzI2JGEt+ZUrFGQX3guD1RMG
q49gJUztJlf604KLpx5z6Tnw4OTeG6ywe83FPeu4P75iRuyqT/dquIrcOHng
8g9+P1dy5UhXiCtT/lUn9VyQ5LRFwa5PkLShn6BlBSbSwmSXeTvyXB3iHjHR
piI/vM4QlYZEQTSWGHR3iVSSEtFCmYG7nbiUAbqVoNVEbM2Hen/Oq+BJWbn9
d2RgK+G5MRnrk7CG8Fz+FJ+RMwSXFW4JJiEZYLLHn8mhfJsVjNVNz+5y72fb
Z7lX47h7uXb+tVP7b/HCvEO71sZtJB25dPLOWaPXs8LYP8wf9ItPpKXRDrak
/IYzaUtAejGtQbS0oIXAC7TC2yqscY8KT3uuo02gdrVe5hVGCtj2KXv8IkM8
KDk5xISCRbcVSOAEjlvz5ThsycfmfIlHGIb9Xh3DTGzLwBaCcUMy1pFDufIZ
lj1l3GhhGBKATomhLxzDd1mhqqT+0R2O4fmjubcvJbLCwa0Pzh/nYr9jTdzB
bVzsNy89vmYO94M+Hblu4uBVo343R8MzATl7a0c5pe+T8i86QVF7EBFtLXIG
42xpt/hbiWR+6ClcZ6H7QghJBLcpvCXrgsU4fAKzLYTZZgEYp2FzHtR7kfp1
a4/DUfs2WZntmdiajk2E2vpkrCXUlj/rDJnXQ5Bx5xD+diHAQW9bYXYVF5Vt
1QmP+MTwSGzi9QspvLDnxrHYmyf2cf7bu+niFtKUSybvmjmOG2g2PdSO9REK
UamEVUcQ7S3SurS1Iiik1u8XyO0uDEgK3iTqQxaE/duk5IFGstKmXKKreyR6
dUd95NYMbE7HxjTpIX0Xrka4bYJqItn/nOoAp9ph82anl7PCpZP1qYncNz53
OuvJAx5hOHfq8fVLSaxw+tC9Y3s57VuWnVy9LI6zy6h1Y7RrZXxJO5o3zSmX
+SGkrdrp6PZ7KA1NE7khVxk3cdfGXCk/VP/+K9EokNhMewA2pEmkfgyniZFJ
NNrhdUky/URmQJJpqufq5tp1S2oCn8revl1y/3YxK9y5mXHzetq921xOrpxP
PHuch1P3b7u6ZTP3bRd/smvC2FhWGPqrqVwkxvn48QOPoDNNkQsa8RbNN2i8
BVHrc8A+P3olqmg/499uTMf6NKxNBVwmuDuT4/cTLW2MHMFd1VVmVniU0Fxe
zlN045Nq8vL49PFZfPGzZ4X8pwd59+/yQTx/6umpo5yonWvPrVvM+XbW6A3j
/7iQCPGLseiRHkaJz1Wv+TqN0LpsJRf+b16JDtoR+8N1aYKCJv6Dl5w4Nr3v
TAFTxjVGOytkFXJBzCluzCrkM7acAkNmXm1eYR3np7SKhMRSVrh1M/PCXR5P
PLzn9tLtqaywbGqs9q8nhf/VQ/sh11aCgoc/05Hqi1ib1WWvqZqGvt3SQDtj
/xYuMzxhBPgZAQFBAD8G4XTxaklD0GjmhfIGd2U9H6nyWltJNVcyReXm/BI+
NMlplc8Sy1jhxtX0c3FcmvbvuLlpGV90+nT05rH/Plc7kkOgHR8UEhup/dCd
9Cvdo5/qyBBqIldnYk0W9U39fpNXo4hGpTdcDXCbiaJm+EgV+H1EUauI6b9V
7+CU1DV5a8zcnpTorfllfEyScxuexJfeuse56uzxJ/t38QDZ6lkHZ4xYJ7OM
tTp+Z/I/Kd7LhRiFm3jLEasyoX4DyRfoeRT13CJ6LnLHECQpIP1iZ7NFZeZo
p4IzKD3zt6ssnMKiSmtGIaf8QZLh1i2u1tdsKdyz7uLkwVyRDf0nSg4cx5WF
VsdHV/uJzNOMTP4lp+MeGwk+K4hYmQF1rviL6eAtEC9Fwm2Eh/dfRqJ41DBA
0Ae59URLRxuZB38LRIEJh/D3pNfH5iWCMD/sfiUGnVdiiU/nYnLlaumZo09Z
YcPck1MHraRoXm/tlFbW+fhf6O7/lJNwlgZkeRqWp3ddA3i1sSD9/CZcdWJg
ef6pz05cRJaUzQEUasS4iGNEB6Oor4aMQVuLJK6FqGF3BMjL9fh5vFmsNl9P
R2Ymf8Sq2RWnY+9vmnVI+L/akaR4J/Jx106n4wx+TGFE/lzH71XH574AVVzZ
sUHqlqqOYBsR0yFoaKcBYkcxUq0t3K0UIyUnQBH+gGA/H8WGNBTV9HgEfT0u
nrU+upHHSif3Z/E1ZuFvaqe0S3kRGiDhH/lw3YkR8qSmTG1TPme8QpQRWa6O
ANeW7cEWIqhDGOk2hfUiWlvl6rbCg4IsxoAyUBPh9YssJK8PXhG1ddO6oTJX
jqos4IrTXes9tPKsiC5oP2wV5Gk/5Thq5/LbtPP4MeHnuic/49Rel9Sq107V
4/jai6n9Mdz1RKpFUNvhdxOpwXZizTaF2tZWeRTzAeacBVqkAApB49EGhTXd
FGdxe+GmiInHBbHM77fzvEGhJ9AIfy25dCIHSjs1jExKBdculMcnP9XdjxFr
Xeo3Cb0apeQr/IRvRSZiO7yNHT7u3rUHOMe2BVvaiWNbiWNDNLYoPiib/PiJ
WF+LEiei0CUruPy0bMEKXr6+zgsuuGnG7rHxhGgNbT2TM1LUkq78q1M7jkj7
lI6UhKldKj1f7TJeffpT3YMYHddan6c9X0JxH7hqO4jidi9nrza/q404uYXG
NqKF0RslBlMQGsEo1bynoUmzjyj2tMAjLEVAalMnkevwwkFj63DxfCMHhbpd
TcwFI8Aa0GoQkfseIpV/gEjuX67EhrQicUccV+FhjO4uG2GuAtS7trqnt7eK
Xv4+FE2/DoXeNqK3xe9uJaMRJHqDLR1CPAWdbws6NRR98bZKat10hSsoF1Ic
fr6ixwp8MZ/Gt9kpLWWUu1a+tqSjQL5lboCO59az0mAaxIFrxTpRj3sxupsx
uitkUE5LTlbv9Xs1OsmX/2aHU9/hMnA6PZZWEtsg6d5gsCVAnBwgTmaD6g+b
vXMhVYIhzPC7aFwdQTgCcr0yykrLknzDiUnE5SOHzVXmH4I7h27BkK1Em8wP
6qmlqnYLHTfhWozuotRKmqjDMc895M/zw15C73sdzuo2MqKtXu7it/qdQeJj
f7A12MLp9RO9jEyfMqCCTHcrXFRwtoC5OGQp3rL5YCUl3ORGE+mlRjsslNNi
NvMdoKxgquIvzTHSxNr0RHLtuwO0dkHMx7RlbcJWjN/OC2N2YRRtt3h/D4bQ
5rYBVNXugpa2umi343KM7nyMjo++4JUdYdiA9s/+rQqRPi9G5KvtDBE3R6SF
EPH73UHidF9QwiHE9zlnt/LANh/4VoHC281BvsbKh9uPJh+aCBGLm2djsoLR
hgbKnqhrQK0BNdW8XF3I378mV1Y/JbM0ZwNmUwrT9L2Ysp8XdAdlXsOYgxhF
hfcPKPpvEKWQDNyLAbGEym6cjNEdjdFpP0jXTsgRdl3MBLvjkJfg8Va7q4Yz
vMccJMn3kTj4gi1ewsPb0hHi/+dgCG5gvnAzYWUNwkqA8DwTL8+K4ji4UE/a
3GDlG4JYQV+nZFonXsDDg+SE0JzjjWGUcDDkMAYd4oVBBzGQsukG7MP+GN2e
GB0bckbN+hjdKqkD1PP37in8NlHY5qhqcfHZasBjCZDMe/1cBrzBVg+59h6S
AW/YQIudEvZWsafN1sIXLjl9AVjIyTL5eOJXA6m1OidE5nh1aI9DcRUKKQqa
mY6UeDnub53Z3nGctsXEnsQOyhxcex4rRRbsecylwoxzmEpZBLo4TIgT+/Qj
Bh4VXm0ocKMl7tAe7Fgao1sYo5sbo/s0Rjc1Rhd6Y0e3yHCaaMzfaHPqA6QF
/TRT8PrdHpIBtxjz1g43ISJ1gFjpcSihYBuNeVMLX8nlgh+Ayc8TizgUHhhI
LVTLXKKeZSaUUCJWXiWyKa6ZkKrs3Ni2WtGQxE/fPHaV13ffwNYb2EiLWSuu
8wQVVph3lS+5ssK0y5hC2UC6C5hAOWvjzuEDQmxUHEbGYcQZDDuD909TsIfi
XZFDzrQPiWsbGtfWZQXzJVzTt9WpD5Lm9JOecPs97gB3ulyCZVo7pD6I4Ate
fP+BtVWuIlqCPPWCFRooL6iO9EONG9VKPmCvclKZJWYUGZFPC9rpZUiWkfHI
aw9whmiU/nn+HV65/1Dusv3aOlpDXXYHS8Ry9E3MuYFPCbBp1zCFAJt4BToC
7KPLGH8J4y7hg4sckjGUbhEx6oLwu0eexwjiuxEXMJwKwy+AlUU/o0dcxEjq
yZgrGHMVY69BPTt4CYKvBZxcs/g8Zh9pFhcFAFzBNichGOKsSLuyaKiJYBgS
y1taYCYsjUGew8K1iA+1XtR45cytrBklVhSRXsmtR1at4Leo+/Rqk/P3cOSS
eC9Lr4xU/ra+O/QavLhkHKf47J54sfL22pw7mHUbM28ReDcxlfIhP7mBSbQ8
TRHjj68L4Cdcw0eELTuOp581kfybBx0+uoGPaAAm3MSEW/iY2tPdxsQ7mHi3
6xy4d7eoURS+T9BR6XVybeXlwHFt5aRgFkPN0SLWXt6wE1w2Oja1orEVFkLL
FIRR5FYEZDpajZIZ1LvcxbPXWYnvaWlCLq2/ZtQhRXlXVuS9PNzIwKVEpb7u
CGZvEuNCda+yrijz8e/Tu4UuEuJH0vgbUlhheyI2J8i11pVPsPyxzOHkccop
tzGFWDbik9tCKU66DfGhVvk3v3jSHYgPH4u7+IT4fcp9TGWfB18Izd5+R5XX
aeACS5rO4fc6SIrtwQ65k0eoM2sLmghOBqSpBUY6WR9EHTFfrR81cvW2T6UH
5aT3S5wosqOQHL+cRr4RM61eebtMBe7TwsTlDP72Nonf2tOYtTNMruuqUVL1
vP5uXB5O0Evt9mVgdxq2E54bkrCO3jG5Mh7LnmEpJVIseowFtFA49yHmPMTs
B5JZZ96XaPe63tBxqY6nvp6p4ZkyR0VqQnnobaKviF9Pr0PvIS3o9nAtaPf7
7IGg4Kj3rEraxHNppQXYOmJBQ4Cn97CCnhixkrRgqRslLhSRo5TfzHdVZckM
nx7PKJniXjluFeOKsirRY98jbL8l2e6DDZKXe/ko8a+a/M20GjyjVKDrpWK3
Rv9dmdiurGOtT8FaSkJZmYjlCfiM+HLxMywiHBc84Tpx3hPiyTmPhU6c/Qiz
6MPKd4yt1+rbLxg6eL6riKnsLYVYc5dZMa+GJq369vTYK9wOrhSdbrODZLuZ
ybbgw6YgN7nMplpCii8omdAQRC1BWR2AXvJh/3IvSsnRKnKh0Il8ku1sGzKa
kEbwJDTgaR0e1fAXLLDq1SL+7h5hebfcwaorzzmvn98Bq7IFMdvIN76zwu0q
XCEn5gxtuD5SIL23fhvT+dl1qViTgtWkV1ckYRnp1aUJcpFlEQM6YqF0fRY8
w/xnuGsM3KgPylnsiaq2Q2UyDLWLgHy+WicWMjfndc1sF9j2UWFLHk8Pl73K
SXrT7m5s9jYLTunbGGi3iAUZRTUKPLlQU/6ZPiB36JWRB1PsQZGbMveZXXEg
245Mm5JbGa+8XuleNW5V4pp8l1TkiSz+Cq098Ur/F1xQ9KRAu0moCyVXvd+z
Btwz4AZNDM6V4xQtZB4uxIECvgOblXfmYFu2MrNcmYIVKRLViM+SRGeWJuGB
0S1n09sLOrbmd8gnbsyVY7wuBxIfdeTnJShGOex6O+lLq8cqJLCRViJMgXYj
4aiJqJMRR8aS1YQfK1fJle8+pT6UeFFMwl5AmeU5TmQTb6Y3S6SfmfC4AQ/q
cFfs9a3k76VghVP5CoK7krCFBFR4PFF6N4qpjWSLaKPvtRq5ZfVkGY6W4BAt
AMfmYzcBuC0HW7Pl6GzIwPoMhEaj0+rnU5NdjtGBEmWNVNTXZvFVEKUeycpq
z6fXi1GMtNmrNXySbBH09DX7fCZaBq33d9TR4m9NQCZHMfwYeBVSqt9g+BUT
IxZQ3nMesU6WE5kOvoMklYQ0sQnxFjxRYmORdwy4WYNrVYpffaIAh3PAjIis
i5w7YmFCIM3G7xdnbijvnXvjdKU8dbAY+wjO3fnYQXBuzcHmbGwiPNZnYl34
mxJXkzJ42GAV2YgrMrCS0GbHVaFCZpfsy+7Ro7ytt6zNlY2OWtEZk4fHDRq8
/jrCr9bXUUP4Vfl55igrVIi8XMF9DLpCLwqI+3Ip855Bl0HWJtUuczPiaXL+
2MwECPcacLtOysv5CsSV4mSRgtpOoeVCUj0rZlk4itH3TLjVICE7V823nYmo
3b5i2hDJpDgf2xU71pPht5HeKbc+i+PHgIg3miR3L07GkhQsJU0a8Vmq0JnL
0rCMLNiK9K5vtngJem9YmvVmB4/kNbhs9W6+nFjr9dd4eQC+ytdR6ePolft4
0m2pT3lLZFEINA9y3MgirmO4pTmQYkdys4LB0ya+/+5hiPNu1fMNo1cV2xh1
vBiHC/gbOfZkSzRmxcwJSdsDNnfvI66rUHitVPjzUbsoQ2N7PrblSR9qU468
5ml9Qyhzo/fsZ5gTj7nxmEcZPguTsIjMOwOQxkWdkfUSpPoZm2vEEwyu5ho3
X07VewKVHh7wLPN2lHo5UiWK/xyZT+nzOR6F9gzKAU9VckN7PrXicaPs8l0T
bjfgRr38LTKuEqfKcbxUiX+KbBH2b1bMZCFJcRTTuhCjYwXRfmyMbpsIdIl1
2ScGg0bMSMguRC5J6eSNRzLGYQzDCVPn+70EA+4s1tp5OrfexQWtwh0odwdL
CYNiT0eRR3rJr3FdJKjXaDLdkMSTZCU7kGhXOOBhI+5bwOk3ynG8Wif3vp7T
I055N3LUXooP7sjG1kzBKZEiqndQiYBG7qWoDxX5oddcqkyJ0X0coxtH5WEx
ukEi0q+J1IZiggLPWU+lSzwvXtqBhUmd8IpaquDHgFP/fYjniPFrQ0hVN/O8
7kqHrdzJV7RLXC3FrtYiN4+Z5LuVeRYTnkwXAURORIoDSQRQgvLmhqjHygag
exa5chHaAXjZIHzYqKNlOFyCA8X8NQFC3zAKpxGRa+i4VUR7ND3WKpTPj9HN
YmWuUyK0MlgqYRFtzo2XmCxIlM8VsqMh8QlxUbj/H4ZJz265iLK9e1dZDRXN
nItKHY5iBw8gFjjb8l3teS6Ff7IIknRimBTK8ReosOqzZjxVNEzPh02yR3fM
uGXCDQJGZo3EVeN0FeTO3jLpH0ULEtlxMhWWKvKzMka3LEa3VOGn1xk20+mK
CTG6D6gwNEY3QLk5/Chycp/7CUKGGb9Imr/76sj0KrPWl9j4zLPA7sq3+3Id
XA9nO2W0gmmPEH+IXnMwbHis+JxR9xpxx4LbZr49R67pKtvEztbgDPMhX1f4
f6wYa9HOfKosCEnTTIoP8mJfyR9ifSXcG+KmR73a+xLaogutpnwbn8RkN3uz
moMZ9jaho5mpTbYjiQY3vhmCpCc2PLIqupRTRZuOpNa4XI9LtLnwvEGunuwv
gdhGLL3gj6nz00gGhKc0lUZ8Ip1n4zmKCoNfMKRENdElGLzLX2d5CZ09cpoa
s6z2DBvn69TmVjky8TY8I7Iey70WkfebcE+wr9BxV4243ACx94J4qscR2vpz
sAwHxGa+kGSLXmqJjHFSsqMZbTpFuAWFwoMZGHa9KEQoPCBHUkTZl4Vk+fNy
k7qnnuxIVGajOb3RltrkSm7yiefEWzu4sbMqc/QHTbjfiOdjKvTSdROuGXGF
MLhYL2OX0XzHKO0qE5vzDpeL8e6EAdPrIxWaPorRjRf6Xqx1D6PrBoXRrjoS
bwuJXZ6m0P95K4YvGf3IRIszvtEbkqweDxs77pPqvmvhoimpvUHhtGsmiEEX
1PY4XUPbOOkf30nXr9txEqw7VpHV6BEEgbhCXEv6PCqc0khVS+q/UdQ9ha91
N8I9Hps5eQ/MrffMbXfMMis56oYJ1418CBlFQlecqeXbEE7VQO6+eovOajtz
o+hU5FCiYXiIJlZ6X+nsALo2svPd8hjdDS1qWY1+MS28o7eNLTeN7dcbOq4x
k9qAK7RxWUjaWQPiaiH2mnAiqkE0RGnD4I5Q8O4RIot9BssB0EQPVa4dqJAc
oRoPhQ51/sGr0SHsLlOE5wx8j5FYieLbPyJDnda8E9Zr0T8uRZGDwzTEgG44
SO0R8P7Kp345zOnvAb12qAIH2Yf2UuxXtj6JbXixpXxno0aNjoJxRIhfnrMQ
nR/EHZmBYeu8A0L8paYkUl1XUfblRoH/Ha5oVa+jZDVC1QsqKjwQ9byn8qre
ms7KutORM9nn5SB130PuhVCsN3JAJ1w780VUV+2hCbP/kYJTBkhiwvsbzj1d
Ry68J+r3JnTff55IzzsRnkXPn0DedeQksnUfhfyVMTG60XK8R0iu7sMUyFDF
yg9U7ECowJEkvgkfFX5fjwGKEEuqSOlEhctIRPio9ux+vNSjzrutHjk1b9Eb
PrtQzOuheUXkwhCXi0zLiTTDYSVh94SrOlqOV58hhMEQOjmE5j+hTjJqIgYq
dvM5T0RKLuCn1DSEeLQTd3AGUke7uqdM/QZT9b4SsZv2uSfOJuwxOuGaMnec
+aQzqDxZGeGPBQtoNB8S4WOozMzjCKHDRvKeDld89yGKDRlE6nkIHQdJmSKd
PPA5xd3JrHI+TP9rNF3e0tg95ep3WKj/+glZo29tidFtjNGtFWkLGs3yLijM
JhTEvIRNbT+hAuOACZ2B0JADOIZ8QDEbFrIwVMHifYUnyJGKCsmFpnuNFc7z
ig1+Lu//fxCgsf/G9hjd5hjdBnrCOgWHz2J0S2J0i6g8L0Y3hwqCG6YrDCGg
0JEwCCjGSb8uagQ5FuLD/XplnDXRA1SUdLUOIU9Z9vLV+Jz4Ouo5bS/4u6vv
xcbodilhmxDZq2N0TAKWU1lF9myF8unK9EzoQUGNGPuxihwwHRDBXcXIEc+9
DM7lg5RxDOnyAWGS3VPTVYlLCNRRxRdrL96+WtaJ4ncOxuj2x+hiqdEdCumM
59fH6EScYgUJPyssplSVcOGfHtLQujCd9yGXzHGKHhsd6nRP4uzByggPCtN2
fbqf83Xn+1CnP4duGlvpN6gkuv+RGN2hGN0BancPjfZ2ZbQ3UmENMfkKZbQF
ySIyFC7mk5Spq5T0iPG8j2ND/CtiEEKhDQpZxefWWmYQdkuxmse/HL00vv2O
xugOx+gOUtuCu1mBjfIWhV6m3FZLnat5fS6FoD5V9PoUmqILakPCLGJ3vWlM
hM4erPS5h9BbA7vlYJVJpt/e+/KU9T4RozsWoztCjQkW3k1lPp5inXM5qSlh
n+eSsAq+1VAggsmroI+a7qPQI8cvghPVM6SHBUmd/I9wqr48HcQnX2WSt1WR
vHWK5C3r3P05ytiw6nSKo0yl8eDwRim2IDo0IsKzkFIW7k9Eq6Tpy/WdfJ9v
nYnRnYzRHae2w8WKjcTOMLFaT+VVpETDNWhoUFh1hiJQvRV7x8xiBB8QDlGI
plDsJJzDns/0JI3qHLovQNPXz8XoGFmnqC0hPQcU6QmRxaRn0wvImk9kSdvA
G3+Nd6hvyPfVkN8XTkxIXLqbGakpUWfKRnZLyTcUSuI6UyJEZa8iKiE9sK47
ShbE6OYRn30oISZ1FRkKbdAIaXqGeC2cJkFLdFflpo5Kq0fmJfR842KMTpDE
fhDSL0jaR9IfUm3CcAuShOFmTttixVILFc15ixMSKcZlsFRTmuhhii8mDBUr
kCboo+I7FVXffmWqOGcTBu+EU3OccoEFNXspYVbw2VaFz9Z2pmaeyqLwLvKQ
jaKRyeLwLnOPajiFckIMSKMWJa4TVNGVPVRU0Qi+Ol1dcmXevRSjuxCjE1vJ
ToaNVkhX71BEKVzprSB7KyytEn2KYESQ4xA9SDEuIbLodx6Z6ilmUwM6yxZp
O/V+6Fejgkbpza6jdKgLz20N4zlh18VShnCGxpLXP0zSwp08zVfDYwyh4QlN
B8PHpivHqVcvvgA171yiTPyzIhlfoxH285Ci3vZ0UW8rFIMzXHAPOThRo4mi
EXSKizif4WteHxaSJI0mJFUixhautyVnfTkqiB/7v2RMhEu3Q7E9GxRd9qHi
jw6mjvOJKM1G+44IQ3+wYuRH0kXDlJAnaYre7yvEaZUrO8vK9z5HU0e8mKKv
dTsuBxV1IMxOyDXXkPsyiSaZH4SsPMObKzNN76EKJw0Mo4VdxI8Rw6WikG44
2VdVrOEHnzMygo5+3dHR7wKNzJnOOi3c+dxOFkfGlOcr7uVEWiQYK+aHfPKr
6T1AiR+NUkgQLEia7X2p6cJ8ALXPrB6NL0LFi0ZjP1WF5tqqUNFnDZn6j5U5
vxD60dRfrZAPTbSQmJHEU0PpJ2F9OtMQbvt/+KX6T5ru9W5H4UBY50PCIdb7
ZiqBKjFVDXWWw0yhlWhxVvR/CI2G4KQh3UZ1eVG9DvkF+t/7IuEf1wX/fQrm
r4U7LqsViQixyTCFR94Y2lmuRytyzW4IyfjgzjR08uu/HBWk23qFRkE4YCES
BO8LPyU00V6pxMLCfcMBUiI1UWMVaQjFEIaFZJh7ZeqIrVr3fKXbfpKM9A9B
fSJGuvGasKnilrBOrlLcjwVyjb1nOMM871GUihfUqH2B3vW5oAjiyS692y6x
fCe8d0vIf5hFfuskEsixxBkiVyDE4y/t7999zqh331+xN1wMufB3NGHetlAZ
m+jkWqWzi8mTE1t/hA4cQww8RMyyI7h27y26GgoUDwqfiXLuePXecrTEOzfC
ZwZHwsyMiACFIl+rKPaziGY0M2m6rFO0m+iSUBtCVYQmnCFHTOnhT74UntTT
viErH3JU9ijWUHRzrZScPiEYxZiPCBvz0Mr7ICXqGvKveP/+/sv3j+8uE6IT
biJE/0IaSvi0PPmH1sp7hozAsJBJkz35h24k5SusynvQfS/ITnxXdEE4QoLl
NBQICXVhpSK3KskYQcM1XpGS4YpnF1qmV3TQF+8Z6c7vhDz/8BBNODJCYLvK
wGClW6PCBFajrB3xtRDWq//1ir2a2HlnZfQxxSSGZiIiJ2UtdSkkliqGH6j4
8zJdRfgcQxRGI/sR87k9el2FE/Wo5xHqTriu2CiVkuZNIX2TlehbSJt9SNXR
isc9XDmv9IOn937+84nbex/s/PANxDKLRWxfzGk+IrpHKwpqgtRRGmVdZ6ji
cUqdxP+0GI+z8BSlH3xuL8gm9N2nTEIE/Uz/fEYRsNk0JfyEuDaKJFksp4xV
lM9AQfWP5PPekN/fCXtu12eS5nwj9MBNxJLLlQdOC+NHoe0ozkupLKNCGk/x
/PnTvh72/eKnkjbsH3rkevJgxJx+pkLjaIUogXLIBPCnfVNi+0P5tK++9Gmk
2/qHP2o5aXRBoI7GdDhxzUdhcIr8nHflE34ahuqLn0Sy+LpwyFYoFE2nZ4yl
RnVhioZV35Z0/Fq23uelrfM+aF4T+mIOKYsJNDJDw9rlUq6M/B/kd4+XtvpL
qo8ibUNFlfT2lK1o5fdXZGuiJc77/8IviwrdIWkaGnZ916cqFA+VV0d3e9Uv
5K/hf2N6kLyzb7d3xMhfe6qo+LNsSfxdqje6kf/oiV3/ru0f5Pl3u73r+/JZ
6vW338q7vt3tXd+Sd6kznP8Zz3m6611fk7+qY4c/l+d/0u1db8lnqWdSfy/v
+lnoLj6OfeVZtTf1I3n+V52uVvjip6qrvyvP/+Z5j6I1St6AGEauL2lUn/dU
/QZmtX/8ddmHfw+1Kt6jFWpWzEOinregedGZsKeo13/V6wCKfP6Rbudj8MaL
2+10Rv1GFvWT+6ie1E8+6X/o9r8Jf1J0eLtd6SDv/UVPkzLTS7Y+hK7/J3ak
XeW9Qm2GNz5R/PVWfv1IOsOlgGducBEfR2eu0JHzPSd6P9XeVvWJSyavrqd6
X3TNnOFFtfxyPuDc9Rnd9Y7q1x4vaCW6C/6vyafP6LYdtZ/W9X51jKqnfPJH
Ico7X6+WvM9vMZxDNKGW35b0v/mF21Pv1hxPl/0Iz/96/MvvV2eOfkiX/Uze
r0as+6t/K6/u3eVpgro/y98n4DkXveio+cr/A3SXb7c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196083884]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2883],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26798],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->32179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31635],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/RegularizedGammaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/GammaRegularized/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55337585],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->696577411],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->791390846]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GammaRegularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 53.7526052}", "context" -> "System`", 
    "keywords" -> {"gamma function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GammaRegularized[a, z] is the regularized incomplete gamma function Q(a, \
z). ", "synonyms" -> {"gamma regularized"}, "title" -> "GammaRegularized", 
    "type" -> "Symbol", "uri" -> "ref/GammaRegularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6822, 235, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->354131725]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 310801, 6308}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2231, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2854, 81, 54, 1, 70, "ObjectName",
 CellID->27616],
Cell[2911, 84, 702, 22, 70, "Usage",
 CellID->29876]
}, Open  ]],
Cell[CellGroupData[{
Cell[3650, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4128, 128, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4251, 134, 374, 14, 70, "Notes",
 CellID->5220],
Cell[4628, 150, 1036, 37, 70, "Notes",
 CellID->14615],
Cell[5667, 189, 395, 13, 70, "Notes",
 CellID->22348],
Cell[6065, 204, 263, 8, 70, "Notes",
 CellID->94447958],
Cell[6331, 214, 234, 7, 70, "Notes",
 CellID->31226],
Cell[6568, 223, 217, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6822, 235, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354131725],
Cell[CellGroupData[{
Cell[7207, 249, 147, 5, 70, "ExampleSection",
 CellID->31696146],
Cell[7357, 256, 44, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7426, 260, 117, 3, 28, "Input"],
Cell[7546, 265, 176, 5, 36, "Output",
 CellID->16653571]
}, Open  ]],
Cell[7737, 273, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[7867, 279, 461, 14, 47, "Input"],
Cell[8331, 295, 4156, 72, 160, "Output",
 Evaluatable->False,
 CellID->35311048]
}, Open  ]],
Cell[12502, 370, 125, 3, 70, "ExampleDelimiter",
 CellID->292579203],
Cell[CellGroupData[{
Cell[12652, 377, 253, 8, 70, "Input",
 CellID->671466948],
Cell[12908, 387, 1254, 39, 56, "Output",
 CellID->451472254]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14211, 432, 200, 6, 70, "ExampleSection"],
Cell[14414, 440, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14489, 444, 198, 6, 70, "Input"],
Cell[14690, 452, 234, 7, 36, "Output",
 CellID->556817691]
}, Open  ]],
Cell[14939, 462, 105, 2, 70, "ExampleDelimiter"],
Cell[15047, 466, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15165, 472, 145, 3, 70, "Input"],
Cell[15313, 477, 229, 6, 36, "Output",
 CellID->259940413]
}, Open  ]],
Cell[15557, 486, 105, 2, 70, "ExampleDelimiter"],
Cell[15665, 490, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15756, 494, 215, 7, 70, "Input"],
Cell[15974, 503, 269, 8, 36, "Output",
 CellID->9887474]
}, Open  ]],
Cell[16258, 514, 125, 3, 70, "ExampleDelimiter",
 CellID->170367886],
Cell[16386, 519, 203, 7, 70, "ExampleText",
 CellID->420429012],
Cell[CellGroupData[{
Cell[16614, 530, 174, 5, 70, "Input",
 CellID->329617373],
Cell[16791, 537, 344, 12, 50, "Output",
 CellID->795116114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17184, 555, 223, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[17432, 565, 238, 6, 70, "ExampleSubsection"],
Cell[17673, 573, 86, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17784, 579, 194, 6, 70, "Input"],
Cell[17981, 587, 377, 13, 51, "Output",
 CellID->238637647]
}, Open  ]],
Cell[CellGroupData[{
Cell[18395, 605, 216, 7, 70, "Input"],
Cell[18614, 614, 1080, 35, 77, "Output",
 CellID->181282440]
}, Open  ]],
Cell[19709, 652, 105, 2, 70, "ExampleDelimiter"],
Cell[19817, 656, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19906, 660, 122, 3, 70, "Input"],
Cell[20031, 665, 158, 5, 36, "Output",
 CellID->433657094]
}, Open  ]],
Cell[20204, 673, 105, 2, 70, "ExampleDelimiter"],
Cell[20312, 677, 214, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20551, 687, 201, 6, 70, "Input"],
Cell[20755, 695, 334, 10, 36, "Output",
 CellID->277290811]
}, Open  ]],
Cell[21104, 708, 105, 2, 70, "ExampleDelimiter"],
Cell[21212, 712, 207, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21444, 722, 306, 10, 70, "Input"],
Cell[21753, 734, 1578, 47, 95, "Output",
 CellID->17491973]
}, Open  ]],
Cell[23346, 784, 105, 2, 70, "ExampleDelimiter"],
Cell[23454, 788, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23531, 792, 240, 7, 70, "Input"],
Cell[23774, 801, 1083, 36, 67, "Output",
 CellID->33254286]
}, Open  ]],
Cell[24872, 840, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24973, 844, 282, 9, 70, "Input"],
Cell[25258, 855, 2249, 65, 82, "Output",
 CellID->371983563]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27556, 926, 250, 6, 70, "ExampleSubsection"],
Cell[27809, 934, 86, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[27920, 940, 200, 6, 70, "Input"],
Cell[28123, 948, 740, 24, 51, "Output",
 CellID->22985760]
}, Open  ]],
Cell[CellGroupData[{
Cell[28900, 977, 253, 8, 70, "Input"],
Cell[29156, 987, 1528, 49, 139, "Output",
 CellID->669655]
}, Open  ]],
Cell[30699, 1039, 105, 2, 70, "ExampleDelimiter"],
Cell[30807, 1043, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30889, 1047, 248, 7, 70, "Input"],
Cell[31140, 1056, 2081, 61, 91, "Output",
 CellID->65481088]
}, Open  ]],
Cell[CellGroupData[{
Cell[33258, 1122, 246, 7, 70, "Input"],
Cell[33507, 1131, 3243, 58, 70, "Output",
 Evaluatable->False,
 CellID->364497570]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36811, 1196, 207, 6, 70, "ExampleSection"],
Cell[37021, 1204, 228, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[37274, 1215, 481, 16, 70, "Input"],
Cell[37758, 1233, 33018, 545, 70, "Output",
 Evaluatable->False,
 CellID->538749027]
}, Open  ]],
Cell[CellGroupData[{
Cell[70813, 1783, 485, 16, 70, "Input"],
Cell[71301, 1801, 36620, 604, 70, "Output",
 Evaluatable->False,
 CellID->15687340]
}, Open  ]],
Cell[107936, 2408, 105, 2, 70, "ExampleDelimiter"],
Cell[108044, 2412, 162, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[108231, 2422, 159, 5, 70, "Input"],
Cell[108393, 2429, 278, 9, 49, "Output",
 CellID->321500722]
}, Open  ]],
Cell[108686, 2441, 37, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[108748, 2445, 266, 9, 70, "Input"],
Cell[109017, 2456, 976, 35, 67, "Output",
 CellID->234497289]
}, Open  ]],
Cell[110008, 2494, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[110101, 2498, 315, 10, 70, "Input"],
Cell[110419, 2510, 6246, 106, 70, "Output",
 Evaluatable->False,
 CellID->11822930]
}, Open  ]],
Cell[116680, 2619, 105, 2, 70, "ExampleDelimiter"],
Cell[116788, 2623, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[116866, 2627, 213, 7, 70, "Input",
 CellID->34798608],
Cell[117082, 2636, 270, 8, 49, "Output",
 CellID->599458984]
}, Open  ]],
Cell[117367, 2647, 37, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[117429, 2651, 332, 11, 70, "Input"],
Cell[117764, 2664, 906, 30, 65, "Output",
 CellID->213545505]
}, Open  ]],
Cell[118685, 2697, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[118770, 2701, 394, 12, 70, "Input"],
Cell[119167, 2715, 15918, 265, 70, "Output",
 Evaluatable->False,
 CellID->459491380]
}, Open  ]],
Cell[135100, 2983, 105, 2, 70, "ExampleDelimiter"],
Cell[135208, 2987, 92, 2, 70, "ExampleText"],
Cell[135303, 2991, 336, 11, 70, "Input"],
Cell[135642, 3004, 74, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[135741, 3008, 839, 26, 70, "Input"],
Cell[136583, 3036, 158, 5, 36, "Output",
 CellID->382009446]
}, Open  ]],
Cell[136756, 3044, 72, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[136853, 3048, 293, 10, 70, "Input"],
Cell[137149, 3060, 528, 16, 36, "Output",
 CellID->29786164]
}, Open  ]],
Cell[137692, 3079, 59, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[137776, 3083, 376, 12, 70, "Input"],
Cell[138155, 3097, 24918, 413, 70, "Output",
 Evaluatable->False,
 CellID->200322411]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[163122, 3516, 217, 6, 70, "ExampleSection"],
Cell[163342, 3524, 215, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[163582, 3535, 334, 10, 70, "Input"],
Cell[163919, 3547, 276, 10, 51, "Output",
 CellID->771032274]
}, Open  ]],
Cell[164210, 3560, 105, 2, 70, "ExampleDelimiter"],
Cell[164318, 3564, 223, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[164566, 3575, 157, 4, 70, "Input"],
Cell[164726, 3581, 266, 9, 53, "Output",
 CellID->155422693]
}, Open  ]],
Cell[165007, 3593, 105, 2, 70, "ExampleDelimiter"],
Cell[165115, 3597, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[165195, 3601, 361, 11, 70, "Input"],
Cell[165559, 3614, 453, 8, 70, "Message",
 CellID->635278312],
Cell[166015, 3624, 980, 32, 81, "Output",
 CellID->73784309]
}, Open  ]],
Cell[167010, 3659, 105, 2, 70, "ExampleDelimiter"],
Cell[167118, 3663, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[167219, 3667, 429, 14, 70, "Input"],
Cell[167651, 3683, 226, 7, 36, "Output",
 CellID->172701424]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[167926, 3696, 210, 6, 70, "ExampleSection"],
Cell[168139, 3704, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[168264, 3710, 143, 4, 70, "Input"],
Cell[168410, 3716, 357, 7, 70, "Message",
 CellID->31160833],
Cell[168770, 3725, 187, 6, 36, "Output",
 CellID->54771668]
}, Open  ]],
Cell[168972, 3734, 105, 2, 70, "ExampleDelimiter"],
Cell[169080, 3738, 101, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[169206, 3744, 172, 5, 70, "Input"],
Cell[169381, 3751, 217, 6, 36, "Output",
 CellID->267731231]
}, Open  ]],
Cell[CellGroupData[{
Cell[169635, 3762, 90, 2, 70, "Input"],
Cell[169728, 3766, 161, 5, 36, "Output",
 CellID->81836250]
}, Open  ]],
Cell[169904, 3774, 105, 2, 70, "ExampleDelimiter"],
Cell[170012, 3778, 342, 11, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[170379, 3793, 257, 8, 70, "Input"],
Cell[170639, 3803, 504, 18, 54, "Output",
 CellID->201712771]
}, Open  ]],
Cell[171158, 3824, 230, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[171413, 3835, 157, 4, 70, "Input"],
Cell[171573, 3841, 266, 9, 53, "Output",
 CellID->805744624]
}, Open  ]],
Cell[CellGroupData[{
Cell[171876, 3855, 88, 2, 70, "Input"],
Cell[171967, 3859, 266, 9, 53, "Output",
 CellID->200261113]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[172282, 3874, 208, 6, 70, "ExampleSection"],
Cell[172493, 3882, 208, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[172726, 3893, 679, 21, 70, "Input"],
Cell[173408, 3916, 59695, 983, 70, "Output",
 Evaluatable->False,
 CellID->33381716]
}, Open  ]],
Cell[233118, 4902, 105, 2, 70, "ExampleDelimiter"],
Cell[233226, 4906, 196, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[233447, 4917, 566, 19, 70, "Input"],
Cell[234016, 4938, 46597, 768, 70, "Output",
 Evaluatable->False,
 CellID->414908694]
}, Open  ]],
Cell[280628, 5709, 105, 2, 70, "ExampleDelimiter"],
Cell[280736, 5713, 92, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[280853, 5719, 1472, 41, 70, "Input"],
Cell[282328, 5762, 24291, 402, 70, "Output",
 Evaluatable->False,
 CellID->196083884]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[306680, 6171, 310, 9, 70, "SeeAlsoSection",
 CellID->2883],
Cell[306993, 6182, 737, 26, 70, "SeeAlso",
 CellID->1662]
}, Open  ]],
Cell[CellGroupData[{
Cell[307767, 6213, 314, 9, 70, "TutorialsSection",
 CellID->26798],
Cell[308084, 6224, 144, 3, 70, "Tutorials",
 CellID->32179]
}, Open  ]],
Cell[CellGroupData[{
Cell[308265, 6232, 321, 9, 70, "RelatedLinksSection",
 CellID->31635],
Cell[308589, 6243, 195, 4, 70, "RelatedLinks"],
Cell[308787, 6249, 201, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309025, 6258, 318, 9, 70, "MoreAboutSection",
 CellID->55337585],
Cell[309346, 6269, 165, 3, 70, "MoreAbout",
 CellID->696577411],
Cell[309514, 6274, 182, 3, 70, "MoreAbout",
 CellID->791390846]
}, Open  ]],
Cell[309711, 6280, 27, 0, 70, "History"],
Cell[309741, 6282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

