(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54446,       1814]
NotebookOptionsPosition[     45769,       1513]
NotebookOutlinePosition[     47296,       1554]
CellTagsIndexPosition[     47210,       1549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"],
           "ChebyshevT" :> Documentation`HelpLookup["paclet:ref/ChebyshevT"], 
          "ChebyshevU" :> Documentation`HelpLookup["paclet:ref/ChebyshevU"], 
          "JacobiP" :> Documentation`HelpLookup["paclet:ref/JacobiP"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"LegendreP\"\>", 
       2->"\<\"ChebyshevT\"\>", 3->"\<\"ChebyshevU\"\>", 
       4->"\<\"JacobiP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GegenbauerC", "ObjectName",
 CellID->18718],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GegenbauerC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GegenbauerC"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Gegenbauer polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["C", "n", 
         RowBox[{"(", "m", ")"}]], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GegenbauerC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GegenbauerC"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the renormalized form ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderscriptBox["lim", 
         RowBox[{"m", "\[Rule]", "0"}],
         LimitsPositioning->True], 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["C", "n", 
           RowBox[{"(", "m", ")"}]], "(", "x", ")"}], "/", "m"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13573]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit polynomials are given for integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " and for any ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13037],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["C", "n", 
     RowBox[{"(", "m", ")"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "m", "+", "1"}], ")"}], "x", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "+", "2", "m"}], ")"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->4998],

Cell[TextData[{
 "The Gegenbauer polynomials are orthogonal on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 " with weight function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], ")"}], 
    RowBox[{"m", "-", "1", "/", "2"}]], TraditionalForm]], "InlineMath"],
 ", corresponding to integration over a unit hypersphere. "
}], "Notes",
 CellID->9905],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->688879],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "0", ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is always zero. "
}], "Notes",
 CellID->7162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1717]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186777530],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->275145500],

Cell[TextData[{
 "Compute the 10",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " Gegenbauer polynomial:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->312614392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"10", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418728731],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"60", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"560", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"1792", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"2304", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1024", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->517369887]
}, Open  ]],

Cell[TextData[{
 "Compute the ",
 "10",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " renormalized Gegenbauer polynomial:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->99522582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"10", ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458668049],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"400", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"1120", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"1280", " ", 
     SuperscriptBox["x", "8"]}], "+", 
    RowBox[{"512", " ", 
     SuperscriptBox["x", "10"]}]}], ")"}]}]], "Output",
 ImageSize->{305, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196282641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->808179750],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "10"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->14779195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"GegenbauerC", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214130862],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydXEuLZEkZzc68lZlVWa+szK53V1VP97Si+BPEhahoK+JCXYhC2wjdCx0d
241udKMb3ejGAXEWPsDRxYjDiDCCOCAOiAPigKggI8i4cBAcXDQI6Rdx4saJ
e+6XWZlddFdl3Bv3i/Od7xHPmx+48+Depz5958H9u3cu3vPknc/eu3/38xfv
fuJJu9S70ul0nrP/nzvs2OeZfYr/n5vN7G/5+7b97tqtXij1Qp1wtRM/fiJ+
fl/4XeEObq5J3bIcPn4kXt+OV3/+/J/S1eNY/uULf8WlzoH9qvLjhfhOX+QB
2xtvPLRL9nznbbH8+uv/ffq7v3vttf90ToIOf/nzvzbi81vx7ou//ts73v7U
T599Be1WP37mD1/64i++9tVf2TOnLY0G4U8/X7Efk373kz8JIN4a7q1Z61a2
h+/fe9buJW2s8KEPfu/hw/911ou2v/H1F5/4zM++8uUXOkdRrtX/6Id/aLWs
ZEIM6YmPYKNE8IUHz7/027/jCj6/JSL51jd/Y8rYR1PRVEIbleG7/d6nP/6x
H7366r9LLPakkWDNJyxPffulH3z/ZbQAAW0sVetKN/wZon62llFv7Zlab67t
AS1Ru2cFq1FbulO9/Pt/gBUzYYGwQr13vfM79uhhuDLIT9qPXbRiYPwkeWq/
9NgKfBYoe2bj5GFvimVT15QOH8P9rpkwtlIZLWYoK9q/Eg+QQG5E3gNyeqI9
Zg+Hj7eiRayiVaf/Ake+mnCYr7zyx3/WODo9M5TRR35gV/tnH4BnM0o33c3H
7KNxbxZA7V62Y8JEjLcKacDUzZjgH+Hj47FsNBu78QGx2X68CL+D3UtM+TlQ
kTAZAINBTEaj+WTwCPBkapgy5Kkn9gEmM56ZkJhoz/3C4kalEVpiygxAIGoH
DGbQWEEw3hQrRYYaOQAWuiUoKkEJVNANvJSozNnN5e0jPiRUtNaacHAz+WiZ
j+kztA/QZ0YTKvrU1Sg8aw9gnRJZ1gBUJmTwPyIjPzeFv66LkDzdEA9DVjeH
sFQVPk6bnmQ/lrAbCDOWhB4IEQZESC+7IeXerOzbmL1uiAWBDL6ekfWzjewH
qIcZW7BQFIu0m5DRGpDI3PSYWN23LoQRIbnspzajVfvZp+wHHkFknX5+KuOe
ivTY1xRZDOhyxmih64nvoT7zWV/4BX/IrxCBuvNQQjJQwhmJMktJrZJTHyU5
Q31kc6JkhEwTp13x60GBMvta1mEqqICSUXJduK5clPS96/L8UFBPWmyhBy25
zNhn9UhhKhYFSkbGdfHHgLJb9/xFzF4XbYdig0mLJSAt0eXa+e5UpKjUi1kz
JyqHKDOTXIg/D6UMlNlfXZTlmAN961RaGYp/oVVmIx8l76M+owbymG8nLRyw
3zyU4Cc+1ctjBOTPQipa1X5CUZLrC1drxnZsr8r+OUMMlRjLXh5+PhFvW5fy
uXidzieA0dzanNurD3mM7L3a21PP3xUdywi3PmdW/6AFoKXPQzoj+lwYCWi7
eRY0v16cnfRye52xaAGUzAzzUCJXACVHgRti5zO5r5yizJx+Jn4DeRwvjoVj
H+3I1YneCcswJtAKe979WXs2Wn/0NaAsaMCoV9lj8bqueJWvQc+1GnlBK8y0
sYd2Zsth/IIJs68HvRN6ME9oC0CQxwBJD+q1SA/G9Vj0Qiv0+t3ZvNl5VdjU
m61DH/r9mbS8IZ42Fk9apA/9T8cku6LvSKS07VJmlVoP+hl99pqUR+I3AT9H
7D5uHfnRurtyfyStzcOdJjkO/ygzE5wKXmVyLP6ls9NFenDUtCv+sylWn87R
A6OZ+Xowfk/Fb9ACR0pAwP65Kx5R6kHv1FEjpDBvboq9gj2Y7Y2iDn589GT1
VNqBXI55dkXbRegZKz56cMpWWI5rPUXPOHBRU/6paL8pKHflfteT76IOETN2
pTMTAi3HxoPEvY65T8XXIIc9AVAyV2hO7y/glmh2Ja7QCvPwiZR9bskN6nO8
sOW2R61WQc3yjtsKuTuZFSO4Au2g9u/Uzx3Lc3mVNcXRrqDT/oZoQ2uVPL3j
Sleu6MfKLcocC+S15mQL1RrtzV/98tAy9+0I+m15Gq0ztn20zDHHqR3IYe5H
O8zEy6CkTniaGRnSGbtHNcdpThg8IETXULg7Fu4hh3l3W9iZj7LMVD1XV3IC
qcyfR2JB3195X22wLf68LTZcDnUlXr4t91FmH3UkXPqo6efHLre0Wd5TaayQ
UkugDlJ79QKr1azXpLv1NYRl4rw50uRacd58iID3xT6qyVD4rfvJ2FHChQtp
yiv0Yu7L6M2nSvTRa9DWILdNMRm7fYApk47M2uvNZ/EhDWZ1bjwRz/d11nXD
UjZGXTrij5FmEbszK1agiImDqqRP2My7Ev7iWi/dCnfr4mVswMiJjWaWrup6
7R2fwhN1tXci9q6zB2bLjNs2J4gOj5PSs6NHrJXrXlmfqiSozY94R4vN2Cqu
Jr9jztyYwwMjzOeBjPo+wizc5gNc+Xwwqy7igx76yHxAcCuXz+ODPW2weZyj
FLl33dWFK7ttDiCvXq/XGQp0L1c5qXvp7o+oOwzQyq1zdK+YA+usyPzua87R
V1tzRJCud2COzH4BDJQrqcsyUI+ZJXJmRW+ALdBWDh7Nyn3WcjU/XMXqKLlQ
zVFm3p2WLSKt5FXnkdTFaI19cbeta4ktPc9chDzOXjjvyjfmA/RH7F4yitaT
dG91qj1zZv+JdpgLdP+yHFNQu0p8aEtaBVqOlICWGclnnhkYqJvrFe05YnOf
NPRKgwVomSG2hHtI57gfrbMf8dEyP+oupK5OAG1zrfgytDqvIJqxcHlVLLzh
oqX2+4JuLOg3pf1l0FI3PM3ssSeWA1pdYVa09Jx98ayxPL8p2jXRht/P5JjL
bcHduaqp5UYshPMLGAW66yVruZx2yzUvumunfCqdRljqKd19rRjHnVYvLu0g
WJZvJ/HvcxL63XJlOPRFBUctpnV9D17ECIKXMLvBS3Q9WfsaZkdkdjkXUdTX
+R/aZ7+xVmtV7q6nWsyNef0s5Y16FovxFH0e6HX1WNEz4qa1n5X7VU47utJV
cs2IQS0OG6AFI3Ai6HQ3buSiZS6eCnd4nhGq8ySfW0jVkxYco43EAyZuublC
zH6Z2kzFUyaCTtkBWvZsi9CqFGZFnYVNxOLK8ci1iWrLkctIbAzUzILzUQc/
2hS/nqTrugPvo1RUjOqJWBr12VMtj7L0L70/FQv5/qeo6QHINTK+be010Jar
oJaRuM4figyl3PmoycKePK/y/Fy1HGrqviHc6ikc5S6eK+qkHd8ig+1dImdD
yn3RpkQrV3WmV3B0VTgdiw02XY6be/AhDvzxn7Im5YRGGNd5uu66FtGke4qK
VveOdEwMeew1dNy3Cmq1FPMyWmHmAwrde1LUzAH+6JWZbF08aTnUA9dizR2w
0lPGopWPmtzqDEFZ0BnBKqiZaXT+qWPlsdSvo29rVu5NNcfO4frGrBgTL4lK
/YiZRecbu+IxWy6Xuuui8xH6/bp41CIu5SRE4UdDeepAPASriswNPmrVUud8
ej5I5s3FDLVELSdQCj/UFbQDsYXujyhqnSuivs6r9RSSnCPUXmQOaj27xmx/
IFopCh81oxX1dQ2DXAK17lUtg7pbn5svcoGeTdfWY3R16ndDqLWu0kMOo3Mo
91fhlmU9F3ggXCsKn1uOPLeFy0PhfigoF6GmVNRiNOouA1CzJ48o0vsf2BXw
Tk/p3saWtLItUqELYxComA9VN+rC3WTGnu4OHQhzWN8MK/LlSSP/PSDVgRG4
LfY8bKDRvUP2QB52StUTuYeel6zlWfuS2LcFA3Rh5By6vqyMysg666D9TF+s
h31JZhXoYJFxqQ69HL3MdFsi7VB8y4/Dxdjl5EDRuxzNit3ysCb+CLxr/qRn
Arucfioy3Hzs7d1RSu2LZ4J/9uPgP6wpra6LjnI5ejh2vUBR+row8odibZ1T
HgljuuZZvrOlK2CadTbF1seCUNcKVtFAxxPsB3TXXc/U7AjqHbc+RxLHLmM6
npIVhzmo6al6Hk5POIyk/k7iXM9oab1jYaMvvrsKWvZiukqpreh6hs+xrp8Q
RX1mBvGp59WXQ9s8w90+b6RrTDoWVLT0AF2DOpb7elZcx46LUDd3E8rIA2qd
07P+roua97X+iUSjvhG2Cmo93U/u9UyidxK5RK3n4oCC0arn6nT1ZhFqnTvr
Xh6z3qn4r85ZAsoQfWNXrp4L1fcz9O2D5dDqDiijTU+fan2fY6LUNQA9F4r2
dDdY1q3noGa5clvRcQMtO3ZR07OGtWelE244yc2ViErKq6Amt5VY8FSiRHON
j5paaZRfE89TllZBXZywklZxSp896UA8QFHr2hPqM2NeE62VpVVQc9wE1MxI
Z2LBgaAapyjcE21Qj30p0OrbBbpytxxaWg5SGMv6jo2uD+65HHMcnddBkj+f
x7Ke0dJ8vhxq5l89U34m3OjqvI+aKHWl+Vz8tys2Xg71hvirntM6l/v6tpCi
3hP59d73hXiOvku2CK28JdR4TxJ84/1K5s1KuJu4KMm9vsV1LlzqaS1dNy/R
UgrQZh1n9Svi+q6qnlyJe18GNu/hpu/G0HfTwam+Jdbc4817tHPQlW9nA+lj
Ug9+zBhXLifCTU9sEbVdy/LSO+ibS2DLms/qt4aBjZGvkVq/Q+h9C4t/KpU5
ML9zkb4nI7a1lnMinOUS3HG8mr7tAasEN0SqelL7O0LWBLvinrZiAHaLLa3l
LJe+9mQZvCbIasOb47cThBUku2KVTHRYzei3UF42pwZKk2Dsmn0Min0wGqL8
yhzYruBbTzyE1mbKxfkdlBSp+G4Le9iUMMTogdrfACOnUkIRb4DBV0w5c67H
C++x31hVNTKA5PZSktvf19N+rm1jtSmefP+s+c0s+N6g9ncNda78H9JIFZo=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12898530]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2645],

Cell["Evaluate for complex orders and arguments:", "ExampleText",
 CellID->39219190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{
   RowBox[{"3", "+", "I"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "I"}]}], ",", "1.1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383771885],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "32.78646033062693`"}], "-", 
  RowBox[{"52.31770355091869`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->635310335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116725712],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->31869374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"GegenbauerC", "[", 
    RowBox[{
     RowBox[{"5", "/", "3"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130695396],

Cell[BoxData[
 RowBox[{"-", 
  "0.2083778132003164186220599521231777552004508126208832646834896537584`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303080514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82858706],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->493308527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{
   RowBox[{"5", "/", "3"}], ",", "0.50000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70173555],

Cell[BoxData[
 RowBox[{"-", 
  "0.208377813200316418622059952123177755200450812585`33.51270752594725"}]], \
"Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268569185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->807560571],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->726340179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249176714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{196, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373299672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55688662],

Cell["Simple cases give exact symbolic results:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->724938881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"n", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->515302143],

Cell[BoxData[
 RowBox[{"ChebyshevU", "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6859360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"\[Lambda]", ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->379850555],

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"\[Lambda]", ",", "x"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111317741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"1", "/", "6"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->400049150],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["2", "3"], "]"}]}], 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"1", "/", "3"}]], " ", 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}], "2"]}]]], "Output",
 ImageSize->{99, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->419946641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->360293883],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"ArcCos", "[", "x", "]"}], "2"], "]"}]}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->981700841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47241504],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->583262485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GegenbauerC", "[", 
   RowBox[{"n", ",", "\[Lambda]", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285191318],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["C", "n", 
    RowBox[{"(", "\[Lambda]", ")"}]], "(", "x", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{38, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->231646122]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3394],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " to a power series:"
}], "ExampleText",
 CellID->332007121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"5", ",", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "4"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376009866],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "x"}], "-", 
   FractionBox[
    RowBox[{"25", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 0, 
    Rational[-25, 3]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{114, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62591907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->626556182],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->194757479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"4", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300500566],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["7", "2"]}], ",", 
    FractionBox["9", "2"]}], "}"}], "]"}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174236841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19645],

Cell["\<\
Eigenfunctions of the angular part of the four-dimensional Laplace operator:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->631730367],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
       RowBox[{"D", "[", " ", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
          RowBox[{"D", "[", 
           RowBox[{"#", ",", "\[Theta]"}], "]"}]}], ",", "\[Theta]"}], 
        "]"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
         RowBox[{"Sin", "[", "\[Chi]", "]"}]}]], 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "\[Chi]", "]"}], 
          RowBox[{"D", "[", 
           RowBox[{"#", ",", "\[Chi]"}], "]"}]}], ",", "\[Chi]"}], "]"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Chi]", "]"}], "2"]}]], 
       RowBox[{"D", "[", 
        RowBox[{"#", ",", "\[Phi]", ",", "\[Phi]"}], "]"}]}]}], ")"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419306319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"GegenbauerC", "[", " ", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", " ", "f", " ", "]"}], "/", "f"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11861636],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "n"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "n"}], ")"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201443107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->430017310],

Cell["\<\
Radial part of the hydrogen atom eigenfunction in momentum representation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->194772213],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n_", ",", "l_", ",", "m_"}], "}"}], ",", "p_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["2", "l"], 
     RowBox[{"l", "!"}]}], 
    SuperscriptBox["n", "2"]], 
   SqrtBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "l", "-", "1"}], ")"}], "!"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "l"}], ")"}], "!"}]]], 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["p", "2"], "+", 
       SuperscriptBox["n", 
        RowBox[{"-", "2"}]]}], ")"}], "2"]], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"p", "/", "n"}], 
      RowBox[{
       SuperscriptBox["p", "2"], "+", 
       SuperscriptBox["n", 
        RowBox[{"-", "2"}]]}]], ")"}], "l"], 
   RowBox[{"GegenbauerC", "[", 
    RowBox[{
     RowBox[{"n", "-", "l", "-", "1"}], ",", 
     RowBox[{"l", "+", "1"}], ",", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["n", "2"], 
        SuperscriptBox["p", "2"]}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["n", "2"], 
        SuperscriptBox["p", "2"]}]}]]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94528754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "l", ",", "0"}], "}"}], ",", "p"}], "]"}], "^", 
      "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "0", ",", "0.4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9290743],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282532177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14272],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " into other functions:"
}], "ExampleText",
 CellID->253509758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"GegenbauerC", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441752491],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"EllipticE", "[", 
        FractionBox[
         RowBox[{"1", "-", "x"}], "2"], "]"}]}], 
      RowBox[{"\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}]}]]}], "+", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], " ", 
      RowBox[{"EllipticK", "[", 
       FractionBox[
        RowBox[{"1", "-", "x"}], "2"], "]"}]}], 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}]]}], ")"}]}]], "Output",
 ImageSize->{362, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1159502]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"GegenbauerC", "[", 
   RowBox[{"n", ",", "m", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->715614091],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{
    RowBox[{"2", " ", "m"}], "+", "n"}], "]"}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"2", " ", "m"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{153, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->769188583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30538],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->377633235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GegenbauerC", "[", 
   RowBox[{"60", ",", "x"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"2", "/", "3"}], ",", "17"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300499535],

Cell[BoxData["0``0.9661171918523955"], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189597213]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->370676016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GegenbauerC", "[", 
  RowBox[{"60", ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "17"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60075057],

Cell[BoxData["0.03267787668098969600666115542`14.465725805360078"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254255467]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19103],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8692],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->19539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->28047],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/UltrasphericalPolynomial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/GegenbauerC/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
GegenbauerC"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->19926861],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->107317328],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->692174785]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GegenbauerC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 57.4245742}", "context" -> "System`", 
    "keywords" -> {
     "Gegenbauer functions", "Gegenbauer polynomials", 
      "hyperspherical polynomials", "ultraspherical polynomials"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GegenbauerC[n, m, x] gives the Gegenbauer polynomial \
SubsuperscriptBox[C, n, (m)](x). GegenbauerC[n, x] gives the renormalized \
form UnderscriptBox[\"lim\", RowBox[{\"m\", \"->\", \"0\"}], \
LimitsPositioning->True] SubsuperscriptBox[C, n, (m)](x)/m. ", 
    "synonyms" -> {"Gegenbauer C"}, "title" -> "GegenbauerC", "type" -> 
    "Symbol", "uri" -> "ref/GegenbauerC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8190, 288, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->186777530]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47067, 1542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2272, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2895, 81, 49, 1, 70, "ObjectName",
 CellID->18718],
Cell[2947, 84, 1458, 48, 70, "Usage",
 CellID->13573]
}, Open  ]],
Cell[CellGroupData[{
Cell[4442, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4920, 154, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5043, 160, 230, 9, 70, "Notes",
 CellID->13037],
Cell[5276, 171, 730, 27, 70, "Notes",
 CellID->4998],
Cell[6009, 200, 530, 17, 70, "Notes",
 CellID->9905],
Cell[6542, 219, 251, 8, 70, "Notes",
 CellID->688879],
Cell[6796, 229, 224, 7, 70, "Notes",
 CellID->31226],
Cell[7023, 238, 207, 7, 70, "Notes",
 CellID->28162],
Cell[7233, 247, 296, 11, 70, "Notes",
 CellID->7162],
Cell[7532, 260, 621, 23, 70, "Notes",
 CellID->1717]
}, Closed]],
Cell[CellGroupData[{
Cell[8190, 288, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186777530],
Cell[CellGroupData[{
Cell[8575, 302, 148, 5, 70, "ExampleSection",
 CellID->275145500],
Cell[8726, 309, 319, 11, 70, "ExampleText",
 CellID->312614392],
Cell[CellGroupData[{
Cell[9070, 324, 141, 4, 28, "Input",
 CellID->418728731],
Cell[9214, 330, 492, 17, 36, "Output",
 CellID->517369887]
}, Open  ]],
Cell[9721, 350, 336, 12, 70, "ExampleText",
 CellID->99522582],
Cell[CellGroupData[{
Cell[10082, 366, 136, 4, 28, "Input",
 CellID->458668049],
Cell[10221, 372, 581, 20, 51, "Output",
 CellID->196282641]
}, Open  ]],
Cell[10817, 395, 125, 3, 70, "ExampleDelimiter",
 CellID->808179750],
Cell[10945, 400, 189, 9, 70, "ExampleText",
 CellID->14779195],
Cell[CellGroupData[{
Cell[11159, 413, 268, 9, 28, "Input",
 CellID->214130862],
Cell[11430, 424, 5214, 90, 134, "Output",
 Evaluatable->False,
 CellID->12898530]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16693, 520, 215, 7, 70, "ExampleSection",
 CellID->2645],
Cell[16911, 529, 84, 1, 70, "ExampleText",
 CellID->39219190],
Cell[CellGroupData[{
Cell[17020, 534, 215, 7, 70, "Input",
 CellID->383771885],
Cell[17238, 543, 268, 8, 36, "Output",
 CellID->635310335]
}, Open  ]],
Cell[17521, 554, 125, 3, 70, "ExampleDelimiter",
 CellID->116725712],
Cell[17649, 559, 69, 1, 70, "ExampleText",
 CellID->31869374],
Cell[CellGroupData[{
Cell[17743, 564, 237, 8, 70, "Input",
 CellID->130695396],
Cell[17983, 574, 253, 8, 36, "Output",
 CellID->303080514]
}, Open  ]],
Cell[18251, 585, 124, 3, 70, "ExampleDelimiter",
 CellID->82858706],
Cell[18378, 590, 113, 3, 70, "ExampleText",
 CellID->493308527],
Cell[CellGroupData[{
Cell[18516, 597, 192, 6, 70, "Input",
 CellID->70173555],
Cell[18711, 605, 248, 8, 36, "Output",
 CellID->268569185]
}, Open  ]],
Cell[18974, 616, 125, 3, 70, "ExampleDelimiter",
 CellID->807560571],
Cell[19102, 621, 216, 7, 70, "ExampleText",
 CellID->726340179],
Cell[CellGroupData[{
Cell[19343, 632, 189, 6, 70, "Input",
 CellID->249176714],
Cell[19535, 640, 538, 20, 51, "Output",
 CellID->373299672]
}, Open  ]],
Cell[20088, 663, 124, 3, 70, "ExampleDelimiter",
 CellID->55688662],
Cell[20215, 668, 221, 5, 70, "ExampleText",
 CellID->724938881],
Cell[CellGroupData[{
Cell[20461, 677, 140, 4, 70, "Input",
 CellID->515302143],
Cell[20604, 683, 216, 7, 36, "Output",
 CellID->6859360]
}, Open  ]],
Cell[CellGroupData[{
Cell[20857, 695, 172, 5, 70, "Input",
 CellID->379850555],
Cell[21032, 702, 225, 7, 36, "Output",
 CellID->111317741]
}, Open  ]],
Cell[CellGroupData[{
Cell[21294, 714, 188, 6, 70, "Input",
 CellID->400049150],
Cell[21485, 722, 413, 15, 69, "Output",
 CellID->419946641]
}, Open  ]],
Cell[CellGroupData[{
Cell[21935, 742, 154, 5, 70, "Input",
 CellID->360293883],
Cell[22092, 749, 268, 9, 51, "Output",
 CellID->981700841]
}, Open  ]],
Cell[22375, 761, 124, 3, 70, "ExampleDelimiter",
 CellID->47241504],
Cell[22502, 766, 203, 7, 70, "ExampleText",
 CellID->583262485],
Cell[CellGroupData[{
Cell[22730, 777, 190, 6, 70, "Input",
 CellID->285191318],
Cell[22923, 785, 300, 10, 54, "Output",
 CellID->231646122]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23272, 801, 238, 7, 70, "ExampleSection",
 CellID->3394],
Cell[23513, 810, 213, 8, 70, "ExampleText",
 CellID->332007121],
Cell[CellGroupData[{
Cell[23751, 822, 247, 8, 70, "Input",
 CellID->376009866],
Cell[24001, 832, 552, 19, 54, "Output",
 CellID->62591907]
}, Open  ]],
Cell[24568, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->626556182],
Cell[24696, 859, 220, 7, 70, "ExampleText",
 CellID->194757479],
Cell[CellGroupData[{
Cell[24941, 870, 239, 8, 70, "Input",
 CellID->300500566],
Cell[25183, 880, 307, 11, 51, "Output",
 CellID->174236841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25539, 897, 223, 7, 70, "ExampleSection",
 CellID->19645],
Cell[25765, 906, 264, 7, 70, "ExampleText",
 CellID->631730367],
Cell[26032, 915, 1301, 42, 70, "Input",
 CellID->419306319],
Cell[CellGroupData[{
Cell[27358, 961, 417, 13, 70, "Input",
 CellID->11861636],
Cell[27778, 976, 245, 9, 36, "Output",
 CellID->201443107]
}, Open  ]],
Cell[28038, 988, 125, 3, 70, "ExampleDelimiter",
 CellID->430017310],
Cell[28166, 993, 262, 7, 70, "ExampleText",
 CellID->194772213],
Cell[28431, 1002, 1334, 49, 70, "Input",
 CellID->94528754],
Cell[CellGroupData[{
Cell[29790, 1055, 470, 16, 70, "Input",
 CellID->9290743],
Cell[30263, 1073, 7833, 132, 70, "Output",
 Evaluatable->False,
 CellID->282532177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38145, 1211, 233, 7, 70, "ExampleSection",
 CellID->14272],
Cell[38381, 1220, 361, 13, 70, "ExampleText",
 CellID->253509758],
Cell[CellGroupData[{
Cell[38767, 1237, 253, 8, 70, "Input",
 CellID->441752491],
Cell[39023, 1247, 914, 33, 65, "Output",
 CellID->1159502]
}, Open  ]],
Cell[CellGroupData[{
Cell[39974, 1285, 182, 5, 70, "Input",
 CellID->715614091],
Cell[40159, 1292, 399, 14, 53, "Output",
 CellID->769188583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40607, 1312, 226, 7, 70, "ExampleSection",
 CellID->30538],
Cell[40836, 1321, 131, 4, 70, "ExampleText",
 CellID->377633235],
Cell[CellGroupData[{
Cell[40992, 1329, 293, 10, 70, "Input",
 CellID->300499535],
Cell[41288, 1341, 178, 5, 36, "Output",
 CellID->189597213]
}, Open  ]],
Cell[41481, 1349, 74, 1, 70, "ExampleText",
 CellID->370676016],
Cell[CellGroupData[{
Cell[41580, 1354, 216, 7, 70, "Input",
 CellID->60075057],
Cell[41799, 1363, 208, 5, 36, "Output",
 CellID->254255467]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42068, 1375, 311, 9, 70, "SeeAlsoSection",
 CellID->19103],
Cell[42382, 1386, 949, 35, 70, "SeeAlso",
 CellID->30231]
}, Open  ]],
Cell[CellGroupData[{
Cell[43368, 1426, 313, 9, 70, "TutorialsSection",
 CellID->8692],
Cell[43684, 1437, 154, 3, 70, "Tutorials",
 CellID->19539]
}, Open  ]],
Cell[CellGroupData[{
Cell[43875, 1445, 321, 9, 70, "RelatedLinksSection",
 CellID->28047],
Cell[44199, 1456, 195, 4, 70, "RelatedLinks"],
Cell[44397, 1462, 207, 4, 70, "RelatedLinks"],
Cell[44607, 1468, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45033, 1486, 318, 9, 70, "MoreAboutSection",
 CellID->19926861],
Cell[45354, 1497, 195, 4, 70, "MoreAbout",
 CellID->107317328],
Cell[45552, 1503, 145, 3, 70, "MoreAbout",
 CellID->692174785]
}, Open  ]],
Cell[45712, 1509, 27, 0, 70, "History"],
Cell[45742, 1511, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

