(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11691,        436]
NotebookOptionsPosition[      8405,        325]
NotebookOutlinePosition[      9702,        363]
CellTagsIndexPosition[      9618,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Messages" :> 
         Documentation`HelpLookup["paclet:tutorial/Messages"], 
         "Mathematica Sessions" :> 
         Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
      2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["General", "ObjectName",
 CellID->18448],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["General",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/General"]], "InlineFormula"],
     "\[LineSeparator]is a symbol to which general system messages are \
attached. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When you refer to a message with name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["On",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/On"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 ", the text of the message is obtained from ",
 Cell[BoxData[
  RowBox[{"General", "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " if no specific message named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " exists. "
}], "Notes",
 CellID->684]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389093575],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->7154242],

Cell["Define a general message:", "ExampleText",
 CellID->120644478],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"General", "::", "general"}], "=", 
   "\"\<This message will work for any symbol.\>\""}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7264323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Message", "[", 
  RowBox[{"f", "::", "general"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->271002574],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "\<\"general\"\>"}], ":", 
  " ", "\<\"This message will work for any symbol.\"\>"}]], "Message", "MSG",
 CellID->363024489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88848480],

Cell["\<\
Define a function that uses the system message when there are too many \
arguments:\
\>", "ExampleText",
 CellID->228836992],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "args___", "]"}], "/;", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"{", "args", "}"}], "]"}], "\[NotEqual]", "1"}], ",", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"f", "::", "argx"}], ",", "f", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"{", "args", "}"}], "]"}]}], "]"}], ";", "False"}], ",", 
     "True"}], "]"}]}], " ", ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"First", "[", 
       RowBox[{"{", "args", "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"x", "^", "x"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->581353567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123451873],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(f\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Cell$$7576`f::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->469342131],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430979271]
}, Open  ]],

Cell[TextData[{
 "This is the same as what a system function like ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->17727276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60907911],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->57750224],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->977375937]
}, Open  ]],

Cell[TextData[{
 "The text is in ",
 Cell[BoxData[
  RowBox[{"General", "::", "argx"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->323179291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"General", "::", "argx"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->903143479],

Cell[BoxData["\<\"`1` called with `2` arguments; 1 argument is \
expected.\"\>"], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76537192]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24016],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->15137],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->515861756]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"General - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 57.8308346}", "context" -> "System`", 
    "keywords" -> {
     "general messages", "system message", "warnings", "errors", 
      "diagnostics", "message handling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "General is a symbol to which general system messages are attached. ", 
    "synonyms" -> {}, "title" -> "General", "type" -> "Symbol", "uri" -> 
    "ref/General"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3097, 115, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->389093575]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9475, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 719, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1342, 44, 45, 1, 70, "ObjectName",
 CellID->18448],
Cell[1390, 47, 442, 14, 70, "Usage",
 CellID->25095]
}, Open  ]],
Cell[CellGroupData[{
Cell[1869, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2347, 83, 713, 27, 70, "Notes",
 CellID->684]
}, Closed]],
Cell[CellGroupData[{
Cell[3097, 115, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389093575],
Cell[CellGroupData[{
Cell[3482, 129, 146, 5, 70, "ExampleSection",
 CellID->7154242],
Cell[3631, 136, 68, 1, 70, "ExampleText",
 CellID->120644478],
Cell[3702, 139, 194, 6, 70, "Input",
 CellID->7264323],
Cell[CellGroupData[{
Cell[3921, 149, 133, 4, 70, "Input",
 CellID->271002574],
Cell[4057, 155, 169, 4, 70, "Message",
 CellID->363024489]
}, Open  ]],
Cell[4241, 162, 124, 3, 70, "ExampleDelimiter",
 CellID->88848480],
Cell[4368, 167, 134, 4, 70, "ExampleText",
 CellID->228836992],
Cell[4505, 173, 779, 24, 70, "Input",
 CellID->581353567],
Cell[CellGroupData[{
Cell[5309, 201, 120, 4, 70, "Input",
 CellID->123451873],
Cell[5432, 207, 393, 8, 70, "Message",
 CellID->469342131],
Cell[5828, 217, 208, 7, 36, "Output",
 CellID->430979271]
}, Open  ]],
Cell[6051, 227, 225, 8, 70, "ExampleText",
 CellID->17727276],
Cell[CellGroupData[{
Cell[6301, 239, 121, 4, 70, "Input",
 CellID->60907911],
Cell[6425, 245, 387, 8, 70, "Message",
 CellID->57750224],
Cell[6815, 255, 210, 7, 36, "Output",
 CellID->977375937]
}, Open  ]],
Cell[7040, 265, 150, 6, 70, "ExampleText",
 CellID->323179291],
Cell[CellGroupData[{
Cell[7215, 275, 102, 3, 70, "Input",
 CellID->903143479],
Cell[7320, 280, 221, 6, 36, "Output",
 CellID->76537192]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7602, 293, 314, 9, 70, "TutorialsSection",
 CellID->24016],
Cell[7919, 304, 127, 3, 70, "Tutorials",
 CellID->15137],
Cell[8049, 309, 284, 9, 70, "Tutorials",
 CellID->515861756]
}, Open  ]],
Cell[8348, 321, 27, 0, 70, "History"],
Cell[8378, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

