(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27311,        954]
NotebookOptionsPosition[     22794,        801]
NotebookOutlinePosition[     24123,        839]
CellTagsIndexPosition[     24038,        834]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files: Basics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"], 
          "Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Running External Programs" :> 
          Documentation`HelpLookup["paclet:tutorial/RunningExternalPrograms"],
           "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"], 
          "Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files: Basics\"\>", 
       2->"\<\"Mathematica Packages\"\>", 
       3->"\<\"Running External Programs\"\>", 
       4->"\<\"Setting Up Mathematica Packages\"\>", 
       5->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Needs" :> Documentation`HelpLookup["paclet:ref/Needs"], "Read" :> 
          Documentation`HelpLookup["paclet:ref/Read"], "Install" :> 
          Documentation`HelpLookup["paclet:ref/Install"], "RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "Splice" :> 
          Documentation`HelpLookup["paclet:ref/Splice"], "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"], 
          "SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], 
          "FileNames" :> Documentation`HelpLookup["paclet:ref/FileNames"], 
          "ToFileName" :> Documentation`HelpLookup["paclet:ref/ToFileName"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "NotebookGet" :> 
          Documentation`HelpLookup["paclet:ref/NotebookGet"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Needs\"\>", 2->"\<\"Read\"\>", 
       3->"\<\"Install\"\>", 4->"\<\"RunThrough\"\>", 5->"\<\"Put\"\>", 
       6->"\<\"Splice\"\>", 7->"\<\"FileNameSetter\"\>", 
       8->"\<\"SystemDialogInput\"\>", 9->"\<\"FileNames\"\>", 
       10->"\<\"ToFileName\"\>", 11->"\<\"ToExpression\"\>", 
       12->"\<\"NotebookGet\"\>", 13->"\<\"Input\"\>", 
       14->"\<\"NotebookRead\"\>", 15->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"File Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Mathematica Expressions in Files\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Get ",
 StyleBox["(<<)", "OperatorCharacter"]
}], "ObjectName",
 CellID->23292],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"<<", 
       StyleBox["name", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]reads in a file, evaluating each expression in it, and \
returning the last one. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
On systems with graphical interfaces, there will usually be graphical tools \
for reading in files. \
\>", "Notes",
 CellID->2872],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is the name of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context, ending with a ",
 Cell[BoxData["`"], "InlineFormula"],
 " context mark character, then ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " will process this name to find the file to read. "
}], "Notes",
 CellID->29448],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is the name of a file, any ",
 Cell[BoxData[
  RowBox[{".", "m"}]], "InlineFormula"],
 " extension must be included explicitly. "
}], "Notes",
 CellID->30323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " can read ",
 Cell[BoxData[
  RowBox[{".", "mx"}]], "InlineFormula"],
 " files of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions written by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " can read ",
 Cell[BoxData[
  RowBox[{".", "nb"}]], "InlineFormula"],
 " notebook files, returning the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions they represent."
}], "Notes",
 CellID->531423571],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"<<", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 ". The double quotes can be omitted if the name is of the form specified in \
",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 ". "
}], "Notes",
 CellID->15948],

Cell[TextData[{
 "If a file with name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "mx"}]], "InlineFormula"],
 " is found to be a directory, ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " will look for a file with a name like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["file", "TI"], ".", "mx"}], "/", 
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"]}], "/", 
   RowBox[{
    StyleBox["file", "TI"], ".", "mx"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24395],

Cell[TextData[{
 "If the file found by ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 " is a directory, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try to load the file ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " in that directory. "
}], "Notes",
 CellID->25197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " by default successively searches for files in the directories specified by \
the elements of ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", 
    RowBox[{
     ButtonBox["Path",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Path"], "->", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " successively searches for files in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22908],

Cell[TextData[{
 "Syntax errors in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input files are reported in the standard form: ",
 StyleBox["filename", "TI"],
 StyleBox[": ", "InlineCode"],
 StyleBox["line", "TI"],
 StyleBox[": syntax error in ", "InlineCode"],
 StyleBox["expr", "TI"],
 ". ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " continues attempting to read a file even after a syntax error has been \
detected. However, if an error is detected, ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " are reset to the values they had when ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " was called. "
}], "Notes",
 CellID->17411],

Cell[TextData[{
 "During the execution of ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ", the global variable ",
 Cell[BoxData[
  ButtonBox["$Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Input"]], "InlineFormula"],
 " is set to the name of the file being read. "
}], "Notes",
 CellID->13993],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " reads a file which has been encoded using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Encode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Encode"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7665]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50050516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->25310444],

Cell["Load a package:", "ExampleText",
 CellID->376008029],

Cell[BoxData[
 RowBox[{"<<", "EquationTrekker`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->668259448],

Cell[TextData[{
 "This has set up definitions for several symbols in the ",
 Cell[BoxData["EquationTrekker`"], "InlineFormula"],
 " context:"
}], "ExampleText",
 CellID->281628957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<EquationTrekker`*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->643273360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DifferentialEquationTrek\"\>", ",", "\<\"EquationTrekker\"\>", 
   ",", "\<\"EquationTrekkerNonModal\"\>", 
   ",", "\<\"EquationTrekkerState\"\>", ",", "\<\"InitializeGenerator\"\>", 
   ",", "\<\"PoincareSection\"\>", ",", "\<\"TrekData\"\>", 
   ",", "\<\"TrekGenerator\"\>", ",", "\<\"TrekParameters\"\>"}], 
  "}"}]], "Output",
 ImageSize->{475, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55582200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17228460],

Cell[TextData[{
 "Get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input from a file:"
}], "ExampleText",
 CellID->163923987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/language\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103370543],

Cell["22*a*b+56*c+13*a*d", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->657023674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "ExampleData/language"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112014036],

Cell[BoxData[
 RowBox[{
  RowBox[{"22", " ", "a", " ", "b"}], "+", 
  RowBox[{"56", " ", "c"}], "+", 
  RowBox[{"13", " ", "a", " ", "d"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4981585]
}, Open  ]],

Cell["The input is evaluated:", "ExampleText",
 CellID->171425259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "=", " ", "1"}], ",", 
     RowBox[{"b", "=", "2"}], ",", 
     RowBox[{"c", "=", "3"}], ",", 
     RowBox[{"d", "=", "4"}]}], "}"}], ",", 
   RowBox[{"<<", "ExampleData/language"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->191265876],

Cell[BoxData["264"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->195938166]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18023],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RunThrough",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RunThrough"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Splice",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Splice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToFileName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToFileName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20769]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26781],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"]
}], "Tutorials",
 CellID->3202],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->312865463],

Cell[TextData[ButtonBox["Running External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RunningExternalPrograms"]], "Tutorials",
 CellID->17610],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->24828],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->27256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->507042369],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->90690950],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->68145611],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->759799435],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions in Files",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]
}], "MoreAbout",
 CellID->19578824]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Get (<<) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 15.8312954}", "context" -> "System`", 
    "keywords" -> {
     "decode", "functions", "input", "load file", "load package", "pipes", 
      "reading", "command file", "script file"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "<< name reads in a file, evaluating each expression in it, and returning \
the last one. ", "synonyms" -> {"<<"}, "title" -> "Get", "type" -> "Symbol", 
    "uri" -> "ref/Get"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12357, 405, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->50050516]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23895, 827}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4432, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5055, 117, 97, 4, 70, "ObjectName",
 CellID->23292],
Cell[5155, 123, 420, 13, 70, "Usage",
 CellID->1723]
}, Open  ]],
Cell[CellGroupData[{
Cell[5612, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6090, 158, 140, 4, 70, "Notes",
 CellID->2872],
Cell[6233, 164, 449, 16, 70, "Notes",
 CellID->29448],
Cell[6685, 182, 245, 9, 70, "Notes",
 CellID->30323],
Cell[6933, 193, 443, 18, 70, "Notes",
 CellID->11153],
Cell[7379, 213, 346, 13, 70, "Notes",
 CellID->531423571],
Cell[7728, 228, 442, 15, 70, "Notes",
 CellID->15948],
Cell[8173, 245, 621, 23, 70, "Notes",
 CellID->24395],
Cell[8797, 270, 341, 13, 70, "Notes",
 CellID->25197],
Cell[9141, 285, 370, 13, 70, "Notes",
 CellID->4508],
Cell[9514, 300, 760, 26, 70, "Notes",
 CellID->22908],
Cell[10277, 328, 990, 33, 70, "Notes",
 CellID->17411],
Cell[11270, 363, 372, 13, 70, "Notes",
 CellID->13993],
Cell[11645, 378, 675, 22, 70, "Notes",
 CellID->7665]
}, Closed]],
Cell[CellGroupData[{
Cell[12357, 405, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50050516],
Cell[CellGroupData[{
Cell[12741, 419, 147, 5, 70, "ExampleSection",
 CellID->25310444],
Cell[12891, 426, 58, 1, 70, "ExampleText",
 CellID->376008029],
Cell[12952, 429, 103, 3, 70, "Input",
 CellID->668259448],
Cell[13058, 434, 180, 5, 70, "ExampleText",
 CellID->281628957],
Cell[CellGroupData[{
Cell[13263, 443, 125, 3, 28, "Input",
 CellID->643273360],
Cell[13391, 448, 506, 12, 71, "Output",
 CellID->55582200]
}, Open  ]],
Cell[13912, 463, 124, 3, 70, "ExampleDelimiter",
 CellID->17228460],
Cell[14039, 468, 135, 6, 70, "ExampleText",
 CellID->163923987],
Cell[CellGroupData[{
Cell[14199, 478, 132, 3, 70, "Input",
 CellID->103370543],
Cell[14334, 483, 99, 2, 70, "Print",
 CellID->657023674]
}, Open  ]],
Cell[CellGroupData[{
Cell[14470, 490, 107, 3, 70, "Input",
 CellID->112014036],
Cell[14580, 495, 281, 9, 36, "Output",
 CellID->4981585]
}, Open  ]],
Cell[14876, 507, 66, 1, 70, "ExampleText",
 CellID->171425259],
Cell[CellGroupData[{
Cell[14967, 512, 346, 11, 70, "Input",
 CellID->191265876],
Cell[15316, 525, 160, 5, 36, "Output",
 CellID->195938166]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15537, 537, 311, 9, 70, "SeeAlsoSection",
 CellID->18023],
Cell[15851, 548, 3658, 134, 70, "SeeAlso",
 CellID->20769]
}, Open  ]],
Cell[CellGroupData[{
Cell[19546, 687, 314, 9, 70, "TutorialsSection",
 CellID->26781],
Cell[19863, 698, 457, 12, 70, "Tutorials",
 CellID->3202],
Cell[20323, 712, 284, 9, 70, "Tutorials",
 CellID->312865463],
Cell[20610, 723, 159, 3, 70, "Tutorials",
 CellID->17610],
Cell[20772, 728, 408, 12, 70, "Tutorials",
 CellID->24828],
Cell[21183, 742, 429, 12, 70, "Tutorials",
 CellID->27256]
}, Open  ]],
Cell[CellGroupData[{
Cell[21649, 759, 319, 9, 70, "MoreAboutSection",
 CellID->507042369],
Cell[21971, 770, 148, 3, 70, "MoreAbout",
 CellID->90690950],
Cell[22122, 775, 140, 3, 70, "MoreAbout",
 CellID->68145611],
Cell[22265, 780, 122, 3, 70, "MoreAbout",
 CellID->759799435],
Cell[22390, 785, 309, 9, 70, "MoreAbout",
 CellID->19578824]
}, Open  ]],
Cell[22714, 797, 50, 0, 70, "History"],
Cell[22767, 799, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

