(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5230846,     140051]
NotebookOptionsPosition[   5158941,     137713]
NotebookOutlinePosition[   5166151,     137834]
CellTagsIndexPosition[   5166061,     137829]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"],
           "GraphPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot3D"], 
          "PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"], "KnotData" :> 
          Documentation`HelpLookup["paclet:ref/KnotData"], "LatticeData" :> 
          Documentation`HelpLookup["paclet:ref/LatticeData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphPlot\"\>", 
       2->"\<\"GraphPlot3D\"\>", 3->"\<\"PolyhedronData\"\>", 
       4->"\<\"KnotData\"\>", 5->"\<\"LatticeData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Integrated Data Sources\"\>", 
       3->"\<\"Discrete Mathematics\"\>", 4->"\<\"Mathematical Data\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphData"], "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an image of the graph with the specified name."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphData"], "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the value for the specified property for a named \
graph."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of named graphs in the specified class."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphData"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of named graphs with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Graphs can be specified by standard names such as ",
 Cell[BoxData["\"\<PetersenGraph\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<FosterCage\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->617057394],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
 " gives a list of all graph names that match the string pattern ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->179378167],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of all standard named graphs. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula"],
 " gives all available graphs."
}], "Notes",
 CellID->523821825],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["i", "TI"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives data for the ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " simple graph with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " vertices."
}], "Notes",
 CellID->80111691],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
      StyleBox["id", "TI"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives data for the graph of the specified type with identifier ",
 Cell[BoxData[
  StyleBox["id", "TI"]], "InlineFormula"],
 ". The identifier is typically an integer, or lists of integers."
}], "Notes",
 CellID->344254594],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives a list of graphs with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " vertices in the specified class."
}], "Notes",
 CellID->112962139],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", "\"\<Classes\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of all supported classes."
}], "Notes",
 CellID->136604891],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", "\"\<Properties\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of properties available for graphs."
}], "Notes",
 CellID->401413861],

Cell["Basic graph properties include:", "Notes",
 CellID->157096821],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdjacencyMatrix\>\"", Cell[
    "adjacency matrix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeCount\>\"", Cell[
    "total number of edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeIndices\>\"", Cell[
    "pairs of vertex indices for each edge", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeRules\>\"", Cell[
    "edges specified as vertex connectivity rules", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCount\>\"", Cell[
    "total number of vertices", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19451230],

Cell["Properties related to graph display include:", "Notes",
 CellID->38957979],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AllImages\>\"", Cell[
    "list of images of all available layouts for the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlternateVertexCoordinates\>\"", 
    Cell["vertex coordinates for all alternate layouts", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Image\>\"", Cell[
    "image of the default layout", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "vertex coordinates for the default layout", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->87697337],

Cell["Global graph properties include:", "Notes",
 CellID->49329940],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ArticulationVertices\>\"", Cell[
    "list of vertices whose removal would disconnect the graph", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AutomorphismCount\>\"", Cell[
    "order of the vertex automorphism group", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Automorphisms\>\"", Cell[
    "vertex permutations corresponding to automorphisms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Bridges\>\"", Cell[
    "list of edges whose removal would disconnect the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ChromaticNumber\>\"", Cell[
    "chromatic number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ChromaticPolynomial\>\"", Cell[
    "chromatic polynomial as a pure function ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CliqueNumber\>\"", Cell[
    "number of vertices in the largest clique", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CrossingNumber\>\"", Cell[
    "minimum crossings in an embedding of the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Degrees\>\"", Cell[
    "degrees for each vertex", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Diameter\>\"", Cell[
    "the diameter of the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Eccentricities\>\"", Cell[
    "eccentricities of each vertex", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeChromaticNumber\>\"", Cell[
    "edge chromatic number", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeConnectivity\>\"", Cell[
    "minimum edge deletions to disconnect the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Girth\>\"", Cell[
    "length of the shortest cycle", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HamiltonianCycleCount\>\"", Cell[
    "number of distinct Hamiltonian cycles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HamiltonianCycles\>\"", Cell[
    "lists of Hamiltonian cycles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HamiltonianPathCount\>\"", Cell[
    "number of distinct Hamiltonian paths", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HamiltonianPaths\>\"", Cell[
    "lists of Hamiltonian paths", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IndependenceNumber\>\"", Cell[
    "size of the largest independent set", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<LineGraphName\>\"", Cell[
    "name of the line graph corresponding to the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RectilinearCrossingNumber\>\"", Cell[
    "minimum crossings in a straight line embedding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Spectrum\>\"", Cell[
    "eigenvalues of the adjacency matrix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ToroidalCrossingNumber\>\"", Cell[
    "minimum crossings in a toroidal embedding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexConnectivity\>\"", Cell[
    TextData[{
     Cell[BoxData[Cell["", "TableText"]]],
     "minimum vertex deletions to disconnect the graph"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->423115246],

Cell["Naming-related properties include:", "Notes",
 CellID->346610557],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "alternate English names", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlternateStandardNames\>\"", Cell[
    TextData[{
     "alternate standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " names"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "English name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotationRules\>\"", Cell[
    "rules for notations specifying the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->850837264],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a list of named graphs in the specified class. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " depending on whether the graph corresponding to ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is in the specified class."
}], "Notes",
 CellID->482514198],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<Classes\>\""}], "]"}]], 
  "InlineFormula"],
 " gives a list of the classes in which the graph corresponding to ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " appears."
}], "Notes",
 CellID->282953651],

Cell["Basic classes of graphs include:", "Notes",
 CellID->45557811],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Bipartite\>\"", Cell[
    "bipartite (two components connected by every edge)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Connected\>\"", Cell[
    "connected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonplanar\>\"", Cell[
    "nonplanar (requires crossings)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Planar\>\"", Cell[
    "planar (no crossings)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Tree\>\"", Cell[
    "tree (no cycles)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->42125002],

Cell["Classes based on vertex degrees include:", "Notes",
 CellID->1570024096],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Cubic\>\"", Cell[
    "each vertex is of degree 3", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Quartic\>\"", Cell[
    "each vertex is of degree 4", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Quintic\>\"", Cell[
    "each vertex is of degree 5", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Regular\>\"", Cell[
    "each vertex is of the same degree", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1263410783],

Cell["Classes based on traversals include:", "Notes",
 CellID->160179848],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Eulerian\>\"", Cell[
    "has a closed cycle containing every edge once", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HamiltonConnected\>\"", Cell[
    "every pair of vertices bounds a Hamiltonian path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hamiltonian\>\"", Cell[
    "has a closed cycle containing every vertex once", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hypohamiltonian\>\"", Cell[
    "one-vertex-removed graphs are Hamiltonian", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hypotraceable\>\"", Cell[
    "one-vertex-removed graphs are traceable", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Noneulerian\>\"", Cell[
    "not Eulerian", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Nonhamiltonian\>\"", Cell[
    "not Hamiltonian", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SquareFree\>\"", Cell[
    "free of 4-cycles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Traceable\>\"", Cell[
    "contains a Hamiltonian path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TriangleFree\>\"", Cell[
    "free of 3-cycles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Untraceable\>\"", Cell[
    "not traceable", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->157863987],

Cell["Classes based on symmetry and regularity include:", "Notes",
 CellID->244891169],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DistanceRegular\>\"", Cell[
    "all vertices have identical distance sets", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeTransitive\>\"", Cell[
    "all edges have identical environments", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Identity\>\"", Cell[
    "automorphism group is of order unity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Semisymmetric\>\"", Cell[
    "edge- but not vertex-transitive", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StronglyRegular\>\"", Cell[
    "strongly regular", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symmetric\>\"", Cell[
    "both edge- and vertex-transitive", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexTransitive\>\"", Cell[
    "all vertices have identical environments", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WeaklyRegular\>\"", Cell[
    "regular, but not strongly regular", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1101101143],

Cell["Special classes include:", "Notes",
 CellID->570966986],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Bicolorable\>\"", Cell[
    "two or fewer vertex colors needed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Bicubic\>\"", Cell[
    "bipartite and cubic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Cage\>\"", Cell[
    "smallest graph of a given girth", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<CayleyGraph\>\"", Cell[
    "Cayley graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ClawFree\>\"", Cell[
    "free of the claw graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integral\>\"", Cell[
    "spectrum consists of integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LCF\>\"", Cell[
    "describable in LCF notation (cubic Hamiltonian)", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<LineGraph\>\"", Cell[
    "line graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Moore\>\"", Cell[
    "graphs with the Moore property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Perfect\>\"", Cell[
    "perfect graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SelfComplementary\>\"", Cell[
    "isomorphic to its complement", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SelfDual\>\"", Cell[
    "isomorphic to its dual", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Snark\>\"", Cell[
    "snark graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitDistance\>\"", Cell[
    "embeddable with edges of unit length", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->5062106],

Cell["Classes associated with graphs include:", "Notes",
 CellID->1413333645],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Antiprism\>\"", Cell[
    "skeleton of an antiprism", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Archimedean\>\"", Cell[
    "skeleton of one of the 13 Archimedean solids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ArchimedeanDual\>\"", Cell[
    "skeleton of one of the 13 Archimedean duals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Platonic\>\"", Cell[
    "skeleton of one of the 5 Platonic solids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Polyhedral\>\"", Cell[
    "skeleton of a polyhedron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Prism\>\"", Cell[
    "skeleton of a prism", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RegularPolychoron\>\"", Cell["\<\
skeleton of one of the 6 regular 4\[Hyphen]dimensional solids\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->581952048],

Cell["Classes of graphs indexed by one or more integers include:", "Notes",
 CellID->1632252252],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Circulant\>\"", Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices each with identical relative adjacencies"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complete\>\"", Cell[
    "all pairs of vertices are connected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CompleteBipartite\>\"", Cell[
    "all pairs connected across two disjoint sets of vertices", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Crown\>\"", Cell[TextData[{
     "complete bipartite ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["K", 
        RowBox[{"n", ",", "n"}]], TraditionalForm]], "InlineMath"],
     " with horizontal edges removed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Cycle\>\"", Cell[TextData[{
     "a single cycle through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Empty\>\"", Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vertices with no edges"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Grid\>\"", Cell[
    "an array of points with grid connectivity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hypercube\>\"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-dimensional hypercube"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ladder\>\"", Cell[TextData[{
     "a 2 ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-vertex ladder graph"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MoebiusLadder\>\"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-sided prism graph with a half-twist"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Path\>\"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-vertex tree with no branches"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Star\>\"", Cell[TextData[{
     "a center vertex connected to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "-", 
       StyleBox["1", "TR"]}]], "InlineFormula"],
     " vertices"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Wheel\>\"", Cell[
    "a cycle with all vertices connected to a center", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->1975216798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->1270882523],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "short textual description of the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LongDescription\>\"", Cell[
    "longer textual description of the property ", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "additional information about the property", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->524183967],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 " may require internet connectivity. "
}], "Notes",
 CellID->94188222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628855868],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->14213114],

Cell["Show an image of the Pappus graph:", "ExampleText",
 CellID->1196870531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<PappusGraph\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323693068],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 
    0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
    0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
    0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
    0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 0.866}, {
    0.5, -0.866}, {0.173, -0.985}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 4}, {1, 16}, {1, 15}, {2, 5}, {2, 17}, {2, 16}, {3, 6}, {3,
        18}, {3, 7}, {4, 7}, {4, 8}, {5, 8}, {5, 6}, {6, 9}, {7, 10}, {8, 
       11}, {9, 12}, {9, 13}, {10, 13}, {10, 14}, {11, 14}, {11, 12}, {12, 
       15}, {13, 16}, {14, 17}, {15, 18}, {17, 18}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 
     0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
     0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
     0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
     0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 0.866}, {
     0.5, -0.866}, {0.173, -0.985}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->777926400]
}, Open  ]],

Cell["Show all available images of the graph:", "ExampleText",
 CellID->2001273393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<PappusGraph\>\"", ",", "\"\<AllImages\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1513036837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.766, 0.643}, {0.174, 
      0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
      0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
      0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
      0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 0.866}, {
      0.5, -0.866}, {0.173, -0.985}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 4}, {1, 16}, {1, 15}, {2, 5}, {2, 17}, {2, 16}, {3, 6}, {
         3, 18}, {3, 7}, {4, 7}, {4, 8}, {5, 8}, {5, 6}, {6, 9}, {7, 10}, {8, 
         11}, {9, 12}, {9, 13}, {10, 13}, {10, 14}, {11, 14}, {11, 12}, {12, 
         15}, {13, 16}, {14, 17}, {15, 18}, {17, 18}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 
       0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
       0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
       0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
       0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 0.866}, {
       0.5, -0.866}, {0.173, -0.985}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.}, {0., 2.}, {0., 3.}, {0.866025, 0.5}, {
      1.73205, 1.}, {2.59808, 1.5}, {0.866025, -0.5}, {1.73205, -1.}, {
      2.59808, -1.5}, {0., -1.}, {0., -2.}, {
      0., -3.}, {-0.866025, -0.5}, {-1.73205, -1.}, {-2.59808, -1.5}, \
{-0.866025, 0.5}, {-1.73205, 1.}, {-2.59808, 1.5}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 4}, {1, 16}, {1, 15}, {2, 5}, {2, 17}, {2, 16}, {3, 6}, {
         3, 18}, {3, 7}, {4, 7}, {4, 8}, {5, 8}, {5, 6}, {6, 9}, {7, 10}, {8, 
         11}, {9, 12}, {9, 13}, {10, 13}, {10, 14}, {11, 14}, {11, 12}, {12, 
         15}, {13, 16}, {14, 17}, {15, 18}, {17, 18}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.}, {0., 2.}, {0., 3.}, {0.866025, 
       0.5}, {1.73205, 1.}, {2.59808, 1.5}, {0.866025, -0.5}, {
       1.73205, -1.}, {2.59808, -1.5}, {0., -1.}, {0., -2.}, {
       0., -3.}, {-0.866025, -0.5}, {-1.73205, -1.}, {-2.59808, -1.5}, \
{-0.866025, 0.5}, {-1.73205, 1.}, {-2.59808, 1.5}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.}, {2.598, 1.5}, {0.866, 0.5}, {-1.732, 1.}, {
      0., 3.}, {0., 2.}, {-0.866, -0.5}, {-2.598, 1.5}, {-0.866, 0.5}, {
      0., -2.}, {-2.598, -1.5}, {-1.732, -1.}, {0.866, -0.5}, {0., -3.}, {
      0., -1.}, {1.732, 1.}, {2.598, -1.5}, {1.732, -1.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 4}, {1, 16}, {1, 15}, {2, 5}, {2, 17}, {2, 16}, {3, 6}, {
         3, 18}, {3, 7}, {4, 7}, {4, 8}, {5, 8}, {5, 6}, {6, 9}, {7, 10}, {8, 
         11}, {9, 12}, {9, 13}, {10, 13}, {10, 14}, {11, 14}, {11, 12}, {12, 
         15}, {13, 16}, {14, 17}, {15, 18}, {17, 18}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.}, {2.598, 1.5}, {0.866, 0.5}, {-1.732,
        1.}, {0., 3.}, {0., 2.}, {-0.866, -0.5}, {-2.598, 1.5}, {-0.866, 
       0.5}, {0., -2.}, {-2.598, -1.5}, {-1.732, -1.}, {0.866, -0.5}, {
       0., -3.}, {0., -1.}, {1.732, 1.}, {2.598, -1.5}, {1.732, -1.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->728561864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433782042],

Cell["Show the spectrum of the icosahedral graph:", "ExampleText",
 CellID->2015281976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<Spectrum\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732090148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox["5"]}], ",", 
   RowBox[{"-", 
    SqrtBox["5"]}], ",", 
   RowBox[{"-", 
    SqrtBox["5"]}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   SqrtBox["5"], ",", 
   SqrtBox["5"], ",", 
   SqrtBox["5"], ",", "5"}], "}"}]], "Output",
 ImageSize->{388, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2134976701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1305303773],

Cell["Generate a list of named snark graphs:", "ExampleText",
 CellID->1695058706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<Snark\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333610640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BlanusaSnark1\"\>", ",", "\<\"BlanusaSnark2\"\>", 
   ",", "\<\"CelminsSwartSnark1\"\>", ",", "\<\"CelminsSwartSnark2\"\>", ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"CubicTransitive\"\>", ",", "66"}], "}"}], 
   ",", "\<\"DoubleStarSnark\"\>", ",", "\<\"FlowerSnarkJ5\"\>", 
   ",", "\<\"FlowerSnarkJ7\"\>", ",", "\<\"GoldbergSnark3\"\>", 
   ",", "\<\"GoldbergSnark5\"\>", ",", "\<\"GoldbergSnark7\"\>", 
   ",", "\<\"LoupekinesSnark1\"\>", ",", "\<\"LoupekinesSnark2\"\>", 
   ",", "\<\"PetersenGraph\"\>", ",", "\<\"SzekeresSnark\"\>", 
   ",", "\<\"TietzesGraph\"\>", ",", "\<\"WatkinsSnark\"\>"}], 
  "}"}]], "Output",
 ImageSize->{525, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249155984]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(99)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Names and Classes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1533190506],

Cell["Obtain a list of all standard implemented graphs:", "ExampleText",
 CellID->676553989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1459672817],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "721", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "20"}], "}"}], ",", "\<\"WongGraph\"\>"}], 
   "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{508, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->2118995085]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->961719889],

Cell[BoxData["735"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81591747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92157315],

Cell["Obtain a list of all implemented graphs:", "ExampleText",
 CellID->1643324693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", "All", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570931184],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "7"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "1917", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "11"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "13"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "20"}], "}"}], ",", "\<\"WongGraph\"\>"}], 
   "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{568, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1217925043]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269120641],

Cell[BoxData["1939"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1999558144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1848577758],

Cell["Find the English name of a graph:", "ExampleText",
 CellID->738578064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221172202],

Cell[BoxData["\<\"cubical graph\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->602134305]
}, Open  ]],

Cell["A list of alternate names can also be found:", "ExampleText",
 CellID->629456667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33052035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"4-crown graph\"\>", ",", "\<\"grid graph (2,2,2)\"\>", 
   ",", "\<\"hexahedral graph\"\>", ",", "\<\"square prism graph\"\>", 
   ",", "\<\"4-prism graph\"\>", ",", "\<\"3-hypercube graph\"\>"}], 
  "}"}]], "Output",
 ImageSize->{377, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1128319471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612011445],

Cell["Additional names acceptable as input can be found:", "ExampleText",
 CellID->129146030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952696506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "5358"}], "}"}], ",", "\<\"Cp1\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Crown\"\>", ",", "4"}], "}"}], ",", "\<\"Ct5\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CubicTransitive\"\>", ",", "5"}], "}"}], 
   ",", "\<\"F008A\"\>", ",", "\<\"Foster008A\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GeneralizedPetersen\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Grid\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hypercube\"\>", ",", "3"}], "}"}], ",", "\<\"H3\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Prism\"\>", ",", "4"}], "}"}], ",", "\<\"Y4\"\>"}], 
  "}"}]], "Output",
 ImageSize->{573, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1384746087]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Hypercube\>\"", ",", "3"}], "}"}], ",", 
   "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149645494],

Cell[BoxData["\<\"CubicalGraph\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1147201670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593810369],

Cell["Find the list of graph classes:", "ExampleText",
 CellID->268927234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28830905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Antiprism\"\>", ",", "\<\"Archimedean\"\>", 
   ",", "\<\"ArchimedeanDual\"\>", ",", "\<\"Bicolorable\"\>", 
   ",", "\<\"Biconnected\"\>", ",", "\<\"Bicubic\"\>", 
   ",", "\<\"Bipartite\"\>", ",", "\<\"Cage\"\>", ",", "\<\"CayleyGraph\"\>", 
   ",", "\<\"Circulant\"\>", ",", "\<\"Class1\"\>", ",", "\<\"Class2\"\>", 
   ",", "\<\"ClawFree\"\>", ",", "\<\"CocktailParty\"\>", 
   ",", "\<\"Complete\"\>", ",", "\<\"CompleteBipartite\"\>", 
   ",", "\<\"CompletelyRegular\"\>", ",", "\<\"CompleteTree\"\>", 
   ",", "\<\"Connected\"\>", ",", "\<\"Crown\"\>", ",", "\<\"Cubic\"\>", 
   ",", "\<\"Cycle\"\>", ",", "\<\"Disconnected\"\>", 
   ",", "\<\"DistanceRegular\"\>", ",", "\<\"EdgeTransitive\"\>", 
   ",", "\<\"Empty\"\>", ",", "\<\"Eulerian\"\>", 
   ",", "\<\"GeneralizedPetersen\"\>", ",", "\<\"Grid\"\>", 
   ",", "\<\"HamiltonConnected\"\>", ",", "\<\"Hamiltonian\"\>", 
   ",", "\<\"Hypercube\"\>", ",", "\<\"Hypohamiltonian\"\>", 
   ",", "\<\"Hypotraceable\"\>", ",", "\<\"Identity\"\>", 
   ",", "\<\"Integral\"\>", ",", "\<\"Ladder\"\>", ",", "\<\"LCF\"\>", 
   ",", "\<\"LineGraph\"\>", ",", "\<\"MoebiusLadder\"\>", 
   ",", "\<\"Moore\"\>", ",", "\<\"Noneulerian\"\>", 
   ",", "\<\"Nonhamiltonian\"\>", ",", "\<\"Nonplanar\"\>", 
   ",", "\<\"Path\"\>", ",", "\<\"Perfect\"\>", ",", "\<\"Planar\"\>", 
   ",", "\<\"Platonic\"\>", ",", "\<\"Polyhedral\"\>", ",", "\<\"Prism\"\>", 
   ",", "\<\"Quartic\"\>", ",", "\<\"Quintic\"\>", ",", "\<\"Regular\"\>", 
   ",", "\<\"RegularPolychoron\"\>", ",", "\<\"SelfComplementary\"\>", 
   ",", "\<\"SelfDual\"\>", ",", "\<\"Semisymmetric\"\>", 
   ",", "\<\"Snark\"\>", ",", "\<\"SquareFree\"\>", ",", "\<\"Star\"\>", 
   ",", "\<\"StronglyRegular\"\>", ",", "\<\"Symmetric\"\>", 
   ",", "\<\"Traceable\"\>", ",", "\<\"Tree\"\>", ",", "\<\"TriangleFree\"\>",
    ",", "\<\"UnitDistance\"\>", ",", "\<\"Unitransitive\"\>", 
   ",", "\<\"Untraceable\"\>", ",", "\<\"VertexTransitive\"\>", 
   ",", "\<\"WeaklyRegular\"\>", ",", "\<\"Wheel\"\>"}], "}"}]], "Output",
 ImageSize->{564, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->910284924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16764254],

Cell["Find the list of graphs belonging to a class:", "ExampleText",
 CellID->53277388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<Snark\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->795584317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BlanusaSnark1\"\>", ",", "\<\"BlanusaSnark2\"\>", 
   ",", "\<\"CelminsSwartSnark1\"\>", ",", "\<\"CelminsSwartSnark2\"\>", ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"CubicTransitive\"\>", ",", "66"}], "}"}], 
   ",", "\<\"DoubleStarSnark\"\>", ",", "\<\"FlowerSnarkJ5\"\>", 
   ",", "\<\"FlowerSnarkJ7\"\>", ",", "\<\"GoldbergSnark3\"\>", 
   ",", "\<\"GoldbergSnark5\"\>", ",", "\<\"GoldbergSnark7\"\>", 
   ",", "\<\"LoupekinesSnark1\"\>", ",", "\<\"LoupekinesSnark2\"\>", 
   ",", "\<\"PetersenGraph\"\>", ",", "\<\"SzekeresSnark\"\>", 
   ",", "\<\"TietzesGraph\"\>", ",", "\<\"WatkinsSnark\"\>"}], 
  "}"}]], "Output",
 ImageSize->{525, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485216440]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<Cage\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23186614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Balaban10Cage\"\>", ",", "\<\"Balaban11Cage\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "11"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "12"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "13"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "14"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "15"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "16"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "17"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cage\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "18"}], "}"}]}], "}"}], 
   ",", "\<\"FosterCage\"\>", ",", "\<\"HarriesGraph\"\>", 
   ",", "\<\"HarriesWongGraph\"\>", ",", "\<\"HeawoodGraph\"\>", 
   ",", "\<\"HoffmanSingletonGraph\"\>", ",", "\<\"LeviGraph\"\>", 
   ",", "\<\"McGeeGraph\"\>", ",", "\<\"MeringerGraph\"\>", 
   ",", "\<\"PetersenGraph\"\>", ",", "\<\"RobertsonGraph\"\>", 
   ",", "\<\"RobertsonWegnerGraph\"\>", ",", "\<\"Tutte12Cage\"\>", 
   ",", "\<\"WongGraph\"\>"}], "}"}]], "Output",
 ImageSize->{532, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1037299421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427853053],

Cell["Test whether a graph belongs to a class:", "ExampleText",
 CellID->226300656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<Cage\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16562659],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619122401]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties and Annotations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1961895733],

Cell["Get a list of properties for a particular graph:", "ExampleText",
 CellID->218429381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<HeawoodGraph\>\"", ",", "\"\<Properties\>\""}], "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "4"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180587304],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"AdjacencyMatrix\"\>", ",", "\<\"AllImages\"\>", 
    ",", "\<\"AlternateNames\"\>", ",", "\<\"AlternateStandardNames\"\>", 
    ",", "\<\"AlternateVertexCoordinates\"\>", ",", "\<\"Antiprism\"\>", ",", 
    
    RowBox[{"\[LeftSkeleton]", "109", "\[RightSkeleton]"}], 
    ",", "\<\"VertexCoordinateRules\"\>", ",", "\<\"VertexCoordinates\"\>", 
    ",", "\<\"VertexCount\"\>", ",", "\<\"VertexTransitive\"\>", 
    ",", "\<\"WeaklyRegular\"\>", ",", "\<\"Wheel\"\>"}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{497, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1031923892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228229632],

Cell["Get a short textual description of a property:", "ExampleText",
 CellID->1347723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<Snark\>\"", ",", "\"\<Description\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1850805952],

Cell[BoxData["\<\"snark\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466919672]
}, Open  ]],

Cell["Get a longer textual description:", "ExampleText",
 CellID->1113244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<Snark\>\"", ",", "\"\<LongDescription\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4392297],

Cell[BoxData["\<\"bridgeless and cubic with edge chromatic number four\"\>"], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->613681166]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29302194],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->553589695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<HamiltonianCycleCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529027222],

Cell[BoxData["32"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1922884068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<HamiltonianCycles\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1648676993],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{496, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1673784]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1943736212],

Cell[BoxData["32"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->344571633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<AdjacencyMatrix\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->609521478],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "24", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 24, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1599523519]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->561612478],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmT1vwjAQhk3S9CPA3pFf006du3SJUBEMVSvKkI2RkTFjfgJjRkZGxowZ
MzIypuePYOM6bUCq0zYXKbFjzvYT3/FK9j0Es/HzSzCbDIPB/TR4G0+G74O7
1yk0uR1CyAjux1sC9QJq7B4VBZTq06NPN47jgl3EhYcLpl0oPSj9irIr7K5Y
p/l8rvQn5IJV0zRNkuTQSrsV5QV10mM/HVpPfveNo16WX7TdbnWiKIpUTqtE
+/0+DENJ5JatHIoTWiLiXlssFjA9rToHImez2XjWSSBMIFiOSZi38jxvZm1k
7KpEMs7tE4Gr+N+0goh6zRUMDpT9L0pqd1OusejfMY76pL2314p6XFU+XSH1
9utao3Jt+C4Czosb3QqJkKjNRFQhVQU0KaXa7tca9bfqVXMKqStirzAr5nlx
VC9Czos2JEKiNhOpCqkrokkxUSFPs0KFRCIk+stEqJC4y/6fuyMkQiLcZf+k
1XK5rGElczGqVRRFu92uXF+TMlZlaLjXsixbrVa0qp4eJ0kisiT2z7PX67Xh
zB8+UnDaJwL/HOVDmswZ6Xk1SeSAx2yuDVUYB3zC5hT5QrkmjmWST/4QRDxR
1AyRnJsTqbu6OpmYPuvF87Gk8wGwyR29\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->10918259]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<EdgeRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->417806960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "4"}], ",", 
   RowBox[{"1", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"3", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"4", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1658359336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GraphData", "[", 
    RowBox[{"\"\<DodecahedralGraph\>\"", ",", "\"\<ChromaticPolynomial\>\""}],
     "]"}], "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->414708089],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "17"], "-", 
     RowBox[{"27", " ", 
      SuperscriptBox["x", "16"]}], "+", 
     RowBox[{"352", " ", 
      SuperscriptBox["x", "15"]}], "-", 
     RowBox[{"2950", " ", 
      SuperscriptBox["x", "14"]}], "+", 
     RowBox[{"17839", " ", 
      SuperscriptBox["x", "13"]}], "-", 
     RowBox[{"82777", " ", 
      SuperscriptBox["x", "12"]}], "+", 
     RowBox[{"305866", " ", 
      SuperscriptBox["x", "11"]}], "-", 
     RowBox[{"921448", " ", 
      SuperscriptBox["x", "10"]}], "+", 
     RowBox[{"2297495", " ", 
      SuperscriptBox["x", "9"]}], "-", 
     RowBox[{"4783425", " ", 
      SuperscriptBox["x", "8"]}], "+", 
     RowBox[{"8347700", " ", 
      SuperscriptBox["x", "7"]}], "-", 
     RowBox[{"12195590", " ", 
      SuperscriptBox["x", "6"]}], "+", 
     RowBox[{"14808795", " ", 
      SuperscriptBox["x", "5"]}], "-", 
     RowBox[{"14713381", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"11613602", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"6892084", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"2751604", " ", "x"}], "-", "555984"}], ")"}]}], 
  TraditionalForm]], "Output",
 ImageSize->{460, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//TraditionalForm=",
 CellID->2002589386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490922267],

Cell[TextData[{
 "A property that is not available for ",
 "a graph",
 " has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotAvailable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187464565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<SixHundredCellGraph\>\"", ",", "\"\<HamiltonianCycles\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178393597],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8611071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60842248],

Cell[TextData[{
 "Some graph properties may be ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " but still include partial information:"
}], "ExampleText",
 CellID->904561909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<LCF\>\"", "/.", 
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<Foster090A\>\"", ",", "\"\<NotationRules\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->935267450],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"NotAvailable\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"17", ",", 
       RowBox[{"-", "9"}], ",", "37", ",", 
       RowBox[{"-", "37"}], ",", "9", ",", 
       RowBox[{"-", "17"}]}], "}"}], ",", "15"}], "}"}]}], "]"}]], "Output",
 ImageSize->{365, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->844865948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1479298170],

Cell[TextData[{
 "A property whose value is too large to include has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<TooLarge\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1146161871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Hypercube\>\"", ",", "5"}], "}"}], ",", 
   "\"\<HamiltonianCycles\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614252307],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"TooLarge\"\>", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->500114072]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Hypercube\>\"", ",", "5"}], "}"}], ",", 
   "\"\<HamiltonianCycleCount\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->906124913],

Cell[BoxData["1813091520"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166213746]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Detailed Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(89)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2131646900],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Basic Graph Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->384419450],

Cell[TextData[{
 "Give the adjacency matrix, returned as a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->1306885974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<AdjacencyMatrix\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369823502],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "24", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 24, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "8"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1825687922]
}, Open  ]],

Cell["Convert to an explicit matrix:", "ExampleText",
 CellID->2119130118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1533960323],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl1O20AQdmJSQqvQhKc+cgYOAU89RIQqJQ9VEXCiwgPlWHAQ47XrCn2Z
3Z3Z2U2MOkhxdsb2zDc/6+x++Pv6fvPj5/p+e70+v7pd32y213fnl79uW1U9
qarJS1VVF9+qdty0o+7j/l7bTz/sR1/csR7ONtUJyF8zy8vI+SOQPyvxxfxJ
ZcQ39vzV7rCTRSdPW3HJ/F69+0brTs+1v2L4oexjlnPhx2xNyWw5FE6cgf5T
e5i1Ilo59lzv00vtzIV2UJ4z45PileLKlSeUcQ5K48tVp9D1Eju8Lu20s39y
d03vw3U+5mTQHwfvCp9NszkX26R84HXh6NPikCMtkVHKh6z2+6+x7y7EHbcW
nwfUbN+1hb+TC/IqWsu795R1L87tBQs9DxcPgSZyRH+qQK/JdWxVRN8Ve65O
Gv5zdSz9hDHgeRr9WPoJ0WMdJej330+855P1k/WT9ZP1k/WT9dP/0E/I1Tht
/dfnwMkMMqVfgh5XbcjhTD32Vky/aP+MYd9nFzmumpG1nqFzQ+Rm5aOxs5HG
5uryZ2wuB/8RmSU3jw/B1ob0GhaQy+L68EpZ3JT4JHhiLG6u+uWsd34W18f4
7Z/DC5/VM3lyFtcXRxp/q4m+DItbovYl+iZP7fvfMvRB8qNZ1760No1B5LG3
sVUAve+QoM/D3mpyr8GVlvtudkfn0Lj6J233Opb+ie1eNbkv3z/k+sL6x/rH
+sf6x/onKQbrnxy4NP1Dsa0clnXQL0GPXkJsK3Iy6I/yz2FbffgpezG2tZtf
naBnV6WMxaHZwrGzrQ9dVmtGFB+J3XxkRZWLrSv9TmkqG5mTrSsZNze+36yq
5uWv9v/2pY69K8FfybmmEownZat/ek0jOUhjhPL/Hz2Nz9IwQrxVjWbNiuie
mvQ5OpaKxFbYmjVq+Yoguj+NVcQqYhUJobeKhG0fqiKct53e70RxJx16r6km
vFI7bc6O3bezR/vPXVRuyNnrVpM35DYtgw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{482, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->481257664]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2106020057],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm71uwjAUhU1S2vK3d+Rp2qkPEaFKMFStKJVQFxYkRsaMPAJjRkZGRkZG
RkbG9NpOiAl2cEhSnHKRiB3rxvFnTnxiy7w6g+7buzPodZz2S9/57PY6X+3n
jz4U2RVCyBi+308E8j7k2Hfs+5CKxyo92rPZzGcfYsPBhtBmLG1AWg1S8bwe
K39glYxGI6E+Qu5Ydr1ee553KKWX+eGHBHXpljZZNYdSzSi9q+7DPlmtVnEG
13VFMsMZ9vv9cDiMGOywlGNwJmMZuJYmkwk0mGatA4O1XC6rJWg7yB1Ef9x2
pqHtdluW/o+eWpEhesLLwAAC4kOcgoFqSTbq0dSCtCU5F8tr/vHYUJHe5Sd2
frtR8f5WuUtDEfeodZc0yrxMg1lUjgzIgAy3yCBzG5XLyOLqWncxdey/ntuc
c5Ui3CZPdV3r6UIGZECGsjKIbpPkKug2+URRzcjcRLWiFl9Bq2ndha/vXKaj
LJrT06+eMpEBGZDhfzFQt1G5icp1TlfSzBvVTY2Kz23ibnLOffJ8D8rybmPK
uxwyIAMylIVBNrdJ4z44t0kXpZrb6K6sFT+3KX5uXvy7HDIgAzKYx5A0t9Ep
x7lNuihdt1G5jyluk0W/pjxdyIAMyPCXDGncRhZ3O24znU41oqI9zmKU67q7
3S7s76SVNJXLhCn/VTebzXw+p1lxp6HnecFe4jxn3fnPzfluycViIdm1Ct0U
kJWBATRxtGtYb/e2WQyRgiMGC3Rkdv/TsdcCpbBWBv8viPrdMr7tJyoJGPiW
7bIwRK3lDOKopVopS1o5a7Fa+H9GSOUXYeKElg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{132, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->443281955]
}, Open  ]],

Cell[TextData[{
 "Plot the matrix using ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->690577473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->980197043],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2UsKwjAQBuCEeIVo3XUf8RAiduXSA4QitAtRag/WRe8XZ8woxUfBLkTL
H5hJJvNth0C79XWxP/i6zH2aVf5UlPk53RwrujJaKdVyJIrOgU4xTAh84NVQ
6Fga7l2XaijpCAberihZKi3tjvY5FBTUR2pBaSqKtZPaQEND/4medRQ0NPRI
9eSupbcLT687DMyYzMOEOFH9cwQFBfV+zrpvDO99MwkLC/t9a6VewsLC/rp9
8RLfvt6soaCgRA3789fGnr4A8DzUog==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->306543497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1508626921],

Cell["Return the number of edges of the octahedral graph:", "ExampleText",
 CellID->235941231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<EdgeCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1209457055],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593452794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1865836360],

Cell["List the indices of edges of the octahedral graph:", "ExampleText",
 CellID->1555489026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<EdgeIndices\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1785625051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{360, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1247052090]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1020556755],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1911565557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488052629],

Cell[TextData[{
 "Return the edges as a set of rules, suitable for plotting in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1460487710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<EdgeRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->678856760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"1", "\[Rule]", "4"}], ",", 
   RowBox[{"1", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"3", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"4", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1326957379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1452635788],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.6220420762904935}, {0.347443782925957, 
    0.006862255772938752}, {1.0542998648703414`, 0.}, {0.3594517551994708, 
    1.2319584325267852`}, {1.0668192347249466`, 1.2242109724974553`}, {
    1.4141497605877613`, 0.6078126211744443}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
       5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.6220420762904935}, {0.347443782925957, 
     0.006862255772938752}, {1.0542998648703414`, 0.}, {0.3594517551994708, 
     1.2319584325267852`}, {1.0668192347249466`, 1.2242109724974553`}, {
     1.4141497605877613`, 0.6078126211744443}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554994758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1140583006],

Cell["Give the number of vertices of the octahedral graph:", "ExampleText",
 CellID->1339548720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<VertexCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1724265539],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1275418785]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[
  "Properties Related to Graph Display", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->313291301],

Cell["Show the default embedding of the octahedral graph:", "ExampleText",
 CellID->538597674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567534813],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-0.316, 0.182}, {0.316, 0.182}, {0., -0.365}, {
    0., 1.385}, {-1.2, -0.693}, {1.2, -0.693}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
       5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.316, 0.182}, {0.316, 0.182}, {0., -0.365}, {
     0., 1.385}, {-1.2, -0.693}, {1.2, -0.693}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1929238788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502002074],

Cell["Return the vertex coordinates for the default embedding:", "ExampleText",
 CellID->1833092302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->981919852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.316`"}], ",", "0.182`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.316`", ",", "0.182`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.365`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.385`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2`"}], ",", 
     RowBox[{"-", "0.693`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2`", ",", 
     RowBox[{"-", "0.693`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2008207510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
     RowBox[{"Point", "[", "%", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1000609593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], AbsolutePointSize[5], 
   PointBox[{{-0.316, 0.182}, {0.316, 0.182}, {0., -0.365}, {0., 
    1.385}, {-1.2, -0.693}, {1.2, -0.693}}]},
  Frame->True,
  FrameTicks->None]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2090624318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1401131257],

Cell["Return the vertex coordinates for alternate embeddings:", "ExampleText",
 CellID->1654847044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
  "\"\<OctahedralGraph\>\"", ",", "\"\<AlternateVertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->953556211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5`"}], ",", "0.866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", 
       RowBox[{"-", "0.866`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5`"}], ",", 
       RowBox[{"-", "0.866`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.122`", ",", "0.004`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.695`", ",", "0.44`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.264`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.699`", ",", "1.213`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.394`", ",", "0.879`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.748`", ",", "0.534`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.72`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.171`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32`", ",", "0.002`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.497`", ",", "0.716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "1.205`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{558, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2142964059]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
       RowBox[{"Point", "[", "#", "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1857827461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {1., 0.}, {
      0.5, -0.866}, {-0.5, -0.866}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.122, 0.004}, {0.695, 0.44}, {0., 0.885}, {1.264, 0.}, {
      0.699, 1.213}, {1.394, 0.879}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.748, 0.534}, {0., 0.72}, {1.171, 0.}, {0.32, 0.002}, {1.497,
       0.716}, {0.75, 1.205}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0., 0.}, {1., 0.}, {2., 0.}, {2., 1.}, {1., 1.}, {0., 1.}}]},
    Frame->True,
    FrameTicks->None]}], "}"}]], "Output",
 ImageSize->{452, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Tiny},
 Graphics3DBoxOptions->{ImageSize->Tiny},
 CellLabel->"Out[2]=",
 CellID->1348695776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1582725764],

Cell[TextData[{
 "Show ",
 StyleBox["all",
  FontSlant->"Italic"],
 " available images of the octahedral graph:"
}], "ExampleText",
 CellID->2004477110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<AllImages\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1670817281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{-0.316, 0.182}, {0.316, 0.182}, {0., -0.365}, {0., 
      1.385}, {-1.2, -0.693}, {1.2, -0.693}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
         5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{-0.316, 0.182}, {0.316, 0.182}, {
       0., -0.365}, {0., 1.385}, {-1.2, -0.693}, {1.2, -0.693}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {1., 0.}, {
      0.5, -0.866}, {-0.5, -0.866}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
         5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {1., 
       0.}, {0.5, -0.866}, {-0.5, -0.866}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.122, 0.004}, {0.695, 0.44}, {0., 0.885}, {1.264, 
      0.}, {0.699, 1.213}, {1.394, 0.879}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
         5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.122, 0.004}, {0.695, 0.44}, {0., 0.885}, {
       1.264, 0.}, {0.699, 1.213}, {1.394, 0.879}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.748, 0.534}, {0., 0.72}, {1.171, 0.}, {0.32, 
      0.002}, {1.497, 0.716}, {0.75, 1.205}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
         5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.748, 0.534}, {0., 0.72}, {1.171, 0.}, {
       0.32, 0.002}, {1.497, 0.716}, {0.75, 1.205}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 0.}, {1., 0.}, {2., 0.}, {2., 1.}, {1., 1.}, {
      0., 1.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 6}, {3, 
         5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 0.}, {1., 0.}, {2., 0.}, {2., 1.}, {1., 
       1.}, {0., 1.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{563, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Tiny},
 CellLabel->"Out[1]=",
 CellID->840013147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1608843685],

Cell["Return the vertex coordinates for all embeddings:", "ExampleText",
 CellID->869214418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<Embeddings\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1702956432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.316`"}], ",", "0.182`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.316`", ",", "0.182`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.365`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.385`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2`"}], ",", 
       RowBox[{"-", "0.693`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.2`", ",", 
       RowBox[{"-", "0.693`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.5`", ",", "0.866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5`"}], ",", "0.866`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", 
       RowBox[{"-", "0.866`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5`"}], ",", 
       RowBox[{"-", "0.866`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.122`", ",", "0.004`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.695`", ",", "0.44`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.885`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.264`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.699`", ",", "1.213`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.394`", ",", "0.879`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.748`", ",", "0.534`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.72`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.171`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32`", ",", "0.002`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.497`", ",", "0.716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.75`", ",", "1.205`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{558, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543466251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
       RowBox[{"Point", "[", "#", "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->793405634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{-0.316, 0.182}, {0.316, 0.182}, {0., -0.365}, {0., 
      1.385}, {-1.2, -0.693}, {1.2, -0.693}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {1., 0.}, {
      0.5, -0.866}, {-0.5, -0.866}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.122, 0.004}, {0.695, 0.44}, {0., 0.885}, {1.264, 0.}, {
      0.699, 1.213}, {1.394, 0.879}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0.748, 0.534}, {0., 0.72}, {1.171, 0.}, {0.32, 0.002}, {1.497,
       0.716}, {0.75, 1.205}}]},
    Frame->True,
    FrameTicks->None], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], AbsolutePointSize[5], 
     PointBox[{{0., 0.}, {1., 0.}, {2., 0.}, {2., 1.}, {1., 1.}, {0., 1.}}]},
    Frame->True,
    FrameTicks->None]}], "}"}]], "Output",
 ImageSize->{563, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Tiny},
 Graphics3DBoxOptions->{ImageSize->Tiny},
 CellLabel->"Out[2]=",
 CellID->789329866]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Global Graph Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->426365709],

Cell["Find graphs having articulation vertices:", "ExampleText",
 CellID->648438847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"GraphData", "[", 
      RowBox[{"#", ",", "\"\<ArticulationVertices\>\""}], "]"}], "=!=", 
     RowBox[{"{", "}"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1979676651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Claw\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CompleteTree\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}], 
   ",", "\<\"NoPerfectMatchingGraph\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Path\"\>", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Star\"\>", ",", "20"}], "}"}], ",", "\<\"WaltherGraph\"\>"}],
   "}"}]], "Output",
 ImageSize->{563, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1260570343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2127614569],

Cell["\<\
Give the order of the automorphism group of the octahedral graph:\
\>", "ExampleText",
 CellID->1309088480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<AutomorphismCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->880119845],

Cell[BoxData["48"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1539944209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<Automorphisms\>\""}], "]"}], "//",
   "Length"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2142228964],

Cell[BoxData["48"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369407019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284337565],

Cell["Explicitly give the automorphisms of the octahedral graph:", \
"ExampleText",
 CellID->710340380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<Automorphisms\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->829172987],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{496, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136918830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1591347325],

Cell["Find graphs having bridges:", "ExampleText",
 CellID->1555399327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteCases", "[", 
   RowBox[{
    RowBox[{"GraphData", "[", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<StandardName\>\"", ",", "\"\<Bridges\>\""}], "}"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"_", ",", 
      RowBox[{"{", "}"}]}], "}"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "4"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278053958],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4"}], "}"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "600", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"WaltherGraph\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"8", ",", "22"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"12", ",", "13"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"11", ",", "12"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->437701377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->540187087],

Cell["Show the chromatic number of the icosahedral graph:", "ExampleText",
 CellID->1510995340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<ChromaticNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1304553605],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2142755183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->856813780],

Cell["\<\
Give the chromatic polynomial of the icosahedral graph, given as a pure \
function:\
\>", "ExampleText",
 CellID->1537370180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<ChromaticPolynomial\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57374556],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "#1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "#1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "#1"}], ")"}], " ", "#1", " ", 
   RowBox[{"(", 
    RowBox[{"20170", "-", 
     RowBox[{"40240", " ", "#1"}], "+", 
     RowBox[{"36408", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"19698", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"6999", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"1670", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"260", " ", 
      SuperscriptBox["#1", "6"]}], "-", 
     RowBox[{"24", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     SuperscriptBox["#1", "8"]}], ")"}]}], "&"}]], "Output",
 ImageSize->{555, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2133084138]
}, Open  ]],

Cell[TextData[{
 "Format the chromatic polynomial in terms of a variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ":"
}], "ExampleText",
 CellID->1456958839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GraphData", "[", 
    RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<ChromaticPolynomial\>\""}], 
    "]"}], "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1498663979],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "3"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "-", "2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "8"], "-", 
     RowBox[{"24", " ", 
      SuperscriptBox["x", "7"]}], "+", 
     RowBox[{"260", " ", 
      SuperscriptBox["x", "6"]}], "-", 
     RowBox[{"1670", " ", 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{"6999", " ", 
      SuperscriptBox["x", "4"]}], "-", 
     RowBox[{"19698", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"36408", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"40240", " ", "x"}], "+", "20170"}], ")"}]}], 
  TraditionalForm]], "Output",
 ImageSize->{528, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->653104348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2077683003],

Cell["Display the clique number of the icosaehdral graph:", "ExampleText",
 CellID->1534131201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<CliqueNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1454429325],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->935857019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1055479679],

Cell["Display the crossing number of the icosaehdral graph:", "ExampleText",
 CellID->1232040733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<CrossingNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->871275157],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778687705]
}, Open  ]],

Cell["The crossing number is 0 since the graph is planar:", "ExampleText",
 CellID->812352573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<IcosahedralGraph\>\"", ",", "\"\<Planar\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->903540884],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->638913117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1656150432],

Cell["Show the vertex degrees of the claw graph:", "ExampleText",
 CellID->1384761857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<Claw\>\"", ",", "\"\<Degrees\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1412248060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->794522419]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", "\"\<Claw\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->807579990],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 4}, {2, 4}, {3, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{113, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484979087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1359959115],

Cell["Give the diameter of the Pappus graph:", "ExampleText",
 CellID->1164390784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<PappusGraph\>\"", ",", "\"\<Diameter\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044915224],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1343074844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1085010401],

Cell["Give the eccentricities of the Pappus graph:", "ExampleText",
 CellID->1486162930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<PappusGraph\>\"", ",", "\"\<Eccentricities\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558066253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", 
   ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", 
   "4", ",", "4", ",", "4"}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858289491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1941840459],

Cell["Return the edge chromatic number of the 120-cell graph:", "ExampleText",
 CellID->1203610954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<120CellGraph\>\"", ",", "\"\<EdgeChromaticNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1940832785],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623818338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1796603398],

Cell["\<\
Find the edge connectivity of a complete binary tree of order 4:\
\>", "ExampleText",
 CellID->1893233366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<CompleteTree\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   "\"\<EdgeConnectivity\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307984763],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499642112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<CompleteTree\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73270977],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.}, {-2., -1.}, {
    2., -1.}, {-3., -2.}, {-1., -2.}, {1., -2.}, {
    3., -2.}, {-3.5, -3.}, {-2.5, -3.}, {-1.5, -3.}, {-0.5, -3.}, {
    0.5, -3.}, {1.5, -3.}, {2.5, -3.}, {3.5, -3.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 8}, {4, 
       9}, {5, 10}, {5, 11}, {6, 12}, {6, 13}, {7, 14}, {7, 15}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {-2., -1.}, {
     2., -1.}, {-3., -2.}, {-1., -2.}, {1., -2.}, {
     3., -2.}, {-3.5, -3.}, {-2.5, -3.}, {-1.5, -3.}, {-0.5, -3.}, {
     0.5, -3.}, {1.5, -3.}, {2.5, -3.}, {3.5, -3.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->823916614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167022577],

Cell["Display the girth of the Petersen graph:", "ExampleText",
 CellID->387325010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<PetersenGraph\>\"", ",", "\"\<Girth\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748509013],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->591975642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->573829145],

Cell["\<\
Return the number of Hamiltonian cycles of the cubical graph:\
\>", "ExampleText",
 CellID->2144864985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<HamiltonianCycleCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1085304353],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42878543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->497635957],

Cell["List the Hamiltonian cycles of the cubical graph:", "ExampleText",
 CellID->1466207881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hc", "=", 
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<CubicalGraph\>\"", ",", "\"\<HamiltonianCycles\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181006642],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "3", ",", "7", ",", "8", ",", "6", ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "8", ",", "6", ",", "5", ",", "7", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "6", ",", "5", ",", "7", ",", "8", ",", "4", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "6", ",", "8", ",", "4", ",", "3", ",", "7", ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "4", ",", "2", ",", "6", ",", "8", ",", "7", ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "4", ",", "8", ",", "7", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "7", ",", "5", ",", "6", ",", "8", ",", "4", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "7", ",", "8", ",", "4", ",", "2", ",", "6", ",", 
     "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "6", ",", "2", ",", "4", ",", "8", ",", "7", ",", 
     "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "6", ",", "8", ",", "7", ",", "3", ",", "4", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "7", ",", "3", ",", "4", ",", "8", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "5", ",", "7", ",", "8", ",", "6", ",", "2", ",", "4", ",", 
     "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{486, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1252650456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "hc", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102759312],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1514022451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141731159],

Cell["\<\
Return the number of Hamiltonian paths of the tetrahedral graph:\
\>", "ExampleText",
 CellID->516224790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<TetrahedralGraph\>\"", ",", "\"\<HamiltonianPathCount\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356111650],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866800191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1660033564],

Cell["Return the Hamiltonian paths of the cubical graph:", "ExampleText",
 CellID->76568324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hp", "=", 
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<TetrahedralGraph\>\"", ",", "\"\<HamiltonianPaths\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541116915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1929232536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "hp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270483501],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1903130146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33126641],

Cell["Return the independence number of the Heawood graph:", "ExampleText",
 CellID->561190714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<HeawoodGraph\>\"", ",", "\"\<IndependenceNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184152574],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2047456091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22150647],

Cell["Give name of the line graph for Petersen graph:", "ExampleText",
 CellID->771253198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<PetersenGraph\>\"", ",", "\"\<LineGraphName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241205494],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"QuarticTransitive\"\>", ",", "39"}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316561909]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<PetersenGraph\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<QuarticTransitive\>\"", ",", "39"}], "}"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1919969643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.}, {-0.951, 0.309}, {-0.588, -0.809}, {
      0.588, -0.809}, {0.951, 0.309}, {0., 2.}, {-1.902, 
      0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 0.618}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 3}, {1, 4}, {1, 6}, {2, 4}, {2, 5}, {2, 7}, {3, 5}, {3, 
         8}, {4, 9}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.}, {-0.951, 0.309}, {-0.588, -0.809}, {
       0.588, -0.809}, {0.951, 0.309}, {0., 2.}, {-1.902, 
       0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 0.618}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.807, -0.746}, {1.05, -1.162}, {1.098, -1.641}, {
      1.247, -0.553}, {1.287, -1.085}, {1.394, -0.755}, {1.568, -1.538}, {
      1.568, -1.288}, {1.568, -0.194}, {1.741, -0.755}, {1.848, -1.085}, {
      1.888, -0.553}, {2.037, -1.641}, {2.085, -1.162}, {2.328, -0.746}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 9}, {2, 3}, {2, 6}, {2, 8}, {3, 
         7}, {3, 13}, {4, 5}, {4, 9}, {4, 10}, {5, 7}, {5, 10}, {5, 11}, {6, 
         8}, {6, 11}, {6, 12}, {7, 11}, {7, 13}, {8, 10}, {8, 14}, {9, 12}, {
         9, 15}, {10, 14}, {11, 12}, {12, 15}, {13, 14}, {13, 15}, {14, 
         15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.807, -0.746}, {1.05, -1.162}, {
       1.098, -1.641}, {1.247, -0.553}, {1.287, -1.085}, {1.394, -0.755}, {
       1.568, -1.538}, {1.568, -1.288}, {1.568, -0.194}, {1.741, -0.755}, {
       1.848, -1.085}, {1.888, -0.553}, {2.037, -1.641}, {2.085, -1.162}, {
       2.328, -0.746}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{390, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1139010944]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305467787],

Cell["Give the rectilinear crossing numbers for complete graphs:", \
"ExampleText",
 CellID->1511179779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<Complete\>\"", ",", "\"\<RectilinearCrossingNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109452584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "9", ",", "19", ",", "36", ",", "62", ",", "102", ",", "153", ",",
    "229", ",", "324", ",", "447", ",", "603", ",", "798", ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", "1318", ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{454, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687706450]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1730687366],

Cell["Display the spectrum of the 600-cell graph:", "ExampleText",
 CellID->2144045394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spec", "=", 
  RowBox[{"GraphData", "[", 
   RowBox[{"\"\<SixHundredCellGraph\>\"", ",", "\"\<Spectrum\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1729375870],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{554, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88880297]
}, Open  ]],

Cell["Display a nicely formatted version:", "ExampleText",
 CellID->752979389],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpectrumForm", "[", "s_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"l", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"First", "[", "#", "]"}], ",", 
          RowBox[{"Length", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
       RowBox[{"Split", "[", 
        RowBox[{"Sort", "[", 
         RowBox[{"s", ",", "Less"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"HoldForm", "[", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"Apply", "[", 
        RowBox[{"Power", ",", 
         RowBox[{"HoldForm", "/@", "l"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], "]"}], "]"}], "/.", 
     RowBox[{"List", "\[RuleDelayed]", "Times"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195340298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"spec", "//", "SpectrumForm"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->744001640],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}]}], ")"}], "4"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "3"}], ")"}], "16"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}]}], ")"}], "9"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "2"}], ")"}], "36"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox["0", "25"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox["3", "16"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}]}], ")"}], "9"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}]}], ")"}], "4"],
     HoldForm], " ", 
    TagBox[
     SuperscriptBox["12", "1"],
     HoldForm]}],
   HoldForm], TraditionalForm]], "Output",
 ImageSize->{428, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->697478955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1945261814],

Cell["Give the toroidal crossing numbers for complete graphs:", "ExampleText",
 CellID->724265970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<Complete\>\"", ",", "\"\<ToroidalCrossingNumber\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->800846594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "4", ",", "9", ",", "23", ",", "42", ",", "70", ",", 
   "105", ",", "154", ",", "226", ",", "326", ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", 
   RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{415, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1563051359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1477823006],

Cell["Give the vertex connectivity of Tietze's graph:", "ExampleText",
 CellID->2122884287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<TietzesGraph\>\"", ",", "\"\<VertexConnectivity\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1022900351],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36736962]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Naming-Related Properties", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->624418620],

Cell["List the alternate English names of the tesseract graph:", "ExampleText",
 CellID->1998647098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<TesseractGraph\>\"", ",", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322569712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"grid graph (2,2,2,2)\"\>", ",", "\<\"hypercube graph\"\>", 
   ",", "\<\"4-hypercube graph\"\>", ",", "\<\"tesseract graph\"\>"}], 
  "}"}]], "Output",
 ImageSize->{521, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1110313645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->941581706],

Cell["Show the alternate stanadrd names for the tesseract graph:", \
"ExampleText",
 CellID->2068690416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<TesseractGraph\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->719576782],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Grid\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "}"}], 
   ",", "\<\"Qt51\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"QuarticTransitive\"\>", ",", "51"}], "}"}], 
   ",", "\<\"H4\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hypercube\"\>", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1556022732]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651669632],

Cell["Give rules for various notations for the octahedral graph:", \
"ExampleText",
 CellID->1522678001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<OctahedralGraph\>\"", ",", "\"\<NotationRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86541508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Antiprism\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"CayleyGraph\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "4", ",", "5", ",", "3"}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "5", ",", "3", ",", "4"}], "}"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "4"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "4"}], 
         "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "7", ",", "6"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "5", ",", "7"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "7", ",", "5"}], 
         "}"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"\<\"Circulant\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"6", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"\<\"CocktailParty\"\>", "\[Rule]", "3"}], ",", 
   RowBox[{"\<\"LineGraph\"\>", "\[Rule]", 
    RowBox[{"{", "\<\"TetrahedralGraph\"\>", "}"}]}], ",", 
   RowBox[{"\<\"QuarticVertexTransitiveConnected\"\>", 
    "\[Rule]", "\<\"Qt2\"\>"}], ",", 
   RowBox[{"\<\"StronglyRegular\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4", ",", "2", ",", "4"}], "}"}]}]}], "}"}]], "Output",\

 ImageSize->{529, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18203558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297733880],

Cell["Query the standard name of the 4-hypercube graph:", "ExampleText",
 CellID->376423650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Hypercube\>\"", ",", "4"}], "}"}], ",", 
   "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->730317139],

Cell[BoxData["\<\"TesseractGraph\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1004521432]
}, Open  ]],

Cell["\<\
Show other alternate standard names corresponding to this standard name:\
\>", "ExampleText",
 CellID->230006864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<TesseractGraph\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65461488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Grid\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "}"}], 
   ",", "\<\"Qt51\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"QuarticTransitive\"\>", ",", "51"}], "}"}], 
   ",", "\<\"H4\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Hypercube\"\>", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1622758557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"GraphData", "[", 
     RowBox[{"#", ",", "\"\<StandardName\>\""}], "]"}], "&"}], "/@", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2133205261],

Cell[BoxData[
 RowBox[{"{", "\<\"TesseractGraph\"\>", "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->660750599]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["Basic Classes", "ExampleSubsubsection"],
  $Line = 0; Null]], "ExampleSubsubsection",
 CellID->254798648],

Cell["Bipartite graphs:", "ExampleText",
 CellID->318484818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", "\"\<Bipartite\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1245087802],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "11"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "2"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "408", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "13"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Star\"\>", ",", "20"}], "}"}], 
    ",", "\<\"TesseractGraph\"\>", ",", "\<\"TruncatedOctahedralGraph\"\>", 
    ",", "\<\"Tutte12Cage\"\>", ",", "\<\"UtilityGraph\"\>", 
    ",", "\<\"WaltherGraph\"\>"}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{518, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->597378756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<UtilityGraph\>\"", ",", "\"\<Bipartite\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1382072168],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658702367]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"GraphData", "[", "#", "]"}], ",", 
        RowBox[{"GraphData", "[", 
         RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"GraphData", "[", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"GraphData", "[", 
          RowBox[{"#", ",", "\"\<Bipartite\>\""}], "]"}], "&&", 
         RowBox[{
          RowBox[{"GraphData", "[", 
           RowBox[{"#", ",", "\"\<VertexCount\>\""}], "]"}], "\[LessEqual]", 
          "20"}]}], "&"}]}], "]"}]}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508898508],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-1., 0.}, {0., -1.}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 3}, {2, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-1., 0.}, {0., -1.}, {1., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-circulant graph (2)\""],
        Annotation[#, "4-circulant graph (2)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -196.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.5, 0.866}, {-0.5, 0.866}, {-1., 
            0.}, {-0.5, -0.866}, {0.5, -0.866}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 4}, {2, 5}, {3, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.5, 0.866}, {-0.5, 0.866}, {-1., 
             0.}, {-0.5, -0.866}, {0.5, -0.866}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-circulant graph (3)\""],
        Annotation[#, "6-circulant graph (3)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -196.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.259, -0.966}, {0.259, -0.966}, {
            0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 0.707}, {
            0.259, 0.966}, {-0.259, 0.966}, {-0.707, 0.707}, {-0.966, 
            0.259}, {-0.966, -0.259}, {-0.707, -0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 10}, {1, 12}, {2, 3}, {2, 5}, {2, 
               11}, {3, 4}, {3, 6}, {3, 12}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 
               12}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.259, -0.966}, {0.259, -0.966}, {
             0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 
             0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
             0.707}, {-0.966, 0.259}, {-0.966, -0.259}, {-0.707, -0.707}}]& ],
          
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3)\""],
        Annotation[#, "12-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -196.8}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 8}, {1, 12}, {2, 3}, {2, 7}, {2, 
               9}, {3, 4}, {3, 8}, {3, 10}, {4, 5}, {4, 9}, {4, 11}, {5, 6}, {
               5, 10}, {5, 12}, {6, 7}, {6, 11}, {7, 8}, {7, 12}, {8, 9}, {9, 
               10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,5)\""],
        Annotation[#, "12-circulant graph (1,5)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -196.8}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 7}, {1, 11}, {2, 4}, {2, 8}, {2, 12}, {3, 
               5}, {3, 9}, {4, 6}, {4, 10}, {5, 7}, {5, 11}, {6, 8}, {6, 
               12}, {7, 9}, {8, 10}, {9, 11}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,6)\""],
        Annotation[#, "12-circulant graph (2,6)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -196.8}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.222, -0.975}, {0.223, -0.975}, {
            0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {0.623,
             0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
            0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 12}, {1, 14}, {2, 3}, {2, 5}, {2, 
               13}, {3, 4}, {3, 6}, {3, 14}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 
               12}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 13}, {13, 
               14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.222, -0.975}, {0.223, -0.975}, {
             0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {
             0.623, 0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
             0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-circulant graph (1,3)\""],
        Annotation[#, "14-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {2160., -196.8}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.901, 0.434}, {0.623, 0.782}, {0.223, 
            0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
            0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 8}, {1, 12}, {1, 14}, {2, 3}, {2, 
               5}, {2, 9}, {2, 13}, {3, 4}, {3, 6}, {3, 10}, {3, 14}, {4, 
               5}, {4, 7}, {4, 11}, {5, 6}, {5, 8}, {5, 12}, {6, 7}, {6, 9}, {
               6, 13}, {7, 8}, {7, 10}, {7, 14}, {8, 9}, {8, 11}, {9, 10}, {9,
                12}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 13}, {13, 
               14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.901, 0.434}, {0.623, 0.782}, {0.223, 
             0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
             0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-circulant graph (1,3,7)\""],
        Annotation[#, "14-circulant graph (1,3,7)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -196.8}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.924, 0.383}, {0.707, 0.707}, {0.383, 
            0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
            0.383}, {-1., 
            0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
            0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 14}, {1, 16}, {2, 3}, {2, 5}, {2, 
               15}, {3, 4}, {3, 6}, {3, 16}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 
               12}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 13}, {12, 
               15}, {13, 14}, {13, 16}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           Annotation[#, 
            VertexCoordinateRules -> {{0.924, 0.383}, {0.707, 0.707}, {0.383, 
             0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
             0.383}, {-1., 
             0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
             0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-circulant graph (1,3)\""],
        Annotation[#, "16-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -196.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.924, 0.383}, {0.707, 0.707}, {0.383, 
            0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
            0.383}, {-1., 
            0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
            0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 10}, {1, 16}, {2, 3}, {2, 9}, {2, 
               11}, {3, 4}, {3, 10}, {3, 12}, {4, 5}, {4, 11}, {4, 13}, {5, 
               6}, {5, 12}, {5, 14}, {6, 7}, {6, 13}, {6, 15}, {7, 8}, {7, 
               14}, {7, 16}, {8, 9}, {8, 15}, {9, 10}, {9, 16}, {10, 11}, {11,
                12}, {12, 13}, {13, 14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.924, 0.383}, {0.707, 0.707}, {0.383, 
             0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
             0.383}, {-1., 
             0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
             0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-circulant graph (1,7)\""],
        Annotation[#, "16-circulant graph (1,7)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -196.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.924, 0.383}, {0.707, 0.707}, {0.383, 
            0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
            0.383}, {-1., 
            0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
            0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 7}, {1, 11}, {1, 15}, {2, 4}, {2, 8}, {2, 
               12}, {2, 16}, {3, 5}, {3, 9}, {3, 13}, {4, 6}, {4, 10}, {4, 
               14}, {5, 7}, {5, 11}, {5, 15}, {6, 8}, {6, 12}, {6, 16}, {7, 
               9}, {7, 13}, {8, 10}, {8, 14}, {9, 11}, {9, 15}, {10, 12}, {10,
                16}, {11, 13}, {12, 14}, {13, 15}, {14, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.924, 0.383}, {0.707, 0.707}, {0.383, 
             0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
             0.383}, {-1., 
             0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
             0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-circulant graph (2,6)\""],
        Annotation[#, "16-circulant graph (2,6)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -196.8}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.94, 0.342}, {0.766, 0.643}, {0.5, 
            0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
            0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
             0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 16}, {1, 18}, {2, 3}, {2, 5}, {2, 
               17}, {3, 4}, {3, 6}, {3, 18}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 
               12}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 13}, {12, 
               15}, {13, 14}, {13, 16}, {14, 15}, {14, 17}, {15, 16}, {15, 
               18}, {16, 17}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.94, 0.342}, {0.766, 0.643}, {0.5, 
             0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
             0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-circulant graph (1,3)\""],
        Annotation[#, "18-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.94, 0.342}, {0.766, 0.643}, {0.5, 
            0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
            0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
             0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 14}, {1, 18}, {2, 3}, {2, 7}, {2, 
               15}, {3, 4}, {3, 8}, {3, 16}, {4, 5}, {4, 9}, {4, 17}, {5, 
               6}, {5, 10}, {5, 18}, {6, 7}, {6, 11}, {7, 8}, {7, 12}, {8, 
               9}, {8, 13}, {9, 10}, {9, 14}, {10, 11}, {10, 15}, {11, 12}, {
               11, 16}, {12, 13}, {12, 17}, {13, 14}, {13, 18}, {14, 15}, {15,
                16}, {16, 17}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           Annotation[#, 
            VertexCoordinateRules -> {{0.94, 0.342}, {0.766, 0.643}, {0.5, 
             0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
             0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-circulant graph (1,5)\""],
        Annotation[#, "18-circulant graph (1,5)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.94, 0.342}, {0.766, 0.643}, {0.5, 
            0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
            0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
             0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 10}, {1, 16}, {2, 5}, {2, 11}, {2, 17}, {3,
                6}, {3, 12}, {3, 18}, {4, 7}, {4, 13}, {5, 8}, {5, 14}, {6, 
               9}, {6, 15}, {7, 10}, {7, 16}, {8, 11}, {8, 17}, {9, 12}, {9, 
               18}, {10, 13}, {11, 14}, {12, 15}, {13, 16}, {14, 17}, {15, 
               18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.94, 0.342}, {0.766, 0.643}, {0.5, 
             0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
             0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-circulant graph (3,9)\""],
        Annotation[#, "18-circulant graph (3,9)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -590.4000000000001}, {
      Center, Center}, {360.0000000000001, 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {2., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 4}, {2, 4}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {2., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"claw\""],
        Annotation[#, "claw", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -590.4000000000001}, {
      Center, Center}, {360.0000000000002, 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -1.}, {2., 
            0.}, {2., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -1.}, {2., 
             0.}, {2., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,3)\""],
        Annotation[#, "complete bipartite graph (2,3)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -590.4000000000001}, {
      Center, Center}, {360.0000000000002, 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -1.5}, {
            2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {2, 
               5}, {2, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -1.5}, {
             2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,4)\""],
        Annotation[#, "complete bipartite graph (2,4)", "Tooltip"]& ],
       TraditionalForm], {2160., -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -2.}, {
            2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 3}, {2, 
               4}, {2, 5}, {2, 6}, {2, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -2.}, {
             2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,5)\""],
        Annotation[#, "complete bipartite graph (2,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -590.4000000000001}, {
      Center, Center}, {359.99999999999955`, 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 4}, {2, 5}, {2, 
               6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,4)\""],
        Annotation[#, "complete bipartite graph (3,4)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 4}, {2, 
               5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3,
                8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,5)\""],
        Annotation[#, "complete bipartite graph (3,5)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 5}, {2, 6}, {2, 
               7}, {2, 8}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4,
                7}, {4, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,4)\""],
        Annotation[#, "complete bipartite graph (4,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -590.4000000000001}, {
      Center, Center}, {360., 360.00000000000006`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {2, 5}, {2, 
               6}, {2, 7}, {2, 8}, {2, 9}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3,
                9}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,5)\""],
        Annotation[#, "complete bipartite graph (4,5)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 
               7}, {2, 8}, {2, 9}, {2, 10}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {
               3, 10}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
               7}, {5, 8}, {5, 9}, {5, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (5,5)\""],
        Annotation[#, "complete bipartite graph (5,5)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 6}, {1, 8}, {1, 10}, {1, 12}, {2, 
               3}, {2, 5}, {2, 7}, {2, 9}, {2, 11}, {3, 4}, {3, 6}, {3, 8}, {
               3, 10}, {3, 12}, {4, 5}, {4, 7}, {4, 9}, {4, 11}, {5, 6}, {5, 
               8}, {5, 10}, {5, 12}, {6, 7}, {6, 9}, {6, 11}, {7, 8}, {7, 
               10}, {7, 12}, {8, 9}, {8, 11}, {9, 10}, {9, 12}, {10, 11}, {11,
                12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (6,6)\""],
        Annotation[#, "complete bipartite graph (6,6)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -984.0000000000001}, {
      Center, Center}, {360.0000000000001, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[
           GraphicsComplexBox[{{0.901, 0.434}, {0.623, 0.782}, {0.223, 
            0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
            0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 6}, {1, 8}, {1, 10}, {1, 12}, {1, 
               14}, {2, 3}, {2, 5}, {2, 7}, {2, 9}, {2, 11}, {2, 13}, {3, 
               4}, {3, 6}, {3, 8}, {3, 10}, {3, 12}, {3, 14}, {4, 5}, {4, 
               7}, {4, 9}, {4, 11}, {4, 13}, {5, 6}, {5, 8}, {5, 10}, {5, 
               12}, {5, 14}, {6, 7}, {6, 9}, {6, 11}, {6, 13}, {7, 8}, {7, 
               10}, {7, 12}, {7, 14}, {8, 9}, {8, 11}, {8, 13}, {9, 10}, {9, 
               12}, {9, 14}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 
               13}, {13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.901, 0.434}, {0.623, 0.782}, {0.223, 
             0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
             0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (7,7)\""],
        Annotation[#, "complete bipartite graph (7,7)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -984.0000000000001}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {-1.5, -1.}, {
            1.5, -1.}, {-2.25, -2.}, {-0.75, -2.}, {0.75, -2.}, {
            2.25, -2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {-1.5, -1.}, {
             1.5, -1.}, {-2.25, -2.}, {-0.75, -2.}, {0.75, -2.}, {
             2.25, -2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete binary tree of depth 3\""],
        Annotation[#, "complete binary tree of depth 3", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -984.0000000000001}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {-2., -1.}, {
            2., -1.}, {-3., -2.}, {-1., -2.}, {1., -2.}, {
            3., -2.}, {-3.5, -3.}, {-2.5, -3.}, {-1.5, -3.}, {-0.5, -3.}, {
            0.5, -3.}, {1.5, -3.}, {2.5, -3.}, {3.5, -3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}, {4, 
               8}, {4, 9}, {5, 10}, {5, 11}, {6, 12}, {6, 13}, {7, 14}, {7, 
               15}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {-2., -1.}, {
             2., -1.}, {-3., -2.}, {-1., -2.}, {1., -2.}, {
             3., -2.}, {-3.5, -3.}, {-2.5, -3.}, {-1.5, -3.}, {-0.5, -3.}, {
             0.5, -3.}, {1.5, -3.}, {2.5, -3.}, {3.5, -3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete binary tree of depth 4\""],
        Annotation[#, "complete binary tree of depth 4", "Tooltip"]& ],
       TraditionalForm], {2160., -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {-2.667, -1.}, {0., -1.}, {
            2.667, -1.}, {-3.556, -2.}, {-2.667, -2.}, {-1.778, -2.}, \
{-0.889, -2.}, {0., -2.}, {0.889, -2.}, {1.778, -2.}, {2.667, -2.}, {
            3.556, -2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {3, 
               8}, {3, 9}, {3, 10}, {4, 11}, {4, 12}, {4, 13}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {-2.667, -1.}, {0., -1.}, {
             2.667, -1.}, {-3.556, -2.}, {-2.667, -2.}, {-1.778, -2.}, \
{-0.889, -2.}, {0., -2.}, {0.889, -2.}, {1.778, -2.}, {2.667, -2.}, {
             3.556, -2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete ternary tree of depth 3\""],
        Annotation[#, "complete ternary tree of depth 3", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -984.0000000000001}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 8}, {2, 
               9}, {2, 10}, {3, 6}, {3, 7}, {3, 9}, {3, 10}, {4, 6}, {4, 7}, {
               4, 8}, {4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-crown graph\""],
        Annotation[#, "5-crown graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.5}, {1., -1.5}, {1., -0.5}, {1., 
            0.5}, {1., 1.5}, {1., 2.5}, {2., -2.5}, {2., -1.5}, {2., -0.5}, {
            2., 0.5}, {2., 1.5}, {2., 2.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {2, 7}, {2, 
               9}, {2, 10}, {2, 11}, {2, 12}, {3, 7}, {3, 8}, {3, 10}, {3, 
               11}, {3, 12}, {4, 7}, {4, 8}, {4, 9}, {4, 11}, {4, 12}, {5, 
               7}, {5, 8}, {5, 9}, {5, 10}, {5, 12}, {6, 7}, {6, 8}, {6, 9}, {
               6, 10}, {6, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.5}, {1., -1.5}, {1., -0.5}, {1.,
              0.5}, {1., 1.5}, {1., 2.5}, {2., -2.5}, {2., -1.5}, {
             2., -0.5}, {2., 0.5}, {2., 1.5}, {2., 2.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-crown graph\""],
        Annotation[#, "6-crown graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -3.}, {1., -2.}, {1., -1.}, {1., 
            0.}, {1., 1.}, {1., 2.}, {1., 3.}, {2., -3.}, {2., -2.}, {
            2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}, {2., 3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {
               2, 8}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {3, 8}, {3,
                9}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {4, 8}, {4, 9}, {4, 
               10}, {4, 12}, {4, 13}, {4, 14}, {5, 8}, {5, 9}, {5, 10}, {5, 
               11}, {5, 13}, {5, 14}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 
               12}, {6, 14}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 
               13}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -3.}, {1., -2.}, {1., -1.}, {1., 
             0.}, {1., 1.}, {1., 2.}, {1., 3.}, {2., -3.}, {2., -2.}, {
             2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}, {2., 3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-crown graph\""],
        Annotation[#, "7-crown graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -984.0000000000001}, {
      Center, Center}, {360., 360.0000000000002}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -3.5}, {1., -2.5}, {1., -1.5}, {
            1., -0.5}, {1., 0.5}, {1., 1.5}, {1., 2.5}, {1., 3.5}, {
            2., -3.5}, {2., -2.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 
            1.5}, {2., 2.5}, {2., 3.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {
               1, 16}, {2, 9}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {
               2, 16}, {3, 9}, {3, 10}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {
               3, 16}, {4, 9}, {4, 10}, {4, 11}, {4, 13}, {4, 14}, {4, 15}, {
               4, 16}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 14}, {5, 15}, {
               5, 16}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 15}, {
               6, 16}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {
               7, 16}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {
               8, 15}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -3.5}, {1., -2.5}, {1., -1.5}, {
             1., -0.5}, {1., 0.5}, {1., 1.5}, {1., 2.5}, {1., 3.5}, {
             2., -3.5}, {2., -2.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 
             1.5}, {2., 2.5}, {2., 3.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-crown graph\""],
        Annotation[#, "8-crown graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1377.6000000000001`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -4.}, {1., -3.}, {1., -2.}, {
            1., -1.}, {1., 0.}, {1., 1.}, {1., 2.}, {1., 3.}, {1., 4.}, {
            2., -4.}, {2., -3.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {
            2., 2.}, {2., 3.}, {2., 4.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {
               1, 17}, {1, 18}, {2, 10}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {
               2, 16}, {2, 17}, {2, 18}, {3, 10}, {3, 11}, {3, 13}, {3, 14}, {
               3, 15}, {3, 16}, {3, 17}, {3, 18}, {4, 10}, {4, 11}, {4, 12}, {
               4, 14}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {5, 10}, {5, 11}, {
               5, 12}, {5, 13}, {5, 15}, {5, 16}, {5, 17}, {5, 18}, {6, 10}, {
               6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 16}, {6, 17}, {6, 18}, {
               7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 15}, {7, 17}, {
               7, 18}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {
               8, 16}, {8, 18}, {9, 10}, {9, 11}, {9, 12}, {9, 13}, {9, 14}, {
               9, 15}, {9, 16}, {9, 17}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -4.}, {1., -3.}, {1., -2.}, {
             1., -1.}, {1., 0.}, {1., 1.}, {1., 2.}, {1., 3.}, {1., 4.}, {
             2., -4.}, {2., -3.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {
             2., 2.}, {2., 3.}, {2., 4.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-crown graph\""],
        Annotation[#, "9-crown graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1377.6000000000001`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -4.5}, {1., -3.5}, {1., -2.5}, {
            1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 1.5}, {1., 2.5}, {1., 
            3.5}, {1., 4.5}, {2., -4.5}, {2., -3.5}, {2., -2.5}, {2., -1.5}, {
            2., -0.5}, {2., 0.5}, {2., 1.5}, {2., 2.5}, {2., 3.5}, {2., 
            4.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 17}, {
               1, 18}, {1, 19}, {1, 20}, {2, 11}, {2, 13}, {2, 14}, {2, 15}, {
               2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {3, 11}, {3, 12}, {
               3, 14}, {3, 15}, {3, 16}, {3, 17}, {3, 18}, {3, 19}, {3, 20}, {
               4, 11}, {4, 12}, {4, 13}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {
               4, 19}, {4, 20}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 16}, {
               5, 17}, {5, 18}, {5, 19}, {5, 20}, {6, 11}, {6, 12}, {6, 13}, {
               6, 14}, {6, 15}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {7, 11}, {
               7, 12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, {7, 18}, {7, 19}, {
               7, 20}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {
               8, 17}, {8, 19}, {8, 20}, {9, 11}, {9, 12}, {9, 13}, {9, 14}, {
               9, 15}, {9, 16}, {9, 17}, {9, 18}, {9, 20}, {10, 11}, {10, 
               12}, {10, 13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 
               18}, {10, 19}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -4.5}, {1., -3.5}, {1., -2.5}, {
             1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 1.5}, {1., 2.5}, {1., 
             3.5}, {1., 4.5}, {2., -4.5}, {2., -3.5}, {2., -2.5}, {
             2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}, {2., 2.5}, {2., 
             3.5}, {2., 4.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-crown graph\""],
        Annotation[#, "10-crown graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1377.6000000000001`}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.333, -0.333}, {-1., -1.}, {-0.333, 
            0.333}, {-1., 1.}, {0.333, -0.333}, {1., -1.}, {0.333, 0.333}, {
            1., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 
               7}, {4, 8}, {5, 6}, {5, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.333, -0.333}, {-1., -1.}, {-0.333, 
             0.333}, {-1., 1.}, {0.333, -0.333}, {1., -1.}, {0.333, 0.333}, {
             1., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubical graph\""],
        Annotation[#, "cubical graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1377.6000000000001`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.981, 0.195}, {0.831, 0.555}, {0.556, 
            0.832}, {0.195, 0.981}, {-0.195, 0.981}, {-0.555, 0.831}, {-0.832,
             0.556}, {-0.981, 
            0.195}, {-0.981, -0.195}, {-0.831, -0.555}, {-0.556, -0.832}, \
{-0.195, -0.981}, {0.195, -0.981}, {0.555, -0.831}, {0.832, -0.556}, {
            0.981, -0.195}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 16}, {2, 3}, {2, 11}, {3, 4}, {3, 
               10}, {4, 5}, {4, 13}, {5, 6}, {5, 12}, {6, 7}, {6, 15}, {7, 
               8}, {7, 14}, {8, 9}, {9, 10}, {9, 16}, {10, 11}, {11, 12}, {12,
                13}, {13, 14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.981, 0.195}, {0.831, 0.555}, {0.556, 
             0.832}, {0.195, 0.981}, {-0.195, 0.981}, {-0.555, 
             0.831}, {-0.832, 0.556}, {-0.981, 
             0.195}, {-0.981, -0.195}, {-0.831, -0.555}, {-0.556, -0.832}, \
{-0.195, -0.981}, {0.195, -0.981}, {0.555, -0.831}, {0.832, -0.556}, {
             0.981, -0.195}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubic transitive graph 19\""],
        Annotation[#, "cubic transitive graph 19", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1377.6000000000001`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.94, 0.342}, {0.766, 
            0.643}, {-0.174, -0.985}, {0.174, -0.985}, {-0.766, 
            0.643}, {-0.94, 0.342}, {0.5, 0.866}, {1., 0.}, {
            0.5, -0.866}, {-0.5, -0.866}, {-1., 0.}, {-0.5, 0.866}, {0.174, 
            0.985}, {0.94, -0.342}, {
            0.766, -0.643}, {-0.766, -0.643}, {-0.94, -0.342}, {-0.174, 
            0.985}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {1, 12}, {1, 2}, {2, 9}, {2, 7}, {3, 8}, {3, 
               10}, {3, 4}, {4, 9}, {4, 11}, {5, 12}, {5, 10}, {5, 6}, {6, 
               11}, {6, 7}, {7, 13}, {8, 14}, {9, 15}, {10, 16}, {11, 17}, {
               12, 18}, {13, 14}, {13, 18}, {14, 15}, {15, 16}, {16, 17}, {17,
                18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.94, 0.342}, {0.766, 
             0.643}, {-0.174, -0.985}, {0.174, -0.985}, {-0.766, 
             0.643}, {-0.94, 0.342}, {0.5, 0.866}, {1., 0.}, {
             0.5, -0.866}, {-0.5, -0.866}, {-1., 0.}, {-0.5, 0.866}, {0.174, 
             0.985}, {0.94, -0.342}, {
             0.766, -0.643}, {-0.766, -0.643}, {-0.94, -0.342}, {-0.174, 
             0.985}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubic transitive graph 20\""],
        Annotation[#, "cubic transitive graph 20", "Tooltip"]& ],
       TraditionalForm], {2160., -1377.6000000000001`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.891, 0.454}, {0.707, 0.707}, {0.454, 
            0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454, 0.891}, {-0.707,
             0.707}, {-0.891, 0.454}, {-0.988, 
            0.156}, {-0.988, -0.156}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {0.454, -0.891}, {
            0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}, {0.988, 
            0.156}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 20}, {2, 3}, {2, 15}, {3, 4}, {3, 
               10}, {4, 5}, {4, 17}, {5, 6}, {5, 12}, {6, 7}, {6, 19}, {7, 
               8}, {7, 14}, {8, 9}, {9, 10}, {9, 16}, {10, 11}, {11, 12}, {11,
                18}, {12, 13}, {13, 14}, {13, 20}, {14, 15}, {15, 16}, {16, 
               17}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.891, 0.454}, {0.707, 0.707}, {0.454, 
             0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454, 
             0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 
             0.156}, {-0.988, -0.156}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {0.454, -0.891}, {
             0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}, {0.988, 
             0.156}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubic transitive graph 25\""],
        Annotation[#, "cubic transitive graph 25", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1377.6000000000001`}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.988, 0.156}, {0.891, 0.454}, {0.707, 
            0.707}, {0.454, 0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454, 
            0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 
            0.156}, {-0.988, -0.156}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {0.454, -0.891}, {
            0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 10}, {1, 20}, {2, 3}, {2, 13}, {3, 4}, {3, 
               12}, {4, 5}, {4, 15}, {5, 6}, {5, 14}, {6, 7}, {6, 17}, {7, 
               8}, {7, 16}, {8, 9}, {8, 19}, {9, 10}, {9, 18}, {10, 11}, {11, 
               12}, {11, 20}, {12, 13}, {13, 14}, {14, 15}, {15, 16}, {16, 
               17}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.988, 0.156}, {0.891, 0.454}, {0.707, 
             0.707}, {0.454, 0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454,
              0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 
             0.156}, {-0.988, -0.156}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {0.454, -0.891}, {
             0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubic transitive graph 29\""],
        Annotation[#, "cubic transitive graph 29", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1377.6000000000001`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-cycle graph\""],
        Annotation[#, "6-cycle graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1377.6000000000001`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-cycle graph\""],
        Annotation[#, "8-cycle graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1377.6000000000001`}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 0.}, {-0.809, -0.588}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 10}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-cycle graph\""],
        Annotation[#, "10-cycle graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1771.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.259, -0.966}, {0.259, -0.966}, {
            0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 0.707}, {
            0.259, 0.966}, {-0.259, 0.966}, {-0.707, 0.707}, {-0.966, 
            0.259}, {-0.966, -0.259}, {-0.707, -0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 12}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.259, -0.966}, {0.259, -0.966}, {
             0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 
             0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
             0.707}, {-0.966, 0.259}, {-0.966, -0.259}, {-0.707, -0.707}}]& ],
          
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-cycle graph\""],
        Annotation[#, "12-cycle graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1771.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.222, -0.975}, {0.223, -0.975}, {
            0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {0.623,
             0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
            0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 14}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13,
                14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.222, -0.975}, {0.223, -0.975}, {
             0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {
             0.623, 0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
             0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-cycle graph\""],
        Annotation[#, "14-cycle graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1771.2}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.195, -0.981}, {0.195, -0.981}, {
            0.555, -0.832}, {0.831, -0.556}, {0.981, -0.195}, {0.981, 
            0.195}, {0.832, 0.555}, {0.556, 0.831}, {0.195, 0.981}, {-0.195, 
            0.981}, {-0.555, 0.832}, {-0.831, 0.556}, {-0.981, 
            0.195}, {-0.981, -0.195}, {-0.832, -0.555}, {-0.556, -0.831}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 16}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13,
                14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.195, -0.981}, {0.195, -0.981}, {
             0.555, -0.832}, {0.831, -0.556}, {0.981, -0.195}, {0.981, 
             0.195}, {0.832, 0.555}, {0.556, 0.831}, {0.195, 0.981}, {-0.195, 
             0.981}, {-0.555, 0.832}, {-0.831, 0.556}, {-0.981, 
             0.195}, {-0.981, -0.195}, {-0.832, -0.555}, {-0.556, -0.831}}]& \
],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-cycle graph\""],
        Annotation[#, "16-cycle graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1771.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.174, -0.985}, {0.174, -0.985}, {
            0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1., 0.}, {0.94, 
            0.342}, {0.766, 0.643}, {0.5, 0.866}, {0.174, 0.985}, {-0.174, 
            0.985}, {-0.5, 0.866}, {-0.766, 0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 18}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13,
                14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.174, -0.985}, {0.174, -0.985}, {
             0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1., 0.}, {0.94, 
             0.342}, {0.766, 0.643}, {0.5, 0.866}, {0.174, 0.985}, {-0.174, 
             0.985}, {-0.5, 0.866}, {-0.766, 0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-cycle graph\""],
        Annotation[#, "18-cycle graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1771.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.156, -0.988}, {0.157, -0.988}, {
            0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {
            0.988, -0.156}, {0.988, 0.157}, {0.891, 0.454}, {0.707, 0.707}, {
            0.454, 0.891}, {0.156, 0.988}, {-0.157, 0.988}, {-0.454, 
            0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 
            0.156}, {-0.988, -0.157}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 20}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13,
                14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 
               20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.156, -0.988}, {0.157, -0.988}, {
             0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {
             0.988, -0.156}, {0.988, 0.157}, {0.891, 0.454}, {0.707, 0.707}, {
             0.454, 0.891}, {0.156, 0.988}, {-0.157, 0.988}, {-0.454, 
             0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 
             0.156}, {-0.988, -0.157}, {-0.891, -0.454}, {-0.707, -0.707}, \
{-0.454, -0.891}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"20-cycle graph\""],
        Annotation[#, "20-cycle graph", "Tooltip"]& ],
       TraditionalForm], {2160., -1771.2}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.988, -0.156}, {-0.891, -0.454}, \
{-0.707, -0.707}, {-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {
            0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {
            0.988, -0.156}, {0.988, 0.156}, {0.891, 0.454}, {0.707, 0.707}, {
            0.454, 0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454, 
            0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 0.156}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 20}, {2, 3}, {2, 17}, {3, 4}, {3, 
               12}, {4, 5}, {4, 15}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {7, 
               16}, {8, 9}, {8, 19}, {9, 10}, {9, 14}, {10, 11}, {11, 12}, {
               11, 20}, {12, 13}, {13, 14}, {13, 18}, {14, 15}, {15, 16}, {16,
                17}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.988, -0.156}, {-0.891, -0.454}, \
{-0.707, -0.707}, {-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {
             0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {
             0.988, -0.156}, {0.988, 0.156}, {0.891, 0.454}, {0.707, 0.707}, {
             0.454, 0.891}, {0.156, 0.988}, {-0.156, 0.988}, {-0.454, 
             0.891}, {-0.707, 0.707}, {-0.891, 0.454}, {-0.988, 0.156}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Desargues graph\""],
        Annotation[#, "Desargues graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1771.2}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{-1., 0.}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> {{-1., 0.}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"2-empty graph\""],
        Annotation[#, "2-empty graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1771.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, 0.866}, {-0.5, -0.866}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, 0.866}, {-0.5, -0.866}, {1., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-empty graph\""],
        Annotation[#, "3-empty graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1771.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-1., 0.}, {0., -1.}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-1., 0.}, {0., -1.}, {1., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-empty graph\""],
        Annotation[#, "4-empty graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1771.2}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.309, 0.951}, {-0.809, 
            0.588}, {-0.809, -0.588}, {0.309, -0.951}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.309, 0.951}, {-0.809, 
             0.588}, {-0.809, -0.588}, {0.309, -0.951}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-empty graph\""],
        Annotation[#, "5-empty graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.5, 0.866}, {-0.5, 0.866}, {-1., 
            0.}, {-0.5, -0.866}, {0.5, -0.866}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.5, 0.866}, {-0.5, 0.866}, {-1., 
             0.}, {-0.5, -0.866}, {0.5, -0.866}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-empty graph\""],
        Annotation[#, "6-empty graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.623, 0.782}, {-0.223, 0.975}, {-0.901,
             0.434}, {-0.901, -0.434}, {-0.223, -0.975}, {0.623, -0.782}, {1.,
             0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.623, 0.782}, {-0.223, 
             0.975}, {-0.901, 0.434}, {-0.901, -0.434}, {-0.223, -0.975}, {
             0.623, -0.782}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-empty graph\""],
        Annotation[#, "7-empty graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2164.7999999999997`}, {
      Center, Center}, {360.0000000000001, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, 0.707}, {0., 1.}, {-0.707, 
            0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}, {
            1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, 0.707}, {0., 1.}, {-0.707, 
             0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-empty graph\""],
        Annotation[#, "8-empty graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2164.7999999999997`}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
            0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
            0.174, -0.985}, {0.766, -0.643}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
             0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
             0.174, -0.985}, {0.766, -0.643}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-empty graph\""],
        Annotation[#, "9-empty graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2164.7999999999997`}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-empty graph\""],
        Annotation[#, "10-empty graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
            0.99}, {-0.655, 0.756}, {-0.959, 
            0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
            0.415, -0.91}, {0.841, -0.541}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
             0.99}, {-0.655, 0.756}, {-0.959, 
             0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
             0.415, -0.91}, {0.841, -0.541}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-empty graph\""],
        Annotation[#, "11-empty graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2164.7999999999997`}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-empty graph\""],
        Annotation[#, "12-empty graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.885, 0.465}, {0.568, 0.823}, {0.121, 
            0.993}, {-0.355, 0.935}, {-0.749, 0.663}, {-0.971, 
            0.239}, {-0.971, -0.239}, {-0.749, -0.663}, {-0.355, -0.935}, {
            0.121, -0.993}, {0.568, -0.823}, {0.885, -0.465}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.885, 0.465}, {0.568, 0.823}, {0.121, 
             0.993}, {-0.355, 0.935}, {-0.749, 0.663}, {-0.971, 
             0.239}, {-0.971, -0.239}, {-0.749, -0.663}, {-0.355, -0.935}, {
             0.121, -0.993}, {0.568, -0.823}, {0.885, -0.465}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"13-empty graph\""],
        Annotation[#, "13-empty graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.901, 0.434}, {0.623, 0.782}, {0.223, 
            0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
            0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.901, 0.434}, {0.623, 0.782}, {0.223, 
             0.975}, {-0.223, 0.975}, {-0.623, 0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}, {-0.223, -0.975}, {
             0.223, -0.975}, {0.623, -0.782}, {0.901, -0.434}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-empty graph\""],
        Annotation[#, "14-empty graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2164.7999999999997`}, {
      Center, Center}, {360., 359.9999999999998}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.914, 0.407}, {0.669, 0.743}, {0.309, 
            0.951}, {-0.105, 0.995}, {-0.5, 0.866}, {-0.809, 0.588}, {-0.978, 
            0.208}, {-0.978, -0.208}, {-0.809, -0.588}, {-0.5, -0.866}, \
{-0.105, -0.995}, {0.309, -0.951}, {0.669, -0.743}, {0.914, -0.407}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ]}}],
           Annotation[#, 
            VertexCoordinateRules -> {{0.914, 0.407}, {0.669, 0.743}, {0.309, 
             0.951}, {-0.105, 0.995}, {-0.5, 0.866}, {-0.809, 0.588}, {-0.978,
              0.208}, {-0.978, -0.208}, {-0.809, -0.588}, {-0.5, -0.866}, \
{-0.105, -0.995}, {0.309, -0.951}, {0.669, -0.743}, {0.914, -0.407}, {1., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"15-empty graph\""],
        Annotation[#, "15-empty graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.924, 0.383}, {0.707, 0.707}, {0.383, 
            0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
            0.383}, {-1., 
            0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
            0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1., 
            0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.924, 0.383}, {0.707, 0.707}, {0.383, 
             0.924}, {0., 1.}, {-0.383, 0.924}, {-0.707, 0.707}, {-0.924, 
             0.383}, {-1., 
             0.}, {-0.924, -0.383}, {-0.707, -0.707}, {-0.383, -0.924}, {
             0., -1.}, {0.383, -0.924}, {0.707, -0.707}, {0.924, -0.383}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-empty graph\""],
        Annotation[#, "16-empty graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.932, 0.361}, {0.739, 0.674}, {0.446, 
            0.895}, {0.092, 0.996}, {-0.274, 0.962}, {-0.603, 0.798}, {-0.85, 
            0.526}, {-0.983, 
            0.184}, {-0.983, -0.184}, {-0.85, -0.526}, {-0.603, -0.798}, \
{-0.274, -0.962}, {0.092, -0.996}, {0.446, -0.895}, {0.739, -0.674}, {
            0.932, -0.361}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.932, 0.361}, {0.739, 0.674}, {0.446, 
             0.895}, {0.092, 0.996}, {-0.274, 0.962}, {-0.603, 0.798}, {-0.85,
              0.526}, {-0.983, 
             0.184}, {-0.983, -0.184}, {-0.85, -0.526}, {-0.603, -0.798}, \
{-0.274, -0.962}, {0.092, -0.996}, {0.446, -0.895}, {0.739, -0.674}, {
             0.932, -0.361}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"17-empty graph\""],
        Annotation[#, "17-empty graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2558.3999999999996`}, {
      Center, Center}, {360.0000000000001, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.94, 0.342}, {0.766, 0.643}, {0.5, 
            0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
            0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
             0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.94, 0.342}, {0.766, 0.643}, {0.5, 
             0.866}, {0.174, 0.985}, {-0.174, 0.985}, {-0.5, 0.866}, {-0.766, 
             0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {-0.174, \
-0.985}, {0.174, -0.985}, {0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-empty graph\""],
        Annotation[#, "18-empty graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2558.3999999999996`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.946, 0.325}, {0.789, 0.614}, {0.547, 
            0.837}, {0.245, 0.969}, {-0.083, 0.997}, {-0.402, 0.916}, {-0.677,
             0.736}, {-0.879, 0.476}, {-0.986, 
            0.165}, {-0.986, -0.165}, {-0.879, -0.476}, {-0.677, -0.736}, \
{-0.402, -0.916}, {-0.083, -0.997}, {0.245, -0.969}, {0.547, -0.837}, {
            0.789, -0.614}, {0.946, -0.325}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.946, 0.325}, {0.789, 0.614}, {0.547, 
             0.837}, {0.245, 0.969}, {-0.083, 0.997}, {-0.402, 
             0.916}, {-0.677, 0.736}, {-0.879, 0.476}, {-0.986, 
             0.165}, {-0.986, -0.165}, {-0.879, -0.476}, {-0.677, -0.736}, \
{-0.402, -0.916}, {-0.083, -0.997}, {0.245, -0.969}, {0.547, -0.837}, {
             0.789, -0.614}, {0.946, -0.325}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"19-empty graph\""],
        Annotation[#, "19-empty graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2558.3999999999996`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.951, 0.309}, {0.809, 0.588}, {0.588, 
            0.809}, {0.309, 0.951}, {0., 1.}, {-0.309, 0.951}, {-0.588, 
            0.809}, {-0.809, 0.588}, {-0.951, 0.309}, {-1., 
            0.}, {-0.951, -0.309}, {-0.809, -0.588}, {-0.588, -0.809}, \
{-0.309, -0.951}, {0., -1.}, {0.309, -0.951}, {0.588, -0.809}, {
            0.809, -0.588}, {0.951, -0.309}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.951, 0.309}, {0.809, 0.588}, {0.588, 
             0.809}, {0.309, 0.951}, {0., 1.}, {-0.309, 0.951}, {-0.588, 
             0.809}, {-0.809, 0.588}, {-0.951, 0.309}, {-1., 
             0.}, {-0.951, -0.309}, {-0.809, -0.588}, {-0.588, -0.809}, \
{-0.309, -0.951}, {0., -1.}, {0.309, -0.951}, {0.588, -0.809}, {
             0.809, -0.588}, {0.951, -0.309}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"20-empty graph\""],
        Annotation[#, "20-empty graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.141, 0.141}, {-0.141, -0.141}, {
            0.141, -0.141}, {0.141, 0.141}, {-0.283, 
            0.283}, {-0.283, -0.283}, {0.283, -0.283}, {0.283, 
            0.283}, {-0.424, 0.424}, {-0.424, -0.424}, {0.424, -0.424}, {
            0.424, 0.424}, {-0.566, 0.566}, {-0.566, -0.566}, {
            0.566, -0.566}, {0.566, 0.566}, {-0.707, 
            0.707}, {-0.707, -0.707}, {0.707, -0.707}, {0.707, 0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 10}, {1, 12}, {2, 3}, {2, 19}, {2, 
               13}, {3, 4}, {3, 6}, {3, 8}, {4, 19}, {4, 13}, {5, 6}, {5, 
               8}, {5, 14}, {5, 16}, {6, 7}, {6, 17}, {7, 8}, {7, 10}, {7, 
               12}, {8, 17}, {9, 10}, {9, 12}, {9, 18}, {9, 20}, {10, 11}, {
               11, 12}, {11, 14}, {11, 16}, {13, 14}, {13, 16}, {14, 15}, {15,
                16}, {15, 18}, {15, 20}, {17, 18}, {17, 20}, {18, 19}, {19, 
               20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.141, 0.141}, {-0.141, -0.141}, {
             0.141, -0.141}, {0.141, 0.141}, {-0.283, 
             0.283}, {-0.283, -0.283}, {0.283, -0.283}, {0.283, 
             0.283}, {-0.424, 0.424}, {-0.424, -0.424}, {0.424, -0.424}, {
             0.424, 0.424}, {-0.566, 0.566}, {-0.566, -0.566}, {
             0.566, -0.566}, {0.566, 0.566}, {-0.707, 
             0.707}, {-0.707, -0.707}, {0.707, -0.707}, {0.707, 0.707}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Folkman graph\""],
        Annotation[#, "Folkman graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2558.3999999999996`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, -0.707}, {-0.259, -0.966}, {
            0.259, -0.966}, {0.707, -0.707}, {0.966, -0.259}, {0.966, 
            0.259}, {0.707, 0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
            0.707}, {-0.966, 0.259}, {-0.966, -0.259}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 12}, {1, 8}, {2, 3}, {2, 11}, {3, 4}, {3, 
               6}, {4, 5}, {4, 9}, {5, 6}, {5, 12}, {6, 7}, {7, 8}, {7, 10}, {
               8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, -0.707}, {-0.259, -0.966}, {
             0.259, -0.966}, {0.707, -0.707}, {0.966, -0.259}, {0.966, 
             0.259}, {0.707, 0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707,
              0.707}, {-0.966, 0.259}, {-0.966, -0.259}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Franklin graph\""],
        Annotation[#, "Franklin graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {1., 2.}, {
            2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 5}, {3, 6}, {4, 5}, {4, 
               7}, {5, 6}, {5, 8}, {6, 9}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {1., 
             2.}, {2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (3,3)\""],
        Annotation[#, "grid graph (3,3)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {1., 2.}, {
            2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}, {1., 4.}, {2., 
            4.}, {3., 4.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 5}, {3, 6}, {4, 5}, {4, 
               7}, {5, 6}, {5, 8}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {
               9, 12}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {1., 
             2.}, {2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}, {1., 
             4.}, {2., 4.}, {3., 4.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (3,4)\""],
        Annotation[#, "grid graph (3,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2558.3999999999996`}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {1., 2.}, {
            2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}, {1., 4.}, {2., 
            4.}, {3., 4.}, {1., 5.}, {2., 5.}, {3., 5.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 5}, {3, 6}, {4, 5}, {4, 
               7}, {5, 6}, {5, 8}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {
               9, 12}, {10, 11}, {10, 13}, {11, 12}, {11, 14}, {12, 15}, {13, 
               14}, {14, 15}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {1., 
             2.}, {2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}, {1., 
             4.}, {2., 4.}, {3., 4.}, {1., 5.}, {2., 5.}, {3., 5.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (3,5)\""],
        Annotation[#, "grid graph (3,5)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2952.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {4., 1.}, {
            1., 2.}, {2., 2.}, {3., 2.}, {4., 2.}, {1., 3.}, {2., 3.}, {3., 
            3.}, {4., 3.}, {1., 4.}, {2., 4.}, {3., 4.}, {4., 4.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 
               8}, {5, 6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 
               12}, {9, 10}, {9, 13}, {10, 11}, {10, 14}, {11, 12}, {11, 
               15}, {12, 16}, {13, 14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {4., 
             1.}, {1., 2.}, {2., 2.}, {3., 2.}, {4., 2.}, {1., 3.}, {2., 
             3.}, {3., 3.}, {4., 3.}, {1., 4.}, {2., 4.}, {3., 4.}, {4., 
             4.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (4,4)\""],
        Annotation[#, "grid graph (4,4)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2952.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {4., 1.}, {
            1., 2.}, {2., 2.}, {3., 2.}, {4., 2.}, {1., 3.}, {2., 3.}, {3., 
            3.}, {4., 3.}, {1., 4.}, {2., 4.}, {3., 4.}, {4., 4.}, {1., 5.}, {
            2., 5.}, {3., 5.}, {4., 5.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 
               8}, {5, 6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 
               12}, {9, 10}, {9, 13}, {10, 11}, {10, 14}, {11, 12}, {11, 
               15}, {12, 16}, {13, 14}, {13, 17}, {14, 15}, {14, 18}, {15, 
               16}, {15, 19}, {16, 20}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {4., 
             1.}, {1., 2.}, {2., 2.}, {3., 2.}, {4., 2.}, {1., 3.}, {2., 
             3.}, {3., 3.}, {4., 3.}, {1., 4.}, {2., 4.}, {3., 4.}, {4., 
             4.}, {1., 5.}, {2., 5.}, {3., 5.}, {4., 5.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (4,5)\""],
        Annotation[#, "grid graph (4,5)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2952.}, {
      Center, Center}, {360.0000000000001, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.222, 0.268}, {0.472, 0.268}, {0.222, 
            0.518}, {0.472, 0.518}, {0.194, 0.286}, {0.444, 0.286}, {0.194, 
            0.536}, {0.444, 0.536}, {0.166, 0.304}, {0.416, 0.304}, {0.166, 
            0.554}, {0.416, 0.554}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 
               7}, {4, 8}, {5, 6}, {5, 7}, {5, 9}, {6, 8}, {6, 10}, {7, 8}, {
               7, 11}, {8, 12}, {9, 10}, {9, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.222, 0.268}, {0.472, 0.268}, {0.222, 
             0.518}, {0.472, 0.518}, {0.194, 0.286}, {0.444, 0.286}, {0.194, 
             0.536}, {0.444, 0.536}, {0.166, 0.304}, {0.416, 0.304}, {0.166, 
             0.554}, {0.416, 0.554}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (2,2,3)\""],
        Annotation[#, "grid graph (2,2,3)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2952.}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.229, 0.264}, {0.479, 0.264}, {0.229, 
            0.514}, {0.479, 0.514}, {0.208, 0.277}, {0.458, 0.277}, {0.208, 
            0.527}, {0.458, 0.527}, {0.187, 0.291}, {0.437, 0.291}, {0.187, 
            0.541}, {0.437, 0.541}, {0.166, 0.304}, {0.416, 0.304}, {0.166, 
            0.554}, {0.416, 0.554}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 
               7}, {4, 8}, {5, 6}, {5, 7}, {5, 9}, {6, 8}, {6, 10}, {7, 8}, {
               7, 11}, {8, 12}, {9, 10}, {9, 11}, {9, 13}, {10, 12}, {10, 
               14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {13, 15}, {14, 
               16}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.229, 0.264}, {0.479, 0.264}, {0.229, 
             0.514}, {0.479, 0.514}, {0.208, 0.277}, {0.458, 0.277}, {0.208, 
             0.527}, {0.458, 0.527}, {0.187, 0.291}, {0.437, 0.291}, {0.187, 
             0.541}, {0.437, 0.541}, {0.166, 0.304}, {0.416, 0.304}, {0.166, 
             0.554}, {0.416, 0.554}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (2,2,4)\""],
        Annotation[#, "grid graph (2,2,4)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2952.}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.183, 0.211}, {0.383, 0.211}, {0.183, 
            0.411}, {0.383, 0.411}, {0.166, 0.222}, {0.366, 0.222}, {0.166, 
            0.422}, {0.366, 0.422}, {0.15, 0.232}, {0.35, 0.232}, {0.15, 
            0.432}, {0.35, 0.432}, {0.133, 0.243}, {0.333, 0.243}, {0.133, 
            0.443}, {0.333, 0.443}, {0.116, 0.254}, {0.316, 0.254}, {0.116, 
            0.454}, {0.316, 0.454}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 
               7}, {4, 8}, {5, 6}, {5, 7}, {5, 9}, {6, 8}, {6, 10}, {7, 8}, {
               7, 11}, {8, 12}, {9, 10}, {9, 11}, {9, 13}, {10, 12}, {10, 
               14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {13, 15}, {13, 
               17}, {14, 16}, {14, 18}, {15, 16}, {15, 19}, {16, 20}, {17, 
               18}, {17, 19}, {18, 20}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.183, 0.211}, {0.383, 0.211}, {0.183, 
             0.411}, {0.383, 0.411}, {0.166, 0.222}, {0.366, 0.222}, {0.166, 
             0.422}, {0.366, 0.422}, {0.15, 0.232}, {0.35, 0.232}, {0.15, 
             0.432}, {0.35, 0.432}, {0.133, 0.243}, {0.333, 0.243}, {0.133, 
             0.443}, {0.333, 0.443}, {0.116, 0.254}, {0.316, 0.254}, {0.116, 
             0.454}, {0.316, 0.454}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (2,2,5)\""],
        Annotation[#, "grid graph (2,2,5)", "Tooltip"]& ],
       TraditionalForm], {2160., -2952.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.139, 0.185}, {0.305, 0.185}, {0.139, 
            0.351}, {0.305, 0.351}, {0.139, 0.518}, {0.305, 0.518}, {0.111, 
            0.203}, {0.277, 0.203}, {0.111, 0.369}, {0.277, 0.369}, {0.111, 
            0.536}, {0.277, 0.536}, {0.083, 0.221}, {0.249, 0.221}, {0.083, 
            0.387}, {0.249, 0.387}, {0.083, 0.554}, {0.249, 0.554}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 7}, {2, 4}, {2, 8}, {3, 4}, {3, 
               5}, {3, 9}, {4, 6}, {4, 10}, {5, 6}, {5, 11}, {6, 12}, {7, 
               8}, {7, 9}, {7, 13}, {8, 10}, {8, 14}, {9, 10}, {9, 11}, {9, 
               15}, {10, 12}, {10, 16}, {11, 12}, {11, 17}, {12, 18}, {13, 
               14}, {13, 15}, {14, 16}, {15, 16}, {15, 17}, {16, 18}, {17, 
               18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.139, 0.185}, {0.305, 0.185}, {0.139, 
             0.351}, {0.305, 0.351}, {0.139, 0.518}, {0.305, 0.518}, {0.111, 
             0.203}, {0.277, 0.203}, {0.111, 0.369}, {0.277, 0.369}, {0.111, 
             0.536}, {0.277, 0.536}, {0.083, 0.221}, {0.249, 0.221}, {0.083, 
             0.387}, {0.249, 0.387}, {0.083, 0.554}, {0.249, 0.554}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (2,3,3)\""],
        Annotation[#, "grid graph (2,3,3)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2952.}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.900969, 0.433884}, {0.62349, 
            0.781831}, {0.222521, 0.974928}, {-0.222521, 0.974928}, {-0.62349,
             0.781831}, {-0.900969, 0.433884}, {-1., 
            0.}, {-0.900969, -0.433884}, {-0.62349, -0.781831}, {-0.222521, \
-0.974928}, {0.222521, -0.974928}, {0.62349, -0.781831}, {
            0.900969, -0.433884}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 14}, {2, 3}, {2, 11}, {3, 4}, {3, 
               8}, {4, 5}, {4, 13}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {7, 
               12}, {8, 9}, {9, 10}, {9, 14}, {10, 11}, {11, 12}, {12, 13}, {
               13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.900969, 0.433884}, {0.62349, 
             0.781831}, {0.222521, 0.974928}, {-0.222521, 
             0.974928}, {-0.62349, 0.781831}, {-0.900969, 0.433884}, {-1., 
             0.}, {-0.900969, -0.433884}, {-0.62349, -0.781831}, {-0.222521, \
-0.974928}, {0.222521, -0.974928}, {0.62349, -0.781831}, {
             0.900969, -0.433884}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Heawood graph\""],
        Annotation[#, "Heawood graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2952.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.002, 0.244}, {0., -0.26}, {0.41, 
            0.008}, {-0.396, 0.006}, {-0.044, 0.07}, {0.042, 
            0.076}, {-0.038, -0.066}, {0.048, -0.07}, {0., 0.}, {-0.204, 
            0.006}, {0.2, 0.008}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {2, 
               7}, {2, 8}, {3, 11}, {4, 10}, {5, 9}, {5, 10}, {6, 9}, {6, 
               11}, {7, 9}, {7, 10}, {8, 9}, {8, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.002, 0.244}, {0., -0.26}, {0.41, 
             0.008}, {-0.396, 0.006}, {-0.044, 0.07}, {0.042, 
             0.076}, {-0.038, -0.066}, {0.048, -0.07}, {0., 0.}, {-0.204, 
             0.006}, {0.2, 0.008}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Herschel graph\""],
        Annotation[#, "Herschel graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2952.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[
           GraphicsComplexBox[{{-0.383, 0.924}, {0.383, 
            0.924}, {-0.383, -0.924}, {0.924, -0.383}, {0.924, 
            0.383}, {-0.924, 0.383}, {-0.924, -0.383}, {
            0.383, -0.924}, {-0.707, 0.707}, {0., 1.}, {0.707, 0.707}, {1., 
            0.}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 9}, {1, 10}, {1, 11}, {1, 12}, {2, 9}, {2, 10}, {2,
                11}, {2, 13}, {3, 9}, {3, 12}, {3, 14}, {3, 15}, {4, 10}, {4, 
               12}, {4, 14}, {4, 16}, {5, 11}, {5, 12}, {5, 15}, {5, 16}, {6, 
               9}, {6, 13}, {6, 14}, {6, 15}, {7, 10}, {7, 13}, {7, 14}, {7, 
               16}, {8, 11}, {8, 13}, {8, 15}, {8, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, 0.924}, {0.383, 
             0.924}, {-0.383, -0.924}, {0.924, -0.383}, {0.924, 
             0.383}, {-0.924, 0.383}, {-0.924, -0.383}, {
             0.383, -0.924}, {-0.707, 0.707}, {0., 1.}, {0.707, 0.707}, {1., 
             0.}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Hoffman graph\""],
        Annotation[#, "Hoffman graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2952.}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-ladder graph\""],
        Annotation[#, "3-ladder graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-ladder graph\""],
        Annotation[#, "4-ladder graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-ladder graph\""],
        Annotation[#, "5-ladder graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -3345.5999999999995`}, {
      Center, Center}, {360.0000000000001, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}, {1., 
            6.}, {2., 6.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {9, 
               11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}, {1., 6.}, {2., 6.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-ladder graph\""],
        Annotation[#, "6-ladder graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -3345.5999999999995`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}, {1., 
            6.}, {2., 6.}, {1., 7.}, {2., 7.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {9, 
               11}, {10, 12}, {11, 12}, {11, 13}, {12, 14}, {13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}, {1., 6.}, {2., 6.}, {1., 7.}, {2., 7.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-ladder graph\""],
        Annotation[#, "7-ladder graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -3345.5999999999995`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}, {1., 
            6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 8.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {9, 
               11}, {10, 12}, {11, 12}, {11, 13}, {12, 14}, {13, 14}, {13, 
               15}, {14, 16}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}, {1., 6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 
             8.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-ladder graph\""],
        Annotation[#, "8-ladder graph", "Tooltip"]& ],
       TraditionalForm], {2160., -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}, {1., 
            6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 8.}, {1., 9.}, {
            2., 9.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {9, 
               11}, {10, 12}, {11, 12}, {11, 13}, {12, 14}, {13, 14}, {13, 
               15}, {14, 16}, {15, 16}, {15, 17}, {16, 18}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}, {1., 6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 
             8.}, {1., 9.}, {2., 9.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-ladder graph\""],
        Annotation[#, "9-ladder graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -3345.5999999999995`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}, {1., 
            6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 8.}, {1., 9.}, {
            2., 9.}, {1., 10.}, {2., 10.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}, {9, 
               11}, {10, 12}, {11, 12}, {11, 13}, {12, 14}, {13, 14}, {13, 
               15}, {14, 16}, {15, 16}, {15, 17}, {16, 18}, {17, 18}, {17, 
               19}, {18, 20}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}, {1., 6.}, {2., 6.}, {1., 7.}, {2., 7.}, {1., 8.}, {2., 
             8.}, {1., 9.}, {2., 9.}, {1., 10.}, {2., 10.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-ladder graph\""],
        Annotation[#, "10-ladder graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.831, 0.556}, {0.556, 0.831}, {0.195, 
            0.981}, {-0.195, 0.981}, {-0.556, 0.831}, {-0.831, 
            0.556}, {-0.981, 
            0.195}, {-0.981, -0.195}, {-0.831, -0.556}, {-0.556, -0.831}, \
{-0.195, -0.981}, {0.195, -0.981}, {0.556, -0.831}, {0.831, -0.556}, {
            0.981, -0.195}, {0.981, 0.195}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 16}, {2, 3}, {2, 13}, {3, 4}, {3, 
               8}, {4, 5}, {4, 15}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {7, 
               12}, {8, 9}, {9, 10}, {9, 14}, {10, 11}, {11, 12}, {11, 16}, {
               12, 13}, {13, 14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.831, 0.556}, {0.556, 0.831}, {0.195, 
             0.981}, {-0.195, 0.981}, {-0.556, 0.831}, {-0.831, 
             0.556}, {-0.981, 
             0.195}, {-0.981, -0.195}, {-0.831, -0.556}, {-0.556, -0.831}, \
{-0.195, -0.981}, {0.195, -0.981}, {0.556, -0.831}, {0.831, -0.556}, {
             0.981, -0.195}, {0.981, 0.195}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"M\[ODoubleDot]bius-Kantor graph\""],
        Annotation[#, "M\[ODoubleDot]bius-Kantor graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.588, -0.809}, {0.951, 0.309}, {0., 
            1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
            0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 10}, {2, 3}, {2, 7}, {3, 4}, {3, 
               8}, {4, 5}, {4, 9}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.588, -0.809}, {0.951, 0.309}, {0., 
             1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
             0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "5-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -3345.5999999999995`}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.434, -0.901}, {0.975, -0.222}, {0.782,
             0.623}, {0., 1.}, {-0.782, 
            0.624}, {-0.975, -0.222}, {-0.434, -0.901}, {0.868, -1.802}, {
            1.95, -0.445}, {1.564, 1.247}, {0., 2.}, {-1.564, 
            1.247}, {-1.95, -0.445}, {-0.868, -1.802}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 14}, {2, 3}, {2, 9}, {3, 4}, {3, 
               10}, {4, 5}, {4, 11}, {5, 6}, {5, 12}, {6, 7}, {6, 13}, {7, 
               8}, {7, 14}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {
               13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.434, -0.901}, {0.975, -0.222}, {
             0.782, 0.623}, {0., 1.}, {-0.782, 
             0.624}, {-0.975, -0.222}, {-0.434, -0.901}, {0.868, -1.802}, {
             1.95, -0.445}, {1.564, 1.247}, {0., 2.}, {-1.564, 
             1.247}, {-1.95, -0.445}, {-0.868, -1.802}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "7-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.342, -0.94}, {0.866, -0.5}, {0.985, 
            0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 0.766}, {-0.985, 
            0.173}, {-0.866, -0.5}, {-0.342, -0.94}, {0.684, -1.879}, {
            1.733, -1.}, {1.97, 0.347}, {1.285, 1.532}, {0., 2.}, {-1.286, 
            1.532}, {-1.97, 0.348}, {-1.732, -1.}, {-0.684, -1.879}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 10}, {1, 18}, {2, 3}, {2, 11}, {3, 4}, {3, 
               12}, {4, 5}, {4, 13}, {5, 6}, {5, 14}, {6, 7}, {6, 15}, {7, 
               8}, {7, 16}, {8, 9}, {8, 17}, {9, 10}, {9, 18}, {10, 11}, {11, 
               12}, {12, 13}, {13, 14}, {14, 15}, {15, 16}, {16, 17}, {17, 
               18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.342, -0.94}, {0.866, -0.5}, {0.985, 
             0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 0.766}, {-0.985, 
             0.173}, {-0.866, -0.5}, {-0.342, -0.94}, {0.684, -1.879}, {
             1.733, -1.}, {1.97, 0.347}, {1.285, 1.532}, {0., 2.}, {-1.286, 
             1.532}, {-1.97, 0.348}, {-1.732, -1.}, {-0.684, -1.879}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "9-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 
            0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
            0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
            0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
            0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 
            0.866}, {0.5, -0.866}, {0.173, -0.985}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 16}, {1, 15}, {2, 5}, {2, 17}, {2, 16}, {3,
                6}, {3, 18}, {3, 7}, {4, 7}, {4, 8}, {5, 8}, {5, 6}, {6, 9}, {
               7, 10}, {8, 11}, {9, 12}, {9, 13}, {10, 13}, {10, 14}, {11, 
               14}, {11, 12}, {12, 15}, {13, 16}, {14, 17}, {15, 18}, {17, 
               18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 
             0.985}, {-0.174, -0.985}, {-0.766, 0.643}, {-0.173, 
             0.985}, {-0.5, -0.866}, {-0.94, 0.342}, {-0.5, 
             0.866}, {-0.766, -0.643}, {-1., 0.}, {0.94, -0.342}, {1., 
             0.}, {-0.94, -0.342}, {0.766, -0.643}, {0.94, 0.342}, {0.5, 
             0.866}, {0.5, -0.866}, {0.173, -0.985}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Pappus graph\""],
        Annotation[#, "Pappus graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -3739.2}, {
      Center, Center}, {360.0000000000001, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> {{1., 0.}, {2., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"2-path graph\""],
        Annotation[#, "2-path graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -3739.2}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-path graph\""],
        Annotation[#, "3-path graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -3739.2}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-path graph\""],
        Annotation[#, "4-path graph", "Tooltip"]& ],
       TraditionalForm], {2160., -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-path graph\""],
        Annotation[#, "5-path graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -3739.2}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-path graph\""],
        Annotation[#, "6-path graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-path graph\""],
        Annotation[#, "7-path graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-path graph\""],
        Annotation[#, "8-path graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -3739.2}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-path graph\""],
        Annotation[#, "9-path graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-path graph\""],
        Annotation[#, "10-path graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-path graph\""],
        Annotation[#, "11-path graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -4132.799999999999}, {
      Center, Center}, {360.0000000000001, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-path graph\""],
        Annotation[#, "12-path graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -4132.799999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"13-path graph\""],
        Annotation[#, "13-path graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -4132.799999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 
               14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-path graph\""],
        Annotation[#, "14-path graph", "Tooltip"]& ],
       TraditionalForm], {2160., -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"15-path graph\""],
        Annotation[#, "15-path graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -4132.799999999999}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-path graph\""],
        Annotation[#, "16-path graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}, {17., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}, {15, 16}, {16, 17}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16.,
              0.}, {17., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"17-path graph\""],
        Annotation[#, "17-path graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}, {17., 
            0.}, {18., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}, {15, 16}, {16, 17}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16.,
              0.}, {17., 0.}, {18., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-path graph\""],
        Annotation[#, "18-path graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -4132.799999999999}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}, {17., 
            0.}, {18., 0.}, {19., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16.,
              0.}, {17., 0.}, {18., 0.}, {19., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"19-path graph\""],
        Annotation[#, "19-path graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -4526.4}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 
            0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}, {17., 
            0.}, {18., 0.}, {19., 0.}, {20., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
               14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}, {11., 0.}, {12., 0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16.,
              0.}, {17., 0.}, {18., 0.}, {19., 0.}, {20., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"20-path graph\""],
        Annotation[#, "20-path graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -4526.4}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {-1., -1.732}, {
            1., -1.732}, {2., 0.}, {1., 1.732}, {-1., 1.732}, {-2., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 7}, {2, 3}, {2, 8}, {3, 4}, {3, 
               9}, {4, 5}, {4, 10}, {5, 6}, {5, 11}, {6, 12}, {7, 8}, {7, 
               12}, {8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {-1., -1.732}, {
             1., -1.732}, {2., 0.}, {1., 1.732}, {-1., 1.732}, {-2., 0.}}]& ],
          
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-prism graph\""],
        Annotation[#, "6-prism graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -4526.4}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {-0.765, -1.847}, {
            0.765, -1.848}, {1.847, -0.765}, {1.848, 0.765}, {0.765, 
            1.847}, {-0.765, 1.848}, {-1.847, 0.765}, {-1.848, -0.765}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 9}, {2, 3}, {2, 10}, {3, 4}, {3, 
               11}, {4, 5}, {4, 12}, {5, 6}, {5, 13}, {6, 7}, {6, 14}, {7, 
               8}, {7, 15}, {8, 16}, {9, 10}, {9, 16}, {10, 11}, {11, 12}, {
               12, 13}, {13, 14}, {14, 15}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {-0.765, -1.847}, {
             0.765, -1.848}, {1.847, -0.765}, {1.848, 0.765}, {0.765, 
             1.847}, {-0.765, 1.848}, {-1.847, 0.765}, {-1.848, -0.765}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-prism graph\""],
        Annotation[#, "8-prism graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -4526.4}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.618, -1.902}, {0.618, -1.902}, {
            1.618, -1.175}, {2., 0.}, {1.618, 1.176}, {0.618, 1.902}, {-0.618,
             1.902}, {-1.618, 1.175}, {-2., 0.}, {-1.618, -1.176}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 10}, {1, 11}, {2, 3}, {2, 12}, {3, 4}, {3, 
               13}, {4, 5}, {4, 14}, {5, 6}, {5, 15}, {6, 7}, {6, 16}, {7, 
               8}, {7, 17}, {8, 9}, {8, 18}, {9, 10}, {9, 19}, {10, 20}, {11, 
               12}, {11, 20}, {12, 13}, {13, 14}, {14, 15}, {15, 16}, {16, 
               17}, {17, 18}, {18, 19}, {19, 20}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[20],
                "20"],
               Annotation[#, 20, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.618, -1.902}, {0.618, -1.902}, {
             1.618, -1.175}, {2., 0.}, {1.618, 1.176}, {0.618, 
             1.902}, {-0.618, 1.902}, {-1.618, 1.175}, {-2., 
             0.}, {-1.618, -1.176}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-prism graph\""],
        Annotation[#, "10-prism graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -4526.4}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.635, -1.955}, {0.635, -0.034}, {
            1.197, -1.159}, {1.197, -0.83}, {1.43, -1.392}, {1.43, -0.597}, {
            1.76, -1.392}, {1.76, -0.597}, {1.993, -1.159}, {1.993, -0.83}, {
            2.555, -1.955}, {2.555, -0.034}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 11}, {2, 3}, {2, 6}, {2, 
               12}, {3, 4}, {3, 5}, {3, 9}, {4, 6}, {4, 10}, {5, 6}, {5, 7}, {
               6, 8}, {7, 8}, {7, 9}, {7, 11}, {8, 10}, {8, 12}, {9, 10}, {9, 
               12}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.635, -1.955}, {0.635, -0.034}, {
             1.197, -1.159}, {1.197, -0.83}, {1.43, -1.392}, {1.43, -0.597}, {
             1.76, -1.392}, {1.76, -0.597}, {1.993, -1.159}, {1.993, -0.83}, {
             2.555, -1.955}, {2.555, -0.034}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 23\""],
        Annotation[#, "quartic transitive graph 23", "Tooltip"]& ],
       TraditionalForm], {2160., -4526.4}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.832, -1.069}, {0.914, -1.425}, {
            0.914, -0.712}, {1.141, -1.71}, {1.141, -0.427}, {1.47, -1.868}, {
            1.47, -0.269}, {1.835, -1.868}, {1.835, -0.269}, {2.164, -1.71}, {
            2.164, -0.427}, {2.391, -1.425}, {2.391, -0.712}, {
            2.472, -1.069}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 7}, {1, 14}, {2, 4}, {2, 8}, {2, 
               13}, {3, 4}, {3, 5}, {3, 12}, {4, 6}, {4, 11}, {5, 7}, {5, 
               10}, {5, 11}, {6, 8}, {6, 9}, {6, 12}, {7, 8}, {7, 9}, {8, 
               10}, {9, 11}, {9, 14}, {10, 12}, {10, 13}, {11, 13}, {12, 
               14}, {13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.832, -1.069}, {0.914, -1.425}, {
             0.914, -0.712}, {1.141, -1.71}, {1.141, -0.427}, {
             1.47, -1.868}, {1.47, -0.269}, {1.835, -1.868}, {
             1.835, -0.269}, {2.164, -1.71}, {2.164, -0.427}, {
             2.391, -1.425}, {2.391, -0.712}, {2.472, -1.069}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 31\""],
        Annotation[#, "quartic transitive graph 31", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -4526.4}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.826, -1.645}, {0.826, -0.442}, {
            1.061, -1.88}, {1.061, -0.207}, {1.261, -1.21}, {1.261, -0.877}, {
            1.496, -1.445}, {1.496, -0.642}, {1.829, -1.445}, {
            1.829, -0.642}, {2.064, -1.21}, {2.064, -0.877}, {2.264, -1.88}, {
            2.264, -0.207}, {2.499, -1.645}, {2.499, -0.442}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 15}, {2, 4}, {2, 6}, {2, 
               16}, {3, 4}, {3, 7}, {3, 13}, {4, 8}, {4, 14}, {5, 6}, {5, 
               7}, {5, 10}, {6, 8}, {6, 9}, {7, 9}, {7, 12}, {8, 10}, {8, 
               11}, {9, 11}, {9, 13}, {10, 12}, {10, 14}, {11, 12}, {11, 
               15}, {12, 16}, {13, 14}, {13, 15}, {14, 16}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.826, -1.645}, {0.826, -0.442}, {
             1.061, -1.88}, {1.061, -0.207}, {1.261, -1.21}, {
             1.261, -0.877}, {1.496, -1.445}, {1.496, -0.642}, {
             1.829, -1.445}, {1.829, -0.642}, {2.064, -1.21}, {
             2.064, -0.877}, {2.264, -1.88}, {2.264, -0.207}, {
             2.499, -1.645}, {2.499, -0.442}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 40\""],
        Annotation[#, "quartic transitive graph 40", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -4526.4}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.826, -1.645}, {0.826, -0.442}, {
            1.061, -1.88}, {1.061, -0.207}, {1.261, -1.21}, {1.261, -0.877}, {
            1.496, -1.445}, {1.496, -0.642}, {1.829, -1.445}, {
            1.829, -0.642}, {2.064, -1.21}, {2.064, -0.877}, {2.264, -1.88}, {
            2.264, -0.207}, {2.499, -1.645}, {2.499, -0.442}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 15}, {2, 4}, {2, 5}, {2, 
               16}, {3, 4}, {3, 9}, {3, 13}, {4, 10}, {4, 14}, {5, 6}, {5, 
               7}, {5, 11}, {6, 8}, {6, 12}, {7, 8}, {7, 9}, {7, 13}, {8, 
               10}, {8, 14}, {9, 10}, {9, 11}, {10, 12}, {11, 12}, {11, 16}, {
               12, 15}, {13, 14}, {13, 15}, {14, 16}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.826, -1.645}, {0.826, -0.442}, {
             1.061, -1.88}, {1.061, -0.207}, {1.261, -1.21}, {
             1.261, -0.877}, {1.496, -1.445}, {1.496, -0.642}, {
             1.829, -1.445}, {1.829, -0.642}, {2.064, -1.21}, {
             2.064, -0.877}, {2.264, -1.88}, {2.264, -0.207}, {
             2.499, -1.645}, {2.499, -0.442}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 48\""],
        Annotation[#, "quartic transitive graph 48", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -4526.4}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.843, -0.969}, {0.887, -1.223}, {
            0.887, -0.714}, {1.017, -1.448}, {1.017, -0.489}, {
            1.215, -1.614}, {1.215, -0.323}, {1.458, -1.703}, {
            1.458, -0.234}, {1.717, -1.703}, {1.717, -0.234}, {
            1.96, -1.614}, {1.96, -0.323}, {2.158, -1.448}, {2.158, -0.489}, {
            2.288, -1.223}, {2.288, -0.714}, {2.332, -0.969}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 7}, {1, 14}, {2, 4}, {2, 8}, {2, 
               13}, {3, 4}, {3, 5}, {3, 17}, {4, 6}, {4, 18}, {5, 7}, {5, 
               10}, {5, 11}, {6, 8}, {6, 9}, {6, 12}, {7, 9}, {7, 16}, {8, 
               10}, {8, 15}, {9, 11}, {9, 15}, {10, 12}, {10, 16}, {11, 12}, {
               11, 13}, {12, 14}, {13, 15}, {13, 18}, {14, 16}, {14, 17}, {15,
                17}, {16, 18}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.843, -0.969}, {0.887, -1.223}, {
             0.887, -0.714}, {1.017, -1.448}, {1.017, -0.489}, {
             1.215, -1.614}, {1.215, -0.323}, {1.458, -1.703}, {
             1.458, -0.234}, {1.717, -1.703}, {1.717, -0.234}, {
             1.96, -1.614}, {1.96, -0.323}, {2.158, -1.448}, {
             2.158, -0.489}, {2.288, -1.223}, {2.288, -0.714}, {
             2.332, -0.969}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 57\""],
        Annotation[#, "quartic transitive graph 57", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -4526.4}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.455, -1.051}, {0.739, -0.887}, {
            1.023, -2.035}, {1.023, -1.707}, {1.023, -1.379}, {
            1.023, -0.723}, {1.023, -0.067}, {1.307, -0.231}, {
            1.591, -1.707}, {1.591, -0.395}, {1.875, -1.871}, {
            2.158, -2.035}, {2.158, -1.379}, {2.158, -0.723}, {
            2.158, -0.395}, {2.158, -0.067}, {2.442, -1.215}, {
            2.726, -1.051}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 7}, {1, 13}, {2, 4}, {2, 6}, {2, 
               8}, {3, 4}, {3, 12}, {3, 14}, {4, 5}, {4, 11}, {5, 6}, {5, 
               9}, {5, 16}, {6, 10}, {6, 18}, {7, 8}, {7, 9}, {7, 16}, {8, 
               10}, {8, 15}, {9, 11}, {9, 13}, {10, 12}, {10, 14}, {11, 12}, {
               11, 17}, {12, 18}, {13, 14}, {13, 17}, {14, 15}, {15, 16}, {15,
                17}, {16, 18}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.455, -1.051}, {0.739, -0.887}, {
             1.023, -2.035}, {1.023, -1.707}, {1.023, -1.379}, {
             1.023, -0.723}, {1.023, -0.067}, {1.307, -0.231}, {
             1.591, -1.707}, {1.591, -0.395}, {1.875, -1.871}, {
             2.158, -2.035}, {2.158, -1.379}, {2.158, -0.723}, {
             2.158, -0.395}, {2.158, -0.067}, {2.442, -1.215}, {
             2.726, -1.051}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 66\""],
        Annotation[#, "quartic transitive graph 66", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -4920.}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.843, -0.969}, {0.887, -1.223}, {
            0.887, -0.714}, {1.017, -1.448}, {1.017, -0.489}, {
            1.215, -1.614}, {1.215, -0.323}, {1.458, -1.703}, {
            1.458, -0.234}, {1.717, -1.703}, {1.717, -0.234}, {
            1.96, -1.614}, {1.96, -0.323}, {2.158, -1.448}, {2.158, -0.489}, {
            2.288, -1.223}, {2.288, -0.714}, {2.332, -0.969}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 10}, {1, 15}, {2, 4}, {2, 9}, {2, 
               16}, {3, 5}, {3, 12}, {3, 13}, {4, 6}, {4, 11}, {4, 14}, {5, 
               6}, {5, 7}, {5, 18}, {6, 8}, {6, 17}, {7, 8}, {7, 9}, {7, 
               17}, {8, 10}, {8, 18}, {9, 11}, {9, 14}, {10, 12}, {10, 13}, {
               11, 13}, {11, 16}, {12, 14}, {12, 15}, {13, 15}, {14, 16}, {15,
                17}, {16, 18}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.843, -0.969}, {0.887, -1.223}, {
             0.887, -0.714}, {1.017, -1.448}, {1.017, -0.489}, {
             1.215, -1.614}, {1.215, -0.323}, {1.458, -1.703}, {
             1.458, -0.234}, {1.717, -1.703}, {1.717, -0.234}, {
             1.96, -1.614}, {1.96, -0.323}, {2.158, -1.448}, {
             2.158, -0.489}, {2.288, -1.223}, {2.288, -0.714}, {
             2.332, -0.969}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 67\""],
        Annotation[#, "quartic transitive graph 67", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -4920.}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{
            0., -1.061}, {-0.352, -0.352}, {-1.071, -1.071}, {-1.061, 0.}, {
            0.352, -0.352}, {1.071, -1.071}, {0., 0.}, {0., 0.}, {-0.352, 
            0.352}, {-1.071, 1.071}, {1.061, 0.}, {0.352, 0.352}, {1.071, 
            1.071}, {0., 1.061}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {2, 4}, {2, 7}, {3, 
               4}, {3, 8}, {4, 9}, {4, 10}, {5, 7}, {5, 11}, {6, 8}, {6, 
               11}, {7, 9}, {7, 12}, {8, 10}, {8, 13}, {9, 14}, {10, 14}, {11,
                12}, {11, 13}, {12, 14}, {13, 14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{
             0., -1.061}, {-0.352, -0.352}, {-1.071, -1.071}, {-1.061, 0.}, {
             0.352, -0.352}, {1.071, -1.071}, {0., 0.}, {0., 0.}, {-0.352, 
             0.352}, {-1.071, 1.071}, {1.061, 0.}, {0.352, 0.352}, {1.071, 
             1.071}, {0., 1.061}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"rhombic dodecahedral graph\""],
        Annotation[#, "rhombic dodecahedral graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -4920.}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{0., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> {{0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"singleton graph\""],
        Annotation[#, "singleton graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -4920.}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, 0.707}, {-0.707, -0.707}, {
            0.707, -0.707}, {0.707, 0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, 0.707}, {-0.707, -0.707}, {
             0.707, -0.707}, {0.707, 0.707}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"square graph\""],
        Annotation[#, "square graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -4920.}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, -0.707}, {0.707, -0.707}, {
            0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {2, 5}, {3, 5}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, -0.707}, {0.707, -0.707}, {
             0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-star graph\""],
        Annotation[#, "5-star graph", "Tooltip"]& ],
       TraditionalForm], {2160., -4920.}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.588, -0.809}, {0.588, -0.809}, {
            0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {2, 6}, {3, 6}, {4, 6}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.588, -0.809}, {0.588, -0.809}, {
             0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-star graph\""],
        Annotation[#, "6-star graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -4920.}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {2, 7}, {3, 7}, {4, 7}, {5, 7}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-star graph\""],
        Annotation[#, "7-star graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -4920.}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {2, 8}, {3, 8}, {4, 8}, {5, 8}, {6, 8}, {7, 
               8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-star graph\""],
        Annotation[#, "8-star graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -4920.}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 9}, {2, 9}, {3, 9}, {4, 9}, {5, 9}, {6, 9}, {7, 
               9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-star graph\""],
        Annotation[#, "9-star graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -4920.}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 10}, {2, 10}, {3, 10}, {4, 10}, {5, 10}, {6, 10}, {
               7, 10}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-star graph\""],
        Annotation[#, "10-star graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -5313.6}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 0.}, {-0.809, -0.588}, {0., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 11}, {2, 11}, {3, 11}, {4, 11}, {5, 11}, {6, 11}, {
               7, 11}, {8, 11}, {9, 11}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-star graph\""],
        Annotation[#, "11-star graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -5313.6}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.281, -0.96}, {0.282, -0.959}, {
            0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
            0., 1.}, {-0.541, 0.841}, {-0.91, 
            0.416}, {-0.99, -0.142}, {-0.756, -0.655}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 12}, {2, 12}, {3, 12}, {4, 12}, {5, 12}, {6, 12}, {
               7, 12}, {8, 12}, {9, 12}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.281, -0.96}, {0.282, -0.959}, {
             0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
             0., 1.}, {-0.541, 0.841}, {-0.91, 
             0.416}, {-0.99, -0.142}, {-0.756, -0.655}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-star graph\""],
        Annotation[#, "12-star graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -5313.6}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.259, -0.966}, {0.259, -0.966}, {
            0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 0.707}, {
            0.259, 0.966}, {-0.259, 0.966}, {-0.707, 0.707}, {-0.966, 0.259}, 
            {-0.966, -0.259}, {-0.707, -0.707}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 13}, {2, 13}, {3, 13}, {4, 13}, {5, 13}, {6, 13}, {
               7, 13}, {8, 13}, {9, 13}, {10, 13}, {11, 13}, {12, 13}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.259, -0.966}, {0.259, -0.966}, {
             0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 
             0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
             0.707}, {-0.966, 0.259}, {-0.966, -0.259}, {-0.707, -0.707}, {0.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"13-star graph\""],
        Annotation[#, "13-star graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -5313.6}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.239, -0.971}, {0.239, -0.971}, {
            0.663, -0.749}, {0.935, -0.354}, {0.993, 0.121}, {0.823, 0.568}, {
            0.465, 0.885}, {0., 1.}, {-0.464, 0.886}, {-0.824, 
            0.568}, {-0.993, 0.121}, {-0.935, -0.354}, {-0.663, -0.749}, {0., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 14}, {2, 14}, {3, 14}, {4, 14}, {5, 14}, {6, 14}, {
               7, 14}, {8, 14}, {9, 14}, {10, 14}, {11, 14}, {12, 14}, {13, 
               14}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.239, -0.971}, {0.239, -0.971}, {
             0.663, -0.749}, {0.935, -0.354}, {0.993, 0.121}, {0.823, 
             0.568}, {0.465, 0.885}, {0., 1.}, {-0.464, 0.886}, {-0.824, 
             0.568}, {-0.993, 0.121}, {-0.935, -0.354}, {-0.663, -0.749}, {0.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"14-star graph\""],
        Annotation[#, "14-star graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -5313.6}, {Center, Center}, 
      {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.222, -0.975}, {0.223, -0.975}, {
            0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {0.623,
             0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
            0.782}, {-0.901, 0.434}, {-1., 
            0.}, {-0.901, -0.434}, {-0.623, -0.782}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 15}, {2, 15}, {3, 15}, {4, 15}, {5, 15}, {6, 15}, {
               7, 15}, {8, 15}, {9, 15}, {10, 15}, {11, 15}, {12, 15}, {13, 
               15}, {14, 15}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.222, -0.975}, {0.223, -0.975}, {
             0.623, -0.782}, {0.901, -0.434}, {1., 0.}, {0.901, 0.434}, {
             0.623, 0.782}, {0.222, 0.975}, {-0.223, 0.975}, {-0.623, 
             0.782}, {-0.901, 0.434}, {-1., 
             0.}, {-0.901, -0.434}, {-0.623, -0.782}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"15-star graph\""],
        Annotation[#, "15-star graph", "Tooltip"]& ],
       TraditionalForm], {2160., -5313.6}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.208, -0.979}, {0.208, -0.978}, {
            0.588, -0.809}, {0.867, -0.5}, {0.995, -0.105}, {0.951, 0.309}, {
            0.743, 0.669}, {0.407, 0.913}, {0., 1.}, {-0.407, 0.914}, {-0.743,
             0.67}, {-0.951, 
            0.309}, {-0.994, -0.105}, {-0.867, -0.5}, {-0.588, -0.809}, {0., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 16}, {2, 16}, {3, 16}, {4, 16}, {5, 16}, {6, 16}, {
               7, 16}, {8, 16}, {9, 16}, {10, 16}, {11, 16}, {12, 16}, {13, 
               16}, {14, 16}, {15, 16}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.208, -0.979}, {0.208, -0.978}, {
             0.588, -0.809}, {0.867, -0.5}, {0.995, -0.105}, {0.951, 0.309}, {
             0.743, 0.669}, {0.407, 0.913}, {0., 1.}, {-0.407, 
             0.914}, {-0.743, 0.67}, {-0.951, 
             0.309}, {-0.994, -0.105}, {-0.867, -0.5}, {-0.588, -0.809}, {0., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-star graph\""],
        Annotation[#, "16-star graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -5313.6}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.195, -0.981}, {0.195, -0.981}, {
            0.555, -0.832}, {0.831, -0.556}, {0.981, -0.195}, {0.981, 
            0.195}, {0.832, 0.555}, {0.556, 0.831}, {0.195, 0.981}, {-0.195, 
            0.981}, {-0.555, 0.832}, {-0.831, 0.556}, {-0.981, 
            0.195}, {-0.981, -0.195}, {-0.832, -0.555}, {-0.556, -0.831}, {0.,
             0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 17}, {2, 17}, {3, 17}, {4, 17}, {5, 17}, {6, 17}, {
               7, 17}, {8, 17}, {9, 17}, {10, 17}, {11, 17}, {12, 17}, {13, 
               17}, {14, 17}, {15, 17}, {16, 17}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.195, -0.981}, {0.195, -0.981}, {
             0.555, -0.832}, {0.831, -0.556}, {0.981, -0.195}, {0.981, 
             0.195}, {0.832, 0.555}, {0.556, 0.831}, {0.195, 0.981}, {-0.195, 
             0.981}, {-0.555, 0.832}, {-0.831, 0.556}, {-0.981, 
             0.195}, {-0.981, -0.195}, {-0.832, -0.555}, {-0.556, -0.831}, {
             0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"17-star graph\""],
        Annotation[#, "17-star graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -5313.6}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.184, -0.982}, {0.184, -0.983}, {
            0.526, -0.85}, {0.798, -0.603}, {0.962, -0.273}, {0.996, 0.093}, {
            0.895, 0.446}, {0.674, 0.739}, {0.361, 0.933}, {0., 1.}, {-0.361, 
            0.933}, {-0.674, 0.739}, {-0.895, 0.446}, {-0.996, 
            0.092}, {-0.962, -0.273}, {-0.798, -0.602}, {-0.526, -0.85}, {0., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 18}, {2, 18}, {3, 18}, {4, 18}, {5, 18}, {6, 18}, {
               7, 18}, {8, 18}, {9, 18}, {10, 18}, {11, 18}, {12, 18}, {13, 
               18}, {14, 18}, {15, 18}, {16, 18}, {17, 18}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.184, -0.982}, {0.184, -0.983}, {
             0.526, -0.85}, {0.798, -0.603}, {0.962, -0.273}, {0.996, 
             0.093}, {0.895, 0.446}, {0.674, 0.739}, {0.361, 0.933}, {0., 
             1.}, {-0.361, 0.933}, {-0.674, 0.739}, {-0.895, 0.446}, {-0.996, 
             0.092}, {-0.962, -0.273}, {-0.798, -0.602}, {-0.526, -0.85}, {0.,
              0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"18-star graph\""],
        Annotation[#, "18-star graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -5313.6}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.174, -0.985}, {0.174, -0.985}, {
            0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1., 0.}, {0.94, 
            0.342}, {0.766, 0.643}, {0.5, 0.866}, {0.174, 0.985}, {-0.174, 
            0.985}, {-0.5, 0.866}, {-0.766, 0.643}, {-0.94, 0.342}, {-1., 
            0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {0., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 19}, {2, 19}, {3, 19}, {4, 19}, {5, 19}, {6, 19}, {
               7, 19}, {8, 19}, {9, 19}, {10, 19}, {11, 19}, {12, 19}, {13, 
               19}, {14, 19}, {15, 19}, {16, 19}, {17, 19}, {18, 19}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[13],
                "13"],
               Annotation[#, 13, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[14],
                "14"],
               Annotation[#, 14, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[15],
                "15"],
               Annotation[#, 15, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[16],
                "16"],
               Annotation[#, 16, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[17],
                "17"],
               Annotation[#, 17, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[18],
                "18"],
               Annotation[#, 18, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[19],
                "19"],
               Annotation[#, 19, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.174, -0.985}, {0.174, -0.985}, {
             0.5, -0.866}, {0.766, -0.643}, {0.94, -0.342}, {1., 0.}, {0.94, 
             0.342}, {0.766, 0.643}, {0.5, 0.866}, {0.174, 0.985}, {-0.174, 
             0.985}, {-0.5, 0.866}, {-0.766, 0.643}, {-0.94, 0.342}, {-1., 
             0.}, {-0.94, -0.342}, {-0.766, -0.643}, {-0.5, -0.866}, {0., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"19-star graph\""],
        Annotation[#, "19-star graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -5313.6}, {
      Center, Center}, {360., 360.}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{312, 432},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[3]=",
 CellID->532481884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1714611269],

Cell["Connected graphs:", "ExampleText",
 CellID->388538990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", "\"\<Connected\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1824518050],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "11"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "13"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "22"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "23"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "26"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "28"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "1625", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "11"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "13"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "20"}], "}"}], ",", "\<\"WongGraph\"\>"}], 
   "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{517, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->858667339]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<WongGraph\>\"", ",", "\"\<Connected\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1555385454],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531858733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"GraphData", "[", "#", "]"}], ",", 
        RowBox[{"GraphData", "[", 
         RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"GraphData", "[", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"GraphData", "[", 
          RowBox[{"#", ",", "\"\<Connected\>\""}], "]"}], "&&", 
         RowBox[{
          RowBox[{"GraphData", "[", 
           RowBox[{"#", ",", "\"\<VertexCount\>\""}], "]"}], "\[LessEqual]", 
          "10"}]}], "&"}]}], "]"}]}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->218853697],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, 0.707}, {-0.707, -0.707}, {
            0.707, -0.707}, {0.707, 0.707}, {-0.354, 0.}, {0., -0.354}, {
            0.354, 0.}, {0., 0.354}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 8}, {2, 3}, {2, 6}, {2, 
               5}, {3, 4}, {3, 7}, {3, 6}, {4, 8}, {4, 7}, {5, 6}, {5, 8}, {6,
                7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, 0.707}, {-0.707, -0.707}, {
             0.707, -0.707}, {0.707, 0.707}, {-0.354, 0.}, {0., -0.354}, {
             0.354, 0.}, {0., 0.354}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-antiprism graph\""],
        Annotation[#, "4-antiprism graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.951, 0.309}, {-0.588, -0.809}, {
            0.588, -0.809}, {0.951, 0.309}, {0., 1.}, {-0.385, -0.125}, {
            0., -0.405}, {0.385, -0.125}, {0.238, 0.328}, {-0.237, 0.327}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 10}, {2, 3}, {2, 7}, {2, 
               6}, {3, 4}, {3, 8}, {3, 7}, {4, 5}, {4, 9}, {4, 8}, {5, 10}, {
               5, 9}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.951, 0.309}, {-0.588, -0.809}, {
             0.588, -0.809}, {0.951, 0.309}, {0., 1.}, {-0.385, -0.125}, {
             0., -0.405}, {0.385, -0.125}, {0.238, 0.328}, {-0.237, 
             0.327}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-antiprism graph\""],
        Annotation[#, "5-antiprism graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0.5, -0.4023506962676288}, {
            0.3437714530256435, -0.93905334677245}, {
            0., -1.}, {-0.3437714530256435, -0.93905334677245}, {-0.5, \
-0.4023506962676288}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               5}, {2, 6}, {3, 4}, {3, 6}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0.5, -0.4023506962676288}, {
             0.3437714530256435, -0.93905334677245}, {
             0., -1.}, {-0.3437714530256435, -0.93905334677245}, {-0.5, \
-0.4023506962676288}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"biggest little hexagon\""],
        Annotation[#, "biggest little hexagon", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -196.2}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 
            0.}, {-0.41, -0.224}, {-0.5, -0.639}, {-0.262, -0.965}, {
            0., -1.}, {0.262, -0.965}, {0.5, -0.639}, {0.41, -0.224}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 8}, {2, 3}, {2, 
               6}, {2, 7}, {3, 4}, {3, 7}, {3, 8}, {4, 5}, {4, 8}, {5, 6}, {6,
                7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 
             0.}, {-0.41, -0.224}, {-0.5, -0.639}, {-0.262, -0.965}, {
             0., -1.}, {0.262, -0.965}, {0.5, -0.639}, {0.41, -0.224}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"biggest little octagon\""],
        Annotation[#, "biggest little octagon", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -196.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 7}, {2, 3}, {2, 4}, {2, 
               7}, {3, 4}, {3, 5}, {4, 5}, {4, 6}, {5, 6}, {5, 7}, {6, 
               7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-circulant graph (1,2)\""],
        Annotation[#, "7-circulant graph (1,2)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -196.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, 0.707}, {0., 1.}, {-0.707, 
            0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}, {
            1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {1, 8}, {2, 3}, {2, 
               4}, {2, 6}, {2, 8}, {3, 4}, {3, 5}, {3, 7}, {4, 5}, {4, 6}, {4,
                8}, {5, 6}, {5, 7}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, 0.707}, {0., 1.}, {-0.707, 
             0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-circulant graph (1,2,4)\""],
        Annotation[#, "8-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {2160., -196.2}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, 0.707}, {0., 1.}, {-0.707, 
            0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}, {
            1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 8}, {2, 3}, {2, 
               5}, {2, 6}, {2, 7}, {3, 4}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4,
                7}, {4, 8}, {5, 6}, {5, 8}, {6, 7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, 0.707}, {0., 1.}, {-0.707, 
             0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-circulant graph (1,3,4)\""],
        Annotation[#, "8-circulant graph (1,3,4)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -196.2}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 9}, {2, 3}, {2, 6}, {2, 
               7}, {3, 4}, {3, 7}, {3, 8}, {4, 5}, {4, 8}, {4, 9}, {5, 6}, {5,
                9}, {6, 7}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2)\""],
        Annotation[#, "9-circulant graph (1,2)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 7}, {1, 9}, {2, 3}, {2, 5}, {2, 
               8}, {3, 4}, {3, 6}, {3, 9}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {6,
                7}, {6, 9}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,3)\""],
        Annotation[#, "9-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
            0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
            0.174, -0.985}, {0.766, -0.643}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {1, 8}, {1, 9}, {2, 
               3}, {2, 4}, {2, 5}, {2, 8}, {2, 9}, {3, 4}, {3, 5}, {3, 6}, {3,
                9}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 7}, {
               6, 8}, {6, 9}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
             0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
             0.174, -0.985}, {0.766, -0.643}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2,3)\""],
        Annotation[#, "9-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -196.2}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
            0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
            0.174, -0.985}, {0.766, -0.643}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 8}, {1, 9}, {2, 
               3}, {2, 4}, {2, 6}, {2, 7}, {2, 9}, {3, 4}, {3, 5}, {3, 7}, {3,
                8}, {4, 5}, {4, 6}, {4, 8}, {4, 9}, {5, 6}, {5, 7}, {5, 9}, {
               6, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
             0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
             0.174, -0.985}, {0.766, -0.643}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2,4)\""],
        Annotation[#, "9-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 7}, {1, 10}, {2, 3}, {2, 6}, {2, 
               8}, {3, 4}, {3, 7}, {3, 9}, {4, 5}, {4, 8}, {4, 10}, {5, 6}, {
               5, 9}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,4)\""],
        Annotation[#, "10-circulant graph (1,4)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 8}, {1, 9}, {1, 10}, {2, 
               3}, {2, 4}, {2, 5}, {2, 9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {
               3, 10}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 
               7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,3)\""],
        Annotation[#, "10-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -588.5999999999999}, {
      Center, Center}, {360.0000000000001, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {1, 9}, {1, 10}, {2, 
               3}, {2, 4}, {2, 6}, {2, 8}, {2, 10}, {3, 4}, {3, 5}, {3, 7}, {
               3, 9}, {4, 5}, {4, 6}, {4, 8}, {4, 10}, {5, 6}, {5, 7}, {5, 
               9}, {6, 7}, {6, 8}, {6, 10}, {7, 8}, {7, 9}, {8, 9}, {8, 10}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,4)\""],
        Annotation[#, "10-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -588.5999999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 9}, {1, 10}, {2, 3}, {2, 
               4}, {2, 7}, {2, 10}, {3, 4}, {3, 5}, {3, 8}, {4, 5}, {4, 6}, {
               4, 9}, {5, 6}, {5, 7}, {5, 10}, {6, 7}, {6, 8}, {7, 8}, {7, 
               9}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,5)\""],
        Annotation[#, "10-circulant graph (1,2,5)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -588.5999999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 7}, {1, 10}, {2, 3}, {2, 
               6}, {2, 7}, {2, 8}, {3, 4}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {4,
                8}, {4, 9}, {4, 10}, {5, 6}, {5, 9}, {5, 10}, {6, 7}, {6, 
               10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,4,5)\""],
        Annotation[#, "10-circulant graph (1,4,5)", "Tooltip"]& ],
       TraditionalForm], {2160., -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 5}, {1, 6}, {1, 7}, {1, 9}, {2, 4}, {2, 
               6}, {2, 7}, {2, 8}, {2, 10}, {3, 5}, {3, 7}, {3, 8}, {3, 9}, {
               4, 6}, {4, 8}, {4, 9}, {4, 10}, {5, 7}, {5, 9}, {5, 10}, {6, 
               8}, {6, 10}, {7, 9}, {8, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (2,4,5)\""],
        Annotation[#, "10-circulant graph (2,4,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -588.5999999999999}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {1, 8}, {1, 9}, {1, 
               10}, {2, 3}, {2, 4}, {2, 5}, {2, 7}, {2, 9}, {2, 10}, {3, 4}, {
               3, 5}, {3, 6}, {3, 8}, {3, 10}, {4, 5}, {4, 6}, {4, 7}, {4, 
               9}, {5, 6}, {5, 7}, {5, 8}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {
               7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,3,5)\""],
        Annotation[#, "10-circulant graph (1,2,3,5)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 7}, {1, 9}, {1, 
               10}, {2, 3}, {2, 4}, {2, 6}, {2, 7}, {2, 8}, {2, 10}, {3, 4}, {
               3, 5}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {4, 6}, {4, 8}, {4, 
               9}, {4, 10}, {5, 6}, {5, 7}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {
               6, 10}, {7, 8}, {7, 9}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,4,5)\""],
        Annotation[#, "10-circulant graph (1,2,4,5)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {2., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 4}, {2, 4}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {2., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"claw\""],
        Annotation[#, "claw", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0., 1.}, {1., 0.}, {1., 1.}, {
            2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
               9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {
               2, 9}, {2, 10}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
               10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 7}, {
               5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 
               9}, {7, 10}, {8, 9}, {8, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0., 1.}, {1., 0.}, {1., 
             1.}, {2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 
             1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-cocktail party graph\""],
        Annotation[#, "5-cocktail party graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               4}, {2, 5}, {2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {5,
                6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-complete graph\""],
        Annotation[#, "6-complete graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 
               3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3,
                7}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-complete graph\""],
        Annotation[#, "7-complete graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -980.9999999999999}, {
      Center, Center}, {360.0000000000001, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3,
                5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {
               5, 6}, {5, 7}, {5, 8}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-complete graph\""],
        Annotation[#, "8-complete graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -980.9999999999999}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2,
                9}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {
               4, 6}, {4, 7}, {4, 8}, {4, 9}, {5, 6}, {5, 7}, {5, 8}, {5, 
               9}, {6, 7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-complete graph\""],
        Annotation[#, "9-complete graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -980.9999999999999}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 0.}, {-0.809, -0.588}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {
               2, 8}, {2, 9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 
               8}, {3, 9}, {3, 10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {
               4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 
               8}, {6, 9}, {6, 10}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 
               10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-complete graph\""],
        Annotation[#, "10-complete graph", "Tooltip"]& ],
       TraditionalForm], {2160., -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -1.}, {2., 
            0.}, {2., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -1.}, {2., 
             0.}, {2., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,3)\""],
        Annotation[#, "complete bipartite graph (2,3)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -980.9999999999999}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -1.5}, {
            2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 4}, {2, 
               5}, {2, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -1.5}, {
             2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,4)\""],
        Annotation[#, "complete bipartite graph (2,4)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -0.5}, {1., 0.5}, {2., -2.}, {
            2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 3}, {2, 
               4}, {2, 5}, {2, 6}, {2, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -0.5}, {1., 0.5}, {2., -2.}, {
             2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (2,5)\""],
        Annotation[#, "complete bipartite graph (2,5)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 4}, {2, 5}, {2, 
               6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,4)\""],
        Annotation[#, "complete bipartite graph (3,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 4}, {2, 
               5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3,
                8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,5)\""],
        Annotation[#, "complete bipartite graph (3,5)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 5}, {2, 6}, {2, 
               7}, {2, 8}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4,
                7}, {4, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,4)\""],
        Annotation[#, "complete bipartite graph (4,4)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {2, 5}, {2, 
               6}, {2, 7}, {2, 8}, {2, 9}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3,
                9}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,5)\""],
        Annotation[#, "complete bipartite graph (4,5)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 
               7}, {2, 8}, {2, 9}, {2, 10}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {
               3, 10}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
               7}, {5, 8}, {5, 9}, {5, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (5,5)\""],
        Annotation[#, "complete bipartite graph (5,5)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {-1.5, -1.}, {
            1.5, -1.}, {-2.25, -2.}, {-0.75, -2.}, {0.75, -2.}, {
            2.25, -2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {-1.5, -1.}, {
             1.5, -1.}, {-2.25, -2.}, {-0.75, -2.}, {0.75, -2.}, {
             2.25, -2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete binary tree of depth 3\""],
        Annotation[#, "complete binary tree of depth 3", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 8}, {2, 
               9}, {2, 10}, {3, 6}, {3, 7}, {3, 9}, {3, 10}, {4, 6}, {4, 7}, {
               4, 8}, {4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-crown graph\""],
        Annotation[#, "5-crown graph", "Tooltip"]& ],
       TraditionalForm], {2160., -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.333, -0.333}, {-1., -1.}, {-0.333, 
            0.333}, {-1., 1.}, {0.333, -0.333}, {1., -1.}, {0.333, 0.333}, {
            1., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {2, 4}, {2, 6}, {3, 4}, {3, 
               7}, {4, 8}, {5, 6}, {5, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.333, -0.333}, {-1., -1.}, {-0.333, 
             0.333}, {-1., 1.}, {0.333, -0.333}, {1., -1.}, {0.333, 0.333}, {
             1., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"cubical graph\""],
        Annotation[#, "cubical graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1373.3999999999999`}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.588, -0.809}, {0.588, -0.809}, {
            0.951, 0.309}, {0., 1.}, {-0.951, 0.309}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {2, 3}, {3, 4}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.588, -0.809}, {0.588, -0.809}, {
             0.951, 0.309}, {0., 1.}, {-0.951, 0.309}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-cycle graph\""],
        Annotation[#, "5-cycle graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-cycle graph\""],
        Annotation[#, "6-cycle graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 7}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-cycle graph\""],
        Annotation[#, "7-cycle graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-cycle graph\""],
        Annotation[#, "8-cycle graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 9}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-cycle graph\""],
        Annotation[#, "9-cycle graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 0.}, {-0.809, -0.588}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 10}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
               7}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-cycle graph\""],
        Annotation[#, "10-cycle graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1765.8}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {3., 1.}, {1., 2.}, {
            2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 5}, {3, 6}, {4, 5}, {4, 
               7}, {5, 6}, {5, 8}, {6, 9}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {3., 1.}, {1., 
             2.}, {2., 2.}, {3., 2.}, {1., 3.}, {2., 3.}, {3., 3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"grid graph (3,3)\""],
        Annotation[#, "grid graph (3,3)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1765.8}, {Center, Center}, 
      {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-ladder graph\""],
        Annotation[#, "3-ladder graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1765.8}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-ladder graph\""],
        Annotation[#, "4-ladder graph", "Tooltip"]& ],
       TraditionalForm], {2160., -1765.8}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 1.}, {2., 1.}, {1., 2.}, {2., 2.}, {
            1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 5.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {2, 4}, {3, 4}, {3, 5}, {4, 6}, {5, 
               6}, {5, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 1.}, {2., 1.}, {1., 2.}, {2., 
             2.}, {1., 3.}, {2., 3.}, {1., 4.}, {2., 4.}, {1., 5.}, {2., 
             5.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-ladder graph\""],
        Annotation[#, "5-ladder graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1765.8}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {1., 0.}, {1., 1.}, {
            1.8660254037844386`, 0.5}, {1.8660254037844386`, 1.5}, {
            0.8660254037844386, 1.5}, {0.8660254037844386, 0.5}, {0., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 8}, {1, 7}, {2, 4}, {2, 3}, {3, 4}, {3, 
               5}, {4, 5}, {5, 6}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {1., 0.}, {1., 1.}, {
             1.8660254037844386`, 0.5}, {1.8660254037844386`, 1.5}, {
             0.8660254037844386, 1.5}, {0.8660254037844386, 0.5}, {0., 
             1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-matchstick graph\""],
        Annotation[#, "3-matchstick graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, -0.707}, {0.707, 0.707}, {-0.707,
             0.707}, {-0.707, -0.707}, {1.414, -1.414}, {1.414, 
            1.414}, {-1.414, 1.414}, {-1.414, -1.414}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 6}, {3, 4}, {3, 
               7}, {4, 5}, {4, 8}, {5, 6}, {6, 7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, -0.707}, {0.707, 
             0.707}, {-0.707, 0.707}, {-0.707, -0.707}, {1.414, -1.414}, {
             1.414, 1.414}, {-1.414, 1.414}, {-1.414, -1.414}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "4-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.588, -0.809}, {0.951, 0.309}, {0., 
            1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
            0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 10}, {2, 3}, {2, 7}, {3, 4}, {3, 
               8}, {4, 5}, {4, 9}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.588, -0.809}, {0.951, 0.309}, {0., 
             1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
             0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "5-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1765.8}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.5, 0.}, {-0.5, 
            0.}, {-0.728713553878169, 0.9734937648862564}, {0., 
            1.6583123951777}, {0.728713553878169, 0.9734937648862564}, {
            0.22871355387816905`, 0.6848186302914435}, {-0.22871355387816905`,
             0.6848186302914435}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 7}, {2, 3}, {2, 6}, {3, 4}, {3, 
               6}, {4, 5}, {4, 7}, {4, 6}, {5, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.5, 0.}, {-0.5, 
             0.}, {-0.728713553878169, 0.9734937648862564}, {0., 
             1.6583123951777}, {0.728713553878169, 0.9734937648862564}, {
             0.22871355387816905`, 
             0.6848186302914435}, {-0.22871355387816905`, 
             0.6848186302914435}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Moser spindle\""],
        Annotation[#, "Moser spindle", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.316, 0.182}, {0.316, 0.182}, {
            0., -0.365}, {0., 1.385}, {-1.2, -0.693}, {1.2, -0.693}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 
               6}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.316, 0.182}, {0.316, 0.182}, {
             0., -0.365}, {0., 1.385}, {-1.2, -0.693}, {1.2, -0.693}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"octahedral graph\""],
        Annotation[#, "octahedral graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> {{1., 0.}, {2., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"2-path graph\""],
        Annotation[#, "2-path graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000001, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-path graph\""],
        Annotation[#, "3-path graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 
            0.}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-path graph\""],
        Annotation[#, "4-path graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-path graph\""],
        Annotation[#, "5-path graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-path graph\""],
        Annotation[#, "6-path graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2158.2000000000003`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-path graph\""],
        Annotation[#, "7-path graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-path graph\""],
        Annotation[#, "8-path graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-path graph\""],
        Annotation[#, "9-path graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {
            5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
               8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., 0.}, {2., 0.}, {3., 0.}, {4., 
             0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-path graph\""],
        Annotation[#, "10-path graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.951, 
            0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 
               5}, {3, 4}, {3, 5}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.951, 
             0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"pentatope graph\""],
        Annotation[#, "pentatope graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.951, 
            0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}, {0., 
            2.}, {-1.902, 0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 
            0.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 6}, {2, 4}, {2, 5}, {2, 7}, {3, 
               5}, {3, 8}, {4, 9}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.951, 
             0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}, {0., 
             2.}, {-1.902, 0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 
             0.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Petersen graph\""],
        Annotation[#, "Petersen graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, -0.5}, {0., 
            1.}, {-0.866, -0.5}, {1.732, -1.}, {0., 2.}, {-1.732, -1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 5}, {3, 6}, {4, 
               5}, {4, 6}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, -0.5}, {0., 
             1.}, {-0.866, -0.5}, {1.732, -1.}, {0., 2.}, {-1.732, -1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"3-prism graph\""],
        Annotation[#, "3-prism graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.588, -0.809}, {0.588, -0.809}, {
            0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {-1.176, -1.618}, {
            1.175, -1.618}, {1.902, 0.618}, {0., 2.}, {-1.902, 0.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {2, 3}, {2, 7}, {3, 4}, {3, 
               8}, {4, 5}, {4, 9}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.588, -0.809}, {0.588, -0.809}, {
             0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {-1.176, -1.618}, {
             1.175, -1.618}, {1.902, 0.618}, {0., 2.}, {-1.902, 0.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-prism graph\""],
        Annotation[#, "5-prism graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1.074, -1.486}, {1.074, -0.534}, {
            1.352, -1.207}, {1.352, -0.813}, {1.746, -1.207}, {
            1.746, -0.813}, {2.025, -1.486}, {2.025, -0.534}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {2, 4}, {2, 6}, {2, 
               8}, {3, 4}, {3, 5}, {3, 7}, {4, 6}, {4, 8}, {5, 6}, {5, 7}, {6,
                8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1.074, -1.486}, {1.074, -0.534}, {
             1.352, -1.207}, {1.352, -0.813}, {1.746, -1.207}, {
             1.746, -0.813}, {2.025, -1.486}, {2.025, -0.534}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 5\""],
        Annotation[#, "quartic transitive graph 5", "Tooltip"]& ],
       TraditionalForm], {2160., -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.943, -1.147}, {1.212, -0.681}, {
            1.264, -1.416}, {1.337, -1.829}, {1.606, -0.825}, {
            1.875, -1.829}, {1.947, -1.416}, {1.999, -0.681}, {
            2.268, -1.147}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {2, 5}, {2, 7}, {2, 
               8}, {3, 4}, {3, 8}, {3, 9}, {4, 5}, {4, 6}, {5, 6}, {5, 8}, {6,
                7}, {6, 9}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.943, -1.147}, {1.212, -0.681}, {
             1.264, -1.416}, {1.337, -1.829}, {1.606, -0.825}, {
             1.875, -1.829}, {1.947, -1.416}, {1.999, -0.681}, {
             2.268, -1.147}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 9\""],
        Annotation[#, "quartic transitive graph 9", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2550.6000000000004`}, {
      Center, Center}, {359.99999999999955`, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.866, -0.5}, {
            0.866, -0.5}, {0., 2.}, {-1.732, -1.}, {1.732, -1.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {2, 3}, {2, 5}, {2, 
               7}, {3, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.866, -0.5}, {
             0.866, -0.5}, {0., 2.}, {-1.732, -1.}, {1.732, -1.}, {0., 
             0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"self-dual graph 1\""],
        Annotation[#, "self-dual graph 1", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {1., 0.}, {1., 1.}, {0., 1.}, {
            0.75, 0.25}, {0.5, 0.5}, {0.25, 0.75}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 7}, {1, 6}, {1, 5}, {2, 3}, {2, 
               5}, {3, 4}, {3, 7}, {4, 7}, {5, 6}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {1., 0.}, {1., 1.}, {0., 
             1.}, {0.75, 0.25}, {0.5, 0.5}, {0.25, 0.75}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"self-dual graph 2\""],
        Annotation[#, "self-dual graph 2", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., -0.25}, {0.217, 0.125}, {-0.217, 
            0.125}, {0., 0.}, {0., 1.}, {-0.866, -0.5}, {0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 6}, {1, 7}, {2, 4}, {2, 7}, {2, 5}, {3, 
               4}, {3, 6}, {3, 5}, {5, 6}, {5, 7}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., -0.25}, {0.217, 0.125}, {-0.217, 
             0.125}, {0., 0.}, {0., 1.}, {-0.866, -0.5}, {0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"self-dual graph 3\""],
        Annotation[#, "self-dual graph 3", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{0., 0.}}, {
             {RGBColor[0.5, 0., 0.]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> {{0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"singleton graph\""],
        Annotation[#, "singleton graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707107, 0.707107}, {0., 
            1.}, {-0.707107, 0.707107}, {-1., 0.}, {-0.707107, -0.707107}, {
            0., -1.}, {0.707107, -0.707107}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {1, 7}, {1, 8}, {2, 
               3}, {2, 4}, {2, 5}, {2, 7}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {3,
                8}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 7}, {
               6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707107, 0.707107}, {0., 
             1.}, {-0.707107, 0.707107}, {-1., 0.}, {-0.707107, -0.707107}, {
             0., -1.}, {0.707107, -0.707107}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"16-cell graph\""],
        Annotation[#, "16-cell graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.508, 0.81}, {0.302, 0.44}, {0.704, 
            0.44}, {0.426, 0.852}, {0.592, 0.854}, {0.786, 0.49}, {0.704, 
            0.344}, {0.302, 0.344}, {0.23, 0.484}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               4}, {2, 8}, {2, 9}, {3, 6}, {3, 7}, {3, 8}, {4, 9}, {5, 6}, {7,
                8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.508, 0.81}, {0.302, 0.44}, {0.704, 
             0.44}, {0.426, 0.852}, {0.592, 0.854}, {0.786, 0.49}, {0.704, 
             0.344}, {0.302, 0.344}, {0.23, 0.484}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"smallest cyclic group graph\""],
        Annotation[#, "smallest cyclic group graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2943.}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, 0.707}, {-0.707, -0.707}, {
            0.707, -0.707}, {0.707, 0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {2, 3}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, 0.707}, {-0.707, -0.707}, {
             0.707, -0.707}, {0.707, 0.707}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"square graph\""],
        Annotation[#, "square graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2943.}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, -0.707}, {0.707, -0.707}, {
            0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {2, 5}, {3, 5}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, -0.707}, {0.707, -0.707}, {
             0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-star graph\""],
        Annotation[#, "5-star graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2943.}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.588, -0.809}, {0.588, -0.809}, {
            0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {2, 6}, {3, 6}, {4, 6}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.588, -0.809}, {0.588, -0.809}, {
             0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-star graph\""],
        Annotation[#, "6-star graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {2, 7}, {3, 7}, {4, 7}, {5, 7}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-star graph\""],
        Annotation[#, "7-star graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2943.}, {
      Center, Center}, {359.99999999999955`, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {2, 8}, {3, 8}, {4, 8}, {5, 8}, {6, 8}, {7, 
               8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-star graph\""],
        Annotation[#, "8-star graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 9}, {2, 9}, {3, 9}, {4, 9}, {5, 9}, {6, 9}, {7, 
               9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-star graph\""],
        Annotation[#, "9-star graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 10}, {2, 10}, {3, 10}, {4, 10}, {5, 10}, {6, 10}, {
               7, 10}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-star graph\""],
        Annotation[#, "10-star graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.866, -0.5}, {0.866, -0.5}, {0., 
            1.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.866, -0.5}, {0.866, -0.5}, {0., 
             1.}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"tetrahedral graph\""],
        Annotation[#, "tetrahedral graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.5, 0.8660254037844}, {-0.5, 
            0.8660254037844387}, {-1., 0.}, {-0.5, -0.8660254037844}, {
            0.5, -0.8660254037844}, {1., 0.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {2, 3}, {3, 4}, {3, 7}, {4, 5}, {5, 
               6}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.5, 0.8660254037844}, {-0.5, 
             0.8660254037844387}, {-1., 0.}, {-0.5, -0.8660254037844}, {
             0.5, -0.8660254037844}, {1., 0.}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"theta-0 graph\""],
        Annotation[#, "theta-0 graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0., 0.}, {0., 3.907}, {-0.675,
             0.39}, {0.675, 0.39}, {-3.384, -1.954}, {3.384, -1.954}, {
            0., -0.779}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 
               3}, {2, 6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {4, 6}, {5,
                7}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0., 0.}, {0., 
             3.907}, {-0.675, 0.39}, {0.675, 0.39}, {-3.384, -1.954}, {
             3.384, -1.954}, {0., -0.779}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"triakis tetrahedral graph\""],
        Annotation[#, "triakis tetrahedral graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -3335.4000000000005`}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.866, -0.5}, {
            0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {2, 3}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.866, -0.5}, {
             0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"triangle graph\""],
        Annotation[#, "triangle graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -3335.4000000000005`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -1.}, {2., 0.}, {2., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {2, 4}, {2, 5}, {2, 6}, {3, 
               4}, {3, 5}, {3, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -1.}, {2., 0.}, {2., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"utility graph\""],
        Annotation[#, "utility graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -3335.4000000000005`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, -0.707}, {0.707, -0.707}, {
            0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 2}, {1, 4}, {2, 5}, {2, 3}, {3, 5}, {3, 
               4}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, -0.707}, {0.707, -0.707}, {
             0.707, 0.707}, {-0.707, 0.707}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-wheel graph\""],
        Annotation[#, "5-wheel graph", "Tooltip"]& ],
       TraditionalForm], {2160., -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.588, -0.809}, {0.588, -0.809}, {
            0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {1, 2}, {1, 5}, {2, 6}, {2, 3}, {3, 6}, {3, 
               4}, {4, 6}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.588, -0.809}, {0.588, -0.809}, {
             0.951, 0.309}, {0., 1.}, {-0.951, 0.309}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-wheel graph\""],
        Annotation[#, "6-wheel graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -3335.4000000000005`}, {
      Center, Center}, {359.99999999999955`, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {1, 2}, {1, 6}, {2, 7}, {2, 3}, {3, 7}, {3, 
               4}, {4, 7}, {4, 5}, {5, 7}, {5, 6}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-wheel graph\""],
        Annotation[#, "7-wheel graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {1, 2}, {1, 7}, {2, 8}, {2, 3}, {3, 8}, {3, 
               4}, {4, 8}, {4, 5}, {5, 8}, {5, 6}, {6, 8}, {6, 7}, {7, 
               8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-wheel graph\""],
        Annotation[#, "8-wheel graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 9}, {1, 2}, {1, 8}, {2, 9}, {2, 3}, {3, 9}, {3, 
               4}, {4, 9}, {4, 5}, {5, 9}, {5, 6}, {6, 9}, {6, 7}, {7, 9}, {7,
                8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}, {0., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-wheel graph\""],
        Annotation[#, "9-wheel graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{364, 324},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->Automatic},
 CellLabel->"Out[3]=",
 CellID->1122786717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->706982632],

Cell["Nonplanar graphs:", "ExampleText",
 CellID->230077173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphData", "[", "\"\<Nonplanar\>\"", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1436482011],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "114"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "115"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "116"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "132"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "134"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "138"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "148"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "149"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "150"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "154"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "714", "\[RightSkeleton]"}], 
    ",", "\<\"ThomassenGraph\"\>", ",", "\<\"TietzesGraph\"\>", 
    ",", "\<\"TriangleReplacedCoxeterGraph\"\>", ",", "\<\"Tutte12Cage\"\>", 
    ",", "\<\"TwentyFourCellGraph\"\>", 
    ",", "\<\"UniquelyThreeColorableGraph\"\>", ",", "\<\"UtilityGraph\"\>", 
    ",", "\<\"WatkinsSnark\"\>", ",", "\<\"WellsGraph\"\>", 
    ",", "\<\"WongGraph\"\>"}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{553, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->737546430]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<UtilityGraph\>\"", ",", "\"\<Nonplanar\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->932839837],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->667238526]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"GraphData", "[", "#", "]"}], ",", 
        RowBox[{"GraphData", "[", 
         RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"GraphData", "[", "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"GraphData", "[", 
          RowBox[{"#", ",", "\"\<Nonplanar\>\""}], "]"}], "&&", 
         RowBox[{
          RowBox[{"GraphData", "[", 
           RowBox[{"#", ",", "\"\<VertexCount\>\""}], "]"}], "\[LessEqual]", 
          "12"}]}], "&"}]}], "]"}]}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->505215235],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0.5, -0.4023506962676288}, {
            0.3437714530256435, -0.93905334677245}, {
            0., -1.}, {-0.3437714530256435, -0.93905334677245}, {-0.5, \
-0.4023506962676288}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               5}, {2, 6}, {3, 4}, {3, 6}, {4, 5}, {5, 6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0.5, -0.4023506962676288}, {
             0.3437714530256435, -0.93905334677245}, {
             0., -1.}, {-0.3437714530256435, -0.93905334677245}, {-0.5, \
-0.4023506962676288}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"biggest little hexagon\""],
        Annotation[#, "biggest little hexagon", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 
            0.}, {-0.41, -0.224}, {-0.5, -0.639}, {-0.262, -0.965}, {
            0., -1.}, {0.262, -0.965}, {0.5, -0.639}, {0.41, -0.224}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 8}, {2, 3}, {2, 
               6}, {2, 7}, {3, 4}, {3, 7}, {3, 8}, {4, 5}, {4, 8}, {5, 6}, {6,
                7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 
             0.}, {-0.41, -0.224}, {-0.5, -0.639}, {-0.262, -0.965}, {
             0., -1.}, {0.262, -0.965}, {0.5, -0.639}, {0.41, -0.224}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"biggest little octagon\""],
        Annotation[#, "biggest little octagon", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.951057, 
            0.309017}, {-0.587785, -0.809017}, {0.587785, -0.809017}, {
            0.951057, 0.309017}, {0., 1.}, {-1.90211, 
            0.618034}, {-1.17557, -1.61803}, {1.17557, -1.61803}, {1.90211, 
            0.618034}, {0., 2.}, {-0.3, 0.}, {0.3, 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {1, 10}, {1, 11}, {1, 12}, {2, 8}, {2, 6}, {2, 
               11}, {2, 3}, {3, 9}, {3, 7}, {3, 12}, {4, 10}, {4, 8}, {4, 
               12}, {4, 11}, {5, 6}, {5, 9}, {5, 11}, {5, 12}, {6, 7}, {6, 
               10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.951057, 
             0.309017}, {-0.587785, -0.809017}, {0.587785, -0.809017}, {
             0.951057, 0.309017}, {0., 1.}, {-1.90211, 
             0.618034}, {-1.17557, -1.61803}, {1.17557, -1.61803}, {1.90211, 
             0.618034}, {0., 2.}, {-0.3, 0.}, {0.3, 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Chv\[AAcute]tal graph\""],
        Annotation[#, "Chv\[AAcute]tal graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -196.2}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 7}, {2, 3}, {2, 4}, {2, 
               7}, {3, 4}, {3, 5}, {4, 5}, {4, 6}, {5, 6}, {5, 7}, {6, 
               7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-circulant graph (1,2)\""],
        Annotation[#, "7-circulant graph (1,2)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -196.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, 0.707}, {0., 1.}, {-0.707, 
            0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}, {
            1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {1, 8}, {2, 3}, {2, 
               4}, {2, 6}, {2, 8}, {3, 4}, {3, 5}, {3, 7}, {4, 5}, {4, 6}, {4,
                8}, {5, 6}, {5, 7}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, 0.707}, {0., 1.}, {-0.707, 
             0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-circulant graph (1,2,4)\""],
        Annotation[#, "8-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -196.2}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, 0.707}, {0., 1.}, {-0.707, 
            0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {0.707, -0.707}, {
            1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 8}, {2, 3}, {2, 
               5}, {2, 6}, {2, 7}, {3, 4}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4,
                7}, {4, 8}, {5, 6}, {5, 8}, {6, 7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, 0.707}, {0., 1.}, {-0.707, 
             0.707}, {-1., 0.}, {-0.707, -0.707}, {0., -1.}, {
             0.707, -0.707}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-circulant graph (1,3,4)\""],
        Annotation[#, "8-circulant graph (1,3,4)", "Tooltip"]& ],
       TraditionalForm], {2160., -196.2}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 9}, {2, 3}, {2, 6}, {2, 
               7}, {3, 4}, {3, 7}, {3, 8}, {4, 5}, {4, 8}, {4, 9}, {5, 6}, {5,
                9}, {6, 7}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2)\""],
        Annotation[#, "9-circulant graph (1,2)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -196.2}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 7}, {1, 9}, {2, 3}, {2, 5}, {2, 
               8}, {3, 4}, {3, 6}, {3, 9}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {6,
                7}, {6, 9}, {7, 8}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,3)\""],
        Annotation[#, "9-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
            0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
            0.174, -0.985}, {0.766, -0.643}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {1, 8}, {1, 9}, {2, 
               3}, {2, 4}, {2, 5}, {2, 8}, {2, 9}, {3, 4}, {3, 5}, {3, 6}, {3,
                9}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 7}, {
               6, 8}, {6, 9}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
             0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
             0.174, -0.985}, {0.766, -0.643}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2,3)\""],
        Annotation[#, "9-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -196.2}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
            0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
            0.174, -0.985}, {0.766, -0.643}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 8}, {1, 9}, {2, 
               3}, {2, 4}, {2, 6}, {2, 7}, {2, 9}, {3, 4}, {3, 5}, {3, 7}, {3,
                8}, {4, 5}, {4, 6}, {4, 8}, {4, 9}, {5, 6}, {5, 7}, {5, 9}, {
               6, 7}, {6, 8}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.766, 0.643}, {0.174, 0.985}, {-0.5, 
             0.866}, {-0.94, 0.342}, {-0.94, -0.342}, {-0.5, -0.866}, {
             0.174, -0.985}, {0.766, -0.643}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-circulant graph (1,2,4)\""],
        Annotation[#, "9-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -196.2}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 7}, {1, 10}, {2, 3}, {2, 6}, {2, 
               8}, {3, 4}, {3, 7}, {3, 9}, {4, 5}, {4, 8}, {4, 10}, {5, 6}, {
               5, 9}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,4)\""],
        Annotation[#, "10-circulant graph (1,4)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 5}, {1, 7}, {1, 9}, {2, 4}, {2, 6}, {2, 
               8}, {2, 10}, {3, 5}, {3, 7}, {3, 9}, {4, 6}, {4, 8}, {4, 10}, {
               5, 7}, {5, 9}, {6, 8}, {6, 10}, {7, 9}, {8, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (2,4)\""],
        Annotation[#, "10-circulant graph (2,4)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 8}, {1, 9}, {1, 10}, {2, 
               3}, {2, 4}, {2, 5}, {2, 9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {
               3, 10}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 
               7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,3)\""],
        Annotation[#, "10-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -588.5999999999999}, {
      Center, Center}, {360.0000000000001, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {1, 9}, {1, 10}, {2, 
               3}, {2, 4}, {2, 6}, {2, 8}, {2, 10}, {3, 4}, {3, 5}, {3, 7}, {
               3, 9}, {4, 5}, {4, 6}, {4, 8}, {4, 10}, {5, 6}, {5, 7}, {5, 
               9}, {6, 7}, {6, 8}, {6, 10}, {7, 8}, {7, 9}, {8, 9}, {8, 10}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,4)\""],
        Annotation[#, "10-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -588.5999999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 9}, {1, 10}, {2, 3}, {2, 
               4}, {2, 7}, {2, 10}, {3, 4}, {3, 5}, {3, 8}, {4, 5}, {4, 6}, {
               4, 9}, {5, 6}, {5, 7}, {5, 10}, {6, 7}, {6, 8}, {7, 8}, {7, 
               9}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,5)\""],
        Annotation[#, "10-circulant graph (1,2,5)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -588.5999999999999}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 7}, {1, 10}, {2, 3}, {2, 
               6}, {2, 7}, {2, 8}, {3, 4}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {4,
                8}, {4, 9}, {4, 10}, {5, 6}, {5, 9}, {5, 10}, {6, 7}, {6, 
               10}, {7, 8}, {8, 9}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,4,5)\""],
        Annotation[#, "10-circulant graph (1,4,5)", "Tooltip"]& ],
       TraditionalForm], {2160., -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 5}, {1, 6}, {1, 7}, {1, 9}, {2, 4}, {2, 
               6}, {2, 7}, {2, 8}, {2, 10}, {3, 5}, {3, 7}, {3, 8}, {3, 9}, {
               4, 6}, {4, 8}, {4, 9}, {4, 10}, {5, 7}, {5, 9}, {5, 10}, {6, 
               8}, {6, 10}, {7, 9}, {8, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (2,4,5)\""],
        Annotation[#, "10-circulant graph (2,4,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -588.5999999999999}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {1, 8}, {1, 9}, {1, 
               10}, {2, 3}, {2, 4}, {2, 5}, {2, 7}, {2, 9}, {2, 10}, {3, 4}, {
               3, 5}, {3, 6}, {3, 8}, {3, 10}, {4, 5}, {4, 6}, {4, 7}, {4, 
               9}, {5, 6}, {5, 7}, {5, 8}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {
               7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,3,5)\""],
        Annotation[#, "10-circulant graph (1,2,3,5)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.809, 0.588}, {0.309, 0.951}, {-0.309, 
            0.951}, {-0.809, 0.588}, {-1., 
            0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 7}, {1, 9}, {1, 
               10}, {2, 3}, {2, 4}, {2, 6}, {2, 7}, {2, 8}, {2, 10}, {3, 4}, {
               3, 5}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {4, 6}, {4, 8}, {4, 
               9}, {4, 10}, {5, 6}, {5, 7}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {
               6, 10}, {7, 8}, {7, 9}, {8, 9}, {8, 10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.809, 0.588}, {0.309, 0.951}, {-0.309,
              0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}, {-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-circulant graph (1,2,4,5)\""],
        Annotation[#, "10-circulant graph (1,2,4,5)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.281, -0.96}, {0.282, -0.959}, {
            0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
            0., 1.}, {-0.541, 0.841}, {-0.91, 
            0.416}, {-0.99, -0.142}, {-0.756, -0.655}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 7}, {1, 11}, {2, 3}, {2, 7}, {2, 
               8}, {3, 4}, {3, 8}, {3, 9}, {4, 5}, {4, 9}, {4, 10}, {5, 6}, {
               5, 10}, {5, 11}, {6, 7}, {6, 11}, {7, 8}, {8, 9}, {9, 10}, {10,
                11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.281, -0.96}, {0.282, -0.959}, {
             0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
             0., 1.}, {-0.541, 0.841}, {-0.91, 
             0.416}, {-0.99, -0.142}, {-0.756, -0.655}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-circulant graph (1,2)\""],
        Annotation[#, "11-circulant graph (1,2)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -588.5999999999999}, {
      Center, Center}, {360., 359.99999999999994`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.281, -0.96}, {0.282, -0.959}, {
            0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
            0., 1.}, {-0.541, 0.841}, {-0.91, 
            0.416}, {-0.99, -0.142}, {-0.756, -0.655}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 9}, {1, 11}, {2, 3}, {2, 5}, {2, 
               10}, {3, 4}, {3, 6}, {3, 11}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {10, 
               11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.281, -0.96}, {0.282, -0.959}, {
             0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
             0., 1.}, {-0.541, 0.841}, {-0.91, 
             0.416}, {-0.99, -0.142}, {-0.756, -0.655}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-circulant graph (1,3)\""],
        Annotation[#, "11-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
            0.99}, {-0.655, 0.756}, {-0.959, 
            0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
            0.415, -0.91}, {0.841, -0.541}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 9}, {1, 10}, {1, 11}, {2, 
               3}, {2, 4}, {2, 5}, {2, 10}, {2, 11}, {3, 4}, {3, 5}, {3, 6}, {
               3, 11}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 
               7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {
               8, 11}, {9, 10}, {9, 11}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
             0.99}, {-0.655, 0.756}, {-0.959, 
             0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
             0.415, -0.91}, {0.841, -0.541}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-circulant graph (1,2,3)\""],
        Annotation[#, "11-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
            0.99}, {-0.655, 0.756}, {-0.959, 
            0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
            0.415, -0.91}, {0.841, -0.541}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 8}, {1, 10}, {1, 11}, {2, 
               3}, {2, 4}, {2, 6}, {2, 9}, {2, 11}, {3, 4}, {3, 5}, {3, 7}, {
               3, 10}, {4, 5}, {4, 6}, {4, 8}, {4, 11}, {5, 6}, {5, 7}, {5, 
               9}, {6, 7}, {6, 8}, {6, 10}, {7, 8}, {7, 9}, {7, 11}, {8, 9}, {
               8, 10}, {9, 10}, {9, 11}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
             0.99}, {-0.655, 0.756}, {-0.959, 
             0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
             0.415, -0.91}, {0.841, -0.541}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-circulant graph (1,2,4)\""],
        Annotation[#, "11-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -980.9999999999999}, {
      Center, Center}, {360.0000000000001, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
            0.99}, {-0.655, 0.756}, {-0.959, 
            0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
            0.415, -0.91}, {0.841, -0.541}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 8}, {1, 9}, {1, 
               10}, {1, 11}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 9}, {2, 
               10}, {2, 11}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 10}, {3, 
               11}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 11}, {5, 6}, {5, 7}, {
               5, 8}, {5, 9}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 8}, {7, 
               9}, {7, 10}, {7, 11}, {8, 9}, {8, 10}, {8, 11}, {9, 10}, {9, 
               11}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.841, 0.541}, {0.415, 0.91}, {-0.142, 
             0.99}, {-0.655, 0.756}, {-0.959, 
             0.282}, {-0.959, -0.282}, {-0.655, -0.756}, {-0.142, -0.99}, {
             0.415, -0.91}, {0.841, -0.541}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-circulant graph (1,2,3,4)\""],
        Annotation[#, "11-circulant graph (1,2,3,4)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -980.9999999999999}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.259, -0.966}, {0.259, -0.966}, {
            0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 0.707}, {
            0.259, 0.966}, {-0.259, 0.966}, {-0.707, 0.707}, {-0.966, 
            0.259}, {-0.966, -0.259}, {-0.707, -0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 10}, {1, 12}, {2, 3}, {2, 5}, {2, 
               11}, {3, 4}, {3, 6}, {3, 12}, {4, 5}, {4, 7}, {5, 6}, {5, 8}, {
               6, 7}, {6, 9}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 
               12}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.259, -0.966}, {0.259, -0.966}, {
             0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 
             0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
             0.707}, {-0.966, 0.259}, {-0.966, -0.259}, {-0.707, -0.707}}]& ],
          
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3)\""],
        Annotation[#, "12-circulant graph (1,3)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -980.9999999999999}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 9}, {1, 12}, {2, 3}, {2, 6}, {2, 
               10}, {3, 4}, {3, 7}, {3, 11}, {4, 5}, {4, 8}, {4, 12}, {5, 
               6}, {5, 9}, {6, 7}, {6, 10}, {7, 8}, {7, 11}, {8, 9}, {8, 
               12}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,4)\""],
        Annotation[#, "12-circulant graph (1,4)", "Tooltip"]& ],
       TraditionalForm], {2160., -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 8}, {1, 12}, {2, 3}, {2, 7}, {2, 
               9}, {3, 4}, {3, 8}, {3, 10}, {4, 5}, {4, 9}, {4, 11}, {5, 6}, {
               5, 10}, {5, 12}, {6, 7}, {6, 11}, {7, 8}, {7, 12}, {8, 9}, {9, 
               10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,5)\""],
        Annotation[#, "12-circulant graph (1,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -980.9999999999999}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 10}, {1, 11}, {2, 4}, {2, 5}, {2, 
               11}, {2, 12}, {3, 5}, {3, 6}, {3, 12}, {4, 6}, {4, 7}, {5, 
               7}, {5, 8}, {6, 8}, {6, 9}, {7, 9}, {7, 10}, {8, 10}, {8, 
               11}, {9, 11}, {9, 12}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,3)\""],
        Annotation[#, "12-circulant graph (2,3)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 7}, {1, 11}, {2, 4}, {2, 8}, {2, 12}, {3, 
               5}, {3, 9}, {4, 6}, {4, 10}, {5, 7}, {5, 11}, {6, 8}, {6, 
               12}, {7, 9}, {8, 10}, {9, 11}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,6)\""],
        Annotation[#, "12-circulant graph (2,6)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 9}, {1, 10}, {2, 5}, {2, 6}, {2, 
               10}, {2, 11}, {3, 6}, {3, 7}, {3, 11}, {3, 12}, {4, 7}, {4, 
               8}, {4, 12}, {5, 8}, {5, 9}, {6, 9}, {6, 10}, {7, 10}, {7, 
               11}, {8, 11}, {8, 12}, {9, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (3,4)\""],
        Annotation[#, "12-circulant graph (3,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -980.9999999999999}, {
      Center, Center}, {360., 359.9999999999998}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 10}, {1, 11}, {1, 12}, {2, 
               3}, {2, 4}, {2, 5}, {2, 11}, {2, 12}, {3, 4}, {3, 5}, {3, 6}, {
               3, 12}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {5, 8}, {6, 
               7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {
               8, 11}, {9, 10}, {9, 11}, {9, 12}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3)\""],
        Annotation[#, "12-circulant graph (1,2,3)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 9}, {1, 11}, {1, 12}, {2, 
               3}, {2, 4}, {2, 6}, {2, 10}, {2, 12}, {3, 4}, {3, 5}, {3, 7}, {
               3, 11}, {4, 5}, {4, 6}, {4, 8}, {4, 12}, {5, 6}, {5, 7}, {5, 
               9}, {6, 7}, {6, 8}, {6, 10}, {7, 8}, {7, 9}, {7, 11}, {8, 9}, {
               8, 10}, {8, 12}, {9, 10}, {9, 11}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,4)\""],
        Annotation[#, "12-circulant graph (1,2,4)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 8}, {1, 11}, {1, 12}, {2, 
               3}, {2, 4}, {2, 7}, {2, 9}, {2, 12}, {3, 4}, {3, 5}, {3, 8}, {
               3, 10}, {4, 5}, {4, 6}, {4, 9}, {4, 11}, {5, 6}, {5, 7}, {5, 
               10}, {5, 12}, {6, 7}, {6, 8}, {6, 11}, {7, 8}, {7, 9}, {7, 
               12}, {8, 9}, {8, 10}, {9, 10}, {9, 11}, {10, 11}, {10, 12}, {
               11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,5)\""],
        Annotation[#, "12-circulant graph (1,2,5)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 7}, {1, 11}, {1, 12}, {2, 3}, {2, 
               4}, {2, 8}, {2, 12}, {3, 4}, {3, 5}, {3, 9}, {4, 5}, {4, 6}, {
               4, 10}, {5, 6}, {5, 7}, {5, 11}, {6, 7}, {6, 8}, {6, 12}, {7, 
               8}, {7, 9}, {8, 9}, {8, 10}, {9, 10}, {9, 11}, {10, 11}, {10, 
               12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,6)\""],
        Annotation[#, "12-circulant graph (1,2,6)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 9}, {1, 10}, {1, 12}, {2, 
               3}, {2, 5}, {2, 6}, {2, 10}, {2, 11}, {3, 4}, {3, 6}, {3, 7}, {
               3, 11}, {3, 12}, {4, 5}, {4, 7}, {4, 8}, {4, 12}, {5, 6}, {5, 
               8}, {5, 9}, {6, 7}, {6, 9}, {6, 10}, {7, 8}, {7, 10}, {7, 
               11}, {8, 9}, {8, 11}, {8, 12}, {9, 10}, {9, 12}, {10, 11}, {11,
                12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,4)\""],
        Annotation[#, "12-circulant graph (1,3,4)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1373.3999999999999`}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 7}, {1, 10}, {1, 12}, {2, 3}, {2, 
               5}, {2, 8}, {2, 11}, {3, 4}, {3, 6}, {3, 9}, {3, 12}, {4, 5}, {
               4, 7}, {4, 10}, {5, 6}, {5, 8}, {5, 11}, {6, 7}, {6, 9}, {6, 
               12}, {7, 8}, {7, 10}, {8, 9}, {8, 11}, {9, 10}, {9, 12}, {10, 
               11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,6)\""],
        Annotation[#, "12-circulant graph (1,3,6)", "Tooltip"]& ],
       TraditionalForm], {2160., -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 8}, {1, 9}, {1, 12}, {2, 
               3}, {2, 6}, {2, 7}, {2, 9}, {2, 10}, {3, 4}, {3, 7}, {3, 8}, {
               3, 10}, {3, 11}, {4, 5}, {4, 8}, {4, 9}, {4, 11}, {4, 12}, {5, 
               6}, {5, 9}, {5, 10}, {5, 12}, {6, 7}, {6, 10}, {6, 11}, {7, 
               8}, {7, 11}, {7, 12}, {8, 9}, {8, 12}, {9, 10}, {10, 11}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,4,5)\""],
        Annotation[#, "12-circulant graph (1,4,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1373.3999999999999`}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 7}, {1, 9}, {1, 12}, {2, 3}, {2, 
               6}, {2, 8}, {2, 10}, {3, 4}, {3, 7}, {3, 9}, {3, 11}, {4, 5}, {
               4, 8}, {4, 10}, {4, 12}, {5, 6}, {5, 9}, {5, 11}, {6, 7}, {6, 
               10}, {6, 12}, {7, 8}, {7, 11}, {8, 9}, {8, 12}, {9, 10}, {10, 
               11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,4,6)\""],
        Annotation[#, "12-circulant graph (1,4,6)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 7}, {1, 8}, {1, 12}, {2, 3}, {2, 
               7}, {2, 8}, {2, 9}, {3, 4}, {3, 8}, {3, 9}, {3, 10}, {4, 5}, {
               4, 9}, {4, 10}, {4, 11}, {5, 6}, {5, 10}, {5, 11}, {5, 12}, {6,
                7}, {6, 11}, {6, 12}, {7, 8}, {7, 12}, {8, 9}, {9, 10}, {10, 
               11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,5,6)\""],
        Annotation[#, "12-circulant graph (1,5,6)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 9}, {1, 10}, {1, 11}, {2, 
               4}, {2, 5}, {2, 6}, {2, 10}, {2, 11}, {2, 12}, {3, 5}, {3, 
               6}, {3, 7}, {3, 11}, {3, 12}, {4, 6}, {4, 7}, {4, 8}, {4, 
               12}, {5, 7}, {5, 8}, {5, 9}, {6, 8}, {6, 9}, {6, 10}, {7, 9}, {
               7, 10}, {7, 11}, {8, 10}, {8, 11}, {8, 12}, {9, 11}, {9, 12}, {
               10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,3,4)\""],
        Annotation[#, "12-circulant graph (2,3,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1373.3999999999999`}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 7}, {1, 10}, {1, 11}, {2, 4}, {2, 
               5}, {2, 8}, {2, 11}, {2, 12}, {3, 5}, {3, 6}, {3, 9}, {3, 
               12}, {4, 6}, {4, 7}, {4, 10}, {5, 7}, {5, 8}, {5, 11}, {6, 
               8}, {6, 9}, {6, 12}, {7, 9}, {7, 10}, {8, 10}, {8, 11}, {9, 
               11}, {9, 12}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,3,6)\""],
        Annotation[#, "12-circulant graph (2,3,6)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 5}, {1, 7}, {1, 9}, {1, 11}, {2, 4}, {2, 
               6}, {2, 8}, {2, 10}, {2, 12}, {3, 5}, {3, 7}, {3, 9}, {3, 
               11}, {4, 6}, {4, 8}, {4, 10}, {4, 12}, {5, 7}, {5, 9}, {5, 
               11}, {6, 8}, {6, 10}, {6, 12}, {7, 9}, {7, 11}, {8, 10}, {8, 
               12}, {9, 11}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,4,6)\""],
        Annotation[#, "12-circulant graph (2,4,6)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 7}, {1, 9}, {1, 10}, {2, 5}, {2, 
               6}, {2, 8}, {2, 10}, {2, 11}, {3, 6}, {3, 7}, {3, 9}, {3, 
               11}, {3, 12}, {4, 7}, {4, 8}, {4, 10}, {4, 12}, {5, 8}, {5, 
               9}, {5, 11}, {6, 9}, {6, 10}, {6, 12}, {7, 10}, {7, 11}, {8, 
               11}, {8, 12}, {9, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (3,4,6)\""],
        Annotation[#, "12-circulant graph (3,4,6)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -1765.8}, {
      Center, Center}, {360.0000000000001, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          TagBox[
           GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 1.}, {-0.5, 
            0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 9}, {1, 10}, {1, 
               11}, {1, 12}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 10}, {2, 
               11}, {2, 12}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 11}, {3, 
               12}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 12}, {5, 6}, {5, 7}, {
               5, 8}, {5, 9}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 8}, {7, 
               9}, {7, 10}, {7, 11}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {9, 
               10}, {9, 11}, {9, 12}, {10, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3,4)\""],
        Annotation[#, "12-circulant graph (1,2,3,4)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -1765.8}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {1, 8}, {1, 10}, {1, 
               11}, {1, 12}, {2, 3}, {2, 4}, {2, 5}, {2, 7}, {2, 9}, {2, 
               11}, {2, 12}, {3, 4}, {3, 5}, {3, 6}, {3, 8}, {3, 10}, {3, 
               12}, {4, 5}, {4, 6}, {4, 7}, {4, 9}, {4, 11}, {5, 6}, {5, 7}, {
               5, 8}, {5, 10}, {5, 12}, {6, 7}, {6, 8}, {6, 9}, {6, 11}, {7, 
               8}, {7, 9}, {7, 10}, {7, 12}, {8, 9}, {8, 10}, {8, 11}, {9, 
               10}, {9, 11}, {9, 12}, {10, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3,5)\""],
        Annotation[#, "12-circulant graph (1,2,3,5)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -1765.8}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {1, 10}, {1, 11}, {1, 
               12}, {2, 3}, {2, 4}, {2, 5}, {2, 8}, {2, 11}, {2, 12}, {3, 
               4}, {3, 5}, {3, 6}, {3, 9}, {3, 12}, {4, 5}, {4, 6}, {4, 7}, {
               4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 11}, {6, 7}, {6, 8}, {6, 
               9}, {6, 12}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {8, 
               11}, {9, 10}, {9, 11}, {9, 12}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3,6)\""],
        Annotation[#, "12-circulant graph (1,2,3,6)", "Tooltip"]& ],
       TraditionalForm], {2160., -1765.8}, {Center, Center}, {360., 360.}], 
     InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 8}, {1, 9}, {1, 
               11}, {1, 12}, {2, 3}, {2, 4}, {2, 6}, {2, 7}, {2, 9}, {2, 
               10}, {2, 12}, {3, 4}, {3, 5}, {3, 7}, {3, 8}, {3, 10}, {3, 
               11}, {4, 5}, {4, 6}, {4, 8}, {4, 9}, {4, 11}, {4, 12}, {5, 
               6}, {5, 7}, {5, 9}, {5, 10}, {5, 12}, {6, 7}, {6, 8}, {6, 
               10}, {6, 11}, {7, 8}, {7, 9}, {7, 11}, {7, 12}, {8, 9}, {8, 
               10}, {8, 12}, {9, 10}, {9, 11}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,4,5)\""],
        Annotation[#, "12-circulant graph (1,2,4,5)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -1765.8}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {1, 9}, {1, 11}, {1, 
               12}, {2, 3}, {2, 4}, {2, 6}, {2, 8}, {2, 10}, {2, 12}, {3, 
               4}, {3, 5}, {3, 7}, {3, 9}, {3, 11}, {4, 5}, {4, 6}, {4, 8}, {
               4, 10}, {4, 12}, {5, 6}, {5, 7}, {5, 9}, {5, 11}, {6, 7}, {6, 
               8}, {6, 10}, {6, 12}, {7, 8}, {7, 9}, {7, 11}, {8, 9}, {8, 
               10}, {8, 12}, {9, 10}, {9, 11}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,4,6)\""],
        Annotation[#, "12-circulant graph (1,2,4,6)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 7}, {1, 8}, {1, 11}, {1, 
               12}, {2, 3}, {2, 4}, {2, 7}, {2, 8}, {2, 9}, {2, 12}, {3, 4}, {
               3, 5}, {3, 8}, {3, 9}, {3, 10}, {4, 5}, {4, 6}, {4, 9}, {4, 
               10}, {4, 11}, {5, 6}, {5, 7}, {5, 10}, {5, 11}, {5, 12}, {6, 
               7}, {6, 8}, {6, 11}, {6, 12}, {7, 8}, {7, 9}, {7, 12}, {8, 
               9}, {8, 10}, {9, 10}, {9, 11}, {10, 11}, {10, 12}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,5,6)\""],
        Annotation[#, "12-circulant graph (1,2,5,6)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -1765.8}, {
      Center, Center}, {360., 360.}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 8}, {1, 9}, {1, 
               10}, {1, 12}, {2, 3}, {2, 5}, {2, 6}, {2, 7}, {2, 9}, {2, 
               10}, {2, 11}, {3, 4}, {3, 6}, {3, 7}, {3, 8}, {3, 10}, {3, 
               11}, {3, 12}, {4, 5}, {4, 7}, {4, 8}, {4, 9}, {4, 11}, {4, 
               12}, {5, 6}, {5, 8}, {5, 9}, {5, 10}, {5, 12}, {6, 7}, {6, 
               9}, {6, 10}, {6, 11}, {7, 8}, {7, 10}, {7, 11}, {7, 12}, {8, 
               9}, {8, 11}, {8, 12}, {9, 10}, {9, 12}, {10, 11}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,4,5)\""],
        Annotation[#, "12-circulant graph (1,3,4,5)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -1765.8}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 7}, {1, 9}, {1, 10}, {1, 
               12}, {2, 3}, {2, 5}, {2, 6}, {2, 8}, {2, 10}, {2, 11}, {3, 
               4}, {3, 6}, {3, 7}, {3, 9}, {3, 11}, {3, 12}, {4, 5}, {4, 7}, {
               4, 8}, {4, 10}, {4, 12}, {5, 6}, {5, 8}, {5, 9}, {5, 11}, {6, 
               7}, {6, 9}, {6, 10}, {6, 12}, {7, 8}, {7, 10}, {7, 11}, {8, 
               9}, {8, 11}, {8, 12}, {9, 10}, {9, 12}, {10, 11}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,4,6)\""],
        Annotation[#, "12-circulant graph (1,3,4,6)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 6}, {1, 7}, {1, 8}, {1, 10}, {1, 
               12}, {2, 3}, {2, 5}, {2, 7}, {2, 8}, {2, 9}, {2, 11}, {3, 4}, {
               3, 6}, {3, 8}, {3, 9}, {3, 10}, {3, 12}, {4, 5}, {4, 7}, {4, 
               9}, {4, 10}, {4, 11}, {5, 6}, {5, 8}, {5, 10}, {5, 11}, {5, 
               12}, {6, 7}, {6, 9}, {6, 11}, {6, 12}, {7, 8}, {7, 10}, {7, 
               12}, {8, 9}, {8, 11}, {9, 10}, {9, 12}, {10, 11}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,5,6)\""],
        Annotation[#, "12-circulant graph (1,3,5,6)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 
               12}, {2, 3}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {3, 4}, {
               3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {4, 5}, {4, 8}, {4, 
               9}, {4, 10}, {4, 11}, {4, 12}, {5, 6}, {5, 9}, {5, 10}, {5, 
               11}, {5, 12}, {6, 7}, {6, 10}, {6, 11}, {6, 12}, {7, 8}, {7, 
               11}, {7, 12}, {8, 9}, {8, 12}, {9, 10}, {10, 11}, {11, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,4,5,6)\""],
        Annotation[#, "12-circulant graph (1,4,5,6)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000001, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 7}, {1, 9}, {1, 10}, {1, 
               11}, {2, 4}, {2, 5}, {2, 6}, {2, 8}, {2, 10}, {2, 11}, {2, 
               12}, {3, 5}, {3, 6}, {3, 7}, {3, 9}, {3, 11}, {3, 12}, {4, 
               6}, {4, 7}, {4, 8}, {4, 10}, {4, 12}, {5, 7}, {5, 8}, {5, 9}, {
               5, 11}, {6, 8}, {6, 9}, {6, 10}, {6, 12}, {7, 9}, {7, 10}, {7, 
               11}, {8, 10}, {8, 11}, {8, 12}, {9, 11}, {9, 12}, {10, 
               12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (2,3,4,6)\""],
        Annotation[#, "12-circulant graph (2,3,4,6)", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 7}, {1, 9}, {1, 
               10}, {1, 11}, {1, 12}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 
               8}, {2, 10}, {2, 11}, {2, 12}, {3, 4}, {3, 5}, {3, 6}, {3, 
               7}, {3, 9}, {3, 11}, {3, 12}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {
               4, 10}, {4, 12}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 11}, {6, 
               7}, {6, 8}, {6, 9}, {6, 10}, {6, 12}, {7, 8}, {7, 9}, {7, 
               10}, {7, 11}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {9, 10}, {9, 
               11}, {9, 12}, {10, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3,4,6)\""],
        Annotation[#, "12-circulant graph (1,2,3,4,6)", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2158.2000000000003`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 6}, {1, 7}, {1, 8}, {1, 
               10}, {1, 11}, {1, 12}, {2, 3}, {2, 4}, {2, 5}, {2, 7}, {2, 
               8}, {2, 9}, {2, 11}, {2, 12}, {3, 4}, {3, 5}, {3, 6}, {3, 8}, {
               3, 9}, {3, 10}, {3, 12}, {4, 5}, {4, 6}, {4, 7}, {4, 9}, {4, 
               10}, {4, 11}, {5, 6}, {5, 7}, {5, 8}, {5, 10}, {5, 11}, {5, 
               12}, {6, 7}, {6, 8}, {6, 9}, {6, 11}, {6, 12}, {7, 8}, {7, 
               9}, {7, 10}, {7, 12}, {8, 9}, {8, 10}, {8, 11}, {9, 10}, {9, 
               11}, {9, 12}, {10, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,3,5,6)\""],
        Annotation[#, "12-circulant graph (1,2,3,5,6)", "Tooltip"]& ],
       TraditionalForm], {2160., -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
               9}, {1, 11}, {1, 12}, {2, 3}, {2, 4}, {2, 6}, {2, 7}, {2, 8}, {
               2, 9}, {2, 10}, {2, 12}, {3, 4}, {3, 5}, {3, 7}, {3, 8}, {3, 
               9}, {3, 10}, {3, 11}, {4, 5}, {4, 6}, {4, 8}, {4, 9}, {4, 
               10}, {4, 11}, {4, 12}, {5, 6}, {5, 7}, {5, 9}, {5, 10}, {5, 
               11}, {5, 12}, {6, 7}, {6, 8}, {6, 10}, {6, 11}, {6, 12}, {7, 
               8}, {7, 9}, {7, 11}, {7, 12}, {8, 9}, {8, 10}, {8, 12}, {9, 
               10}, {9, 11}, {10, 11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,2,4,5,6)\""],
        Annotation[#, "12-circulant graph (1,2,4,5,6)", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2158.2000000000003`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
               9}, {1, 10}, {1, 12}, {2, 3}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {
               2, 9}, {2, 10}, {2, 11}, {3, 4}, {3, 6}, {3, 7}, {3, 8}, {3, 
               9}, {3, 10}, {3, 11}, {3, 12}, {4, 5}, {4, 7}, {4, 8}, {4, 
               9}, {4, 10}, {4, 11}, {4, 12}, {5, 6}, {5, 8}, {5, 9}, {5, 
               10}, {5, 11}, {5, 12}, {6, 7}, {6, 9}, {6, 10}, {6, 11}, {6, 
               12}, {7, 8}, {7, 10}, {7, 11}, {7, 12}, {8, 9}, {8, 11}, {8, 
               12}, {9, 10}, {9, 12}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-circulant graph (1,3,4,5,6)\""],
        Annotation[#, "12-circulant graph (1,3,4,5,6)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0., 1.}, {1., 0.}, {1., 1.}, {
            2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
               9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {
               2, 9}, {2, 10}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
               10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 7}, {
               5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 
               9}, {7, 10}, {8, 9}, {8, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0., 1.}, {1., 0.}, {1., 
             1.}, {2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 
             1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-cocktail party graph\""],
        Annotation[#, "5-cocktail party graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 0.}, {0., 1.}, {1., 0.}, {1., 1.}, {
            2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 1.}, {5., 
            0.}, {5., 1.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
               9}, {1, 10}, {1, 11}, {1, 12}, {2, 3}, {2, 4}, {2, 5}, {2, 
               6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {3, 
               5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {3, 
               12}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 
               11}, {4, 12}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 
               12}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {7, 
               9}, {7, 10}, {7, 11}, {7, 12}, {8, 9}, {8, 10}, {8, 11}, {8, 
               12}, {9, 11}, {9, 12}, {10, 11}, {10, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 0.}, {0., 1.}, {1., 0.}, {1., 
             1.}, {2., 0.}, {2., 1.}, {3., 0.}, {3., 1.}, {4., 0.}, {4., 
             1.}, {5., 0.}, {5., 1.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-cocktail party graph\""],
        Annotation[#, "6-cocktail party graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2158.2000000000003`}, {
      Center, Center}, {360., 360.0000000000002}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.5, -0.866}, {0.5, -0.866}, {1., 
            0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 3}, {2, 
               4}, {2, 5}, {2, 6}, {3, 4}, {3, 5}, {3, 6}, {4, 5}, {4, 6}, {5,
                6}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.5, -0.866}, {0.5, -0.866}, {1., 
             0.}, {0.5, 0.866}, {-0.5, 0.866}, {-1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-complete graph\""],
        Annotation[#, "6-complete graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.433, -0.901}, {0.434, -0.901}, {
            0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
            0.624}, {-0.975, -0.223}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 
               3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3,
                7}, {4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {6, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.433, -0.901}, {0.434, -0.901}, {
             0.975, -0.223}, {0.782, 0.624}, {0., 1.}, {-0.781, 
             0.624}, {-0.975, -0.223}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"7-complete graph\""],
        Annotation[#, "7-complete graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.383, -0.924}, {0.383, -0.924}, {
            0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
            0.924}, {-0.924, 0.383}, {-0.924, -0.383}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3,
                5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {
               5, 6}, {5, 7}, {5, 8}, {6, 7}, {6, 8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.383, -0.924}, {0.383, -0.924}, {
             0.924, -0.383}, {0.924, 0.383}, {0.383, 0.924}, {-0.383, 
             0.924}, {-0.924, 0.383}, {-0.924, -0.383}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"8-complete graph\""],
        Annotation[#, "8-complete graph", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.342, -0.94}, {0.342, -0.94}, {
            0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
            0.766}, {-0.985, 0.174}, {-0.866, -0.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2,
                9}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {4, 5}, {
               4, 6}, {4, 7}, {4, 8}, {4, 9}, {5, 6}, {5, 7}, {5, 8}, {5, 
               9}, {6, 7}, {6, 8}, {6, 9}, {7, 8}, {7, 9}, {8, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.342, -0.94}, {0.342, -0.94}, {
             0.866, -0.5}, {0.985, 0.174}, {0.643, 0.766}, {0., 1.}, {-0.643, 
             0.766}, {-0.985, 0.174}, {-0.866, -0.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"9-complete graph\""],
        Annotation[#, "9-complete graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.309, -0.951}, {0.309, -0.951}, {
            0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 0.951}, {-0.309,
             0.951}, {-0.809, 0.588}, {-1., 0.}, {-0.809, -0.588}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {
               2, 8}, {2, 9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 
               8}, {3, 9}, {3, 10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {
               4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 
               8}, {6, 9}, {6, 10}, {7, 8}, {7, 9}, {7, 10}, {8, 9}, {8, 
               10}, {9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.309, -0.951}, {0.309, -0.951}, {
             0.809, -0.588}, {1., 0.}, {0.809, 0.588}, {0.309, 
             0.951}, {-0.309, 0.951}, {-0.809, 0.588}, {-1., 
             0.}, {-0.809, -0.588}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"10-complete graph\""],
        Annotation[#, "10-complete graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2550.6000000000004`}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.281, -0.96}, {0.282, -0.959}, {
            0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
            0., 1.}, {-0.541, 0.841}, {-0.91, 
            0.416}, {-0.99, -0.142}, {-0.756, -0.655}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {1, 10}, {1, 11}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {
               2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {3, 4}, {3, 5}, {3, 
               6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {4, 5}, {4, 6}, {
               4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11}, {5, 6}, {5, 7}, {5, 
               8}, {5, 9}, {5, 10}, {5, 11}, {6, 7}, {6, 8}, {6, 9}, {6, 
               10}, {6, 11}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {8, 9}, {8, 
               10}, {8, 11}, {9, 10}, {9, 11}, {10, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.281, -0.96}, {0.282, -0.959}, {
             0.756, -0.655}, {0.99, -0.142}, {0.909, 0.415}, {0.54, 0.841}, {
             0., 1.}, {-0.541, 0.841}, {-0.91, 
             0.416}, {-0.99, -0.142}, {-0.756, -0.655}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"11-complete graph\""],
        Annotation[#, "11-complete graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.259, -0.966}, {0.259, -0.966}, {
            0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 0.707}, {
            0.259, 0.966}, {-0.259, 0.966}, {-0.707, 0.707}, {-0.966, 
            0.259}, {-0.966, -0.259}, {-0.707, -0.707}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
               8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {2, 3}, {2, 4}, {2, 
               5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 
               12}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {
               3, 11}, {3, 12}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 
               10}, {4, 11}, {4, 12}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 
               10}, {5, 11}, {5, 12}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 
               11}, {6, 12}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {8, 
               9}, {8, 10}, {8, 11}, {8, 12}, {9, 10}, {9, 11}, {9, 12}, {10, 
               11}, {10, 12}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.259, -0.966}, {0.259, -0.966}, {
             0.707, -0.707}, {0.966, -0.259}, {0.966, 0.259}, {0.707, 
             0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
             0.707}, {-0.966, 0.259}, {-0.966, -0.259}, {-0.707, -0.707}}]& ],
          
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"12-complete graph\""],
        Annotation[#, "12-complete graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2550.6000000000004`}, {
      Center, Center}, {359.99999999999955`, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {2, 4}, {2, 5}, {2, 
               6}, {2, 7}, {3, 4}, {3, 5}, {3, 6}, {3, 7}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,4)\""],
        Annotation[#, "complete bipartite graph (3,4)", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.}, {1., 0.}, {1., 1.}, {
            2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 4}, {2, 
               5}, {2, 6}, {2, 7}, {2, 8}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3,
                8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.}, {1., 0.}, {1., 1.}, {
             2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (3,5)\""],
        Annotation[#, "complete bipartite graph (3,5)", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 5}, {2, 6}, {2, 
               7}, {2, 8}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {4, 5}, {4, 6}, {4,
                7}, {4, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -1.5}, {2., -0.5}, {2., 0.5}, {2., 1.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,4)\""],
        Annotation[#, "complete bipartite graph (4,4)", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2550.6000000000004`}, {
      Center, Center}, {360., 360.00000000000045`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
            1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {2, 5}, {2, 
               6}, {2, 7}, {2, 8}, {2, 9}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3,
                9}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -1.5}, {1., -0.5}, {1., 0.5}, {1., 
             1.5}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (4,5)\""],
        Annotation[#, "complete bipartite graph (4,5)", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 
               7}, {2, 8}, {2, 9}, {2, 10}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {
               3, 10}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
               7}, {5, 8}, {5, 9}, {5, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (5,5)\""],
        Annotation[#, "complete bipartite graph (5,5)", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.866, 0.5}, {0.5, 0.866}, {0., 
            1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
            0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
            0.866, -0.5}, {1., 0.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 4}, {1, 6}, {1, 8}, {1, 10}, {1, 12}, {2, 
               3}, {2, 5}, {2, 7}, {2, 9}, {2, 11}, {3, 4}, {3, 6}, {3, 8}, {
               3, 10}, {3, 12}, {4, 5}, {4, 7}, {4, 9}, {4, 11}, {5, 6}, {5, 
               8}, {5, 10}, {5, 12}, {6, 7}, {6, 9}, {6, 11}, {7, 8}, {7, 
               10}, {7, 12}, {8, 9}, {8, 11}, {9, 10}, {9, 12}, {10, 11}, {11,
                12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.866, 0.5}, {0.5, 0.866}, {0., 
             1.}, {-0.5, 0.866}, {-0.866, 0.5}, {-1., 
             0.}, {-0.866, -0.5}, {-0.5, -0.866}, {0., -1.}, {0.5, -0.866}, {
             0.866, -0.5}, {1., 0.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"complete bipartite graph (6,6)\""],
        Annotation[#, "complete bipartite graph (6,6)", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -2943.}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.}, {1., -1.}, {1., 0.}, {1., 
            1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
            2.}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 7}, {1, 8}, {1, 9}, {1, 10}, {2, 6}, {2, 8}, {2, 
               9}, {2, 10}, {3, 6}, {3, 7}, {3, 9}, {3, 10}, {4, 6}, {4, 7}, {
               4, 8}, {4, 10}, {5, 6}, {5, 7}, {5, 8}, {5, 9}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.}, {1., -1.}, {1., 0.}, {1., 
             1.}, {1., 2.}, {2., -2.}, {2., -1.}, {2., 0.}, {2., 1.}, {2., 
             2.}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-crown graph\""],
        Annotation[#, "5-crown graph", "Tooltip"]& ],
       TraditionalForm], {1374.5454545454545`, -2943.}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1., -2.5}, {1., -1.5}, {1., -0.5}, {1., 
            0.5}, {1., 1.5}, {1., 2.5}, {2., -2.5}, {2., -1.5}, {2., -0.5}, {
            2., 0.5}, {2., 1.5}, {2., 2.5}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {2, 7}, {2, 
               9}, {2, 10}, {2, 11}, {2, 12}, {3, 7}, {3, 8}, {3, 10}, {3, 
               11}, {3, 12}, {4, 7}, {4, 8}, {4, 9}, {4, 11}, {4, 12}, {5, 
               7}, {5, 8}, {5, 9}, {5, 10}, {5, 12}, {6, 7}, {6, 8}, {6, 9}, {
               6, 10}, {6, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1., -2.5}, {1., -1.5}, {1., -0.5}, {1.,
              0.5}, {1., 1.5}, {1., 2.5}, {2., -2.5}, {2., -1.5}, {
             2., -0.5}, {2., 0.5}, {2., 1.5}, {2., 2.5}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-crown graph\""],
        Annotation[#, "6-crown graph", "Tooltip"]& ],
       TraditionalForm], {1767.2727272727275`, -2943.}, {
      Center, Center}, {360.0000000000002, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{-0.707, -0.707}, {-0.259, -0.966}, {
            0.259, -0.966}, {0.707, -0.707}, {0.966, -0.259}, {0.966, 
            0.259}, {0.707, 0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707, 
            0.707}, {-0.966, 0.259}, {-0.966, -0.259}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 12}, {1, 8}, {2, 3}, {2, 11}, {3, 4}, {3, 
               6}, {4, 5}, {4, 9}, {5, 6}, {5, 12}, {6, 7}, {7, 8}, {7, 10}, {
               8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{-0.707, -0.707}, {-0.259, -0.966}, {
             0.259, -0.966}, {0.707, -0.707}, {0.966, -0.259}, {0.966, 
             0.259}, {0.707, 0.707}, {0.259, 0.966}, {-0.259, 0.966}, {-0.707,
              0.707}, {-0.966, 0.259}, {-0.966, -0.259}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Franklin graph\""],
        Annotation[#, "Franklin graph", "Tooltip"]& ],
       TraditionalForm], {2160., -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.468, 0.908}, {0.242, 0.736}, {0.722, 
            0.728}, {0.332, 0.462}, {0.612, 0.462}, {0.466, 0.684}, {0.466, 
            0.816}, {0.604, 0.71}, {0.552, 0.556}, {0.388, 0.558}, {0.336, 
            0.716}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 8}, {1, 11}, {2, 4}, {2, 7}, {2, 
               10}, {3, 5}, {3, 7}, {3, 9}, {4, 5}, {4, 9}, {4, 11}, {5, 8}, {
               5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.468, 0.908}, {0.242, 0.736}, {0.722, 
             0.728}, {0.332, 0.462}, {0.612, 0.462}, {0.466, 0.684}, {0.466, 
             0.816}, {0.604, 0.71}, {0.552, 0.556}, {0.388, 0.558}, {0.336, 
             0.716}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Gr\[ODoubleDot]tzsch graph\""],
        Annotation[#, "Gr\[ODoubleDot]tzsch graph", "Tooltip"]& ],
       TraditionalForm], {2552.727272727273, -2943.}, {
      Center, Center}, {359.99999999999955`, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.707, -0.707}, {0.707, 0.707}, {-0.707,
             0.707}, {-0.707, -0.707}, {1.414, -1.414}, {1.414, 
            1.414}, {-1.414, 1.414}, {-1.414, -1.414}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 6}, {3, 4}, {3, 
               7}, {4, 5}, {4, 8}, {5, 6}, {6, 7}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.707, -0.707}, {0.707, 
             0.707}, {-0.707, 0.707}, {-0.707, -0.707}, {1.414, -1.414}, {
             1.414, 1.414}, {-1.414, 1.414}, {-1.414, -1.414}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"4-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "4-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {2945.4545454545455`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.588, -0.809}, {0.951, 0.309}, {0., 
            1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
            0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 6}, {1, 10}, {2, 3}, {2, 7}, {3, 4}, {3, 
               8}, {4, 5}, {4, 9}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.588, -0.809}, {0.951, 0.309}, {0., 
             1.}, {-0.951, 0.309}, {-0.588, -0.809}, {1.175, -1.618}, {1.902, 
             0.618}, {0., 2.}, {-1.902, 0.618}, {-1.176, -1.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"5-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "5-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {3338.1818181818185`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.5, -0.866}, {1., 0.}, {0.5, 
            0.866}, {-0.5, 0.866}, {-1., 0.}, {-0.5, -0.866}, {1., -1.732}, {
            2., 0.}, {1., 1.732}, {-1., 1.732}, {-2., 0.}, {-1., -1.732}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 7}, {1, 12}, {2, 3}, {2, 8}, {3, 4}, {3, 
               9}, {4, 5}, {4, 10}, {5, 6}, {5, 11}, {6, 7}, {6, 12}, {7, 
               8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[11],
                "11"],
               Annotation[#, 11, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[12],
                "12"],
               Annotation[#, 12, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.5, -0.866}, {1., 0.}, {0.5, 
             0.866}, {-0.5, 0.866}, {-1., 0.}, {-0.5, -0.866}, {1., -1.732}, {
             2., 0.}, {1., 1.732}, {-1., 1.732}, {-2., 
             0.}, {-1., -1.732}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"6-M\[ODoubleDot]bius ladder graph\""],
        Annotation[#, "6-M\[ODoubleDot]bius ladder graph", "Tooltip"]& ],
       TraditionalForm], {3730.9090909090914`, -2943.}, {
      Center, Center}, {360., 360.00000000000045`}]}, {InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.951, 
            0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 
               5}, {3, 4}, {3, 5}, {4, 5}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.951, 
             0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"pentatope graph\""],
        Annotation[#, "pentatope graph", "Tooltip"]& ],
       TraditionalForm], {196.36363636363637`, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0., 1.}, {-0.951, 
            0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}, {0., 
            2.}, {-1.902, 0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 
            0.618}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 3}, {1, 4}, {1, 6}, {2, 4}, {2, 5}, {2, 7}, {3, 
               5}, {3, 8}, {4, 9}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {
               9, 10}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[9],
                "9"],
               Annotation[#, 9, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[10],
                "10"],
               Annotation[#, 10, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0., 1.}, {-0.951, 
             0.309}, {-0.588, -0.809}, {0.588, -0.809}, {0.951, 0.309}, {0., 
             2.}, {-1.902, 0.618}, {-1.176, -1.618}, {1.176, -1.618}, {1.902, 
             0.618}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"Petersen graph\""],
        Annotation[#, "Petersen graph", "Tooltip"]& ],
       TraditionalForm], {589.0909090909091, -3335.4000000000005`}, {
      Center, Center}, {360., 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1.074, -1.486}, {1.074, -0.534}, {
            1.352, -1.207}, {1.352, -0.813}, {1.746, -1.207}, {
            1.746, -0.813}, {2.025, -1.486}, {2.025, -0.534}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 5}, {1, 7}, {2, 4}, {2, 6}, {2, 
               8}, {3, 4}, {3, 5}, {3, 7}, {4, 6}, {4, 8}, {5, 6}, {5, 7}, {6,
                8}, {7, 8}}]}, 
             {RGBColor[0, 0, 0.7], 
              TagBox[
               TooltipBox[PointBox[1],
                "1"],
               Annotation[#, 1, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[2],
                "2"],
               Annotation[#, 2, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[3],
                "3"],
               Annotation[#, 3, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[4],
                "4"],
               Annotation[#, 4, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[5],
                "5"],
               Annotation[#, 5, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[6],
                "6"],
               Annotation[#, 6, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[7],
                "7"],
               Annotation[#, 7, "Tooltip"]& ], 
              TagBox[
               TooltipBox[PointBox[8],
                "8"],
               Annotation[#, 8, "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1.074, -1.486}, {1.074, -0.534}, {
             1.352, -1.207}, {1.352, -0.813}, {1.746, -1.207}, {
             1.746, -0.813}, {2.025, -1.486}, {2.025, -0.534}}]& ],
          AspectRatio->Automatic,
          FrameTicks->None,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]],
         "\"quartic transitive graph 5\""],
        Annotation[#, "quartic transitive graph 5", "Tooltip"]& ],
       TraditionalForm], {981.818181818182, -3335.4000000000005`}, {
      Center, Center}, {360.0000000000001, 360.00000000000045`}], InsetBox[
      FormBox[
       TagBox[
        TooltipBox[
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.943, -1.147}, {1.212, -0.681}, {
            1.264, -1.416}, {1.337, -1.829}, {1.606, -0.825}, {
            1.875, -1.829}, {1.947, -1.416}, {1.999, -0.681}, {
            2.268, -1.147}}, {
             {RGBColor[0.5, 0., 0.], 
              LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 7}, {2, 5}, {2