(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1027677,      24725]
NotebookOptionsPosition[    996573,      23668]
NotebookOutlinePosition[    998771,      23724]
CellTagsIndexPosition[    998656,      23718]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Graph Drawing in Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction"], 
          "General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Introduction to Graph Drawing in Mathematica \"\>", 
       2->"\<\"General Graph Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot3D"], 
          "LayeredGraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"], "TreePlot" :> 
          Documentation`HelpLookup["paclet:ref/TreePlot"], "GraphData" :> 
          Documentation`HelpLookup["paclet:ref/GraphData"], "PolyhedronData" :> 
          Documentation`HelpLookup["paclet:ref/PolyhedronData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphPlot3D\"\>", 
       2->"\<\"LayeredGraphPlot\"\>", 3->"\<\"TreePlot\"\>", 
       4->"\<\"GraphData\"\>", 
       5->"\<\"PolyhedronData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Computational Systems\"\>", 3->"\<\"Data Visualization\"\>", 
       4->"\<\"Discrete Mathematics\"\>", 
       5->"\<\"New in 6.0: Data Visualization\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["i", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]], "->", 
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["j", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]]}], ",", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of the graph represented by the \
adjacency matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " attempts to place vertices to give a well laid-out version of the graph. "
}], "Notes",
 CellID->457633418],

Cell[TextData[{
 "The vertex names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " and the labels ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can be any expressions."
}], "Notes",
 CellID->181146064],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", edges are drawn as ordinary lines. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", edges are drawn as arrows."
}], "Notes",
 CellID->69175411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->30166],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what ticks to include on the frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method used to lay out the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use for packing components", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], "Automatic", Cell[
    "how much padding to put around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall graphics directives for vertices and edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True}}}},
 CellID->32136],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", vertices are displayed as points, with their names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " given in tooltips."
}], "Notes",
 CellID->16670666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    StyleBox["vlab", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to specify an alternative tooltip for a vertex. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["i", "TI"]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
 " specifies a tooltip for an edge."
}], "Notes",
 CellID->762729751],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->442256812],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is the position where the vertex is being placed, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is its name."
}], "Notes",
 CellID->166183907],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge."
}], "Notes",
 CellID->636470603],

Cell[TextData[{
 "The graphics primitives obtained by applying ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the graphic generated by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ".",
 " ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->184577521],

Cell[TextData[{
 "In the graphics generated by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ", edges are effectively drawn first, and vertices afterwards."
}], "Notes",
 CellID->249053938],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", coordinates are chosen so that the average length of the edges in the \
graph is approximately 1."
}], "Notes",
 CellID->80983619],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 ", an explicit rule ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["k", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["k", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies coordinates for a vertex. If any coordinate is given as ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", it is found automatically. Vertices for which no rules are specified are \
taken to have automatically generated ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " positions."
}], "Notes",
 CellID->204192059],

Cell["\<\
The graph does not need to be connected. Disconnected components are \
typically arranged so as to fill area roughly uniformly.\
\>", "Notes",
 CellID->70117131],

Cell["\<\
When a graph is specified by an adjacency matrix, the names of its vertices \
are taken to be successive integers starting at 1.\
\>", "Notes",
 CellID->67697114],

Cell[TextData[{
 "The adjacency matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->105198305],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are not shown if the graph is specified by an adjacency \
matrix."
}], "Notes",
 CellID->424434705],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " include ",
 Cell[BoxData["\"\<CircularEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RandomEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RadialDrawing\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 ".",
 " ",
 "The method ",
 Cell[BoxData["\"\<LinearEmbedding\>\""], "InlineFormula"],
 " lays out all vertices on a single line."
}], "Notes",
 CellID->102997983],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " normally uses the ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 " method, though uses the ",
 Cell[BoxData["\"\<RadialDrawing\>\""], "InlineFormula"],
 " method if the graph is a tree."
}], "Notes",
 CellID->106260262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " returns an object of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["Annotation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Annotation"], "[", 
    RowBox[{
     StyleBox["data", "TI"], ",", 
     RowBox[{
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"], "->", 
      StyleBox["rules", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->233609336]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337842453],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->161911048],

Cell["Plot a network from rules for connections:", "ExampleText",
 CellTags->"b:0.1",
 CellID->1269326376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"4", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->433788910],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341056942]
}, Open  ]],

Cell["Show the directions of edges:", "ExampleText",
 CellID->128745197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85415944],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.93381150779063, 0.}, {0.934117823025754, 
    0.869482954049618}, {0., 0.434455976633643}, {1.86761826162018, 
    0.434313309965105}, {0.911456965364256, 0.0895522406484344}, {
    0.90589124623519, 0.113634188161932}, {0.901171557895575, 
    0.137896133002432}, {0.89730368036666, 0.162308362496844}, {
    0.894292350489672, 0.18684097992423}, {0.892141256124789, 
    0.211463941129168}, {0.890853031634755, 0.236147091315678}, {
    0.890429254658686, 0.260860201976642}, {0.890551780752736, 
    0.608653383596489}, {0.890992970274035, 0.633366189533347}, {
    0.892298585984822, 0.658048425920723}, {0.894467028947622, 
    0.682669865370593}, {0.897495643553527, 0.707200354950612}, {
    0.901380720774415, 0.731609853111251}, {0.906117502705257, 
    0.755868466476532}, {0.911700188390938, 0.779946486453295}, {
    0.956472365452127, 0.779930713401184}, {0.962038084581194, 
    0.755848765887686}, {0.966757772920808, 0.731586821047187}, {
    0.970625650449723, 0.707174591552775}, {0.973636980326711, 
    0.682641974125389}, {0.975788074691595, 0.658019012920451}, {
    0.977076299181628, 0.633335862733941}, {0.977500076157697, 
    0.608622752072976}, {0.977377550063648, 0.260829570453129}, {
    0.976936360542349, 0.236116764516271}, {0.975630744831562, 
    0.211434528128896}, {0.973462301868761, 0.186813088679026}, {
    0.970433687262857, 0.162282599099007}, {0.966548610041968, 
    0.137873100938367}, {0.961811828111127, 0.113614487573087}, {
    0.956229142425446, 0.0895364675963233}, {1.86768036899183, 
    0.438159201103159}, {1.87860734641476, 0.506638024643768}, {
    1.90829495780804, 0.569306947076409}, {1.95436191879445, 
    0.621139207441778}, {2.01311313470807, 0.657977268435525}, {
    2.0798360892489, 0.676866298226629}, {2.14917884193423, 
    0.67629118160603}, {2.21557931464818, 0.656298049473435}, {
    2.27371143362146, 0.618490578614038}, {2.31891234117606, 
    0.565901358565185}, {2.34755640998987, 0.502748643414554}, {
    2.3573460596795, 0.434097999804597}, {2.34749604890116, 
    0.365455990824865}, {2.31879646064506, 0.302328486969278}, {
    2.27354932858585, 0.249779032647435}, {2.21538398777712, 
    0.212022692283043}, {2.14896596066625, 0.192087954165713}, {
    2.07962272908497, 0.191573811215898}, {2.0129164095621, 
    0.210521503550825}, {1.95419760826253, 0.247411210557646}, {
    1.90817624146523, 0.299283957807187}, {1.87854374666313, 
    0.361978960486114}, {1.86767698725544, 0.43046736570249}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.0346649517689871, 0.5}}], 
      ArrowBox[{1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
       2}], ArrowBox[{2, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
       34, 35, 36, 1}], ArrowBox[{3, 1}], ArrowBox[{3, 2}], ArrowBox[{4, 1}], 
      ArrowBox[{4, 2}], 
      ArrowBox[{4, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
        52, 53, 54, 55, 56, 57, 58, 59, 4}]}, {
      TooltipBox[PointBox[1],
       "1"], 
      TooltipBox[PointBox[2],
       "2"], 
      TooltipBox[PointBox[3],
       "3"], 
      TooltipBox[PointBox[4],
       "4"]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.93381150779063, 0.}, {0.934117823025754, 
     0.869482954049618}, {0., 0.434455976633643}, {1.86761826162018, 
     0.434313309965105}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31997761]
}, Open  ]],

Cell["Include labels for vertices:", "ExampleText",
 CellID->278833988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->522758305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->654190971]
}, Open  ]],

Cell["Show labels for edges:", "ExampleText",
 CellID->450338680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "\[Rule]", "2"}], ",", "\"\<4\[Rule]2\>\""}], "}"}], ",", 
     
     RowBox[{"4", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->157238898],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->430224463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24464],

Cell["Draw a graph specified by its adjacency matrix:", "ExampleText",
 CellID->16827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5705],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.93381150779063, 0.}, {0.934117823025754, 
    0.869482954049618}, {0., 0.434455976633643}, {1.86761826162018, 
    0.434313309965105}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 1}], 
      LineBox[{3, 1}], LineBox[{3, 2}], LineBox[{4, 1}], LineBox[{4, 2}]}, 
     {RGBColor[0., 0., 0.7], PointBox[1], PointBox[2], PointBox[3], 
      PointBox[4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.93381150779063, 0.}, {0.934117823025754, 
     0.869482954049618}, {0., 0.434455976633643}, {1.86761826162018, 
     0.434313309965105}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217413637]
}, Open  ]],

Cell["Include self loops and multiedges:", "ExampleText",
 CellID->417582009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "True"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358351727],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35952710]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26664],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->369255627],

Cell["Specify a graph using a rule list: ", "ExampleText",
 CellID->1096410170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430275],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355361068977`, 0.4354768904620554}, {
    0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
    0.9349065696772771, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355361068977`, 0.4354768904620554}, {
     0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
     0.9349065696772771, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17168707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56963074],

Cell["Specify a graph using a dense adjacency matrix: ", "ExampleText",
 CellID->155380432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273676337],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355361068977`, 0.4354768904620554}, {
    0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
    0.9349065696772771, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355361068977`, 0.4354768904620554}, {
     0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
     0.9349065696772771, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264658852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1640804889],

Cell["Specify a graph using a sparse adjacency matrix: ", "ExampleText",
 CellID->1544973088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430216091],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355361068977`, 0.4354768904620554}, {
    0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
    0.9349065696772771, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355361068977`, 0.4354768904620554}, {
     0.9335045208470918, 0.8695704006680989}, {0., 0.4348238908893781}, {
     0.9349065696772771, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219810259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1233819],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 " for collections of graphs: "
}], "ExampleText",
 CellID->149518306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{"GraphData", "[", 
     RowBox[{"g", ",", "\"\<EdgeRules\>\""}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<GeneralizedPetersen\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "2"}], "}"}]}], "}"}], ",", 
       "\"\<ClebschGraph\>\"", ",", "\"\<TesseractGraph\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2815895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.058330599512005, 0.9820970750993849}, {
      2.132393360347747, 0.9796640406225409}, {0.8740135101849748, 
      2.0401423600338253`}, {1.5951540318125943`, 0.785830411757916}, {
      2.418702302823167, 1.4749708742126544`}, {0.7739402191515196, 
      1.4769933162072155`}, {2.32085943824735, 2.0371938256114355`}, {
      1.883514319531773, 2.4052870686926466`}, {1.3120842358545912`, 
      2.405564694611964}, {0.5521343942889079, 0.3814034727295681}, {
      1.5933753138603766`, 0.}, {2.6367628551806703`, 0.37785617620846357`}, {
      3.1930474666643605`, 1.3372207100289877`}, {3.00206067720356, 
      2.429262678653379}, {2.154017612498619, 3.1429727487157275`}, {
      1.045388751913524, 3.145382698360752}, {0.19389818111363288`, 
      2.4339159550318916`}, {0., 1.3421616077172862`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 10}, {2, 7}, {2, 12}, {3, 17}, {4, 5}, {
         4, 6}, {4, 11}, {5, 8}, {5, 13}, {6, 18}, {7, 9}, {7, 14}, {8, 3}, {
         8, 15}, {9, 6}, {9, 16}, {10, 11}, {10, 18}, {11, 12}, {12, 13}, {13,
          14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.058330599512005, 0.9820970750993849}, {
       2.132393360347747, 0.9796640406225409}, {0.8740135101849748, 
       2.0401423600338253`}, {1.5951540318125943`, 0.785830411757916}, {
       2.418702302823167, 1.4749708742126544`}, {0.7739402191515196, 
       1.4769933162072155`}, {2.32085943824735, 2.0371938256114355`}, {
       1.883514319531773, 2.4052870686926466`}, {1.3120842358545912`, 
       2.405564694611964}, {0.5521343942889079, 0.3814034727295681}, {
       1.5933753138603766`, 0.}, {2.6367628551806703`, 
       0.37785617620846357`}, {3.1930474666643605`, 1.3372207100289877`}, {
       3.00206067720356, 2.429262678653379}, {2.154017612498619, 
       3.1429727487157275`}, {1.045388751913524, 3.145382698360752}, {
       0.19389818111363288`, 2.4339159550318916`}, {0., 
       1.3421616077172862`}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.8204229641012275`, 0.4321657715633965}, {
      1.036256447240108, 0.7134194270095069}, {1.8175241370524842`, 
      1.4309393686633856`}, {0.6721914226631673, 0.2835832493072038}, {
      0.25417459320628877`, 0.4284405070495584}, {2.0717204397528826`, 
      0.9321356830672599}, {0.6703193672149296, 1.574494246454242}, {
      0.6118456954945826, 0.9295423324524118}, {1.3980623427782088`, 
      1.5768301309737525`}, {1.0338868331202415`, 1.8604842004908388`}, {
      0.25157098931398236`, 1.429436107157864}, {0., 0.9280935362682613}, {
      1.0355701973669136`, 1.1471509064787448`}, {1.459928614647865, 
      0.9305888263698067}, {1.0372393676939173`, 0.}, {1.4023030680894015`, 
      0.28465313341221765`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 9}, {2, 5}, {2, 10}, {2, 12}, {4,
          11}, {4, 12}, {4, 14}, {4, 16}, {5, 7}, {5, 11}, {5, 16}, {6, 2}, {
         6, 9}, {6, 13}, {6, 14}, {6, 16}, {7, 9}, {7, 3}, {8, 9}, {9, 11}, {
         10, 3}, {10, 11}, {10, 8}, {12, 8}, {12, 13}, {12, 7}, {13, 3}, {13, 
         11}, {14, 10}, {14, 7}, {15, 5}, {15, 14}, {15, 8}, {15, 13}, {15, 
         1}, {16, 3}, {16, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.8204229641012275`, 0.4321657715633965}, {
       1.036256447240108, 0.7134194270095069}, {1.8175241370524842`, 
       1.4309393686633856`}, {0.6721914226631673, 0.2835832493072038}, {
       0.25417459320628877`, 0.4284405070495584}, {2.0717204397528826`, 
       0.9321356830672599}, {0.6703193672149296, 1.574494246454242}, {
       0.6118456954945826, 0.9295423324524118}, {1.3980623427782088`, 
       1.5768301309737525`}, {1.0338868331202415`, 1.8604842004908388`}, {
       0.25157098931398236`, 1.429436107157864}, {0., 0.9280935362682613}, {
       1.0355701973669136`, 1.1471509064787448`}, {1.459928614647865, 
       0.9305888263698067}, {1.0372393676939173`, 0.}, {1.4023030680894015`, 
       0.28465313341221765`}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.462536267982853, 0.6683040043248684}, {
      1.5631057757042315`, 0.5515647529667521}, {0.8693305371493443, 
      1.3282674162606747`}, {1.9094099395493909`, 1.387325743282453}, {
      1.7018000444604333`, 0.01604228522427742}, {0.7428483434872406, 0.}, {
      0.07607560242979905, 0.6888477787111533}, {1.0331457081139268`, 
      0.7009529532123772}, {1.5933243996482136`, 1.0279389820219802`}, {
      0.5530939403001436, 0.9686377589523277}, {0., 1.6878703443475684`}, {
      0.9004657803214509, 1.804827166077596}, {2.387063362771671, 
      1.6670767120498866`}, {1.429989994652155, 1.6551044856582298`}, {
      0.7610125184577052, 2.341139204453035}, {1.7201389057984589`, 
      2.356791973382646}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {1, 5}, {1, 13}, {2, 3}, {2, 6}, {2, 14}, {3,
          4}, {3, 7}, {3, 15}, {4, 8}, {4, 16}, {5, 6}, {5, 8}, {5, 9}, {6, 
         7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 12}, {9, 13}, {
         10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {13, 
         16}, {14, 15}, {15, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.462536267982853, 0.6683040043248684}, {
       1.5631057757042315`, 0.5515647529667521}, {0.8693305371493443, 
       1.3282674162606747`}, {1.9094099395493909`, 1.387325743282453}, {
       1.7018000444604333`, 0.01604228522427742}, {0.7428483434872406, 0.}, {
       0.07607560242979905, 0.6888477787111533}, {1.0331457081139268`, 
       0.7009529532123772}, {1.5933243996482136`, 1.0279389820219802`}, {
       0.5530939403001436, 0.9686377589523277}, {0., 1.6878703443475684`}, {
       0.9004657803214509, 1.804827166077596}, {2.387063362771671, 
       1.6670767120498866`}, {1.429989994652155, 1.6551044856582298`}, {
       0.7610125184577052, 2.341139204453035}, {1.7201389057984589`, 
       2.356791973382646}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->322791888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556990123],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 " for collections of sparse matrices: "
}], "ExampleText",
 CellID->587125292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<Bai/dwa512\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2132219943],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->588844539]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4212966],

Cell["Give labels for some edges:", "ExampleText",
 CellID->124062807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "3"}], ",", "\"\<23\>\""}], "}"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524298092],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.4322945363076125}, {0.9443685976902727, 
    0.8053683937984101}, {0.002039855487186326, 1.179360021193507}, {
    1.6813210456539793`, 1.6106199560744496`}, {1.6811673587196472`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"23\"", StripOnInput -> False], TraditionalForm]], {
             0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{2, 3}]}, LineBox[{2, 4}], 
      LineBox[{2, 5}], LineBox[{3, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.4322945363076125}, {0.9443685976902727, 
     0.8053683937984101}, {0.002039855487186326, 1.179360021193507}, {
     1.6813210456539793`, 1.6106199560744496`}, {1.6811673587196472`, 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588070640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1093274895],

Cell["Give vertex labels:", "ExampleText",
 CellID->250888577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1908060239],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77276291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1301177980],

Cell["Do not show multiedges or self-loops:", "ExampleText",
 CellID->956609091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417724249],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.036501778392792, 0.}, {1.1690731639707779`, 
    0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
    3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
    1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
    1.2966250642465846`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 1}, {3, 4}, {3, 5}, {3, 1}, {6, 7}, {6, 5}, {6, 
       2}, {6, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.036501778392792, 0.}, {1.1690731639707779`, 
     0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
     3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
     1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
     1.2966250642465846`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400448195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622455388],

Cell["Show edge as arrows:", "ExampleText",
 CellID->1768796684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1049937125],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.36327126408405364`, 1.8090169944118928`}, {
    0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
    0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
    1.809016994253556}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03444668289820355, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{4, 2}], ArrowBox[{5, 2}], 
      ArrowBox[{6, 2}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.36327126408405364`, 1.8090169944118928`}, {
     0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
     0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
     1.809016994253556}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{132., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{136, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1464971006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996109397],

Cell["Plot a disconnected graph using different packing methods: ", \
"ExampleText",
 CellID->2995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"GraphPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"i", "\[Rule]", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "^", "2"}], ",", "102"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "102"}], "}"}]}], "]"}], ",", 
      RowBox[{"PackingMethod", "\[Rule]", "pm"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"pm", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Automatic\>\"", ",", "\"\<ClosestPacking\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[1]:=",
 CellID->1209134277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJw9V3k8VG0bZsaQNWSoMHNmU0ZZXmRLbupLsqQFKSEvldZXSikkWVJUJCpq
kiUkLaQUzaMiyhKJvC1SWRJJlmQs37znNP6a3/M753me677u677mOgyfPWv8
SGJiYnRxMbH/fi///FH7SB2D/j1Tv703cZFaqn2CaiMDHpaa/3Yrp6N8UrFC
onDNzguq/WA7zA93Le2pKcGg6KGq3FdPCsry3vFo1QtxCG9yuvqut5M/5X74
+30dMTgIBy7sOCPg21yVI58yZ8KFao8eO4Ekuv59a2nTHRr0JF9IqrRXR8VR
NdWdkzSYzD+6sjmLjpRLttgtZynDj9mFk5VbOGiLMdNQNVoJrqwW11LyYiGJ
D+nrUt8w4cHlbHVlNS00sV2ar1vHglecbUeyGWx0uY1hfUuaATk9T42vWyqh
nvUvPi9ax4KRpE27+jbLIrA1LvaSJ4G+jk7TFVtJ1NKg520dgE3jL9x4ynqx
FAb39cqqKB7j/NOU5G9LL2jB4/v1Qd+NWai5WPpw/WYOrL5l035yCwMdVIsJ
CW3pt5LjF+V79dLQmyMvPiRX/bLK7q0+m7+Ugfzz/GkFRRhYT4itJdcz0Nt0
go88a8D3KzBiVJIuMyDpZGfLfL4KWvlkwd5HM1iwkxHgmhuuhN6YKYW0h8rB
2EejezdPK6HbaZkGzunywB6+MOofJoO2y9bi9ZlX+WzNTiIh7O7Z+SYPxcHX
WGzsv37C9nmrdwcNWon6m7ouxLJMWRIW2QfWH3XF0D/Yza5diAXrEAnHV1oV
NxDTzITwoS4cz7k6iYnARTMg/mfb/bubpNCV1N9Pz3/ngEamfuLpBUrIpiff
UHExB/Yd78uWNZJBSdp7LVW+aYFj49u/Lkgw0WL3YMdICxX4zHmE89OZXxOV
ginCXpqFakEjDd0Jd2clzOVA97LyT40mJLR98Pf4f/d5HEtM/aVIRcnt3qzz
huqQ4rpS3+ekBPJvac5U20uDJbw2/D6tfOM3zwc1oKn5+cGXMppIxWdzVcoL
EjRbKal+SWZO41/nzJa8V8dAcZUOCTNV1GGtXzOOT1HtOa6/1ATLSwvGmMjD
Q459zgWDrHKqY+EuRXSJmlTK3SADFW60Dx9DxFFnG/V83IlZ0/NS3n+tRq+B
AdHrR6t94zRQVsrrpce9FCC7c7TGIFbYXweS8a176rAn7zmun4gE0pfxRiZ8
1n2Wu9RCHP3RnZWH1I8tQzwZNP/b4XkHysesLu22NaXx5NHoDy+8/lXD3pkG
O6RR91/J539Is+Ff1Zpq6woOctKm+RtU0sDhvUWFpesP/k6lkm1v1lMB/Clb
/ztvo/7a/zktU4Y5WZH9Jw0oKFg3tDDxhJZw3j7uD8EU0IstXUYSr5mwO+TQ
PLvPdERXdqsrdhi1Kkm9ic+fWXVPqGQ/GVxjogIZfDZybCPpnbvDhl65xnc1
dZP8lcPNq0z2cqb5+Cl3a+vkAzYMRPokWI7QkN+ffnqdu+tXcUQLnU3ZNrTq
rRaYegfh9Yj0ITF2btDgl4B/B7OMkJTXhC+kUu+v5r/4aSbreekUBhTxl4ds
cGajL62fr91W54B2k9FBo3kc1CttlKX8Wh3u36vB6xHhVzwTXTv2QRmRLQxw
ffz8a3b0TVs2quXr6M+hzoRDeZM43hK2D+5HTkcM8PO+qFLwfs0Y8k1Zo0tH
YY9McTy+yvNxvYv8KfREPH7+nugsvP81lMhNHdFslJ9xx+J8ugKEmGo91a2Z
i/w0A/F5EOu7fjqsCkN6x/3x+sPLvXA9f63qyvqXzAa0SsW1QFMFHRvlqQs4
bHjnCr8X1Wii7rfyn6LpbFAZZezfsGiMD4+PryYrc2ATWTH4QYcy6qwGmuUe
JjR3LV7+KJ8+racYl5zby3lM5PvyPO5feYp78Ho8XyzC+Uqcyy/TzZ/ie6ye
uLBIwIEtJzRwfkT6IRfcwPd7PHDE50UyPBvH/+uB2cTJ3UwYnIrLSasXQ/v+
+F++5z94/94HbcD7VZgXEHfotway7GhPDTXRmOZb2b/oc6Xw/+a31oVVnhu5
KNZ+NT2YgUHYczF+ggkX3TdAy8b0MbDJaTpTq8pFjavmDsvaYfCU2n/+jkAb
pSvGD/K3YhAT3L5zV7c2MrOgPuedwEDgPfEo9oM26pi/b2NbAQYBy+TTG4Xr
3GXDa5MbMFi56ZC5zVdtlOMV/V7Qj8HXSjcgTWgjz/CFtTwpBnzqu80Jnc1F
ezueFqapMsCsaWFGmBkXEf+PDMhtJPRdUU0859Q2OC89ykUW9sT+3muOdcuu
ctFaKnF+bum1Qn4ZF83+NoTf/1ohquRIAxeteBaI4+uW+7mm/y0X+baq4Pj9
m8SNTd9x0c7iOLy+kSuaMesaueiQBFG/bN/MjTP5XGQn4OP8jNty/x7K4CJv
XYK/F3MmjfSPcVHUVoLfb/f9Mv/24iJycav0tnYG6D/V0tN2p6MRI+k1e/oY
4Pb+zZdnDDpq6W0dbp9igA2Pt2J8gIZebjL8ylNjgvV1j4xbNTTk7Plj/yJD
Jtxlp9nrFNGQr6HZmxFnJsjQ3mLfcmnoGDc+UlGov0gLO4MzBTTUaLok9MZJ
JlxtzR5pKKch7ajhcYUsJvwv+cbjY59oyIWUU5xTwgQr3gD1mgIdDWw4Im5W
xQQBvf3xiaV0FKzpcOBdPRMiHO+ODIXS0dwWnVfqL5lQ1z2R4vKAjoxuNpoM
Ct9XvezYPTFERw4Bn3Y0PmBCQ4EBaSEVQw/fXZmRnM0El5ow7yQdDGnuDacc
imdC44DsErfFGJoyTtwrGcCEfOv4L3uWY2jts+pTv9YI/a+7pQDsMGR/dv9N
pjETlB5szr60DENBTlM89zlM+BpcaFBviqFywz5TJ3EmjEb058ZrYUixvuzr
ge8MkDX31hhRwJBjetD28eMsWNUxPh6zmYSuKPaJCbJZ4G5cmdmwloSqDp48
0vmUBQdjukv7/iYh6uiNkm8fWbDSWPXhxzMklOW3QcflNwtuPdR91ttCQuB4
OydLjg2al4ZjS43IKCvq4qWbc9igvutoc3Y6GaX35+29JvSHHRZd8lKzJRCj
VX5Uj8YGSzqpNfOMBDIdilfxprLh+23+F7YEBSXcn/Qqp7Bhcdd1dHgHBVmk
v35k+4MFoaGcDxsRBek9Gz9q08yC9YH3x1ImKCjEkz1oW8KCsPSBoUC6JNLs
+hqnkcqCXr1Tmm0sSXR15PHmlFAWBFD3BSXJSKKmqWTvKB8WuGLDXbTXFKR1
Isck3p4F7wXXuOXRFHRlW2Uc1Vy4jv3+3oZNQZTAVZp6eiw4E6DRmVUogZa3
pahH6rAgt+U0r8pCAs1/sbvWUfj8coU7b+wJGXUs/1d+tXB/SopM3Im1wvqL
ZTMWCvNNxx+9d15lV6auGLTyphLzsDPgxsXEmp9WaSbEvPDC36lR5H5azX1O
zNO8Q8vZfqoDVm5biHmrWynzsWay3+pzGDGPiv+oP3/1oM9qV+oAPq9NhdI2
vqe/WSVFROLz3EEezZHN/Wo1PJuY95jRqIIa3W6r8QEH3A/Mr8383+SSLqss
WcIvRP5sLE/4ySwfJfx5iTLhN0UrY/H9P00IPzLMHcfPN2YRfvXRYSZ+v3RD
MO5nHbEMHN9Ioxzud/O2KeL498sSflhrb4fX172E8EvPtx/w+l/9/I77aQ/7
Js7PpxTCb43iODh/syoJP5Z+QvA7+Mev01JcrrNkJeFRG9eS64YhXcsYg+oQ
CpgZTvkreGLo2CvLZv9eCTBcZXjm9gYMfXtJ077oJwEJksml6x0x9FLrvS93
kAxzXXLFVE0wtGyzqu+Ky2TAfrUH3ZmDIR+Yx3myiwy3tT/pz+qno153N0GY
HxnEaIN5t7PpqKxMP5MTTYaCKqcMBW86cpGckTe7lgydb4bONGF0FNpiq3PN
SAJOj8c+pn6noaxko+KIIglwWVlu/uUFDVVmJLb621Ago/68+mQpDR3WrXo4
1kiBxpb8dece0xDF2aApbYMk/Jgze47JOxqqkHCV2lMnCQ9zKlVeS9FRq/kV
uXkcKfiHqpXZb01HJ7oc/3rpJgVdBx2uv4+ioy7rnX9t8JGCmx7b7BbU0dHe
q98zepdKQVrG9U0xMkI+BMGuo5OSsMVrpGQ7V+gvsYFGlAuSEDhluNtA6DfP
DHffgrmSYJ7XqvfcBUNPza7aXVsjA6wX97xIh8RRpPGlik+vpMEjHnPnGYoj
d/OUjP5d0mCcon08skYM+c1juQrmS4Pt+knVXw5iaEQn+1m8jDSII9jiGzbF
z1xY8UyNKg1L7Rr6tDdN8qMOBPYhW2m4qm/aEOA4wZczevTz4GVp2Lf84Vkp
v3F+ieNnjr2yDNirkbJOFwv4iXkOS/ouyEDeCtezM5wFfBObCCyMKwv7g6Ru
XjcT8NsWfFzqd18WknPzdJbtF/C70mrqwFQONl4UTtakgJ8xKutcz5MDF8Gh
SEr1OL+v4JPL4045SPf8XNtXMcG33/NwcpuUPByY2tcb/HGS797e08SekoP4
+NkkMXExtJkpOMerk4OYD28PZ8SKoVdNhufKguVg8dDoVYMpMVT4ZOClo5Qc
3DG+nrh4vThyPdbICguXBSilt/PixZG6TGwV7YcMOGY5rZiVKo4S6h84Pd0s
A7fujCdFHBFHdTVpT9KE+V6UT8oSms3Fk2dN5xN1z6Io8t1Z0/nE6eK2Tq2O
WdP5pFfd6fMppsp0PtEI8DzjtE1lOp/sc9AorL2lMp1PBMdomRYjKtP55HcJ
3JM0pE7nEz/BqWQnH+p0PjldUfb3inDqdD4hvkeo0/nE6BTxXJRP6AnEflE+
ceYQ54vyyb8vNfH7RfnELFYdxyfKJwE3NuH4RfkkYqsjXp8on/DIRP2ifLJ4
oBDnR5RP/N0I/kT5pKia4FeUTy4dmWWuJ/x+6P6zHsoLmgzZyYFzasT7Wxuk
WgUeHKixIs57XHZjfs8yDiS+Je7bLGHBXaTFgexjBJ6L7++sdSUL17kE3sb+
tY9V29ig00T494yXjdVepWwoqiL8e8cNaxi7xIb67QQfGhEXnV2j2TDkQPDl
oEje7n6ADX47CT6J7x329PeO6HlwINEP0f6eRKJfovNn7if6Kbqfq0b0W4Sv
UJbQgwi/6SJCL6L6TD0IPYnqd5Ag9CbiR/kKoUcRf3ZVhF5F/I780fP/AWST
bhg=
       "], {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
           115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 1}, {2,
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
           140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 2}, {3, 4}, {4, 
           7}, {5, 6}, {6, 16}, {7, 29}, {8, 9}, {9, 23}, {10, 11}, {11, 
           54}, {12, 13}, {13, 33}, {14, 15}, {15, 7}, {16, 35}, {17, 18}, {
           18, 4}, {19, 20}, {20, 33}, {21, 22}, {22, 46}, {23, 24}, {24, 
           2}, {25, 26}, {26, 15}, {27, 28}, {28, 35}, {29, 150, 151, 152, 
           153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
           166, 167, 168, 169, 170, 171, 172, 29}, {30, 31}, {31, 173, 174, 
           175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
           188, 189, 190, 191, 192, 193, 194, 195, 31}, {32, 196, 197, 198, 
           199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
           212, 213, 214, 215, 216, 217, 218, 32}, {33, 24}, {34, 26}, {35, 
           51}, {36, 37}, {37, 15}, {38, 20}, {39, 40}, {40, 54}, {41, 15}, {
           42, 27}, {43, 44}, {44, 4}, {45, 9}, {46, 47}, {47, 32}, {48, 
           49}, {49, 23}, {50, 4}, {51, 219, 220, 221, 222, 223, 224, 225, 
           226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 
           239, 240, 241, 51}, {52, 242, 243, 244, 245, 246, 247, 248, 249, 
           250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 
           263, 264, 52}, {53, 2}, {54, 47}, {55, 49}, {56, 7}, {57, 58}, {58,
            16}, {59, 44}, {60, 13}, {61, 18}, {62, 63}, {63, 28}, {64, 37}, {
           65, 24}, {66, 67}, {67, 46}, {68, 29}, {69, 265, 266, 267, 268, 
           269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
           282, 283, 284, 285, 286, 287, 69}, {70, 33}, {71, 67}, {72, 37}, {
           73, 63}, {74, 18}, {75, 23}, {76, 13}, {77, 44}, {78, 58}, {79, 
           49}, {80, 52}, {81, 49}, {82, 9}, {83, 44}, {84, 27}, {85, 23}, {
           86, 40}, {87, 20}, {88, 37}, {89, 26}, {90, 33}, {91, 29}, {92, 
           26}, {93, 24}, {94, 22}, {95, 20}, {96, 18}, {97, 13}, {98, 11}, {
           99, 9}, {100, 7}, {101, 6}, {102, 2}, {103, 1}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "36"],
          Annotation[#, 36, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "49"],
          Annotation[#, 49, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "64"],
          Annotation[#, 64, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "81"],
          Annotation[#, 81, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "100"],
          Annotation[#, 100, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "42"],
          Annotation[#, 42, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "67"],
          Annotation[#, 67, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "94"],
          Annotation[#, 94, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "52"],
          Annotation[#, 52, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "85"],
          Annotation[#, 85, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[33],
           "55"],
          Annotation[#, 55, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[34],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[35],
           "33"],
          Annotation[#, 33, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[36],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[37],
           "76"],
          Annotation[#, 76, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[38],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[39],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[40],
           "66"],
          Annotation[#, 66, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[41],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[42],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[43],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[44],
           "70"],
          Annotation[#, 70, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[45],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[46],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[47],
           "84"],
          Annotation[#, 84, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[48],
           "31"],
          Annotation[#, 31, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[49],
           "43"],
          Annotation[#, 43, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[50],
           "32"],
          Annotation[#, 32, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[51],
           "69"],
          Annotation[#, 69, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[52],
           "34"],
          Annotation[#, 34, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[53],
           "35"],
          Annotation[#, 35, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[54],
           "72"],
          Annotation[#, 72, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[55],
           "37"],
          Annotation[#, 37, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[56],
           "38"],
          Annotation[#, 38, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[57],
           "39"],
          Annotation[#, 39, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[58],
           "93"],
          Annotation[#, 93, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[59],
           "40"],
          Annotation[#, 40, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[60],
           "41"],
          Annotation[#, 41, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[61],
           "44"],
          Annotation[#, 44, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[62],
           "45"],
          Annotation[#, 45, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[63],
           "87"],
          Annotation[#, 87, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[64],
           "46"],
          Annotation[#, 46, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[65],
           "47"],
          Annotation[#, 47, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[66],
           "48"],
          Annotation[#, 48, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[67],
           "60"],
          Annotation[#, 60, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[68],
           "50"],
          Annotation[#, 50, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[69],
           "51"],
          Annotation[#, 51, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[70],
           "53"],
          Annotation[#, 53, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[71],
           "54"],
          Annotation[#, 54, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[72],
           "56"],
          Annotation[#, 56, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[73],
           "57"],
          Annotation[#, 57, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[74],
           "58"],
          Annotation[#, 58, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[75],
           "59"],
          Annotation[#, 59, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[76],
           "61"],
          Annotation[#, 61, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[77],
           "62"],
          Annotation[#, 62, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[78],
           "63"],
          Annotation[#, 63, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[79],
           "65"],
          Annotation[#, 65, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[80],
           "68"],
          Annotation[#, 68, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[81],
           "71"],
          Annotation[#, 71, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[82],
           "73"],
          Annotation[#, 73, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[83],
           "74"],
          Annotation[#, 74, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[84],
           "75"],
          Annotation[#, 75, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[85],
           "77"],
          Annotation[#, 77, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[86],
           "78"],
          Annotation[#, 78, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[87],
           "79"],
          Annotation[#, 79, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[88],
           "80"],
          Annotation[#, 80, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[89],
           "82"],
          Annotation[#, 82, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[90],
           "83"],
          Annotation[#, 83, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[91],
           "86"],
          Annotation[#, 86, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[92],
           "88"],
          Annotation[#, 88, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[93],
           "89"],
          Annotation[#, 89, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[94],
           "90"],
          Annotation[#, 90, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[95],
           "91"],
          Annotation[#, 91, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[96],
           "92"],
          Annotation[#, 92, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[97],
           "95"],
          Annotation[#, 95, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[98],
           "96"],
          Annotation[#, 96, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[99],
           "97"],
          Annotation[#, 97, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[100],
           "98"],
          Annotation[#, 98, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[101],
           "99"],
          Annotation[#, 99, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[102],
           "101"],
          Annotation[#, 101, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[103],
           "102"],
          Annotation[#, 102, "Tooltip"]& ]}}],
      Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9VHk0lWkY514UIffORXW57k7LsZSl0h2PNDmVJSWpiBxL2pRKG6UNEy1k
PYo0qHSnRAnJ92hiyEUZXSZFRZQUpbJFU+/EH995z/fH+7y/9eH5BK3woyko
KAR8/36caR97a0rZXOgJ+jbo7TkDdVOXxerU8+BOyfzB1WUGKKUVaMZ9/xfm
hNS02H+mwt1KumRFXLh5R0f9zXplzPLeXOpcrQjhDU4Xn3Z3UN/WHHhfOFMB
9sKelM1nhqmFF9Xpp+bzIaXKo2vJsApefR9Q0pDHga7ElPiKZWwsOC6r6hjl
wKj08FJ5lgEyi/yXLBYwoXdK/miFvwj9LfhzdCIYcMFFUczwEqBSS4ZrahMf
itOy2UxdMY5sUqWMawXwj2jjoWyeENNaeba5qjy43HXf4qqEgV3u1W2WrgL4
Eu+59d2GSQj2FgVeGjQwnTmz4YK9CjY+MvG23cEdx5+/7pTtgglcKDS5W6ns
8ZU6rZz41i5FDPcK60LeWwhQXqB6oG6DCFxyF76I9ufhXt3I0LDGHht16qbU
q5uDTYeqWxIr+22yu6vOSu14GJgTyLl2kwu2Iwor6XU8bM74X48cWyD3NXmR
rPg0HsRHdzQaUSxc+tes4NKJAtjC2+F2JZyBTfMYoS/C1GHoufnt66cZeONc
ptnyDA0Qfk4ZCDyohpsm1RB+8yt9ArLjaci9ddbI6o4i+FooDP3wEzYZumwL
6bMZ8zfVNVRyl6kClst21h124+J27vXOrSgAV6QRfCWVMR8i5XwI/9RJ8CTU
Ko3stJwIJz+2Ft7ynIAXUgfvJ78XgV6madzpWQxc2CWdo7VABLui3mVPMlfD
+OnBEtZbMTjWN89OUeLjgjX7HI9Zs6BNVEr06ZDKjidxtSCYY61zrZ6DeeFr
BLHTRPB6UdnLeisabuob/PrjPY+jcan9WtqY+MJbkDyHDUluS019opUwsFGe
qRvMgV/TW8l7YqlF04M+PWiQP9j7UE0fWT4bKpOqaSC3Yei0J/LH8bsuF6rc
ruVhTIVD7GQWG1b6yQk+Ld0HJH+psZLzs4b46OGhLkxYxYWsMm3H/K1aeF47
vmTGWjUoX81peR6qiB2t2skxJ34Z70tZzyWZySMeRLgPVPnG6GFW0mO7KC9N
yO4YkJn9/t1fB5pF7m02BOU8IPk5Ektr/1rPhzbjv6/YWSviz9zZeEzo9f+U
roZGbw8Y7ikbsjm/zX4uJ10DB3q9CH/nz96ZZptV8fXsxOReVSE80ZFV2ZaL
0Gk6J9CsggMOz6zLJW691BZG0cYmd22AQOWAH/PWma78zWkRE6ZmHeuJNlPG
fcZh+XEnxN/79nx3KFcTq/07zZUe82Fb6H7DJW0GaMBcXVvgMGBTlHqd9G9e
VVeYSg8d3CKP7+RRQnRspZkk5AmhW73+qax2lFr6We5sFSwa1+Ojem7AaLEQ
PhzziZV84aDfTz+9Em75lR8S49mkjZ+cm8Uw1zuE8BnLh9JQQp9Z/zCVx5Uc
UdHQh3Zaifeb+f3UOSv39AxlHtykFoeuXS7E9n/bLt1gi2B6g/lec0MRdqua
ZzEfs6HwtozwGcOvdSaiZqiFiXRrM5KPj7OnRFy3F2INNdN0qvZk2J8zSvAW
CX3IPnI6ZEbmtesoE78mfvJNWmFsgAdL5xI8vkwjkvex/RR24iSZHxSRRfyX
KR/zfBUhROkfedbJGZoQOld831g2Df30d5I+KLy7evpgJRdNogIJ//AyL5Ln
N5WdWU/oQkBnlts1fRYeHUhnD4uE8NQNBi1l+vi6WeNlhIEQWAO83Wsthyi4
F+VCZ4rAk661r/gVEzuqgCMJ4oO8c8HiUqnBeJ4iV12+sTidj74Pk8n+ytEK
InzWV1sSveKmUXeNpd8oD5eRFMthEfif0CP6jOWHfu1Pct+j2JH0RSU8m+Dv
L543Er2ND33fYi6fq1PAXT/3n3T9duLfs5C1xK/8nB0x+wf1UPLqRWqYld64
3v8BBKgHWg==
        "]]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJw9V3k8lN/3t28NRZoZQ5oZM89jaVORqOZ8vqFUhKiEdhLZQtmS+kikBZW0
KUuytqgoxXMlVMoSWaOyJNnJlqXf9MzH7695ndd9zrnv9/uc+75zWfvcLR1E
hISEFggLCf39VZ297JiMsDwM3FHbxziPoSjd7NimZgyo4spWoSZc5KTuV9Tq
zAVfrXPS6YPfiNWBJ+JVLTkg1BpYvsF9mpAa+lchR3GEJxTU1nPmRQ7vZXvi
kfBPg7yHKq3R4at7iOmS8udfPnLB4YSYsXi1EKqIjnPQduTAoiPv4vPk1JB1
s/lh/XMcWHk8P7DIgIvuKIol1xSqwt04caXlxiz0K5K4mIypQvr9e8G/A1VR
kB/Fbl87DkeMOF7dJ7TQMQnv4uEGdYh4314TfFYD7RRvHxVO4MD8CO0SeSsK
Sg66cD2sG4NXG8XfpuiLo7WIJlIbO8KDJPM6xq0/xKXRQeolaT4fI+7ALtF0
nvtJi7Hzt9XA/AYlOFC2n5COFxqSSdYC/92mZW/i1JG5pfepGDdNkN6O9BzL
MXR87WJK8I05cPSdzbeV6VQUYmCumB2tAE/b9Oy0jRmo1aia61PAhfHEoLSm
lTiyXnNMxno9Dvt+5JH574w3lrbrcsHfMfd0aLo8kujsU58Tj0HSWLiUXAMF
5XzsMO55KQ7tPxwlNidTUKROwKTtVwlQVLkauU1cDGHakSQ/yqRiaGHDGPEj
0+B0WuIob/nHknTeUgaKy+lVTLvQzDNZX0zGn0/bTvSm0qAmPqKq0YWOfr5Q
6lvxQR0oB4NJfL69W1Lq3TBwLH9B4vE+2FhywkcYjis1mSe0CSG7gpcBP0M1
QGxaKrhBm4KmZ3v83FutDrD2ikgJRQzJFX02bBzVAnE/m7Nerjhy2DnLWsaN
Caba+0l9vKWcW/ACFfis8XVjaBQVuSWrNLRkqYPTcGWgCmuMMDlXQe5XTY3q
cK2WR2divN7MX8aCYnobzeDNJOEZtTjcvpINMtZnyP3Oe572yghVA7ZC66X/
9aqhWEoZ2ElQgRpRsudOtwqqe7XA9t0LOihk9ICxnTJC03MqymLYMItiReIT
ubeFnL+tei9+SexXR/RT5Q3fe9SAuqpqmPVEBgXedz6je00UnKd0u69LjhDl
tn/718fL5S3yyF3CRgYRCtUjTRhMfPR7SXmghvbgYUFWFcqQXRdTZlDJQCcL
uli3f7ABt9hAzs/anKLrZi4Y7HrbJDONjxBzmLZvK2wRsXlxz/RXTAy9X2Xp
P//ET975K4YVMpgk0lMV8FdOlxLqWSeK9pUJ3cmhakB0nglLZbEW2q9v6eI8
wYZItUWDlaoVxGd7jtmuMXlYGiny52+9K+OB1iklsqAQKzp7wGOK0LEC5za2
JrzbF1a5clwSGYlYri79hkNfm35X0E4uojKXz8l/rABuLBHy/Gmi6BtzY6kw
S7bu/Pk4JpIWL27/vlEdQnxZl9cFDxIK3wXne2a+Dqcw3ItKNGBp52LmeCsH
gTWD1F9RWSpYezcbbcnTSo/30gQxqirJJ+Nu2zKZxjnw5iJzPVWml5iX/W20
WpUNY5+pS1FdO0GtepXspIDBYcfXVSuea6BdPmYPfNU14Zt/VrlcpCbK0rSX
bjzFghBXb5JP7hmpNzevtPPmrJdZ3mI4G03q/UvOR1r9labwhxqIGar4aNe8
q4SR/0Kyf7WZN0g/ksAekPW6sR6yXy+ZSxNFhbhoIuQLiedKw+iJv/MuOivJ
Pva0LPw0oJP1O1lzyP6HZAg/Jfo00IHMo/52A8rwfV3pmESEAvryrIk8D88u
aXTs0MZQV+ZCkn9srxz97zzf7U2zW3gTh2TNH6IUGXk0dUlG7dUyDcA+zq8e
NuOgJOHK2LocHHaUtOxIKO8iJjs2SVmnqUPoyxLTpUmz0R6HdK5YIA6JjJv+
q3hctPpw2bftk3Lglz181WFKBTW7iJL+JbtEh+TjErGL1EszVM7nrv0QUdN9
MH5KUgtUta+T+hzXTd/3ZJIJngeFYv/mp/jKk+clH+OQ+B9/nXzcJIFBkMsh
qYfmwwTqOn07y6yQR7f5ZPy3f9sVish+KQRm37raroZWqx7oVRSRgcBGNnm/
SEw+S2Dw75uJ7Xk5tAgMDaNBpRMUeQie4OCbDmJo6/mKAye15MGwfmws1BhD
oW9DipJs5aHYeK7wYS0McTY5v6Jck4fwNPFPGB1DVnf83d83y8NUFAtfJ4eh
jAC96E24Anj5aEuf48fLH+v/+/ywAmy+EJcwwf9eu9MuJiRVAbpGA1JeLMTQ
Lc10n/d1CtCmWnNedwOGSn7V/694RAEMxC1n6R3CkOB+nAvpohwS/+E8wTo+
Pfxs8iGGtqM0Mr+3zlN3uhJDYVaC+uk9pcp+PRhSEBLsX8tLZa0SxpHns5Uk
vp9rqC9SZuEo9bMfid9FHLs1wI9zYw6R/MYq/+mTFcFR7TIBf1nVFYVvejHk
zRToM+1rVppZhaH4UIF+Hzayb3VmYah7TKBvT2c4Zf5F/v1kYSi/pBeDCin5
Prd5XORR4WWj+xuDA/N+muSPc5BFmOFUCgUHm6MfAuq+cdDG8Vv9jhz+vE1q
pS4r56B34zuPT/FwmPt801TfKw5qLkv8kmePQ55OV0d5HgdNFY1G1Abg4G/I
9mAjDtpcnRLiHYtD+NxKy8K3HJTI3CNW8wiHRs9qPZUGDiq/pZDvXsyvf/Ro
y6J+DnIZ6ZQS+oTDU93eZ7dluGjoWXZQ4mcc/EzrPlbjXHT5SExDCz9ecCNQ
TdyYi+5vXMPL5X9f6JO0yWY/FxVTTL2ulfD3s35gIxnERTq+s+bYP8ZB1msy
x+0yF12V7aL8cx2Hs7HhV7TvcpFf5aTfh+M4HPghs3rjAy76sG9FTP5uHLCL
1hLKWVxUtPhrduc/OLzd82XqWCYX9XceusfEcIhnaoenxnORQfl2mCeHw0MN
V2Gni1x01ll9YO0EBoVfm7wqjnGRdMkqlhkLh5W6Jo9CvccIO92HOZv5+m2s
aRRi2IwRIXFmunp8/cL8mdqWfmNE5XxPjzV+OCyqCVikVzVG7I2Y35IchcNY
S4aR+d5xYvKI9+7RJByq7uqX9jF+E3vT7a2Es3AoN7I88PrXb8J+npvGON8f
3FvmV4V8myCapivun8zGQTFt6yH0cZL4pWRR+igTB5/ysmD0fIowbS6gzo3D
QV7/np5b2DQxWhzrcy0Mh0uO170WL/tDdHUTepfdcDCxRBnJGX8IvZCO1GsW
OFy5vyx+V/8fop6Suc5tOQ6epS6DK8b/ELtUQumd8/j9j1mZdLv4DxHJ3Umr
5c+XYcaqM09s/xAtD1x6m1sx2Lr/NmU8f5qwuxC+7uBHfnxiodfk+BRREKtQ
HVyCwXOzsH9f0acIEXHbj58KMfjJcB+R1Jgk2vq1Q27z1z+NiIy4rJog4g/f
ep3Azy+5fqA8YsdvgtV5wu7e+WaeTn20kNEKBtK53vpjd20TTyu6kNUcwEBb
qiUMDDoaeQk1ykGOeQykLF+4RLy9jnd74rvrzSEG0ht13nta7hOPvkKkGGMo
I/0kh8izWRU8bYd3rN5FyiigafbbpdZveEZxafZ2/Fi5Psqi3YzgRR+u0DxO
V0ZxNmLhTJWHvG3X5i2Y6megst/lnxLUo3j7N+21ksxloCT7X4+sEsKJp0GH
bMR8GYj+3/1TfbKIvC8P3DtNrjefY037/1BCe0C/5m++ea2GqG+yElIM0SDr
f8r00TvlroR84vPJ/QOlXywU2aCEKg3VSXzbZL+Ns5croe5mTxK/dVCBTtQy
JVS15ijJz6A9PGqHsRKaF/ie5C9verez5bASMkyQJfVZctWjnp6ohFx5HaR+
UUNvdOLblBBiBJP6mj8d36a/kIHs8A3L2Mk0+P7u9/2FrnTE/b1n+NcuGv98
J0oN+9PRFqOX64uoNKhInWVt4E1Hoq8XetpXUeEcvTIz3IaORnpnXeRep0Lc
01EdsUV0tPRcyoUn7lRIHXdirxmkIWJiaZ/ndiowdM44dGXS0Gkpk4YtW6lw
SCP2S7gDDbnmPl2cuJ8KtOqh2u+qNPR8V/wjlTNU2NJ2rSjjCxWZrf9nsDWX
CuOSS0Z7MqjoW3JOTuVvKhDWju4vz1LRkUxHk6J/aCDbuMa8JoCK3h85mSt7
lgarWy3CXU9SUZRodnHzBxrs5OaZzr5BRQP2G76WSNKB+8TFJLOYiiZ8e1rU
ltOhkVlaVyJEQ1ZbXvv4bqaDZcjAl6eGNHQqsMonz4IODCfZILHzNFSScfl+
6P/okGg52fe9ioZCbBrOUJh0WPkuKiVzLh2ZMGtHFHpoYC4jK2+wno6O+FQ/
eZhJg+bdOy4fdqajxI++io+jRAFrO9TXJDxC7C/ziuxVEIVYJ4MWms8woVfl
6jaRIQKbAk2hJfkXYYjGmZJOIuA6PWJfcm+I+PQ6MPqaiQh8kzWIWXNukPi3
+Ea0mpUIqF0tnS/qMkAcmLPx2ftQETgVtEx4k20/0fX+cl5IkwikqLucKWjv
JWK/P+/fZiEK296NpVaG9RCe69Skx+tEQXFRfGjhi26C2rijK/yQGKSFieZL
X+wm8ouy5TxHxaCn1yRHX6KHKNZJvLb5mDgcrYgaLqb1EqeiWhiNzeLgHP3T
KS+zj3i//jmzjCsBJzOapoqr+glNqei33sYSsN3UXWVr7wCh519we+laCRh3
0lpRP3uIgBeVe9JlJaBXJgtnsn4RWa4ye94+E4cdut0+qynDRLTdmxs2xuJg
9Nzc2jJ/mNBRSe0NJ8RgT/GqQbrGCPE7YfclzSVi4B97Ff1ZN0J4OEUpVdwR
BXg8ZNNMGSHkCu871vD/378eKS7KWcRGIT8Dmb8T+ngm1xfrdEmz0cvkpwah
pv08WV8RSbyThcKvhubPlRvgXWxXmU0pYyHhOJWsx6KDPEuT2a3FuSxUMGjv
mMUY4hUv1dJpfchCzD3WA/dX/+KtVjSgLXzEQmvX7nrqaDnMm7co5eGNFyyk
S+0QvmQ0wnsSczrbtpyF2pSZJ7JERnmZeV9u1PxkoQjDxsfX/Ed5Ykm2SnWz
2GjmveedIHiPqB5sINf7b/4pvrmVjcqOqJL5OccCDOO82ehCYRtZ3/vcJw2l
SDZ65mlL7n+nOWtJfSIb6W61JPE9/rzg7Yb7bDSvbSeJf0XSkvQofrzzvRLJ
r8Bj01RmEhu9Wx1C8q95uabSKYqNeEOPSX1KaDvqTY+yUSctgNQvplMrPdya
v54m0Dc77BIjT5uNHDwoSbX894PBf/798oa7E/cDF2JiBP695JXQuqQ8Loh2
CPz77P3k6Oi7XIhU7SD9W2N4+eXmUC48cxP4976y9Lzp/VzIyRX49/WvmxcS
PC4UzE4n/bsClS6Xms+F6jGBfy+P009LmOaA9Boq6d9tRy7lTn/ngKXwPtK/
FYUnq4TrOKADzqR/C947nP9/78ys25uxSf+eyYfzmqR/z9QPtzhK+vfM/vlX
BP49g+9jkMC/Z/A3Vgn8e4Zfw4KzpH/P8BfxEPj3jD4X7wn8e0a/yVGBf8/o
u+0///4/GS98yQ==
       "], {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
           115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 1}, {2,
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
           140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 2}, {3, 4}, {4, 
           7}, {5, 6}, {6, 16}, {7, 29}, {8, 9}, {9, 23}, {10, 11}, {11, 
           54}, {12, 13}, {13, 33}, {14, 15}, {15, 7}, {16, 35}, {17, 18}, {
           18, 4}, {19, 20}, {20, 33}, {21, 22}, {22, 46}, {23, 24}, {24, 
           2}, {25, 26}, {26, 15}, {27, 28}, {28, 35}, {29, 150, 151, 152, 
           153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
           166, 167, 168, 169, 170, 171, 172, 29}, {30, 31}, {31, 173, 174, 
           175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
           188, 189, 190, 191, 192, 193, 194, 195, 31}, {32, 196, 197, 198, 
           199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
           212, 213, 214, 215, 216, 217, 218, 32}, {33, 24}, {34, 26}, {35, 
           51}, {36, 37}, {37, 15}, {38, 20}, {39, 40}, {40, 54}, {41, 15}, {
           42, 27}, {43, 44}, {44, 4}, {45, 9}, {46, 47}, {47, 32}, {48, 
           49}, {49, 23}, {50, 4}, {51, 219, 220, 221, 222, 223, 224, 225, 
           226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 
           239, 240, 241, 51}, {52, 242, 243, 244, 245, 246, 247, 248, 249, 
           250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 
           263, 264, 52}, {53, 2}, {54, 47}, {55, 49}, {56, 7}, {57, 58}, {58,
            16}, {59, 44}, {60, 13}, {61, 18}, {62, 63}, {63, 28}, {64, 37}, {
           65, 24}, {66, 67}, {67, 46}, {68, 29}, {69, 265, 266, 267, 268, 
           269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
           282, 283, 284, 285, 286, 287, 69}, {70, 33}, {71, 67}, {72, 37}, {
           73, 63}, {74, 18}, {75, 23}, {76, 13}, {77, 44}, {78, 58}, {79, 
           49}, {80, 52}, {81, 49}, {82, 9}, {83, 44}, {84, 27}, {85, 23}, {
           86, 40}, {87, 20}, {88, 37}, {89, 26}, {90, 33}, {91, 29}, {92, 
           26}, {93, 24}, {94, 22}, {95, 20}, {96, 18}, {97, 13}, {98, 11}, {
           99, 9}, {100, 7}, {101, 6}, {102, 2}, {103, 1}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "36"],
          Annotation[#, 36, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "49"],
          Annotation[#, 49, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "64"],
          Annotation[#, 64, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "81"],
          Annotation[#, 81, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "100"],
          Annotation[#, 100, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "42"],
          Annotation[#, 42, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "67"],
          Annotation[#, 67, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "94"],
          Annotation[#, 94, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "52"],
          Annotation[#, 52, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "85"],
          Annotation[#, 85, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[33],
           "55"],
          Annotation[#, 55, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[34],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[35],
           "33"],
          Annotation[#, 33, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[36],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[37],
           "76"],
          Annotation[#, 76, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[38],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[39],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[40],
           "66"],
          Annotation[#, 66, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[41],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[42],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[43],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[44],
           "70"],
          Annotation[#, 70, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[45],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[46],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[47],
           "84"],
          Annotation[#, 84, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[48],
           "31"],
          Annotation[#, 31, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[49],
           "43"],
          Annotation[#, 43, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[50],
           "32"],
          Annotation[#, 32, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[51],
           "69"],
          Annotation[#, 69, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[52],
           "34"],
          Annotation[#, 34, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[53],
           "35"],
          Annotation[#, 35, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[54],
           "72"],
          Annotation[#, 72, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[55],
           "37"],
          Annotation[#, 37, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[56],
           "38"],
          Annotation[#, 38, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[57],
           "39"],
          Annotation[#, 39, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[58],
           "93"],
          Annotation[#, 93, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[59],
           "40"],
          Annotation[#, 40, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[60],
           "41"],
          Annotation[#, 41, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[61],
           "44"],
          Annotation[#, 44, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[62],
           "45"],
          Annotation[#, 45, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[63],
           "87"],
          Annotation[#, 87, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[64],
           "46"],
          Annotation[#, 46, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[65],
           "47"],
          Annotation[#, 47, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[66],
           "48"],
          Annotation[#, 48, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[67],
           "60"],
          Annotation[#, 60, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[68],
           "50"],
          Annotation[#, 50, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[69],
           "51"],
          Annotation[#, 51, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[70],
           "53"],
          Annotation[#, 53, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[71],
           "54"],
          Annotation[#, 54, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[72],
           "56"],
          Annotation[#, 56, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[73],
           "57"],
          Annotation[#, 57, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[74],
           "58"],
          Annotation[#, 58, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[75],
           "59"],
          Annotation[#, 59, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[76],
           "61"],
          Annotation[#, 61, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[77],
           "62"],
          Annotation[#, 62, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[78],
           "63"],
          Annotation[#, 63, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[79],
           "65"],
          Annotation[#, 65, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[80],
           "68"],
          Annotation[#, 68, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[81],
           "71"],
          Annotation[#, 71, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[82],
           "73"],
          Annotation[#, 73, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[83],
           "74"],
          Annotation[#, 74, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[84],
           "75"],
          Annotation[#, 75, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[85],
           "77"],
          Annotation[#, 77, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[86],
           "78"],
          Annotation[#, 78, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[87],
           "79"],
          Annotation[#, 79, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[88],
           "80"],
          Annotation[#, 80, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[89],
           "82"],
          Annotation[#, 82, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[90],
           "83"],
          Annotation[#, 83, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[91],
           "86"],
          Annotation[#, 86, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[92],
           "88"],
          Annotation[#, 88, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[93],
           "89"],
          Annotation[#, 89, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[94],
           "90"],
          Annotation[#, 90, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[95],
           "91"],
          Annotation[#, 91, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[96],
           "92"],
          Annotation[#, 92, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[97],
           "95"],
          Annotation[#, 95, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[98],
           "96"],
          Annotation[#, 96, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[99],
           "97"],
          Annotation[#, 97, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[100],
           "98"],
          Annotation[#, 98, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[101],
           "99"],
          Annotation[#, 99, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[102],
           "101"],
          Annotation[#, 101, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[103],
           "102"],
          Annotation[#, 102, "Tooltip"]& ]}}],
      Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1VXlY1OUWHpYZh3HYpmlEwGnW3ywoMZqIwnXOk4JLikSQC0uGAV5QXMAE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        "]]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{410, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[1]=",
 CellID->367587356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739766316],

Cell["\<\
For very large graphs, it is often better not to draw vertices at all:\
\>", "ExampleText",
 CellID->1632065829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "500"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "500"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693558391],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{154, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9280787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8888429],

Cell["Multiclick to move vertices in a graph: ", "ExampleText",
 CellID->455833000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", "6", "}"}], ",", 
    RowBox[{"{", "6", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119821187],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.963046450095603, 1.1238588340433}, {
    0.316727678335415, 1.11823656731674}, {0., 0.555550744463462}, {
    0.971989537551765, 0.0059389375733031}, {0.326408369629416, 0.}, {
    1.29031504745204, 0.567565852410607}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{1, 6}], LineBox[{2, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{2, 6}], LineBox[{3, 4}], 
      LineBox[{3, 5}], LineBox[{3, 6}], LineBox[{4, 5}], LineBox[{4, 6}], 
      LineBox[{5, 6}]}, 
     {RGBColor[0., 0., 0.7], PointBox[1], PointBox[2], PointBox[3], 
      PointBox[4], PointBox[5], PointBox[6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.963046450095603, 1.1238588340433}, {
     0.316727678335415, 1.11823656731674}, {0., 0.555550744463462}, {
     0.971989537551765, 0.0059389375733031}, {0.326408369629416, 0.}, {
     1.29031504745204, 0.567565852410607}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446419444]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.963046450095603, 
    1.1238588340433}, {-0.266255332074517, 1.08343161147137}, {0., 
    0.555550744463462}, {0.971989537551765, 0.0059389375733031}, {
    0.326408369629416, 0.}, {1.29031504745204, 0.567565852410607}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{1, 6}], LineBox[{2, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{2, 6}], LineBox[{3, 4}], 
      LineBox[{3, 5}], LineBox[{3, 6}], LineBox[{4, 5}], LineBox[{4, 6}], 
      LineBox[{5, 6}]}, 
     {RGBColor[0., 0., 0.7], PointBox[1], PointBox[2], PointBox[3], 
      PointBox[4], PointBox[5], PointBox[6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.963046450095603, 1.1238588340433}, {
     0.316727678335415, 1.11823656731674}, {0., 0.555550744463462}, {
     0.971989537551765, 0.0059389375733031}, {0.326408369629416, 0.}, {
     1.29031504745204, 0.567565852410607}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[2]:=",
 CellID->79938080]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29965],

Cell["Use different methods to get different layouts:", "ExampleText",
 CellID->381125490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", "20", "}"}], ",", 
    RowBox[{"{", "20", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448969433],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0548568240538163`, 1.5536326163118646`}, {
    0.5831638581550639, 1.167237961146115}, {0.36863689129236143`, 
    0.7763280870273562}, {0.3788103339661774, 0.09766347910746342}, {
    0.5989508493741111, 0.3940500051877318}, {1.2584263803193418`, 
    0.7940857910069359}, {1.4326487758374844`, 0.28991449171654754`}, {
    0.6851626222212586, 1.5634875248454292`}, {1.3899638633614106`, 
    1.335866817742779}, {1.598838573394859, 0.6197736167411466}, {
    1.0304029379625805`, 1.1784565737756354`}, {0.10196215668344666`, 
    1.1169028418776659`}, {0.31582638860960655`, 1.4261775087354298`}, {
    0.7551306315888459, 0.}, {1.5756139131071718`, 1.017104075625705}, {
    1.127136413526816, 0.03866577120704484}, {0.13730364298935482`, 
    0.38854933614148707`}, {1.0460137879765183`, 0.40284765498244396`}, {0., 
    0.7444675835724477}, {0.813909863354777, 0.7867123507206955}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 
       7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 
       15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {3, 4}, {3, 5}, {3, 
       6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {3, 12}, {3, 13}, {3, 
       14}, {3, 15}, {3, 16}, {3, 17}, {3, 18}, {3, 19}, {3, 20}, {4, 5}, {4, 
       6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 
       14}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {5, 6}, {5, 
       7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {6, 7}, {6, 8}, {6, 
       9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 15}, {6, 16}, {6, 
       17}, {6, 18}, {6, 19}, {6, 20}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 
       12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7,
        20}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8,
        16}, {8, 17}, {8, 18}, {8, 19}, {8, 20}, {9, 10}, {9, 11}, {9, 12}, {
       9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {9, 19}, {9, 
       20}, {10, 11}, {10, 12}, {10, 13}, {10, 14}, {10, 15}, {10, 16}, {10, 
       17}, {10, 18}, {10, 19}, {10, 20}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {12, 13}, {12, 
       14}, {12, 15}, {12, 16}, {12, 17}, {12, 18}, {12, 19}, {12, 20}, {13, 
       14}, {13, 15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {14, 
       15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 20}, {15, 16}, {15, 
       17}, {15, 18}, {15, 19}, {15, 20}, {16, 17}, {16, 18}, {16, 19}, {16, 
       20}, {17, 18}, {17, 19}, {17, 20}, {18, 19}, {18, 20}, {19, 20}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0548568240538163`, 1.5536326163118646`}, {
     0.5831638581550639, 1.167237961146115}, {0.36863689129236143`, 
     0.7763280870273562}, {0.3788103339661774, 0.09766347910746342}, {
     0.5989508493741111, 0.3940500051877318}, {1.2584263803193418`, 
     0.7940857910069359}, {1.4326487758374844`, 0.28991449171654754`}, {
     0.6851626222212586, 1.5634875248454292`}, {1.3899638633614106`, 
     1.335866817742779}, {1.598838573394859, 0.6197736167411466}, {
     1.0304029379625805`, 1.1784565737756354`}, {0.10196215668344666`, 
     1.1169028418776659`}, {0.31582638860960655`, 1.4261775087354298`}, {
     0.7551306315888459, 0.}, {1.5756139131071718`, 1.017104075625705}, {
     1.127136413526816, 0.03866577120704484}, {0.13730364298935482`, 
     0.38854933614148707`}, {1.0460137879765183`, 0.40284765498244396`}, {0., 
     0.7444675835724477}, {0.813909863354777, 0.7867123507206955}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1265823214]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "20", "}"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<CircularEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->728849980],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.378404875209022, 0.689202437604511}, {
    1.3446729069366978`, 0.9021777033830586}, {1.2467789221984749`, 
    1.0943054662624527`}, {1.094305466287486, 1.2467789221802872`}, {
    0.902177703412487, 1.3446729069271357`}, {0.6892024376354539, 
    1.378404875209022}, {0.476227171855392, 1.3446729069462595`}, {
    0.2840994089716026, 1.2467789222166625`}, {0.1316259530469227, 
    1.0943054663125193`}, {0.0337319682914482, 0.9021777034419156}, {0., 
    0.6892024376663968}, {0.033731968253200684`, 0.47622717188482033`}, {
    0.13162595297417157`, 0.2840994089966361}, {0.2840994088714692, 
    0.1316259530651106}, {0.4762271717376784, 0.033731968301009996`}, {
    0.6892024375116825, 0.}, {0.9021777032947733, 0.03373196824363878}, {
    1.0943054661873528`, 0.13162595295598378`}, {1.2467789221257237`, 
    0.2840994088464359}, {1.3446729068984502`, 0.47622717170825}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 
       7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 
       15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {3, 4}, {3, 5}, {3, 
       6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {3, 11}, {3, 12}, {3, 13}, {3, 
       14}, {3, 15}, {3, 16}, {3, 17}, {3, 18}, {3, 19}, {3, 20}, {4, 5}, {4, 
       6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 
       14}, {4, 15}, {4, 16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {5, 6}, {5, 
       7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {6, 7}, {6, 8}, {6, 
       9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 15}, {6, 16}, {6, 
       17}, {6, 18}, {6, 19}, {6, 20}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 
       12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7,
        20}, {8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8,
        16}, {8, 17}, {8, 18}, {8, 19}, {8, 20}, {9, 10}, {9, 11}, {9, 12}, {
       9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {9, 19}, {9, 
       20}, {10, 11}, {10, 12}, {10, 13}, {10, 14}, {10, 15}, {10, 16}, {10, 
       17}, {10, 18}, {10, 19}, {10, 20}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {12, 13}, {12, 
       14}, {12, 15}, {12, 16}, {12, 17}, {12, 18}, {12, 19}, {12, 20}, {13, 
       14}, {13, 15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {14, 
       15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 20}, {15, 16}, {15, 
       17}, {15, 18}, {15, 19}, {15, 20}, {16, 17}, {16, 18}, {16, 19}, {16, 
       20}, {17, 18}, {17, 19}, {17, 20}, {18, 19}, {18, 20}, {19, 20}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.378404875209022, 0.689202437604511}, {
     1.3446729069366978`, 0.9021777033830586}, {1.2467789221984749`, 
     1.0943054662624527`}, {1.094305466287486, 1.2467789221802872`}, {
     0.902177703412487, 1.3446729069271357`}, {0.6892024376354539, 
     1.378404875209022}, {0.476227171855392, 1.3446729069462595`}, {
     0.2840994089716026, 1.2467789222166625`}, {0.1316259530469227, 
     1.0943054663125193`}, {0.0337319682914482, 0.9021777034419156}, {0., 
     0.6892024376663968}, {0.033731968253200684`, 0.47622717188482033`}, {
     0.13162595297417157`, 0.2840994089966361}, {0.2840994088714692, 
     0.1316259530651106}, {0.4762271717376784, 0.033731968301009996`}, {
     0.6892024375116825, 0.}, {0.9021777032947733, 0.03373196824363878}, {
     1.0943054661873528`, 0.13162595295598378`}, {1.2467789221257237`, 
     0.2840994088464359}, {1.3446729068984502`, 0.47622717170825}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302005716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4827],

Cell[TextData[{
 "Plot graphs generated by ",
 StyleBox["Combinatorica:",
  FontSlant->"Italic"]
}], "ExampleText",
 CellID->12382],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72863096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"ButterflyGraph", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323993010],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.37571551314021745`, 1.909351275566128}, {
    1.1055214402176687`, 2.4079276359179405`}, {1.9063907032447824`, 
    2.0316677152851357`}, {2.3860440089864445`, 0.1983721802843159}, {
    2.4053256552809357`, 1.3009007017668657`}, {2.2080746330536307`, 
    2.3865985716385714`}, {0.020215915419335317`, 2.210608973210844}, {0., 
    1.107242354041598}, {0.19787741325558517`, 0.02197869484506243}, {
    2.0308730933976604`, 0.4991241223455115}, {1.29997158139945, 0.}, {
    0.4985861945456874, 0.37631650604523315`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 8}, {2, 3}, {2, 6}, {2, 7}, {3, 5}, {4, 5}, {4, 
       11}, {5, 6}, {5, 10}, {7, 8}, {8, 9}, {8, 12}, {9, 11}, {10, 11}, {11, 
       12}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.37571551314021745`, 1.909351275566128}, {
     1.1055214402176687`, 2.4079276359179405`}, {1.9063907032447824`, 
     2.0316677152851357`}, {2.3860440089864445`, 0.1983721802843159}, {
     2.4053256552809357`, 1.3009007017668657`}, {2.2080746330536307`, 
     2.3865985716385714`}, {0.020215915419335317`, 2.210608973210844}, {0., 
     1.107242354041598}, {0.19787741325558517`, 0.02197869484506243}, {
     2.0308730933976604`, 0.4991241223455115}, {1.29997158139945, 0.}, {
     0.4985861945456874, 0.37631650604523315`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148974278]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " to preserve the embedding provided by ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->463852448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"ButterflyGraph", "[", "2", "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->299597884],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., -1.5}, {2., -1.5}, {3., -1.5}, {1., -0.5}, {
    2., -0.5}, {3., -0.5}, {1., 0.5}, {2., 0.5}, {3., 0.5}, {1., 1.5}, {2., 
    1.5}, {3., 1.5}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 8}, {2, 3}, {2, 6}, {2, 7}, {3, 5}, {4, 5}, {4, 
       11}, {5, 6}, {5, 10}, {7, 8}, {8, 9}, {8, 12}, {9, 11}, {10, 11}, {11, 
       12}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., -1.5}, {2., -1.5}, {3., -1.5}, {
     1., -0.5}, {2., -0.5}, {3., -0.5}, {1., 0.5}, {2., 0.5}, {3., 0.5}, {1., 
     1.5}, {2., 1.5}, {3., 1.5}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{148, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->453911894]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->719208908],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DirectedEdges",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203839123],

Cell["Show the direction of edges:", "ExampleText",
 CellID->2036916947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"3", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"4", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1851389954],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.36327126408405364`, 1.8090169944118928`}, {
    0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
    0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
    1.809016994253556}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03444668289820355, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{4, 2}], ArrowBox[{5, 2}], 
      ArrowBox[{6, 2}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.36327126408405364`, 1.8090169944118928`}, {
     0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
     0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
     1.809016994253556}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->826141558]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->238189510],

Cell["By default edge labels are shown:", "ExampleText",
 CellID->825767658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
    ",", 
    RowBox[{"4", "\[Rule]", "6"}], ",", 
    RowBox[{"5", "\[Rule]", "6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612297678],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9347907617516572, 0.}, {0., 
    0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
    0.9329317643597267, 0.8688665917385817}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"edge 3->6\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{1, 4}]}, LineBox[{2, 4}], 
      LineBox[{3, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9347907617516572, 0.}, {0., 
     0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
     0.9329317643597267, 0.8688665917385817}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722946009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1515268568],

Cell["Display the edge label as a tooltip:", "ExampleText",
 CellID->384406038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308099912],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9347907617516572, 0.}, {0., 
    0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
    0.9329317643597267, 0.8688665917385817}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      TagBox[
       TooltipBox[LineBox[{1, 4}],
        "\"edge 3->6\""],
       Annotation[#, "edge 3->6", "Tooltip"]& ], LineBox[{2, 4}], 
      LineBox[{3, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9347907617516572, 0.}, {0., 
     0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
     0.9329317643597267, 0.8688665917385817}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211250145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2141000564],

Cell["Display the edge label both explicitly and as a tooltip:", "ExampleText",
 CellID->2014701195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->682974758],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9347907617516572, 0.}, {0., 
    0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
    0.9329317643597267, 0.8688665917385817}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      TagBox[
       TooltipBox[
        {Arrowheads[{{0.5, 0.5, 
            GraphicsBox[{
              GrayLevel[0], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox["\"edge 3->6\"", StripOnInput -> False], 
                 TraditionalForm]], {0, 0}, 
               ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
               GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{1, 4}]},
        "\"edge 3->6\""],
       Annotation[#, "edge 3->6", "Tooltip"]& ], LineBox[{2, 4}], 
      LineBox[{3, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9347907617516572, 0.}, {0., 
     0.43401927156207404`}, {1.8681899829560922`, 0.4348838582490424}, {
     0.9329317643597267, 0.8688665917385817}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->804409825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65693485],

Cell["Draw vertices only:", "ExampleText",
 CellID->26472224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "20", "}"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020060192],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0548568240538163`, 1.5536326163118646`}, {
    0.5831638581550639, 1.167237961146115}, {0.36863689129236143`, 
    0.7763280870273562}, {0.3788103339661774, 0.09766347910746342}, {
    0.5989508493741111, 0.3940500051877318}, {1.2584263803193418`, 
    0.7940857910069359}, {1.4326487758374844`, 0.28991449171654754`}, {
    0.6851626222212586, 1.5634875248454292`}, {1.3899638633614106`, 
    1.335866817742779}, {1.598838573394859, 0.6197736167411466}, {
    1.0304029379625805`, 1.1784565737756354`}, {0.10196215668344666`, 
    1.1169028418776659`}, {0.31582638860960655`, 1.4261775087354298`}, {
    0.7551306315888459, 0.}, {1.5756139131071718`, 1.017104075625705}, {
    1.127136413526816, 0.03866577120704484}, {0.13730364298935482`, 
    0.38854933614148707`}, {1.0460137879765183`, 0.40284765498244396`}, {0., 
    0.7444675835724477}, {0.813909863354777, 0.7867123507206955}}, {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0548568240538163`, 1.5536326163118646`}, {
     0.5831638581550639, 1.167237961146115}, {0.36863689129236143`, 
     0.7763280870273562}, {0.3788103339661774, 0.09766347910746342}, {
     0.5989508493741111, 0.3940500051877318}, {1.2584263803193418`, 
     0.7940857910069359}, {1.4326487758374844`, 0.28991449171654754`}, {
     0.6851626222212586, 1.5634875248454292`}, {1.3899638633614106`, 
     1.335866817742779}, {1.598838573394859, 0.6197736167411466}, {
     1.0304029379625805`, 1.1784565737756354`}, {0.10196215668344666`, 
     1.1169028418776659`}, {0.31582638860960655`, 1.4261775087354298`}, {
     0.7551306315888459, 0.}, {1.5756139131071718`, 1.017104075625705}, {
     1.127136413526816, 0.03866577120704484}, {0.13730364298935482`, 
     0.38854933614148707`}, {1.0460137879765183`, 0.40284765498244396`}, {0., 
     0.7444675835724477}, {0.813909863354777, 0.7867123507206955}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683492993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141508825],

Cell["\<\
Draw edges using gray arrows and self-loops using red arrows:\
\>", "ExampleText",
 CellID->2122510440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"First", "[", "#2", "]"}], "\[Equal]", 
         RowBox[{"Last", "[", "#2", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}]}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1956840094],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], 
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        1.617753747939871, 0.6043445040754697}}]}, 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        1.2861364580114905`, 1.5508520406615778`}, {1.235077563955481, 
        1.5998987766238648`}, {1.1998172689016462`, 1.6612934389610226`}, {
        1.1831838498924179`, 1.7301114768787123`}, {1.186511496475816, 
        1.8008329003583985`}, {1.2095332935161967`, 1.867785046192633}, {
        1.250402630826509, 1.9255975901480156`}, {1.3058413223258467`, 
        1.9696333081008135`}, {1.3714025538797674`, 1.9963600341986787`}, {
        1.4418275684133692`, 2.003633980769769}, {1.5114674780907973`, 
        1.9908716944974434`}, {1.5747363694227587`, 1.959096856017892}, {
        1.6265593571145882`, 1.9108581690802318`}, {1.662779647635908, 
        1.8500249254931247`}, {1.6804919613798617`, 1.7814766438763485`}, {
        1.6782755691593034`, 1.7107116767223833`}, {1.6563082508602172`, 
        1.643406179937026}, {1.6163520354711356`, 1.5849588205222633`}, {
        1.5616118663005267`, 1.5400577420279753`}, {1.4964785280405675`, 
        1.5123045220726108`}, {1.426176455853139, 1.5039252848202889`}, {
        1.3563446761984415`, 1.5155921404821588`}, {1.2925844927220613`, 
        1.546369274426623}, {1.2893252649071054`, 1.5485600106322983`}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.617753747939871, 0.6043445040754697}, {0.8211445524089258,
         0.}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.8211445524089258, 0.}, {0., 0.5703652293375701}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 0.5703652293375701}, {0.2886834314367773, 
        1.5275030724879717`}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.2886834314367773, 1.5275030724879717`}, {
        1.2893252649071054`, 1.5485600106322983`}}]}, 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.2886834314367773, 1.5275030724879717`}, {
        0.28551893221057645`, 1.525177597112911}, {0.2231053752734016, 
        1.4917539396046855`}, {0.15382422981934443`, 1.477169157969334}, {
        0.0832326323630564, 1.4825931177172031`}, {0.01699283258705837, 
        1.5075907555338612`}, {-0.03958198353798031, 
        1.550156976310378}, {-0.08195387174976924, 
        1.6068774845956957`}, {-0.10672412428109046`, 
        1.673202649957809}, {-0.11190588491129698`, 
        1.7438124391342988`}, {-0.09708351745222271, 
        1.8130431432596024`}, {-0.06344594450179188, 
        1.8753416717878233`}, {-0.013691282317782725`, 1.9257109735671039`}, {
        0.04818957881955876, 1.96011085722502}, {0.11723308943756347`, 
        1.975782060507429}, {0.18790117404050402`, 1.9714675745208077`}, {
        0.2545254478060206, 1.9475134701544448`}, {0.3117618855728952, 
        1.905841139255684}, {0.3550194734917133, 1.8497931771319562`}, {
        0.3808284605965528, 1.7838652683573002`}, {0.38711867232972563`, 
        1.713345581693724}, {0.3733855621067576, 1.6438905987595895`}, {
        0.34073068169587695`, 1.5810713998142973`}, {0.29177332422688923`, 
        1.529926799704111}, {0.2886834314367773, 1.5275030724879717`}}]}}, 
     GraphicsComplexBox[{{1.2893252649071054`, 1.5485600106322983`}, {
      1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
      0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}, {
      1.2861364580114905`, 1.5508520406615778`}, {1.235077563955481, 
      1.5998987766238648`}, {1.1998172689016462`, 1.6612934389610226`}, {
      1.1831838498924179`, 1.7301114768787123`}, {1.186511496475816, 
      1.8008329003583985`}, {1.2095332935161967`, 1.867785046192633}, {
      1.250402630826509, 1.9255975901480156`}, {1.3058413223258467`, 
      1.9696333081008135`}, {1.3714025538797674`, 1.9963600341986787`}, {
      1.4418275684133692`, 2.003633980769769}, {1.5114674780907973`, 
      1.9908716944974434`}, {1.5747363694227587`, 1.959096856017892}, {
      1.6265593571145882`, 1.9108581690802318`}, {1.662779647635908, 
      1.8500249254931247`}, {1.6804919613798617`, 1.7814766438763485`}, {
      1.6782755691593034`, 1.7107116767223833`}, {1.6563082508602172`, 
      1.643406179937026}, {1.6163520354711356`, 1.5849588205222633`}, {
      1.5616118663005267`, 1.5400577420279753`}, {1.4964785280405675`, 
      1.5123045220726108`}, {1.426176455853139, 1.5039252848202889`}, {
      1.3563446761984415`, 1.5155921404821588`}, {1.2925844927220613`, 
      1.546369274426623}, {0.28551893221057645`, 1.525177597112911}, {
      0.2231053752734016, 1.4917539396046855`}, {0.15382422981934443`, 
      1.477169157969334}, {0.0832326323630564, 1.4825931177172031`}, {
      0.01699283258705837, 1.5075907555338612`}, {-0.03958198353798031, 
      1.550156976310378}, {-0.08195387174976924, 
      1.6068774845956957`}, {-0.10672412428109046`, 
      1.673202649957809}, {-0.11190588491129698`, 
      1.7438124391342988`}, {-0.09708351745222271, 
      1.8130431432596024`}, {-0.06344594450179188, 
      1.8753416717878233`}, {-0.013691282317782725`, 1.9257109735671039`}, {
      0.04818957881955876, 1.96011085722502}, {0.11723308943756347`, 
      1.975782060507429}, {0.18790117404050402`, 1.9714675745208077`}, {
      0.2545254478060206, 1.9475134701544448`}, {0.3117618855728952, 
      1.905841139255684}, {0.3550194734917133, 1.8497931771319562`}, {
      0.3808284605965528, 1.7838652683573002`}, {0.38711867232972563`, 
      1.713345581693724}, {0.3733855621067576, 1.6438905987595895`}, {
      0.34073068169587695`, 1.5810713998142973`}, {0.29177332422688923`, 
      1.529926799704111}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649071054`, 1.5485600106322983`}, {
     1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
     0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1668403339]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->489698888],

Cell["Applying a number of methods on the Petersen graph:", "ExampleText",
 CellID->289707743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GraphPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "3"}], ",", " ", 
          RowBox[{"1", "\[Rule]", "4"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"2", "\[Rule]", "5"}], ",", 
          RowBox[{"3", "\[Rule]", "5"}], ",", 
          RowBox[{"6", "\[Rule]", "7"}], ",", 
          RowBox[{"7", "\[Rule]", "8"}], ",", 
          RowBox[{"8", "\[Rule]", "9"}], ",", 
          RowBox[{"9", "\[Rule]", "10"}], ",", 
          RowBox[{"6", "\[Rule]", "10"}], ",", 
          RowBox[{"1", "\[Rule]", "6"}], ",", 
          RowBox[{"2", "\[Rule]", "7"}], ",", 
          RowBox[{"3", "\[Rule]", "8"}], ",", 
          RowBox[{"4", "\[Rule]", "9"}], ",", 
          RowBox[{"5", "\[Rule]", "10"}]}], "}"}], ",", 
        RowBox[{"Method", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"m", ",", "Small"}], "]"}]}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<SpringElectricalEmbedding\>\"", ",", "\"\<SpringEmbedding\>\"", 
          ",", "\"\<HighDimensionalEmbedding\>\"", ",", 
          "\"\<CircularEmbedding\>\"", ",", "\"\<RandomEmbedding\>\"", ",", 
          "\"\<LinearEmbedding\>\""}], "}"}]}], "}"}]}], "]"}], ",", "3"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394919304],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{2.0122303406161803`, 1.352991288530645}, {
        1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
        1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0., 
        0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
        0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
        1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
        0.10051765268637802`}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4,
            5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 
           10}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{2.0122303406161803`, 1.352991288530645}, {
         1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
         1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0.,
          0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
         0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
         1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
         0.10051765268637802`}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox[
        "\"SpringElectricalEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0.5441166092897437, 1.7290808001413414`}, {
        1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 0.}, {
        0.3218482339362243, 0.19208897427950378`}, {1.6865117231827154`, 
        1.2878487206527054`}, {0.12044128736467352`, 1.3744305143844167`}, {
        0., 0.7515321328026353}, {0.8858209412870136, 0.917384959508828}, {
        1.4333584750586268`, 0.19839682147095472`}, {1.7619907541382775`, 
        0.743543273683796}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4,
            5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 
           10}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.5441166092897437, 1.7290808001413414`}, {
         1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 
         0.}, {0.3218482339362243, 0.19208897427950378`}, {
         1.6865117231827154`, 1.2878487206527054`}, {0.12044128736467352`, 
         1.3744305143844167`}, {0., 0.7515321328026353}, {0.8858209412870136, 
         0.917384959508828}, {1.4333584750586268`, 0.19839682147095472`}, {
         1.7619907541382775`, 0.743543273683796}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"SpringEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.320886372833192, 1.8668718121973629`}, {
        0.2741185697327577, 1.8697623490318942`}, {1.9761359502006721`, 
        0.6055312964039608}, {2.060287067324816, 0.849172928502917}, {
        1.2073478236715713`, 1.6636785553866518`}, {1.3247474796717678`, 
        1.5020916110578275`}, {1.1309189202245784`, 0.6904765210086242}, {0., 
        0.44972542574419894`}, {0.8490781368146694, 0.}, {1.1270578133860027`,
         1.0552567221481597`}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4,
            5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 
           10}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.320886372833192, 1.8668718121973629`}, {
         0.2741185697327577, 1.8697623490318942`}, {1.9761359502006721`, 
         0.6055312964039608}, {2.060287067324816, 0.849172928502917}, {
         1.2073478236715713`, 1.6636785553866518`}, {1.3247474796717678`, 
         1.5020916110578275`}, {1.1309189202245784`, 0.6904765210086242}, {0.,
          0.44972542574419894`}, {0.8490781368146694, 0.}, {
         1.1270578133860027`, 1.0552567221481597`}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox[
        "\"HighDimensionalEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.4600511483345453`, 0.6942955794063059}, {
        1.3206286700046308`, 1.1233938456875674`}, {0.9556158829382257, 
        1.388591158772099}, {0.5044352654586627, 1.3885911587923556`}, {
        0.13942247836844457`, 1.1233938457405996`}, {0., 
        0.6942955794718573}, {0.1394224782913842, 0.2651973131780768}, {
        0.5044352653339768, 6.076938952048749*^-11}, {0.9556158828135396, 
        0.}, {1.3206286699275704`, 0.2651973130189799}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4,
            5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 
           10}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.4600511483345453`, 0.6942955794063059}, {
         1.3206286700046308`, 1.1233938456875674`}, {0.9556158829382257, 
         1.388591158772099}, {0.5044352654586627, 1.3885911587923556`}, {
         0.13942247836844457`, 1.1233938457405996`}, {0., 
         0.6942955794718573}, {0.1394224782913842, 0.2651973131780768}, {
         0.5044352653339768, 6.076938952048749*^-11}, {0.9556158828135396, 
         0.}, {1.3206286699275704`, 0.2651973130189799}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"CircularEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0.4279394866783388, 0.2700204462653949}, {
        0.6338209849016331, 1.4465554832299836`}, {0.24427100631275533`, 
        1.0741830655963822`}, {0., 0.9198384425081313}, {1.57077103059052, 
        0.8667501956269344}, {0.4905115545737259, 0.3403925530089148}, {
        1.061708857503319, 0.}, {1.5427954422067143`, 1.0068228209881993`}, {
        0.5986138679379224, 0.3533514010326001}, {0.18447471549565198`, 
        0.7075206259405432}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4,
            5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 
           10}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.4279394866783388, 0.2700204462653949}, {
         0.6338209849016331, 1.4465554832299836`}, {0.24427100631275533`, 
         1.0741830655963822`}, {0., 0.9198384425081313}, {1.57077103059052, 
         0.8667501956269344}, {0.4905115545737259, 0.3403925530089148}, {
         1.061708857503319, 0.}, {1.5427954422067143`, 1.0068228209881993`}, {
         0.5986138679379224, 0.3533514010326001}, {0.18447471549565198`, 
         0.7075206259405432}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"RandomEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{4., 0.}, {1., 0.}, {3., 0.}, {7., 0.}, {8., 0.}, {
        9., 0.}, {2., 0.}, {0., 0.}, {6., 0.}, {5., 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          CircleBox[{2.5, 0.}, 1.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{3.5, 0.}, 0.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{6.5, 0.}, 2.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{4.5, 0.}, 3.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{0.5, 0.}, 0.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{4.5, 0.}, 1.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{5., 0.}, 2., NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{7.5, 0.}, 0.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{4.5, 0.}, 2.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{6.5, 0.}, 1.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{5.5, 0.}, 3.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{7., 0.}, 2., NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{1., 0.}, 1., NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{3., 0.}, 3., NCache[{0, Pi}, {0, 3.141592653589793}]], 
          CircleBox[{5.5, 0.}, 0.5, 
           NCache[{0, Pi}, {0, 3.141592653589793}]]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{4., 0.}, {1., 0.}, {3., 0.}, {7., 0.}, {8.,
          0.}, {9., 0.}, {2., 0.}, {0., 0.}, {6., 0.}, {5., 0.}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"LinearEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1669363495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MultiedgeStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->100942717],

Cell["Spread multiple edges by a specified scaled distance:", "ExampleText",
 CellID->1029865650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", " ", "1"}]}], "}"}], ",", 
     RowBox[{"MultiedgeStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3."}], ",", 
       RowBox[{"1", "/", "2."}], ",", "1", ",", "2"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40554687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJxdkmlM0wcAxUtrEA8oHts0KohHECtzeIF4PBSZUq0KCJIKqCjIiBQLDDqU
Q6cgEMFAzZjNSrdkFDtkQsXJAiOIrYIocozhWuXaWigFN/s/eqmrX/eSl5f3
7eWX5xWfGp7AZDAYIQ5/SPVUcuGC7wns/LdSq1ObUezl3BY2aoGi1j20M2oM
tw82//P8cwMY/1OufVAsCBrFg8eB8zu/6kU58xlbfs6Ma86CaVUfBc2Lo1OV
GTTMc0vev/mMxrfDIdkfbaGR7r3EIiqkcev+Nu6P0xQaIkP+zBmgUf6X6Zhd
SiG6s6w4cJkZCfVIGNtLgXH962473wy2R/iLzQYSuy42u/qUmfEsoq91qIDE
LU/r821NZrzu843XeJCgn/bcPdJnxYrjB083ek/jgaevbeyNFU4BvaExh6dQ
5e4XJJtpg4r1MrEn3Qh27KaQyHk27B6sSQoST+JVoF1sYNtwYMarm1qlAWML
YtpOsWzgzuDFaPonUOPmzx+etOKntYJSgWUch92s30k6rOhYVevaunIckd2Z
LRoJCeMnun5VDA1bfb2Pn5ZEv5M6yGijsEQ62v3rIgqhAwlT8koKH0s7RSfD
KLi5bDN6bHSkV0syu4DCo8fJvqInJFIGCeGdexQCwjTnNCdJaN0ixv3GKKTk
kFuEFIGt+QXNl+bQ4N5YWh9fRODqp3EyyWoLNCMc5kO7ERU/CGJqQy1YuuoX
VoOnEdpHCk7qFxZIKyZfvMckelyooT8uW+Az18ZjxRmwPjyD0kgsKPajZy3I
nsA+Rrkkrc4C2dYbWQXicZw5k1gnbrZAEFAjbbyth1WR2r5dbYF3RxzLotIh
6rTTlTUtBBhjwrxDbBoT8tk3n6sJxHCe+gklFGaxh2rf9BNoV0SpXNZQWNFi
DyvSE3hWt/rC7kYSec7nk669I5DXtpLPDSbx5V71UmoxiYc5nIUHegn8dpZp
vL+VxJXGkPdp8QQ6hufXdMSSqI6awzCYTFhcZigZzXL86fQsWW/PJDIZHic2
ymjsFx8VN9IG6LZcGLjbRaPRWLJ8ZLkBe6aVLyPf0qh8e1Yu501gh7C6m7XB
jNl5XT783HH4C0tFimQzxKOZ3vuUekTHtnpskpuRW3Ivv9Wow1tYi4v0ZvCO
Z0bP5eigcmHxq36mkaYp9060/Q0+U7cvLZwG9fSea4pIhyF95KEPP/h92ZMU
3kw9ZE0cgb6WAkvN51ZVO3juGWlZm0ghbl27f8+RcYTnTYmSHJxmR0gPrXOf
wLzSu4HbCRLX9JJLgwMTuPU6M8unkwRXr9sxUm3AsV1VFe53TGAush4Uxplw
/XUw7+J1Eyo4AdplnSYo38FFdd6EelUD71QAgeCG7Sz3NJNjb1cXp4ZARn+G
MjvdBEFIgzJ2EYlU28JCp3xHV1nDXxWSUDACpy9/Y8LODYYmMUmC6ZSl6Ggy
Yf3m/dlnT1D4D92YQz4=
      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
          51, 52, 53, 2}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
          66, 67, 68, 69, 1}, {2, 3}, {3, 4}, {4, 5}, {5, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
       1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {
       0., 0.5703652293376675}, {0.28868343143689057`, 
       1.527503072488035}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJxdk3s01QcAxy+Voowa91iit62FaF6T9u1myhK5Jc80xFIe1claDkq58qaI
szzCyavmHW2LbXk3Cz021QnpVtd1uTd+9/e4v1y33f277znf8/37+/me79qQ
E/vDNDkcjova/2Wv9HjKx+Ukvpr9cUTUq0D6Wq0OvpDFrVr9b/q9X6POo33m
4S4JOP/TOeWzq9E7hOi877iiP/YxcjUH9apPKiC1zi+lCQZBl1x5XxcyoNrM
Cs19FNh9wKc+8gSDjYtdrhq1KuCt4rxZ78DAZPywsfVSFs72TbF8iobEODVZ
15fFb/nPA3RraBys9noWUchipQbfvohPw+NFha7dIxbC9AiLMDkFp6eeZZfm
WEx2vhdR2RTSkz8TlBoqYbRdHCVZ/A65lXHWPVuVwA+LxoS2MhR5d7902alE
UEHzmnWHpVh1/VHJuLMSHo67FlkJpnG/6kNztr0SelV30kt+mkJg/bdtSSZK
DDcoZNRTCbqCk4fM6TmE8GKHG5ZJYOiV1GbZOYdIS+Gfpu6T+C5ttCDhJYVC
nRu/doUwuPJAnqXcRGOv7kmDHB0GdJ2tf+gJGmMtHl5u9TR+nvGNi2+gUXIo
Jt/Zg8a0BtGlL6GxoPD5wl4JBdVradKsKQN7u4Ky9QIKy0+HNsjdGbQYE1TD
SgqG4Tc0Zs+oOb8JGr1XT+IIN+6t9hUW5hda/BN3S9HGs+C8us0iJ8taOyBi
GprlgkvfP2ThtMltsDxjCsNb+TaNIhYJM8X9OjcleNA+O3OOZvGlhUmMR/ck
vIz0xv7+wCL0NvHBbEwMvyXckFua7yFrGuvfx0wgXf+o5byKhdnL1nsC/Qn0
qbRXhgtIaPj2lmmreyi0AkR3E0mUyJqMK87QUNHBxy8nkRBKP73gsIBG8v7z
PqJMEorGFX0bLlOIG1lt0FpM4uDQ46JeEwr7oqc73jWToJvnPomrJZE/4Owq
GCIxkJgaf92JhExBhQQQJFRafU8yBuXYXj2wK2YZA15P4m5uyhR4xcuunbJl
0OlzmOvQIIHX5qTu06EM2tZxOzxH1Hvpnhd4XWOwISBHsVRvEkWmRgPiJwxm
//F7qu8qxqHgbTKOgQJRGyv9NFIn0LEz4W64nwJ5MSHPY4dEmE7Oa5q4oQAT
q8zWXy1C2OiLmujLNI5dbDqv1/gWgQf21DuY0ygS51X+vkgEiyXmLXsHKcTn
7nD0jBHBdssKC5uzFMrXjH9EsSKEy8WdPpsp1B/J2ZNwdQLzR1edZMUkqMyy
vGCeGAttHjhuUfMIjY2oHpgXg+uwpmYsRc1L292mtncSfWmu3T1RBBZvsuj3
lhH44xjFLfMkQGaY5vr7yHHnl9rw1TwCR5R9M45dctieKr0lAIHIz8+pvrAi
kRZ+Kn/YjUAm2bMtQb0DGbQ861UYgZvvKrT5WhSy66bOOmQReF31xpCMUP+v
TZpp10Eg0MqquP0vCv8CvcJCuw==
      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
          51, 52, 53, 2}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
          66, 67, 68, 69, 1}, {2, 3}, {3, 4}, {4, 5}, {5, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
       1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {
       0., 0.5703652293376675}, {0.28868343143689057`, 
       1.527503072488035}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJxdkn1Q0wUAhseHwoE4vgakoQeYyFdGieJQX1AnggIyRb2Bih8gx+mGbCbh
EZkVhtc2kC7IZGUq35lABJ0GWFttKoHjBN0EdMBwsDH225fbYNm/vXfPPf8/
9wYdY9FzHEkkEu0N/1mkzi/z+UGPLXPV8kmRGeVBi3vTX75GY7NnkmS/Ai2p
d7X9O1Qg/W8f24armPEvcf9vqrfko8eodOwj1xWY8a5kyHnwuhVF9tyEXo4Z
1/7acaPJ1YaI9SFTmSfNGCLz1aJ8G/iOQQEzO824mt1RkC6yISPl6wr6MjM4
TorYuoB5bMzOZCrlJjw9Kt6Vd2Qej2RLYgoqTei2eH9QXj0PQbrfn96bTTDO
71t68v48nvGOnqWNGkFrjtSVyu0omWYItw9qsXb/yusvDXasjm/B3QItEtvj
2sgLdjzItp0/4KZFMHdKKNHb4UW7uIqycxYLrKTdB5/ZQb/SMlhxQYNcpZR/
/rYd9T19ihGRGm5u8D1z1o4eUqf2cKAaYT05pyai7AgRdtQYvpzBV4uZGqHU
CNnTA+pqjgnmJZftuvdMqBmjFVPWm8AOXf66qMyEhs645JsaI1ozaM9KnphQ
OU5k2mqNOCjhlVMDzci5gxxFohEk/sV/bAwzyCvoT2NUBiRcuOsRxjOjb6+0
e/QLAxpWWvrjusyYlUYdk60wwPRooH2f1ILgI6knfgnV4P7KKKtCZ4FD7OOk
rD1qCDyj4793sULo9Dx3gD0D8qF1tAwvK7YO1+fFV01jhGqrUpGt2O088q28
TQWFT1bvcScrkp1TsmSDr1C/dANjbNqCpnAml/l6CnuWWq5dFVsgXtXs0R0y
BQeHc43iLgJrY3YVn8o2ooFE1Xz2DYEt76u6qgwGsKy+ZQ6fEGAJLfSRMgPY
g5y2YjYBJq217VCAAVtbNzl5FhJgyx4+jKjXo3UBrsLzBO4IW1OOx+rBm92W
coFPoCoiVh4oIcBIEFzx/JmAU4Al9cxhAg2zH54LkxiQrJzc/OKWCl7cduom
vQFc5dVPh5+8Ar1UXZS3xgj3vbVpkZ6vYNn+4l54rhFHIv/YMLBvCoKuCKay
2QhnESNZcEuJEWVG2ozViCeBD06nuCjBcJzcWUg3venc4XG6aBJCVyeG4LYJ
hbLK0FzrBEJoNdsqxnRYz+eUUqwKtCeG3+gq1qE/2BY9RhlHsX2MURugw+Jy
0uNu+jg6fvptyOfeHEr0/qO62+N47s4l/54/h/a+y++IwydQ1FJns4XMgTu0
pvrX7glU+h6myFRaqKYpxYX5k8j0epu60KMFm1Xq77FaiWWiS82SFDX8s0Rx
LrVzSCz8cfei5WowXTi9PAcd/Dryw5vc1BBPrvpcf1KHbEevRTFvfux+c5SZ
0KdD/ZY081t0NaZLJH4XowkMp1FZ0jo14pUbeXIuAZ7bibyp5RqsSxRe+k5B
gF7r12lv1MBxgrYuPUqPfwG2kjrE
      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
          51, 52, 53, 2}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
          66, 67, 68, 69, 1}, {2, 3}, {3, 4}, {4, 5}, {5, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
       1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {
       0., 0.5703652293376675}, {0.28868343143689057`, 
       1.527503072488035}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJxdi3sw1AkAx+1uD6dIKS7NWZyzHskjTdJu31/NIc3FRNRU13pdqENkKKnt
oVSHLHJyl0djE3HqsqrLXV1zJxyL1NzGeuyuxRH2Z1/2l61z/9535jOfPz7z
tYtKCvmGbmRk5LfAf26ZOpptUanGNrJEMtoyh2t2S37fI9Ojts48sD1cjvqg
ZmW3/wSM/rez8+KiREKGF62+q9pPvUIBXbSi+vgcMocqHGmlNKK4wSO6qJ1C
cvRdjrydRqyfbHU+JqKgvFllvOk9jWDKV35kPlvoYf/I1jnTiTpB+2eBtyjs
rbsz9jqETrwW5015HaXQs3Q5WtLoxLnN5dt7WRT4jm7ivEI6YfUw2apJrIdQ
sEFjcZdONDu7F4zw9JBkWsfaChkE95KTTJ6qghHFTyt5ziCqq/4+2bJGBenN
7K6CFwziL1/bTEbjLFJCmIvmf2EQl6+eYx8MnQXN50SFTS2DKPey8byoI3He
9KuginwGMWnmfJVWRWL/zp5Tp5MYhCi+IdfkEIkwQaVQE8Ag9g0rWZH2JA73
HLJMcdSj2Cpof/IbHab7nKwacvQI4X0iZD7WoduK5GRN6eEbE5lrm6ODmws3
7q0/haIaVkZsiA5xn2ZRz4opsEqbLbyX66BkHuCf6adQF5FrvOypFruf2xfd
sHiPzfoVwvoILbryqpN6OO+hePDymPlHDWw4vNCJfQaYrbuQzhyfgd/2254R
JwyYF2wavWU9g1mmqfFJngHWmWtcAgKmIW3/IJ0+bYD0Z7+o+pQpbJTRQ8Vx
Bjy5crk2vvIdUrfmmZT5GxB7RyGgiycxfk98zbDGgNzOxqRe60kEyn9YsUg8
DwfHrDOqhAkYr3/jE3mPxAVv7o6QrRrER5f8GptAonPYP1A2osZAr4zzkk0i
InXDT7suq2HjlqjJsSaxmTHo+r2dGse/TDmStpSEQ+KHYM1jFbgz0cQUg0T2
Vctv7wapsFwkslxsTqI4dYmZYWQWG1+R6gxXEqa+EX7ss7O4eK5NXOi38HN9
6JI+Oo7FwUGNXUkqPP3RvoT9+TiiZiwfjVWr8KqTRZ5PHMOE9t1uwTsVJAfa
+tw7RvGFYuXwd2w1aGyVaRtGcUHHM5HeUEPYwhsL71AgxnunZ5NWjUv57iX7
UxXQcFZ7qQ5pYODe2SPcokBjxWHtn2Wj0HJfpA+WDWI4nyjl9CtQnhz59cXr
g5A1BSdq1yrQy+cY3+8YxFAre/HBqBHczj6Qu2zvEMISAmbTnsrBG3BgeZkP
4/DHB0UPXOVg2S7ikUXDiMxy87j+WAbKidvrulEKUTarOeOIDPe3jgyIRqSI
CleO82MkiM8iOd3UFIgE74QeYwn6/ArNlz2ZxrbEbMGHuX4UrKWb8DNn0FTT
ZiTcJIHZbxV/KG2U2HbGxaaiWQLNakZ3a4YSPj3RDQVXBlDjM5e+S6TEJWpL
6BP+IFoGkk9styRRvupR6ljnEDixHm8ngkn8C9aJKAk=
      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
          21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
          36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
          51, 52, 53, 2}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
          66, 67, 68, 69, 1}, {2, 3}, {3, 4}, {4, 5}, {5, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2893252649072209`, 1.5485600106322432`}, {
       1.6177537479398745`, 0.6043445040753757}, {0.8211445524088582, 0.}, {
       0., 0.5703652293376675}, {0.28868343143689057`, 
       1.527503072488035}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->168690700]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PackingMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47225018],

Cell["Packing disconnected components using different methods:", "ExampleText",
 CellID->1302252890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GraphPlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "\[Rule]", 
           RowBox[{"Mod", "[", 
            RowBox[{
             RowBox[{"i", "^", "2"}], ",", "114"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "114"}], "}"}]}], "]"}], ",", 
        RowBox[{"PackingMethod", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "m"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Layered\>\"", ",", "\"\<LayeredTop\>\"", ",", 
          "\"\<LayeredLeft\>\"", ",", "\"\<ClosestPacking\>\"", ",", 
          "\"\<ClosestPackingCenter\>\"", ",", "\"\<NestedGrid\>\""}], 
         "}"}]}], "}"}]}], "]"}], ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47617879],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxNmHk8VN8bx62V7GLGZJsZs9yRRpY2qjlFqRClJAmVXSRRyFZJhVJCkaVQ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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNlX881fcXx++9rjXuDRddbq7ruve6LkkRfdfad59DStLmSqsm6a4vYZZs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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"Layered\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxNWHk8lO33tu8JMcxiDOYZmTGKaFPNSYSkFC3a82qjUC8plRAtVBIphBZb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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNlH1Uk2UYxscA+dga25QBMgZubDhkGgR9Wb03NAPS2RAQUUzyQBAkkFoC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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredTop\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxlWHk4lN/7RtmVnRmzYQYzg7EULcocWpT6lF2FEomoVAhFRZGlIkmWpI1S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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllHlQU2cUxRM2wUQgYYeQQMKShEUWYWxteVeGKUqrjXtrQaNopaJIVahY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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredLeft\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxNWHk8VV0XNk+hqKREuKZrKK47pHL3zlXSZCqlQZKiCVGG6k0qQxlSkVAq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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNVAlUTHsYv00aoXhIKtIyWzOJNHeatN2vJi0oGZTlRTJUDkk9LV56shQv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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPacking\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxNWHk8lN/3H0sYYxlj9olsWROlLBXPLUk7KVkq2SohEiql0kYfCRVR2ZKE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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNVXs4lPkeH4yZYaQxN8NQcjlZcouzLqXfLwzVUraTdSurGlFEwu46JJ16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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPackingCenter\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk8lN/3H8a+ZTfJWGIsg5hRkTBHZYuQvbSQoiKypJWUIiWVPhKyRCIV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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdVAs01Xccv0uMi0ZeN+Hch+uKe937x0rC/5PmtRQt1Fm1ktJK0VWR7Vam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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"NestedGrid\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 351},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487867453]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44888674],

Cell[TextData[{
 "Use different ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " around the graph: "
}], "ExampleText",
 CellID->1808033363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"GraphPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "2"}], ",", 
         RowBox[{"2", "\[Rule]", "3"}], ",", 
         RowBox[{"3", "\[Rule]", "4"}], ",", 
         RowBox[{"11", "\[Rule]", "22"}], ",", 
         RowBox[{"22", "\[Rule]", "33"}], ",", 
         RowBox[{"33", "\[Rule]", "44"}], ",", 
         RowBox[{"1", "\[Rule]", "11"}], ",", 
         RowBox[{"2", "\[Rule]", "22"}], ",", 
         RowBox[{"3", "\[Rule]", "33"}], ",", 
         RowBox[{"4", "\[Rule]", "44"}]}], "}"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1", ",", 
       RowBox[{"Scaled", "[", "0.1", "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500288768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.8610735521122315}, {1.0404792714052309`, 
       0.8824178321727809}, {2.2021501267370684`, 0.8823391990124911}, {
       3.2440101842787676`, 0.8611240564004663}, {0.00033029964993236405`, 
       0.021939352545726376`}, {1.0415126913548782`, 
       0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
       3.2437724011391795`, 0.02237834280406742}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
          6}, {6, 7}, {7, 8}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "33"],
          Annotation[#, 33, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "44"],
          Annotation[#, 44, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.8610735521122315}, {
        1.0404792714052309`, 0.8824178321727809}, {2.2021501267370684`, 
        0.8823391990124911}, {3.2440101842787676`, 0.8611240564004663}, {
        0.00033029964993236405`, 0.021939352545726376`}, {1.0415126913548782`,
         0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
        3.2437724011391795`, 0.02237834280406742}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.8610735521122315}, {1.0404792714052309`, 
       0.8824178321727809}, {2.2021501267370684`, 0.8823391990124911}, {
       3.2440101842787676`, 0.8611240564004663}, {0.00033029964993236405`, 
       0.021939352545726376`}, {1.0415126913548782`, 
       0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
       3.2437724011391795`, 0.02237834280406742}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
          6}, {6, 7}, {7, 8}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "33"],
          Annotation[#, 33, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "44"],
          Annotation[#, 44, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.8610735521122315}, {
        1.0404792714052309`, 0.8824178321727809}, {2.2021501267370684`, 
        0.8823391990124911}, {3.2440101842787676`, 0.8611240564004663}, {
        0.00033029964993236405`, 0.021939352545726376`}, {1.0415126913548782`,
         0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
        3.2437724011391795`, 0.02237834280406742}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0.1],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.8610735521122315}, {1.0404792714052309`, 
       0.8824178321727809}, {2.2021501267370684`, 0.8823391990124911}, {
       3.2440101842787676`, 0.8611240564004663}, {0.00033029964993236405`, 
       0.021939352545726376`}, {1.0415126913548782`, 
       0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
       3.2437724011391795`, 0.02237834280406742}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5, 
          6}, {6, 7}, {7, 8}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "33"],
          Annotation[#, 33, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "44"],
          Annotation[#, 44, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.8610735521122315}, {
        1.0404792714052309`, 0.8824178321727809}, {2.2021501267370684`, 
        0.8823391990124911}, {3.2440101842787676`, 0.8611240564004663}, {
        0.00033029964993236405`, 0.021939352545726376`}, {1.0415126913548782`,
         0.00024330303003800013`}, {2.2024052867334283`, 0.}, {
        3.2437724011391795`, 0.02237834280406742}}]& ],
     AspectRatio->Automatic,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    FrameMargins->0,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{497, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->135066617]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->179618439],

Cell["Specify an overall style for the graph: ", "ExampleText",
 CellID->1676190373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}}, {
       {RGBColor[1, 0, 0], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {3, 4}}]}, 
       {RGBColor[1, 0, 0], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}}, {
       {RGBColor[0.5, 0., 0.], PointSize[Medium], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {3, 4}}]}, 
       {RGBColor[0, 0, 0.7], PointSize[Medium], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}}, {
       {RGBColor[0.5, 0., 0.], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {3, 4}}]}, 
       {RGBColor[0, 0, 0.7], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}}, {
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {3, 4}}]}, 
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->380842905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297939305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 ", which has higher priority: "
}], "ExampleText",
 CellID->580503372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "l"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317015018],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {3, 4}}]}], 
     {RGBColor[1, 0, 0], PointSize[Large], 
      {RGBColor[0, 1, 0], PointBox[{0.9329071093442749, 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{0., 0.43416140263422554`}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{0.933936894005156, 0.8689407501260831}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{1.868121719946255, 0.4336827821587582}]}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
     0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
     1.868121719946255, 0.4336827821587582}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666454885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414909817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 ", which has higher priority: "
}], "ExampleText",
 CellID->88626299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "vl", ",", "el"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->238367270],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.9329196605347692, 0.}, {0., 0.4341830912834329}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.9329196605347692, 0.}, {1.8681088610644687`, 
        0.433702388876057}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.9329196605347692, 0.}, {0.9339538512611285, 
        0.8689546144364431}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0., 0.4341830912834329}, {0.9339538512611285, 
        0.8689546144364431}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.9339538512611285, 0.8689546144364431}, {
        1.8681088610644687`, 0.433702388876057}}]}}, 
     GraphicsComplexBox[{{0.9329196605347692, 0.}, {0., 0.4341830912834329}, {
      0.9339538512611285, 0.8689546144364431}, {1.8681088610644687`, 
      0.433702388876057}}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9329196605347692, 0.}, {0., 
     0.4341830912834329}, {0.9339538512611285, 0.8689546144364431}, {
     1.8681088610644687`, 0.433702388876057}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->908047783]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SelfLoopStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91275691],

Cell["Draw self-loops with a specified scaled diameter:", "ExampleText",
 CellID->1053407179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "2"}], ",", 
       RowBox[{"4", "\[Rule]", "4"}]}], "}"}], ",", 
     RowBox[{"SelfLoopStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375686493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}, {-0.000012288822544327573`, 
      0.4333760844644708}, {-0.002236522112915044, 
      0.4193919325380646}, {-0.008292177431412686, 
      0.406592215451568}, {-0.017693522288050018`, 
      0.3960036162185542}, {-0.02968646180683665, 
      0.38847546103089176`}, {-0.043309025718934406`, 
      0.3846115936300077}, {-0.05746852932863061, 
      0.3847219401650801}, {-0.07102921926431047, 
      0.38879764958788665`}, {-0.08290337382750108, 
      0.39651180360762606`}, {-0.0921385506549699, 
      0.4072456392592552}, {-0.09799398343820917, 
      0.4201381807368604}, {-0.09999999981375597, 
      0.4341552994540519}, {-0.09799569443317126, 
      0.4481726629284062}, {-0.09214183540362131, 
      0.46106591904518907`}, {-0.08290796885560865, 
      0.4718008818958139}, {-0.07103475599831328, 
      0.47951648526017615`}, {-0.05747456365943528, 
      0.48359384991929566`}, {-0.04331507362451967, 
      0.48370592481357677`}, {-0.02969203817632935, 
      0.4798437202607142}, {-0.017698179833139264`, 
      0.4723170290305459}, {-0.008295542563964009, 
      0.4617295774384432}, {-0.002238324910991451, 
      0.44893059962240955`}, {-0.000012384681218270512`, 
      0.4349467192981119}, {1.8681347662009442`, 0.43446808811069354`}, {
      1.8703724861443347`, 0.4484500882639533}, {1.8764404839486293`, 
      0.461243958729058}, {1.8858520371159813`, 0.471823485458024}, {
      1.897852231947677, 0.4793400699770825}, {1.911478516216193, 
      0.48319079664414116`}, {1.9256379068108818`, 0.48306679334645986`}, {
      1.9391946594252192`, 0.4789780065600814}, {1.9510613681787232`, 
      0.4712524035292292}, {1.9602861879468563`, 0.4605096655599655}, {
      1.9661291831751675`, 0.4476114825254161}, {1.968121679133679, 
      0.4335924355290573}, {1.966103854965306, 0.41957701172325207`}, {
      1.9602375631378837`, 0.4066894076392371}, {1.95099334703383, 
      0.39596335582823217`}, {1.9391126980145326`, 0.38825920774352707`}, {
      1.9255485793725315`, 0.3841949237602745}, {1.9113889878275772`, 
      0.3840965057189639}, {1.8977696838046925`, 0.3879718478668323}, {
      1.8857830905193675`, 0.3955101036493726}, {1.8763906692002752`, 
      0.4061066191424705}, {1.8703457989541157`, 0.4189114331800853}, {
      1.8681333471853043`, 0.43289745391514384`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
          41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}, {-0.000024577645088655147`, 
      0.43259076629471604`}, {-0.004473044225830088, 
      0.4046224624419037}, {-0.016584354862825373`, 
      0.37902302826891043`}, {-0.035387044576100035`, 
      0.35784582980288276`}, {-0.0593729236136733, 
      0.342789519427558}, {-0.08661805143786881, 
      0.3350617846257899}, {-0.11493705865726123`, 
      0.3352824776959347}, {-0.14205843852862093`, 
      0.3434338965415477}, {-0.16580674765500217`, 
      0.3588622045810266}, {-0.1842771013099398, 
      0.3803298758842849}, {-0.19598796687641834`, 
      0.4061149588394952}, {-0.19999999962751194`, 
      0.43414919627387827`}, {-0.19599138886634251`, 
      0.46218392322258683`}, {-0.18428367080724262`, 
      0.4879704354561526}, {-0.1658159377112173, 
      0.5094403611574022}, {-0.14206951199662657`, 
      0.5248715678861268}, {-0.11494912731887055`, 
      0.5330262972043658}, {-0.08663014724903934, 
      0.533250446992928}, {-0.0593840763526587, 
      0.5255260378872029}, {-0.03539635966627853, 
      0.5104726554268663}, {-0.016591085127928017`, 
      0.4892977522426608}, {-0.004476649821982902, 
      0.4636997966105936}, {-0.000024769362436541025`, 0.4357320359619982}, {
      1.8681478124556334`, 0.4352533940626289}, {1.8726232523424142`, 
      0.4632173943691484}, {1.8847592479510034`, 0.48880513529935776`}, {
      1.9035823542857078`, 0.5099641887572898}, {1.927582743949099, 
      0.5249973577954068}, {1.9548353124861308`, 0.5326988111295241}, {
      1.9831540936755088`, 0.5324508045341615}, {2.0102675989041834`, 
      0.5242732309614045}, {2.0340010164111915`, 0.5088220248997002}, {
      2.0524506559474576`, 0.48733654896117273`}, {2.06413664640408, 
      0.461540182892074}, {2.068121638321103, 0.4335020888993564}, {
      2.064085989984357, 0.4054712412877459}, {2.0523534063295124`, 
      0.379696033119716}, {2.033864974121405, 0.35824392949770617`}, {
      2.01010367608281, 0.342835633328296}, {1.9829754387988083`, 
      0.33470706536179073`}, {1.9546562557088991`, 0.3345102292791696}, {
      1.9274176476631302`, 0.3422609135749064}, {1.9034444610924801`, 
      0.357337425139987}, {1.8846596184542956`, 0.3785304561261827}, {
      1.8725698779619764`, 0.4041400842014123}, {1.868144974424354, 
      0.4321121256715294}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
          41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.9329071093442749, 0.}, {0., 
      0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
      1.868121719946255, 0.4336827821587582}, {-0.00006144411272164479, 
      0.4302348117854518}, {-0.011182610564575226`, 
      0.360314052153421}, {-0.041460887157063434`, 
      0.29631546672093784`}, {-0.0884676114402501, 
      0.2433724705558687}, {-0.14843230903418325`, 
      0.2057316946175566}, {-0.216545128594672, 
      0.18641235761313638`}, {-0.28734264664315307`, 
      0.1869640902884985}, {-0.3551460963215523, 
      0.20734263740253103`}, {-0.4145168691375054, 
      0.24591340750122814`}, {-0.4606927532748495, 
      0.29958258575937396`}, {-0.4899699171910458, 
      0.36404529314739975`}, {-0.4999999990687798, 
      0.4341308867333573}, {-0.48997847216585627`, 
      0.5042177041051288}, {-0.46070917701810654`, 
      0.5686839846890431}, {-0.4145398442780432, 
      0.6223587989421673}, {-0.3551737799915664, 
      0.6609368157639787}, {-0.28737281829717637`, 
      0.6813236390595762}, {-0.21657536812259834`, 
      0.6818840135309818}, {-0.14846019088164675`, 
      0.6625729907666688}, {-0.08849089916569633, 
      0.6249395346158274}, {-0.04147771281982005, 
      0.5720022766553137}, {-0.011191624554957261`, 
      0.5080073875751457}, {-0.0000619234060913595, 0.4380879859536573}, {
      1.8681869512197007`, 0.4376093119184349}, {1.879375550936653, 
      0.5075193126847335}, {1.9097155399581258`, 0.5714886650102571}, {
      1.9567733057948866`, 0.6243862986550871}, {2.0167742799533643`, 
      0.6619692212503796}, {2.084905701295944, 0.681222854585673}, {
      2.155702654269389, 0.6806028380972663}, {2.2234864173410753`, 
      0.660158904165374}, {2.2828199611085958`, 0.6215308890111132}, {
      2.328944059949262, 0.5678171991647945}, {2.3581590360908167`, 
      0.5033262839920476}, {2.3681215158833755`, 0.4332310490102536}, {
      2.3580323950415103`, 0.3631539299812275}, {2.328700935904398, 
      0.2987159095611526}, {2.282479855384131, 0.24508565050612804`}, {
      2.223076610287643, 0.20656491008260253`}, {2.155256017077638, 
      0.1862434901663395}, {2.0844580593528654`, 0.18575139995978673`}, {
      2.0163615392384426`, 0.20512811069912856`}, {1.9564285728118176`, 
      0.2428193896118301}, {1.9094664662163565`, 0.29580196707731937`}, {
      1.879242114985558, 0.3598260372653934}, {1.868179856141502, 
      0.4297561409406862}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
          41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9329071093442749, 0.}, {0., 
       0.43416140263422554`}, {0.933936894005156, 0.8689407501260831}, {
       1.868121719946255, 0.4336827821587582}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5140914]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexCoordinateRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->469196428],

Cell["Explicitly specify all vertex coordinates: ", "ExampleText",
 CellID->49039736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], ",", 
      RowBox[{"6", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"7", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}]}], "}"}]}], ",", 
      RowBox[{"8", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->895811688],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.}, {-1., 0.}, {1., 0.}, {0., 2.}, {
    0., -1.}, {-2., 0.}, {0., -2.}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 8}, {4, 6}, {4, 
       8}, {5, 3}, {5, 7}, {6, 7}, {7, 8}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {-1., 0.}, {1., 0.}, {0., 2.}, {
     0., -1.}, {-2., 0.}, {0., -2.}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15899962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379319889],

Cell[TextData[{
 "Explicitly specify only ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates and automatically compute the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate: "
}], "ExampleText",
 CellID->762072884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "1"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0.5"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "1"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1701360579],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7742097334628223, 1.}, {0.931322776289103, 
    0.}, {0.9313227762887095, 0.5}, {1.0884358191148022`, 1.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {3, 2}, {4, 2}, {4, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7742097334628223, 1.}, {0.931322776289103, 
     0.}, {0.9313227762887095, 0.5}, {1.0884358191148022`, 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{75.79764923321869, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{80, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218901788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24443973],

Cell["Show vertex labels:", "ExampleText",
 CellID->1001631834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1042589918],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.43504106006758986`}, {0.9332823111592068, 
    0.}, {0.9332483037744383, 0.8700109363256525}, {1.8671265559855126`, 
    0.43505689234652134`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {3, 2}, {4, 2}, {4, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.43504106006758986`}, {0.9332823111592068,
      0.}, {0.9332483037744383, 0.8700109363256525}, {1.8671265559855126`, 
     0.43505689234652134`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235183724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291462997],

Cell["Show vertex labels as tooltips only:", "ExampleText",
 CellID->73764302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655204029],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.43504106004813836`}, {0.9332823112779212, 
    0.}, {0.9332483039048904, 0.8700109362373283}, {1.8671265560678756`, 
    0.4350568923215951}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {3, 2}, {4, 2}, {4, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.43504106004813836`}, {0.9332823112779212,
      0.}, {0.9332483039048904, 0.8700109362373283}, {1.8671265560678756`, 
     0.4350568923215951}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->956179799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268593998],

Cell["Show vertex labels as tooltips only if the graph is small:", \
"ExampleText",
 CellID->1953868534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69684929],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.43504106004813836`}, {0.9332823112779212, 
    0.}, {0.9332483039048904, 0.8700109362373283}, {1.8671265560678756`, 
    0.4350568923215951}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {3, 2}, {4, 2}, {4, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.43504106004813836`}, {0.9332823112779212,
      0.}, {0.9332483039048904, 0.8700109362373283}, {1.8671265560678756`, 
     0.4350568923215951}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506324945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8973542],

Cell["Show vertex labels both explicitly and as tooltips:", "ExampleText",
 CellID->1197125759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406910921],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.43504106006758986`}, {0.9332823111592068, 
    0.}, {0.9332483037744383, 0.8700109363256525}, {1.8671265559855126`, 
    0.43505689234652134`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {3, 2}, {4, 2}, {4, 3}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.43504106006758986`}, {0.9332823111592068,
      0.}, {0.9332483037744383, 0.8700109363256525}, {1.8671265559855126`, 
     0.43505689234652134`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2376213]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82661052],

Cell["Show no vertices:", "ExampleText",
 CellID->1148726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "1000"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "1000"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1976145425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4715762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647530537],

Cell["Render vertices using a predefined graphic:", "ExampleText",
 CellID->2039050761],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", " ", "=", " ", 
   GraphicsBox[{{}, 
     GeometricTransformationBox[
      RasterBox[{{146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 
       146, 146, 146, 146, 146}, {146, 146, 146, 146, 146, 146, 86, 86, 86, 
       86, 86, 146, 146, 146, 146, 146, 146}, {146, 146, 146, 146, 102, 128, 
       114, 56, 48, 54, 108, 124, 98, 146, 146, 146, 146}, {146, 146, 146, 
       111, 130, 119, 76, 50, 63, 60, 68, 117, 134, 106, 146, 146, 146}, {146,
        146, 84, 95, 78, 46, 47, 57, 57, 65, 65, 80, 105, 115, 90, 146, 
       146}, {146, 146, 45, 23, 35, 43, 48, 48, 48, 53, 65, 67, 71, 74, 83, 
       146, 146}, {146, 61, 26, 28, 42, 42, 42, 66, 107, 118, 122, 97, 70, 79,
        75, 86, 146}, {146, 20, 22, 30, 40, 37, 31, 93, 144, 144, 144, 129, 
       77, 69, 69, 86, 146}, {146, 36, 92, 39, 21, 25, 32, 110, 144, 140, 144,
        138, 94, 44, 72, 86, 146}, {146, 113, 136, 99, 29, 14, 41, 125, 144, 
       141, 144, 144, 96, 38, 103, 86, 146}, {146, 112, 139, 137, 82, 8, 17, 
       64, 121, 142, 142, 101, 33, 33, 120, 86, 146}, {146, 146, 131, 143, 81,
        6, 11, 2, 18, 88, 87, 19, 9, 27, 100, 146, 146}, {146, 146, 104, 123, 
       59, 4, 7, 3, 1, 1, 1, 5, 5, 24, 85, 146, 146}, {146, 146, 146, 62, 15, 
       1, 1, 12, 55, 89, 52, 13, 10, 51, 146, 146, 146}, {146, 146, 146, 146, 
       49, 16, 34, 116, 133, 145, 132, 91, 58, 146, 146, 146, 146}, {146, 146,
        146, 146, 146, 146, 73, 126, 135, 127, 109, 146, 146, 146, 146, 146, 
       146}, {146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
        146, 146, 146, 146}}, {{0, 0}, {17, 17}},
       ColorFunction->(Apply[RGBColor, 
         Part[CompressedData["
1:eJztl8mOHEUQhhvkB2AxuzHiFdhX5yuAzb5KSJxBCJBYZDhy9DK2x/Z4OXDg
hGzANvKMZ2yBLbMYa7p7etz7TK/TPd0NeF84QETkH6WKVGEu3Oq7hLq+yMis
qsys7Pvfemft2zdm/uGGTGZFBvzhkuJCnfj9ut7GpLyjM0TkP2Oi63v3EJF/
k4m8bQ+PeB8T+TeYkROiPPj1zMjVa8TI7dlNjBK9rQ8/M00kt7cRfjUzcmuY
kf6Gf5oZ6nXcD3ytSgzd9BFiqL/hqxVi4HbvIoZ6H0kedeDvZYY6jteZsD48
8uGfYgbazt7/X9eIZa2DCP8aM3BHpoiB2zVBDIL6uI58+KlJYjnIg5/YSSy7
VUzY3nqM1/pKmYgi/LWrRF+vP8lEvlwi+jpO9AM/eZjoaz9J7V9llt0nTOjR
znqMD/4eJvQ2wn/M9LUfjNeOH9G2f4VJ9jt3EP2gDvzVK0Qv0ZeKROQxXviX
mZ57gulrf/CPMz3tZ8d2oqf+ymViyX3E9LQe/F1MT+vgN/yZeaKrdez4X2KW
1BfPEEvqvz9EdN1jzJK7k4n8+Daiq9cvXyK66p9n2uo/ZaL59yLT1TqI8Lcx
bb0PrDP4O5iue5Tpaj34SxeJjuZZ/yHT0bz5AtFRj9+IyIM/dJDoBHnwLzAd
zUOE/+5boqntsE5te4wTEf52Jrq+bSsR+bHNRFOv2/m/kmm5R5hOMP8OHiDa
7uIFoq392fdbmCOiPNse3rb/gIk8oq2PPNSDv3CeaGkeIvzDTDvRoz3mGWKS
t+23jBGtIMKvZRpuLk+0gvX1PhO1Qx78c0wryLPvDx758A8xyf78OaKp15Fv
PfpBTPK2/jqm6fI5ohm0f5Bp6jqw/d/CNHQe2/kl57m6O3eWaAT7j5zH6i6X
JRrB/iXf64p67NO2/weYhr5P+Owssajx7J/Eovpv9hORRz14+a6V3M3MYrB/
yHmq5vbvIxbce0zU/hlmwW3cQCxoHrycF2v6HPC84OW8V9N+kA8v571qUAde
znVVf36saT68nLcq/nxW1Qgv91vQdnb+y3mh7M8tFX1f8HczJX/+KQf3h/Zy
vin7c0zZrN+85mEe2Po2wst+MOe/6yV93/ByPihqO+TF12/en1NKwfyS731R
o+zPRfP9nPff/dDL+supf5aJxrd1CzHnvzMF/50oqJd5Oate/p/UAy/7ekHn
E7y8z7z2I9/hebO/5TUPzxNe1n1O3xPmi31+sr/k9De8vM+su5XJaT3rbV58
fc+6zZuIrH8/WbM/ZNUjwsvzntWIevb5ISIPXv7vnPLr7JRfh7+pl/d1Qj2e
Z3z+/uzXz69aD172w5Nu+zhx0q+TX8z54oSfPz/593/ajP+YjkPW32mzvn70
7/+4/44eVy/1ZtymjcQx//x/MOM/7Pe3o1onvr4n/f1NaT146e9AEOFvYvbp
ddnHps3/5681Ij8+/77UKM/zK1N/b6KXcU9oRH68/phG5MXf33iQF+9/g15H
frz9F5qHCJ/xyPXPg/qZf8W2f1f7i/ukeD3+e/+pT33qU5/61Kc+9alPfepT
n/r/1/8NYarCTQ==
          "], #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{17, 17},
    PlotRange->{{0, 17}, {0, 17}}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876584969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"gr", ",", "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280649582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26736123]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(19)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29731],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Theory",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->240147850],

Cell["Plot a complete graph on 10 nodes:", "ExampleText",
 CellID->423199925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10847997],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.6976632167880235, 1.3720049088576323`}, {
    0.9359151590398638, 0.}, {1.1516430144084309`, 1.2047028177685624`}, {
    1.3915213866478011`, 0.7851574198556063}, {0.4498362997104189, 
    0.0017504978463637189`}, {1.3062737651378444`, 0.3110922887341992}, {
    0.6928790796321462, 0.6647128835574782}, {0., 0.7901655257566345}, {
    0.08025030877797557, 0.31401818807387316`}, {0.2409781475270742, 
    1.2087304721648426`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {
       2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 10}, {4, 
       5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 7}, {5, 8}, {
       5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 8}, {7, 9}, {7, 
       10}, {8, 9}, {8, 10}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.6976632167880235, 1.3720049088576323`}, {
     0.9359151590398638, 0.}, {1.1516430144084309`, 1.2047028177685624`}, {
     1.3915213866478011`, 0.7851574198556063}, {0.4498362997104189, 
     0.0017504978463637189`}, {1.3062737651378444`, 0.3110922887341992}, {
     0.6928790796321462, 0.6647128835574782}, {0., 0.7901655257566345}, {
     0.08025030877797557, 0.31401818807387316`}, {0.2409781475270742, 
     1.2087304721648426`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387534975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130383977],

Cell["Plot a random graph on 10 nodes:", "ExampleText",
 CellID->62113979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167329848],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1.52776065503148, 0.435819464128689}, {
   0.646837101690136, 1.36818149994117}, {0., 1.08967826438368}, {
   1.20242973510441, 1.67169707983484}, {1.07834868457873, 
   0.655652820710508}, {1.34036525976974, 1.20773646109371}, {
   0.672439615170161, 0.}, {2.1074649972814, 0.540998772798394}, {
   1.90615969364722, 1.3676219827894}, {0.574017255868274, 
   0.782824465733439}}, {
    {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 4}], LineBox[{1, 8}],
      LineBox[{1, 9}], LineBox[{1, 10}], LineBox[{2, 5}], LineBox[{2, 6}], 
     LineBox[{2, 7}], LineBox[{2, 10}], LineBox[{3, 2}], LineBox[{3, 4}], 
     LineBox[{3, 5}], LineBox[{3, 10}], LineBox[{4, 1}], LineBox[{4, 2}], 
     LineBox[{4, 5}], LineBox[{4, 8}], LineBox[{4, 9}], LineBox[{5, 1}], 
     LineBox[{5, 2}], LineBox[{5, 4}], LineBox[{5, 6}], LineBox[{5, 7}], 
     LineBox[{5, 8}], LineBox[{5, 9}], LineBox[{6, 1}], LineBox[{6, 2}], 
     LineBox[{6, 3}], LineBox[{6, 4}], LineBox[{6, 5}], LineBox[{6, 10}], 
     LineBox[{7, 1}], LineBox[{7, 2}], LineBox[{7, 3}], LineBox[{7, 8}], 
     LineBox[{8, 1}], LineBox[{8, 4}], LineBox[{8, 5}], LineBox[{8, 6}], 
     LineBox[{8, 7}], LineBox[{9, 1}], LineBox[{9, 2}], LineBox[{9, 4}], 
     LineBox[{9, 5}], LineBox[{9, 6}], LineBox[{9, 8}], LineBox[{9, 10}], 
     LineBox[{10, 1}], LineBox[{10, 3}], LineBox[{10, 4}], LineBox[{10, 5}], 
     LineBox[{10, 7}]}, 
    {RGBColor[0., 0., 0.7], PointBox[1], PointBox[2], PointBox[3], 
     PointBox[4], PointBox[5], PointBox[6], PointBox[7], PointBox[8], 
     PointBox[9], PointBox[10]}}],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59370361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57941970],

Cell["A random graph with 1% of possible edges filled in:", "ExampleText",
 CellID->11773221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246836684],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxFVHs01GkYHnfDTGaGMS5jbi7DUu61lc685LiztDSKkawoyq1aRLVskpBE
cqTQqu1EkS4ubfP74qTYopBbKpEICTk1lGnb6vz88Z3vPOd5v+d9n/d7v48b
Er1hmyyBQAj9uv7fW5hqbYwiFhDot4M8iomo9qH3isUj+qBxg310NaaPLr0+
8Ka5nIPjDkLU4K0IOUCNHMOOEgkW/Souo9HHDPynmZ1/mUiw1gnP2qABfcB6
SuzRbXX0KPuI08ywEVxZLZizaZZBViZc3+t6MsBBXyq4HW+xiQvzjBBzqaB3
hEE71DSLOUqD02IzmOAyb8pc7ktFdl82uXJTGNDO4HzLP0jqqVCJUofkq720
nPsaaHd3ftiYBxVS7cJr1hxUQjTS1QknRwb45z+1nlSexVRTUjljqXRgsPfk
ysTrIq37UqrzIh/cypIP1SUSEKOuMmtl+IyAtUel+1M5Ec3fHPBzDuMAPA5I
ChS+x/rea3w8dl4PggXNFSGkCWy0K5XyLpkCna4LBuZUOhqqNqIEOBHAgmWf
c5JCQi6vTY8Jt7HwfuWRVzq8CGACKi4wT27/hAVJhpYNeHOg8nhOv96o0g9/
6rB5w/f4xtnGSLv3TNyvtdXIiqd/6kCj2FSgHi+L1uXWBXaNaANtfNaCLdZF
nb0/h4ZYceFYeSPFeIyHmsNrJoN8DGGj80OWrlgOtfXlV8f1sPF6YrqvWW55
zgb+6QRZKxUqWnen3lvrkwHOy8Wo+z0L0gaLJMqDFG0FtCv42r4uERfnLfpH
VYc0eTg2dkxBB6c1IaIlfHKcpIqMxcEJPVQzqC7EFmXtZ7FK5M3IIpmCy5Oi
Eam3BDPTeJT1i3ufgLT+yS0+WRHN/co88659SW9aQS43+EyTIOae3je8xYJC
7F4tg/fjOyZC/TnuNyy2ggbFBEMwqJbnlQjpaJ9zGqbisOTnpuqMkaIaDT/v
0byoO9fChm02rxZCOjVQyfNoS5aVASR0ZjJ7/RVQ9SbJ8NUyVUir2ppZOslG
hLVTLw2vG+J61jRDOo/PBAg9Yl5+YRprus7bbb3LCOdJHjvVbGe+vifFbz4w
m1ubdrrrcOFD6QuJ0R9ExHfRik3J+yAoZIdLpBQJdvBSv82dGywo9fn4Nq5p
AbusLAqp3EGF59RRxlSfNjrL2qVXRtaAwZdKVunnVJD7YYfNti4soEQ+EpMf
66Brvqug8DQFPPhbfVe1q6GozA3UEakaZMnX2f3OI6HDK4Ty9kZ8vL64iSuu
lueNgHWR7OWQqflj3rTw+bNM/LC2KFQbHnCesi61qSB5rGr/ylwyNLSkC8x/
00NW5Fi3RNCAcn5UwuV5RVTMLC95E6YF3uS2AizwM3bPgUzaP6ALpZttaES+
LJr5d4Aeo6wPrL1tygqBNCT5cb8JixKnAY4MenJXq0E/kQMHxjhVau1c1GF4
K1+lmQOa48V54i005Hox86TXi6X6xcEcWuXuWcFIFuv7PGrz1mdosYEVYBG/
fZkewii2yUnDOvC6ThguslFEr8YLemoDiNA6HSY8XkRGJB4yCiw0xvVqsteb
NFQtA7eCkeWRXfLo8PZ9Lo71bKi0mJJNz2CjYsWFSpEDEaL/Wd78jMhG93NF
rW4cE8jyVLPLSF/E2k/P1e7wMcH1pgjr0GIxGQaUs9PvqsugSMaQJ4lFwvvb
6llVRr3ChOCcsPoKdid2gm7iGq/y05I/S/km1qphwcXEdfrF6QvYuMZ+kbSB
DtJzSUJVdxnklyPqP9S0FF9z9uiuikEueG2MuB3ZQkXaxBORJ5JNcX4gtflz
ia0Zju10lBJOxX/936pOpnnx9NGEQvdNf6Eu/PGyJikv9AmW7bciTZVKg+75
BadTlxnIbH4NTGnS4dPf4261IiqSZkfsu53DAbfYe3vHxjTRf+9rwxM=
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 24}, {1, 70}, {4, 9}, {7, 16}, {7, 49}, {8, 4}, {10, 48}, {
       10, 66}, {11, 25}, {13, 81}, {17, 21}, {18, 57}, {19, 23}, {20, 58}, {
       20, 61}, {23, 78}, {27, 78}, {28, 15}, {28, 60}, {32, 1}, {34, 78}, {
       37, 68}, {37, 99}, {39, 5}, {39, 38}, {39, 84}, {40, 17}, {40, 72}, {
       42, 76}, {43, 76}, {44, 43}, {45, 6}, {45, 64}, {47, 87}, {48, 32}, {
       48, 60}, {48, 93}, {49, 30}, {50, 67}, {52, 19}, {52, 70}, {52, 88}, {
       52, 97}, {54, 19}, {55, 49}, {55, 78}, {55, 93}, {56, 4}, {57, 18}, {
       57, 70}, {58, 15}, {58, 98}, {59, 13}, {59, 62}, {60, 82}, {65, 26}, {
       66, 59}, {66, 70}, {67, 58}, {68, 61}, {68, 86}, {69, 14}, {69, 70}, {
       69, 91}, {70, 78}, {71, 93}, {72, 90}, {73, 29}, {73, 82}, {74, 32}, {
       77, 60}, {78, 37}, {78, 68}, {79, 21}, {79, 61}, {79, 62}, {83, 67}, {
       84, 7}, {86, 4}, {90, 56}, {91, 68}, {93, 6}, {96, 73}, {98, 12}, {99, 
       12}, {100, 48}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxFVHs01GkYHnfDTGaGMS5jbi7DUu61lc685LiztDSKkawoyq1aRLVskpBE
cqTQqu1EkS4ubfP74qTYopBbKpEICTk1lGnb6vz88Z3vPOd5v+d9n/d7v48b
Er1hmyyBQAj9uv7fW5hqbYwiFhDot4M8iomo9qH3isUj+qBxg310NaaPLr0+
8Ka5nIPjDkLU4K0IOUCNHMOOEgkW/Souo9HHDPynmZ1/mUiw1gnP2qABfcB6
SuzRbXX0KPuI08ywEVxZLZizaZZBViZc3+t6MsBBXyq4HW+xiQvzjBBzqaB3
hEE71DSLOUqD02IzmOAyb8pc7ktFdl82uXJTGNDO4HzLP0jqqVCJUofkq720
nPsaaHd3ftiYBxVS7cJr1hxUQjTS1QknRwb45z+1nlSexVRTUjljqXRgsPfk
ysTrIq37UqrzIh/cypIP1SUSEKOuMmtl+IyAtUel+1M5Ec3fHPBzDuMAPA5I
ChS+x/rea3w8dl4PggXNFSGkCWy0K5XyLpkCna4LBuZUOhqqNqIEOBHAgmWf
c5JCQi6vTY8Jt7HwfuWRVzq8CGACKi4wT27/hAVJhpYNeHOg8nhOv96o0g9/
6rB5w/f4xtnGSLv3TNyvtdXIiqd/6kCj2FSgHi+L1uXWBXaNaANtfNaCLdZF
nb0/h4ZYceFYeSPFeIyHmsNrJoN8DGGj80OWrlgOtfXlV8f1sPF6YrqvWW55
zgb+6QRZKxUqWnen3lvrkwHOy8Wo+z0L0gaLJMqDFG0FtCv42r4uERfnLfpH
VYc0eTg2dkxBB6c1IaIlfHKcpIqMxcEJPVQzqC7EFmXtZ7FK5M3IIpmCy5Oi
Eam3BDPTeJT1i3ufgLT+yS0+WRHN/co88659SW9aQS43+EyTIOae3je8xYJC
7F4tg/fjOyZC/TnuNyy2ggbFBEMwqJbnlQjpaJ9zGqbisOTnpuqMkaIaDT/v
0byoO9fChm02rxZCOjVQyfNoS5aVASR0ZjJ7/RVQ9SbJ8NUyVUir2ppZOslG
hLVTLw2vG+J61jRDOo/PBAg9Yl5+YRprus7bbb3LCOdJHjvVbGe+vifFbz4w
m1ubdrrrcOFD6QuJ0R9ExHfRik3J+yAoZIdLpBQJdvBSv82dGywo9fn4Nq5p
AbusLAqp3EGF59RRxlSfNjrL2qVXRtaAwZdKVunnVJD7YYfNti4soEQ+EpMf
66Brvqug8DQFPPhbfVe1q6GozA3UEakaZMnX2f3OI6HDK4Ty9kZ8vL64iSuu
lueNgHWR7OWQqflj3rTw+bNM/LC2KFQbHnCesi61qSB5rGr/ylwyNLSkC8x/
00NW5Fi3RNCAcn5UwuV5RVTMLC95E6YF3uS2AizwM3bPgUzaP6ALpZttaES+
LJr5d4Aeo6wPrL1tygqBNCT5cb8JixKnAY4MenJXq0E/kQMHxjhVau1c1GF4
K1+lmQOa48V54i005Hox86TXi6X6xcEcWuXuWcFIFuv7PGrz1mdosYEVYBG/
fZkewii2yUnDOvC6ThguslFEr8YLemoDiNA6HSY8XkRGJB4yCiw0xvVqsteb
NFQtA7eCkeWRXfLo8PZ9Lo71bKi0mJJNz2CjYsWFSpEDEaL/Wd78jMhG93NF
rW4cE8jyVLPLSF/E2k/P1e7wMcH1pgjr0GIxGQaUs9PvqsugSMaQJ4lFwvvb
6llVRr3ChOCcsPoKdid2gm7iGq/y05I/S/km1qphwcXEdfrF6QvYuMZ+kbSB
DtJzSUJVdxnklyPqP9S0FF9z9uiuikEueG2MuB3ZQkXaxBORJ5JNcX4gtflz
ia0Zju10lBJOxX/936pOpnnx9NGEQvdNf6Eu/PGyJikv9AmW7bciTZVKg+75
BadTlxnIbH4NTGnS4dPf4261IiqSZkfsu53DAbfYe3vHxjTRf+9rwxM=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{418., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{422, 290},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568803849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20283967],

Cell["A graph describing a simple relation:", "ExampleText",
 CellID->1101626006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"2", "^", "i"}], ",", "21"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83927677],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.7709227141903507`, -1.770922714122615}, {
    2.097550398281226, -2.886099383252903}, {
    2.886099383241242, -2.8860993833237094`}, {
    3.2942823736324884`, -4.409459043115562}, {
    3.443687717716621, -3.443687717974324}, {
    3.6477792131463316`, -2.6820078881622824`}, {
    0.6010598936909091, -5.61157883049738}, {
    1.601059893690909, -5.611578830587173}, {
    2.273824897449191, -0.6010598936909091}, {
    1.3627397234677159`, -3.29428237378335}, {
    4.001276052191999, -4.001276052624939}, {
    4.40945904305142, -2.4779163930008554`}, {
    1.213334379664905, -1.2133343795220677`}, {
    1.7709227139900803`, -4.001276052324533}, {
    3.443687717916891, -2.328511048873365}, {
    4.409459042904812, -3.2942823741937124`}, {
    2.601059893690909, -5.611578830766759}, {
    0.6010598936909088, -2.2738248972238866`}, {
    2.477916392439634, -4.409459043005606}, {
    3.09019087871044, -2.1244195535010872`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 6}, {4, 5}, {5, 3}, {7, 8}, {9, 1}, {10, 
       2}, {11, 5}, {12, 6}, {13, 1}, {14, 2}, {15, 3}, {16, 5}, {17, 8}, {18,
        1}, {19, 2}, {20, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7709227141903507`, -1.770922714122615}, {
     2.097550398281226, -2.886099383252903}, {
     2.886099383241242, -2.8860993833237094`}, {
     3.2942823736324884`, -4.409459043115562}, {
     3.443687717716621, -3.443687717974324}, {
     3.6477792131463316`, -2.6820078881622824`}, {
     0.6010598936909091, -5.61157883049738}, {
     1.601059893690909, -5.611578830587173}, {
     2.273824897449191, -0.6010598936909091}, {
     1.3627397234677159`, -3.29428237378335}, {
     4.001276052191999, -4.001276052624939}, {
     4.40945904305142, -2.4779163930008554`}, {
     1.213334379664905, -1.2133343795220677`}, {
     1.7709227139900803`, -4.001276052324533}, {
     3.443687717916891, -2.328511048873365}, {
     4.409459042904812, -3.2942823741937124`}, {
     2.601059893690909, -5.611578830766759}, {
     0.6010598936909088, -2.2738248972238866`}, {
     2.477916392439634, -4.409459043005606}, {
     3.09019087871044, -2.1244195535010872`}}]& ],
  AspectRatio->Automatic,
  ImageSize->{233., Automatic},
  PlotRange->All]], "Output",
 ImageSize->{237, 299},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1008378237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27343426],

Cell["Draw the graph of a random permutation:", "ExampleText",
 CellID->15541839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"Range", "[", "20", "]"}], "\[Rule]", 
    RowBox[{"RandomSample", "[", 
     RowBox[{"Range", "[", "20", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263917851],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lntUU1cWxkNueATuNYEEFBREqFCKlVpwlFGbIyVMxfJQrMpLEXlaRYuK
CoIG1GJtQSyCyMLRVSpPqYqoYYB7xKLWKvLQqAXkMRGopEKRh5UBht6wzx8s
1l73nL2//f3O4mNe6M614Xwej3d56ufv399MbOe5v5Giq3+Mr2v6qpfV1mZo
g82rzD+XMlhbm6AUuoerP6jdNjdyly665+zQ9iG/nw0VtZZU7NFFBUyq+l3i
JLveunnV8q8nZSEtY0X5/21gjeIavgzX65eddDbOPDWnkfTvqpealhdTpP8M
pTFXby35uSHKtV8WOxZeGbdLF9s1zd0skDTKqmI/sVScm2T/qReoOneJQR6x
NWzwF3wcqp0jW+CeJM9y62dX/e7n5Fs2JDv4Q4TbzsdiPBL3xOHj202yBbdz
987tF2O4D/uGTd8/f3rjLkW7EG9v/6mmcOmQzHNQrd5cJCTnraJXvPJIm4G7
XfN16AuTMnvL9Esvo3Wxk6T7sfOUfx6JoWP/y+hl26JLgx/1SNGsqF7BnfpX
bN31epOH96TocF9xj0GLho1Pt7hadEaKegoEETe/fc0q5yyuWBkoRfYO7XZG
t/pZh0fvGSSbSlHGzyf5PzgNsDlvIl7yH0rQjVkmg4EfDrC618KGMr+WIMN4
P6+a8n72QYxb5y+eEnQ9N7G/et9rduGsIZ3k2RI0Xt2SI8IaNt2lziV13AQZ
V1jWjv70igW/YX/4vs7uRU+pcze5H2lpLT5tq2Z/ne5fJkuq7P6yi8wP2FIY
1O3USfSNFD2t06R2EP1ua3/L33Skg705vd+Kq3NScmw6yf6JzqOfatZ3EX/U
/b61uQZq4t/q3ZIfX0i7WfDXalNOWcGaXjZ4a1VP/XEzlGzuNq90B4N99BWv
Y3eYIcOqYe+H8Qw+G34+p8PXDNkkvQ4ZOMrgO8c/eWHtYob2Wvk9N05ncJ/3
f9jlM81QVrZPy8IsBluNvfh8xTtTtKXjnaM8l8Hr/0XlObaZou5eobPfOQaf
ueH6UIxN0YNcn7EN/2bwpOV55312UtS22ZurL6aptgYJpcjksAF3nm59V+6p
kaAKz7+4fou/sVq5+pEELXzixc2btTbXJvKqBCU4reH03D/gGllwWoLqQzWc
3pDWjSamByQof88bbp/Qo5bmyiAJCroo4/ZV5mjrANN0gyUCBt8d1p5vim35
zXSUxgeztf0qL3fdG+yjse9u7bxIcZJvYxeNHcu0ejyyFd7XWmj8VmeM05vg
rRrPU9EYV2j3GZHfHUlvpnGSXLuv+HvFwhNNNDZr1/oxUZ/M1TtjtH79UnaP
Oy+c1875aad+yvXriNX6fck/hZs3XqzlETJ5iNOzOkXLi3mg5vRWWGt5Lqls
4/Yp36flfSg1g9sX+NN3tl/Y0U4R/plR1o/SNBThX/qBeeeVUYrwn7yf6N/M
ExD+1u7xgQP6AsK/79v5pXqMgPDfddqlXCoWEP7rP4tPMDcWEP5R9AGuBv55
C5y588Afjdpy/YC/UrGfmwf89VoTOD3A3180k9ML/J3mWXH7AP+etdu4fYH/
y1vK1Ld7KcI/eK5e4NMoivCXBzOrrgVThP9gVWHDqXUU4d/4aWn9Xi+K8Ncb
4yVt/owi/BWDf8atkVOEf66stOxzd4rwP55wiauB/7rAN9x54H/lJJ/rB/yX
6pVx84B/X0kxpwf4n9kv4vQC/9oIA24f4G+4uIrb94iT16Gkqb/HjlkboqOC
+bij9fnJiiwGdYiVJWc1fHw5zmrs8kYGKa9Eh5XspLD5+9ddt72lUbM1z31m
K4Wz3fpkZxNpZHvrH0OODgJ8oOD+S4tBI2Tjf7ek0leA/Qe8z8/ZYoQWU6m2
2T4CvOgrzxqkMkRBT5qrn80X4Opu3TPFQYbobvCmi89UFFa4Rj+3mBAi/+5h
8R9Tet1jjWT2tUJkFaY3u0fNn84PIckr+B5zOC7scZ0Oue88cSymfqUO6V93
zOp5VzMPfzQ9/yNR0a2uIzyib0PnUOB7gTyif9uJimZeAI/sF23rcSJdwSP7
K28fXJZfzyP+NH0smS1epkP8K22+3Wxdo0P83eI938zPi09qyDc4D/kG/SDf
YB7kG+iBfAO9kG+wD+Qb+A35Bn5AvoFfkG/gJ+Qb+A35Bt8h3+A+5Bv0h3wD
vyHfQB/kG+iHfIP9IN9gf8g38AfyDfyDfAN/Id+gpr5Tfb8mawbhc1N/qSpl
vojwyyjsTcssFBG+qhOyJYcNxYT/REtAuuEiMXkf4/a2fY3uYvJ+9BMpezRV
g98WEQ5DIU5i8v58imN6O/TF5H0uatuzTHVBRN7vSMBReYOliLxv+P8Ivnvs
G06rnmDIfaNh3ZwbU3kG/fMS86gHNEPet4He+5pfq2miz+nZ7mNMJk30uyW7
TPx+iib7rbSoq9hfSZP9MyrHwr/TZ4g/xQ6n5H/tZoh/R+67TQhHGfKeXeX5
aPmxGfj/7uAdjQ==
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
         36, 37, 38, 39, 40, 41, 42, 43, 1}, {2, 44, 45, 46, 47, 48, 49, 50, 
        51, 52, 53, 54, 55, 56, 57, 58, 59, 3}, {3, 60, 61, 62, 63, 64, 65, 
        66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 2}, {4, 5}, {5, 20}, {6, 4}, {
        7, 6}, {8, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
         91, 9}, {9, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
        105, 106, 107, 8}, {10, 11}, {11, 13}, {12, 108, 109, 110, 111, 112, 
        113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
        127, 128, 129, 130, 12}, {13, 7}, {14, 15}, {15, 17}, {16, 131, 132, 
        133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 
        147, 148, 149, 150, 151, 152, 153, 16}, {17, 18}, {18, 14}, {19, 154, 
        155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 
        169, 170, 171, 172, 173, 174, 175, 176, 19}, {20, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "17"],
       Annotation[#, 17, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{5.237564093258365, -0.7638942394254882}, {
     5.737564093258365, -3.6528045305206365`}, {
     4.737564093258365, -3.6528045304308434`}, {
     2.679884190984258, -0.9690160102414831}, {
     2.6819871355564127`, -1.9682568480501261`}, {
     1.9705164798524684`, -0.26389423942548795`}, {
     0.9695307832477637, -0.26736893138586826`}, {
     5.737564093258365, -2.4583493849730624`}, {
     4.737564093258365, -2.4583493848832694`}, {
     0.975757987738103, -2.679913955914736}, {
     0.2667857102344747, -1.9761973516789757`}, {
     3.7097756144073886`, -2.2916827182764647`}, {
     0.26389423942548806`, -0.976878295639954}, {
     1.2925569390050262`, -4.207455670847477}, {
     0.29316381535851066`, -4.233518445617658}, {
     3.7097756144073886`, -0.7638942394254882}, {
     0.2638942394254882, -3.234133603766807}, {
     1.2638328026495982`, -3.2077024347657117`}, {
     3.7097756144073886`, -3.8194711971274407`}, {
     1.9768180908318924`, -2.6767076072025193`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421936992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Linguistic or Geographic Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->385106577],

Cell["Generate a network of \"nearby\" words in a dictionary:", "ExampleText",
 CellID->642816617],

Cell[BoxData[
 RowBox[{
  RowBox[{"words", "=", 
   RowBox[{"DictionaryLookup", "[", "\"\<wol*\>\"", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8901538],

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Thread", "[", 
        RowBox[{"#", "->", 
         RowBox[{"DeleteCases", "[", 
          RowBox[{
           RowBox[{"Nearest", "[", 
            RowBox[{"words", ",", "#", ",", "3"}], "]"}], ",", "#"}], "]"}]}],
         "]"}], ")"}], "&"}], ",", "words"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->550942384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"#2", ",", "#1", ",", 
        RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], "&"}], ")"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21495481],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{362, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98727803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->772935647],

Cell["\<\
A word graph, with edges between adjacent letters in a word: \
\>", "ExampleText",
 CellID->1625009677],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"Characters", "[", "\"\<Shakespeare\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"w", ",", 
       RowBox[{"-", "1"}]}], "]"}], "\[Rule]", 
     RowBox[{"Drop", "[", 
      RowBox[{"w", ",", "1"}], "]"}]}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1491815909],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172684830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61216903],

Cell["Show the adjacent countries in South America:", "ExampleText",
 CellID->216280258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"#", "->", 
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<BorderingCountries\>\""}], "]"}]}], "]"}], 
      "&"}], "/@", 
     RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]}], "]"}], ",", 
   
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170857758],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.6895891157838556, 0.5412211049429447}, {
    1.2898889373605307`, 0.6908771654966054}, {1.1242906658449248`, 
    1.699738916619459}, {1.4991893843172683`, 0.}, {0.6068917530313892, 
    1.0292934694661393`}, {0., 1.0952794444351666`}, {2.0753640391148487`, 
    0.8975976209557249}, {2.5625850771649885`, 1.7217397771581822`}, {
    0.09703356171844879, 2.448512672262741}, {1.2949194168581988`, 
    2.8190036783799752`}, {0.6148032772402418, 2.7903270178694646`}, {
    1.9425969238491374`, 2.4110171590847305`}, {3.0881862860352864`, 
    0.932417597136902}, {3.7290230177853494`, 2.148603775272479}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 1}, {2, 3}, {2, 
       4}, {2, 5}, {2, 7}, {3, 1}, {3, 2}, {3, 8}, {3, 9}, {3, 10}, {3, 5}, {
       3, 7}, {3, 11}, {3, 6}, {3, 12}, {4, 1}, {4, 2}, {4, 7}, {5, 1}, {5, 
       2}, {5, 3}, {6, 1}, {6, 3}, {7, 2}, {7, 3}, {7, 4}, {7, 8}, {7, 13}, {
       8, 3}, {8, 13}, {8, 14}, {8, 7}, {8, 12}, {9, 3}, {9, 11}, {10, 3}, {
       10, 11}, {10, 12}, {11, 3}, {11, 9}, {11, 10}, {12, 3}, {12, 8}, {12, 
       10}, {13, 8}, {13, 7}}]}, {InsetBox[
       FrameBox["\<\"Argentina\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"Bolivia\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"Brazil\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"Chile\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Paraguay\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"Uruguay\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Peru\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"Colombia\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"FrenchGuiana\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"Guyana\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"Suriname\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"Venezuela\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"Ecuador\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["\<\"Panama\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.6895891157838556, 0.5412211049429447}, {
     1.2898889373605307`, 0.6908771654966054}, {1.1242906658449248`, 
     1.699738916619459}, {1.4991893843172683`, 0.}, {0.6068917530313892, 
     1.0292934694661393`}, {0., 1.0952794444351666`}, {2.0753640391148487`, 
     0.8975976209557249}, {2.5625850771649885`, 1.7217397771581822`}, {
     0.09703356171844879, 2.448512672262741}, {1.2949194168581988`, 
     2.8190036783799752`}, {0.6148032772402418, 2.7903270178694646`}, {
     1.9425969238491374`, 2.4110171590847305`}, {3.0881862860352864`, 
     0.932417597136902}, {3.7290230177853494`, 2.148603775272479}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{304, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->205385925]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Number Properties",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->480580540],

Cell["Numbers that have a common divisor:", "ExampleText",
 CellID->1078389345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"m", ",", "n"}], "]"}], "\[Equal]", "1"}], ",", "0", ",", 
       "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1163732381],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.7206297558266304`, -2.868030251324204}, {
    2.251378482949244, -1.0485403824184472`}, {
    4.3389269320415025`, -2.185449241840873}, {
    2.523728789920516, -1.3979080208666423`}, {
    4.2499859094732475`, -0.13860456121857112`}, {
    3.1029738550955797`, -1.9798376656245795`}, {
    0.1386045612185712, -1.6569651899421227`}, {
    2.5588208202747786`, -0.8008631308518297}, {
    3.9276856049115385`, -2.590821128887062}, {
    3.079946729311441, -0.7567705029709542}, {
    0.1386045612185713, -2.868030251324204}, {
    3.099334143573696, -1.661941455268035}, {
    1.034110859870586, -2.868030251324204}, {
    1.941439866238645, -1.4838924702778589`}, {
    4.139456756126792, -1.3635339605351586`}, {
    2.417106347388823, -1.8425139715062362`}, {
    1.9296171585226007`, -2.868030251324204}, {
    3.395884451972294, -1.5605724373190786`}, {
    2.8251234571746155`, -2.868030251324204}, {
    3.267456875454739, -1.0226180453845584`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{2, 4}, {2, 6}, {2, 8}, {2, 10}, {2, 12}, {2, 14}, {2, 16}, {2,
        18}, {2, 20}, {3, 6}, {3, 9}, {3, 12}, {3, 15}, {3, 18}, {4, 6}, {4, 
       8}, {4, 10}, {4, 12}, {4, 14}, {4, 16}, {4, 18}, {4, 20}, {5, 10}, {5, 
       15}, {5, 20}, {6, 8}, {6, 9}, {6, 10}, {6, 12}, {6, 14}, {6, 15}, {6, 
       16}, {6, 18}, {6, 20}, {7, 14}, {8, 10}, {8, 12}, {8, 14}, {8, 16}, {8,
        18}, {8, 20}, {9, 12}, {9, 15}, {9, 18}, {10, 12}, {10, 14}, {10, 
       15}, {10, 16}, {10, 18}, {10, 20}, {12, 14}, {12, 15}, {12, 16}, {12, 
       18}, {12, 20}, {14, 16}, {14, 18}, {14, 20}, {15, 18}, {15, 20}, {16, 
       18}, {16, 20}, {18, 20}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.7206297558266304`, -2.868030251324204}, {
     2.251378482949244, -1.0485403824184472`}, {
     4.3389269320415025`, -2.185449241840873}, {
     2.523728789920516, -1.3979080208666423`}, {
     4.2499859094732475`, -0.13860456121857112`}, {
     3.1029738550955797`, -1.9798376656245795`}, {
     0.1386045612185712, -1.6569651899421227`}, {
     2.5588208202747786`, -0.8008631308518297}, {
     3.9276856049115385`, -2.590821128887062}, {
     3.079946729311441, -0.7567705029709542}, {
     0.1386045612185713, -2.868030251324204}, {
     3.099334143573696, -1.661941455268035}, {
     1.034110859870586, -2.868030251324204}, {
     1.941439866238645, -1.4838924702778589`}, {
     4.139456756126792, -1.3635339605351586`}, {
     2.417106347388823, -1.8425139715062362`}, {
     1.9296171585226007`, -2.868030251324204}, {
     3.395884451972294, -1.5605724373190786`}, {
     2.8251234571746155`, -2.868030251324204}, {
     3.267456875454739, -1.0226180453845584`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{268., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{272, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->273832524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313669608],

Cell["Numbers that have no common divisor:", "ExampleText",
 CellID->41676353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"m", ",", "n"}], "]"}], "\[Equal]", "1"}], ",", "1", ",", 
       "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529154504],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8928616023707678, 1.3334575104453756`}, {
    1.0905287329733213`, 2.0613154111445846`}, {0.4292183024327898, 
    1.1048947834820342`}, {0.6771504641359762, 2.020522220972709}, {
    1.2508179493909293`, 1.6299381446369199`}, {2.1211367851539777`, 
    0.61129685146357}, {1.4402537599967218`, 1.299863756372772}, {0., 
    1.0238643095247815`}, {0.5356934494723753, 0.7102812883470448}, {
    0.812415714485724, 0.}, {1.1634958578489707`, 0.7423673960827961}, {
    2.046891915909807, 1.8148534017034255`}, {0.9107151836091696, 
    0.9048606242737322}, {0.11802284113721029`, 0.4539272458731439}, {
    0.0779026558336623, 1.550602728166739}, {0.36379799780704436`, 
    1.8156210017278518`}, {1.1000155444842277`, 1.1552993270119145`}, {
    2.257989017405133, 1.2111712147691611`}, {1.3594280283839049`, 
    0.9613453644926615}, {1.3892795568673717`, 0.07380510501519155}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {2, 3}, {2, 5}, {2, 7}, {2, 9}, {2, 
       11}, {2, 13}, {2, 15}, {2, 17}, {2, 19}, {3, 4}, {3, 5}, {3, 7}, {3, 
       8}, {3, 10}, {3, 11}, {3, 13}, {3, 14}, {3, 16}, {3, 17}, {3, 19}, {3, 
       20}, {4, 5}, {4, 7}, {4, 9}, {4, 11}, {4, 13}, {4, 15}, {4, 17}, {4, 
       19}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {5, 11}, {5, 12}, {5, 13}, {5, 
       14}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {6, 7}, {6, 11}, {6, 13}, {6, 
       17}, {6, 19}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 
       15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {8, 9}, {8, 11}, {8, 
       13}, {8, 15}, {8, 17}, {8, 19}, {9, 10}, {9, 11}, {9, 13}, {9, 14}, {9,
        16}, {9, 17}, {9, 19}, {9, 20}, {10, 11}, {10, 13}, {10, 17}, {10, 
       19}, {11, 12}, {11, 13}, {11, 14}, {11, 15}, {11, 16}, {11, 17}, {11, 
       18}, {11, 19}, {11, 20}, {12, 13}, {12, 17}, {12, 19}, {13, 14}, {13, 
       15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {14, 15}, {14, 
       17}, {14, 19}, {15, 16}, {15, 17}, {15, 19}, {16, 17}, {16, 19}, {17, 
       18}, {17, 19}, {17, 20}, {18, 19}, {19, 20}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8928616023707678, 1.3334575104453756`}, {
     1.0905287329733213`, 2.0613154111445846`}, {0.4292183024327898, 
     1.1048947834820342`}, {0.6771504641359762, 2.020522220972709}, {
     1.2508179493909293`, 1.6299381446369199`}, {2.1211367851539777`, 
     0.61129685146357}, {1.4402537599967218`, 1.299863756372772}, {0., 
     1.0238643095247815`}, {0.5356934494723753, 0.7102812883470448}, {
     0.812415714485724, 0.}, {1.1634958578489707`, 0.7423673960827961}, {
     2.046891915909807, 1.8148534017034255`}, {0.9107151836091696, 
     0.9048606242737322}, {0.11802284113721029`, 0.4539272458731439}, {
     0.0779026558336623, 1.550602728166739}, {0.36379799780704436`, 
     1.8156210017278518`}, {1.1000155444842277`, 1.1552993270119145`}, {
     2.257989017405133, 1.2111712147691611`}, {1.3594280283839049`, 
     0.9613453644926615}, {1.3892795568673717`, 0.07380510501519155}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->218367560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47379447],

Cell["Link a number to another with a bit 1 inserted:", "ExampleText",
 CellID->770391204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"j", "->", 
         RowBox[{"FromDigits", "[", 
          RowBox[{
           RowBox[{"Insert", "[", 
            RowBox[{
             RowBox[{"IntegerDigits", "[", 
              RowBox[{"j", ",", "2"}], "]"}], ",", "1", ",", "i"}], "]"}], 
           ",", "2"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"IntegerDigits", "[", 
             RowBox[{"j", ",", "2"}], "]"}], "]"}], "+", "1"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", 
        RowBox[{
         RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245077623],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9VHk01AsbRvZtjBlj6aaRsQxqZn4zgyjehPJVfJYshygkuiUpIklaCEkl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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 5}, {2, 6}, {3, 4}, {4, 7}, {5, 14}, {5, 
       12}, {6, 12}, {6, 13}, {7, 15}, {8, 9}, {8, 10}, {8, 11}, {9, 28}, {9, 
       24}, {9, 21}, {10, 24}, {10, 25}, {10, 22}, {11, 21}, {11, 22}, {11, 
       23}, {12, 29}, {12, 26}, {13, 26}, {13, 27}, {14, 30}, {14, 29}, {15, 
       31}, {16, 17}, {16, 18}, {16, 19}, {16, 20}, {17, 56}, {17, 48}, {17, 
       42}, {17, 38}, {18, 48}, {18, 49}, {18, 43}, {18, 39}, {19, 42}, {19, 
       43}, {19, 44}, {19, 40}, {20, 38}, {20, 39}, {20, 40}, {20, 41}, {21, 
       57}, {21, 50}, {21, 45}, {22, 50}, {22, 51}, {22, 46}, {23, 45}, {23, 
       46}, {23, 47}, {24, 58}, {24, 52}, {24, 50}, {25, 52}, {25, 53}, {25, 
       51}, {26, 59}, {26, 54}, {27, 54}, {27, 55}, {28, 60}, {28, 58}, {28, 
       57}, {29, 61}, {29, 59}, {30, 62}, {30, 61}, {31, 63}, {32, 33}, {32, 
       34}, {32, 35}, {32, 36}, {32, 37}, {33, 112}, {33, 96}, {33, 84}, {33, 
       76}, {33, 71}, {34, 96}, {34, 97}, {34, 85}, {34, 77}, {34, 72}, {35, 
       84}, {35, 85}, {35, 86}, {35, 78}, {35, 73}, {36, 76}, {36, 77}, {36, 
       78}, {36, 79}, {36, 74}, {37, 71}, {37, 72}, {37, 73}, {37, 74}, {37, 
       75}, {38, 113}, {38, 98}, {38, 87}, {38, 80}, {39, 98}, {39, 99}, {39, 
       88}, {39, 81}, {40, 87}, {40, 88}, {40, 89}, {40, 82}, {41, 80}, {41, 
       81}, {41, 82}, {41, 83}, {42, 114}, {42, 100}, {42, 90}, {42, 87}, {43,
        100}, {43, 101}, {43, 91}, {43, 88}, {44, 90}, {44, 91}, {44, 92}, {
       44, 89}, {45, 115}, {45, 102}, {45, 93}, {46, 102}, {46, 103}, {46, 
       94}, {47, 93}, {47, 94}, {47, 95}, {48, 116}, {48, 104}, {48, 100}, {
       48, 98}, {49, 104}, {49, 105}, {49, 101}, {49, 99}, {50, 117}, {50, 
       106}, {50, 102}, {51, 106}, {51, 107}, {51, 103}, {52, 118}, {52, 
       108}, {52, 106}, {53, 108}, {53, 109}, {53, 107}, {54, 119}, {54, 
       110}, {55, 110}, {55, 111}, {56, 120}, {56, 116}, {56, 114}, {56, 
       113}, {57, 121}, {57, 117}, {57, 115}, {58, 122}, {58, 118}, {58, 
       117}, {59, 123}, {59, 119}, {60, 124}, {60, 122}, {60, 121}, {61, 
       125}, {61, 123}, {62, 126}, {62, 125}, {63, 127}, {64, 65}, {64, 66}, {
       64, 67}, {64, 68}, {64, 69}, {64, 70}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "126"],
       Annotation[#, 126, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "127"],
       Annotation[#, 127, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9VHk01AsbRvZtjBlj6aaRsQxqZn4zgyjehPJVfJYshygkuiUpIklaCEkl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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13209423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->364627306],

Cell["Link a number to another with a bit 0 inserted:", "ExampleText",
 CellID->831064643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"j", "->", 
         RowBox[{"FromDigits", "[", 
          RowBox[{
           RowBox[{"Insert", "[", 
            RowBox[{
             RowBox[{"IntegerDigits", "[", 
              RowBox[{"j", ",", "2"}], "]"}], ",", "0", ",", "i"}], "]"}], 
           ",", "2"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"IntegerDigits", "[", 
             RowBox[{"j", ",", "2"}], "]"}], "]"}], "+", "1"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", 
        RowBox[{
         RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476378441],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxcu3k81O33P25fxowxM2Ys2Y2xDDN2LeQkIlGyVqjsEikVokQUCZUKIUKL
CC3KWnOlPaSIspRWSWSnrN/Xzbv7c/9+f/U4j3O9ruuc5zlzzvMcjxQ9g+19
eLi4uJwFuLj++bfueKC9qR4bQnzIwwfcWYge0io3xvXbdNMt4oJMrgogRnDx
QWOY2H9kPKw2IS3IF5cpjHzaToO3Te93wxpldDYv18l2lRR4uvZn7FxPRwFd
6Ke9NwX4+izuPlpHR8fd7giacJGhkmfxPZlan1jcVxkIsnZ0bgxWQea3+0s7
rWngfHUtwzZABUn7fnvwLoAI293PmgRicr+5cX23AxmSxvkPiCYLIq/2jN+h
QaIg5up3s5OLH2m/vMNT4EiFtnJkI/aUD2m8O0hc70YG5Q3lciKHif97nwb5
yZSF90dPvpk5FKQANQXW3fu9GCiA/T78E680dJgXt0UkMZBQxNlPRxPIcPFx
UO4RTO7UzatL3C0AidcS9zlSuJG7Z1i73XIyTOGu4efduFHN4NJU/p8E0E9V
ey9eiUfaYWtDTHwEoftdv6ctdj/P3te8rSukYEuBqU/hSS4ks2SNS08pFSgN
NQyjSDwKd9sbqryDDA06YeN99uIofdndyGEdLQhc8shmnTseGVwRTLhRzoI3
U52BJsViCOezJ1bYgwU3WjdtiSQJoP6wZ/XtZ5lwZdb7Q+5uMaRYdMj0sbwm
sNN2pP14zf8//6UhSZK64D9XTq/tmn1KIK2vv/S3kCpK9a0S/yQrB7PlDZ7D
O1VRL9H6XdVqGgyKvV3emqeKaG9rjKXPzJo+ouT7WXz+w5ls7vbNOY4HY9PD
WzZen+KwK5JMA2b4YddZbvy2fUJoWPMFuvEKDynbNgWIB6miqOBEZtwSGuh/
Fa5l6ExxNkVt8zK3IsM9FeEjT/YII+nNHkf224hC/3XFK6Q3ZFRWu1GnSVMb
qo/3JR6vpqDBedV3Xi1s2Doh/fasvwj6qBqj1ELTAmn6gI7GEBlpRkmf//Bc
C8wOn7i34RQO2Rf4SsdFzpnGjz2s2yaoijoGVLlsxmVAs+Be1Ue935wJ30Lm
2mQpYLzxv+0yIIjcvpm0V1ygQgxv97rRCjKyqd//aqqfDZJ75tIVxmY5lu9f
rfbN0wR/St6KagccOsu14nCbtRawLmzwMQ7gQqW1ra9n9pJBPH1r088bkuiO
thlvR6M6TEWIbjFSo6A/4l4Pyk9rwOrWVWPCN3EoTXUw/9ZNDbC7x3t8rnKG
U3HNJn1ESAv0lAdY29zpqMr/wk5HKxYozgWfruRmoO8fyWL2U5rQe8PEuMNe
CaXxdtk1v2bC2P5Wdhqegey3uUi9nGVBYUeW+Io7yqjr0kE+UQoTfjv7jAxW
Kf8v/nIQWkBbiD/xq/rmR6Z00JTEVT9nqiKN/ZraKxQUwSKfj/TxiSpa3y5f
bRIiDdvun8gTXa6GGAv1YcjU+3hu+8eEEU67h6KrxXE+UCh9/lLsyihnht+j
LesAlh+apd9we3nRfPxutiuFDAdm/dOyjdTQlbktSW0MMlwv+14dLjrKeZ8T
eIPwTQTeFJ2VV6vjQ4UR+3maZwTgDu1a20iCGDpI4Nq8tkcbfOJdaoVKaEja
RyqKdFEbHjkI8IbOiKHakvv6xGYWCNjGvlQ6R0XLbC8d4bnKBnzJ+BFckxj6
4xutJXuMD67YJ/qG1Kqi3aGX17cIS4OYiNXEi8oRjj8t6mj8SRqIry9ufHSI
D0WLMaKMXckQfUFlfe0WElIUjk4YPqYNteI978b28SG2r+bTaCIL3jm9dgpq
IiJy6n2nhhkWGLOGaOm3+FGR3++e8zZEsFzmrSUlJYF0fc/Fjy9lAmPn+pbW
FVSECr8bmllqQkP5W1u+EiIqjlnn3GaoCWXl8g3OCjxod+CHFINkrB7HLLvU
+lAV1Y7xyYsYscDlYQ995rcyUusvPKFJ1gKXayo+/J6qyDwiJMhyhA1ZqkGs
/hUqaFf2XkK/kyaILb9cZOau8m+83pwq6rHC4jvEKrDPlVOAxTo/xJkKsLPT
5JKF0N1MNHyWB6Vksz5W6kiBXh3h7DZrDD9pftnbpdrw5uzTwhe3hjlcd7LW
ku1ZkFr6Ir5yDQ/SX12+0f05C8bup1rVhoxzFLx/E4IMqSDNFVPK5JZASw9u
l1qZpwGj1utKSV5iSG29Dnkwhgn35bh0U1fwI65zBCX2VybQ6eLb92aOcTSf
ZAfWdWtClLxCLUFDAX1IFl5j0MqE+EtLunmF6YgHHI7OP2SBE7/O0V0fFVF7
5mtjf30mVB/p4M37roi8fYn2YlFkuNBj1yyQJIPOQ/d2blCDhjab7PVfqKi6
U/MjzKqB/46211puYsiN0qXmfVAdthJ17xZv50VmeYQV+xI04Dop42vCS6z+
TWXIP+JoQW/C9k+hripo+BBx0kFFA+o+tpo8sVFBH18PcRdsVP8XzxvCv7dZ
HNWGkLgW4laiMjoSmEDJFNGClc8uu1/XV0Zsq0F7YR51SIHQlQ2iyog3W/ln
6XkGUPUX+yGfKB2TVeBAUJIZOV/zf3o6XNy12G95KpUW9DmZ9U278dqI5/A/
sircZTUsyIvn1WD+/mJ/42eqLOgLzyUv3Pfs20atps1seG4WHs0dwEIH013z
7oayYVYryPxOGAttYc+Zsk+yYUhl7Yf1SSxU9HXljgt5bLgu+LJ+7xUWGt7b
LFV/nQ3pGbFWgY9Y6CTu2dqZMjZYmU3owlcW+vFyq+V0ERsOz53XfMfLRivT
9FfK5LAh8IvSUwVFNvI+ur/MKJEN0lI5wVrL2aiGQ1mavZsN9VuG6jfZstF4
t93Z3/ZsWGO9MWD7Zjb6//ITNjqplyB2jPJ/+ucOjwM/j7P+/V4hxWt8TRfr
3/vXHLrk6/mM9e/7WeYR7rE1rH/tGxciuR65y/rX/jO5AiduV7H+9a+Dlbni
0yPWv/5rfO3w3vCW9S8+QgcP8T4bZP2LX61WfFgZ/v/w/SsvSbjuMWL3f+e/
Z1dcWLn6/+4bu9TJe5n1f+8tfehMixb/P3tsdfPOx09o/WtvdgKr7Hab1r/+
+DQk3llSofWvv+HfuZe0nNf6F48XN4+FPInW+hcvqd36tKwgrX/xzIluCTvj
ofX/w1vr33j81f+N19/v/8bz7/1/4/33/b/58Ne+v/ny1/6/+fTXv7/59tf/
v/n4F5+/+foXv7/5/Bffo/erdt/G+Ov66f1ZB7ex0Iui5jOKLZOmz11ENdfG
spDdAVd/SZdJU/6I5VsIl1goNiHxW2LahGksXsFejcNCIkfGhvsujpuiQq2o
oGYWWqd126T/+JipzQOS5sYuFurn1Nwa9Bs1bXvPbS2EyS8/3fplZD9iOvvo
7I2M1yzUJqyRL7Jt2HSra0XRu3sspMY3TO/PGzL10Xd/7J7PQjGdBkN8GkOm
ous/WbrF/OXbQ6Y5Gxb59q9KwwW9kpNJZvoyFlpZMrLwvWvEA5k0SRaKctNc
uD/Hx89oyawWciy9s/B+CCVRx/WHFnrbcH/Bvm1U2YyfH7TQ7xV3F+z/YEu4
m4/JNx0mF/zbGDPsdaxXC5l9SVrw39hg/mT9tBZ6qem+gM+6jq/xPTQWkjzb
soDfQSHS3SIjFhp4sYiv245ra8JcWWi9W2vBcl9eOHeiaAH/gqLSluwRHlhx
7s5CfMYC6JurT/FA+5n2hfgJ3Fcs57bkAe5ix4X4qpW1DFtL88BTau5C/F8c
ndU5RuCBjgDNhfyQu5y/IlGRB1JvJCzkz1j5uu0CTjyQ/Wpe+p/84pa3ysq4
xAOZ+XEL+bfMoSlcQIQXngfoLuTnx68dgudieOHesdcL+TuzOnBhnmlYmGe0
0L60Wdq2w3xgkPs/PY/wlYFxPpDLXPyeOHMy1tWNH8q+Ld7/RjLp/kAxPwgr
cy3kt91L/S87uvmhH398wT5mUnt/0Cg/kOoX7c/k4tW61sMP8XsX/TM/Vx4w
UsUPSlxOC/6XpN98vGw3PzzsWMQnWFJ1nYsoP1g8X8QvypgrsiqTDxyuLeLb
Sv1HxkOkethCfYl+ysDOE6BVPnCh/rAF/7mPAEaKVgv1Sbb8NvYeAYi4xoX6
NV3HjdlDgLW5Rxbq2+b+t5i9BDC0Hl+of/yNupg/BIjiW6yP7HvHMX8JsO+r
4kL9VHJIxvAgQCj5wkJ97ZMTwPDCg6X14EL9NU+ewvDEgwPLbqE+M1g7FuZF
84V5kY1udL7F4iECndRFvWpwAxYvERiRXvxePNQCiycOPJqyF+7fsHktFm8c
CKYuvt9ScBHLBxzQCzMW7Pv9bRrLFxzM/xhbsP/4nmYsn3BwfNWif91dCli+
4eBXecOC/6Edylg+4sC2w3IBn/LN/+QrDup/7lzA74rBP/ksAvdEFvG1tBLv
6nKjgdUSRqYuNt+mH6yK9KHS4K7UzzkpUEZJZn39hm+osMp0md0KbWVkEO9U
cCKHCnsoV4K6JJTRgU+U4pvhVOjqZT4e/q2ERNkSq2/5UGHduBV7olUJtW6R
OUrxo0LZJBdv5U0l9L7HZknVQSqYcnmHyZ9UQm9Facd6LlHhvVnd8MhuJbR2
8PhDzy4qnFVwwOVsxvg/TvNgtRwNYos82uetlVBwt51vli8NXpw9ctx8jRJy
sDl0YlUpDQy/DKxuXKeESA6zxQODNCj38fBRc1VCA/dLV7kyJCB0+EyW9F4l
dK2VU6RpKwFLeES1K08rIWF1iyZzDwl4HI8/kFSuhJ4rtooJYrLlmhNrGt4p
ocRha69wGwlwIfLCyWkl9MVc/PtKFQlwk/uWISKtjMbHdAjRv2hgZt22sUlH
GT1215nJvU4DifqZXSMYfu8zar2/e9OgoNVOZiWG78Xl0oXX8FLQeXe5gDKT
jpSGVW4WDUjCs3A932tEOmrvbqDEvpeEhp2xbOawMsrglTtmgsk681Ovcl8r
oz/0HXEf+iXhULgsVew2xq8itQW9RaQgN3HmxL50jI+9UVdtM5SCgXdc3Oei
ldHP1DPZfoFSkODZTv0ZrIxesly4LxVKQcTIh+/HfZXRDzuzjsLvUjBxfn4j
3kcZeeeWVfmoSMNcn9xQ4k5l1NRbt6nbXRr4jBsSMg8oo9HA3Q57kqUhq+TI
pH2KMmp2wlvjbkrDnzgrla2FymhaOz9+6xNpMFQ8Iin6RBm9ILzvJTRIgy/U
loV/U0b2YZzT1Q+k4adGjkk6Hx0xZY2nRQulgX1WdcZPkY58yzhjt6Kl4RXv
HxZxOR254VkbtNdLw0fDnNfjNnR06NXpsWcUaTj/c+PbL5voSN5uu8KqVikY
s3lvLY7Nk2WMpdp5aVKw7749j9lmOjLayi7jF6OAIan4028nOjqzp+KNymsy
TA+d37cH07tc8fFOSSVD+sDRxA+OdBT9ecrdZhMZ5n6+7DthRUczqo/H6Ng8
pyvpft/CgI7Uw/ZLusyTgNCpsXmdDB0tqfMv9ekhwfjdmpPL57H4DjlPDHSR
4IfC119j3cpoSX9NfdIXEjw2yjwdjTB8cZTDb/6QIDBf+XxPvjKKPCg+6CBH
BtVuxl7ScWXUa7I5sHQ9GZwTvWVK9imj5c5ZnXXxZOC8Hw4S8VNGNd8NU7of
kyHJqsNU1EMZmc+O7Z/no4BOjV+9pJcyckmj38evooCL2zJT4SBlhHPPi6CH
UkAsJmlweZQyamkMEHl7kQI9q/fPnTqnjOZ9+XAe9ylQ7xJan3BTGeVuDiO1
N1Bg51LBP/avsPd4wwM21FNAuiVyx/CgMhJDwynvqyjA+BputkmUjuwzh2Mv
ncfu48y3nFSno9zWvo2yt0lgsWSRrwQceLtj/QESxCgt8hm5Tama7lYk4JNb
5DspPKSOaGUSVOss8qG0uR/hKgQSyJ+/uNBP3g/OST4UIIHjT62FfnMp/rXs
YzESSLEX+ZahFEM7VoME4esX+Vjupku2NvYk2Ki4yNe6Z/yMY4+SgLdfb6Hf
pb4ciH2BSCCBX+R7VXF3/7Ov00JeOodPlJmSoV57UW/6na9lIoIM3HqLfJC+
7dkDrVIyDB1dvD/Ne033RCsZlrxYfN/3VuZw+SAZ8qoW7SNzB03c/UOGK5GL
fPB2YUya4ygWT5VFPui5bYvBny4y7Ly56L9D47vPMpVk8ExYxMf14JnLTCz+
p3Yv4hfCFX3PzZYMny0X8fUnHbqdf1UGFB13eHOwee1TcYiL8lEZuPxQNLBM
VwU9tq5LebFbBuoaE52UqCroTbyM4dedMhC3O052apyOKnYbL0WhMrDul/WI
7ls6uiW8O7TklAz0Ecxb6qrp6IhoOIm/Uga0qfrnDuTTkVbOjS0WfTIQECjo
9OUkHb23EL+7nC4LXudlVrDj6IjwfW2znqcsGCSUashE05F3h9AXk4uycP2a
b0Z/LB1VKh0S9OmQhf5ne9d7Yt9bKlvXjeHlgCdC36suj46q+ov8yvXlIO1q
k+KnKjpaTxctXLJBDv68Oqxk0EZHJjsMP0RukYPik/KuQ2N05OGgeXiJsxzk
V6melBVXQUFnDvevMpODwwKzK5GOCtrKFOrVVZADw+dlhPF1Kijzu+Oo1Igs
2O16lCTmoYLOZRv+7KmWBRatOqw6WAX9uF6kIBclC3GNygW8YSqIR3LvTI6p
LOw+f3bZ/lAVtC5KtF7wAw1Oy06BapkKwnNnTebO0CDeolZ2DKkgu7N5n1+T
JeCg6qrA/FYVdPNhs0CqvAQkXGB9X9qvgr5PNZevUZIAuxoZ26u8DLRqNndD
k7QElD9S0m2RZiAVnWutR4UlQPBS/7rL2gwkc0vy0nKsn+EfkjNo5gxkG7Lt
qkYj1m+IBveNHRkoMWx18NAlGjQbp0s6bWegjY+sO3aH00CkFD40+jEQSSdm
1aO1NMguVeeyDWCgFe/rjGSX0EDbr9q3HNOfKf6JL/1FhRuth92Use87N7Ic
U55QIYKHlzruwEBLo8qu52H9uS8wzqN2NQPZr3SaiU6kAs3T/akxZt8WMVO2
3wEqXGvZtM4Ds3+V3qiXUggVDHt+b9fB/CMI/zHE7adC3TWh2Ec/VdBcZHv+
dAwVpiRncAYYPtanTK5syaDCDomqb6kYfgEr12VLVVBBj8z/pK1UBb168JGd
d1cUhn/vqBTfo4Ludx3Ys3qZKPyIU88sx+Tr7bbXLDkE6DjIGxoSoILWy21Z
HWlHgBWmdMZjVxXk6EU+OjaKh6KkmrnsNSrINyc5JqcMDzX+FbscNVXQ5Yke
7XfxeOgi0N6eF1VBPaTC95oYv0vcdoXXcZCOfq3VP6iRhodYzSnB2Fd0pKy/
KW1TPR4e7PGOki+no1Kx4m12SwjwWmLTqqksOkrdFOY/Fk0A06dXy3KO09HL
bPltj8YJUJR51HNZFB09pp+IswwRhZItrqNxEXR0//M+vvhfovBJbyP+PqYP
LbHYesqTCFwtI8dyE+mo5YF4/OQTIty6cPCd7wXs99fxe2khTgxslLxjP96h
o+mDRjI2dDHYpbGlLrKZjtQEHpx9yBID9fRKDe9hOpJ9FW/qpS4GEV5Z+bli
WD63OqvEiotBVw4OsVgqSGgiQ3fkMxEOCSof1rLCfj+bzjkYPyfBCXa40cgT
AaTOvHCkL58ElwIZNk0xAmgiJIhnK1ZPl/rpimtrCaCVuzLOLQkhQazM1q9B
jfwo+KFPrkIACTSkzNP2+fGjKAs5ubYgEqytoj2P4eJHzYK3LUQOkWDf7PFf
3Rf4kHDUPe7faSTonsaVXTTnQzJqHSaW1ST4tJOybMsfXmTIoAapfSPBSADP
jz4OLwp/+nyHH5UM55N9vdZk8SJfXMfe41ZkKJ/fwlmfzItU99Y3DUSSYa3C
N05NGi8yP3V+89B1MvRfXutJquBFt8W3m+PbyaDif97kSj8vigq9YTI7SwYN
i+xtVfp8yKQtHd5LUUBZKTQ+7QQf6no2ctKEifXDb9s+PennQ1Lvg08u06Fg
fGRd3ToHfsSOtIo9gumF9Cq3fqziRx8GZbK9pClAG9eQMV0igPo2Vkjdn8Pe
czAf8A0RQOn6SRWz2Pss/XHV99UC6EignqGpGQEkUtrTTSl8iOBtd3nzLB6o
kWlyX1/yolnPKRztOTZveKSFyRziRW+OCJrPXsXDz+WXhroVeVF/b7FhURYe
dhz+tjLrAQ+6zaP47c4lPBjs0D31ZzsPOiQmxHOjDg9qWW/PFvHxIIcPVz3p
Y3gIUHDdqHaTGwUQ/EVKDAmQ33ou8XAAN8q0Cp0gxhOA74FilKw+N+or+KHk
94kA7t+dXS6LcaPUesK03SpRiPfj3dPEzY3Sjo1WMvIx+YTHlIMQN/r+e1rF
cF4UPBKChD4rc6OURzt7px2IkECIPqLswI3y29gnXLOJcMVvf1XjGW5U8VY/
ofkNEd6F+3fe+8yNys5c7iyYIkL+rsef5Y15UGnyce5ZfjGo03OWzcniQfly
yz/N8YqBwL1ls2kzmD9dNmc//iJCFPFSuvMWXiRJ913d8YAIXicyBDfe4EWT
w5/qpWKJcLfoQfeWKV502Cl+tv2ROCzpuSWr18CL4nVEPswViAPpTm9zSRwv
UjcPNHt0QhxWav9MiNHmRU/eXGa6HBKH4tO84w9beNCJx/TmgAPiYB3ubzwe
woOGt5uPsqPFAR1+jHtG5kHVag177U+Lw6cRksH3Cm4URXm9b7YYuy/w+b0a
X24Uusmi8NtLcbjp140zxPBRTv7ovfm3OKh3SkxkD3Ehhc78m04MKrR9qZDw
ec2FzsZGr851psK5+rUW5KdcyMvrnuGHY1j95Qvi0Ju50LLqE8yacir4TsX+
Jo9woYyfq91m3lOhVTJ1lZ0Kdn9kx+o8Lmx+UnfDbd/BjY5akQ9NS9Ngr3/B
47FqbvTEIejyQyYN3F+UD0vSeNCNtR6grksDmcljlttDeZD81eDWLi0arIza
ViL3lgf5fQqup8jToKjNzSxfjxftU1d6fVSABoKuz24GxfOiKY7xqNc3rN7f
TP8TjOUvTWzDBQc1Csw7zl68pEBE2vaHbt53osDXk3aO5VQi8sryeWYVSwH7
lWmDPnJERGKc4G0vpcBhjy9j9suJyHmS+CqojQLVO/KZuv6Y7G+VrP+bAnv1
G573XCYik84O4VyyOGTpObqeHyKifDNax366ODzMkMgLVBJDe3duLOvRFIf7
h3jyPTeIoeVvQDCFKQ77eGsKZA6JIb8+6oNIBXHYkf4+9fA1MbTygoenLl4c
3r09oRbdLIZydDaJ5w1i9ll6866YEEN2V+0vSmL8OERcqQ9HIaERXp+BFQUU
MDYL08lWJaFe+qc7/RjfZi8N2T6jS0I9EbqbDNZi9WG/gOtlfRJilGc+05ah
QGmz+MlYTRLyfeTHGR4mA86H3jkhTUIujcZWAQ1kSBlm0l9ykZAr18lmxxKM
j+qFvzTpFkNm26pfy6eRIfQBd+LrCjG0zedTVxfGDxMacqW2JImhVdz/8EMa
VCYcWJjvj274hz/SwChx18L8H7HtH35JA9w564X9wJO8zRj/pMFsXNPC/kAy
NRrjpxifkTu6sF9YnrIT4680KHsxubB/0OnJwPgt9n1s1sJ+4oalOcZ/aSC0
lb6wv3CZf4zxYxpsi8td2G+EOPNg/JkGG24NL+w/XOIOYvyaBr8S7Rf2I7mv
b//n79VslMz8ifFzKsxtXtSfivLB+DsVrjgsft8klo/xeyoYzC3uvzlUOsb/
qcCuUl54P/11EzYfUMHpReaCfUInZrH5gQpmuEX73X70YvMFFQS94hb8UzEU
w+YPKtR0LO6/lzw/jc0nGH8RXMQnR/Kf+YUKdKVF/NRO/zPfUGGF7SK+KZne
1b7WCiB/yw3Xa8ZAqVf07x0wVAD9kOZjUkwG2pB7IUBWXQE28ZEuU4gMpJ17
vVFdWQGuyJXEZw2poIpvPsrzdAVwuXS4+8JrFRSseu7JYZYC5Go8aSCWq6CT
o0wi2VQBvFveGzWdV0Hba3oEipwUYNQnOC8uTgXZhlo6d+xWgORMTfuE/SrI
Qsxg088UBfh88lZWQ5AKKsiV7J4oUQCch2HiS0wOXRLUJ9CgAGllkXPJ2Pkx
ebabwXcFeFvVWJaM3Tf/eHfJi1kFkKZ1Ujux95z4Tt7cLKoI38sOVcti9iQo
y1xtk1CEXoeK6euYveGCcYqFUorw05f4oQjzR2DvYNUNiiJ8fZRlooT5i7hu
9dkJKILWhpj9DAyPPtEVk9tHFEAhhhQ1guGV8puyWrldAfyGXRL5nTA+e/Xl
GLtWAS7lbXdegfHRknBNlusFBbirrH3hgxcD1W7MPTaRLg2VfG8+PX3AQHKN
JSu+1UoD4eiRjKhmBmJ5qJ2LaZcGsb26jM89DCT9qPfmtn5p+NSsuGJwloEm
mnSzTo5Jg+ZkWXE0TRXFTuVpXxuWhg/Os1xb2aoo+2O44+sv0nB/ya85a0tV
NDcYT6usl4a0NwpbJNxV0amNf8ZOFkmDYrNQW0mwKurqgfy5GGkwkvuOU4pS
RRZ87SQhR2lYVbufXhuvitx8TdvGlKTBN+EbL0+SKrLp1aMZDEsBd7jgxnuJ
quiLTVriqgdSEHYjTGsuVhXJJZgRD56TAv7pvX7S4arIxemOM2m3FPh+SzG8
5qeKjC+/WvXeXgrOCIRVRjqoonLr6BUOplJgELk1OdVYFR0/+OvRTkMpSJWg
S5LoqkirZkImY6kUlNd687FFVJH7l87cWgsp2Pjj9Au1UQYqDWpi6LpLwfaS
6Qn2ewb6wNfi9PKQFKRlPJp2fcFALioxOTGiFCi6TP6WgckVmys9+NkUoMwB
Vwh23n3F+3Mea7D5/6vwz0DsvtWnvqwPcqCAnPKH1SHYe8bD3dVHsHp/e93T
SjvMHrJJuXu8DQVipQy1GzB7jXG3PQaWUmBg8k1ECeZPhUFsf8kSCuBrPj15
jfmbQrJDxhNk+JJZLLYMwyPb7siT/S/IsPnR9XfkOFVE6MzZdTSTDOt6Sg49
w/D8VVpAaPQnQ9PbrRV8GN7Zm/AXHhmRYfCKY3MFFo/DEcJbOoXJMNKRGSaJ
xev0FGrZ9IkEO60Hxy9i8Twk+2PYFJEgPVCVLYzF20NLwNugkAQX5AZDTbB8
6D218n5AJsZPG/rb7LF8UVBZbXsynQT+n4NtD2D59Bin4vk0lwThWYfv9GP5
VmBSHVd0Cztvoyz5DcvHGfODBVZNGL++tIwVj+UrbnRkzmCMBMd069+2Yvn8
hUlvj7TghzAHsVX94li/D1sfMcnLD3reIaencuY5aquHZqRa+MBYkGg7PjXH
aaGlL1l2hw/ytWaEcy3mOOFPPtrVFfPBlay4X3nxs5yTvN3b1Sv4YDNx+zjp
xQwnUJr/9ec2PqjVcPg8S53hWB9bmxogzA9ytRmhXPumOeIXx0842/DD6M7N
2m9/TnFuhzvQ92Xzg2lRYTZv3BTnl8qE++A4P7zlZdZFrpriWIqqFcc4CoBV
1cc9QapTnHtn7i6/clsA5Jw9vSWMpjiESreVr0UFYbDPaL4qeIqTI1R07KqH
IExTzx68+HKKE7BXq0GvUBBiPu7nN9swzflykiYt0S0ISVpW6gd+TnPaXhBx
t3iF4LfiEXxT1gznFHvonbm4EERMFdxtc5nlHItur+cTEwIx8h2ls7Q5jsBu
wkeVSUG48ChFpe/lHCdaY2b9uxeCsGuk4Idw+DyHmzXItzxZEGz2WzsP8nEh
WV31FZRrJHBvXpN9ehcXWvLj2vyHYyRQf/r+qY8aF/KdmEkwwuYXl0s8gk3X
5jl68uc0trqTwMrqrObmoTlOUoW+v9QmEryJeDxyUGuOo/or3LQY0xPv7RN6
GDDL0VlmM9CIfR9xA+26dXOGM3f3hktFPAnQvsfKm0VmOBX8SsNKRSRo8iFW
dRye5syYlp/3aCHBK7W1njjaNIdjJlKxi5sM8Iz7ALVlihMvMhEhrEuGRleL
S2bVGL7fJGRee5JBf7XJq2cNU5xqF3qu52lsPvJ8MckRnuakHTtfE1pDhlXd
BVGau6Y5I2ZJPnMfyLDV+UUyfXyaczSRnG48RYaZ0c05hIwZTl7VBlqXCAWI
p7+xB9fPcjgtO1S5KBQwu+Wa0yY2x1lnuW7zBiIFhuRm9S3fzHGWP/r5bZKL
AvWq+Tw3T85z2KZ2wSW9ZDj7MmzDmAwXwlumGVx8SgaSozqPrQ8XsjVMtK69
RgAeA5XPT5eKIvWWBPa+k9h88aqNPnRWFLUl8Cfe9yDAwHxRqMYPUXQy5ohP
gxIB7vmN8wXpEBH3Xbx7fis2v68kfYYAIuJy0jw1eggPPq+unOg/RUSn7J4t
G5PH5vfkGddzBURUrOFOYyARKPrzbp1zHhGlZH8iK3qJAPebvAHrRCJ64mT3
cwtBBHoDhqRTthER/0xX4FAdDhr63nhrKhPRlyM10yHxOIjTNxnAvRNFLp24
Z7XuOMDv0PvwMEYUXYMd9Y2WOLD5Ia0XQRdFROFe49trcGBZmTVy5REB5bKK
CiO24KBoy26rz74E9G4sa63OERyU6A0oFBMJyOmScclgDQ6kwgOn2A/x6AUx
mzzMJwIijF+nlxzFI7FvZT53NmP2evR89NuER0uIvQaad0XgsHjx2WWmeGTN
vp7RQ8WDXPxPzuPleLQ2KeyM7T48SHnRhFevw6OfD0XGaZcEQJA/DSVh/fNO
D+WskLoA/BBQdni9jYFk8eQrqXf4IbMj7VSiIwPtKTj3Y9qOH7JKInx2Yf05
t4LBzuLmB/LOV7MXNRhIoltNfE8DH7j473TNF2Wg6eHo9W/L+cAx+6aSIdb/
8xR4cq1r+cDHUJduifGDNInSZvvPfHDX3WzXs9sq6IJUj1MinR8eX77Ufg7j
F9rPXbofRfEDNF7EO2P8w/DJqzr7n/xw5+Cmd9swfjJAaC1x8xKAywXEnEsY
f0kpn+S37xaA8i1jknmYXGW3dczTRRDW2r+KccLOh9eFBs09FISXV/edsMDu
u8WTvdpGTgjMP0gtjcbeS85aeSZruxBUj9sLl2H2SGyQPnP/mBDEoZRzTMze
sJEV87YpQjB/eZAh/Q+fIWp1N4UKQdIvrrvxmL9N3ZUGnFVCcMP9ottxDI/b
m6zk9o1g9e3IPQtXDK/pMXP8tauS4PDyYiiPzDzH4ZTgW8t4STiS03AOnZzj
vGDemrMOlgTpo3Ne5X2znPf1yj/ebpeEIB/BbKQ/y5mNPGuf6yYJOu8tatNC
Zzib9vd0vvGUhLt0/Vs2VdOcwbfMM5p7JaFwa0LVAP8053VZ0tkPSZJQTlC+
L+IzxcmsZabfKJUEmcNPjzt/+MOp51k+zPdWEoxC73BMwv9wnGNOuv7ilQJ1
Dyo93+gPZ6cSPtZSTwoc2KSR8/J/ODcOHLJs9JQC0gdX6XU6fziHmfx+y09J
gdTMqNH7nX84W0+cXu1VhfGPpd97Yhv+cFzkanbZdUmBXW/e3MX1Uxy5fU4V
zpNSoD9FJ8xi/WPFWHQqU1gaiIM22ykXpjkRTzN6xsSkIdGYMR20eYZznqcl
1EFUGuKPJpEJkrOclGa53X7c0uBmYiff2jTLOT+U0f2yTwosN6Stngub41C+
eank1EtBvcnQjcNC85zH1GG3d740CKlRPGbIjUcqPZfvfztHg1WHb/6RHxBB
+ys+j3I/oUGM92pu3C8RpPHBZH3XGA2uTz7e/IMXj1Kz7bL1FCSw+B0+eUML
j7q8bYaGLSQgxzV63G0HHlHkzm1c4y0BklqEAGI5Hg2ub5epOSABXjJf77Jx
BJS6lWfe8qgEcDuntGf4EZAd62DJ1mMSYCdjRG54SkD6Soqc4YMS0BEobK7G
EEWmfcEb9++QAEfxzzNKUaLo4TOJkHYbCZD79cgnul4UpQfdPB2lJgHHRcYC
4nFEZNE2mkyfw/wRVTzPXkpEQy2O9NYmGlgT7kassSeiR5LpbS9ysfmpt7cw
0YWI7GlnQp120+AWXm11jSURlc7vLr63GpvfY11Es7B6VvJEs0lNhgautv7U
7/2iSMd8NipqmgoHB9HKVVdE0TZTa/rGL1S4kGbzgeggio4fW53+4g0VLKJv
tThMEhDt5o2THSwKxHS+8hqRFUfX08diHrtRwOFUEvstTRxJh/3qop+gwPvu
gj91UuLo9op72S8rKPCpU7crlSGO7vRlqZd8pMCtMaMnJcbi6MFKtPIdrzi8
/WBxUcRVHJXfrLldLC8OG3D5uauixVEqS1myU1cc1sNp/TNF4ihr9QqjGGNx
2GqS9FzgnThKn13/QgOTf45GuR4SoKIem572Th1xcF3Ofl2vR0XttmnJRDlx
MI4Q/vLGnYqo9OLAW9zicL75jXv+ESp6ecrJUeIDBQjH41IPXqSiq0nGV7+X
U+B+CqNz7g4VBT7x2EtMoEDS7+emanVU9NP2aOSVzRQ4rhq3z+8RFU2mbjd8
y6SA2rf1eXm1VPSLHvzrEdYP9fpr8/WKqUiOscMopIMMUx7J5QOnqGhH1pm+
wmoy7Mj+WiUcTEVSAY3PvuaTwa5rdbqMJRVVv895sOosGWS6V9nyLsHe2xuy
siFCCw5sPFVSW0lAT+PJBm+PaYG4e2emIZcoSg770vUtRQtWTq47r2onig77
nEEXUrXg/JNj6qKXRdF9XgfF1tNacPNAo5zOtCiKaoypP5ukBWe3Gwc+X4/1
x7qe2xKxWpD9uClZM5uIqi++8Hi2Xwsa3xFujncTkWjZlJmxjxZEbcz9fk5E
DGG8WE7LXgtmJu4cuykvhnqe6gzsNtGC9cSa8Z1MMTTd8yFiSFULGryOJaxi
iaHUcRutC2QtUB6VCyKriaEttKfBvnOawOv4R4wuJYb4drbosvs14aX0Eaoc
jxi6nO32+2GXJsTtWNPP/4yI4hxud75+pQkROpnea6OJKClHcurDM014NnNy
nKlNRK988afNH2vC5cxgkk6nKCqz8BdnPtEE5WXs5+Sjoih0wtA/oV4T5DL1
xtN1RJGanp69QqsmnJLMeLnjKwGpPh2Vjf+sCfRmwda+iwTEbZIdwTXNgr37
DF2e+ZJQhLHRxsf8bJAa2Rd0P5GEGvVuJWbi2XA/u0502y0SGv9SJ25AZMP+
M7kdE50kZHFvg2M4gQ2FNZ7vavnJqHOgcluYIBsyGjooPVpkJM6lrLVvlgVL
Iis2VNljevzDe12DLIgjO4znhZCRSt4anzXdLMgTbdqzKomMnncaePg1sKDe
6/6qqBwy4rysFCBWskCVJSZwqpCMNiuUdskUsGC29JCsUBEZDTxs5Q1LYcFm
HLd3Wz4ZDfnvd+aKZAHticbXtWfIKEb0T3HKDhZEVFSFEA6SkcjLY8WftrBg
hXP1ZoWtZCTvsSU1cwMLlptUe9UvJ6MLSWusDKxYEB8WzEmlkNGUn5corwUL
2hM7nVX6SOjYHyce1TUswC8ftbNGJLTbNCb77DoWJBKmEhrTSWhHUNkyMScW
3N7Fat4ZQkJG/dZFOp4syJ/N/MjZSELBn92Ojj9kwS9UU3LsGR+6PllY093C
gic7bcsvXOBDRw9UU7O/saBOJt59TTQfmjTW+rj3NwuU5u/9KN3Dh05zt85f
EmHDN8/2wqAQPjR1yfLBDjk2fG7vG4g4wofI87saubTZ0BBjulUnjw9tUWEP
l5uyQWKmJsOxEfv+1IzfVxs2sOx+D8ny8yOzXxZbBV3Y8OjBRPX6NfyocE+B
/x13NhzxnQ2wTOFH9mZRFde2s6E6xi1LqYMfLd31vfPxNja0PX34qZkhgFwD
JbkprmzQWv8GzPYIIP7K+eQH9mzQdRUY2XNXAAlHXtFVtWSDuH8gnB8VQFZH
D++vWYrp8QcNzRiCKGoH/StZjQ3XZYInPW0EUYItXqqdyoZVDBlOiLcgOrHx
VctzHjZkGo2VHQgSROUh8juvYfmzTsmlQdpPEIWJGvQYv2fB2LXD5ekbMX2V
PtEMy5/HTZE8L7UE0VHv2J4L3UzY5pUfHKxEQs6/d/bv+8kEr9f1OjssSCgk
eoln0CgTXL9G+h4LJKHZsjId9iQT1jB5X9DSSKg9o6X11AQTuN1D+Tdg8R72
zqafH2bCVCZvrNsPEsqPm+E93MuErO9bUg8QyWgExESudjLBZOepOS4dMgpL
3aeRW8+E3qUCJtE2ZETKuXxCsooJo54BgU+3k9GhrTI/uy8x4SeFZ+9EIBlp
v7jx4M1JJpD7LIuP7cbyPXIgpzuCCUdOjN6220lGp5VG5Hp9sftLtJRT3Mlo
jPyu74UjE9jjDNxbSzJSoErq2lkwYftAovcSJhlRdxgJKC9jguYu19oMITKa
ZZv8fq7NhL32t/Y1fMLwsE9em6fJhLmd3+29KklowyfXoTZMjsgVnWGkkBB5
W22Wvw5mv6a7Xp83CWluXd6ovJwJpNz62/tWklBpxkeBwjVMyNxVEBssQ0IX
jkrbrCllQqu62YnrjQIoICFb9WU2E8zercur/imAfuUNVWonMuHUx7WfLacF
UHrnnwTNMCYMeHXK38Hk1Rw34zhvJlzlfz892y+AKqhG9RP2WLxuylKrmgRQ
cGjIB6PVTOjcX8ZNviyAGj6/u9hrwITm/eGO93YJoE2Ne2xPMzE8LuSofWcJ
IM1YmXtZdCaMx4d/k+nlR0f91JgbFLH4CZ+X07vAj8wtjN0aMXnA0S1LbSM/
+hR425zEYIKtRVSpoCA/mvU1Mx7Uwu5/dEzi6QM+ZJPfXEvD8My7lnqdGceH
Es0rMqmWTLAumuG5bseH5L6vOefmwoTkbzNLXdT5kOOEAsliBxMuaW34zCHy
ob60qAcSB5mw9kTG4E8+PoTT2z5DweJ9rdjGwFqYD+0ePrMrLI8JK1otZktk
+JCfTe3Ho7eYEF0S8MpuJR+qm266d+oBE/rjqb4dgXz/239LQz4l8j/7b2lQ
pO7+z/5bGsbkbf6z/5aG78TX/9l/S8Oea8f+s/+WhvNOf/6z/8a+J1z4z/5b
GkZ6Vf6z/5aGtcS8/+y/pWGZyeh/9t/S8I7q+J/999//r/R3/y0FvV8d/rP/
loJTH0b+s/+WAvnjF/+z/8b4ubnKf/bfUmDqlP2f/bcUaJ77/Z/9txQMDxz9
z/5bCi77vPrP/lsKFFLX/Wf/LQWiJcH/2X9Lgcq7iAV8byq4PbpgpQQaAvUB
8j8ZqDT8Lr1TRwnKCzRWcb1lIGPB3033FZTA8e5prp57DCT2SovHmaYEkp3+
l13zGOhFOzpqTlGCd5+DzZViGag2ZUV+tYQSnDpyeDfVh4FsCy/QQ5SVYF9g
8DxhLQNVcg+V3TJQgvX55KlH2gwk+kOP7G6rBC4d56IrZRkoWWD7zxl/Jehz
emErTmKgVvy1U93HlODioV/WuSIMdOXPyEPWZSV4sqvVqYzAQIOzQlmEOiV4
ad74R1mCgS7KNzfd6VQCjxMbdvmrMpDrTfPrZ4aUoEJfsvagCQPVuKGOrfNK
IGR5P5x/EwMZqbmfZQkqg0YIKHrsZ6BG+qXBeEye/n304YMzDFS97PQuHy5l
mIkQ9lp7k4HMC+ccjUaUwLPnx2bVBgbyD9eo63qvBCMe0r3lnxlon8aPP+ce
KUFWgB375Cg2fz/dcGfoqhIMVbzhKZlloFlW/HzzRTloQq/pV46rImfToBSb
V3KQZzaax5Whitxr1WvRpBzkr7mjG1Osil7l397HRZWHG28ND1IeqqJQym3T
IIY8OH8ZOLDjvSoisWp0xJjywHZtnSL8UUU7GZB+VUkerLZXrD0groYkarPS
iwjyIIHv6GSw1JAeIz3bbEAOpGybmovM1dDnW0Odyx/KQYrgJYUnzmrovRKj
v+e0HLTi+XXCvdRQxas7DdxucnDZUkKWEKCGnmdwG8TT5eDqmQcXVTHZ3HPJ
+uO/ZKH81jrzJ9j5w7ePsfjvyUJQgMae1S5qaGciFtdUWWBQm3fbWaghrg2H
i6f2yIJxTET2T8yeh5tOX85yk4WBrC9W9lQ15C6Tb/HCQRZ6DmQbDGL+pG24
fZh3kyzctb0TvuaDKhpNt40Q2SELJ+54837E8HiWlPFh6KgsZJQIDelcV0Uf
WCb60iWyUPdguOEEhmdt5p6nUrXYvCW75nbWY1XkxX2kMr6XBjqzZ7cWtaki
C63c9HIRCVAK4Q8P7VdFzRxiRaGyBDjvS/r0lF8NOYrYShLYEqAtr0DRV1RD
VhqeWSu1JKBt6q2Hroka6lpfJeciJwGeG89M6GxSQ2M3buA1eSUAZ3xl2Y3d
aqhOvWyn2Xsa3N96JGT9UTXEiL+ypKqUBva5VT7fzqohU3xGuEYEDU4q7Xt3
LgfDf2+veLwZDaIlvuJb89RQZKlR3k8cDZ7+7o/bh+mX2h1y29dGhWvq3VmX
sO+rw6MTxQqpELJCpHk4Tg31Tvju2nSEClV134eMsff9s8WU/f2oIFi0MbwU
iwffvLnPg01UmL4wJHTFWA2pUNZyGbpQQfvL0qorCmrIkLuJ1OVJhT3axbtW
Yf4/v2vZiI+kglb95j1zP1VRQ73Nq6AcKmjsfR5hieHH/yzxCF89Fb5abo1w
wPCN3pPLfdl+2jRrK3dJ7vAkZ05H3lP25ZSpu3DWEQWvSc7vmLFZwcApU11u
I39CzQTHtSDQVV1nylRhmvn2NPcER+GGo/BWhSnT8LSm7zdNxznyJ5bzhi2f
MtX7qqHQETXGYZt9T2BHTZkeY+qzA56NcmRFI78b906ZBsm8sgSVUU5xVG1w
2N5pUxVPyafWF0Y4WlKfs6SlZkyfbKTEqhiNcKgrM9dIvZ4xNfk4kfx0cpgT
XbO1MyZ11pTLzjbI4vMwJ9jLNW/AYc40S+PV4yJMf+ApT+W4yLzpAcWBTQOG
I5xPq09TC2/Om14KeDf+J3uE47myZWekHBcEXlW810Ef5STVea9MceCC428u
d4w9HeVcdWqjhO/nAoGVD+9swew/gmv5kXqEC87yUs+zMP9MlO+UrIjggvh3
ZAES5r/n4wfqHW5cYKZ5x+Vc9QTH4nvun04mFziL3xOq8Jzk1A8XHLdomTdd
KbSuby2Gb/a4mmtysAh04sP6Tgn+4Vx/Y/cyQkUEPj156JB68DfHeq1Izqt+
HLRV3VSabpnkWJR0Pg98hoPWyNsMB9okp0P15Q1GNQ5itn8i6NlOcKpXFBhV
1OHgwMUntGdHxjnZL5uDyj7h4FT4UxO7B2OceM45jSiqCCiaF58+Rx7j5OSY
bo5zFQGbgpc+wYdHOUf3Tw0Y3hCBaqtjDRuIo5zX9/D1NkQ8lKxTVvnydIQz
D+rmE3vxcDHzc86T6yMcCved3Uva8SAUcdt/M2eEk6twXyVnGQHeVy/tL5ob
4UwHCazKPkUAvY06U8f8Rjntczv6StsJMOefYZ07huFtvzpDmSQKGfI/DV/l
jHHmcCZjTH1RYHo56B9yH+fo3mfp86wShZaUN9u4VCc4XR/1xLiMRKGPeipM
dXiCI/DrpOZVmijw3Vv/q+LmJKeh0isx8xMBok0iAka3/uZUOGk6Hs8kQF3U
6hnq0G/O49tdROlWfphzWvH9bqMw+nyf74zafX7old3bbqeDQ37Cfj7hp/lh
zSspskkyDk3brfu2YSM/yG67dLmxC4fqc2uZo1zY+WOnyseXiCB+haKDBy7x
QR3U6EVZiiDRKKXJdOCDM28UmtnumCy0w9i7gxdMUwQ6Bl1FkISsmxY5jBe+
P9A793K1CDq1vUj2xhJeaOQtDRegiaDP2j5DXxt44M3jJ0r9b3AoMvVc+O0U
HnATps00xeKQ7712vTXePLD+iaZgCwOH9ARWCD3ZwANOlc2km3XCSMy2V26l
PQ+cK+bnj3UTRt/v5lin7OQBq9qLYQf/CCER5ZmiwEzsPNH529UcIaTb5hkW
2sUDUTs2zV6yE0IPBTJoG1i8cJXUuD2QIoSEeQYG6k/wgsOk+eclfYLIlV+4
RGOIFzbuv9bb2CaIZByR/QZnPmjf80kgqkMQmcegOoEqPlh7a4vWzJggmvP7
aM5XSoCoNcXkf+q5+bnsZ+xZAog+HQ6wxur91j/6KheweB7lsd+v+EgV1bV/
sRfeIgqHZmwiarB+4cAqdU3wFAWBJA/r7ClV9DTKt/minSj0n0oLM6Bh/c9Z
PNNeRRSssuvOzLDVUCl8yBb6QgDdyGKDmDVq6NzliytDkwnQN2yVGIPVd5U4
ngOe6gTYmbTUZsZbDWn+GjjrVYuHcL5sBdOdWL9T1N940gYPfxRkk4aw/sgN
yT+VP4rAQb7nw+LY+YcmbT2sQyKQds/dURSrx8LinOOG6iIwwUh8n4b1Y9HB
ZX19vTgo3exw4K6WGvKJpP76zMFB8nE16XKKGoppWzPnfwMHT74uDef9jfXD
TQTrLTU4OGLTa6fdpYq+f3kdJP0RB2aPf69/9kAVJf9awcqWEQGR52pvzYtU
0e6x8hdRQSJwx/rUxHiaKvqRaWW+8qUIEE3bcwcTVFGA0+odz09Soez7oSib
+N+cU3fckfhOKtwvueV/fWqSY+VU76exgQpNAQf2PrWb5JwKvmC6z4QKKa4y
PEtTJzgtsu6f3hpSoUil3/3Ss3GO05uS+aIVVLAsN8ldNTfGya7cTixbRwUp
H2XXDSZjnBrc8hBxXyq80NJ7nnpylKPmsWUq7jgVbKuTl7ybHeE06vOsNCin
QkG44N7okyOckNukzukvVECb3hsoWY9wuEVvHQyi0YD4GJcHOiOcLMkeoxkr
GnyONzSVWzPCWVe5v1DyAA1+H4k+cz1+hJO0b1TB4RINalf01Z8fGeFc/Fxg
GvmMBok36p9HxoxyXhI/rq/9QoN+8Uh7mtYYh7tMkvvOGA2UX5h1VPaPceK4
Gh2PT9HAqeWZetndcQ6vdGLlAKZPjrqkzome4IQ6xH/Q+EoDbQjYXwKTnKcf
zUWln9OgK/zs/IP+SQ5p8Kuy9GUaeJq3iq7B6jPzzS+FclcKwK/SCVIFDq31
GVCZCKFALb9/5LV3OCS2mTcTHaOAQ//+1Xo8Ioi4Q3CjfxqmD92Js9IVQV8z
B7745FGgOaRszNJPBMlVfF695SoFCozXZPvniqDdSqFDpEIKSCmdSH70TgQt
oYvcOVZAgSb3npKdJDy68CvuQ/d5ChRevzS31xKPePXdv+8+QYFfV39r4A7g
0QHdvMt3wymgIzK5MeYSHgWML6M4eFLAf89crMczPGp2nXojuBY7n24Uuu8L
Hv158rSsTIsC3tcc5prG8EjRci/diIT5d7Vr+v00HsFl7ZCzY2RIfFsU4PEb
jwqsnppz3pEh9d7FkPA+PPrVuce58D4ZjPTaPbOa8ahQtsFW5yoZRg5K5GXc
xKO5ToacyhkyREDejeQEPDq8RldTJ5YMWWbNSe834dHuCzYh3WFkKFB7V0Sn
49GkvsLb03vIcHXpRhyzXwQV/qlK/oT93l+7mODRUQqi/K407SSKwqsNvlLf
72Jyh5XK4a8EqL/blbb1KwVdG5U9NnWZAHnPw9U+iIij01bUb7tdsP7gn6ca
wBRHq15LX2uZwYNKVpd80CpxRNLrDC7LxEOLda96g404Ov/tzLlhAzy4oRr5
cUwe/hL5qbBFBB6u6hn5hp3Pf1sc9yhcBGoVZp9oaooj7zczpW+welBw/PHL
j3hxNCI92tvUh/2ed722PPuNgrQ+H6R/vI8DpmaFFVRS0PcaVcryQhzc9drt
w4ynIJx4YAMXJvPvfR7c4EhBhnq7tI2w891QX1+kTEGSPMIPOT9wMN2iPmgy
QUac5FmunWoiUJ+wt6TxJRmxjEhhlDARwKns73UsIyP9MbLuk9cisKo4Udb/
PBnl5ItGj+vhQfTmL5piChlFPXANvZ2Bh1ADoSdimHxQ09VmeAoPpJuJM0bY
eavW66s22WqDzHIHmnyEOOLpyGvabK8Nu9TtvwbniiO75/V5G520IfKj8QHa
M3G0OmOqXc5ZG3K+JhbbjYijBz7n0ysdtcHy3ZIuaxkqutc2s5m1URsEjl/Q
1jenotnljx2vrtOGu/etyuz9qWhsGN3bbq4Nb5dautPiqUh2J021eIU2uNfg
kjRyqegJXoj3u442tBOnz8WVUZFYQl9YtKo2XCu28guuoKINY9G3+mS0Yf6G
msOZu1RUC8l9mWRtSD1S++HPdSoKF3lgxyusDSH6l10IWVR0d5+BXAqXNvBu
aF5+NoaKdCOX/9YZZcMNnvCcQg8qSp1kDHzqZcPO66vmio2p6LLd8/U5n/9f
E18aT2X3va/BcBwynGOm4nB7znCfowGVZFGppIgyFZWUSkkZSqMhyZyERnnI
0GAqpNC9UhGNhkqKogElhGT2u//f583/5fVZa5977bWvvdd1vTkigM2tvcZs
Jfzxw+/Irc8iiEu29ZH5wUbPSMaY9hcRKEUNHhqj2HjW4nDil04R7Fa2fvs+
mY23FrsEZA6I4Pn+/LEtvmxcPVlwL3CKAXQ+jnult56NSj9vR7fT9Z5U2Kc8
k57vstqPP5poGMAnx9G59r8ZuG7pw8+UrgHE+psJjzxj4L8z1/9giAxAadU/
9ouKGeiT1nUna6EB7Bgsu3n0NgN3rGvawKH7OVB665EXMnDndWqb1FoDOLW0
vWnPJwaGVp0Z7qDP62r10sv6M6RxoY14kLubAZQ8zZJNtJLGd05R/doeBvDL
uJKlfFYa+V2Ljrd7GsB0W6+4M63SuOJjzeKIXXT/C8ZexxsyMWbTE7k/Ow3g
Q/mZL36RTHShXnjM2UGf1/z1ElEfmRgmvbhn01Z6v1llZ5f9I4P/LNW3z3Ex
gM1/1kQ47ZbB39rXa/fQ/PK3LZLtvCqD1bvmyf9daQANtRKm6ZUymH+pfGbR
EgMI50eMNX6UQW5PX4fqfLq+eJ+0hFYZbDOdXHaeS/cnae31lAYZnMpreZs1
ywCIBre/EcUy2F7dJ1asTPPRxj01nX5/VsH27Rw3EvKNFGYuiGehAVMg0PUi
wfdzpmpNEQtD1vmWjfiSQL05pcX4xMLnhjZxcIiEhV1Rt5Xp98TWr471+CAJ
7KYPL/qN2ZiQINMdeYAEu2jjieRtbAyUulhUu5OE+6HuYoxoNhrvLDdibCTh
GSmTvz+PjW9zP2yoXUXCry3qVsbP2bhhRtbr34YkvI+7y5BpZaPRWvE562aT
MDfeeOVEFxvXry1w+cEgwXnczSe0h42pD6sED/sF4Jombnm8g43UJ+3Sty0C
mJq1aCE0snFJmBr9BAugWy+6KIzmY7BJk96+MgF8CDI/v5e+vyF/amYG5wvg
TNg5gz2BbDSUMv3bnC0Aa6eiLYts2Dhfb8rKlgwBMK7apD/UYaNAKq3pWpYA
2uPtm8UHWVh98p2SVq4AjOatG5d9xsIxlyNdoyUCSMlNOvg8nYV1z/nLHlUJ
YH3GhzypEBZeCVnmWzZPCE13jWcnODCw32Hi/IulQrh6e0XcAgMGPvTcqum7
QQgVcvVHHFUYyPw7sGnEUwgL3R6U/ZRh4OYuwxdZh4VQdGTZSzcFBs6apuL6
IFoIChcMMkN1Gah5t7r/1BUhsC88PXJ+OQNFtzg5jreE8KB6y/61vgyUSHKM
v1giBK1uqbq3NxnIr5gSWv9QCI+vWbn+6WJg4ptg/YwqIYRLVrYrz5fGZc4D
yQ3VQtjzOdXL6zjtB5K8i1Y/FcLS2r6gqdXSeNCzU0r9kRDyA8a1OuWZeN9J
jPC7L4RyH8aBFfZMHPxbllSQS9d76s6tYzFM9DweuH1VqhBKj7jELilnot6Z
r54v4oTQve5pYeZnJo6feHb46zEhnK80LbEZZGLXVOnOpV5CWLNkh6PbOBNb
3++EbCchJC5Anag/TJQIH/34wlIIM1xLbPQ+MZEn9A/YZSQE0+BPSXKlTKyL
snGJ/zxm5mezs2j+GIFBjVpssdFRs7eSVZR6H4GpcVGF2w1GzcJrrmSYtRL4
btQhzyRmxOxckZxyTg2BoTWuDTEaI2b1d3w/VOYReOPl7sGNbcNmxwV2/fPP
Epj+ZOV5/rdhs1NtO32rfQn8tlna6zVnxOzmuPDdNgcC51d6S+27OGJ20I08
XG9C4KC/+4N75qNmt5tPyJfqEXjrnkvONrkxM8VJ8lOAEoHTzklxHg2OmeUl
3bGSlCGwUdFx7oXOcbMNI8WyU6QJfK2Zv6SvccJMYZKSPylHoE2DaZZC8aTZ
qSxL34WaBJaLKiRzForBnX75b04iAjepS4zF/z+/XhQ3WriCwL8+NiWLCsSA
W1iPL7YR+P2mXU1VhRgoDSc6dgQTqDrjSYxusRhM+N4246US2GZSN181WgxO
vl0VU1xG4F2zTScXrhADl7tMy2dvCPQQ5EpHv5s0s7/4Wqm5k8BE22kHW1w1
QRA0quvgMUgl9W8oq1ykCbsGHK8ONP+hVDNG/b/O0oSYA4mU6uI/lIJX9oOw
GZoQe8RXNuXUAKVVUuIXIqkJblOLv9tX9lOtpw5Qc5iawDtJTj0zvZ+ymtJR
v11NE045a+29T+vnC2vkhd5zNCHiV9m1xn9/U8f7/XVm22nCnrLUQ1qKND4y
5votUBMkYat+aFovlXw2+uqrTE3oXVaa5efUSz0eCynOf6sJ4pw6+0jjXmqN
3u1LhpJasCLSycTVvJfi7p63fpqRFswtbF3h699LvStmGjds0YICFz3e8tpe
KvBdE/dcmBaMu8ZWutr+phLKr/sfTtMC267oi/Fdvym3ttq+WcVa4LfUZPfq
lD7qR4DvoTOUFmTo7Dj2Y1M/1db5rNjhgRZsf/iykZw1QPmOzuwMvq0F7Psa
ZlkfBqjhX16qGZe14IDDEg+DiD/U+1Wzhl4d04L2G4/SNs0apH504ww9rjok
DsYKZ2+WxI/JUtNVXNRhYN5HCUszSWxP2z+8KUYdKJdHGhZGkvhkcYmaA6rD
v8vb70cuk8T5FxpObO9Vh+Foaz+PXZKYvSAqiK2hAUXNE0U/0yTxOWfzxNwl
GlDZW5RIdkviJeWcWQOOGvDl8LzQtSuksKqD3y3uqQEen2Pay65LYdjP+utp
uzWg6biW2l55et6aN/686K4BOafWxWsEMPDVjRy2k40G6G4/Nxn/hoH7TRd/
eztHA6q4Dbk/udLY26oVeZGpAX6LiLI33tK4Jf9XxfkWddDybauvSpXGtkAV
3uwcdTDTzo6eWy6Nev7Z3fcC1UFqqpjYvxXSmF21I0ZqhTpUR5a3P8uXxkjD
ZtMMFXUoJ6yWXzktjYPhsu/Hf6lBmGSnu661NJp/NBue/1wN9i7c+PzwBAMl
Py/4I16oBuvnJ/x7KZ2BCnWhRG6mGijbgbMIGFi3WInotVCGzPnBoY0HFdHZ
Uo/V7KsMX2NDrw/sVkS1+hth3pnKsCn3W+TaXbR+zHd4rdKoDP8kft83ekAR
VWzMRxwlVIB5PPrg8XBFvL24Ra5JqAKHw32+vMyg8Y5HJgk2KjAjvcJn+3NF
jIx4pdO8QwVMq5co2g4rIntxgCjKVwW+wyGZ1TwWbnVzuTfspwL/Ptlq0LKJ
hcyNV5Yre6kA7qm7fzSWhQEd2/y3OKiAmluGaWYZCzdVRCR9MVaBe+tzOyVo
Pf62IZ7LVVCB8UWPzieK0/p+82NpPdr/fQzWZedq0vMwOWqJ5h1lgBWcZQSX
jVPMNmSGBymD2c+zxq48Nu44Jqc6sFYZcpOZ5ktns7Hho7Jf62xlCKi2eOhC
6wPXR57uaUNKEDbf8lxBFwu/VgU4LmlUgse2PgH1T1g4Kszc5vhQCV4+K5Av
Ps9CSfPNs5SKlCA3qDDnqicLb5tKlK2m9e2K6n99fTNHqczFbYu6aL0XccXz
RLPdKMV6VOLkTes9fcevl+W0Rikpbn/inqW0/upq010pOUrd9BCzPErr949L
tM/tUxylTOfITp3rSOvz3Pj3M5aMUuKHgzjEFgNYUrVpzfrTo9S6xL3Kw7S+
m7oqXUO/e5S6tfz9BkdvAzAYv2+/0muMqttq2T52wAAyXCcXBY2MUZSCq0GJ
vwFs+u4x+SZxnGrz3y21J8AAdO3g4CujCcrM71qPPB03MMDlxW8nqMcTRpuL
9tP1Zk8P+eQ9SRlaPRYe20PnB/750jc0SXHnVSulbjcAsexws2RjMfSQa3Ly
dDWA6HC2pt0OMfT+eLKUR/uJR4fk5t09JYbhBf7vrK0M4AHrRdGeZDF8QXZP
GtHunUjqtUQaj+/2bV5vRNcX77U7N1wMna3P9cqRBmCzPf9Gm6cYhny4w39G
6+mv/pH78xeKoe0Wd11FoQAcZyoFwWYmHoviHTbXEkBR+vmGF8eYGGgtGFzK
FED+4WV3gmOZuMbMVvPlEB9CQppDC88wcQa/T//Cdz78blQytj3JxJoA8+qN
b/igpfGdU7uLiQOh+mMVT/iwz6pL39yCiaN2MeBVwocYlbsmpBwTrV5IHWrK
4UOCd8yXxDppXON+PPNwJh/OM+tUP8RKo+sWt5rEND4sXnzO/5qlNDY3igbt
aPz46a74yjEGlraHPC3M4IPRxfcXiUIGXjHLXnfhFh9qdtpaXdnHQLNCw52l
xXyYN32WXdMcBqZMTLgVPeLDQz2N3avGpTDOw2aKeD0fLLc4i4/US2HdKs8c
+a982Bh3PyPyrhRar5ZyIQf5kLG1/LIq/d6F9KdbZUgJ4LDbhY/zaTzwrENI
qQvgePX7VS10/i3j+Tue8AXw+l1gZXCDFDa7SM6UNRHA21LFwUn6e4NLTlG9
U0iIahB7sNFznPqpsvapYFgAsTPFCkbbxihDh4qED7S+zR44K+NsP0b1/Ts6
OrdPANT2a6d1HoxSPklzXiwdEMCLHi8XM+4oVVRxUWOYXm+0cLZXwsURysPO
RkVtGgnZZbL5j1RGKMbe5xtWyJEQIDIXG88YplqtuwOlZpIwOKvsBrVqmMq/
5KxUJSTp+8T4XCAxTHEWfI9/DyT0bP5WdvjTEBVSzG8/bU/CXyerPVlvhqgb
Jxc3quwggSM+4nOpc4gydl3oU0P7gWHx60XR6sNU0cIf+3+Fk/DPnhtRUTuG
qdDtsvuaE0mIXMRZkVQzTN06EWUm+y8JQYPc23ctRqilD9nJzOsklLp464hq
RijNC+eDwnNIWBLvcyl14yiFC+eetc8lIWJFjdLq36MUIaF+z/MmCdYar59Y
hI1RYqm7olqvkeBydgMrR2GcKj4coDntEp2vZPJl9Mw4ZZWuv6GGz4KUqKED
7j6qCB8t80JcWPD+4lPD6O2q6FrwRftQJAtUz3c80qWxXu7y0673WPAwT409
Z58q9nSmP+v7yoJFPzXuGoaqopoW4/RsJht4qpOPFqeqosmoRbkCjw3/io9d
a32sioa2S22tgA13mj/Pc+9RxaiBIyvvWbNhUXOzfaGWGvL89TqfrGVD5Bqn
yZQ1algfFS7uaMmGnwPjiW+OqqGu7yKjhnls8F57S4N9XQ3r2JGfZ6uyIcDH
QNbktRpW28qsiR9ggXj8mN+uXjV0yvO3b6phgcXYvkmWlDp+MF3qMXaZBSrD
ZL+KsjpCVulv3l4WdJ4+rFutpo4zzjvvKDBlwZCC6YIRRXV0L68YeCvPAkl3
fu3EFHUMqIu7VNGhCHUJW6Kz2tXwUlZO4ZYqRZDsuTVh/EQNC9w5G1bnKsKC
J8mk42U1DEw5dLU4RRGSz9VajHqr4UmVMnuTmTxY9/XBN5daFpZMa1RS4PPg
YL01404fC9c8f7tNNJ8HXEXeyauqbGy7GV8xZyEPZjMTvI+bs9Eh8MXEZxrv
Rb5njBcbN/qHxhga8eBl9/TBsXNs7Dwo9slRyIONFh9OTC9jo1KY5b8pOjw4
nF/y608LG0mHT9OjWDzg2Gw1sB1j48/TpuSjKTz4OnG6/pWiEq41GmAwu7lw
wIn/46i2EjoHJrSbvOeCq/75+0X6StjxVF3J5DEX1NdeLDTUU0JjI7Z4bx6N
faZuV1VXwpghLcdFV7iQcUHOslFCCdM8bxp3RHNBtLEqcBXtV/f4ygflnOCC
hLRD9pln9Pdz04c0Argws1XZUzmTjRPOlopXfLjA6FG6c/AYvR/lwE1793GB
OVeZ52fPxsZ5U35cOMCFb51TKpvo+WtxqhEnA7mwkqXa4z+VjVaulzauCePC
3Lm++LeFhcMYMVFowANL5YdH3fOZ+C4i6GefFt2/2q0zzN8xsTvvqEcSgwdX
iwS/K38x8ebfzceCBriguGOTYLSPznc0XH3xExeomDULr32n/VnArfqaZ1z4
8cbjhFU1E6UvurB+3eOCc6uJz9zLTJx7XCKi8gYXLAYNwtZuZeK8B2G5Eylc
mAJG97gaTBQE+5SrJHNB/vfLPc+eS+OqxktyuxK40POq/0dioDQW+Yc6a5zj
wqy5w2LaetIof2B9B3GBC0mlfywV6xkYOU3yr30aF17fvvNq4BQDi32alE3p
/ieLPx9XWMZAQdy5M/YUF44eaBWukWXgzB3qsd9qudB1JfnltG9S6CGx9Kne
dy4co0Rz+59L4Ttiqsf8US6oODxx1auUQrmv3Zf/kefBiZzS8G+vpbC7x7pO
XZcHq9I2vC/rksJpscfChTTfyjXdzhxUZeCBvpWdl5bzIKRbf9VcOwaaw409
Z9fwQP6V69pC6UnKpjBbFLmYB72cuKC8jZNU1NB49msuD5Ru4s8TcZOUdUMQ
h6/Mgzmqr65OuzZJLRlMSt05lQcfD64LcD8/SZVeV7N37uHC3qMzhpT3TlJh
vGzZymYuSLt0rOvkTFLPjAomPF/SfLnkHvuRmqCeZlgptD7kgsbCxPczlk9Q
R+31lhaVcCGu+qdWbMk4Raq+MVx+hws5f99V6MwepxrlbsyvKeDCE0HSA8WQ
Maq0c+p7+0IuXMqbeuzT11Hq7pfe7VX3uVCV1Gs/xWaU0jX63fqZ5v+NnsWO
6ZX0/IjjfDGs48LJJ+0u7utGKDGL0N6FbVx4VTn6SmFgmArwGV+1jOaTn67r
z9O3hyn/FYFNSZI82NZhITwcN0yF6V6T3qHBg46k0hGH6GHqozFLp5W+v5kT
uZvh+jB1MdynZZE5DwzZMWXi34apnCrR94J1PDBrnbSaYzpCDXmUVXxUIWHn
n+Kq4SoOOsuNNv9UJ8EpmJ+zq4SDZ7J3EU2zSZjRkvzlznUO3lr+e/9+Lgmi
GX8q3C7T8ZQhq23zSVB1OTLj6xkOyuf3lq02J6Ei4tLlW+Ec/HFs7rdCGxKe
roy8IBPMweWjl/U1NpPw6HvYKTjGwaNpkZ9/e5NwjLlUwesoB82iTXdlHyfh
1HejdwnHOeh+rwfyYkhQX8WcnRXKwYqrO/jH6PlT//pufEAUB5NrVyqfy6Lr
d6p/dz+Rg+ObTpwPKyBBL3WaSDmNg76pcW2DJSQ8qVpTrpLPweL4gdH0chLy
1ErPm1EcnLK4VeROkXAlOsZx2isO7l+wIkH7AQkp8o5i9S0c/Ge2cdKveyQ8
kPogmNlN56/0utR1mwTjwFoD5zEOdlcUX3Cj5+uliRNKUxm6OGNNU/3FKyTs
fp+5OIOli7nCpFKZMyR85+4OatXQxYSB8ljZWiF02wff+PlOD7mpZhfzWoWQ
GjSaHNWgh3ZqW+yy+4Rg61RhtofGM8z7tjlME0F2z9NnsXR+u727uQZLBHfb
XPe9adbDaXZN4lu1RXAo2ztkerseVvcqS6SSIrjVcKHkcZ8eHp8n3rTNWATs
X1M2Z4oR2KximWezRARi7+VD9OQJTICQUm0LEQQZU/W5swlcG1+TU0Tj/T3P
ORlzCDyu90JSAkRwQ/KXoacFgUdNZO0Ei0QQVbXrwQY7AoeLSO6WOSJwOuBk
/X4LgTLW68g/eiKQMeJ0eu4l0MZ6TrujqgjcU/4YRx4kcHzGPmQwRFB/y/nr
p+MEku+9DS8PCeHm9q+GnFAaB+zyvtkuhKDq35n8kwT6z5rh2/hWSPvPhu09
wQRyQ+pEjyqFUKMguB16lMDL45Vh00uE8CS5U1HTj8CvS7Ze+eemEB5Yndwj
tYtA7+xvD2ZKknDWd5Xe9MfaWFBl2m8qTcJaRpa+5x1tlPXbyT4mT/Ovq0Ly
dro26n/9+T1VjYRvPmZ3AxO1UbXlFWWnR/PdoUpmeYQ2drTvvc+ZR4LKxkNP
wk9oY9CHv/VnLEjYor/bJOWQNv7pf/hEktZzRcTQcLWfNraFW/t0bSPhodYS
WxGNNynnpKf4kXCz5flQfYA2VnYEzQg6ScJ4neOXlKPaOG8WoTFyltZXfm46
zmHaiHKpoaFXSfCaOX0g74w26i5a6plB8+2B57M64xRtLPn1u2Ayn4Ty35z9
PjnaeOX5Pzeti0ho65Q4XF2ujTJrNaO2FZNg2hvfmfVSG79u2D2+sJAE8dru
Gq9P2rh/lmzoV1r/NfQq6QX0aOPj2915iZkkzJ1i2iKc0EbHo7arL9P3zWa6
pps0UwePFdV4bIklQTL68r1YJR3c3BsbuPkEvb+kn0ZOWjoY0hr0V1NXALsq
B0vY9Hld9vVOjhYIQLaB69cSR2D+zQCL8TkCUIjodxNLJVDsrRrXZL4AlB69
aPicT2Bm9NXfBvMEMKgSpP7pIYFb+HtDO2j/tKDrm5NzHYEjc+5kR+oLIDJu
WdrtVgLlvvVHuNJ+avPY+6dOPQTu/PVWoUJeQOtd6VfVIzR/Q/XsDKYKoGf/
1vLz0/Rx/ePlMvP6+KAX6py/n6GPoQ1UuHsrH3z/rv6rKaOPbRsG291e82F5
dx0RzNRHS1cJ4xqKD9y9n6WvSerjz+9Rbhb5fAiMj9h3Q0wfY00KV2yk/VJ3
RELF20EC/TziXS4k8eHEwLOLp34QOHhFOX5PDB8OdhQtFn0ksMs7y1oQzof4
Q4Wmzs8JDBz6psQ+yQdzkdm+S6UEpukVbzen8SVGmEXiDQKzLsVE36bzbyT+
et9xgUBBWnCFZSwfrOUGxQwjCZwfvnWzipgImlfO8KEIDlal5wxMmSqCsL45
Wa+UONhre1ZJV1IEJ+4X18SKczAi8sYbazkRTLs88TB5UAcvXxjZL1QXgemZ
EUFgpw4aTMgYbdUXgd6PFnZ+iw6O7bB18jQSwWHnwGXpb3XQZdrP7AJLETTV
hvldrdXBnIKt3685isBX54hPwysd1Jq5POzqThGwpkjZ2NPx9uyXdyYPieBq
reErWXr9oXyNLdzT9HvkYv75bbMO7vl+WTI6UQT2Beo2Hh062HbOWTU7VQTd
knER6/7oYMx9zGddF0Hl1aebONM5mB/3+MzxXBFs/OYfZc3moINSnnJRvgi2
2bXKzdOj47uM+Gl5IhiSa35naMTBAKUT0rY3RVC78OOj25YcNE8+09aeLoJE
D1a+jAMH+W+arfIviGDQX31twTYOfv5yLF06RgR+J9cmz9zHQZaatv++4yJY
c1T6WvtBDj6bd1Boco8HGs+29pXxdXHky2yVwhxar7Tpmj021sW86RONKqk8
CL4lo7vFXBcnjZXdv5/hQfPpHTZGK3Xx+lWb4NwgWi8qRRyXsNbFlGua2VI+
tD66+e79LRqLgi+si9/Mg9jF2cs5Vrq4rqNo6RcbHqzsv3UpeJkuPv3s9Tme
nud7vj6pGTPRxRvS3mUcQx44MAK+fTXQxa6zvFxZ2g+46MCcNI4uzpNNDM3l
8GDZ9xi7ArYupr1khK+exYOyNq17KdN1cebjqQOytJ+Qnzt2cMoA3c9z4b5T
ZvNgU/Kxe/5fONj/KyGXpceDV3u3TEuu5+CeOYdH2CQPhlOHgkYeczBdu1v1
vjEPbiuzIri0XkiBZaMpy3iwNYOZcDmHgzzVbm8rex4MHj9SU5zBQSW3m2fm
buMB34LlVZHKwWP6lz8+9OVBmkeTRHcKB6fXXLm56SQPJAIOvLai47EHdLbK
OxAQujXpzYUnJO55Z2OD6whajweL95WQ2KrQw6q2ISD5qc+BkpskelZ4qZvY
ErD6WlLCxhQSfYQONxTtCbiyc1BidTyJvFcBEgucCMgfYf3qP0niNQ/VeUGb
CXjZvte5PJBEm+Xyrrk7CdhxLeTPdB8aD7144+9LQAj3UJ/GThJ/OLUkHD1B
QBx2uS9zJ/H3P2M6btEEjFcosPLcSNQw0P3//h+dxE+G1ncmMwnYXvdfHKfs
tmi9Q0BLy3/rL2w8LNZBEVC64b/fPyC+IDCvhgDV5v++39IkSm+uJ2AW3/t/
9W3eVvtK7wMB3pbs/9Vf9+c3f/VnAmzu/7e/cruPpTpfCFgx/N/+X/Q7VZyj
sfLM/f/rz+DMoVNXWgk4seu//on89fzXNBNA5f3X3/8DGAkp7Q==
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
         140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 1}, {1, 151, 
        152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
        166, 167, 168, 169, 170, 171, 172, 173, 1}, {2, 174, 175, 176, 177, 
        178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
        192, 193, 194, 195, 196, 2}, {2, 3}, {3, 197, 198, 199, 200, 201, 202,
         203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
         217, 218, 219, 3}, {3, 4}, {4, 220, 221, 222, 223, 224, 225, 226, 
        227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 
        241, 242, 4}, {4, 8}, {5, 243, 244, 245, 246, 247, 248, 249, 250, 251,
         252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
         5}, {5, 6}, {5, 7}, {6, 266, 267, 268, 269, 270, 271, 272, 273, 274, 
        275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 
        6}, {6, 9}, {6, 10}, {7, 289, 290, 291, 292, 293, 294, 295, 296, 297, 
        298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 
        7}, {7, 10}, {7, 11}, {8, 312, 313, 314, 315, 316, 317, 318, 319, 320,
         321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334,
         8}, {8, 16}, {9, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 
        345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 9}, {
        9, 17}, {9, 18}, {10, 358, 359, 360, 361, 362, 363, 364, 365, 366, 
        367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 
        10}, {10, 18}, {10, 19}, {11, 381, 382, 383, 384, 385, 386, 387, 388, 
        389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 
        403, 11}, {11, 19}, {11, 23}, {12, 404, 405, 406, 407, 408, 409, 410, 
        411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 
        425, 426, 12}, {12, 13}, {12, 14}, {12, 15}, {13, 427, 428, 429, 430, 
        431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 
        445, 446, 447, 448, 449, 13}, {13, 20}, {13, 21}, {13, 22}, {14, 450, 
        451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 
        465, 466, 467, 468, 469, 470, 471, 472, 14}, {14, 21}, {14, 24}, {14, 
        25}, {15, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 
        485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 15}, {15, 
        22}, {15, 25}, {15, 26}, {16, 496, 497, 498, 499, 500, 501, 502, 503, 
        504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 
        518, 16}, {16, 32}, {17, 519, 520, 521, 522, 523, 524, 525, 526, 527, 
        528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 
        17}, {17, 33}, {17, 34}, {18, 542, 543, 544, 545, 546, 547, 548, 549, 
        550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563, 
        564, 18}, {18, 34}, {18, 35}, {19, 565, 566, 567, 568, 569, 570, 571, 
        572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 
        586, 587, 19}, {19, 35}, {19, 39}, {20, 588, 589, 590, 591, 592, 593, 
        594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 
        608, 609, 610, 20}, {20, 36}, {20, 37}, {20, 38}, {21, 611, 612, 613, 
        614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 
        628, 629, 630, 631, 632, 633, 21}, {21, 37}, {21, 40}, {21, 41}, {22, 
        634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 
        648, 649, 650, 651, 652, 653, 654, 655, 656, 22}, {22, 38}, {22, 
        41}, {22, 42}, {23, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 
        667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 
        23}, {23, 39}, {23, 47}, {24, 680, 681, 682, 683, 684, 685, 686, 687, 
        688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 
        702, 24}, {24, 40}, {24, 48}, {24, 49}, {25, 703, 704, 705, 706, 707, 
        708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 
        722, 723, 724, 725, 25}, {25, 41}, {25, 49}, {25, 50}, {26, 726, 727, 
        728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 
        742, 743, 744, 745, 746, 747, 748, 26}, {26, 42}, {26, 50}, {26, 
        54}, {27, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 
        761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 27}, {27, 
        28}, {27, 29}, {27, 30}, {27, 31}, {28, 772, 773, 774, 775, 776, 777, 
        778, 779, 780, 781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791, 
        792, 793, 794, 28}, {28, 43}, {28, 44}, {28, 45}, {28, 46}, {29, 795, 
        796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 
        810, 811, 812, 813, 814, 815, 816, 817, 29}, {29, 44}, {29, 51}, {29, 
        52}, {29, 53}, {30, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 
        828, 829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 
        30}, {30, 45}, {30, 52}, {30, 55}, {30, 56}, {31, 841, 842, 843, 844, 
        845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 
        859, 860, 861, 862, 863, 31}, {31, 46}, {31, 53}, {31, 56}, {31, 
        57}, {32, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 
        876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 32}, {32, 
        64}, {33, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 
        899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 33}, {33, 
        65}, {33, 66}, {34, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 
        920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 
        34}, {34, 66}, {34, 67}, {35, 933, 934, 935, 936, 937, 938, 939, 940, 
        941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 
        955, 35}, {35, 67}, {35, 71}, {36, 956, 957, 958, 959, 960, 961, 962, 
        963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 
        977, 978, 36}, {36, 68}, {36, 69}, {36, 70}, {37, 979, 980, 981, 982, 
        983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 
        997, 998, 999, 1000, 1001, 37}, {37, 69}, {37, 72}, {37, 73}, {38, 
        1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 
        1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 
        1024, 38}, {38, 70}, {38, 73}, {38, 74}, {39, 1025, 1026, 1027, 1028, 
        1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 
        1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 39}, {39, 71}, {39, 
        79}, {40, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 
        1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 
        1069, 1070, 40}, {40, 72}, {40, 80}, {40, 81}, {41, 1071, 1072, 1073, 
        1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 
        1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 41}, {41, 73}, {
        41, 81}, {41, 82}, {42, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 
        1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 
        1112, 1113, 1114, 1115, 1116, 42}, {42, 74}, {42, 82}, {42, 86}, {43, 
        1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 
        1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 
        1139, 43}, {43, 75}, {43, 76}, {43, 77}, {43, 78}, {44, 1140, 1141, 
        1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 
        1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 44}, {44, 
        76}, {44, 83}, {44, 84}, {44, 85}, {45, 1163, 1164, 1165, 1166, 1167, 
        1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 
        1179, 1180, 1181, 1182, 1183, 1184, 1185, 45}, {45, 77}, {45, 84}, {
        45, 87}, {45, 88}, {46, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 
        1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 
        1204, 1205, 1206, 1207, 1208, 46}, {46, 78}, {46, 85}, {46, 88}, {46, 
        89}, {47, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 
        1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 
        1230, 1231, 47}, {47, 79}, {47, 95}, {48, 1232, 1233, 1234, 1235, 
        1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 
        1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 48}, {48, 80}, {48, 
        96}, {48, 97}, {49, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 
        1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 
        1274, 1275, 1276, 1277, 49}, {49, 81}, {49, 97}, {49, 98}, {50, 1278, 
        1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 
        1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 
        50}, {50, 82}, {50, 98}, {50, 102}, {51, 1301, 1302, 1303, 1304, 1305,
         1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 
        1317, 1318, 1319, 1320, 1321, 1322, 1323, 51}, {51, 83}, {51, 99}, {
        51, 100}, {51, 101}, {52, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 
        1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 
        1342, 1343, 1344, 1345, 1346, 52}, {52, 84}, {52, 100}, {52, 103}, {
        52, 104}, {53, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 
        1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 
        1367, 1368, 1369, 53}, {53, 85}, {53, 101}, {53, 104}, {53, 105}, {54,
         1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 
        1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 
        1392, 54}, {54, 86}, {54, 102}, {54, 110}, {55, 1393, 1394, 1395, 
        1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 1405, 1406, 
        1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 55}, {55, 87}, {
        55, 103}, {55, 111}, {55, 112}, {56, 1416, 1417, 1418, 1419, 1420, 
        1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 
        1432, 1433, 1434, 1435, 1436, 1437, 1438, 56}, {56, 88}, {56, 104}, {
        56, 112}, {56, 113}, {57, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 
        1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 
        1457, 1458, 1459, 1460, 1461, 57}, {57, 89}, {57, 105}, {57, 113}, {
        57, 117}, {58, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 
        1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 
        1482, 1483, 1484, 58}, {58, 59}, {58, 60}, {58, 61}, {58, 62}, {58, 
        63}, {59, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 
        1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 
        1506, 1507, 59}, {59, 90}, {59, 91}, {59, 92}, {59, 93}, {59, 94}, {
        60, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 
        1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 
        1530, 60}, {60, 91}, {60, 106}, {60, 107}, {60, 108}, {60, 109}, {61, 
        1531, 1532, 1533, 1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 
        1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551, 1552, 
        1553, 61}, {61, 92}, {61, 107}, {61, 114}, {61, 115}, {61, 116}, {62, 
        1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 
        1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 
        1576, 62}, {62, 93}, {62, 108}, {62, 115}, {62, 118}, {62, 119}, {63, 
        1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 
        1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598, 
        1599, 63}, {63, 94}, {63, 109}, {63, 116}, {63, 119}, {63, 120}, {121,
         1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 
        1611, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620, 1621, 
        1622, 121}, {121, 122}, {121, 123}, {121, 124}, {121, 125}, {121, 
        126}, {121, 127}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "126"],
       Annotation[#, 126, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNlXs01GsXx8dcaBhm/IY5mcptrpkbpSuOfXSTkKakXCLMJFEiKhVRHZeo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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35437280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2033482006],

Cell["Link a number to another with a one bit deleted:", "ExampleText",
 CellID->1499084524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"j", "->", 
         RowBox[{"FromDigits", "[", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{
             RowBox[{"IntegerDigits", "[", 
              RowBox[{"j", ",", "2"}], "]"}], ",", 
             RowBox[{"{", "i", "}"}]}], "]"}], ",", "2"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", 
           RowBox[{"IntegerDigits", "[", 
            RowBox[{"j", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{
         RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->901573380],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAAIr1xy809AUAQ/CgIt13lPwSldG9e
RfI/pqxIiiPh9T+sFihShQsCQIiqTlfvF/Q/gkzqNKB/DEB8o0YUiuDhP4Wl
8qG3QwBA7CYahdkK/j+qmYJxfg0KQNqbLzRyhO0/CPkieJhVDECAmtZ876X6
PzUUqTZz4xNAnEkap8ZJ8D+GomPcJTb4P+x83wkhHwBAVicz5Ll1BkDuiJFk
J9zxP3aWP7dSIghA0b9UJhqZ/D+OxtWOObkRQHG1Jvs2auo/3ulCkI4FCEA/
3LMHvGIFQKxri/dEbxFAmXeCPqKQ+T8yUtVQQdMSQHKZPr76aAJAPB+Xl9WD
GEAOJBOwquv4P5BmS6fRxOY/aerqY7dw/T8cKZR5x9v/P9jnY6Rv7+8/UmnW
FsBvAkAGKnrIX9L5P07YNpHfhg5A2BVnEVkO2T/g4kbRFnYCQFuxJ7lx5QNA
T/rs33QkDkDYGZZ0tPbzP2Q4pGC9fhBA13FGM5yl/j/ACMBoJI0WQJ1OvKCX
xuw/WAcFU0o+/z/SQlY5j1cIQHpu72WBFQxAJDpSRA87AEAWoDG8KAcPQI6y
giqwWQRASoYP8C5zFUDF3x5YWtr1PyV0gLRZ2A9A6han06YvC0DUZyuuusoV
QFOsjiBG6AFAbMER+fp5F0ASfIAzmYEFQFyImPFU7RxAobw4kxIE/D8AAAAA
AAAAAFrXKOb3jvY/1JedlWuT8D/Cvr63iKroP1yUvyBc0/U/SgUDmNQc8z/3
szYYB6cGQAAAAAAAAAAA9k4wXBej9T8ccijLO3kBQE8vd/BP0AZAiNXMKpmo
5D9Gi6KGG+sKQPbkXLxR/fI/weORPQseFEDgShaYIvy6PwSEkuvH8fI/Y544
z0trBUDKKtvyz7sFQF6mYCUCBPk/x9Tr0qNWCUAMisJZnr0AQNjNvY5fHBNA
7g2VW+wL4j8vEK8ZUvwKQExwvYMPzgdAavp46i+cE0A4fdo9D8v3P8RT0Pi9
nxVAAw29jQad/j/cQvI/WHEbQILXBUeiavA/GCv7QdAv5D/0kvAU4GMHQMYf
nGocpQFA5aX2c+5JAUBqaKB65NEFQDTl4w4h5wRAfqS9UN5rEUCRTiV8/Uzx
P7j5ZsHbjAdA0KTTJgCcCkA0ADencTESQG4C/sr1CP8/LBHZ5m0pFEDgY3fV
ywkDQCYQFgY4EhpAChtak7LZ8D9dEOH3kk8GQIoQUA/XARBA7RNP3eUDEkAm
hBtDF1oHQIx9U/r15xNAsxjhDaToCEDW3WGvnNMZQDnOaQcMUf0/kR1/4a4I
FUCbFAPpVhoOQB4lIJEenBpAPhJRIpTiA0Cr/lRFYswcQBuzRJjqQAVAzZ/C
F/LwIEDfPCeHeJb7Py99xX0=
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 1}, {5, 2}, {5, 3}, {6, 1}, {6, 
       4}, {6, 3}, {7, 3}, {7, 4}, {8, 4}, {9, 2}, {9, 5}, {10, 1}, {10, 6}, {
       10, 5}, {11, 3}, {11, 7}, {11, 5}, {11, 6}, {12, 4}, {12, 8}, {12, 
       6}, {13, 5}, {13, 7}, {14, 6}, {14, 8}, {14, 7}, {15, 7}, {15, 8}, {16,
        8}, {17, 2}, {17, 9}, {18, 1}, {18, 10}, {18, 9}, {19, 3}, {19, 11}, {
       19, 9}, {19, 10}, {20, 4}, {20, 12}, {20, 10}, {21, 5}, {21, 13}, {21, 
       9}, {21, 11}, {22, 6}, {22, 14}, {22, 10}, {22, 12}, {22, 11}, {23, 
       7}, {23, 15}, {23, 11}, {23, 12}, {24, 8}, {24, 16}, {24, 12}, {25, 
       9}, {25, 13}, {26, 10}, {26, 14}, {26, 13}, {27, 11}, {27, 15}, {27, 
       13}, {27, 14}, {28, 12}, {28, 16}, {28, 14}, {29, 13}, {29, 15}, {30, 
       14}, {30, 16}, {30, 15}, {31, 15}, {31, 16}, {32, 16}, {33, 2}, {33, 
       17}, {34, 1}, {34, 18}, {34, 17}, {35, 3}, {35, 19}, {35, 17}, {35, 
       18}, {36, 4}, {36, 20}, {36, 18}, {37, 5}, {37, 21}, {37, 17}, {37, 
       19}, {38, 6}, {38, 22}, {38, 18}, {38, 20}, {38, 19}, {39, 7}, {39, 
       23}, {39, 19}, {39, 20}, {40, 8}, {40, 24}, {40, 20}, {41, 9}, {41, 
       25}, {41, 17}, {41, 21}, {42, 10}, {42, 26}, {42, 18}, {42, 22}, {42, 
       21}, {43, 11}, {43, 27}, {43, 19}, {43, 23}, {43, 21}, {43, 22}, {44, 
       12}, {44, 28}, {44, 20}, {44, 24}, {44, 22}, {45, 13}, {45, 29}, {45, 
       21}, {45, 23}, {46, 14}, {46, 30}, {46, 22}, {46, 24}, {46, 23}, {47, 
       15}, {47, 31}, {47, 23}, {47, 24}, {48, 16}, {48, 32}, {48, 24}, {49, 
       17}, {49, 25}, {50, 18}, {50, 26}, {50, 25}, {51, 19}, {51, 27}, {51, 
       25}, {51, 26}, {52, 20}, {52, 28}, {52, 26}, {53, 21}, {53, 29}, {53, 
       25}, {53, 27}, {54, 22}, {54, 30}, {54, 26}, {54, 28}, {54, 27}, {55, 
       23}, {55, 31}, {55, 27}, {55, 28}, {56, 24}, {56, 32}, {56, 28}, {57, 
       25}, {57, 29}, {58, 26}, {58, 30}, {58, 29}, {59, 27}, {59, 31}, {59, 
       29}, {59, 30}, {60, 28}, {60, 32}, {60, 30}, {61, 29}, {61, 31}, {62, 
       30}, {62, 32}, {62, 31}, {63, 31}, {63, 32}, {64, 32}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "63"],
       Annotation[#, 63, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwBEQTu+yFib1JlAgAAAEAAAAACAAAAIr1xy809AUAQ/CgIt13lPwSldG9e
RfI/pqxIiiPh9T+sFihShQsCQIiqTlfvF/Q/gkzqNKB/DEB8o0YUiuDhP4Wl
8qG3QwBA7CYahdkK/j+qmYJxfg0KQNqbLzRyhO0/CPkieJhVDECAmtZ876X6
PzUUqTZz4xNAnEkap8ZJ8D+GomPcJTb4P+x83wkhHwBAVicz5Ll1BkDuiJFk
J9zxP3aWP7dSIghA0b9UJhqZ/D+OxtWOObkRQHG1Jvs2auo/3ulCkI4FCEA/
3LMHvGIFQKxri/dEbxFAmXeCPqKQ+T8yUtVQQdMSQHKZPr76aAJAPB+Xl9WD
GEAOJBOwquv4P5BmS6fRxOY/aerqY7dw/T8cKZR5x9v/P9jnY6Rv7+8/UmnW
FsBvAkAGKnrIX9L5P07YNpHfhg5A2BVnEVkO2T/g4kbRFnYCQFuxJ7lx5QNA
T/rs33QkDkDYGZZ0tPbzP2Q4pGC9fhBA13FGM5yl/j/ACMBoJI0WQJ1OvKCX
xuw/WAcFU0o+/z/SQlY5j1cIQHpu72WBFQxAJDpSRA87AEAWoDG8KAcPQI6y
giqwWQRASoYP8C5zFUDF3x5YWtr1PyV0gLRZ2A9A6han06YvC0DUZyuuusoV
QFOsjiBG6AFAbMER+fp5F0ASfIAzmYEFQFyImPFU7RxAobw4kxIE/D8AAAAA
AAAAAFrXKOb3jvY/1JedlWuT8D/Cvr63iKroP1yUvyBc0/U/SgUDmNQc8z/3
szYYB6cGQAAAAAAAAAAA9k4wXBej9T8ccijLO3kBQE8vd/BP0AZAiNXMKpmo
5D9Gi6KGG+sKQPbkXLxR/fI/weORPQseFEDgShaYIvy6PwSEkuvH8fI/Y544
z0trBUDKKtvyz7sFQF6mYCUCBPk/x9Tr0qNWCUAMisJZnr0AQNjNvY5fHBNA
7g2VW+wL4j8vEK8ZUvwKQExwvYMPzgdAavp46i+cE0A4fdo9D8v3P8RT0Pi9
nxVAAw29jQad/j/cQvI/WHEbQILXBUeiavA/GCv7QdAv5D/0kvAU4GMHQMYf
nGocpQFA5aX2c+5JAUBqaKB65NEFQDTl4w4h5wRAfqS9UN5rEUCRTiV8/Uzx
P7j5ZsHbjAdA0KTTJgCcCkA0ADencTESQG4C/sr1CP8/LBHZ5m0pFEDgY3fV
ywkDQCYQFgY4EhpAChtak7LZ8D9dEOH3kk8GQIoQUA/XARBA7RNP3eUDEkAm
hBtDF1oHQIx9U/r15xNAsxjhDaToCEDW3WGvnNMZQDnOaQcMUf0/kR1/4a4I
FUCbFAPpVhoOQB4lIJEenBpAPhJRIpTiA0Cr/lRFYswcQBuzRJjqQAVAzZ/C
F/LwIEDfPCeHeJb7Py99xX0=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97039115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1427681118],

Cell["Link a number to another that is one bit different:", "ExampleText",
 CellID->1978097035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Map", "[", 
     RowBox[{"Thread", ",", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"2", "^", "6"}], "-", "1"}]}], "]"}], "->", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Thread", "[", 
            RowBox[{"BitXor", "[", 
             RowBox[{
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"2", "^", "i"}], "-", "1"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", 
                  RowBox[{"Length", "[", 
                   RowBox[{"IntegerDigits", "[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}], 
              ",", "j"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", 
             RowBox[{
              RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}]}], ",", 
        "List"}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1000830342],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJwtk4kz3AcYhvf47TrW2ZpUSTWmlUqoqa4kGOb7qjaxpDTRoJQ11oZEhCGp
KxhEkLgSG7ZIOkVXTFKJaWiFOHY06BiJI7JRdZO6z921h91qps/MO+8f8Lyv
ZVjMaR6FRCLhXv7rrhMKIUc+Bx6Wd367mbIOpP/pSr88EfhADtOC4lBv7gJw
SfWdsohdcB1kMgu1FWBlF10bc2AbnB1m5v3JNAymxPpFd2zC/lI3l394KhBm
t/jxypRw8nyMZZipAhz6ZWduNyxDvjXrajhjEQa+17zyUsqgiSFOy0jeBclF
5jmKPgmbS8RSA/11MLtKrKWmE9jy6sJk4HU6tvn317sOkPGJWLdBkL4E3a6f
GQqaSWhe/2ur5oEG5vfPHAwopyM+DhwLWeiG7sR02Ww+gZ4RE+O27utweF+P
T6iNFpqav+S4sHahR2z7+XQbBUNWaqKTC7cgriBPPGGzAdZ5kmlezijoxjre
cvtIARKnAc+FWjIePVCtKG7chgiSfpHbLBmv0Dk5F6xWoTXK95RB3gY8Wp1l
JcV3QshyTCOObUOI8flDPiI12HGCOMzjEkjMdj9bsSMD29UxoRMxAhTFu7Rx
s3n4ljviqyOkIEs02iyIUsHss5W+KtEmvLGeN4hWL0BIEHthlqeDfl38wWfH
toDJZb6+RJDQZKLQ3CxwCOx7Hu1wvLVQHCeyn4x6Ac/J9TV8fzJ6ZHCZYxVz
0GPYUVoZtgUBG9SK7YwJWDNcHs83fav/LQVSlwTtH1XQV1lsISqdg5381A1q
7ir8scZghYdug6JdwDpqSceMh3GBKRsr0BB1HIrIdJQKS75r+mYGqtxHI9TT
GuDpnZDnclQwV5jmZi+Twv3hBg9uuRK6Br6s6x9RwzvxyfHZYzIgKtWtRgwN
FIz7UF4nb8I+1r2O3chNeFpnHDtVS0H+kJddM20G2AV5a9RwCgrLmbf+Zmvh
mStf31BmScGkzSj3iw/JWOPa0vNkiEDjuaXh4vwd2D59cp5IIJA+WDOzVKeH
3ZJEZXP7ChhU5Ch+F2phqdaE2GJv9nZFkX8evkZFt7vBFhlUEl4ueRk+Y2OA
ftcUb/zc1fAxVX4wdlwXv6oXTTFHd0Gc35m2c18bHUUdk5UdVGx6n92SEk5g
7+LNs07nqGh1e+pUkhUZS0pzJfJVMhJ62jfS1TtwpOw9nlMVGau1M3/Wf6GF
/EDfI0s/KKDrOWMSH1ORb7/7wYCbHPgy58x7vQTGDhky2zNpaJGg6f2UrQJB
yHTPsTId/MtRzP4kkobOSS0+Y4u6SCj9qoPjGGiSSrL6JYGORSqZv2EKgYee
elGzjLVxmKnpu2uhgsakvuximh4G3PGmZwUtgbDzYXu5VAdH4tRxDj/JwdPo
4tClvb/8C2x/5ZM=
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 1}, {3, 4}, {3, 2}, {4, 3}, {4, 1}, {5, 6}, {5, 
       7}, {5, 4}, {6, 5}, {6, 8}, {6, 3}, {7, 8}, {7, 5}, {7, 1}, {8, 7}, {8,
        6}, {8, 2}, {9, 10}, {9, 11}, {9, 12}, {9, 7}, {10, 9}, {10, 13}, {10,
        14}, {10, 8}, {11, 13}, {11, 9}, {11, 16}, {11, 5}, {12, 14}, {12, 
       16}, {12, 9}, {12, 1}, {13, 11}, {13, 10}, {13, 15}, {13, 6}, {14, 
       12}, {14, 15}, {14, 10}, {14, 2}, {15, 16}, {15, 14}, {15, 13}, {15, 
       3}, {16, 15}, {16, 12}, {16, 11}, {16, 4}, {17, 18}, {17, 19}, {17, 
       20}, {17, 21}, {17, 12}, {18, 17}, {18, 22}, {18, 23}, {18, 24}, {18, 
       14}, {19, 22}, {19, 17}, {19, 27}, {19, 28}, {19, 16}, {20, 23}, {20, 
       27}, {20, 17}, {20, 32}, {20, 9}, {21, 24}, {21, 28}, {21, 32}, {21, 
       17}, {21, 1}, {22, 19}, {22, 18}, {22, 25}, {22, 26}, {22, 15}, {23, 
       20}, {23, 25}, {23, 18}, {23, 31}, {23, 10}, {24, 21}, {24, 26}, {24, 
       31}, {24, 18}, {24, 2}, {25, 27}, {25, 23}, {25, 22}, {25, 30}, {25, 
       13}, {26, 28}, {26, 24}, {26, 30}, {26, 22}, {26, 3}, {27, 25}, {27, 
       20}, {27, 19}, {27, 29}, {27, 11}, {28, 26}, {28, 21}, {28, 29}, {28, 
       19}, {28, 4}, {29, 30}, {29, 32}, {29, 28}, {29, 27}, {29, 5}, {30, 
       29}, {30, 31}, {30, 26}, {30, 25}, {30, 6}, {31, 32}, {31, 30}, {31, 
       24}, {31, 23}, {31, 8}, {32, 31}, {32, 29}, {32, 21}, {32, 20}, {32, 
       7}, {33, 34}, {33, 35}, {33, 36}, {33, 37}, {33, 38}, {33, 21}, {34, 
       33}, {34, 39}, {34, 40}, {34, 41}, {34, 42}, {34, 24}, {35, 39}, {35, 
       33}, {35, 46}, {35, 47}, {35, 48}, {35, 28}, {36, 40}, {36, 46}, {36, 
       33}, {36, 55}, {36, 56}, {36, 32}, {37, 41}, {37, 47}, {37, 55}, {37, 
       33}, {37, 64}, {37, 17}, {38, 42}, {38, 48}, {38, 56}, {38, 64}, {38, 
       33}, {38, 1}, {39, 35}, {39, 34}, {39, 43}, {39, 44}, {39, 45}, {39, 
       26}, {40, 36}, {40, 43}, {40, 34}, {40, 53}, {40, 54}, {40, 31}, {41, 
       37}, {41, 44}, {41, 53}, {41, 34}, {41, 63}, {41, 18}, {42, 38}, {42, 
       45}, {42, 54}, {42, 63}, {42, 34}, {42, 2}, {43, 46}, {43, 40}, {43, 
       39}, {43, 51}, {43, 52}, {43, 30}, {44, 47}, {44, 41}, {44, 51}, {44, 
       39}, {44, 62}, {44, 22}, {45, 48}, {45, 42}, {45, 52}, {45, 62}, {45, 
       39}, {45, 3}, {46, 43}, {46, 36}, {46, 35}, {46, 49}, {46, 50}, {46, 
       29}, {47, 44}, {47, 37}, {47, 49}, {47, 35}, {47, 61}, {47, 19}, {48, 
       45}, {48, 38}, {48, 50}, {48, 61}, {48, 35}, {48, 4}, {49, 51}, {49, 
       55}, {49, 47}, {49, 46}, {49, 60}, {49, 27}, {50, 52}, {50, 56}, {50, 
       48}, {50, 60}, {50, 46}, {50, 5}, {51, 49}, {51, 53}, {51, 44}, {51, 
       43}, {51, 59}, {51, 25}, {52, 50}, {52, 54}, {52, 45}, {52, 59}, {52, 
       43}, {52, 6}, {53, 55}, {53, 51}, {53, 41}, {53, 40}, {53, 58}, {53, 
       23}, {54, 56}, {54, 52}, {54, 42}, {54, 58}, {54, 40}, {54, 8}, {55, 
       53}, {55, 49}, {55, 37}, {55, 36}, {55, 57}, {55, 20}, {56, 54}, {56, 
       50}, {56, 38}, {56, 57}, {56, 36}, {56, 7}, {57, 58}, {57, 60}, {57, 
       64}, {57, 56}, {57, 55}, {57, 9}, {58, 57}, {58, 59}, {58, 63}, {58, 
       54}, {58, 53}, {58, 10}, {59, 60}, {59, 58}, {59, 62}, {59, 52}, {59, 
       51}, {59, 13}, {60, 59}, {60, 57}, {60, 61}, {60, 50}, {60, 49}, {60, 
       11}, {61, 62}, {61, 64}, {61, 60}, {61, 48}, {61, 47}, {61, 16}, {62, 
       61}, {62, 63}, {62, 59}, {62, 45}, {62, 44}, {62, 15}, {63, 64}, {63, 
       62}, {63, 58}, {63, 42}, {63, 41}, {63, 14}, {64, 63}, {64, 61}, {64, 
       57}, {64, 38}, {64, 37}, {64, 12}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJwtk4kz3AcYhvf47TrW2ZpUSTWmlUqoqa4kGOb7qjaxpDTRoJQ11oZEhCGp
KxhEkLgSG7ZIOkVXTFKJaWiFOHY06BiJI7JRdZO6z921h91qps/MO+8f8Lyv
ZVjMaR6FRCLhXv7rrhMKIUc+Bx6Wd367mbIOpP/pSr88EfhADtOC4lBv7gJw
SfWdsohdcB1kMgu1FWBlF10bc2AbnB1m5v3JNAymxPpFd2zC/lI3l394KhBm
t/jxypRw8nyMZZipAhz6ZWduNyxDvjXrajhjEQa+17zyUsqgiSFOy0jeBclF
5jmKPgmbS8RSA/11MLtKrKWmE9jy6sJk4HU6tvn317sOkPGJWLdBkL4E3a6f
GQqaSWhe/2ur5oEG5vfPHAwopyM+DhwLWeiG7sR02Ww+gZ4RE+O27utweF+P
T6iNFpqav+S4sHahR2z7+XQbBUNWaqKTC7cgriBPPGGzAdZ5kmlezijoxjre
cvtIARKnAc+FWjIePVCtKG7chgiSfpHbLBmv0Dk5F6xWoTXK95RB3gY8Wp1l
JcV3QshyTCOObUOI8flDPiI12HGCOMzjEkjMdj9bsSMD29UxoRMxAhTFu7Rx
s3n4ljviqyOkIEs02iyIUsHss5W+KtEmvLGeN4hWL0BIEHthlqeDfl38wWfH
toDJZb6+RJDQZKLQ3CxwCOx7Hu1wvLVQHCeyn4x6Ac/J9TV8fzJ6ZHCZYxVz
0GPYUVoZtgUBG9SK7YwJWDNcHs83fav/LQVSlwTtH1XQV1lsISqdg5381A1q
7ir8scZghYdug6JdwDpqSceMh3GBKRsr0BB1HIrIdJQKS75r+mYGqtxHI9TT
GuDpnZDnclQwV5jmZi+Twv3hBg9uuRK6Br6s6x9RwzvxyfHZYzIgKtWtRgwN
FIz7UF4nb8I+1r2O3chNeFpnHDtVS0H+kJddM20G2AV5a9RwCgrLmbf+Zmvh
mStf31BmScGkzSj3iw/JWOPa0vNkiEDjuaXh4vwd2D59cp5IIJA+WDOzVKeH
3ZJEZXP7ChhU5Ch+F2phqdaE2GJv9nZFkX8evkZFt7vBFhlUEl4ueRk+Y2OA
ftcUb/zc1fAxVX4wdlwXv6oXTTFHd0Gc35m2c18bHUUdk5UdVGx6n92SEk5g
7+LNs07nqGh1e+pUkhUZS0pzJfJVMhJ62jfS1TtwpOw9nlMVGau1M3/Wf6GF
/EDfI0s/KKDrOWMSH1ORb7/7wYCbHPgy58x7vQTGDhky2zNpaJGg6f2UrQJB
yHTPsTId/MtRzP4kkobOSS0+Y4u6SCj9qoPjGGiSSrL6JYGORSqZv2EKgYee
elGzjLVxmKnpu2uhgsakvuximh4G3PGmZwUtgbDzYXu5VAdH4tRxDj/JwdPo
4tClvb/8C2x/5ZM=
     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135234610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1579773941],

Cell["Link a number to another that is one bit reversed:", "ExampleText",
 CellID->2048509254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"Reverse", "[", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "9"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1306769929],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->601449755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1604511784],

Cell["Link a number to another that is one bit rotated right:", "ExampleText",
 CellID->1746063565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"RotateRight", "[", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "9"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->759610285],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->78409646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->842478017],

Cell["Link a number to another that is one bit rotated left:", "ExampleText",
 CellID->1696081216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"RotateLeft", "[", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "9"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->856391230],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->227417121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581457596],

Cell["Link a number to itself but with last bit dropped:", "ExampleText",
 CellID->1522827744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"IntegerDigits", "[", 
          RowBox[{"j", ",", "2"}], "]"}], ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "8"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2050629870],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1l3k8VPv/x8cSCtnGMoOxzJgt4VpKbjovEaVNIiVpuaKkTFkuJUnWstUl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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268,
         269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 1}, {2, 1}, {
        3, 2}, {4, 2}, {5, 3}, {6, 3}, {7, 4}, {8, 4}, {9, 5}, {10, 5}, {11, 
        6}, {12, 6}, {13, 7}, {14, 7}, {15, 8}, {16, 8}, {17, 9}, {18, 9}, {
        19, 10}, {20, 10}, {21, 11}, {22, 11}, {23, 12}, {24, 12}, {25, 13}, {
        26, 13}, {27, 14}, {28, 14}, {29, 15}, {30, 15}, {31, 16}, {32, 16}, {
        33, 17}, {34, 17}, {35, 18}, {36, 18}, {37, 19}, {38, 19}, {39, 20}, {
        40, 20}, {41, 21}, {42, 21}, {43, 22}, {44, 22}, {45, 23}, {46, 23}, {
        47, 24}, {48, 24}, {49, 25}, {50, 25}, {51, 26}, {52, 26}, {53, 27}, {
        54, 27}, {55, 28}, {56, 28}, {57, 29}, {58, 29}, {59, 30}, {60, 30}, {
        61, 31}, {62, 31}, {63, 32}, {64, 32}, {65, 33}, {66, 33}, {67, 34}, {
        68, 34}, {69, 35}, {70, 35}, {71, 36}, {72, 36}, {73, 37}, {74, 37}, {
        75, 38}, {76, 38}, {77, 39}, {78, 39}, {79, 40}, {80, 40}, {81, 41}, {
        82, 41}, {83, 42}, {84, 42}, {85, 43}, {86, 43}, {87, 44}, {88, 44}, {
        89, 45}, {90, 45}, {91, 46}, {92, 46}, {93, 47}, {94, 47}, {95, 48}, {
        96, 48}, {97, 49}, {98, 49}, {99, 50}, {100, 50}, {101, 51}, {102, 
        51}, {103, 52}, {104, 52}, {105, 53}, {106, 53}, {107, 54}, {108, 
        54}, {109, 55}, {110, 55}, {111, 56}, {112, 56}, {113, 57}, {114, 
        57}, {115, 58}, {116, 58}, {117, 59}, {118, 59}, {119, 60}, {120, 
        60}, {121, 61}, {122, 61}, {123, 62}, {124, 62}, {125, 63}, {126, 
        63}, {127, 64}, {128, 64}, {129, 65}, {130, 65}, {131, 66}, {132, 
        66}, {133, 67}, {134, 67}, {135, 68}, {136, 68}, {137, 69}, {138, 
        69}, {139, 70}, {140, 70}, {141, 71}, {142, 71}, {143, 72}, {144, 
        72}, {145, 73}, {146, 73}, {147, 74}, {148, 74}, {149, 75}, {150, 
        75}, {151, 76}, {152, 76}, {153, 77}, {154, 77}, {155, 78}, {156, 
        78}, {157, 79}, {158, 79}, {159, 80}, {160, 80}, {161, 81}, {162, 
        81}, {163, 82}, {164, 82}, {165, 83}, {166, 83}, {167, 84}, {168, 
        84}, {169, 85}, {170, 85}, {171, 86}, {172, 86}, {173, 87}, {174, 
        87}, {175, 88}, {176, 88}, {177, 89}, {178, 89}, {179, 90}, {180, 
        90}, {181, 91}, {182, 91}, {183, 92}, {184, 92}, {185, 93}, {186, 
        93}, {187, 94}, {188, 94}, {189, 95}, {190, 95}, {191, 96}, {192, 
        96}, {193, 97}, {194, 97}, {195, 98}, {196, 98}, {197, 99}, {198, 
        99}, {199, 100}, {200, 100}, {201, 101}, {202, 101}, {203, 102}, {204,
         102}, {205, 103}, {206, 103}, {207, 104}, {208, 104}, {209, 105}, {
        210, 105}, {211, 106}, {212, 106}, {213, 107}, {214, 107}, {215, 
        108}, {216, 108}, {217, 109}, {218, 109}, {219, 110}, {220, 110}, {
        221, 111}, {222, 111}, {223, 112}, {224, 112}, {225, 113}, {226, 
        113}, {227, 114}, {228, 114}, {229, 115}, {230, 115}, {231, 116}, {
        232, 116}, {233, 117}, {234, 117}, {235, 118}, {236, 118}, {237, 
        119}, {238, 119}, {239, 120}, {240, 120}, {241, 121}, {242, 121}, {
        243, 122}, {244, 122}, {245, 123}, {246, 123}, {247, 124}, {248, 
        124}, {249, 125}, {250, 125}, {251, 126}, {252, 126}, {253, 127}, {
        254, 127}, {255, 128}, {256, 128}}]}, 
     {RGBColor[0, 0, 0.7], PointBox[CompressedData["
1:eJwd0wOfEAYAxuEue7Va1lXbsm1zC5ddl3XZ5rK11dJybbll27Zt20+9v//z
Ed7A4DZBIQGhLOB7oUIThrCEIzwRiEgkIhOFqEQjOj8Qg5j8SCxi8xNxiEs8
4pOAhCQiMUlISjICSU4KUvIzv/ArqUhNGtKSjvRkICOZyEwWspKN7OQgJ7nI
TR7yko/8FKAghShMEYpSjOKUoCSlKE0ZyvIbv1OO8lSgIkFUojJVqEo1qlOD
mtSiNnWoSz3q04BgGtKIxjShKc1oTgta0orWhNCGtrSjPR3oSCc604WudKM7
PehJL3rTh770oz8DGMggBvMHQxjKMIYzgpGMYjRjGMs4xjOBiUxiMlP4k7+Y
yjT+ZjozmMksZvMPc5jLPOazgIUsYjFL+Jf/WMoylrOClaxiNWv4n7WsYz0b
2MgmNrOFrWxjOzvYyS52s4e97GM/BzjIIQ5zhKMc4zgnOMkpTnOGs5zjPBe4
yCUuc4WrXOM6N7jJLW5zh7vc4z4PeMgjHvOEpzzjOS94ySte84a3vOM9H/jI
Jz7zhW/n/wqYtIE2
       "]]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1l3k4lOv/xycJhWxj32fGbAnHUuqk+y2itEmkJC1HKikTcrRJslW2OkR0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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5599262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1514008187],

Cell["Link a number to itself but with first bit dropped:", "ExampleText",
 CellID->1238314478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"IntegerDigits", "[", 
          RowBox[{"j", ",", "2"}], "]"}], ",", "1"}], "]"}], ",", "2"}], 
      "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "8"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1448658424],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxFl3k01Pv/xyXLJMPYZj4zmNWWylKqm9Q8SWizxW2xthApDXURCt2yJhIu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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268,
         269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 1}, {2, 1}, {
        3, 1}, {4, 2}, {5, 1}, {6, 2}, {7, 3}, {8, 4}, {9, 1}, {10, 2}, {11, 
        3}, {12, 4}, {13, 5}, {14, 6}, {15, 7}, {16, 8}, {17, 1}, {18, 2}, {
        19, 3}, {20, 4}, {21, 5}, {22, 6}, {23, 7}, {24, 8}, {25, 9}, {26, 
        10}, {27, 11}, {28, 12}, {29, 13}, {30, 14}, {31, 15}, {32, 16}, {33, 
        1}, {34, 2}, {35, 3}, {36, 4}, {37, 5}, {38, 6}, {39, 7}, {40, 8}, {
        41, 9}, {42, 10}, {43, 11}, {44, 12}, {45, 13}, {46, 14}, {47, 15}, {
        48, 16}, {49, 17}, {50, 18}, {51, 19}, {52, 20}, {53, 21}, {54, 22}, {
        55, 23}, {56, 24}, {57, 25}, {58, 26}, {59, 27}, {60, 28}, {61, 29}, {
        62, 30}, {63, 31}, {64, 32}, {65, 1}, {66, 2}, {67, 3}, {68, 4}, {69, 
        5}, {70, 6}, {71, 7}, {72, 8}, {73, 9}, {74, 10}, {75, 11}, {76, 
        12}, {77, 13}, {78, 14}, {79, 15}, {80, 16}, {81, 17}, {82, 18}, {83, 
        19}, {84, 20}, {85, 21}, {86, 22}, {87, 23}, {88, 24}, {89, 25}, {90, 
        26}, {91, 27}, {92, 28}, {93, 29}, {94, 30}, {95, 31}, {96, 32}, {97, 
        33}, {98, 34}, {99, 35}, {100, 36}, {101, 37}, {102, 38}, {103, 39}, {
        104, 40}, {105, 41}, {106, 42}, {107, 43}, {108, 44}, {109, 45}, {110,
         46}, {111, 47}, {112, 48}, {113, 49}, {114, 50}, {115, 51}, {116, 
        52}, {117, 53}, {118, 54}, {119, 55}, {120, 56}, {121, 57}, {122, 
        58}, {123, 59}, {124, 60}, {125, 61}, {126, 62}, {127, 63}, {128, 
        64}, {129, 1}, {130, 2}, {131, 3}, {132, 4}, {133, 5}, {134, 6}, {135,
         7}, {136, 8}, {137, 9}, {138, 10}, {139, 11}, {140, 12}, {141, 13}, {
        142, 14}, {143, 15}, {144, 16}, {145, 17}, {146, 18}, {147, 19}, {148,
         20}, {149, 21}, {150, 22}, {151, 23}, {152, 24}, {153, 25}, {154, 
        26}, {155, 27}, {156, 28}, {157, 29}, {158, 30}, {159, 31}, {160, 
        32}, {161, 33}, {162, 34}, {163, 35}, {164, 36}, {165, 37}, {166, 
        38}, {167, 39}, {168, 40}, {169, 41}, {170, 42}, {171, 43}, {172, 
        44}, {173, 45}, {174, 46}, {175, 47}, {176, 48}, {177, 49}, {178, 
        50}, {179, 51}, {180, 52}, {181, 53}, {182, 54}, {183, 55}, {184, 
        56}, {185, 57}, {186, 58}, {187, 59}, {188, 60}, {189, 61}, {190, 
        62}, {191, 63}, {192, 64}, {193, 65}, {194, 66}, {195, 67}, {196, 
        68}, {197, 69}, {198, 70}, {199, 71}, {200, 72}, {201, 73}, {202, 
        74}, {203, 75}, {204, 76}, {205, 77}, {206, 78}, {207, 79}, {208, 
        80}, {209, 81}, {210, 82}, {211, 83}, {212, 84}, {213, 85}, {214, 
        86}, {215, 87}, {216, 88}, {217, 89}, {218, 90}, {219, 91}, {220, 
        92}, {221, 93}, {222, 94}, {223, 95}, {224, 96}, {225, 97}, {226, 
        98}, {227, 99}, {228, 100}, {229, 101}, {230, 102}, {231, 103}, {232, 
        104}, {233, 105}, {234, 106}, {235, 107}, {236, 108}, {237, 109}, {
        238, 110}, {239, 111}, {240, 112}, {241, 113}, {242, 114}, {243, 
        115}, {244, 116}, {245, 117}, {246, 118}, {247, 119}, {248, 120}, {
        249, 121}, {250, 122}, {251, 123}, {252, 124}, {253, 125}, {254, 
        126}, {255, 127}, {256, 128}}]}, 
     {RGBColor[0, 0, 0.7], PointBox[CompressedData["
1:eJwd0wOfEAYAxuEue7Va1lXbsm1zC5ddl3XZ5rK11dJybbll27Zt20+9v//z
Ed7A4DZBIQGhLOB7oUIThrCEIzwRiEgkIhOFqEQjOj8Qg5j8SCxi8xNxiEs8
4pOAhCQiMUlISjICSU4KUvIzv/ArqUhNGtKSjvRkICOZyEwWspKN7OQgJ7nI
TR7yko/8FKAghShMEYpSjOKUoCSlKE0ZyvIbv1OO8lSgIkFUojJVqEo1qlOD
mtSiNnWoSz3q04BgGtKIxjShKc1oTgta0orWhNCGtrSjPR3oSCc604WudKM7
PehJL3rTh770oz8DGMggBvMHQxjKMIYzgpGMYjRjGMs4xjOBiUxiMlP4k7+Y
yjT+ZjozmMksZvMPc5jLPOazgIUsYjFL+Jf/WMoylrOClaxiNWv4n7WsYz0b
2MgmNrOFrWxjOzvYyS52s4e97GM/BzjIIQ5zhKMc4zgnOMkpTnOGs5zjPBe4
yCUuc4WrXOM6N7jJLW5zh7vc4z4PeMgjHvOEpzzjOS94ySte84a3vOM9H/jI
Jz7zhW/n/wqYtIE2
       "]]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxFl3k01Pv/xyXLhLGbGYMxM5aRslRKWZonCW22uFpsLURKQ12EW3TLFpFw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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 259},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->173317309]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sparse Test Matrices",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1272578724],

Cell["\<\
A sparse test matrix related to a structure from NASA's Langley Research \
Center: \
\>", "ExampleText",
 CellID->49495937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Matrix\>\"", ",", "\"\<Boeing/nasa1824\>\""}], "}"}], ",", 
     "\"\<Matrix\>\""}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1461987012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 259},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->229374184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->476506339],

Cell["\<\
A sparse test matrix related to a finite element model of a geodesic dome: \
\>", "ExampleText",
 CellID->591564621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/blckhole\>\""}], "}"}], ",", 
     "\"\<Matrix\>\""}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1432366078],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 291},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->661108009]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Finite State Diagrams",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2135965849],

Cell["A finite state diagram describing the C preprocessor:", "ExampleText",
 CellID->651156851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<start\>\"", "\[Rule]", "\"\<none\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<none\>\"", "\[Rule]", "\"\<none\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<none\>\"", "\[Rule]", "\"\<slash\>\""}], ",", 
       "\"\</\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<slash\>\"", "\[Rule]", "\"\<none\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<slash\>\"", "\[Rule]", "\"\<C++\>\""}], ",", 
       "\"\</\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<slash\>\"", "\[Rule]", "\"\<C\>\""}], ",", "\"\<*\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<C++\>\"", "\[Rule]", "\"\<C++\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<C++\>\"", "\[Rule]", "\"\<none\>\""}], ",", 
       "\"\<end-of-line\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<C\>\""}], ",", "\"\<other\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<star\>\""}], ",", "\"\<*\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<star\>\"", "\[Rule]", "\"\<star\>\""}], ",", 
       "\"\<*\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<star\>\"", "\[Rule]", "\"\<C\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<star\>\"", "\[Rule]", "\"\<none\>\""}], ",", 
       "\"\</\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "0.2"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "0.4"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1015062256],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{425, 336},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207635540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1515331628],

Cell["A finite state diagram for string matching:", "ExampleText",
 CellID->79839193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<start\>\"", "\[Rule]", "\"\<empty\>\""}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<empty\>\"", "\[Rule]", "\"\<empty\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<empty\>\"", "\[Rule]", "\"\<n\>\""}], ",", "\"\<n\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<n\>\"", "\[Rule]", "\"\<n\>\""}], ",", "\"\<n\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<n\>\"", "\[Rule]", "\"\<empty\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<n\>\"", "\[Rule]", "\"\<na\>\""}], ",", "\"\<a\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<na\>\"", "\[Rule]", "\"\<nan\>\""}], ",", "\"\<n\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<na\>\"", "\[Rule]", "\"\<empty\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nan\>\"", "\[Rule]", "\"\<na\>\""}], ",", "\"\<a\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nan\>\"", "\[Rule]", "\"\<na\>\""}], ",", "\"\<a\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nan\>\"", "\[Rule]", "\"\<nano\>\""}], ",", "\"\<o\>\""}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nan\>\"", "\[Rule]", "\"\<empty\>\""}], ",", 
       "\"\<other\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nano\>\"", "\[Rule]", "\"\<nano\>\""}], ",", 
       "\"\<any\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "0.3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->920577915],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{425, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268716051]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19760],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " for hierarchical style drawing of directed graphs: "
}], "ExampleText",
 CellID->178337475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun1\>\""}], ",", 
       "\"\<fun1[a,b]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun2\>\""}], ",", 
       "\"\<fun2[1,2,3]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fun2\>\"", "\[Rule]", "\"\<fun3\>\""}], ",", 
       "\"\<fun3[0.5]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun3\>\""}], ",", 
       "\"\<fun3[0.6]\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104551000],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {0.04835996651265902, 1.951640033487341}, {0.10455097716174719`, 
    1.8954490228382528`}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.24042613086921105`, 1.759573869130789}, {0.32011027392758673`, 
    1.6798897260724133`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.5029716924536255, 1.4970283075463744`}, {0.6061489679212887, 
    1.3938510320787112`}, {0.717157287525381, 1.282842712474619}, {
    0.7765193382916591, 1.2185423901034025`}, {0.8288976183795514, 
    1.1513492952006954`}, {0.8742921277890582, 1.0812634277664972`}, {
    0.9127028665201793, 1.0082847878008083`}, {0.9441298345729148, 
    0.9324133753036284}, {0.9685730319472645, 0.8536491902749577}, {
    0.9860324586432286, 0.771992232714796}, {0.9965081146608071, 
    0.6874425026231434}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.7}}], 
      TagBox[
       TooltipBox[ArrowBox[{1, 2}],
        "\"fun1[a,b]\""],
       Annotation[#, "fun1[a,b]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[ArrowBox[{1, 3}],
        "\"fun2[1,2,3]\""],
       Annotation[#, "fun2[1,2,3]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
         21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 4}],
        "\"fun3[0.6]\""],
       Annotation[#, "fun3[0.6]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[ArrowBox[{3, 4}],
        "\"fun3[0.5]\""],
       Annotation[#, "fun3[0.5]", "Tooltip"]& ]}, {InsetBox[
       FrameBox["\<\"main\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"fun1\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"fun2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"fun3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2089298815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363990941],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " for different types of tree drawing: "
}], "ExampleText",
 CellID->64651062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "\[Rule]", " ", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "7"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599520976],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.4748737341529163`, 2.1213203435596424`}, {
    1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
    0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
    3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`, 
    0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 0.}, {
    4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
    0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {3.5355339059327373`, 
    0.}, {4.949747468305833, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
       10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.4748737341529163`, 2.1213203435596424`}, {
     1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
     0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
     3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`, 
     0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 0.}, {
     4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
     0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {3.5355339059327373`,
      0.}, {4.949747468305833, 0.}}]& ],
  AspectRatio->0.6546536707079771,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79635200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194382608],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " to draw graphs in 3D: "
}], "ExampleText",
 CellID->335683558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "200"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9126831],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245512612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonRules\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->865173728],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.14989196306734098`, 1.6282365992600838`, 
    2.034790098161645}, {0.45882859547216137`, 2.4131040673569437`, 
    1.497290804610815}, {0.8867517844533197, 1.3744685748830008`, 
    2.6608239599857644`}, {0., 0.8630758337450009, 1.4088852765998738`}, {
    2.494513394891599, 1.0153556138684852`, 0.6261857821644515}, {
    1.7570746240657682`, 1.2686226228898914`, 0.}, {2.1861316189987283`, 
    0.23058166991925377`, 1.164419752497684}, {2.64452330570507, 
    1.7802746527334183`, 1.252351241361411}, {0.49940409238782746`, 
    2.132707294142412, 0.5381702420089732}, {0.21494646718266286`, 
    1.1752873055936524`, 0.4838076397375538}, {1.451440296627411, 
    2.1906454092797447`, 0.2386971625366867}, {1.1932541568484303`, 
    0.45298456346304716`, 2.4215859802780324`}, {0.645042029113735, 
    0.13687217620863024`, 1.6477650438145712`}, {2.1455427873495223`, 
    0.5112980898824377, 2.1234791504769026`}, {0.9929382726241752, 
    0.6415912392274025, 0.15049278883517236`}, {1.2584962067522718`, 0., 
    0.870768138976459}, {1.3863327475591207`, 2.643582236049019, 
    1.7907067309970293`}, {1.6510900963737563`, 2.002082018112852, 
    2.510273668736498}, {1.9995288088402505`, 2.5066483241309188`, 
    1.012861128006255}, {2.4288883754716544`, 1.4691776217162738`, 
    2.177877735146855}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.14989196306734098`, 1.6282365992600838`, 
     2.034790098161645}, {0.45882859547216137`, 2.4131040673569437`, 
     1.497290804610815}, {0.8867517844533197, 1.3744685748830008`, 
     2.6608239599857644`}, {0., 0.8630758337450009, 1.4088852765998738`}, {
     2.494513394891599, 1.0153556138684852`, 0.6261857821644515}, {
     1.7570746240657682`, 1.2686226228898914`, 0.}, {2.1861316189987283`, 
     0.23058166991925377`, 1.164419752497684}, {2.64452330570507, 
     1.7802746527334183`, 1.252351241361411}, {0.49940409238782746`, 
     2.132707294142412, 0.5381702420089732}, {0.21494646718266286`, 
     1.1752873055936524`, 0.4838076397375538}, {1.451440296627411, 
     2.1906454092797447`, 0.2386971625366867}, {1.1932541568484303`, 
     0.45298456346304716`, 2.4215859802780324`}, {0.645042029113735, 
     0.13687217620863024`, 1.6477650438145712`}, {2.1455427873495223`, 
     0.5112980898824377, 2.1234791504769026`}, {0.9929382726241752, 
     0.6415912392274025, 0.15049278883517236`}, {1.2584962067522718`, 0., 
     0.870768138976459}, {1.3863327475591207`, 2.643582236049019, 
     1.7907067309970293`}, {1.6510900963737563`, 2.002082018112852, 
     2.510273668736498}, {1.9995288088402505`, 2.5066483241309188`, 
     1.012861128006255}, {2.4288883754716544`, 1.4691776217162738`, 
     2.177877735146855}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490925954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7616771],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 " for an extensive collection of predefined graphs and properties: "
}], "ExampleText",
 CellID->212276565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329468572],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "11"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "674", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "20"}], "}"}], ",", "\<\"WongGraph\"\>"}], 
   "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{571, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->474834767]
}, Open  ]],

Cell["Get the connectivity and plot it: ", "ExampleText",
 CellID->322493678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<DesarguesGraph\>\"", ",", "\"\<EdgeRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->724898899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "6"}], ",", 
   RowBox[{"1", "\[Rule]", "20"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "17"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}], ",", 
   RowBox[{"3", "\[Rule]", "12"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"4", "\[Rule]", "15"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"6", "\[Rule]", "7"}], ",", 
   RowBox[{"7", "\[Rule]", "8"}], ",", 
   RowBox[{"7", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "9"}], ",", 
   RowBox[{"8", "\[Rule]", "19"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"9", "\[Rule]", "14"}], ",", 
   RowBox[{"10", "\[Rule]", "11"}], ",", 
   RowBox[{"11", "\[Rule]", "12"}], ",", 
   RowBox[{"11", "\[Rule]", "20"}], ",", 
   RowBox[{"12", "\[Rule]", "13"}], ",", 
   RowBox[{"13", "\[Rule]", "14"}], ",", 
   RowBox[{"13", "\[Rule]", "18"}], ",", 
   RowBox[{"14", "\[Rule]", "15"}], ",", 
   RowBox[{"15", "\[Rule]", "16"}], ",", 
   RowBox[{"16", "\[Rule]", "17"}], ",", 
   RowBox[{"17", "\[Rule]", "18"}], ",", 
   RowBox[{"18", "\[Rule]", "19"}], ",", 
   RowBox[{"19", "\[Rule]", "20"}]}], "}"}]], "Output",
 ImageSize->{504, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->467704386]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2304381],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.8335253333310906`, 0.5888170252248909}, {
    2.0728746150102593`, 1.16232292774174}, {2.0452097366029087`, 0.}, {
    3.1842358068082213`, 1.5088106370118022`}, {1.8092544632153253`, 
    2.2170727576760214`}, {0.9858377251250173, 1.1262011579141327`}, {
    0.9524336752400109, 1.549208838972261}, {2.1008188553439187`, 
    3.058262762988642}, {1.7843370796557942`, 0.8507630499639595}, {0., 
    1.567385033742867}, {2.085383889339903, 1.8942980324184897`}, {
    1.0613480551729944`, 0.04899391087399674}, {1.371894587245123, 
    0.9496047076220485}, {0.25574626245231546`, 0.6161798111699599}, {
    1.0018968898132863`, 1.970850516810505}, {2.294005954533018, 
    1.5244877320505001`}, {0.29170005333867377`, 2.508005651118731}, {
    2.8665338205728323`, 2.4403435004007865`}, {1.1170578550191452`, 
    3.044609269377525}, {1.3945975472981806`, 2.1331235892551694`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
       8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {11, 
       18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {15, 
       17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {20, 
       16}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.8335253333310906`, 0.5888170252248909}, {
     2.0728746150102593`, 1.16232292774174}, {2.0452097366029087`, 0.}, {
     3.1842358068082213`, 1.5088106370118022`}, {1.8092544632153253`, 
     2.2170727576760214`}, {0.9858377251250173, 1.1262011579141327`}, {
     0.9524336752400109, 1.549208838972261}, {2.1008188553439187`, 
     3.058262762988642}, {1.7843370796557942`, 0.8507630499639595}, {0., 
     1.567385033742867}, {2.085383889339903, 1.8942980324184897`}, {
     1.0613480551729944`, 0.04899391087399674}, {1.371894587245123, 
     0.9496047076220485}, {0.25574626245231546`, 0.6161798111699599}, {
     1.0018968898132863`, 1.970850516810505}, {2.294005954533018, 
     1.5244877320505001`}, {0.29170005333867377`, 2.508005651118731}, {
     2.8665338205728323`, 2.4403435004007865`}, {1.1170578550191452`, 
     3.044609269377525}, {1.3945975472981806`, 2.1331235892551694`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->334976310]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " to use the embedding provided by ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->671484576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", 
    RowBox[{"\"\<DesarguesGraph\>\"", ",", "\"\<EdgeRules\>\""}], "]"}], ",", 
   
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"GraphData", "[", 
     RowBox[{"\"\<DesarguesGraph\>\"", ",", "\"\<VertexCoordinateRules\>\""}],
      "]"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3352873],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-0.988, -0.156}, {-0.891, -0.454}, {
    0.156, -0.988}, {-0.988, 0.156}, {-0.707, -0.707}, {-0.454, 
    0.891}, {-0.454, -0.891}, {0.891, 0.454}, {-0.156, -0.988}, {0.156, 
    0.988}, {0.988, -0.156}, {0.454, -0.891}, {0.707, -0.707}, {-0.156, 
    0.988}, {0.891, -0.454}, {-0.891, 0.454}, {0.454, 0.891}, {0.988, 
    0.156}, {0.707, 0.707}, {-0.707, 0.707}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
       8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {11, 
       18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {15, 
       17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {20, 
       16}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-0.988, -0.156}, {-0.891, -0.454}, {
     0.156, -0.988}, {-0.988, 0.156}, {-0.707, -0.707}, {-0.454, 
     0.891}, {-0.454, -0.891}, {0.891, 0.454}, {-0.156, -0.988}, {0.156, 
     0.988}, {0.988, -0.156}, {0.454, -0.891}, {0.707, -0.707}, {-0.156, 
     0.988}, {0.891, -0.454}, {-0.891, 0.454}, {0.454, 0.891}, {0.988, 
     0.156}, {0.707, 0.707}, {-0.707, 0.707}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->632942655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2130626482],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " for a large collection of polyhedra and properties: "
}], "ExampleText",
 CellID->455035373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318678338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "14"}], ",", 
   RowBox[{"1", "\[Rule]", "15"}], ",", 
   RowBox[{"1", "\[Rule]", "16"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"2", "\[Rule]", "13"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"3", "\[Rule]", "14"}], ",", 
   RowBox[{"3", "\[Rule]", "19"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "15"}], ",", 
   RowBox[{"4", "\[Rule]", "20"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"5", "\[Rule]", "19"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"6", "\[Rule]", "20"}], ",", 
   RowBox[{"7", "\[Rule]", "11"}], ",", 
   RowBox[{"7", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "12"}], ",", 
   RowBox[{"8", "\[Rule]", "16"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"9", "\[Rule]", "14"}], ",", 
   RowBox[{"9", "\[Rule]", "17"}], ",", 
   RowBox[{"10", "\[Rule]", "15"}], ",", 
   RowBox[{"10", "\[Rule]", "18"}], ",", 
   RowBox[{"11", "\[Rule]", "12"}], ",", 
   RowBox[{"13", "\[Rule]", "17"}], ",", 
   RowBox[{"13", "\[Rule]", "18"}], ",", 
   RowBox[{"17", "\[Rule]", "19"}], ",", 
   RowBox[{"18", "\[Rule]", "20"}]}], "}"}]], "Output",
 ImageSize->{509, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291061795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512707771],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.3510665033858347`, 3.2977890850512446`}, {
    3.1865563846947325`, 2.6238668716369213`}, {2.0665656762533846`, 
    2.548161935734005}, {1.2789538963136433`, 3.3507587327070447`}, {
    1.1153503684998707`, 0.053192005960164046`}, {1.40084848129012, 
    0.8019321778789572}, {0.27998772243040215`, 0.7259460328909365}, {
    2.1871977892361265`, 0.}, {2.51569973472592, 2.185885919240392}, {
    1.4897706790305143`, 2.5772300732952496`}, {2.4614257516452325`, 
    1.0884691904836643`}, {1.0057748746584316`, 2.2622850072577894`}, {
    0.3813963006519727, 2.7643781473461964`}, {0.951641939495207, 
    1.1644995147789872`}, {0.800693628697374, 1.7222706255814162`}, {0., 
    1.7617491626558388`}, {3.467086670710268, 1.5882310059733398`}, {
    2.6668432156829933`, 1.6288233658645452`}, {3.085347518767926, 
    0.5853276152241507}, {1.978160206899467, 0.773727374059213}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.3510665033858347`, 3.2977890850512446`}, {
     3.1865563846947325`, 2.6238668716369213`}, {2.0665656762533846`, 
     2.548161935734005}, {1.2789538963136433`, 3.3507587327070447`}, {
     1.1153503684998707`, 0.053192005960164046`}, {1.40084848129012, 
     0.8019321778789572}, {0.27998772243040215`, 0.7259460328909365}, {
     2.1871977892361265`, 0.}, {2.51569973472592, 2.185885919240392}, {
     1.4897706790305143`, 2.5772300732952496`}, {2.4614257516452325`, 
     1.0884691904836643`}, {1.0057748746584316`, 2.2622850072577894`}, {
     0.3813963006519727, 2.7643781473461964`}, {0.951641939495207, 
     1.1644995147789872`}, {0.800693628697374, 1.7222706255814162`}, {0., 
     1.7617491626558388`}, {3.467086670710268, 1.5882310059733398`}, {
     2.6668432156829933`, 1.6288233658645452`}, {3.085347518767926, 
     0.5853276152241507}, {1.978160206899467, 0.773727374059213}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73939248]
}, Open  ]],

Cell["Compare to a predefined embedding: ", "ExampleText",
 CellID->224272968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonImage\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437639446],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
    0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
    0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
    0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
    0.416}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
     0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
     0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
     0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
     0.416}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22370456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6602502],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 " for a large collection of sparse matrices: "
}], "ExampleText",
 CellID->1202273972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/can_292\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1521266319],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9V2k4FVrY5RykcJxB5zgTjo6iFEnI0F5FitxCkiRlaNRNMjZLEVGGNLgu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    "], {
     {RGBColor[0.5, 0., 0.], LineBox[CompressedData["
1:eJxN2Xd0lGUWB+AJIh0SEiANCElQIbC7FlDYLk0CqDSluasixW0qTRJQaQoE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       "]]}, 
     {RGBColor[0, 0, 0.7], PointBox[CompressedData["
1:eJwl1FV4EAQUBeANGDBqxGCM2kaXNIIKSCMISEnnaGlQUFq6Q0pauqQb6e5G
QpFOFQGVrn8fD/+5r+fl3KjoTjU6BgYEBGQWMTcWsYlDEHGJR3yCSUBCEpGY
JISQlGQkJwWhpCQVYaQmnDSkJR3pyUAEkUSRkUwxfchCVrKRnRzkJBe5+YA8
5CUf+SlAQQpRmA8pQlE+4mM+oRjFKcGnlKQUpSlDWcpRngp8RkUq8TmVqUJV
vqAa1alBTWrxJbWpQ13qUZ8GNKQRjWlCU5oRTXNa0JJWtKYNbfmKdrSnAx3p
RGe60JVufM03dKcH3/IdPelFb/rQl37053sGMJBBDGYIQxnGcEYwklGMZgxj
Gcd4fmACE5nEZKbwI1OZxnRmMJNZzOYn5jCXecxnAQtZxGKWsJRl/MxyVrCS
VaxmDWtZx3o2sJFNbGYLv7CVbWxnBzvZxW72sJd97OcABznEYY5wlGMc5wQn
OcVpznCWc/zKeS5wkUv8xu9c5g+ucJVrXOcGN7nFbe5wl3vc50/+4m8e8A8P
ecRj/uU//ucJT3nGc17wkle85g1viRl/ILGITRyCiEs84hNMAhKSiMQkIYSk
JCM5KQglJakIIzXhpCEt6UhPBiKIJIqMZAp8/4/eAX5OhBg=
       "]]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9V2k4FVrY5RykcJxB5zgTjo6iFEnI0F5FitxCkiRlaNRNMjZLEVGGNLgu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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->831250632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2027715731],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " supports graphs defined by ",
 StyleBox["Combinatorica:",
  FontSlant->"Italic"]
}], "ExampleText",
 CellID->281285891],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641520322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"FiniteGraphs", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309591901],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9750449426797229, 1.062247795082255}, {
    1.4790677456667756`, 0.7319426320045371}, {1.963479149661524, 
    1.1019817633346387`}, {0., 1.659614420658325}, {2.8858680006718744`, 
    1.7661117103832606`}, {0.8500874811579211, 2.226453354139057}, {
    2.005448854485258, 2.2770377199976304`}, {0.37949734640870436`, 
    1.0014085488425934`}, {1.6436695643237411`, 0.14186415877037262`}, {
    2.5722530298189232`, 1.076006558877305}, {0.6705902116478444, 
    2.0178516122241033`}, {2.183675455684301, 2.0678254138403345`}, {
    0.4354454464564408, 0.7314389424765337}, {1.371943619735835, 
    0.10729098950595106`}, {2.5069573970206793`, 0.8098819195146054}, {
    1.4045964871149206`, 2.7397902454649508`}, {1.1469190893779593`, 
    1.6573994439657271`}, {0.6246944213093002, 0.}, {2.395762126962716, 
    0.06073129221806184}, {1.743084562624058, 1.6772105927574148`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6}, {1, 9}, {1, 11}, {1, 14}, {2, 8}, {2, 10}, {2, 13}, {2,
        15}, {3, 7}, {3, 9}, {3, 12}, {3, 14}, {4, 6}, {4, 8}, {4, 11}, {4, 
       13}, {5, 7}, {5, 10}, {5, 12}, {5, 15}, {6, 16}, {6, 20}, {7, 16}, {7, 
       17}, {8, 17}, {8, 18}, {9, 18}, {9, 19}, {10, 19}, {10, 20}, {11, 
       16}, {11, 20}, {12, 16}, {12, 17}, {13, 17}, {13, 18}, {14, 18}, {14, 
       19}, {15, 19}, {15, 20}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9750449426797229, 1.062247795082255}, {
     1.4790677456667756`, 0.7319426320045371}, {1.963479149661524, 
     1.1019817633346387`}, {0., 1.659614420658325}, {2.8858680006718744`, 
     1.7661117103832606`}, {0.8500874811579211, 2.226453354139057}, {
     2.005448854485258, 2.2770377199976304`}, {0.37949734640870436`, 
     1.0014085488425934`}, {1.6436695643237411`, 0.14186415877037262`}, {
     2.5722530298189232`, 1.076006558877305}, {0.6705902116478444, 
     2.0178516122241033`}, {2.183675455684301, 2.0678254138403345`}, {
     0.4354454464564408, 0.7314389424765337}, {1.371943619735835, 
     0.10729098950595106`}, {2.5069573970206793`, 0.8098819195146054}, {
     1.4045964871149206`, 2.7397902454649508`}, {1.1469190893779593`, 
     1.6573994439657271`}, {0.6246944213093002, 0.}, {2.395762126962716, 
     0.06073129221806184}, {1.743084562624058, 1.6772105927574148`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->435244706]
}, Open  ]],

Cell[TextData[{
 "Set option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"], " "}]], "InlineFormula"],
 "to use the embedding provided by ",
 StyleBox["Combinatorica:",
  FontSlant->"Italic"]
}], "ExampleText",
 CellID->99740068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"FiniteGraphs", "[", 
    RowBox[{"[", "5", "]"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1061686246],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.474, 0.922}, {0.472, 0.844}, {0.472, 0.77}, {
    0.478, 0.69}, {0.472, 0.998}, {0.576, 0.596}, {0.68, 0.6}, {0.786, 
    0.596}, {0.866, 0.6}, {0.946, 0.598}, {0.39, 0.598}, {0.32, 0.596}, {
    0.214, 0.6}, {0.118, 0.598}, {0.026, 0.586}, {0.484, 0.494}, {0.478, 
    0.388}, {0.482, 0.306}, {0.478, 0.222}, {0.484, 0.15}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6}, {1, 9}, {1, 11}, {1, 14}, {2, 8}, {2, 10}, {2, 13}, {2,
        15}, {3, 7}, {3, 9}, {3, 12}, {3, 14}, {4, 6}, {4, 8}, {4, 11}, {4, 
       13}, {5, 7}, {5, 10}, {5, 12}, {5, 15}, {6, 16}, {6, 20}, {7, 16}, {7, 
       17}, {8, 17}, {8, 18}, {9, 18}, {9, 19}, {10, 19}, {10, 20}, {11, 
       16}, {11, 20}, {12, 16}, {12, 17}, {13, 17}, {13, 18}, {14, 18}, {14, 
       19}, {15, 19}, {15, 20}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.474, 0.922}, {0.472, 0.844}, {0.472, 0.77}, {
     0.478, 0.69}, {0.472, 0.998}, {0.576, 0.596}, {0.68, 0.6}, {0.786, 
     0.596}, {0.866, 0.6}, {0.946, 0.598}, {0.39, 0.598}, {0.32, 0.596}, {
     0.214, 0.6}, {0.118, 0.598}, {0.026, 0.586}, {0.484, 0.494}, {0.478, 
     0.388}, {0.482, 0.306}, {0.478, 0.222}, {0.484, 0.15}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 166},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->247474206]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6065],

Cell["Symmetries of large graphs may not be preserved by default:", \
"ExampleText",
 CellID->221957996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", "30", "}"}], ",", 
    RowBox[{"{", "30", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182394302],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.1114005126335007`, 1.289301515616812}, {
    1.6370155861833364`, 0.5706210492993329}, {0.1419860643873393, 
    0.36689558814750073`}, {1.3128549112260455`, 1.0051732005827123`}, {
    0.4960392949523978, 0.6508293652450466}, {0.3917649705030759, 
    0.11741921725272897`}, {1.6054699849369687`, 1.1445299916167877`}, {
    0.1688051525963573, 1.2762586282392163`}, {0.98502695790447, 0.}, {
    1.434745284786581, 1.3884800434220756`}, {0.6654896506356242, 
    0.006106656437970037}, {0.2360436160550149, 0.8944191338385613}, {
    0.3703027175525651, 1.5097638236513715`}, {0.9182267145305598, 
    0.6007064527509616}, {0.028280555219938885`, 0.6402823044194568}, {
    0.7841866865551173, 0.27674699737174646`}, {0.42989850910854155`, 
    0.3874620482155069}, {0.8944677228127644, 1.600821841234734}, {
    0.5906182755634598, 0.9139446958226601}, {0., 1.0070854154775484`}, {
    1.1884694388231527`, 1.5820867716842424`}, {0.9502789075733394, 
    0.9510486317550997}, {1.1274833734158378`, 0.3570603925597483}, {
    1.6507814652679687`, 0.8692976527525662}, {1.3030540882580046`, 
    0.11013648465910397`}, {0.4857263769223567, 1.224204203047345}, {
    0.6409572156010862, 1.6021198099013856`}, {1.3252616490494438`, 
    0.6751708815000305}, {0.768795868143376, 1.2376691092499894`}, {
    1.4756194191932133`, 0.3433561406905473}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1,
        25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {2, 3}, {2, 4}, {2, 
       5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 
       13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2,
        21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {
       2, 29}, {2, 30}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
       10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3,
        18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {
       3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {4, 5}, {4, 6}, {4, 7}, {4,
        8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 
       16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4,
        24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 6}, {5,
        7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5,
        23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {
       6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6,
        15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {
       6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 
       30}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 
       15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7,
        23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {
       8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {
       8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 
       24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {9, 10}, {9,
        11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {
       9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 
       26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 11}, {10, 12}, {10, 
       13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 
       20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 
       27}, {10, 28}, {10, 29}, {10, 30}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 
       22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 
       29}, {11, 30}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 
       18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 
       25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {13, 14}, {13, 
       15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {13, 21}, {13, 
       22}, {13, 23}, {13, 24}, {13, 25}, {13, 26}, {13, 27}, {13, 28}, {13, 
       29}, {13, 30}, {14, 15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 
       20}, {14, 21}, {14, 22}, {14, 23}, {14, 24}, {14, 25}, {14, 26}, {14, 
       27}, {14, 28}, {14, 29}, {14, 30}, {15, 16}, {15, 17}, {15, 18}, {15, 
       19}, {15, 20}, {15, 21}, {15, 22}, {15, 23}, {15, 24}, {15, 25}, {15, 
       26}, {15, 27}, {15, 28}, {15, 29}, {15, 30}, {16, 17}, {16, 18}, {16, 
       19}, {16, 20}, {16, 21}, {16, 22}, {16, 23}, {16, 24}, {16, 25}, {16, 
       26}, {16, 27}, {16, 28}, {16, 29}, {16, 30}, {17, 18}, {17, 19}, {17, 
       20}, {17, 21}, {17, 22}, {17, 23}, {17, 24}, {17, 25}, {17, 26}, {17, 
       27}, {17, 28}, {17, 29}, {17, 30}, {18, 19}, {18, 20}, {18, 21}, {18, 
       22}, {18, 23}, {18, 24}, {18, 25}, {18, 26}, {18, 27}, {18, 28}, {18, 
       29}, {18, 30}, {19, 20}, {19, 21}, {19, 22}, {19, 23}, {19, 24}, {19, 
       25}, {19, 26}, {19, 27}, {19, 28}, {19, 29}, {19, 30}, {20, 21}, {20, 
       22}, {20, 23}, {20, 24}, {20, 25}, {20, 26}, {20, 27}, {20, 28}, {20, 
       29}, {20, 30}, {21, 22}, {21, 23}, {21, 24}, {21, 25}, {21, 26}, {21, 
       27}, {21, 28}, {21, 29}, {21, 30}, {22, 23}, {22, 24}, {22, 25}, {22, 
       26}, {22, 27}, {22, 28}, {22, 29}, {22, 30}, {23, 24}, {23, 25}, {23, 
       26}, {23, 27}, {23, 28}, {23, 29}, {23, 30}, {24, 25}, {24, 26}, {24, 
       27}, {24, 28}, {24, 29}, {24, 30}, {25, 26}, {25, 27}, {25, 28}, {25, 
       29}, {25, 30}, {26, 27}, {26, 28}, {26, 29}, {26, 30}, {27, 28}, {27, 
       29}, {27, 30}, {28, 29}, {28, 30}, {29, 30}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.1114005126335007`, 1.289301515616812}, {
     1.6370155861833364`, 0.5706210492993329}, {0.1419860643873393, 
     0.36689558814750073`}, {1.3128549112260455`, 1.0051732005827123`}, {
     0.4960392949523978, 0.6508293652450466}, {0.3917649705030759, 
     0.11741921725272897`}, {1.6054699849369687`, 1.1445299916167877`}, {
     0.1688051525963573, 1.2762586282392163`}, {0.98502695790447, 0.}, {
     1.434745284786581, 1.3884800434220756`}, {0.6654896506356242, 
     0.006106656437970037}, {0.2360436160550149, 0.8944191338385613}, {
     0.3703027175525651, 1.5097638236513715`}, {0.9182267145305598, 
     0.6007064527509616}, {0.028280555219938885`, 0.6402823044194568}, {
     0.7841866865551173, 0.27674699737174646`}, {0.42989850910854155`, 
     0.3874620482155069}, {0.8944677228127644, 1.600821841234734}, {
     0.5906182755634598, 0.9139446958226601}, {0., 1.0070854154775484`}, {
     1.1884694388231527`, 1.5820867716842424`}, {0.9502789075733394, 
     0.9510486317550997}, {1.1274833734158378`, 0.3570603925597483}, {
     1.6507814652679687`, 0.8692976527525662}, {1.3030540882580046`, 
     0.11013648465910397`}, {0.4857263769223567, 1.224204203047345}, {
     0.6409572156010862, 1.6021198099013856`}, {1.3252616490494438`, 
     0.6751708815000305}, {0.768795868143376, 1.2376691092499894`}, {
     1.4756194191932133`, 0.3433561406905473}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87220296]
}, Open  ]],

Cell["Use explicit methods to preserve symmetries:", "ExampleText",
 CellID->46586287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<CircularEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410701411],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.390443574307614, 0.6914132894715279}, {
    1.3752513102370372`, 0.8359580267279495}, {1.330338492865724, 
    0.9741854653640221}, {1.2576680278282981`, 1.1000544030228516`}, {
    1.160415963158294, 1.208063763142887}, {1.0428326807487314`, 
    1.2934930184007385`}, {0.9100571342678041, 1.3526085004068022`}, {
    0.7678922522241587, 1.3828265789300054`}, {0.6225513221455394, 
    1.3828265789365306`}, {0.4803864400991806, 1.3526085004260928`}, {
    0.3476108936129453, 1.2934930184319513`}, {0.23002761119571152`, 
    1.2080637631846582`}, {0.13277554651600898`, 1.1000544030733552`}, {
    0.060105081467280996`, 0.9741854654210511}, {0.015192264083555895`, 
    0.8359580267890114}, {0., 0.6914132895339541}, {0.01519226405759777, 
    0.5468685522761683}, {0.06010508141649906, 0.40864111363606276`}, {
    0.1327755464426228, 0.2827721759707079}, {0.23002761110292835`, 
    0.17476281584193998`}, {0.3476108935048199, 0.08933356057353059}, {
    0.48038643998043906`, 0.03021807855554448}, {0.6225513220213713, 
    1.957589645940061*^-11}, {0.7678922520999907, 0.}, {0.9100571341490631, 
    0.03021807849767233}, {1.042832680640606, 0.08933356047989127}, {
    1.1604159630655109`, 0.17476281571662644`}, {1.257668027754912, 
    0.28277217581919667`}, {1.330338492814942, 0.4086411134649759}, {
    1.375251310211079, 0.5468685520929828}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1,
        25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {2, 3}, {2, 4}, {2, 
       5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 
       13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2,
        21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {
       2, 29}, {2, 30}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
       10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3,
        18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {
       3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {4, 5}, {4, 6}, {4, 7}, {4,
        8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 
       16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4,
        24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 6}, {5,
        7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5,
        23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {
       6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6,
        15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {
       6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 
       30}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 
       15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7,
        23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {
       8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {
       8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 
       24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {9, 10}, {9,
        11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {
       9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 
       26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 11}, {10, 12}, {10, 
       13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 
       20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 
       27}, {10, 28}, {10, 29}, {10, 30}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 
       22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 
       29}, {11, 30}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 
       18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 
       25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {13, 14}, {13, 
       15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {13, 21}, {13, 
       22}, {13, 23}, {13, 24}, {13, 25}, {13, 26}, {13, 27}, {13, 28}, {13, 
       29}, {13, 30}, {14, 15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 
       20}, {14, 21}, {14, 22}, {14, 23}, {14, 24}, {14, 25}, {14, 26}, {14, 
       27}, {14, 28}, {14, 29}, {14, 30}, {15, 16}, {15, 17}, {15, 18}, {15, 
       19}, {15, 20}, {15, 21}, {15, 22}, {15, 23}, {15, 24}, {15, 25}, {15, 
       26}, {15, 27}, {15, 28}, {15, 29}, {15, 30}, {16, 17}, {16, 18}, {16, 
       19}, {16, 20}, {16, 21}, {16, 22}, {16, 23}, {16, 24}, {16, 25}, {16, 
       26}, {16, 27}, {16, 28}, {16, 29}, {16, 30}, {17, 18}, {17, 19}, {17, 
       20}, {17, 21}, {17, 22}, {17, 23}, {17, 24}, {17, 25}, {17, 26}, {17, 
       27}, {17, 28}, {17, 29}, {17, 30}, {18, 19}, {18, 20}, {18, 21}, {18, 
       22}, {18, 23}, {18, 24}, {18, 25}, {18, 26}, {18, 27}, {18, 28}, {18, 
       29}, {18, 30}, {19, 20}, {19, 21}, {19, 22}, {19, 23}, {19, 24}, {19, 
       25}, {19, 26}, {19, 27}, {19, 28}, {19, 29}, {19, 30}, {20, 21}, {20, 
       22}, {20, 23}, {20, 24}, {20, 25}, {20, 26}, {20, 27}, {20, 28}, {20, 
       29}, {20, 30}, {21, 22}, {21, 23}, {21, 24}, {21, 25}, {21, 26}, {21, 
       27}, {21, 28}, {21, 29}, {21, 30}, {22, 23}, {22, 24}, {22, 25}, {22, 
       26}, {22, 27}, {22, 28}, {22, 29}, {22, 30}, {23, 24}, {23, 25}, {23, 
       26}, {23, 27}, {23, 28}, {23, 29}, {23, 30}, {24, 25}, {24, 26}, {24, 
       27}, {24, 28}, {24, 29}, {24, 30}, {25, 26}, {25, 27}, {25, 28}, {25, 
       29}, {25, 30}, {26, 27}, {26, 28}, {26, 29}, {26, 30}, {27, 28}, {27, 
       29}, {27, 30}, {28, 29}, {28, 30}, {29, 30}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.390443574307614, 0.6914132894715279}, {
     1.3752513102370372`, 0.8359580267279495}, {1.330338492865724, 
     0.9741854653640221}, {1.2576680278282981`, 1.1000544030228516`}, {
     1.160415963158294, 1.208063763142887}, {1.0428326807487314`, 
     1.2934930184007385`}, {0.9100571342678041, 1.3526085004068022`}, {
     0.7678922522241587, 1.3828265789300054`}, {0.6225513221455394, 
     1.3828265789365306`}, {0.4803864400991806, 1.3526085004260928`}, {
     0.3476108936129453, 1.2934930184319513`}, {0.23002761119571152`, 
     1.2080637631846582`}, {0.13277554651600898`, 1.1000544030733552`}, {
     0.060105081467280996`, 0.9741854654210511}, {0.015192264083555895`, 
     0.8359580267890114}, {0., 0.6914132895339541}, {0.01519226405759777, 
     0.5468685522761683}, {0.06010508141649906, 0.40864111363606276`}, {
     0.1327755464426228, 0.2827721759707079}, {0.23002761110292835`, 
     0.17476281584193998`}, {0.3476108935048199, 0.08933356057353059}, {
     0.48038643998043906`, 0.03021807855554448}, {0.6225513220213713, 
     1.957589645940061*^-11}, {0.7678922520999907, 0.}, {0.9100571341490631, 
     0.03021807849767233}, {1.042832680640606, 0.08933356047989127}, {
     1.1604159630655109`, 0.17476281571662644`}, {1.257668027754912, 
     0.28277217581919667`}, {1.330338492814942, 0.4086411134649759}, {
     1.375251310211079, 0.5468685520929828}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->870866876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59809439],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " may produce a drawing that is different from those defined in ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1980357588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GraphData", "[", "\"\<DesarguesGraph\>\"", "]"}], ",", 
   RowBox[{"GraphPlot", "[", 
    RowBox[{"GraphData", "[", 
     RowBox[{"\"\<DesarguesGraph\>\"", ",", "\"\<EdgeRules\>\""}], "]"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139529343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{-0.988, -0.156}, {-0.891, -0.454}, {-0.707, \
-0.707}, {-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {
      0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}, {
      0.988, 0.156}, {0.891, 0.454}, {0.707, 0.707}, {0.454, 0.891}, {0.156, 
      0.988}, {-0.156, 0.988}, {-0.454, 0.891}, {-0.707, 0.707}, {-0.891, 
      0.454}, {-0.988, 0.156}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 6}, {1, 20}, {2, 3}, {2, 17}, {3, 4}, {3, 12}, {
         4, 5}, {4, 15}, {5, 6}, {5, 10}, {6, 7}, {7, 8}, {7, 16}, {8, 9}, {8,
          19}, {9, 10}, {9, 14}, {10, 11}, {11, 12}, {11, 20}, {12, 13}, {13, 
         14}, {13, 18}, {14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19,
          20}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[19],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[20],
          "20"],
         Annotation[#, 20, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{-0.988, -0.156}, {-0.891, -0.454}, {-0.707, \
-0.707}, {-0.454, -0.891}, {-0.156, -0.988}, {0.156, -0.988}, {
       0.454, -0.891}, {0.707, -0.707}, {0.891, -0.454}, {0.988, -0.156}, {
       0.988, 0.156}, {0.891, 0.454}, {0.707, 0.707}, {0.454, 0.891}, {0.156, 
       0.988}, {-0.156, 0.988}, {-0.454, 0.891}, {-0.707, 0.707}, {-0.891, 
       0.454}, {-0.988, 0.156}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.8335253333310906`, 0.5888170252248909}, {
      2.0728746150102593`, 1.16232292774174}, {2.0452097366029087`, 0.}, {
      3.1842358068082213`, 1.5088106370118022`}, {1.8092544632153253`, 
      2.2170727576760214`}, {0.9858377251250173, 1.1262011579141327`}, {
      0.9524336752400109, 1.549208838972261}, {2.1008188553439187`, 
      3.058262762988642}, {1.7843370796557942`, 0.8507630499639595}, {0., 
      1.567385033742867}, {2.085383889339903, 1.8942980324184897`}, {
      1.0613480551729944`, 0.04899391087399674}, {1.371894587245123, 
      0.9496047076220485}, {0.25574626245231546`, 0.6161798111699599}, {
      1.0018968898132863`, 1.970850516810505}, {2.294005954533018, 
      1.5244877320505001`}, {0.29170005333867377`, 2.508005651118731}, {
      2.8665338205728323`, 2.4403435004007865`}, {1.1170578550191452`, 
      3.044609269377525}, {1.3945975472981806`, 2.1331235892551694`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
         8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {
         11, 18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {
         15, 17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {
         20, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[19],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[20],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.8335253333310906`, 0.5888170252248909}, {
       2.0728746150102593`, 1.16232292774174}, {2.0452097366029087`, 0.}, {
       3.1842358068082213`, 1.5088106370118022`}, {1.8092544632153253`, 
       2.2170727576760214`}, {0.9858377251250173, 1.1262011579141327`}, {
       0.9524336752400109, 1.549208838972261}, {2.1008188553439187`, 
       3.058262762988642}, {1.7843370796557942`, 0.8507630499639595}, {0., 
       1.567385033742867}, {2.085383889339903, 1.8942980324184897`}, {
       1.0613480551729944`, 0.04899391087399674}, {1.371894587245123, 
       0.9496047076220485}, {0.25574626245231546`, 0.6161798111699599}, {
       1.0018968898132863`, 1.970850516810505}, {2.294005954533018, 
       1.5244877320505001`}, {0.29170005333867377`, 2.508005651118731}, {
       2.8665338205728323`, 2.4403435004007865`}, {1.1170578550191452`, 
       3.044609269377525}, {1.3945975472981806`, 2.1331235892551694`}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196049615]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27150],

Cell["Make a graph of the relationship between subexpressions:", "ExampleText",
 CellID->364036052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"#", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"List", "@@", "#"}], ")"}]}], "]"}], "&"}], "/@", 
     RowBox[{"Level", "[", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], 
       ",", "Infinity"}], "]"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1646353476],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.12485686871772939`, 5.783202758183018}, {
    1.7115634161761535`, 3.5992885528793384`}, {1.1826612336900122`, 
    4.327259954647232}, {0.6537590512038707, 5.055231356415125}, {
    1.7115634156913693`, 0.}, {0., 3.04316788779893}, {1.1826612335592788`, 
    2.871317151206428}, {1.7115634159337614`, 1.7996442764396692`}, {
    1.7115634158125654`, 0.8998221382198346}, {3.8271721469051174`, 
    6.511174159381013}, {3.4231268322024997`, 3.0431678873378702`}, {
    2.567345124289198, 3.8773488853426996`}, {2.7693677815406357`, 
    5.055231356130175}, {3.298269964222876, 5.7832027577555944`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{3, 2}, {4, 1}, {4, 3}, {7, 6}, {7, 2}, {8, 7}, {9, 5}, {9, 
       8}, {12, 11}, {12, 2}, {13, 12}, {14, 10}, {14, 13}}]}, {InsetBox[
       FrameBox[
        RowBox[{"-", 
         FractionBox["1", "2"]}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["x",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox[
        RowBox[{
         SuperscriptBox["tan", 
          RowBox[{"-", "1"}]], "(", "x", ")"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
         RowBox[{
          SuperscriptBox["tan", 
           RowBox[{"-", "1"}]], "(", "x", ")"}]}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox[
        FractionBox["1", "4"],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox[
        RowBox[{"-", "1"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox[
        RowBox[{"x", "-", "1"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox[
        RowBox[{"log", "(", 
         RowBox[{"x", "-", "1"}], ")"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox[
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"log", "(", 
          RowBox[{"x", "-", "1"}], ")"}]}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox[
        RowBox[{"-", 
         FractionBox["1", "4"]}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox[
        RowBox[{"x", "+", "1"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox[
        RowBox[{"log", "(", 
         RowBox[{"x", "+", "1"}], ")"}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         RowBox[{"log", "(", 
          RowBox[{"x", "+", "1"}], ")"}]}],
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.12485686871772939`, 5.783202758183018}, {
     1.7115634161761535`, 3.5992885528793384`}, {1.1826612336900122`, 
     4.327259954647232}, {0.6537590512038707, 5.055231356415125}, {
     1.7115634156913693`, 0.}, {0., 3.04316788779893}, {1.1826612335592788`, 
     2.871317151206428}, {1.7115634159337614`, 1.7996442764396692`}, {
     1.7115634158125654`, 0.8998221382198346}, {3.8271721469051174`, 
     6.511174159381013}, {3.4231268322024997`, 3.0431678873378702`}, {
     2.567345124289198, 3.8773488853426996`}, {2.7693677815406357`, 
     5.055231356130175}, {3.298269964222876, 5.7832027577555944`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{271.35773470425954`, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{275, 461},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312426717]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24979],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyhedronData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyhedronData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29414067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15200],

Cell[TextData[{
 ButtonBox["Introduction to Graph Drawing in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]
}], "Tutorials",
 CellID->25850],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GraphPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=GraphPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->728763141],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->9998260],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->79482326],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->56091742],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->752091114],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->21582118],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->55060115]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 52.2087626}", "context" -> "System`", 
    "keywords" -> {
     "circular embedding", "digraph layout", "draw a graph", "graph drawing", 
      "graph embedding", "graph layout", "graph visualization", 
      "high-dimensional embedding", "linear embedding", "network layout", 
      "network visualization", "plot a graph", "radial drawing", 
      "random embedding", "spring-electrical embedding", "spring embedding", 
      "plot a permutation", "plot a finite relation", "plot a sparse array"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GraphPlot[{v i1 -> v j1, v i2 -> v j2, ...}] generates a plot of the \
graph in which vertex v_ik is connected to vertex v_jk. GraphPlot[{{v i1 -> v \
j1, lbl_1}, ...}] associates labels lbl_k with edges in the graph. \
GraphPlot[m] generates a plot of the graph represented by the adjacency \
matrix m.", "synonyms" -> {"graph plot"}, "title" -> "GraphPlot", "type" -> 
    "Symbol", "uri" -> "ref/GraphPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26033, 837, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->337842453]},
 "b:0.1"->{
  Cell[26569, 858, 106, 2, 70, "ExampleText",
   CellTags->"b:0.1",
   CellID->1269326376],
  Cell[102146, 2654, 701, 22, 70, "Input",
   CellTags->"b:0.1",
   CellID->1209134277],
  Cell[102850, 2678, 44040, 1167, 70, "Output",
   CellTags->"b:0.1",
   CellID->367587356]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 998225, 23701},
 {"b:0.1", 998358, 23705}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3489, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4112, 104, 1574, 37, 70, "ObjectNameGrid"],
Cell[5689, 143, 2999, 94, 70, "Usage",
 CellID->18997]
}, Open  ]],
Cell[CellGroupData[{
Cell[8725, 242, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9203, 259, 247, 7, 70, "Notes",
 CellID->457633418],
Cell[9453, 268, 321, 13, 70, "Notes",
 CellID->181146064],
Cell[9777, 283, 622, 21, 70, "Notes",
 CellID->69175411],
Cell[10402, 306, 361, 12, 70, "Notes",
 CellID->30166],
Cell[10766, 320, 4858, 129, 70, "3ColumnTableMod",
 CellID->32136],
Cell[15627, 451, 502, 17, 70, "Notes",
 CellID->16670666],
Cell[16132, 470, 778, 28, 70, "Notes",
 CellID->762729751],
Cell[16913, 500, 816, 28, 70, "Notes",
 CellID->442256812],
Cell[17732, 530, 859, 31, 70, "Notes",
 CellID->166183907],
Cell[18594, 563, 1624, 60, 70, "Notes",
 CellID->636470603],
Cell[20221, 625, 766, 24, 70, "Notes",
 CellID->184577521],
Cell[20990, 651, 268, 8, 70, "Notes",
 CellID->249053938],
Cell[21261, 661, 414, 13, 70, "Notes",
 CellID->80983619],
Cell[21678, 676, 995, 34, 70, "Notes",
 CellID->204192059],
Cell[22676, 712, 171, 4, 70, "