(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    627091,      15207]
NotebookOptionsPosition[    607393,      14546]
NotebookOutlinePosition[    609435,      14599]
CellTagsIndexPosition[    609320,      14593]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Graph Drawing in Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction"], 
          "General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Introduction to Graph Drawing in Mathematica \"\>", 
       2->"\<\"General Graph Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"],
           "LayeredGraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"], "TreePlot" :> 
          Documentation`HelpLookup["paclet:ref/TreePlot"], "GraphData" :> 
          Documentation`HelpLookup["paclet:ref/GraphData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphPlot\"\>", 
       2->"\<\"LayeredGraphPlot\"\>", 3->"\<\"TreePlot\"\>", 
       4->"\<\"GraphData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 
       3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphPlot3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a 3D plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot3D"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["i", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]], "->", 
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["j", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]]}], ",", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphPlot"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a plot of the graph represented by the \
adjacency matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " attempts to place vertices in 3D to give a well laid-out version of the \
graph. "
}], "Notes",
 CellID->457633418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->30166],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method used to lay out the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use for packing components", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall graphics directives for vertices and edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->32136],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", vertices are displayed as points, with their names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " given in tooltips."
}], "Notes",
 CellID->16670666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    StyleBox["vlab", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to specify an alternative tooltip for a vertex."
}], "Notes",
 CellID->762729751],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the 3D graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is the position where the vertex is being placed, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is its name."
}], "Notes",
 CellID->166183907],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the 3D graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge."
}], "Notes",
 CellID->636470603],

Cell[TextData[{
 "The graphics primitives obtained by applying ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the 3D graphic generated by ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->184577521],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", coordinates are chosen so that the average length of the edges in the \
graph is approximately ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->80983619],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 ", an explicit rule ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["k", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["k", "TI"]], ",", " ", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["k", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies coordinates for a vertex. If any coordinate is given as ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", it is found automatically. Vertices for which no rules are specified are \
taken to have automatically generated ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " positions."
}], "Notes",
 CellID->245035128],

Cell["\<\
The graph does not need to be connected. Disconnected components are \
typically arranged so as to fill a planar area roughly uniformly.\
\>", "Notes",
 CellID->70117131],

Cell["\<\
When a graph is specified by an adjacency matrix, the names of its vertices \
are taken to be successive integers starting at 1.\
\>", "Notes",
 CellID->67697114],

Cell[TextData[{
 "The adjacency matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot3D"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->105198305],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are not shown if the graph is specified by an adjacency \
matrix."
}], "Notes",
 CellID->424434705],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " include ",
 Cell[BoxData["\"\<SpiralEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RandomEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<RadialDrawing\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->102997983],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " normally uses the ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 " method, though it uses the ",
 Cell[BoxData["\"\<RadialDrawing\>\""], "InlineFormula"],
 " method if the graph is a tree."
}], "Notes",
 CellID->106260262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " returns an object of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", 
   RowBox[{
    ButtonBox["Annotation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Annotation"], "[", 
    RowBox[{
     StyleBox["data", "TI"], ",", 
     RowBox[{
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"], "->", 
      StyleBox["rules", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->233609336]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49203075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->259160533],

Cell["Draw a graph in 3D:", "ExampleText",
 CellID->154509960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->842440708],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
    1.2489078088843701`, 0.5255467015764722, 0.3620722620527624}, {
    0.6246093616342041, 1.1018346147779203`, 0.08722338092960641}, {
    0.624254498361977, 0., 0.}, {0.6239350024552749, 0.4752835519667111, 
    0.9966146808021568}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 
       4}, {3, 5}, {4, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.5258999070429866, 0.3615916580888974}, {
     1.2489078088843701`, 0.5255467015764722, 0.3620722620527624}, {
     0.6246093616342041, 1.1018346147779203`, 0.08722338092960641}, {
     0.624254498361977, 0., 0.}, {0.6239350024552749, 0.4752835519667111, 
     0.9966146808021568}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321399936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2526546],

Cell["Display vertex labels:", "ExampleText",
 CellID->474638002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614553804],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 0.5258987981659422, 0.3615942842699139}, {
    1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
    0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
    0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
    0.9966153364115204}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 3}, {2, 4}, {2, 5}, {3, 
       4}, {3, 5}, {4, 5}}]}, {Text3DBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], Text3DBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], Text3DBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], Text3DBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], Text3DBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.5258987981659422, 0.3615942842699139}, {
     1.2489076131700623`, 0.525544286476852, 0.36207014874114496`}, {
     0.6246083330617399, 1.1018343880069714`, 0.08722409832521527}, {
     0.6242515745492005, 0., 0.}, {0.6239375541972342, 0.4752828563336832, 
     0.9966153364115204}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1717555944,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24464],

Cell["Draw a graph specified by its adjacency matrix:", "ExampleText",
 CellID->16827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5705],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1167717610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239423027],

Cell["Use rendering and style options to tailor the presentation:", \
"ExampleText",
 CellID->44034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cylinder", "[", 
       RowBox[{"#1", ",", ".05"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"ColorData", "[", "\"\<Atoms\>\"", "]"}], "[", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "117"}], "}"}], "]"}], "]"}], ",", 
        RowBox[{"Sphere", "[", 
         RowBox[{"#1", ",", ".15"}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "20"}], "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356001663],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{
    {Specularity[
      GrayLevel[1], 20], 
     CylinderBox[{{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, {0., 0.6383721562676106, 
      0.0005166374503760146}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.8529587157814721, 0., 0.000058993543025062656`}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      1.4923842795065547`, 0.8518947103601523, 0.}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.6390758705051751, 1.4898647777696166`, 0.0005877776666556173}}, 0.05],
      CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.7471167161829144, 0.7442574629173819, 
      0.5463274426713254}, {0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}}, 0.05]}, 
    {Specularity[
      GrayLevel[1], 20], 
     {RGBColor[0.784314, 0.501961, 0.2], 
      SphereBox[{0.6390758705051751, 1.4898647777696166`, 
       0.0005877776666556173}, 0.15]}, 
     {RGBColor[0.894824, 0.731424, 0.325131], 
      SphereBox[{0., 0.6383721562676106, 0.0005166374503760146}, 0.15]}, 
     {RGBColor[0.628274, 0.850553, 0.0782731], 
      SphereBox[{0.8529587157814721, 0., 0.000058993543025062656`}, 0.15]}, 
     {RGBColor[0.573624, 0.399845, 0.661808], 
      SphereBox[{1.4923842795065547`, 0.8518947103601523, 0.}, 0.15]}, 
     {RGBColor[0.878431, 0.4, 0.2], 
      SphereBox[{0.7471167161829144, 0.7442574629173819, 0.5463274426713254}, 
       0.15]}}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.6390758705051751, 1.4898647777696166`, 
     0.0005877776666556173}, {0., 0.6383721562676106, 
     0.0005166374503760146}, {0.8529587157814721, 0., 
     0.000058993543025062656`}, {1.4923842795065547`, 0.8518947103601523, 
     0.}, {0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}]& ],
  AspectRatio->Automatic,
  ImageSize->{180., 149.74760192490155`},
  PlotRange->All,
  PlotRangePadding->Automatic,
  ViewPoint->{1.588839061592924, -2.3467950628034457`, 1.848822157363408},
  ViewVertical->{-0.03511036645858233, -0.09132297257995095, 
   2.107701758334389}]], "Output",
 ImageSize->{184, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200568142,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26664],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->369255627],

Cell["Specify a graph using a rule list:", "ExampleText",
 CellID->1096410170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2003953898],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682391938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1812687329],

Cell["Specify a graph using a dense adjacency matrix:", "ExampleText",
 CellID->107686483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4894094],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1098260347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1640804889],

Cell["Specify a graph using a sparse adjacency matrix: ", "ExampleText",
 CellID->497633172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430216091],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1316016864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1233819],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 " for collections of graphs: "
}], "ExampleText",
 CellID->149518306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{"GraphData", "[", 
     RowBox[{"g", ",", "\"\<EdgeRules\>\""}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<GeneralizedPetersen\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "2"}], "}"}]}], "}"}], ",", 
       "\"\<TesseractGraph\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2815895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.6509328828936183, 1.2646385965038918`, 
      1.6642822254446685`}, {1.1308460339873492`, 2.043775880365558, 
      1.1114394306798119`}, {1.401219944022496, 0.6155706299351184, 
      1.8363728421366994`}, {0.8657422081059183, 1.7572651890546422`, 
      0.37561741417070393`}, {1.7674315773220874`, 2.022429042290417, 
      1.1112785939904284`}, {0.9258027270682795, 0.8073870154334553, 0.}, {
      2.0135307875337687`, 1.7188327951587792`, 0.37533152744351184`}, {
      2.194296005138756, 1.2128777812032405`, 1.664689644828715}, {
      1.889640377337792, 0.7752778436276173, 0.00007170827296332227}, {0., 
      1.1815987145885662`, 1.0546382097473403`}, {0.18852648326154164`, 
      2.1587807598437547`, 0.7542605152912105}, {0.9540838998114, 
      2.8179639825072282`, 0.9312073322496234}, {1.9961776256163373`, 
      2.783326336369459, 0.9312439591613758}, {2.7159640250768513`, 
      2.0738892610591977`, 0.7545197555428648}, {2.8377154345416526`, 
      1.0864245910623693`, 1.0549815943744871`}, {2.2915235096264674`, 
      0.28181213664293026`, 0.6824286256431145}, {1.3806807562342687`, 0., 
      1.1113949439219544`}, {0.4911047013277775, 0.34288809829057976`, 
      0.6822655567455523}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 10}, {2, 7}, {2, 12}, {3, 17}, {4, 
         5}, {4, 6}, {4, 11}, {5, 8}, {5, 13}, {6, 18}, {7, 9}, {7, 14}, {8, 
         3}, {8, 15}, {9, 6}, {9, 16}, {10, 11}, {10, 18}, {11, 12}, {12, 
         13}, {13, 14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[17],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[18],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6509328828936183, 1.2646385965038918`, 
       1.6642822254446685`}, {1.1308460339873492`, 2.043775880365558, 
       1.1114394306798119`}, {1.401219944022496, 0.6155706299351184, 
       1.8363728421366994`}, {0.8657422081059183, 1.7572651890546422`, 
       0.37561741417070393`}, {1.7674315773220874`, 2.022429042290417, 
       1.1112785939904284`}, {0.9258027270682795, 0.8073870154334553, 0.}, {
       2.0135307875337687`, 1.7188327951587792`, 0.37533152744351184`}, {
       2.194296005138756, 1.2128777812032405`, 1.664689644828715}, {
       1.889640377337792, 0.7752778436276173, 0.00007170827296332227}, {0., 
       1.1815987145885662`, 1.0546382097473403`}, {0.18852648326154164`, 
       2.1587807598437547`, 0.7542605152912105}, {0.9540838998114, 
       2.8179639825072282`, 0.9312073322496234}, {1.9961776256163373`, 
       2.783326336369459, 0.9312439591613758}, {2.7159640250768513`, 
       2.0738892610591977`, 0.7545197555428648}, {2.8377154345416526`, 
       1.0864245910623693`, 1.0549815943744871`}, {2.2915235096264674`, 
       0.28181213664293026`, 0.6824286256431145}, {1.3806807562342687`, 0., 
       1.1113949439219544`}, {0.4911047013277775, 0.34288809829057976`, 
       0.6822655567455523}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{2.2883255526684994`, 0.8109519880607183, 
      0.9324954777306715}, {1.832802253118513, 0.03702607904443889, 
      0.4833492957040065}, {1.398124641730424, 0.8118349085593037, 0.}, {
      1.8293809521064772`, 1.585589053073933, 0.4878367457081389}, {
      1.8299878975814117`, 0.8075341915267422, 1.8264010767701637`}, {
      1.399246155012148, 0., 1.3962092320375366`}, {0.8817706351107589, 
      0.8078797639600878, 0.9329232861243189}, {1.395939026549845, 
      1.6149420986410572`, 1.4007636485234602`}, {0.8900229428192779, 
      0.805262215823636, 1.863146121538291}, {0.45926950995211047`, 
      0.031778977908916484`, 1.3764178862554763`}, {0., 0.8066195665078377, 
      0.9318302121998964}, {0.45585496762245326`, 1.5813234487957304`, 
      1.3808986186893337`}, {1.4056092282268131`, 0.8103195463043348, 
      0.930486538931486}, {0.8924113166360428, 0.0025003964648230292`, 
      0.462590904479621}, {0.4584903413830621, 0.8101972441992584, 
      0.037312108368178665`}, {0.8889696618217534, 1.6172898578161732`, 
      0.46803150670151467`}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 5}, {1, 13}, {2, 3}, {2, 6}, {2, 14}, {
         3, 4}, {3, 7}, {3, 15}, {4, 8}, {4, 16}, {5, 6}, {5, 8}, {5, 9}, {6, 
         7}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 10}, {9, 12}, {9, 13}, {
         10, 11}, {10, 14}, {11, 12}, {11, 15}, {12, 16}, {13, 14}, {13, 
         16}, {14, 15}, {15, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "16"],
         Annotation[#, 16, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.2883255526684994`, 0.8109519880607183, 
       0.9324954777306715}, {1.832802253118513, 0.03702607904443889, 
       0.4833492957040065}, {1.398124641730424, 0.8118349085593037, 0.}, {
       1.8293809521064772`, 1.585589053073933, 0.4878367457081389}, {
       1.8299878975814117`, 0.8075341915267422, 1.8264010767701637`}, {
       1.399246155012148, 0., 1.3962092320375366`}, {0.8817706351107589, 
       0.8078797639600878, 0.9329232861243189}, {1.395939026549845, 
       1.6149420986410572`, 1.4007636485234602`}, {0.8900229428192779, 
       0.805262215823636, 1.863146121538291}, {0.45926950995211047`, 
       0.031778977908916484`, 1.3764178862554763`}, {0., 0.8066195665078377, 
       0.9318302121998964}, {0.45585496762245326`, 1.5813234487957304`, 
       1.3808986186893337`}, {1.4056092282268131`, 0.8103195463043348, 
       0.930486538931486}, {0.8924113166360428, 0.0025003964648230292`, 
       0.462590904479621}, {0.4584903413830621, 0.8101972441992584, 
       0.037312108368178665`}, {0.8889696618217534, 1.6172898578161732`, 
       0.46803150670151467`}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->292595254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556990123],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 " for collections of sparse matrices: "
}], "ExampleText",
 CellID->587125292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<Bai/Dwa512\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2132219943],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26987676]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4212966],

Cell["Give vertex labels:", "ExampleText",
 CellID->250888577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351220558],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}, {0.5005929727778766, 0.8635423780726239, 
    0.4739247390459652}, {0.4920172509665102, 0.8407288343650516, 
    0.45929268978759186`}, {0.48254980183176827`, 0.8183424512798847, 
    0.44455108519962555`}, {0.4722022197954076, 0.7964106445616815, 
    0.429717978759675}, {0.4609871771441853, 0.7749602732527634, 
    0.4148115360041569}, {0.44891840851059517`, 0.7540176067999749, 
    0.39985001228165995`}, {0.4360106940525902, 0.7336082928834996, 
    0.3848517303963203}, {0.42227984135289026`, 0.7137573260071315, 
    0.3698350581685859}, {0.2233674474028645, 0.4384884307090406, 
    0.15850073921510838`}, {0.2088302721100161, 0.4192201215903733, 
    0.14348406698737398`}, {0.19350457734491278`, 0.40055806738839683`, 
    0.12848578510203437`}, {0.17740913189799573`, 0.38252512280496265`, 
    0.11352426137953746`}, {0.16056364724383648`, 0.3651433720955066, 
    0.09861781862401932}, {0.14298875340125003`, 0.34843410202330893`, 
    0.0837847121840688}, {0.12470597366850197`, 0.3324177757904116, 
    0.06904310759610248}, {0.1057376982645513, 0.31711400797711975`, 
    0.0544110583377291}, {0.45885630665416527`, 0.893701761555346, 
    0.4739247390459652}, {0.43988803125021464`, 0.8783979937420543, 
    0.45929268978759186`}, {0.4216052515174666, 0.8623816675091568, 
    0.44455108519962555`}, {0.4040303576748801, 0.8456723974369592, 
    0.429717978759675}, {0.38718487302072085`, 0.8282906467275032, 
    0.4148115360041569}, {0.37108942757380375`, 0.8102577021440689, 
    0.39985001228165995`}, {0.35576373280870055`, 0.7915956479420925, 
    0.3848517303963203}, {0.34122655751585207`, 0.7723273388234252, 
    0.3698350581685859}, {0.1423141635658264, 0.49705844352533424`, 
    0.15850073921510838`}, {0.1285833108661265, 0.4772074766489661, 
    0.14348406698737398`}, {0.1156755964081216, 0.45679816273249085`, 
    0.12848578510203437`}, {0.10360682777453145`, 0.43585549627970216`, 
    0.11352426137953746`}, {0.09239178512330914, 0.41440512497078413`, 
    0.09861781862401932}, {0.08204420308694851, 0.39247331825258114`, 
    0.0837847121840688}, {0.07257675395220656, 0.3700869351674141, 
    0.06904310759610248}, {0.06400103214084014, 0.34727339145984165`, 
    0.0544110583377291}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {2, 3}, {2, 4}, {3, 4}, {4, 5, 6, 7, 8, 9, 
        10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 1}, {4, 21, 22, 23, 24, 
        25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 1}}]}, {Text3DBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], Text3DBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], Text3DBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], Text3DBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531558036,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1301177980],

Cell["Do not show multiedges or self-loops:", "ExampleText",
 CellID->956609091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "False"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1761264953],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1171508751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996109397],

Cell["Plot a disconnected graph:", "ExampleText",
 CellID->2995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"i", "\[Rule]", 
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"i", "^", "2"}], ",", "102"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "102"}], "}"}]}], "]"}], ",", 
     RowBox[{"PackingMethod", "\[Rule]", "pm"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pm", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Automatic\>\"", ",", "\"\<ClosestPacking\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[1]:=",
 CellID->1209134277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmHk4ld3Xx48585BDJZxRoULGSJb4JTKkolJCRVQaKD3KlEeUKMmYclLI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      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 1}, {2, 
          127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
          140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 2}, {3, 4}, {4, 
          7}, {5, 6}, {6, 16}, {7, 29}, {8, 9}, {9, 23}, {10, 11}, {11, 54}, {
          12, 13}, {13, 33}, {14, 15}, {15, 7}, {16, 35}, {17, 18}, {18, 4}, {
          19, 20}, {20, 33}, {21, 22}, {22, 46}, {23, 24}, {24, 2}, {25, 
          26}, {26, 15}, {27, 28}, {28, 35}, {29, 150, 151, 152, 153, 154, 
          155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
          168, 169, 170, 171, 172, 29}, {30, 31}, {31, 173, 174, 175, 176, 
          177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
          190, 191, 192, 193, 194, 195, 31}, {32, 196, 197, 198, 199, 200, 
          201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 
          214, 215, 216, 217, 218, 32}, {33, 24}, {34, 26}, {35, 51}, {36, 
          37}, {37, 15}, {38, 20}, {39, 40}, {40, 54}, {41, 15}, {42, 27}, {
          43, 44}, {44, 4}, {45, 9}, {46, 47}, {47, 32}, {48, 49}, {49, 23}, {
          50, 4}, {51, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 
          230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 51}, {
          52, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
           255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 52}, {53, 2}, {
          54, 47}, {55, 49}, {56, 7}, {57, 58}, {58, 16}, {59, 44}, {60, 
          13}, {61, 18}, {62, 63}, {63, 28}, {64, 37}, {65, 24}, {66, 67}, {
          67, 46}, {68, 29}, {69, 265, 266, 267, 268, 269, 270, 271, 272, 273,
           274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 
          287, 69}, {70, 33}, {71, 67}, {72, 37}, {73, 63}, {74, 18}, {75, 
          23}, {76, 13}, {77, 44}, {78, 58}, {79, 49}, {80, 52}, {81, 49}, {
          82, 9}, {83, 44}, {84, 27}, {85, 23}, {86, 40}, {87, 20}, {88, 
          37}, {89, 26}, {90, 33}, {91, 29}, {92, 26}, {93, 24}, {94, 22}, {
          95, 20}, {96, 18}, {97, 13}, {98, 11}, {99, 9}, {100, 7}, {101, 
          6}, {102, 2}, {103, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "25"],
         Annotation[#, 25, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "36"],
         Annotation[#, 36, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "49"],
         Annotation[#, 49, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "64"],
         Annotation[#, 64, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "81"],
         Annotation[#, 81, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[17],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[18],
          "100"],
         Annotation[#, 100, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[19],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[20],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[21],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[22],
          "42"],
         Annotation[#, 42, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[23],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[24],
          "67"],
         Annotation[#, 67, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[25],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[26],
          "94"],
         Annotation[#, 94, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[27],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[28],
          "21"],
         Annotation[#, 21, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[29],
          "52"],
         Annotation[#, 52, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[30],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[31],
          "85"],
         Annotation[#, 85, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[32],
          "18"],
         Annotation[#, 18, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[33],
          "55"],
         Annotation[#, 55, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[34],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[35],
          "33"],
         Annotation[#, 33, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[36],
          "22"],
         Annotation[#, 22, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[37],
          "76"],
         Annotation[#, 76, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[38],
          "23"],
         Annotation[#, 23, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[39],
          "24"],
         Annotation[#, 24, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[40],
          "66"],
         Annotation[#, 66, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[41],
          "26"],
         Annotation[#, 26, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[42],
          "27"],
         Annotation[#, 27, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[43],
          "28"],
         Annotation[#, 28, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[44],
          "70"],
         Annotation[#, 70, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[45],
          "29"],
         Annotation[#, 29, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[46],
          "30"],
         Annotation[#, 30, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[47],
          "84"],
         Annotation[#, 84, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[48],
          "31"],
         Annotation[#, 31, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[49],
          "43"],
         Annotation[#, 43, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[50],
          "32"],
         Annotation[#, 32, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[51],
          "69"],
         Annotation[#, 69, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[52],
          "34"],
         Annotation[#, 34, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[53],
          "35"],
         Annotation[#, 35, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[54],
          "72"],
         Annotation[#, 72, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[55],
          "37"],
         Annotation[#, 37, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[56],
          "38"],
         Annotation[#, 38, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[57],
          "39"],
         Annotation[#, 39, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[58],
          "93"],
         Annotation[#, 93, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[59],
          "40"],
         Annotation[#, 40, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[60],
          "41"],
         Annotation[#, 41, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[61],
          "44"],
         Annotation[#, 44, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[62],
          "45"],
         Annotation[#, 45, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[63],
          "87"],
         Annotation[#, 87, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[64],
          "46"],
         Annotation[#, 46, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[65],
          "47"],
         Annotation[#, 47, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[66],
          "48"],
         Annotation[#, 48, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[67],
          "60"],
         Annotation[#, 60, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[68],
          "50"],
         Annotation[#, 50, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[69],
          "51"],
         Annotation[#, 51, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[70],
          "53"],
         Annotation[#, 53, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[71],
          "54"],
         Annotation[#, 54, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[72],
          "56"],
         Annotation[#, 56, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[73],
          "57"],
         Annotation[#, 57, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[74],
          "58"],
         Annotation[#, 58, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[75],
          "59"],
         Annotation[#, 59, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[76],
          "61"],
         Annotation[#, 61, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[77],
          "62"],
         Annotation[#, 62, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[78],
          "63"],
         Annotation[#, 63, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[79],
          "65"],
         Annotation[#, 65, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[80],
          "68"],
         Annotation[#, 68, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[81],
          "71"],
         Annotation[#, 71, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[82],
          "73"],
         Annotation[#, 73, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[83],
          "74"],
         Annotation[#, 74, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[84],
          "75"],
         Annotation[#, 75, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[85],
          "77"],
         Annotation[#, 77, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[86],
          "78"],
         Annotation[#, 78, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[87],
          "79"],
         Annotation[#, 79, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[88],
          "80"],
         Annotation[#, 80, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[89],
          "82"],
         Annotation[#, 82, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[90],
          "83"],
         Annotation[#, 83, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[91],
          "86"],
         Annotation[#, 86, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[92],
          "88"],
         Annotation[#, 88, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[93],
          "89"],
         Annotation[#, 89, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[94],
          "90"],
         Annotation[#, 90, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[95],
          "91"],
         Annotation[#, 91, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[96],
          "92"],
         Annotation[#, 92, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[97],
          "95"],
         Annotation[#, 95, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[98],
          "96"],
         Annotation[#, 96, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[99],
          "97"],
         Annotation[#, 97, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[100],
          "98"],
         Annotation[#, 98, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[101],
          "99"],
         Annotation[#, 99, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[102],
          "101"],
         Annotation[#, 101, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[103],
          "102"],
         Annotation[#, 102, "Tooltip"]& ]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllXs0lHkYx6dxKYWYg5yGaa50Oy7lFk0eaTnJJSVJRI5GKhGl0ii1wqJC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       "]]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxl2Hk4lN37AHDGzliSxppsM2OtJBLV3G2KSihvZGn7JqVI0mtL6pVIylaR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      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 1}, {2, 
          127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
          140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 2}, {3, 4}, {4, 
          7}, {5, 6}, {6, 16}, {7, 29}, {8, 9}, {9, 23}, {10, 11}, {11, 54}, {
          12, 13}, {13, 33}, {14, 15}, {15, 7}, {16, 35}, {17, 18}, {18, 4}, {
          19, 20}, {20, 33}, {21, 22}, {22, 46}, {23, 24}, {24, 2}, {25, 
          26}, {26, 15}, {27, 28}, {28, 35}, {29, 150, 151, 152, 153, 154, 
          155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
          168, 169, 170, 171, 172, 29}, {30, 31}, {31, 173, 174, 175, 176, 
          177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
          190, 191, 192, 193, 194, 195, 31}, {32, 196, 197, 198, 199, 200, 
          201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 
          214, 215, 216, 217, 218, 32}, {33, 24}, {34, 26}, {35, 51}, {36, 
          37}, {37, 15}, {38, 20}, {39, 40}, {40, 54}, {41, 15}, {42, 27}, {
          43, 44}, {44, 4}, {45, 9}, {46, 47}, {47, 32}, {48, 49}, {49, 23}, {
          50, 4}, {51, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 
          230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 51}, {
          52, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
           255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 52}, {53, 2}, {
          54, 47}, {55, 49}, {56, 7}, {57, 58}, {58, 16}, {59, 44}, {60, 
          13}, {61, 18}, {62, 63}, {63, 28}, {64, 37}, {65, 24}, {66, 67}, {
          67, 46}, {68, 29}, {69, 265, 266, 267, 268, 269, 270, 271, 272, 273,
           274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 
          287, 69}, {70, 33}, {71, 67}, {72, 37}, {73, 63}, {74, 18}, {75, 
          23}, {76, 13}, {77, 44}, {78, 58}, {79, 49}, {80, 52}, {81, 49}, {
          82, 9}, {83, 44}, {84, 27}, {85, 23}, {86, 40}, {87, 20}, {88, 
          37}, {89, 26}, {90, 33}, {91, 29}, {92, 26}, {93, 24}, {94, 22}, {
          95, 20}, {96, 18}, {97, 13}, {98, 11}, {99, 9}, {100, 7}, {101, 
          6}, {102, 2}, {103, 1}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "0"],
         Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "25"],
         Annotation[#, 25, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "36"],
         Annotation[#, 36, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "49"],
         Annotation[#, 49, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "64"],
         Annotation[#, 64, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "81"],
         Annotation[#, 81, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[17],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[18],
          "100"],
         Annotation[#, 100, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[19],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[20],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[21],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[22],
          "42"],
         Annotation[#, 42, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[23],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[24],
          "67"],
         Annotation[#, 67, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[25],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[26],
          "94"],
         Annotation[#, 94, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[27],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[28],
          "21"],
         Annotation[#, 21, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[29],
          "52"],
         Annotation[#, 52, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[30],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[31],
          "85"],
         Annotation[#, 85, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[32],
          "18"],
         Annotation[#, 18, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[33],
          "55"],
         Annotation[#, 55, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[34],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[35],
          "33"],
         Annotation[#, 33, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[36],
          "22"],
         Annotation[#, 22, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[37],
          "76"],
         Annotation[#, 76, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[38],
          "23"],
         Annotation[#, 23, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[39],
          "24"],
         Annotation[#, 24, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[40],
          "66"],
         Annotation[#, 66, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[41],
          "26"],
         Annotation[#, 26, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[42],
          "27"],
         Annotation[#, 27, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[43],
          "28"],
         Annotation[#, 28, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[44],
          "70"],
         Annotation[#, 70, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[45],
          "29"],
         Annotation[#, 29, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[46],
          "30"],
         Annotation[#, 30, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[47],
          "84"],
         Annotation[#, 84, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[48],
          "31"],
         Annotation[#, 31, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[49],
          "43"],
         Annotation[#, 43, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[50],
          "32"],
         Annotation[#, 32, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[51],
          "69"],
         Annotation[#, 69, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[52],
          "34"],
         Annotation[#, 34, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[53],
          "35"],
         Annotation[#, 35, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[54],
          "72"],
         Annotation[#, 72, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[55],
          "37"],
         Annotation[#, 37, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[56],
          "38"],
         Annotation[#, 38, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[57],
          "39"],
         Annotation[#, 39, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[58],
          "93"],
         Annotation[#, 93, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[59],
          "40"],
         Annotation[#, 40, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[60],
          "41"],
         Annotation[#, 41, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[61],
          "44"],
         Annotation[#, 44, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[62],
          "45"],
         Annotation[#, 45, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[63],
          "87"],
         Annotation[#, 87, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[64],
          "46"],
         Annotation[#, 46, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[65],
          "47"],
         Annotation[#, 47, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[66],
          "48"],
         Annotation[#, 48, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[67],
          "60"],
         Annotation[#, 60, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[68],
          "50"],
         Annotation[#, 50, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[69],
          "51"],
         Annotation[#, 51, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[70],
          "53"],
         Annotation[#, 53, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[71],
          "54"],
         Annotation[#, 54, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[72],
          "56"],
         Annotation[#, 56, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[73],
          "57"],
         Annotation[#, 57, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[74],
          "58"],
         Annotation[#, 58, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[75],
          "59"],
         Annotation[#, 59, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[76],
          "61"],
         Annotation[#, 61, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[77],
          "62"],
         Annotation[#, 62, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[78],
          "63"],
         Annotation[#, 63, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[79],
          "65"],
         Annotation[#, 65, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[80],
          "68"],
         Annotation[#, 68, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[81],
          "71"],
         Annotation[#, 71, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[82],
          "73"],
         Annotation[#, 73, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[83],
          "74"],
         Annotation[#, 74, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[84],
          "75"],
         Annotation[#, 75, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[85],
          "77"],
         Annotation[#, 77, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[86],
          "78"],
         Annotation[#, 78, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[87],
          "79"],
         Annotation[#, 79, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[88],
          "80"],
         Annotation[#, 80, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[89],
          "82"],
         Annotation[#, 82, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[90],
          "83"],
         Annotation[#, 83, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[91],
          "86"],
         Annotation[#, 86, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[92],
          "88"],
         Annotation[#, 88, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[93],
          "89"],
         Annotation[#, 89, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[94],
          "90"],
         Annotation[#, 90, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[95],
          "91"],
         Annotation[#, 91, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[96],
          "92"],
         Annotation[#, 92, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[97],
          "95"],
         Annotation[#, 95, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[98],
          "96"],
         Annotation[#, 96, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[99],
          "97"],
         Annotation[#, 97, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[100],
          "98"],
         Annotation[#, 98, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[101],
          "99"],
         Annotation[#, 99, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[102],
          "101"],
         Annotation[#, 101, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[103],
          "102"],
         Annotation[#, 102, "Tooltip"]& ]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdlXs01GkYx4cx05iGNGkSmp0Z/GZQMl0krHl2K902ydLNpdJBS+kihSZU
jIQSXXRTIlmTalVUFF00pV2XUsmlEoPkspSwYbedtvf12985v38+5z3P5fs+
z/fle2109lanUCi+X37ql7/MbTvTdW6nZP7cB3KJpX4R5b/voFVuct0rAsbS
DFxk800QXycKKW7wM4Fg8zhNeXd94TduJw1P5TobA6VBWjZv4xDijA972Hm6
nySUsMb26Pw8yTeer0zbEvOsW5Jp2JAYY9eOzg8pym68fmIC3uEaDrRKCspb
npjiLfYxhklbSlJvaRsh7vrKab1NnDHM2HlbWmyL6zyjq5Hx/B4XzqXQxk91
4CP+MaHwQAbBBfnF8xF/SbmIh4ew3L2UQtgyxziwLdwc8e30rQ96qkUQ+7vy
ecQ+U8RX0pS9ameNYUKsWDHahYV4Rtj+43vbCLi7gPYo04aGuH3ROPUXyZ8k
9ulOVfqn/kb9JvV2c5I0v+g2x6TLkypH+mzctaQv/rQROJ1gRUi1/kTnmamU
D8wMcwhdtaj0YYoIxV/ivHX3kQAz0FxWZO1TRiAeZm/BijihA9tKVtTPkHMQ
j7R10s1NZMO1Rmt3sQO+94Y5lSZBd0ygPy0sq26GEPGl3/87J0LwarlFil/i
sOCx0soEQn1uRsnkoxGnv+sU6aQSkN4Xw9CuxvrkPWl2aC+gQWOLD/2nDMwT
pu8YcHtDhzGGRxOW0jQQJ8QJKj1ZA7qye9V9SIeWbNuorLReyWSaxaabkwXo
fEpeh27W/leSm5JJJF4b5fa549dx8Dw19mmNvx7irfnjO6f9IQKWbwSp3+CO
xZkvAwjwKcsn9bXVt0YRHqQG0vF1Tmcb8Xy63SnY0SozBY0hRkS1GPc1NGpT
65pKEYD9YXUFC/elXVw7u6bXHOghK/YFbsB5fVaOdGUG8GCReC3pvoIYfm+F
dwyh1vTNAtlBzAMyDKvf5ohgXU+F1JCP9ZkfV66qs5JzsHlDJa4/+kjgwwlT
+PBAr3Gc7cMBdH7zQYsYjwoBMF2jSXXGb44KvCAzAgG7IenHDrx3x1il4E7n
ACdWsfpMmyHiL+9+51aSrwfsC+3g4G6AeNGQTnnpEQGMZLmQ+lU/v1i1vz9b
53+kr8XzrLe7rLqp3QjGzXzaw7/KRFx60S/a6hgV1g1atR0f8Qn3q/IvFnSd
MfLSjyfQedtYduWnOgI+PwkpYF3C9a8R7g1zKTeA3KojpbYVeP533XnPP90i
ANGSeaT9ss8rPu7oT4DnozrmkBDn5fHcHpW7FRUutGgfekNg3UpmOodOCG+V
xB2eXc4kRiBuzf2qv4GcQWmfRUXcq5RyJo9jCom35vMNLbD/rLVx9vf7LIAE
o0ndFdxylLfWw9jRs280WCao/z0876F+qWumQgt0kqmjujYNovNWLuDXKDCD
Eq+9FTP6cT0O6s52j+uF0Nlo8z5sJfZPDm+qzu0rbAjgq5P807wo8cSYZA6M
1KqKj0/hIa5Je6BsWiCCyGD+oVkR3Sgvu+mrn///fVmfqb+xWGEKlu8seP0N
xoj/4Kqvmh9dA0aEeBXe38W3zOWpgWagweGSdMs+1ziFWaMDRQd4cznMDpR3
bG59byVXAH21HMuiKiXinKd3M9axCVjvc//ptBvYzz2DHC8Fi8ygPjSnTDvB
DPEcMw/Nmt18iNywlaTbzWjGw5OHlRKducypb2ePQnzAeo9qX7JeHq6LuYzj
f+1fA6Q1AtJ8vsg+oXrX6MQlUt42ol01hwU8yzQqBd/L58jXqr4OVfeGD/cZ
6sh0j+QoLWi11SPV846vo5r/yAtq1wo7cT3e2dtC3bsMoGnW4z56LBvx19fr
VL50Pcm0ebkY19mWPVGlf3KHtt5w3zjXkeU+8aQQMsxaqCwm9pnBJKbR3Smm
QDyZUNnjiO83Xa0iuSpPCMsVb5efLXuP4gw0L2S4ZolAVqBYZJmO61/tLTfR
kAohTf9k6EwJ1sFufWn9sgFtCMntOeo9iP3ntT9V9T5qTZ5O0s0/1lN1jyKZ
dtA5jw8o7/M239TBEebAFR8n3ddOK7nX1QEebPalJA+Pnxk8WuVjtwljkj5X
3gxcqaMTEOb/C+OyUw+Kf/l91Okcx3sSvRXPHIbP5zJ2sWoO2dLcU0eV2Jd4
Mt3fPMceLVxVcJ+0L/8AvyL4Qw==
       "]]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{390, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[1]=",
 CellID->418703521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739766316],

Cell["\<\
For very large graphs, it is often better not to draw vertices at all:\
\>", "ExampleText",
 CellID->1632065829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "500"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "500"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693558391],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40583224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198996824],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " for detailed control: "
}], "ExampleText",
 CellID->66078131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cylinder", "[", 
       RowBox[{"#1", ",", ".05"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#1", ",", ".1"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25225345],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, {0., 0.6383721562676106, 
      0.0005166374503760146}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.8529587157814721, 0., 0.000058993543025062656`}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      1.4923842795065547`, 0.8518947103601523, 0.}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.6390758705051751, 1.4898647777696166`, 0.0005877776666556173}}, 0.05],
      CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.7471167161829144, 0.7442574629173819, 
      0.5463274426713254}, {0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}}, 0.05]}, {
     SphereBox[{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, 0.1], 
     SphereBox[{0., 0.6383721562676106, 0.0005166374503760146}, 0.1], 
     SphereBox[{0.8529587157814721, 0., 0.000058993543025062656`}, 0.1], 
     SphereBox[{1.4923842795065547`, 0.8518947103601523, 0.}, 0.1], 
     SphereBox[{0.7471167161829144, 0.7442574629173819, 0.5463274426713254}, 
      0.1]}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.6390758705051751, 1.4898647777696166`, 
     0.0005877776666556173}, {0., 0.6383721562676106, 
     0.0005166374503760146}, {0.8529587157814721, 0., 
     0.000058993543025062656`}, {1.4923842795065547`, 0.8518947103601523, 
     0.}, {0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250175321,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29965],

Cell["Use different methods to get different layouts:", "ExampleText",
 CellID->381125490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", "10", "}"}], ",", 
       RowBox[{"{", "10", "}"}]}], "]"}], ",", 
     RowBox[{"Method", "\[Rule]", "md"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"md", ",", 
     RowBox[{"{", 
      RowBox[{
      "Automatic", ",", "\"\<CircularEmbedding\>\"", ",", 
       "\"\<SpringEmbedding\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448969433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.9599783287298667, 0.018738480002704172`, 
      0.8228742299453742}, {0.39309584105931356`, 0., 0.36389020286388446`}, {
      0.3735651133117312, 1.1100096234968304`, 0.8575952383789729}, {
      0.3668827716327681, 0.339498106129567, 1.1331222420332554`}, {
      0.973921386199005, 0.7737808029962083, 1.1436907195781303`}, {0., 
      0.5715057553323957, 0.5336159291980741}, {1.3343728112414683`, 
      0.5637603610206549, 0.5265247001798242}, {0.9496570489178419, 
      1.1556117522927671`, 0.40298752369445223`}, {0.41211230882709216`, 
      0.8532925526560646, 0.028659230815795134`}, {0.9112094910763441, 
      0.3406049272307131, 0.}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1,
          9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 
         9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
         10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
         7}, {5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 
         8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {9, 10}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.9599783287298667, 0.018738480002704172`, 
       0.8228742299453742}, {0.39309584105931356`, 0., 
       0.36389020286388446`}, {0.3735651133117312, 1.1100096234968304`, 
       0.8575952383789729}, {0.3668827716327681, 0.339498106129567, 
       1.1331222420332554`}, {0.973921386199005, 0.7737808029962083, 
       1.1436907195781303`}, {0., 0.5715057553323957, 0.5336159291980741}, {
       1.3343728112414683`, 0.5637603610206549, 0.5265247001798242}, {
       0.9496570489178419, 1.1556117522927671`, 0.40298752369445223`}, {
       0.41211230882709216`, 0.8532925526560646, 0.028659230815795134`}, {
       0.9112094910763441, 0.3406049272307131, 0.}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{1.3416407864998738`, 0.6379881062938119, 0.}, {
      1.2135254915695022`, 1.0322864403734158`, 0.}, {0.8781152949603676, 
      1.2759762125503964`, 0.}, {0.46352549159679346`, 1.27597621256901, 
      0.}, {0.1281152949657769, 1.032286440422147, 0.}, {0., 
      0.637988106354047, 0.}, {0.1281152948949662, 0.2436897722629393, 0.}, {
      0.4635254914822195, 5.584099849187396*^-11, 0.}, {0.8781152948457934, 
      0., 0.}, {1.2135254914986913`, 0.2436897721167452, 0.}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1,
          9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 
         9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
         10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
         7}, {5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 
         8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {9, 10}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.3416407864998738`, 0.6379881062938119, 
       0.}, {1.2135254915695022`, 1.0322864403734158`, 0.}, {
       0.8781152949603676, 1.2759762125503964`, 0.}, {0.46352549159679346`, 
       1.27597621256901, 0.}, {0.1281152949657769, 1.032286440422147, 0.}, {
       0., 0.637988106354047, 0.}, {0.1281152948949662, 0.2436897722629393, 
       0.}, {0.4635254914822195, 5.584099849187396*^-11, 0.}, {
       0.8781152948457934, 0., 0.}, {1.2135254914986913`, 0.2436897721167452, 
       0.}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.323592542072384, 0.4673041356783296, 
      1.1863955682110139`}, {0.3832400445728782, 1.1655522919404486`, 
      0.8031051365055124}, {0.34022046971554315`, 0., 0.524798421507198}, {
      0.9726030406602706, 0.8489073818030234, 1.1469802632729689`}, {
      0.8836555030227753, 0.20710026416400623`, 0.10722467388574597`}, {0., 
      0.6261682081569737, 0.5087903845866846}, {1.3235979987695352`, 
      0.5423017375812899, 0.5504417211373555}, {0.46933800120622515`, 
      0.7714766001412148, 0.}, {0.963814651694465, 1.1264847614062419`, 
      0.36767456680857746`}, {0.9293119542164455, 0.07480941467093505, 
      0.9615281228617322}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1,
          9}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 
         9}, {2, 10}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
         10}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {4, 10}, {5, 6}, {5, 
         7}, {5, 8}, {5, 9}, {5, 10}, {6, 7}, {6, 8}, {6, 9}, {6, 10}, {7, 
         8}, {7, 9}, {7, 10}, {8, 9}, {8, 10}, {9, 10}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "10"],
         Annotation[#, 10, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.323592542072384, 0.4673041356783296, 
       1.1863955682110139`}, {0.3832400445728782, 1.1655522919404486`, 
       0.8031051365055124}, {0.34022046971554315`, 0., 0.524798421507198}, {
       0.9726030406602706, 0.8489073818030234, 1.1469802632729689`}, {
       0.8836555030227753, 0.20710026416400623`, 0.10722467388574597`}, {0., 
       0.6261682081569737, 0.5087903845866846}, {1.3235979987695352`, 
       0.5423017375812899, 0.5504417211373555}, {0.46933800120622515`, 
       0.7714766001412148, 0.}, {0.963814651694465, 1.1264847614062419`, 
       0.36767456680857746`}, {0.9293119542164455, 0.07480941467093505, 
       0.9615281228617322}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{491, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->159753063]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4827],

Cell[TextData[{
 "Plot graphs generated by ",
 StyleBox["Combinatorica:",
  FontSlant->"Italic"]
}], "ExampleText",
 CellID->12382],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72863096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"ButterflyGraph", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323993010],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.25406567996491325`, 2.081766543384009, 
    0.00010434970835154767`}, {0., 1.1744657301111634`, 0.3323397457336863}, {
    0.20922046996979227`, 0.25469279686396384`, 0.}, {2.036694346854802, 
    0.2085371525785591, 0.0002532416476079269}, {1.1162499031061688`, 0., 
    0.33248449407965763`}, {0.20778997160955104`, 0.25494530775290325`, 
    0.6645380847205984}, {0.25431477444924167`, 2.083154263321488, 
    0.6647664512486793}, {1.1746830309466094`, 2.2914574180478287`, 
    0.3323669659797754}, {2.0827529139498164`, 2.0369894414520058`, 
    0.0000662507431209991}, {2.0356427506650236`, 0.2087012212850884, 
    0.6649269992462039}, {2.291079507698286, 1.116057612711652, 
    0.33244325255757656`}, {2.0829229004057463`, 2.0356286933688152`, 
    0.6647864423643455}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 8}, {2, 3}, {2, 6}, {2, 7}, {3, 5}, {4, 5}, {4, 
       11}, {5, 6}, {5, 10}, {7, 8}, {8, 9}, {8, 12}, {9, 11}, {10, 11}, {11, 
       12}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.25406567996491325`, 2.081766543384009, 
     0.00010434970835154767`}, {0., 1.1744657301111634`, 
     0.3323397457336863}, {0.20922046996979227`, 0.25469279686396384`, 0.}, {
     2.036694346854802, 0.2085371525785591, 0.0002532416476079269}, {
     1.1162499031061688`, 0., 0.33248449407965763`}, {0.20778997160955104`, 
     0.25494530775290325`, 0.6645380847205984}, {0.25431477444924167`, 
     2.083154263321488, 0.6647664512486793}, {1.1746830309466094`, 
     2.2914574180478287`, 0.3323669659797754}, {2.0827529139498164`, 
     2.0369894414520058`, 0.0000662507431209991}, {2.0356427506650236`, 
     0.2087012212850884, 0.6649269992462039}, {2.291079507698286, 
     1.116057612711652, 0.33244325255757656`}, {2.0829229004057463`, 
     2.0356286933688152`, 0.6647864423643455}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29927820]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->597282073],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65693485],

Cell["Draw vertices only:", "ExampleText",
 CellID->26472224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "20", "}"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020060192],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.6664860546661757, 0.15886181723864556`, 
    1.1198044587391005`}, {0.9668207805336966, 0.06698646295413824, 
    0.6066092561854979}, {1.1341299730795247`, 1.0488226261190117`, 
    0.41944372472144764`}, {0.032306788029477396`, 0.8997599103722558, 
    0.9312918385560864}, {0.6308743341659453, 1.167428753624086, 
    0.1860857382566728}, {0.9476079370693338, 0.6712717341885157, 
    0.04597698407549888}, {0.260524311780374, 1.2429775372580973`, 
    0.563670433591125}, {0., 0.8012563329052503, 0.37077382054116675`}, {
    0.7743782909854537, 1.3222339796878433`, 0.7534652383391304}, {
    0.7919117730464904, 0.7143479365511884, 1.31279849221987}, {
    1.1429152651960046`, 0.9680461392995454, 0.9647079342899811}, {
    0.4175170964613226, 0., 0.6758767334077882}, {0.7300801718304126, 
    0.19780909034296834`, 0.15101431334220644`}, {1.2646977958399117`, 
    0.5171347421112806, 0.47281373611657274`}, {0.010909473123374869`, 
    0.35247162223301126`, 0.7835544869806252}, {0.280631255669034, 
    0.5099382702408398, 1.2336289792332198`}, {1.1572318625788398`, 
    0.4201168113839938, 1.002253423272997}, {0.3970068503672394, 
    0.7258225688162888, 0.}, {0.48644363747196295`, 1.115589930183683, 
    1.1512460802762263`}, {0.19721701206847203`, 0.27954160896880903`, 
    0.2527926567178459}}, {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.6664860546661757, 0.15886181723864556`, 
     1.1198044587391005`}, {0.9668207805336966, 0.06698646295413824, 
     0.6066092561854979}, {1.1341299730795247`, 1.0488226261190117`, 
     0.41944372472144764`}, {0.032306788029477396`, 0.8997599103722558, 
     0.9312918385560864}, {0.6308743341659453, 1.167428753624086, 
     0.1860857382566728}, {0.9476079370693338, 0.6712717341885157, 
     0.04597698407549888}, {0.260524311780374, 1.2429775372580973`, 
     0.563670433591125}, {0., 0.8012563329052503, 0.37077382054116675`}, {
     0.7743782909854537, 1.3222339796878433`, 0.7534652383391304}, {
     0.7919117730464904, 0.7143479365511884, 1.31279849221987}, {
     1.1429152651960046`, 0.9680461392995454, 0.9647079342899811}, {
     0.4175170964613226, 0., 0.6758767334077882}, {0.7300801718304126, 
     0.19780909034296834`, 0.15101431334220644`}, {1.2646977958399117`, 
     0.5171347421112806, 0.47281373611657274`}, {0.010909473123374869`, 
     0.35247162223301126`, 0.7835544869806252}, {0.280631255669034, 
     0.5099382702408398, 1.2336289792332198`}, {1.1572318625788398`, 
     0.4201168113839938, 1.002253423272997}, {0.3970068503672394, 
     0.7258225688162888, 0.}, {0.48644363747196295`, 1.115589930183683, 
     1.1512460802762263`}, {0.19721701206847203`, 0.27954160896880903`, 
     0.2527926567178459}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273857571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141508825],

Cell["\<\
Draws edges using gray lines, and self-loops using red lines:\
\>", "ExampleText",
 CellID->2122510440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"First", "[", "#2", "]"}], "\[Equal]", 
         RowBox[{"Last", "[", "#2", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", " ", 
          RowBox[{"Line", "[", "#1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
          RowBox[{"Line", "[", "#1", "]"}]}], "}"}]}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1956840094],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{{
      {RGBColor[1, 0, 0], 
       Line3DBox[{{0.6303192962505789, 1.4876218973029331`, 
        0.0005797939520425094}, {0.6264290016249354, 1.4870857081587598`, 
        0.0005797939520425094}, {0.5556302621739354, 1.4874482863248715`, 
        0.0005797939520425094}, {0.487772608319501, 1.5076456075370734`, 
        0.0005797939520425094}, {0.42829899634593754`, 1.5460576167216387`, 
        0.0005797939520425094}, {0.38197988694049917`, 1.5996032334858907`, 
        0.0005797939520425094}, {0.3525305999426044, 1.6639874898386104`, 
        0.0005797939520425094}, {0.34231330340005156`, 1.7340460355139145`, 
        0.0005797939520425094}, {0.3521475408022782, 1.804159377650014, 
        0.0005797939520425094}, {0.3812444943633846, 1.8687036280851994`, 
        0.0005797939520425094}, {0.42727025718792594`, 1.92250160320691, 
        0.0005797939520425094}, {0.4865330391715287, 1.9612380930109834`, 
        0.0005797939520425094}, {0.5542792905920784, 1.9818059900653926`, 
        0.0005797939520425094}, {0.6250749909085962, 1.9825555148954837`, 
        0.0005797939520425094}, {0.6932415190658031, 1.9634265470778038`, 
        0.0005797939520425094}, {0.7533111435442972, 1.925953447582435, 
        0.0005797939520425094}, {0.8004655966693298, 1.8731419855570732`, 
        0.0005797939520425094}, {0.8309225545261886, 1.8092282414257628`, 
        0.0005797939520425094}, {0.8422390223935495, 1.73933882501824, 
        0.0005797939520425094}, {0.8335072907295099, 1.6690796631037657`, 
        0.0005797939520425094}, {0.8054277438095946, 1.604086340250188, 
        0.0005797939520425094}, {0.7602526809351629, 1.5495720607899561`, 
        0.0005797939520425094}, {0.701605656390802, 1.5099094904891013`, 
        0.0005797939520425094}, {0.6341908291426372, 1.4882800189773602`, 
        0.0005797939520425094}, {0.6303192962505789, 1.4876218973029331`, 
        0.0005797939520425094}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0.6303192962505789, 1.4876218973029331`, 
        0.0005797939520425094}, {0., 0.629714428901812, 
        0.0006180106941365837}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0., 0.629714428901812, 0.0006180106941365837}, {
        0.8593461265010855, 0., 0.00013831132020443448`}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0., 0.629714428901812, 0.0006180106941365837}, {
        0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0.8593461265010855, 0., 0.00013831132020443448`}, {
        1.4901071967290844`, 0.858359946964393, 0.}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0.8593461265010855, 0., 0.00013831132020443448`}, {
        0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{1.4901071967290844`, 0.858359946964393, 0.}, {
        0.6303192962505789, 1.4876218973029331`, 0.0005797939520425094}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{1.4901071967290844`, 0.858359946964393, 0.}, {
        0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]}, 
      {GrayLevel[0.5], 
       Line3DBox[{{0.746112934024352, 0.7433341273460402, 
        0.5463963224169619}, {0.6303192962505789, 1.4876218973029331`, 
        0.0005797939520425094}}]}}, 
     GraphicsComplex3DBox[{{0.6303192962505789, 1.4876218973029331`, 
      0.0005797939520425094}, {0., 0.629714428901812, 
      0.0006180106941365837}, {0.8593461265010855, 0., 
      0.00013831132020443448`}, {1.4901071967290844`, 0.858359946964393, 
      0.}, {0.746112934024352, 0.7433341273460402, 0.5463963224169619}, {
      0.6264290016249354, 1.4870857081587598`, 0.0005797939520425094}, {
      0.5556302621739354, 1.4874482863248715`, 0.0005797939520425094}, {
      0.487772608319501, 1.5076456075370734`, 0.0005797939520425094}, {
      0.42829899634593754`, 1.5460576167216387`, 0.0005797939520425094}, {
      0.38197988694049917`, 1.5996032334858907`, 0.0005797939520425094}, {
      0.3525305999426044, 1.6639874898386104`, 0.0005797939520425094}, {
      0.34231330340005156`, 1.7340460355139145`, 0.0005797939520425094}, {
      0.3521475408022782, 1.804159377650014, 0.0005797939520425094}, {
      0.3812444943633846, 1.8687036280851994`, 0.0005797939520425094}, {
      0.42727025718792594`, 1.92250160320691, 0.0005797939520425094}, {
      0.4865330391715287, 1.9612380930109834`, 0.0005797939520425094}, {
      0.5542792905920784, 1.9818059900653926`, 0.0005797939520425094}, {
      0.6250749909085962, 1.9825555148954837`, 0.0005797939520425094}, {
      0.6932415190658031, 1.9634265470778038`, 0.0005797939520425094}, {
      0.7533111435442972, 1.925953447582435, 0.0005797939520425094}, {
      0.8004655966693298, 1.8731419855570732`, 0.0005797939520425094}, {
      0.8309225545261886, 1.8092282414257628`, 0.0005797939520425094}, {
      0.8422390223935495, 1.73933882501824, 0.0005797939520425094}, {
      0.8335072907295099, 1.6690796631037657`, 0.0005797939520425094}, {
      0.8054277438095946, 1.604086340250188, 0.0005797939520425094}, {
      0.7602526809351629, 1.5495720607899561`, 0.0005797939520425094}, {
      0.701605656390802, 1.5099094904891013`, 0.0005797939520425094}, {
      0.6341908291426372, 1.4882800189773602`, 0.0005797939520425094}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[Point3DBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.6303192962505789, 1.4876218973029331`, 
     0.0005797939520425094}, {0., 0.629714428901812, 0.0006180106941365837}, {
     0.8593461265010855, 0., 0.00013831132020443448`}, {1.4901071967290844`, 
     0.858359946964393, 0.}, {0.746112934024352, 0.7433341273460402, 
     0.5463963224169619}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2134971310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19051973],

Cell["Give labels for some edges:", "ExampleText",
 CellID->124062807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<12\>\""}], "}"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{".5", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"Line", "[", "#", "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"#3", "=!=", " ", "None"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"#3", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", "2"}], ",", 
            RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
          RowBox[{"{", "}"}]}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3492647],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{{
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0.03365651002401626, 0.26132176561732473`, 0.}, {0., 
        0.24474517431169207`, 0.9989742720646206}}], Text3DBox[
        FormBox["\<\"12\"\>", TraditionalForm], {0.01682825501200813, 
        0.2530334699645084, 0.4994871360323103},
        Background->GrayLevel[1]]}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0.03365651002401626, 0.26132176561732473`, 0.}, {
        0.8449440803969506, 0., 0.5231593586461052}}], {}}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0., 0.24474517431169207`, 0.9989742720646206}, {
        0.8449440803969506, 0., 0.5231593586461052}}], {}}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0., 0.24474517431169207`, 0.9989742720646206}, {
        0.5309374948741479, 0.949494003878113, 0.5283357973868779}}], {}}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0.8449440803969506, 0., 0.5231593586461052}, {
        0.5309374948741479, 0.949494003878113, 0.5283357973868779}}], {}}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0.5309374948741479, 0.949494003878113, 
        0.5283357973868779}, {0.5005929727582219, 0.8635423780610084, 
        0.47392473904882065`}, {0.4920172509476756, 0.8407288343531846, 
        0.4592926897903591}, {0.48254980181373935`, 0.8183424512677356, 
        0.44455108520230396`}, {0.4722022197781689, 0.7964106445492206, 
        0.4297179787622641}, {0.46098717712772025`, 0.7749602732399608, 
        0.4148115360066561}, {0.4489184084948864, 0.7540176067868011, 
        0.3998500122840691}, {0.4360106940376194, 0.7336082928699258, 
        0.38485173039863907`}, {0.4222798413386382, 0.7137573259931294, 
        0.3698350581708142}, {0.22336744739858583`, 0.4384884306888143, 
        0.15850073921606336`}, {0.2088302721064361, 0.41922012156969085`, 
        0.1434840669882385}, {0.19350457734201035`, 0.40055806736723093`, 
        0.12848578510280853`}, {0.1774091318957492, 0.38252512278328654`, 
        0.11352426138022145`}, {0.16056364724222322`, 0.3651433720732943, 
        0.0986178186246135}, {0.14298875340024655`, 0.34843410200053493`, 
        0.0837847121845736}, {0.12470597366808425`, 0.3324177757670511, 
        0.06904310759651848}, {0.1057376982646945, 0.3171140079531489, 
        0.054411058338056935`}, {0.03365651002401626, 0.26132176561732473`, 
        0.}}], {}}, 
      {RGBColor[0.5, 0, 0], 
       Line3DBox[{{0.5309374948741479, 0.949494003878113, 
        0.5283357973868779}, {0.45885630663346927`, 0.8937017615422886, 
        0.47392473904882065`}, {0.4398880312300795, 0.8783979937283865, 
        0.4592926897903591}, {0.4216052514979173, 0.8623816674949026, 
        0.44455108520230396`}, {0.4040303576559406, 0.8456723974221433, 
        0.4297179787622641}, {0.3871848730024146, 0.8282906467121509, 
        0.4148115360066561}, {0.37108942755615343`, 0.8102577021282066, 
        0.3998500122840691}, {0.3557637327917278, 0.7915956479257467, 
        0.38485173039863907`}, {0.34122655749957803`, 0.7723273388066231, 
        0.3698350581708142}, {0.14231416355952564`, 0.49705844350230816`, 
        0.15850073921606336`}, {0.12858331086054448`, 0.4772074766255117, 
        0.1434840669882385}, {0.11567559640327754`, 0.45679816270863643`, 
        0.12848578510280853`}, {0.10360682777044368`, 0.43585549625547665`, 
        0.11352426138022145`}, {0.09239178511999507, 0.4144051249462169, 
        0.0986178186246135}, {0.0820442030844246, 0.3924733182277019, 
        0.0837847121845736}, {0.0725767539504883, 0.37008693514225294`, 
        0.06904310759651848}, {0.06400103213994214, 0.34727339143442904`, 
        0.054411058338056935`}, {0.03365651002401626, 0.26132176561732473`, 
        0.}}], {}}}, 
     GraphicsComplex3DBox[{{0.03365651002401626, 0.26132176561732473`, 0.}, {
      0., 0.24474517431169207`, 0.9989742720646206}, {0.8449440803969506, 0., 
      0.5231593586461052}, {0.5309374948741479, 0.949494003878113, 
      0.5283357973868779}, {0.5005929727582219, 0.8635423780610084, 
      0.47392473904882065`}, {0.4920172509476756, 0.8407288343531846, 
      0.4592926897903591}, {0.48254980181373935`, 0.8183424512677356, 
      0.44455108520230396`}, {0.4722022197781689, 0.7964106445492206, 
      0.4297179787622641}, {0.46098717712772025`, 0.7749602732399608, 
      0.4148115360066561}, {0.4489184084948864, 0.7540176067868011, 
      0.3998500122840691}, {0.4360106940376194, 0.7336082928699258, 
      0.38485173039863907`}, {0.4222798413386382, 0.7137573259931294, 
      0.3698350581708142}, {0.22336744739858583`, 0.4384884306888143, 
      0.15850073921606336`}, {0.2088302721064361, 0.41922012156969085`, 
      0.1434840669882385}, {0.19350457734201035`, 0.40055806736723093`, 
      0.12848578510280853`}, {0.1774091318957492, 0.38252512278328654`, 
      0.11352426138022145`}, {0.16056364724222322`, 0.3651433720732943, 
      0.0986178186246135}, {0.14298875340024655`, 0.34843410200053493`, 
      0.0837847121845736}, {0.12470597366808425`, 0.3324177757670511, 
      0.06904310759651848}, {0.1057376982646945, 0.3171140079531489, 
      0.054411058338056935`}, {0.45885630663346927`, 0.8937017615422886, 
      0.47392473904882065`}, {0.4398880312300795, 0.8783979937283865, 
      0.4592926897903591}, {0.4216052514979173, 0.8623816674949026, 
      0.44455108520230396`}, {0.4040303576559406, 0.8456723974221433, 
      0.4297179787622641}, {0.3871848730024146, 0.8282906467121509, 
      0.4148115360066561}, {0.37108942755615343`, 0.8102577021282066, 
      0.3998500122840691}, {0.3557637327917278, 0.7915956479257467, 
      0.38485173039863907`}, {0.34122655749957803`, 0.7723273388066231, 
      0.3698350581708142}, {0.14231416355952564`, 0.49705844350230816`, 
      0.15850073921606336`}, {0.12858331086054448`, 0.4772074766255117, 
      0.1434840669882385}, {0.11567559640327754`, 0.45679816270863643`, 
      0.12848578510280853`}, {0.10360682777044368`, 0.43585549625547665`, 
      0.11352426138022145`}, {0.09239178511999507, 0.4144051249462169, 
      0.0986178186246135}, {0.0820442030844246, 0.3924733182277019, 
      0.0837847121845736}, {0.0725767539504883, 0.37008693514225294`, 
      0.06904310759651848}, {0.06400103213994214, 0.34727339143442904`, 
      0.054411058338056935`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[Point3DBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.03365651002401626, 0.26132176561732473`, 
     0.}, {0., 0.24474517431169207`, 0.9989742720646206}, {0.8449440803969506,
      0., 0.5231593586461052}, {0.5309374948741479, 0.949494003878113, 
     0.5283357973868779}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377483975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234209287],

Cell["Draw edges as cylinders and vertices as spheres: ", "ExampleText",
 CellID->127920141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cylinder", "[", 
       RowBox[{"#1", ",", ".05"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#1", ",", ".1"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769819478],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, {0., 0.6383721562676106, 
      0.0005166374503760146}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.8529587157814721, 0., 0.000058993543025062656`}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      1.4923842795065547`, 0.8518947103601523, 0.}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.6390758705051751, 1.4898647777696166`, 0.0005877776666556173}}, 0.05],
      CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.7471167161829144, 0.7442574629173819, 
      0.5463274426713254}, {0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}}, 0.05]}, {
     SphereBox[{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, 0.1], 
     SphereBox[{0., 0.6383721562676106, 0.0005166374503760146}, 0.1], 
     SphereBox[{0.8529587157814721, 0., 0.000058993543025062656`}, 0.1], 
     SphereBox[{1.4923842795065547`, 0.8518947103601523, 0.}, 0.1], 
     SphereBox[{0.7471167161829144, 0.7442574629173819, 0.5463274426713254}, 
      0.1]}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.6390758705051751, 1.4898647777696166`, 
     0.0005877776666556173}, {0., 0.6383721562676106, 
     0.0005166374503760146}, {0.8529587157814721, 0., 
     0.000058993543025062656`}, {1.4923842795065547`, 0.8518947103601523, 
     0.}, {0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468794193,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->489698888],

Cell["Apply a number of methods on the Petersen graph:", "ExampleText",
 CellID->289707743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GraphPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "2"}], ",", 
          RowBox[{"1", "\[Rule]", "3"}], ",", 
          RowBox[{"1", "\[Rule]", "5"}], ",", 
          RowBox[{"2", "\[Rule]", "4"}], ",", 
          RowBox[{"2", "\[Rule]", "6"}], ",", 
          RowBox[{"3", "\[Rule]", "4"}], ",", 
          RowBox[{"3", "\[Rule]", "7"}], ",", 
          RowBox[{"4", "\[Rule]", "8"}], ",", 
          RowBox[{"5", "\[Rule]", "6"}], ",", 
          RowBox[{"5", "\[Rule]", "9"}], ",", 
          RowBox[{"6", "\[Rule]", "10"}], ",", 
          RowBox[{"7", "\[Rule]", "8"}], ",", 
          RowBox[{"7", "\[Rule]", "11"}], ",", 
          RowBox[{"8", "\[Rule]", "12"}], ",", 
          RowBox[{"9", "\[Rule]", "10"}], ",", 
          RowBox[{"9", "\[Rule]", "11"}], ",", 
          RowBox[{"10", "\[Rule]", "12"}], ",", 
          RowBox[{"11", "\[Rule]", "12"}]}], "}"}], ",", 
        RowBox[{"Method", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{"m", ",", "Small"}], "]"}]}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<SpringElectricalEmbedding\>\"", ",", "\"\<SpringEmbedding\>\"", 
          ",", "\"\<HighDimensionalEmbedding\>\"", ",", 
          "\"\<CircularEmbedding\>\"", ",", "\"\<SpiralEmbedding\>\"", ",", 
          "\"\<RandomEmbedding\>\""}], "}"}]}], "}"}]}], "]"}], ",", "3"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394919304],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{1.8180660420210464`, 1.726538923683491, 
        0.8578145747377102}, {1.8170924836183677`, 1.727042516801842, 
        0.00012016363410760622`}, {0.8205399797932222, 2.0983288911166946`, 
        0.8583786421479505}, {1.9949066637594315`, 0.6779450005318729, 
        0.8580964753795491}, {0.8203322387380596, 2.0982802021935765`, 
        0.0005990816218184314}, {1.9941541631895223`, 0.6775520472491301, 
        0.}, {0.0002485886554329797, 1.420175085759304, 0.858452444963022}, {
        0., 1.4212172387506314`, 0.0007070760950785293}, {1.1747821027354912`,
         0., 0.857707944857172}, {1.173082661395227, 0.00019281899175949135`, 
        0.00010103504491415505`}, {0.17743450937134297`, 0.37143025920710737`,
         0.8583458824697232}, {0.17605471936914718`, 0.3720074593374567, 
        0.0007953252618357332}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.8180660420210464`, 1.726538923683491, 
         0.8578145747377102}, {1.8170924836183677`, 1.727042516801842, 
         0.00012016363410760622`}, {0.8205399797932222, 2.0983288911166946`, 
         0.8583786421479505}, {1.9949066637594315`, 0.6779450005318729, 
         0.8580964753795491}, {0.8203322387380596, 2.0982802021935765`, 
         0.0005990816218184314}, {1.9941541631895223`, 0.6775520472491301, 
         0.}, {0.0002485886554329797, 1.420175085759304, 0.858452444963022}, {
         0., 1.4212172387506314`, 0.0007070760950785293}, {
         1.1747821027354912`, 0., 0.857707944857172}, {1.173082661395227, 
         0.00019281899175949135`, 0.00010103504491415505`}, {
         0.17743450937134297`, 0.37143025920710737`, 0.8583458824697232}, {
         0.17605471936914718`, 0.3720074593374567, 
         0.0007953252618357332}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox[
        "\"SpringElectricalEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{1.086595655475874, 0.00014035605983842014`, 
        1.0423999290106358`}, {1.0867065929349613`, 0., 
        0.0007321336932967215}, {0.16770321241727526`, 0.33669344510708543`, 
        1.0416587323506015`}, {1.8377020519350615`, 0.6271431291273959, 
        1.042112355978953}, {0.16788109440146448`, 0.33713154990369487`, 
        0.00029145147055920084`}, {1.8375872410465925`, 0.6272395152406515, 
        0.00035765392267839147`}, {0.0005414598927719894, 1.300989680760421, 
        1.0427372966479695`}, {0., 1.3011683000906666`, 
        0.0011739709148030908`}, {1.6700094038487716`, 1.5912976597423567`, 
        1.0423563101939282`}, {1.6703253402023384`, 1.5913983929410436`, 
        0.0010215257781093223`}, {0.7513684862912153, 1.9283591280816714`, 
        1.0418102412966717`}, {0.7513623719375849, 1.9278909740723735`, 
        0.}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.086595655475874, 0.00014035605983842014`,
          1.0423999290106358`}, {1.0867065929349613`, 0., 
         0.0007321336932967215}, {0.16770321241727526`, 0.33669344510708543`, 
         1.0416587323506015`}, {1.8377020519350615`, 0.6271431291273959, 
         1.042112355978953}, {0.16788109440146448`, 0.33713154990369487`, 
         0.00029145147055920084`}, {1.8375872410465925`, 0.6272395152406515, 
         0.00035765392267839147`}, {0.0005414598927719894, 1.300989680760421, 
         1.0427372966479695`}, {0., 1.3011683000906666`, 
         0.0011739709148030908`}, {1.6700094038487716`, 1.5912976597423567`, 
         1.0423563101939282`}, {1.6703253402023384`, 1.5913983929410436`, 
         0.0010215257781093223`}, {0.7513684862912153, 1.9283591280816714`, 
         1.0418102412966717`}, {0.7513623719375849, 1.9278909740723735`, 
         0.}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"SpringEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{1.461397317976364, 1.706476727439755, 
        1.039230484541326}, {1.461397317976364, 1.7064767274397545`, 
        1.1102230246251565`*^-16}, {1.9594996766040835`, 0.8627385925131044, 
        1.0392304845413265`}, {0.4816474796743223, 1.6969764986465283`, 
        1.039230484541326}, {1.9594996766040835`, 0.862738592513104, 
        4.440892098500626*^-16}, {0.48164747967432237`, 1.6969764986465279`, 
        0.}, {1.477852196929761, 0.009500228793226984, 1.0392304845413267`}, {
        1.4778521969297613`, 0.00950022879322665, 6.661338147750939*^-16}, {
        0., 0.843738134926651, 1.0392304845413263`}, {
        1.1102230246251565`*^-16, 0.8437381349266506, 
        2.220446049250313*^-16}, {0.4981023586277195, 4.440892098500626*^-16, 
        1.0392304845413265`}, {0.4981023586277196, 0., 
        6.661338147750939*^-16}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.461397317976364, 1.706476727439755, 
         1.039230484541326}, {1.461397317976364, 1.7064767274397545`, 
         1.1102230246251565`*^-16}, {1.9594996766040835`, 0.8627385925131044, 
         1.0392304845413265`}, {0.4816474796743223, 1.6969764986465283`, 
         1.039230484541326}, {1.9594996766040835`, 0.862738592513104, 
         4.440892098500626*^-16}, {0.48164747967432237`, 1.6969764986465279`, 
         0.}, {1.477852196929761, 0.009500228793226984, 
         1.0392304845413267`}, {1.4778521969297613`, 0.00950022879322665, 
         6.661338147750939*^-16}, {0., 0.843738134926651, 
         1.0392304845413263`}, {1.1102230246251565`*^-16, 0.8437381349266506, 
         2.220446049250313*^-16}, {0.4981023586277195, 4.440892098500626*^-16,
          1.0392304845413265`}, {0.4981023586277196, 0., 
         6.661338147750939*^-16}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox[
        "\"HighDimensionalEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic]},
    {
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{1.528846084572988, 0.764423042286494, 0.}, {
        1.4264328161505042`, 1.1466345634198338`, 0.}, {1.1466345634495556`, 
        1.4264328161333442`, 0.}, {0.764423042320814, 1.528846084572988, 
        0.}, {0.3822115211828764, 1.426432816167664, 0.}, {
        0.10241326845680399`, 1.1466345634792776`, 0.}, {0., 
        0.764423042355134, 0.}, {0.102413268388164, 0.3822115212125983, 0.}, {
        0.38221152106398837`, 0.10241326847396404`, 0.}, {0.7644230421835341, 
        0., 0.}, {1.1466345633306678`, 0.10241326837100406`, 0.}, {
        1.426432816081864, 0.3822115210342664, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.528846084572988, 0.764423042286494, 
         0.}, {1.4264328161505042`, 1.1466345634198338`, 0.}, {
         1.1466345634495556`, 1.4264328161333442`, 0.}, {0.764423042320814, 
         1.528846084572988, 0.}, {0.3822115211828764, 1.426432816167664, 
         0.}, {0.10241326845680399`, 1.1466345634792776`, 0.}, {0., 
         0.764423042355134, 0.}, {0.102413268388164, 0.3822115212125983, 
         0.}, {0.38221152106398837`, 0.10241326847396404`, 0.}, {
         0.7644230421835341, 0., 0.}, {1.1466345633306678`, 
         0.10241326837100406`, 0.}, {1.426432816081864, 0.3822115210342664, 
         0.}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"CircularEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{0.6513415216251447, 0.6325052022211953, 0.}, {
        0.5477927924877151, 1.0617951395741594`, 0.1396467649530373}, {
        0.05892139759449677, 0.624737451144381, 0.2792935299060747}, {
        0.3906378119325178, 0., 0.41894029485911205`}, {1.1212601672804299`, 
        0.062232813447838375`, 0.5585870598121494}, {1.40620667208846, 
        0.7558550034835501, 0.6982338247651868}, {0.9245565512324047, 
        1.346921129011864, 0.8378805897182241}, {0.16692971813964969`, 
        1.190518943607282, 0.9775273546712615}, {0., 0.4232601848577848, 
        1.1171741196242988`}, {0.7029759153571012, 0.04228843636545243, 
        1.256820884577336}, {1.069973696010332, 0.7730729516803748, 
        1.3964676495303736`}, {0.6513415216251447, 0.6325052022211953, 
        1.536114414483411}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.6513415216251447, 0.6325052022211953, 
         0.}, {0.5477927924877151, 1.0617951395741594`, 0.1396467649530373}, {
         0.05892139759449677, 0.624737451144381, 0.2792935299060747}, {
         0.3906378119325178, 0., 0.41894029485911205`}, {1.1212601672804299`, 
         0.062232813447838375`, 0.5585870598121494}, {1.40620667208846, 
         0.7558550034835501, 0.6982338247651868}, {0.9245565512324047, 
         1.346921129011864, 0.8378805897182241}, {0.16692971813964969`, 
         1.190518943607282, 0.9775273546712615}, {0., 0.4232601848577848, 
         1.1171741196242988`}, {0.7029759153571012, 0.04228843636545243, 
         1.256820884577336}, {1.069973696010332, 0.7730729516803748, 
         1.3964676495303736`}, {0.6513415216251447, 0.6325052022211953, 
         1.536114414483411}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"SpiralEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[
       GraphicsComplex3DBox[{{1.0260613117587096`, 1.1743389708162593`, 0.}, {
        1.727772977099522, 0.8325490798261694, 0.06850604896729329}, {
        0.9794726577244616, 0., 0.39907445768745786`}, {1.736894883765979, 
        0.702252900014015, 0.5991637177764442}, {0.9011045208449657, 
        1.2892765197585239`, 0.20164500036156147`}, {0.464502140175601, 
        0.43049116843662305`, 0.3826282567040614}, {0.7926523402335506, 
        1.5001366699954872`, 0.7120003417040592}, {1.1729855380011445`, 
        1.2765581839340976`, 0.6088355163604016}, {0.8552795680397616, 
        0.9000058245906953, 0.4491534459329484}, {1.2752511732407008`, 
        0.5946611029682312, 0.5716550688149465}, {0., 0.7845609512605682, 
        0.3997838837423764}, {1.2197004734498482`, 0.7981801115999407, 
        0.7095559382405009}}, {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 5}, {3, 7}, {
           4, 6}, {4, 9}, {5, 8}, {6, 10}, {7, 8}, {7, 11}, {8, 12}, {9, 
           10}, {9, 11}, {10, 12}, {11, 12}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "12"],
           Annotation[#, 12, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.0260613117587096`, 1.1743389708162593`, 
         0.}, {1.727772977099522, 0.8325490798261694, 0.06850604896729329}, {
         0.9794726577244616, 0., 0.39907445768745786`}, {1.736894883765979, 
         0.702252900014015, 0.5991637177764442}, {0.9011045208449657, 
         1.2892765197585239`, 0.20164500036156147`}, {0.464502140175601, 
         0.43049116843662305`, 0.3826282567040614}, {0.7926523402335506, 
         1.5001366699954872`, 0.7120003417040592}, {1.1729855380011445`, 
         1.2765581839340976`, 0.6088355163604016}, {0.8552795680397616, 
         0.9000058245906953, 0.4491534459329484}, {1.2752511732407008`, 
         0.5946611029682312, 0.5716550688149465}, {0., 0.7845609512605682, 
         0.3997838837423764}, {1.2197004734498482`, 0.7981801115999407, 
         0.7095559382405009}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox[
        StyleBox["\"RandomEmbedding\"", Small, StripOnInput -> False], 
        TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 377},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26685438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MultiedgeStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->100942717],

Cell["Spread multiple edges by a specified scaled distance:", "ExampleText",
 CellID->1029865650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"4", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "5"}], ",", 
       RowBox[{"2", "\[Rule]", "5"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
     RowBox[{"MultiedgeStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5."}], ",", 
       RowBox[{"1", "/", "3."}], ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->40554687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxF1Hs01Gkcx/FZFGrKmFTbaWvdmYpooj3YPvIbhmKkYrs7KY1Kii6SQhep
LJsVlZBsO7pQQpJFDDYikSJlMjNkxjXMRYutnT/an+ec55/n+ec5r+d83wZ+
B9b5q1EoFGfVVlfteZ37fRMXd2Ft9pZ09xejiKJ/0bz71QmUbysvvKwj3bQL
lLMm7XBkIffc7ZDKyD7ynlKcaa3QNwSqW28dbx0FRzeO/SB08l5pt9HeXCiB
59EPvF21EjR8GjDSOyFC0DVRNvNIJ+Q7pTdnFysw9U51yHwjAupLXZvbiE4U
ly+rcHFSIAZFGezFBOZVXMh6qtYJ7u1Eu231ckx73d14n0lghTHP0TJPjOcT
BgcEG+WwC7O+zHZQndem0aPWiSFoCprmJpWBo9VIaDkTCOB1ndfvEiF6Yujg
wnAZLHTMqRIPArGVNXGxXBGCHyxc9lZXhnLam9E2HwI6Deu/uguE4Bx5HdGf
PYK4gpaxFl8CyPfMK73ShJDqe9Nvb++FXOTeQxcSOCFe+tZoTyPSRKt/CUjv
QUU0p1+nh4CZKFJ5imhAaZLT4qtSKTbEjLeqjRDoMKhfp32uDstpATz1lVIw
49dniMYInEup4gyn1uBLxJw1e29IwF4w4pmpzkKU/6H9EbHVMIi0MI+YIcEx
vsMseyoLJZbsKENvPgTRDN3O890Y89lHZOqxoLiu//vwWClkD227LejdCB/Y
FtzwAwv76oi1fcli5MbM0Dj1sxKPLRtyzPVV/k3GMTONxXgkaithvVSA41Oc
a8Ug4PzQJnRqtggDPu6m+/wUKGLonXRcpnI7XW/XZSmCxt8CvvqoHO92edX4
2BO4Onsr70m2ECMH2cIFcXKYNY+5hLAIMJN7nK+ZCPGqckNSjbEcmy6+z05Q
+e/WbCxYwuzA8U8lT+llMjAdrXLyVf78SlnOBd0P0ORpqE3fJCP9Cx6tqNws
qMMHUyr9Y2Ef6U9jF3YsiamFV0DzJc5Qr+r9Mltblf/W5uEdgQufIc4/w9vD
ohdmVNcVG1X+n+ski4L/qEK9djzj3/092FRpnhY6rvLPjilImsPH0bKZnmF5
UmRZv5qfqMHCqqA07aChMnjNnhbRPiZBbaAO984MFh7/NmPVnoQn8LOaKXRk
S1Tv38N8MocFR5cN40JaAXRDkqjlV7rxnOttW/EjCxs2qzuG3hHByHpIs+Ty
pL+ZtfuK3f8IMdbETB93UJL+3jZ26dEeQpzpsHlp0Tnp//nTla73azowfDF/
t2+MgvSHkMsImvIBzh8PhaUxFKT/xXZx3NCzdvg/3rtTUTvpn5tJ8byU+B4a
tk3VhwPkpP/2PmwLC3iH0pbl0YwpctK/X6PRwC62Cm7nA7831Bkg/TNOztWT
s/nwU4yn0p37Sf9bTN3d0rnlyHevH+ap+vC//7zA+JoXyr9weKR7ywSvl/Q/
oTHdJOzjY3i4FidbNfeQ/lnxFau4E/mINBW83DEhJf0fXnLlmzrkYpDGz7xv
KCX9KeE3R6JW38Fo1WY9WxcJ6X/M5oKXsi4ZQdQ/31I9pORcNJ4uPGs9mgrh
OlrKXYceco609Z0i7OMyce4MJ+ukeS9Cv82d6WB4v1dyFsreWa88qdNHzqlJ
+ncvlifk4LrVVU3eUB8512c/uhUk2+fB7X2i3fjzfrIDwRPmcSv1CxFy5Kei
mLQBshtrbzdSmCHFKOqpX+jLHSSdZfRfqXuetiBY01/L9eHkvxR23utWG2zF
1rAkMVdXQXYs4831Sn+bNrjfuPbZM1BBdo94dGS24eV3oImn2qdUKMhODh0L
m3tfqx337j6QdtOUZFeDZxme5yYIkLLIeKx9kxLa3zr82rIoImlJB+zNeNGL
UpVkt1NeMixsAoWwSvhxfnSrkuz8fzSVC8Y=
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
           36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
           51, 52, 53, 2}, {1, 5}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
           64, 65, 66, 67, 68, 69, 1}, {2, 3}, {2, 5}, {3, 4}, {3, 5}, {4, 
          1}, {4, 5}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6303192962505789, 1.4876218973029331`, 
       0.0005797939520425094}, {0., 0.629714428901812, 
       0.0006180106941365837}, {0.8593461265010855, 0., 
       0.00013831132020443448`}, {1.4901071967290844`, 0.858359946964393, 
       0.}, {0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxF1Hk81GkAx/HZnEkbia2oyBFpa02uyH7jN45ypMuQipdQibJqqWjZXLWl
wooKW0itUUqHkB1MbAhL4yjKNRnjqIw5umj9sfv0vF7PX89/7+f1/ej4Hdwc
MINGo9lPX5npu2AgxCfVmAf3Qu9sl0YpYuZOKRR8sQPtv1Mc+VdPtgEPtDj9
bqxj4HbCjTBO9Ah5p5XlmIi1lwI1HXnHOqRwU01yLIr4+i6x8rQ27OVjY/ir
fP86PprejunOi+rDhmDnPcIYHlZbXVQKVRMj05xrsWwZhYpmKbcoloeLS19r
Si6L0A3a4hUrKehHPj3/6AAPbH/Z8bd6Ihg822t4y4xCrZ+sv6sdD5kspwOn
iiZg88El+JINBcXDAVTr1ADu1ZT5Dq+dwPBGx4luewp0urGZOG8AyVebfl/d
JESr7qUxXzcKlyNy8jLMBrCwu3wq0l8ILaM/BlWYFKiym8va7vQjg5H3qZEm
RNK99o/tPhRyT8vINK1rg5y/s9x+eQFEfS6Cub0UwmIdjFXVuMh0F4TNdx1C
QEjcZOcQhcJk2RKN6lZkZ+gxcnL5KAo7JTk5TuFhplvxqk0t4D5ZH3Z3Fh/p
Dt3vlD9SsN930ORTYjNyrLY9rU8YBCOrPWLjDAYG89t2ta59ipbOELqFxiC8
OWXl1krT/2LrwDSpe4LT3vob5pW/xjUP3doKVQaqB4qi6s1qENjfcNcx/DVe
+2wsrJ7PAL000bP0VT8m0ouPsDUk8DZQCOZpU+B7zS4PPNGP4sL2bd25YhzP
ZQbeN6KQVWCUYruoH2EhQ/GddDEcQ4VLL9Mp7C8ouR5a1IfgQyq+PRwRXLZ4
WqZYU2jxbpu/eE0fONoKhzSZImyes9s8nUFBzqnCPqKsF0Mp1YcfjE7AZ+TC
9XxXCpVsn8rC1b1Yfj+C/jxuAsEO4XMrPCh0zYo/xFvfg7/TRDGsJRPEX2q/
3U3FrQn+8qNzDBgjxJ+9SVHbVtSA5e0P9kZED0Pd/WbLCgGF1h/n3DgUVYe6
ZRHDlZUC6LLOrKWEFFyTLEwu8WvB9HN86KwowKrEypubP1FoDhs3KjZ/jNl3
jM/t8hiCGdXAYsoyUBqox+EEVWHplvECGxYf1gYmVW6zGUgvfaTOmVmB2FaZ
wuUKfMhNNBw31WBgREVN3l25BJbL7X7xDxqEQajWEbklDHyOYe2auaEPs9sW
NO9jffXnOT/4vP23aR/amofyOyXEn5uy/uXjqz3IWFdtOakkIf51ygN/Nlq/
Qq7qtdrg+2Lif/oL8r0GujFp+R09fIeY+NcbcIdHM7rA8PiSYU0TE/8tWR0r
5Xe+wLzoHq/eKyLib5p7K33xD88hHWTIn/pRRPxZh29eiFtYDc6NMwv7fh0j
/rULf3pvymZjcl9CSXzJKPHP6Ixr7D1ZjhO33tEb+CPE38bqsWlBagkaU/aY
f6M2QvwP1NypUO+7i6NjW3ccXTNM/Ps4OkFnw24j+EOeSqK3gPhrpio61KcU
YOzYk9Doo0PE/1i234ErjXnYn6diXJrKJ/4zXfykVcx49pgPpeB5SUB2ITWM
9FukkMDWOcfiOZ8aJjv6NCOf6VIfw+YqhVh5Tvft/911FkZfkC0LZGse50Hf
b5TsNPKkhexZ33AMO9G8dzuOkV3ztDycap6dh0lyp/AfvTekA9yDIV5MdjZ0
tKYWr3v/hnQjKGlG1MDl69Bx/l4/k/2WOJ+36iz31HgGQ8u004E7xeRfquzS
UtUZXHTZ1nLnlIlJx06adiiopLWhK8twtP5bCelelFGSslSuA5VyGtuqt0tI
J5NV9QyMUjvx3EXlhnmWhHS1Uhh6rsLyBaomZX6OaZOQDntfs1Q7K+xCwFpD
gaqMlHR7Mzc2xvbRS0jfbzU9oi8lnf8Xw8UMLQ==
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
           36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
           51, 52, 53, 2}, {1, 5}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
           64, 65, 66, 67, 68, 69, 1}, {2, 3}, {2, 5}, {3, 4}, {3, 5}, {4, 
          1}, {4, 5}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6303192962505789, 1.4876218973029331`, 
       0.0005797939520425094}, {0., 0.629714428901812, 
       0.0006180106941365837}, {0.8593461265010855, 0., 
       0.00013831132020443448`}, {1.4901071967290844`, 0.858359946964393, 
       0.}, {0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxF1Gs4lGkAxvHphGLbUSGn0hCWpKQodGvfqWa3A3LIspWkTQcqRQeEkFS0
pVUumyY6qkmkRDTJxrKIdhhj5DiGcWbGTGK1fdjr2fe6nk/Pt9/73P9Fvoe3
7Z1Ko9HWfz3Tvh7tjoBdSeYiOD/2TttcpUDknEnlzC/fg/bflxP6uiXNWARa
zOImODLx9NyDoJKIXnJPK0hfPmrAAN7x75zmK7BVPWFj1on/7+VrPO1MW7vg
FNJ8z6+8C9WD/YbzwtrQ08h7z9YXQwsKyZKlMqyzy2QUm1OYcr2h3WeTGAs/
rP1lb6EU22NjxyKWU0hO4PnkeotRlpLDZrOkyLPJHKTZUhivDO302CrGfvr9
X0t4I9iR4V9qCgpjKwsCIg3FqLtmlfTMdwRa7rQYwQYKU0+bBYiEnRjRHj61
VTaMIQur4ZGtFPakeTY/OdkJ6YRvvu/FYVzrtjZw3U4hctECr4hxEZ4rP+Df
/24YCbn1n+t3UVjkJdrH4Ang0LOtaIFnF2RtmyVzWimsHVewuh824HFvcozD
PTH6OQMlyd0UDEoHfHLd+MgUBE0KVMS44j88Ih+i8I1u9nS9xjp07FEOizvb
iQPrDH3oYxTsVbQtXBx5MDpfyjmp0QkjaYF+MY2J0ism0SqJH2B69cfAkBIR
KnaeknUrMzGz4y1rR0UN/hLGsRoSRDBTT+vZP5uJ7GtuJvvGqjD/UGbDmWAR
HL1PFZvOY6Ja336lcE0HOPZuljNaRnHQata2ZQwKOdfZ0YqxdujwTt8K9B/F
5502SWwzCrvjBZz3j9pxJDgxtkkqQ/8eZWP7FRQ8GVzXDOd2SG7YlHGiZLh4
NFVlwo7CkNPcJ4XdbVitHuiJOTJUsWJ1BUwKfQUa244cb4N8d9Vg710pdmUk
mVRuoRAf9KBPT9aKIf6rQlUHKdjS7I4qDwrTXR1GzfxbERbFXijjjxB/4yJG
2ilODSo/UlvycnuI/8J3oRUnJ6uxqKKsvmhEgrb0ozQ9CYVipfNCmxOV+FtW
r3ZjtQQM6eVC/REKsTc/eqKsHG9z8h40xXcjd0van/RxCn7Lz7hwh0pxtiIo
X0fUBbnReWH/NCYmB1WtlOUlyEvbYSlgdeGald5rjhoTqvNcO6IFb+B72TEw
+aUYcTZ9zj9oML++u7u3Q+1eYdWXIHHZCjE0/bSv5uszccJ2da/hH624fGCK
7stSOfG3sLeq8utpwel0Hb5zjJz4r6iuW2z4czOqdS6FWNrLiX8UR0+zrLkJ
kpio7MSBUeJ/RHFoTtwxIcrpLfmc1FHiX/tWq/aCbiPeHH6vXEONEv+Mjps/
9fAboDODz3DokhF/tZn5BpyHfDDHb+xzPCcj/tmRMS6U7mt411p/dFIfIP6X
YsyTn73KR5DRZLrBxn7iH7yu+MD8/OfwpwvtfYL7iL9LCu/Cc80ctGWnHMz/
vZf4G6r1FdCyODibrpTYVNRD/FNS12vbTdxHsMRTPUIgIf5nX/AKi7QzYLAk
8qPXUDfxP/bQdsMMrTR88qoqspjWTfzp4YeV+AZZXFOPOFazXy/ZhcMtd91D
k0+5Wss+OQWw+siORK4rVVWisrllbLpQbtlPdjfb6fAyPc1sbvQzk/GnWgNk
pypL34lqzmRxMzPp8prxAbLr+MByIX3GI+5RdpJpasMg6UB67qOBvNo7XJt+
vttq9yHSjc5KZY+If1K4Ie1XV8leDBFno4YBjopSFVSDr2RdspaT/yL5raw3
zOs93I4PbgpPkJOOzaX17wiaWgv38CnfWjbJSfeMH5kVzAr/AFtbG2fPhQrS
SUXR2yt1mjxo3due1+KuIF0NsM61W1BeB43bGvzWMwrSYbOO+SHll76+kwm5
JCtFQbrdGLrc/JiXAPq5nbeb7ipI5/8F5cMqzw==
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
           36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
           51, 52, 53, 2}, {1, 5}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
           64, 65, 66, 67, 68, 69, 1}, {2, 3}, {2, 5}, {3, 4}, {3, 5}, {4, 
          1}, {4, 5}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6303192962505789, 1.4876218973029331`, 
       0.0005797939520425094}, {0., 0.629714428901812, 
       0.0006180106941365837}, {0.8593461265010855, 0., 
       0.00013831132020443448`}, {1.4901071967290844`, 0.858359946964393, 
       0.}, {0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxF1Hs0lHkcx/HJjMvKlkGyy0qu41C7brn3Lc+UKfe2omypCRslLYtaLGe1
4rRyS+WS1hAaNovOKpemWJIYl8GgWYyZIYzbxIxRtPPH9tvnnN8/z++P55zX
cz7vndTwI0FyOBzugOzgZecLXlhAthkfvCv9C927JJCotqFI/+gCuP+emthn
Y4XGfMBdM+LAPjL8mVwe0ZIwi+5x9TSLFT19gFZ2yU9sCXgS01yrYv6/Fzv4
OZLGp8ArerQ08NUUMBfmDDTiuBAx/IauqSoEN0/7ClbUEsQS8LhxKwzma7WD
YiOFkOLysxVVYwnsg9imcbYYaAfbRUY/FkK6c2bOQsUizIz5e7s4YRBpwMKR
eoUwOBmikQCLIOiWWm51wYAVsGbe2C4E84TCYWrJApR9J79eR8GAuKPO+Id8
IRQraV31Z85DD13ul83esu92j53NOSyEpwbEKA38PCTcflHO8sXA2Td8KX5o
FtRowexQyhykPR5cGwzAoIuKvd76kgdTcSECe48JWOa6T6uNY9DaepmkaMuD
+E1EpYxyLsjhqI6abzGYKa0VWKdNQOCt7awHulyontWjji5gQIsz3pTA5MLf
p43pUbXjMGKvO2UhwSBgW/eTIBwXFE6mqGwPHYeCNtPqkXUMPgj4syOkcZgY
y31eRh6HO3+9zC7DkyHpty2h5gWjYBZja+Uke0+xcK8PUyKDw3Z1PFPIgeWu
jJ/Z58dBIUuP/5kKGQ5fdPtelMgHK4dc5cvqK1Cwp9/WxASDpm5Jf1USH3L1
Bdri/GXgAE7XfDcGRrGdGY2X+MAIJCwtGC6DMes86ZENBm1UQqCHCx8KKiiX
UqvegbPU/WKeMwZKPwZhfRs8eNxaf2bG6R3MeLm+4xzAwNLSzGalhAeZRcxb
VkwR9BnkzZ3xxCA/hlZy14YHX3IaNmIDRaBjen9SVeaP1f9hMlA9AXfJJe+7
cCLkX3wDj2fuGwD5QDf5CwrTyD8i6aAZUb0fCrynI7Q83kJQ2LX1IZl/ZSah
TrO5DwrvGpJpxVNQFZEqTlnC4EmBZ83XPr3Q334oonbzFNw5yFlUWcPgQEi4
xfvr3UBzONbZkTwJ5HuDMV5yZJgsHTjd59QJvUNhlraak+DfUt/gqCzbxf6D
vhav2uGGv9FhjQYBPDhu0NZEJEMzryquw6YVgide17pGC0AQ4FXZrEWGI/1J
ifsb/wHJ6lHrK0YS5H/qgZ36TdEbCHIiTRPxEuTfLLqc3mQ3Ai/W8VGJA2Lk
n000NDbNHoIRd9XyPffEyD/ONE1FIs+G5/Kax5pPipF/ijVbUTVnAN7cIwk7
toiRf4tLTvY2cj9w9rf1b61fQf5ZDkMNfposINnl3Ag+tYL8I9Lk4nj5ZaDv
tsuogLGA/EXhYSd8GYWwU2dDd9/qPPJf1DlOaWVlgEXmkKjHcB7501JsCTfP
RMMsBed/znUO+XMqE24T6oMZ2vF8MKIKkf+iXKmve0ciY1A5zMFP1plP/hJS
LPUrxWSGfnoF3y11BvmruVMlL3x/ZcwFYIp+edPIP2i4btfnWd2M0fxN59pD
F9Eu6EX+m3vSexhFZY0j9p2LaEd4hRyTNmIvI6/y4ZVK6yW0u9rEDhdTt17G
t/heqU7REtpphFQr38ehl5FNv1AUukWEdr0Qk3WzYayHwRY88rl0VYQ6UD7M
IxD29jA8/GpYxDER6kZajzyFXstk6OVepwXLdvTJea/678oCvVSoM0vW/vh0
Ff2XW/TiseTMQrgYYql8VEWKOvahuTh/SvAQVndUGR7ykaLuPbNyFNHe1kB7
vYk9N1mKOtkTJrYOO/EUSE3i6xkVUtTVqGUDJlf5OTisze2iPJOiDp+NzHu4
HNUCObvvL8fL3n/qtuhUZkx1fxtYJIk8v6mUos7/Cx6DGfM=
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
           21, 2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
           36, 37, 2}, {1, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
           51, 52, 53, 2}, {1, 5}, {2, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
           64, 65, 66, 67, 68, 69, 1}, {2, 3}, {2, 5}, {3, 4}, {3, 5}, {4, 
          1}, {4, 5}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6303192962505789, 1.4876218973029331`, 
       0.0005797939520425094}, {0., 0.629714428901812, 
       0.0006180106941365837}, {0.8593461265010855, 0., 
       0.00013831132020443448`}, {1.4901071967290844`, 0.858359946964393, 
       0.}, {0.746112934024352, 0.7433341273460402, 0.5463963224169619}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{390, 298},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2019399611]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PackingMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47225018],

Cell["Pack disconnected components using different methods:", "ExampleText",
 CellID->1302252890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GraphPlot3D", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "\[Rule]", 
           RowBox[{"Mod", "[", 
            RowBox[{
             RowBox[{"i", "^", "2"}], ",", "114"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "114"}], "}"}]}], "]"}], ",", 
        RowBox[{"PackingMethod", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "m"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Layered\>\"", ",", "\"\<LayeredTop\>\"", ",", 
          "\"\<LayeredLeft\>\"", ",", "\"\<ClosestPacking\>\"", ",", 
          "\"\<ClosestPackingCenter\>\"", ",", "\"\<NestedGrid\>\""}], 
         "}"}]}], "}"}]}], "]"}], ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47617879],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmXk4Ve3Xxw9FOKaQ2THm7EOmRIbqvo2ZMpQxpYT0NJdK6hEyNEiaiAxJ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        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllns41Gkbx8ckORtDDMOYMeWYQznT9jwOaURMDoN0EsqViqi89t1CDiVJ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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"Layered\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmXk4VO/7x2eQbDEmWWbsM/YlovpKdR5ExhIhos1aWnxUFNXnk5SIKGmh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        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllnk4lGsfx2eGMNYxNJZBxi5GonK8qvtGOYaxhIQ2SoeiFJVXy0HZ94po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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredTop\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxtmXk4Vdv/xw1NMiYynMFUnIOTrpKk214qMhSSSBlSKSUyhJvKEFKIbkWk
wVChDJHMsjOTBsOXlEIZUmSW2c/jtM+yur/+6Xlez3nWWeu9PvuzX59D6vBp
IxsONja2J+xsbJxz//OdqV2VOksDMhbUSZ8mHpzt9z+zvyTu3btMAmp+hs53
yfIs3r9ts2gL/gXTFtVRObhMEt+6Z3Sx1sM+rID0IMbo0jBWNLrN+AqbJN4y
WVrz9WcrFvuXVbbT+ArgIaRZHWNEx7X3mdyMlzqI4U8zjf+t4QEdpof17Xzp
eMyD91u+uRtji/dH3PehsYG7Sj8WU/eQcG4tzsKm2laMK1ug/ouqIDC+qeey
cnS8sDJWXQSTbsV2zZy9Sd3NDz4d+v719DF2vEjZLZbK3Yp5Dn9uW+4iAaRD
yzhDu3jw9jfrCuzvGGLLvLa56F2VArcdhqtWCy/DlXrY3Ct3mWAnZhKOBrtQ
gXhY8e2VjSTWeS06PtcmbyMBwQNFCC+NLyFRPpKBKKeG5KY6aRYn1olud5Do
27Caxc09X2mJ63IB5Y2HjB/4KuB+eWVUdzkjrMkqjp4evhLIPYi78s1QEq9u
6OhS+VSA3TO4vH3/SwEw4xD45GivBK4haHlJ4FkrRpEua5heLAlSRyQifW5T
Wesz71EW1CfsOy8VJ/0HpwEdBxOEr9ARluC7uAJEbFgeRr/Nh69mMyNNHOzD
HpMvqHGR+YBkUq/ZKxsenG7dFhE+1IKlhYnk9vTxgKiS9ZG7BmVw5WExEbpT
GyZ02Lrk7whusNIk70e2oTTO91dHtLBAG7ZBLcRFIGg5GL3TeqmPJIs/Mvng
kSq+C/unr/npYNxSUJ9qrVRQKIebaYU/e/HKEHtYmn9n3JEbhBzRYlPTIuFF
ow5Ds9dasQLZSLluNQ5Q758o0DQliKcUszsZH+rD+NyP+hgNcQJM9yO510EA
J+0fEOTrbsHYz43WCJ5TAkPOUkg9MzkDSPxR50Q+10MjHmk8X/WfPDn81jzg
kG4rJPiNR6alq/JoYMlGESP2f/tZPEcyxmHAbgRL3T3mtilQFm/YWMQ1RFfF
1CsE9WtaprFba7iKA6fk8FsaNzeEfTbAzr0vm7yayQMYasFF6uyieMM+Be/I
jhbsOzYzzP3wO8aRqj98Wp+XtZ8aLq6pIK5RLGrZ+9aNe5bjRhccPYPrWrAp
/mcJ5VdIgNaVl2A/vQwPW6HodUruIGZYLaTxdoUoiEi0R+qQeqlovm4f0O5Q
H4Wv+c95ozd8fmddvvoPTgPCEyjneKrkpP59EZD8nc8X8Wvy24+3YF8rMts7
LJeA4G2+YSU5I4VdAVqfxAtaMOY68mD9uClSh9J7Wuefr3E+nnuqhjD/7A66
nvPLacy556By6i8Z3OiA+/q0Fy3YNUy0UEufDahNvMsx2SeNh65LXvbTvBWL
6ZMYuWU9iUmX6Y5qH2Ww1hl9yrtGL5wNXIw3463BFXB+Sw1biuRubFE35W4P
YxRLWiHkPUUXwyV0tkV8bW7FHn8OFIgN6sU+hDSNk60nCrUNB022T/ZhK0Jr
fTPtxzAT18xghYSZQqCg8+MWRyu2LuDUoVw7KWC8glKdlj5TqNcaP15+yYyV
f/aIwVz/pP9Rh0rgovhtpN6I+oz4f+uQBmL7YwyKpuHz/jt3zLLZviT5JRVf
VxzzyO9QPaZ4NftrvWcvdurR01UWjIlCthg1tVX3A7D3N94Jx/dSQQ//ZYZG
22hhqLWQxpEvRthqv9d9a83HMQ83Q/bdxjK4uXfjGZpCH+u+Zv1akXvPC1I7
p1IrCRIlHJG6+naWEZ8hsgy8s6FSTP/qKvSuuZL/LdYLU1ZZWtMSKApejet7
jvzkwUdp7bI+bcexOt7m+XtPOFVJsRiThfX5+1yStTN/x6+Vx12qHypvtTuK
zY5xO2TXjmIB147JV03Rcf062T0/DUyxgfCt1G3a/MDqZcJyOQMZfNcO95g2
72cYkc+vCR9Bm5XcuK35wCqvufu6eP3KjZtaJDDcmb25C7Dh+WaMfje/vdgR
T5P555ozijvRW5sNvZdJxn/yP5BkwJGuygGu3f9pDcYFcTBpvfOX/2XWvW9K
KruxXGii8Ljqtey8JTrYJq92l3IpfrCXK0RvTFMGD2dzlxk42Y8ReSpwlyHv
l4AQlZFqsbk85Ri7xIW6CmnGvbunDfuwku0V8/3fsg997zDvSxF0839B7ktW
ycf/0aIJTDtvlvejvgyLWyQZis7OvU+LJP4XV7eDDRfbteoHY2k/VnRcKXpH
FhXQfj/X+Hi+/9hRbczbRETqkXEb9nid706ZB5L4gaLhsz9S6jCib2TbRCP5
TLSSF/iDIotXq24TrfouDaLVO2mU6tHCLu6kN/mR1pheoi17qG0/NuXF+6Ey
d6hw0CVMf5TRiql12TWQf01hnl6i2fw1ongGv9m3Apl+Vs5cEi+R3IgcKH5m
SJ/58Di7byZyJShf0juWoTP3nmWPtE2+14stLlWdz19F8xVSh2FZhbVl3iuA
qUY6u/xVPhz0TfI8YwRizgnJvUcTJcBgMsdI5lJB1udBhwv5dsp3bGLtgOMG
K158H7CKN3nUh+kGrIvay8sPhLP3rZvYJ4Zn9/Q/1l31ANvJ/tnF000e0G5q
Iu8XIs+ERbeQPiB+xfXsKbvFYPX7i2J52StxjvGi1gGuVkxX8dIl7l4+EBs2
SvXdIYYnm2zXY6/ow35qaJ7ZvmgFMKMar20fFsAN3r5yXvm+hVU/4Y9P3Hm4
Uoy1vrYdd4R+5UrQO6RqY+9Nxb8r93DHHm7FbDcfnl7jzwukXl5R2TyqiN+9
1Jqwt2Ev6/kNM8p/9StFkrXO4Lh57Cc5GbBnl49Vkh43btiQfqT99H5siYXf
ozR1QbDW9McTg81sOL62mLoj3x0LLH3k3PVsCksJ1jHYVSuK2zaFVgiKJGBF
nQqT9rNUkDe6B+mfRD4GO0nIe9xXKnBN1lyfdK6M3utZA/luV8OTRxfTQaf/
/eaKbZDnKz/heS9EB3XpH83lcW4Wl0uiFdcr0sFued0JsjHkmfGps/Z6dDB4
ZthNbynk0ZPJTkoOdHBM6sWmlpblLM75z6SdwXU6ENDpKWJvg/ymwTWZbxl0
8KvVrzxqOVxnkWuY0vo6Oqgpfb/Y1AzytKnF/kXf6UBYuuHtlzLILZ0qD6aP
00F2kkSWqy4815eXuVNvZ+jgeacEkk/FPubnuwUksRBb6BX55cz13e1PyEr1
QN4vz9zPcp9j/UlmfCy+ZzR0fv8Oy3LX2iZAnreKed4IFaP1HLWQS95m5vO6
16tgdR3k73Yz81yipOOV/QTyFdbM/LeThiY7LSE/N/V4/r7yta0jmwbhPv/e
z7zfac27YuqOkP+SYNZDT39UrH8bzCFibYMT/y9xMDBy74LwR1hXYjTHQrtG
cdDT9vPo/krIl9Wu3bQVFwef6B5cERmQ55WFKcemiwN5LSBaexfybjdJ3q2p
4uBNvscI+RLkDKrHFvVMcVB59YTTbQfIry3KMtxRLg646j0HTuyH/M6aIq4r
beIganJV1u0dkFtFSehUcJLAqQyfH9QNkNdKuBy3UiSBY8+e8eNykNvOmChb
mpFAbui0ubAk5AH7Jef7s81G2+DzFMhjk7q5WrJIQOAJ+vlzZ1/Xf2ongeJv
6Pr6bZJDZ3jJQJP9IrKfnnWeyhlKZLDdXATZv/TqKz/GdMigfbsXcl5GY+ks
+0Ey8Fx6EslnubaE0qw1GYRsPofkafEykSvKkgyGX6L5W/gILJo1JIOKu+h9
7Zx8c75GjQwctPuQ+81/ZVvFECcDWd37SD0EFQvTT0lQwQGNhERSD3y/9Ot7
Z1Qvo4JDr9cY7B+AXC9I8Cv7IAWcFJTzrByBPPKuyAfBjxTgZy5baz8O+aZT
KlVLSijg4NVG2R1TkIdcVehtT6KAb4W+EXozkBuYh/pmhFFAZJKhn+8s5Gu6
/GvPe1JAU5bL5R8LuNQndpsCVTJoUEP5TtuxZ/6SZJBCRtcZUzXX3cdFBmJU
9HvbDhjZrx8kgcymBmSfqQqOFnIfSUDk1hrkXK+Aq/GmEhLYrS6L5HDTe6mv
fTIJpLSvRnLjFHDmexNOAio745Gct0gyeV3ypyDuIsgbbzLXeS11qPNNPuTn
9zO/t7jZMssiG/K1Wsx9Jl63OpKTAXmoO/NctdYpfF/TIFczYeagqcRx92Mq
5P8EMHO7uU0lLS4F8tgpZs7GqoLJ6gv4oyWX5u/F9DnKvc8x79GrFl3n7RPm
vQvVoN/beZlZJ+7Cqcg+RbOZdbVq/yHkXFOxzDpsfWaF5LD+CLNuvZZbI7mV
1DHrfCz+M5Kz7QkejmcHqUDO8WLkPUvok74rHAx7jKnA1nv0cs4JyA8fUMi3
2k0Fhby3rTPOQN4xLBfHr0kFH9etSw/ygpy//Eb0jPrc8/XivtCWQMinC8WC
lZSp4LDAIqWim5A/fz75z0M5KoibyskQvw/53puk50fIVOAYa3t8WyLkb6f3
z3CepYCHBR6vX2yEc65PmNIKPnsKUGgS8UwHkB88kJZ7/BAF8Ot28Z7WhXzI
QWpQaC8FuF5wPT2wF/Jx07p2MU0KqD0VHL/RAvIX+R+HPTZSQEO79Bv1Y5DH
3X2atUWOAnQqNflnHCCvdsgZPiJCAfU8k0883CHPK5OPO7GBDur9QNNgGPTY
JW4V929to4PHMXVXH1+HfLh8U1WrIR3Eu+2rbAuFvDCzOx5Y0QHFeItd5FXI
m40VstLt6cBWvUC+Nghy4BXpqHyeDqodrocHB0LuaBagnRdIB1rpb4Qqr0B+
XOrUU+1IOqDrFXwJWMA3/Nx0QfiYPJDsRnnFc0pH7Bl5kHrsLbJOZQh3gYKv
PIhRu4F8r2rWWbcn/8qDKPILZJ/hRnn+lGh5cFvvb/Rcf586ciFFHhj6mSA5
XAhqvlqWLw8sSuuR3HJUPAKHq+TB8RcaSM7Br7cWL5+bx9/94Q9FZ//xtHBl
APMNqG/szac0d9swwOmlqJ982xa9pnc3A4yEDiI+Y7ZTrHuvEgMYamoj/nN6
SNz9Og8DNEd4Ir7E4/76vPM3RaDsZIj41bn7m0qbShWBXlMW4mPcHutzQuIV
gdPwEcTfLAeLjsyGKgJGxDHE99IuzAbz+yiCQF4K4oeKDL6egXOK4GodGfHJ
nZHMz5slkhH/3CtXPL/+q111iK9KlDD3s0mtAfHbF2PM/denXUR82Pg987yP
/b4j/txnTJrPx7U6H/FtLIaZ55agIcTPZ64y85+9p4P4/M1B5n0FOKH+XxvO
vF/NM+i8IPqWWQ/7/pgviLkjt7SpFkuD8xoxdwzJmIl0nICcmDtObnZvDKNB
Tswdcm5rZUMHhVmcmDs8onyPylZDTswdGU62mo7ZkBNzx2V/r0D2HMiJueN8
zavgN68hJ+aO7uIRBcURyIm5g9t5WGBQAe6TmDssVCP98uwhJ+aOg8aRyNxK
zB2uJyIryqcW5PB77sgX2brl360iLE7MHf4xW6RMXSEn5g5Vm2N4xh3Iibmj
+lx6kU8a5MTc0WVauXRlOuTE3OE7lvzN/B7kxNwR+5NDbtgdcmLusFyc69qr
ATkxd8xyvle5xwY5MXe4m5l6bM+B512/Zr2SgTMNhAQIm/ly9bLm/SEpNpML
h2lgy06hN2m9P1j8u5vV9U4TGthVVrEqKeY7i+8YuB4qakgD1CB5zt0q3Sx+
UOf9+WP6NHBgpKZhIqeLxafJ/kIde2hgdlFhWK1GJ4srXYu7d+IADfCeWHmr
6nM7iz+XpE8GHacByS9h/Q0xX1k8/GPj7Sf/0MDm0xqq4re/sPjbu+zyv4Jp
oMbS2kOxHv6OQbrqEuoWRwPiq2f1fcwgl9+8f/53NjwkUXNYCfJN7VsmM2tp
4EwTm8HCzz+oSjm0sZsGYjOOIuuHeL7v85mmgYItWsh+LGQDQmP46OBeTxSy
/1/3eXqKSXTw9Jg4ct4L4/Ju2qvpQD+6DMmnJ62Rt1yODsxqmpA8w36SJ4Vk
6SBvpzKSf5i+4ZiWBB0MLHqH3FdgUOqGpyvn1kkVR+631OX8wc+cc/N+lThS
D5IkK8/RQTKg3r38YPQU9IHFLtNKBeNk8ClY6PlHa8hl5UGJDjsFXJp1bG41
WeAbods/RXLNzSPNH4K4dkF+tqCx5bEgBfzQt6ObaUAeVLJn+CyZAr5OLeGv
W+BLdW9OL1005y2xAnuueChCrtJv8EpTmQL+dzK2wUga8txLghcf/o8Cog2u
OTYs8Ldlfeqno9ooQHzDUOGXBb7HkM8t1fhJARuLZdbJ+kAeLqwbcnOSAt6F
hr2Jc4f8mmJEVCgXFbhEe4ZbOkD+qjw0aK0oFZymfTttZgN5Z2duxak5b5za
Xrr2ljnkBcLpQZqqVODEJnBd3HjB79u/vStaoJKxPhdywrvcGOZfvmdCTniX
C8dninQG5IR3dbeUFDalQU5414ZyTS/Bp5AT3hUxIf6jOgVywrsEt5qe4FrA
Ce8aadBUrUiGnPCunjNaCCe869wgug7hXfalJOR7Ce86nqCF7JPwrmONpei5
fnsXWaAFyYHwLvoeCyQ3wrvW61YhOR+WYvLEL/YShk+hj4k4M9epK/1wMuIZ
5HRJ5vc29O9Xss6E3PIv5j4PrXS+mpgNucYN5rmEFQdeO+ZC/smWmUPaGOlw
Zh7kySHM3FSft3w9mw95ZhkzZ2PygHDeAt49bjd/L+ae/Qjfp8y8x9ds6DrG
Zsx7/8hAv7dzHbNO2nT7kX0GhDHr6gvJCT3XY2YdKn41RXKINmfWrURsE5Lb
0XRmnQsnnkJyJrzX8Y/3F+G9qpONyPuO8F68PQd5PxLey5mIvk8J733qi75/
Ce91S65A3teE98ZGpiHvd8J7U3bbID5AeK/GQXXEHwjvlUjegvgG4b2vu24h
fkJ479sq9Hd4wnufP7+F+A/hvQ5LhxBfIrz34YVhxK8I7x3MqUJ8jPBeyzhP
xN8I791efhzxPcJ742VRPyS89/I61CcJ760WQ/2T8F4FEuqrhPc++8NvCe+t
kv16Dh+Hf/chvJfT/zBukw454b0eUd7eq5wgJ7xXtVH1Lb865IT3Bk4F88YL
QU54b0mt089+NsgJ743ovLz+IjvkhPcGK/9PxWAV5IT3jq+erU/6G3LCe0l1
0znOZyAnvNc+IpaxJRNywnvtnscif/8ivNe/KtZJW1MC5vDbe6v/2dmxIgBy
wnvDOLSqGgsgJ7x3Z9npEyodkBPe29ycZ8cxATnhvb+ya5/eWMAJ771hlvXv
p07ICe9NN+B5dwaHnPBeh2PFVIdAyAnv5bdp+0zVgZzw3oDcQzIl7JAT/dzV
YdTlWj3s80Q/v7/nSOH7RsiJfh57vs035gPkRD9XvD/R1t0MOdHP27LOSqd9
hpzo5xf8HmSOtkBO9HNODdtNua2QE/1cMuHsyckFnOjntOUoJ/p5ZPBxZB2i
n8fnxCHfS/Tz5IZ/kH0S/Twlfhw91+9+PubQiuRA9PMfjMNIbkQ/b9swguRs
9Gbu+Z1kAJ8/7kX38tzzPsIACYfQezzTONcfOhiAbILeu4vtXD95zQAtimid
7Doz139SGUBOAq0rpdVz/SqYAfKPoHX4NH6uv9kyQIkdWreU6rl+qMkA3pvR
Ohe+P9c/5ebeR1aayHPxnmeu3/IzgEexFvIcnQ+a68/sDJDChT538/18UvE/
f8cnPh/eGIM818T6VRS0DxD7qfeZQfoGsf+SR/VInyHO6+2K9iUin8sX0D5G
5EkpQvsekb9NBtonXX7fFy0I7avE/d7xRvswUQ/Ff/Tt/wMyOYBf
        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxtlns01OsaxwcpjOu4DcPMuMS4DBJJzu59UXKLIUaKpNjZR1S0c6qzXSIi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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredLeft\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic]},
    {
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxl2Xk8VN/7AHA72bKOJduMZYwlkkTFPZbsCsUnsmSpqCSlLGUpopKPsiSl
LJEKQylkaW4kZG2TFoylVGRPKPnK/TXH/fz8k9e769znPM+Zc557h+jpb7+b
hYmJKZ+ZiYl18V/+f9pi3OyUwLwl+bf9LjLK9H8/80853D2tFUF0l3uH43tR
hnuHGPRdtRUAgXv8m4s5JVADu2l209xR5Pv6zDwRSWHgK+/FzTcjjvb8rHve
P0JHwgUqqut28YOQ5pZqKWdZ1NzBMTmPuBOZcb2XdQThBFu2cdUUVcqiWTmd
mz4HbUe4XFnbUF4COLm7Ya+4uQjKY8pKe/uCjgyO/+DwucoPlFmDhGymR2iN
2RvFEBIdIUbaTqLBK8Ac9UnXhN0MrUbrWLYMDx05aMgjnvmMCLhRGRE1M050
oFWz2i/dFtE1dZPcc10enMqwfv84kAXVGGYKarR2REJnG0XuzpFAEddnWoCu
PGO+U8MDTYaeRKC6fxDnY7ztMW7PRQGPQWj5y/skhid73W9r8RUDSbK3ys4R
FKCr1if9KmMFU5wsgwLdRDS68qlMENkeOWTuJ5JWLwe0whWONl2WQJs7Pg6u
66pGciJpRp0PZUBfzl4+9wFx1FDILUaghI54pm98+PmpPJjVJdCUr8Dxg0dk
Ls7ZcwIjm83XjAMp//GVoEzIFOc/hJmvPdLgA7qqLHIlLitQBSanVXM7R5GI
69su55txATT748B2ZU6U4tF7+dJkD9L908jl2CEpEO9OetboJ4dqTUmIUQJ6
EYG+vb3Xn6wC3H3b9A5clkb513zMFBXoRQ5+OotOzLCBgC62teXD4uhNx3eh
RZLWyL30zvlXgixAlZUzepu2FOpkeqnkUZMt0pmU0vKreBU4nCbvuVZfBK2Z
Pji5cIGOKNj18Io1zSAKJxU7pN0EUGotc8D2XaPI0/Gj6Bf9X4hMHPWJVyYP
umrHuBD/lx5kxnRUcetuCriYRreXUJVlzBdzMsjj78H5hFGZjdVX5f9X33bH
L5eu6pXSyhZGFv9OieH+80ePmo1+RnT/XRqP4Y7TmoIHEgaQPgNtYctGCbRD
p2bFJGU9Ukji/pxSOYHcG3HIHymUQlMNk7VTurciJtck559ukwKC/r4KOjMC
aIeDamTaxx5kTK/mVH56BZKdaxoxK8DFGH9a8sCRrMcDyMaFtv2oMDtqH3Yo
/PzLHsT5+tfpX/myQEBc5CG3KyuaIqgWcYC8Ezm+Rq5AgEsQxA3cxK1Di6GW
pXWb6vW61DBYkeHvtd4Mbwwng8t3i0qUxeZpeKcAw64HOKd68WZWqv5GmHhe
Rzy8/gjpk7ygYry3Bym3jDc+c44JXHb/5FgU9ok2GGvaJVndg2wKSjAPuy0M
sq6Z4dZhR/bHpc/X9c3nH7MelWN44B3mxA8+osA71tJL7Ygcau8ctPbuox6k
1bbW7YYsATiqRLzOy5JGEzQLuUZc6IiwpViCi/4YMpA6fObBI1hH1yqhAWeu
acQk5GeG/ioSutLN0EdazgYxyw9X+hklDC6YjfdOywmhshZGl/s/0JGZ1CQN
6ucGRHsmUXZX8yjN3HbC0fjnKHJMceHU9NkvyCXPm9kG6lM0oGoxlMpCR9y3
nOF8fUIeKBxpGR4KmKRZ0fNm62OckODkk8VzF+RBFOq2uH8KM+IZNog4auav
Av78nk3trMa78pIz7dq36a8bHa+XO5lDBEv/P6rMGOdcb+U2VEoAGAlZKd0q
F0M1a7NuRu96hTDZW54IedCA7CAbOtG9R2lMWXp6hIxYZJUgm9ZILBEE9x9K
nwaDtAQPEUOvPntkZaJKZdxWEdBJCvdOzpBFXSLfBCqrjiJY3VVBonYNru6Z
J8I9Cq5IgnTn27h1Vf2TleMfYxYQyTJh9vX9XVrk87NVn7MjkAu1BrKihVKg
RCXv38QtnOi08oDSyd69yO/Dg/qjuiLgah5L6cxb+PmaWVWU0Z72hNZ3I7Nd
+KwceqQ5V8tgvzfSd5NDYM5lELHw5KrW+UcO3fJSyW5k6z9I+AlH/qx0aXCj
fHWQeYosam0SlNUbWYJovmA+1VbdQEsdD7k28pod9XEZJ0Qs1osu97i30UcW
lGuQLnEZfqdVOamPHYvehhwN9Vr2uYbrc+l8XPy8MP3nx9XFuubW0xmEfmUf
+bSzAAp+epj9OH0GoTpbJ7BpSwEBqRGfsze/0fauv1BeyWGBZB+iPPQ6Kw3O
mc/OfD0li15iCpIf3zeGMHEUucolKYAy4y+4/cdFgHe7/+bFfAr5oKwTxTTl
7d9s5m1HkXvDV8X1WSSAvcpx3LmD1Usd9Me14urVfiI183aICDhS8CGsOBnu
ewnvghIyF8/TJ2pXXCv4p2kS1oQhdc4xROD42h9VB4iATv/kqxBeh6CzVadn
vM2RjlXOtSLyAkA3tX8MIJKoc81UyBD1JRI9/a8hi4UsCAoJx63Pluvsy/oH
CYb//O1KG/ipAOgb1JOohEHaIE9Ba1WaB/KqxPHXloUXSPC7uZ6HEX20iSMp
W6bV6cgrlRfaZjqiwPPBdwnuBkH0/kqnz9XyY8h7dIE9N0kW5LV8wuUN22fE
QJyyBW6fGfsWFIQ0yoHDxmXbvM8tnrPMaT6F178h60ZDl9azciQbbh0ujDmw
aarzgR/r75wv2boCBaM/eUvUzyE+VyekWz4SQfN51zluf37G9Zne/o+kvlQg
VxS//KwmcqEOwD3P8eYokh/Y1kyJkAaz37QSp6yF0PLhsTuWhBzE6dW31b32
c0gF0zjufMHOIyVQmoufV7fo5WLp1QtI4Mvf3QsSgijLbA19fAUdUTULrWH3
lwYxTS8jwzYKoYWOxlbMDaPIXXYPM4o2L7BfmzloV8CLbm1rOizc2YNwP9Jf
6h/8hCvRig4iY3zyliyrQboceE4Rrd8bJIZ+1RrmyfakI5mDrpZck5ygP1G1
4aatPHothn5rW8c2RONk/9K+XXbB6FHPT3iOyD0OtpjRVQR6YW/9LfLZUduO
e14D/juQ3o09+ew3+EH61ad+92a/09DVtTImVUGITx/9fYiiKEisUbpr2iiI
+rxNaBASu4XcJcbzPeMkgzM1nrj9E+tXFcCZ00q4fjWKLTZlz2IfK/jJTMTe
DbrNDpt3wv8ogdUpsaU5G6BXid46EbtHCfhmXiLMS0AnJyiujQ5XAuYGE9Wz
v2FdSs8V+EtfUwLj7VKudUPQM7vv9HbTlAD/pgSbr73QWXfOvP/drwRm6iTH
tPqgJ2vFJ6VykMHEEAhIG4bOtiMxo0+BDCgfXwNzJhjP3R6W7wGbyEBvk8Pa
/FXQ3bY/bfKwIoO+6+RvCZug9+WUHYiwJQOPQnw/36CLXT9SRl5JiF6WhzvY
+EIr5xrmcqCP8WHx/NgWUumKQrd7e34p/vZ1/HG8r6BXzv5Ymq+koTbvkW7o
cmFYfshFNGrlMm/XxPJ5bGFNBn3ZOIImWP5Ph7oYFDyGfrwnb6le/ezlH2/d
hK6/EavvWvb6zcwx0H+wYOthtIjj8zZP6Nc29zVcYVUEU+ivYdMd8LnG1aho
tGFSAXy9nF7ZrA19eyq/mtZnBdCsXMJmzQOdKmhE8e5VAHs8EBLaJcLwOt9Y
wr0eBUDdcv+DAxX6Xn1tqma/Asgeu/jKNgL65WJ73QdDCkAhrOrVqD10WcPO
5DczCsC0edjdThU6068Y7R8rFMFX/ZoGJ27oeo+Ka41kFMGHjUqC6ePw83K6
kESp0VYEMVMP8037oCc7cy7tz+8ME7hFu6Bnsw0ns3grgjWqFbjr+Ydc506G
KoLUm/jxZ67Hnm35VxFceYOPp95Uh/ItQxFciv+Gi98DrTy9slARdLpU4+Y7
KPFuZfIDRcA7kIjLj+OLmDyhh4pgteUDXD4X+JuTd5UpgrkdAJf/hYMLFxOL
FUGWwH1cvaby3Vp/5iiCkd3XcPXVSFb9TklRBK6+87j1wOPC9COznQRa3Zzr
vxvBffhR1oNNdnUk8EJBQjJ5M/Rh2u+XQw9JYEd92t1mM+hCFie3BlJJwOtA
2vvrFtA9NC+YjWSTQDvbBDu3FXQ+Qx4n11QSIMg0POKzhu6nrK9QF0cC/snU
+7eXeadfuRUlkgT4JdHSrmXe4TOd3PiBCPje03DuSw2oUn9OBKHW+HGML92I
TakjAo2Wetx9S/Nk0tgqiGD+zjguTpkL6hfDqURAXYGfV4FkMS/nDSJo3InP
w4UNszeyUokgpFgclzezU9QvdueJoLrXCZdn73OY84keLf+mDv2uCTbOiq2l
u7eqQo9Swu4bVbCulUBZ1v9fw+IM5tTJMSFD5y/F5sXj3xXyVhG6Zy6WhzoH
zsevFaCzPMLydqBHrklvmacGY3lucVrZyL7M08KwurRexjuHLlZHDzIRN46a
LVb3gpv4+z40wNZJdwM+TjtHbF2p78PPq7YJW4dC4jq4PPTkY+vWsxafN2Vv
bJ3LJOLznNQq5jdlJwYk8yvXbACwz6ceC6lUtxIDOys1iA5W0ONpOuQsYzFw
z/zl7FZH6ALOa/ntNoqB1v2+lmQP6BvUMniAlhiwme0seLMfurKi4o9DymLA
wUq/3vUYdLok58AnaTFwaf2kdWkk9PBZJblcITHg1ZW10HUO+pynt+9mfwK4
PFOy21kc9icFcxtObPUiABkRO8IWEvQYWpXibUcCYDktd5NbDbrMKzVXRwsC
8Cmncsavg65Q3b1150YCqMurQ14YQP9CHHSvUiOARlmXPW/MoLeyVJHCpQlg
E1tEXpot9B8vn7jn8hFAvZm2CcEJeooU8JgQWny+o2jOieyFfazq8ePOWzQE
gLhpLbXZCzqHrEsR3UoAiK7a/JXVA3r6r+p9mT4CIG5G9XylG/ROXcOz0acF
QEdPgdWUC/TMeOlfUdkCYIPwqTLqTui/DWfzU2gC4L7jo3VDztBHntccL/4g
AFJHC1jvLPPY/S6ilseEQEJ8Ic4L5xQ/eicJARkeGm6cuwXMKceKhYBAN/6+
8fNdnMdahAD340JcnFbaHkrOX4XAijE13Lw6uGt7JTiFAU3ZFJcHyZs3dArk
hUGz7xNc3i7MdWtwAWHQ4bkGl+eotPViZrvJIKLzmtIqDfjc9HBzwIs0dzIw
DZXpO3oMuuUZgqbSYt/V5sVEqiuD3sOfFkLRXeyvlC1eNn2DbisspH9Bggx2
MYdaSnLD9x57aMJNrdNKwPgSp/N3Yeisxk/bqS+UwA7eE2UFy/zw/jUShGIl
4P7JQcd0BXQWUzW+potKwPbdyZbVQ/C+Do8qyzaGLvbDalGffe5Dv2UxQ7fa
rwQ+7OkOzDgMXWGWA6xe7Lu6Lbpx780MdmPXP9Hu1kzql4F5mMTGD4vRq27M
gk64gMVz/9eGTtb90B88weJn0RPUu2kM3SoHm68fqU7n7Wron+RElvJjb0od
N1vmOn5YPktzGwV+G0L/7oTlP7Uo8MUeH+hxj7B6vb9cHeV3HXqjJ1bfDVcy
aqt6oK+8iq2HGhO5CDEyzMPesYMu274qA4SDq+OQDtw/15isy2IaUwYuD8yC
a4WgZzJfMA5cUAapqGPnqgn4/M5znG/ukBgFHHO7FyH+BvqVY8k63DoUIDv+
QWagFnr0s8RbTTsoYJPL1pUrKqAPmtKzh05QgNKnd3ftlnmwzFHn6AwKkONl
Xlv+BPpn49A9bdUU8A/7JZa9ndBTmr5Wur2mgL0uot8bJ6EbAWrilgEKEKAN
UqkicF5PL2SsPfCFAhJa8O9RCxSw66U6B9u1XZbl4RI2PtCoOCcRBv3VbMhS
PIqBemEnLkNfVxe4FP9vh1Zr1QLoGR97luZr7jHVcrEUOpsvlh+HtohD75b5
fSksnzmyE7sWlo3zXQPLf8kVKaamNOjuTQlL9RJUCs6rD4dOJGP19VCM5ZRz
g/5+BFsP0u1Pbx/eAN1nUF241XMAGVvQX1MvD59HjpTMRxTv7keGhuLFuYWg
D7JMbjYp6EM+rJWotphXYnj4LRUJb6QPodj2NEV9gj5GifxmpNCHtDyVuN3a
Cl3Q28ZHzaUPaUjlUrQug66Sqs19dKAP4eqWzl2VBf18RvyLK6X9yBX20n3W
8dAzbUJakhsGkP2P5DLaT0DfECCK2vB9QnZX29cGHIL+bbe2mMnRQeRhWrpA
vQ/0Lp2Ipfds3oDzz77C8Mo3jS8tfb8iKx/gr480+Kxi+HwIqZnAjy8ZFiU9
J/oNMeEh4uLhmfMTnyKPIEZ78PGXJ9XRJeZGkH4bGdx8+dXyT3meGkXCBFfg
8jN779i8VcUoEm8iictnfNiz5yoZo8hkEz7/iWFMuZZao0h9Hr5efdZT+7qD
RxA/+39x9Y1vr3mDHv+GKG43wK0Hq8h9X9Z/EQWCnY83JW6B/YBmJ9fV36Oi
oL3exibIGLpdgpVG3A9RELLhTuAJ3WX9xtQW8/cLosBVTEQhVx16DqnfcpiL
ALrP5jyeWtb/lFJc3SuFCKBjPcg7uKxf+r32+OHNi31LitU5IoEf+i6HnTqx
ygTQkPv+4Agr9IEh6W+fmggg6Vwj1+Fl/ZvWdrN3H94QAJ+/2o7wA9B3JNRp
Rg0QAOW3S8NjT+hoqMPs63ECqH3Wugdxgl5x8QbH8wUC2PO+bPXcVujf1a5O
+/OLAU8vItd302X9p/XTtdTFvnE0/PdTLQPog6HV0zHqYsB7o4VK6TroZ05r
hEzfo4D0ixxXSwp/Md6jvtRuOarwmAKsgjOQgCToj2P0M/3aKEBTjrpKNQz6
+aMjYS1dFDDA81Hl8z7ot4U145FhClhrOqxEdYHOZ3DdlDa3uA/3ppw+aQ9d
X/y8jPkKFaA4HxS02xq6Nv1QzGsxFQCeDH/aaQmduVB/W/aACpgrGcd5SiCp
UmNSBQRlhuHGuWQjkFTOrApW6Kbj7st2LNxaV0AVPN86iYvTSxDdeUdGFTyr
H8bP69chPW51VXA8vhSXB0vLXq9tG1XBx5RbuLzFTIXvOmmhCta6CeDy3P8c
68fEYl3B4ZOwH7M5gvVvhvuexVVEQz/cVrPU75mkmNtGxUL/ML5rqT9sLfOg
Np1d1t8+wPrJqHb6SGLcsn54F9Z/yl7jieo8Dz20AOtXc53a2NLjoZ+Twvrb
GpSu07XMJ05h/XATCe/NkzNL/fOm3FbcOA2GWL9t+YIbd9/hMbDUn9uO9uDi
XF2B9fN26C7cvG7071zq/6/GmuHy4G6OPS/8a9qIy9uXSWTp+SLaxgWX56CL
9XsQf2VQ50H+uYXzEKMuhfrMpERfZZAz+K5N/s09hhtE3oyQcVYGszkqAyEp
j+HnhYPSSDRSBjvUjflsHRsYbsKTff6MvDLgjbpu5CPfwnDnshuS9UzKoK2S
VUntShvDf2xwlMv7QAY6hsQo1jPQ93g99uGvIIPamlQ9r5Fmhk/rV7nUXiUD
qaNO24tY4H0tSq04taPJYKA46v4EBcaZbnhG0+QoGezk64g403uX4eLjlxKU
DpFBJ79Zyqq0Bv2/ruWKXV8erBO5eD3CyMMQNr4e+90/4zOc+wwWz0GDU3/i
YfjtKiz+ovsVf+JnOJKOzdcmVv/PfBn+TjxnKT8Z3BJ/8sNwld1YPlfLFP7J
J8O/2GH5Z+qz+pN/hkeUYvWKebj6T70YXu2M1Vd3Vdef+jKcNQlbD5eTltYD
w8uUIzTO5hAB07uMONNv8Hufkyc2B+rcIQLpsz3qaY3Qx/QyCXceEsGO5JH4
8VvQd5ZIt9x8TgTrtSzXjcRD/0rNWQHGiID+JPDVw1Dor1huHGcWJoF5jcEn
3Yegr48YO0pcTwKDDw/vJQdAb3A8rV7hRAK9PZc/xx+HrnvinB57MAmIv1Uv
35QA/SPrz3+TE0hAWbPwTsYd6InBj3ZHXyeB54kR3tFN0AmNRRzZN0jANgv/
/ewvF+z6rvyIGG7hZd9Dtc4tjc/Mag9G10JX0MLi+WT2XMt+K/TT89FL8dMo
e1iYlz23jkpj812x7nzUXj/o27Oyl/JDuCGmVLzM2RywfO6ePEt4vWyczT5Y
/gMP3n+QaQu9iBWr14vZla7X1kEPcMfqS5qVqf4usuy9BBlbD9033NzNx2Ee
NOjYPq8bGdB8LRJ+LzmgiZ0LZ9I6yfQr0Ke7sXMkd7zRSukudNUx2tK5M8ae
tMm3Fjq/PXZOZTfFgRvPod8hY+faCc2+3rb30ENtsHOwSIRpbKgXetRp7NxM
tomL/N4PvbQcO2ffucbgnDQet3QuuwbMjS4fhyiOnePNb9/j7lsyqrF07rPU
ROPi3L4d6xO4LePw8/LF+ood0Y9xefBbhfUhY8fbcHlbE4D1LVkle3F5Lp53
993yXBRQQ/H7eWbAy57JOlFwkPkDbj+fXClzlTdPFIAiNdx+PrFGfrVwkCgo
jDXD7ec5FqIP6Hqi4Hp7Lm4/33db/LnrlAjQ9eLH7ecHisM+SBeIAGNvDdx+
vnl2m9/wHhFQsfE2bj/XybBwcFQRAfVv/XD7eXWoz531P4WB4M4ruP2cLbj3
1z9dwoDfmCNy+X6+u/J3hdRLYXC55WTa9UsXq/57PTt2PfLf8Xmx8Rn+N55a
LB6G/42/DIuf4X/nC7D5MvxvfnSw/DD8bz7TsXwy/G/+C7D8M/xvvRCsXgz/
T30Z/p/1wPD/AbG/XnM=
        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllgs0VGsbxwcxQhr3u5lxv6QcOcXn8L4otySNmiJ3OnRVoUG51Ol+41Ah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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPacking\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxl2Xk4lN/bAPBBym7GjD1aZEskWUvOkQiVyp4tVLJFy7eUVMqaVEKisiRL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        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllns4VPsax9cQGTMxGDMqaeuCSE22Sxdn3p+UEtt1IpFQMXSliy52VMhB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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPackingCenter\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic], 
     Graphics3DBox[
      TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxtWXk4lO0XnrFmyRYNhsnOWGeQFvQelEpfIV+WooQ2bUL7QpRUyhKFpFQi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        "], {
         {RGBColor[0.5, 0., 0.], 
          Line3DBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
            126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
            1}, {2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {
            3, 4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 
            11}, {11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
            171, 172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 
            182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {
            14, 15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 
            204, 205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {
            19, 12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 
            218, 219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {
            24, 25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 
            40}, {31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
            248, 32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
            259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
            33}, {34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
            281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
            294, 35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 
            10}, {42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 
            304, 305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 
            313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
            326, 66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 
            333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {
            50, 51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 
            47}, {57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 
            348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 
            361, 362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 
            372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 
            385, 386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {
            66, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 
            401, 402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {
            71, 72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 
            405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 
            418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {
            79, 75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 
            51}, {86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92,
             56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[Point3DBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[Point3DBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxtVnk4lWkfthMSonMOE8e+HMdZGG30/EjrVMglFCXLoI0sqU8hRKOFmlMd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         "]]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      ImageSize->150,
      PlotLabel->FormBox["\"NestedGrid\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Automatic]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 259},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1099848233]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44888674],

Cell[TextData[{
 "Use different ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " around the graph: "
}], "ExampleText",
 CellID->1808033363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"11", "\[Rule]", "22"}], ",", 
       RowBox[{"22", "\[Rule]", "33"}], ",", 
       RowBox[{"33", "\[Rule]", "44"}], ",", 
       RowBox[{"1", "\[Rule]", "11"}], ",", 
       RowBox[{"2", "\[Rule]", "22"}], ",", 
       RowBox[{"3", "\[Rule]", "33"}], ",", 
       RowBox[{"4", "\[Rule]", "44"}]}], "}"}], ",", 
     RowBox[{"PlotRangePadding", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1", ",", 
       RowBox[{"Scaled", "[", "0.1", "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500288768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{3.2436195286341127`, 0.8602248290586441, 
      1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
      1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
      7.54515276838023*^-12}, {0., 0.8600311586989597, 
      1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`, 
      0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
      1.0414686786380125`, 0.00017575829722887848`, 
      1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
      1.7145598887634764`*^-11}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5,
          6}, {6, 7}, {7, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "22"],
         Annotation[#, 22, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "33"],
         Annotation[#, 33, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "44"],
         Annotation[#, 44, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{3.2436195286341127`, 0.8602248290586441, 
       1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
       1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
       7.54515276838023*^-12}, {0., 0.8600311586989597, 
       1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`,
        0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
       1.0414686786380125`, 0.00017575829722887848`, 
       1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
       1.7145598887634764`*^-11}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->0], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{3.2436195286341127`, 0.8602248290586441, 
      1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
      1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
      7.54515276838023*^-12}, {0., 0.8600311586989597, 
      1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`, 
      0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
      1.0414686786380125`, 0.00017575829722887848`, 
      1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
      1.7145598887634764`*^-11}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5,
          6}, {6, 7}, {7, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "22"],
         Annotation[#, 22, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "33"],
         Annotation[#, 33, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "44"],
         Annotation[#, 44, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{3.2436195286341127`, 0.8602248290586441, 
       1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
       1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
       7.54515276838023*^-12}, {0., 0.8600311586989597, 
       1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`,
        0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
       1.0414686786380125`, 0.00017575829722887848`, 
       1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
       1.7145598887634764`*^-11}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->0.1], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{3.2436195286341127`, 0.8602248290586441, 
      1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
      1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
      7.54515276838023*^-12}, {0., 0.8600311586989597, 
      1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`, 
      0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
      1.0414686786380125`, 0.00017575829722887848`, 
      1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
      1.7145598887634764`*^-11}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 5}, {2, 3}, {2, 6}, {3, 4}, {3, 7}, {4, 8}, {5,
          6}, {6, 7}, {7, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "22"],
         Annotation[#, 22, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "33"],
         Annotation[#, 33, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "44"],
         Annotation[#, 44, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{3.2436195286341127`, 0.8602248290586441, 
       1.886857576865091*^-11}, {2.201092053929193, 0.8826380484904247, 
       1.202008770140444*^-11}, {1.0408988629052907`, 0.8825001030571051, 
       7.54515276838023*^-12}, {0., 0.8600311586989597, 
       1.3143504740437112`*^-12}, {3.2448764377547614`, 0.022263110972893962`,
        0.}, {2.202936186730363, 0., 8.424511845012996*^-12}, {
       1.0414686786380125`, 0.00017575829722887848`, 
       1.4020751832800595`*^-11}, {0.00034448167796719, 0.02137253664434796, 
       1.7145598887634764`*^-11}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->584759501]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->179618439],

Cell["Specify an overall style for the graph: ", "ExampleText",
 CellID->1676190373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, {
       {RGBColor[1, 0, 0], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 4}, {3, 4}}]}, 
       {RGBColor[1, 0, 0], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, {
       {RGBColor[0.5, 0., 0.], PointSize[Medium], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 4}, {3, 4}}]}, 
       {RGBColor[0, 0, 0.7], PointSize[Medium], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, {
       {RGBColor[0.5, 0., 0.], Dashing[{Small, Small}], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 4}, {3, 4}}]}, 
       {RGBColor[0, 0, 0.7], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, {
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 4}, {3, 4}}]}, 
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{452, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1597594693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297939305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 ", which has higher priority: "
}], "ExampleText",
 CellID->580503372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "l"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317015018],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 4}, {3, 4}}]}], 
     {RGBColor[1, 0, 0], PointSize[Large], 
      {RGBColor[0, 1, 0], 
       Point3DBox[{0.0336565100218259, 0.261321765643619, 0.}]}, 
      {RGBColor[0, 1, 0], 
       Point3DBox[{0., 0.24474517434175455`, 0.9989742720647393}]}, 
      {RGBColor[0, 1, 0], 
       Point3DBox[{0.8449440803872921, 0., 0.523159358644546}]}, 
      {RGBColor[0, 1, 0], 
       Point3DBox[{0.530937494896891, 0.9494940038888471, 
        0.5283357973836946}]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1479170635,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414909817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 ", which has higher priority: "
}], "ExampleText",
 CellID->88626299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "vl", ",", "el"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->238367270],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
        0.24474517434175455`, 0.9989742720647393}}]}, 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
        0.530937494896891, 0.9494940038888471, 0.5283357973836946}}]}, 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
        0.8449440803872921, 0., 0.523159358644546}}]}, 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
        0.8449440803872921, 0., 0.523159358644546}}]}, 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
        0.530937494896891, 0.9494940038888471, 0.5283357973836946}}]}, 
      {RGBColor[0, 1, 0], 
       Line3DBox[{{0.8449440803872921, 0., 0.523159358644546}, {
        0.530937494896891, 0.9494940038888471, 0.5283357973836946}}]}}, 
     GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
      0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
      0.5283357973836946}}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
       TagBox[
        TooltipBox[Point3DBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[Point3DBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253634311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SelfLoopStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91275691],

Cell["Draw self-loops with a specified scaled diameter:", "ExampleText",
 CellID->1053407179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "2"}], ",", 
       RowBox[{"4", "\[Rule]", "4"}], ",", 
       RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
     RowBox[{"SelfLoopStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375686493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxd0ntMk1cUAPCiobTokM0giJti2EMiDMEHDnQnKhN5OKcwzRSGrQwiUnGC
gCmyAhFEagsTKCXtkNdQsQwUKkThxiAikmJRYyhb6NevMmthxaabVTpE/vpO
4k3OP7/cnHvOuWc1P33fTwtYLFbwfCycD626dakgrA6iXKL/yevWAuu9k3L0
cezD2IdgcCl4Vm2fhqwH7LX3uZPMvdR1c+1dPRRIri2vOzFLgVfaMGzjW+Dq
Rv5pHxMFpVLXJYmsQHBTRDSGh2GeapFnmHwsCXq9R8W5P2sYz/D/la28EQ0j
k4InusYhxrtFOUNFCRlEvrP+qz0zg4wLH2WNv/xYTOyXLfylFfcZ54h/FAlc
a4jXpDiWlgwwvrKiXlJpbiDsrB38P+buMZ5w6aN9vX4tJNjf4Wy3ogtTW/Ks
y9oJb7H5zaNkzHMr6FtVzvoO4mnLaTTG4bvNc5mdZVfV5LP0qTL3K1hn1MRs
fU1kF1Gr80vdd2FfxT19TjHTXeQFN3FK7o5zUFU1Zx2UdJEr3qE+buPDjH++
ztIs/vIm6dHlaDq+0TJuv84u957qIKqgPusnDvSItmz31P/aiVYSwesUjTAO
bdfjrrmpSD4xTfUNoVMhHk9rtE1ELnUcDH+K7iM+Jms9ryS20dfsxFr0OWIK
X+woI56yswHCtejcuF0Km1ZIJJEN+c8KsR5Xj6RDZk4QCRg+IPNKw33YpBTc
XWGnYEf/B9uTj+D+zIxfTuKUUPCLZaJ2thidazwgqPOjIF668/abQfS/jz2/
veKOHnJPNv++5NNpxjulWyVxKXoYW+lS6ixF32J2jPjs1kPrv1Di6/SScV9d
SXlNph6yQysHokLRD2m+2yAb08PJbqOJfxzd+dbu7ZlhFGj2Xwj5Wo5unvH7
vuA3Ci615qnSbqKfsa0ZKXQzgOLD9vMF99Avvmrrzy0wgCw7cFFUP7qRkzC8
ymqAU+Oj8NcNdK/Au8su7KWBLmpZVHsRfSAkt4KjoEHmSR9fk4KeEi/UVT+g
Ac7+IOAGo2cYKu7k62g417C5iWvF+Tj+/N+3fIAGi4Ikp+ehF0a85YVU0VBq
Ws0/5YEefbh27GgkDTGDRUHFvfgvxiZb3d7nBtDtd9IrRejK2PVOmmwD8B7H
q9sOoycGfDGhWTg/nyP+MXt46O8AivB4GA==
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {2, 4}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
          39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxd0mtM01cUAPBWBwWGb0BnFKpEJoEoFB2sggfiA3CAQVDEriqsKKIgAwQU
g6hEjFQUxPFUChOIQAmPYOwI3DRg21ApRYgPUsq/9e9k5VEeQ+IDqp/uTbzJ
+fLLyT33nHs2RZ8/FLOEwWBwvsXSb6F+0rgmflclHGD9NpEpUQPju3P6zEBY
X1gf6FjX6OJ5I6T2mLsoLMdwXpybqflpBwV5DT9VJi5QsO6cCvyiJ6FuZ/RF
9igFuXesVpxgALSp2v+XbCb3FGet3VUylAK2zzXPnO8osSe7Fpg/aOWBd4LF
YXpOjl2Sla68wb+OlI5/OvSJurFnvEjVTm0oRzmjlkkRg1LsFsLjWfFWdSj/
jbDGcA9hty+syrtvaEUBZqd19hEd2Pmi1Yc6ndvRl+F9iT5s4hlx9ZnTdlL0
5DjTVzzbib3dPUSc7tGNZJft5+YPk7q1ppS2u3UyRKeYqUIXu7AfeLdQVRqo
QOY/uHWFepO+cjq6mEFGBTpbZ8gW9PZgF/9Vm3osT4EMStF4UKwKu5PbZK1w
mxzJF1nTV3Vq7PMt5vnrx7tRTWP5r+FBL7D7N6WtjJuTovHY6nXXIwawQ1NL
eMPyDhTS8367aII45Wn7slTdhq7ELbOuXDKInS08W9R4S4w4CyzBy0KSb0Kj
e60/i9Cli5ual4tJXcvwgPJZdS46o/09Usfvx25lK+AZLPzQLEczFJVN9mHk
tvS9bIqCBPvgvbkCsj8xq7y2imwo+DdxwSQRE7fwcE1+VK+FipZOrxZ3I/am
zDLPIznDQKVnLdO+I35Q5j8kH9CAatRhjOZPYedndEedrNDAwdbiJKd+4i6R
FBU2qQH97j3GlD3T2Ev9EpyC/xmGV96Ue3U98fmCpXLjjBby0jz6eMwZ7PsD
uZaFQMHOn+3an/oQP8f1YhY56MB14tIFmke8xDfAcJOlB0dJWmpyJHGvGNFn
Fa2HkRs9I0W/EP+7OUH4uPotSF6dT9v4gbyH2aXNEXFpcPyo8XF7QNzXeniV
tIiGpEEld4ZD/KjdSn1BGw2X40PN/kNkDrE/UjXN+TToT72WhQQTT9frNy9u
o8EkuJD9WEHmzLLZYvPH/bdwxQkce9cT96zoreL066HMb0fmp4fkHxs+BUU5
z+ignjvmyj5BfHvjDmcXKx2webeO8k8S/woxvXTV
      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {2, 4}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
          39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic], ",", 
   Graphics3DBox[
    TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxd0ntM01cUB/CCwfoKShhoB/KaxACZBdNuloLHtuocVWchVlx9drMIEeyW
SMLmc0IQcQwcYjHg/CluGaFVslJ0Si8zWBACrUgpxYLF2tHC8MerKzKf/+ze
xJucfz65OTn3e0+k/HDqAV8Gg7H6Xc15VyadJjCbT0EKUzx2/LYJGO+djMxH
acY0Iwwxf3im8tKQ2z43rm3+KL6XFf+m/laTHUrqWJTylR2WHeoCgfw51HLl
eREuO9ypVGTy96VBrWLZ3yxrF+6j3zdQBAFngWUfUSa47mNvk4WsEG77Bjwj
N9TM7tvYh69Ij7s4KpQ/liviS65iPydaUBx8vh6lGKL8HNKf0f9esJSvzN/Y
jFRrOLqNgRrs0TzxZKKzDTFuzLReobTYE2vEU8GzJrSurEPeE9uAnbVBOqje
ZUaHjbmPky7dxB6jp/qk66xoZ0Jha/on1dh/gu6nnO029Dw+P7Zu/CKes2pP
k9hn1yByWo70xK7WYXfVcXzD456g8eIft7bMacGeflTywUT9INI86ZHMZ3Zi
Z991P2TP2tDT7AaZW9uNXbt3EzdyZT8qi44J8EIv6VN1obzl214k8OrX/vO4
D/tKDa2Ni+lGupFnM5y0fuyWgkvFf63vQOz/hOGNhcTLP70Wps69h+hM7vdJ
R6zYX9NRUiOvAdVEePgPEizYCzhqgUpOoRdVRXbL6CPsmz5Mnlwh3o5E+zOv
J3eSverb2yRpG7ADHbNQPJtB9ucLSYezK2cAQmdEEXQYjX00j0p6oLUCtyTQ
ks0Zx+7f2PibX38vMA1+VE3QBPaQLIU+kmWGqelp2cLISez6VWEB4RU9wKWv
rmILprALrY6uEzIzRG/eopjaM409/bLhZc5OC8xrNS869JUHO3LzS/wy+uGh
NbpCy/sXu+5gb8r5DYMwWWpzVJmIJy5WlJlSh8B2oo+7INSL/fcw/3R1hQPu
H9t2iw4ivua7rNM25ITQk7+gdj3pI+TljL2mhiGp/e6fquXE1V/PlR8MdoOh
urP2MyBztof43uG9ccOie1HX6rjkXcyGUyLD5yPwa7OyOiiY5KCpLGIHjrvh
o3ihT7mX5Lnjj9IDqS9c8PFYoydqguSfzNY1b80bBv9wzlHjUuLcYtl1c4kT
hnw6ZUtmyf9a6cpTa/c74IyyojTnS+JU/G6PcPkQqAU1xwp3E38Liy1xlg==

      "], {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 4}, {1, 3}, {2, 3}, {2, 5, 6, 7, 8, 9, 10, 11, 
          12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
          2}, {2, 4}, {3, 4}, {4, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
          39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 4}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "4"],
         Annotation[#, 4, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
       0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0.,
        0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
       0.5283357973836946}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Automatic]}], "}"}]], "Output",
 ImageSize->{491, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->441519075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexCoordinateRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->469196428],

Cell["Explicitly specify all vertex coordinates: ", "ExampleText",
 CellID->49039736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], ",", 
      RowBox[{"6", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"7", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"8", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->895811688],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 1., 2.}, {-1., 0., 2.}, {1., 0., 2.}, {0.,
     2., 0.}, {0., -1., 2.}, {-2., 0., 0.}, {0., -2., 0.}, {2., 0., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 8}, {4, 6}, {4, 
       8}, {5, 3}, {5, 7}, {6, 7}, {7, 8}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1., 2.}, {-1., 0., 2.}, {1., 0., 2.}, {0., 
     2., 0.}, {0., -1., 2.}, {-2., 0., 0.}, {0., -2., 0.}, {2., 0., 0.}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->851064969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379319889],

Cell[TextData[{
 "Explicitly specify only ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", " ", "y"}], TraditionalForm]], "InlineMath"],
 " coordinates, and automatically compute the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " coordinate: "
}], "ExampleText",
 CellID->762072884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"6", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"7", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"8", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "Automatic"}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1218538592],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0., 1., 0.03913553576705829}, {-1., 0., 
    0.03913553575154348}, {1., 0., 0.0391355357636122}, {0., 
    2., -0.39037169488531276`}, {0., -1., 0.039135535751620196`}, {-2., 
    0., -0.3903716949137702}, {0., -2., -0.39037169491463297`}, {2., 
    0., -0.3903716948909663}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 8}, {4, 6}, {4, 
       8}, {5, 3}, {5, 7}, {6, 7}, {7, 8}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1., 0.03913553576705829}, {-1., 0., 
     0.03913553575154348}, {1., 0., 0.0391355357636122}, {0., 
     2., -0.39037169488531276`}, {0., -1., 0.039135535751620196`}, {-2., 
     0., -0.3903716949137702}, {0., -2., -0.39037169491463297`}, {2., 
     0., -0.3903716948909663}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486799337]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24443973],

Cell["Show vertex labels:", "ExampleText",
 CellID->1001631834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1042589918],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {3, 2}, {4, 2}, {4, 3}}]}, {
      Text3DBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], Text3DBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], Text3DBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], Text3DBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449399609,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291462997],

Cell["Show vertex labels as tooltips only:", "ExampleText",
 CellID->73764302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655204029],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {3, 2}, {4, 2}, {4, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1709990844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8973542],

Cell["Show vertex labels both explicitly and as tooltips:", "ExampleText",
 CellID->1197125759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406910921],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
    0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
    0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
    0.5283357973836946}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {3, 2}, {4, 2}, {4, 3}}]}, {
      TagBox[
       TooltipBox[Text3DBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Text3DBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Text3DBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Text3DBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392173674]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82661052],

Cell["Show no vertices:", "ExampleText",
 CellID->1148726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "1000"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "1000"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1976145425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56319487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29788626],

Cell["Draw edges as cylinders and vertices as spheres: ", "ExampleText",
 CellID->29247091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cylinder", "[", 
       RowBox[{"#1", ",", ".05"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#1", ",", ".1"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669401884],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, {0., 0.6383721562676106, 
      0.0005166374503760146}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.8529587157814721, 0., 0.000058993543025062656`}}, 0.05], 
     CylinderBox[{{0., 0.6383721562676106, 0.0005166374503760146}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      1.4923842795065547`, 0.8518947103601523, 0.}}, 0.05], 
     CylinderBox[{{0.8529587157814721, 0., 0.000058993543025062656`}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.6390758705051751, 1.4898647777696166`, 0.0005877776666556173}}, 0.05],
      CylinderBox[{{1.4923842795065547`, 0.8518947103601523, 0.}, {
      0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}, 0.05], 
     CylinderBox[{{0.7471167161829144, 0.7442574629173819, 
      0.5463274426713254}, {0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}}, 0.05]}, {
     SphereBox[{0.6390758705051751, 1.4898647777696166`, 
      0.0005877776666556173}, 0.1], 
     SphereBox[{0., 0.6383721562676106, 0.0005166374503760146}, 0.1], 
     SphereBox[{0.8529587157814721, 0., 0.000058993543025062656`}, 0.1], 
     SphereBox[{1.4923842795065547`, 0.8518947103601523, 0.}, 0.1], 
     SphereBox[{0.7471167161829144, 0.7442574629173819, 0.5463274426713254}, 
      0.1]}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.6390758705051751, 1.4898647777696166`, 
     0.0005877776666556173}, {0., 0.6383721562676106, 
     0.0005166374503760146}, {0.8529587157814721, 0., 
     0.000058993543025062656`}, {1.4923842795065547`, 0.8518947103601523, 
     0.}, {0.7471167161829144, 0.7442574629173819, 0.5463274426713254}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807598518,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Make a 3D graph layout with spheres and cylinders:", "ExampleText",
 CellID->472397991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "75"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "75"}], "}"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"#1", ",", "0.1"}], "]"}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Sphere", "[", 
        RowBox[{"#", ",", "0.3"}], "]"}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206162687],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{6.379583379140258, -2.2329801799719426`, 
      2.2989413329388446`}, {5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}}, 0.1], 
     CylinderBox[{{5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}, {4.610312212715493, -3.1984417257141815`, 
      1.2879164266385839`}}, 0.1], 
     CylinderBox[{{0.9396808496227191, -11.988308095801976`, 
      0.693825176165868}, {1.5901183560157497`, -11.489862252699487`, 
      0.6269793743415427}}, 0.1], 
     CylinderBox[{{1.5901183560157497`, -11.489862252699487`, 
      0.6269793743415427}, {2.3526165762312408`, -10.649935868363741`, 
      1.0424325854670937`}}, 0.1], 
     CylinderBox[{{4.610312212715493, -3.1984417257141815`, 
      1.2879164266385839`}, {3.2351716688353624`, -2.816545719406334, 
      1.0367030435799127`}}, 0.1], 
     CylinderBox[{{9.275047449697803, -5.363378333560891, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{2.3526165762312408`, -10.649935868363741`, 
      1.0424325854670937`}, {2.300592299206386, -9.592674763129995, 
      1.293951203466927}}, 0.1], 
     CylinderBox[{{2.300592299206386, -9.592674763129995, 
      1.293951203466927}, {3.356954324710544, -9.543158211237333, 
      1.0371115062667533`}}, 0.1], 
     CylinderBox[{{9.617067592851964, -3.1683003683167676`, 0.}, {
      10.082690046474436`, -2.3618186217207455`, 0.}}, 0.1], 
     CylinderBox[{{10.082690046474436`, -2.3618186217207455`, 0.}, {
      9.27620829985751, -1.8961961681344803`, 0.}}, 0.1], 
     CylinderBox[{{5.374301559059179, -6.244716646151558, 
      0.04717288590736812}, {4.932696147713032, -5.884706587144593, 
      0.628441291975753}}, 0.1], 
     CylinderBox[{{4.932696147713032, -5.884706587144593, 
      0.628441291975753}, {4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}}, 0.1], 
     CylinderBox[{{8.751042189224883, -5.803070954300765, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{4.4533362787703545`, -4.995759874293232, 
      1.4640739557529558`}, {4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}}, 0.1], 
     CylinderBox[{{4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}, {4.610312212715493, -3.1984417257141815`, 
      1.2879164266385839`}}, 0.1], 
     CylinderBox[{{1.1559479769834045`, -8.321129633247484, 
      2.2799467788303756`}, {1.4604424994983742`, -8.83046935216075, 
      1.7085451093780628`}}, 0.1], 
     CylinderBox[{{1.4604424994983742`, -8.83046935216075, 
      1.7085451093780628`}, {2.300592299206386, -9.592674763129995, 
      1.293951203466927}}, 0.1], 
     CylinderBox[{{1.0815404796238564`, -5.568957470085157, 
      1.7325073360119183`}, {1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}}, 0.1], 
     CylinderBox[{{1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}, {2.8394925011707057`, -4.177825171714405, 
      1.2962719915692014`}}, 0.1], 
     CylinderBox[{{4.356089351115765, -4.823584162051838, 
      0.47447435899362367`}, {4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}}, 0.1], 
     CylinderBox[{{9.029282340748518, -9.49814891948426, 0.}, {
      9.61706759299014, -10.307165913896153`, 0.}}, 0.1], 
     CylinderBox[{{3.2351716688353624`, -2.816545719406334, 
      1.0367030435799127`}, {2.8394925011707057`, -4.177825171714405, 
      1.2962719915692014`}}, 0.1], 
     CylinderBox[{{5.104509267973733, -6.643910472226944, 
      0.8590162643773225}, {4.932696147713032, -5.884706587144593, 
      0.628441291975753}}, 0.1], 
     CylinderBox[{{12.511645210249199`, -0.7488551283614633, 0.}, {
      13.377670613996225`, -1.248855128426266, 0.}}, 0.1], 
     CylinderBox[{{13.377670613996225`, -1.248855128426266, 0.}, {
      13.377670613861534`, -2.248855128426266, 0.}}, 0.1], 
     CylinderBox[{{2.8394925011707057`, -4.177825171714405, 
      1.2962719915692014`}, {4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}}, 0.1], 
     CylinderBox[{{8.632259839943242, -6.476719131939155, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{3.356954324710544, -9.543158211237333, 
      1.0371115062667533`}, {3.4093894229640433`, -10.598005774687236`, 
      1.2985249534311873`}}, 0.1], 
     CylinderBox[{{3.4093894229640433`, -10.598005774687236`, 
      1.2985249534311873`}, {2.3526165762312408`, -10.649935868363741`, 
      1.0424325854670937`}}, 0.1], 
     CylinderBox[{{2.3036100862404245`, -0.7488551283614635, 
      0.8111482354322899}, {2.4878965322445037`, -1.520714804828307, 
      0.6191341229689898}}, 0.1], 
     CylinderBox[{{2.4878965322445037`, -1.520714804828307, 
      0.6191341229689898}, {3.2351716688353624`, -2.816545719406334, 
      1.0367030435799127`}}, 0.1], 
     CylinderBox[{{6.293522544424394, -1.7632105169150227`, 
      1.8742449160156505`}, {5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}}, 0.1], 
     CylinderBox[{{9.151445139519156, -0.7488551283614631, 0.}, {
      9.27620829985751, -1.8961961681344803`, 0.}}, 0.1], 
     CylinderBox[{{4.896149282492775, -11.858757085507774`, 
      1.6290090401158706`}, {4.250017546177062, -11.356500839544424`, 
      1.7198336128180665`}}, 0.1], 
     CylinderBox[{{4.250017546177062, -11.356500839544424`, 
      1.7198336128180665`}, {3.4093894229640433`, -10.598005774687236`, 
      1.2985249534311873`}}, 0.1], 
     CylinderBox[{{2.0712912302255524`, -1.1795861819863305`, 0.}, {
      2.4878965322445037`, -1.520714804828307, 0.6191341229689898}}, 0.1], 
     CylinderBox[{{4.835044621681809, -3.080634318198545, 
      1.882483772185398}, {4.610312212715493, -3.1984417257141815`, 
      1.2879164266385839`}}, 0.1], 
     CylinderBox[{{8.666011076664464, -10.616182908177162`, 0.}, {
      9.61706759299014, -10.307165913896153`, 0.}}, 0.1], 
     CylinderBox[{{10.54831249987966, -3.1683003684421966`, 0.}, {
      10.082690046474436`, -2.3618186217207455`, 0.}}, 0.1], 
     CylinderBox[{{4.446276310721011, -8.265729340781432, 0.}, {
      4.1196740671290435`, -8.707175136091369, 0.6148082907478731}}, 0.1], 
     CylinderBox[{{4.1196740671290435`, -8.707175136091369, 
      0.6148082907478731}, {3.356954324710544, -9.543158211237333, 
      1.0371115062667533`}}, 0.1], 
     CylinderBox[{{8.974279983197476, -7.069115397410794, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{0.7488551283614633, -4.767525339263965, 
      1.9458370387856416`}, {1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}}, 0.1], 
     CylinderBox[{{1.1463284849362416`, -5.268756759562174, 
      2.302600874640964}, {1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}}, 0.1], 
     CylinderBox[{{9.617067592837218, -7.303070954365567, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{3.1152938006672573`, -2.5730926701326826`, 
      0.4592888402714588}, {3.2351716688353624`, -2.816545719406334, 
      1.0367030435799127`}}, 0.1], 
     CylinderBox[{{4.712751766469497, -8.14162072894987, 
      0.7057494640549767}, {4.1196740671290435`, -8.707175136091369, 
      0.6148082907478731}}, 0.1], 
     CylinderBox[{{11.013934953526272`, -2.361818621887984, 0.}, {
      10.082690046474436`, -2.3618186217207455`, 0.}}, 0.1], 
     CylinderBox[{{2.6350753427881983`, -4.309742604134296, 
      1.8967569142342118`}, {2.8394925011707057`, -4.177825171714405, 
      1.2962719915692014`}}, 0.1], 
     CylinderBox[{{9.61706759285545, -11.307165913896153`, 0.}, {
      9.61706759299014, -10.307165913896153`, 0.}}, 0.1], 
     CylinderBox[{{1.7934529651921056`, -1.0940548612169252`, 
      0.7190862680470995}, {2.4878965322445037`, -1.520714804828307, 
      0.6191341229689898}}, 0.1], 
     CylinderBox[{{4.618331756619821, -11.767581764789085`, 
      2.330926594268444}, {4.250017546177062, -11.356500839544424`, 
      1.7198336128180665`}}, 0.1], 
     CylinderBox[{{10.259855202539985`, -7.069115397583948, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{6.7224899756478385`, -2.50019726925329, 
      1.82079524971937}, {5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}}, 0.1], 
     CylinderBox[{{2.502003248957592, -0.8057480946805278, 
      0.22199319828832031`}, {2.4878965322445037`, -1.520714804828307, 
      0.6191341229689898}}, 0.1], 
     CylinderBox[{{10.601875345953797`, -6.476719132204443, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{2.408306046642268, -4.448508402541549, 
      0.9006460298118744}, {2.8394925011707057`, -4.177825171714405, 
      1.2962719915692014`}}, 0.1], 
     CylinderBox[{{14.243696017877939`, -0.7488551285947529, 0.}, {
      13.377670613996225`, -1.248855128426266, 0.}}, 0.1], 
     CylinderBox[{{4.891248080120752, -6.599960491268763, 
      0.2398023673504177}, {4.932696147713032, -5.884706587144593, 
      0.628441291975753}}, 0.1], 
     CylinderBox[{{3.013101160074931, -2.387957737714401, 
      1.4850224383671302`}, {3.2351716688353624`, -2.816545719406334, 
      1.0367030435799127`}}, 0.1], 
     CylinderBox[{{10.568124109232574`, -10.616182908433357`, 0.}, {
      9.61706759299014, -10.307165913896153`, 0.}}, 0.1], 
     CylinderBox[{{0.7931225545631968, -5.139078439501725, 
      1.4148144800667617`}, {1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}}, 0.1], 
     CylinderBox[{{0.7488551283614633, -8.41973621348822, 
      1.6521465227932766`}, {1.4604424994983742`, -8.83046935216075, 
      1.7085451093780628`}}, 0.1], 
     CylinderBox[{{10.483092996853623`, -5.8030709545340535`, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{5.613131639097827, -6.331135378215775, 
      0.6639565805800605}, {4.932696147713032, -5.884706587144593, 
      0.628441291975753}}, 0.1], 
     CylinderBox[{{10.548312500169327`, -1.5553368751665333`, 0.}, {
      10.082690046474436`, -2.3618186217207455`, 0.}}, 0.1], 
     CylinderBox[{{9.959087736499146, -5.363378333653024, 0.}, {
      9.617067592971908, -6.303070954365567, 0.}}, 0.1], 
     CylinderBox[{{5.063931167400363, -2.967761979090076, 
      0.888342184726086}, {4.610312212715493, -3.1984417257141815`, 
      1.2879164266385839`}}, 0.1], 
     CylinderBox[{{1.3200927261367092`, -12.00453362229192, 
      0.0435967225449605}, {1.5901183560157497`, -11.489862252699487`, 
      0.6269793743415427}}, 0.1], 
     CylinderBox[{{6.566331879097178, -2.0674938447795377`, 
      1.3721315528150029`}, {5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}}, 0.1], 
     CylinderBox[{{8.220200232370765, -2.361818621553507, 0.}, {
      9.27620829985751, -1.8961961681344803`, 0.}}, 0.1], 
     CylinderBox[{{10.204852845449693`, -9.498148919642597, 0.}, {
      9.61706759299014, -10.307165913896153`, 0.}}, 0.1]}, {
     SphereBox[{9.27620829985751, -1.8961961681344803`, 0.}, 0.3], 
     SphereBox[{6.379583379140258, -2.2329801799719426`, 2.2989413329388446`},
       0.3], SphereBox[{5.922286788318849, -2.4600553079229073`, 
      1.672623954578731}, 0.3], 
     SphereBox[{0.9396808496227191, -11.988308095801976`, 0.693825176165868}, 
      0.3], SphereBox[{1.5901183560157497`, -11.489862252699487`, 
      0.6269793743415427}, 0.3], 
     SphereBox[{4.610312212715493, -3.1984417257141815`, 1.2879164266385839`},
       0.3], SphereBox[{9.275047449697803, -5.363378333560891, 0.}, 0.3], 
     SphereBox[{9.617067592971908, -6.303070954365567, 0.}, 0.3], 
     SphereBox[{2.3526165762312408`, -10.649935868363741`, 
      1.0424325854670937`}, 0.3], 
     SphereBox[{2.300592299206386, -9.592674763129995, 1.293951203466927}, 
      0.3], SphereBox[{9.617067592851964, -3.1683003683167676`, 0.}, 0.3], 
     SphereBox[{10.082690046474436`, -2.3618186217207455`, 0.}, 0.3], 
     SphereBox[{5.374301559059179, -6.244716646151558, 0.04717288590736812}, 
      0.3], SphereBox[{4.932696147713032, -5.884706587144593, 
      0.628441291975753}, 0.3], 
     SphereBox[{8.751042189224883, -5.803070954300765, 0.}, 0.3], 
     SphereBox[{4.4533362787703545`, -4.995759874293232, 1.4640739557529558`},
       0.3], SphereBox[{4.209682010620032, -4.56639928499329, 
      1.0409427824048298`}, 0.3], 
     SphereBox[{1.1559479769834045`, -8.321129633247484, 2.2799467788303756`},
       0.3], SphereBox[{1.4604424994983742`, -8.83046935216075, 
      1.7085451093780628`}, 0.3], 
     SphereBox[{1.0815404796238564`, -5.568957470085157, 1.7325073360119183`},
       0.3], SphereBox[{1.5157295832837965`, -4.880210956692507, 
      1.6842326019820142`}, 0.3], 
     SphereBox[{4.356089351115765, -4.823584162051838, 0.47447435899362367`}, 
      0.3], SphereBox[{9.029282340748518, -9.49814891948426, 0.}, 0.3], 
     SphereBox[{9.61706759299014, -10.307165913896153`, 0.}, 0.3], 
     SphereBox[{3.2351716688353624`, -2.816545719406334, 1.0367030435799127`},
       0.3], SphereBox[{5.104509267973733, -6.643910472226944, 
      0.8590162643773225}, 0.3], 
     SphereBox[{12.511645210249199`, -0.7488551283614633, 0.}, 0.3], 
     SphereBox[{13.377670613996225`, -1.248855128426266, 0.}, 0.3], 
     SphereBox[{2.8394925011707057`, -4.177825171714405, 1.2962719915692014`},
       0.3], SphereBox[{8.632259839943242, -6.476719131939155, 0.}, 0.3], 
     SphereBox[{3.356954324710544, -9.543158211237333, 1.0371115062667533`}, 
      0.3], SphereBox[{3.4093894229640433`, -10.598005774687236`, 
      1.2985249534311873`}, 0.3], 
     SphereBox[{2.3036100862404245`, -0.7488551283614635, 0.8111482354322899},
       0.3], SphereBox[{2.4878965322445037`, -1.520714804828307, 
      0.6191341229689898}, 0.3], 
     SphereBox[{6.293522544424394, -1.7632105169150227`, 1.8742449160156505`},
       0.3], SphereBox[{13.377670613861534`, -2.248855128426266, 0.}, 0.3], 
     SphereBox[{9.151445139519156, -0.7488551283614631, 0.}, 0.3], 
     SphereBox[{4.896149282492775, -11.858757085507774`, 1.6290090401158706`},
       0.3], SphereBox[{4.250017546177062, -11.356500839544424`, 
      1.7198336128180665`}, 0.3], 
     SphereBox[{2.0712912302255524`, -1.1795861819863305`, 0.}, 0.3], 
     SphereBox[{4.835044621681809, -3.080634318198545, 1.882483772185398}, 
      0.3], SphereBox[{8.666011076664464, -10.616182908177162`, 0.}, 0.3], 
     SphereBox[{10.54831249987966, -3.1683003684421966`, 0.}, 0.3], 
     SphereBox[{4.446276310721011, -8.265729340781432, 0.}, 0.3], 
     SphereBox[{4.1196740671290435`, -8.707175136091369, 0.6148082907478731}, 
      0.3], SphereBox[{8.974279983197476, -7.069115397410794, 0.}, 0.3], 
     SphereBox[{0.7488551283614633, -4.767525339263965, 1.9458370387856416`}, 
      0.3], 
     SphereBox[{1.1463284849362416`, -5.268756759562174, 2.302600874640964}, 
      0.3], SphereBox[{9.617067592837218, -7.303070954365567, 0.}, 0.3], 
     SphereBox[{3.1152938006672573`, -2.5730926701326826`, 
      0.4592888402714588}, 0.3], 
     SphereBox[{4.712751766469497, -8.14162072894987, 0.7057494640549767}, 
      0.3], SphereBox[{11.013934953526272`, -2.361818621887984, 0.}, 0.3], 
     SphereBox[{2.6350753427881983`, -4.309742604134296, 1.8967569142342118`},
       0.3], SphereBox[{9.61706759285545, -11.307165913896153`, 0.}, 0.3], 
     SphereBox[{1.7934529651921056`, -1.0940548612169252`, 
      0.7190862680470995}, 0.3], 
     SphereBox[{4.618331756619821, -11.767581764789085`, 2.330926594268444}, 
      0.3], SphereBox[{10.259855202539985`, -7.069115397583948, 0.}, 0.3], 
     SphereBox[{6.7224899756478385`, -2.50019726925329, 1.82079524971937}, 
      0.3], SphereBox[{2.502003248957592, -0.8057480946805278, 
      0.22199319828832031`}, 0.3], 
     SphereBox[{10.601875345953797`, -6.476719132204443, 0.}, 0.3], 
     SphereBox[{2.408306046642268, -4.448508402541549, 0.9006460298118744}, 
      0.3], SphereBox[{14.243696017877939`, -0.7488551285947529, 0.}, 0.3], 
     SphereBox[{4.891248080120752, -6.599960491268763, 0.2398023673504177}, 
      0.3], SphereBox[{3.013101160074931, -2.387957737714401, 
      1.4850224383671302`}, 0.3], 
     SphereBox[{10.568124109232574`, -10.616182908433357`, 0.}, 0.3], 
     SphereBox[{0.7931225545631968, -5.139078439501725, 1.4148144800667617`}, 
      0.3], SphereBox[{0.7488551283614633, -8.41973621348822, 
      1.6521465227932766`}, 0.3], 
     SphereBox[{10.483092996853623`, -5.8030709545340535`, 0.}, 0.3], 
     SphereBox[{5.613131639097827, -6.331135378215775, 0.6639565805800605}, 
      0.3], SphereBox[{10.548312500169327`, -1.5553368751665333`, 0.}, 0.3], 
     SphereBox[{9.959087736499146, -5.363378333653024, 0.}, 0.3], 
     SphereBox[{5.063931167400363, -2.967761979090076, 0.888342184726086}, 
      0.3], SphereBox[{1.3200927261367092`, -12.00453362229192, 
      0.0435967225449605}, 0.3], 
     SphereBox[{6.566331879097178, -2.0674938447795377`, 1.3721315528150029`},
       0.3], SphereBox[{8.220200232370765, -2.361818621553507, 0.}, 0.3], 
     SphereBox[{10.204852845449693`, -9.498148919642597, 0.}, 0.3]}},
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdlHtUDFgcx2emSU9pHmkavWaanmrR8xDuT6VpKREiqqNE9KCETWTTSyW0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     "]]& ],
  AspectRatio->Automatic,
  ImageSize->{349., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{353, 241},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246462954,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJycvQVYH1maN8q2pm2mZ6bXRnZmZXa/e3cr2mlNy7ROSxF3TwoChAAhJCGE
CJIgITgEd4cEgru7u8Mfd5e/1u+5X9WpIpMpspN+bp7uhKJOnXrPe87rUvRp
Mz2dC6fN9M+e/sO3pqdN9PTPXvrDN8am3K9e/Dstrb87rqWltfhPWtzP/x/3
E/mfBaD1oo6ODsgfrRP8X1oq7u+XuV+eJFcK7u8XuKsXxX+F365wf/MPvvzU
DNzf4gyL4t0N/NVLT+bnfjhO7s+Lc73xv9yfEZ//2br7x8j9SfH+L/irl5/c
F2E4SsaMi+9452+MGRHn+QcJHl6QXB8iowfF0f8sufui5PogGd0vjv7tTxrd
K0L7e8ndlyTXB8joLnHuf5XcfVlyvZ+MbhdH/8dPGt0qQvJfkruvSK73kdFN
4tz/j+Tuq5LrvWR0vTj6f37S6FoRkk2Suxsk13vI6Cpx7i2Su69JrneT0eXi
6Hd/0uhSEZIPnjN6FxldJM79keTu65LrnWR0vjj6k580OleE5HPJ3Tck19pk
dJY49xeSu29KrmkyOl0c/fVPGp0qQvJnyd23JNc/ktGPxbm/l9z9meT6BzL6
kTia/kmj48XRuyR3fy65Ju/WihXh3iu5+7bk+jsyOkqce/9PGh0ujj4kufsL
yTXBmVaoCMlRyd1fSq6/JaODxLmP/6TR/uLo088Z/Q0Z7StCwkju/kpyTU6G
lrc4t+5PGu0hjtaX3H1Hcv0VGe0mQmIoufv3kusvyWhncW6jnzT6njj6ouSu
lPsTatFyECExk9z9R8n1n8jou+LcV37SaBtx9DXJ3X+SXBMq17ISIbGU3JXK
oc/I6Jvi3Dd/0ujr4ujb4juk0upTMsr8qVH8v1L5+GvJ9SfkqSt4in+/QlOM
DsU4UEwYxTymmHiK+UGcTSpZpJAKs10SR2/mrzZwszEUc48yiN9uUvKFSfvO
84MHmf49zLfiKCn3lM65g8xpIo7eyl+9zs25izKzpByDP/bO2x3QrhMwZfZA
cctJY3116SpDuMnL3Bh9inGimAhuFRsZrU3iDFKuJ8XIx+R9RiJGtovvu3WK
Cnb4OCn+QE6lceGgTeGqRy4blIyIEITY/GxtnXoU40wZPNxuXPaFccdO/cED
TLc289/iTFLOIl2n8N7zIpTv8Vdv0tR5morQe7/AdV/jY5PuenvZeIBMk9CD
zCYUFCE/BnHmb65hZB915RblGLbDu2CPf4eu//RlL+UtB42V6YwJ81/irFJK
lsJA5KCWnjj6QxEGF3pjocG33W76Uyl3VhoClROPlZqiFdRNo7UHrSUo8yEy
7Q0OBpqyObsp5N6Oxw8P5VQbFw7ZFMo9chCUhPBABN3Q+g9xZimtSfeAvFlL
V8TcDhGOUO1tbbqH5p0t1EnebO0jjBZD1Qz0azC6gNFOtCW8IY68SlPR5z8o
dN/fmHKxu9FBNhEgYx92I7MB+fnIC18N1v2DCMlvnoMRAZKz4uhPxfkf0B8O
nmTUd+0QE46yHPQ3YGkAmAaWNFgYXep6vAaJD72p5ML3PZ7np1PvrjQFKiY5
3BUvo34Kbd1oKWDz7/1OnFuqT0ohIRqN1ik8pSe8Tn88vPs8e80FAQnIKkVz
F8YmsbICjQry5ck3RRjitd/vMDi64GqpTn7A1idivATqFkCmwdgcRlpUdUG/
Fmf99+fA8D6B4YS4L98IMOixZ11hn4joShT0omUGA3IMK1A72Kxw1ls7GY/p
T0fP6GkcHBAXiYo8yJqwzGGMMx+W1JgfIPyUf9F//iQIjoqjiSx/XdsW52Nx
rxQRnUgbQ9404ruHsQr0lHWeYIgO+hY5m87HP26iv5jcb8xauiPoEXLK0dKN
8SmsrkKlwurCEJEw/Nr+3+fAQeiTWBv8L4kO9+a+KFzIwbnUMfqc0rcWMs62
4oyvpjTupi7F3KEYT4p5cQ2aXVSSwd4JK1vQ21tpI+h5wikZsdUo7kfrLAbl
GJKzRPLy81PPgYZwKWJxvLCmAf0jbYOYNkwsA4srKAv35rjgFqZ8B9PyFdP8
BYeMu0c/qL1soHT0gV8+IrtA7x7e6QjjBDhXIKobGeM8IokW8oSXPxeCvXhK
q/rZoQdI68MCtxGzk8hwqdzj3HfWcdb49k4q9pz28K3bcI9DSC0iZRBsp0Nx
MMojs72NZ+v80reS+0SXf6KxvipIr3sUE0MxuVuZ8u1MzhZG0NE5vOvox6Jo
BAo5so+ltJmmTdskK11jTXVX7T3hm4OIDgS0ThKthJ9RakVI37+NvF9bxDvR
n1/j3n+cOneXuhz97s3ib293Hroxzlya1dMZOMoIVghHDXf3UfE3PisMO1ZX
fLW116l9KaiFTahBWl5wFaJkeLLvH/+k969JZ1qcnTtbV00oN58PQzP3xjTr
x01cj1bYB7Euzrh/qUuPEWzmX1ygmNsUc59ifDbqhGy+Er3djqZiDr1babW/
N/LSRNn9eVn44mraPFsyjtpuNJSiPIRox/ybPnsOXERKE935ibb/B5oy30+F
WH6QHnqgtMikpvdu3dKDak1kER6lIDEg9sN7iV/7p+6OzTyWnnuupOBiffH1
rlKb4XKnWZrKP/Cl7JbecsRdTUkI25eOlUqgXcMT2FAPujOXLl1v/5Yhlukr
+ynGgmJ8icjP38xkbGT4nfnyOfASS5Ro2E/sjf+gqcD9VJHVzrYoo8Ey+4mB
wCl54jibJ0N5E6pyUeBT8UBeEaSqjEJFAspTUJaJknwUloDeVLt798K1Kwj0
Ql4iOkox1wGMcFTAYn6GHSlF8QgSq+ATu2ph07ebCaEYsiMv7aaYS5SBD2WW
/tE1HjitF4eOMCKE0hVI9U9hBV/iKRvov2gq49CnXVZnZyOt1WUBrOwxVks4
fqRA9xT62tCWnFuJzFqkNOBRE6KbEdwEr0bY1YCmauhDKsNbcA9GchbqGjA8
iJV5sAqw8pVxWcHUABQ9QLMKZZP884FJitv3Ro5yB9+GAKX1sswkYvFWoNre
hXW4OmXGCDbD39gBwl+IFv2Ef3CSq/IAPX39kjrEDYXx6C7CAie2BoEpNWYm
MFRyLkNFuPvb9P7VQ9a4HY7QAuS2oXkcg8uYVGF4ae5YLDxrkMkJ20GMD0Le
B7RqCIwb3L7OTjld2nitcuJ+hSqgCNFpiA9BuKXUqpbCSrRkouvyvzwqUl31
zv1ykxvwDkR6BprqMC6DYoaXAOzq8vJIucCBXqWvskww7HIR3oLMEZTOoXSG
FXxHP6f9NTprf4aHsItKNvm0+sGJrkyLoVa3sdnIUTZNhsJWlBehKFSwB//G
iRCg/BhP+QJfo/fLT1jhbjii81HUio4xXj4sqDC7uiz4JTit2XPvNRyMxuVC
3KkTvFpP7Ig36avjVkWgN9ea7B1+cGkp00XTFoXZbLBVSrTNorsHHXlSuKTY
20jg+kCc94yAFQsYhsIlH3FtKBxD/QKalkRvxks0VXDqPmI60L/KvoCn7BAO
52naOwYMz8o9bNnUYDRmYLIamm5gVIPpOYw1CBb234CFyFUiu55YyS/TjjiX
CNtK+HQgsFv017yiTTGXORVia49xMNKGMLI4w2N1jZ8n019PnzaCgyviE1BZ
goEOLI9zghdYVatn2rWknhfpXglwbBP3ylxcN2NEGXhSl+kfFgRuMH5yjRuQ
975Ofz211wwWDxCYiuxaNMswOodFJZaV6taewu+e807i2SN09xf7lqbOHaCs
+Ze9QKjYuQC1C1A7eGicbqzeYgRcbODUlTPesEtDZD1yB1E/j/YVVE1MSj1G
Umz/N3kjJb5xzZ7V2nD/y+ykU2V15lVjTlXqwFLEZOJhJGLuvinsh7XmTCys
S+HbzqsKWlJPk3RdwlvWrK4nb+G4ybWd1CP9j6rcj3Wnmg83u45PR46z3F4W
daCiHKUx82F6J54zN9EKtf6POKeF+O+LAm1QXvTmSoOdQ+4mS2n32eZITGdB
U61B+wJ6ZeguWc29I51fiiHim9X6o2T+tdMeTL/fzZxYvW/FJgaiLh1j1VBx
p32MxcwSJtqIbfC3oBdm//enMPPCmv3NWxKH9GHjhKg4lBajtx0LY9Ascvwe
6vleqW9KOvP/ITP/QQK3aJm+10Mbshfd4f0YqVWo68fALGYVWFCynUN10pml
GCG+ba3fSWZ+WziHJ1YPOuNGEgKrkd6Pyhk0LqN8Yu7sc+YkNobWb8T1r81J
PFEv7Q7C5Vzcb4RvF6ReM+mqhXnWLJdr4r82z3nqj+Spv5c8dfc5MJOIAPHb
vfDUU47PeZfw1NtPvYt/2vk5TxErkHiHn4bQ9TkQ/ht56nXJU57PeZfw1AbJ
unye8xSJpqyLRQgxpnNEqY2imJRNTCLFPLGYiU7Ec1XOFrvLab0U8zyd6g/k
La/gKf8N7+U5TzFelGHaeya13xr17j03fJjp28scE99CbACOjzKGFGPLvZ3o
J69qk2s3ikncxJTtYFq/Ydq+ZgQP4096/9pveUZGzv5rBygL+80uD7/yqzkW
OGjkt2jprrKx1dgaz11hnlilhFPy9tBeirlJMUEUk7mVqf6IafiEESJKvK1y
lLpoS1lHf+hUusu19+z9WRMbhbnpvMnzofv9Ouj4H3lMEQ8bx69sDDZH+Xyb
kaNT2GFZPOdcoA7IRGQ8Yh4g5FqvBUOiWPx4Pl7yAgeK1qsXKbMH26zSv7Br
3G83ont7wdh0wYgR4nCvEwve2oDyd/80PvVQapNJxqRNmsL9IfyDEGArjZtI
of2XZ0MruX5dhDze7LOq4LOdxbcG+r2HVmNlbEYnCmtQkon8AHnUBUHbfvEM
xTw1Oz/NbhHS8wcpJ6vNwVF/ji87kyS7mrRsH896BOGBvcpR0KS4d9ymqWjT
Dwt8D9blXGrrvNe1ENTOPmxAZjFy4pBgKUYfhfN2h0OO1BZ89gpflvxWGpUU
NZZNFZf3D4dcWy7xUssSNPICNeqW0D6G7la0ZbJFToKW9qpwjl0pJo6zpbcx
5e8yOVsZrTVv0V5xJdy+eJ3a+PjetyWPdOrrbjaPe7RoIuqQVIz0RDy+L2D5
VzQVsndr2WXtngCjqTzHxe7QlaW0JbZsBg39aKlEJR81IbYrb8D5U0z6Nqbq
I6bxM0ZLGp2Trvx3z1y59HqDAO373cY6Cn8HNj8K3XlYbAT6gXEVpiYxWrdc
FyjoYq8RPqHnTJk9et+i8rvrPYeujJ8xnNZh+g4xxEfET3xAXL8lTaUynzQ4
nxx4fGO60Wt+Kn6BzZ1G5QAa6lGbqLW24+k7P+k1Pb3sa6XJCWQ707DAmbEd
LIbkGO1HV4qWQAPnqUvuW24nf2ZXt9d+iLFeML68ZPJ8HPz2mTiQnvdXBUi2
958ygosnUpLRWI3xXiingGVOWVWoZ7vqSrwE3ZDf2T2U5Y3N7mGfBxUdiugy
jJi1DFbZebFOdzT2hgMXmCfeIcJbf65DWJ4HoQqacqc31p7ZNe50SZXoytbH
YiIfmgYWvUoMj0FWLmDl7znjnv522sAY7q5ITUBTKSY6oBkDFoCl2cWeVJrS
3085WFJBIV/FFZ5I6jF7vHg3AR6h8HHSOOutw4vUs/xsvEglB7l+TduQ5ZTp
kAzkN6J9GOOLvDK9qFQvcvinRIxYn6IiHT/LfHSsuOZyxYhDhdK3GJFZiI9F
nDsCL5BI5pOz8QuO7xsTtx/vevuYd73VfsIZEb3HTsjvWCM2BJVZGKyHQkZ8
x4urmGoR6P4d+seFo+a444foDJTWo3cIcwtQKrG6ukCw63aESrT9sij2dF2l
RcuQa4sqrAGJZchIQYrH887Kb56JE2msXsDJwfuwTkF4PXIGUTOHJs6s9mph
nbyb9zFPTkmUzntlbofbUy4PNN0fmQwdYZMHkNeO0kqUJSPHldhxT6z6X3Kn
6iR10YGyiv/IsXKXU/9Z+zmTG/LLhvT7/bvOseZOCIxHbinauzA1BcUq1Ep2
cqxexMqOHvoqjAPhkYPHLagcQ+cS+uQgKLlMU0nHP6izOyKLN5+qcV8YjVnQ
ZM+iYgiNzahLeR7//PUzsSLNGyBY2UC7wiQTjvV40InrpqhwmV/yKoXtTREj
Gwt1v+93uzCf6qhqCmOn0llNuRLN8+gaRHctmuKJnOEl3xEInJHZSdkYUwEP
Po/LOpLcdjF1xvaxyj0Gfj7wuUbraM66wDEJcdUokaFjDkMK9C3JUfdI4O6v
0F9N0W4wTYFrLSL78WgEaxzHgaYqj/4wesdIEevEVkVhJBeqOqBHjeFJDNYI
sbW/QT3Pxok0YkeuX6Y/HvG6gXb3UbVHiuIaI9hhb9Bbm04dXnK6wSb6oS4Z
o+VQtgNDLCa5wz4AWR7BKD8ZyRf6NUdhNBVnvqMg+Ghd0ZW2vvvtKyEtbGIN
MnORFaYKN6StoR8Lp3JEdiNtHCkjmjGOcy0so8CPm+AQL4wCdl+AWxFqF/HE
276HsjXYnENv6ThweOXmDYQHoCQNfTVY7gM43sfR+UznOmxITwjReNdJVGLl
8JJSoPRHFFOwhSl9l0nmmDnhvxu0j6ji76qHPbtYl+DTFGNPMQEUE06RqBy/
S+37zrBW9oiMQkkBeluwMAzNHIkdLM8sD5c+8cEQHw5nZ0bsf7fCcm9fmOlU
ifOiLHJZkbnAmT1o7EJzEVvklrmRITD+hr6LR12YXwXvLXto7c7jpkXXDXFd
6F1YJDTD7KMczm8ruHl84r4N6K2d2qc1F+3xIBoZRWjuwPgE5Csc22GnJppy
NzHPxdA/PRNDxGvwGtFkDLypy+kfX6/Xthg4dmmK0Zs8y7TtFvH02oXzIE4P
5gHFpG5hqj5j2r9jun9gKncwgq31Gn1abeQErwSklqOuGwNTmFvFigpzK/Na
a74h4lH6H5rK3vW57JruSshdtiiU7cvESg3QrcHwIkY7Nc1RCM5TOYbOXbTq
3X0uZyMvso768UxOznGTse74D6zpfSvWj1E4xcN0kHK58H7JrdMzznfhG42Q
EoR2gD6pPOYI2wREVpDA1yxkcvQuKZq1TYeO6o+fZJ5HXX8DW6/vo6zubPOO
/zas+lTU0KWIZatA9T03zf2bKrtzVUcZQpGvE0562ZmyS/rctfag25De/QUz
W6WF2epVpuM480eBU1Hue21hEQf/MqR1o3IKrctoWyaY4t+o9XuaKqF/nL9o
Bh8vZCehvQKz3cAkRxQsFsdme6BoA1sLFM0guR0h+Sqn8HlTmwsJqBgH5Mg+
mHDQEv41/LzGOyqsdOZdHOEXh9AyhHZCkGZv0Jaas5G4W4yQDjwexaMhde3J
sGHT4BUrb43DHdUdvedqt//4TFwRzvMzmrqjQ8V7/DkvQ7e87Wb1rFulOqQI
cWl4FIF4R7k3Y00xZhRzWPSzv65N3TXbFBr8bVLhmYwe88wFx1S1dzwbFIig
uxp3XWKRbjhJdBnOZKK3d970BO2Oi+lwrvtLfsz/0LtXTt/AvWA8zEFVMwZG
sbgEtQrLyxPetUjtRG0/+mWY6YW8HSzHdYtmd1NRt7MRdriq2Kyh/17TamAd
m1CG1FT/hwitREgX4kjUKorkLIRRTChPsQacdm20JcH7u5xMndK2GxWzrmXq
kDzEPUK8x/Po8R/+d6z9hrNyDD+t8TvTm3d7tNtnYil+jM2SobQVVSUoj2cz
bMctE8auxYxeiRy5FDpkEkhTD299URbDNFfe7OR4mTKqDSl1yC5AbhxS77Xd
YQSLkOeEp/n4m07cFn2a8jhpAL8s4fWGwon8XEZbwoxT4AqQ1o6aCXStoHdV
iAH+68mH8KhBSieq+9Enw4Et5bf2dEdeHCt3mh0Mn1elT6N0CHWcPM/od2rp
d2zuc2jss6vvvVvbe6em16aqx7qC0412U+lmX9T5n+3Juznc7T22FDfCZvfx
alRFOtJtnyv1/ibWNpZd2DPqe1We58l2J2CxAGy9Cp1z6OtDTylqg5bKsFTC
LheplwtVy/mKA+9VWx8Zirs+V+O1Mhq/oslbRPUkmnvQWoG6mIk4I8Fu43Nu
tKmLN6g7YR+6Fe7y6jrrSTywLzYuY/EKSfbiM0O0fkusrYsW1F3aE5cz4NHA
xwvjh6C6ZcDdP0G81HcoI/ct9wI+jYzYkxvPNNJU7p4/9d/QXQq/oykNYQcy
oKgGOtUYnMZQY3s5Xugog9bbnaXoLEEX918xH2qhqQR6a7PZoXF/c3GtSwVA
gwLdk+hrQm3wJ8/BIvGnrcuhfUPA4pYW5pTcww4ZEWjNw4xghU1qMLuIqU5F
56OKAVQNoGYA9QNolGHXnwZuGiqj77OVMRjKh6IB6NVgZAljfejPL9zCCFjk
rGWLM1TA/U8eilEojpKSiRcIQTdmuBNKcLiRpm4cpwLsP0xMOJBVY5w/apun
9MpASBwivfw/CY/YlR13tiHJbDDVdindQ5UZgsyHoDdWa+9auEJievlJ6K7A
IsckJzjFQ405mVstPOvhXQ+fBvg1IKARQY0IaeJwmEv/adRIX+ntgMxItOVh
rgngE0XUmBleao6U4lBKv+/87zjk9IbS/bqsrSviElFZgYEeLE9Bs8wH6VSL
Q53NCYLe9hb955lLVxHoh4J0Xvuc7yMazxKnXMypx2sWbaJHTxnlcLL9t1jz
xxvxDi695G2GlV8YdO5kBvYzvbsYJJjzJ4yP4+rSVDizvcBlL59d0+QomwmW
sUmdyK1FUWa6uyozGJkJyMhAahESqxHTiMBm8FLmoFL/NtxCkZyL+haMjmJ1
mc9UWZqX8aHc0mJ4WWdvEXj0mwcp5gZ/1DPpHxbOXoaTNx8mrq3BSD/ks7zc
YVdmpFFo6Ql8NvbeFLB3XHXeFV7JSKtFHaeHzmNKgRkl2zvNbQ/xs4kxuc/H
T1yHUygS81DTioExLCxBqcKqfLU+BcNxK/N+TQtWESPHz6dx+t4/ruGQswEK
OFI9RpnbU47xn3lU7PfuO+c5d/m+/MZt1a0L82aMYIXxdH+BYjjVLIFi8jYx
+RuZ70SZdpczI3S+7XE1mEm1kzeHqGbSVWz5Clo4ftmGluTYBgQ1w6lB0HF/
R1N+e76fpHfN77WGZSSCi5HThaYpyFYxIGez+jA2DZYT6t0TyElX3zHZRzHX
KN3AjUbZH5nQ303vuYbrnPzLQW4LWsYwsoxpFdpG27Wk2ctSHP/qmTh+S5AE
lqxpHLwqkNjL61GVC8gfl68bS/b7bdoIRoHwzkNKG6rG0b6EXjkaZ2ato/E4
BY2c5RC7PO/TsHArZOiIQTzFrHkeiMG9k2KucIdlWytN2RtvCn3wVVLWicxW
s5ypu1lKz2QERiHUEwHmg5aMoMNvIN6dc26UafIH5rU/mMuOXJw8ozN+iiFx
Os4GsefmOn1o0clSk+SHhhRMVoLtAkbVvE06VHaA+Kh8SGpkAn9Kg/fSM+au
8CsHbag4HIhbuQhoxaNhJI8JttgvrAtQOoi5GY5psGjrR3KM0xb3xG/8a48H
jpj40UbscT/YcrpBsxgVTpFNPtcD+8tn4l7Ipd4dAtN83KjAE//1i8J5u6I8
lwBHTtvoRtwQ/NvmCXyv0fpzd2OQkoLmZIzFLC48qJ2/ETBwUI/TQkT77xTF
XCWuHXL94tqMP99HKJWoKlc5oWH+aUnw8cZC884e5+7FkE72URMyy5GXhmx/
dbSJsIbXiUV24+Zmz8gvQsqORspMIpZuB6odXdn7Fiu3hV34Fb1ddkAH1g6I
juEj3gPtWBknfGtVsTpWdY1iAjcZZH9o2PhnPc4i2rd77poH/Ct5k1A4US/R
G0uuPETtLNjFYULLb3pUoZ5jOtwejCh9/pyVzRR1WJbMuxRpgjMRE0P7qfUy
8PVzzvuzcS7NX3xdOGXXWcc4pKdy1Irx6PkFr6r56779+84R+F49RDRMTtHL
3sxUfMBUvPckpftlgSKoc8bUDZ+tjpnfutGU7/53Ky339Yddmi52XuqLWFlO
X2JLZ1A/iJZGNGWyhc5rmLU5SUXf+1NO0qmyRovqKZcqNccL4tKRGI5Ya4LZ
X9Kbm2h99qIbHiQhoxpNMozMY0GJOYXiLHXLeZNL0tc+dcf8Roy99+9bvO7N
h9c4tL64xq9O+yJ/FCrFStF2pvYjIaPtDW1X/uxe+aI28ExXwc3BXu+RlbhB
NqsLJdUoS5LHmazLV5Bi9hfPxKw0P1PMq7RlneORlYq2xxiPml3wLJ8z99pL
MbeoSxFbbxR9favjoCX/EPHW/ILD5EHKzWpbdIx2coVeBk3F7fq0z1xnJeQO
WxjC9qRjkc8nYjGgwOg4huvUjeHCOeVkbMyZ9yvdjvWkWYy2ek7OxU6wWUMo
a0c1pyNHjQbrCJH9t+lD8/vv85HIoBpkcqrLHOqXoE25XdwW4/fnjFymoMuy
cMEl74YvguuQLuJyAxEQBntskNiDRRV6jt+aMTBbNGLWvDcJO7c2XT00HnRt
pdCT7UvAaiGLhhV0jaKnRlPqti67QYpREilaF+P4neSayMMNuxzgloCcVHQ8
5mS1kR7l4vVBcMaeaKKFvqSwD2RdXeBqvmIjQPf3e/jIEa/o6/KE73psS9q9
H6uSDFoabDrpLb30N1PGF/HAnVedWkox1Q4Nn//Eke8q5nonWmKe4Lf47A9D
LhdX0lzZ1ljM5nPaNIvuBcg4bbpgNM1CqAT5o7YPTLJhVweLommact5FpV77
sjqED9DI+r0H5XH9yGpHcTlKElajL4A4NrQpy/OUJ62nDmrAuBLTt+LUzqHw
coGbMCBv5xejpgZKX0fkRKEzHwvNQmoRN7R/Xb7GT8Psv0iuhUzzfc7w5BRI
KkDQSX/bZ1e74lulieaUo9Qr1FVzytqCum9Jed+kQm5tirV677H1jmyaSjr1
aYvz2dEUq/kmv2VaD/RX0yeuwsEP8emoqONNo7lZKOVQKdml+QHClV4+SMJ8
fkQmPaTEPL/Xwylm4MgF1t0jMQT12ZhogEbGrZPF/CImm0it0r9yJLH73UaL
w2OhFiQk9JBVFKrQsIiuIXRVsCUuBGWWHKO9/EF24IHKAtPGXofmlcB6NqEc
aWlI8yUDcugfF3WvwMUHyaloqMWYDIo5PoVAszSmJc1HkeL058/EqTQres2X
rPX7G3RbpNFQhcPkUMiUMnkchTJUNt89IrM7OWqnM2NvsGRvsmp/WWlvobG7
xcFWemzn5L3L6iRPtuEhJoqh4XTSizDxg1cWkhtRNYyuBd6zOrCqSa7PF7jR
LzmMWnM8eqtB4Q6D1h90ZfuYvj1M1SfMqoU1EqK4ox0Wzx+73h7MT0G1ClbJ
Lk637RQ5ce7uL0cvn1cFOiE/mjvOWOaPGIspOaZ6yDrfoamgvZtLLLS7Qo3G
ShznZGELirRZlI6gvhUN2YpUPkeD/mFu/3XcDEZoLgpa0T6OsRXMqPDDc/D5
s2fi8w+S6w1r+Pwj2UEv7ffaLU/PRdpoyoPYwVQoy4FWJfqmbb1h4w/rIFiF
4VYUbsTiegKuJXKPVO09IreyRnQoynMw0IgVktZN2+NiItyrENuLjAlkTcKA
xOUjyNHk9F2BOn5JU4YXKVu/7W7ZPz5oO+MzdcldedNOY31p+RqDkgwMNy0t
DN1PxKMaPpzWM49RBYZWlbtEDGfS9KL+VXj48oewuQ6TA1CJB25kjYtm7Pqk
9+qZxWAbTVEwnzy6yhm/XRoMzWK4ebrAQcDQK/RF9nQAn5cX2YrsMZTP48f/
X/iV1nmu+W5Fj90XY2Ym6iB3FD7ivQWL7SQvdIazIacwVk2k1a+0j6qM7eET
i8ynEvpVKiyvTGOuH00J8NfnLDRvSjd1m371F7pd2oxsL9P4jZidxWFU7wD1
wGr7w5g9WZWG+UPW+QqPLAQ/QmQgwqwGbjEPO3voy5pzUXAqQ3S3sDssqcx8
jTtrh27AKhSR+ShuQ9cEJjiGrULjQJ3ITWiqkP5+1sQUPh7ITkRHOeYEQ3hR
g/kBQVOk/dV6mWT12s/B4VvPxOG/Sa75HzeI+Js6exWuAUjJREMDRgchF7NS
5XPj9WTMrzh5ejOWdz/m9KBhGj2rvHOpSNYxqIBGvoThSuQ4jxox1Qe9Bw08
Fq86Km9dV97U62FEPfftcyR5nNN7Uymm+H2m/kvm8JYce+36RCO+/mYyUMY+
6kZ2A4oKUBipTrhCfNevcCaIOeG9KZuYoi1M4UaGrP1V2pRlguCYx+fi543z
NlBy36hgW75G71w+fR33gvAoG9XNGBrF8jLvQZyb6xdqjf8G5t78XzHHX5K7
r+0yhTln1OUipxVNY3xK7IQSwyurSl8DIa71Mu2Fa1nwakK0DAnDoub87/Y1
qFrgNRJuR9H8qMM8d84xS+3zGKHhCL8PH4O6L5jOnecHT5hNGtxauHJPbu2t
cgrVPIhHSBpiC5BceezTDkedqSTb1cYg1VSqii1bRdM0OrvRUcSWeXTuNize
xLisSSheDzKlDP2oy1k7LJp2XR06bjzNMKMnGcJHX9wVApM8sjohmkJ/1kdf
x+VQ+BYgvQO1k+hZQfcyuxeifnqcYqw464BiEjcyOutrwAXMEUVTdIHzWHti
Ia3T4nfdx/VU+Nfj8SDyp5HHSc45oK2A6AAbaUpnbwDiB3nff4llj8yjbzWq
m01tRl4ZCpOQ5YbHFcjiTksnyQcYR9scfyQHlHyS6hSvEx3cOXPnijrBGzVJ
GCuHugMY5m4tYKJ9tSl8ObJn2atkzipm7LwjR9lHqDv27z54+OewmtORw2bh
Kzb+Gqf7uH9l1pI5LOyo4BZs5N2C4b0qoT57Awlh8GZa8ObzuR8bNv+gN3jg
Wbh5Yx1ufo9nV/4J9f5emRjjjLLpFRQH/VzEx/2dW6qu7R8Kuzpf6iEfiFMq
clf5yHHrADrq0PiQL/lZ4PgzVlewIMf4KvpX0byE8jmkjiOwB7sOKa5Z80et
OJ8Phi2OgF3gWTq7OFRdj65ajJRjJk+zlLxAUy76Gx96fpeXqVvefqt6zr1C
HVaIhBQkBiHqepLIrzj11FCXsnLe7ErMGv9RkweKm04aW7NnrP/1detf84pJ
Y55vCdg+o06uJRbl6KAm4rKAlbdOU3raH/dfPqcIcmALI9Gbi5UGoI/FmAKT
wxgoiuiHTY0YW/4ner+cuQuXWDwuQ20PBqYxK+eIj5VN8Z0GrmYgsBIZ9eDW
rk2lGH9e53e2L+/2aI/P5FLCGJsjQ3kLqgtQGkTWy8k7012U58VtsT5/zsg+
W9BxvXjBJZ8NTkN0GMKu84Je6kVYv+Z/xlM9HdatmfFETQ94GuiqaNMRpc5b
JziuuT0kTreF/mJC3xSe3shIRms1uEWoSXIJu7KoHK9Zi5ZawCQSXqVI6kbp
FJ97VDolF+j7dXpTrdH+CV9zRa4X2/0QS0VAkxo9s5B1oSvrnTUqN+WdlMyj
jUz2Fj7m6kVIm+y2z24q4+qXNYFnOgtuDPR6Da/GDiC7AyXlKI54xp6/tm79
a/k90gpssv6X7j3mYz2YVaIyhjz78yMU47A1IOZMY56LvCYV9PbufZdhHYCo
bJQ2o3sE00tYVmFRIc+teSRWxh/lFKhS2NWLeRev09v7zjEKDwdkRKE1H7OC
NTLNCdUZjFX9ao2KL1C6XpRJ+odmDT+YDhw2mDjJdO9jSI7lW9zO01Tq7u0t
5ofHg8w5k1HDmYzyQg2fFNs9xLv0Bb+mdP0b1q3/V3h2rw1BqtDfTMRVYHEa
fHT40e0HxNzI2MRvgujLO0Axdzf5RJ2sy3VaqU5GUyPvdsmcBH1KcfoB7mUh
rhmFI2hYQMsyMvv6fi1g4APZ4QvsHQ/EPUZVNQb7sTxL6F6hmBipfG1t3w1I
Phr3yoLNTPE2wfvwGseF91G3bLZ6xH0VWHU8bOhi8PLtBxpHe9bhgtaZtSf3
U4wlkQtpW/gnKZE/VOz+duKSocrvHnKi0VWAxRZgiFPK5JhokspXKUbW424t
11bqESK4e/uwHUo7CO30NWR/aNz4naHsgM7IEWYP7wvyjDhaneOwVJ2EpnrU
jyBnSoiJvbQ3BBaFcGuBVzt+J5wEAxh5wzsdaY2oG0b/Im/iDiwtv7Z2Tk5T
55yoS4nvXav+3kJ21IyPtDPMmgbnyFCxrl9lp50tbbWsJOHEfMQn4aEvgi+c
EvHJ2c+MCWX4gLqSwQvla8MnTWZ0mervxLwObpYGeq9c3wJufkhJR2MdJgah
XOCVsenhMinepNrLqyLe/lqe8DJYakMT7vIzmtK9Hcef4uRvfetPcCzcZ+WG
i/rOLbWNQdbdhaqHaKxFwzAnm0Ey0V/RvgvTRHjV4GE/j8b0MQ3BzN9z69pN
Xb9KeYR8GlJ0OKrXOGrRKkTt5Mm63pTfEdLWHunvqPY+1ZN9Y6TLe2IpfpTN
6ScVXzko8NRaw47BAequ9ZYH0V+FVZyIHjSLWrEN0jg7w9lYyInaQB9cPWQF
q3BEFPDlBZ1TGJdjTK6SxhSleHllHV7ewLP7x7wu8juXS9tiA3/ILDhX0HOz
aNE1TxOUhqhoRLs11qBhCAVT+FBc+c2DVKTNp9nxx8trzGvGnGvUweWIz8bj
aCTY8SvfWGWwe8zrsjzbg+1KENiuCr0zkLWjLVGL5J4IuZ7uZ6mHTl/lJ52p
aLSsnXKrUYeV4lE6HgeOOIk5YW/RlqxuOByLEN2JnAlObWL5ctzG5JPEnvYh
bmSeFwkektN8LIJ5Qk9/Ex9r9uofxfOyVoHDSb2U61/XRJzrKrceGPIZVMb3
IasNRRUoTUGuh5BfwGEh/PDWCoeD3YlXRxvdpqajp9isUZR3o7YSVXG9/gy9
rfvMaYXLXaRGoiUfM808L9DhgJufVMlyhU46L+4n8LqtZXdzb7/DcV7dHXWu
J/pSLcdbvabn4qfZ3BFUdaCugM11FKrbOA7Xeq8EfQsk0y/xTiTFFH7ANH/N
dHzHiCshGaAvCym3DzcyJe8xNR8z67Dy8jqsrHnkpVXLa5Uj7ju3Ndw4Oh55
Y6XCRz2cqFEVKXn22zmM7nq0PBKw8w80lXv46wE7w5VHTmxDNKbyoKlnee16
cAj9JfwZebfngAFr5YYY3knInCS5TFEUk/suU/EuL4hJ/jOfAXCA6ODhFJO/
nWn8E8l2X4MliN5Yp7N73OWSMsWNbYnDbCHYZhb9CxjqZBtChdWJcTE3wulz
N/PJVGIG0FVEtfFZP5iQZX7j0nrcZcrIXn7tKglcrmHw1ePUeRvqatS7t0u/
s+49dnPWwHTekCFc54U1Xfav8LeWO7TxWfh7fednQ1cNVaHOKI5DfyFWOAEx
wGKS53QYLPpY2NuNlXv2Ld22REwgKjMwXAelmNS5gqkW0Reho9H3FNKJdKwo
08it14u/vtF16NokYzynz/QcZoTOQa8RKtO7SF3z2XY362un1qP3Jg1tV6+Y
LV0SbdTX+Vqg92QnTysdbPEwDHW5GG8CO0wky8Lky2tS4Ayl40iZJLx7pfLb
K32HTCbPMP2HmP/4CyVfPRaA/CGeZ5fqZg7cyJS7pCAgEiGOPDZfFd+ko03d
1Kc83d4PT9kT32TwaOpmPO9J9XZasSMShW/69bQE/OvTqSPWkm191hl+nf5q
Sv8KvPyQmY7WOj4hUDULjlWwqwsLoxU7BGwcVpvcgV8Mckog9NgQzPN46kll
wG2Wpsz0KBdP4rJu0Y+ZtoxUOfrD3ZF1Nlzzxpkcotxub4mM+iGpXDdtyDJN
7pwIv1AEOfRcFfKpXqN3jOw5z1q6ISwRRVXo6cf8HFRKzlKZXrPYeflhYUa5
+n8UmLsvvOt8xPyNIBK3uirU2vyWew93xI9uzbzzXXXcubZqq+4xnx42vh1Z
1ShI1iRc4VBQc8Ctep9L1Z77lbscK3bal9N3acqWpiIuvpfls6ci26ih0655
yb+BTahAehpSXF7Q+evubfyPBB6C2feehdkN+67gdjCi8lDciq5xvsxzXoXJ
leVPiNihvx7ZbwvreBGh7nyC8rmqz3W6aEa2h6n4jCHH4zy3ksvb04P2lRaZ
1PbZ1a36VbOxRXj8GMkP5AGM1pN6c5ryPbo13e67yod6LXXWnZO+nZr4ZhL2
S8Jja4GKXqXPQ9cL99PwqAEVI2Li7pPzbHuQCr/5YUbkwZJy06ohh2pVQBni
spAUjvBL/y5i1pljUMc/bbc7NR5/c6nWVzGepGBLltE0gc4mVPpyKBiIkw/E
rg7ErAxELw9ELQ1ELtJU5J4tpWY/dPqfH8uzm+sJXlxNnUPZGBrb0JAizQN/
aR1neCZ2XzrqhbtZiGxGzgheqJrH56J0YfZSZtaUXcwO94p9XjI9wb1kobih
yxMs5b6bKrD4sT38wnCZw9Rg6IwqdQLFA6jhdLhMNtfhCT6v0lTGiU/bHE6P
Jd5ebPBbnX68ypYsoHEE7Q2oixTwyVek0neg/wj3qhDay5dGviw+b0BT0Qc3
l9ns6Yi9OFztNDkWPsmmj6KUE3NlKA3QWsNnCL21+fCeWRszdYw7OCVqpBRq
3iOpxtRYXivyW3jqLWxBUQuKW1DSjDI+jyNv16d9pqcWfW9rcgLYrlQsVxF/
6sgshqr+N3wKjIDnBe9LRhAKfpnbWxtr1LRBLx03K8W+Thw+rXU2hbh9npR+
LLv1ct6MQ7bKJxlhEQh3Unrq0FTszg87zU/Ph1lrSoPYgXQoOUg6VHxW6FCT
hpMk2sIsm+oP7565e1md4Mk3jZkoA9vBYoSjhlG2N4OzVGd09SPFmgW++sSM
w+vuJYcctK2Al1sEwp8JVVT6lBlNWdBU0cEvZdZ6SzF2bFUYRrOgrmXRzcnJ
AXSl/7t4og3p7bK9pzTXbREShqI83pexPMYHsNnVRSFy/gQLAnpoqpr+Yf78
RXi4Ie0hWsow001ydZY1Ks5yfjZupT6r7ZJrMRa+tSYgFD1jWJIvfSHKeu5M
xhp9VOp7tDnPvKfHtX85oodN5Xa9AkVJyHDkzhD99eRFE9bPg+9i0F2OxS7O
5CMZT/NDg3XBBLv/SW/q2ntCfcMW4eEozYesFaviIpdYzorqUPLHLj5VffdO
/25OHl1y2mhN68K7AjIFlswsVq/oHuYzp2/d3Brp9EOFt+5I0G0FvbmJk6WW
1xDmi9JUDNRA0SfI0iWFLPvfsKZzvddCv9dF62nOO8P9IVIqUd+P4XneX90+
2kYwQ2TT62RrS+j9ihOWsAtCbDYqmiEb40WzXKWRalcCXqWaOsHrhqd37MT+
+ZRsTCxhpD9v7bw60JvKjXfK/E3n813kvdGqlRwFahbQNoyuOjTGlmxn6G9n
T12DUyCSsvk0xpFRrC7xSVArS+OC9P8jTZXSZ9WG9/moYVoVn/3GR+dV3Jtm
E9rRMox5DsGcbtE0j7yGixuDfb94uNMc4c0YV6j5zO0gN5c9Db5G0yF2mqgg
xKQgppRT7pu1T2iM7+BBJDKL0NpJaivkUCuUQoXM29z5PksxdkRne0wJ/N9P
+4shY2u4Z4E+ubTHGRZJfJ5v2iDvq+PP1cscOl4SeLv2xM7bMA2HdyFSulA1
zRPPujoBclbXVRPwmBWizDRlbHkdFY38akm/iF/R73efPy33tmWzw9CZjYV6
4kbjw7nDbH8OTSXvO6mkr8AsmO9hk9mB+kn0rqBvVewG+Sr948AeR1g8QkAN
0gdQOYfyWVaA423bYmT3oo/bgBFc+7Qk9ERjiUXngHuXMrINaTXIy4yOQEwG
39UopAW2NSoha4M+unrEATYJiKxEUT/a5tGvEKuM3iDVlIwNpRu5zbDoU0OC
w0f798zzmUFlJDNFoNbTySLFaz1LspMxL2l78xUm9xrgUCeXdowU8Cj1yL4n
UPrGogd+6BjCkkJOcPhL+qPhE4a454akJNRXkmqvadKWYmVhrDdrz5HVa8EI
bgXtBNNUuNcjqh+xgxC6KJ5NwaVC0npW9M1Rcfu2114/MBh+Za7MfXUoTq7O
X0bdJNo70JL6JBJCX1Ycj4BNCQI7ETOI34rPcugwNqTueG7zSP/er+WMP00V
HjujvB2E0CasUau03kbaNU1Y+5omL6z54A/jj9IwOo/JsVqSv/OWtjHMfRCc
gbxGtI9gfInXfsaW5qbc6zThFYFNyJCN4qGt4BvieGHBri9HrhooQxzZ4ijI
8qHg3W8aTM5hhBOu0avml2o+ECXEboq5KFQobGNqPmc6v2OKPmTWVnhtD+V3
dfujYO2cQv2iPquSVc98h3jE9kDpo8MvQtp77tmrk+KAdPl58bKppqQW80qx
b+Sb+9xglYbQBmQNo4K0EWnxnp1LmGFzx1DVg4YKVEevra9ce9eSkTm4k5GV
jo56zA2CnecUbc3iSAV61agdQ1oJPB/M6J47Rl2yp2wTdtznVNQhvXvLV27J
LQx+I55vTkYF7aNyb3zXEKHXW2Y7POQ/okkcQH4bKopQ4LVuPdLem8L6pHyB
WMevkNKdZDcPtPbzHSx0xH6lr59IhHGexslUmezGNsdjRjQXVzA8gP4CUjX0
u90kAdCV/Ee2yWPnnwbpvavHb8MuAnGFqOhE/zTfdWBGofKuRdkARsegFARU
Wc/5jcGef3qUeSyj/XLWvEMa6xOPUB/4Ggl5XW8QkZ+9/+POG6dmIm4py/zZ
oWSoylm0LaG/D+2P1/XqlPYzFdYtpeMnlaYmxJe9+3NZbCIfl56b7RH5w7fC
udrYcODIqo0V4kJRk4PRJqiHhGyaJfV4LcHSSzuJR9yF+Dd/tsbR95KYTwhn
QW8XOHr4Hnr6qgvJU7zOno+AazEedqNoio93C10sziQguhVNw5gdxaWPS/2P
NRWYd/W59coju3hnY0E+8vx/I0C1qXY3PWtuqgl2R9Ej9JdB3kUiwfOLit60
n4YRab/a/17jo7rUBbdN15J33K7beZvTSGblWDBkBk4xT+Nlg/ZJ9SVHvvVd
XgU6ejE9C4UCSqVauEtyDPlj4U8xmduZ+i+Yzu+Zko+Zp3oVnjtPmXtuuZP+
pVPzESeaSjpwaOmGD0nRGloQY6u075II2xoHjNLeUmO2ZzDQbL7QVd4fq1Tk
yVE3ywPQnrPWC4Lf1SbOcL1wG14hyMhFayumx6FcgYaTuNIujFLckDcT3xjP
4whO3txDWVtu8o34KrLsRJzsUtyybYTGxReedqzr+bpzIlq+Edb97fABe9g8
QlQ1CgfQMo9uOSrHx9ewonOGunJ/o93jz53rD7mMnndcMb+huK7/hrg6g/2U
s8XmiLDvkkqZ9IHr6XLnJJswRLRh0pZZ6zSZvfPTIRNdha89mxuBnjysNAl5
LcsYq39H5OOiXnBUftgONrGIKkNxH18mMaxY70WXxpmE9UuxslYtd/sIFefw
ZUHS2aoGy7pJtzpNWAUe5vLFw8keimDddTHxrwX68Mf1fHi1IrQPhGL+hXg2
7l3cHOb/zeP805k917KWOePUPxZhnvA970pI0o9igjmVaOO56M3n47eaPNp2
Ofk9i9QdVjTluW9zqvU3lbG6rTVWXeM+3Zr4VmRVciY+UmzX8JRFfz+vawbX
B0hNRXMt795Qz/MhjbnRqrVOamIc3kJ9JhJ2JQjrQtLo+kxfqdwQMCTlrv8p
YijqxPs1zscFV+TMbNw0mzOKih7U1aA2mbczpTYD0RNeoalAmyA+PxyLI6Xb
mLxtzDcinu7tpB5f+7wi7HRr2c2eIe9edVwnMutQlIPcB3VXq+ot6xtutzTa
dDTZ9TbdG2h2GW3xmORkUYvvAk2lHP6oxfbEWPzNxVpf+SRvsC+haZw32Bui
3hJO5A+z+67jVggi8lHcjq4pTMoxIVetVVJL+5U/GxdSyfNHERe5x74fvn9R
keLKNsdhpgBsI/FoDo1wZoW6IYTo+U86xG0gXMHxtj86+VTj8dHTxnN6zMAJ
5msRE7G7tzVcPzQSbrFY7q0ceaTSFMv5xIauTrSl1+ehrhC1xagpRVU5KipR
Vo3SGhTXoaCez5Pa/+PUbVOVYGqPlkHTISSUj6t70n4m7ICJ5lQQ7PMR1YFs
3muON0VqkvZ/lPJNAQdSnktyvX4u9N91JKlXnKaz78Cy7W0khKAmG6MNUIle
Sjlme8eao9ZplaTGguNmeocoe7ttfhx77ODMj+UphV0A6+YEVxOBvt6iqZzd
X45eMVSF3OfdpAPFfNkgRlhMz2O00r4aN0phnMuKVeU01bjzsPKKFYJCUciZ
xq3ENF7mW6U96aUh9RhKpaewZmkn6395as0u1LmkbeervjDgwOeYsak9AuOQ
X8bnoUyT0nKVEosLQ+v865+K9OuuSyV5fF9k4YW2UU5jntVEF+NxKlL81WGG
X4ljEmntJYNr8ApAVhbamzA7wuc2QMGODxaL3bKOKc/a4348kir4ksDBeT55
r39u/Nfi3kot9mev8x08FR/72U7q8m3KMeZTz4oDPjIDb/rdxtNXsNcGNvGI
4uySPr6FaL+cN4SkutYnItypBn9q8tEZvOrOW5RYXUDRMGpb0ZCHIvev1+jy
wC1YR4BbdVk3emYwocDIilyo7dC2gnEsPCuQ2I/CaaQMLWO85Un9y/P66Qtr
ksoBom29SVM3z2wMc/s8Jf1EbuvVghnH3NOXYZuE0C5oe8EyB74teCFuEFIa
2CGsbGO9/oFpbwu1mQuaOS1Jvsx3ihzkBE872xr3jUBnF9SngmFfiKhOZE0g
fYwllPPSUV+UjHISGqgIXouBf/qclfwdWYk0jvfPIk1Enf+g1PdYa75FX4/7
wHJUH5vWjkKOK6SjwM/5kmKmFBgeWSf/xIjClp5TjMrZERed0DgIvjB5XCjK
HR9tjSPxuFcdCiFb5jSu8TtCJQHFFxCRE8SfLGlPHKldIcD+zBrut+hNxYba
A36XFvPdlH2x6pU8FWqX0D6Knha0p7mYKWZ52IfXSemPRPqu2mXA3vCEsQNf
wccqFPOLfNXUwvKUEEPdQF9jk3ogV4JTIIr+dKVzn+nE6XMTZ5i1bgDSaoFn
wy7NZfhHAfYtLbonV73usNnh6MzBQgOpLpxQ8WXwo1WulxWzZQR2qfwksL9K
H1k66QFDO55YWYWydYmvbBagFm1Yo3g0znBEI2/SiZyyCNU4eLMut+ZukVwE
fjppHzwpfxFg/7VI0SLMVN2Bc6y9Kx4loq4So71QCFa6XL481eR2RTnHwzy0
Ts4JddN6Nqju5aBVCRYtB6cxTfkZbU7xr0OeYVWPbc2KbyVi85Ecj4d3+Mel
mZlS76IAo7TH/N8LsJ5SG7vDL43Pa2se5ivqOY42vqrYRzHuV5Xz5TygkRRD
YOVXKNZ230ZlD1jlX2D03EnlXfq2NUB/qOjulCx4RpU6iVIZ6utQE7/7J8H3
u2fDdwtmD+FTjccynjcVzeAAiTvzAdcPmeZvmF5tpvNHZp28fE/Yf1IpfsYS
5V0ctOqKd5m8rcyT/U/Y+X7HxeNz/rc0BQFsfxoppe1WY3gcAyV7JPNJZakA
szTD4Z9FijlvRt0MfNcx/3uXjpMuU8b2K9euKywNZkzXw8l3PRbinCdIa6gw
iknnbLyNzJw+03uUEb7s8wbxKD+mv5zUN4KnG7IeoaMCC71E3C8reY+y9Lsa
Uk+UAK80A5+cV06z0j9Ced19P+bhnpQ6w4wxq3SFayL8IxDijoArnebrod4m
rpPHrjVlELXVpPhPFzv3XBg9zoydYOBq+KSrt5gV+ufZQ+a4G4D4HFS3YmiC
Lx5ZVWr2PQPLf8dd8tAKEP/hacriIH1w+t0s19016cZtbfZdc4EdmgRSk5af
hhz/1UjDdTrE2jcGjC9QDg/ee5ClHdiuEzRj7qu646xxtJBbM4t+DN/fh+ex
gs+LvgzDYHgUILkLldNoXsaBZ+D2r6GUZjm/I0KbrvNlh4feRKbdYkfIykLq
Cls6h8ZhtDejNVNTeG+d9bhZfM5oF+Vvsf1x+N78MqOSwTulSp9CRKYhIRxx
d9kcuye9uQW5eSIBN8rJ89IvoLy0DlJpV/hfiW+sOrlv1uW6Jt0PrSmYrSDN
rIZVmJjEaP1crf+6b3tsEp/z3kflW9HNsUayGoeR8ZBRvl9QYTsqOaU5djRM
70k/7/OS519cB5n0O0m/FHeudM9Jta094mNQU4SRdiiEhlIrSvVcj1RWbxSh
erz34y6rs3OxtuqaYIynQ12lQccS+gfQV9oSb0S+jsPvuPQLJuuh+uOzoHqN
Pqo0vg/fRGRXo6Wfb72/qMCiUtM12vrsvg2vkPowvkgwlJSxJ1MMkVhv8bEl
KlP7hxkLMzbcm2+yNFRJ+jHzzpcVTLXxIUWf22I/RGEWG+IZiuGYxlYRu5ck
73xh3Tr+U6Qjst+vat/CtXgEViGzH1UzaFhCwdjCusrHdwTaJVR+hzoXu82w
7HPDrl26w4eZ/gNPPFN2l3/o8HMCvWvF4Ba8w5CVj7Y24iFZhlqJ2ekOFaeV
tg7jYXAbzTz5vsZREqGI28j3UGz/nunfzeR8wKz1k71KVvsEEogedrKS//Os
HXnxaByfg2lVJdTEPfkCGcejjC5S9gEfeOXv9uvW85u/5qGyvcvaG09eFbNd
f0WyCcOsTk6GByK7HsXT2HmTL4uJKEVhD9pm+P79vcuqfc7IaMI8t5TeZeRl
yi2YtRxKXo8wukxZB213LtT26GHc58wclTctFDd1SJdW/pxZ/I390dKSWsXb
JNdvi5RgtJcKuP1BcuyBvBrT4nGHYpVfDqISkeCPiKuvr52yM9uynUwV8Q9R
0MU3/Sc4e1nbm1e2/VqQMEQyyYVIbWApBgaIu6e6gX1wS2vNb3T5MOVr+/7D
hH0Zdca5E3dyVN4pCItC5P0Vd9KJhgft1jN3SFiPNHNJup6fi+95sJ8qtNvT
mnRJ1uQ8MhsxzKb3oaQJlXkoCRR9KZS58Z8avG2RnIPiIdFf8IplEup7IJ6q
hMCW7xmxhzIVdHxrvtMevpVBq5NsPqyPTWlHQTWfNpbpsFZPQXq6/tXX7QSo
//s5UP9MfEfKwc967PQXkhz5tsCzOWDr1Oiahawb3VlEO3x5J+V9/cBgsBcy
K1EyKa73Fe4AZTbz/aDQs4zcjFVzRswWpnJPftlzX3821UHRFq5ZyFKzNSvo
GEdvIxqj/kU8QXZPQfMXTP+PeNal31YgePoHjrHs2jl/2wJxAajNwHg9qRac
ZrEwV/OF7kMS/xAKXZIoJmcTQ7hLIre26EjktaJwBq+ucR2h1VWokKlD5OQ/
cKdnUDg9VfWs1w1u0BMNJnUTk7aRn86HOndk/6K9JZsYwLf0nq4j2vuUGrOj
8u7k34g7cu+Za5Pmb0l9CGSN79D75Ma28I9BQSnfsnxuGio5Is/L8k+mavPx
f92AjUY5H5u00IbDR3T0Pypzs0RiKopkSB1eIavjdcRTpJwtaZNu1ef8V35k
e8U1vsOdtAbxpA0h3t+GOhf97oWSzy907dYbOcIMHGKmbVOR03fdARFxKCvj
G3eszPAdLTSr8/+0ds6OUHxKIPfHRdwtYX3S7+sRSfOS0HvMgf/4ECO1k8iK
f7HbGtZxfCizRIb2ed41YGACmtI7Rlnd2+rx+NuAhlNB42Z+SmtX//tIK0bJ
uGi1CJzq4nXqbsTH7uX7vAf0PZavOWqszRW3xPX+cr/LkzO65POeZ462f4eO
/5y5l9rWgbU3nTRnsIQz9+HyGI/rUDuE/iWMKkEk3Aaio/JJF+bETZ9CErOz
NjMuf8XrpN8eIfrIq3vWUgxzt/JdFZs+Z2I3rc+VFHL2aXeY58C7FWH9WMuC
dj2/OcHn+5w8vZKe22XLnkUIz0RCTPEMJlyfUNn1Y1TwvR2Pk4/mtFwpmL2X
qwlIRVQEoh2G7Biyek6WmQSVwvK9pMi9eRXGxcN3i1U+eYh6jIQgRPIsnNaf
04mBUwWievF4DGtf9iAGLUlyNPCmLmV8dLVp5+XhExdmdJmeIwz5Wtpf1i/9
TiLJBeY9+Zcps6Cttwu+tu08YjWpf2354vl543UngEiCNy+Tj2JoU6mmX9QH
6faV2IwMBoypkoZ4ll9ZjaokddrNtVWHn9lW6n64Lcu8v9tjaCVGxmZ18s0c
yxPVyZZk1fx3jTgdzlq7Od64v86R9HxMlfF5QlVFKA2JIjS9FglYy9DXe7po
I3cLk0IxrMs9uBhpOYojBVktpdnfi1DpH6ZcHN4NTdoV36j/aOJmgvJ+BPvA
G743lx2FvXhRmzSPs+HrEHTEL5a+c2rtUzB5X9ysP+7XfTll5F41vanB9PBU
0A1ViR87yIfygLZVPiNkoFZe6a1xuDhwkKell8U3F579ftD94pLQipcvwm9a
Qe8Y+muVld4kzvFLQiUmHJ/ft6PbWmc+/q66LhSTmdDUaNA5D1kvenJqjXKq
T4SV/WiX+8H5RLIbTzzZx0nW0ZOMS/67ZW7UheT3TWv/bCI7pD9xiuk+wCDZ
b8mfWft6nZDDuvbFgDUcPdDdku61i08h7LJvXgpoZBMqkZ6DrEgkWb0knhrm
ENkebpPytjHVHzKV7/OshqyV7y5lSboTpn5gWrHbue187IB14eSD9vm4yaUc
xVI1FjpAfzCgr69+4IzcBL6GdbmTZAXNK/ni1Fk5v9bqPCT6s06Xho/xRC32
F9ncKLTedibyoHALU/4Bw6fqzA0IOtqvBd8KTfnv3lRw9Ot+TsRp/zh3/Qob
6YP/W9iVBkWVZemc6K6eqYqZ6LGioyY6Oqojpn/Nj3naLl2lVS7tVFl2WZ1q
uRQFKCX6WASRRTZBRFlEUEgRUIFiRzYRlH1XSJJ9k33fd0iSZEmWfF/E5L3v
pc08KmJ+Jvdw893zbt57lu98pyYH4/XYGKBoqEV1zguUJqAyYqNWttDg3dfo
VFVvnlF9PrT8qEvebvMkajJ/IGiG2jeOFHOevZOV72UVe3h2RJLNpuy2ssQj
EZUG0UM2UUu3w7T+flyADZpKudIHEi9swSRsQ1bR2IiblMm3+roz3Gqy7P7C
QJxak6uCYopQMbYrUB+vuna962/kptTJnmbM3JkbCbs9Kr7x7DV0n7VwUF83
m7IgyregiesXu8zeHvNquRTd75o3EdQ4Hz+izllaqsRSK5QDmJxEzxyq5kgC
i1Dq617fEffMAjS+I0xKGr5wVDWis8xnVnVXCbCwjuFBNLxFVjQeOU9eIj8C
Y8bCj7mR/he32hNuQxec5i2uzl/lM8PXpUwEr3jWdNXGA85P4JEB6ZlV67t4
mojicnR1Y34WvWcsteubuuU4vkRQFmJfI+MlCpNRHsNVh2nq/ScabrU02BTV
XYyr/O6ebqdnUNXzWqNgU+vHjFPOAbfmkzdHTeyVluaTLAHTp+xkq771lDL+
PzHPAw7nZ1542+yimH0o34wqIfxWGc82oizWmqJvC2+ErxsWYzNpXvpP0l2N
5j8uhN0mJMt9eVgmARqOMBpNDaC/ANVDyK9GQgYCgy8xskefxeaeSW2zSpu7
nbwZGI2wIITdqD3/uOt6+oivfDaiR5U+v1S6vtQAVTdmRjE0Q2qKcyf5bPlH
p+jeCqa+1dT1R8h7kddJ4DC9OmNsmZf5RNYExRypc9zUvRTVBkZH0CRHThxC
bkZ+GVdmkNxnm7zkFS9lbIRX8PX/eQVecn6eD0/dgWcKEqsI7MhnZwKFd5Oo
VqgeB/0n02R4vcazLKS8Qk6a6DeiqDfLqD4XKmXMz5JU8pPEo3GKC0nDDs9X
vKO1skff0wpRE8aKZVylTPrlz6plht25LiPtwROq5HFO5/Mp3qGuGG+Cbwkn
EM/XIsZzUn/wj1Km1ZDVPghEVjpaqzDbC+0MRQUuK2cHS2amqUM+xKFTc31v
fuTZqrf2TYP+zZqoBqTLkZuD/J83k+yWFKQWSzlISFm65yCfRUQP9GeygG3Q
WZelf2Gb/8p2HWerD7F+tYjsAd8T6F4N3k5jfIWwZBBE2fh4knF1jUuj7qel
jasRtHwLzk/hkUm0LJy+IXApRlgb9Mcwm7mbVXzOth4lRoY+wiv51CkDsizE
vd/+0Vx1qEbKPDBm0vyOlmZcqm52rxdqYzILHPcVuhytdZN2eRhNSJnqK38f
k9ku5wZx7SlQlQHNmyS7MtyJtlTav/PXek9UIu4/RrX7eym76RxCaq3Lm9Ez
RqoLlzYws0xadZ8Kh3clsgdIvfeNE10xNpOVD5SjCarN/HlUjaGlHe9KuIrg
xjm8HofeDCG3s4Ut4/psr0/RNwGdxv4z1l6rzjd03kadAfuebY51L0fxJDzP
9qU6TTcGK2dTF7iSadQN8Or7h2drxNj4Mu5p+71rpL5DpndVts7LjuZDZvyt
TLX8ezYFPq8RnqXT8suLn9c/NB7Icptq4+tmSsdR1+3jDd8g+D6Dbzyku7uM
L6zev4vMWDQXYbaFlkYqdS7J9FhLosRJeCc8m+oB4dz/A28j3odnFmWvHkOd
isCkcvv6eGznR9K9HXYm6igvbUUsN1yAtQbKizyuxETHeutzcY5cv+8sfmBk
d/ckpkoz6yyzJ25naYLSERGDmABtmIVeU1a6H9DpI4MelqvJD7j6ZEy/oZCl
oXVMjmO4/L2mPK2YZ08OJhf9mNFll6nyeYGQeETI8NROokcQKIy/mwiwX39N
s9fKcqBNN80Sxvvt30B/r7afMufcAxH/EvIawkKpXsDmGlZXFiQOwl7i+b7F
DKt85MYmj9BYB77Tr/AcaRJhpnYJCH2MwlfoqoVKCBlzUI+LI8SCJpnHRnty
H3xXm2XV2urbpYzs5NKbUSBHWSYKgvSVanbGzNOAA2nSEwsOroiOREUBhlqg
GdUdisDKqmaqTh9LcJEySU4HSmMM6+XOrcNBbetxLXhdhaI8FEYI7H1M6zkj
jRePiCrBZCvlF1Kh/iCL5JwVB2uJgNb8ac30ER5mI6MJNWPooaxyEltBL3wH
CzEbKNXLDv549adJg9xdpI+cC8M2HLu6GfCUgLmne1OKUN1GbMaFFcJAPL4w
ti3er+9bkWVyqCOQncr1UXdE04iuYgHvRggO791Lqp3fSpmfTfeVhZxvkX49
feE2Ap8jS068yAkloaZWra1T+4HcNf6CL01tG93c4ad3V7l+PxB/Y7ZKph5L
XtIWq1A3gbYOtBUJDCuXNu0fIPIlSmvQPUjy8Y+/Kc7/6iHRVVEXnoQPnmH5
aiuTJPgq8HOP7gzlbLClIyifNRbnCHfwXAsBjGU6oYq81nvGnDi4hiwXmYCm
KqiGjULgX4i0dpRPoVGNyjlum3+m98YUBqfn/V03Xz/jWrMwXwP0cMRNnJ3A
SPlH/DqYkivHB0JtVaWydek1zioeoXJk9ZHLtXYRDYfJ/aWza1N2seX72JbD
bN1BFlvyCbrvSDl5cNDJTBPrx8kTMVKC9WbaPHZKickWGqn5+Lw/7mQisQFl
I6Q+zuTr/ve64qqXTlOk3j2GffmZW90Jt+GLTvOWV+ctWUthP/H9gMQZ40/0
5+dJxsGV8Y/7MqzibPjA1Weqm8EbPj7cfVulG6tVjwmoHMN0CP+n54jnb//v
jdZv+yI5CTXlGOvC2jQPl1iZGZFLBP3sarxgtCLz5kGq1+4wt/zsN5Q612ak
S+3guupiMWTOxu3zlp+4N/CTl8rWdcXJYtic95w+lB6bs7qBJ09RlIPuBiwO
0UqyVW5joZf3H3dY58OrjjyX9MAwr5b3fWViGeKy137B1h9g1XfjtEFhXKin
2peV6PXPd806IqznE+FtOBsyMX5fZGUaljQ7vp3xf7MRUYCkdLwIR6Irn2F4
r0Pp+VXzAIRkIK8O74YxvgjlBiZWVvhzcsepK9wdmW7ZNy8z4bqn8rFdn1Po
lt1D0O4xjxFhl3XuVZttttInkwtLQlQIIhz0XCIHRwxuwicWaWWo6STWnc6D
Ua1zQh7xwDC1jVl7xi58l1vhEc+2cx6TrJPaxnLmKktAZ7kpyPShucH3KJ1t
rI0f69+/lIkx2V0h+6E9z2mwUza6+HyYy+tFRROqiyGP4iPnH/5jzU7c9RSE
1eAVBVgUTXNCLEd6VnU5WLfaRN6f0jkOmXvYqgNs21ds019ZlEZow671B3Vr
EjqQo9vIxSiN4j3L30hNVKaReFiGF13ENKpW4T+Es9nagAnw3h2Zevx5rWna
mEuK5n4cFxKCsJuo6UdzLeqTLghr5PtMipEFO4Q1BkmZokvfDMpsFvMCN7uS
oS7huEYNwXQNdqGnYFtG6HfC6ceeZ2y8mVtp+31rTvkNX/FW27uuOluO6pQ8
Xj2YsrZRuoqmeXT3obuUz/n8K99yJvB4eZZZXatnkzKsUZtURZpV5sdzqY6Y
GMNgqaGw//jetOJuT/8uPHOYdGe1wQ/L/p54FYN3hZhrouUVs4R6gZus3YZS
0We1yXN7WDDhoYdSi4xedTtkLd7LQFgionQ7zqEwnnSXWWmlrQ7mlzHTyket
/o2a+bns4ZZg0+E8z9nO8IXFjHnu7SQaetAqh+IplleWRytobySib77rs7h7
phDdPz4nvaC96Y+EF1BUEc97aR5aDcGY9g/Jf4lridquZAEUyp1kv/9ttFGT
3LVj5FHnxvM20p6ttAAlkS9fo6kB06NYV4PTOfZznRKhanRnk+mZWZnzZm4o
154BVSXQwRFiocm+zY409dqa5Izw3HzX9mOCrvieVdJDYya3YHQfD3QeXQNq
RwjT3+ga2hcWf5GVglbvkKPAgDA7UjJ25o50l8Lx9GCco1IRvDKWtqotW0Lj
NKk/6Cx+UoDCdlIOOLyK/hUtHx0lOBpD0w2/e6SnYOMbTHWAm6StGZfnmpeg
zzXSCr5tjIr0Vvhn6VXOJhbnfoZXOaK7CG1qybhyGzOlnunrV8JtxZ4jp6NZ
4l5r+RFrKVMq3d9vy2qi7pMSg+E3WG+jJQazKky1sGl4WIf4fp694F9OWnDO
jxD9Gm/q0TOM+UWsbmB6cVoq6ITu5G0chTyaxb5Uf398Khp/HzXS3dvW5oxv
2L7QopOR3eaR165vSg9NmNoj+Cny89DZhIVRaCmVw+p8V+mfCZkVn5/5jYEM
3tlIasabMdKks0bJ6XsPU81t4/j7s/D+eWYunp3Fee+rhDNl1XaVE/crNyLL
kJp12gHu0Ugog7yLtKad0mBCo6371mnIyHbOjJ24LHBO/Mo8V7+2vwmaoEgb
iRhvI46S09Pvd1LG93um5Nbf21NtRxof0uaPBSOo6kDD25MyeBQgpg3Z48ie
xBuDxAHbxGWvaG3QIzx2GXdn7YXvo6gZiZh5T5x10H9f2Kn93e5XFlP8uIZE
zJZQ7OmAGmP96M2loa54ty8Kk42r6l0bph81aOMVeFWI3Hik3bwuaJUiSmjm
mWhR/D2CVr+asXdEbDgU+RhtxgZvUC8vKgeLpMyTs3sUd871vXCebg5RKl8o
uTLazblVgdooiZWwKlrrs42rTZzbEr7t4KixO4ISkVNBWOynlVjWGaiaFXqm
JJ46PORhtZYayDWmYbaCHg6jGkwNaXuzJRbCmihPFV/rtmV2cf5P4Hux2LCO
w5NK0ke8Rom6RT1z6rcL9jcRE4XKYoy00WjCEiloYoUV0aoQiiPYOqc4Z/ox
P9eXg8aeeJCMrCrSimycFhAOL87pb3WK/JGI8UjijDK9yT64EgtZJV72E+xu
5sg6ReIQIUpuQc9G8h7F/3tD+CYLKiXGt4jRBHbYgo6QnBeNihER17AFtSAR
o1LEyA69JetApcUcdGLEipnwJM5U+kdhdWIpU2FO2mFWYiQaFaOLLgrSHlTa
WDQqxk4ZCU9wl0pfEI1+Kvqsx+z4UOmLolHxeX5OmPs+lTbBlrjCFqnTwpw0
H/n/dmDVY0hkVFrc+1R8Y38rPEEIlb4sGhXbJceEuZ9QaXEPVLHl9T/C3BFU
mhWNijFGh4W5o6i0GbagJbZIfSFIxVEpC9GoGLn4ufAEz6m0pWhUjM3cK8yd
QqWvikbFKFR9V+N0Km0lGhXjbf9bmDuTSlsLqxNL/ZcglU2lbESjYtS2HvOQ
T6XFmCExivg/hbmLqLStaFSc0ftUkC6j0naiUbGHre/WWEGl7bHlRhbtJjKn
gkqJsUHiuI8eHV1LpR1Fo+La6d8KczdQaSfR6C91tyDSLVTaWTQqru7R8wG1
U2kXYXViqV8Lc3ZRKX0fXL3F1kf/SpK1H+g+DdJPkn/6X8G6YF8=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101867367],

Cell["Structure an engineering matrix:", "ExampleText",
 CellID->1279748360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/Dwt1005\>\""}], "}"}], ",", 
     "\"\<Matrix\>\""}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1461987012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56592827]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19760],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " for hierarchical-style drawing of directed graphs: "
}], "ExampleText",
 CellID->178337475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun1\>\""}], ",", 
       "\"\<fun1[a,b]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun2\>\""}], ",", 
       "\"\<fun2[1,2,3]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fun2\>\"", "\[Rule]", "\"\<fun3\>\""}], ",", 
       "\"\<fun3[0.5]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<main\>\"", "\[Rule]", "\"\<fun3\>\""}], ",", 
       "\"\<fun3[0.6]\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104551000],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {0.04835996651265902, 1.951640033487341}, {0.10455097716174719`, 
    1.8954490228382528`}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.24042613086921105`, 1.759573869130789}, {0.32011027392758673`, 
    1.6798897260724133`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.5029716924536255, 1.4970283075463744`}, {0.6061489679212887, 
    1.3938510320787112`}, {0.717157287525381, 1.282842712474619}, {
    0.7765193382916591, 1.2185423901034025`}, {0.8288976183795514, 
    1.1513492952006954`}, {0.8742921277890582, 1.0812634277664972`}, {
    0.9127028665201793, 1.0082847878008083`}, {0.9441298345729148, 
    0.9324133753036284}, {0.9685730319472645, 0.8536491902749577}, {
    0.9860324586432286, 0.771992232714796}, {0.9965081146608071, 
    0.6874425026231434}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.7}}], 
      TagBox[
       TooltipBox[ArrowBox[{1, 2}],
        "\"fun1[a,b]\""],
       Annotation[#, "fun1[a,b]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[ArrowBox[{1, 3}],
        "\"fun2[1,2,3]\""],
       Annotation[#, "fun2[1,2,3]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
         21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 4}],
        "\"fun3[0.6]\""],
       Annotation[#, "fun3[0.6]", "Tooltip"]& ], 
      TagBox[
       TooltipBox[ArrowBox[{3, 4}],
        "\"fun3[0.5]\""],
       Annotation[#, "fun3[0.5]", "Tooltip"]& ]}, {InsetBox[
       FrameBox["\<\"main\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"fun1\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"fun2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"fun3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2089298815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363990941],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " for different types of tree drawing: "
}], "ExampleText",
 CellID->64651062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "\[Rule]", " ", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "7"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599520976],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.4748737341529163`, 2.1213203435596424`}, {
    1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
    0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
    3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`, 
    0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 0.}, {
    4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
    0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {3.5355339059327373`, 
    0.}, {4.949747468305833, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
       10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.4748737341529163`, 2.1213203435596424`}, {
     1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
     0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
     3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`, 
     0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 0.}, {
     4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
     0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {3.5355339059327373`,
      0.}, {4.949747468305833, 0.}}]& ],
  AspectRatio->0.6546536707079771,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79635200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194382608],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " to draw graphs in 2D: "
}], "ExampleText",
 CellID->335683558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "200"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9126831],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1W2d0llWef5O35g2kkEqAVJr0XgICEQgoXVFkECQLERiKEBxgsSAgBghN
JAZBiiECAoYWmjg6gsowxX6OOHNmnVn3HNmzc44f5oMf9kP2d/+/+9x784Cz
+mE8zDtPuc+/93szqeKphZVLK55aNK+icFxVxfKFi+atLCx/sgqPggmBQKAJ
/2vIDeC6GVfyv6bmZvz/v+63SP1Gqqv/HAicX7jwc3ORpp6HeTt48HX8Vsz6
MLDG+aaw8Nd4Gg2f40UsdoHfdMi7hNuEBDBzPhI+p78pVL9JhJedcf6Jnssv
XfrvwsCL06f/gQgDrZwV48ZcK4lsq6r6Er9TJ36gV4TUiqAhMfCkA1kTEW3a
nJb291u3dhUWGrI05IKCd3j/fCDw3Sef7O3Tp33uBb2CkA0MDTn7R2Qjq5NA
/4CujcuGrzs+deqNHTsAb/eSgz3zDh869J8aI1b0al//zMzXQM3VVasuL1++
tHj68CHvqhUCI9p09ltwuK/2Fu4sX/f4+BzpUKO5iDZp8UebIvL8zNy5Z+fN
axg//tCIEUD3j+++S5HnP3z//Z6uXQ+UloI+vP3k0CFZH/3zpUszOq8lgrzM
s1oOHX2YE+U+L+ucfu9SAu5KB7xdUfIEmOhTeHT1lN0COfy/P/zwSs+eL8Ri
wPjeunUBsYoQEL9UUrIxGj358MNRoQAUE3EkdPa5satHjfpIyUUoiBnd4Q7w
FuTcf2/pb/Ca+HMc2xzdofp/vvoKLAYEauiZqo/wdFBoGT5LF+rHJ83Gk8qK
3weEvhhewEY2Tn6+S2otiDbMih3FzS3ujtbe6NxqN9Di+sbOndBfmeDPdCx1
1uTLJDacePpcZSUIATnEpO0pnNAYaCP3WUlHtRxJyRfHjkExO9q3/31dHSwy
J+UkX5MSVwZYeerRR3EBvQIFlOpSYgiYnz4aBriyfMvO/PzXSkuvV1drSoyt
akpemLqhX8cTSt5hh5dBwaVHJ06E9UBzOxe8qi210LNlyGLX+g9wB0FAHOYi
cJ+lJY511CQoBVuHR43a1rbt2OAMCpXUfPPee3iuLqkhWALMQ5QqPwX5V7E8
lNAIBr7/5hvGm1auZswXgANoEDlIhmJJSZ5YAr7MTXtL+UjkPPHiCZizePmx
LJYfiHVlr7mDepwD+SXqSTIpoQ5oAbiA9WAlvP6r06cDQZ/H3CsUtBN4kMXI
ER8s6vcrqI8UIPQ0y3/0iiCohuLlUn7AAuDCNwOdPGl2z37thYUncfftjRuv
DRlCY2f8ahG1YFXE3cGDBIuBkCjT4LbcXGjEYoYgIA51mejD3EX0jXuIBzjB
KhgGq3hNcimt8KnDn3eM7WD8fqLyk8AwwV7g0yj5AuEAZbBHjRzo3xpzkk+W
wkkUZONzEAu+z1dWNs6ejeXkKgoDeWfNmvZtLyp7CTXp74YKJW0caIq+ZI8y
2q7mm2pUl6lyT3bte8tJki8WtnXgq+gi6yOQD6hFkKvr1eul4mKoi5Ti4Z+a
mpZ3/QW8qk2al3ccSkMmWoAeoTUCc0MApZToakJYxNix8QShLQpJNi1c+PTI
FSOGX5vywPuab4mWceNT0CFgAcfnDQ1Tcpfg4f3daxkFCBdq//r8ecAFsYX5
V7RMh1hKVeQvLlbEji2qQU4Bj3E8T1TBPmgchZoOG18HZYgHlGIMn0AgF5cs
wUKotU3odQpEaE02MQTCBDCoCCpJSzjIggIaogUmQfuAcqaiAiAgBKxu2+a0
lizpzWi22QTxEZB2tGs3t3QHmYqJ3EE2bIgRlrmK13iOf5JVksHFqkolisGh
ZRvC4f2DBv1mwwYwUVHxCR6WlX1Ej8+EBAELvjY3aVhRQjVcH5QbiW9c9wVW
D4lVgV7Ija8QipFGwSwplsiUTKsa0qkBiXX5qI31o0dvzcxMCxyggUCUAZF2
CEBBGv5BKGJ/IchkRtdnyJ9UADqjjcxad2XlSqwEc/gUBEEtkF4iXDGQjOvM
2BvKQAJvIU2rqJ2bizdEqeSZ7cACaEABB7AW4Lu4dOmuoqKanByhoLVRWrpo
DBCR4d588MGrq1cDMcVoLSrdiWEoBMhXBFAvLF6MdHZPm701q9+G4ZBfQAVt
+AfZCeUhSLBNuJ7qVWwEWkO4eGOIB37wgjdUKUiDEBCMGJl0vtq76wtIBOxU
zVYVyYQJN2mA5JrUwXcAAnGqWfIxXLw6JWVnQYH4TnzPiiOqmk2auDk9/ci4
cWSWMoX4HF5jxMi4+ei4s0AK1NCf+HwI0ju85SpAgW1ldoEIzIyujg9ZZ6V4
+S0rfozwc5t1lofngxfGojBj0af19UcnTQIaxsw4DHRTPA6NofYAZgjn8cE1
AJOXd9VYYYYbkYJngCrVl79StMenepiR6VS10F4ihInZCCMf1tQAOSMM9Pdq
376HRo68vnkzNIdCvW3GGaZoHQszPHi6Hkz7Ebw9vYjHLIULMHL7s88Mn0mw
g9Nz5sBP8QiIHsqvMkxqXJ1/BHYP0RNt/aERx3EHrcPcGR9DXn5EiQvDhDMy
Nud3eFv7SumPQg8EEacgE3XZXbCwW2KFwRDpYlm77Bre9u2u1gzs964K1uNv
aMn8HCxGnrhjJeBgibbLPm86toSE85qL4T8Jfi+xNNYmuCRY3d3QHtHF8VfT
/dPgin517zV18OsG9DjnaxZiP/616efu+rWtgO7+tSuzn/N1X7lft+p3Os6V
/4yvTI/6T78y3YD+ynrLP/vKVt1rf9Iq3ttqbJF8lel7mvr/QGmtfkIwuOxW
b5I1B07IZGaEqtYO5EfGNAZSVfQLL5p4mF0W7gAlEBfLgrvBvWurGkwkVbQs
aDY1SgrhlA25iLiEUIpgg9hjlNIsnRRAwrGZceDezHo6yyaeTlXZJJzhJRe+
DUjWSWWZZJJK5eg6Jvb9AwceHD4crtAidzp0WY4RPQRWbEubNjpTJTTiAZMV
yCFdIBBk/v3rr9GZlIRrENxF4qHGo7dKItvQfWOBZLJUKIC1ADM8ex9kv03J
yYD2/oYN8BVrKQ5NtmcDLMQgUFCTm4vk26/TSeBjX42PQRbU9LzOYyEwwDYI
X0UdOOgRX+neHaEXsoGHTm27lIWogzHKSmhwdAUo+2jHDgBRFaPUhmGDCRpS
EhdsYVoYewXVd7kVLwcZrZIv6OmNg0nPS0IhFdVG5ayHbOTLiMGCO/ZUgidi
ekKigoOKxYXb5cg8K9J0p/zC5Dsz8woHMrpTMBh0J2F9gjnNdhb+TiPm82rX
8+zTmA9L0BcbiAXZHsWUXHpY9P1KgZovT20Pxp6Sec1CsfchDyo7k0CVQOng
g6IysLJfVnfMniIqAWE8Bp64XL6XqiH4VIXS4MwJej4SZD60VLDrFTUJnIxo
A6tGWAYndtKTRSBpmBNKM+OChAfBQDwWnu315H3S2VP/UZS4eXpswva8PCBC
kLFR/JcCX+rBJGO9kPwbEye+3KULyn0W8brbNrMhXd/aLlE8JQZx7Bs4cHen
TvPLapXRJJ6i6ThYorRcPAQWsLO7Y0fUm/xe18uqanLr52j4nIYPQ0KffKS8
nBUizBbkHdj3F8LPkjVmFvtY28cgMRgGCnnojxjqVh1HEbpi7Gbt7aooTaie
mfEIlBzxPEiVErdvo08c2v8KmF/iQDdxDsuof9o3Z4Rwbch4e9u2NdnZKqqz
74LM0Vzt6dIF7AoVEXp2xawPHy5eRUUsdnC4lfTwtLXr137MxcTBKAoZNEoo
YqaKIHYcmzQJsQuah4g8iiKmrzcFmQyKgtS1sgAxYHbTd5l9s16jTCf13Y9w
9e6zz4IPhj8739608Stl4w80YQWE/eWJE3aFwIiYWtq4OilhpazyiUuJWWQu
SAn7fVgIhMrhjWFMU8KpCVYgXdG/O7S7rFd0E4xHdr7fJWWPsmpilDlcEhGt
nV6HIMD61LRLdu6N+/HDVcTs3+edFiu6+TyPkIuFF+M1ppTmDIFzetanKr5K
feZUfxLZou580D+PK3a0BrBGVmlO/Gadqmjs4visguGfYRGfGcDjjrK0M7hi
X6we6fNSE4vdKVncNHi42zJrO67xLQ0GZLDeny+eQht5PL8CqYvZg5MwE6GT
TLYxCS2n9YkW/ckTIhMzOsUd7UQiWDL7G1ziF9cwkPUTnm1RbbFTlDwYNllH
z+LFp+IA/OXx4/iF3EAGkRhH4/eSVGLsoIgTVGAxzBG3wlscb0HX+cpKgPr+
r3+FzOA8T49cMWzQO6ZjJRzTD2LBS8XFYBxyAWUCJwoqd3bosOeeey5Jrw/x
q+ky55bzRIoUtorbopEUvAfO2m7d6seONdw1S3Gw/FEVswcmLoFdXFm5MijT
L5PWAoMt1ExGcsRC1E4AB9bAws09ex5oNVd1N0OP7CooqB8zRg2DYjEzh3Hh
sphTunPg5rkdCnIjdASWQKAZfIBqbi00y/SgW8arj+XNJvOQKefBBgghS4YI
4e2C7PHFoa14zm4a6jEKwDUi/+z+1S0sYaGXFaABrMAvUhZw83vm7haGYHad
HEuKYgU4oMXCwzlH0R09d25ojSxHrIcNsd4RN507cJFJKo5dKuO9cQsOP3z+
pedRwTOeDVoLZ/tMiiLzR+3hx6Zxc6A4/i/WFDb7JnR8DcPEDrO81FYBThTq
7bsv8LIc+WCS1fWHxXyvhaUjViR8rkWElAlBhDMAUGFecJJjoqwR/hiB6O6B
IboP7XcZvQiemagY6OqsADiEj/6dT4EkOyeRmWmQO3Z2t9FO5Ec7mHQ+izYR
4Lw5vwWPyE47nnmPmJJNfoMYWEn2y9s7sNsZG7E4sbd2R3y2Byc+qemTGQnA
GYIM4qx2YTEIikFjVbPw0NZ9tbdgFwxtWIQ3ZudIY0VtqbMLsbK58WGNMwOj
omU0/vehi/sUvDEjZRotV3JnHPL5vKEBRCwpmNYpvgsdGt7+ssMUsArwYhVB
DrsUz/c50DmPGdH1EN79YuJFmOP1F19cn5iI3hDXAj0GAz01YwYiHiqzT+vr
aeCoqST3B3PTGzVXhOtOq9UWKgelgbf2ypCvOjX1lZ494TnM+smIAYh06Hdf
7d9//6BBGZEjVCmrbLVXwW6k6ey3WlYuFrM/gk64d34D0iREgnqRm4vqdEI3
h5qBCYs3xePAtbJ3Rde0Vx4Mj+cmg7LMeQ5UesrLL95krkAO3TdggGnJTS2U
bFjbkpGBmhJBCR/ADKynEarML+O0nrFFNWb8X7fmBBS0qN+v8I3s78efG7t6
QNdG2C9EzriNxabOnW+hhfLbX2HdAE9k/wVnhxkoK2StYisJs5NpDjc4kJy4
EPHB6eSDE/GtJ5QOzldqH6bE99UyWZXvrUJwUquKfKvYq9FS1bybq/ynO9J8
92EfFHaOhV52IRQT2Vq3vsRYRzhJpra9cxtZ97BFno0Skmn4WZJZOuItbR6N
EewLIjL1uYbK/loqwTDr5HFjrnWM7ZD5vGR16lXZWNyxMVTkLN7MwYfSQq+q
cGFSwagqPj5wQPU3hGl39uOefaP1QwQjTO7NgcKs5OMatwNTVe59i48/ljsL
TgDXPb9gAUoQVAvKQmQ+pyb472/cyEMmx6ZMgdVWP7JZz/5XWo3ETS3P7FvX
s2dNTk5d796ILKCBO1OQNUoE/ENVtq1tW074uEGEVrnKgeZWUEAM9HW9eo1J
eJhhQzq7JPZRQ6IrDg4fjjoK0VVvv8DjXVhm9xIC/dOFC6cffxy46e4wF1KG
iGp2rwDuj/v2sbnk9oFrLyYq8bQLWIKnd8vav2z4Ou7Waz1AgogteLRt7u4e
uQfRiyO+Qw9tgodb6KHI8zvovbbmY1YOEVPNgzAgQqCS6U/E3OKOeSzofa8j
KKFKlIgZKEznpAckMma4T/yZcY2FEjSzft3FGBp0ZsPnwKLuQz4ove7q0f5z
TsRiz2qwKzbUXa6qYiEZvit0OxnheztRvzt0njgBza/06AELffupp5Ste/Or
3p406UMa5s4Fr/ZqX2/6Og3T9rTc/YAESCgAmmt5pyBzcm8nXKYq4PGegAwK
WWPE3NMSWAHpQhSAKvIPcS+dTxI1dP8JsrAHXfsysZl69A5NDLExwd8HRww1
ED1LdU6IDY+ahkTf13KyS5/tQY2Er1UdTe2a7pVbliCRZ0wADc9ZKNhOodj1
vOAZSJBVvjr69/XXHDUpGcocNk75sJCZPOAgVI8PeBQLZiJU5dJfXlh4El8i
cBhfpqPwPJ2pS3EN4jndBmTQfrRWb8o59OkpyItLz6iRek7OpIwFwDgsZY2a
j0osjbGaQojZmpV1Yvr0AxsvEIpoLwXoQQRIAUEgi33KiMznIBDzELUVGL33
jrj7yJhGfAtDAemIhemJh1hWMrqhvipKqJ6aMAbqAygoFGyYdk7qnSiZzJYs
EZaTWGrGXGYxWfmzFvrb9euIyfNSy1AOz0yfbjJGHJ8i+u9o1w7udbisDPRC
q6YI7+F5GDKjinejLYaob6ccDT3oDCTuLCjAF08+qSfQsm+eTNtunD374tKl
b0yYAG+enLWoxeSJUyO7U3XfnbaUeBp57+KSJfAKyOW/bt6cmF6prTfJkS46
S+Z4LPrbtWuZMoZWRzJ9Ft/KhzHuvFezYJli2g7pzgvO+DSNkMbg3hcGZm1X
ZtR6NUcdELw9kUQazZSLNPJEw/jyD1Gl7Fr/QaETJdV5i7vTqCtOZE7SaHZS
TXtnT525NLJ6oo8DuikCbB2Z5PFiNDu97KQBb3czCiSmcB3KL+g62UepQFLn
JcyhWulyUokU/QA+Rp+wdnqdsS5Tq9mprnSXerIJwDAwWBLTr5q8mmyS4sgW
92ZIi8eGaOZunq4RB3f0rfoT7gvZildwp7qTcpNbyaZJD+agh6a30MtigKRm
WCHPi3TWT/HutdTDXobS0iWlbDzE1ZxcqeaTMR+l0j1kkJPx5R8wriEg4jFP
vPKMBYISVkMAW2Ztx5qHHryppSya0RW/pbrAoUpt9pIqm9E5H0GM+7fkezsl
7Xwocn/TokVYTm4QRyErI8eoqcS4x8ONL1bFcZD36eHDyAxuIWXSCqnL96jR
dVuRd4/PVMw21CHymxyaRI0hbJyeM4dgEZ6ATp2LDXp06h5LfCnDnDgCHIBm
Qv/09dchSHyHPPBhTQ0Cyz9u32bB8+a+P2gtks4OPl2yB7N7bxFfFEr33Yut
qLPHM7s9p9TZ5SVOtqkE4SoGQm5/9hkP53GWgl7Wqzj8u/9ZJiryqBKIwGe/
q60FF3v79oVRbM3MRBXNJyxWwTUHqIbCO04W+G22k49PVq0ApANgtMndC4M/
BRLVDn6EJ9nMhjxqfE704FnQAOAjq0teadbVFEtypGW1Py8wguwkVBwgx2Y+
CEYBH3DULva0abADNBMvxOPb27UDxwdKSz/avh1ezGXZpudyONZ/LxGROsbu
FptJNqvLOO6pL6R2A/DpkSs4U0v3/H3YoHdqVr8dSJSTY6yK8N/KXnOLg1v2
1d5ixQjbROkC2wPz1OhzY1cjQiI9CHb5OohgOaTPRWV35NmcdaT6YECgQ+1K
tm5dLiOYgQmLt2RkQNcQB3ihMdgTkg7PSaR0/byjAIGOcGMkwlm42vuV6idZ
79sH3qpOTd0/aBDWwZGhKXt+UGaaIe5ZsDaLexniq8ZGpVFZETb2AHmqvQk5
dRGtyc7eVVTkHhF8qaSE78I8gmEO72nKORekfaKOBJNYhPXw9y3p6XZeRPob
j95CjfVgsHxDKPRy584LyvfRiSzULE/PLC8lUvEEhOlO9CRBVmaxC4F2eeAd
i3hk8Uh5+fz00erwYWwC7A9PQBoMhwdcoMWh/S4rLbpcmPxPJ5xW2rApKWl3
SUlF0jCUb8oOyAWECg/eFI8DMOyFZ3DdUTVpC5tTBoyvzHQRE8lN4yGr9dmc
2dOuglCGyqurVx+bPBlOo+SZn39q5kxg+7S+PlGpMWgjRRuHB0ODOdp88+WX
1RZyMNhw//1KbpyzQay/fvppPOWp1Df3//Ge9DqWUQApFEXdXTA74WWPbSZO
zd7RZvnGziSYb3hYGwgOlZWpuKGOwUVvnT1LN4M+6P2qpiIXnBRSFt1bbe1b
8iYclHuxsBnKjhzQuidnLgzI3jIlzfEPQpIbN1El66xj/7Yh6kV01k3k0AyI
M7ycxM00Gh3YpF+hkgYt8BW2itQuzxGh5Dqw7y8teNETeNkRxcesPNHxcPeF
vHD7xOxnMaaZIp282Nm54iXRO4XtdO3k0f79lnyXbv4iiPriXyvw4D0PK9HT
8NDuuWdY+ltUpRN67TVOYit2/m0EZ0H42hSWmmLoNttXeZFSe/Yn4qtxgr71
5MTUmc3O3/5wK4ZcmT9GsTNEcsJ63UiQf6TRopIlD2YXptnbAoMSdPXY3otM
2g9Is528yt/XpBuaOeyeN+e3Zk+DB23Mc8udS6NP2s2ym8eymzRG3f1Ne3oh
37F3tVPrzi5UlZ3P/OFJgOULlLVg3P6ANxeOeppi9xK0u1a9ffrI970PO/eG
GhuLjDp4Yc+Ludgs9Km+e//uHf/S8s4zHrJx9C/8q9BAwv8BsHLO8Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107538667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7616771],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphData"]], "InlineFormula"],
 " for an extensive collection of predefined graphs and properties: "
}], "ExampleText",
 CellID->212276565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"GraphData", "[", "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329468572],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Antiprism\"\>", ",", "11"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "674", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "16"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "17"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "18"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "19"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"Wheel\"\>", ",", "20"}], "}"}], ",", "\<\"WongGraph\"\>"}], 
   "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{571, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->474834767]
}, Open  ]],

Cell["Get the connectivity and plot it: ", "ExampleText",
 CellID->322493678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphData", "[", 
  RowBox[{"\"\<DesarguesGraph\>\"", ",", "\"\<EdgeRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->724898899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "6"}], ",", 
   RowBox[{"1", "\[Rule]", "20"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "17"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}], ",", 
   RowBox[{"3", "\[Rule]", "12"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}], ",", 
   RowBox[{"4", "\[Rule]", "15"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"6", "\[Rule]", "7"}], ",", 
   RowBox[{"7", "\[Rule]", "8"}], ",", 
   RowBox[{"7", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "9"}], ",", 
   RowBox[{"8", "\[Rule]", "19"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"9", "\[Rule]", "14"}], ",", 
   RowBox[{"10", "\[Rule]", "11"}], ",", 
   RowBox[{"11", "\[Rule]", "12"}], ",", 
   RowBox[{"11", "\[Rule]", "20"}], ",", 
   RowBox[{"12", "\[Rule]", "13"}], ",", 
   RowBox[{"13", "\[Rule]", "14"}], ",", 
   RowBox[{"13", "\[Rule]", "18"}], ",", 
   RowBox[{"14", "\[Rule]", "15"}], ",", 
   RowBox[{"15", "\[Rule]", "16"}], ",", 
   RowBox[{"16", "\[Rule]", "17"}], ",", 
   RowBox[{"17", "\[Rule]", "18"}], ",", 
   RowBox[{"18", "\[Rule]", "19"}], ",", 
   RowBox[{"19", "\[Rule]", "20"}]}], "}"}]], "Output",
 ImageSize->{504, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1055785905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2304381],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{1.118932418206827, 0.8614302643777074, 0.}, {
    1.2814051849698087`, 0.9564592510505615, 1.048741645084963}, {
    2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
    0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
    1.1149246705226328`, 1.9111826126753004`, 1.4902134912823035`}, {
    1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
    1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
    0.09091614877600662, 1.8739446167829552`, 1.4709856545168347`}, {
    1.910569080333191, 1.7834384807872268`, 0.4663446950583585}, {
    1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
    0.8870163642106299, 1.8161307480763924`, 0.44053341978562255`}, {
    1.9100662154614163`, 0.036239322203641455`, 0.6233297089631952}, {
    0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
    0.14159245861518743`, 1.6219307272298191`}, {0.7199767897359262, 
    0.9554049272869731, 1.0452198797768009`}, {0.0032569172979363126`, 
    0.05177078200422336, 0.6278777332918799}, {0.8828287774210202, 
    1.0497397414724374`, 2.0947242724140147`}, {0.0034527989948853754`, 
    1.7688609578030021`, 0.4718824350898466}, {0., 1.0448427458263843`, 
    2.036310839181915}, {0.09152513835519904, 0.12788227463465096`, 
    1.6289154686138856`}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
       8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {11, 
       18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {15, 
       17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {20, 
       16}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.118932418206827, 0.8614302643777074, 0.}, {
     1.2814051849698087`, 0.9564592510505615, 1.048741645084963}, {
     2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
     0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
     1.1149246705226328`, 1.9111826126753004`, 1.4902134912823035`}, {
     1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
     1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
     0.09091614877600662, 1.8739446167829552`, 1.4709856545168347`}, {
     1.910569080333191, 1.7834384807872268`, 0.4663446950583585}, {
     1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
     0.8870163642106299, 1.8161307480763924`, 0.44053341978562255`}, {
     1.9100662154614163`, 0.036239322203641455`, 0.6233297089631952}, {
     0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
     0.14159245861518743`, 1.6219307272298191`}, {0.7199767897359262, 
     0.9554049272869731, 1.0452198797768009`}, {0.0032569172979363126`, 
     0.05177078200422336, 0.6278777332918799}, {0.8828287774210202, 
     1.0497397414724374`, 2.0947242724140147`}, {0.0034527989948853754`, 
     1.7688609578030021`, 0.4718824350898466}, {0., 1.0448427458263843`, 
     2.036310839181915}, {0.09152513835519904, 0.12788227463465096`, 
     1.6289154686138856`}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1666281135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2130626482],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " for a large collection of polyhedra and properties: "
}], "ExampleText",
 CellID->455035373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318678338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "14"}], ",", 
   RowBox[{"1", "\[Rule]", "15"}], ",", 
   RowBox[{"1", "\[Rule]", "16"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"2", "\[Rule]", "13"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"3", "\[Rule]", "14"}], ",", 
   RowBox[{"3", "\[Rule]", "19"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "15"}], ",", 
   RowBox[{"4", "\[Rule]", "20"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"5", "\[Rule]", "19"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"6", "\[Rule]", "20"}], ",", 
   RowBox[{"7", "\[Rule]", "11"}], ",", 
   RowBox[{"7", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "12"}], ",", 
   RowBox[{"8", "\[Rule]", "16"}], ",", 
   RowBox[{"9", "\[Rule]", "10"}], ",", 
   RowBox[{"9", "\[Rule]", "14"}], ",", 
   RowBox[{"9", "\[Rule]", "17"}], ",", 
   RowBox[{"10", "\[Rule]", "15"}], ",", 
   RowBox[{"10", "\[Rule]", "18"}], ",", 
   RowBox[{"11", "\[Rule]", "12"}], ",", 
   RowBox[{"13", "\[Rule]", "17"}], ",", 
   RowBox[{"13", "\[Rule]", "18"}], ",", 
   RowBox[{"17", "\[Rule]", "19"}], ",", 
   RowBox[{"18", "\[Rule]", "20"}]}], "}"}]], "Output",
 ImageSize->{509, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2075339510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512707771],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.035907294711242654`, 2.053908755073474, 
    1.3969287845150231`}, {0.8178657114140849, 2.6120708570852256`, 
    1.6775414438987761`}, {0.20119629199449007`, 1.7386481708138142`, 
    0.46287733993555047`}, {0., 1.2513522446033365`, 1.9923120396636724`}, {
    2.419414667844493, 0.5869941267236009, 1.2432389977888922`}, {
    2.2544439626171044`, 0.902830997580057, 2.177611095368384}, {
    1.6380534698389309`, 0.02933142635088104, 0.9632247986806294}, {
    2.455927851367067, 1.3895714725490882`, 0.6483276293434732}, {
    1.2643549110288859`, 2.1537172997523273`, 2.4454284454026127`}, {
    0.7588456426382721, 1.3133705842395624`, 2.641050712905222}, {
    2.188362652770088, 1.9002061083202606`, 2.159836476333582}, {
    0.267520842486597, 0.7411844197070961, 0.4806706502184508}, {
    0.14362131989015792`, 0.4397321702743018, 1.4258694572490265`}, {
    1.1915035103840135`, 0.4874337789303481, 0.19463989686811867`}, {
    1.3715375589900334`, 0.5398658250926897, 2.475079675696348}, {
    0.9906450911457438, 0., 1.7240997150085426`}, {1.4659739845345097`, 
    2.6411619150630217`, 0.9163426108297441}, {1.0845562532761046`, 
    2.101022109545067, 0.16583208265941063`}, {2.3133365851865895`, 
    2.201682254973269, 1.214860413196446}, {1.6971715803970775`, 
    1.3276510808034077`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.035907294711242654`, 2.053908755073474, 
     1.3969287845150231`}, {0.8178657114140849, 2.6120708570852256`, 
     1.6775414438987761`}, {0.20119629199449007`, 1.7386481708138142`, 
     0.46287733993555047`}, {0., 1.2513522446033365`, 1.9923120396636724`}, {
     2.419414667844493, 0.5869941267236009, 1.2432389977888922`}, {
     2.2544439626171044`, 0.902830997580057, 2.177611095368384}, {
     1.6380534698389309`, 0.02933142635088104, 0.9632247986806294}, {
     2.455927851367067, 1.3895714725490882`, 0.6483276293434732}, {
     1.2643549110288859`, 2.1537172997523273`, 2.4454284454026127`}, {
     0.7588456426382721, 1.3133705842395624`, 2.641050712905222}, {
     2.188362652770088, 1.9002061083202606`, 2.159836476333582}, {
     0.267520842486597, 0.7411844197070961, 0.4806706502184508}, {
     0.14362131989015792`, 0.4397321702743018, 1.4258694572490265`}, {
     1.1915035103840135`, 0.4874337789303481, 0.19463989686811867`}, {
     1.3715375589900334`, 0.5398658250926897, 2.475079675696348}, {
     0.9906450911457438, 0., 1.7240997150085426`}, {1.4659739845345097`, 
     2.6411619150630217`, 0.9163426108297441}, {1.0845562532761046`, 
     2.101022109545067, 0.16583208265941063`}, {2.3133365851865895`, 
     2.201682254973269, 1.214860413196446}, {1.6971715803970775`, 
     1.3276510808034077`, 0.}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->301894616]
}, Open  ]],

Cell["Compare to a predefined embedding: ", "ExampleText",
 CellID->224272968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<SkeletonImage\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437639446],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
    0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
    0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
    0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
    0.416}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {5, 8}, {6, 15}, {6, 
       11}, {7, 16}, {7, 14}, {8, 19}, {8, 20}, {9, 10}, {9, 2}, {9, 11}, {10,
        15}, {10, 4}, {12, 13}, {12, 3}, {12, 14}, {13, 16}, {13, 4}, {15, 
       16}, {17, 18}, {17, 2}, {17, 19}, {18, 3}, {18, 20}, {19, 11}, {20, 
       14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-1.548, 0.503}, {-1.133, -0.369}, {-0.7, 
     0.965}, {-2.345, 0.762}, {1.134, -0.368}, {0.957, -1.317}, {1.548, 
     0.503}, {0.489, -0.159}, {-0.957, -1.317}, {-1.449, -1.995}, {-0.001, \
-1.192}, {0., 1.628}, {0., 2.466}, {0.7, 0.965}, {1.449, -1.995}, {2.345, 
     0.761}, {-0.489, -0.159}, {-0.302, 0.416}, {0., -0.514}, {0.302, 
     0.416}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22370456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6602502],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 " for a large collection of sparse matrices: "
}], "ExampleText",
 CellID->1202273972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/Can229\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1521266319],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{289, 229},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->500302571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2027715731],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " supports graphs defined by ",
 StyleBox["Combinatorica:",
  FontSlant->"Italic"]
}], "ExampleText",
 CellID->281285891],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641520322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"FiniteGraphs", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309591901],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{1.9931907532119242`, 1.8591992116487477`, 
    1.676559672768495}, {0.18508820346330968`, 0.2372538344824261, 
    1.5078387583665187`}, {1.0891937312816355`, 1.9890117856144567`, 
    0.7391693404596911}, {1.9934639122780444`, 0.2366455249475362, 
    1.5092228308515159`}, {0.1881230273251373, 1.1987009160757172`, 
    0.2367129195610128}, {2.1569894896747352`, 1.09773047259834, 
    1.3155939342564122`}, {1.0892028936573188`, 1.0646717831620727`, 0.}, {
    1.0887775146688101`, 0.12047513730659876`, 1.7324332297612233`}, {
    1.0897831279931334`, 1.9328875635458171`, 1.924412719391484}, {
    0.018592554396938743`, 1.0858134558281625`, 1.3157534486419842`}, {
    2.1804012018183543`, 1.085799830954703, 1.003185796822787}, {
    1.0882665905333597`, 1.3835479017450782`, 0.03795315798593735}, {
    1.0898052771703717`, 0., 1.4307135990408892`}, {1.0894302604977815`, 
    2.110703863330336, 1.6545204926894197`}, {0., 1.099128939824794, 
    1.004523467957728}, {1.9896428104275548`, 1.2007069209193213`, 
    0.2367318315904695}, {1.0886881819865195`, 0.32070732185556117`, 
    0.5609932805293301}, {1.0892991662517537`, 0.9991914176348545, 
    2.079901662942266}, {0.18554669021139425`, 1.8593385901114106`, 
    1.678314395626562}, {1.0885134757835606`, 1.0899235070517685`, 
    1.1635909467518735`}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 6}, {1, 9}, {1, 11}, {1, 14}, {2, 8}, {2, 10}, {2, 13}, {
       2, 15}, {3, 7}, {3, 9}, {3, 12}, {3, 14}, {4, 6}, {4, 8}, {4, 11}, {4, 
       13}, {5, 7}, {5, 10}, {5, 12}, {5, 15}, {6, 16}, {6, 20}, {7, 16}, {7, 
       17}, {8, 17}, {8, 18}, {9, 18}, {9, 19}, {10, 19}, {10, 20}, {11, 
       16}, {11, 20}, {12, 16}, {12, 17}, {13, 17}, {13, 18}, {14, 18}, {14, 
       19}, {15, 19}, {15, 20}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.9931907532119242`, 1.8591992116487477`, 
     1.676559672768495}, {0.18508820346330968`, 0.2372538344824261, 
     1.5078387583665187`}, {1.0891937312816355`, 1.9890117856144567`, 
     0.7391693404596911}, {1.9934639122780444`, 0.2366455249475362, 
     1.5092228308515159`}, {0.1881230273251373, 1.1987009160757172`, 
     0.2367129195610128}, {2.1569894896747352`, 1.09773047259834, 
     1.3155939342564122`}, {1.0892028936573188`, 1.0646717831620727`, 0.}, {
     1.0887775146688101`, 0.12047513730659876`, 1.7324332297612233`}, {
     1.0897831279931334`, 1.9328875635458171`, 1.924412719391484}, {
     0.018592554396938743`, 1.0858134558281625`, 1.3157534486419842`}, {
     2.1804012018183543`, 1.085799830954703, 1.003185796822787}, {
     1.0882665905333597`, 1.3835479017450782`, 0.03795315798593735}, {
     1.0898052771703717`, 0., 1.4307135990408892`}, {1.0894302604977815`, 
     2.110703863330336, 1.6545204926894197`}, {0., 1.099128939824794, 
     1.004523467957728}, {1.9896428104275548`, 1.2007069209193213`, 
     0.2367318315904695}, {1.0886881819865195`, 0.32070732185556117`, 
     0.5609932805293301}, {1.0892991662517537`, 0.9991914176348545, 
     2.079901662942266}, {0.18554669021139425`, 1.8593385901114106`, 
     1.678314395626562}, {1.0885134757835606`, 1.0899235070517685`, 
     1.1635909467518735`}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2089755405]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 ButtonBox["Introduction to Graph Drawing in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]
}], "Tutorials",
 CellID->25850],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GraphPlot3D",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=GraphPlot3D"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->227045602],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->201084267],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->532643543],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->510013558]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphPlot3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 46.8179996}", "context" -> "System`", 
    "keywords" -> {
     "3D graph drawing", "3D graph embedding", "3D graph layout", 
      "3D graph visualization", "3D network layout", 
      "3D network visualization", "graph plot3", "graph plot 3D", 
      "high-dimensional embedding", "plot a graph", "radial drawing", 
      "random embedding", "spiral embedding", "spring-electrical embedding", 
      "spring embedding"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GraphPlot3D[{v i1 -> v j1, v i2 -> v j2, ...}] generates a 3D plot of \
the graph in which vertex v_ik is connected to vertex v_jk. GraphPlot3D[{{v \
i1 -> v j1, lbl_1}, ...}] associates labels lbl_k with edges in the graph. \
GraphPlot[m] generates a plot of the graph represented by the adjacency \
matrix m.", "synonyms" -> {"graph plot 3d"}, "title" -> "GraphPlot3D", "type" -> 
    "Symbol", "uri" -> "ref/GraphPlot3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21645, 697, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49203075]},
 "b:0.1"->{
  Cell[89015, 2253, 663, 21, 70, "Input",
   CellTags->"b:0.1",
   CellID->1209134277],
  Cell[89681, 2276, 43862, 1167, 70, "Output",
   CellTags->"b:0.1",
   CellID->418703521]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 608984, 14579},
 {"b:0.1", 609116, 14583}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2821, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3444, 91, 1576, 37, 70, "ObjectNameGrid"],
Cell[5023, 130, 3010, 94, 70, "Usage",
 CellID->18997]
}, Open  ]],
Cell[CellGroupData[{
Cell[8070, 229, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8548, 246, 259, 8, 70, "Notes",
 CellID->457633418],
Cell[8810, 256, 369, 12, 70, "Notes",
 CellID->30166],
Cell[9182, 270, 3421, 90, 70, "3ColumnTableMod",
 CellID->32136],
Cell[12606, 362, 502, 17, 70, "Notes",
 CellID->16670666],
Cell[13111, 381, 376, 13, 70, "Notes",
 CellID->762729751],
Cell[13490, 396, 862, 31, 70, "Notes",
 CellID->166183907],
Cell[14355, 429, 1627, 60, 70, "Notes",
 CellID->636470603],
Cell[15985, 491, 768, 23, 70, "Notes",
 CellID->184577521],
Cell[16756, 516, 482, 16, 70, "Notes",
 CellID->80983619],
Cell[17241, 534, 1145, 40, 70, "Notes",
 CellID->245035128],
Cell[18389, 576, 180, 4, 70, "Notes",
 CellID->70117131],
Cell[18572, 582, 172, 4, 70, "Notes",
 CellID->67697114],
Cell[18747, 588, 468, 18, 70, "Notes",
 CellID->105198305],
Cell[19218, 608, 408, 13, 70, "Notes",
 CellID->424434705],
Cell[19629, 623, 624, 20, 70, "Notes",
 CellID->102997983],
Cell[20256, 645, 638, 21, 70, "Notes",
 CellID->106260262],
Cell[20897, 668, 711, 24, 70, "Notes",
 CellID->233609336]
}, Closed]],
Cell[CellGroupData[{
Cell[21645, 697, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49203075],
Cell[CellGroupData[{
Cell[22029, 711, 148, 5, 70, "ExampleSection",
 CellID->259160533],
Cell[22180, 718, 62, 1, 70, "ExampleText",
 CellID->154509960],
Cell[CellGroupData[{
Cell[22267, 723, 544, 15, 28, "Input",
 CellID->842440708],
Cell[22814, 740, 1581, 44, 200, "Output",
 CellID->321399936]
}, Open  ]],
Cell[24410, 787, 123, 3, 70, "ExampleDelimiter",
 CellID->2526546],
Cell[24536, 792, 65, 1, 70, "ExampleText",
 CellID->474638002],
Cell[CellGroupData[{
Cell[24626, 797, 625, 17, 70, "Input",
 CellID->614553804],
Cell[25254, 816, 5775, 109, 200, 1696, 38, "CachedBoxData", "BoxData", \
"Output",
 CellID->1717555944]
}, Open  ]],
Cell[31044, 928, 121, 3, 70, "ExampleDelimiter",
 CellID->24464],
Cell[31168, 933, 86, 1, 70, "ExampleText",
 CellID->16827],
Cell[CellGroupData[{
Cell[31279, 938, 456, 14, 70, "Input",
 CellID->5705],
Cell[31738, 954, 1300, 37, 70, "Output",
 CellID->1167717610]
}, Open  ]],
Cell[33053, 994, 125, 3, 70, "ExampleDelimiter",
 CellID->239423027],
Cell[33181, 999, 100, 2, 70, "ExampleText",
 CellID->44034],
Cell[CellGroupData[{
Cell[33306, 1005, 1256, 35, 70, "Input",
 CellID->356001663],
Cell[34565, 1042, 16180, 276, 171, 2586, 49, "CachedBoxData", "BoxData", \
"Output",
 CellID->200568142]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50794, 1324, 216, 7, 70, "ExampleSection",
 CellID->26664],
Cell[CellGroupData[{
Cell[51035, 1335, 240, 7, 70, "ExampleSubsection",
 CellID->369255627],
Cell[51278, 1344, 78, 1, 70, "ExampleText",
 CellID->1096410170],
Cell[CellGroupData[{
Cell[51381, 1349, 381, 11, 70, "Input",
 CellID->2003953898],
Cell[51765, 1362, 1299, 37, 70, "Output",
 CellID->682391938]
}, Open  ]],
Cell[53079, 1402, 126, 3, 70, "ExampleDelimiter",
 CellID->1812687329],
Cell[53208, 1407, 90, 1, 70, "ExampleText",
 CellID->107686483],
Cell[CellGroupData[{
Cell[53323, 1412, 459, 14, 70, "Input",
 CellID->4894094],
Cell[53785, 1428, 1300, 37, 70, "Output",
 CellID->1098260347]
}, Open  ]],
Cell[55100, 1468, 126, 3, 70, "ExampleDelimiter",
 CellID->1640804889],
Cell[55229, 1473, 92, 1, 70, "ExampleText",
 CellID->497633172],
Cell[CellGroupData[{
Cell[55346, 1478, 687, 22, 70, "Input",
 CellID->1430216091],
Cell[56036, 1502, 1300, 37, 70, "Output",
 CellID->1316016864]
}, Open  ]],
Cell[57351, 1542, 123, 3, 70, "ExampleDelimiter",
 CellID->1233819],
Cell[57477, 1547, 216, 8, 70, "ExampleText",
 CellID->149518306],
Cell[CellGroupData[{
Cell[57718, 1559, 516, 16, 70, "Input",
 CellID->2815895],
Cell[58237, 1577, 9772, 237, 70, "Output",
 CellID->292595254]
}, Open  ]],
Cell[68024, 1817, 125, 3, 70, "ExampleDelimiter",
 CellID->556990123],
Cell[68152, 1822, 229, 8, 70, "ExampleText",
 CellID->587125292],
Cell[CellGroupData[{
Cell[68406, 1834, 269, 8, 70, "Input",
 CellID->2132219943],
Cell[68678, 1844, 9206, 155, 70, "Output",
 Evaluatable->False,
 CellID->26987676]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77933, 2005, 232, 7, 70, "ExampleSubsection",
 CellID->4212966],
Cell[78168, 2014, 62, 1, 70, "ExampleText",
 CellID->250888577],
Cell[CellGroupData[{
Cell[78255, 2019, 499, 14, 70, "Input",
 CellID->351220558],
Cell[78757, 2035, 7875, 137, 232, 3732, 65, "CachedBoxData", "BoxData", \
"Output",
 CellID->531558036]
}, Open  ]],
Cell[86647, 2175, 126, 3, 70, "ExampleDelimiter",
 CellID->1301177980],
Cell[86776, 2180, 80, 1, 70, "ExampleText",
 CellID->956609091],
Cell[CellGroupData[{
Cell[86881, 2185, 599, 16, 70, "Input",
 CellID->1761264953],
Cell[87483, 2203, 1300, 37, 70, "Output",
 CellID->1171508751]
}, Open  ]],
Cell[88798, 2243, 125, 3, 70, "ExampleDelimiter",
 CellID->996109397],
Cell[88926, 2248, 64, 1, 70, "ExampleText",
 CellID->2995],
Cell[CellGroupData[{
Cell[89015, 2253, 663, 21, 70, "Input",
 CellTags->"b:0.1",
 CellID->1209134277],
Cell[89681, 2276, 43862, 1167, 70, "Output",
 CellTags->"b:0.1",
 CellID->418703521]
}, Open  ]],
Cell[133558, 3446, 125, 3, 70, "ExampleDelimiter",
 CellID->739766316],
Cell[133686, 3451, 122, 3, 70, "ExampleText",
 CellID->1632065829],
Cell[CellGroupData[{
Cell[133833, 3458, 423, 13, 70, "Input",
 CellID->693558391],
Cell[134259, 3473, 2944, 52, 70, "Output",
 Evaluatable->False,
 CellID->40583224]
}, Open  ]],
Cell[137218, 3528, 125, 3, 70, "ExampleDelimiter",
 CellID->198996824],
Cell[137346, 3533, 393, 13, 70, "ExampleText",
 CellID->66078131],
Cell[CellGroupData[{
Cell[137764, 3550, 932, 26, 70, "Input",
 CellID->25225345],
Cell[138699, 3578, 14072, 237, 171, 2060, 36, "CachedBoxData", "BoxData", \
"Output",
 CellID->250175321]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[152832, 3822, 239, 7, 70, "ExampleSection",
 CellID->29965],
Cell[153074, 3831, 90, 1, 70, "ExampleText",
 CellID->381125490],
Cell[CellGroupData[{
Cell[153189, 3836, 538, 17, 70, "Input",
 CellID->448969433],
Cell[153730, 3855, 9237, 225, 70, "Output",
 CellID->159753063]
}, Open  ]],
Cell[162982, 4083, 120, 3, 70, "ExampleDelimiter",
 CellID->4827],
Cell[163105, 4088, 131, 5, 70, "ExampleText",
 CellID->12382],
Cell[163239, 4095, 139, 4, 70, "Input",
 CellID->72863096],
Cell[CellGroupData[{
Cell[163403, 4103, 148, 4, 70, "Input",
 CellID->323993010],
Cell[163554, 4109, 3363, 87, 70, "Output",
 CellID->29927820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166966, 4202, 223, 7, 70, "ExampleSection",
 CellID->597282073],
Cell[CellGroupData[{
Cell[167214, 4213, 241, 7, 70, "ExampleSubsection",
 CellID->65693485],
Cell[167458, 4222, 61, 1, 70, "ExampleText",
 CellID->26472224],
Cell[CellGroupData[{
Cell[167544, 4227, 311, 9, 70, "Input",
 CellID->1020060192],
Cell[167858, 4238, 5102, 132, 70, "Output",
 CellID->273857571]
}, Open  ]],
Cell[172975, 4373, 125, 3, 70, "ExampleDelimiter",
 CellID->141508825],
Cell[173103, 4378, 113, 3, 70, "ExampleText",
 CellID->2122510440],
Cell[CellGroupData[{
Cell[173241, 4385, 1087, 31, 70, "Input",
 CellID->1956840094],
Cell[174331, 4418, 6442, 118, 70, "Output",
 CellID->2134971310]
}, Open  ]],
Cell[180788, 4539, 124, 3, 70, "ExampleDelimiter",
 CellID->19051973],
Cell[180915, 4544, 70, 1, 70, "ExampleText",
 CellID->124062807],
Cell[CellGroupData[{
Cell[181010, 4549, 1335, 38, 70, "Input",
 CellID->3492647],
Cell[182348, 4589, 7280, 127, 70, "Output",
 CellID->377483975]
}, Open  ]],
Cell[189643, 4719, 125, 3, 70, "ExampleDelimiter",
 CellID->234209287],
Cell[189771, 4724, 92, 1, 70, "ExampleText",
 CellID->127920141],
Cell[CellGroupData[{
Cell[189888, 4729, 933, 26, 70, "Input",
 CellID->769819478],
Cell[190824, 4757, 14072, 237, 171, 2060, 36, "CachedBoxData", "BoxData", \
"Output",
 CellID->468794193]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[204945, 5000, 227, 7, 70, "ExampleSubsection",
 CellID->489698888],
Cell[205175, 5009, 91, 1, 70, "ExampleText",
 CellID->289707743],
Cell[CellGroupData[{
Cell[205291, 5014, 1817, 44, 70, "Input",
 CellID->394919304],
Cell[207111, 5060, 22230, 540, 70, "Output",
 CellID->26685438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[229390, 5606, 235, 7, 70, "ExampleSubsection",
 CellID->100942717],
Cell[229628, 5615, 97, 1, 70, "ExampleText",
 CellID->1029865650],
Cell[CellGroupData[{
Cell[229750, 5620, 959, 28, 70, "Input",
 CellID->40554687],
Cell[230712, 5650, 14198, 296, 70, "Output",
 CellID->2019399611]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[244959, 5952, 233, 7, 70, "ExampleSubsection",
 CellID->47225018],
Cell[245195, 5961, 97, 1, 70, "ExampleText",
 CellID->1302252890],
Cell[CellGroupData[{
Cell[245317, 5966, 1099, 29, 70, "Input",
 CellID->47617879],
Cell[246419, 5997, 172772, 4212, 70, "Output",
 CellID->1099848233]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[419240, 10215, 236, 7, 70, "ExampleSubsection",
 CellID->44888674],
Cell[419479, 10224, 232, 8, 70, "ExampleText",
 CellID->1808033363],
Cell[CellGroupData[{
Cell[419736, 10236, 875, 25, 70, "Input",
 CellID->500288768],
Cell[420614, 10263, 7382, 189, 70, "Output",
 CellID->584759501]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[428045, 10458, 230, 7, 70, "ExampleSubsection",
 CellID->179618439],
Cell[428278, 10467, 84, 1, 70, "ExampleText",
 CellID->1676190373],
Cell[CellGroupData[{
Cell[428387, 10472, 843, 24, 70, "Input",
 CellID->14566157],
Cell[429233, 10498, 5332, 141, 70, "Output",
 CellID->1597594693]
}, Open  ]],
Cell[434580, 10642, 125, 3, 70, "ExampleDelimiter",
 CellID->297939305],
Cell[434708, 10647, 384, 12, 70, "ExampleText",
 CellID->580503372],
Cell[CellGroupData[{
Cell[435117, 10663, 839, 25, 70, "Input",
 CellID->317015018],
Cell[435959, 10690, 5290, 97, 232, 1227, 26, "CachedBoxData", "BoxData", \
"Output",
 CellID->1479170635]
}, Open  ]],
Cell[441264, 10790, 125, 3, 70, "ExampleDelimiter",
 CellID->414909817],
Cell[441392, 10795, 379, 12, 70, "ExampleText",
 CellID->88626299],
Cell[CellGroupData[{
Cell[441796, 10811, 808, 24, 70, "Input",
 CellID->238367270],
Cell[442607, 10837, 2269, 55, 70, "Output",
 CellID->253634311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[444925, 10898, 233, 7, 70, "ExampleSubsection",
 CellID->91275691],
Cell[445161, 10907, 93, 1, 70, "ExampleText",
 CellID->1053407179],
Cell[CellGroupData[{
Cell[445279, 10912, 738, 22, 70, "Input",
 CellID->375686493],
Cell[446020, 10936, 7652, 169, 70, "Output",
 CellID->441519075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[453721, 11111, 242, 7, 70, "ExampleSubsection",
 CellID->469196428],
Cell[453966, 11120, 85, 1, 70, "ExampleText",
 CellID->49039736],
Cell[CellGroupData[{
Cell[454076, 11125, 1727, 50, 70, "Input",
 CellID->895811688],
Cell[455806, 11177, 1571, 50, 70, "Output",
 CellID->851064969]
}, Open  ]],
Cell[457392, 11230, 125, 3, 70, "ExampleDelimiter",
 CellID->379319889],
Cell[457520, 11235, 306, 10, 70, "ExampleText",
 CellID->762072884],
Cell[CellGroupData[{
Cell[457851, 11249, 1792, 50, 70, "Input",
 CellID->1218538592],
Cell[459646, 11301, 1886, 56, 70, "Output",
 CellID->486799337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[461581, 11363, 234, 7, 70, "ExampleSubsection",
 CellID->24443973],
Cell[461818, 11372, 63, 1, 70, "ExampleText",
 CellID->1001631834],
Cell[CellGroupData[{
Cell[461906, 11377, 458, 13, 70, "Input",
 CellID->1042589918],
Cell[462367, 11392, 5380, 102, 232, 1363, 32, "CachedBoxData", "BoxData", \
"Output",
 CellID->449399609]
}, Open  ]],
Cell[467762, 11497, 125, 3, 70, "ExampleDelimiter",
 CellID->291462997],
Cell[467890, 11502, 78, 1, 70, "ExampleText",
 CellID->73764302],
Cell[CellGroupData[{
Cell[467993, 11507, 462, 13, 70, "Input",
 CellID->655204029],
Cell[468458, 11522, 1300, 37, 70, "Output",
 CellID->1709990844]
}, Open  ]],
Cell[469773, 11562, 123, 3, 70, "ExampleDelimiter",
 CellID->8973542],
Cell[469899, 11567, 95, 1, 70, "ExampleText",
 CellID->1197125759],
Cell[CellGroupData[{
Cell[470019, 11572, 456, 13, 70, "Input",
 CellID->406910921],
Cell[470478, 11587, 1864, 52, 70, "Output",
 CellID->392173674]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[472391, 11645, 243, 7, 70, "ExampleSubsection",
 CellID->82661052],
Cell[472637, 11654, 61, 1, 70, "ExampleText",
 CellID->1148726976],
Cell[CellGroupData[{
Cell[472723, 11659, 436, 13, 70, "Input",
 CellID->1976145425],
Cell[473162, 11674, 3384, 60, 70, "Output",
 Evaluatable->False,
 CellID->56319487]
}, Open  ]],
Cell[476561, 11737, 124, 3, 70, "ExampleDelimiter",
 CellID->29788626],
Cell[476688, 11742, 91, 1, 70, "ExampleText",
 CellID->29247091],
Cell[CellGroupData[{
Cell[476804, 11747, 933, 26, 70, "Input",
 CellID->669401884],
Cell[477740, 11775, 14072, 237, 171, 2060, 36, "CachedBoxData", "BoxData", \
"Output",
 CellID->807598518]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[491873, 12019, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[492103, 12028, 93, 1, 70, "ExampleText",
 CellID->472397991],
Cell[CellGroupData[{
Cell[492221, 12033, 879, 27, 70, "Input",
 CellID->206162687],
Cell[493103, 12062, 50048, 834, 262, 19427, 328, "CachedBoxData", "BoxData", \
"Output",
 CellID->246462954]
}, Open  ]],
Cell[543166, 12899, 125, 3, 70, "ExampleDelimiter",
 CellID->101867367],
Cell[543294, 12904, 76, 1, 70, "ExampleText",
 CellID->1279748360],
Cell[CellGroupData[{
Cell[543395, 12909, 352, 10, 70, "Input",
 CellID->1461987012],
Cell[543750, 12921, 3083, 55, 70, "Output",
 Evaluatable->False,
 CellID->56592827]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[546882, 12982, 233, 7, 70, "ExampleSection",
 CellID->19760],
Cell[547118, 12991, 254, 8, 70, "ExampleText",
 CellID->178337475],
Cell[CellGroupData[{
Cell[547397, 13003, 844, 24, 70, "Input",
 CellID->2104551000],
Cell[548244, 13029, 2844, 64, 70, "Output",
 CellID->2089298815]
}, Open  ]],
Cell[551103, 13096, 125, 3, 70, "ExampleDelimiter",
 CellID->363990941],
Cell[551231, 13101, 223, 8, 70, "ExampleText",
 CellID->64651062],
Cell[CellGroupData[{
Cell[551479, 13113, 438, 14, 70, "Input",
 CellID->599520976],
Cell[551920, 13129, 3120, 91, 70, "Output",
 CellID->79635200]
}, Open  ]],
Cell[555055, 13223, 125, 3, 70, "ExampleDelimiter",
 CellID->194382608],
Cell[555183, 13228, 211, 8, 70, "ExampleText",
 CellID->335683558],
Cell[CellGroupData[{
Cell[555419, 13240, 333, 11, 70, "Input",
 CellID->9126831],
Cell[555755, 13253, 8870, 149, 70, "Output",
 Evaluatable->False,
 CellID->107538667]
}, Open  ]],
Cell[564640, 13405, 123, 3, 70, "ExampleDelimiter",
 CellID->7616771],
Cell[564766, 13410, 254, 8, 70, "ExampleText",
 CellID->212276565],
Cell[CellGroupData[{
Cell[565045, 13422, 156, 5, 70, "Input",
 CellID->329468572],
Cell[565204, 13429, 1452, 41, 71, "Output",
 CellID->474834767]
}, Open  ]],
Cell[566671, 13473, 77, 1, 70, "ExampleText",
 CellID->322493678],
Cell[CellGroupData[{
Cell[566773, 13478, 168, 5, 70, "Input",
 CellID->724898899],
Cell[566944, 13485, 1418, 37, 71, "Output",
 CellID->1055785905]
}, Open  ]],
Cell[CellGroupData[{
Cell[568399, 13527, 105, 3, 70, "Input",
 CellID->2304381],
Cell[568507, 13532, 5448, 137, 70, "Output",
 CellID->1666281135]
}, Open  ]],
Cell[573970, 13672, 126, 3, 70, "ExampleDelimiter",
 CellID->2130626482],
Cell[574099, 13677, 251, 8, 70, "ExampleText",
 CellID->455035373],
Cell[CellGroupData[{
Cell[574375, 13689, 175, 5, 70, "Input",
 CellID->318678338],
Cell[574553, 13696, 1418, 37, 71, "Output",
 CellID->2075339510]
}, Open  ]],
Cell[CellGroupData[{
Cell[576008, 13738, 107, 3, 70, "Input",
 CellID->512707771],
Cell[576118, 13743, 5419, 137, 70, "Output",
 CellID->301894616]
}, Open  ]],
Cell[581552, 13883, 78, 1, 70, "ExampleText",
 CellID->224272968],
Cell[CellGroupData[{
Cell[581655, 13888, 175, 5, 70, "Input",
 CellID->437639446],
Cell[581833, 13895, 3449, 110, 70, "Output",
 CellID->22370456]
}, Open  ]],
Cell[585297, 14008, 123, 3, 70, "ExampleDelimiter",
 CellID->6602502],
Cell[585423, 14013, 237, 8, 70, "ExampleText",
 CellID->1202273972],
Cell[CellGroupData[{
Cell[585685, 14025, 268, 8, 70, "Input",
 CellID->1521266319],
Cell[585956, 14035, 11107, 186, 70, "Output",
 Evaluatable->False,
 CellID->500302571]
}, Open  ]],
Cell[597078, 14224, 126, 3, 70, "ExampleDelimiter",
 CellID->2027715731],
Cell[597207, 14229, 263, 9, 70, "ExampleText",
 CellID->281285891],
Cell[597473, 14240, 141, 4, 70, "Input",
 CellID->1641520322],
Cell[CellGroupData[{
Cell[597639, 14248, 170, 5, 70, "Input",
 CellID->309591901],
Cell[597812, 14255, 5535, 138, 70, "Output",
 CellID->2089755405]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[603408, 14400, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[603727, 14411, 965, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[604729, 14451, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[605050, 14462, 410, 12, 70, "Tutorials",
 CellID->25850],
Cell[605463, 14476, 147, 3, 70, "Tutorials",
 CellID->99260146]
}, Open  ]],
Cell[CellGroupData[{
Cell[605647, 14484, 305, 8, 70, "RelatedLinksSection"],
Cell[605955, 14494, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[606359, 14511, 299, 8, 70, "MoreAboutSection"],
Cell[606661, 14521, 155, 3, 70, "MoreAbout",
 CellID->227045602],
Cell[606819, 14526, 151, 3, 70, "MoreAbout",
 CellID->201084267],
Cell[606973, 14531, 166, 3, 70, "MoreAbout",
 CellID->532643543],
Cell[607142, 14536, 179, 3, 70, "MoreAbout",
 CellID->510013558]
}, Open  ]],
Cell[607336, 14542, 27, 0, 70, "History"],
Cell[607366, 14544, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

