(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1627545,      31629]
NotebookOptionsPosition[   1587930,      30296]
NotebookOutlinePosition[   1589556,      30338]
CellTagsIndexPosition[   1589467,      30333]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Show" :> Documentation`HelpLookup["paclet:ref/Show"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"], "ListPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot3D"], 
          "ParametricPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot3D"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"], 
          "ContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot3D"], 
          "ListContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot3D"], 
          "Graphics" :> Documentation`HelpLookup["paclet:ref/Graphics"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Show\"\>", 2->"\<\"Plot3D\"\>", 
       3->"\<\"ListPlot3D\"\>", 4->"\<\"ParametricPlot3D\"\>", 
       5->"\<\"RegionPlot3D\"\>", 6->"\<\"ContourPlot3D\"\>", 
       7->"\<\"ListContourPlot3D\"\>", 8->"\<\"Graphics\"\>", 
       9->"\<\"Import\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Symbolic Graphics Language\"\>", 
       2->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Graphics3D", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Graphics3D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Graphics3D"], "[", 
       RowBox[{
        StyleBox["primitives", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a three\[Hyphen]dimensional graphical image. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17064]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " is displayed in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " as a graphical image. In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " it is displayed as an explicit list of primitives. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31505],

Cell["The following graphics primitives can be used: ", "Notes",
 CellID->1157],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Cuboid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cuboid"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["min", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell["cuboid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Cylinder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cylinder"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["3", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell["cylinder", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["GraphicsComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsComplex"], "[", 
     RowBox[{
      StyleBox["pts", "TI"], ",", 
      StyleBox["prims", "TI"]}], "]"}], Cell[
    "complex of graphics objects ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["GraphicsGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsGroup"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "objects treated as a group", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Inset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inset"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "inset object ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], "1"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "line ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], "]"}], Cell["point ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], "1"], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], "1"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "polygon ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Sphere",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sphere"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell["sphere ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}]}], "]"}], Cell["text ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->31502],

Cell["The following graphics directives can be used: ", "Notes",
 CellID->7666],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["AbsoluteDashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteDashing"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], "1"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "absolute line dashing specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["AbsolutePointSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsolutePointSize"], "[", 
     StyleBox["d", "TI"], "]"}], Cell[
    "absolute point size specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["AbsoluteThickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteThickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[
    "absolute line thickness specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["CMYKColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CMYKColor"], "[", 
     RowBox[{
      StyleBox["c", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[
    "color specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Dashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dashing"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], "1"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "line dashing specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Directive",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Directive"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "composite graphics directive", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["EdgeForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EdgeForm"], "[", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "polygon edge specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["FaceForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceForm"], "[", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "polygon face specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Glow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Glow"], "[", 
     StyleBox["c", "TI"], "]"}], 
    RowBox[{Cell["glow color specification", "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     StyleBox["i", "TI"], "]"}], Cell[
    "gray\[Hyphen]level specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hue"], "[", 
     StyleBox["h", "TI"], "]"}], Cell["hue specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[
    "opacity specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["PointSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PointSize"], "[", 
     StyleBox["d", "TI"], "]"}], Cell[
    "point size specification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[
    "color specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Specularity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Specularity"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "surface specularity specification", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[
    "line thickness specification ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True}}}},
 CellID->9275],

Cell["The following wrappers can be used at any level:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32391],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Annotation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Annotation"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["label", "TI"]}], "]"}], Cell[
    "give an annotation", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Button",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Button"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["action", "TI"]}], "]"}], Cell[TextData[{
     "make ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " act as a button"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "use the dynamically updated current value", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["EventHandler",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EventHandler"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "attach an event handler", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Hyperlink",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hyperlink"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["URI", "TI"]}], "]"}], Cell[TextData[{
     "make ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " a hyperlink"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Mouseover",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mouseover"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["over", "TI"]}], "]"}], Cell[
    "specify a mouseover form", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["PopupWindow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PopupWindow"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["cont", "TI"]}], "]"}], Cell[
    "attach a popup window", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["StatusArea",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StatusArea"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["label", "TI"]}], "]"}], Cell[
    "specify a label to appear in the status area", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell["specify a style", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Tooltip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tooltip"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["label", "TI"]}], "]"}], Cell[
    "attach a tooltip", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->243501764],

Cell["The following options can be given: ", "Notes",
 CellID->32046],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["AlignmentPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AlignmentPoint"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "the default point in the graphic to align with ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesEdge",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesEdge"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "on which edges to put axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["axes labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesStyle"], 
    RowBox[{"{", "}"}], Cell[
    "graphics directives to specify the style for axes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "background color for the plot ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Boxed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Boxed"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw the bounding box ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxRatios",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxRatios"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "bounding 3D box ratios ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style specifications for the box ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ContentSelectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContentSelectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow contents to be selected ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ControllerLinking",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerLinking"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "when to link to external rotation controllers", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ControllerMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how external controllers should operate", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ControllerPath",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerPath"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what external controllers to try to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["$DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$DisplayFunction"], Cell[
    "function for generating output ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Epilog",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Epilog"], 
    RowBox[{"{", "}"}], Cell[
    "2D graphics primitives to be rendered after the main plot ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FaceGrids",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FaceGrids"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "grid lines to draw on the bounding box ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "FaceGridsStyle", 
    RowBox[{"{", "}"}], Cell[
    "style specifications for face grids", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[
    "default format type for text ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0.", Cell[
    "the margins to leave around the graphic", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ImagePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImagePadding"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "what extra padding to allow for labels, etc. ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "absolute size at which to render the graphic ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for labels", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "simulated light sources to use ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "Method", "Automatic", Cell[
    "details of 3D graphics methods to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a label for the plot ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range of values to include ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRegion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "final display region to be filled ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "PreserveImageOptions", "Automatic", Cell["\<\
whether to preserve image options when displaying new versions of the same \
graphic\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Prolog",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Prolog"], 
    RowBox[{"{", "}"}], Cell[
    "2D graphics primitives to be rendered before the main plot ", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "RotationAction", "\"\<Fit\>\"", Cell[
    "how to render after interactive rotation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SphericalRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SphericalRegion"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to make the circumscribing sphere fit in final display area \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Ticks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Ticks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specification for ticks ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "TicksStyle", 
    RowBox[{"{", "}"}], Cell["style specification for ticks", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ViewAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewAngle"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "angle of the field of view ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewCenter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewCenter"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], Cell[
    "point to display at the center ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ViewMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewMatrix"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "explicit transformation matrix ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    RowBox[{"{", 
     RowBox[{"1.3", ",", 
      RowBox[{"-", "2.4"}], ",", "2."}], "}"}], Cell[
    "viewing position ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ViewRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range of viewing distances to include ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ViewVector",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVector"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "position and direction of a simulated camera ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewVertical",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVertical"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell[
    "direction to make vertical ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->17632],

Cell[TextData[{
 "Nested lists of graphics constructs can be given. Directive specifications \
such as ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " normally remain in effect only until the end of the list which contains \
them. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29789],

Cell["\<\
A list containing only graphics directives is treated as if its elements were \
directly inserted into an enclosing list. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6046],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to apply the options or directives ",
 Cell[BoxData[
  StyleBox["opts", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2145],

Cell[TextData[{
 "In a notebook front end, ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " can be changed by direct interactive manipulation. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6003],

Cell["Dragging with the mouse rotates a 3D graphic. ", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13152],

Cell[TextData[{
 "Directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " specify surface colors for objects that follow. Final colors are \
determined from simulated illumination, including ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " components. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31901],

Cell["\<\
By default, four light sources of different colors are used, arranged at \
particular fixed locations outside the bounding box. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8326],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " is set so that if possible the projection of the whole 3D object just \
fills the 2D viewing area. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29153],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " style in the current stylesheet. The settings for ",
 Cell[BoxData[
  ButtonBox["BoxStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ", etc. are appended to the default styles given for ",
 Cell[BoxData["\"\<Graphics3DBox\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Graphics3DLabel\>\""], "InlineFormula"],
 ", etc."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->132654351],

Cell[TextData[{
 "Settings that can be given through the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option include ",
 Cell[BoxData["\"\<SpherePoints\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<CylinderPoints\>\""], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->886506922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives an empty 3D graphic."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21184]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->29562321],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->48876208],

Cell["\<\
Use lines, polygons, cylinders, spheres etc to build up 3D graphics scene:\
\>", "ExampleText",
 CellID->855412436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Cylinder", "[", "]"}], ",", "Red", ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}], ",", "Black", ",", 
    "Thick", ",", "Dashed", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",",
     "Yellow", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}], ",", "Green", ",", 
    RowBox[{"Opacity", "[", ".3", "]"}], ",", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1147869],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}, 
   {RGBColor[1, 0, 0], SphereBox[{0, 0, 2}]}, 
   {GrayLevel[0], Thickness[Large], Dashing[{Small, Small}], 
    Line3DBox[{{-2, 0, 2}, {2, 0, 2}, {0, 0, 4}, {-2, 0, 2}}], 
    {RGBColor[1, 1, 0], 
     Polygon3DBox[{{-3, -3, -2}, {-3, 3, -2}, {3, 3, -2}, {3, -3, -2}}]}, 
    {RGBColor[0, 1, 0], Opacity[0.3], 
     CuboidBox[{-2, -2, -2}, {2, 2, -1}]}}}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1016698699,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10070301],

Cell[TextData[{
 "Use plot functions to automatically create ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " from different types of data: "
}], "ExampleText",
 CellID->892199019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50579370],

Cell[GraphicsData["CompressedBitmap", "\<\
eJykvAV8G9nV9+9nd/u0D7V92o0dTmwxs2TZkpmZZdkyx8zMzGxLZmZmZmam
2OFlxuK2u9Hn/86MZCdxsn3b/5vPriWNZkZ3zveec37n3jtj7BLm5e7vEubt
5nJXN8QlyMvbLfSuTmAIsOntf5ORkRkB/i+6KgO8//+Ad9D/I2KxGPjipb9R
wN+3ga/Y0KdY8C/4UQz9k2H+g63RwN+3Lo6MubQP6x8cef6bv5KegQRtTQH/
vvNiXxkZ4v+v7YmvbX/rUivw0OY4aStk3nF3d5d8+bP7xkhbCn4Lnlrmbcne
Mhetj5Se7Z2Xfl1yXir0fbj0DP8BnR/4RnoCCvRqKT3vjfM2Sc8P/v0VdEbJ
EZKtZOjF6qWWgodclR7765/Z3/rSlV2Rtuh/wQ+/uNhfejbJVdlcOuZ/pb/x
e/DDv7/8Gy8TuHzUb6S/JPvStYNv32xry9f4/Vr6q1cvHf/2peNxF3YBf+1/
pK83Lh31zqWjsNBRztLfuPVP7e0o3fvOP2gRaEVJi+yleytc2vsXl86Ngfbm
S9uNuLT3v1/aG31h68s9Bn7pyF9eOhJ1YeeLHvvSt7B/6miq9Oib0tYS3nAU
uF3SStqlc5z3VdKlo/7j0n6INx4tKz037dLRv/qnjgb7Lti96P+X335H/FKP
eO0s/yttA/1l+0vd+r/ecKaXP9984xnPeznt/Iy/8BZa+Qgt/YrNgQ9gLPkv
6W9e7gk3L4i8JfWWty71CMr5tl95i2x8RdZ+IosAoVmg0CRYaCw5+f9cOudl
35L8hurlNv6nb4mNf4lVgMgySGQeLDINFRmFiQwihPqSs/760lkue7zkrJzL
Z/0fv1Jb/xJegMgmqMQypMQ8tMQ0XGQSITKKEulHi3RiRVpSi/xz51d6iRVk
hd/6lfMDymwDS3lBJTYhIqtQkWW4yDyyxCSqxChGZBAr0o8X6SSINJNE6slC
Nel1nMd/8PU2dF7W5Xb/LqCCH1RuG1zGCym1CSuxChdZRogsooTm0cWmsSKj
+BL9RJFukkgnRaSZKlJLF6lmCLnntn8l4slDL4w3kCSf/9aVwCq74Ep+SIVt
aDkvrMwmotQqssQySmQRIzKPFZrFFZsmFBknFRukCHXTRFrpIo1MkVqWiJsj
5OQKlUHb/faSraBYBnnHW9Je/6bogDv//atBNYLgarvQKn5YpW14BS+y3Dqq
zCq61DKmxCJOZB4vMksQmiYVGycXGaUUGqYV6WUUa2cJNXJEqnkibr5IuVDI
LhIqAg3530u/ILHt716zyXXxC6+HrHIzuM4hpFYQWmMfXs2PqLKNrORFV1jH
VFjFllvGl1kklJonisySRKYpQuPUYqO0IsOMQoPMAv2sAt3cQs38YrVCIbdY
pCQUKpYIWaXFTEm2vtyaWz/TGjmpHc7joMzt0HqHsDpBRK1dZA0/qto2uooX
W2kdV2kVX2GZWG6RVGaWXGqaWmKSJjJOFxplFBtmFRlkF+rnFOjl5uvk52sX
FmgUF6qIipXLhKzyYmZFEbOykCFp02+lV3znZ9pynskv2iIf1ugU3uAQWS+I
qrOLruXH1NrG1fDiq2wSqqySKi2TKyxSys1Sy0zTS00ySowzRUZZQsOcYoPc
Iv28Qr38Ap3CfO2ifK3iPE1RvlpZAbeikF1VxKwuZNQUMGrz6ZJGSdrxmq+9
3rrfvWQpiBsivNk5oskpstEhukEQ02AfW8+Pr7NNqLVJrLFOqrZKqbJMrbRI
qzDPKDfNLDPJKjXOLjXMLTHIE+nnC/UKinSLCnWKC7SF+VqifM3SPI2yXPWK
XJWqPOWaAlZdAaM+n96QR2/MoQHNbMmivqmlN36mpb+5zBQV2eIc1eIU0+wQ
2ySIa7RPaOAn1tsm1fGSa61Ta6zSqi3Sq80zKs2yKkyzy01yyozzygzzSw0K
SvQLRXrFQh1hsbaoSLukUKu0QLM8X6MiT70yV7U6R6Umh1OXy27MYzbl0Zpz
aS051LYsKtDejgzKz7f33DPP8wTlvJXYqHbXmDbn2FanuBaH+GZBQpNdUiM/
ucE2pZ6XVmedXmeVUWuZWWOeXW2WU2WSW2mcX2FUUG5YWGZQVKovLNETiXRK
hNplxVrlRZoVhRqVBepV+WrVeaq1uSp1Odz6bE5jlnJzNqs1l96WQ+3IpnZm
UboyKEBze9LI0ta+JVUCMjJ3L7eOEN3pFtvhGtfuHN/mlNDqkNQiSG62T2nm
pzbZpjXaZDRYZ9ZbZdVZ5tSa59aY5VWbFFQZF1YaFVUYFJfri8r0Skp1S0t0
ykTaFUKtSqFmVbF6dZFabaFqXb5KfZ5KQy63MYfTnK3ckqXUmqnYnsXszKZ2
Z1F6Mim9GeS+NHJ/KknaX9+9ZNVrUHtvv+Q7UO+kxPa4x3Xfi+9yTeh0Tuxw
Sm53TGkTpLbap7XwM5ptM5tsshqtsxssc+ot8urM82vNCmpMi2qMi6uNhFUG
JZX6pRV6ZeW65WU6laXaVSVa1SLNGqF6XbFafZFqQ6FKYwG3OZ/TkqfcmqvU
ls1uz1LszGR1ZTB7Mul9WZT+DPJAOnkwjTSUQhpOJgINH00ggI36/RvbfuOy
rWnxve4JPfcSu12Tu1xSOp1SOxzS2gXpbXaZrfysFtvsZpucZuvcJsv8RouC
BrPCetPiOhNhrbGoxqi02rCsSr+8Uq+iQqeqXLu6TKumVLO2RKNepN4gVGss
Vm0qUmkp5LQWKLflK7XnsTtzFbtyWN3ZrJ4sZm8moy+DPpBOHcogDaeRRlKJ
oynEsSTCeCIBuILJOPybrA9peeg63nr5CsgJA56J/e7JffdSel1Te1zSup3S
uxwyOgVZHXbZ7fycNl5uq01+i3VBs1Vhk0VRo3lxg6mo3qSkzqi01rC8xqCi
Wr+ySq+6SremUru2QquuXKOhTL2xVK2pRLVZpNIq5LYVc9qLlDsKlboK2N35
ij15rN4cZl82YyCLPphJG8qgDqdTRtLIY2nE8RTiRDIBKg7fnonESfPveS1z
WWlIruc8K5AvelPSkHfyoGfKgEdq/720Ptf0XpeMHqesbsfsLkFOl11uJz+v
g5ffblPYZlXUalncYiFqNi9pMi1tNClrMCqvN6ys06+q1auu0a2t1qmr0q6v
1Gqs0GgqV28uU2stVWkr4baLOB1C5c5ipe4idk+hYm8Bqy+fOZDHGMylD+XQ
hrOpI1mUsQzyeDp5Io00mUqcSibIvAVe0y9nYvAzUfjZCNxcGA7YMB+IlZFG
F5lfAG8S77Rl3WmUXjV4LZI+9yvpFV6+/rekWkGiV17Ut/gLsikj3qnDnmlD
HumD9zIGXLP6XbL7nHJ6HXJ7BHnd9gVd/MJOXlGHTXG7lbDNUtRqXtpiVtZs
Wt5kXNloVNVgWF2vX1OnV1urU1+j3VCt1Vit2Vyl0VKp3lqh1l6u0lHG7Szl
dJco94iUeoXsvmLF/iLWYCFzKJ8xnEcfyaWO5VDHsykTWeTJTNJUOnEqlQg2
UuY/ZmPws1H4uXDcfChuPhi3EIgFNi/6YMAm/zd4Db9893cawPv4O+05dxoz
b9ek3qqQecP1Q7XtazXE26/lmLfFL2k6qZkwFzZKHfdNG/NOH/XKHPHIGr6X
PeSWM+iSO+CU1++Q3yco6LUr6uEXd/OEXTaiTqvSDsuydvPyNrOKVpPKFuPq
ZsOaJoPaRv36Br2Get3GOu2mWq3mGo3WavW2KrX2StXOCpWucm53Gae3VKmv
hN0vUhwUsoaKmcNFjJFC+mgBbTyfOpFHmcwlT2WTpjNJ0+kkyEb/PRdHmIvB
z0fi58PxC6G4xSDcYgB2yQ+77INd9sJIwitU8/zqylUNOYQa8DHzTmPO7Zr0
W+XxN4VvsBZ48e9IM+6LUZXLNcebrQf1TvH5P/DXkRf2S5/yz5j0zZzwzhr3
yh7zyBm5lzviljfsUjDkVDjoWDQgKO63E/bZinp5JT3WZd1W5V2WFR3mle1m
1e0mNW3Gta2GdS0G9c16jU26TQ06zfXarXVabbUa7TXqHTWqXdUq3VXcnkpO
X4Vyf7nSQBl7qFRxuIQ5ImKMCunjxbSJIupkIWUqnzKdS57OJs9kSuz3m7kE
wnwcYSGGsBCFXwzHL4biloJwSwHYZV/sijd2xROz6o5Zc0OvOaPB3f8TvMb/
vHJL8ypGFbimnDsNWberk26Vx9wUhl7P976W8zP2fHnc4Tf/Ym+UHP+iFpY/
76XkjJnAzGn/rCm/7EmfnAmv3HGPvLF7+aNuBSMuhcNOxUOOwkGBaMCupJ9f
2scr77Wu6LGq7Lao6jKv7jSt7TCpazeubzNsaDVoatFrbtZpadJubdRqb9Ds
qNforFPrqlXtqVHpreb0VSkPVCoNVrCHyhVHylijpcyxEsaEiDYppE4VU6cK
KdP5lJlc8kw2GbLo7+eTiAsJxIU4wmI0YSkSvxSOXw7FLQfjVgJwK37YVW/s
midm7R5m3RWz7ozecEBv2qM2bVHgodAYwX/LKmhcI6jcoiiCBr5dnXyrLPKG
MPh6vte1bKermRILgYa7PELz63/Rru9csuut855Kyp4LzJ71z5nxy5v2yZ/y
Kpj0KJxwLxp3Kx5zEY46iUYcSoYFpUN2ZYP8igFeZb9NVZ9Vda9FTY9Zbbdp
fZdxQ6dRY4dhc7t+S5tea6tuW4t2R7NmZ5NGV6N6d4Nab71KXx23v5YzUKM8
VK00XKU4Uskaq2COlzMmyuiTJbQpIW26mDpTQJnJo8zmUKAmysgupJAWkoiL
CcSlOMJSDGE5Er8Sjl8Jxa8G41YDcWt+2DUf7LonZuMeZsMVs+mE3nRAb9mj
tm1R2zaoHUskcA5orOh/ZFEa1ync2wwmTBEUiKm3ymJuFAddz/O8luVwNd1S
LsVANulNMfRyrfk//4K1Xz/PC6tfu7B6zmJw7kJg3nxA/pxfwaxP4YxX4bRH
8ZS7cNJNNOFSMu5UOuZYNiooH7GrGLatHOJVD1rXDFjV9VvU95k39Jo29hg3
dRs2dxm0duq3dei2t+t0tml3tWp2t2j0NKv1Nqn2N6oM1HMG65SHa5VGatij
1YpjVayJSsZkBWOqjD5VQpsW0maKqbOF1Ll8qdWvL6SRFlNIS0nEpQTichxh
JYawEkVYDcevheLXgnHrAbh1P+yGD3bDE7vpjtl0xWw5o7cd0Nv26B1b1K4N
atcSuWeG3DdBykBDIlCP/bUcXuMGnXOXzYArEyECpdEQAY9rWY7XMizlUvVl
k9SuJPxczH2NwflI/b+/0q9f7PWLSxY/H6GTIeWthOYthxQsBRUsBhQu+BXN
+xTPeQlnPUQz7iXTbqVTLmWTTuXjjpVjgqpRu+oR25phXu2Qdd2gZf2ARUO/
WVOfaXOvcWuPUVu3QXu3XkeXbmeHdle7Vk+bZm+rel+L2kCz6mATd6iRM9yg
PFrPHqtTHK9lTdQwJ6uYUxWM6TL6dAl9RkibLaLNFVIlFr+9mEEGLZ5MWk4i
rSQQV+KIqzGEtSjCWgR+PRS/EYzbCMRt+uE2fbBbXthtd8y2G2bHGbPjiN61
R+/aovasUfsWyAMz5KEx8sgAcayHONFGSKwP9ejfXrmmeZWkdpvOVmBTURw8
XgVkAwAIvJ7vfi1LcDXN6mqqoVyy2pVEtmz8JWu+yS8kDK5c2vrLSzY/r7Nl
SAVrYYWrIYUrQUXLAcVLfsJFH9GCV8m8Z+mse9mMW/m0S8WUU+WkQ9WEoHrc
rnaMXzfKqx+xbhi2bByyaBo0ax4wae03buszbO816OzR6+rW7e7S7unU7OvQ
6G9XH2hTHWpVGW7hjjQrjzUpjTeyJ+oVJ+tYUzWs6SrmdCVjppwxW0qfA2xe
SJsvoErUJn0pm7KcSV7OIC+nkJYTSKDNY4lrMYT1KMJGBH4jDL8ZjN8MxG35
47Z9sNte2B0P7I4bZtcZs+uA3rNH79miDqxRBxaoQ1PkkTHyxAB5qoc81Uac
aiAeqMJlzqdbrsC1r1NU7tJZCDYZy8GQVMCvYm4UBV7Pu3cty04uzVw22VAu
SVMuUfFKHONqHOVGrMyLUb3zV2hk7GIE+3JuPe//5zNYLzP49QWDws2Ioo2w
4vUQ4WqQcCVAtOxXsuRTuuhdtuBZPu9eMedWOetSNeNUPe1YMyWonbSrm7Ct
H+c1jlk3jVo2j1i0DJu1Dpm0DRp1DBh29ut39en19Or09mj3dWsOdGkMdqoN
daiOtHNH2zhjrcrjzUoTjexJAEOt4nQNa6aaOVvJnCtnzJfRF0roC0KapN8r
LmdTVjIpqxnk1TTyWgppLQEAQFyLJKxHEDbCCJuh+K0Q/HYgbtsft+OL3fXC
7rpj99wwe86YfQf0gT36gAcyOLRAHZuiTiAG93URZ9qIRxqIR6qIx1z4UyX4
e4pwiSfcoHFgdDqaTcBzkRQVeSb3DrA98Hqu+9VMAIOZbLLulURV2XgluTj6
1VjKjRji7ZgLE1/u/9CYnGTU+5W4D3nAK2pQ5lyJvsTkPy+YFG1HFW9FCDfD
RBshJetBpWsBpat+ZSu+5cveFUueFYvulQtu1fMuNXPOtbOOdTOC+mm7hinb
xkmbpgnr5nHL1jHztlGz9hGTziGjrkHD7gH9nn7d3j6d/l6tgR7NwR714W61
kS6VsU7uWDtnvFV5ollpslFpqp49BWJRnKlizVaAWBbKGIsldAkT9nIudTmT
spxOAZmkktdTSBtJpM144kYMcQPAEkLYDMJvBeK3A3C7/rhdH9yeF3bPHbvv
ijlwxhwAWOzQhzz0sTXqGMSCPDFCnhogH+giH2ghHqojHqsinnIRz5Tg7yvC
P2TAP6aBcG7R2cAvY9k4wDvoqneUVG5ylW+A0K5l2YNkkgyvJmpcjWfLxdKu
xlBvRBNvR2Plo2XeoIZ++1L6lfx762K3lzBJOL3zMqe33sDp3N9kSMK9aOFu
lGgnomQ7rGQrpHQzuGwjsHzdv2LNt3LVu2rFs3rZvXrJrWbRpXbBqW7esX5O
0Dhr1zRj2zzNa5m0bp2wbBs3bx8z7Rw16Rox6h426B3S7xvU7R/QGejXGurT
GO5VH+lRHe0GUKmMt3Mn2jiTLcpTICql6Tr2TI3ibBVrroI1V8acL2FIOHFX
i2hrBdS1POpaFoCKsppEXk8kbySQthJI23HE7WjCdjhhOxjghN/2xe0AnLxx
+17YfXfsgSvm0Alz6IA5skMf8dBHVqhjc9R9U9QpgEofeaaDeKiFeCxBxYG/
pwT/gAX/iAH/hAr/jAz/kgj/hgAyIyiBpQFL9RZX5bo65yqwxQNMJOlAONOT
TdC6msC9Fke/FkMCaN2JJilE4hCRKFSkzBsy9W//kS+9xui/LzF6+9yXiKL9
mJK9qNLdiLKdsLLtkPKt4PLNwIoN/8p136o17+pVz5oV97plt7ol1/pF54YF
x8Z5QdOcXfOsbcuMTdu0dfuUZcekeeeEade4cfeYUe+oQd+IXv+w7uCQ9tCg
1vCAxkif+miP2li36ninykS7ymQbd6qFM92kPNOoNFPPnq1hz1UpAozmy1gQ
H7XlQvpKAW0tn7aRR93MpWxmUTbTyBtJ5I040mYsaSuGuBNN3I0i7IUT9oLx
u/74XW/crgcOcKWDe9hDCNGRAHPMR5/w0PetUPcBRCbIU0PkmT7yoQ7yoSaI
6IkK4hkH8T4bRPQxHf4pFf45Bf4VCf4tAf49Dv4nDAiKrnobaI6qqpwW94qe
0rvAFiDdW4DRLkFNNg6gxLoRS7oRhb8dhVeIIiAi8JhwNC5c5sXYyc/Ful+I
36y8XiZ04YHEksPY0oOY0v2osr2I8t2wit3Qyp3gyu3Aqi3/6k3f6g3vmnWv
2jWPutV79SuuDcvOTUuOzYuClgW7lnnb1jmbtlnrjhnLzmnzrinTnknj3gmj
vnGD/jG9wVGdoRHt4SGtkQHN0X6NsV718R61iS7VSRCQylQLd7qJM9OoPFuv
NFfLnq9RXKhUhOhoLhUxlgvoK/n01VzaWg51I5u6lUXZySLvpJO3k0nb8aSt
aOJ2BHEHoBNG2A/F7wfhD/xxB964AwCQC/bQGXvkhDmWALIBAKFPzVFnJqgz
Q+QDPRDQI03EEzXEUwCQMhwA9CET/gkD/hkV/gUZ/jURAoSH/wkL/ysK/gMK
8XckqNY0OLJA0wxYvwfeO8ilWsgm6V1JUL0SqygbQ78WTbkZjbsVhZWPxCAi
MZgIHD4MQwqVkXl97vXX/4DX5ZnJV2ZniWXH8WVHsWWH0eUHUeX7ERX74RV7
oRW7wVU7gdXb/jVbvrWbPnUbXnXrHvVr9+pXXRtXnJuWHZuXHFoW7dsW+O3z
vI45685Zy64Z8+5p094p475Jo/4Jg4FxvaEx3eFRnZFh7dFBrbF+zfE+jYke
9clutalO1el2lelW7kwzd7aRM1evPF+rtFDDhhjpLJcwV4qZKwWM1Xz6Wi59
LZu2nkndSKdupVN20sh7qeS9ZNJePGkP8KNw4m4wYS+IcBCIP/THH/rgjjxx
R/ewRy7YIwfMsT3mhI++D2JCSTA9MEQ+1EM+0kE+hjA9U0G8p4z4gI34CMBE
BzF9SYF/TYJ/h4f/AQv60V8wiL+hED8iET8hEM+B/yBeRvTfSUaarOSS9QFS
78Yqy8UygJh3PQoghZGPRMEjkehIBD4SRQrD0IJ/ltV5njl/vaw2LvQCoewk
vuw4rvwopuIwqvIwovIgrGo/tGovuGo3sHonoHrbr3bLp27Tq37Do2H9XuO6
a9OqS/OKU/OyQ+uyfdsSv32R17Fg3TVv2T1n3jNr2jtj3D9tNDBpODihPzSu
NzyqOzKiMzqkPTaoOd6vOdGrMdmtPtWlNt2hOtOmMtvKnWvmzDcoL9Qpn6u3
ctZKKWtVxFwrZqwVMNbz6OvZ9I1M2iaAKJWynUzZSSbvJZEOEkkHccSDaOJB
OOEgmLDvjz/wxR/54o68cMfu2GNX7IkT5kSAuQ8gskafWqHPXkakDSJ6qoZ4
TwXxvjLiQzbiYyb8Uwb8cyr8KzKYikBEOPifMaAn/f0lPj+hED+hET/gEd/T
kZIZdqDJRrKJ6lfi2FdimNdiqDdj8Lei0XejMPAINDociQuHkcJhtDAEMxil
FPgGVpKa510po/NRZ8Br7iecY4ktP4quOIysPAgHsFTvB9fsBdbsBtTu+NVu
+9RteddtejZsuDduuDWtuzSvObWuOrSt2Lct27Uv2XYu2nQtWHXPW/TMmfXN
mvbPGA9MGQ1OGg6P64+M6Y2O6o4N64wPaU8MaE72a0z1qk93q890qs22q861
qsy3cBeaOIuNylBdY7xcyV4pV1wtZa2VsNaFzI0ixkYBfTOXvplN28qgbadS
QTCJlN148l4cAIZ0GEM8iiQehRGOggnHAfgjHzzgOyceuBM37Ikz9r4D5tQO
c8pDn0FgHpigHhoiH+kjH+sgn2oin0FgPlBGfMRGfMJCfEaHfyEBQwTj2x+x
IJgfXgXzIwbxAwHxAxHxRyryMw2U37Ucl6tpPLlkoO2aAJt3oxly0RRI42Hu
RqNgkSh0OAYXgiKFwKmhMGYIjB0M4waei7qL1WWvzOacqwwpn9PE8vsJ5Sfx
5Sex5ccxEKKoigPQeSoBSnvBNbuBtbv+dTu+9dve9VueDVvuDZv3mjZcm9ed
W9YcW1cFbSt2Hcu2nUs2XYtW3QuWvfMWfXNm/TOmA9PGg1NGw5MGI+P6o6N6
YyO6E0M6k4PaUwOa030aM73qs91qc52q8+2qCy0qi81cyGtMV2vYq1WKa+WK
66UAH9ZGEXOzkLGVT9/Ope1k0XYyqLup1N1kyl4CZT+OvB9DOogiAXyOwwnH
IYSTQPyJH/7EG3cf4OOKve+MPYX4nEF8HpijHoJ8UI/1kU91kM+0kO+pIz9Q
QXwI8FFEfMIE+CC+pCIAgfANQcrnL2gpnx8RiB+BCIeGHAeIdgTknynIz7VR
sTeKgq7n3LuazpdLNpVL1JaNAy6CLhtFvhZFANLR3WgkLAqBikDgwgFEGGog
khkEZwfBuQFwNf8LpX1ZHVyM2lwe23l5zuZiXgIgmFR2P/GFnx3HSiGCETC8
EoyAIVV7QdW7ATUSV9v2atjyaAQgbro2bzg3rzu1rjm0rdq3r/A7lnldSzbd
i1Y9C5Z9c+b9s2YDM6ZDU8bDk0YjEwaj4/pjY7oTIzqTQwBE7el+zdlejbke
9flutYVOlcV2FYig5Wq98lqt0no1e6NKcaOctVnK2hIyt4oY2/mMnVz6bg5t
L4u6l07dT6XsJ1EOEsiHseRDAGIE8TiMeBJKuB9EuO+Pv++DP/XEnd7Dnrpg
zxwxZ/aYB7aYh9bohxboR6aox0YgxCcQxPfVkR+qIj/iID5RQnx67mRfk+Hf
EkGVdwHxb5CO+EkS/dCIv+MQf8cj/0xDfqOCyrhVkQCO1ed6Xsuwl0s2l0vU
l4tXAWTFlSjggog3I7F3opAKUQhkJBwbASeGwakhKEYgmu2P4PrD1fzgWr4I
Ha830YQqJomyeEVrvPPaljeRlnkbIFt6P7H0JEHmrdLjeBl0KSg/YiAFEnmh
QID8Vg3mN38p3S2v+k0PwEUbN1ybABddd2xdE7Sv2nWs8DsBuos2PQtWkIua
D8yaDs6YDE8Zj0wajY4bjI/pT4zqTo7oTA1pTQ9qzfZrzvVqzHerL3SpQVxt
Vps5a43K6/VK6zVKG1XszUrFrXLWdilzR8TYLWLsFtD3cun72bT9DOpBOuUw
hXKYRD6KJx/Hko6jSCcRUrSnAfhTX/yZF+7MHXfmin3ghH0ggNDaoB9boh+b
oZ8Yo54aoJ7qIp9pAv6JAPxTgvYzFuILhtQ/JQL+5fh54Z/PUYjnGMRPOORf
KchvVVH5d5rA6YKbJRE38n2uZTnKpVjKJhjIxWvIAboxmnI1knQzErg4tEIk
QBeBCUcQQmHUUAVmCIIdiOL4ItV8EVo+CF0vtJ77xejRq8rjn+P7lvjFLCzE
FlNylFByFF9yGAdJ/2hQ+u9Hlu2Fl++Fle+GVgDqfyewatu/etu3FkiNW571
m+4NG26N6y5Na6/E3a4lXveide+CVd+8Rf+cGQB1aMZ4eMpodNJwbNxgYkx/
ckR3alhnekhrdlBzrl9jvlddok/4K23c1VbOerPyeqPSRj17s5a9Va24Xcna
KWPtljL3RIz9Ivp+Af0gl3aYTT3MoB6lUY5TKCeJ5JN40v0Y0v0o4mk48TSE
cBpIOPPDn3njHnjgHrjhHjpjHwowD/mYRzboR+dInxmg3tNFvQ95KxhyOYiP
2aC3fg6F3K9JUskPIkVDqh/wUJTUW0GkaMSPBORfacg/KqE+9iAU3G3Nvl2b
Ak5TFAZcy3a5mmotm2AkG6cpF6skF02ViyTdiMTfBsEiEJFwTAScEIYiByHo
QTB2IIwbgFDzRWt6IXW9kAYeWAPXc8+9qJ//aaKvzWGA48bC/Vjwv71o0V5U
yW5E6W542U5o2U5I+XZQxVZg5ZZ/FVDQbXrXbHjWbrjXr7s1rgFInVpWHVtX
BIDa6ViSpFJrKARbDMyaDc6YDk8bj0wZjk4ajE/oT4zpTY3oTg/rzA5qzQ1o
QiyZy10qKx0qa23c9RbORrPyZqPSVj17u1Zxp5q1W8naK2fulzIOhIzDYvpR
Ae0oj3qcTT3JpJykUe6nkO8nkk7jSKfRxNMI4lko4SyIcOaPP/PBP/CU4nzk
gH1kh3nEwzy2Qj82Rz8xQT01RD3TQ72vjfxAQxp8L3C+CL4QTrCIQyP+hkS8
BZQHMnAgfYJE0aCH/p2C/JMS6hsddJr8YN7djrw7DRm3KhNuFoeAg45AQk0y
lY3XkYvlykXTAaLXI/C3IjDyEUhEBHDFAFE4JRQgimL5I5T94Kq+CE3QT1EG
7mgjN7yRk8zr81D/8S+xvVi3qwC8KdyJBscityOF2+GirVBojCuobDOwfNO/
YsO3ct27at2zZs29ds2tftWlYdWpeQUoKQRtSxDNc+3aCyZUKOROG49OGY4B
NMf1Jsd0pka1Z4a1II7OS71qyz0qK13ctQ7uejtno1V5s1lpu5G9U6+4W8fa
q2HtVzIPyhmHpYwjEf24mHZSQDvJpZ5kUe5nUO6nkk+TyKfxpNMY0lkk8SyM
CKB84I9/IEF5D/fQBfvQEfvIHvPYFvPECv3kJZTvaSPf10B+IEEJ5dHPGQBK
hESsfkeA//G8igDrcZRUr4qRCDHkmX+jIn9gor7XRAfAlxLlx3Lu9hTcbcm9
XZNysyQSDLyZDkBalY3Tk4tVk4thXY0iX40g3IzA3o1AwSPg6AgYPgy4ehg9
BK4YhFLyRal4IzS8kTqeAE2UsRvOxIloIqCY2L4hAp+Pb739L7OFcvVt4E3B
ZmThRnjhRljRekjxerBwPbBkzb90zbd8zbtyzbNq1b161a1mxaVu2alh2aFp
SdCyaNe2aNu5YNM1b9U9Z9E7C1YkgNYdmjIamTQYAxwUogrxdJsfUF/sV1vq
VV3pUVnt4q53cjbalTdblbab2TuNirsNrP061kEN86CScVjGOCqhHxXTjgto
x3nUk2zq/UzK/TTKaTL5NIF8Fks6iyKeRRAfhBAeBBIe+OIfeuEfuuMeumIf
OmEfCTCPbDGPrdFPLNBPTdFPjVDP9FHv6SDf10R+oIb8kAshVUR8BiClIb6i
IL4hSQvDc++Ev6jdwWCLfI5F/kRE/o2B+rMK+mtbnDtsI1p+OlV+MP9uR+6d
htRbFXE3igKvZbuCgTfeUDZWUy5aSS6KejWScCMCdycCDQtHoMJhuHA4KRQE
qxgM4wQiVXwx6h4obQ+U/j20kSvW1JlgJiCb8Wlm1jJv8FaQJXhT1L+Br6+o
4p9TxxBRcGA8bzUsfzW0YDUYnFFbCRCu+ImWfUqXvcqX3SuW3aqWXGqWnOoW
HRoW7RsX7JrnbdvmbTrmrLpmLXoAljMm/WDdYgjULaMTeuPjupL5MI/ZYc25
IfWFQbXFftXlXpWVHu5aF2e9U3mzXWmrlb3dxN5pOHfRKomL0o+E9KNCACbt
OAeIttT7ULQ9TSSfxZHOokkPIokPwogPggkP/QkPffAPPXCP3HCPgGgrwD7i
Yx7bYJ5Yop+YvQpTHfmRCuJjZcQnAEwm4gs6ABMOwiTA/4CHBmIgqQuIoYt6
EuSJQ/5EQv5IRf2Vg/6DAcZS44EDZj8YvpQMOKp8T8GdlmxQIYnCr+d5Xk23
k0s0kY3VkY3hykUxrkYSr0fgbodjFMKRyHAYNhxGDIXRQpAMf5Cqqj9cwxfg
idF1Qxu5YEyd8WYCkjmfamHNsLAAMPznGzLkq0Qvr5KEvFsO+Jy9FJKzGJy3
GFiw6F+46Fu86CVa9ChZuFe24Fqx4Fw171g7L6if5zfO2TbP2rTOWrXPWHRO
m3VPm/RNgQM2QxP6Eo3jPTWiOT2sMTukPj+gutivsgSA6+audnLW25U3WpU2
W9hAbN2uU9ypYe1VsfYrmAdljEMR4IVgmgSoHWdST9IBapT7YGAlg4E1ivgg
nPgwhPAwkPDQD//IC//IHffYBffYEfsYCKw8MLA+NUc/NUE/M0S99yJHIj7m
ID6VqFiAGhXxDRkhHYaWFChIqYp94YIYpBiPfE5G/V0R9WddzFfBJBOTZzbk
Uy/UZozCTKr8UMHdjvw7Dem3ymNvFPpfy3KWS7aQjdWXjVGTi1IEdO3VCPzN
cIx8OAoRDseEKRDCYJQQGDMYwfZHcbxBZaTthdJzxxi6YE2ccOYCogWfYmlD
t7RgWZkqWxm+ySPfetnvXmMH7Q2OzWbMBWXOBWbP+eXN+RTMeRbPuQvn3Epm
XcpmnSpmBdUzdrUztg0zNk3TVi3TFm1TZp2TJt2TxhJefiOjOmMj2hPDWlOD
GjMD6nP9agt9qks93OUu7koHZ61Neb1FabOJvdUAZkSA2m4Fc6+MuV/COCim
HxbSj/Jpx7mgr52kUk6SKPcBZLGk0yjSWTjxQSjxQRDoa4988I888Y/v4R47
Y584YJ/wMU8gXwMC5zMj1Pv6qA90UB9qIj9UQ37EhQoPRTAXgir1JVkjUalA
4Pw7NO4pyYUAMsDXnpNQP7JQf1NF/8EOb5D8nr7dJ2acpw7ogyCF5QT5iWz5
vvy7LRm3awCPC7ue63E11VY23lg2RksuWlkukgrkxRvh2DvhaFgYAhWmgAuD
kYJhjGBAt8K5/mhVT7SmO1iuGLpiIGoESz7Z0oZmZcG0NmXbGHJt9N7gd5eV
6r9d5Mqfmy0/X+0Hnek3wJvUqYD0Kb+sKZ+cKc+8KffCKdfiKeeSKYeyKfvK
KX71JK9u0rph0rJ50lzCMbB3zKB/VG9wBBzUHhvSmhjQnOrXmOlTm+tRXehW
WYJorrYqrzUrbTQqbb6QqhBNEeOgkH6YTz/KpUE6lQrq1CTy/TjyaTTpNIJ0
Fko8CyY8CCA89IUc0AP32BX3xAn7xB771Bbz1AoDOSDqPQPU+7qoD7SRH2kg
P1ZFfsKBciBTkgMhWXMxfg2GTen49U/Q4KgYhRQDDkhAPqeh/s5F/6CD+aMb
0apoT8/nM1Pj920oDzzR29EKc5nywwV3u/LuNGbcqoDcMNNJLslcNlZPNlpV
LpIpF0G8Fo67FYZWCEMiw2DYUAViCIwWjGD6wzn+MHU/pKYnVtsFMBjG+Jym
lQ3N2oJpA9A04vD0VG21ZaQczsd+Xo2gr+ubX762BRoB/C/gTfKYb9q4d+a4
R/b4vbxxl4Jxp+JxQcm4Xfm4bdW4jYScasuYcfuoUdeIYe+wfv+Q7uCQzvCg
1tiAxkSf+lSv2ky32lyXykIHd6mds9IG8ltvZG/WsbdqFLerJN7IAL2xCOR3
mEM7yqQep4PeKA2gAL9w4lkI8SyA8MCP8NAbSnuAK7pgHwOuaId5aoN5Zol+
Brnie/qo93WQH2giP1JDfsyVRk+oYIS/XDD+ReKKkmmitwBPlKE8B3Up8jkR
9ZyKes5E/6iG+as57rsEmkP9jF7CZ8YOH5mrvu9IOA5ErMUrTGfLDxTcbcsF
6smbJWHX8yCPjAM8UkM2ii0XQZYLx98Iw9wNQ8FD4ZhQBUKoAjUYxgxEsn2R
XG+EpjdC1xOj74ozcgSsh7fkkwCAVpYMG1NFnpGyrZ4KX1udr34RTd+58LNX
dOvPULw0HgStEf134E3KsEfGiFvWiEvuiGP+iADiFlE9Ylk7Yt4wbNI0bNQ6
bNAxpN89qNc/oDPYrz3cpznapz7RqzbVrTrTqTLfzl1s4yy3KK82K601sTfq
FTchejvlTKDuB70PiKVAlZgL0UujniRT7ieSTyHvAxQoQA9wPVCBeuIf3sM9
csU9dsI+FmCfAEWFNZj7npmg3zsv9z88VyyfQlH0FfkJud5f0WAUvVAsUEWB
FGMheHT0c2X0j4a4vzoQHvSrevV1W+SfGgV8Ymj0mTX9iRtyP1xhKUV+vEC+
J+dOc+btSkCTBoAOmGgBOaCKbCRdNpx4LQx3G3DAUAQqVAEXqkAKUmAEwdgB
CK4vWtUdpeUOqFGMkQvOVIC34AOGpFpbMqzNFG0AePpcvraanbqmvYqOvbJU
d0ruLhBfrAT/xT/thRf3qSX23wNPAqnK6LxBfuGgjWjQqnzQonrQtG7QuHHQ
sHlAv21At7Nfp7dPe6BXc7hHY7RbbbxbdaqTO9POnWvlLLYoLzcprTaw1+sV
N2pZW1XM7QqAHWNPCI7ZHEoq/CzA8ygngHRJIN+XJEGweiAC1cPDC3ZQbf/Y
DvOE9yIDSt1OQ+J2yE9fGnoD3e6lDHhp6kKMBMGJiSgxGfWchX6ujvnRDPeD
F+nxoGrYdKVz6ap+whd6Dl9ZaL/PB7oPcitOYS4bjJ+d+Xfq08AFvXleV9P4
QDa8Eq1xJVJRNpwsF4a/GYq5G4pEhMIwIQrEYAVaEJzlB+P6w9V9gVSI0XGB
BIwD3sKOaG1DsbEEjKpoY6zMM1Cx1VGz0wDYaQuU9RxYMlJfe/t8xeXlO8bf
wPDlDHnuf5CvxcV2uyZ2O6X1CLJ6bfP6rAv6LIV95mV9JlV9RnV9Bk19ei29
Ou29Wl09mn3dGoNdaiOdquMdKpPtnJk25bkWpYUmpeUG9mqd4nota7OauVXB
2Clj7IroALuDAtphLjQ6k0E5SSVDfkcC/S5cWvk9hCq/RxA7IGQ+htTLUwso
ZF4ITtDpkKDgZCM+ZyG+pF92ur9IpAviYoAN+Rx9zo6Gfs7FPNfD/sgj/C2C
OjfOS54tCKwdtSh4bBD8lTnvQwv2By7EkyDYeoLCdJ78QCEYOmsSbwqDrme7
yiVZA0X+lSjOuxHUK2HEa6HY26EohRA4KkQeF6xACVJgBiLYPggVL4SWN0rX
HafniDN2wJvbEax4JBtLGs8MsC7ETledr6lpp6oj4Og5KBo60mUkt6hcXr33
j8j9IwX0X1KSUPSNA7ZHtTvHtTskd/DTO22yuyzzu82Ku41Luw0ru/Vru3Ub
u7VbuzQ7utR7OtX6O1SHoGV8k63KMy1Kc03shQbFpTrWai1zvZq5WcnYLqfv
ltD3imn7hdTDPOpRNuVYgjJJgpIoRRkgcUNp0QfEz8dQBQ+iBOKnISRdJPGT
+yJ+fkkDVChCOrOBgVQoEkL5onyHCgccSkxBiQEfVMU8N8T96EH6exxte8Ss
cCY9oaXVvnbTMONLU+9PTQw+5zGfuaMOQxVW0xUmcuR784BAeqsy5kah37V0
gWy82ZUYzSuRrHfDyHKh+Buh6LshCHiIAiZYgRioQA+Esf3hXB+06j2U9j2U
gRvWyJFgwidYAiitqDxzpq0x29YAMLK6rZamnZqOPUdfwDZ0ZJg4gbdMXl5L
9s4rmvRiZdk7UlEqc6GCztesg3daRDQ7xrXYJbXy0toss9rN8tqNhR2GZR36
VR26de1aTe0abe1qXW2qva0qA9Dq1/EmpalG9my94nwta7GatVLJXKtgbJTR
t0poO0W03Xzqfi71IItymE45TiGfJJHuA7yiQF4StfnA55yXE1Tr2YLjoUCF
/swE9b4h6gNd1IdaUNXw8tg25VyqQLykhR4CLgONhiqDQVMqNEHHEytjnmtg
n1sRnruTf0xjnA0Z1E7H5wyK3HsnLEseG8V8aWD/rZnGJ3bkx16wvRiFxWyF
0QL57oI7jUD0jLie63k1hQdkvnfDub8Pp70bCrrfrRCkQggMGayAD1KgBMIZ
vjCOH1zdB61xD6PjjDFyBtIewcKWZG1F4ZkzbE0UbQ05fF01vhZgZR07FX2B
kpED08SRau5MtHTBnTN4ndvle7B/KfUvaG9wwW5ovSCm0TaxySq12Tyz2Tiv
xUDYolfeqlPdolXfotHcotbeotLdzO1v5Aw1KI82KE3UK87UseaqmQsVzKUy
xmoJfV1I3yyibRdQd3Koe5mU/TTyQTL5KIF0HEc6gSYiAEZn0FgnoCgfQowe
QfX44/NRFEk5ADAC8xoH8QnAiPkKIzA2osHYCA6hIF8VJHiUmIQS00FEYm2c
2Jrwkx/lxyzmxwOa3VNhZXPJIWMdDs1bxvlfGAR+a2b9iTn3E0eg3MRuJ8Hn
cuWHC+925N2uS7wpCrme5XY1xUo2TuvdcMXfh1JkQ3HXQ9B3QuDwYAVMEORW
AXBFHwTXC67phdK5h9NzwBkL8OZ8opU1mWdOtzVh2Roq8/VU+VoaduqAhfXt
lY0ELFNHmrkTycoZb+OM/ceU3pJGx7fPn/UALuINqrGPqLWJr7NIaTDJbDDM
bdQrbtQpb9SqadRoaFRtaeR2NHJ66pUH6pSGa9ljNYpT1azZSsZ8GWNRRF8u
pq8V0jbyqVu51J0sym4aeS+JfBBPOowhHUURT8IJ94MJp/74M2/8A4CLK+6h
k3QAGvQdU/STi4kEqcxHglwYiM9p8BdDWziQiyTQ/XgBBfAbCRcKWsxAi1Wx
Yn2cmEf4KZj6Uy7zW6BSmfZu2gpKni33HJi0L3tonPaVufcnZiaf2ih96MG4
H4raTFWYyZEfLLrblnG7Ov5Gkf+1dAfZeJMrUaq/D2VdCaFcC8HeDEHcDVZA
BCvggmCUAAWWP4zji+a6obTuofSBcOdAMLElWtqQbSxotqZMW0Mlvh7XTlvd
TkPbXkXPHnxkg6kD3dyRbOVM4Llg+I6Yf+w/r9YGwC7QCEu0fwU/tNI6utos
qcYoo1Yvt067qE6zrE69pk61sY7bWqfcWavUW8MerFIcrWRNVDCnyxlzpeAa
8qVC2koedT2HuplF2c4g76aQ9xJI+zHEgwjiUSjhOJhwEgDOsp954B4AWKB5
AekUjxn6iRHqqR40uQ7N70ikxGcAFir8S/KL0lmafxAvYZHoCAkWFkashhUb
4cV2RHEQ9adCxb91cfdm+QObXkWrmWHTHd51GxZlH5rHfWLp9qGx7td2yu95
YI8j4WvJCtP58v0Fd1ugXFTgfTXNVjZG790w7pUQ6pVgIuAxt4NhCsEKaNBj
4FQfONsHpuqLBIKathPaEApq5jyStSWFZ8qwNWLzJUJeQ8teVdeeYyhQNBWA
z2mwciLynLF8Z7S9A8rBHvUmv5FUZ+dzDP/oDlowL4H3EstEgdGu3DK6wiSh
0iCtSienWrOoWq20WqW6mtNYrdRardhZxeqrYA2VM8dKGZMl9FkRbb6IuphP
Xc6hrGVSNtLIW6nknSTSbhxxL4p4EEY4DCIc+eNPfHD3PXGnbtgzJ+wDe8xD
KLBJSD3RQz49X8vykWRsWEKKBP+aAP8OB/8DoBRQUlKgUkAinl+QkiQeNkas
jhUbg6SeB1Gf57N+6uC8P2cwt+FUvxORvFoe0Tnu1LRvXvSpVeQHJnZfmml9
YU996oM5jIKtZChM5sv3Zt1pApJQ+PXce1eTLa9E6VwJ5ciGUK8GY68HwwFY
8CAYLhDIQDCmH1LJA6HuidDxwOo6Yo0EeDMgtlmReWZ0W2NFW30OX0fVTlPT
HpR+BgK2iQPT3IFm5Qg+EsDOBSVwQjoKkM585M+yurza9ufuPXv1XjMZcOV1
cKl5dJlRYrleeoVWboV6cYVqWQW3pkKpsUKxrYLZVc7oK2UMldDHoTvx5gop
C3mUpWzySgZ4C8BmImk7nrgbQ9yLIOyH4A8CwDWWx9AisftO2FN7zAMe+qEV
+pEZuHJFwuuZOuJ9LuJDJcTHLMSndHBlMsjrZc9CgUrhR4SEFxIMeFiURKGL
lTBiDZzYlCB2ID0PoT3PZv3UxvlmRmtn3aZvx7dgLT91uM2vZ9a2/rFV7ofm
gZ8a2nxvpfGpq+IjP8xBLGw5R2E8DyyaG1JulgAZyVku3vRKuPrvQxRlg8nX
gtA3ghDyQTBUEBzvB6P5Kyj5I7keKA03pJ4bxtCJYMwjWNiQgJjHA3KRgTJf
VwXMRYC+4wL6ztiBaQbyIvOc8ICJHZyRTo4IF3uEmy3i5/3r/87sTfcHykQA
XwQIzaNKDBPLdNLLNHLLVIWl3Ioy5doydlMZs72U0S2k9xfThouo4wXUmXzK
fA55MZO8nEZaTSZtJBC3Ygk7UYTdMPxeEP7AD3foBa6IPXbG3BdgTm2h9WJm
qIdGqMd6yCfayKfq5yv5FBGSJbBfXHgXtAzlr+gXIlyangARTkJDtLBiXbzY
kigWkMSB1OeZrJ8aOT9MqD9aM5ndda5ZTSuaK40d6rvXvWFV96FV2ocmPl8b
W31vp/eRM+2xH3w/Fr6cqzBWKN8NlMnxN0V+1zIcZGNNZSPVroTQ3g3CXQ1E
3QpEwgJgmEAFUgCC7g1T9oGre2E0ndAGzlgTQDzYEq0kodCQDWQovpa6nbo2
IO7slUDl4ECzdCTbOBHsnDAOLgjAxG6OcDc7uDsP/v/A6xdSpX79nJNvkVm4
0CCxRCu9VC2vhCsSKVeK2HUiVouI0VFM6ymgDeRTR3IpEznkmSzyfBppMZm4
kkBciyVsRBG2w/G7wfg9aHX5oTu4ZvnYAVwNe2oNrbg0RoHLLbWRTzTAdcrv
SwgxpIS+IsC/xcG/x8D/dB7/Xql4pYQwYmWsWBsP+hNAyI/6PJ31vEb5+Yja
p8sG27vWnauxtRtpOZN1QRMjTt2HvMpn5omfG3r+0dz6W2vuZ06Ex/7IvSTY
YqbCaN7dLkDnxd8s9ruaaicbbQCkrHdDyO8G4q4Hou4EIhABCLy/PDUAzvRG
cDzgmp4oXResoQBnZkewtCbbmNF5khAIJSs7VUBDQMmKbuFAsXEk8J2wDs4o
Z2c4QAiwracdzMsG5mOpIPPqMwr/FU6X70iEnolhCvIqMAkr1I8r1kwXqeQJ
lUXF7KpiVkMRo7WI1llA7c2lDGZRRjPJkxmk2TTiQiJxKRa8B3Y9HL8J3ZC2
64s78MAeumKPHMHV5fd56FNLcNHyQwNoUbkG4qkqtKJcEbxzBrwtgwyS+gYi
9UdAgiPBMunHlwtaMPJBpNhYsSZObAxEPjJASpzEfF6u9LxP9Q/zOmdbZuMr
IV374ZULhQlLjb5jc3bdD61KPjaL/drA/a8mxt/ZKH8MiM8g2G4ibAEonYrl
OzNu10AGkoHpANHvd0GkK4GEmwEo+UAYKhBF8IHRfRXA1QhuSKDA1XfGGtvj
LXhEa0sqz4Rpa6BkC4Q+TQ07VaC0NbBnmwgYFg5Ua0ci3wkncEI5AZycYB6O
Ct4CBcDAvtby/hbyMv8PrC6PfUCswHk6r1zjsALd+EL19GJOfhFbVMiqKmQ0
FtDaCihduZS+LPJQGnkslTSVTJxLAJ9psBSBXw3Br0N3zO54YffuYQ+coXtp
bKH7NMxQZ0bQ0nIt6S1O4O0ZDPjH0P1NXxDgX+Pg32EgSQGmqBdrKqERJIgS
HaKkjhObARGPLPaiimMYz4Xs5+3c5zMaH60ZrSx7j+/7dawn5m8II5e6PUfX
BC0P+DnvWYV8ZuT2JwvTL+24H7jiHwYjdlNgCxI+L9sL/HwXfSMAA/eHYQJg
JD8k00uBA8Q8d7SOM9rQEWvGJ1iB7sTgGbFtoYDHBwIeFwh4xgKmuYBm5UCy
dcQLnDBOzghXJ9g9AcxLIO8rkAd+I9D6bpD53Z+ldD4SeL4C4XJ8hPKSwb0s
47A87fh81fRCpYICxdJ8ZnUevSmP2p5D7s4k9aeBTwoaTyBMxxPmosHHSywH
4Vb9cBve2C0PzI4rZs8Rc2iHPrZG3zdHnRqjzvSRD7QRj9TB+zWfKZ3fykSB
f06Ef4WDfwugQJ+rOwiFGCGRdigxAXIYRaxYDSc2JIh5JLE7RRzBeJ7Hft7I
eT6q9t2y7uGS8+qe2/huUM1+StpORcTMmMfQtlvloXPiA9PI70zdvrc2+5zH
/tgZ/SgYtisD3ScK9UOwJyPhfki8312KP5zlBVfxRGjeQ+k5Y4wFOAseycqS
ZmPC4gHyQFuND8QysB4ysmeZCeiWDmSeA8HeEevohASM7+6o4ClQ8LaVD7C7
G8y/A5w/1PxOmPGdN3kKpL9fe6YoZHNd13SjoGzt+FxuRr5iYS6zLIdem0Nt
ziZ3ZJB6UokDyYSRBMJELH4mCjcfhlsMAp/kseaJ2XDDbDujdwXofR7q0BK8
TRa8g0wX+UAT8UgV/kQZ/h7rvO+T4F/i4d9g4d+joVyCOK96JKketLak5MGK
uTixHkFsSRLfo4hD6eJ0lrhSWdyr+tO85nuLvKNdu9VTp66TMOFBTvpSa+TY
nH/Hik/BNj/zqVHUX8zcvjcz+taG9akb4aHM+SgZ2B2RBF8YzVeB7Y1Uu4fQ
cUMZOmFN7QgW1hQrM4aNkRLvPBLZAZFIEYxEAoqNA9HOEefohHJxgt8DrOyg
4GMv78eTB7p4KO92hPUtwISRRrd+1s7XXs7h4CxkQIZWXDYnI5dZmM2oyKLV
ZVJaM0idqcTeRMJgHH40Gj8ZiZsNxc4HYhd9MCsemDVX8HkT23zUrjXqwBy6
CVwfcaqFeKCGeMSBP2HD32PAP6TCPyHBPifAvsLCvkWDXflPUFT5G1SlgBMK
GBRYTJLRYiZWzMGBWdqKJHamiP1o4nimWKgkblURT6h/vWjy3o750Zn12JFf
7V5K6WZJ5tRA5Ph4WO2sh3DXKvszo8i/Gjj/YGLwvY3ip6BlobtVwF6GYHor
cLzhGu4IPVe0sQPOzJZsYUm3MlG0MeDYAp1XXQuMHGxjeyByUK0dSHxHnIMj
2tkJcc9JalN/u7uBvLtBFnfCLG9HWd6KMbspue3pZ+x6+em2UH/WBHYPTNOI
zVTOzGYUZdIqM6gN6eS2NGJXIqEvBj8UiRsLw02FYGcDMAvemGV39Kozel2A
2rIFH+OxZ4o8NEQc6yLua8DPVOCPlOBPWfD36fCPKLBPibAvcLCvMTCw2yKl
QeJHST0h0T+SeA0oVHW82Jgo5pPFnlRxJEOcwxbXcsT9aj8uaH+1afD4yHzp
4F7ndkzLfmr5fGPqYldCz0BI3ZxT5Yl53rcmkX8ydP7B1PA7GeksieRpj3At
dySUNQlm1lRLM6aVkZKNnoqtpiZfRddeydCeZSqgWQqAcIC3d8Q4OSHBfOmg
4G0n78e/G8i/E2JzO9TidrjJbcCiccZSo77ZpjffZFPwIVCBKWpx6ezMDFpR
OrUyldyUQuxIxnfH4vsicEMh2LEg7JQ/Zs4LveiGXnFCr9mjNm2Q2xbIPWPE
gT7iSBtxXw1+xoE/YsOeMmAf0GAfk2GfEWBfgl0V9gcUKFP+BpcWaOfVGVpM
gUKuKhQEgK7qRhWHMsTJLHGJsrgN6Koaf1rR/WjXZH/PfmQjdOg4vG21qGS1
JnO6ObGzz6d92b76qVnBd8aRfzZx+5OJ0R9kpM82ANcpIrTc0PqOeGM+2cyS
ZmWsaK3PtdFWtwVSG0ffXtEYkImg0xPsgNDqKA2tYF6zu+tvfTfY5k64za0I
81uRxrdijW7GG9xI1L0hsehlXSGx6K03WVQN2N07UT0ulZWVRhWmkKuSSc1J
hM54XE8Urj8UOxyAGffFTHuh59xQS46oVT5qwxq5ZYbcMULs6yGONOEnqvAz
ZdgjFuwpHfYBGfYxEfY5DvYVBvYd4PkoMIn9cNE5JW4PiHMG5PaaeLE5SexI
EfvSxNFMcS7QObniPrXn85pfrxs83racX/WdOwwY3Uls2Sgs3irLHamPHBp2
797h171vUfC1YfTfjFz/IiN9TiMY8nB69kRjG6q5OcPKUMlGR5WnqWmrqmen
ZGTPMBNQrByIfAfAzaWhU2LFAP6dIKs7Iea3IyxuRZvfBKwYp3cTsGKy1vU0
9esXTyp6zZK3pXEUylMqoF6LV4tPYWalUESJpOoEQks8vjMa2xuGHQjEjPig
JzzQ066oeQfUki1yzQq5aYrYNkTs6cAPNODHXNgZG/aYCXtGg31Agn1CgH2B
hX2Nhn0P2A70bTBq/ohCvuiKVEiIqeHFBkSxDVnsShUHA11RUSxSBqPmqPpf
lnQ+3TDaWrq3ueexehw4spPcuJ9VMV+YOtsSNDXp1rfPa/rYvPB74xjQdtAd
ZDeBN2QjS7q5CctKn8PTUrdV07blGNgBOYdm4UDiOeDsHdFAye8GJhx5b768
P/9uEO9OqNXtMNPbkSa3Yk1uxhvegKx2I1X9eqbK9TfM6knsdvfSVmh0jQv2
wDiVmERGdhKpJJ5YG4tvjcF2hWH6gjCDvuhRD9SEC3LGATlvi1y2RKybILb0
4Tva8H012BEHdqoIe8SAPaPCPiTBPsXDvsDAvkHB/ogEkzk40PKi46HFZIw0
32gRxKYksQDoeHSw42WzxdUccbeaeEbz22W90wXBybbj8anLykHY4HFs015K
0WZJ3Hqn/+ycy+CxTcun5kXfmcT+CQyGV86txzQzYlvpcHnqGrZcXT7byI5h
bk+xdsDzHTEOjghXR5g7EALtwRAYYH0nxPp2uNUtwG5RBrdAu+ndSNa+kapx
PUPlerbS9QLW9fPZsNesJ/8m/1W6F60Sm0DLTiCWxhDqonDtkZjuIEyfD3rI
AzXqgpwUIGd5iAULxIoJfF0fvq0F21OFHSrD7rNgD2mwp2TYhwTYpzjYl2jY
N5DD/kUiOaFq+qUehwN7nD5RzCOL79HEgQxxAktcqCxuUBEPqP8wq/3BrNX7
G7xnJ/z7xx6LZ/69j8JrTtKzDqtiNvuCppY8u0/5LR9aFX0hI3k2I2QzjpWW
qq2KFl9J345pYk+1FBB5Dlh7R6QzIN4dFDztIfe0vRNkeSfU/HaUxa0Yk5ux
+jcTdG4kad9I0biernI9R/l6HutaEf2aRMNetplkLdXlp71DNmM7hKvGxVFy
YwilUfiGcGxHKLrbD93vjhpyQY4JEFM8xJwFfNEYvqoH29CE7ajADpXODUaC
DIaFfYWGfYcEO9pfIBf9CZy5gHoZCXMe3ghiE5LYjiL2oInDmOI0triUI25V
FY9qfDNl/NWq6ReH5p+c/Z+6rjsqiizd9+7O+2Pfvj179p2z71gdqit27gYa
aHIOTZYgShBE18DouM6IOWAOzKqMWcYw5gQjKgyCYgKGIEFAJEkYdxydnXHG
sEq+5+y9t6oZppfHX110dd36ft/v+33fvXXr3qSW7ow7vQsud6083LJnZ9MX
GyqurSj6esHVltRzfUm5TxHLptgQC0jyDk1xi0x1jp3pkJimT05Xp8/i5qQx
82fSmUn04iTlJzPIrARyWTS5Klq+LkqeHSbbEISw2uon3elF/N2N2OciPeBI
SGzr9Nj1R23/wWvPj6ubW/oyn/VrHXetMhxarj+Vpb24RFOQqS6crSpK5W/M
4G7Gc3ej2UorWx3IPvBlHnoybRamy5npg0AZmOdaBNRrFfue5wYnhqMR51RY
WPsaQKgR5YE0Mw5HN5DjCT73AZf9h0uDByqt75si3nZGP30yvfFJRmnXonMt
mw80HMp9cHLbreJVxffnljSnn+1AKOGKFs0Tt6a6RM10jE8zzEjXpM7iM9Jh
X5DJhHRKohYnKJdOQ1IPE+bqcPn6cNmGENkmjM8OL2KXO+ISxCfPSJzWSQVS
2ffZxzGy3xcA89oCz8tebdq9XH9kqe70x5pLi9QFc1VX0/ji6dyNePZWNHvX
ylYFMnW+TJMH0+rKdJiZHhPzVC8C9QqLvjCF4xfFd9aJ8RdpAklOYvytdwd7
vMAJX3AlYPRm8GCV9V1TxOvOmN6upJrOOUUtK04+2HWiNfdg5ZmcsqJVN8vn
ljXOPf1QIlaqiE0xacaEdG1SuiotHZFobjKzMBkF3JJ4MiuWXBUnXxMlX2uV
Z2OEtvhJt0MGuRN7XIiDTgihkzppoVY2TiUw8S1++xhUTYYVmv6RvdK4O0uX
9zft2Y/UlxeovszgryVzxfFsaTRbbmXuBzE1vkyjJ9NqYdqdmCcm5hsBKLWY
HYeEObpizYvjzssWd8kYKCE17vMCp5BQDd8MHqiyDjyMeNkR19Geer9l4ZW6
jZebt52t3/f57XM5d/OX37/14Y1qiVh7opoiNl2XmKZJnqmaNRPxaEEyvXA6
9fF0cilEKUoB42xthCzbKtsQINvsJ93mTeRAiFyJ/U7EESNxQkdc1shuqOR1
PDkOlGSSpxUCSurJUHKGp29Yod/zifboIs25D1X5c/jCVO56IvtVDFsWxtwN
Yqr8mAdeTLOFeWxmuo0CRMyPKvYNj4JuGPVmVWNQmvS2BOhlACHj0uQiStMB
b3DGb/Rq4NDNkIHKsOFHES8eJzS3pJfXLStpWlf0aNPlqoOfVx7f+fWFrOqy
JcV3kBUKG5Omp2pSUlQZyez8FHpRsnJRgvKTBHJ5vGJFlHxVmHw9VKFg6SZ/
6VZvYqcHQuczJ+KwiTiuIy5qpGUqeS1PdrLU+HNSW4T9Bz4aUZWwHqLpJpuW
aXP/pjmWqT4/j89P567OYIti2ZJw5lYQXeFH13jSjRb6kZnuNDL9euY7LNlv
VEiGRsURSKzXUIYseiRDYSaQ4AhmmUGmC1jpBnZ4gkNIr0cKAwdLQ0ZqwgYf
RfU3J9bXZVbUZ91rW17WsDW/Nvdo3cHt9eeX16FdfoSV4dGyQKkzVBnT2QUz
kCgvSSA/jiFXxspXR8nWhMqyQ6QbA6RbfIgdHsTfLcRnZoTFMT1xXiMtUcsr
OUU7S73gmFcaXljFaRwFkT6C+ugm44rD5qWavQvVx+fzF2ZzBSnstQS2OJIp
DaZv+9FVnnS9hW52ojtMdK+eeaZhflBDNNhfoWHEud5NDwKMIMIBTHME6Waw
0CbKR3zGzvkNfxk4cisEPLC+aorpqpvZVPdhQ+tHtW1Z5Q2b8pt25DXv29F0
ak1NAR7Os6Exexo7P4FGlc80xdJoxYpI+ZoI2fpQaba/dLMvsd2TyIE4OBMH
HIijeuKMRnpNJavgFe0c9YJlBmB8QxX00WFl+Q80hLpIPxkaxs1L1PsXqE7M
4S+kcQWJ7PUYpsRKl/lR9zypagvd5EQ/dqB79My3GuafKvY1zw7ibp84PIHK
Hh1w1wM/o0gMCMVHrmCtO4LisM/oGf/RwkBwJwTUW1/UxXbXZHQ2z2nvnNfQ
nFXeurqgbWNeW25OyzGEA65A/g9+WBBHL45TLkuQr4iRr7BCcZVmB0k3+hFb
vIidbkSuM7HPgfjcQJzUEFcwAi2c8juW/hfPId+4aoUZceNWzhPXORT267G3
3rB1serAXP7kLO5iEvtlHHM9nL4RSN/yoios1AMz1Wqiuw30Ux3zvZp9xbPv
eNRLQzWMmJqFjANNd/jF9DXuIgvO+INrgeBuyGBt+POvpz9rTP5H+8zex/Ma
Oxbd7lya373uaMenn7Ydlgh1hOQv8MPiaOWyqfJVMADCZOuCpRv8ic3exHZ3
YpcLsdcRS6WWKFDLbvOKBpZ8ytKv4P1ASTfj9Z//P7vt97rBdut2LOIPzOZO
p7KXEpgrkXRRMF3qQ911o2qcqYcOdLue7tMyz9XMz9jooXF/G7C/PbC/wyH1
ncAs53Gjxw77gHP+oAgZ/bYy+nV97M9t8S97EnufpDX2zr3dv7Cgd+Wx7m0S
sSpA78tkRShWR8jWhkrXB0o3+hLbPIgcLHwHjcQxKHxqaQkvr+PIfmgrxw5p
VahsjDOK668INv3Cb9NE5dPkZHKHZrFnkphLU+nCUKrYn7rlQVW4UA1OVJuR
7tHSz9TMS2gepjOKbJ16zIB96mYzLx6bt9gVrIPmeQFknh+4Ds0LHqm1DjVH
DHRG/9Qb39Ob3NCXca8/82oPetyH89Of4Yc1YdJ1QdINmLg7LFP2QOKaiDw9
cVYtvc7LarCcv+TYEYgsDCOrQVi3dNxvjnZ+w2t2qz+dz+alMWen0Zcj6auB
VKk3dceirHaiHhqpTh39VI2CFKa0EY4T85ngMWiSrxFYsUkZ2KTV7mC7Jzjo
A077gcLAsfLgkSrrYEPEwOOoH7riu7pTartmV/VlFncjk4R9kdC7MNkBiJJb
3adASuY6TDk8IQxbWeX3LPNOzSMUvfX4+cBv4O3/8r6G02QW8Z/+lT2WzJyb
SueHUtd9lchJZuUDE9Wmo/rU9Aueec2xA7gmFnsO0EMWwRwTiHMEac7gQ1eU
ibZ6gn3e4KQfKvVKg4fvWQerwwfbI1+0Jzx+nNLak1bbi9ep0Ik1mOQPO12J
3U5T9hunHMVhVcbJYVh9y9I/qblBg9o2Bv1rG8yT2cDlpDPHE+nzkVRBgLLY
U3nbVVntoHyop7q09LcqBjr5DY+qMFyr4q6PYECICcQ6ghQzWADrCzew2QN8
5g1O+IGCgNGvgoduhg5Vh71rjfq2NeFxc3JPf3LDE2QA1rH/hh8+M005rEMJ
8Sonq+HIJywFYwRiJI5rfTBegzuLvMKRz+xOpU/EURes1BUf5VcW8o4jWWdQ
tmmpfhX9T555y+G6GoYDLIRgreiiR4VQsAnEOIIkM5jnApZawEYPkOsNjvmO
XQoYuRI0fCMEhsObh9F9ddP626Z/05csEWIR7z33wSMWP9DAf/8l3hfug+Id
gyZiiccJ6L1J9Mko6mKQstCTLHUmK4zKJh3VpaafqRgowTARD6tVo0h/tbji
N4BAE4h0BDPM4K8uYIkFZHuAXV4gz3f0tP/whUDIhLE664/VMU9r47/viO/r
SkX3IXhR8qs50ui+hDVLLJPdl/JAInUqTHnJj7xmIcsdyRq9sk1DfaOif+SY
9zDaeExPoxBtBpwPbfq42ILy4U4UbaNH/UYvBoCy4OFK6/M7MT/Wx7zqQs+c
8W5P6A6EtdDdJrsD8lCc8nQwWeBFFpkV94xko07ZraKe8cxPPDsgzrrA5BKC
PdQBxDqBmTg6VriBLZ5jud6jeb7gUgAoCXp3K+znu5FvmyLfdMRIBK35wDbr
TuIu8gVzW743WnnGn7ziTpY4KKr0ZKua6udpSGlUB6hwPSTQxHMCTea6gE/c
wAaPMaiaR3zBeZQUXheHva8Ie98YIbLjdzZG4h2vJlqLR9tkB8PJc96KQhdF
mUFRq1V2qKjnHDL1X2j1LlynQyFwN4AAE5LqRDPIcEFIw0y00wsc8oF1+lhh
4HBJ8FCFdag+3Bb5H9ie6ki87FrFtkvXpijzQsgL7orrjoo7OrJJrezF1sI+
AgyKUb1mDA1c6IGPTU0FgJcL8uMDvvAbyw8YLQkavR8i5gLUorBLlLddi3hE
Fg1jbZlGHg1UXHZT3HBQVGrIR2rqHygSkVdHUNKFTNcjpgeZQNQ4vhaIr8B0
AV9wJ1isJVCLuJqS+IiexC0RQss5UxXHfRUFLopyI1mnJrt56geOGYIMhvwR
1dWA+INqGieQDtO7RUwW+7G65gfYqlbUDu6z4p3WJlr2pwntwb9dkYovPOVf
Osohoo0qhCj0IyoihTCG5PE2giAHEO0Iks1gvivIQuQBu7FxZ/1tvSjUgLCj
ob9de3g275SJVW9uqPyURX7VKL+vIdt4RJ03WDlE3sAI9TeBCEdbBWMzcZ+3
OEaCbMOVkyTArq0/2h3jbP2/ewPlZ53lxXp5NYSUo77nmfcqzFMjdh60L9gB
THUCKc6ifRs9xFE+1JKwr2ag6C37FrCK/3m/r+y8o6xUq6jnyW9wPfRWww+h
iJ9ojhnMdkHmrEGbBQi7B8ILYaWVBNtdd9L5uH866CW7aJSVq4W6mnnLc0CN
zTDDVPArMyTiExrUgrCvaojdFe2fWOF3U/542E2Wr5dBx3Rw1EuWfa3mURVr
EohnEohne06Jru2Drx1qdy37kXNcE/7hiKvsilZWzZM9LAUjCOUKg2YUJQoj
VApbTkc/w36VWO2uYj86io9/f9RJek0te6Ain/L0MNQ9rXoM81YyIddidCVh
YMJ7GnZ3K6xr9ZBVfscxkP2S307IiGH41xGTeWSS1aF/J/4qCv8qcjK+TDj+
H/HsWHx21GT8tfMZOsQ7tkqiwYSa1M6T6Joz8FlTJ3xr632jb1Pxt6hd1CWd
hY8kv/k3xb7UwQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115428073]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "50"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1054715],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmwdUFtfTxqmCiqKIYonYC5bYO767YAn2Ho0NS0ysEQtqbDG22MVGiCJg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   "], {{
     {EdgeForm[None], Specularity[
       GrayLevel[1], 50], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmwfcl2MXx+/7jsjIFjIayCbKHil7hAoZaVhJZsPWIGTzGklSiZLKyAwt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        "]]]}, {}, {}, {}}, {}},
   VertexNormals->CompressedData["
1:eJxlWwl4TkcXTomWlNZSqrUHLYLYmtDEd1tbxb5VldgFsVessbWK1JomRRDE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    "]],
  Axes->True,
  PlotRange->{{-3.999999999999899, 
   3.9999999999994964`}, {-3.9999999999997984`, 
   3.9999999999997984`}, {-0.9999999999999748, 0.9999999999999748}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->216614703,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125887659],

Cell["Use built-in polyhedron data:", "ExampleText",
 CellID->112689921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", 
      RowBox[{"Opacity", "[", ".8", "]"}], ",", 
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"p", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Dodecahedron\>\"", ",", "\"\<Icosahedron\>\"", ",", 
       "\"\<TruncatedIcosahedron\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590893160],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->670321022]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5532],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Primitives",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->336807952],

Cell["3D planar polygons can fold over themselves:", "ExampleText",
 CellID->75602352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145818814],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0, 0, 0}, {1, 1, 1}, {0, 1, 1}, {1, 0, 0}}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->230499921,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmetuGzcQRlfaXV0s25JsyfKtluLYcS5unCJBERQoCvRH+6sPYaQCEqBF
izRP0bfIgwrtkhxK3MOJKKsVYNlcc843M7xzf7n/9H7++/2nD+/uZz9/vP/z
/Yd3f81++uNj9ShvZFn2a/Xz23FW/f1P9Zf9+XGxWGT5fD5f2E82NV/ZD9V3
WT2c2dL31XezKuXy2z39rvrO/dMK5SnVt1DeBna5qVF+/rt6nLHetyG/+n9h
qpXLilL3wtZ9LapNYbZM3XxZN2sinjNr9Q0UOt5K2LlqdQerHWNVOCtnSLtT
a3cLH3cjuwJ2J9buOfT6G9rdQG/g87fwHxNjCdtja3sNzcMH2D6G7Vi1bcF2
Ym1n8Hmi2rZhe2RtL6B7ErSm1gfovaOcwYOzBIVxjC3lBL5cbEWZgDJLUJiX
kaWMENEjUNhbOygfWsoBfLnaijIQivflSYLSRfnAUvaCiIwvzxKUHZSHltJD
RM9B4ajSKV1EdJug9FAeWEpHKM5197kDif2V/qxIWSHTnv28SnDoUX/FKWtT
bfV5CRb77S7K+ytWa/l0ift6e1rwdDkKKpABvkhQ97RyNHaKgJopvWM7aph7
Q30KKuvvaxmJarVAvUlQ+yj3VKot13rS9f/CDXuoQ3MuocUA5R2V2424l+Cy
5ww1QtSyHB/aTLwd2bbmaoxJnqcJ9oGWT70/RmyuQ9ux91X2Odicuw9Rbqts
24eKkG3yfZpgj1BuqWz2IzdzuGnDCEy2UuF8yhxS5Qgq2jxuEtBR6cyiXwPH
oLLX+jWT61GpqjDSHDEcJNS6EoM6/yXVCqgNE2otiY3PdbVxQm2QUMtFjXOz
rnakqC138YEK1zrzJ2cRXWGi1Qri2VWUTHVm3dHVs8Qaek8ZM6blGbdOP1Vq
meyQ6luYOzu1LSOVM5RbiKGt7NlMdXVXnlQ7T6i16uc30eJcs5nWV4pW059/
C3f+dR/2r834Fyi3EUuOzHEXpKuwFWeaSrlUcdcD0ey9GfsRyn70SofM/iv/
MigbrNnFG3S+NfExyh2f8yDHRuVYiSxNC1vQRN1brM5S63x9ON0I2L640EeT
usZEZ9qrlALPflVVrqhcMx+gVIS9sFBmfa72m7HDOcH3GjOWTL44hrZTKCXr
nc/rVzOuMZvRm0L351Uj0n2gUvOLSuVyn7Jq5xRd3dtF9Evxm72oJ7nnLMkT
jaPaqN1DO79o44fr5F5i18d+FStdLPQdHNeX/cQuNq3k78D0c+ZKqS9ZYyzs
wbGC2bMUykhl1rjP5HmF7RUr+dsvdbcWKB0+UKkRKQ1FSd21BUojyRrbhT3a
K9Rb7os7tzUnjNSJNlbakfbh3pKj8jihxPaNldoSE/doVOJtLpWYzVjJ7+q4
p6HSqbSPem8RK9TOqubf3HGQz3NyifrUdTpGhrMwT2U83XOm0Mnhk+uEwlRy
o/ncqIqGWB8ZZpFIUVM30q2Ivm4XpinwJoj2ZaRgz2nVE5J5mr+SjDDXRURk
j50myPZuXH1vUueyVdm/yb1RuXEG/J10ivdU5cXxcy6wI74MR4/Zj95KPrme
NgPe6u5eZ7ysn7Dm7ty4sub6dKxS7iJK3QeuKBOV8kriCeaJJaEvUVjL2s3l
6+D8FlpwbRlFlm98T5ex5+z825u4vvHPNF6jFhtXmGFkZ9qpkH6fL+3GohP6
aYJ/FtQu/B4murnYh9WV+Oat3I0Yzz27kW+zQM00iLs19+/k4vrn8M692eGK
1IV3J2KVi4p7Z3cuKqw9klhy0XDvhDm2eJM/gGfubfdUNFh7Fx7ZuUs9Aduy
7Nvb8OzGWunz3soqh2cvrJV/9xvWNp888OrO1rwOWsHV8/pv7P+fVN/mldFb
F1vjX/mRJA4=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52427192],

Cell[TextData[{
 "Vertices can be shared by using ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->91248340],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ",", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ",", " ", 
       RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}]}]}], "}"}], ",", " ", "\n",
      "  ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", " ", 
       RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25898699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{"v", ",", "\n", " ", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", " ", "5", ",", " ", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"4", ",", " ", "6", ",", " ", "2"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"4", ",", " ", "2", ",", " ", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"4", ",", " ", "1", ",", " ", "5"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"5", ",", " ", "1", ",", " ", "3"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"5", ",", " ", "3", ",", " ", "6"}], "}"}], ",", " ", "\n", 
       "   ", 
       RowBox[{"{", 
        RowBox[{"3", ",", " ", "1", ",", " ", "2"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"6", ",", " ", "3", ",", " ", "2"}], "}"}]}], "}"}], "]"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359364606],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
     Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
     0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
     Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5, 0}, {
     0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {0.5, -0.5, 0}, {
     0.5, 0.5, 0}}], 
   Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 3}, {5, 3,
     6}, {3, 1, 2}, {6, 3, 2}}]]]], "Output",
 ImageSize->{104, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->195818511,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Directives",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16531122],

Cell["\<\
Directives can specify color, opacity, and specularity of faces:\
\>", "ExampleText",
 CellID->510772710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Cuboid", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], "]"}], ",", "Blue", ",", 
      RowBox[{"Opacity", "[", ".4", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "10"}], "]"}], ",", "Red", ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185549952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 1, 0], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{
     {RGBColor[0, 1, 0], 
      CuboidBox[
       NCache[{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0.5, 0.5, 
        0.5}]]}, 
     {RGBColor[0, 0, 1], Opacity[0.4], CuboidBox[{0, 0, 0}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0, 0], Specularity[
      GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->185437202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27161693],

Cell["Specify the specular exponent:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->225462722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "n"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "20", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->37956373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 5], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 100], SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->74595844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11262266],

Cell["\<\
Colors, thickness, and dashing directives affect lines and edges:\
\>", "ExampleText",
 CellID->899893768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Blue", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Red", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dashed", ",", "Red", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79475161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[0, 0, 1], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydl+1PUzEUxrvdjfE2YZvISxwiYVFRAkEBRVFEQY3hg3/Cgkvgg9Eg/36j
Pec+3bqndXdIgHtPz9NfT9/Obc+7N5e9H92bq4vu2qfr7q/Lq4vfa2c/r11R
VjLGfHd/35aMe//j3vTv3Fpb7vV6C+5pzFdYJnMv7imFd9Xz2f3PXEkGRV56
itIJsbK8glRvqfcE3qmk9xikWbEquTcXNNV/hNp3xKr2/WA0VHMITWOE5mUY
cdbXmDLZ2o7ZA3GxQF1X9S7UK2Opt6FukzcjW0fEbCHutbHUm2Cvk7dC9oyq
H0HdIW+V7GlVdxDJ47HU62BvkneCbF0V5gHUW+StkT2p6jYi2RlLvQL2bsrL
tc0i1HupOLkfuiuk8FUBO1c3EfebAraOqJkD+21qfHludf6l8P1Y6mlE8pG8
M2TrKtORkcKzRNxi5vFWYH1J9F1M3g1Zv5aWGmPll2tnNs4t1u+tnFHp5xTR
OgjHydknXT9HZGB8QLuz/64XZZoq6h65Z8XnrHTdEVnCUw7sINdGO72QynYN
1B3ExnuFZz5N5TwyBarPO0wZjyo99t+AsqN1bJDzb01L9Uxi9DlmHq0xvaQ0
ng1eN3XQlgNaanVzrGk678450FtE5xw7Hp1VDdDroEprlcTe4KjSdF6HLdBr
AT01i9xaml4newF0XYI9/+PbaPxXGxyZtCErIxyjBdJwZk+T51Ijj3kMx2iZ
dLx20/T5xFj53RePUTvRRsmZwk7zeTSlzz6fyVP26GohNTo9Uh4J18gEIr9P
uomRVJ6bkDgLIp/JqiOJ97ACPKUJylIi/tGUKAM5Uygyduy/Ha2GWWgjNh7b
7FY0PxMboDXJXy6mDb6fdnDmExav05AVcwSzYwcZalTNgcefwPZRU3NeNYzI
vZu4nt+RvPYPwJka7lmy7Tqi5ux8aAe7PLzxxIRpG9+N5PUIhEohwWcSzsbH
IEj/ysnowz0YlsvJR1ZpaXjMo1nmLHE21JLIeWWeYLyyKBbeye/QRs0W7fnX
YOa3Dt9bbvnABiey6BTDPXlhB7vfRPcbXtX+RJXfnfmcyqP7DGrN/Dp75cQc
PLHBHTH6mvFcd8DUO2L09eZTwEOoN1TNXq69ikj01qctl/1oB6oVMJ+qir+r
/FXzu31b1dx3HkF/Fnquah59nh1/ptlXdQPxps5PojpUVYu8nBMmbXATy79l
Q5nBZ2S9e+UnFaxyKT3V0kVYer8xpvQXfftM0g==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 0, 1], Thickness[Large], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydWGtPE1EQvd3dPiiPQimgxCoSG5FIbFRQRIn4AI3hgz+hIU3gg9Egf3+j
O7NnYHt2bCsNlJ29Z86de+dx73A6uDof/hhcXZwNNk4uB7/OL85+bxz/vMxe
xZUQwjD7/X4nZM9/sif9PU3TNBoOh6vZ3xC+QQpx9jDUT1jRkS/Zd5yJMRD5
2894WxNJHnK10NHRj8DOuKPvoTsrUpKP5oBlHX+H8QWRqtfj4Ggr5gAztEsc
+fhrcHRcjiXF7AKzVrBSHiOS1Y7wHOj1qdB92Nel0ZjkeUXvgPsBjSYkzyl6
G+jNqdBbsKRHo1WS1RuhB+7HNFojuanoTaC3p0I/AHqHRuska9SELuzu02jD
k8M6uF9M4M7Ra0DvTeBWbc0DsWTfs5NXrfEpLw+mQreAPvR2jL2lHpWXR1Oh
m7D7k+dpjhtdq7w8duyWBMs5E6C+OquxKlGK95vIDCGVnyj7OnGQXFFGGWQt
tUyT1xNTpaF5k+v6k33XM/0jzDTn6sQFnfwj80bQPYCu1cnU8sznGZP5xmhV
iLOXveSzspbIskd9sHL8T8fKtaEGVqs8HG+8A5HLyp5tgPURWOdvxcorbIK1
m+Zx24IHF6Zi4wowBzarGIv4y1Wf99Vn5yhdAPsSsbu1ucQ+yYZFsM8SO1vB
3vTZ2RttsFfB2sJ+sxd5Np+dtTpgj8AsQ+0JvvKZ2e8rJqMWJYUdWrnVDC2S
zZuWi7ZDdyewV1z2RWenzIvCLs9dwnBO+MxLjqfiwn4nyKJxOewzs6dsB8QX
CU4JqX18l/LZi7WWPZSA1aqS7AjvM2dTmVXuwMVIs8zhmyFXW5+Jc1LEVTCy
/VwhJjM2wHgPjLzX/89o3tkEI0ecqFYyUZj+wTZyXoqwBS6v6o7nEu1n0Naa
Uy1yS95GJb0OVrALvZmxeuVM5fjdA099dG2GHOGw6OMo209vsr/YA5UZmlg1
14O3YLDOq6xpdzauzXKbrKN6lrXsDsd1S+5FVWjBNyN+9Wqw3sWkUAztk2sm
TjU9wjqTkkUckYeYreFGSBH5Bpx59xJhpzqEsm6wldtGo1wHX4Iz7yTZr5wd
faDzProGCxhlHZ5WvFLl59PvCTi7iuYTlL3dA/qhovk051uB9Ww9Rc/CXkbd
T2/yOJTsY/vXgX6qaM55Po3sLqWdXen05DNgGdza2enuax9AKLt9vFLUpJpo
fZT2aDpD6ZSn1Qq39mjB/49CDZgPirGOsRi5UVror3QPhET7qBAqfwFXDlvF
\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
     Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV39PE0EQ3d71KAq00Bb5oQUkqSKIEImiEgiCAsZo4kdoyCXwh9EgX/+i
N3Nvy/bt4h00aXtz8/bt7MzszO63wfVF+nNwfXk+WDm9Gvy+uDz/s3Ly6yp/
FdeMMWn+/TFv8ue/+ZN+v2dZZuI0TTP9mK78mK/5b5K/nFXpLP8VSJz/R8O3
J5DGHIb8FwzHGPOAtB3VHkI7GdTuQ9sSqT60LX9oq34PM6uUDPXgmFHMO3B0
/4N5A8wc+SAiuanoHcy6SNqY5ClFb4P7SSX0JtDLpK2TrP4y60CvkjYheULR
a7C7XwndB/dz0o6R/FDRq0BvlHAX6BVY8qqEW3PG9MC9TdoGyeOKXgR6pxJ6
Dui3IS2PNrOw+33ITl6HaYN7rxK6BfRByGPsUc0WseRjKHacN8ohL48roRtA
nwTslk1YWJDAgi+B1dga4eW7ziCjctEYaM4IGYGBs+GGwa0UQnRK7yKqNzR6
pJLYmjZ5O96rGrp2pz4puACZME/QG97+vvHJLph533PEwuw8apzYt8DOe4Jt
j4LsvKeFXcg3wMoZW42Vo/0abFP3YuOVTSFiy9lNR5EsaVZi42rQJH8uOKzy
z32DoxaehTO2TbNMZ8X+s7MEK3HpLIxqI3qTYJ3O/H59OzuvlKPTI1aOJs8S
ZuVRc45n7H5vwTszJTPUgjNwHthKH6PWiuoRYTgrwswtkmey0VxZuBfrdMBD
topJnmsJSO2nR2jeHeE5Qp50LX9Kes7HMGub5IRYG05s5fFxAF8+Swfxs71E
4ivZITsxxinh7qw2K5pg3SQ9192Cxe0OfMK0nXkednGOCWMtF4XJZwtlpIhL
5MMu4eI7sdoIPSNWzuy7sdrIrGPlzBaVsiX586EaOByVoR54+C5mk74q+2Oi
4ji7WzkTLI9WxZHzhM9hs4Vz7JMju7OP9g0RuSbsw2cJMdQ8BtlNNu/d94cU
y6iUqZ45dzHnvb39YUTd9anAeL9/xvsCL/BZQhxlztlnxAbOoQOsrjHic7Gf
kR9cP3g9sROI7nCt3q7mFe2Au7iTcpS5im4BrRZqzRTvcT2390CtU15P4H74
Apw9RXPH457cB1rrt2ZwlPrnX3uj6yuKtTzHEjjXFM32sf2LQL9UNPde7k72
jqb3P2NPbozqgFPvfZ7XOYb2tLCraI4o54c9G+lNzssWrg3j4NabnFYe24nY
IkEdKcrN1xQXChH1DqYekGKldy1jav8ArOeCGw==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
     Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV2tPE0EUnXa3lkdbKG3lWQSUiAJCQgSUCAQi+Igm/oSGNIEPRoP8/Y3O
vXMGpmcHutjAtnfnzLl37mtmvvVuLvs/ezdXF72l8+ve78uriz9LZ7+u7auk
ZIzp2/8fM8b+/mt/6f/3LMtM0u/3M/2YtjzMV/us2JcdlT7Zp0BS+1223w5z
Bqk68PYU2NGA1z5NS0ePMVoTKb3Van9M6fghuCbuGT/A/KZIldtx6NC3Zh+Y
9gOYt8BM0+rLJDcUvQOr5mg0Ibmu6G1wLxRCbwL9jEZTktVjZh2WrNBoheRx
Ra+Be3UIt0OvAr02hHtM0c9hyTqNPiFZ88AsgXuzELoL9DaNVkkeUfQc0Dux
UZ5tZmD3biF0B9z7MTt5HWYK6IOYx9ijZhKWHBZC18F9HIsdx1Y55OVpIXQV
6PPIKkV0FlRg75fI2kXk2tF8D3LNGPtnK8z1E6661Ot5gEFF+9aY0FKp6jJ1
HJr9JOwkWcAqRjn0URZ0pjhLrpeIvWnQlRTsQK66ubPkKi/msyToYdEuMJSV
O414Rvy+BVauozgrs3B0hKVica/BynlbjJU7wAhs5fgsQwv7tZgWXnEdkeuC
VfYbyaFGITbuFTWwzQVssYrg6ouzcx43yBNlkidJK3uU4xLXyqgmolsjdsax
tXF2Xrl0SomyzE4Ddo4uaytF2TkHZFcXB0lEvXeaQ+x2zNH9P5A7t/JdN6tj
DR3CcpbENfjM83sH5z1HOwGOzyKc4XFt7AUf3Ro8Jr+7/8U8FVl9mDfhGhYJ
yxkb19AiOSUNVaxhnnDct+LsbZI55319P565k931lhQZ+VCE2RLRUrKisN+v
gatGxFnYzYxpjjHcufhM7E8HC2Bjbcmj2HzUXmauA0w8nu3uXgCuV5nrVbHu
fT/X0wDdxxniDazSGOX2+3KOo42Y7mUu98YG7fN7wMCcZhbfHXbh39ECHI0s
OJkFHO+y4d1jkDvvl3Fwc//6AC+H3Ve8kmfwtc9d/wje9SdJP3MwO9LIPvzR
r6OvH68zlwncheLzYt36BJrdeU+s48w9BMLdDIb1D38mdHcr3rG4l+2F686d
53hVO0C7O7H3JqP8PVTzPNfFue42wDmraI49x2MN6K6ieS/lXXwVliwregz2
8q69As4XiuJR1rEItN5WcxrZ/nlYsKHoBixg1DQ4txQ1SaNcay2g9d6Z21k5
hv4csqdojlXsRCPc7xXdgr2xc6ig9Abp+vJAbfvOfaLj3O8SzNYa0bVLw/us
kin9A2JLs+w=\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->40287656]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Cylinder", "[", "]"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117585489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Thickness[Large]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Dashing[{Small, Small}]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}],
      CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->18782198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286535092],

Cell["Specify different properties for front and back of faces:", \
"ExampleText",
 CellID->261029909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400585771],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], CuboidBox[{0, 0, 0}]},
  PlotRange->NCache[{{
      Rational[-1, 4], 
      Rational[5, 4]}, {
      Rational[1, 4], 
      Rational[5, 4]}, {
      Rational[-1, 4], 
      Rational[5, 4]}}, {{-0.25, 1.25}, {0.25, 1.25}, {-0.25, 
    1.25}}]]], "Output",
 ImageSize->{184, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222326089,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->328450358],

Cell["\<\
Graphics directives normally remain in effect only until the end of the list \
which contains them:\
\>", "ExampleText",
 CellID->400684904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121021918],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}], 
   {RGBColor[0, 0, 1], SphereBox[{1, 0, 0}]}, 
   SphereBox[{2, 0, 0}]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61903802,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinates",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->661472451],

Cell["Use ordinary coordinate system:", "ExampleText",
 CellID->83259975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133351120],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 2, 4}, {10, 8, 6}],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->501409602,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339973159],

Cell["Specify coordinates by fractions of the plot range:", "ExampleText",
 CellID->170010472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".2", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".8", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->548504695],

Cell[BoxData[
 Graphics3DBox[CuboidBox[Scaled[{0, 0.2, 0.4}], Scaled[{1, 0.8, 0.6}]],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->445691265,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lighting and Camera",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->121441449],

Cell["Default lighting on gray specular sphere:", "ExampleText",
 CellID->277599385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".25", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "10"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267039481],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.25], Specularity[
    GrayLevel[1], 10], SphereBox[{0, 0, 0}]},
  Lighting->Automatic]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->455394567,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153858149],

Cell["Different light source for each sphere:", "ExampleText",
 CellID->5063482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Spot\>\"", ",", "Yellow", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
        RowBox[{"Pi", "/", "8"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Blue", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
      "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "White", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "0"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372618166],

Cell[BoxData[
 Graphics3DBox[{
   StyleBox[SphereBox[{0, 0, 0}],
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 2}}}], 
   StyleBox[SphereBox[{3, 0, 0}],
    Lighting->{{"Spot", 
       RGBColor[1, 1, 0], {{3, 0, 2}, {3, 0, 0}}, Rational[1, 8] Pi}}], 
   StyleBox[SphereBox[{0, 3, 0}],
    Lighting->{{"Directional", 
       RGBColor[0, 0, 1], {{0, 3, 2}, {0, 3, 0}}}}], 
   StyleBox[SphereBox[{3, 3, 0}],
    Lighting->{{"Point", 
       GrayLevel[1], {3, 3, 2}}}]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37864711,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->795089234],

Cell["Specify the view point using special scaled coordinates:", "ExampleText",
 CellID->54398295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pi", ",", 
      RowBox[{"Pi", "/", "2"}], ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337541594],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  ViewPoint->
   NCache[{Pi, Rational[1, 2] Pi, 2}, {
    3.141592653589793, 1.5707963267948966`, 2}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->86338209,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266662520],

Cell["Specify orthographic views:", "ExampleText",
 CellID->384715916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "Infinity"}], ",", "0"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "Infinity"}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250586471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewPoint->{0, 
      DirectedInfinity[-1], 0},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzt3c9L03Ecx/Hv8J/o6D/wgS4dunQJ8hAfCoI6FMX4utJgVGtkIERBSRQU
KRRDiEmhEoNaP6y0IctmY9M1950kw2QynMzpfny/o1/4pr7qoU6dOzwPL3jx
ft0e/8Bbe4NdPr832G162zsC3vNd3ebF9gPnAu6pzWMYRudWdhlu/+W27XSK
iGGYPp/Ps92MNrfuNOOkm62r589q7qxa9WjVp1W/ViGtwlqNaBXRKqrVmFbj
WsW0imuV0Cp5eHf66J7Mib1Z7z7rzP55f8dC4GDh0qHF3iNLV48VbxxfvnWq
dNdcGThdfnB2ddBfCV9Yexysjl5ej/RuPLtSe3mt/uZ6feJmY/J2c+qOPX3P
Tg3Ys/edbMjJDzqfHzqFodaXR63icKs06pSfOJWIU33q1KJ284XtvLJbr5tf
3za+TdR/xOo/J2ub8Q15vy4fqpJYk48VSa5KqizpFZkpyeyyZIryaUmyizJX
kNyC5ObFssTKSj4j+bTkk2IlxIqLFZPcuMyNSTYqmYjMjEgqLNMhmer//q6v
8bzH9XGVDMQQQwwxxBBDDDHEEEMMMcQQQwwxxBBDDDHEEEMMMcQQQwwxxBBD
DDHEEEMMMcQQQwwxxBBDDDHEEEMMMcQQQwwxxBBDDDHEEEMMMcQQQwwxxBBD
DDHEEEMMMcQQQwwxxBBDDDHEEEMMMcQQQwwxxBBDDDHEEEMMMcQQQwwxxBBD
DDHEEEMMMcQQQ+y/EPvnr8a/fjp6fgOIqeyQ\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewPoint->{0, 0, 
      DirectedInfinity[1]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzdmFtLAkEUgGfd9X5Nu4hJKSRED0YEPRQREVlU0j3oSost6EMU5j/qd/Uv
el3qjE6mp07MngqjhZ2dHb9vXMfdnXOmarfqzq3datTswkbTvq83ag+Fyl0T
mkxDCOHAfpMVUH+BWnt3XNeFRsdxjHZNmFB125u4hsL49JMSFBlomiaJIhQW
NGWeHp/lcYokJ6AwoWkcSHkskmQeCp8kgJTHSZLMKbKk+syTZFaRM6rPHEmO
KrIMpJCdqvYx0hhWxpzqmyYzspB9Aim7n1fGCGmkkbGAripNmil1VYvIGCKN
JPquJWSmSDOBzGVkJkkzjswVZCZIM4bMVWTGSTOKzDVkxkgzgsx1ZEa1zQoy
I6QZRuYmMsOkGULmFjJDpBlE5jbb3EFmkDQDyKxqm35k7iIzoG3uIdNPmhYy
99nmATIt0jSRecg2j5BpkqYPmccDME+Q6es3/V2zcy5OPfJnkvd3ediAECza
ev8VQpwPlLyQpNUlP4y0/C2X/5S56rkDesbnDxJ/beS+xejdfwzqh56P33zy
vb6F+O+7Ab+d+XMJf/7iz5n8eZofG/DjEX4MxI+7+LEeP77kx7T8OJofu/Pz
BX6Ows+L+LkYP//znmvy81rvObR+fu4999dfV9Bfq9Bf/9BfU9Ffp5FrPmE5
gZlyEDpbUHy1BlR++0fU+Wwf2bPmZLwCFKSd+w==\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->17266657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420338531],

Cell["Specify the view vectors using ordinary coordinates:", "ExampleText",
 CellID->30861637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"ViewVector", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0", ",", 
        RowBox[{"-", "5"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6602843],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  ViewVector->{{5, -5, 5}, {5, 0, -5}}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{154, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->311864414,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(36)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->671730737],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AlignmentPoint",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1817420],

Cell[TextData[{
 "Specify the position to be aligned in 3D Inset, using ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->79404433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"1", "/", "2"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27695968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{0, 
         Rational[1, 2]}, {0, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 
         Rational[1, 2]}, {0.5, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{1, 
         Rational[1, 2]}, {1, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5508554]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"Sphere", "[", "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
          RowBox[{"AlignmentPoint", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", "a"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->238949188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 0}, {0.5, 0}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 
         Rational[1, 2]}, {0.5, 0.5}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   GraphicsBox[InsetBox[
     Graphics3DBox[SphereBox[{0, 0, 0}],
      AlignmentPoint->NCache[{
         Rational[1, 2], 1}, {0.5, 1}],
      ImageSize->50], {0, 0}],
    Axes->True,
    ImageSize->100,
    Ticks->None,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231603232]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->738017417],

Cell["\<\
In 3D, the aspect ratio determines the ratio of the final displayed 2D image:\
\
\>", "ExampleText",
 CellID->197467626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"1", "/", "k"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32775646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->1,
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False], ",", 
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->NCache[
       Rational[1, 2], 0.5],
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False], ",", 
   FrameBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     AspectRatio->NCache[
       Rational[1, 3], 0.3333333333333333],
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->187818819]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->125737826],

Cell[TextData[{
 StyleBox["Draw ",
  Deletable->True],
 "all the axes:"
}], "ExampleText",
 CellID->73946957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->895510267],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->295779378,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147392701],

Cell[TextData[{
 StyleBox["Draw only the ",
  Deletable->True],
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  Deletable->True],
 "axis:"
}], "ExampleText",
 CellID->651913589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "True"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->6137773],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->{False, False, True}]], "Output",
 ImageSize->{154, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->23848311,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFnQt0FcUZx5fk3iSEgDyCRgWlCBWFmwQREIoVtEJVLm8IL4WAEUh4hJAH
ed3k3ii+RVHxjYpCrda2tvZ12nN6Tk97tC9trVVrrdZX1WotogIie9qdb2Z2
Z775du/e5EZzlGRzZ7/5vt/O7n7ff2Y38cr69VWbKus3rK0cMauusnb9hrXb
RszcUuf8KrePZVm7nf9vLbGcn//n/AT/77Zt27LWOf/mVlVVjYOtKuffHGcr
h22xX9vwZZ0Jn64RbSOi1Vj47Wqxla/s4/wr9rlU7NOX/HSF2LeIbUXc/pwf
zoDPl4nPB/h8vkRYH8i2ou7noo8x0GaRsDEExYRjHA2tF4jWQ0O1niv6PwF9
mou2R0HruLB9UqjWFwvbw9CnEbR9GrT+prB9Kvo0irZHQuuZovVXQrW+QHhy
Gvo0D22DNWuGsF3gfC92BlohapWPtkfAXl8XfTCbEWcvq3hPeWrv+NT+s1KP
np16fHLqiampJ89N/fS81M/P7/rlhV2/mtX1m4u7np6d+v3c1DMLUn9elHq+
IvXistTLK1OvXJaKOgawd3ib9ztNeMs+zWX9Dt9Zmry1NHlHWfKe8tT95amH
uuvDa5WpN9am3roi+c765Hs1SYtZx0cas4CjZ00VPkWlT6elYp07YsnrY0nm
XJnh3MQMnPsb5dz7m5If1nYeqOsEL9N7OFkcLeZhDttjbH2soznW2R7rTOvq
d8HVH4Grv+iBqwcbOj9p6jzU0sFOdeerL/L0FPB0onJ8wdNYdSxRG+tQ/b3a
x99vIX+nh/X3dd3f/xj+ftaRsJg3Bcjn4eDzBOzz+NWxRFUsURPrcDxvAM8T
ven5v0jPm8HzROJoMvF5Vzv4j88p7n+5ci6D/5OWxNpXxNqdKK4woujiUZT6
R3FOL0Zh72i3r2kjIoGrrlWqXMusKU6zebHWBbE2Hk4lhLNRhtOihHNDafLm
0uRtZck7y5L3lqceyDScJT7hVEM4WyCcei+cI3o49vVtcHTwnYLHNFYcnQJ5
dKY5Qc2Xca2EuNZBXFtlXB0Q1zXZiOsFFFeVFtd/ZVyfanEl7Ksgruva7Btb
7Z0tRGwnQ2xniOMF95zpTrN4rHlurMUNsAICXKME2JhJgD8IGeAKHOC7AQF2
mgG22ruoGCFvsE4XMfZjW+dDjNvneGG28TAv9QnzysAwH8tumI04zGMszHYv
zFta7Nuaifsij3SUGKmQHV4AkTaZwS6Vwa6PJTbFOuog2NbAYB9Wg/0aFWyc
DvbV1XSwH/kFezUEe4MXrL17O5ybOJ88ESIeaSv57kyIuBGCblaDXiiDXmsE
3dnzoOfTQb/pBL0OB/2xEvRnTtApKuhbWdD2nU2+UY8QUUMWPysea4Cot5NR
X6ZH3aRHfWNp8pbS5O1lybvUqCdkIep/b4Sot8qot0PU7VTUN2lR2/c0WkTk
JRD5cDHCB7Gti+B4N/BBDsG3qMEvg+AvjyU2xBKbZfBtMvhrv4TgO0TwV0Lw
11LB391o39dAxQ8VE1y13dosDvHXyyGPESwCBKsUBNsUBFdhBKn7MkfwlzQI
kgzBthAIbgYEt3METQ4C+/56Jzqb16V81J8k7r8Q+2yIvS44/OU+4ScDw38E
wv9eN8Jfo4X/QZjwr0fhb2fh3yvCx2PgeODQT1Q5/FNOif3I2ETl7/hO1mBv
nGwLYLVYsnKS5mrJanvvsPo7sPonsHo7mFVH4ihntYOzahOsdrXYtzfbd3is
7AfrqHMGNAmrCHGCe2fE25Z5gzfeOLV4bCtQazCotarUVktqWwQ1ViSlpzbJ
n9rsENQ2ALXNyQ85tQZGzS2VQlHbE0yNjaSIm2kE0YPfRN3fCIZwb5oLIy8t
RlHruBjrDYw3lSZ3lSZ3S4wPZoLxT+EwHjAxJiVGKBFYCqZivMvB2AgYtx17
qJYiWRxy/OWKKxvO6voDw3hssx9DnqfPVwoslWGzwvC6rDBcCgwvlQwvJxge
ZAw7NYZdOsOdwPA2neED2WBotFDsQPY/D8bjFrhxaDjn6GWPW9dB+a3JH0km
1/QSzpSD8x0XZ63AqYogqGp1ix8P5z0uzq3H9m3GFIZ0kyaurAoxzfrQNDuQ
mBRM8zvpaP7RobmwZzRRKSnLDkmzgdHcy2hiCnCfgJEltR2pIlBaD+ht8ylm
OHN3C+9KSgAymd0tme0zmP0sHLN/ALM30jKj9QWD2X2S2cNbLOK6xrmdiMYY
5gUa0vx4rCYeq1V4NfnxUit4VWHiAmu2eL3Eea2SvK4AXjWSly6buXrMMZeX
XtryekfyqhO88DgbRPLCSnO+4LVJ4UWne6oIgJQrldfOXuP1XgAvPylAL5Hs
+wWvj/Zv8OFVIs5DPJ+SF5rTQopTo85JyMmZc/pdOE7vu5zq03HCpaSoo449
yDh9vL/amK0a6HJSxxXmFfV4bQ0uI5DiYPJS5XfGqzy1J+u8XPnalA1N3QHV
nbKYcHKRT/fXGFek40he/VCriODlm7WZIoWr0Ki8uvx4jQ/Ha47Oa7nkVcl4
vaXzMmVWTacx63S9+HJ4Hd63MYAXOw/7o09zQ3NaZHCq04XoAE7fDuT0FMXp
ZeD0msvJnRYxpUtXzzIL+l3NSrnl1QlH920yrtwDyHGFeeWk59WKpA9T7+yg
JpC6zeuv4Xh5qichgBjlqV4TOGmXMevXn+QFFBeraxrIVJ8s4lcZQmEwq71f
DCuzlDdrUD3h92HF1EOGCq74i/in8dh6Mns3y/NgQFw8pwGdHRrQYglopQS0
1gBk6qkBgMyKCHJ4POsNtRDk5jmo7oFqFKlDbnbRz7EQj1XrqalW/lg5Dj9r
Jklw2xdIUJsuJAmaModbolMZPU0Qxp1WQ8JVTtOFYJkK+74gHtsYgE6tHFco
Chsip07cuDPhmNwURu7H3SX3rkrOVCcJckG5Pc6sIHOA63pEKh8mwYhK0NW/
F+r5K1kXqQQTqkbZRE19IYL7EcGvOwS7whN8XSFoTgXQeoZZTboEZbZ/0Mli
McXCzMffQpnNmtl/KHpt1MShuxLDl94F6em90hN6vrWSqAE+cXLasPTkSiV8
9Rss+G1OWw2oKoaukGuzcGn5/bDH/LzZBUPg1fQfgp+ooXiOe8jJcXG23zeA
nzY7g7aHdIsjV4NciRxN5bkT2N3j+BxwfDGQozLfQGpCRi2qT2pxjkd8Ocr7
cL74niO+F2NavrUCqZ25tJL+tB7KCq0qhZYyO+MqaJoiRFai2gQNy4A/dyoG
xiUi1+nweUBiLG0JU3EuNZQyc7olmM73M6WjLnpZp9E5YNJRdQ1cd+r1lFsf
wFpUZ3esMxako+VXG6Sh1UzN8blLR9y1m5nRqghFK0gtU2nR1RRUCLm2t9ow
PS243i+KxzZ0G1iDPnWSBtjk7gN7EwGr9QGmyhpq+UlWDA9vxqvx07OqIXPb
YFHDFWHRxIg7gayuPOOsHuespn3ZrJTaoCg8p8VGBusrZpgimTkZ0rucqCkR
LJWpkoZaheIaSqrW+A7IWQ2lrla+rOZQYobJypwIQQufssXq7fCsyIqdyvmZ
co3HVb7Lys0OFus5PV0RmYLPJkrUD2D0aNYZ1emM2n0YOTU5URfxzB7Uan9G
1HjyyzsRq3bEqk4XqNWJNXWRSxZZvYNYqTK1KicGVOGyCvKU6myzQlqFq5Mh
kbo3WL2KWNXorPzkRFRvqxWPkql/5uSe4c49v8xcm6VV62mVUasu5KPFAN6i
8nCMnnUZybXz7tpEzui9bjNSZ4q8/HyzDyNZxeDVFFRdLcda+hze1CVo0bq7
HJ/OhKM6PRmkjqHqWq0K1dyU5giZqrliT/sNWV8vUTTuDIpGU2pMj3RiBkif
R0jX6EjljBwp1WLBQi20UXEEenf2iVZ3jyiSHtVZO3WVgbvwXhCdGkh0Hk3U
XZzmR5SSgMxi3CigIMfF83J5GRF1r5lL/DRws6bSBQ1ChuxlkqnwJAlZg5ys
ygJJY2xWpKsoiCrVFdSQMKnO+vkRfaInRI35dx+ilFCEiCp1xUEiV+5tqq1k
7W/KlFwu7z2qeBWIPt1FU0WSCapqZQXyCZFd52l3eLn2D9/pFYJbw1e6LsFa
iqA2VZgJwadCEkRTrmjaIZGO4G6dINQnh4icmxMcIshB7p1n5to5DidrLs8j
SU3AlDFpUuXeulL1ad8ng0ktyJAUEsaRPEdWu3p1ciSQlDq24C5SGFydwBz0
JQHEmg1iN2eRmLLgnljvQIrjpJaCal+d2FGiRgkgVhG69tUW0ZhaZhpiE0IR
+0MWiWlqAaqA3apOauYhzsYK/2qEVglIJZPL5GiiFJF6LBuk0EIHU8/00VWo
+lfUdlCT4CwlSo4t2F4aTidncoEqrSBZU51bQND2dA/aIgWasthbh0bPMAQJ
LFohp1UdGTCbAXp5KGa87DWZtfQCM/6ShBdcZqs0ZnxdyAeSGYRqFR9uhet+
WmJmnWbmwpzYYElMPM8HV7BzQ+a5qihlip3kfB8i9oh8EjQrxOCFRFaJq3a6
uLDicoOByyjCPtpfja9gHjH3CjY1PKkKKamQUmdvk+ILAmEUDSPVc4fVkfaE
8znByixYvcdWhIDuz8q4P07OiNlKSs5zpXQ0P+quL+o5M37GnaqtTjDkdIDG
dBOnLV4o41dJyZyfUtQDqJ0ts4osUNvhR00u/A6g9muKGrAaaS5tI3V1F5qT
5rPQrwoHDdL8w/s2ZsBsvJ6JpanX1YVEJLPrQjP7CWJ2kceMj6vR6NwkVnbo
4vEhBZoz0lj41xg1O66NFI0dX/2hNnefJPNblZortSS/umm0X42ukuRaUlZI
8iv8mGeV94C8ZGJc54NxO8IIw8+UPnzKgM/3baIpmk830isDYZb6TCXnJaoD
kqSpb5oTie5ammCSMPrG8QH5W/UkDs3SEzx0lk4RysCY0/iYpSgQMmKp/QY4
jpHKu2/5gIp5RY7TUHYEotxroASCZejcTovSXA6BFLnDbR1IO2JozNXSoSqI
DFn2C9TcvbXmJWFgdoWACQzPEoNyhn6hvMSACc9ivWzClPO2przJYBoyEsPj
V7gqq3HCspTrV+Wz9UMFSVdzDyJZTKpxJsmrKZJwDZyIz20fjM+EwQjTbCRG
cpUOg6NVtUS5EXpMplvHCvefU8LljEJWIUVOP6zMxRJ2eR6JFgUQz82YVHQd
iUUbWFUcNDNl/U6srks1KJycCYX25bSAqVEAR1g3JXufs/MYhWGkso1jVgpP
ImZvEkaI2+STefw5FxxjScgYFwTGaPFXZo5yomK3YesENQxcP8uCkPmHihwl
Xz+0r4Z+whCeecqR19LicHm6UBtUWYvlXI7pcY7P8M7PYl9X4e7KvCCzZJB4
/T1VicM1a1DILFn1GExPkJ4OogvGXeDjHURGepTISAM8jKgeOnlno1Xg5yEz
OEX6NcDM7Fh/hjtENhLgTRRlcJbjURPz0XOHGTrP8QLe5liE+w+TDekjC/ot
kNofTh7hfsC8dHp0/rNmyJ4L3bSBGTbShnAxF4uYNQ2NVzG5TsAW/5rFOi5k
e8k7K7Or3Vm3DED9wTWOP8OLGefy+yjrhL2NjNEVwToNL5bxFfAbOLOoKzfk
k61GTyyyXGHdu18zy3EWTQFrCfc1Zkha/zjIOtuXXdXgiLBLObqYMafnSe+j
0qxUA8J53d/23vTLjovXATO6kHke5XoeWIbVaOEsF9ree0i9c469wmkxsxoR
VqGgDGcxX1jsJ44ps8i8rGD2hOr4OXEt4NbErVF8UW8jk3fNqOhngOyHnwxe
P47T7JDQ/WDLZo4i11XkiGM7UPTDKhDm2zIlHnmM1H76ZNCP5My/ikVP1SKi
5agnnE2E7Qk/ySD72Yj7ObB/AyPX3X7wmzNchV5cq1bIfmz+Vi+8ZjlsP5CN
V8l3yiP7Xssq8YSL0YO4+MGXnGvHTzoPpGwb7yXDK/m5/WLh33HIxsoMbByP
fltE2TIyaa89Oxv7OJvMGreI35LfL41FPGryDIsltvL3A3yOMxw8ZClqWMLv
5O+bxiJ+90jEsCjfbdlzS8MJDqrF5cgifh9DrmHxlDQWlyGLeGzmGBZPtb13
lquWliJL+HxQLVkW/nsEEWStAlmDERR129t8PHNb8l26UWRjMbJRFGBjFEFS
tbUQ2TL/TgW3M1r4guOZj/YfqPTneXE6wUy1MhdZGSx643uPSbP3bJEhHK8d
Cfkmbak3XIL6GKr1MTZNHzNFH+y6FBFWLWsc6uNC1Ae7erEDw9d4lhJ9sL1k
/jlA2ObP75cpxNmn00SWXmQr91RrPHF8WatJonWh8IC/te8s1DoqWpeL1vKp
Rv5+V/kWf3busFvCGKcV+54vbA6HVhORTWaDVcbDRS2ZL2zyv8QxyVavd95e
LHkscvboK+4jbI+vwh7nEPbxUzpFggvziv9dlilEK3V7mOijDFrLv1eBW5WI
VhOg1TSCHr5XMw8mQ+tzbfXs9VodJ2yCNes8ctzpdxjWejq0nm7Tf90mT/T8
DWh1vvIpOwcjwsZF8Cn7Wyh5zlYctqw+/wfoSbev\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesEdge",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1012572876],

Cell["\<\
Choose the bounding box edges automatically to draw the axes:\
\>", "ExampleText",
 CellID->176722527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315034285],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->Automatic]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->475839908,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73049692],

Cell[TextData[{
 "Draw the axis edge that is the intersection of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane and the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SubscriptBox["z", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->608291285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "None", ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517617630],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->{{1, 1}, None, None}]], "Output",
 ImageSize->{154, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->223370673,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNnQmUFcd1htuzAjNoALMJCQls2bItN5tAwkIiUhQZS3iExL4KEIzFNgwD
DDDMvFkaeZFkS0aWsYR2xOA1TuLEznKSk3NynMVZHTteYtmxHcdxHCeOtaEF
+iRVt6q6q27dqq733gwnc6Rh+r3q2/d+r7r63r/qdbduPbijrX3rwZ3bts5Y
sn/rvh07tx2Y8d6O/eyl2jdFUXSC/f+5qRH7+3/ZX/D/ljRNo9q2trYUfqKr
+a9oE/tdx15cAFsb2O8atlUr/50Pr65lv/mO9ZoF9ltaWC3bjiLfXSnfHcO3
6rKjsz/mwft3StvNjveXyf1b+FZ99r48xlxo0yrbjEcR1qDtWdD6NnnENwe1
fp+0PRm9W4u2Y2h9i7Q9Naj1zdL2JejdOrT9bmh9k2x9WUHrq6D1YunJjKDW
10vbb0Xv1qPtd0Hr62Trt6F3G9D2O6H1tdon3Mw6YkvQXgvSvFc1sr2i5i8t
Sr58Q/IHNyZ//OvH/vSWY3+25NhXbz32l+9P/vr25O/uTL6+Ivnm6qSBNRyN
7DWi7XeA/XnSK370Om7/4sdmJ0/OSZ6dk5yem3zm6uTzC5IvLkxCDvrttcl3
1yfPb0p+sDn50d3Jv25PIm4Rs6P9mCPj5H7Ucj9m3h8PPjhr8OFZgydmD2Y+
DQmfrnH4dBv26VuWTz/9wODPdg7+fPfgL9oHI34k3N9Hoe0rwb9Z0r965d+V
ffFAEg98KB7UHT1pOfpb5Tj6PYej/71v4Ff7B148OBDV8GNr3uFP+e3g7VVp
PlLBHnFn3N8V93fHA5nbD4S5/Yea23/ud3urcntH7vb/gNsvHx54pbufj1Q1
RM8UPr9T6wHg89x74r72uF94flR5/mHw/CHN86eY53Or8vyH4Pm/6Z53KM8P
Sc9fK/W9PtAH/uMeAuc/9BPD/wV3xaVtcd8OFcUhFcUxO4o5RhRfGNYoXjCi
6GdRnEv6zt9bgljwqCNiuUL2HzhXF7FmK+PedXFJD2i/CqjfDOgTs/OATtEB
HXMGtCo0oJdYQEdUQP0yoPRDpfS+3oiI6gqI6i3aWAqf0KI74149sp1aZD16
ZLNkZJ9yR/aVxZVE9u8ssl2+yN7QIksf6IXPDI+ocLWKLpefGZxdN7Fmy+Ke
O+IeFuKquHd9XNocl7ZDiHutED9ywULs9Ib4ER5i+rGe9KGj/OPB12gR53T5
KTbxrZtZs9vjo/5QD6tQ74VQP6qF+rgW6mdFqO8pJ9SNONT/8Ic6aIfakz5M
RvsWiPYSGS3khbdAtN3L4qMQrQi4JAJui/t2QcAHVMADhQHPryLgbeUHfL8K
+PjR9JFuuJCRMU+VPXks31rCmrXG3XrYy+Pe1XFpQ1zaEveJsDtU2L1m2B/X
wn7aCvt3i8L+RmDYB2TYZ4/yyEXY545RYX+iOz1xhIp8JkQ+OdWy/Fsh8iPV
BP/IsAb/Yy34/9zDgh/0Bf9BFfxHjeDTRw9T8UN+Hk2U8Y/jW0sh/sMWgl6B
YGNc2hr3fUBDcCQAwZnyEXwHIWijEHS5EJQwgk9yBOlJoIBzT0FhvOz/UMe1
AoVDGoijOog1GojdAOIgBzHAQAzGAx80QTxaDoi/KgfEf+kgDg9IEH0CRN95
BuLDCsSDOogjDET6RBfF4nJg0SJ7BFSpy4BFVzCO/n0KR0nhuC8e/JgXx28H
4lgjcXxfx3EPxvFiF899C3B8XODoTj8lcBxKnzpIEYGKNxoriUwCIq3xAT+R
tXFpU1y6O+6754IT+YlOZO/gLzsHfmUSeQ0RuY8i8lghkWadyJ3QR3xQVphQ
9igo3RaU4wrKExcGSreCMuCA8vBRBCV95gDFZXrGRVei4BxaDnz2V4CoqyxE
15aP6K4yESUaogc0RI8oRI9LROdPdXoIGWrbBP7KCsXooIeRXjgIRp1uRp/U
GD3HGM3jjH7TzSi7Cv2Dn9FOxWifm9G9GaNemtGTXYIR1ZMuzTlZqiNcn1a0
xvvcrHpsVjtMVkqPqJrVHQSrf1GsfopY7ZesXlGssqo4K7V40paxOqGxepqx
2n/+dIeVw4B+GTWhV3EryGpXQQ8LBbfZFBJ0OYSBu38kwG1xgzsYAO4hDdyj
GrhnARzRz2h2uCaCftjQGrcjdjWMXNSa5Yh2LWiLMBm7BxW7x0aA3c887Eom
O70iPK6xOynYHeTsnttH5c7TSHZYJYD3VwG7TsXuEJVfG2XldlMV0djluqfN
7nPVsLtbY7fbZGeKcZRwQLNLgd1rQ3sC2WH9CDSV1XDO7gV8Bzz4lgM+qNDK
w/dMRfj+ieFbl+P7kYbv5058Lt3FqNNEbg74DjB8bwy14/PxYpIeVvhBL10T
Tm+1SU/Xqxz0kirp/bNOb3tO7xd7pYZdhrKhlXic3lOS3vmhvZTKM5UkiBXm
RoKgKzHBCoEtgwlRs0qCfxtIsN1H0BBJUG2oFUM8PXmusyyCeI6hISfYUUQw
LyQzjUXX1XTBmyT4aUZwgZPgV3WCy10EE4OgSxy2lZa8eDqC6gSW4EmC+Mow
BQiOoa4X+HqypjXeCQQLCgi9FPcTfEib46MJXm8RvLWYIJ5AMwmaQk2fIdTY
5adWRsjsBV8fJpMEm9F2nSS425v50WKGrvONIMENyfMegp1OgoSkodeqnGBX
RvCFMzsDCY5F27WSIM7//EVsWQSfHGmCSC/1SCCIoCzTeAb90pld1lV2Eknw
IrRdUwVBTV8kpseGk+Amk+AOH0FCL0GFLireoAZ55czuQIKgxW/Qa98iej22
iGLKkblM7aJ3ujp6P1D08ORpLlYPGPQSkx4qffMKTlYhr7JMGucoE930Rpv0
9CSwK2K12+HoDobvdqr0JbXLXntyqzp8/7iS4/u2C5+c68klbkPBtFUWuwA2
C5HXh9pxfgLanJW1gMKyPtv258+22hJEbnb55JYmX3OR20yTI7Xf12lyqIQz
apBzoeRAx2sW235sNQxatJQU9AqxnSzEdnPZ2PQ5FVL6dCguFDa9+MBn5gSS
G9BsYtvuPJlDizJqQmWpgNqzgdQ8p6lac2RQcwjGPq3FLtmygqMMamtb4x3u
3JiQV0g99AJA+2ERNKfIYte5qErj+d1eXDmM9zLbFVBPSE1lPSWFIr1dn/U/
OWeEme2zmVnKij39a9dlpztwrTDOzWxda7xH5R/FOoAtgRYyeypjdnWZzFZz
Zt+tjNmgxSxXA+hK7EWWBeO+JriRucm6wKw30090+bNCbtcNK7f9NDdCRbEr
WK16eJnlvri/tQwjN6R7knNi2cqMbOkjze2mMrltK5ObXfnbVZeqGc4ybvx6
kK3N8PHqDKzwbZ0OTVEgXo9bvL54bfI71yW/d33y+4uTPxouXrZanPGy63xc
Y8kqgevtjZIXnu/x97e94fyQShfObyhb3l4lPzRbrfOztDq6yreqLFEmvDHU
DpqRWp9v1fU0vzo932XV1aFopau6tzU6cp5iOPmtDeWXaZ2v5vy8Nb5RZsms
N9XWxIbRa7CrBZhdXE5W97o+56F3XFtdoy+tHTZ61jSjT6Vz1fhWzdAm151a
5EjlZJ1WMuA6i9RFdFUJ6XIkuacRuYWVk/uxgxzWN211LivvyWorqxuwcklz
gx633qup48oeSUrVovu1UHTf09Dli09gghFN8BSh0+cY7eqhowxyTaCl+8iJ
OvV2Uk4i1WB9QUCV6L7pQOeZXcSKJimNOAsvLqyHna9Ab4O3jjDqVVtRCoH3
RPXw1rvhWROLhCJnCyTuCoxr6uXRC8mK5UIUh7AkheD/v/QIoYSuKbiejs/c
sdXTW05pJUhg0idjLxw9Y0KRUoPp6p+sLEBPL5teUIaMVBNSnrOmsi1614wM
PUtLxyKdUWfY9GSd8TrLk2l6OGueJOmF1hdIPxlRen9fFj19JsIlcdpVmklP
VBnnKqR3oCwVxaVykssohoHexkroEbqdu8YV9Khcz0PPrs1WhWspugaVacT2
AoBhoff9InqGvE4qxWSFyyq0fDqHzJRpejDuNSqF3SgyIqjPVhSqK7aKd6/2
1cfhIvitMgnmWnuIxoJqjVPlEtzo1duNMg3JKxUAPJN9p7JKgNsH7XUULhE5
B+gSWRDA0x14jUSzm98myJmDajUkr7jk0Gyah+Y3v5jf11z8suW0gt+OUH5Y
ZCGKXUuHx31QMMQrzSZJhu3+uoMUWUiJCjHMJrPzxcgawy9VylCuyDMZUhNm
DqGKXllrMHyZyJ89DJu8+XNe+d5BroMKh/gMCfGGCiHmy3modQFlQMxKuHxC
CAT6od0jxBAJLy6G911whvkiAVqxD2MoCjkoRV4b2lPeuRySS+P1PC7BFE2r
ofVkw4hQLE/J11mYov3ZHq9s6q/mhG4/MgxXaTqMLZ26GJ6sguHXvQzJiSNC
evapMa6qxM5rQhj6q5IefcGK0rLKZzgvgOHS4WPo0WTIeV69NsG5DcyXW2vo
YfXtEjO1DtVkbD3QnnqTU+QVMGzFDL8TxjDTtSL+zeBoolOasctjYxKJJ9hh
DKEfNigtP69QYH3jDX55gcTY75jBrBDjskowQoDR5AJ5y1PmqTVBZTBsJFV9
UeUt9KgM2/Bqx5GBqN16yQORf6k4mqarq6/2wskcChAXKS+c2YnHQz9DQtsX
DBf4GZo6l84QTwVXxvBvMobqphLoexuiz12WdUOkUjOOrCOyJpVxfOnMrjI4
LvLXKna9vMEhF7qm57JVasOFUdCbic5mW+wXGFl3ZM3DMBr1CqX3ezguLMy1
bY5bHLLriHIEele4BkUDI+jWGcY3Ek4SrycySmc0YycqFivb9lCcH05xhabe
IPm1eop/QlGEEe9K0Q+fv0tbQ2+u7+AIzWX0HKGSvyRCe6odF31GweLoifi7
vpDlzPVm27T6IBjqCpjOUJ+6sxl+OoChOGevyvvhGnk+u9bJkDL2qz39uozI
4w4p/PSqBV+lx7g5NhVyFNXzTASyjQJpz4EikKe9IAW/WX+x9Jh+QsuvlqNF
vPrCD8d8AIA05DAeezHIPO2uhKMz6xYcL8tUCCQpojkVD8dnbY6LOEegNzfr
jSEY9fUzLlnbxCiraB59WAVIVS80Rxgbm625AQIlkJym6zmFJB8oIgnj3nz7
pA7E+JOKMLLeyOMvwOioXzwU69X8gKQYwRzVZYWaDtJnXZN8x9Gq3zmi7y3U
e2OVJD3TBGcdJFmH5BhQOa0vJxTLuuyZAg/JBnOmIKsEp3mEHVujRfN9Nkjg
V6ef1uP4F5TfQeKxp6F8eLLFR/cDHleRZ04E4CuxIIRX/06WhHBuDYSmOAiV
XPIhSQgOx++YPe7UN9JRnMkMPfZfWrHzZaaOApc7XlRXvHzG0p49sTeSdYWo
zyaQqzh03Y8MHsYhfmtqFi/7L7qc/YI7el+KY4WUyxUr+5y5r95YWfKPz4TR
lcXa4hJF9Fg7IFZ14+t3sbjq+caULP32qBLcF7qK4ek3X3dTRiST4FrtzL89
gdwT9yn/5zH/4Q7iE/1aAD+2UTWolBcWvJTh9QR/pkZ6LX1dqHwd73TRkU2e
I7JJj48XhWflvJ8vZn7BHZxbuEdmncAth+YTwiMYwMWL4m4i/pwMcttadLbd
pDwai1JEbrdCX+C+HKMtRTF3B3bnR12ijt6kJwPcjJUMhB63Qalw+XFFzIxB
JH6WqqOOyZIPbiE7ntKt8BFH0Uesza6Ygm6dHCjgZxmHPIb9IS7NfD9L1yk+
Du9rME7Wa0PRIW5/uYqlkV3WeGukdRTb5t/NA7/5W/aQxxqv4jHwSxJzne+k
7J8lRiHb/jhpv466drKma7h1/uAH5jrXdE7J4thl2VwvAlfLVGSA+RjHgazj
dvmAy/zldulK0bY6WrIWTzzJzm/WaAO3yC9NwhyRodrWGqSPF8mewq1x7zZx
W7XSFtG7bUu10tI4aYlXDdzSZs0SDEnIUqNtqU09PYVlzWIoyK2wz5V3BtoK
f2Gy6vNyzy1qT5ZF8T1xNiH25LMZ4mzJx56tak/RWaxVzHJP9OrEiqyoJ+KQ
e9eJvYUB8q5g1uzdOGTn7qy3qR/uC/4WtrCFV+i0IFvbgmyBFbCY3Xkb26jN
bFgU8fpcYQ1/36h5WKyOSbV7wWNmmjWsHWJOwhr+fMd4+gN/C39yeFtYxb12
dIFV7BvpO5xFPPIia5gbrsyEtXEk7dzqZmQVf08M+wgk4FvuNWoU9VjDfQP7
KKzhpzLVI6ubkFV8tuEeJayq+6tjaxuRNfgU67O9U3HmiLOOfgJUbmsDsgUj
oHGPXWFnSoGddciO/qnl3kyVEdWhvdegvceTe08jqeVWViErb1bvy2uE6E/q
GQ0wNrI3V8hcYrLWmh9TtJ5ecMxl6JiTpVWrB8Ldr/XjtsrjAql8LGY/fBAU
eR5+DlaN3PdWue8E2VqsIZ1JfEa81S2ydYtsLe6KoZ6vUi9bqZx4lIpQO2a9
4iOezYJi440XydqjSbYWd+p8W5qfZfzdBbLVaM2T/KlO2jFlMiWe04PPft5w
trRUR9KbguzVmq3UEcXTrHAWxN59u6xaLb+k/UsC7aunJPHPhyd705jdBhUb
sst3nxFo9yrkNzWeTIvk9duic0XgUd6das9u0axPt6zyDRhRUWz8ROCvXRR4
xFnoSHgsv5g88kTLWjaqy1fGSN/U055E35qd2s8ATNXoY2QikfSQvzi18Gji
Do1zkVV8BR6P9uImpwfanods4WuczhsGo0iODoZtdeaLc/XqVB+bzUyjQY5T
+PNN5bnaRNrWW4l7z8LzGhvwlUpEWU9+knXWK03Sj0b5r7B8jfRe1WCR9JT+
xGyrs+GfhdIK3+vS4L3eg2JtIUipM6Eh2OpthX3BPotctn4jFWdKTaHNutQ8
U+YE+rI44+caz0dZNrIrD0nRjq6RtKDvc2Oqzrw6RcNrUT1bTPWlGwM9WTEi
7RYi9ivh1RPW7+hN/wcnriis\
\>"]]
}, Closed]],

Cell[TextData[{
 "Draw the axis edge that is the intersection of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SubscriptBox["z", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->530379811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None", ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127219369],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->{{-1, 1}, None, None}]], "Output",
 ImageSize->{154, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->391453014,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264995808],

Cell[TextData[{
 "Four different positions for the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->47467851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Cylinder", "[", "]"}], ",", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"AxesEdge", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"None", ",", "None", ",", "#"}], "}"}]}]}], "]"}], ")"}], 
   "&"}], "/@", 
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153813159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {-1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mntwFdUdxzfZexNCwGAQBEOV0lKsdhMQQqh1xnbq6B/ORUADyNMQoklI
SHLzftzXBlHeIogCggImfeu0dqbtH/2nf7QzbacP+7bVvrQVqxYpLyU77Tm/
c87u7zz2cnOlmclN9u7Z3/l+9uye8/39dmN1XY0NrXVdTfV1s++J17U3NtV3
zr67LU6+sgssy9pMftfNsMj//yX/we9mz/Ms627yWdjQ0DALtu7iW5ZN/mmA
H6sC9nyBfNpk0+Yt2Ld38q0iukV3s8OsG2DvHfyYCXQrwvayBjNh/+386NKQ
/Uv4/sl0K+rv533MgDbVvI8pxjbXQ5uFPM7ULG0W8DbTEAn9t1DZvg5aV6Kz
UUZOZjSnoz7D+6B7I+Qoq+xwlfv8fHf0Nvfri91v3u5+5073+18c/sE9wz+6
1/3pMveXD7i/We2+us59/SH3b5tdyyaHqJFtZRsYrU9zfbR1Ie1petJJb3fS
eyozB6oyR1Cv37pSr/9ozLzdknmvPQ1xUE8Rpedy6HkeZ7RFzxXtTqrXSaVo
/xne/3zU/+fM/f9B6//9rvT5vhQdMRrX3PtctfebNjqJRidJNPQ5aaLhMdBw
EDScGKeGd5GGD9LJsW0JUKKOwLWgZA4fAdA5lzRb7gytchIPOckmJ9kBctIg
Zy+S8yUh57uynF+EyznXm6ZyUsnLwwnvsYS3a8gyXCVM02x8t84jzZY5g0TW
aidRJ2T1y7KOXlHWKiTrkczbWzLvtqXf7zTI8vYNmpTBfWvdiJXdQprFnL6l
zgDT9yDoa3aScdCXcdKPg76nkL5v1Jj03Q/61rqvCX2nDfqSvj7vQL9BYRko
rPDQXObEnF5f4QpQuEkoHMhbYX24wu0Jb+eQt3fQe3LAO9TnHenhcxcb15n8
7E2kW1Uxpxvk9fvy1jiJeie5xUl1Inn7fHkLcpC30f1rvfumkHcGy3N1eb3k
NHKFbHyvF+eU7bBA6QIYZ1XsWlmsi8Q+y8QupGJfVsTel1VsD4hNmsV6x7sD
vWy0S+ho+9cC2wvzOr/f6V9YtW4Dhk4f4z6EsdlJtgDGIGDsAIxDgHEyBOMn
oRgZgvEfwLikYOwf8J7q8w73ese6vRNxhsEoJirqYaaKBNsyH6WHIxYame53
htYJpq4Qpi+HM/1aY3qHMMUDpg8J06MJb8eQt4cx9QumzkDfNSBbrJ+RnPjY
usUC0G/hDl4Yc9qBscdnXO4MPgCMDU6yFRiHBOMTeTA+nDndnHlnq8yYSY7p
jM92e893jr3QJjHmOHZR/xt+dDH9thpG0Afsw4DrBWA3AA5/BMC3EOCFAbos
SoBPDHgH+71nAsBgHCfncX16Bl8VCa7XjpjTxWiXctqhWiexwUk87CS3Itqd
edBuCmj/TWi70xf6ZdrdmLaH0p5qN612E8O5izA3+yxSjrZDaekyuRLR9jip
hKDdX5l5Ojfa3691/7TR/csm9w2Z9rxPuy3hPY5p+7yjPd5z2WlL+D1YxP8W
om3NM5P7siWMjli5R5xkm6DbhuiOhdD98N5hiW6DTNeRPuvTpWW6A/3e04yu
a+xUh5hCsN4SoJvGaeC+q8G5RcxpjTlxMYsGdmaViWQXIjkVTvJzE8m/WsNJ
wNQEJCc7zo1uyUKCr0ogWuy3ijlbjTirqamlHrsNfH4+OGtCcJDTxh6N4hAH
dJzgxC+OtKiZwARpXICtmu3NipBkaQJBSIYgvJgjQhNFeI8goGQB22BkPLrG
TsQvj7Rq+SOce/gMMgx/WkD5TzBawLmIRIg5bXjxVlx0E4J8lEBW5gy5EkE2
ZP6pQ2Kvj90V2JKxka1mxiJtzi/WvpnMZwYD2AoE1oHAdldmnkRgXxkvGE71
/CQB20bhTeiyps5kRUy2zYeLjxgbZITFSBV3OckzuxPfyW9CGWQKsT5TlTnO
WBe5Ly5xX75jvKymdAN7S7aEFyus0XGPYjayZkS2XSZ7AZN9PpTsz3Xu34HM
LxoYMhWT+8qZLIruSjxiwaKFPbNIZ3jyysoguXP9aqX7uzXuH7Nw+dkAdpW+
6SILM9UbEbl1CI/usYJtWMUXxZxmHXG5hJiKo/rBnrwRG1XESwoidlrgPahi
UY3T3KE/i4q/wn9A/rYYVmndO/JUwE/hMNeBqszhqsxzMtf3cuOiRZvOgEtK
eiRPRV3H2dFmpbYaUF1nGqVq4TlUJ6zQsCIAonExzbez0Ky/Ao3qh5HzOE+c
h3qPMZap+E6qRqu05ABrRe6SJ8MKlYGX0Vi1RUnRdB8IduMDslaHM+DxKFVZ
uONQvHqrSKb9mpHC8tI4Wc6EsewTLMJ3kCU5hEU4dVthEt/Z4u6pltfkwFHp
fK7gOwj1Z8b31Rz5WMlTVHOkbFNxurLlCOGLanNgRPtGnQVNvP26p2eZZp68
D3JeVuI9jXmVDEzxkb4Tufq87bnwDim88ynvSH68cY1X8c3YjUxQeO2rxNuj
8LIMgeVs3agwtE/hrXZf+mxuvH5ZD3ilzA1baOa+uEdpHx+voaIAHoyseU1o
zZNsmJ8KtaEiwg5RgGUPbnIEfR2B8lofSlGlXGG/DHqqfVycUZXTX0tqlGoC
JmVpw9UhRY8XlKJJkPoFhlryLmdGm7S71pZmYVw30a7YGsW/KJYaZ3zjIvwx
I6yVCN9EhDg/V1MG5s6EizlnWPcZYbmH1v0axbsY0x5Mwgp57BmGgeQuQbLU
/ZkgeVUnwZUGnPzs0UhOdlwcaclCoo3NzSYnE3jmTXLSus1E9LUciVhNXRS1
4EHLJDXjwYYMzMyHI63joJmreRk1AxDJm0RzKDeaV2rd3woa9oSAPS4qY/WF
i0N0gAxZgF8KYuu9Om/APQNPyQrF7DdH8yzcXzKPjDjSRo7RXDjWuaC+PKgz
MozBFBkVKg/bZGTLmG0Jp8BVILhrbpRX6MBh1grHz1JPn2ZXzjQ0Z7Sm8fEQ
lTlR8UlTFMjLqMwdyGEqjsTMEvHCK1s2Hq0KnW8Z50us53ypOCqGsLLdIfHg
Vedj19VMPFavaYws97wwmGJZDWKUXabZhTBG/WmGXhOBZz0zYAI3uI6VgtHP
QbMzAtks4+WIn9n4NZ8AERIFCsAQVaOlrce5E8IoTperByrkBpTWBZCVEiSw
3QSjOBx2zzHIN3TIAQEJ7pliYEi/UvIRKcvltVg1zEbK3ZUZep9NoRf/1Lf8
elynQTbxSlQaNoXgIM6ONmurUphyXLvSZvgyeQUOfKGvnyV0TD90R2OVn3yF
v83ENSdSknHfO0h1Ba6HegJTLSCbZvQNnh0miTVJ9QzMspMUxWKvLFUIjaVc
105Zl1jhL5EVXr0KCqQZS1SRRHWXfoKWkjAtxL9AuDlEAxxZ4jsl2gnrHRbk
y4YVjPU+BVNHYQULfAW8OjdPRC9mvoVGOJplZQzi4usA1hSbrZDwphUf41tF
9ChZqmgQtlQZ5j5zXHp9wR1ss5mchqoiMZl3P9JLjzevFzJ/iR/Ho49z6NIA
a8YCGguukWPdZDcJZI5TpugStVGbc9O8iGpbROPRdjSYYWZg0aDuaHDmxpWN
Ky/mPbWQ72gn1agnmgvQngrI/7SHguCOyOktB1u8A0Tit/L4i1F8uqs43/gN
/D1MmwWmYWuU2EV5xBbvk04Ki+2xNwbyia0+cSr5P/ShVmeLlT6W+Fcm/JCG
Ua0X/ESc/p3Az4kxlvbGR0SLN13RFPXCuT1Pf6uiEEVk724Vct3ZosC5ieIn
4FQdizHT0EO+sW7wgnc8cYxqJQZbN/wYPs8sLTa9P+l9UoJUBv19TI6DZwd0
XRX68cW7jCpjlXJUqXSWZ2u9mNoHvXzcQ29qW+xHzNJUT1ScIesT6rknLcRq
Qa8w2il7Zv5JpJzupSuWze+jiLhHrU8ZxpK2quCtbd47e/NvntKaXq30Er6W
tI7yuYXGhrcPrJs9fOUHR9F3rCO8JXs3/BZDXLx9DVcBo2fdKl0zQatSHnMO
tHK0K6aE7wdmeOsbXx8R3gdosarIZxHZqmIDUvA/OaLxzA==\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {-1, 1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9m3l0FVcdx4fkJSEhhCVCQwUJVdoqZ0igBQQEQl3w2PNYytaWNUBKErLv
29smQGmhUNYuQCi0iUvdPepRz9Fz/ENP3W2r1apVW4tL1bZUoEDm6L2/u8zd
Zt57CZgDL5k3d373+5m5797v7zfzwuUtlRW15S1V28uLlzWVN1RWbW8u/kR9
E3orc4RlWRXof3ORhf7+L/oL/le4rmtZZeg1VFFRMQ22FqPXDLSVQX+Tdxei
10y0FcJb+A/0G71axbB3Pm2bY9w7j+7NU/ZOhb130sj5eCtE9pIG74P9s+nR
Y3z2l9L94/BWFt9P+5gCbWzaR6GgAP+ZoWzfDK1n0IgTU2p9O41dpOzNVLYn
QetbaeyR6HcuugR5KR31AXoUPvvZ6Cgr98vzna8vcr5V1vvdj/V+/5O9P7i7
98crnJ/f47ywzrFwi5ASR90GtdY0qh33monjTjg8M3GiJHGq1Dlb6gzMdp6d
4wT09NJ9zsubnFe2Oq9ud17fmfhbdcKCKJnk5OMuspV+b4J+p1Ie3u+UmB3f
a8cPzEx4AmaBgLlUwLeX+gjYKAl4oy7xZmP8QkscD3h0/XOM/U8R+s/A/RfX
2rFmO9Zpx+NYSIIIeQyEnJvlfDqZkF8zIX/mQmoT/wYhFzviuCfUSZaiBcYX
jKJMUcutm+3IA3YUKWqxY11DU7TWV9HbLfH/tGNF70ajVxPRwT0Rw2ghyoro
WQLdH0TNVtk999qRLSCvTpD3IMg7AvJOM3mfT13eA0Hy3H09VgYdVKLGCaBx
Aj17MM5s1Gyl3X0PyNxqR3Yymd12PAEyHzHKXJCmzAZN5m4s093f4x7stgxa
3wNaC11vloQrPXOF3UX03of1RoneVk3v47Ler1wXvQ9GiF73SBeSos5tRPE4
YbayZqNmYbtjud0pyi63o5V2tJ7JdtKX/bws+y9IdpUmO6LJPtzlHu80KIc5
3iqg4yIXb80F5e1c/CoQf78svgfE7wPxR0vSFv8HXXwzFn+pK4ZkeOIfZuKP
dbqPtyNhZK4kozmfnm9YC+eF7VZF9WpQvc2OVoHqtgDVd/iq/pmoegtV/VdR
dRtTHTepfqzDPdnGhdORkkeVj8Zb8+F8c/FdK+xuNHWssXs2MPENsviDIP6J
kkRfqfO0j/gf3u0EiP9HDRX/DhLfScVf62XiH+l2H2Xin2xz+1o8/WS8jKT6
8bixFoD+5rDdZkTYbkerGULEjveaED6TFOFehrDNQ/hXQ/wtAeEKQdirI7S7
fa3u2WaC4BGI7gquxMKw3Ri2WxhJ53L45CKStXbPRkbSaMfaGclDQHIMkzjB
JD/SSP5kIrnokUQxyUOM5CgjOY1JvOsx3qOR3N4o78r4IUU22ZEdKSLNMyEt
95B+y5EqGFJ9CkgnGNJTzYNPN6hz0xiPTXOq4AQXAV+TkW8d49sFfB12LMr4
Dml8X9D40Ic/OV+TwBeLXnMY34Fu9xDje8Lj867aOG0MugbHnEPHZJ3A2BFm
Cwph3EwZY02YMY4Ydw+b8TXEWCkwtsqMezgjXg0p4ymPUeMoMNKqqz74po/A
Fa0H4FYdeD0AV9jRmhsJfAEBd3jAg37AZ5oHzzVe7q8x86peWvWzodR4twi8
nYz3YX/ebwTwbtB5E28aefcJvMc70NLrnmpzz7Qg3iv9teqVG23kVXOZTI+3
AZYLuuKFBYfE/XINSzBiAu/xksSTqfCu8nh/z3jPI95diX9qvFc5L7N3yCdh
3pOEt2mwv071+/lGXnU7w4d3uYm3VuN9lPGeKXWeEXkXm3l/RXg3e7x/R7x1
Eq+YJYi+kPL2tQyeHS5v2K4M4AXjrvLuGSZvuczbqPHulnmxlezweJ+pVz+Z
o4y8MH+VietQ2K6B1VVlXaUlKST3I6z7NdbPpsz6R50Vpcx+qcphycO5abBC
HrCEb4ftWtlGEI/neezyYNDS1EDXyKA7VFBDTkac3mHB6YE/QqDa/JNnJIV3
F5NtDbOTWVkPs1LO5VPFXOZh/hIwf+NhOud3epjmHE43tMxTGK+cxp7PKGUz
ISJSty7meKyaEt8/U0O8Mw3EVwliNUaUihaRmCHt0GzhhYFqlcdMCevQIiPi
SjmnunGIal2GI+7VEAVneHFgl3m+8WWsVzyhmKpsEJJeXh7hRbETJYmTpc5T
AuNXfT6QmHG9yqgUSUjqK7n7AzIjM0rv9tdoHjAnBcZWE2OEpGMkNxZLQApj
f/qMr4uMzf6Mkhmk5uhaf22ajHypNHj7jXLynJxxYRLG3/kxSim0xigZQGwQ
gCbEKl1DYuO5p1jbGDrb/b5sXnkgZmQTzA9hgyo7rTBrflZz8cC6OGxXK05A
cfFiKiriktKfgvvF4eGqyRrxPjou+AFeDU6Z1Ox5xPyMJKSkqCBW3I6wivzw
Sd/SSFVXK7g84nxy06Ks9aMkrp1koZyS17VEyrOc8sMpUG4aKiXxd8z2pEG5
xGTr1NyE557BlJ9LRvmiQskqv2rlK4jSWy/fHqjS5tlgUsUTeAaWOHWedTYJ
paJg0m8mI32lHG60AalX4zPknrpf90jfGageHqnnYZX8i9dPeNHvKNyESIX0
pwrpVkoqlcY4qW7YlYImJm28hPyBOnqBUbvfVkBJ6/2s7Goh+yKZplgpOshq
/wrp11IjFYvoSr3IkJqYnNAV5BKGQmpwQmL6pdQQRNLT5A41Ip3zfyPFfgiv
p+mRqp5B9O5iBpYW6XduIKngilIjhc9pWdiuCobliQpJN31hZw0XlhWI5Nya
pyuHujybS2pixtU0mHVXgDtaq7F2yWW/Yxrrl5KxvhTIKtYRaGqm213BI6XH
qjoHmRWbep6cidWS680KhT+xmBA3snp+0OySCKvqhQtSYF0nJGlisr1HKl/T
G7ADs4fECkVsXNQV60M05Q6y+uCVGtJgXQrrqtkr8YRmu5x0D5n1FzorKdjL
tTDftFTxhayIos1PoWS8TX686+UEzofX4bzPyrzfY7zPybwvb4IHA7ZRXqUo
JvFSh9jt55twRSUN3hLNTUhemOc1YjIulv/S5l3HeLdoBfvGONzKtQowanIz
jO9ApUE6w8c3SbnNDq3ssFcodKZButpASujG44sKj05cjuDrmoQUjNPV/to0
SG/3d4hSfiNm5TppH3+ALIB0pUC60cFCrIn8gtJ6INQhLvfEkPFH+yVWH+uU
But02UwYfP8WOWNlrAle+Axi/bjKCgKsSfroxbCs6EJg0YXFYgms2Sca3ROh
Nd5bfT/UWwzu6boDE87JL7KHJxXgN+qksgsBvkqAA+yicaUN4C2Wqy7mJGCr
kMJyXlJRS8oLlFOfCwsj2Yhba8IFw4gVK7iyiTI/u2vmnWx0FhpvVOEVK4j8
XjHnhVnnFnplP9XLYV/QYXklXyhOYFghFcCKCazsGImLSoN1UrCLWmNijfiw
ktF6mzqSl1Henxh5dyTOm0pOl7tjSuqDhWsOmTgpXI9Rx3MA80TBTZmZN8hJ
bYfGjEOOxw+bFL0m35bgNRYVAOwRFiJZQa/Mkob+wmB3tNagP470w7OuKBR+
mrXw3PNuFn6jkJdKuGDRp3uCZT93qV/3N0Sx+Dz5WPwyJsDbkJyEq8WC8Odk
ClIXwhtjsCItc8DRNRtiqmr4KMoPVkQyBxxmOtIBT7zne92DN8DRxO7xrRdt
vfTpPReWDnPvcPgM1Cs8cZwnehEcQl6f1U95htYfPMGWo+X6eHmGA0tZTyOp
3znRgY8UlsUU+8iEHBv3QdwVPmkoNvpnzWZ9ZLPo3hqUWnSYVUJEvAU/83Bg
/MUJdEZww74k8bx38lm8LHHewzEXMJ3Q2rxm6PFyXeFuTYjNK/gByUVYY4h8
sYEkQOr40KPhDDDE74iQaFjSEhwrk8QyZRZ6pAyqK49FIhfEKoNIaAdy7XiX
8RlAHgmfKP6csHBNywQ97CyIUUaQuQu9MVY5cqlypNr/CG0EFCgR7mIRqD5z
BPZ9KFX5R5Wj1bve5Gi1tpJnihIiUUgg9R4WiaPWyHOHGCeb0hiPz+LHUya1
VxLDWMX3OTN8JCiz2Qi0iaORiLlUlRrpLiWSejYztEijlBYhv1FD9wNhFm9P
ucnYZU/lqzHKlBjZATEKDIrFWEuUWDCKpOefSZwxSeIsUuKInyNPzVjX+/6T
ePRC5ehRrvddQIs8mS3x4ZlEPWY0PYZch0IxgtDTXDo3jpVaT1DpUIs5Snx8
NUJMO3xTKQNmcyoHfmbR6KNoW/LEQhE7pzwYbmPTtng0Yzjy/NgkpoRGhNkP
/b6Nts6hkWE2gu9wsW9K4VbT6CrPZl/yHYnJCh3eiz9qN1FvEqIKyHfzprje
J7SI7gUnA3unKrH4J4ZuT3DF73QWC/rEVuNoj9Oh1S2GsYVZC2isD3HWTPZM
tDdTkAnYylR6YGd1JjR5r7JXbS1eSfLKqO/wPz5b1OCSz4rlzfhsxZnnHyEk
RmDr3MIU25el1e5mek6z6e+l8G6F9mqN+B/j+7s/\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, 1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->155451001]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->67196238],

Cell[TextData[{
 "Place a label for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis in 3D:"
}], "ExampleText",
 CellID->97822314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537177117],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesLabel->FormBox["z", TraditionalForm],
  Ticks->None]], "Output",
 ImageSize->{154, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->131235113,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151751837],

Cell[TextData[StyleBox["Specify a label for each axis:",
 Deletable->True]], "ExampleText",
 CellID->230946731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->433750576],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  Ticks->None]], "Output",
 ImageSize->{154, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1225098,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->187450823],

Cell["\<\
Specify overall axes style, including the ticks and the tick labels:\
\>", "ExampleText",
 CellID->7911699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250467504],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->194003760,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell["Specify the style for each axis:", "ExampleText",
 CellID->182866778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61145213],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->576103628,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25478268],

Cell["Specify a background color:", "ExampleText",
 CellID->732449720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->636131],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], SphereBox[{0, 0, 0}]},
  Background->RGBColor[0.88, 1, 0.88]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1529954972,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->326603403],

Cell["Align the center of a graphic with the baseline of the text:", \
"ExampleText",
 CellID->499253726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71322552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    BaselinePosition->Center,
    ImageSize->70,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", "y"}], "}"}]], "Output",
 ImageSize->{125, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2131508873]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642270484],

Cell[TextData[{
 "Specify the baseline of a graphic as a fraction of the height by using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7133431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", 
        RowBox[{"Scaled", "[", "b", "]"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "70"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200239423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     Graphics3DBox[SphereBox[{0, 0, 0}],
      BaselinePosition->Scaled[0],
      ImageSize->70,
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     Graphics3DBox[SphereBox[{0, 0, 0}],
      BaselinePosition->Scaled[0.5],
      ImageSize->70,
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     Graphics3DBox[SphereBox[{0, 0, 0}],
      BaselinePosition->Scaled[1],
      ImageSize->70,
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{347, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2094912904]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaseStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->890586598],

Cell["Set the starting style: ", "ExampleText",
 CellID->65039657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"BaseStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323696755],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], CylinderBox[{{3, 0, -1}, {3, 0, 1}}]},
  BaseStyle->RGBColor[1, 1, 0]]], "Output",
 ImageSize->{184, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->707498909,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592061771],

Cell["Set multiple starting styles:", "ExampleText",
 CellID->231089630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Opacity", "[", ".5", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Thick", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2678569],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], CylinderBox[{{3, 0, -1}, {3, 0, 1}}]},
  BaseStyle->{
    RGBColor[0, 1, 0], 
    Opacity[0.5], 
    EdgeForm[
     Thickness[Large]]}]], "Output",
 ImageSize->{184, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736584431,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNnImfFcW1x8vue+/szDAMS7G7RM0zcTduiScaN55rjNEkJp884yNxFwFl
ERFkhxlgQEBZVRRZREHZZAeTvE19f9F83jvn1Knq6urue3tGPvmEzx1mernd
v/r2qXNOnap7H3p65rNTX3p65nPPPD35vulPT3v2uWdmTL73lem4K75IKXUI
f5aMUfj3/+Ff/HNoYGBAqXX4fzR16tTJvLUG/49xS8X4x1T+pybxkV45UpHz
zd4VsreJtugP8zY1kY8uk3NbaatijpoTJvDxxfLu9oLjC+V4V+b4eD4+X46P
oK2qOy4axvE580TDqDrnzJHrjPFaQX9GwTYfV697bW5CkB3BWXGwPZrfNUPe
RddsxnepJjVJqclKXaLUZUr9QKkrlPqhUjU6VOqK07wrxviuWI1WkRqjVJfS
So1TaoKCdQDrATYAbAJ4F2AzwFZQVyn1Y6WuVupapa5X6kZVoXcH96gE28xP
vSw0k3uOMjeGlYAvFcEqUD3QC7AaYC0k99+Y3B+2A+wA+ABgJ8DHAJ+Aukmp
m5W6VanbsQUixtxa1QIdI1nHC9ZOWab9R2piWAExSmElOlHSX0LJLoDdAHsB
PgXYD+qnSt1Bl6X74L98Jc+KEpJM2iPUUPM1jBENa6yGd9IatnkaPgo1wOcA
B0EBaYhyNPSwhql+3xQNzb6GsfU0bCnWsC/RAF8AcbhLqbv5GVUDJdwH1Z9E
SdVT0uormUBK+qySdcVKPixQcoCUwJckBo6Culep+/jZh/Zq9Pyb2GuT6GET
QT34crpioytX1HvFovYUioJjQKKm5OrqZl1/EE7NfJTOG8WvDl/TxMaa3vc0
feJp+ixHExwHOAnqAZXT242q34mq1kDVMF/VpBxVm4ak6kiiCk6BelDlKRvO
yp4c8CKFKKNn2IX/RVbZ5AbKtnvKPvaUfVqs7AQpgzOgHsrTxnFJ/VpsbFhA
bbiv7eJQ24ZBajtYV9sjzC6MV0bfY8KuM9DXnadvbZ6+rZ6+nZ6+vcX6vkr0
wVkQfSE/VqQeEX3dwbNN6bskpW/9IPV5HizUd5r0wXlQj+Yp5GeqHhSFPYHC
Eb5nY4Wr8xRu9hR6US/x81mFRzMKz9VVOEUUjgqecY+v8OKhK0xHATjsKTyZ
VhjlaOQMSd0n/UQHFFMaL83JHTaVjdj5Go9bjWdII3wN6pe5npl9i7pbSI77
p1Z5p6icEKgc2UhlmcyjOKyFKs9blWE20MYq7xCVk0uqzM3RclXWDb4upIQq
w+yJ45y6XVReOiiVZfKWcoHPuMhGKm+V3nP5hVVZJjyfyFMZjlFaWOVPhOWV
ZVTWzwEHm0QEKtEV/UGp5kAlb6sbROVVQ1OZm+qUCdppl05B8SmF1ylQea2o
vLqhyvppYpnUojg0qoetypZAJVuAulrs8nqjEor95RCSs4bhkZ0RJUC/tSpb
A5Xcm9RVwvLGApWpHKOhxDI5Rp5Ek6vkK7xSFN7sKaQhRH2FDbOgcnGHBgVP
JgrbAoXs3dUPROFtfBTeAhodD03hoHKM40B3YYUuV2kZ8OpO6hLZ+hltVUQZ
ixuRp61k/lMQtXOGeU8o/zq1gaQuk6U4WfrLz3kXaoX5LNc87e5B6s3NMorG
yvfwWPlxFVyHdFJxLYw7prQyQVpzF5uq0UuSfyaSy2TpuXlRo4xD/UKR4sdU
cB39mnY1xYzasaL2HnZQTi28mQhOj8suzc+J6ysuiEWk+NGk5qanaf2q1jO0
cR8q7FVG8WhRfL/tVcI3Is0x1aCm8KtrMKrr50ysmjzMz7m09bDC6+jntX5R
65d1EIkLVPeI6gfyVFdgHhDr24l455Ay0oLITw8RyBfQMOIvWj+nw5zxvfq6
u6X3PUz6UbDTC28A6b2NK1YdpTXXzalMQVPdT89P/7umXpib51rnWKC5U1g/
6muuGc30mss3uoWVt9VV3ijPUjdiBkeXUncrda+C5VQnw6uJ8mz1sIHydlH+
K195s68c5gDMBir+/oRLc82Dz2ZZv7pOStnqTqXuUrAYYCnAsrr6NzXUb6PM
E77+tqx+mAXwOhC6m1hDZKriU2yWEZdrFatR/6LUj7hAf42i3s8WDwsB3oac
VhUlLJvrtKpJ+sBvC+3JtCrCZqEPfR3gNYCZoG5gxNfxtEGFKu12vuFSmW8Y
r9RERbMaF9M+mtK4HPMahmKs6jZF138TyF8MrUXtQYu40sCRlVr0VJkWtboW
wQyA6QCvAkwDatQ1NCkSEfqYHsFV/IrwgUT4R0S7JspzuZY53KDoOq+zBcyF
pGkLbNOWJE3DJ0+ty62wcdOKW+bPq/3O+Nv5IIlD3ZZWg5bi2a+SMU4DeAXg
Zdp+ibZfBHiBXrj9PMXwF0DfrfU9/LpX07nTmNIMvtT3bK/tvXXam5rp41F5
KyziGyzi19tsPQs45swjKT8aDJWKTyUiLBVjAgZKyCTWv9DMhHbh6yXIBzLH
ApmfAbLcA1IUtNmdhf3VY1J1e8USJpg2L5U74J/LUfsy8k9L+caLPVYmPr/B
Kl8DdeUF50Wmcje98LJiQwmvl8vxWnQheTWaxY2dmWJzVnFmxdMcdPNlECJc
IEkkSZ5NNLgKU3UEJcWMKPGpDIqgvk9H2MlSFkcEe/IJTi9BcClQB8I+U1RU
GwS7sJLb46xuFWAcQ6PpwxbxH6uYJ0+tGYgRilEtCcG3LME53IIZoC4rphg7
irg9m4hxjDUYI3pzFWHof9V6itb3a+fNmhxHpAjP8f/s2V6k55uLcpZFOc+i
XAg8tzzMWSK2kIyxOHUrRzN3LpDMT9L51ZglrMGf1djCPppe6AXBuhJybNPH
yn6QWjOTo9klQyWrH9Sqqh/QfhevS5YMF59yMVZ25zjossYpWSVDxZYS17JZ
ZT7VcLvTUF1pqa6BKj45IottWM17+yBBu4LaJ76zRvoW246/EDiX4D7NjpMa
9wJMHhxb/YjWD2v9kHZWm2Vby7KNcIOttiZsp1m2rxnrHCn2anKpRTaXsjl7
Pl0/5w0jMPvJjI2GdV6z2sXVRlH/WqjgPWL8HdGOWBj30rFek/PGzoBVxJ5h
qfEOTYlzNZ51Ork7s+KoMWH9S/Sb+lFtrBePzyRaXlLnRah6hGNHmBuqxojt
zoUyiLHNRDkvXS1HOKz+Gqt3lRT8k+iuA/odiSVH4iMqhLmaZ8/IdmlixeIc
0N4m1mGrH9f6V1o/po31xs4z1GfbnOsZcCcdZaLjnOk2QLvMQ2tHAkS38Ugg
n21Ys24xvsFVqfqhCcnW8LciAxbiEW5XLXrax3a+mvxcL6tbDuIoDNzZxMRk
ZCmy+gkkqX+tM36hLNlqQJYzdCY6kWz2FesVZli0sy3a4kFWUIonukOx2rD+
1pQhSzYboeup4G9Dch3tVhW2Y7JnOvYOn0PbmLH081tXg2BextoXsHOYAeMt
X/0bTa8ndaHfLcu34vPllS80zTJ6cBjXWozp/LSkhVJvj2z1NcWPmFSRjWqS
/He9V8dZT40kdhuoFeYB8itGATH+Vu20dwOfvA7EtntZ/DJuzjzqkZQLsz1V
kWjWIzQluaxf6IgIbEswgjZYiSrNWuM1R9Af3blDw2CxCcGrn9nnswtXXkaG
YW+aYZuFZR4Qqt9EzEyiwUYf400jtHz6rTpIxHusZqOgFi+wijv+IiaERmVr
oHGxR63Hr+Lz41UTeK0qT6bT5MIRfh0GOETnf4mW8AWwdQ7Lp8hZKYEcNEVe
QdLktunCduSgiF+LscF30mkE3waPbyG2W2V+DLe3I8UdQL8jKsN20LEtLOld
ft8GC7SPzWER9zHE0SU0a0OjGdMTkVWgU81aSSR8iqffTtAcUgRfkT89BgLX
kI2RbCuSpXW8OHLOVtU3MtPCang+0U5LlOzF69Hk5Grs7d6h/mNGERvSoc3k
ZsQPT91hZ6RMefkD9Jcf4rs/wJ8d1MO3cdXc2Kth288tWMF97k3qlrYG2zJ4
rsJS0XJlWkdxlqfXT4PDGtHcXI3m6NJYieowpMrW3BIMmwhLYQ56US5Ps/5b
T9XOMP34oWK59rvUnvdI0WZvypYZEjM8z8yM7qQ/P8J9H+MP/d5pjrfRudv5
fVvYXDewIazmvsbd3lWE24tp1gKalmILUfwrreyB8xDgxHeepDyKLTWfZ5fl
2eQPQAlmPZK5KxarZB99oJ/VXi8niOQk0arWZ1LZbd5EGDMkbgjRzDruoit8
gvt24xU+of27eELyI9r/IXH9gO14u+W6ka1hjbVThFYd8NYoNsz8XQ9vgb8D
/A1yseK7TlEvsw4gi5V7fzdyrfCyG38ASlyzmVBdpqtkMKCf1yadNNmP6hTP
ud7r6tmZo52y8IFJohYzX7fHLjHYg2T34vX2AB/vcITpvQbtVn5YG9lk+wQt
+yeSaj4h4UPlYS1FL+P5/gMI5fem2WNpVozxDIYjP/sauUy38GYt6Bc054+d
YpUbUvGHKBrD/NCb6/yE1O6mCLvHzi7vQ0/xKbLbRzI/5b176Szh2U4wd/Kz
2MHPZXNCUj+j9e9p8s6srTQMqUNT1obbZu5QKfnkAvwXwH8C8sSr/518ax5Q
PHaa8l0vPuX3+lHIMzbX5Z5ItxwEzSZ/lGo6OwLl/s622ZEdWIVrSHjumEkh
z312McR+HDd9htfYjz/EdS8x3MNTn7usWe6gy+npNKmMNyUBK2GUzTdjzwqN
vfw3OHRMrpYlFxG6Nj8CFVvi6IQct4tuGkbvfHLDjB0uBb+ExNUN7NY91JR+
O0Fl406Izs0D7/YWWxGrz/Cpfo6/DxDNg7x6gF8R7lVdNDO/n881JrqbLqPf
1PoNrWdrssv3rPNcTd2729Ik95nymNTyCP4HLjzXMQnXLTBg5iLCsWAdrlWp
qfb59SMmO9w4TsK6wZYBt9oZ3uw6BvMRnYit8HNqp1mIcZBeNfxLDRe+n/Nr
P+glWi/W+m1Nz+Vj29e3egGpD9xce8Xr6xT3YxN5vwFkSi8Pqunn1YAq7j1L
fSKdMBX2c51Q3QYGWaZ2UYdqhajaimrE9SFH9UVNbdtkeW73eGYM1KxjQ+0H
6WHzuhZ8ockYlapLr9J6pdYrtF6uxVr3gXR8r9eL/1zvss8mj6fzlc3wLeQi
vRBEx6L8yBIVOy1HtMP0/0V2IqpXrNXU3fpNRNev6CQ3ej+z7DdDs+Josr7D
eKUjxPgwqdZrqE60WtM4D69uzPgAJO5gt+dWt3sBCi2WyFIcN5+xTAhT//8W
6tpsxSccEeKObI5f7AnGCeFwfo0UXYSbRLcO4QrVBCzhiOeRVrPdoh80xdR3
gRZPuSwpdyETr8qLqL9XDFsSaOhGqDjS/VQjXquNepVQP8SWzc+mzTgIseRd
NhN434LGQFkROx5mKRvE8B0w5VqWckSYq0FGpZhyexnKESqMPMohw1qGcvgc
xN8uAX8aS/HM0hgJamvY3ZqkdwvoWVrP1dT67JJrb/WjQOY1rhFKjvQ6Yrxe
Uwu+IrzHDHt+BofIqr6wnni/jWsmed1pKW8CK54+7xWbjOA7IAfBPoJjWezg
KqZb8elGhLctd5jqwzUWUHEWgK/xBXZckvCksLbV62UN/XYo5TkKPV8XLcJO
6PLyUjJeQ1eacJz0Hyf9plW8l54BMva6p/A27mMP8zYxb6cZO1HlKjKVpv8F
wvydYFb/CM6hJVfLca74nOVTrX1pyC7CfSCjKYr2mQXaDjK6BSSMfA3aCJuA
RExTTsjabYQhdY7WpHeaFh3kS34mfkOy2p10f5I7wtpxOcaxY4zbX5OPyBQJ
spCLGYcVlEpDxuyTR1G6E0xyGYteYxOzTemgZ9fBY3ZllvCyR22ilKZPY1xD
wPKZArZdYslQTXNOmnFljH8w46bECR5OMJv6SZU426SYyjXWiiMEHCFefHde
PvHPxLdGfNPrXHj1xGhyF/0S9GRQa1bvuiXSmMBiynUAKAPr1QhXfLCFS8Yb
McdT1FrTolMy0kzxPgHOnxyT2flmcRcu4TCcP4J/EONURE5iXt5qlFKU3+QZ
jiXJhA37C6ZsrNiNLT60ibBxx+wmMMMVN2HDnENsLZapVqRZ/HE42mOOnASx
12PWI39JbkfxqK8mPsMw3kUyRoSMa8L4m4RxRJArUqVhxEy4rSFhRZEY+eZm
buGK/6gc30lU81hop3WcrzBeYn0Y7shFuM9RINwVOvHBRyTQJR+VEYttphFp
O/4x1f5L2pV2w5z7VZOEmbPlrG8oYho7pnjuX4loXn3Wh6o43lbC8YZlGq6X
8JkW8JxIlc0Fdhbc+AYzRF7LLmFTxiXsEZeADSae6awh+TSp2GkVzKfizibV
p7PGRj0LPgXGO3MCZ9umOH+rGgMmwJxPDJ1ua326xXM05ej63xvC9a8JVDD2
lxiY/MGRNc7WDS98N8CeNvEBx0IfwF7VcvWJnktYc12l4nwvt/AYVVHd/J5L
Jr7gZGLv92DbUoetqjdTY0fKZobIsTUoVZYs17vHJasOlxRg3e55Vy8JS7Ae
9T66KX7VRK4zbKU8G4jNiZikF8W4PV8BjTOwTUc9L3uAbjNkgs1FBDlmNhWP
hImgitVfKN0bsJWb1CrmAorjyZO+5YE084X9tgTmYpTxod54gSgWONCKsUP+
RL55Uc5OhokkzgpdadsJ3O/3uyN2+PCpzG+bkZiXwUaUwsYOpGKSHUlkKpg/
MCBVI5JabNGvcdexQk392y1CX2StsD8d4zM+E6MF5lDCz2WnPKvEkfwsV0Nq
UhXJsz8agCFN144jbH77YaTYXglm7WWYNZ4XtPXYksRG0fyuW7m/yLM4M37a
ZsuDHyeJZ0KMfaH4uZOSYQbEsJ3n/Iod+0AvHyWIaAF+lnKU4aHFJfSwL9Wn
19aQXskZKztPQGPMqLinjqAFVnPsqjXDrbdRT+UPNJrRSy3opJwtcnQ4Cw5Y
TPwq0pTzrioXu16r6D0VyTSxx5qGHeVOi7Fj1ID7liPD71t6xzfE2yXrtgRI
BcCIXF/T96VHd+wqjMP8/T2dtKRgLsjochmjW+t10vchqTrtFWLN5OKywdfP
va2Ly+dG2JokMzdR+ARf6hCveorMnK8dlbvgEJGJxReS0UixsK5CC2NG7WRh
s0HGLmaFvQunWyWZZjKtYlten6Sb2kAqcdTLTdiGztvvwogCWtbDJf2YyJms
0UHDAKcHXNUojUwxszbHrGgaufSsZ4/XJ90KqyyxZlo7NQske17CxNYQMY6A
HdIV93hBM+P0Xd5RkbxD8jbjy2JhE0sMjfwYetqiOQBjU34rZUllqbTUoaJs
LXiEcKF5TPeJbZXziYKZbEnsqNhihkvZZruX6e61me7BdDLhVRPyuISWVLP9
r8Xvf9K609wmHICatZuEiJMk325a6xNiL9lSp1aOVzlMqmyJBhtr1iDYtTqt
+ZQ0TPNGlyYMmuLA5kz9xZTBDzTIXSsudxWbcazOUXey21/zt/tUzX/nLacT
/KQn0JPl3LUkmebytatO4WJnjDoyXOwaPGQzg6PdAnZEWWftCn9uFLqyYKxk
K1AVZ0SpPnU2yRfOm6pRlTLxqrTToMHcbLJwQUsoZmJmCFsGV5XukHVVdgXS
8AyVDt8LjaE1rq+xl17Mo3RT8vCH6OkRj9Q7/Fz9ONg6aEW+ZoWNhr1uzR8/
GjJEJeaKz98gCuic4h5wMSqrstUUzps2phLU4FqES0WspSfDpXXAm9sdRYuA
53LoWg5SZ9uYCe92RomgHITAYpKZDZtaRpIl2biER23/wRbSQgZVTZp6hr0W
faasZjJwD8LQGNA6gpoEHmrpmAyD2oA3+zqCFum/zn53CdtGUGTwRsNULve+
PMLcvZrnVZIKjudcTAyPDQfCkGJxjs/FC14hdqE6jNslz1ti1iagwCsB5O01
mSejNo/L0LCcOk1PeYV9yEJInKsbY3jOVS/Wqa9XORS6ETtrYGikc+avuUdQ
z6DiM+dq/NyNORwH+t6f8aKZlE3Kap4qq+O6yOdlu/XmVH1IL9KuTMyVx9jF
A1MXrIrrS1eKamC/iUwMOE+zeXIn4TpU0y1WR5z5s3ysk1egjYY/s5U539zv
JYl2DKIXaj/xSSa+bLaopBJ13BuSnAEfrPLJ+l6Fzct9T97lGaKjjcoX2R8s
tGPydeEIk6ZBg29APBDOgXKdx4x/3dfOBc++GvA7A3cKtx9mskbuv91kl/P4
Oa+wnsqb1NLztBuI+BOH3BPaU0XWOqoqgarTcIeo+vGArQNH1qNMJN+Za3nb
QM/RyWjc/9Y711mO1JNDsYNkuHyftfxUnt11rCWcy+LnN5bKAy6ltoL0LJ1y
5v4XgPpBLj3QTWWOX4ttyUxybKIY3fIWIcTf0ZWZ+xFVC7zho1kiMlMXFXAT
kz+aykgcoygZO55Lko2bhc4trCOcIxltfNv8lFeTdSrvh1N28qC+zHtQrgYQ
myzIDinUTcLhdr6//bYO/tbMHmp8Hz0PPU2HGYff8oOQylO/shlHxYwNuRZN
rt5+Ex4/gMz6qDEmqq2iRaOS4uxIzfoG33SXjEWPyUoQKqtJdMHuc520jL9L
KrNqkO/WZbbp2W62keKj9GqUtKOQ7N+WgPkedNF7+R7his/RwTbPx7RQ27Zm
Zlz3uRWGeP39tJdOvkbaMIWv3y5PJ7yu7WEP8VnDgqMjgu1b5ZqP8tmdwdHu
YNvax+N8dldwdHiwfb0o+Q2fPVz0hmddLdd8is8K9YX67bfp/ZHP7gmOhp/K
ukKu/Sc+e2RwNFzNfJlc+8989ijRG541Wa75HJ8Vfm9/aMcT5Jov8dk6OBp+
/lbLtafx2WODo+EMlF3RPJPPHhccDb1Ht1x7Fp89fsD77F+wdps23+CzJgZH
w/Uzthown8+eFBzNW51HZ7/NZ5vPsrujA6Z2bL/Bbimfc/FAMv6hd67gvZfK
Vh9vqYv+H1LTST0=\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Boxed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->600718728],

Cell["Draw the edges of the bounding box:", "ExampleText",
 CellID->780919887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154799522],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Boxed->True]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2315076,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFm3lwFuUdxxeSN4QrMYgFRBEolg52k3CIKeXu9JipgYKAcikhBHLfd/Je
G0EQVFARlEuOpLa19zXT/tE/OtPOtNPL2trWtrYW7WlbLVEQdtrn+T3HPue+
m4QZGXjJ5n3293w/u88+z/f3293SstbKirqy1qryspmfaC5rrKwqb5n58YZm
9KusUY7j7EL/aqc66Of/oZ/g32rf952siooKH/44t+EPZwX6jKFfzoStZehz
NNrKov+T3y5Bn3jHmBABfdIIJbRtrvHbxfTbcXgrm/eOfpgB3y+ksSfgrRj/
nsa4FdrMpzHyQ9oU0TaTjG1ugTYfon1NVo7EaGV7GrSeRyNOidR6Lo09Tfk2
S9meCq1vp7Fz0P/56OSMibTX+4WzE0N7Ofnn5nufWeA9v9j7yhLvG8u8b6/q
++7H+r73yb4f3O39aK33s3u8Fzd5L23xXt7uvVLmOdloFzVytrINtM5MSoNZ
s3BPUx9y04cK048Xpo8VpU8Ve2LH31yeoeNXd3mv70n/rSb9z/o0RBP6iyn9
vw/6nyGOQ7zHzFY32e2m0m4KCXkEhBznQhYOR8i/m1NvtaUGO5N4fDhOjlHH
dHocuI7Ze9xEvZtEanpMas5nUvMLpuYPO2Q1TYGaK8kE7ks9MjeBomn0yMC3
c1GzzW58h5tAshrcZBuTtR9kPVEUyHpuKLJeQ7KqDbKuegl/b9wZbRhHRN0U
QR0cr3nr3V6ksMxNVAoKPVnhaa7wLqrwO7LCnxKFmzMpTGCF1/bG/f29/qEe
g0q48uEzi159TiFqttbt/rTbg6RuAalVILXdTfYyqY9qUr8wFKl/5VJbkdQU
6vpyIvGuINV/zKT2RlA7yRfm12LUbI3bhQSvc3vuAcE7QXCjSfDTIxD8Dyb4
UgcTnGaCD/Yiwf7j3UiMOhsSzTdQzWPx1gLUrNTtFGVvlWXH3VSfmzoAsp/E
sj1R9ldDZf+WyC5nsuvS/2pKvanIflCS7R/tNCiHlcOZSMcGrFeLQHkHiO9e
6/asc3s3gPhyN1EN4jsyiv/IdREfx+IfJeK7/OMd/sl2VX8B6B9PjzyspyWg
vx0QutbAIEcIG93ebQyhSUZ4bLgIf0IIu0MRHmIIRxjCiXYkz4cFmoyasVQ7
PgfOEtDeapIfR/J3uYkaJj/hph4U5D9T5J3JKH+9XX6jID8uyH+YyX+SyvdP
t3ICMnpyKUFeKMEmN76dEiSb3WSnmzISXBgJQQsmeLsbT4tmgmOdhODa2WaV
QHRxMI6WAkmzDeZ+N16hwTwMMEcFmM8uigCzjcJcRDBVAkw7g0klrvYxmEd6
/MMM5hkM459t5mekIOCRfOf44Nxwos5SmJwI0b2MqBaIutxUUiEqjkr0KzvR
fxFRl0C0Tyfq8E+1+Wdbrl1oUK/1vIBN87owcy0rdRuAr83I9wDja5H5Dmt8
Xwzh20j5fs/4/sL4/iPwXcF8CYnvCYHvWcTXyE8arBzyKPQNnjsnGJVmTLSW
3weYu91EnYC5dySYDwSYf69Nv8EwBxXMAwLmU53+0wzzfKNh1YG5TvP/qiuP
BbyNpW4L8HbwNZXz7hB4uxnvwZHw7hR4G2TepMCLHYzAe3KovKrXzY7Ay41v
Hfjx68L7R4W3WeYF+8t4YTHmvGcQb9PgQI3q4SYYedVsA/ZaWupWlbpNOu86
mbee8aYY75HC9FOReV9QeCtk3rZQ3qOEt90/03rtXNPl/lp1pI438qrboylv
rcbbLVrbMo13H+ItpLwnir1ni73+aLy/sfAq6Y3oyCnv8YD3an99NF6Yv1aK
M3OpWwesfAXlljJg5SkSZz0UzrqasX4Ks/5EY/0zYq0krFK+i1iD7EMxlicI
a/O1/nr1qhxnZAWPv4Jva6BdinfeKeeCAJoeDuh9GihKpRVQJWuR7SdxP2h5
1a5HYNJ+C+d6OdkudettjmiDkN+ISfnwMbd6vxMw9fqFmuVoJs8HzGiUMGMt
Q9shiCSF4Clcm1AOiY74Qwvi65WGoog5kZCsHzZK5itRY5xI558GxQMqSUa5
kKNmACzBgN8KB7zfBNiaGtQzJeKUjshOEJzSEPjCPOAmxlctlA54PUvh+5yF
Tx2jFj5DJmhzgucb3xyoMq8eVkZuEAyMJM0ieS4vj/Ca3bGi9Mli72w0xl/a
GYV0MYncvIFRtoGXBmo0h5tjvxaXl7qVig9S7Px2OR/uFSpsVswVGTBfKcuA
qSYtovsDN/ROf62ZUl1XJlLKGqP7EZMykjPzooWRcgBR3okpvxadkpVheelC
SjZtHhc8wbv9dZgnm1XorHR1Njri3cWUk5dkrgPdLqCDep5CJ2UsFoeHXADc
A0DNjTlJBlrR7aiZGaftFGhx3ZLTzh8GLS6pK2WoDLSy58HVG2N2YiVVFkkD
6e6AFBdHeLWQ1+c56Zcik74qkpKKlZ5wS6Sq6Rk7Esou7tRZZhJknmI9y0q5
NCrla3ukqlZQViD5p+rXA0r/elFSjy7mm6SeYKQ8hygXRKL8dSilmIWpBlZy
di1Dpmyw2Tox66qTi0PvGSUyd2zdNFOq8xLUxlbo3kf05zzfIrmlUuKDEnhA
+fkRUKoVEytl4A7eGqjW3EE4qeqA9EykUsiieRWMF/ujkm4YAinLL3WzHpAO
Ih+kntNsIymM3JVQH7HavY1ydimWSKywH7bC/hzB3hsKqyTTYoX9sFYLg1rJ
0FjV2ojMGqQnYslAYT3NbtTbWHGGss7EymrVbyisNhMvOj9cJ6kbGqvqjYyp
SpVcNRgy6xqJ9WXCWk5ZaUHXmFSbWQOHNBzWVqPLJSkLT8tEVl7WzMx6t8y6
BbPyW0TG4lc01mYrq1r1zKOsVm8k5i3Vcoq9z8a6OMJ5FVgvRmdFvl70gjaH
NEzW9UL2oqTbI2XdbmBlhaEg6ZZzmB6F1eyTwlkbNNZuPZepEdJuUv46WMhK
8+wO83VhDQoMar6me0KTWwphLTa6JeIJxUyGZ6UjZH3RygoFv9YUzk+cfHxf
2urySUGM11OqtTU2y87rwgLLfZPKu9nCy8tiCu/zi70vD4sXhDkFYdmbyVFc
MjgKMy3MxnfIlZXAPinAu4XEnNeQDMALbcB9CPjHJmDCOVmslSHgy3HMTNOb
A2Fm8W3dVRBe4x3jD0KNxWoXif3fIfPGZV5ynymc9/saL1BOucir9EI9ieCi
84u1ZvDGTVf66yzn18g7x+gsNN7EbrkUofOeicCLK0DOzcFQFmv1Auw7CBYS
AaxVhxVclGG1DWGdFe6iNmipHUrT40I9VGF9jrF+XWAlo3UGP7MvbcFPn+Db
/zvtvL0mXtU1WpxUCO+MjLxbLbz7M/EC5Sx9IFNc7T4FrTRBZYLjouwHKz5o
N1MXGoYylqfrDkPPfnTePjsvOZtzQq5cDLzNAsxKMQSYZ0BYtQ7MHNU4hWy0
nXdKuHskGRBPbXlBRiyaIl549MfJIqcWP5A6Bn/cGoKH66RCdYLiCYYR6+R4
solyhsA32eSi1Kxnp1yk4Hzw9CoCyT33gj8WE01WiipYtuZzsQLV+7VYzwoM
RvJL8lROQXTFJP9mj3o7+KFvpBT9daagD/wculOAVfYkVTcOazvuVXRtvC6i
Xi8WpXnMxaj1SjHzQFkW1TcLaYLn0vMCKQcUKVIhanCgJrMSeFthglazkMQg
h0E1zGUaxot+DoeSF/zL/bURjgL0nQs1BEPf+JpwUX/whPZY7qXwvrwnuLER
taeYPBe3a2e9mPU2hixzeOdTwTKnXTejzP1kkX5wcPDBaLuTdOLciT/wxU0W
UbwXW1Ss0eUrEjRnEwYH/pQw1dksnGkO06PhFjDv4LIdn8ZwoKVYJR7+6Fvz
jKhHG+OLb9+QcDjWchwri8YyzD16pGwaKZdGaqDHboUQyZQv0EjBU5Q0DjwP
IZzllUIcGIDGODjMRKqgkipYFWlPbQ4V+l5tiDAK/Yz3lEcTPjHWvUkTw95q
/qCyr2ZnlnxfQe4iyTHw8R9tOG4f1fbN0fZV7wznDiOG+aksJUaMx6DHIqbF
YU85q/uLR9FnbkaZPeRI6pjNzhBRramJEYNn32NKlFVKFPg+Jo5mzEliTDT0
YBzj4jGUni8mcfIyxFmuxNGfUyZx8v3gTShx/6XK/uKRDGgKNFI+Cwn7TqB9
kH3Y+yaq4hJlrzzp2Gvv1KGGdyl7sHcryB43WfpZoOyFzyo+MKRKo72Nhxqy
1YXNu+Q+/FTDGcCt5tGVFp85fGjIE5rsvSqYI9G3c2irHBqTPE0+XYmJW+OL
7lbaOpvGJG9D3eIHb+7gy2oSahWjrXDMm6HVDCWmeqVj3TcISsh7k7f5wRuE
YusbqYLZ0GqW8q16RebTmHOh9WxDz+qch1vfAa3Z24imZ7OxgiJodbsyLhn7
Ivj2A+gzB22VkJE56v9WpFKS\
\>"]]
}, Closed]],

Cell["Do not draw the edges of the bounding box:", "ExampleText",
 CellID->18544491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->620843839],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->615522085,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxRatios",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->184393596],

Cell["Specify the ratios between the bounding box edges:", "ExampleText",
 CellID->696824140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667120005],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxRatios->{1, 2, 3}]], "Output",
 ImageSize->{121, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206400518,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275843579],

Cell["Use the actual coordinate values for the ratios:", "ExampleText",
 CellID->234650043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437859817],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}, {2, 2, 1}],
  Axes->True,
  BoxRatios->Automatic]], "Output",
 ImageSize->{184, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166044516,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->185360361],

Cell["Use dashed lines for the bounding box:", "ExampleText",
 CellID->54309145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"BoxStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "Dashed", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46897230],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  BoxStyle->Directive[
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70822202,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DisplayFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->211603405],

Cell["\<\
Display a 3D graphic in a popup window when a button is clicked:\
\>", "ExampleText",
 CellID->617198859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Sphere", "[", "]"}], "]"}], ",", 
   RowBox[{"DisplayFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"PopupWindow", "[", 
       RowBox[{
        RowBox[{"Button", "[", "\"\<Click here\>\"", "]"}], ",", "#"}], "]"}],
       "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41011826],

Cell[BoxData[
 ButtonBox[
  ButtonBox["\<\"Click here\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Click here",
   ButtonFrame->"DialogBox",
   ButtonFunction:>{},
   Evaluator->None,
   Method->"Preemptive"],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook[
     Graphics3D[
      Sphere[{0, 0, 0}], {DisplayFunction -> (PopupWindow[
         Button["Click here"], #]& )}]]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{60, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167793451]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438492775],

Cell["Display a 3D graphic in a new notebook:", "ExampleText",
 CellID->1107675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"DisplayFunction", "\[Rule]", "CreateDocument"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846083194],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["qh8_shm", 1, 1]], 88]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"Untitled-14\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["qh8_shm", 1, 1]], 88],
  Editable->False]], "Output",
 ImageSize->{208, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734710778]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Epilog",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->50229676],

Cell["Place text at the right bottom corner of the 3D graphic:", "ExampleText",
 CellID->278338907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Framed", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Cylinder\>\"", ",", "20"}], "]"}], ",", 
        RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185372961],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Epilog->InsetBox[
    BoxData[
     FormBox[
      FrameBox[
       StyleBox["\"Cylinder\"", 20, StripOnInput -> False], Background -> 
       RGBColor[1, 1, 0.85], StripOnInput -> False], TraditionalForm]], {
    Right, Bottom}, {Right, Bottom}]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1970375292,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FaceGrids",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->107861140],

Cell["Put grids on every face of a 3D graphic:", "ExampleText",
 CellID->490860158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87871385],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->All]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->822713056,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314815608],

Cell[TextData[{
 "Put grids on both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " faces:"
}], "ExampleText",
 CellID->6729609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195558251],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->{{0, 0, 1}, {0, 0, -1}}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->660234297,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10535504],

Cell[TextData[{
 "Put face grids on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->18848067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355539880],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->{{0, -1, 0}}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->127413357,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9238429],

Cell[TextData[{
 "On the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane, put grid lines on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", 
     FractionBox["1", "3"]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    FractionBox["1", "3"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->185725235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "3"}], ",", 
           RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18972493],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->NCache[{{{0, -1, 0}, {{0}, {
        Rational[-1, 3], 
        Rational[1, 3]}}}}, {{{0, -1, 
      0}, {{0}, {-0.3333333333333333, 0.3333333333333333}}}}]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->248971400,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQuUVdV5xw/zZAaG1wDylFGQgHpmBvGFgWh0KYlmQETlqYI4KgwwAwwM
wzzvxRDjIyZGCWqiUZmbNIlp06aPrHatrtXVrqbvNk1NatI0NU1Ta02DCoJ4
Vrv3tx9n729/+9x9Z4auFZbOzJ177nf2/3f22ef7/nufMy1bOx9s3bW1c/u2
rQ0r927teHD7tn0NN7XvZb8qHxNF0VH2/yszIvbz/7Kf4P+jSZKwN4yvm9nX
cvZWGX/Ff0jgX1TGfmyGLe5C75TzLxXp6yhq+rXYjivlqqrk92aHxUr5TrkR
MeJs2P83ws83ObGr0d6noteXBH5uitw37Ly1tbWUz04yPyubXcZi+D5fKbef
JI89vC6yvbm/Ovn5sfB70Vj2NbrYolgtv4+Te6kht94o3x0PexXvig0Ww/tL
iWOSyP45m9ANcSp1HLmvRbDBZY6yCuc358n2TB5hnGmybVMN1dBu9Pqi4Ij1
smXTRi2iOv743K9HEcvR6wXBe5hAHKEZKFoFej0/MY+7OlvHy7bODfq06oNY
2Wy0dSV6fSF8uiHxjwOzZTsuQJ+sQq/h/WieQwSfu9NkPH6WjGff64LizmJf
eVghwAjvxK8njgBnVs1/N/5b1+S/vSL/B9fm//D6w3984+E/WXn4z24+/N1P
5P9qdf5vb8v/w+3576/LV+moaSvw64ZAtZPV60KhoFoCOmYebco925x/vjn/
0pJ84bL81y7Pv3JVPqR5P9iQf21z/sd35/91a/71bfl/vz8XqTEti6OvxWps
nCyPCzSRtVZsA79pOBLnHo1zTzTmPt+U+0JT7rnm/AvN+ZdFu68ood3/bLf7
Fw/m3mjLvbkrV4GuA2NR2+dltN2krc8+q5dwMfDbxQfjwb54MB8Phgj6XRD0
R8MS9MuOwV/tHXx7/+C7XYNsx3wkrUWazrfOPHztAAGx6Dft8UBnPNCt2v4p
T9u/Am3/5qi2/dShAd52fO1L2z8h8WdTcxJ7RIuaWuN+pqdD6ekvSc91oXr+
zdbzlqPnzED/+7n+SHE3Vc0FVRORGjfDmmkcJ9C2dFPctyXuv18p3I8UNo6+
wv8gFXaDwn6u8OzhvuRIH+jEo4PQWS1Ho4qieqdLvcCrif2wJu69M+5jorfa
og+B6MNFRV89AtE7LNFRGT/BxzJtpw3VycO9yaO9hPI5gUd4apLmfHCEL10T
99wGqjcbqvc4qh9rzH22MfdUU+5YU+6Lzfkvl6r6zizV5VxrrT7OqeJPguJH
epPHe8r0EU1Vzw5UPUUeZzjbL2U/rIoP3Rr3COnrlHTWiJ3xgJY+ANIfHg3p
ryLprULxpLfaB/+HHe1O3sVPWtL7TenJEz3Jk4d0JlO6/olSP86+geclwKN7
tYPkXgPJAYXkoUwkXwckvx2IZJNEIvr6VNYd/lOcBBrLAQPLIMfygYMleaqb
IDNLj+PmWK1eQ3WxmP3QEh80pPcK6Xcp6buU9J4RSm/B0iM4/ueJvoB0n/Dp
/lQf1/0Y6P4c150cPRgR2meC9vlyFASti0BrV0vcjeSuB7nblNy9AXKPm3I/
XEQuHNnZ4kj/ZAvv/D+jBL8TLDh5pivSV2as+QJ5fOGMWAiaD7BDjGSvBdl3
27K7QPbgyGTDUT3f7N2p5ge45v/aCZr32Jr7+s8wzXlK8+dB87Gu5LkDhGqo
wSCDVD5AdBGo3g8HWwg/VJLwxxtzn2vMPd2Ue8YUvtQrXJy7F/ADvgaf2kXE
H6TEfxrEfwaLT76036N+jhzb+BgfXdgSd8Ixp9VvAPX3gfrdSn2vUv9pS33+
S371cJwXpF0dlP9jEeU5R/mAVP4QpfxpUP4sKHeP/HmJqh+5dqj0G+DIe+Xf
DvLvMeTvM+R/spj837xaqF5EnOnh8vcFyP+sKb+LyU9e6CQITNcEKmSdF80D
AvuyIWx0IBwECLlMCF9dKq9Sl2QNeSSIey0Q/02CYKm7AHEEQDzaa4DoTo4d
5CC+yEF88OJeDwlVY1E1i1lR8soHzpU5LfGebFp3AK0tcZ+ocNolrcEMWtBH
Gr9+Je8v4aR+BKR+CqR+7iGVFjkkKZYIMFJfSEkljJTba8B1E9fEzIwJeWAs
AIyus6GHCWz7HWw9ClsfYOvX2DoBWx+FTfSqJS+qXpaF7hMS3d9noNsO6Hbn
finQ7bfR5Wx0j9vonmHoDiTPM3T7Pni5w8OuUp5xOJd0GZYnpv+WxgFvbEYg
yU2ZJB+JRSZ9ueh954LiryTFQYLiwzbFpyiKbh+cGtgHScJGHIgwrSXeTXI0
83lU05rWi8hEr/pMY+7JxtxRdRoPB+R6AHmXAnkfAdK1K8yyFlJ6G+RzAPLL
DOSeD4Z2OwTqh0kS15HgYk2FHtneEu9FMFc5MDfbBgGDCWfxNTnuwfFOeQ5w
5hnOX2icHYE4e2icL3Gco0UTexEwQzTZoNmZQXOdQVP0xRXdqZ9psXzWZvmN
Yiz/hrFcOzKWqNo0ihCRk2qWVB0GV1m4Lps1KHalsKMNHsVEoNdh08N1jKYn
uF2L/LkjcY6kN+TQ+04xej8Eev8C9F7X9NoUPeRD+iwMTe+YTe94u5/eTESL
nMEY3xLvtGl1ubSA0fX3OjbPuYJ1j4J1P4f1hguLMDa8tR9kwQzWXgELj1+Q
/coZuZRVDdoKelptS7zLYIUTPxjHbtTGQAYu4W4PA9dfjhYuXSqjavFZgYvn
ygzX24Udzgg1SfNSsxPObGI1cMIJsjjTVprl9F2UUebOAQhKz482pXRmA5mI
rqGAK8suk9K7hbYMSmavwrREpmzSAkY3+6rvbba1ZjnrJiyYRXxxSRisVaGw
3qJgEe6LVYdaRQXL6U4N7cSj9kSrR+HZXxjb1ohMrQD/sqv0ux1LLgTTb5SK
aaPExGfL7oPZJQOT68AWKdet2ounvqeHdjrj9QSyTwGvdNUI+wd9aLWnOijO
asCZrCmJ1Z/brP4JWL2GWOl5Kte17XNYuXWqXSacHdpVCqs7xVaiL7EfINMq
Ukwh7wO5ve7clp7HP0e4hP/JWkI4QRm4VDGAZ27rSFrjZV+CM3A5md47NSe2
iLRJOmBMho0U0x0BmMAvhCtyvdcncotPO8l3ZrgFp5rEvzaGj+j8V7UWOxGh
Jd5OZvWi4EQWiGs29tjTajTEy0uHuFlBJOYVpxVx2jKqTp6c7nbyKKiQBFd3
lUyl/o0kyinyYwjvXs2itMRtTmqPCyM9D73Fg/ChEITLho8QyM2g7PoB2gHR
laZbHR1vx6tEIIcAX6RC+SMBJKtlf4Rol9t5rMbY7VbrmxwPk5zs0TP6JMbf
+wjDeDgQI9CbY01zkZ6viTGjTFKZ/4nCdtwXx5XUFytlX4QxYIm/EiAJ9iOC
vcUIFkonKPLreeYKAXL+gPY8SIR2NfAOqwZwb6z1MFSrYJx1JKyNkO81kjWC
S3AdRfAgRfApY1WJl+ANBEHgdqHogD++J+8C9LrpyOhwq08LYMfJQlsp/Fz/
MoLVX7y5UOFfaviX3okI5BOZVrA5e1eU4e94GMI19iLdC38QgtF01l3Hg6y3
jBLiPZYb40qqxroyq7VzZQa1RLl0i32ubza1DpuanorQU90h1MQ5+iF95n6P
ZNZqMLNmI7BL5K9RcT1xhuXI4Kaxj4s+Nz0xVmcvDGGy1s8ETc8gJi9TTIDE
xe5gFohETC1o4+y0D4meCNQlVlo2QB7MO5G50rRG03HWg8/PzIEPuc7GA/bq
RncSSy+SQJREP4l9I5bEtE5hMhZHpZOlPkymB4QrUbpcgNGIc8Le2ViSFYxN
F7TED5aKSxhB2ootiktQWvJb/sFpGLiyLDMTF1ldQdmQyIIc16RjrfMOetT5
LfGOEEq6XEemoqZ0xJ4ZZZTE3F7hMuhRV+WHDelnCFKHB5K5CsUsQenKoJ19
EI/hGb1pjuNSe+t009ZAnPS0iOAEV64r9To0geoVgWr5uUJFVOtmGUpVAONJ
TtOoEWqmJ7MvwmkXZVKLs2vZ0/ZqvVGjRE0hEXYZWayblFSCz71qTKpak9JX
uuk+QqtwFY4dH+25ApflYsoDrfcaLUA/Hx6gJwxAaQXUKQC9W2jz83F6Ur3K
z7MqHNetYJzkjBqaG9ILXUxQXxt1UHttUH02KLPi9tU53KJuy+hJDqlJ/izc
qmQ0KTGbhrxpcxLNXD81QlA/MUDheUfTyDdtRBeUWc8YifjpoZ3FOUXqWlcX
yEn0nxtbDQsROa0+UF8JBvV3LqgtFqg3EKgDBijTBkOVcwrKyr7fZ9k3TUpV
KtS9nRXmuFWbnaEDs48hu4H0Xx91VlgMH55aml8cHukhuvDMck/l6SyjotnB
PFKRuy8xV+iJY32WP2QEt5gVIMK5ryScV2Th/K6N8/sI570WzjcVTtJPtFyc
x2ycsuyx8/nh8yTvk60ynG2JFPpjS1EfguSJpsYxz2uGw/OniKeapvPypN0I
OuEfbZ7lYHNznmIsvDXc2DHtxQygx8OB3uoHel8WUMol89TlTnFA3gEczFON
mcDudk8iTJSf93scxnTa2A/xW8OHiOfY/RApc8MsQznEtGw4UdiO+2VpHPHz
FYDnumIVRhbYTse6teaYRxUsXrzQHgAW1fdm6SrrMeWD02TV1VytV8NXn7rE
mBUsSrIn21AyDdz/b5J7RkaS1Wwwo3Cy4GbagiR+hgh4l0x6lbze7DZqE06u
jC8wWr3KU+Vmk0MzgXqdpHkzblZGxMjdlkkOzUujeYR+hxyyT6xqV9Yo3AOn
ydUjcjWyz4FrUJudg5cxbtEtpI9impglkft2OLlNAeQMG5w2ntwyWFV3omg5
Q+TiNLkqSW7ciMmZTp076Tcq5H5kkCPWQpA2sOtD4brYqmLOEpkOTa5ckpsg
xznfAhvkJEjHhfTuhBOcRU7caVaM3F+HkLNnnt/2kTsSSo7niDinqdTk4F5y
+YwN8Q9WD67PdNCzTBgSHZrjkwu6RhVdeic+zPRlmZ8uOlQ6G+WKnxzvY9D3
bgjz0dMpeWTsnSNW6SML7EXgelZUsDInHuCpVVE9huUaMuksn73ixk/LqTOu
M1z1IpOhaEWNaYeSc3+I2lfVbaDh1F7V1O7B1MRcMqMGc3fTTnYPvNcDl9LB
YuaCW70db/cQm4KIQUayPDD7JYmZjt85J7Y1JcbnoqKZpofMcJ3u62e/xrjI
YteuzSifPSXGxzJw/5aFkxJVLHKtzLXgaApQr5MZFVL8GQrQj+aSEzeKFrcG
2FYELbeSNWqFd4kMN6N/XWm77ueK2tAIqAGrhtfR0g7HfTehEX6KW7kaZcGp
IWemIoPZUjszC1rS4WN2xMdsSXFmf+owE/1qfrpQ3F3IYBvMGhqrCLh21zMh
ailZEfAV43gkq/BTq0T5bMQqqK5oka/8RNiEzWRieyQY2+8jbB/n2GCMWige
gPBD49Qk1n7YyE4ZyFg/49pdh8SZEROlwPtDu2hiynn3rfDVo1yVWxVAJbpg
laeGJ81PEuKxYIjQyy62TlYfxwcIjrIYtTjykopDcct4XFLJ9Jbm6N7/WO38
Bp7GsNioEYjqyqzoAzimU44mx5c8HMVZGuuu+BfDAnnCAPmeDZJ1SA7GncMO
qhPCScLKiXGuF49gRlCrztK1qmt+aks+nCYwbP7OR/F5TcJ8zYDprplANt17
vX6YrNB3i66MyqF0lm0hLKeHsDycyRLGv6XpuY1A3uKAXO8BCXO8b+4mjGQO
0lnPxNn4qtesHNlHUq37Vc8vgFGyIbPOwCYAadl1UTPAGiP0vkp0dkd1fMhe
+Kp9q4hJyme5M1KkQ8LlF6m/KNc9i5U150tdp+eG5dHSBTAXibUp0+4gNWMJ
DRzL77d76XsJ/x6dn+GVYyJG+c51ZtZX7xR20ETUldRZrWvqnxWoXy+wcE1L
rZ/3S1jtyX5gqtl/0Vz2BZ41Ogt52kIxrsFVRcml4BIpTfpPFtrIuxjTZ7+a
Cqe7bnaGd+Eq5DkJ29GHlJLpWa2HqznR+jT75tYy3Xr1jG0YG+vDWt2rW62N
PQjcxFoLT5Kt9zWSXSl5A3AjZbbLXVx/K/HThfEaneJ1Ow97hWrjJKLkexJa
ZzdNZJVn3awyo2UVZsvKeCJeTbYMwn2YtQjcwgluhsv3ZmW4nsyMbgv0xCrl
OKaJGFQF5aI5cOqwL9cpLuPMbIbvIV0e5Mtm7J4EBKpJ7w4+BE+dV5pr9PWJ
h7Mv9IF9YaokvlPvT4wHQh/fycf5oFDDP+HuSVwJJ6A9wajlPEdSKdvVqv6l
yriaW5SqanYJ4cGQw4L10HvhlR1kDlXo8so2Wc2V8Edcs+GYx1HRuSPhj66f
ic/eLJd9whp/2ftreGT+SGw25nFLBMa8U+6YR7d5vIwOMweV5ijCcazlseHe
qxf28dh0XUtHrpGRa6zzij/J6g4elQ+OIuQZ9wylI1bJiOL6JSLyVq7j8cpF
vLNE7xPR5GVO/qOeLcYJq7v4+HGcKPfTLi5Q0XpjP/wtvJ8xsAMc2c00zC0i
eRWcIve1Xe5rg9oXO514lxrxvngQdY7zFS1yPxvVfhLxPDWcG4Tux8owjSu6
jn+isGMk8a3Vd0b8Taj9eBV7aHy1RmAKFd96ehq+Z2xMCkD2LRVLPZl4MhXT
uqORtxzfDyniqtXSE1CMzYbuJHH/5gJ+qoOIlvVkPVNBXYl74znjGPaS70Xs
qfizl9TaoHFF9oWfplPl7Ku057iZW9Rm9Cb4MNp35TB0qnvQa4rsCz+zpGIY
+3LXElUV2SvuJ+XD2Gt1Yjx73NjXBrQvfP9+mbMv/ISpWrTvyhHvocHYgxlp
HYqEz3IzUvp0XtyeO1EU+m+/iBjzE3RProxxB4qBniii27DA8/m16PMTDSXp
3tVfqqE8VXMkKEfR16Dok8jos8g+gvdThmKvklkYPNld6+SvSrm3vkz2xhbU
0mnWEcxuoTriVotRaz8mW8vjVmTEVR6MuQqNf1+J2jdZxqnMiOM+P8xuH497
g2wXP+6VKv/Sx1tV9+rapK6r18pP1clWiCe2NBtb8V0tk7XGOLmVeLLZkiT9
Wwv8+1K5VY1sgXiq60KixyVJmnk5mR57GctIY+X+xFPiL3LYZK80j1QE9n0B
i1gpOfCI84IjKlLm363hCnnqPYNFVX+VhiueHxxV9Qqct/CjOUMy5O1cFBxR
jcY4n5gnI10aHElfsawel0acJdU2W8fXVpQeAXylmS7bcwW8vzwxx+V0K1VT
LYOtPpKYY166VZ1syQrY6rLEP7aVJ2YGlEZQnK9PVI8OGB0qdOxWcX8pj3BT
YAQ1Dlj5Bfvx5sDPq7uAV3u2V+POxoz3zXgbLHZqnBC/XZH488bV+shkZwmr
fi22W5HYvVioc/9KYTTm/wBOWAAn\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FaceGridsStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->425670242],

Cell["Specify overall style of face grids:", "ExampleText",
 CellID->117945834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14902408],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->All,
  FaceGridsStyle->Directive[
    RGBColor[1, 0.5, 0], 
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->618920835,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FormatType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->304651547],

Cell[TextData[{
 "By default, expressions are displayed using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " in graphics:"
}], "ExampleText",
 CellID->130415530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289335594],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], Text3DBox[
    FormBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LongEqual]", "1"}], TraditionalForm], {
    0, 0, 0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->960351550,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89343214],

Cell[TextData[{
 "Display expressions using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->260195582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141409998],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], Text3DBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[Equal]", "1"}], {0, 0, 0}]},
  FormatType->StandardForm]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1560922804,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->54834949],

Cell["Have 30-point margins on all sides:", "ExampleText",
 CellID->428658683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "30"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96766759],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[SphereBox[{0, 0, 0}],
   ImageMargins->30,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{174, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->234255499]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->553430479],

Cell["Leave different margins on each side:", "ExampleText",
 CellID->490450314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"50", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->619794205],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[SphereBox[{0, 0, 0}],
   ImageMargins->{{50, 50}, {10, 10}},
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{214, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->311135785]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImagePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->173992851],

Cell[TextData[{
 "Thick lines and labels outside of the bounding box can be clipped without \
",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26905627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\"\<z-axis\>\""}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67221593],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   AxesLabel->{
     FormBox["x", TraditionalForm], 
     FormBox["y", TraditionalForm], 
     FormBox["\"z-axis\"", TraditionalForm]},
   ImagePadding->None,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->735163521]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25196821],

Cell["Leave enough padding for labels: ", "ExampleText",
 CellID->254549396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\"\<z-axis\>\""}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352847106],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   AxesLabel->{
     FormBox["x", TraditionalForm], 
     FormBox["y", TraditionalForm], 
     FormBox["\"z-axis\"", TraditionalForm]},
   ImagePadding->All,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->258166759]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21667574],

Cell["Specify the same padding for all sides in printers' points:", \
"ExampleText",
 CellID->117888487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46056034],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   ImagePadding->30,
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmllvFEcQx4fpOez17noNtrDBx/rAODa+DQFsDidKojwgIJEQrxZaCR4i
IodXlG/BYyT4SPk+o6Srj9nq6urZWduQYNmzc3T/6l/V1T3dvX5y8u5177eT
d29enXR/Oj35/fWbV390f3x7Km+JS1EUfZB/f01H8vwfeab+PhRFIR988eNT
eRRSQAxXcFKonyiWpw9UiWfkiYBD0r+OoqOvohx4Cl5l5vMBisJLeUyK9+/v
q6sX8pjLq3vq6ld5zOSVstHr9eA0loe76um+oQmkIoJ4yr9JeZ7KkiAmljWF
PP9WPd/zNObEi7axCpyEsV6X00Qc7YWGyGMEeu7U5DSML3BrBDiJ5mhUXEFK
TYQaSAmQ4rebfyYeCTTdriBhTTkixjZGmhQllp6WdOT1gdN2uflMDE+YmOc1
GI+RBnVbS1B6Rm19UdbXOhPM21echyi+8Dkm66YD66oYRYcVGtpDcO6RFuow
dYVXd1fVvcb0g8KMI5cNNzHyrlhujjnFx1MUXU2d8XIg8e6MI9UCZYE0Ek1a
S47iWJpSRVF/2qltr0Wy5GrQhh/n7dpWGsTKNdaKYDypb2OE2JgN2vA92apt
JUVWgD7PWklYK5tObtmRm/bTRZaYMrHRvFWS58vB+r6iW4qwgnorKFhlCRmj
oF9fIAVrbP2cqb+h6i9DJJD9jcBIk7E+rCvGdEWPVSE2HN2rtgIWOI2af7VG
btBRe7vCiu/HNxduZ4R4A6dr57Lit+ooE7HPYcOP180qKxm+o9tdjYssv8H4
cNPJKttXqd4wz9e7qohLJtcHU8ZYyg2HUr4jJQHeEFssqcn4d2NINU1WzYqi
LJr+P5jSYjJyeUhGm/Gmz+CiwmdVm/VoySFhNbssZZxRcxaGr2RxSEqHUbJ4
hriEOV2mjfYCYw8Xlz6FerT/2SkxuV9NCUQlKZWUOqaY945dMambhgqPKsjE
x66iTHpjW17esW8zKP0/54pyCFZlD85NtWsw2nIXQy7v6Jkv6TN7QRs0w7pO
fthVmV7+WslAyz3ahJdrmrXAZCuM+GPnIsBsq830Gi5uC4oyT8YBiMuaoYCM
NNBz+7W50WjFEEAG7cVQjBv3XSL2aknSxg1thKHRN1E1bQHRmkysWkz7h2mz
KFYdhtYcijaD4tZSzz79bUedNEB3c0Oz55jRfQr5DexUorPCj+YYE835ksq1
9gQhjwbI3NzMJWO9HRRZaKc2Q42HprZIhC8HqNxcOExtEOqUpOYMlc7iq6kZ
ietMIK45k2NhqkBxBepcBdXNLc2ctcz+O4Z4vxQgZoOISGUT8VYDbcStYueC
xFFEXA8QuZV5mJgh4mbA5yRI7BTh/e2YWLPvW9sX9gLWuF0XbW2CWFFznNRZ
WYHtwuxWGa/uBOzETMadxQ7YuB9oi/PaoOMfvDkeVthyM7PCEln1+iMtXH8X
iFwk+ruJA1rHsSOMHWEy4XuGT/as5e9smWl45Qszo8TtwQGiv6eqiVU7NGUO
BaLgr440s84eg92ZiqvY6Lo+ufwmA5GOrYUUq7UtV59tc8S23eML4gq2HUu6
9z3IMNHQZNuOj0ise2Yv/LqTDTa/clQ7RrXtN0261joppaIvS8rf6Mj3oax3
i3itj4fmjeva2LRlScveNqUTMz/VkdkiXu+gUnnZV3eI7nVTChqzUdh32i5h
rSAWzPH1vsI+YS2gUsDSO1cbTG+z61KBbEwTJRtlnMMruXIENAquEJ3bAxlF
0R8pcB7a+ZpVc1CHBA9RT8mJmrsBhl1FMiMbkAjlqIKClVia3cu2nhw7rWJX
g5D9qc21nvpR362CxR9UDfgmDeZzP6urR/IItCfq6tiMEb+oK/jeLDQ3eK5K
HJEn/hvj2VdR7rBwxw7t3X/1PwfRpX8By76PLg==\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1048655362]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->916031387],

Cell["Specify different padding on different sides:", "ExampleText",
 CellID->140939525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"40", ",", "40"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120384357],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   ImagePadding->{{40, 40}, {10, 10}},
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVWE1vFDkQNe3uaWYyQMSiKCJ8hLAkISQkEAgECF8HkNACJ+5EaCQ4IFZZ
rtH+C+7wk/b/tBaXy9VTXS4PHkBIRDPdHsfvVdVzudrt5/sf347e739892Z/
8enB/t9v3735Z/HJhwPXZY8YYz657+t549r/u5b//tU0jXWNwt0NNBr/ZwrX
fAgN81z8x8KlHP825sFvMQ4ihah64Y7RffLXV6BCc3h43//aCSMsYzagkfv+
4do9N3LP992MbNXCm+PuUrrxgDV2NBq5tvuYe5n4mYC3Hg9IYxyLb97N5Ogz
Hyq4O4JiAr4K8QOuCrgaTAf/wT7g70zAc/s9FgP4XXzY+LdM8pH6dbiXzHu4
l4QuWzVDPLse/ziML31WHx7WNL5qxzObtz1mSZnxJqyCU8J+P4PvQqRJGfXM
MnWBb0aoAs1C/L6VzU55R5qfcOxWYy95FDvZ/EOmCvK6hrPhPqa1VXPu5vMB
0ynfEs9CWgFwPUVWOhEUzoyXs+28mW2pFprNTWWBcojqSyXmd15lsxHbDc+2
KbJ4IY22LdqP3Pb4DZG1Z1V8GVlH9HqD9ZDQ55XcrCLs9Vbp1FrynZR9IbKl
FLeI65pnX9Tnscd7MEcA86fC3Yv8/pnMcsVuTeKuJHeb42EladrUkf8TbdSx
/3C9pDAfjZg3fyazmM+rnWyhVVNQLUERjKZzP/ITua4ARwZ+EOE3WrzvR7j7
aLEMlFjWp8DPRNYRvRa8BxVW1NWqWb7SwfLIl1WO2Pq0DEPvxTie78J3PFhr
GUg95NBVyMFj/3T4yyICaK4o85fCn1PqHu0aed2zYX5zec+qzymsHYjEdbeq
cB4Tc/WLGW1bGHyupvnGOZ3ioz2pb/AkSXvZ0fLyBF5Wh5m3sHbrTF6ae9qz
8n3KRcczyMhCZFpV1tE5d5lxbSAo1TXcxYIHZwLGBozc98U1MG1/nnEd1SsK
Yx/zdFfjXNABwMOIZZDJcpL5AmzFl//8LqvLFj8hVsd8tk0fMyvYeo5NUyt+
MiLfiqLWUHAOEpzxczzN2WecfXc/rkY9DWPFcgoYT6qM8V5pzNit1VZEPZfm
YzowNrZihozndEK9KoupzzQ7n2AqRQVCpmXlaVAyvZbU+OL9tPfILDTpUxZt
T0zRL6tW4ncGtHJGsMcnIfjGZ/wRAv6BlTXVSvyeM5UVphvUjKsJ9Y3tvhdO
sNHdLYN6wg5M4rZiR7735seBOdCevThu9zGaDbnvz7UBPZZmpdV+m2YkZcFh
l9vMorfNZIZV7UoN66LlV88wkDnnjVnOwHacSSM8m8nntIriW6T4D/AWpDTz
97qYyekVoPmjlbsVFCim9q9qxk9vqmEQ+6aSC8gqTxxq4ct6QNqOLzfEqJUw
inYXmLk7bBSfiUU2GnZHWC1viSzG60IYW4Wx+J6zy+KE+xxjhEqBb7PXmvRu
uogszYZ5rAIHnqFsRRrzXSmvtwPhw+438U1Da1LOlxVcezlc4bFlDZ63UByP
EljaDdPZqOfBgm6KgH0yAcvtwm94cj/r6E47WcgtOO9+4f+Lp+UQUarWvPQj
7kexSS9e/Bbj9pruCsPozJGvFbHYeg==\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->352378205]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->66471262],

Cell["Use predefined symbolic sizes in 3D:", "ExampleText",
 CellID->86190724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69731536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->Small,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{302, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451397320]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1808076656],

Cell["Use an explicit image width: ", "ExampleText",
 CellID->324773305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239643983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->100,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -2}, {0, 0, 2}}],
    ImageSize->100,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325680759]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122836996],

Cell["Use an explicit image width and height: ", "ExampleText",
 CellID->49112691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13340374],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->100,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -2}, {0, 0, 2}}],
    ImageSize->{100, 100},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40621242]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LabelStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->150860619],

Cell["Specify overall style of all the label-like elements:", "ExampleText",
 CellID->194093272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212931558],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  LabelStyle->RGBColor[0, 0, 1]]], "Output",
 ImageSize->{184, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342821180,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Lighting",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->752167364],

Cell["\<\
Ambient light is uniformly applied to all the surfaces in the scene:\
\>", "ExampleText",
 CellID->88941452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
    
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Ambient\>\"", ",", "Orange"}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392976626],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{1, 2, -1}, {2, 3, 1}], 
   CylinderBox[{{3, -1, 0}, {3, -1, 1}}]},
  Lighting->{{"Ambient", 
     RGBColor[1, 0.5, 0]}}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179554984,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1WmlvGzcQXUu7lmxLtnzJp3zEdxxfda7WzdGkSZq0aYEAbYGgRWGkKmKg
ZxIU/ZI/0d+Sv7do+Yazu9Rb2is5sQFrRXHmPR7DmSGXT4/fvGz/dvzm5MXx
0qNXx3++PHnxeunhH6/MT+W+IAjemf9/pwPz/T/zTf7fxXEcBP+Yz7Ddbt+U
0t/ms2RKZX3ekF9fm8+yKUUo4Yt5ms/gutT+pbJVb+3vqjuIUmhrrcA1qf9V
tesoRWm9YlwVmRPFGDlD5heVGXNaga8lKh+I9M/KOtmV9LFiT1Ftmcr7Iv2T
Ys9SbUjlPZH+QbHnu5J+rthLBdK7Iv29Yl+i2ojKOyL9rWKvdSX9TLE3qLaf
yldE+huVvky1FSpvi/RTbclOV9JPFHuPaqtUFu7gC8X+iGoHqLwl0g8U+2pX
0vdjZ9U4tYNU3hTpu4r9MdUOUVlGOLit2J92JX2k2LeptkbldZG+qdKfUW2d
ymIZsq7Rks+7kj5U7IdUO0zlVZE+UOzHVDtC5RWR3lXsrwqwrfQVxb5lnlXj
AHlWmENWjcxsMkuRaL0N8OQV16DysmhvKCe0y0ZrwmjjKa7DCgejXs1Vh7dk
FGaNpqiqFvs58Qii62otiBak3oI1x2W1FrWVR1JrxIw0FFxtfAUi93NREOaV
90h5l1kzaf0pM7QgKLPODLntYLQyobHlWbSp2F0DGdolQovMB899SxAmtT13
CWGFEPo9COLPZZaylZUhrBJCxXzwmFiEhrbhPiGseRDcMeGVPidodW0P/Nom
IVQ9vZAYJisFPz6iNqx7EM5qg0Wrao/gt4EAAZlSNdMBTztmRJP9/2OPndg8
JT82bLfTgtivbfnSY/kQrhaMMltehupmQujpotEEU81jO2etjKkMsSN7Qt/n
tZUjHot2MXk0m4LJcZ1zH3jsGWUY+yAMSVYJ5KYiNwk5NB/jpDfpReMyVsi4
os52gTrhReX85Z75aCgqjLRuOj3s8UfdobMFwy/UFR0+MgywRm2EGfCwTJD+
uJeFMx/4r0F3pekfPHVTI1LF47E5Ox7zsnEudMd8VNXagQKWlj7F2sOU5VQO
jq6c5cCnR864JTEHT179TdId9TKwr7oFW3XmHchr+iwTA+8LGl4G9hVJjpat
JYu2IW4hLaeOsTsW9h83lEUWn2NJ6Me2Pktpf6wOj9iIl4nXfJLpQS6kPl0R
p0F9yvXIz8Oee17nflj5sKbKxLcrdpaWjdS0b5xyOzjOqjAS8K79cbaLLRHX
vsslvpm56l4u9hgow3/BDyc7YuY6SLnkr53fk/q5JhQTYzmZRg1xyeIN8HlY
2I+aF5utpRZnfhjzZO0+68PVXB+YZ8jLwz2F3xlTHvjKmo8nSnksVQ7Fz8Ut
go0lUQD+ecjH5cRDjqXs5WTvkZPiEwN42mFlHTXPwR5ZeWYGvKxzVMZY1JQV
tjJQwMpjx331s0p2m2U0cRahkHNUiPMacbKPYM6ql7OVm1XL2PIwci856jFj
xcu4kJazPATrcFl9ysUwhtqvFQ/LIbFwRsIs/af3K7Se1f4hakUFXJyXMJfo
d+yNwQOBy56eHBA65yHF6HNxPjZue/rBTHxykHjX/hzDdJzFxB1PH/YImbOQ
httCxcz3Y1KlgL7rseUdYuEcoea00v09zDEl+1mM9Z6HaZuYOEeABYQas89m
Sva9NWWqEtOm5i4cRUNtIY9kWRk6I2VZ4+y++jkgblAfOOfOYudZ6MmeuaHo
Q4q+ou1u6khwxpFHqijSuCLVFWlRkZLZ5zXKZz155GSsmoqMXqHjsuuT06rM
rs7KyBS5w5tbT25x0cdQTp/sDsd3fhNqdnVWhml5IDmvyBOOVeBvJHDPmjKf
y34CoLwKiue05WEF+GgBY5I98lxzCxLGOF0F3TJGnTmVjifHf+YTi/HmA91w
picXNgDk8gje71g2zhagtdcLm6NXzAYLhxc5Lwu/lWGvYll4fcDrww9P9sjW
Ihze9Vo29p1T52RbIBxefZaNYzbYdi6MbUDnCyzYMzZ7ZFksYOkTFh5X9GX7
HGz8Fo4zEMvGNgMbRD4zdSFsvA7AtpX2DevUOsuxArZlwmE7sGzDcfYedUPX
V5qvdMnEbyfZvi0Txxz40nWNLVnucvpo8skts/IatqwcQ8G2qpEyy2Myll77
6mflOIHyJY38+Jl3n0WsKx7WPlMEm2Uc13nEc0mzlSxGds+0SkxRjomzcoww
TtuTzHC0R8Y1wgtzjBwFMZpzgtIZecvt5D7Ah2Tn8wawTxsUMEbt5Oyje8Z1
wivnGPnsAnOK945sazM9MvOb/lKOeUatKDk1Y5/x4Rk5C0DfszOn8zPLG/rI
zWfh1GyM4pxg6z25trxctn8twt58Ty65A9HxHsnyLOjMXRQ+xy5eN73ybDv6
2WhxzGJv1CtLcmPAorPvZq/aKzput/Sl6CvKVYQqp5CBfdeK3d9uBwqPK487
o9UVjc/PfesB02pXAPsgzrqYBaez2JxUiIXfIqL16X4zt/o5g2SWSFlqxMK7
sWXtiz2X3NRxL0Iv6UhxXsF72Zai23N4vu/E/goskezhO1H5vsRM7ETHDuvH
Vz435rZPy/CkZZQCG5nCJObZe1rkSfMtJ8zsDUuQnRbYd/V8d4vj4LwPz9nJ
N7R19hbEbpztC3hHziilwObc0Lb3W/ZJi090Fk5ti63vV7TsjhLH1/xqyNAm
1C5DRbG3v/j+mfc+j4MyQij2Xt2hjgtrL5P2oGpHOkf2puI10vLegPKssEjb
cCgo10nLe/sqdK2v7GDYG6Z8Y47jt9yGcnovN5Xk3lp6d9SR3lCpOyL1CdXy
nnBFpeWGTXBEtbzLWoqduzAB38bjjGdesZ+I9K04f1M21rUGqa9F6g7VRlSe
UOlnIn2Xan1vTyH9nUjzDT8+jUl2GM9F+l6c3QbmMQHmjyIl9wA7Yn5F64+l
/oGj3datIWrbUou7IEh+TqQU9P0PFNA+gA==\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342706330],

Cell["Directional lights with different colors:", "ExampleText",
 CellID->51534522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Directional\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437410544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 0, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[1, 1, 0], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Directional", 
       RGBColor[0, 0, 1], {{0, 0, 1}, {0, 0, 0}}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmwu8T1UWx9d9ude9uO4D9xJuHoM8Kpk0TDVS8ixUNBXTZZQrUWgKpcgk
xYjUoIkmjxkmoiajSTJTKfRUKXpIhlJNapo0Y8ZnZq3vPvvv3P3/49I5//Pf
e6+z1u+31tpr7/+5pz7l44YPu758XMXQ8rILx5TfMLxi6NiybqPHaFdGmogM
03Nkiej3/+k3zvMOHz4sGcOGDTvMPymzD/mJfmZq58m0ztZPE8nQa7penUzn
qFWtUu9ZkWxOTK9+SmNGz4xk81KOdohGa1orM4FJvzRi/PRId761shLjkY6G
yJwa6Sg8hkzbSKY44J4etOsjfUpktW4wmhG0S5FuGekurZJ080h3g2A0M2iX
IN000t2oStInx+MSG80K2vWQbhQhaRKMVgvaeEFOinQ3r5J0aaS7RTCaHbTr
IF0v0n1KlaTrRNJtjyNNrKUwQnJqMJoTtIuQrh3pbl8l6VqRdIdgtHrQJjMl
L0JyZjCaG7QLkK4e6f5RlaXjvWcF7bygXZu7whnbTK95WiJCG8e4u9KctTld
pPeHOVEjaOcfuT9pvtq8KFUd4eypGbRrJTE4nGI+WzY2lEid63Z3HldTaN8i
Xoam4M4QY5KmcK5axE72mvRydE1hRod+tbuamqZMp8n9C3XVSKkrbJtUsxgq
+5eeQlteSm0hZ8ug5oG2DD3DKKbWFmazaf9BoC0zhbbclNrCbDYvFjo8aaol
Xc+0vCpor55Sezg3LNo1I7ppuDDDPjL1zNKuanrNztKr/idZGMpEVvvTsgIU
1g7njkMRZkKI1eZBrqmodgSFYFaytZFjRqvrRHdHjhandPuaR28OR7ZEECNw
tplQZDkpMOWkxBRmTnXDUwNlmSjOxo4CyKNfvZavFVikQCUK9SzSszjDXQtN
ooDhWojWkCNoHVSbBGYjjEhqdPmxtve1aU/zrsr2HqqByQLDIMW6/Oh6JVKi
a5xIfUXWQGVPsqvdXZ/uEkTqIl7kMddAWXWi67yaVi2FL7NTorWKC8ICEGZC
2DnPuc1hq4f5BgpIl3eRxrolEGliHm+qZzM9m2e4a1ND1YTxxsg25L5SdBSj
Lx+oudhRaxnVIt/aqnR0n4KykCg7iHmwL8RxJXioITbVuNYbLRI6s1uKtNJt
l97TWs825py2dtXD2tZvGk5BTIVbcGNTD99hLwFvAebyMG1utplsaJlWsVUg
tZ+NgdUpC5vzs2OQT09d4KuzyjDeHCynGDiD2063orpjNcTt9TxDrXdQXWeY
O08XOY3hdoi25raWcFdFZSCvj++LwJ/r8acZmswIf7iSVDvqvINDHR+F6mRJ
Efob4LGmmG7loSuw9oZUOuiGXaSjbupFfmR3d9Kzs54/Vld0Ngd0sgEb7ojo
D7ntdFQ4Yq0g0wQzJ2GyEPO5QEnPiEpcyrUtaadq8bBVyCynMyfzCHFdiJSR
Qi0w2w4PnwGijmDsrKj1l4zIufrrRqSL3n+eKuhqV1PQhW4dPAepztzU0VM6
DRqtiVIzTDXAbAEQVE9Geoqd0tFZWO67VSEHdxQz2RqjvBW57oJwJs7t5IF3
MbByvsgFIt1ELhTprip6qCd7qv0eprU73d0QOR9xR8txOgse7VHfxrNpTLYV
UZRy3DpfNSbU9FKYpHFrLdKsIQFvgQUXhY6ew088gW4g7SHSS6S3SB+Ri0Qu
Nof0VTb9FENf03wx/X2Q6YV8d+6NmMGmE/o7YKsNdpuSa3XAk+MWq6RdxHEZ
ZTPP6zHDmzNDT8XKWTjyHABcgLMdiz6g7SvSX+QSkUtFLhMZYIwGKqPLldFA
0zyA/kuR6Y/8xdzr2F0Io/OIWGd4nYHd1mBoBJ5aYEuOUdbRGZVQPWpSchvj
orY+vToTlK541RG5yLO4FLQDRX4qcoXIlSJXKYtBeg5WbT9TZoON0SDtZ/QK
JAd6go7dRTDqgf6uMV7tfbDKIFXTymvVGLG7qU+M8piEZSRyO+ZqJ0LTlbj0
9EHpDyRH5EoAD1b8IleLlIsMERmqnH6ebs9HlNQ1PCfhKx8/13GTSjfputw4
2FOO+MLRxbEnTM8DRicSph3wGpOQuSky0bEMq7nPxCxmZiPKwqlE7MfUgQtw
qhrsRyoNAMtVnlk5mIdB5lqR4SIVhn+Entdp7R6ptK6ztlmoYPxaZB3Xclyj
mq6E2ADC2RdrLpBdiOKZTLmWoCsypCfArD7BO4kMOI2EOJuwdWeq98Xi5aTU
IMAMAds1ERW5TjmIXC8ySmS0yA3K5UadFGPsarpvoHsUIiMRdywdxSHQGkQE
B3pyvTHeFSAd8XULqnzeicWrmJnajjpxDoWqJ6lxCaauxK0uOo7MCACOAvKN
ImNFxoncJPILS72btXrdYiButg7rvonxscg6hiPRYdxgVY6FK7B2CZZ7guJc
WLWj4BefSKTqUtDbEO5zybte+GuAj045Pr3WUxkd4/ELgy/jNSoTbPc0UeRW
kdv0UF6TjNdt9EzkmKCSnmmCoxGE17VYSbC7DAy9wHMO2FobzqrxooI0YG1o
zhQ9Gz29qRQDmUZXe1LXkUManDE4/2ZATvBEJoncLnKHyGSRKTbD7tQsnGpX
0z+F/js4JnmyCZqqbQzUrsd1juDVWB8Ikt6gOpta+QOrHSG7zGOyKyBqnYl+
L5LhcuI1hNQbgd0bY2Ga6Bk5OncqEZFfitwlMk3kbsvH6bqS3aPsppv+u+m/
i2Mq8pM9U0fzFtiNxXuO4zVYH0St6g+q89lntbVtYWp24ZMXXz1KWRq7kN79
UDiYWTWcJLwBuy5Yt3pSjpGjM12JiNwrMkNkpjL6lZ6zNEXvU5azrG02ZjJ8
L6LTPdupxNV4Qm887nMkR2J+KBX4cmD1ZHXVDKt/AuxK+CXTiTWsL5p+Rm5U
MB3GYNDxuh2fO1J3A3MGqGcpEZHZymOOhe1+kbl2aL4/YJu8uXTN4ZiN6K88
2XtQdJf9qrONxu2YcRzHYL4CKIOB1ZfFQIE2PbHYtcQrvakhg9E3groxzufh
JHj90kdqBgDvA+wc4D8g8qDIr0XmKcf5SnGBng/Z1dr202Ieww8ianx5KFYb
gtMI3GTYTSRLxmJ+hKd2GeC02LU8AV71SONuhP0qsqCCpLgJ/93mIzUNCC5G
s4mD4zLPcMtDVkN+Y7XyYZGFIov00IrySLp9zaTrYY7f8Au22DO8H2Wqcibc
pmHqDsyOB8Jo4AxlBerHtGtRNW750brWg6pUToaPRuUE4jSF5HNBmuXD4/gs
MCoGVlk8IvJbkUdFFhvDJfobdKll5hLtMMTkW13EFjl+3D4PVXNROwtm0zE3
BdMTPLPh1E2F1z3cQR6bUx8iNYy8Hoe+26kS05j0LkBzySNCE1FxPJYYA1km
8juR3xun5UpnhXH6g1310L4VRKnUJExuGfcYZ7QkmM7HhtGE470guBM040F2
PSivsrQMn2dlHJNhXzxTweQdj9OmMsFnMp1cpOaDwRFbDDzHajk8lM1jIiuN
zSol97heV8NK926Pa5+N2fGYJ74ctstiPBfGSN4Pw5mAuBNA4wE3giLXLzW7
8Dl+7ahKXkJGj2IKT0Lf3VSK2cyJecRsIRBctBwpx2gV8FeLrFFGT1jcnhT5
I4+F7NmKfrc17kkbs2MNso6wo7ocfUtjJB/C5gOVGd5G7RwF0v5HiV5KfqVs
TK/BOxNIeRe3OT5oD/uILcPjKzyt1aB9whjIUyJrRf6Ecq3+TxunddZhx1rG
/whLx8+RW+EjuJgJqXYWwGm2pzUZRGNAd0Kc6rIhrcAlkyjwM1D7oA/Vo3jU
sVmJv9e4wEQ8ZB25p+FZL/KsO7TYb0i3rxn0PiPyZ8vWp+33lmOZoPh4jN9S
rC2MkZsBoklUlQpDWjVm/M2tkJ3iLcRpOpPrASrYIh+h5ZhOEHJsnnbPIZWA
yHMiGw33X7T5Vz2ft6u1LdM3Mr4BwuuNoNIzBU9VZrbchy1B6z7gTAZaRfh0
+Rh8auGCCXhkJuvLfLQuJutddFY7JplRRCCgcOV5Rf2CsXpRZJMduoK9lG5f
Sul7geN5peeJJVitwzNPonsldhJ85vt5NZVVuyLpWfkx2OSxvb6Vunofdehh
or8ME6vMg0QiFxwbgPVXIDoKL4m8LLJZOWxRWlv1fMWu1rbobGb4JURfjDHb
4Gn9iRx8AlMr8OCj1MRf+9VaCQ1JzSf+lJq/YWcjPZ1CsIAJCgvw1yQvnolR
eMHj32xYZasiF3nV8uw1PV/PEnnDrta2HcyrjG9FdrOn9EKMzzNYeCpGZikY
5vvFa2LSX3rSU/PIpPTfwyrkdjMFaF2LhfXkRYLAyx79qwZUXlfYIm+KbDMm
b6lL3rarxWIb/W8g85ontAUNjspf0LweK2uxuJJ6sJiIzIXEzVXjkBntwZax
IKzGL0+TzRt98jjgr3jUQFag8rbIOyLbFfW7iv49uxr67XS/jYhj4mgkOLj0
2ugJPIXZPxCFhdSc6Yrp+OhtVuBz96rIVG59hMxcxfxbhwVHYxO5sBUgzu1v
OfQGWt4T2SGyUxm8r5X4A50X79s830n3e4g4Vm/5yLyGss0oTpBZh9mVQFgE
nCkObsq/ZlZmUytiw6/9OmTUIxTD1YT4GSLuiLhgvB5j4SjsNNjygciHllEf
6blL58bHdrW2af2Q8feRdbwSpF5Ha4LRc9hci/3lYJmTtEMLd6rJrPwbIvx1
rYjStwh9a/DWs6RynNI2MuddF4+IjEJX/B9bNd4t8onIHvvKx9/sqke6fdRj
cLeJyi67K6LrwvgumrfFiL6I9WdBsgZUiwxh+Cwi/I3hWVb+C6fNoxpR7Bag
7AmyewMT9uUYv3d8sBy5XUdYGZ29Rmufxu1Tu5q2vZ7mJ55ZgtZ7aEtwepnI
bcDuGgrCgqQnz8dn4/82x6pTzLRcg8qNuGwLyf9mjIcj8TEAYaC45VORzzQq
+7UyfG5X0/QZ3fs8pQSfOJk3Ub8FUxs9k6XHe58izbE48u5OxKE44nA/NcFx
eImp+4ZPtJ2xKOwB2qcg3a/ARb5Q7F9qJP5utf4ru3JYr+XzFwjt99T2omK3
D9JOn3VvYHKTZ7Qq5fsgyXyMTknEYAmT8Tngv+L9vwPf7fKe3+eBf2HwDKgi
PqB75q8V7wHD6xh8iYRDvY87d/s47PBBeAVLz2F1SdJMD+Ph8NovYN4CLGAn
t54gOrDO0R9hKYH0cw/zgEK0OfyNnv/Q3P/WrtY2TV8z7mB/XhnzR2jd7gG/
iM3HknZV4d+TI7RBb2mE/EnW7K0e9vvewXtjmL8C1jeKUsEa8n/q+Z3myUG7
Wts0fcv4N8h+FcO/F3270P0udrZSitYkrROpkad8D7OALdomasF2D3sPznIZ
kcD8rcGT7xSsIf9e/f0vu5qGg/T/E5kEbpcr+9DmQL+DlU22ducHWMJ6E2Xy
YfeWBW+j5pNUWyhcOwjiHmbPflx0IIbxoMFKd/j+rd49ZFdr297+e8YTWA9w
93407UHrDixsKQwQhfXdIQw9jU9rEZl3mBm7vSvjGL8Dxr8cqkPqyf/Y1e77
N93fIxIA3IeyD1C8NXx/19CladNQOWTZcd/VpMpv9177jOgk4Bz0cA6Z1/6j
eP5rV7vrkMdzMIbnCzTsoVhtt4Cmej+4MpqwcuGnPDz9IdNyP3P1a1L/iHsq
48mr7J9/IP8lYP6Gnm1uU3dMJLmRX6g4uYT7E1R8ibp4dA5lmFWNyn/tGh1H
Q6BKdoTvMqcnWQ9rDH7IjbY9kR++CtIky4zmJCXG3xHew/vjWfEVjKeK6Avr
QugdpKpRWT73M91KU4ZNkGq+ErnprAJ7m5Jqifv1i7Pj3/8N9f8w1j6CqnYg
VSdo+zflnXRB1EolFdft/FsUSIWzuGOkzUkXH469MR/ozkhIhdkd1i57N98C
4J641gtGw18k9rY2b+ghXRIhCKVaRVLu/df6wWj4dKZZhMC9A93gcPL/aWBf
yyKd7s30hsFouJdoEOl0/ydA+N59uJLXi3S7/5uhcYQglCqKpMgj3tI/VoWt
FSHg3XlpEukMpXIjnW2QMk8kz4acSOY0ZJpHmuK/ONIjW7zBLi2iFu+ci6T9
H5Rn5qI=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->266370581]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164604977],

Cell["Point lights with different colors:", "ExampleText",
 CellID->405169220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159693515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 0, 0], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzN2geUXUUZB/Av9723m80m2U2WZDcJJAsklBBKpIOIIoKK2HuPGAUFQcBe
KHZAsCv23nvvvffejr33duyao7+ZufuyzL6QzVHPMWfz3r1zZ775///ff765
77176pbzT9961pbzzzhty/TJ52455/QzTjtv+qSzz9XUWRARW/0/cyoc/8tR
/n/Ctm3borN169Zt+V9Mp5c43mtP45757DivjbNO+15aj23PerMieG0jHOU1
NQ6ns24/voN1+foR7ejRanS5emg7esmc0Wvz9c3t6PF01utfb2Pskfsc3PZZ
fjV9NrXz7Fap0FTnq3PvjW3EyXn13q/tvaq62qnO8/XY0CJZU13tVudTuffe
bey18+o93caerq72qvPMK9a2sfeeV+/d294bqqtD1fnK3HtVi2Tf6upwdb4i
955sY2+cV+8Vbe9N1dWF1XnOdSxvkRxUXR2pzidy7/E29uZ59V7Sxj5sJ72z
M2O0jX3kvHqPtL2Prq4uqs6X5d4L297HVFdHq/Pxfu/Za3G990URc3pfzeg5
K33C+NoLi6vzse3j56zTtB5WiVGvmquJcTUrM7lwj2jDleZYWvVZOjBSPX/K
9HSOVI2cdZ6r1xy31usoqbfXTCRv849U65pG7Z0idUuk8q+OtXhgrPo89Vo/
C1X610Tx9s6j1eold26oonUGRBsdGK1eCSn6PlW07oBoiwZGq1dKUnHfKlrP
/9phJdrOvJwq8H5VtKEB0UYGRqsZJP/uX0UbHhBt4cBodeYPmAeuwZHGZs7b
kRvngWl4YKTk9k3V6IUDaszg0QnHgQNGJ9S5ada6LhEGrbY6wkjyTxuh3kGH
BkZJOA4aECWH2Trzb+B6nVesVHUH+XTu6JTjg/+ro0cj5qy4/8Xo5PVDBoyu
kedxc+5slv7XRy8egPz/b3RSbTKPXrAgmiY6ymi3241erxcd79HVot2fDsP/
0TzL05Ch/jx5lhgaimZY3M7ChTEykv6i8dIsWhTd9K45X+/pqLtBhoqR6/38
sNR7bVJsPJcZQPooyvymjWZU5juLF8eSJekvRpYute050uTPVb30NQKygqsF
5TORTxkDfNPdIZIlebEbLIRAIhYYpjFZmroZGzN0fDyWLYvlRGwmJqLZbTdt
K1aE93SYz8dc0MGfnvobZ3wBLlyBDC/OSbddw5lWQ4zBaXRfLlGFN0lBZ36Q
Vq6MycmYmoJq9epo1qyJ7u67R8d7LNawalW6pod+UBe0BWrB2eTKW0TdUf3Z
Mc7UO5YVMYGkZJERQlOBV7ABAtQee8TatTE9HXvuKdpee8XQ3u54Rhxo0Lxu
XbquF/BGJE75ZmhIQO8UkC8TMdLILqFMu0xMFDWFKCiJQAqagEgl+Ao4cMDa
sCH22Sf23Tf2c0PQ7L9/NBs3RnPAAdHxHkMaXPCnh37r15fFMVrAQ05u+SGD
5uIGaUwSL9wl5LkGTCCMthhF3ALbJKYyIcwFMCxwwbhpUxx4YBxkY2oOOSSa
zZujd41r5PfoaDj44OzInPkxdNAoHFCXAyGpXwikBbYkCUa2VKCGd4i+vltP
O2O6R4mV0OMOvUgEKYqDbioTFtxQAA0xeKAedlgcfngccUQceWQcdVQ0Rx8d
vWOO8aHSQX+HdlmnQw8NvFAyGHUCFC4s1SeiM9mkgUUTi6F5s0h3HOnuNCa5
BwtKlASIKjbHoGBC0xb8sAAPGtgQH3tsHHdcXOtacfzxce1ri3+d60RzwgnZ
101qWOGCy9e8ZuqKHcJIkYAQcogRdfp05NxAIjJCy6W361ymipkQsUblgvWF
l4jCwsxELRQKfhjhvu5148QT46ST4uST4/rXjxvcIAdvbnjDaBzHlDZXXL/e
9VJHLBE0FDdK9ImVPGHFtCwgBC37lNJWFXPvKDs7ZJSr1krDisEwIlLJiznQ
YQ10TA8ELjAhAiKsYJ9yStzoRnHqqWX9dm52s7j5zdNfNF4ap7HqpjeNm9wk
bnzj1EtffDFFE0eqFIIy12fHy7SkaJ8a5/HOzD66i9wmDKUNzxVizCBP5jGb
JGHFP8QGByXowIQ3QS+cbnObuO1t43a3s3pvf3t8HDnXeqtbxS1vmchiiB4p
CIIYfahEq8KKH8hIzD4lpZPayX3pU2X92WHHfFLvGKeD0WKIxNNsQDFZsm5M
iAxV5QcWamOS94DuHe4Qd7pT3PnOcZe7RLNlSzR3u1t0Tjstv8cqDXe9a7qk
wx3vGHiieOtbxy1ukYQo5KhDI8yYmh3IZ4H1aSl27EPrXeCUv6dZmu6MOilF
vKes4SM/+JTk8IdZOQaZnI8R+oMIK9AIaLrHPeL00+OMM8xwr3tF7973jljt
QIPme94zXb/73QNRHBEkhRiyJ3V9ahxAOkuW2QuvsrjonO7qdshp9qeu/A1Y
uvVQIIihNIghEjJ8QDaZ4Y/CYzEHQQIPHuDBCTDsZ50VZ58d55wT971vNOed
F73zz49Y4+Dcc1OTC/e5T5x5ZmCIHm5EEEJ2pU3OsGJh6acbSjyBEgcyvkpl
6kX5rmPO5+25fPK3hcPIEEG1FkAYNsOkcBhjDjOiIR30BQYH2BAAFfD73z8e
+MB40IPiwQ+WnYc+NHoPexg2Dh7ykNTmygMeEPe7X+BXmFEALcELJ5myyKww
KxMhdpAjuwSP2LjL3cEusOmwmlJAiLIudpN6avE5w5uukCAtJIUBeHAC/PCH
x4UXxsUXxyMeEY98ZDzqUdF79KNxceBU40UXxQUXpG4644V6IUUPqkgx+5GK
YH06igRn8BvXl80pcam/u2gGcskZmLL2RRDHkrdEEKGYbJjOpFhwDXnhITz8
cAL8mMfE4x4Xl14al10Wj398XH55dK+4Ihrvsdq51ksuicc+NhDErRCTMKmk
CEqSxK/EshILH36zhCxY5c6GjgybpRuHnXJZNsMlfd1pU1WjCaLCWC2ispjU
YKSHaU3epwMXLmAiAvoTnhBPelI85Snx1KfG054WT3+6hfiMZ0Ts7si51ic/
OZ74xMC0EKQCOYgiYdIsW/RiPrxYQYFQHaxX4lpB1rHbXEW7IB/0bdVVeS1t
eeXPdVMqtT2HPrIuLNFMUSjxmdlhKHwkRgqQgRbsK6+MZz0rnvOceO5z4/nP
j+YFL4jOC18oTw6cP+956cKznx3PfGYgiyQNMCQJYdCTOf6VNtw4Ajdlgk0Y
UC3nHcTcU9Z3z/U90Qy/7S2jLb/8rdkqm5HioDJYUFJmDjNZR4WcZIECEGYy
ACVaQEOPy4tfHC99abz85fGKV8QrXylrr3qV+yFHzl/2snjJS+JFLwp0ESWF
bFIGRRnkT+njTJ7AjycZhbaWNDcip2bVn+53zix9d5WqQ674k/SRNjsQ0eTM
HGayuAsn2QKF6RCSJCjBRQX617wmXve6eMMb4o1vVPve/ObovOUt9loHb3pT
anv96+O1r41XvzrRxB9HchSCcsii/MkSsseZfKLOW9t2dNQYMtWw+nul+juF
udxmvuvLe++kPVa+FFiliTnMYzYlrrCSJnCYDCUY8QEZ9re+Nd7+9njnO+Pd
7473vAeK977XHb6jd70r3vGOeNvbAlEEsZdJGURN7igkcRwga1zJFrYJ1VZN
RIoZ0yeunX2b3jLa/lvLtlm/Yk7ZFdx9FT7KLleYiIyqQyEjP/DQXFqARAOH
970vPvCB+NCH4iMfiY9+ND72seh8/OMYOXD64Q+nS+9/f6KKM3YkQE2G6SJl
eMmXBccOrKjg8ghSlnnaKQd9gz/7fEFmlAjlXyxXqnzkKAQUXA5gdMJZ4NCz
FtNAUKCDBR+gn/xkfPrT8dnPxuc/H90vfME9vYPPfS61aP/EJxITNFDFQQLx
lxsEJIbhZJtMLM0CKiCfMfzA76XnIJ/dkn/9XSkF1j/HSjFNZFwdMw+T8xDs
TAIIOGSGDtIvfjG+8pX42tfi61+Pb3wjOt/8JgYOnH71q/HlLwdKqHzqU4nH
Bz+YqEsEErLAXTJLIa61+2Jg87NY3XbNl8G2mW+u8yYUK6TOMftYC7yjsJLe
VExNd9g5heL0/dKXEmpwv/3t+O534/vfjx/8QMAf/tBnU0ff+1585zvxrW8l
Ughi8ZnPJNaFgjxIJllUDiVEnmXAorCrWplz7mnqXwQK+oG/qU8ogsoUOdQR
8FVZpld6zEp32IkOEFiAQ/3jH8dPfxo/+xkn/uIXPjX9/Ofp5Cc/CUyQwABN
ZMHnNraTQ/Kzo8TSnnuYNd2/jFd46hrV+n1b+XU2O2bCXmuHUheooN6AanGq
KpIt69IPJ3VhARK+X/86fvvb+N3vsP/97yOWO/rNb+JXvwqwYSZ8AUxvlkGY
6eXO0rfp8LqqwJ7LK2T1TlGQ1qpnfcdZm7J8pzCSVW0gCz9wq6kBAPSXv0wo
//CH+NOfovuXv0Qs+/Of449/DJARQANU2jIPYa0DOKmqxnK0cuXOSwqjfj6j
zndBOTxbz3FiYqk2sZeQSgQZpVuuf/SjJJL54QLnr3+Nv/0tOn//e8SYYygB
JCctMWAM6CxOhuF6SZFwdko3vivnhauuflm9dVYqcJiyo9UgTRJsMpaDjD4F
GVT/+Ef885/pFco+OMKSzsKiNmJ0UwwsT4Usfc6YGoBsgdOEqKCq7wGyaqOq
lJrIKlIJEubyOBtSdIGKxTvCYROhkORZDPWzLM0cDDPPPuSekw6sIopwEsuy
PBvxu+nNwtzF716LdSSHdZRHQBUjVcldVHmCqDd7b8zfVOb56mqSVRqd3dc9
p0Uiz7wo56WuRcM0MdwvYeoGeYjE+PlZnKs+91DmWtpyqzNx+Kzz7cjqirFi
XqOWVb3qdTLzlFXpvbw9q3sd2baXnNRX6zkSkm6/98xTN3WvzW2v8otO/cRU
/YnowLZ3+VV8qo1Z90pPVPVmPncUv1b34rPP17cxy3MztRdr90+3vctzSjNP
NdW91rQIyhNe9dNX9c462cYsz7Sta2PWvSbaXtlHsWd1ta4oYy2C/ARV7LVt
+5N5tRYpZn4WKitxVYeOtNcPydc3zBqdvNVt58jPL8U+Xoe2tk8cRSz4N7vn
sqo=\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[0, 0, 1], {0, 0, 2}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->277173877]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->421043655],

Cell["Spotlights with different colors:", "ExampleText",
 CellID->1020162722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Spot\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"Pi", "/", "6"}]}], "}"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow", ",", "Blue"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42457521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 0, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 0, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[1, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[1, 1, 0], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[1], SphereBox[{0, 0, 0}]},
    Lighting->NCache[{{"Spot", 
        RGBColor[0, 0, 1], {{0, 0, 1.5}, {0, 0, 0}}, Rational[1, 6] Pi}}, {{
       "Spot", 
        RGBColor[0, 0, 1], {{0, 0, 1.5}, {0, 0, 0}}, 0.5235987755982988}}],
    RotationAction->"Fit",
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->797765129]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->539068038],

Cell[TextData[{
 "Display a label on the top of the graphic in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->771515743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "==", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126827358],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  PlotLabel->FormBox[
    RowBox[{
      RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"], "+", 
        SuperscriptBox["z", "2"]}], "\[LongEqual]", "1"}], 
    TraditionalForm]]], "Output",
 ImageSize->{104, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->39643184,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->583455798],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " and other typesetting functions to modify how the label appears:"
}], "ExampleText",
 CellID->358165567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Framed", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}], "==", "1"}], "]"}], ",", "Red", ",", 
      RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134444572],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  PlotLabel->FormBox[
    StyleBox[
     FrameBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "+", 
          SuperscriptBox["z", "2"]}], "\[LongEqual]", "1"}], StripOnInput -> 
      False], 
     RGBColor[1, 0, 0], Background -> RGBColor[1, 1, 0], StripOnInput -> 
     False], TraditionalForm]]], "Output",
 ImageSize->{104, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->117882460,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->568677812],

Cell[TextData[StyleBox["Display all objects:",
 Deletable->True]], "ExampleText",
 CellID->288438668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8384457],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  PlotRange->All,
  RotationAction->"Fit"]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->76185019,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75580773],

Cell[TextData[{
 "Explicitly choose ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->152530789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "All", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113676480],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Axes->True,
  PlotRange->NCache[{All, All, {
      Rational[-1, 2], 
      Rational[1, 2]}}, {All, All, {-0.5, 0.5}}],
  RotationAction->"Fit"]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79926776,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166641402],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        StyleBox["s", "TI"]}], ",", 
       StyleBox["s", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        StyleBox["s", "TI"]}], ",", 
       StyleBox["s", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        StyleBox["s", "TI"]}], ",", 
       StyleBox["s", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->687841644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", ".8"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69613566],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Axes->True,
  PlotRange->0.8,
  RotationAction->"Fit"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157241328,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->533773865],

Cell[TextData[{
 "Include ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " coordinate unit of padding on all sides:"
}], "ExampleText",
 CellID->618308069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429680998],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->1]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->273411816,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->594321515],

Cell[TextData[{
 "Include ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "10"], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 "of the image size as padding on all sides:"
}], "ExampleText",
 CellID->317582922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"Scaled", "[", "0.1", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329684157],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->611433905,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154551926],

Cell["Specify different padding on each side:", "ExampleText",
 CellID->3256323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.5", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", "0.3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11015496],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  PlotRangePadding->{{0.5, 1}, {0.3, 0.3}}]], "Output",
 ImageSize->{154, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->134557595,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRegion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->219280631],

Cell["The contents of a graphic use the whole region:", "ExampleText",
 CellID->1713052246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->961237306],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Background->RGBColor[0.87, 0.94, 1]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->129517761,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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