(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    509627,       9864]
NotebookOptionsPosition[    495898,       9395]
NotebookOutlinePosition[    497564,       9437]
CellTagsIndexPosition[    497477,       9432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsGroup" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGroup"], "Plot3D" :> 
          Documentation`HelpLookup["paclet:ref/Plot3D"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsGroup\"\>", 
       2->"\<\"Plot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Combining Graphics\"\>", 3->"\<\"Graphics Objects\"\>", 
       4->"\<\"Polygons\"\>", 5->"\<\"Symbolic Graphics Language\"\>", 
       6->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphicsComplex", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsComplex",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsComplex"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a graphics complex in which coordinates \
given as integers ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in graphics primitives in ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " are taken to be ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " works in both 2D and 3D. "
}], "Notes",
 CellID->32091],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " effectively replaces integers ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " that appear as coordinates in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " by the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3766],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " provides a convenient way to build up meshes or simplicial complexes in \
which vertices of polygons are shared. "
}], "Notes",
 CellID->5808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " is treated like a single primitive in ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12126],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"], "[", 
   RowBox[{
    StyleBox["pts", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can be any nested list of graphics primitives and directives. "
}], "Notes",
 CellID->14825],

Cell["The following options can be given: ", "Notes",
 CellID->31159],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContentSelectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContentSelectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow contents to be selected ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexColors",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexColors"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "vertex colors corresponding to each ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexNormals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexNormals"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "vertex normals corresponding to each ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->17518],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["data", "TI"], ",", 
    RowBox[{
     ButtonBox["VertexColors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VertexColors"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " replaces ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["j", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["VertexColors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VertexColors"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["j", "TI"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3220],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["VertexNormals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexNormals"]], "InlineFormula"],
 " option works the same way. "
}], "Notes",
 CellID->10035],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     StyleBox["pts", "TI"], ",", 
     StyleBox["data", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " substitutes coordinates to give an ordinary list of graphics primitives \
and directives. "
}], "Notes",
 CellID->31314]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438479937],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->138809517],

Cell["Polygons and lines in 2D:", "ExampleText",
 CellID->71162777],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335110482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"v", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], 
    "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"v", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}],
      "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56516828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1, 0}, {0, 1}, {-1, 0}, {0, -1}}, 
     PolygonBox[{1, 2, 3, 4}]]], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1, 0}, {0, 1}, {-1, 0}, {0, -1}}, 
     LineBox[{1, 2, 3, 4, 1}]]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->64225193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36924650],

Cell["Polygons and lines in 3D:", "ExampleText",
 CellID->912318266],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23974798],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "5"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11945553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".8", "]"}], ",", "Yellow", ",", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Polygon", "[", "i", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Line", "[", "i", "]"}]}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56811946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 1, 0], Opacity[0.8], 
     GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {1, 1, 
      2}}, Polygon3DBox[{{1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {4, 1, 5}}]]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Thickness[Large], 
     GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {1, 1, 
      2}}, Line3DBox[{{1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {4, 1, 5}}]]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->65400126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489948303],

Cell[TextData[{
 "Use built-in ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->571715156],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405558569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"i", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<FaceIndices\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226907178],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"15", ",", "10", ",", "9", ",", "14", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "6", ",", "12", ",", "11", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "11", ",", "7", ",", "3", ",", "19"}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "7", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7", ",", "16", ",", "1", ",", "14"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", "8", ",", "4", ",", "15", ",", "1"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{410, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->118710523]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Polygon", "[", "i", "]"}]}], "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{"v", ",", 
        RowBox[{"Line", "[", "i", "]"}]}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154743775],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->62351058]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17524],

Cell[TextData[{
 "The coordinate data for any primitive can come from a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->351972900],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22904023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Circle", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->692380617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{0, 0}, {2, 0}, {2, 2}, {0, 
     2}}, {CircleBox[1], CircleBox[2], CircleBox[3], CircleBox[4]}]], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{0, 0}, {2, 0}, {2, 2}, {0, 
     2}}, {RectangleBox[1], RectangleBox[2], RectangleBox[3], 
      RectangleBox[4]}]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->71071714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}],
      "]"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->149120789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{0, 0}, {2, 0}, {2, 2}, {0, 2}}, 
     LineBox[{1, 2, 3, 4, 1}]]], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{0, 0}, {2, 0}, {2, 2}, {0, 2}}, 
     PolygonBox[{1, 2, 3, 4}]]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->47157019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243881952],

Cell["3D primitives:", "ExampleText",
 CellID->157816812],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64115471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sphere", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Cuboid", "[", "i", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->416520138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 1}, {2, 2, 1}, {0, 2, 
     0}}, {SphereBox[1], SphereBox[2], SphereBox[3], SphereBox[4]}],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 1}, {2, 2, 1}, {0, 2, 
     0}}, {CuboidBox[1], CuboidBox[2], CuboidBox[3], CuboidBox[4]}],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->84989243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "1"}], "}"}], "]"}]}],
      "]"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], "]"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->514452754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 1}, {2, 2, 1}, {0, 2, 0}}, 
     Line3DBox[{1, 2, 3, 4, 1}]],
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNmNtPGkEUxpe9ACKIIFIQVPCuVVtbezE1bfrSPvW170RJ9KFpY/33N+3M
mW/28s0GloRlz55vfnvmdmaGH7Pnh/mv2fPj3Wzy/Wn25+Hx7u/k2+8n9Sio
eJ53r74/B566/6fu5Hsfx7HnfVXXcD6f74r1RV19Zfn4NU9v1TVQVoSnO/L0
Bk/r2tI36lddvW3xfoB2tdB7jbItbYXGawRj8b9B6XVtRYkfjJFoXoHRXaC5
AGczE4W+9ckeiPoMxBfkDcgWv3cC9lYp9SHYY/KGZPdFvZ9t/4w3Ilvq5U3A
npZS74B9QN4q2T1Rj8A+KqUegn1K3hrZG6Lug/2SvHWypYflDZp9WUrdAftq
iboj6jbY1+RdIVvGo9cE+30pdQPsG/I2yG6Lugb2J/Kukr0majsjP5dSh1B7
gZr/8NySskl2KymZncUtBeCWbRWRTMl0durC6qPja3pmVpRkVHmGm/GjIxkU
1ZZbw5mXiW0aw5siJm6BdlG/ObSQaOfq0lD3+lGnFCEigs6BAXKx9JiRmlHF
o86hVYl2Gac53Pa/9paj1YhmM+XKElq9kFYn2lGcWQ0W1FSicHJ3g2h7oHWI
xv1YTFsl2g5ovSU1rRbSmkTbAm2whBYV0lpEs/lzvKSmxbQ1onVBmyyhhYW0
NtHWQNtfUlMZG2aI4H1dIuke0VnrmEgcl0vaIJLNrWdUwxaehw5hM/NOfetD
eUkEPaLDZK6mMfkOUdb30JQ0nyuqV4R38ArrsnpQ+urxW8tN3On8XMSw6yTn
L4kqNLaJk/Oiy7J9zvP7Ii7OZLxKWWJ+NgbZd4N4GhdnM46x4hDrKLlORLs/
44zGMbpE2189Ik4wJjir8brvEu0oGxBxHGd2vBki93KeqMv788zOE7QBaNkx
rr3FND/JDCnBjr8hEXiPlRKmRGijjbapRrxfBIGe7hLNjpa9AlpF3WuKIfGK
xCSbKQ6pZi6J9+9M8lHDU4qp6pDsXk5aGTPPfDjbRE5Zbq8dsquqMEcQOhTu
t22mqEukAAfUKi6JxxCfenRP6Zh2KabAIdndMxM6iGW0gODu5YZk9xFHnyh+
jsK7Ut5vjhFLsuNAu+QpvCvlU+YUsUjMURILWIZhzylc9hgRSA+GSdnk3bwD
7ZF9jncHmXZI39olNdt67dEvreTqu0EqjuFjTm1Pd6zSJ7JkZUU/pV5u09dQ
m90YtxL34znUZj8+QASsOoHKnKH4tM/Z/ABqcwodkZfnhV0jzKmfx3jRfNSm
xCCWjpdVwziTU70y/yCENjN7E/JydutALXnR4/8bOKu24kzuk325jpdVK1Bd
iEpyS+4foRr8siPJnRj1CA3gfSdefZKI5jhrqwH5H3v9dxI=\
\>"]], ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 1}, {2, 2, 1}, {0, 2, 0}}, 
     Polygon3DBox[{1, 2, 3, 4}]],
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNmFtPGzEQhZ1kc79AgIQAIRcooQr39ILaolZ9aZ947XuEIsFD1YryN/qT
V61nfHZJzjpskNjsZM58Hjvrsb2306f72c/p08PddPD9cfr7/uHuz+Dbr0f7
VS5jjJnZ/x8dY+//2Tv9n4VhaMxXew1ms9lArS/2mrVWDp99/fbGXnPWyi98
+xFWSSxx2097NT31XiOmIlbgvE6wr/53iK4v8U8QvyZWPvajja5qLsHYeEFz
Bs7WXJZymyV7R9UnIG6TN0d2R9Wvwd5ZST0Cu0vegGxt2xyC3SNvnuy2qgdQ
D1dS95DJK/IWyG6peg/sEXmLZOsI6zgKe5zCduo22Kcp7E1Vb4F9Qd4S2fo8
mCbYVyup18B+S94y2U1V18B+T94K2euqroD9YSV1EexP5K2SrTPDRHPy80rq
AGr3iBoj1xtS1shuxJHzs7xuo3lk6z7bRT7PTgm2f9Xbv6Ew+Bl8gVHgGW7M
tqXU7GfHlzP3KTHT4hpgCRZkhsjJO3Y8tolZHhDtzF7K9l6K2/pKhDwRJvYi
ZlaMnFRxlRqmVby0AtHOQSuk0MpeWpFoY9DKEQ2/yWq0EtFGoNVTaCUvrUy0
A9CaKT3VPiVWgirReqC1iMZPhZ9WI9ouaJ2Unha8tDrR5PnXNSWFlvfSGkTb
RG79lJ76aa5NhxJAA7TDFFrgpTWJVgFtRD310/QRQXvxyg9SAaQxkWRso13O
IqFFhCwI59QzeTpltnNfcgliG8oJEQLkwKtlkrAFwvwYXckliHsEFq9gSVa0
UnIFm88uGqFE/VwgNUDi+c395DUmSaqCxPOHSVyrI9JizcjN12CQruj3Tyfl
Q9pLMgk58bqeJGVB6qSQ+LfzkGZzO8olFN7xOIrOdIq8pDHxR0qbw2WRS9rM
hL5ZvrR9UHgf6Chc/9MoPJschXcDTLmgsfBTov2XjIeIuSbwDtxFcb8Su3wL
GHtqQ5LE47xPtmQttCOi8Rg6Whm9YUoVlAGNieSUsTcS7Qg8i3bJllojJarr
yWeRxDWCT1lt5LRNpGyCxHWLd4td5CTrnw597JI+ume+gZHh2CGyqEexYVTC
nmN5NW6RfYz2y1H9jgEuvkl6PsueIoeA6rWL3iD1JtkTRGcxZkYVYrHyGt87
FfeCe/kmdCuUW2/a5OV1+wJqt4vi8zfv50+gdvvoDvJi1TFU7uzDTyJX6aPQ
1WR31twjL1fiIdjuRN1FBqzah0rbTsxyrig7ULs3KH3yciVpQX2g6gF5uVo0
odZTvGYv+bKqDpWe3vUdhMnH3vB5nRTNuWr0/Lbw/qYI/0T9R3MtRBVDTD05
6zsROdbpydiYzH9nwgdY\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->559490847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185474324],

Cell[TextData[{
 "Mixing directives and primitives within a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->132111076],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"15", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], ",", 
        RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", 
       RowBox[{"4", 
        RowBox[{"Pi", "/", "5"}]}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590951174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{"v", ",", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
        "}"}], "]"}], ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}],
      "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151282521],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[
   NCache[{{15, 0}, {
     Rational[15, 4] (-1 - 5^Rational[1, 2]), 
      15 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {
     Rational[15, 4] (-1 + 
       5^Rational[1, 2]), (-15) (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
     Rational[15, 4] (-1 + 5^Rational[1, 2]), 
      15 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
     Rational[15, 4] (-1 - 5^
       Rational[1, 2]), (-15) (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {15, 0}}, {{15, 
     0}, {-12.135254915624213`, 8.816778784387097}, {
     4.635254915624212, -14.265847744427303`}, {4.635254915624212, 
     14.265847744427303`}, {-12.135254915624213`, -8.816778784387097}, {15, 
     0}}], 
   {RGBColor[0, 1, 0], Thickness[Large], LineBox[{1, 2, 3, 4, 5, 6}], 
    {RGBColor[1, 0, 0], PointSize[Large], 
     PointBox[{1, 2, 3, 4, 5}]}}]]], "Output",
 ImageSize->{154, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->2183721]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9694],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContentSelectable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->938834632],

Cell["\<\
No individual object is selectable; the graphics complex appears as one \
object:\
\>", "ExampleText",
 CellID->118110927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", ".5"}], "}"}], ",", ".5"}], "]"}], ",", 
     "Pink", ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Disk", "[", 
          RowBox[{"1", ",", ".5"}], "]"}], ",", 
         RowBox[{"Rectangle", "[", "2", "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713606423],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], DiskBox[{-1.5, 0.5}, 0.5]}, 
   {RGBColor[1, 0.5, 0.5], 
    GraphicsComplexBox[{{0, 0.5}, {1, 0}}, {DiskBox[1, 0.5], 
      RectangleBox[2]}]}},
  ContentSelectable->False]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57221656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172648066],

Cell["\<\
Allow the individual objects in the graphics complex to be selectable by a \
single click:\
\>", "ExampleText",
 CellID->189168641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", ".5"}], "}"}], ",", ".5"}], "]"}], ",", 
     "Pink", ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Disk", "[", 
          RowBox[{"1", ",", ".5"}], "]"}], ",", 
         RowBox[{"Rectangle", "[", "2", "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9339115],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], DiskBox[{-1.5, 0.5}, 0.5]}, 
   {RGBColor[1, 0.5, 0.5], 
    GraphicsComplexBox[{{0, 0.5}, {1, 0}}, {DiskBox[1, 0.5], 
      RectangleBox[2]}]}},
  ContentSelectable->True]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11460750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->445946109],

Cell["\<\
The first click selects the whole complex, and subsequent ones select \
individual objects:\
\>", "ExampleText",
 CellID->448229726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", ".5"}], "}"}], ",", ".5"}], "]"}], ",", 
     "Pink", ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Disk", "[", 
          RowBox[{"1", ",", ".5"}], "]"}], ",", 
         RowBox[{"Rectangle", "[", "2", "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"ContentSelectable", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184691575],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], DiskBox[{-1.5, 0.5}, 0.5]}, 
   {RGBColor[1, 0.5, 0.5], 
    GraphicsComplexBox[{{0, 0.5}, {1, 0}}, {DiskBox[1, 0.5], 
      RectangleBox[2]}]}},
  ContentSelectable->Automatic]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284162394]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexColors",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20189],

Cell["Specify colors for each vertex:", "ExampleText",
 CellID->531257434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->480943747],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[
   NCache[{{-1, 0}, {1, 0}, {0, 3^Rational[1, 2]}}, {{-1, 0}, {1, 0}, {
     0, 1.7320508075688772`}}], PolygonBox[{1, 2, 3}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->558285063,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->303481860],

Cell["Specify vertex colors for 3D polygons:", "ExampleText",
 CellID->222606742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718803155],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{1, 0, 0}, {1, 1, 1}, {0, 0, 1}}, 
   Polygon3DBox[{1, 2, 3}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->38019485,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexNormals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->175719815],

Cell["Define vertices and face indices of a cylindrical model:", "ExampleText",
 CellID->447671047],

Cell[BoxData[
 RowBox[{
  RowBox[{"vl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", " ", 
           RowBox[{"i", "/", "20"}]}], "]"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "20"}], "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96808944],

Cell[BoxData[
 RowBox[{
  RowBox[{"il", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "20", ",", "1"}], "]"}], ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "+", "21"}], ",", "20", ",", "21"}], "]"}], ",", 
       RowBox[{"i", "+", "20"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21627096],

Cell["\<\
Without surface normals, the shading is constant or flat for each polygon \
face:\
\>", "ExampleText",
 CellID->25220463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"EdgeForm", "[", "]"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"vl", ",", 
      RowBox[{"Polygon", "[", "il", "]"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->418367912],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->79032079]
}, Open  ]],

Cell["\<\
With surface normals, the shading is interpolated or smooth across each \
polygon face: \
\>", "ExampleText",
 CellID->374733348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"EdgeForm", "[", "]"}], ",", 
    RowBox[{"GraphicsComplex", "[", 
     RowBox[{"vl", ",", 
      RowBox[{"Polygon", "[", "il", "]"}], ",", 
      RowBox[{"VertexNormals", "\[Rule]", "vl"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->251009505],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], EdgeForm[None], 
   GraphicsComplex3DBox[
    NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {0, 1, 0}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-1, 0, 
      0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 0}, {0, -1, 0}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {1, 0, 
      0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2}, {0, 1, 2}, {
      Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {-1, 0, 
      2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 
       2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], 2}, {0, -1, 2}, {
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
      Rational[1, 4] (1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       2}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {1, 0, 2}}, {{
      0.9510565162951535, 0.30901699437494745`, 0}, {
      0.8090169943749475, 0.5877852522924731, 0}, {
      0.5877852522924731, 0.8090169943749475, 0}, {
      0.30901699437494745`, 0.9510565162951535, 0}, {0, 1, 
      0}, {-0.30901699437494745`, 0.9510565162951535, 
       0}, {-0.5877852522924731, 0.8090169943749475, 0}, {-0.8090169943749475,
        0.5877852522924731, 0}, {-0.9510565162951535, 0.30901699437494745`, 
       0}, {-1, 0, 
      0}, {-0.9510565162951535, -0.30901699437494745`, 
       0}, {-0.8090169943749475, -0.5877852522924731, 
       0}, {-0.5877852522924731, -0.8090169943749475, 
       0}, {-0.30901699437494745`, -0.9510565162951535, 0}, {0, -1, 0}, {
      0.30901699437494745`, -0.9510565162951535, 0}, {
      0.5877852522924731, -0.8090169943749475, 0}, {
      0.8090169943749475, -0.5877852522924731, 0}, {
      0.9510565162951535, -0.30901699437494745`, 0}, {1, 0, 0}, {
      0.9510565162951535, 0.30901699437494745`, 2}, {
      0.8090169943749475, 0.5877852522924731, 2}, {
      0.5877852522924731, 0.8090169943749475, 2}, {
      0.30901699437494745`, 0.9510565162951535, 2}, {0, 1, 
      2}, {-0.30901699437494745`, 0.9510565162951535, 
       2}, {-0.5877852522924731, 0.8090169943749475, 2}, {-0.8090169943749475,
        0.5877852522924731, 2}, {-0.9510565162951535, 0.30901699437494745`, 
       2}, {-1, 0, 
      2}, {-0.9510565162951535, -0.30901699437494745`, 
       2}, {-0.8090169943749475, -0.5877852522924731, 
       2}, {-0.5877852522924731, -0.8090169943749475, 
       2}, {-0.30901699437494745`, -0.9510565162951535, 2}, {0, -1, 2}, {
      0.30901699437494745`, -0.9510565162951535, 2}, {
      0.5877852522924731, -0.8090169943749475, 2}, {
      0.8090169943749475, -0.5877852522924731, 2}, {
      0.9510565162951535, -0.30901699437494745`, 2}, {1, 0, 2}}], 
    Polygon3DBox[{{1, 2, 22, 21}, {2, 3, 23, 22}, {3, 4, 24, 23}, {4, 5, 25, 
     24}, {5, 6, 26, 25}, {6, 7, 27, 26}, {7, 8, 28, 27}, {8, 9, 29, 28}, {9, 
     10, 30, 29}, {10, 11, 31, 30}, {11, 12, 32, 31}, {12, 13, 33, 32}, {13, 
     14, 34, 33}, {14, 15, 35, 34}, {15, 16, 36, 35}, {16, 17, 37, 36}, {17, 
     18, 38, 37}, {18, 19, 39, 38}, {19, 20, 40, 39}, {20, 1, 21, 40}}],
    VertexNormals->
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {0, 1, 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-1, 0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {0, -1, 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {1, 0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2}, {0, 1, 2}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 2}, {-1, 0, 
       2}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 2}, {0, -1, 2}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 2}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        2}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 2}, {1, 0, 2}},
       {{0.9510565162951535, 0.30901699437494745`, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}, {0, 1, 
       0}, {-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 0}, {-1, 0, 
       0}, {-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 0}, {0, -1, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}, {1, 0, 0}, {
       0.9510565162951535, 0.30901699437494745`, 2}, {
       0.8090169943749475, 0.5877852522924731, 2}, {
       0.5877852522924731, 0.8090169943749475, 2}, {
       0.30901699437494745`, 0.9510565162951535, 2}, {0, 1, 
       2}, {-0.30901699437494745`, 0.9510565162951535, 
        2}, {-0.5877852522924731, 0.8090169943749475, 
        2}, {-0.8090169943749475, 0.5877852522924731, 
        2}, {-0.9510565162951535, 0.30901699437494745`, 2}, {-1, 0, 
       2}, {-0.9510565162951535, -0.30901699437494745`, 
        2}, {-0.8090169943749475, -0.5877852522924731, 
        2}, {-0.5877852522924731, -0.8090169943749475, 
        2}, {-0.30901699437494745`, -0.9510565162951535, 2}, {0, -1, 2}, {
       0.30901699437494745`, -0.9510565162951535, 2}, {
       0.5877852522924731, -0.8090169943749475, 2}, {
       0.8090169943749475, -0.5877852522924731, 2}, {
       0.9510565162951535, -0.30901699437494745`, 2}, {1, 0, 
       2}}]]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->345419746,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->996749287],

Cell[TextData[{
 "Most surface and region plots produce ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->7053333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", 
      RowBox[{"Pi", "/", "3"}]}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15964869],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458634864]
}, Open  ]],

Cell["\<\
You can use this to transform the coordinates, in this a simple rotation:\
\>", "ExampleText",
 CellID->191989951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{"p_List", ",", "rest__"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RotationTransform", "[", 
       RowBox[{"Pi", "/", "3"}], "]"}], "[", "p", "]"}], ",", "rest"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340023272],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfQdwXdd55jMe3kNjkUVLseMk9hanbEnxJpNJdrTKeByJEi05VmwrFiU7
NKk1qdiyItJWxF6EQlSi4wFE750gKlHYABaQFMBOQaYLRctK4ni8iSbj8c7O
cL9zvnv/d9659z0CSDLZ2V0NBN5y2t/bORdPbdi2+cVvbNi2ZeOGjz/+6oZX
Nm/ZuPXjj33zVTwKfiAQCAzh/z0fDuD6Hq70/0P37uFf8/dq/E7GqyR1F1Rt
9H+BJFw+gIug9S6g7gPsZ78z+6l/gz79Vvi8W0w/v7W4/XR73cLslaz+TY62
jG2hLsPW/UrrPugZYZXnSYrVJ9XTwruO+4+y6r4r0XgIpDvUs7HpbZ/qtEy+
Dw7CSx4x6f8wnDxotfOu7/8+Plg6zGo1ST7PFwNryOmbsSwY3d4fXCRsqxcx
ix905v3qZUJp9klfNrTmKPfHN6F2dWHYoFOSwyFJzkyJ3mfc5/1q6z11qNc+
mL+dRvo/P/2tYG2MNrsPruI8SSCHHt3/L3yf+v/4/Po+JPf3SPzlUjdpfu7d
QOjihTtvXrqLS/zGNZ8mz57/Pv7FDy70k1R5YnWI0977JMT28tBnpiD++YgF
88PW/S9Y979o3X9g0dhQnQIZ33x58Pn1HS9u6vviF8qe/WI5Lp77UvWfPlOE
iw1/3v6ZdfsDSbgMrHryyb1f3dCJy6efzv7yC00JOrD92sd34l+z/TOfK1j/
3GGz/QsvNH726RzdPtXb/ql1jVOTt3/Hgu+TzsqXQPWwPPnWtpG+nusLb/04
6djY+UAYF2dmbvT2TODi8uV3Gup7k3AVCOMCt7js6hw7d/at+7VfVR1pv3Xz
b3DZ0TEye34BF4NHT584PoeLkycuH+k/gYs3L32vpfmobp/qbb9758TAkRs2
rL+7bNoaMGdnnayvu2TCgCkxcTyYsVws2rf9tavv1tV1W+0FBmkvMBvjp3rb
5+edxsIWCbOh6V0LoS1ZhhdOmZ7rDpBGVVWt+Bc/7W3DFy98xwTU6qDbp0l7
WXhf39T06WvqZUJMpno7LAXSB2KhKsifro7Mmoucn/tBc9MRG6oEnMcOuv0H
vVAJFqYm3xwamjaBAo+CUwMWVNKhuGgmUjW7eKgUzQJpuAAugBEvo3CmcO3h
rhvXf7Rozlrlbe+lLCgOuuv2GV5OANyAHhctTfP79k4GbJj+yz3TJ7EoJNBY
zBCw5ARqA8rjfnK4yisnoyNnx8cvmLrHkMMM7/g9PROdHaPoUh0ZWb8+4oEm
Ad+lytPurqv7903FykQi7sF0WGc87smA6oMCNDuAScGqQpooPwM4jFFe3tjd
dQwSlJdbmZdXgeeVlS3Z2aWYpK93+unP1C4LqtGRt15/bSyWH3w0g/CDH799
FKjHGk3rYFDoJrgRDwcGTuZklwIRAPyVV17HFLguKqxpbh6ASujvO97ff1yM
AmEPrnui/v33f64W/FvLgW369Pdhy+Nxk3BHPDEnbKST1hgDYCJwallZA0iA
BqUl9Xt2HwTMeHhgfyGAREtBgdCfmLXoH4Q5h2+zNNiSXOfuxvW/3vCVHo70
0QTUAmbBMKLxACBAzsos7u+fAqR79+Tm5lbgeWFBdSTSBijGRs+DWoEkrFTb
cI4rrOodF2oGHfQ6QtIMYgJhCfy2BUesn6JpFfVcf/KTf4R340CUQIIhAvv3
FQDSivLGl19+DVCgTX5e5dDgNKDr7Z2wFkjFELA0g9ckmBoqVSCRdp3tV3Zs
P2ZDlIALP2b65I8+EqEMg1TxZHh46ExJSR3pJ/Ik9lJ0gykfGaLnhemEl2Pa
eZWTYQp/BCnz0CoBZKtNyB7/4+xDh1pABUDT1joUT5LXeFcq4oFbPKR4oJnl
BtKzCFrjrZbxhENMDFVUNAMLaP3Hn9698NbfLkV7xEAnzrHvYn10uQiIZZgc
vhIBtQyYfvug+MBeap4+dRWqEs/BMTt3Zo2NnsN8cO9aW+aXpj10vJhaWnK2
ouycV0wIDRQC1IXJfb5SEuUqL9RUC46ms2i5EoMfPXrqjQNFmBGYO3CgEOCZ
wgabtGXzEQ/VfHyONJNaCBcQNMSVEa++94dGoPal4YOCHSWzwzNoip7QpHiO
UQvyI3wrkkaOISY+99lm6Dm18P+8eI6MgXH2/DsvbTliYTg1ns1ZEgY+YmqJ
owOnMFB5WePuXTlAyInj85UVzeROCzLKAvDDOeBMgHyB31w8fGETPpj7Jx6v
I7ZEqsg3D1gWWnSFFywjsvwlgaqlZRDLReOc7BKoX6Dq4oXbMoiX6uYUAjNZ
cwnQ2bmajI1f7Zkcv22yu69OeUh0ha8fwZUBsEhVG3CP2+JDh0EurP7K5bvC
rWsENyLCJlgCtCwBc6x97OB3v/u3S+BQkclUb8Bp+AcPebWkRc4b19/DYuGS
gNdAtprq9saGPoxgyt/Dok3MOfDaUp2mKirIrzp8uBO4y84chOqzIfPRK54M
m7jJZqzpA5HJPaAl0AnW3bMnt6S4Ds/h6/b12l5JqkAkJsz0qgQi6mr2Saus
bMZIQNLhms6ennE8u37tb579QhvUS+A/LZ87P/Kdt//u+fUdC9rtE73h9RrA
eLBEABmr27Ztd11tN8CEZ4PfFo5SvXxseOMrvNRUrFDbNTV5CR3z8irBAUlY
RSAkJIblAhEXCWW8fLi6l4yJnet/CCoIfpGpWmR5Fy7cLiyI4Brr+avX9vf2
ToI6Y6NnfSAXS+EH+S8IXkRrUQjQBY0zMw/BI0cDcAq6EHLhsiit/+PisJCw
gmXnlIkn8X0cq40lTE5cyj1YAaYH7Pv35Y+NncfqZFExkZto3aj/ZuJmteBG
oBcpBj7z86qAZKBt9vzb0idNZjJx4nDDPxceJD5ZzSQGKNDbM75/PwKkdvB6
Tk4phdFSYXZGSPw7ww4HBWbiJN2EBNBXVrQAaEwyfmzWtV4rhQF9+WDuzbtr
H89VfPAfLFgS5YQXRf8VFy/ceWLtbix+eGgGgQk1gdgsIweSKtGKrMuA2gcn
hhSEmpqOQHlgBACKi4Cl80yeitIfWKiv60HEB4yWl06q/JQN/2Lo71Y5fXVA
2s9//r8QkFINWHbSobbox8RY8YN7RXv78NGBk1h/dXV7eXmjFfQYUYEPB+AW
ihHqgbNv2zo8NXk78BvLxECimqy+Xw38tjTNLxjRgunwWe5gXNwYPpnS+idP
zOPVoaKa/PwqSoUYUwP6D4qWxCtcO0a+a6y0pB5tgBJpcPHC3RfWd8J/DPz6
4jBhWAa34uoL/8PALnC8EMcjNC2+Fykm1AQQSIR7g+gHaLl29YcgKdmEitDK
pJj8vxKvEfgBa7CJGILdTLxAZcEDWyT8ruemeWAN8AZuh10xfSiT3l7ATc23
hivGkpqb+gEbup2ZuWnBxoHkIRHnyLZw+fDQGZhV05lyssYiRgs6yBg8ev3X
LLgS+3EaztVi1Xz9YVmFyctrRG/D2BcX14LIWEt1pC0BbHzowGZSs6KiGcOh
/7GxWWmRLvoFY6A1Zxs8OvPM54ru3Pnpry6anh54o36rGS+GLC/ZgVM0FtbW
0NALYDo7RhHQWkbHtERx4SQUmAcOA6B1ctnSQjPKEcqKbj0AJgZ5z565g/gI
zPiJ5cP820wlLsQWgUxeFjKp1HnfFPgA1h0ODfHuC6hpeywOJnILC6vLShuA
VbwCmCKcrvSHzcJLYUF1e/sQvQKw447tx2BtAv9+WTDrnVEPf/PlwcGBmwtG
DGGqI64eK4DZ3LUrGxd4K5rZqIbF+FgChk1lWF7gYGT4DK6JHjM2SZcxqC3A
RKACRuKETmyvy0pq6f9u+VCvkZKMKcScHsYWtIEqwQq0E+dItqlRP+TrXXkF
WiVuK1sQlxKbdOfJ0SJJIrlog2Gzs0rJ6XiOW7Qh3NWR2fy8U2rx/3ZJWlr7
bA+YWlrIB6983958rBTram0ZNB2nBN7UJ3w5GpTNz68EudBUFD0aQDoJDtAK
XiGiAGxNdQemBPXxHEMTP3iLEWiV8eQbX68sKjzlgTexttbwrhDPA1QqLq7D
MgFLpKqNYxt+Qsj0E6L0Fb1q0ffIkROgINph/exmsrvhvUalFuOUltQhxKUt
B0IxNwcEjHr628QbIhKsGwL98WVxtoY8bX7u3Q1/3o6pseycnDJyqamtQ2KV
zKf+HC2kPnF8HhIBE4vn6CziSygpvcJX+OnvOw6nHFhEMw6i26SI4sPPpUvf
Q3g0M309IJINfab8sI8tC369oyr01GcKurvUMk3NEhILZWokf28pRpOVlzWC
TQHi6VNXXbuuYjD2FxtBGVa7kH4QCKIDnEwM6eSHRYoEX6A7up45c5PSERB9
vmXzEZjtwK8sH/4HTM3m60aB/AyrDG5Ns6h/5fJd4K6oqAZs62TPTE9DhNpk
BVwTW3hlCTUwADyRAxAUwndnd/I/kONg4NTJ761fH5kYvxn45SXpOLURIrAS
gvPE43XUcff1Gz9k6XU2RWiEAIlwmi5HAgmnPYRqcTVKhiXhlG1e9GufweEz
KniJ/xobBmGLS0vOKov+0SXpPA1/mtRm4vmTcaIDLGLgiFIX0GxNjf1kDjM6
IKCOjTa96e6u8fKyJkJgSPnD4jK52BtoaurnzBhLkEPU9fVONTb0k1ewfnhx
s+ffsXfiLU4CyAfvvfcPz36hbZF84HA+FofYCPEHOH8h1ot/0ITYtNo0VZpy
/YdrOv2sdoqZagYO6ut7RN5TuQwRkoryJhgVSJF+mwxZeGnLEURlcEo/vCxs
pMfnCpOiKcIVWDW8D9wCpoBouRjJF+VhSjiu83IrwC64xTUuOItoCs4DJILc
FAc044WDC0yNpgCeRoTchw5BjYtI1cyTa7MRpMI42Hs4H1K/kvECgCKMB7Zs
2UmAnTCaP/MnzSavUDtYKQWsBJDDUSSvmyrQDEiMLE5YqAuW6WgfFu2ANnhi
aQdeQy8KXwb5LqobgRuECZLpysB7MCaRtqAD0MmJy/l5p8H6MAFKh3zIgniN
hhiYAiLRClwBnxIMFh9f7pmewEpfLhJjjoudO7M6O0cDzLgDIaa6dOJwCTBi
tUUYuD5UdNjc/UMITV+B/AKPgfhCm6gepd9MFgUyIMcIt2ll2SIZy8AkHe0j
iCioCefnfgQrCSwAFyoLap+x0OcXQtAkABytgFf0cCjx3Jdab918TzX4cEKt
nJGIw9IO13SplSpdccs3GlplRkOmp0G9g1dAbXPzAK6JR6+fwfUCa3v25MLb
cPS92C0OhwmPDpwUNxhvQT7hu9CN6+8VFERYs1GbezjXxQt33zgw+keP7ofD
OjV5G+xmn8LQpyXCeIHX39o28ugju0oOKSSSIhgJNMw72PT8+vp4u675D//z
Oxlm5yA1p6ZFqmaLi2aEU+fn7gCPCMJgoWO9t4fFA4in1+bmfgCLANvIgqmp
16Iejc7Ihyit8GVNrRYUY+fc1+iUrXISaUsxHAYiqzI2ZFkE60ZXakZyAXzj
bVuH1z1RL/he4cdtKs4bHXkLbjSaogNcSjNawwXNPOZj8tfeIU/c++b1E57m
0Kt5CMsCr4M3MF1ry9HMzEOcWiKDeIrTtLdhCgFdS/R090CkgD+BXUtzOjas
v/94WVmDRJoUkRjbgqdkfOokXNO24OJwTUdBfhUG5vxYGKt0x46dB9+7z1Mh
wyTDH/z+3q//RR8YDQiEirBPcug4LBV+PCgB9bFpY8ej/y3r9dfGOtuvYAjO
AejqantACdADFMKU5JDZ83eeWlf6s5/9z4Bt85dLGX3OZiVMwmvf7uVOkxat
MyxdvihNjSXDBpmlSfF4uQlAsI/fJFFb67ASEF+blgZ6weWBZApRgXi0EAlJ
hvjU1/VQHjS9Qlgu9CYCR50pvqELhNqXhnU+euQ6ZB8Ugsp+9JHIN77ev/lr
jYEgdDzPhwAr7vmQd9TTQOrX/nvD5q/1oy16gESwcYNHr2MkPWqYUSTWsHt3
TkfHqEulkIjSt7/Voob5p9BKNdA0Sof0rH3s4NTkzYXYwMrIVqwyY2zLJuAa
b9GytfWo2ATRcbE2IQX0gdfa2jpIkQGJ0Dcal4CalFyQBNhubhrAa9Fj6ZgK
qwMHSOyE8ZhycPVWWGoWWAIQqmbGTSAoJp2UQ9Q/k5OtDGwgCb/0+RWFI55u
gQccVK+CWW80d3dd0CyhR1fh88wNagqMjt9JihnSZXSaMYqWFL0fumfWNpcu
SzwBKDupYqyJeMlAmfg/pjW5cOE2zPCEjiTMkNKKGKTkj15gfTh8GMSRH5De
tCfKNmBaxOiykRGjurRXNhYj7dubPzw0TdkRKoGaCNRJgVRMBGxhoAP7C0pK
6tAHw4lGkgiKmFfYYHKP9ysk2UdwgQMMUFRUk5VZTJRgGZy9pqZjbPQc9Cq6
KJhI//LSyVf/sl0h1vbsl6vxtCeyUnYULcrmUMbA13iNRbryltDmAM6RkbN8
BHmNsfwYD4OLBxrEDUKkqOXHFRZFy09ubWsbwqyUY6FWQUF1YWE1mqmITOM7
DWJ78sQ8uETVveu6QUz0qapshZgq1kQzAEkiYYCgepIOUGtru2Dm0JR9QBoM
MX5sFk/0uCGsGPPk5JRWVbWoEYLuU7AUpnphfeuN638dh0ZxTxTZVFHe8PPr
O+ghmLmUOBYnORJpKy2pJ5JE1uwMC1ZI5w3XB3PKRJMFbU+AegtUIlkvXriN
W9eypFBlmNVHHQerUuUKKlomx65d/SGa4jHVGlAEauK5xmMy5kTjsrJGBH3J
qm+y2q8VCGRnl6CN2tKq8+owwpWVLWgpuF4jW9lErQFIzHTl8l1JyDLCxHPy
8+T47Y1f7YlDFTse4Z5JqestxERb6ZY1QVSCWUY1f98vwkixojMQUCp3Hpuv
6gDNAxXlTSQZZsMwGDhq84GR4kO1UCGYl1xIqEErKK3hoZkYvYVV5uVW5h4s
B3egnattjD2gvnorKDsIHd7g/iEMAteiqLCGugtTcAWYpadnAuxBNDm6Cx2e
fy7vSP9lZiHixtA6unxYKshmvGFagtOnr+3Ynnnq5GU+p9O6YMR8xLZoZM0P
b2O9gt0UBsZ8J3bcwSusfWNjP0M/0hz9aMeFt0F2TEv+IuS4QBBUWdkMsVL6
TWMvAy1wD2xhYdWRdvThbVFhNYZQes/Guh4tA7NAe5WXNaEtVoLZuT0Kt709
44prkl2K4zVEPzu7VCfVNf+RZmh+8sQtWHQ4TA/e85wMsaP4sJkPNHUODQDj
6Onpa27mJoHON2O906eukkDRWI95nRjbDG4levHasM0h2mZwQVNjn3Jc9NMH
RNuauSdMR8NOu00h5S4ZYgWDosHQ4PSOHZnUSkGELa7eQcDpPgnjSXv78Ot/
dQBwYEEujVeKG4cZMQWa6X02l1nW4GJEF4a4ggWdrVX1OTvP5K99tAwkt7bM
wzBHfSdNbkBSXFzr7lvNMPnb1PQiEg6v4wUYSWK+mFoKaRu1vwjiD+wvjOoY
0/66+dYre/fmmZxPagBkxCgSaShdB2zjaXl5U+YbxVissi/kdtlnzXvHEh8d
OIlZQrpFdCdf0OU1jAC/MFLVymJA1PZOjF8EybkE0Tkql9XaMvz0Z3K/8/bf
rVkU5nWrdKnzL+jIAVKo2P70NQ5OiRAf1le/mzEdmNrBLNbrrM+ysfR9aWMx
ql59umtjlbvKZsLzylvRcEMBghJgQnCBaJx0eGWMlbFsHgGEAAF3cG7hOoUt
baOxnd4EZ27sHNaKbspLqmpFZ1zDqZ6avJTs6jewPNwjzAlt6mgaPMWS0Brg
8ATXEnC92vRyQMWdO7IxsuWriNvv2EWT63X0NyDRWSDJjbSDzCeLxlDWtK11
CGIgET1oiBaKi8SaUlC6u8eDrpYBJkFcc9cKmqk0k9YyeEIZZ/RITsUTIvLQ
ocMHD5YBl0q/aA8nSDWjL9WvFIgy3iMCKCtrIJWEfx8wD4hT12BS8D0gMzcE
Y2o8d2cPbtrYdurkguj0uJZW2+HViPA3bVTKEjPBHEm+3Sxq+Wn2BTfqqq/v
ieoZy6ZiZZLRSGbpz9AjSvOAw8XqKk0PMwbfG42isk056OwYPVRUo7SU6BZ0
VDq8tgvqakIH2OTlZImzMIj284NULfpS+/3mHhPdJwW9x0bP7t9XAIJg1Bjt
grkOFR2mWyXaLQSWAHyFBe0vbupUNYSYUxoebtfYDhcVju7Y3kX8GBnulAS6
OwhoJicu6V2ACsQUqhfRPNw44GgU7RtMQGBJhVhLmkG+YR3EPGtMPhbchkAp
RGDcgqfsAP2Y6dPXwaN4R08Ey8BsQAd9AIVWX82SQRcdrRjv0gtivhKmTKI1
R7tg1ry8ipHhMw6dmWEUReiceo3P2eZT7euHxZdccPdVEhsiXWIT6VoCD1lZ
xcNYgURGMfYSYMTYy8mJi7t3HxStnsz2pr0E7PV13ZmZhxCe0Js0E8ycVfZ2
qihDbccPgiTUVNH6Ygr6YSJSGZO88sr2yopm+hphCht/gANoxaDeAa+Kah0j
+Ckprtu6dRe6MaJlBEBvytxpz6Q6NQ3WY355BPQx8ovBuTfvPrm24Mc/ft+D
+QT0SHn//Z9D4589c8er2WP8mTd1jHTl8h3ZKWVb0mhNVCwp4wUoMrzGYFyn
XafBlN1d44AE+BE6hlhYUEq2ZVBhVXNlCvifbq9izNxKrE5Jpub0EBQ3OmFu
HvkOaHwHiXut97SmxLxsgmBY7Q4Nu+P29U7m51VR33AznSMJsEBNjf1YHygg
sh2Sekd+3qDagbw4nOvv9qTcufNT4Jx+vSR5orkZqdlDxsH7wsvqndDD2oGS
Rj6vqW6XDWxoakanGazZgNu4I4iNgJMo5qlv4GPwMBrWIVjImJ+7A03Q2zuJ
F0A+hqFxZIVJnahMsfSNxmwGT/iSMJL7Af37+45Dq4EIDpZ5BgjvykobWluH
opEyV8gaHp4BcfAf7ZpdrC3VtSHY/XfgOhLLxJbgIoWah5aU6lw4T0WpcSNR
XJWWNgB402oyEnW8XOgjRDP90RYfFBiO6cNDcugHaGMZBf3xyruzLRWtMRxd
QOARVu+NN4pU3ktpIK2qxZJiGeqpPlm3e3cODDc5OTYnGt33BYbTmQ6l29Kx
erSQ7XO44MIwoKuTlP/WUDfx+T8tkW+8+VtW4l7ODywYdRUHv+1tQ4hLzO08
CWNRFpoZ1wIbLPeSoxmLmqfKEC1h0XRjorIqFMC88FwcXYK52VYdqSlrBB5V
D1pNODBtrYMaxQrXOhsmviJWqHGtnBcMqooD1CKYp7NjLBJpI1GBVrHXamdB
XW0PKI+nwmthkzde/csBoM3+tqK/HtGV57Cc/hb9rHcxBIGRxoY+4DKOzQSz
cHuyYH0eNlN0iRNjstpKTDM+PDpwSjY8if6Lqa7jCl4E0AxwabA09KkY8eDB
8sbGfrAxXkG+uFeG84vO8/gs+j7V1InMGdAJSVIKPAhed87diX+I1kpN1XZj
MdE6G1aKTtR1eqS7X/x8q/IV7S/6+eNc7zbJkA/9cC2trUclR+9jE6PRJXdy
kFElihWbyG06igLUIjU1HTBvRC21CPFNzsb6pXDJnUcMRvCKWsQ8464y9sAm
PUXYSLzIzi5pauqnv+jNvOsnvwyuRgMgOFf7noxAMQjacA5z/zmeoDFjMBDL
OXyuXQDacSkWB6TCg6ebNhY21M8uDvu/pPWKfAgLw4LLEO1E9bZlHWOiTVKj
WQNtWkdZUbpYR1ww2oJ7SIxLBRdwkecLC6vhZ0b1CNvhB64G94o7Pgl6VFer
Pc10EgPevLp+EsK8aAGrUVfbpdZEOcA4uEc0TT2tHBonruZ64JfDGjEykPgo
LK7s5fkfsnpo77iItZZ6z27Kvr2TjfUX6cYxhhDcOBZR9t3ExJFgRHCqZRGJ
tKhFxH1FeZNbKUxmNc+IktWugoL8KrhZwLulNyDeYD4JUsh/lBo5ceevN4IU
A3VJGQRo1B2MmUpK6nj4mJVZTIq3OrPZD1cHronss7D2OnS0zW99tVcnpxLa
Qu4FhobZsrm2JjLjaAZyV4zNi6mNklVYR6cHYNZGudWAzoyb/7sMfjR3GkgW
gplQer4pVFhUFtQ9sobo19MERcADk1Xd3ccQK2EVUAvoELIwrXG3CovBazza
vy8fvMBMlxBMMp3yRSr68TxWjTZmPodZY+Z53MyaQ4Nnv1g+P/duxqL0xa+4
uAdjq50OYgmplqKWMIYWAHPv3jw4yDHRI2RJKg/U41Bet9zTLx5uDjE+qq/r
yc4quXDhtlP5R09qD+39TlVH2rTHrGoDY6Pn8vOUEAHfaKBCGQ0LVIROiOsc
OGs4LHVOjF/EcOwPh7m3d4L6h4lHqYtmZRYz9y5V67Dk0MBaLML54zP+LjZ9
71Mn1Wc/UhALiX20Kmip9Pbke11Dg9MUd9sGio1gQb6zc5RcYOY2HV03NVdR
0cRDMnToRW8A/QX5EUm4Yly37hCUINoTs/C+I/r1ngXHD0cXyeDm5JR1tI9Y
egOAYfVlZQ0uFyR78sPBFzc1jY1eU2hK88W5vWPA/gK4/f7faIyDu8ULlB2l
0R2mAKan+5gcBFT71rWyduweFic7+ejWVZQ3trcPG/X8VbQH3Hu2YGwlx290
ZLmXWluPuVLwx5gP7dEG2GG5rLVlEBRVnrFvxKhqOk2NfVgzi3SMN3Ue7U3z
EJSjuaSqQU1i1p8ALXMN3tpIU+Pw+i+1qRM7y6eEutUnvFLghyPakXge+JWT
C4pns7NLETeLfeTnk8Q+OtV7umhypoJZpDQCLN4msF1e3gRVIXF5iln4gk+C
10rjh1yryspw8aFacKbymLVmYb5Q5zB9suCsuAFJhYURtGR12tX8KsbBHJJx
Z13PiXHm5n4AjceMsdQ+UxghS23Q+XpFyr1EO5rux/k8QYlwiRG+I6dYFaa5
cvkOzaOv5WRKRCoMba3De/bkuvV65frGVpHD/f3HEUtRw3BPEDWMatk+tGf3
QbA2+ZrJENbTREQcu8JMoaarTwY82eULSmk090HqUX527Mjs6hpztXuYewhc
+VBfhhAIGKK6EARnpt9a9+TBd9/9H54vd/vzuvsNflu/86zu7Pl3Nnyl5+yZ
O9H9QjnZpSNufjaZ0b6ZOYhmSBiNA8FgVEEzoV0lNUtc3DLO8aK3uaXElaKV
4iwQR5LHpq+NQSormtXoqX4afuW5s7fglzPGwfA8IkEy0lBweEfHUMPLdkDZ
UoNFLrhpfXP/E2NxpZMOT+/YfmwJeE90r8+Hp/JrRSyIKgZoH+F5E7GZDMS8
9XqQSHboO7YJ91K7VF+S1BtSEHpKLKH2lnB7ldRhwG4AL+TacyyB/uprr+2L
VLVBdWAqHdOE9Yn/85J/BUb1c/V1FDSLVLWCoxn3gA6QyZCrz1pbjkqSF/pF
RXHUL1hsSXEdPAIsSDgnWbxdtxochFKYPv19Pz2y+O9g6C8QqNM5GCw/d1zl
VpRiVbmKmCqltx6P9ezYngnCiPdKjW/4s6Ha2m5mQp29wIQdAPT1Tm3duosG
j1UBvgtJLLOgw23umAujiYljoE0/D0lJiulX4i9V6hWAAC9e+/bewcFT4BRq
FObX8ArzwOlvbR0KuhId69+qCKbkULfKBdrf1fH3xfl1jv37+v/ipZ7oaRQr
TkwXO7jg1gLFVxUPinGA5mO1eSGNmxYW9PkTYAxAyfYn58wIXQF6cKx3STGd
Cezp09e1qbX0hNYbK/UHZN+mG2PV2qgnzBxPWO8RuizrcOPdMPdOsKpoxGlh
1izJuSyl+fOrG6nziz9gbYT16ouDcSLCEKt08LMipD7bmRuLyYVMp2a+caiz
Y1Ty/6m33BPIVImQeTAlfms+TOO+D+ak8/OrduzIYlyiPLKQ3hejKKrNm+qj
nqSx5oV2r79+ANJLh5wJQIfz0Wxg4KRIPTcnOlKPlbW1DuZklzgZHZMrWYkk
P128cPfLL7So+pdrwfyjco3F5J/85B+3bD6CUMU92RCUyM6ZAVYVfhO5T3Sp
WSeMUr2yogXwysJDrt8Dltm2bTciPUl4OnkhZjQZNWv515hTJ8O0K4Z+IaNa
JQViJ89MGoBCJSV1O3dksTTp+HwYjaSD48LvV4pdjs1mJfNzEa++UlmQf9y2
9f5yzO/PId6ABRL+C0oWnhXxMDdkmdym261mzo9IQkPzgCulRnalCs+uotbj
CRiRP3G35AAh+vjK7yrZk44JTUeBCgBsjtUx9yH5a3MPK66ZAaNrDizjlZXz
TpG96ayJs0DlsSf+GNXfZUy+c+en4EUEcXLKjLyYl1vh2rQo78XU6uh7bH/9
jQmdkLD3l/KAAa65B4H7sGW/KGUS6nD3roO1tV36XKKua9DwyP4Mw1tV1kXX
VdMwbmVl84H9BUz0mC6wY20w/6mTl02FaO5LxQXG3LUrm5u5HJmTLLdUtVua
Lr78cptG26Iwyi/oIiKDjuzrcb7QEALxWJaJqTHb9U/yAJBTX9dDn4fenlhP
LBRPdu3MhsCTf0B8RrEV5U3T09d0zUXjkLZGdhYZMZbyglibRv/jU2+qIkaK
y0ms95WVNiAqcbSgyDXPdqk9X4e73NpJtA4dU/GSp1/5ch089gS4U3pSf0U/
AxrxW9tGXtoCi3eHG8nN6pTgZxWfUo5pweQworW7XONtpf4W/i0qLAnmyWJy
hFx9AzbdV4L5csE9kW9WkekJYODp01fVDnVXy5BKEjLcMj4FwMwc+prYSuOJ
ZMEhgpsX1qtNRAot8e3IJ7XsArvrnija/nqna0ecaqNVgwwTO/V13VDYXJQl
qyIi3MlMnjP9Fu5Na2joBWtwB6rsZXCjQnvXcjKP+bM+rPukYvqmxiPcBGfW
hzmf9u6/aykPkVks+vjxOTi39Ub+IlpdZVLUsQpQZYgTtZVYlNyq70QEQn//
9z+DeXnmT5orys5JXB/D41E5xdK7u8ZFKFwcRP2XrMxieBsCoZax0NjYucM1
ndyXo0/RaOlkaUwlPpKs3Ct3JIMglGZ1plPLLoKdqalLeiF6VpFdRMOIosSQ
0bfmrnDKTKfeXyKQeSUsBMjhmAALwIWqTy4Og7/n+jWlJWfZN+hGr8Qefs/p
8x6ys8rank37ACjHj816pUz5GNTJ0ZNVttXlvez4c+TLV2iHBtUmR6d+QF9J
tm9TL/AjXfhN80oUCYbAIYRSZfEWZ21/38VQdtZJ9O1svyIcjAUV5FcVFlYr
W0Q8mJlFISdLnk5NWWjOvHDMiSbmeQiInsTClOaaFdRo5iknRsemZHIuphvM
eJy+ebTuR74H25aV1hsaJrk6MgtgwRQAPHF88YcaP++99w87th+DG+NyUBjg
jY2eA9lkazNzjxLvwE/Oyip24tUU17uU00TcfU/9xR+l7227qFrpSkcK+cA8
a6TynbSR5KUD+wvLShslJeRUWGTPosrADs7Il7LALURCQf60+maCG/P76/X/
qn6F4cOBS55a11hcNDMzvSDftLO2G7vRc9rw0AwgtSJMOgjOHvvouZ6QSy/q
ZoU07WEpb4veRPSMjy+nkT3aWofcgwhaw1ibkrlePDkz812CAvBB3PRFycoj
Wh8DW5Gq2U/9Ue5LW5qUNyWSYSZomOl06mo8LSMRCrDE1JF9ysbXX7dP2dDq
eTVQGvHjzU4paWDUiNVu2ljz6U8VtLbMKw0RvwZuPn1U0x46F4YLzhBYBor4
1Mkov2MO/T22VhhhZ0Vh14fAoqzjLM5e81CcfJh+nibtzBMudI6ceE8lbY6d
h9sJy2XxfAiLI3GxXPVN3Pg748ynn9Jwghkg4/B14CtjkMnx26QvooW62m6L
26iMPOdFZLeLGTH45KVC+rnoQ/xQtyfH5++a6vYzMzcd/gZB9u+bAkGwXJAU
jJl4P/1j6i4NkRUab/xqDzoivmLalObJyTpZtom5HTmdkWFxqfZRo6czKO6W
kQw6OHRsJKwMZgaBEOJ1d10FzvVZi/j6Z636lYJ2CGK++fLgE4/XfenPcspK
T4E8UV+DeTzzUIM6haQ1quw85g5Ybz4mQ/YgQw2bxx2owGX/SQpwXpg/+WfP
HsQaYBKwHqU97b89SbzH+2vddmZhnaYLJPJI/2XoI5Dm05+qeXFTH+QMIquy
g9apAaXJNGOBAWPg8mRLUsQfpstPAgXcvNVdUAJcjrkefSQCYsAijgxfU7oh
8XdcjJuEp7c/q36tgO6Yn3sXYgV5BNogWdu2DgM4TA50Ml3oy1XOznw0QlN0
AOnBtOAbYB48rD4D8THfdS79nPnnNYdBNqAwsFJMAHR88ne2r32sRv+dz2RM
H4Ks6D71tcf1pf4FEuFdzDcPUh77dOXvfnI3RsA4GG369PcVj9vfOOVaPX+f
13etqsFzuiWow+9eBJIxdAg40b03f61dX+pfQDTe6T0e7vcygvwTamqIT9wz
64yLmz/2yVL/Fuu/3N9qTUzV+/3dXF/Y/xXv//96fO7j/V3jON8piP5da5+/
i/2B/w3KgPOK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51439851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433486400],

Cell["The same idea applies to 3D surfaces:", "ExampleText",
 CellID->54359028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2951893],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1WmtwldUVjbyEEmSKQxUojwwUaJjWERQH0Gyl1AJSoyAG0FGk4DiVR0UL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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmQn4l1MWx+9LEVoIJZW0TAuKJLtRokSNkBRJaUclJJQWpZASWVpoIXtU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        "]]]}, {}, {}, {}}, 
    {Hue[0.67, 0.6, 0.6], 
     Line3DBox[{414, 1, 377, 237, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
      166, 181, 196, 309, 425, 211, 412, 348, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 223, 224, 311, 426, 225, 413, 349, 210, 195, 
      180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 239, 415, 15, 392, 
      313, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 312, 414}]}},
   VertexNormals->CompressedData["
1:eJx1WHtYjVkX74KRIZeQMCoUQmgooXe5jpiiSRehXCZKisklREU0I0RCiDFy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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94293763,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{"p_List", ",", "rest__"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RotationTransform", "[", 
       RowBox[{
        RowBox[{"Pi", "/", "4"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], "[", "p", "]"}], 
     ",", "rest"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19101537],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->644752796]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30301],

Cell["Set up a graphics complex with shared coordinates:", "ExampleText",
 CellID->593526080],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sqrt", "[", "3", "]"}], ",", 
         RowBox[{
          RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}]}], "}"}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Point", "[", "1", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365030740],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will split a complex into primitives with duplicated coordinates:"
}], "ExampleText",
 CellID->660392801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352416049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], "}"}], ",", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SqrtBox["3"], ",", 
        FractionBox[
         SqrtBox["3"], "2"]}], "}"}]}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{315, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91382839]
}, Open  ]],

Cell["Both forms produce the same image:", "ExampleText",
 CellID->178073185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", "g", "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Normal", "[", "g", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93781147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[
     NCache[{{0, 0}, {3^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{
       0, 0}, {1.7320508075688772`, 0.8660254037844386}}], {PointBox[1], 
      LineBox[{1, 2}]}]], ",", 
   GraphicsBox[{PointBox[{0, 0}], 
     LineBox[NCache[{{0, 0}, {
        3^Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0, 0}, {
        1.7320508075688772`, 0.8660254037844386}}]]}]}], "}"}]], "Output",
 ImageSize->{230, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->471423238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125364875],

Cell[TextData[{
 "Graphics complexes can be built up from integrated ",
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->651056669],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<SnubCube\>\"", ",", "\"\<VertexCoordinates\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96200338],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<SnubCube\>\"", ",", "\"\<FaceIndices\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6015805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{"v", ",", 
    RowBox[{"Polygon", "[", "i", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->80497603],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->256702322]
}, Open  ]],

Cell["Or, get a graphics complex directly:", "ExampleText",
 CellID->840963975],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<SnubCube\>\"", ",", "\"\<Faces\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->121761124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "g", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->53036109],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[5]=",
 CellID->253257553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "g", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->832806256],

Cell[BoxData["GraphicsComplex"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->539220545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16818839],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 " contains number of 3D graphics complex models:"
}], "ExampleText",
 CellID->618125448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"ExampleData", "[", "\"\<Geometry3D\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83315880],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Beethoven\"\>", ",", "\<\"CastleWall\"\>", ",", "\<\"Cow\"\>",
     ",", "\<\"Deimos\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "16", "\[RightSkeleton]"}], 
    ",", "\<\"Volkswagen\"\>", ",", "\<\"Wrench\"\>", 
    ",", "\<\"Zeppelin\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->311915028]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Geometry3D\>\"", ",", "\"\<Teapot\>\""}], "}"}], ",", 
     "\"\<GraphicsComplex\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208143391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->105011545],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->532752292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->251770005],

Cell[TextData[{
 "Many ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " formats produce ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148433934],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<ExampleData/bunny.noff.gz\>\"", ",", "\"\<GraphicsComplex\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153449872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "]"}], ",", "g"}], "}"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95063523],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->2246270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49169055],

Cell[BoxData["GraphicsComplex"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->280784546]
}, Open  ]],

Cell["In this case the surface has about 35k vertices:", "ExampleText",
 CellID->220413326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"First", "[", "g", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->154607217],

Cell[BoxData["34834"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->92805538]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20523],

Cell["A random selection of index coordinates: ", "ExampleText",
 CellID->636441424],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", 
         RowBox[{"Pi", "/", "70"}], " ", "k"}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", 
         RowBox[{"Pi", "/", "70"}], " ", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "70"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->715442954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{"p", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"RandomSample", "[", 
      RowBox[{
       RowBox[{"Range", "[", "70", "]"}], ",", "70"}], "]"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->718269586],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[
   NCache[{{Cos[Rational[1, 35] Pi], Sin[Rational[1, 35] Pi]}, {
     Cos[Rational[2, 35] Pi], Sin[Rational[2, 35] Pi]}, {
     Cos[Rational[3, 35] Pi], Sin[Rational[3, 35] Pi]}, {
     Cos[Rational[4, 35] Pi], Sin[Rational[4, 35] Pi]}, {
     Cos[Rational[1, 7] Pi], Sin[Rational[1, 7] Pi]}, {
     Cos[Rational[6, 35] Pi], Sin[Rational[6, 35] Pi]}, {
     Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
     Cos[Rational[8, 35] Pi], Sin[Rational[8, 35] Pi]}, {
     Sin[Rational[17, 70] Pi], Cos[Rational[17, 70] Pi]}, {
     Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {
     Sin[Rational[13, 70] Pi], Cos[Rational[13, 70] Pi]}, {
     Sin[Rational[11, 70] Pi], Cos[Rational[11, 70] Pi]}, {
     Sin[Rational[9, 70] Pi], Cos[Rational[9, 70] Pi]}, {
     Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
     Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {
     Sin[Rational[3, 70] Pi], Cos[Rational[3, 70] Pi]}, {
     Sin[Rational[1, 70] Pi], Cos[Rational[1, 70] Pi]}, {-
      Sin[Rational[1, 70] Pi], Cos[Rational[1, 70] Pi]}, {-
      Sin[Rational[3, 70] Pi], Cos[Rational[3, 70] Pi]}, {-
      Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {
     Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-
      Sin[Rational[9, 70] Pi], Cos[Rational[9, 70] Pi]}, {-
      Sin[Rational[11, 70] Pi], Cos[Rational[11, 70] Pi]}, {-
      Sin[Rational[13, 70] Pi], Cos[Rational[13, 70] Pi]}, {-
      Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {-
      Sin[Rational[17, 70] Pi], Cos[Rational[17, 70] Pi]}, {-
      Cos[Rational[8, 35] Pi], Sin[Rational[8, 35] Pi]}, {
     Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-
      Cos[Rational[6, 35] Pi], Sin[Rational[6, 35] Pi]}, {-
      Cos[Rational[1, 7] Pi], Sin[Rational[1, 7] Pi]}, {-
      Cos[Rational[4, 35] Pi], Sin[Rational[4, 35] Pi]}, {-
      Cos[Rational[3, 35] Pi], Sin[Rational[3, 35] Pi]}, {-
      Cos[Rational[2, 35] Pi], Sin[Rational[2, 35] Pi]}, {-
      Cos[Rational[1, 35] Pi], Sin[Rational[1, 35] Pi]}, {-1, 
     0}, {-Cos[Rational[1, 35] Pi], -Sin[Rational[1, 35] Pi]}, {-
      Cos[Rational[2, 35] Pi], -Sin[Rational[2, 35] Pi]}, {-
      Cos[Rational[3, 35] Pi], -Sin[Rational[3, 35] Pi]}, {-
      Cos[Rational[4, 35] Pi], -Sin[Rational[4, 35] Pi]}, {-
      Cos[Rational[1, 7] Pi], -Sin[Rational[1, 7] Pi]}, {-
      Cos[Rational[6, 35] Pi], -Sin[Rational[6, 35] Pi]}, {
     Rational[1, 4] (-1 - 5^
       Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {-Cos[Rational[8, 35] Pi], -
      Sin[Rational[8, 35] Pi]}, {-Sin[Rational[17, 70] Pi], -
      Cos[Rational[17, 70] Pi]}, {-Sin[Rational[3, 14] Pi], -
      Cos[Rational[3, 14] Pi]}, {-Sin[Rational[13, 70] Pi], -
      Cos[Rational[13, 70] Pi]}, {-Sin[Rational[11, 70] Pi], -
      Cos[Rational[11, 70] Pi]}, {-Sin[Rational[9, 70] Pi], -
      Cos[Rational[9, 70] Pi]}, {
     Rational[1, 4] (1 - 5^
       Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {-Sin[Rational[1, 14] Pi], -
      Cos[Rational[1, 14] Pi]}, {-Sin[Rational[3, 70] Pi], -
      Cos[Rational[3, 70] Pi]}, {-Sin[Rational[1, 70] Pi], -
      Cos[Rational[1, 70] Pi]}, {
     Sin[Rational[1, 70] Pi], -Cos[Rational[1, 70] Pi]}, {
     Sin[Rational[3, 70] Pi], -Cos[Rational[3, 70] Pi]}, {
     Sin[Rational[1, 14] Pi], -Cos[Rational[1, 14] Pi]}, {
     Rational[1, 4] (-1 + 
       5^Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {Sin[Rational[9, 70] Pi], -Cos[Rational[9, 70] Pi]}, {
     Sin[Rational[11, 70] Pi], -Cos[Rational[11, 70] Pi]}, {
     Sin[Rational[13, 70] Pi], -Cos[Rational[13, 70] Pi]}, {
     Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {
     Sin[Rational[17, 70] Pi], -Cos[Rational[17, 70] Pi]}, {
     Cos[Rational[8, 35] Pi], -Sin[Rational[8, 35] Pi]}, {
     Rational[1, 4] (1 + 
       5^Rational[1, 2]), -(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
     Cos[Rational[6, 35] Pi], -Sin[Rational[6, 35] Pi]}, {
     Cos[Rational[1, 7] Pi], -Sin[Rational[1, 7] Pi]}, {
     Cos[Rational[4, 35] Pi], -Sin[Rational[4, 35] Pi]}, {
     Cos[Rational[3, 35] Pi], -Sin[Rational[3, 35] Pi]}, {
     Cos[Rational[2, 35] Pi], -Sin[Rational[2, 35] Pi]}, {
     Cos[Rational[1, 35] Pi], -Sin[Rational[1, 35] Pi]}, {1, 0}}, {{
     0.9959742939952391, 0.0896393089034335}, {0.9839295885986297, 
     0.17855689479863665`}, {0.9639628606958532, 0.2660368455666751}, {
     0.9362348706397372, 0.3513748240813427}, {0.9009688679024191, 
     0.4338837391175581}, {0.8584487936018661, 0.5128992774059061}, {
     0.8090169943749475, 0.5877852522924731}, {0.753071466003611, 
     0.6579387259397126}, {0.6910626489868646, 0.7227948638273916}, {
     0.6234898018587335, 0.7818314824680298}, {0.5508969814521025, 
     0.8345732537213026}, {0.47386866247299864`, 0.880595531856738}, {
     0.39302503165392355`, 0.9195277725514507}, {0.30901699437494745`, 
     0.9510565162951535}, {0.2225209339563144, 0.9749279121818236}, {
     0.13423326581765546`, 0.9909497617679348}, {0.044864830350514924`, 
     0.9989930665413147}, {-0.044864830350514924`, 
     0.9989930665413147}, {-0.13423326581765546`, 
     0.9909497617679348}, {-0.2225209339563144, 
     0.9749279121818236}, {-0.30901699437494745`, 
     0.9510565162951535}, {-0.39302503165392355`, 
     0.9195277725514507}, {-0.47386866247299864`, 
     0.880595531856738}, {-0.5508969814521025, 
     0.8345732537213026}, {-0.6234898018587335, 
     0.7818314824680298}, {-0.6910626489868646, 
     0.7227948638273916}, {-0.753071466003611, 
     0.6579387259397126}, {-0.8090169943749475, 
     0.5877852522924731}, {-0.8584487936018661, 
     0.5128992774059061}, {-0.9009688679024191, 
     0.4338837391175581}, {-0.9362348706397372, 
     0.3513748240813427}, {-0.9639628606958532, 
     0.2660368455666751}, {-0.9839295885986297, 
     0.17855689479863665`}, {-0.9959742939952391, 0.0896393089034335}, {-1, 
     0}, {-0.9959742939952391, -0.0896393089034335}, {-0.9839295885986297, \
-0.17855689479863665`}, {-0.9639628606958532, -0.2660368455666751}, \
{-0.9362348706397372, -0.3513748240813427}, {-0.9009688679024191, \
-0.4338837391175581}, {-0.8584487936018661, -0.5128992774059061}, \
{-0.8090169943749475, -0.5877852522924731}, {-0.753071466003611, \
-0.6579387259397126}, {-0.6910626489868646, -0.7227948638273916}, \
{-0.6234898018587335, -0.7818314824680298}, {-0.5508969814521025, \
-0.8345732537213026}, {-0.47386866247299864`, -0.880595531856738}, \
{-0.39302503165392355`, -0.9195277725514507}, {-0.30901699437494745`, \
-0.9510565162951535}, {-0.2225209339563144, -0.9749279121818236}, \
{-0.13423326581765546`, -0.9909497617679348}, {-0.044864830350514924`, \
-0.9989930665413147}, {0.044864830350514924`, -0.9989930665413147}, {
     0.13423326581765546`, -0.9909497617679348}, {
     0.2225209339563144, -0.9749279121818236}, {
     0.30901699437494745`, -0.9510565162951535}, {
     0.39302503165392355`, -0.9195277725514507}, {
     0.47386866247299864`, -0.880595531856738}, {
     0.5508969814521025, -0.8345732537213026}, {
     0.6234898018587335, -0.7818314824680298}, {
     0.6910626489868646, -0.7227948638273916}, {
     0.753071466003611, -0.6579387259397126}, {
     0.8090169943749475, -0.5877852522924731}, {
     0.8584487936018661, -0.5128992774059061}, {
     0.9009688679024191, -0.4338837391175581}, {
     0.9362348706397372, -0.3513748240813427}, {
     0.9639628606958532, -0.2660368455666751}, {
     0.9839295885986297, -0.17855689479863665`}, {
     0.9959742939952391, -0.0896393089034335}, {1, 0}}], 
   PolygonBox[{13, 69, 15, 47, 35, 23, 17, 50, 37, 11, 8, 68, 66, 53, 30, 20, 
    52, 7, 60, 12, 5, 54, 64, 55, 43, 27, 65, 59, 33, 39, 1, 40, 61, 2, 45, 
    16, 56, 10, 48, 67, 24, 31, 3, 29, 70, 9, 41, 62, 25, 4, 32, 21, 49, 42, 
    34, 44, 57, 26, 18, 28, 51, 6, 38, 14, 63, 19, 46, 36, 22, 
    58}]]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133247999]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"2", 
            RowBox[{"Pi", "/", "25"}], " ", "k"}], "]"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", "/", "25"}], " ", "l"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", 
            RowBox[{"Pi", "/", "25"}], " ", "k"}], "]"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"Pi", "/", "25"}], " ", "l"}], "]"}]}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"Pi", "/", "25"}], " ", "l"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", "25"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->222044372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".8", "]"}], ",", 
     RowBox[{"EdgeForm", "[", 
      RowBox[{"Opacity", "[", ".3", "]"}], "]"}], ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{"p", ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "625"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"100", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
       RowBox[{"VertexColors", "\[Rule]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
          RowBox[{"{", "625", "}"}]}], "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->43849380],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->118444744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46463762],

Cell["Cows with random gradients:", "ExampleText",
 CellID->293325019],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Geometry3D\>\"", ",", "\"\<Cow\>\""}], "}"}], ",", 
     "\"\<GraphicsComplex\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451035718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", "=", 
        RowBox[{"ColorData", "[", 
         RowBox[{"RandomChoice", "[", 
          RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"EdgeForm", "[", "]"}], ",", 
          RowBox[{"g", "/.", 
           RowBox[{
            RowBox[{"GraphicsComplex", "[", 
             RowBox[{"v_", ",", "r__"}], "]"}], "\[RuleDelayed]", 
            RowBox[{"GraphicsComplex", "[", 
             RowBox[{"v", ",", "r", ",", 
              RowBox[{"VertexColors", "\[Rule]", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{"White", ",", "30"}], "]"}], ",", 
                    RowBox[{"f", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", ".5"}], "]"}]}], 
                   "}"}], "&"}], "/@", "v"}], ")"}]}]}], "]"}]}]}]}], "}"}], 
        ",", 
        RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"GrayLevel", "[", ".15", "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", "3", "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658509299],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{466, 403},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->420950916]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3360],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->751]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GraphicsComplex",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
GraphicsComplex"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->645706336],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout",
 CellID->79632535],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->303275895],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->407863466],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->148999781],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->21765692],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->499225149],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->83192593]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphicsComplex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 22.2079946}", "context" -> "System`", 
    "keywords" -> {
     "polygon mesh", "surface data", "surface graphics", "surface mesh", 
      "surface polygons", "surface triangulation", "line data", 
      "line graphics", "line mesh", "boundary representation", 
      "solid representation", "simplicial complex", "constructive geometry", 
      "surface topology", "combinatorial topology"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GraphicsComplex[{pt_1, pt_2, ...}, data] represents a graphics complex \
in which coordinates given as integers i in graphics primitives in data are \
taken to be pt_i. ", "synonyms" -> {"graphics complex"}, "title" -> 
    "GraphicsComplex", "type" -> "Symbol", "uri" -> "ref/GraphicsComplex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12699, 412, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->438479937]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 497333, 9425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2279, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2902, 76, 1580, 37, 70, "ObjectNameGrid"],
Cell[4485, 115, 1161, 37, 70, "Usage",
 CellID->9079]
}, Open  ]],
Cell[CellGroupData[{
Cell[5683, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6161, 174, 207, 7, 70, "Notes",
 CellID->32091],
Cell[6371, 183, 822, 30, 70, "Notes",
 CellID->3766],
Cell[7196, 215, 294, 8, 70, "Notes",
 CellID->5808],
Cell[7493, 225, 479, 17, 70, "Notes",
 CellID->12126],
Cell[7975, 244, 421, 15, 70, "Notes",
 CellID->14825],
Cell[8399, 261, 69, 1, 70, "Notes",
 CellID->31159],
Cell[8471, 264, 1578, 44, 70, "3ColumnTableMod",
 CellID->17518],
Cell[10052, 310, 1988, 72, 70, "Notes",
 CellID->3220],
Cell[12043, 384, 214, 8, 70, "Notes",
 CellID->10035],
Cell[12260, 394, 402, 13, 70, "Notes",
 CellID->31314]
}, Closed]],
Cell[CellGroupData[{
Cell[12699, 412, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438479937],
Cell[CellGroupData[{
Cell[13084, 426, 148, 5, 70, "ExampleSection",
 CellID->138809517],
Cell[13235, 433, 67, 1, 70, "ExampleText",
 CellID->71162777],
Cell[13305, 436, 437, 16, 70, "Input",
 CellID->335110482],
Cell[CellGroupData[{
Cell[13767, 456, 574, 18, 47, "Input",
 CellID->56516828],
Cell[14344, 476, 466, 14, 123, "Output",
 CellID->64225193]
}, Open  ]],
Cell[14825, 493, 124, 3, 70, "ExampleDelimiter",
 CellID->36924650],
Cell[14952, 498, 68, 1, 70, "ExampleText",
 CellID->912318266],
Cell[15023, 501, 503, 16, 70, "Input",
 CellID->23974798],
Cell[15529, 519, 430, 14, 70, "Input",
 CellID->11945553],
Cell[CellGroupData[{
Cell[15984, 537, 578, 18, 70, "Input",
 CellID->56811946],
Cell[16565, 557, 4984, 90, 131, "Output",
 CellID->65400126]
}, Open  ]],
Cell[21564, 650, 125, 3, 70, "ExampleDelimiter",
 CellID->489948303],
Cell[21692, 655, 208, 8, 70, "ExampleText",
 CellID->571715156],
Cell[21903, 665, 225, 7, 70, "Input",
 CellID->405558569],
Cell[CellGroupData[{
Cell[22153, 676, 231, 7, 70, "Input",
 CellID->226907178],
Cell[22387, 685, 742, 20, 54, "Output",
 CellID->118710523]
}, Open  ]],
Cell[CellGroupData[{
Cell[23166, 710, 557, 18, 47, "Input",
 CellID->154743775],
Cell[23726, 730, 4564, 79, 139, "Output",
 Evaluatable->False,
 CellID->62351058]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28339, 815, 216, 7, 70, "ExampleSection",
 CellID->17524],
Cell[28558, 824, 251, 8, 70, "ExampleText",
 CellID->351972900],
Cell[28812, 834, 390, 14, 70, "Input",
 CellID->22904023],
Cell[CellGroupData[{
Cell[29227, 852, 657, 21, 70, "Input",
 CellID->692380617],
Cell[29887, 875, 545, 15, 123, "Output",
 CellID->71071714]
}, Open  ]],
Cell[CellGroupData[{
Cell[30469, 895, 575, 18, 70, "Input",
 CellID->149120789],
Cell[31047, 915, 462, 14, 123, "Output",
 CellID->47157019]
}, Open  ]],
Cell[31524, 932, 125, 3, 70, "ExampleDelimiter",
 CellID->243881952],
Cell[31652, 937, 57, 1, 70, "ExampleText",
 CellID->157816812],
Cell[31712, 940, 430, 14, 70, "Input",
 CellID->64115471],
Cell[CellGroupData[{
Cell[32167, 958, 658, 21, 70, "Input",
 CellID->416520138],
Cell[32828, 981, 14179, 240, 121, "Output",
 CellID->84989243]
}, Open  ]],
Cell[CellGroupData[{
Cell[47044, 1226, 579, 18, 70, "Input",
 CellID->514452754],
Cell[47626, 1246, 3428, 65, 109, "Output",
 CellID->559490847]
}, Open  ]],
Cell[51069, 1314, 125, 3, 70, "ExampleDelimiter",
 CellID->185474324],
Cell[51197, 1319, 239, 8, 70, "ExampleText",
 CellID->132111076],
Cell[51439, 1329, 467, 16, 70, "Input",
 CellID->590951174],
Cell[CellGroupData[{
Cell[51931, 1349, 585, 16, 70, "Input",
 CellID->151282521],
Cell[52519, 1367, 1180, 27, 178, "Output",
 CellID->2183721]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53748, 1400, 217, 7, 70, "ExampleSection",
 CellID->9694],
Cell[CellGroupData[{
Cell[53990, 1411, 238, 7, 70, "ExampleSubsection",
 CellID->938834632],
Cell[54231, 1420, 132, 4, 70, "ExampleText",
 CellID->118110927],
Cell[CellGroupData[{
Cell[54388, 1428, 831, 27, 70, "Input",
 CellID->713606423],
Cell[55222, 1457, 367, 11, 72, "Output",
 CellID->57221656]
}, Open  ]],
Cell[55604, 1471, 125, 3, 70, "ExampleDelimiter",
 CellID->172648066],
Cell[55732, 1476, 141, 4, 70, "ExampleText",
 CellID->189168641],
Cell[CellGroupData[{
Cell[55898, 1484, 828, 27, 70, "Input",
 CellID->9339115],
Cell[56729, 1513, 366, 11, 72, "Output",
 CellID->11460750]
}, Open  ]],
Cell[57110, 1527, 125, 3, 70, "ExampleDelimiter",
 CellID->445946109],
Cell[57238, 1532, 142, 4, 70, "ExampleText",
 CellID->448229726],
Cell[CellGroupData[{
Cell[57405, 1540, 835, 27, 70, "Input",
 CellID->184691575],
Cell[58243, 1569, 372, 11, 72, "Output",
 CellID->284162394]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58664, 1586, 229, 7, 70, "ExampleSubsection",
 CellID->20189],
Cell[58896, 1595, 74, 1, 70, "ExampleText",
 CellID->531257434],
Cell[CellGroupData[{
Cell[58995, 1600, 683, 22, 70, "Input",
 CellID->480943747],
Cell[59681, 1624, 16254, 274, 108, 283, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->558285063]
}, Open  ]],
Cell[75950, 1901, 125, 3, 70, "ExampleDelimiter",
 CellID->303481860],
Cell[76078, 1906, 81, 1, 70, "ExampleText",
 CellID->222606742],
Cell[CellGroupData[{
Cell[76184, 1911, 654, 20, 70, "Input",
 CellID->718803155],
Cell[76841, 1933, 17298, 291, 129, 223, 7, "CachedBoxData", "BoxData", \
"Output",
 CellID->38019485]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94188, 2230, 234, 7, 70, "ExampleSubsection",
 CellID->175719815],
Cell[94425, 2239, 99, 1, 70, "ExampleText",
 CellID->447671047],
Cell[94527, 2242, 981, 30, 70, "Input",
 CellID->96808944],
Cell[95511, 2274, 546, 17, 70, "Input",
 CellID->21627096],
Cell[96060, 2293, 131, 4, 70, "ExampleText",
 CellID->25220463],
Cell[CellGroupData[{
Cell[96216, 2301, 310, 9, 70, "Input",
 CellID->418367912],
Cell[96529, 2312, 3137, 56, 70, "Output",
 Evaluatable->False,
 CellID->79032079]
}, Open  ]],
Cell[99681, 2371, 139, 4, 70, "ExampleText",
 CellID->374733348],
Cell[CellGroupData[{
Cell[99845, 2379, 369, 11, 70, "Input",
 CellID->251009505],
Cell[100217, 2392, 43758, 729, 184, 12875, 218, "CachedBoxData", "BoxData", \
"Output",
 CellID->345419746]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[144036, 3128, 227, 7, 70, "ExampleSection",
 CellID->996749287],
Cell[144266, 3137, 234, 8, 70, "ExampleText",
 CellID->7053333],
Cell[CellGroupData[{
Cell[144525, 3149, 549, 17, 70, "Input",
 CellID->15964869],
Cell[145077, 3168, 15048, 251, 70, "Output",
 Evaluatable->False,
 CellID->458634864]
}, Open  ]],
Cell[160140, 3422, 124, 3, 70, "ExampleText",
 CellID->191989951],
Cell[CellGroupData[{
Cell[160289, 3429, 391, 12, 70, "Input",
 CellID->340023272],
Cell[160683, 3443, 14864, 248, 70, "Output",
 Evaluatable->False,
 CellID->51439851]
}, Open  ]],
Cell[175562, 3694, 125, 3, 70, "ExampleDelimiter",
 CellID->433486400],
Cell[175690, 3699, 79, 1, 70, "ExampleText",
 CellID->54359028],
Cell[CellGroupData[{
Cell[175794, 3704, 541, 18, 70, "Input",
 CellID->2951893],
Cell[176338, 3724, 33856, 565, 167, 15505, 260, "CachedBoxData", "BoxData", \
"Output",
 CellID->94293763]
}, Open  ]],
Cell[CellGroupData[{
Cell[210231, 4294, 489, 15, 70, "Input",
 CellID->19101537],
Cell[210723, 4311, 12339, 206, 70, "Output",
 Evaluatable->False,
 CellID->644752796]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223111, 4523, 233, 7, 70, "ExampleSection",
 CellID->30301],
Cell[223347, 4532, 93, 1, 70, "ExampleText",
 CellID->593526080],
Cell[223443, 4535, 646, 23, 70, "Input",
 CellID->365030740],
Cell[224092, 4560, 253, 8, 70, "ExampleText",
 CellID->660392801],
Cell[CellGroupData[{
Cell[224370, 4572, 102, 3, 70, "Input",
 CellID->352416049],
Cell[224475, 4577, 571, 21, 56, "Output",
 CellID->91382839]
}, Open  ]],
Cell[225061, 4601, 77, 1, 70, "ExampleText",
 CellID->178073185],
Cell[CellGroupData[{
Cell[225163, 4606, 221, 7, 70, "Input",
 CellID->93781147],
Cell[225387, 4615, 659, 17, 75, "Output",
 CellID->471423238]
}, Open  ]],
Cell[226061, 4635, 125, 3, 70, "ExampleDelimiter",
 CellID->125364875],
Cell[226189, 4640, 246, 8, 70, "ExampleText",
 CellID->651056669],
Cell[226438, 4650, 218, 7, 70, "Input",
 CellID->96200338],
Cell[226659, 4659, 211, 7, 70, "Input",
 CellID->6015805],
Cell[CellGroupData[{
Cell[226895, 4670, 207, 6, 70, "Input",
 CellID->80497603],
Cell[227105, 4678, 2938, 52, 70, "Output",
 Evaluatable->False,
 CellID->256702322]
}, Open  ]],
Cell[230058, 4733, 79, 1, 70, "ExampleText",
 CellID->840963975],
Cell[230140, 4736, 207, 7, 70, "Input",
 CellID->121761124],
Cell[CellGroupData[{
Cell[230372, 4747, 105, 3, 70, "Input",
 CellID->53036109],
Cell[230480, 4752, 2938, 52, 70, "Output",
 Evaluatable->False,
 CellID->253257553]
}, Open  ]],
Cell[CellGroupData[{
Cell[233455, 4809, 100, 3, 70, "Input",
 CellID->832806256],
Cell[233558, 4814, 173, 5, 36, "Output",
 CellID->539220545]
}, Open  ]],
Cell[233746, 4822, 124, 3, 70, "ExampleDelimiter",
 CellID->16818839],
Cell[233873, 4827, 230, 7, 70, "ExampleText",
 CellID->618125448],
Cell[CellGroupData[{
Cell[234128, 4838, 155, 4, 70, "Input",
 CellID->83315880],
Cell[234286, 4844, 463, 13, 36, "Output",
 CellID->311915028]
}, Open  ]],
Cell[234764, 4860, 285, 9, 70, "Input",
 CellID->208143391],
Cell[CellGroupData[{
Cell[235074, 4873, 106, 3, 70, "Input",
 CellID->105011545],
Cell[235183, 4878, 6630, 113, 70, "Output",
 Evaluatable->False,
 CellID->532752292]
}, Open  ]],
Cell[241828, 4994, 125, 3, 70, "ExampleDelimiter",
 CellID->251770005],
Cell[241956, 4999, 339, 13, 70, "ExampleText",
 CellID->148433934],
Cell[242298, 5014, 238, 8, 70, "Input",
 CellID->153449872],
Cell[CellGroupData[{
Cell[242561, 5026, 250, 8, 70, "Input",
 CellID->95063523],
Cell[242814, 5036, 33318, 550, 70, "Output",
 Evaluatable->False,
 CellID->2246270]
}, Open  ]],
Cell[CellGroupData[{
Cell[276169, 5591, 99, 3, 70, "Input",
 CellID->49169055],
Cell[276271, 5596, 173, 5, 36, "Output",
 CellID->280784546]
}, Open  ]],
Cell[276459, 5604, 91, 1, 70, "ExampleText",
 CellID->220413326],
Cell[CellGroupData[{
Cell[276575, 5609, 134, 4, 70, "Input",
 CellID->154607217],
Cell[276712, 5615, 211, 7, 36, "Output",
 CellID->92805538]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[276972, 5628, 224, 7, 70, "ExampleSection",
 CellID->20523],
Cell[277199, 5637, 84, 1, 70, "ExampleText",
 CellID->636441424],
Cell[277286, 5640, 477, 16, 70, "Input",
 CellID->715442954],
Cell[CellGroupData[{
Cell[277788, 5660, 317, 10, 70, "Input",
 CellID->718269586],
Cell[278108, 5672, 8406, 147, 201, "Output",
 CellID->133247999]
}, Open  ]],
Cell[286529, 5822, 1020, 32, 70, "Input",
 CellID->222044372],
Cell[CellGroupData[{
Cell[287574, 5858, 905, 25, 70, "Input",
 CellID->43849380],
Cell[288482, 5885, 61315, 1009, 70, "Output",
 Evaluatable->False,
 CellID->118444744]
}, Open  ]],
Cell[349812, 6897, 124, 3, 70, "ExampleDelimiter",
 CellID->46463762],
Cell[349939, 6902, 70, 1, 70, "ExampleText",
 CellID->293325019],
Cell[350012, 6905, 282, 9, 70, "Input",
 CellID->451035718],
Cell[CellGroupData[{
Cell[350319, 6918, 1718, 45, 70, "Input",
 CellID->658509299],
Cell[352040, 6965, 140740, 2311, 70, "Output",
 Evaluatable->False,
 CellID->420950916]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[492841, 9283, 310, 9, 70, "SeeAlsoSection",
 CellID->3360],
Cell[493154, 9294, 455, 17, 70, "SeeAlso",
 CellID->751]
}, Open  ]],
Cell[CellGroupData[{
Cell[493646, 9316, 305, 8, 70, "RelatedLinksSection"],
Cell[493954, 9326, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[494363, 9343, 319, 9, 70, "MoreAboutSection",
 CellID->645706336],
Cell[494685, 9354, 169, 3, 70, "MoreAbout",
 CellID->79632535],
Cell[494857, 9359, 147, 3, 70, "MoreAbout",
 CellID->303275895],
Cell[495007, 9364, 143, 3, 70, "MoreAbout",
 CellID->407863466],
Cell[495153, 9369, 128, 3, 70, "MoreAbout",
 CellID->148999781],
Cell[495284, 9374, 161, 3, 70, "MoreAbout",
 CellID->21765692],
Cell[495448, 9379, 197, 4, 70, "MoreAbout",
 CellID->499225149],
Cell[495648, 9385, 178, 3, 70, "MoreAbout",
 CellID->83192593]
}, Open  ]],
Cell[495841, 9391, 27, 0, 70, "History"],
Cell[495871, 9393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

