(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26319,        904]
NotebookOptionsPosition[     21420,        742]
NotebookOutlinePosition[     22936,        782]
CellTagsIndexPosition[     22851,        777]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Redrawing and Combining Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], 
          "ContentSelectable" :> 
          Documentation`HelpLookup["paclet:ref/ContentSelectable"], 
          "Selectable" :> Documentation`HelpLookup["paclet:ref/Selectable"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Inset\"\>", 
       2->"\<\"GraphicsComplex\"\>", 3->"\<\"GraphicsGrid\"\>", 
       4->"\<\"ContentSelectable\"\>", 5->"\<\"Selectable\"\>", 
       6->"\<\"AffineTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combining Graphics\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphicsGroup", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsGroup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsGroup"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a collection of graphics objects grouped \
together for purposes of interactive selection in a notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15749]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFormula"],
 " works with both two\[Hyphen] and three\[Hyphen]dimensional graphics. "
}], "Notes",
 CellID->31539],

Cell[TextData[{
 "A graphics group can typically be created by applying the ",
 StyleBox["Group", "MenuName"],
 " item in the ",
 StyleBox["Graphics", "MenuName"],
 " menu to a collection of selected graphics. "
}], "Notes",
 CellID->9299],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContentSelectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContentSelectable"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", double\[Hyphen]clicking allows you to select an individual graphics \
object ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " within the group. "
}], "Notes",
 CellID->25575],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContentSelectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContentSelectable"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", individual objects within the group cannot separately be selected, unless \
they are first explicitly ungrouped. "
}], "Notes",
 CellID->4099],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContentSelectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContentSelectable"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", objects within the group can be selected immediately with a single click. \
"
}], "Notes",
 CellID->14363],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFormula"],
 " always defines a level in the hierarchy of a graphics expression, so that \
for example ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " goes to the next enclosing ",
 Cell[BoxData[
  ButtonBox["GraphicsGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->13245]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->443669055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->479534204],

Cell["A group of primitives to be selected together:", "ExampleText",
 CellID->112932648],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsGroup", "[", 
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->243029686],

Cell[BoxData[
 GraphicsBox[GraphicsGroupBox[
   {RGBColor[1, 0.5, 0.5], 
    GraphicsGroupBox[{DiskBox[{0, 0}], 
      DiskBox[{0.8790514573342856, -8.881784197001252*^-16}]}]}]]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"In[2]:=",
 CellID->57729575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11483],

Cell["Combine multiple primitives in groups:", "ExampleText",
 CellID->351345468],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"GraphicsGroup", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->906292874],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"GraphicsGroup", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FaceForm", "[", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111245375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128351837],

Cell[BoxData[
 GraphicsBox[{GraphicsGroupBox[{CircleBox[{0, 0}], CircleBox[{1, 1}]}], 
   GraphicsGroupBox[
    {EdgeForm[GrayLevel[0]], FaceForm[None], 
     GraphicsGroupBox[{RectangleBox[{3, -1}, {5, 1}], 
       RectangleBox[{4, 0}, {6, 2}]}]}]}]], "Output",
 ImageSize->{184, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->436485550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418332641],

Cell[TextData[{
 "Define the hierarchy within graphics: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13245,
  ButtonNote->"13245"]
}], "ExampleText",
 CellID->187814216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsGroup", "[", 
   RowBox[{"{", 
    RowBox[{"Red", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"GraphicsGroup", "[", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"GraphicsGroup", "[", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", 
           RowBox[{"Disk", "[", 
            RowBox[{"{", 
             RowBox[{"2", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3584746],

Cell[BoxData[
 GraphicsBox[GraphicsGroupBox[
   {RGBColor[1, 0, 0], GraphicsGroupBox[{DiskBox[{0, 0}], GraphicsGroupBox[
       {RGBColor[0, 1, 0], 
        GraphicsGroupBox[{DiskBox[{1, 0}], GraphicsGroupBox[
           {RGBColor[0, 0, 1], DiskBox[{2, 0}]}]}]}]}]}]]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911369413]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28392],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContentSelectable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28752],

Cell["\<\
No individual object is selectable; the graphics group appears as one object:\
\
\>", "ExampleText",
 CellID->118110927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"GraphicsGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713606423],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], DiskBox[{-3, 0}], GraphicsGroupBox[
    {RGBColor[1, 0.5, 0.5], 
     GraphicsGroupBox[{DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]}]},
    ContentSelectable->False]}]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29808899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165337762],

Cell["\<\
Allow the individual objects in the graphics group to be selectable by a \
single click:\
\>", "ExampleText",
 CellID->189168641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"GraphicsGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9339115],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], DiskBox[{-3, 0}], GraphicsGroupBox[
    {RGBColor[1, 0.5, 0.5], 
     GraphicsGroupBox[{DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]}]},
    ContentSelectable->True]}]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353813074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172648066],

Cell["\<\
The first click selects the whole group, and subsequent ones select \
individual objects:\
\>", "ExampleText",
 CellID->448229726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"GraphicsGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ContentSelectable", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184691575],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], DiskBox[{-3, 0}], GraphicsGroupBox[
    {RGBColor[1, 0.5, 0.5], 
     GraphicsGroupBox[{DiskBox[{0, 0}], 
       RectangleBox[{2, -1}, {4, 1}]}]}]}]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174011939]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7389],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContentSelectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContentSelectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20735]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14726],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->11101676],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->58107079],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->36816838],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->120986465]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphicsGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 38.0834010}", "context" -> "System`", 
    "keywords" -> {
     "graphics selection behavior", "graphics selection", "graphics picking", 
      "graphics editing", "graphics hierarchy", "graphics grouping", 
      "composite graphics objects", "composed graphics objects"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GraphicsGroup[{g_1, g_2, ...}] represents a collection of graphics \
objects grouped together for purposes of interactive selection in a notebook. \
", "synonyms" -> {"graphics group"}, "title" -> "GraphicsGroup", "type" -> 
    "Symbol", "uri" -> "ref/GraphicsGroup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8743, 267, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->443669055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22708, 770}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2773, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3396, 91, 1578, 37, 70, "ObjectNameGrid"],
Cell[4977, 130, 813, 24, 70, "Usage",
 CellID->15749]
}, Open  ]],
Cell[CellGroupData[{
Cell[5827, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6305, 176, 247, 7, 70, "Notes",
 CellID->31539],
Cell[6555, 185, 239, 7, 70, "Notes",
 CellID->9299],
Cell[6797, 194, 531, 18, 70, "Notes",
 CellID->25575],
Cell[7331, 214, 414, 13, 70, "Notes",
 CellID->4099],
Cell[7748, 229, 376, 13, 70, "Notes",
 CellID->14363],
Cell[8127, 244, 579, 18, 70, "Notes",
 CellID->13245]
}, Closed]],
Cell[CellGroupData[{
Cell[8743, 267, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->443669055],
Cell[CellGroupData[{
Cell[9128, 281, 148, 5, 70, "ExampleSection",
 CellID->479534204],
Cell[9279, 288, 89, 1, 70, "ExampleText",
 CellID->112932648],
Cell[9371, 291, 386, 13, 70, "Input",
 CellID->243029686],
Cell[9760, 306, 333, 9, 70, "Input",
 CellID->57729575]
}, Open  ]],
Cell[CellGroupData[{
Cell[10130, 320, 216, 7, 70, "ExampleSection",
 CellID->11483],
Cell[10349, 329, 81, 1, 70, "ExampleText",
 CellID->351345468],
Cell[10433, 332, 331, 12, 70, "Input",
 CellID->906292874],
Cell[10767, 346, 700, 23, 70, "Input",
 CellID->111245375],
Cell[CellGroupData[{
Cell[11492, 373, 151, 5, 70, "Input",
 CellID->128351837],
Cell[11646, 380, 393, 10, 103, "Output",
 CellID->436485550]
}, Open  ]],
Cell[12054, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->418332641],
Cell[12182, 398, 202, 7, 70, "ExampleText",
 CellID->187814216],
Cell[CellGroupData[{
Cell[12409, 409, 726, 22, 70, "Input",
 CellID->3584746],
Cell[13138, 433, 410, 10, 115, "Output",
 CellID->911369413]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13597, 449, 218, 7, 70, "ExampleSection",
 CellID->28392],
Cell[CellGroupData[{
Cell[13840, 460, 234, 7, 70, "ExampleSubsection",
 CellID->28752],
Cell[14077, 469, 130, 4, 70, "ExampleText",
 CellID->118110927],
Cell[CellGroupData[{
Cell[14232, 477, 723, 23, 70, "Input",
 CellID->713606423],
Cell[14958, 502, 362, 10, 72, "Output",
 CellID->29808899]
}, Open  ]],
Cell[15335, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->165337762],
Cell[15463, 520, 139, 4, 70, "ExampleText",
 CellID->189168641],
Cell[CellGroupData[{
Cell[15627, 528, 720, 23, 70, "Input",
 CellID->9339115],
Cell[16350, 553, 362, 10, 72, "Output",
 CellID->353813074]
}, Open  ]],
Cell[16727, 566, 125, 3, 70, "ExampleDelimiter",
 CellID->172648066],
Cell[16855, 571, 140, 4, 70, "ExampleText",
 CellID->448229726],
Cell[CellGroupData[{
Cell[17020, 579, 727, 23, 70, "Input",
 CellID->184691575],
Cell[17750, 604, 341, 10, 72, "Output",
 CellID->174011939]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18164, 622, 310, 9, 70, "SeeAlsoSection",
 CellID->7389],
Cell[18477, 633, 1483, 53, 70, "SeeAlso",
 CellID->20735]
}, Open  ]],
Cell[CellGroupData[{
Cell[19997, 691, 314, 9, 70, "TutorialsSection",
 CellID->14726],
Cell[20314, 702, 166, 3, 70, "Tutorials",
 CellID->25408]
}, Open  ]],
Cell[CellGroupData[{
Cell[20517, 710, 318, 9, 70, "MoreAboutSection",
 CellID->11101676],
Cell[20838, 721, 146, 3, 70, "MoreAbout",
 CellID->58107079],
Cell[20987, 726, 161, 3, 70, "MoreAbout",
 CellID->36816838],
Cell[21151, 731, 197, 4, 70, "MoreAbout",
 CellID->120986465]
}, Open  ]],
Cell[21363, 738, 27, 0, 70, "History"],
Cell[21393, 740, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

