(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    305902,       5919]
NotebookOptionsPosition[    297720,       5640]
NotebookOutlinePosition[    299107,       5678]
CellTagsIndexPosition[    299020,       5673]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Hue" :> Documentation`HelpLookup["paclet:ref/Hue"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Black" :> 
          Documentation`HelpLookup["paclet:ref/Black"], "White" :> 
          Documentation`HelpLookup["paclet:ref/White"], "Gray" :> 
          Documentation`HelpLookup["paclet:ref/Gray"], "Raster" :> 
          Documentation`HelpLookup["paclet:ref/Raster"], "Opacity" :> 
          Documentation`HelpLookup["paclet:ref/Opacity"], "Blend" :> 
          Documentation`HelpLookup["paclet:ref/Blend"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RGBColor\"\>", 2->"\<\"Hue\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Black\"\>", 
       6->"\<\"White\"\>", 7->"\<\"Gray\"\>", 8->"\<\"Raster\"\>", 
       9->"\<\"Opacity\"\>", 10->"\<\"Blend\"\>", 11->"\<\"Lighting\"\>", 
       12->"\<\"ColorSlider\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GrayLevel", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GrayLevel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GrayLevel"], "[", 
       StyleBox["level", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies the gray\
\[Hyphen]level intensity with which objects that follow should be displayed. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GrayLevel",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GrayLevel"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The gray level must be a number between ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->453491169]
}], "Notes",
 CellID->21465],

Cell[TextData[{
 Cell[BoxData["0"], "InlineFormula"],
 " represents black; ",
 Cell[BoxData["1"], "InlineFormula"],
 " represents white. "
}], "Notes",
 CellID->14329],

Cell["\<\
On display devices with no native gray\[Hyphen]level capability, dither \
patterns are typically used. \
\>", "Notes",
 CellID->259],

Cell[TextData[{
 "For 3D surfaces, explicit ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " directives define surface colors; the final shading depends on lighting. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24082],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is an \[OpenCurlyDoubleQuote]alpha channel\[CloseCurlyDoubleQuote] used to \
specify opacity. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5389],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GrayLevel", "[", 
     StyleBox["g", "TI"], "]"}], ",", 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->213546703]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24986],

Cell[TextData[{
 "If no opacity has been specified, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"GrayLevel", "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be displayed with the specified gray level. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->313175541]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12735]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31256223],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->520935766],

Cell["Specify the gray-level of graphics primitives:", "ExampleText",
 CellID->318848115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GrayLevel", "[", ".3", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3472245],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.3], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25732364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29427969],

Cell["Specify the gray-level with opacity:", "ExampleText",
 CellID->333146456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", 
      RowBox[{".3", ",", ".5"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770088028],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.3], Opacity[0.5], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->62794501,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->784094178],

Cell["Specify the output gray-level of expressions:", "ExampleText",
 CellID->313175541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"GrayLevel", "[", ".5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628623050],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}],
  StripOnInput->False,
  FrontFaceColor->GrayLevel[0.5],
  BackFaceColor->GrayLevel[0.5],
  GraphicsColor->GrayLevel[0.5],
  FontColor->GrayLevel[0.5]]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->585967620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132685642],

Cell["Specify the gray-level of plots:", "ExampleText",
 CellID->580206808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".5", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211868938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262796101]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5872],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GrayLevel in 3D",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->34682444],

Cell["Use diffuse surface color:", "ExampleText",
 CellID->330788945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->907978],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347358064,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use diffuse and specular surface color:", "ExampleText",
 CellID->928327454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "20"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29801507],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136910783,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use glow color, setting the diffuse surface color to black:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->255057354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Glow", "[", 
     RowBox[{"GrayLevel", "[", ".5", "]"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93466233],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    GrayLevel[0.5]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6498979,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10437030],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->600573779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "a", "]"}], ",", 
      RowBox[{"GrayLevel", "[", 
       RowBox[{"1", "/", "2"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->724058432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.99], DiskBox[{0, 0}]}}]}], 
  "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->26505357]
}, Open  ]],

Cell[TextData[{
 "Use the opacity argument directly in ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->213546703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"GrayLevel", "[", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "a"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2124034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {GrayLevel[0], DiskBox[{1, 0}]}, 
     {GrayLevel[
       NCache[
        Rational[1, 2], 0.5]], Opacity[0.99], DiskBox[{0, 0}]}}]}], 
  "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->731308186]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->359827742],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " can be computed in the following way:"
}], "ExampleText",
 CellID->58418415],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RGBToGray", "[", 
    RowBox[{"RGBColor", "[", 
     RowBox[{"r_", ",", "g_", ",", "b_"}], "]"}], "]"}], ":=", 
   RowBox[{"GrayLevel", "[", 
    RowBox[{
     RowBox[{".299", "r"}], "+", 
     RowBox[{".587", "g"}], "+", 
     RowBox[{".144", "b"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44052381],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"RGBColor", "@@", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBToGray", "[", "c", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->324554571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0.7966678282947302, 0.7883738098704798, 0.6503713484512017], 
     RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {GrayLevel[0.794632581231069], RectangleBox[{0, 0}]}]}], "}"}]], "Output",\

 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->88374126]
}, Open  ]],

Cell["\<\
From this formulae we see that many colors will produce the same gray level \
G:\
\>", "ExampleText",
 CellID->71829785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{".299", " ", "r"}], "+", 
     RowBox[{".587", " ", "g"}], "+", 
     RowBox[{".144", " ", "b"}]}], "\[Equal]", "G"}], ",", "r"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1458215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"r", "\[Rule]", 
    RowBox[{"3.3444816053511706`", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.144`"}], " ", "b"}], "-", 
       RowBox[{"0.587`", " ", "g"}], "+", 
       RowBox[{"1.`", " ", "G"}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67231139]
}, Open  ]],

Cell["Use a color function in the RGB color space:", "ExampleText",
 CellID->81273868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "g"}], "}"}], ",", 
      RowBox[{"RGBColor", "[", 
       RowBox[{
        RowBox[{"3.34448", " ", 
         RowBox[{"(", 
          RowBox[{"0.5", "\[InvisibleSpace]", "-", 
           RowBox[{"0.144", " ", "b"}], "-", 
           RowBox[{"0.587", " ", "g"}]}], ")"}]}], ",", "g", ",", "b"}], 
       "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->127726852],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l0GKFEEQAAd/Ius/6ihefYLgScS3OE/wCYL7gLx6q4OgexBEBBG1rl7c
nekmqsmoqmaWJLqnpzvIqszcxy/ePH/56HQ6/bv8XaOP85Nnl8/7kjk6392+
vnw+6nrtvF2++9T5y36i8//76/G189vt/m+db654/t75w3b7j85Ptwf+7Px5
+/1fnV9tL/i783408eE5j9EZ33y9dsYXxhfGF8YXxhfGF8YXxhfGN+etiY88
zj2PmH1DviHfkG/IN+Qb8g35hnxDviHfkO+4Tud5PDwd8YXxhfGF8YXxhfGF
8YXxhfGF8c37romPfThfpzF45etHzPmtym9VfqvyW5XfqvxW5bcqv1X5rcrv
WGfm+zCGvNkLdsQXxhfGF8YXxhfGF8YXxjfXzSY+6ui8zsSwLp03e8GO+ML4
wvjC+ML4wvjC+Oa+0MqqT8zraAz7zuvSebMX7IgvjC+ML4wvjC+Mb+57raz6
IL6um64r3ndel86bvWBHfGF8YXxhfGF8c19vZdXn8XVfcN10XfG+87p03uwF
O+IL4wvjC+Ob55ZWVnMMvu577guum64r3ndel86bvWBHfGF8YXzzXNbKak7D
133dfc99wXXTdcX7zuvSebMX7IgvjG+eO1tZzaH4em5xX3ffc19w3XRd8b7z
unTe7AU74pvn6lZWcza+nss8t7ivu++5L7huuq5433ldOm/2gh3xXf0fge98
7vRc5rnFfd19z33BddN1xfvO69J5s1cb4v6+73rEHN5f94+uj/fxPe6HV9G/
4/v8Hn7v/F7nHvd8/F2ed8zPOS/P+/l+zikdbTg/f24rDyi5QXo=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJxd2As8VdkewHFXog+uVFeFUdNTpedEJLWMuMhkip7I9FA0laZGJamLGrdu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    "]],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->31097049,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["The corresponding gray level colors:", "ExampleText",
 CellID->81263777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "g"}], "}"}], ",", 
      RowBox[{"RGBToGray", "[", 
       RowBox[{"RGBColor", "[", 
        RowBox[{
         RowBox[{"3.34448", " ", 
          RowBox[{"(", 
           RowBox[{"0.5", "\[InvisibleSpace]", "-", 
            RowBox[{"0.144", " ", "b"}], "-", 
            RowBox[{"0.587", " ", "g"}]}], ")"}]}], ",", "g", ",", "b"}], 
        "]"}], "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->99343556],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWt1OwjAULtvAG0kUwZiIkffwXq98iIWYwAXRIO9iTLjgHeQp9k6LtmWF
ctpubYfbyM6S/Zyer6c/5+xrOeM1Xs3eFvFqPo0nL8v4Yzaffk6e35e0KOwQ
Qrb0/Lkj9PmXPvFzm6YpVSjXPr0GFBAyKaQPKT8IKxtpdITJ9BzKuu6+XoYY
OlqVdawo0Og4nlyya3TQEBIpJTdKSReMQEX0QIvXXu2omBGwGyqIoMS4YK8H
WiusQK9p2ngu7LyQ60nbeGAxdVvzaEQ/9KMQ71m9PnGZz/w3jz2eMsYEd/Wy
+8ggQz8MpPJAYiuTnR3zmBh0d81A/NAxG5uHjRgtKZoBtQS+6X0gR4566Bco
u9o7SX/UOfCYqQdg+QnI90B+hN6ybpf5dZ3dHXortfWdJIkSLae2JEWmiGjo
bXPtK0QiMkMyzSHWm9c/RPojTesXl0swF9x5+9qB6x+sY2sH7gVETHODCT/I
lxLrxTaQ1ZFbEInIWrhayb/YM8H/sKzIOpTa70qrhvh9CVla0PPu0HG1qOk7
Ix71Je/AlcJ+Ps8lFhGJyGYgz3MHYZM3qnxvWakl1923yIyWYXQZ47fnFrlD
+9rnEpGIbBcDIRIZvUx2JyDm/XkRjzdgPJhHQSQiW4k8zh7ALK4bE8DaHOXJ
SdXbss2tuPdsXWaEud91xwUy/M471rdhXgFyM2Ou389bidfMNns7N3vp6B8U
nT9aLL3r\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->423112910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->822077253],

Cell["Gray level values outside of the 0, 1 range will be clipped:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->453491169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "g", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "g"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24819876],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiBQkGIPs/kAXG
W/7/B9LIJAuQXNPQ0MAC5zEwA7kMECAKIpD4YjC+AxgwiAIJKSBXfP/+/WDx
/2DAIAYzB8oXReMzjdo2atuobaO2jdo2atuobaO2jdo2bG1DtC4xW58MjABU
NXqx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71130253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450168257],

Cell["\<\
The actual surface color depends on the colors of lights in 3D:\
\>", "ExampleText",
 CellID->817886889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
     RowBox[{"Specularity", "[", 
      RowBox[{"White", ",", "20"}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "2"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511687184],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]},
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], 
     Scaled[{2, 0, 0}]}, {"Point", 
     RGBColor[0, 1, 0], 
     Scaled[{0, -2, 0}]}, {"Point", 
     RGBColor[0, 0, 1], 
     Scaled[{0, 0, 2}]}}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16479138,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
The default 3D lights contains several colored light sources:\
\>", "ExampleText",
 CellID->18572949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "20"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105564],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2808146,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->191188808],

Cell["Visualizing the gray level with opacity:", "ExampleText",
 CellID->6267183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", 
         RowBox[{"i", ",", "j"}], "]"}], ",", " ", 
        RowBox[{"Cuboid", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", "j", ",", "0"}], "}"}], ",", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", "j", ",", "0"}], "}"}], "+", "0.1"}]}], "]"}]}],
        "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "1", ",", "0.2"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}], "}"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<GrayLevel\>\"", ",", "\"\<Opacity\>\""}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68525830],

Cell[BoxData[
 Graphics3DBox[{{
    {GrayLevel[0.], Opacity[0.], 
     StyleBox[CuboidBox[{0., 0., 0}, {0.1, 0.1, 0.1}],
      FontColor->GrayLevel[0.]]}, 
    {GrayLevel[0.], Opacity[0.2], 
     StyleBox[CuboidBox[{0., 0.2, 0}, {0.1, 0.30000000000000004`, 0.1}],
      FontColor->GrayLevel[0.]]}, 
    {GrayLevel[0.], Opacity[0.4], 
     StyleBox[CuboidBox[{0., 0.4, 0}, {0.1, 0.5, 0.1}],
      FontColor->GrayLevel[0.]]}, 
    {GrayLevel[0.], Opacity[0.6000000000000001], 
     StyleBox[
      CuboidBox[{0., 0.6000000000000001, 0}, {0.1, 0.7000000000000001, 0.1}],
      FontColor->GrayLevel[0.]]}, 
    {GrayLevel[0.], Opacity[0.8], 
     StyleBox[CuboidBox[{0., 0.8, 0}, {0.1, 0.9, 0.1}],
      FontColor->GrayLevel[0.]]}, 
    {GrayLevel[0.], Opacity[1.], 
     StyleBox[CuboidBox[{0., 1., 0}, {0.1, 1.1, 0.1}],
      FontColor->GrayLevel[0.]]}}, {
    {GrayLevel[0.2], Opacity[0.], 
     CuboidBox[{0.2, 0., 0}, {0.30000000000000004`, 0.1, 0.1}]}, 
    {GrayLevel[0.2], Opacity[0.2], 
     CuboidBox[{0.2, 0.2, 0}, {0.30000000000000004`, 0.30000000000000004`, 
      0.1}]}, 
    {GrayLevel[0.2], Opacity[0.4], 
     CuboidBox[{0.2, 0.4, 0}, {0.30000000000000004`, 0.5, 0.1}]}, 
    {GrayLevel[0.2], Opacity[0.6000000000000001], 
     CuboidBox[{0.2, 0.6000000000000001, 0}, {0.30000000000000004`, 
      0.7000000000000001, 0.1}]}, 
    {GrayLevel[0.2], Opacity[0.8], 
     CuboidBox[{0.2, 0.8, 0}, {0.30000000000000004`, 0.9, 0.1}]}, 
    {GrayLevel[0.2], Opacity[1.], 
     CuboidBox[{0.2, 1., 0}, {0.30000000000000004`, 1.1, 0.1}]}}, {
    {GrayLevel[0.4], Opacity[0.], CuboidBox[{0.4, 0., 0}, {0.5, 0.1, 0.1}]}, 
    {GrayLevel[0.4], Opacity[0.2], 
     CuboidBox[{0.4, 0.2, 0}, {0.5, 0.30000000000000004`, 0.1}]}, 
    {GrayLevel[0.4], Opacity[0.4], 
     CuboidBox[{0.4, 0.4, 0}, {0.5, 0.5, 0.1}]}, 
    {GrayLevel[0.4], Opacity[0.6000000000000001], 
     CuboidBox[{0.4, 0.6000000000000001, 0}, {0.5, 0.7000000000000001, 
      0.1}]}, 
    {GrayLevel[0.4], Opacity[0.8], 
     CuboidBox[{0.4, 0.8, 0}, {0.5, 0.9, 0.1}]}, 
    {GrayLevel[0.4], Opacity[1.], 
     CuboidBox[{0.4, 1., 0}, {0.5, 1.1, 0.1}]}}, {
    {GrayLevel[0.6000000000000001], Opacity[0.], 
     CuboidBox[{0.6000000000000001, 0., 0}, {0.7000000000000001, 0.1, 
      0.1}]}, 
    {GrayLevel[0.6000000000000001], Opacity[0.2], 
     CuboidBox[{0.6000000000000001, 0.2, 0}, {0.7000000000000001, 
      0.30000000000000004`, 0.1}]}, 
    {GrayLevel[0.6000000000000001], Opacity[0.4], 
     CuboidBox[{0.6000000000000001, 0.4, 0}, {0.7000000000000001, 0.5, 
      0.1}]}, 
    {GrayLevel[0.6000000000000001], Opacity[0.6000000000000001], 
     CuboidBox[{0.6000000000000001, 0.6000000000000001, 0}, {
      0.7000000000000001, 0.7000000000000001, 0.1}]}, 
    {GrayLevel[0.6000000000000001], Opacity[0.8], 
     CuboidBox[{0.6000000000000001, 0.8, 0}, {0.7000000000000001, 0.9, 
      0.1}]}, 
    {GrayLevel[0.6000000000000001], Opacity[1.], 
     CuboidBox[{0.6000000000000001, 1., 0}, {0.7000000000000001, 1.1, 
      0.1}]}}, {
    {GrayLevel[0.8], Opacity[0.], CuboidBox[{0.8, 0., 0}, {0.9, 0.1, 0.1}]}, 
    {GrayLevel[0.8], Opacity[0.2], 
     CuboidBox[{0.8, 0.2, 0}, {0.9, 0.30000000000000004`, 0.1}]}, 
    {GrayLevel[0.8], Opacity[0.4], 
     CuboidBox[{0.8, 0.4, 0}, {0.9, 0.5, 0.1}]}, 
    {GrayLevel[0.8], Opacity[0.6000000000000001], 
     CuboidBox[{0.8, 0.6000000000000001, 0}, {0.9, 0.7000000000000001, 
      0.1}]}, 
    {GrayLevel[0.8], Opacity[0.8], 
     CuboidBox[{0.8, 0.8, 0}, {0.9, 0.9, 0.1}]}, 
    {GrayLevel[0.8], Opacity[1.], 
     CuboidBox[{0.8, 1., 0}, {0.9, 1.1, 0.1}]}}, {
    {GrayLevel[1.], Opacity[0.], CuboidBox[{1., 0., 0}, {1.1, 0.1, 0.1}]}, 
    {GrayLevel[1.], Opacity[0.2], 
     CuboidBox[{1., 0.2, 0}, {1.1, 0.30000000000000004`, 0.1}]}, 
    {GrayLevel[1.], Opacity[0.4], CuboidBox[{1., 0.4, 0}, {1.1, 0.5, 0.1}]}, 
    {GrayLevel[1.], Opacity[0.6000000000000001], 
     CuboidBox[{1., 0.6000000000000001, 0}, {1.1, 0.7000000000000001, 
      0.1}]}, 
    {GrayLevel[1.], Opacity[0.8], CuboidBox[{1., 0.8, 0}, {1.1, 0.9, 0.1}]}, 
    {GrayLevel[1.], Opacity[1.], CuboidBox[{1., 1., 0}, {1.1, 1.1, 0.1}]}}},
  Axes->True,
  AxesLabel->{
    FormBox["\"GrayLevel\"", TraditionalForm], 
    FormBox["\"Opacity\"", TraditionalForm]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{229, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->268179285,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472884272],

Cell["White noise with opacity:", "ExampleText",
 CellID->221950275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}], ",", "40"}], "]"}], ",", 
    RowBox[{"Raster", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"200", ",", "200", ",", "2"}], "}"}]}], "]"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "GrayLevel"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610197368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->153541414]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20003],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Black",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Black"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["White",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/White"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->25812715],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->181942870],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->86305828]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GrayLevel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 58.5683004}", "context" -> "System`", 
    "keywords" -> {
     "brightness", "darkness", "density", "intensity", "screen density"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GrayLevel[level] is a graphics directive which specifies the gray-level \
intensity with which objects that follow should be displayed. GrayLevel[g, a] \
specifies opacity a. ", "synonyms" -> {"gray level"}, "title" -> "GrayLevel", 
    "type" -> "Symbol", "uri" -> "ref/GrayLevel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12254, 349, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31256223]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 298877, 5666}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2270, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2893, 72, 4193, 83, 70, "ObjectNameGrid"],
Cell[7089, 157, 985, 31, 70, "Usage",
 CellID->11128]
}, Open  ]],
Cell[CellGroupData[{
Cell[8111, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8589, 210, 268, 10, 70, "Notes",
 CellID->21465],
Cell[8860, 222, 167, 6, 70, "Notes",
 CellID->14329],
Cell[9030, 230, 142, 4, 70, "Notes",
 CellID->259],
Cell[9175, 236, 404, 11, 70, "Notes",
 CellID->24082],
Cell[9582, 249, 562, 19, 70, "Notes",
 CellID->5389],
Cell[10147, 270, 793, 28, 70, "Notes",
 CellID->24986],
Cell[10943, 300, 611, 21, 70, "Notes",
 CellID->21419],
Cell[11557, 323, 660, 21, 70, "Notes",
 CellID->12735]
}, Closed]],
Cell[CellGroupData[{
Cell[12254, 349, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31256223],
Cell[CellGroupData[{
Cell[12638, 363, 148, 5, 70, "ExampleSection",
 CellID->520935766],
Cell[12789, 370, 89, 1, 70, "ExampleText",
 CellID->318848115],
Cell[CellGroupData[{
Cell[12903, 375, 216, 7, 28, "Input",
 CellID->3472245],
Cell[13122, 384, 259, 8, 121, "Output",
 CellID->25732364]
}, Open  ]],
Cell[13396, 395, 124, 3, 70, "ExampleDelimiter",
 CellID->29427969],
Cell[13523, 400, 79, 1, 70, "ExampleText",
 CellID->333146456],
Cell[CellGroupData[{
Cell[13627, 405, 328, 10, 70, "Input",
 CellID->770088028],
Cell[13958, 417, 5244, 92, 129, 120, 3, "CachedBoxData", "BoxData", "Output",
 CellID->62794501]
}, Open  ]],
Cell[19217, 512, 125, 3, 70, "ExampleDelimiter",
 CellID->784094178],
Cell[19345, 517, 88, 1, 70, "ExampleText",
 CellID->313175541],
Cell[CellGroupData[{
Cell[19458, 522, 236, 8, 70, "Input",
 CellID->628623050],
Cell[19697, 532, 395, 14, 36, "Output",
 CellID->585967620]
}, Open  ]],
Cell[20107, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->132685642],
Cell[20235, 554, 75, 1, 70, "ExampleText",
 CellID->580206808],
Cell[CellGroupData[{
Cell[20335, 559, 322, 10, 28, "Input",
 CellID->211868938],
Cell[20660, 571, 2482, 45, 128, "Output",
 Evaluatable->False,
 CellID->262796101]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23191, 622, 215, 7, 70, "ExampleSection",
 CellID->5872],
Cell[CellGroupData[{
Cell[23431, 633, 235, 7, 70, "ExampleSubsection",
 CellID->34682444],
Cell[23669, 642, 69, 1, 70, "ExampleText",
 CellID->330788945],
Cell[CellGroupData[{
Cell[23763, 647, 297, 9, 70, "Input",
 CellID->907978],
Cell[24063, 658, 11659, 197, 216, 106, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->347358064]
}, Open  ]],
Cell[35737, 858, 82, 1, 70, "ExampleText",
 CellID->928327454],
Cell[CellGroupData[{
Cell[35844, 863, 382, 11, 70, "Input",
 CellID->29801507],
Cell[36229, 876, 14964, 251, 216, 142, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->136910783]
}, Open  ]],
Cell[51208, 1130, 152, 3, 70, "ExampleText",
 CellID->255057354],
Cell[CellGroupData[{
Cell[51385, 1137, 269, 8, 70, "Input",
 CellID->93466233],
Cell[51657, 1147, 3013, 55, 216, 108, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->6498979]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[54731, 1209, 242, 7, 70, "ExampleSection",
 CellID->10437030],
Cell[54976, 1218, 317, 13, 70, "ExampleText",
 CellID->600573779],
Cell[CellGroupData[{
Cell[55318, 1235, 580, 17, 70, "Input",
 CellID->724058432],
Cell[55901, 1254, 876, 29, 91, "Output",
 CellID->26505357]
}, Open  ]],
Cell[56792, 1286, 270, 9, 70, "ExampleText",
 CellID->213546703],
Cell[CellGroupData[{
Cell[57087, 1299, 559, 17, 70, "Input",
 CellID->2124034],
Cell[57649, 1318, 877, 29, 91, "Output",
 CellID->731308186]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58575, 1353, 237, 7, 70, "ExampleSection",
 CellID->359827742],
Cell[58815, 1362, 344, 12, 70, "ExampleText",
 CellID->58418415],
Cell[59162, 1376, 367, 12, 70, "Input",
 CellID->44052381],
Cell[CellGroupData[{
Cell[59554, 1392, 604, 20, 70, "Input",
 CellID->324554571],
Cell[60161, 1414, 446, 14, 123, "Output",
 CellID->88374126]
}, Open  ]],
Cell[60622, 1431, 130, 4, 70, "ExampleText",
 CellID->71829785],
Cell[CellGroupData[{
Cell[60777, 1439, 278, 10, 70, "Input",
 CellID->1458215],
Cell[61058, 1451, 459, 15, 36, "Output",
 CellID->67231139]
}, Open  ]],
Cell[61532, 1469, 86, 1, 70, "ExampleText",
 CellID->81273868],
Cell[CellGroupData[{
Cell[61643, 1474, 714, 21, 70, "Input",
 CellID->127726852],
Cell[62360, 1497, 89573, 1481, 200, 6472, 114, "CachedBoxData", "BoxData", \
"Output",
 CellID->31097049]
}, Open  ]],
Cell[151948, 2981, 78, 1, 70, "ExampleText",
 CellID->81263777],
Cell[CellGroupData[{
Cell[152051, 2986, 761, 22, 70, "Input",
 CellID->99343556],
Cell[152815, 3010, 953, 20, 70, "Output",
 Evaluatable->False,
 CellID->423112910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153817, 3036, 230, 7, 70, "ExampleSection",
 CellID->822077253],
Cell[154050, 3045, 153, 3, 70, "ExampleText",
 CellID->453491169],
Cell[CellGroupData[{
Cell[154228, 3052, 632, 20, 70, "Input",
 CellID->24819876],
Cell[154863, 3074, 398, 11, 70, "Output",
 Evaluatable->False,
 CellID->71130253]
}, Open  ]],
Cell[155276, 3088, 125, 3, 70, "ExampleDelimiter",
 CellID->450168257],
Cell[155404, 3093, 114, 3, 70, "ExampleText",
 CellID->817886889],
Cell[CellGroupData[{
Cell[155543, 3100, 1033, 30, 70, "Input",
 CellID->511687184],
Cell[156579, 3132, 32678, 545, 216, 317, 10, "CachedBoxData", "BoxData", \
"Output",
 CellID->16479138]
}, Open  ]],
Cell[189272, 3680, 111, 3, 70, "ExampleText",
 CellID->18572949],
Cell[CellGroupData[{
Cell[189408, 3687, 300, 9, 70, "Input",
 CellID->105564],
Cell[189711, 3698, 40108, 663, 216, 119, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->2808146]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[229868, 4367, 228, 7, 70, "ExampleSection",
 CellID->191188808],
Cell[230099, 4376, 81, 1, 70, "ExampleText",
 CellID->6267183],
Cell[CellGroupData[{
Cell[230205, 4381, 1016, 29, 70, "Input",
 CellID->68525830],
Cell[231224, 4412, 15443, 277, 152, 4292, 90, "CachedBoxData", "BoxData", \
"Output",
 CellID->268179285]
}, Open  ]],
Cell[246682, 4692, 125, 3, 70, "ExampleDelimiter",
 CellID->472884272],
Cell[246810, 4697, 68, 1, 70, "ExampleText",
 CellID->221950275],
Cell[CellGroupData[{
Cell[246903, 4702, 542, 17, 70, "Input",
 CellID->610197368],
Cell[247448, 4721, 46311, 763, 70, "Output",
 Evaluatable->False,
 CellID->153541414]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[293820, 5491, 311, 9, 70, "SeeAlsoSection",
 CellID->20003],
Cell[294134, 5502, 2858, 107, 70, "SeeAlso",
 CellID->5161]
}, Open  ]],
Cell[CellGroupData[{
Cell[297029, 5614, 318, 9, 70, "MoreAboutSection",
 CellID->25812715],
Cell[297350, 5625, 124, 3, 70, "MoreAbout",
 CellID->181942870],
Cell[297477, 5630, 148, 3, 70, "MoreAbout",
 CellID->86305828]
}, Open  ]],
Cell[297640, 5636, 50, 0, 70, "History"],
Cell[297693, 5638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

